---
title: v1.6.2
weight: 998993998
---

## Add the manager config patch to config/default/kustomization.yaml

The scaffolded `--config` flag was not added to either ansible-/helm-operator binary when [config file](https://master.book.kubebuilder.io/component-config-tutorial/tutorial.html) support was originally added, so it does not currently work. The `--config` flag supports configuration of both binaries by file, this method of configuration only applies to the underlying [controller manager](https://pkg.go.dev/sigs.k8s.io/controller-runtime/pkg/manager#Manager), not the operator as a whole. To optionally configure the operator's Deployment with a config file, make the following update to `config/default/kustomization.yaml`:
```diff 
# If you want your controller-manager to expose the /metrics 
# endpoint w/o any authn/z, please comment the following line. 
\- manager_auth_proxy_patch.yaml 
+
+# Mount the controller config file for loading manager configurations 
+# through a ComponentConfig type 
+- manager_config_patch.yaml
```
This feature is opt-in: flags can be used as-is or to override config file values.

_See [#4780](https://github.com/operator-framework/operator-sdk/pull/4780) for more details._
