## v1.3.0

### Additions

- Added OLM bindata for the 0.17.0 release version. ([#4242](https://github.com/operator-framework/operator-sdk/pull/4242))
- Added [`order=<int>`](https://sdk.operatorframework.io/docs/building-operators/golang/references/markers/#usage) marker fields to CSV markers. ([#4254](https://github.com/operator-framework/operator-sdk/pull/4254))
- In Ansible-based operators, added the `ansible_operator_build_info` metric to instrument commit and version information. ([#4220](https://github.com/operator-framework/operator-sdk/pull/4220))
- In Helm-based operators, added the `helm_operator_build_info` metric to instrument commit and version information. ([#4220](https://github.com/operator-framework/operator-sdk/pull/4220))
- Added the `--package <name>` flag to all `generate` subcommands. This flag is required by `generate <bundle|packagemanifests>` when run outside of a project. ([#4074](https://github.com/operator-framework/operator-sdk/pull/4074))
- Added the `run bundle-upgrade` subcommand to automate testing upgrades of an operator from one version to another using OLM. ([#4271](https://github.com/operator-framework/operator-sdk/pull/4271))
- (go/v2) Added the command `òperator-sdk edit` which allows users edit the project layout to support [multi-group](https://book.kubebuilder.io/migration/multi-group.html). ([#4156](https://github.com/operator-framework/operator-sdk/pull/4156))

### Changes

- (go/v2) Bumped controller-runtime from v0.6.3 to v0.6.4. ([#4282](https://github.com/operator-framework/operator-sdk/pull/4282))
- Go CLI plugin go/v3 is now the default. ([#4307](https://github.com/operator-framework/operator-sdk/pull/4307))
- Bumped `operator-sdk` binary dependencies to their k8s v1.19 equivalents. ([#4294](https://github.com/operator-framework/operator-sdk/pull/4294))
- Updated helm-operator's Helm dependency to v3.4.1. ([#4259](https://github.com/operator-framework/operator-sdk/pull/4259))

### Bug Fixes

- Made the `cleanup` command's error handling more robust on deletion and "not found" events. ([#4303](https://github.com/operator-framework/operator-sdk/pull/4303))
- Fixed the documented `packagemanifests` make recipe. ([#4303](https://github.com/operator-framework/operator-sdk/pull/4303))
- `generate kustomize manifests` will now (re)generate a base `ClusterServiceVersion` manifest with a valid name. ([#4276](https://github.com/operator-framework/operator-sdk/pull/4276))
- (ansible/v1) Pinned all top level Python requirements. This fixes a bug that erroneously installed Ansible 2.10.z instead of Ansible 2.9.z. ([#4321](https://github.com/operator-framework/operator-sdk/pull/4321))
- Refactored the `generate bundle|packagemanifest` commands to generate bundles/package manifest data outside of projects. ([#4074](https://github.com/operator-framework/operator-sdk/pull/4074))
- (go/v2) Removed unused import for defaulting webhooks scaffolded by `create webhook` ([kubebuilder#1718](https://github.com/kubernetes-sigs/kubebuilder/pull/1718)). ([#4156](https://github.com/operator-framework/operator-sdk/pull/4156))
- (go/v2) Allow owner to not be specified in generated licenses ([kubebuilder#1749](https://github.com/kubernetes-sigs/kubebuilder/pull/1749)). ([#4156](https://github.com/operator-framework/operator-sdk/pull/4156))
- (go/v2) Fixed controller imports scaffolded by `create api` when `--resource=false` ([kubebuilder#1770](https://github.com/kubernetes-sigs/kubebuilder/pull/1770)). ([#4215](https://github.com/operator-framework/operator-sdk/pull/4215))
