// Copyright 2018 The Operator-SDK Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package controller

import (
	"testing"

	"github.com/stretchr/testify/assert"
	"k8s.io/apimachinery/pkg/apis/meta/v1/unstructured"
)

func TestHasHelmUpgradeForceAnnotation(t *testing.T) {
	tests := []struct {
		input       map[string]interface{}
		expectedVal bool
		expectedOut string
		name        string
	}{
		{
			input: map[string]interface{}{
				"helm.operator-sdk/upgrade-force": "True",
			},
			expectedVal: true,
			name:        "base case true",
		},
		{
			input: map[string]interface{}{
				"helm.operator-sdk/upgrade-force": "False",
			},
			expectedVal: false,
			name:        "base case false",
		},
		{
			input: map[string]interface{}{
				"helm.operator-sdk/upgrade-force": "1",
			},
			expectedVal: true,
			name:        "true as int",
		},
		{
			input: map[string]interface{}{
				"helm.operator-sdk/upgrade-force": "0",
			},
			expectedVal: false,
			name:        "false as int",
		},
		{
			input: map[string]interface{}{
				"helm.operator-sdk/wrong-annotation": "true",
			},
			expectedVal: false,
			name:        "annotation not set",
		},
		{
			input: map[string]interface{}{
				"helm.operator-sdk/upgrade-force": "invalid",
			},
			expectedVal: false,
			name:        "invalid value",
		},
	}

	for _, test := range tests {
		assert.Equal(t, test.expectedVal, hasHelmUpgradeForceAnnotation(annotations(test.input)), test.name)
	}
}

func annotations(m map[string]interface{}) *unstructured.Unstructured {
	return &unstructured.Unstructured{
		Object: map[string]interface{}{
			"metadata": map[string]interface{}{
				"annotations": m,
			},
		},
	}
}
