// Copyright 2019 Google LLC.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.13.0
// source: google/devtools/clouderrorreporting/v1beta1/error_stats_service.proto

package clouderrorreporting

import (
	context "context"
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Specifies how the time periods of error group counts are aligned.
type TimedCountAlignment int32

const (
	// No alignment specified.
	TimedCountAlignment_ERROR_COUNT_ALIGNMENT_UNSPECIFIED TimedCountAlignment = 0
	// The time periods shall be consecutive, have width equal to the
	// requested duration, and be aligned at the `alignment_time` provided in
	// the request.
	// The `alignment_time` does not have to be inside the query period but
	// even if it is outside, only time periods are returned which overlap
	// with the query period.
	// A rounded alignment will typically result in a
	// different size of the first or the last time period.
	TimedCountAlignment_ALIGNMENT_EQUAL_ROUNDED TimedCountAlignment = 1
	// The time periods shall be consecutive, have width equal to the
	// requested duration, and be aligned at the end of the requested time
	// period. This can result in a different size of the
	// first time period.
	TimedCountAlignment_ALIGNMENT_EQUAL_AT_END TimedCountAlignment = 2
)

// Enum value maps for TimedCountAlignment.
var (
	TimedCountAlignment_name = map[int32]string{
		0: "ERROR_COUNT_ALIGNMENT_UNSPECIFIED",
		1: "ALIGNMENT_EQUAL_ROUNDED",
		2: "ALIGNMENT_EQUAL_AT_END",
	}
	TimedCountAlignment_value = map[string]int32{
		"ERROR_COUNT_ALIGNMENT_UNSPECIFIED": 0,
		"ALIGNMENT_EQUAL_ROUNDED":           1,
		"ALIGNMENT_EQUAL_AT_END":            2,
	}
)

func (x TimedCountAlignment) Enum() *TimedCountAlignment {
	p := new(TimedCountAlignment)
	*p = x
	return p
}

func (x TimedCountAlignment) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TimedCountAlignment) Descriptor() protoreflect.EnumDescriptor {
	return file_google_devtools_clouderrorreporting_v1beta1_error_stats_service_proto_enumTypes[0].Descriptor()
}

func (TimedCountAlignment) Type() protoreflect.EnumType {
	return &file_google_devtools_clouderrorreporting_v1beta1_error_stats_service_proto_enumTypes[0]
}

func (x TimedCountAlignment) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TimedCountAlignment.Descriptor instead.
func (TimedCountAlignment) EnumDescriptor() ([]byte, []int) {
	return file_google_devtools_clouderrorreporting_v1beta1_error_stats_service_proto_rawDescGZIP(), []int{0}
}

// A sorting order of error groups.
type ErrorGroupOrder int32

const (
	// No group order specified.
	ErrorGroupOrder_GROUP_ORDER_UNSPECIFIED ErrorGroupOrder = 0
	// Total count of errors in the given time window in descending order.
	ErrorGroupOrder_COUNT_DESC ErrorGroupOrder = 1
	// Timestamp when the group was last seen in the given time window
	// in descending order.
	ErrorGroupOrder_LAST_SEEN_DESC ErrorGroupOrder = 2
	// Timestamp when the group was created in descending order.
	ErrorGroupOrder_CREATED_DESC ErrorGroupOrder = 3
	// Number of affected users in the given time window in descending order.
	ErrorGroupOrder_AFFECTED_USERS_DESC ErrorGroupOrder = 4
)

// Enum value maps for ErrorGroupOrder.
var (
	ErrorGroupOrder_name = map[int32]string{
		0: "GROUP_ORDER_UNSPECIFIED",
		1: "COUNT_DESC",
		2: "LAST_SEEN_DESC",
		3: "CREATED_DESC",
		4: "AFFECTED_USERS_DESC",
	}
	ErrorGroupOrder_value = map[string]int32{
		"GROUP_ORDER_UNSPECIFIED": 0,
		"COUNT_DESC":              1,
		"LAST_SEEN_DESC":          2,
		"CREATED_DESC":            3,
		"AFFECTED_USERS_DESC":     4,
	}
)

func (x ErrorGroupOrder) Enum() *ErrorGroupOrder {
	p := new(ErrorGroupOrder)
	*p = x
	return p
}

func (x ErrorGroupOrder) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ErrorGroupOrder) Descriptor() protoreflect.EnumDescriptor {
	return file_google_devtools_clouderrorreporting_v1beta1_error_stats_service_proto_enumTypes[1].Descriptor()
}

func (ErrorGroupOrder) Type() protoreflect.EnumType {
	return &file_google_devtools_clouderrorreporting_v1beta1_error_stats_service_proto_enumTypes[1]
}

func (x ErrorGroupOrder) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ErrorGroupOrder.Descriptor instead.
func (ErrorGroupOrder) EnumDescriptor() ([]byte, []int) {
	return file_google_devtools_clouderrorreporting_v1beta1_error_stats_service_proto_rawDescGZIP(), []int{1}
}

// The supported time ranges.
type QueryTimeRange_Period int32

const (
	// Do not use.
	QueryTimeRange_PERIOD_UNSPECIFIED QueryTimeRange_Period = 0
	// Retrieve data for the last hour.
	// Recommended minimum timed count duration: 1 min.
	QueryTimeRange_PERIOD_1_HOUR QueryTimeRange_Period = 1
	// Retrieve data for the last 6 hours.
	// Recommended minimum timed count duration: 10 min.
	QueryTimeRange_PERIOD_6_HOURS QueryTimeRange_Period = 2
	// Retrieve data for the last day.
	// Recommended minimum timed count duration: 1 hour.
	QueryTimeRange_PERIOD_1_DAY QueryTimeRange_Period = 3
	// Retrieve data for the last week.
	// Recommended minimum timed count duration: 6 hours.
	QueryTimeRange_PERIOD_1_WEEK QueryTimeRange_Period = 4
	// Retrieve data for the last 30 days.
	// Recommended minimum timed count duration: 1 day.
	QueryTimeRange_PERIOD_30_DAYS QueryTimeRange_Period = 5
)

// Enum value maps for QueryTimeRange_Period.
var (
	QueryTimeRange_Period_name = map[int32]string{
		0: "PERIOD_UNSPECIFIED",
		1: "PERIOD_1_HOUR",
		2: "PERIOD_6_HOURS",
		3: "PERIOD_1_DAY",
		4: "PERIOD_1_WEEK",
		5: "PERIOD_30_DAYS",
	}
	QueryTimeRange_Period_value = map[string]int32{
		"PERIOD_UNSPECIFIED": 0,
		"PERIOD_1_HOUR":      1,
		"PERIOD_6_HOURS":     2,
		"PERIOD_1_DAY":       3,
		"PERIOD_1_WEEK":      4,
		"PERIOD_30_DAYS":     5,
	}
)

func (x QueryTimeRange_Period) Enum() *QueryTimeRange_Period {
	p := new(QueryTimeRange_Period)
	*p = x
	return p
}

func (x QueryTimeRange_Period) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (QueryTimeRange_Period) Descriptor() protoreflect.EnumDescriptor {
	return file_google_devtools_clouderrorreporting_v1beta1_error_stats_service_proto_enumTypes[2].Descriptor()
}

func (QueryTimeRange_Period) Type() protoreflect.EnumType {
	return &file_google_devtools_clouderrorreporting_v1beta1_error_stats_service_proto_enumTypes[2]
}

func (x QueryTimeRange_Period) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use QueryTimeRange_Period.Descriptor instead.
func (QueryTimeRange_Period) EnumDescriptor() ([]byte, []int) {
	return file_google_devtools_clouderrorreporting_v1beta1_error_stats_service_proto_rawDescGZIP(), []int{6, 0}
}

// Specifies a set of `ErrorGroupStats` to return.
type ListGroupStatsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Google Cloud Platform project. Written
	// as <code>projects/</code> plus the
	// <a href="https://support.google.com/cloud/answer/6158840">Google Cloud
	// Platform project ID</a>.
	//
	// Example: <code>projects/my-project-123</code>.
	ProjectName string `protobuf:"bytes,1,opt,name=project_name,json=projectName,proto3" json:"project_name,omitempty"`
	// Optional. List all <code>ErrorGroupStats</code> with these IDs.
	GroupId []string `protobuf:"bytes,2,rep,name=group_id,json=groupId,proto3" json:"group_id,omitempty"`
	// Optional. List only <code>ErrorGroupStats</code> which belong to a service
	// context that matches the filter.
	// Data for all service contexts is returned if this field is not specified.
	ServiceFilter *ServiceContextFilter `protobuf:"bytes,3,opt,name=service_filter,json=serviceFilter,proto3" json:"service_filter,omitempty"`
	// Optional. List data for the given time range.
	// If not set, a default time range is used. The field
	// <code>time_range_begin</code> in the response will specify the beginning
	// of this time range.
	// Only <code>ErrorGroupStats</code> with a non-zero count in the given time
	// range are returned, unless the request contains an explicit
	// <code>group_id</code> list. If a <code>group_id</code> list is given, also
	// <code>ErrorGroupStats</code> with zero occurrences are returned.
	TimeRange *QueryTimeRange `protobuf:"bytes,5,opt,name=time_range,json=timeRange,proto3" json:"time_range,omitempty"`
	// Optional. The preferred duration for a single returned `TimedCount`.
	// If not set, no timed counts are returned.
	TimedCountDuration *durationpb.Duration `protobuf:"bytes,6,opt,name=timed_count_duration,json=timedCountDuration,proto3" json:"timed_count_duration,omitempty"`
	// Optional. The alignment of the timed counts to be returned.
	// Default is `ALIGNMENT_EQUAL_AT_END`.
	Alignment TimedCountAlignment `protobuf:"varint,7,opt,name=alignment,proto3,enum=google.devtools.clouderrorreporting.v1beta1.TimedCountAlignment" json:"alignment,omitempty"`
	// Optional. Time where the timed counts shall be aligned if rounded
	// alignment is chosen. Default is 00:00 UTC.
	AlignmentTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=alignment_time,json=alignmentTime,proto3" json:"alignment_time,omitempty"`
	// Optional. The sort order in which the results are returned.
	// Default is `COUNT_DESC`.
	Order ErrorGroupOrder `protobuf:"varint,9,opt,name=order,proto3,enum=google.devtools.clouderrorreporting.v1beta1.ErrorGroupOrder" json:"order,omitempty"`
	// Optional. The maximum number of results to return per response.
	// Default is 20.
	PageSize int32 `protobuf:"varint,11,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A `next_page_token` provided by a previous response. To view
	// additional results, pass this token along with the identical query
	// parameters as the first request.
	PageToken string `protobuf:"bytes,12,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListGroupStatsRequest) Reset() {
	*x = ListGroupStatsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_clouderrorreporting_v1beta1_error_stats_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListGroupStatsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListGroupStatsRequest) ProtoMessage() {}

func (x *ListGroupStatsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_clouderrorreporting_v1beta1_error_stats_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListGroupStatsRequest.ProtoReflect.Descriptor instead.
func (*ListGroupStatsRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_clouderrorreporting_v1beta1_error_stats_service_proto_rawDescGZIP(), []int{0}
}

func (x *ListGroupStatsRequest) GetProjectName() string {
	if x != nil {
		return x.ProjectName
	}
	return ""
}

func (x *ListGroupStatsRequest) GetGroupId() []string {
	if x != nil {
		return x.GroupId
	}
	return nil
}

func (x *ListGroupStatsRequest) GetServiceFilter() *ServiceContextFilter {
	if x != nil {
		return x.ServiceFilter
	}
	return nil
}

func (x *ListGroupStatsRequest) GetTimeRange() *QueryTimeRange {
	if x != nil {
		return x.TimeRange
	}
	return nil
}

func (x *ListGroupStatsRequest) GetTimedCountDuration() *durationpb.Duration {
	if x != nil {
		return x.TimedCountDuration
	}
	return nil
}

func (x *ListGroupStatsRequest) GetAlignment() TimedCountAlignment {
	if x != nil {
		return x.Alignment
	}
	return TimedCountAlignment_ERROR_COUNT_ALIGNMENT_UNSPECIFIED
}

func (x *ListGroupStatsRequest) GetAlignmentTime() *timestamppb.Timestamp {
	if x != nil {
		return x.AlignmentTime
	}
	return nil
}

func (x *ListGroupStatsRequest) GetOrder() ErrorGroupOrder {
	if x != nil {
		return x.Order
	}
	return ErrorGroupOrder_GROUP_ORDER_UNSPECIFIED
}

func (x *ListGroupStatsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListGroupStatsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Contains a set of requested error group stats.
type ListGroupStatsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The error group stats which match the given request.
	ErrorGroupStats []*ErrorGroupStats `protobuf:"bytes,1,rep,name=error_group_stats,json=errorGroupStats,proto3" json:"error_group_stats,omitempty"`
	// If non-empty, more results are available.
	// Pass this token, along with the same query parameters as the first
	// request, to view the next page of results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// The timestamp specifies the start time to which the request was restricted.
	// The start time is set based on the requested time range. It may be adjusted
	// to a later time if a project has exceeded the storage quota and older data
	// has been deleted.
	TimeRangeBegin *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=time_range_begin,json=timeRangeBegin,proto3" json:"time_range_begin,omitempty"`
}

func (x *ListGroupStatsResponse) Reset() {
	*x = ListGroupStatsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_clouderrorreporting_v1beta1_error_stats_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListGroupStatsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListGroupStatsResponse) ProtoMessage() {}

func (x *ListGroupStatsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_clouderrorreporting_v1beta1_error_stats_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListGroupStatsResponse.ProtoReflect.Descriptor instead.
func (*ListGroupStatsResponse) Descriptor() ([]byte, []int) {
	return file_google_devtools_clouderrorreporting_v1beta1_error_stats_service_proto_rawDescGZIP(), []int{1}
}

func (x *ListGroupStatsResponse) GetErrorGroupStats() []*ErrorGroupStats {
	if x != nil {
		return x.ErrorGroupStats
	}
	return nil
}

func (x *ListGroupStatsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListGroupStatsResponse) GetTimeRangeBegin() *timestamppb.Timestamp {
	if x != nil {
		return x.TimeRangeBegin
	}
	return nil
}

// Data extracted for a specific group based on certain filter criteria,
// such as a given time period and/or service filter.
type ErrorGroupStats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Group data that is independent of the filter criteria.
	Group *ErrorGroup `protobuf:"bytes,1,opt,name=group,proto3" json:"group,omitempty"`
	// Approximate total number of events in the given group that match
	// the filter criteria.
	Count int64 `protobuf:"varint,2,opt,name=count,proto3" json:"count,omitempty"`
	// Approximate number of affected users in the given group that
	// match the filter criteria.
	// Users are distinguished by data in the `ErrorContext` of the
	// individual error events, such as their login name or their remote
	// IP address in case of HTTP requests.
	// The number of affected users can be zero even if the number of
	// errors is non-zero if no data was provided from which the
	// affected user could be deduced.
	// Users are counted based on data in the request
	// context that was provided in the error report. If more users are
	// implicitly affected, such as due to a crash of the whole service,
	// this is not reflected here.
	AffectedUsersCount int64 `protobuf:"varint,3,opt,name=affected_users_count,json=affectedUsersCount,proto3" json:"affected_users_count,omitempty"`
	// Approximate number of occurrences over time.
	// Timed counts returned by ListGroups are guaranteed to be:
	//
	// - Inside the requested time interval
	// - Non-overlapping, and
	// - Ordered by ascending time.
	TimedCounts []*TimedCount `protobuf:"bytes,4,rep,name=timed_counts,json=timedCounts,proto3" json:"timed_counts,omitempty"`
	// Approximate first occurrence that was ever seen for this group
	// and which matches the given filter criteria, ignoring the
	// time_range that was specified in the request.
	FirstSeenTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=first_seen_time,json=firstSeenTime,proto3" json:"first_seen_time,omitempty"`
	// Approximate last occurrence that was ever seen for this group and
	// which matches the given filter criteria, ignoring the time_range
	// that was specified in the request.
	LastSeenTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=last_seen_time,json=lastSeenTime,proto3" json:"last_seen_time,omitempty"`
	// Service contexts with a non-zero error count for the given filter
	// criteria. This list can be truncated if multiple services are affected.
	// Refer to `num_affected_services` for the total count.
	AffectedServices []*ServiceContext `protobuf:"bytes,7,rep,name=affected_services,json=affectedServices,proto3" json:"affected_services,omitempty"`
	// The total number of services with a non-zero error count for the given
	// filter criteria.
	NumAffectedServices int32 `protobuf:"varint,8,opt,name=num_affected_services,json=numAffectedServices,proto3" json:"num_affected_services,omitempty"`
	// An arbitrary event that is chosen as representative for the whole group.
	// The representative event is intended to be used as a quick preview for
	// the whole group. Events in the group are usually sufficiently similar
	// to each other such that showing an arbitrary representative provides
	// insight into the characteristics of the group as a whole.
	Representative *ErrorEvent `protobuf:"bytes,9,opt,name=representative,proto3" json:"representative,omitempty"`
}

func (x *ErrorGroupStats) Reset() {
	*x = ErrorGroupStats{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_clouderrorreporting_v1beta1_error_stats_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ErrorGroupStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ErrorGroupStats) ProtoMessage() {}

func (x *ErrorGroupStats) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_clouderrorreporting_v1beta1_error_stats_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ErrorGroupStats.ProtoReflect.Descriptor instead.
func (*ErrorGroupStats) Descriptor() ([]byte, []int) {
	return file_google_devtools_clouderrorreporting_v1beta1_error_stats_service_proto_rawDescGZIP(), []int{2}
}

func (x *ErrorGroupStats) GetGroup() *ErrorGroup {
	if x != nil {
		return x.Group
	}
	return nil
}

func (x *ErrorGroupStats) GetCount() int64 {
	if x != nil {
		return x.Count
	}
	return 0
}

func (x *ErrorGroupStats) GetAffectedUsersCount() int64 {
	if x != nil {
		return x.AffectedUsersCount
	}
	return 0
}

func (x *ErrorGroupStats) GetTimedCounts() []*TimedCount {
	if x != nil {
		return x.TimedCounts
	}
	return nil
}

func (x *ErrorGroupStats) GetFirstSeenTime() *timestamppb.Timestamp {
	if x != nil {
		return x.FirstSeenTime
	}
	return nil
}

func (x *ErrorGroupStats) GetLastSeenTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LastSeenTime
	}
	return nil
}

func (x *ErrorGroupStats) GetAffectedServices() []*ServiceContext {
	if x != nil {
		return x.AffectedServices
	}
	return nil
}

func (x *ErrorGroupStats) GetNumAffectedServices() int32 {
	if x != nil {
		return x.NumAffectedServices
	}
	return 0
}

func (x *ErrorGroupStats) GetRepresentative() *ErrorEvent {
	if x != nil {
		return x.Representative
	}
	return nil
}

// The number of errors in a given time period.
// All numbers are approximate since the error events are sampled
// before counting them.
type TimedCount struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Approximate number of occurrences in the given time period.
	Count int64 `protobuf:"varint,1,opt,name=count,proto3" json:"count,omitempty"`
	// Start of the time period to which `count` refers (included).
	StartTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// End of the time period to which `count` refers (excluded).
	EndTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
}

func (x *TimedCount) Reset() {
	*x = TimedCount{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_clouderrorreporting_v1beta1_error_stats_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TimedCount) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TimedCount) ProtoMessage() {}

func (x *TimedCount) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_clouderrorreporting_v1beta1_error_stats_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TimedCount.ProtoReflect.Descriptor instead.
func (*TimedCount) Descriptor() ([]byte, []int) {
	return file_google_devtools_clouderrorreporting_v1beta1_error_stats_service_proto_rawDescGZIP(), []int{3}
}

func (x *TimedCount) GetCount() int64 {
	if x != nil {
		return x.Count
	}
	return 0
}

func (x *TimedCount) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *TimedCount) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

// Specifies a set of error events to return.
type ListEventsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Google Cloud Platform project. Written
	// as `projects/` plus the
	// [Google Cloud Platform project
	// ID](https://support.google.com/cloud/answer/6158840).
	// Example: `projects/my-project-123`.
	ProjectName string `protobuf:"bytes,1,opt,name=project_name,json=projectName,proto3" json:"project_name,omitempty"`
	// Required. The group for which events shall be returned.
	GroupId string `protobuf:"bytes,2,opt,name=group_id,json=groupId,proto3" json:"group_id,omitempty"`
	// Optional. List only ErrorGroups which belong to a service context that
	// matches the filter.
	// Data for all service contexts is returned if this field is not specified.
	ServiceFilter *ServiceContextFilter `protobuf:"bytes,3,opt,name=service_filter,json=serviceFilter,proto3" json:"service_filter,omitempty"`
	// Optional. List only data for the given time range.
	// If not set a default time range is used. The field time_range_begin
	// in the response will specify the beginning of this time range.
	TimeRange *QueryTimeRange `protobuf:"bytes,4,opt,name=time_range,json=timeRange,proto3" json:"time_range,omitempty"`
	// Optional. The maximum number of results to return per response.
	PageSize int32 `protobuf:"varint,6,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A `next_page_token` provided by a previous response.
	PageToken string `protobuf:"bytes,7,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListEventsRequest) Reset() {
	*x = ListEventsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_clouderrorreporting_v1beta1_error_stats_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListEventsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListEventsRequest) ProtoMessage() {}

func (x *ListEventsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_clouderrorreporting_v1beta1_error_stats_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListEventsRequest.ProtoReflect.Descriptor instead.
func (*ListEventsRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_clouderrorreporting_v1beta1_error_stats_service_proto_rawDescGZIP(), []int{4}
}

func (x *ListEventsRequest) GetProjectName() string {
	if x != nil {
		return x.ProjectName
	}
	return ""
}

func (x *ListEventsRequest) GetGroupId() string {
	if x != nil {
		return x.GroupId
	}
	return ""
}

func (x *ListEventsRequest) GetServiceFilter() *ServiceContextFilter {
	if x != nil {
		return x.ServiceFilter
	}
	return nil
}

func (x *ListEventsRequest) GetTimeRange() *QueryTimeRange {
	if x != nil {
		return x.TimeRange
	}
	return nil
}

func (x *ListEventsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListEventsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Contains a set of requested error events.
type ListEventsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The error events which match the given request.
	ErrorEvents []*ErrorEvent `protobuf:"bytes,1,rep,name=error_events,json=errorEvents,proto3" json:"error_events,omitempty"`
	// If non-empty, more results are available.
	// Pass this token, along with the same query parameters as the first
	// request, to view the next page of results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// The timestamp specifies the start time to which the request was restricted.
	TimeRangeBegin *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=time_range_begin,json=timeRangeBegin,proto3" json:"time_range_begin,omitempty"`
}

func (x *ListEventsResponse) Reset() {
	*x = ListEventsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_clouderrorreporting_v1beta1_error_stats_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListEventsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListEventsResponse) ProtoMessage() {}

func (x *ListEventsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_clouderrorreporting_v1beta1_error_stats_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListEventsResponse.ProtoReflect.Descriptor instead.
func (*ListEventsResponse) Descriptor() ([]byte, []int) {
	return file_google_devtools_clouderrorreporting_v1beta1_error_stats_service_proto_rawDescGZIP(), []int{5}
}

func (x *ListEventsResponse) GetErrorEvents() []*ErrorEvent {
	if x != nil {
		return x.ErrorEvents
	}
	return nil
}

func (x *ListEventsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListEventsResponse) GetTimeRangeBegin() *timestamppb.Timestamp {
	if x != nil {
		return x.TimeRangeBegin
	}
	return nil
}

// Requests might be rejected or the resulting timed count durations might be
// adjusted for lower durations.
type QueryTimeRange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Restricts the query to the specified time range.
	Period QueryTimeRange_Period `protobuf:"varint,1,opt,name=period,proto3,enum=google.devtools.clouderrorreporting.v1beta1.QueryTimeRange_Period" json:"period,omitempty"`
}

func (x *QueryTimeRange) Reset() {
	*x = QueryTimeRange{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_clouderrorreporting_v1beta1_error_stats_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueryTimeRange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryTimeRange) ProtoMessage() {}

func (x *QueryTimeRange) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_clouderrorreporting_v1beta1_error_stats_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryTimeRange.ProtoReflect.Descriptor instead.
func (*QueryTimeRange) Descriptor() ([]byte, []int) {
	return file_google_devtools_clouderrorreporting_v1beta1_error_stats_service_proto_rawDescGZIP(), []int{6}
}

func (x *QueryTimeRange) GetPeriod() QueryTimeRange_Period {
	if x != nil {
		return x.Period
	}
	return QueryTimeRange_PERIOD_UNSPECIFIED
}

// Specifies criteria for filtering a subset of service contexts.
// The fields in the filter correspond to the fields in `ServiceContext`.
// Only exact, case-sensitive matches are supported.
// If a field is unset or empty, it matches arbitrary values.
type ServiceContextFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The exact value to match against
	// [`ServiceContext.service`](/error-reporting/reference/rest/v1beta1/ServiceContext#FIELDS.service).
	Service string `protobuf:"bytes,2,opt,name=service,proto3" json:"service,omitempty"`
	// Optional. The exact value to match against
	// [`ServiceContext.version`](/error-reporting/reference/rest/v1beta1/ServiceContext#FIELDS.version).
	Version string `protobuf:"bytes,3,opt,name=version,proto3" json:"version,omitempty"`
	// Optional. The exact value to match against
	// [`ServiceContext.resource_type`](/error-reporting/reference/rest/v1beta1/ServiceContext#FIELDS.resource_type).
	ResourceType string `protobuf:"bytes,4,opt,name=resource_type,json=resourceType,proto3" json:"resource_type,omitempty"`
}

func (x *ServiceContextFilter) Reset() {
	*x = ServiceContextFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_clouderrorreporting_v1beta1_error_stats_service_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ServiceContextFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServiceContextFilter) ProtoMessage() {}

func (x *ServiceContextFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_clouderrorreporting_v1beta1_error_stats_service_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServiceContextFilter.ProtoReflect.Descriptor instead.
func (*ServiceContextFilter) Descriptor() ([]byte, []int) {
	return file_google_devtools_clouderrorreporting_v1beta1_error_stats_service_proto_rawDescGZIP(), []int{7}
}

func (x *ServiceContextFilter) GetService() string {
	if x != nil {
		return x.Service
	}
	return ""
}

func (x *ServiceContextFilter) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *ServiceContextFilter) GetResourceType() string {
	if x != nil {
		return x.ResourceType
	}
	return ""
}

// Deletes all events in the project.
type DeleteEventsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Google Cloud Platform project. Written
	// as `projects/` plus the
	// [Google Cloud Platform project
	// ID](https://support.google.com/cloud/answer/6158840).
	// Example: `projects/my-project-123`.
	ProjectName string `protobuf:"bytes,1,opt,name=project_name,json=projectName,proto3" json:"project_name,omitempty"`
}

func (x *DeleteEventsRequest) Reset() {
	*x = DeleteEventsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_clouderrorreporting_v1beta1_error_stats_service_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteEventsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteEventsRequest) ProtoMessage() {}

func (x *DeleteEventsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_clouderrorreporting_v1beta1_error_stats_service_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteEventsRequest.ProtoReflect.Descriptor instead.
func (*DeleteEventsRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_clouderrorreporting_v1beta1_error_stats_service_proto_rawDescGZIP(), []int{8}
}

func (x *DeleteEventsRequest) GetProjectName() string {
	if x != nil {
		return x.ProjectName
	}
	return ""
}

// Response message for deleting error events.
type DeleteEventsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DeleteEventsResponse) Reset() {
	*x = DeleteEventsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_clouderrorreporting_v1beta1_error_stats_service_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteEventsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteEventsResponse) ProtoMessage() {}

func (x *DeleteEventsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_clouderrorreporting_v1beta1_error_stats_service_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteEventsResponse.ProtoReflect.Descriptor instead.
func (*DeleteEventsResponse) Descriptor() ([]byte, []int) {
	return file_google_devtools_clouderrorreporting_v1beta1_error_stats_service_proto_rawDescGZIP(), []int{9}
}

var File_google_devtools_clouderrorreporting_v1beta1_error_stats_service_proto protoreflect.FileDescriptor

var file_google_devtools_clouderrorreporting_v1beta1_error_stats_service_proto_rawDesc = []byte{
	0x0a, 0x45, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c,
	0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x72, 0x65, 0x70, 0x6f,
	0x72, 0x74, 0x69, 0x6e, 0x67, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x65, 0x72,
	0x72, 0x6f, 0x72, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x73, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x65, 0x72,
	0x72, 0x6f, 0x72, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63,
	0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65,
	0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x38, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x65, 0x72,
	0x72, 0x6f, 0x72, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x2f, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0xfd, 0x05, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x56, 0x0a, 0x0c,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x0b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1e, 0x0a, 0x08, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x69, 0x64,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x67, 0x72, 0x6f,
	0x75, 0x70, 0x49, 0x64, 0x12, 0x6d, 0x0a, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x69,
	0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x46, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x12, 0x5f, 0x0a, 0x0a, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x72, 0x61, 0x6e, 0x67,
	0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x65,
	0x72, 0x72, 0x6f, 0x72, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x54, 0x69, 0x6d, 0x65, 0x52,
	0x61, 0x6e, 0x67, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x52,
	0x61, 0x6e, 0x67, 0x65, 0x12, 0x50, 0x0a, 0x14, 0x74, 0x69, 0x6d, 0x65, 0x64, 0x5f, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x12, 0x74, 0x69, 0x6d, 0x65, 0x64, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x44, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x63, 0x0a, 0x09, 0x61, 0x6c, 0x69, 0x67, 0x6e, 0x6d,
	0x65, 0x6e, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x64, 0x43, 0x6f, 0x75,
	0x6e, 0x74, 0x41, 0x6c, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x09, 0x61, 0x6c, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x46, 0x0a, 0x0e, 0x61,
	0x6c, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x61, 0x6c, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x57, 0x0a, 0x05, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x18, 0x09, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74,
	0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x72,
	0x65, 0x70, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4f, 0x72, 0x64, 0x65, 0x72,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x12, 0x20, 0x0a, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x05, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22,
	0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x0c, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x22, 0xf0, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x68, 0x0a,
	0x11, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x73, 0x74, 0x61,
	0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x65, 0x72, 0x72, 0x6f, 0x72, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x0f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12,
	0x44, 0x0a, 0x10, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x62, 0x65,
	0x67, 0x69, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0e, 0x74, 0x69, 0x6d, 0x65, 0x52, 0x61, 0x6e, 0x67, 0x65,
	0x42, 0x65, 0x67, 0x69, 0x6e, 0x22, 0x89, 0x05, 0x0a, 0x0f, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x4d, 0x0a, 0x05, 0x67, 0x72, 0x6f,
	0x75, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x65, 0x72, 0x72, 0x6f, 0x72, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x52, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x14, 0x0a, 0x05, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x30,
	0x0a, 0x14, 0x61, 0x66, 0x66, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x73,
	0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x12, 0x61, 0x66,
	0x66, 0x65, 0x63, 0x74, 0x65, 0x64, 0x55, 0x73, 0x65, 0x72, 0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74,
	0x12, 0x5a, 0x0a, 0x0c, 0x74, 0x69, 0x6d, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73,
	0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x65, 0x72,
	0x72, 0x6f, 0x72, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x64, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x52,
	0x0b, 0x74, 0x69, 0x6d, 0x65, 0x64, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x12, 0x42, 0x0a, 0x0f,
	0x66, 0x69, 0x72, 0x73, 0x74, 0x5f, 0x73, 0x65, 0x65, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x52, 0x0d, 0x66, 0x69, 0x72, 0x73, 0x74, 0x53, 0x65, 0x65, 0x6e, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x40, 0x0a, 0x0e, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x73, 0x65, 0x65, 0x6e, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x52, 0x0c, 0x6c, 0x61, 0x73, 0x74, 0x53, 0x65, 0x65, 0x6e, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x68, 0x0a, 0x11, 0x61, 0x66, 0x66, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74,
	0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x52, 0x10, 0x61, 0x66, 0x66, 0x65,
	0x63, 0x74, 0x65, 0x64, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x12, 0x32, 0x0a, 0x15,
	0x6e, 0x75, 0x6d, 0x5f, 0x61, 0x66, 0x66, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x05, 0x52, 0x13, 0x6e, 0x75, 0x6d,
	0x41, 0x66, 0x66, 0x65, 0x63, 0x74, 0x65, 0x64, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73,
	0x12, 0x5f, 0x0a, 0x0e, 0x72, 0x65, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69,
	0x76, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x65, 0x72, 0x72, 0x6f, 0x72, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x52, 0x0e, 0x72, 0x65, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x76,
	0x65, 0x22, 0x94, 0x01, 0x0a, 0x0a, 0x54, 0x69, 0x6d, 0x65, 0x64, 0x43, 0x6f, 0x75, 0x6e, 0x74,
	0x12, 0x14, 0x0a, 0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x35, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52,
	0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x22, 0xa1, 0x03, 0x0a, 0x11, 0x4c, 0x69, 0x73,
	0x74, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x56,
	0x0a, 0x0c, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x0b, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1e, 0x0a, 0x08, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f,
	0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x49, 0x64, 0x12, 0x6d, 0x0a, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x41,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x72, 0x65, 0x70, 0x6f, 0x72,
	0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x46,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x5f, 0x0a, 0x0a, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x72, 0x61,
	0x6e, 0x67, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x54, 0x69, 0x6d,
	0x65, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x74, 0x69, 0x6d,
	0x65, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08,
	0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xde, 0x01, 0x0a,
	0x12, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x5a, 0x0a, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x65, 0x76, 0x65,
	0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x45, 0x76, 0x65,
	0x6e, 0x74, 0x52, 0x0b, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x12,
	0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x44, 0x0a, 0x10, 0x74, 0x69, 0x6d, 0x65, 0x5f,
	0x72, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x62, 0x65, 0x67, 0x69, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0e, 0x74,
	0x69, 0x6d, 0x65, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x42, 0x65, 0x67, 0x69, 0x6e, 0x22, 0xef, 0x01,
	0x0a, 0x0e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x54, 0x69, 0x6d, 0x65, 0x52, 0x61, 0x6e, 0x67, 0x65,
	0x12, 0x5a, 0x0a, 0x06, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f,
	0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x72, 0x65, 0x70,
	0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x54, 0x69, 0x6d, 0x65, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x2e, 0x50, 0x65,
	0x72, 0x69, 0x6f, 0x64, 0x52, 0x06, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x22, 0x80, 0x01, 0x0a,
	0x06, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x12, 0x16, 0x0a, 0x12, 0x50, 0x45, 0x52, 0x49, 0x4f,
	0x44, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x11, 0x0a, 0x0d, 0x50, 0x45, 0x52, 0x49, 0x4f, 0x44, 0x5f, 0x31, 0x5f, 0x48, 0x4f, 0x55, 0x52,
	0x10, 0x01, 0x12, 0x12, 0x0a, 0x0e, 0x50, 0x45, 0x52, 0x49, 0x4f, 0x44, 0x5f, 0x36, 0x5f, 0x48,
	0x4f, 0x55, 0x52, 0x53, 0x10, 0x02, 0x12, 0x10, 0x0a, 0x0c, 0x50, 0x45, 0x52, 0x49, 0x4f, 0x44,
	0x5f, 0x31, 0x5f, 0x44, 0x41, 0x59, 0x10, 0x03, 0x12, 0x11, 0x0a, 0x0d, 0x50, 0x45, 0x52, 0x49,
	0x4f, 0x44, 0x5f, 0x31, 0x5f, 0x57, 0x45, 0x45, 0x4b, 0x10, 0x04, 0x12, 0x12, 0x0a, 0x0e, 0x50,
	0x45, 0x52, 0x49, 0x4f, 0x44, 0x5f, 0x33, 0x30, 0x5f, 0x44, 0x41, 0x59, 0x53, 0x10, 0x05, 0x22,
	0x7e, 0x0a, 0x14, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78,
	0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1d, 0x0a, 0x07, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x1d, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x28, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x22,
	0x6d, 0x0a, 0x13, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x56, 0x0a, 0x0c, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x52, 0x0b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x16,
	0x0a, 0x14, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2a, 0x75, 0x0a, 0x13, 0x54, 0x69, 0x6d, 0x65, 0x64, 0x43,
	0x6f, 0x75, 0x6e, 0x74, 0x41, 0x6c, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x25, 0x0a,
	0x21, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x5f, 0x43, 0x4f, 0x55, 0x4e, 0x54, 0x5f, 0x41, 0x4c, 0x49,
	0x47, 0x4e, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x1b, 0x0a, 0x17, 0x41, 0x4c, 0x49, 0x47, 0x4e, 0x4d, 0x45, 0x4e,
	0x54, 0x5f, 0x45, 0x51, 0x55, 0x41, 0x4c, 0x5f, 0x52, 0x4f, 0x55, 0x4e, 0x44, 0x45, 0x44, 0x10,
	0x01, 0x12, 0x1a, 0x0a, 0x16, 0x41, 0x4c, 0x49, 0x47, 0x4e, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x45,
	0x51, 0x55, 0x41, 0x4c, 0x5f, 0x41, 0x54, 0x5f, 0x45, 0x4e, 0x44, 0x10, 0x02, 0x2a, 0x7d, 0x0a,
	0x0f, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4f, 0x72, 0x64, 0x65, 0x72,
	0x12, 0x1b, 0x0a, 0x17, 0x47, 0x52, 0x4f, 0x55, 0x50, 0x5f, 0x4f, 0x52, 0x44, 0x45, 0x52, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0e, 0x0a,
	0x0a, 0x43, 0x4f, 0x55, 0x4e, 0x54, 0x5f, 0x44, 0x45, 0x53, 0x43, 0x10, 0x01, 0x12, 0x12, 0x0a,
	0x0e, 0x4c, 0x41, 0x53, 0x54, 0x5f, 0x53, 0x45, 0x45, 0x4e, 0x5f, 0x44, 0x45, 0x53, 0x43, 0x10,
	0x02, 0x12, 0x10, 0x0a, 0x0c, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x44, 0x5f, 0x44, 0x45, 0x53,
	0x43, 0x10, 0x03, 0x12, 0x17, 0x0a, 0x13, 0x41, 0x46, 0x46, 0x45, 0x43, 0x54, 0x45, 0x44, 0x5f,
	0x55, 0x53, 0x45, 0x52, 0x53, 0x5f, 0x44, 0x45, 0x53, 0x43, 0x10, 0x04, 0x32, 0x8b, 0x06, 0x0a,
	0x11, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x53, 0x74, 0x61, 0x74, 0x73, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x12, 0xea, 0x01, 0x0a, 0x0e, 0x4c, 0x69, 0x73, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64,
	0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x65, 0x72, 0x72,
	0x6f, 0x72, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x53, 0x74, 0x61,
	0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4f,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2f, 0x12, 0x2d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0x53, 0x74, 0x61, 0x74, 0x73, 0xda, 0x41, 0x17, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x12,
	0xd8, 0x01, 0x0a, 0x0a, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x3e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x72, 0x65, 0x70, 0x6f, 0x72,
	0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x72, 0x65, 0x70, 0x6f, 0x72,
	0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x49, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2b, 0x12, 0x29, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x65, 0x76, 0x65, 0x6e,
	0x74, 0x73, 0xda, 0x41, 0x15, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x2c, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x69, 0x64, 0x12, 0xd5, 0x01, 0x0a, 0x0c, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x40, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x69, 0x6e,
	0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x41, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74,
	0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x40, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2b, 0x2a, 0x29, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x65, 0x76, 0x65,
	0x6e, 0x74, 0x73, 0xda, 0x41, 0x0c, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x1a, 0x56, 0xca, 0x41, 0x22, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x65, 0x72, 0x72, 0x6f,
	0x72, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70,
	0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xa3, 0x02, 0x0a, 0x2f, 0x63,
	0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f,
	0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x72, 0x65, 0x70,
	0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x42, 0x16,
	0x45, 0x72, 0x72, 0x6f, 0x72, 0x53, 0x74, 0x61, 0x74, 0x73, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x5e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f,
	0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x65, 0x72,
	0x72, 0x6f, 0x72, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x2f, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x3b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x72,
	0x65, 0x70, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0xf8, 0x01, 0x01, 0xaa, 0x02, 0x23, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x45, 0x72, 0x72, 0x6f, 0x72,
	0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61,
	0x31, 0xca, 0x02, 0x23, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x5c, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x5c,
	0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0xea, 0x02, 0x26, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x52, 0x65,
	0x70, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_devtools_clouderrorreporting_v1beta1_error_stats_service_proto_rawDescOnce sync.Once
	file_google_devtools_clouderrorreporting_v1beta1_error_stats_service_proto_rawDescData = file_google_devtools_clouderrorreporting_v1beta1_error_stats_service_proto_rawDesc
)

func file_google_devtools_clouderrorreporting_v1beta1_error_stats_service_proto_rawDescGZIP() []byte {
	file_google_devtools_clouderrorreporting_v1beta1_error_stats_service_proto_rawDescOnce.Do(func() {
		file_google_devtools_clouderrorreporting_v1beta1_error_stats_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_devtools_clouderrorreporting_v1beta1_error_stats_service_proto_rawDescData)
	})
	return file_google_devtools_clouderrorreporting_v1beta1_error_stats_service_proto_rawDescData
}

var file_google_devtools_clouderrorreporting_v1beta1_error_stats_service_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_devtools_clouderrorreporting_v1beta1_error_stats_service_proto_msgTypes = make([]protoimpl.MessageInfo, 10)
var file_google_devtools_clouderrorreporting_v1beta1_error_stats_service_proto_goTypes = []interface{}{
	(TimedCountAlignment)(0),       // 0: google.devtools.clouderrorreporting.v1beta1.TimedCountAlignment
	(ErrorGroupOrder)(0),           // 1: google.devtools.clouderrorreporting.v1beta1.ErrorGroupOrder
	(QueryTimeRange_Period)(0),     // 2: google.devtools.clouderrorreporting.v1beta1.QueryTimeRange.Period
	(*ListGroupStatsRequest)(nil),  // 3: google.devtools.clouderrorreporting.v1beta1.ListGroupStatsRequest
	(*ListGroupStatsResponse)(nil), // 4: google.devtools.clouderrorreporting.v1beta1.ListGroupStatsResponse
	(*ErrorGroupStats)(nil),        // 5: google.devtools.clouderrorreporting.v1beta1.ErrorGroupStats
	(*TimedCount)(nil),             // 6: google.devtools.clouderrorreporting.v1beta1.TimedCount
	(*ListEventsRequest)(nil),      // 7: google.devtools.clouderrorreporting.v1beta1.ListEventsRequest
	(*ListEventsResponse)(nil),     // 8: google.devtools.clouderrorreporting.v1beta1.ListEventsResponse
	(*QueryTimeRange)(nil),         // 9: google.devtools.clouderrorreporting.v1beta1.QueryTimeRange
	(*ServiceContextFilter)(nil),   // 10: google.devtools.clouderrorreporting.v1beta1.ServiceContextFilter
	(*DeleteEventsRequest)(nil),    // 11: google.devtools.clouderrorreporting.v1beta1.DeleteEventsRequest
	(*DeleteEventsResponse)(nil),   // 12: google.devtools.clouderrorreporting.v1beta1.DeleteEventsResponse
	(*durationpb.Duration)(nil),    // 13: google.protobuf.Duration
	(*timestamppb.Timestamp)(nil),  // 14: google.protobuf.Timestamp
	(*ErrorGroup)(nil),             // 15: google.devtools.clouderrorreporting.v1beta1.ErrorGroup
	(*ServiceContext)(nil),         // 16: google.devtools.clouderrorreporting.v1beta1.ServiceContext
	(*ErrorEvent)(nil),             // 17: google.devtools.clouderrorreporting.v1beta1.ErrorEvent
}
var file_google_devtools_clouderrorreporting_v1beta1_error_stats_service_proto_depIdxs = []int32{
	10, // 0: google.devtools.clouderrorreporting.v1beta1.ListGroupStatsRequest.service_filter:type_name -> google.devtools.clouderrorreporting.v1beta1.ServiceContextFilter
	9,  // 1: google.devtools.clouderrorreporting.v1beta1.ListGroupStatsRequest.time_range:type_name -> google.devtools.clouderrorreporting.v1beta1.QueryTimeRange
	13, // 2: google.devtools.clouderrorreporting.v1beta1.ListGroupStatsRequest.timed_count_duration:type_name -> google.protobuf.Duration
	0,  // 3: google.devtools.clouderrorreporting.v1beta1.ListGroupStatsRequest.alignment:type_name -> google.devtools.clouderrorreporting.v1beta1.TimedCountAlignment
	14, // 4: google.devtools.clouderrorreporting.v1beta1.ListGroupStatsRequest.alignment_time:type_name -> google.protobuf.Timestamp
	1,  // 5: google.devtools.clouderrorreporting.v1beta1.ListGroupStatsRequest.order:type_name -> google.devtools.clouderrorreporting.v1beta1.ErrorGroupOrder
	5,  // 6: google.devtools.clouderrorreporting.v1beta1.ListGroupStatsResponse.error_group_stats:type_name -> google.devtools.clouderrorreporting.v1beta1.ErrorGroupStats
	14, // 7: google.devtools.clouderrorreporting.v1beta1.ListGroupStatsResponse.time_range_begin:type_name -> google.protobuf.Timestamp
	15, // 8: google.devtools.clouderrorreporting.v1beta1.ErrorGroupStats.group:type_name -> google.devtools.clouderrorreporting.v1beta1.ErrorGroup
	6,  // 9: google.devtools.clouderrorreporting.v1beta1.ErrorGroupStats.timed_counts:type_name -> google.devtools.clouderrorreporting.v1beta1.TimedCount
	14, // 10: google.devtools.clouderrorreporting.v1beta1.ErrorGroupStats.first_seen_time:type_name -> google.protobuf.Timestamp
	14, // 11: google.devtools.clouderrorreporting.v1beta1.ErrorGroupStats.last_seen_time:type_name -> google.protobuf.Timestamp
	16, // 12: google.devtools.clouderrorreporting.v1beta1.ErrorGroupStats.affected_services:type_name -> google.devtools.clouderrorreporting.v1beta1.ServiceContext
	17, // 13: google.devtools.clouderrorreporting.v1beta1.ErrorGroupStats.representative:type_name -> google.devtools.clouderrorreporting.v1beta1.ErrorEvent
	14, // 14: google.devtools.clouderrorreporting.v1beta1.TimedCount.start_time:type_name -> google.protobuf.Timestamp
	14, // 15: google.devtools.clouderrorreporting.v1beta1.TimedCount.end_time:type_name -> google.protobuf.Timestamp
	10, // 16: google.devtools.clouderrorreporting.v1beta1.ListEventsRequest.service_filter:type_name -> google.devtools.clouderrorreporting.v1beta1.ServiceContextFilter
	9,  // 17: google.devtools.clouderrorreporting.v1beta1.ListEventsRequest.time_range:type_name -> google.devtools.clouderrorreporting.v1beta1.QueryTimeRange
	17, // 18: google.devtools.clouderrorreporting.v1beta1.ListEventsResponse.error_events:type_name -> google.devtools.clouderrorreporting.v1beta1.ErrorEvent
	14, // 19: google.devtools.clouderrorreporting.v1beta1.ListEventsResponse.time_range_begin:type_name -> google.protobuf.Timestamp
	2,  // 20: google.devtools.clouderrorreporting.v1beta1.QueryTimeRange.period:type_name -> google.devtools.clouderrorreporting.v1beta1.QueryTimeRange.Period
	3,  // 21: google.devtools.clouderrorreporting.v1beta1.ErrorStatsService.ListGroupStats:input_type -> google.devtools.clouderrorreporting.v1beta1.ListGroupStatsRequest
	7,  // 22: google.devtools.clouderrorreporting.v1beta1.ErrorStatsService.ListEvents:input_type -> google.devtools.clouderrorreporting.v1beta1.ListEventsRequest
	11, // 23: google.devtools.clouderrorreporting.v1beta1.ErrorStatsService.DeleteEvents:input_type -> google.devtools.clouderrorreporting.v1beta1.DeleteEventsRequest
	4,  // 24: google.devtools.clouderrorreporting.v1beta1.ErrorStatsService.ListGroupStats:output_type -> google.devtools.clouderrorreporting.v1beta1.ListGroupStatsResponse
	8,  // 25: google.devtools.clouderrorreporting.v1beta1.ErrorStatsService.ListEvents:output_type -> google.devtools.clouderrorreporting.v1beta1.ListEventsResponse
	12, // 26: google.devtools.clouderrorreporting.v1beta1.ErrorStatsService.DeleteEvents:output_type -> google.devtools.clouderrorreporting.v1beta1.DeleteEventsResponse
	24, // [24:27] is the sub-list for method output_type
	21, // [21:24] is the sub-list for method input_type
	21, // [21:21] is the sub-list for extension type_name
	21, // [21:21] is the sub-list for extension extendee
	0,  // [0:21] is the sub-list for field type_name
}

func init() { file_google_devtools_clouderrorreporting_v1beta1_error_stats_service_proto_init() }
func file_google_devtools_clouderrorreporting_v1beta1_error_stats_service_proto_init() {
	if File_google_devtools_clouderrorreporting_v1beta1_error_stats_service_proto != nil {
		return
	}
	file_google_devtools_clouderrorreporting_v1beta1_common_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_devtools_clouderrorreporting_v1beta1_error_stats_service_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListGroupStatsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_clouderrorreporting_v1beta1_error_stats_service_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListGroupStatsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_clouderrorreporting_v1beta1_error_stats_service_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ErrorGroupStats); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_clouderrorreporting_v1beta1_error_stats_service_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TimedCount); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_clouderrorreporting_v1beta1_error_stats_service_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListEventsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_clouderrorreporting_v1beta1_error_stats_service_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListEventsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_clouderrorreporting_v1beta1_error_stats_service_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QueryTimeRange); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_clouderrorreporting_v1beta1_error_stats_service_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ServiceContextFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_clouderrorreporting_v1beta1_error_stats_service_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteEventsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_clouderrorreporting_v1beta1_error_stats_service_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteEventsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_devtools_clouderrorreporting_v1beta1_error_stats_service_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   10,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_devtools_clouderrorreporting_v1beta1_error_stats_service_proto_goTypes,
		DependencyIndexes: file_google_devtools_clouderrorreporting_v1beta1_error_stats_service_proto_depIdxs,
		EnumInfos:         file_google_devtools_clouderrorreporting_v1beta1_error_stats_service_proto_enumTypes,
		MessageInfos:      file_google_devtools_clouderrorreporting_v1beta1_error_stats_service_proto_msgTypes,
	}.Build()
	File_google_devtools_clouderrorreporting_v1beta1_error_stats_service_proto = out.File
	file_google_devtools_clouderrorreporting_v1beta1_error_stats_service_proto_rawDesc = nil
	file_google_devtools_clouderrorreporting_v1beta1_error_stats_service_proto_goTypes = nil
	file_google_devtools_clouderrorreporting_v1beta1_error_stats_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ErrorStatsServiceClient is the client API for ErrorStatsService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ErrorStatsServiceClient interface {
	// Lists the specified groups.
	ListGroupStats(ctx context.Context, in *ListGroupStatsRequest, opts ...grpc.CallOption) (*ListGroupStatsResponse, error)
	// Lists the specified events.
	ListEvents(ctx context.Context, in *ListEventsRequest, opts ...grpc.CallOption) (*ListEventsResponse, error)
	// Deletes all error events of a given project.
	DeleteEvents(ctx context.Context, in *DeleteEventsRequest, opts ...grpc.CallOption) (*DeleteEventsResponse, error)
}

type errorStatsServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewErrorStatsServiceClient(cc grpc.ClientConnInterface) ErrorStatsServiceClient {
	return &errorStatsServiceClient{cc}
}

func (c *errorStatsServiceClient) ListGroupStats(ctx context.Context, in *ListGroupStatsRequest, opts ...grpc.CallOption) (*ListGroupStatsResponse, error) {
	out := new(ListGroupStatsResponse)
	err := c.cc.Invoke(ctx, "/google.devtools.clouderrorreporting.v1beta1.ErrorStatsService/ListGroupStats", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *errorStatsServiceClient) ListEvents(ctx context.Context, in *ListEventsRequest, opts ...grpc.CallOption) (*ListEventsResponse, error) {
	out := new(ListEventsResponse)
	err := c.cc.Invoke(ctx, "/google.devtools.clouderrorreporting.v1beta1.ErrorStatsService/ListEvents", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *errorStatsServiceClient) DeleteEvents(ctx context.Context, in *DeleteEventsRequest, opts ...grpc.CallOption) (*DeleteEventsResponse, error) {
	out := new(DeleteEventsResponse)
	err := c.cc.Invoke(ctx, "/google.devtools.clouderrorreporting.v1beta1.ErrorStatsService/DeleteEvents", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ErrorStatsServiceServer is the server API for ErrorStatsService service.
type ErrorStatsServiceServer interface {
	// Lists the specified groups.
	ListGroupStats(context.Context, *ListGroupStatsRequest) (*ListGroupStatsResponse, error)
	// Lists the specified events.
	ListEvents(context.Context, *ListEventsRequest) (*ListEventsResponse, error)
	// Deletes all error events of a given project.
	DeleteEvents(context.Context, *DeleteEventsRequest) (*DeleteEventsResponse, error)
}

// UnimplementedErrorStatsServiceServer can be embedded to have forward compatible implementations.
type UnimplementedErrorStatsServiceServer struct {
}

func (*UnimplementedErrorStatsServiceServer) ListGroupStats(context.Context, *ListGroupStatsRequest) (*ListGroupStatsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListGroupStats not implemented")
}
func (*UnimplementedErrorStatsServiceServer) ListEvents(context.Context, *ListEventsRequest) (*ListEventsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListEvents not implemented")
}
func (*UnimplementedErrorStatsServiceServer) DeleteEvents(context.Context, *DeleteEventsRequest) (*DeleteEventsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteEvents not implemented")
}

func RegisterErrorStatsServiceServer(s *grpc.Server, srv ErrorStatsServiceServer) {
	s.RegisterService(&_ErrorStatsService_serviceDesc, srv)
}

func _ErrorStatsService_ListGroupStats_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListGroupStatsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ErrorStatsServiceServer).ListGroupStats(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.clouderrorreporting.v1beta1.ErrorStatsService/ListGroupStats",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ErrorStatsServiceServer).ListGroupStats(ctx, req.(*ListGroupStatsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ErrorStatsService_ListEvents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListEventsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ErrorStatsServiceServer).ListEvents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.clouderrorreporting.v1beta1.ErrorStatsService/ListEvents",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ErrorStatsServiceServer).ListEvents(ctx, req.(*ListEventsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ErrorStatsService_DeleteEvents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteEventsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ErrorStatsServiceServer).DeleteEvents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.clouderrorreporting.v1beta1.ErrorStatsService/DeleteEvents",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ErrorStatsServiceServer).DeleteEvents(ctx, req.(*DeleteEventsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ErrorStatsService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.devtools.clouderrorreporting.v1beta1.ErrorStatsService",
	HandlerType: (*ErrorStatsServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListGroupStats",
			Handler:    _ErrorStatsService_ListGroupStats_Handler,
		},
		{
			MethodName: "ListEvents",
			Handler:    _ErrorStatsService_ListEvents_Handler,
		},
		{
			MethodName: "DeleteEvents",
			Handler:    _ErrorStatsService_DeleteEvents_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/devtools/clouderrorreporting/v1beta1/error_stats_service.proto",
}
