// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.13.0
// source: google/cloud/video/transcoder/v1beta1/resources.proto

package transcoder

import (
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// The current state of the job.
type Job_ProcessingState int32

const (
	// The processing state is not specified.
	Job_PROCESSING_STATE_UNSPECIFIED Job_ProcessingState = 0
	// The job is enqueued and will be picked up for processing soon.
	Job_PENDING Job_ProcessingState = 1
	// The job is being processed.
	Job_RUNNING Job_ProcessingState = 2
	// The job has been completed successfully.
	Job_SUCCEEDED Job_ProcessingState = 3
	// The job has failed. For additional information, see `failure_reason` and
	// `failure_details`
	Job_FAILED Job_ProcessingState = 4
)

// Enum value maps for Job_ProcessingState.
var (
	Job_ProcessingState_name = map[int32]string{
		0: "PROCESSING_STATE_UNSPECIFIED",
		1: "PENDING",
		2: "RUNNING",
		3: "SUCCEEDED",
		4: "FAILED",
	}
	Job_ProcessingState_value = map[string]int32{
		"PROCESSING_STATE_UNSPECIFIED": 0,
		"PENDING":                      1,
		"RUNNING":                      2,
		"SUCCEEDED":                    3,
		"FAILED":                       4,
	}
)

func (x Job_ProcessingState) Enum() *Job_ProcessingState {
	p := new(Job_ProcessingState)
	*p = x
	return p
}

func (x Job_ProcessingState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Job_ProcessingState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_video_transcoder_v1beta1_resources_proto_enumTypes[0].Descriptor()
}

func (Job_ProcessingState) Type() protoreflect.EnumType {
	return &file_google_cloud_video_transcoder_v1beta1_resources_proto_enumTypes[0]
}

func (x Job_ProcessingState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Job_ProcessingState.Descriptor instead.
func (Job_ProcessingState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1beta1_resources_proto_rawDescGZIP(), []int{0, 0}
}

// The manifest type can be either `"HLS"` or `"DASH"`.
type Manifest_ManifestType int32

const (
	// The manifest type is not specified.
	Manifest_MANIFEST_TYPE_UNSPECIFIED Manifest_ManifestType = 0
	// Create `"HLS"` manifest. The corresponding file extension is `".m3u8"`.
	Manifest_HLS Manifest_ManifestType = 1
	// Create `"DASH"` manifest. The corresponding file extension is `".mpd"`.
	Manifest_DASH Manifest_ManifestType = 2
)

// Enum value maps for Manifest_ManifestType.
var (
	Manifest_ManifestType_name = map[int32]string{
		0: "MANIFEST_TYPE_UNSPECIFIED",
		1: "HLS",
		2: "DASH",
	}
	Manifest_ManifestType_value = map[string]int32{
		"MANIFEST_TYPE_UNSPECIFIED": 0,
		"HLS":                       1,
		"DASH":                      2,
	}
)

func (x Manifest_ManifestType) Enum() *Manifest_ManifestType {
	p := new(Manifest_ManifestType)
	*p = x
	return p
}

func (x Manifest_ManifestType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Manifest_ManifestType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_video_transcoder_v1beta1_resources_proto_enumTypes[1].Descriptor()
}

func (Manifest_ManifestType) Type() protoreflect.EnumType {
	return &file_google_cloud_video_transcoder_v1beta1_resources_proto_enumTypes[1]
}

func (x Manifest_ManifestType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Manifest_ManifestType.Descriptor instead.
func (Manifest_ManifestType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1beta1_resources_proto_rawDescGZIP(), []int{9, 0}
}

// Fade type for the overlay: `FADE_IN` or `FADE_OUT`.
type Overlay_FadeType int32

const (
	// The fade type is not specified.
	Overlay_FADE_TYPE_UNSPECIFIED Overlay_FadeType = 0
	// Fade the overlay object into view.
	Overlay_FADE_IN Overlay_FadeType = 1
	// Fade the overlay object out of view.
	Overlay_FADE_OUT Overlay_FadeType = 2
)

// Enum value maps for Overlay_FadeType.
var (
	Overlay_FadeType_name = map[int32]string{
		0: "FADE_TYPE_UNSPECIFIED",
		1: "FADE_IN",
		2: "FADE_OUT",
	}
	Overlay_FadeType_value = map[string]int32{
		"FADE_TYPE_UNSPECIFIED": 0,
		"FADE_IN":               1,
		"FADE_OUT":              2,
	}
)

func (x Overlay_FadeType) Enum() *Overlay_FadeType {
	p := new(Overlay_FadeType)
	*p = x
	return p
}

func (x Overlay_FadeType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Overlay_FadeType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_video_transcoder_v1beta1_resources_proto_enumTypes[2].Descriptor()
}

func (Overlay_FadeType) Type() protoreflect.EnumType {
	return &file_google_cloud_video_transcoder_v1beta1_resources_proto_enumTypes[2]
}

func (x Overlay_FadeType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Overlay_FadeType.Descriptor instead.
func (Overlay_FadeType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1beta1_resources_proto_rawDescGZIP(), []int{12, 0}
}

// Transcoding job resource.
type Job struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the job.
	// Format: `projects/{project}/locations/{location}/jobs/{job}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Input only. Specify the `input_uri` to populate empty `uri` fields in each element of
	// `Job.config.inputs` or `JobTemplate.config.inputs` when using template.
	// URI of the media. It must be stored in Cloud Storage. For example,
	// `gs://bucket/inputs/file.mp4`.
	InputUri string `protobuf:"bytes,2,opt,name=input_uri,json=inputUri,proto3" json:"input_uri,omitempty"`
	// Input only. Specify the `output_uri` to populate an empty `Job.config.output.uri` or
	// `JobTemplate.config.output.uri` when using template.
	// URI for the output file(s). For example, `gs://my-bucket/outputs/`.
	OutputUri string `protobuf:"bytes,3,opt,name=output_uri,json=outputUri,proto3" json:"output_uri,omitempty"`
	// Specify the `job_config` for transcoding job. When you use a `template_id`
	// to create a job, the `Job.config` is populated by the `JobTemplate.config`.
	//
	// Types that are assignable to JobConfig:
	//	*Job_TemplateId
	//	*Job_Config
	JobConfig isJob_JobConfig `protobuf_oneof:"job_config"`
	// Specify the priority of the job. Enter a value between 0 and 100, where 0
	// is the lowest priority and 100 is the highest priority. The default is 0.
	Priority int32 `protobuf:"varint,6,opt,name=priority,proto3" json:"priority,omitempty"`
	// Output only. The origin URI.
	OriginUri *Job_OriginUri `protobuf:"bytes,7,opt,name=origin_uri,json=originUri,proto3" json:"origin_uri,omitempty"`
	// Output only. The current state of the job.
	State Job_ProcessingState `protobuf:"varint,8,opt,name=state,proto3,enum=google.cloud.video.transcoder.v1beta1.Job_ProcessingState" json:"state,omitempty"`
	// Output only. Estimated fractional progress, from `0` to `1` for each
	// step.
	Progress *Progress `protobuf:"bytes,9,opt,name=progress,proto3" json:"progress,omitempty"`
	// Output only. A description of the reason for the failure. This property is
	// always present when `state` is `FAILED`.
	FailureReason string `protobuf:"bytes,10,opt,name=failure_reason,json=failureReason,proto3" json:"failure_reason,omitempty"`
	// Output only. List of failure details. This property may contain additional
	// information about the failure when `failure_reason` is present.
	FailureDetails []*FailureDetail `protobuf:"bytes,11,rep,name=failure_details,json=failureDetails,proto3" json:"failure_details,omitempty"`
	// Output only. The time the job was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,12,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time the transcoding started.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,13,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Output only. The time the transcoding finished.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,14,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
}

func (x *Job) Reset() {
	*x = Job{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Job) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Job) ProtoMessage() {}

func (x *Job) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Job.ProtoReflect.Descriptor instead.
func (*Job) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1beta1_resources_proto_rawDescGZIP(), []int{0}
}

func (x *Job) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Job) GetInputUri() string {
	if x != nil {
		return x.InputUri
	}
	return ""
}

func (x *Job) GetOutputUri() string {
	if x != nil {
		return x.OutputUri
	}
	return ""
}

func (m *Job) GetJobConfig() isJob_JobConfig {
	if m != nil {
		return m.JobConfig
	}
	return nil
}

func (x *Job) GetTemplateId() string {
	if x, ok := x.GetJobConfig().(*Job_TemplateId); ok {
		return x.TemplateId
	}
	return ""
}

func (x *Job) GetConfig() *JobConfig {
	if x, ok := x.GetJobConfig().(*Job_Config); ok {
		return x.Config
	}
	return nil
}

func (x *Job) GetPriority() int32 {
	if x != nil {
		return x.Priority
	}
	return 0
}

func (x *Job) GetOriginUri() *Job_OriginUri {
	if x != nil {
		return x.OriginUri
	}
	return nil
}

func (x *Job) GetState() Job_ProcessingState {
	if x != nil {
		return x.State
	}
	return Job_PROCESSING_STATE_UNSPECIFIED
}

func (x *Job) GetProgress() *Progress {
	if x != nil {
		return x.Progress
	}
	return nil
}

func (x *Job) GetFailureReason() string {
	if x != nil {
		return x.FailureReason
	}
	return ""
}

func (x *Job) GetFailureDetails() []*FailureDetail {
	if x != nil {
		return x.FailureDetails
	}
	return nil
}

func (x *Job) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Job) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *Job) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

type isJob_JobConfig interface {
	isJob_JobConfig()
}

type Job_TemplateId struct {
	// Input only. Specify the `template_id` to use for populating `Job.config`. The default
	// is `preset/web-hd`.
	//
	// Preset Transcoder templates:
	// - `preset/{preset_id}`
	//
	// - User defined JobTemplate:
	//   `{job_template_id}`
	TemplateId string `protobuf:"bytes,4,opt,name=template_id,json=templateId,proto3,oneof"`
}

type Job_Config struct {
	// The configuration for this job.
	Config *JobConfig `protobuf:"bytes,5,opt,name=config,proto3,oneof"`
}

func (*Job_TemplateId) isJob_JobConfig() {}

func (*Job_Config) isJob_JobConfig() {}

// Transcoding job template resource.
type JobTemplate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the job template.
	// Format:
	// `projects/{project}/locations/{location}/jobTemplates/{job_template}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The configuration for this template.
	Config *JobConfig `protobuf:"bytes,2,opt,name=config,proto3" json:"config,omitempty"`
}

func (x *JobTemplate) Reset() {
	*x = JobTemplate{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JobTemplate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JobTemplate) ProtoMessage() {}

func (x *JobTemplate) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JobTemplate.ProtoReflect.Descriptor instead.
func (*JobTemplate) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1beta1_resources_proto_rawDescGZIP(), []int{1}
}

func (x *JobTemplate) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *JobTemplate) GetConfig() *JobConfig {
	if x != nil {
		return x.Config
	}
	return nil
}

// Job configuration
type JobConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of input assets stored in Cloud Storage.
	Inputs []*Input `protobuf:"bytes,1,rep,name=inputs,proto3" json:"inputs,omitempty"`
	// List of `Edit atom`s. Defines the ultimate timeline of the resulting
	// file or manifest.
	EditList []*EditAtom `protobuf:"bytes,2,rep,name=edit_list,json=editList,proto3" json:"edit_list,omitempty"`
	// List of elementary streams.
	ElementaryStreams []*ElementaryStream `protobuf:"bytes,3,rep,name=elementary_streams,json=elementaryStreams,proto3" json:"elementary_streams,omitempty"`
	// List of multiplexing settings for output streams.
	MuxStreams []*MuxStream `protobuf:"bytes,4,rep,name=mux_streams,json=muxStreams,proto3" json:"mux_streams,omitempty"`
	// List of output manifests.
	Manifests []*Manifest `protobuf:"bytes,5,rep,name=manifests,proto3" json:"manifests,omitempty"`
	// Output configuration.
	Output *Output `protobuf:"bytes,6,opt,name=output,proto3" json:"output,omitempty"`
	// List of ad breaks. Specifies where to insert ad break tags in the output
	// manifests.
	AdBreaks []*AdBreak `protobuf:"bytes,7,rep,name=ad_breaks,json=adBreaks,proto3" json:"ad_breaks,omitempty"`
	// Destination on Pub/Sub.
	PubsubDestination *PubsubDestination `protobuf:"bytes,8,opt,name=pubsub_destination,json=pubsubDestination,proto3" json:"pubsub_destination,omitempty"`
	// List of output sprite sheets.
	SpriteSheets []*SpriteSheet `protobuf:"bytes,9,rep,name=sprite_sheets,json=spriteSheets,proto3" json:"sprite_sheets,omitempty"`
	// List of overlays on the output video, in descending Z-order.
	Overlays []*Overlay `protobuf:"bytes,10,rep,name=overlays,proto3" json:"overlays,omitempty"`
}

func (x *JobConfig) Reset() {
	*x = JobConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JobConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JobConfig) ProtoMessage() {}

func (x *JobConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JobConfig.ProtoReflect.Descriptor instead.
func (*JobConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1beta1_resources_proto_rawDescGZIP(), []int{2}
}

func (x *JobConfig) GetInputs() []*Input {
	if x != nil {
		return x.Inputs
	}
	return nil
}

func (x *JobConfig) GetEditList() []*EditAtom {
	if x != nil {
		return x.EditList
	}
	return nil
}

func (x *JobConfig) GetElementaryStreams() []*ElementaryStream {
	if x != nil {
		return x.ElementaryStreams
	}
	return nil
}

func (x *JobConfig) GetMuxStreams() []*MuxStream {
	if x != nil {
		return x.MuxStreams
	}
	return nil
}

func (x *JobConfig) GetManifests() []*Manifest {
	if x != nil {
		return x.Manifests
	}
	return nil
}

func (x *JobConfig) GetOutput() *Output {
	if x != nil {
		return x.Output
	}
	return nil
}

func (x *JobConfig) GetAdBreaks() []*AdBreak {
	if x != nil {
		return x.AdBreaks
	}
	return nil
}

func (x *JobConfig) GetPubsubDestination() *PubsubDestination {
	if x != nil {
		return x.PubsubDestination
	}
	return nil
}

func (x *JobConfig) GetSpriteSheets() []*SpriteSheet {
	if x != nil {
		return x.SpriteSheets
	}
	return nil
}

func (x *JobConfig) GetOverlays() []*Overlay {
	if x != nil {
		return x.Overlays
	}
	return nil
}

// Input asset.
type Input struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A unique key for this input. Must be specified when using advanced
	// mapping and edit lists.
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// URI of the media. It must be stored in Cloud Storage. Example
	// `gs://bucket/inputs/file.mp4`.
	// If empty the value will be populated from `Job.input_uri`.
	Uri string `protobuf:"bytes,2,opt,name=uri,proto3" json:"uri,omitempty"`
	// Preprocessing configurations.
	PreprocessingConfig *PreprocessingConfig `protobuf:"bytes,3,opt,name=preprocessing_config,json=preprocessingConfig,proto3" json:"preprocessing_config,omitempty"`
}

func (x *Input) Reset() {
	*x = Input{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Input) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Input) ProtoMessage() {}

func (x *Input) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Input.ProtoReflect.Descriptor instead.
func (*Input) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1beta1_resources_proto_rawDescGZIP(), []int{3}
}

func (x *Input) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *Input) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *Input) GetPreprocessingConfig() *PreprocessingConfig {
	if x != nil {
		return x.PreprocessingConfig
	}
	return nil
}

// Location of output file(s) in a Cloud Storage bucket.
type Output struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// URI for the output file(s). For example, `gs://my-bucket/outputs/`.
	// If empty the value is populated from `Job.output_uri`.
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
}

func (x *Output) Reset() {
	*x = Output{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Output) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Output) ProtoMessage() {}

func (x *Output) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Output.ProtoReflect.Descriptor instead.
func (*Output) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1beta1_resources_proto_rawDescGZIP(), []int{4}
}

func (x *Output) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

// Edit atom.
type EditAtom struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A unique key for this atom. Must be specified when using advanced
	// mapping.
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// List of `Input.key`s identifying files that should be used in this atom.
	// The listed `inputs` must have the same timeline.
	Inputs []string `protobuf:"bytes,2,rep,name=inputs,proto3" json:"inputs,omitempty"`
	// End time in seconds for the atom, relative to the input file timeline.
	// When `end_time_offset` is not specified, the `inputs` are used until
	// the end of the atom.
	EndTimeOffset *durationpb.Duration `protobuf:"bytes,3,opt,name=end_time_offset,json=endTimeOffset,proto3" json:"end_time_offset,omitempty"`
	// Start time in seconds for the atom, relative to the input file timeline.
	// The default is `0s`.
	StartTimeOffset *durationpb.Duration `protobuf:"bytes,4,opt,name=start_time_offset,json=startTimeOffset,proto3" json:"start_time_offset,omitempty"`
}

func (x *EditAtom) Reset() {
	*x = EditAtom{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EditAtom) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EditAtom) ProtoMessage() {}

func (x *EditAtom) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EditAtom.ProtoReflect.Descriptor instead.
func (*EditAtom) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1beta1_resources_proto_rawDescGZIP(), []int{5}
}

func (x *EditAtom) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *EditAtom) GetInputs() []string {
	if x != nil {
		return x.Inputs
	}
	return nil
}

func (x *EditAtom) GetEndTimeOffset() *durationpb.Duration {
	if x != nil {
		return x.EndTimeOffset
	}
	return nil
}

func (x *EditAtom) GetStartTimeOffset() *durationpb.Duration {
	if x != nil {
		return x.StartTimeOffset
	}
	return nil
}

// Ad break.
type AdBreak struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Start time in seconds for the ad break, relative to the output file
	// timeline. The default is `0s`.
	StartTimeOffset *durationpb.Duration `protobuf:"bytes,1,opt,name=start_time_offset,json=startTimeOffset,proto3" json:"start_time_offset,omitempty"`
}

func (x *AdBreak) Reset() {
	*x = AdBreak{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AdBreak) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AdBreak) ProtoMessage() {}

func (x *AdBreak) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AdBreak.ProtoReflect.Descriptor instead.
func (*AdBreak) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1beta1_resources_proto_rawDescGZIP(), []int{6}
}

func (x *AdBreak) GetStartTimeOffset() *durationpb.Duration {
	if x != nil {
		return x.StartTimeOffset
	}
	return nil
}

// Encoding of an input file such as an audio, video, or text track.
// Elementary streams must be packaged before
// mapping and sharing between different output formats.
type ElementaryStream struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A unique key for this elementary stream.
	Key string `protobuf:"bytes,4,opt,name=key,proto3" json:"key,omitempty"`
	// Encoding of an audio, video, or text track.
	//
	// Types that are assignable to ElementaryStream:
	//	*ElementaryStream_VideoStream
	//	*ElementaryStream_AudioStream
	//	*ElementaryStream_TextStream
	ElementaryStream isElementaryStream_ElementaryStream `protobuf_oneof:"elementary_stream"`
}

func (x *ElementaryStream) Reset() {
	*x = ElementaryStream{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ElementaryStream) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ElementaryStream) ProtoMessage() {}

func (x *ElementaryStream) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ElementaryStream.ProtoReflect.Descriptor instead.
func (*ElementaryStream) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1beta1_resources_proto_rawDescGZIP(), []int{7}
}

func (x *ElementaryStream) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (m *ElementaryStream) GetElementaryStream() isElementaryStream_ElementaryStream {
	if m != nil {
		return m.ElementaryStream
	}
	return nil
}

func (x *ElementaryStream) GetVideoStream() *VideoStream {
	if x, ok := x.GetElementaryStream().(*ElementaryStream_VideoStream); ok {
		return x.VideoStream
	}
	return nil
}

func (x *ElementaryStream) GetAudioStream() *AudioStream {
	if x, ok := x.GetElementaryStream().(*ElementaryStream_AudioStream); ok {
		return x.AudioStream
	}
	return nil
}

func (x *ElementaryStream) GetTextStream() *TextStream {
	if x, ok := x.GetElementaryStream().(*ElementaryStream_TextStream); ok {
		return x.TextStream
	}
	return nil
}

type isElementaryStream_ElementaryStream interface {
	isElementaryStream_ElementaryStream()
}

type ElementaryStream_VideoStream struct {
	// Encoding of a video stream.
	VideoStream *VideoStream `protobuf:"bytes,1,opt,name=video_stream,json=videoStream,proto3,oneof"`
}

type ElementaryStream_AudioStream struct {
	// Encoding of an audio stream.
	AudioStream *AudioStream `protobuf:"bytes,2,opt,name=audio_stream,json=audioStream,proto3,oneof"`
}

type ElementaryStream_TextStream struct {
	// Encoding of a text stream. For example, closed captions or subtitles.
	TextStream *TextStream `protobuf:"bytes,3,opt,name=text_stream,json=textStream,proto3,oneof"`
}

func (*ElementaryStream_VideoStream) isElementaryStream_ElementaryStream() {}

func (*ElementaryStream_AudioStream) isElementaryStream_ElementaryStream() {}

func (*ElementaryStream_TextStream) isElementaryStream_ElementaryStream() {}

// Multiplexing settings for output stream.
type MuxStream struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A unique key for this multiplexed stream. HLS media manifests will be
	// named `MuxStream.key` with the `".m3u8"` extension suffix.
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// The name of the generated file. The default is `MuxStream.key` with the
	// extension suffix corresponding to the `MuxStream.container`.
	//
	// Individual segments also have an incremental 10-digit zero-padded suffix
	// starting from 0 before the extension, such as `"mux_stream0000000123.ts"`.
	FileName string `protobuf:"bytes,2,opt,name=file_name,json=fileName,proto3" json:"file_name,omitempty"`
	// The container format. The default is `"mp4"`
	//
	// Supported container formats:
	// - 'ts'
	// - 'fmp4'- the corresponding file extension is `".m4s"`
	// - 'mp4'
	// - 'vtt'
	Container string `protobuf:"bytes,3,opt,name=container,proto3" json:"container,omitempty"`
	// List of `ElementaryStream.key`s multiplexed in this stream.
	ElementaryStreams []string `protobuf:"bytes,4,rep,name=elementary_streams,json=elementaryStreams,proto3" json:"elementary_streams,omitempty"`
	// Segment settings for `"ts"`, `"fmp4"` and `"vtt"`.
	SegmentSettings *SegmentSettings `protobuf:"bytes,5,opt,name=segment_settings,json=segmentSettings,proto3" json:"segment_settings,omitempty"`
	// Encryption settings.
	Encryption *Encryption `protobuf:"bytes,6,opt,name=encryption,proto3" json:"encryption,omitempty"`
}

func (x *MuxStream) Reset() {
	*x = MuxStream{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MuxStream) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MuxStream) ProtoMessage() {}

func (x *MuxStream) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MuxStream.ProtoReflect.Descriptor instead.
func (*MuxStream) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1beta1_resources_proto_rawDescGZIP(), []int{8}
}

func (x *MuxStream) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *MuxStream) GetFileName() string {
	if x != nil {
		return x.FileName
	}
	return ""
}

func (x *MuxStream) GetContainer() string {
	if x != nil {
		return x.Container
	}
	return ""
}

func (x *MuxStream) GetElementaryStreams() []string {
	if x != nil {
		return x.ElementaryStreams
	}
	return nil
}

func (x *MuxStream) GetSegmentSettings() *SegmentSettings {
	if x != nil {
		return x.SegmentSettings
	}
	return nil
}

func (x *MuxStream) GetEncryption() *Encryption {
	if x != nil {
		return x.Encryption
	}
	return nil
}

// Manifest configuration.
type Manifest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the generated file. The default is `"manifest"` with the
	// extension suffix corresponding to the `Manifest.type`.
	FileName string `protobuf:"bytes,1,opt,name=file_name,json=fileName,proto3" json:"file_name,omitempty"`
	// Required. Type of the manifest, can be "HLS" or "DASH".
	Type Manifest_ManifestType `protobuf:"varint,2,opt,name=type,proto3,enum=google.cloud.video.transcoder.v1beta1.Manifest_ManifestType" json:"type,omitempty"`
	// Required. List of user given `MuxStream.key`s that should appear in this manifest.
	//
	// When `Manifest.type` is `HLS`, a media manifest with name `MuxStream.key`
	// and `.m3u8` extension is generated for each element of the
	// `Manifest.mux_streams`.
	MuxStreams []string `protobuf:"bytes,3,rep,name=mux_streams,json=muxStreams,proto3" json:"mux_streams,omitempty"`
}

func (x *Manifest) Reset() {
	*x = Manifest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Manifest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Manifest) ProtoMessage() {}

func (x *Manifest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Manifest.ProtoReflect.Descriptor instead.
func (*Manifest) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1beta1_resources_proto_rawDescGZIP(), []int{9}
}

func (x *Manifest) GetFileName() string {
	if x != nil {
		return x.FileName
	}
	return ""
}

func (x *Manifest) GetType() Manifest_ManifestType {
	if x != nil {
		return x.Type
	}
	return Manifest_MANIFEST_TYPE_UNSPECIFIED
}

func (x *Manifest) GetMuxStreams() []string {
	if x != nil {
		return x.MuxStreams
	}
	return nil
}

// A Pub/Sub destination.
type PubsubDestination struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the Pub/Sub topic to publish job completion notification
	// to. For example: `projects/{project}/topics/{topic}`.
	Topic string `protobuf:"bytes,1,opt,name=topic,proto3" json:"topic,omitempty"`
}

func (x *PubsubDestination) Reset() {
	*x = PubsubDestination{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PubsubDestination) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PubsubDestination) ProtoMessage() {}

func (x *PubsubDestination) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PubsubDestination.ProtoReflect.Descriptor instead.
func (*PubsubDestination) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1beta1_resources_proto_rawDescGZIP(), []int{10}
}

func (x *PubsubDestination) GetTopic() string {
	if x != nil {
		return x.Topic
	}
	return ""
}

// Sprite sheet configuration.
type SpriteSheet struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Format type. The default is `"jpeg"`.
	//
	// Supported formats:
	// - 'jpeg'
	Format string `protobuf:"bytes,1,opt,name=format,proto3" json:"format,omitempty"`
	// Required. File name prefix for the generated sprite sheets.
	//
	// Each sprite sheet has an incremental 10-digit zero-padded suffix starting
	// from 0 before the extension, such as `"sprite_sheet0000000123.jpeg"`.
	FilePrefix string `protobuf:"bytes,2,opt,name=file_prefix,json=filePrefix,proto3" json:"file_prefix,omitempty"`
	// Required. The width of sprite in pixels. Must be an even integer.
	SpriteWidthPixels int32 `protobuf:"varint,3,opt,name=sprite_width_pixels,json=spriteWidthPixels,proto3" json:"sprite_width_pixels,omitempty"`
	// Required. The height of sprite in pixels. Must be an even integer.
	SpriteHeightPixels int32 `protobuf:"varint,4,opt,name=sprite_height_pixels,json=spriteHeightPixels,proto3" json:"sprite_height_pixels,omitempty"`
	// The maximum number of sprites per row in a sprite sheet. The default is 0,
	// which indicates no maximum limit.
	ColumnCount int32 `protobuf:"varint,5,opt,name=column_count,json=columnCount,proto3" json:"column_count,omitempty"`
	// The maximum number of rows per sprite sheet. When the sprite sheet is full,
	// a new sprite sheet is created. The default is 0, which indicates no maximum
	// limit.
	RowCount int32 `protobuf:"varint,6,opt,name=row_count,json=rowCount,proto3" json:"row_count,omitempty"`
	// Start time in seconds, relative to the output file timeline. Determines the
	// first sprite to pick. The default is `0s`.
	StartTimeOffset *durationpb.Duration `protobuf:"bytes,7,opt,name=start_time_offset,json=startTimeOffset,proto3" json:"start_time_offset,omitempty"`
	// End time in seconds, relative to the output file timeline. When
	// `end_time_offset` is not specified, the sprites are generated until the end
	// of the output file.
	EndTimeOffset *durationpb.Duration `protobuf:"bytes,8,opt,name=end_time_offset,json=endTimeOffset,proto3" json:"end_time_offset,omitempty"`
	// Specify either total number of sprites or interval to create sprites.
	//
	// Types that are assignable to ExtractionStrategy:
	//	*SpriteSheet_TotalCount
	//	*SpriteSheet_Interval
	ExtractionStrategy isSpriteSheet_ExtractionStrategy `protobuf_oneof:"extraction_strategy"`
}

func (x *SpriteSheet) Reset() {
	*x = SpriteSheet{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SpriteSheet) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SpriteSheet) ProtoMessage() {}

func (x *SpriteSheet) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SpriteSheet.ProtoReflect.Descriptor instead.
func (*SpriteSheet) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1beta1_resources_proto_rawDescGZIP(), []int{11}
}

func (x *SpriteSheet) GetFormat() string {
	if x != nil {
		return x.Format
	}
	return ""
}

func (x *SpriteSheet) GetFilePrefix() string {
	if x != nil {
		return x.FilePrefix
	}
	return ""
}

func (x *SpriteSheet) GetSpriteWidthPixels() int32 {
	if x != nil {
		return x.SpriteWidthPixels
	}
	return 0
}

func (x *SpriteSheet) GetSpriteHeightPixels() int32 {
	if x != nil {
		return x.SpriteHeightPixels
	}
	return 0
}

func (x *SpriteSheet) GetColumnCount() int32 {
	if x != nil {
		return x.ColumnCount
	}
	return 0
}

func (x *SpriteSheet) GetRowCount() int32 {
	if x != nil {
		return x.RowCount
	}
	return 0
}

func (x *SpriteSheet) GetStartTimeOffset() *durationpb.Duration {
	if x != nil {
		return x.StartTimeOffset
	}
	return nil
}

func (x *SpriteSheet) GetEndTimeOffset() *durationpb.Duration {
	if x != nil {
		return x.EndTimeOffset
	}
	return nil
}

func (m *SpriteSheet) GetExtractionStrategy() isSpriteSheet_ExtractionStrategy {
	if m != nil {
		return m.ExtractionStrategy
	}
	return nil
}

func (x *SpriteSheet) GetTotalCount() int32 {
	if x, ok := x.GetExtractionStrategy().(*SpriteSheet_TotalCount); ok {
		return x.TotalCount
	}
	return 0
}

func (x *SpriteSheet) GetInterval() *durationpb.Duration {
	if x, ok := x.GetExtractionStrategy().(*SpriteSheet_Interval); ok {
		return x.Interval
	}
	return nil
}

type isSpriteSheet_ExtractionStrategy interface {
	isSpriteSheet_ExtractionStrategy()
}

type SpriteSheet_TotalCount struct {
	// Total number of sprites. Create the specified number of sprites
	// distributed evenly across the timeline of the output media. The default
	// is 100.
	TotalCount int32 `protobuf:"varint,9,opt,name=total_count,json=totalCount,proto3,oneof"`
}

type SpriteSheet_Interval struct {
	// Starting from `0s`, create sprites at regular intervals. Specify the
	// interval value in seconds.
	Interval *durationpb.Duration `protobuf:"bytes,10,opt,name=interval,proto3,oneof"`
}

func (*SpriteSheet_TotalCount) isSpriteSheet_ExtractionStrategy() {}

func (*SpriteSheet_Interval) isSpriteSheet_ExtractionStrategy() {}

// Overlay configuration.
type Overlay struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Image overlay.
	Image *Overlay_Image `protobuf:"bytes,1,opt,name=image,proto3" json:"image,omitempty"`
	// List of Animations. The list should be chronological, without any time
	// overlap.
	Animations []*Overlay_Animation `protobuf:"bytes,2,rep,name=animations,proto3" json:"animations,omitempty"`
}

func (x *Overlay) Reset() {
	*x = Overlay{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Overlay) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Overlay) ProtoMessage() {}

func (x *Overlay) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Overlay.ProtoReflect.Descriptor instead.
func (*Overlay) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1beta1_resources_proto_rawDescGZIP(), []int{12}
}

func (x *Overlay) GetImage() *Overlay_Image {
	if x != nil {
		return x.Image
	}
	return nil
}

func (x *Overlay) GetAnimations() []*Overlay_Animation {
	if x != nil {
		return x.Animations
	}
	return nil
}

// Preprocessing configurations.
type PreprocessingConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Color preprocessing configuration.
	Color *PreprocessingConfig_Color `protobuf:"bytes,1,opt,name=color,proto3" json:"color,omitempty"`
	// Denoise preprocessing configuration.
	Denoise *PreprocessingConfig_Denoise `protobuf:"bytes,2,opt,name=denoise,proto3" json:"denoise,omitempty"`
	// Deblock preprocessing configuration.
	Deblock *PreprocessingConfig_Deblock `protobuf:"bytes,3,opt,name=deblock,proto3" json:"deblock,omitempty"`
	// Audio preprocessing configuration.
	Audio *PreprocessingConfig_Audio `protobuf:"bytes,4,opt,name=audio,proto3" json:"audio,omitempty"`
}

func (x *PreprocessingConfig) Reset() {
	*x = PreprocessingConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PreprocessingConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PreprocessingConfig) ProtoMessage() {}

func (x *PreprocessingConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PreprocessingConfig.ProtoReflect.Descriptor instead.
func (*PreprocessingConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1beta1_resources_proto_rawDescGZIP(), []int{13}
}

func (x *PreprocessingConfig) GetColor() *PreprocessingConfig_Color {
	if x != nil {
		return x.Color
	}
	return nil
}

func (x *PreprocessingConfig) GetDenoise() *PreprocessingConfig_Denoise {
	if x != nil {
		return x.Denoise
	}
	return nil
}

func (x *PreprocessingConfig) GetDeblock() *PreprocessingConfig_Deblock {
	if x != nil {
		return x.Deblock
	}
	return nil
}

func (x *PreprocessingConfig) GetAudio() *PreprocessingConfig_Audio {
	if x != nil {
		return x.Audio
	}
	return nil
}

// Video stream resource.
type VideoStream struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Codec type. The default is `"h264"`.
	//
	// Supported codecs:
	// - 'h264'
	// - 'h265'
	// - 'vp9'
	Codec string `protobuf:"bytes,1,opt,name=codec,proto3" json:"codec,omitempty"`
	// Enforce specified codec profile. The default is `"high"`.
	//
	// Supported codec profiles:
	// - 'baseline'
	// - 'main'
	// - 'high'
	Profile string `protobuf:"bytes,2,opt,name=profile,proto3" json:"profile,omitempty"`
	// Enforce specified codec tune.
	Tune string `protobuf:"bytes,3,opt,name=tune,proto3" json:"tune,omitempty"`
	// Enforce specified codec preset. The default is `"veryfast"`.
	Preset string `protobuf:"bytes,4,opt,name=preset,proto3" json:"preset,omitempty"`
	// The height of the video in pixels. Must be an even integer.
	// When not specified, the height is adjusted to match the specified width and
	// input aspect ratio. If both are omitted, the input height is used.
	HeightPixels int32 `protobuf:"varint,5,opt,name=height_pixels,json=heightPixels,proto3" json:"height_pixels,omitempty"`
	// The width of the video in pixels. Must be an even integer.
	// When not specified, the width is adjusted to match the specified height and
	// input aspect ratio. If both are omitted, the input width is used.
	WidthPixels int32 `protobuf:"varint,6,opt,name=width_pixels,json=widthPixels,proto3" json:"width_pixels,omitempty"`
	// Pixel format to use. The default is `"yuv420p"`.
	//
	// Supported pixel formats:
	// - 'yuv420p' pixel format.
	// - 'yuv422p' pixel format.
	// - 'yuv444p' pixel format.
	// - 'yuv420p10' 10-bit HDR pixel format.
	// - 'yuv422p10' 10-bit HDR pixel format.
	// - 'yuv444p10' 10-bit HDR pixel format.
	// - 'yuv420p12' 12-bit HDR pixel format.
	// - 'yuv422p12' 12-bit HDR pixel format.
	// - 'yuv444p12' 12-bit HDR pixel format.
	PixelFormat string `protobuf:"bytes,7,opt,name=pixel_format,json=pixelFormat,proto3" json:"pixel_format,omitempty"`
	// Required. The video bitrate in bits per second. Must be between 1 and 1,000,000,000.
	BitrateBps int32 `protobuf:"varint,8,opt,name=bitrate_bps,json=bitrateBps,proto3" json:"bitrate_bps,omitempty"`
	// Specify the `rate_control_mode`. The default is `"vbr"`.
	//
	// Supported rate control modes:
	// - 'vbr' - variable bitrate
	// - 'crf' - constant rate factor
	RateControlMode string `protobuf:"bytes,9,opt,name=rate_control_mode,json=rateControlMode,proto3" json:"rate_control_mode,omitempty"`
	// Use two-pass encoding strategy to achieve better video quality.
	// `VideoStream.rate_control_mode` must be `"vbr"`. The default is `false`.
	EnableTwoPass bool `protobuf:"varint,10,opt,name=enable_two_pass,json=enableTwoPass,proto3" json:"enable_two_pass,omitempty"`
	// Target CRF level. Must be between 10 and 36, where 10 is the highest
	// quality and 36 is the most efficient compression. The default is 21.
	CrfLevel int32 `protobuf:"varint,11,opt,name=crf_level,json=crfLevel,proto3" json:"crf_level,omitempty"`
	// Size of the Video Buffering Verifier (VBV) buffer in bits. Must be greater
	// than zero. The default is equal to `VideoStream.bitrate_bps`.
	VbvSizeBits int32 `protobuf:"varint,12,opt,name=vbv_size_bits,json=vbvSizeBits,proto3" json:"vbv_size_bits,omitempty"`
	// Initial fullness of the Video Buffering Verifier (VBV) buffer in bits. Must
	// be greater than zero. The default is equal to 90% of
	// `VideoStream.vbv_size_bits`.
	VbvFullnessBits int32 `protobuf:"varint,13,opt,name=vbv_fullness_bits,json=vbvFullnessBits,proto3" json:"vbv_fullness_bits,omitempty"`
	// Specifies whether an open Group of Pictures (GOP) structure should be
	// allowed or not. The default is `false`.
	AllowOpenGop bool `protobuf:"varint,14,opt,name=allow_open_gop,json=allowOpenGop,proto3" json:"allow_open_gop,omitempty"`
	// GOP mode can be either by frame count or duration.
	//
	// Types that are assignable to GopMode:
	//	*VideoStream_GopFrameCount
	//	*VideoStream_GopDuration
	GopMode isVideoStream_GopMode `protobuf_oneof:"gop_mode"`
	// The entropy coder to use. The default is `"cabac"`.
	//
	// Supported entropy coders:
	// - 'cavlc'
	// - 'cabac'
	EntropyCoder string `protobuf:"bytes,17,opt,name=entropy_coder,json=entropyCoder,proto3" json:"entropy_coder,omitempty"`
	// Allow B-pyramid for reference frame selection. This may not be supported
	// on all decoders. The default is `false`.
	BPyramid bool `protobuf:"varint,18,opt,name=b_pyramid,json=bPyramid,proto3" json:"b_pyramid,omitempty"`
	// The number of consecutive B-frames. Must be greater than or equal to zero.
	// Must be less than `VideoStream.gop_frame_count` if set. The default is 0.
	BFrameCount int32 `protobuf:"varint,19,opt,name=b_frame_count,json=bFrameCount,proto3" json:"b_frame_count,omitempty"`
	// Required. The target video frame rate in frames per second (FPS). Must be less than
	// or equal to 120. Will default to the input frame rate if larger than the
	// input frame rate. The API will generate an output FPS that is divisible by
	// the input FPS, and smaller or equal to the target FPS.
	//
	// The following table shows the computed video FPS given the target FPS (in
	// parenthesis) and input FPS (in the first column):
	//
	// |        | (30)   | (60)   | (25) | (50) |
	// |--------|--------|--------|------|------|
	// | 240    | Fail   | Fail   | Fail | Fail |
	// | 120    | 30     | 60     | 20   | 30   |
	// | 100    | 25     | 50     | 20   | 30   |
	// | 50     | 25     | 50     | 20   | 30   |
	// | 60     | 30     | 60     | 20   | 30   |
	// | 59.94  | 29.97  | 59.94  | 20   | 30   |
	// | 48     | 24     | 48     | 20   | 30   |
	// | 30     | 30     | 30     | 20   | 30   |
	// | 25     | 25     | 25     | 20   | 30   |
	// | 24     | 24     | 24     | 20   | 30   |
	// | 23.976 | 23.976 | 23.976 | 20   | 30   |
	// | 15     | 15     | 15     | 20   | 30   |
	// | 12     | 12     | 12     | 20   | 30   |
	// | 10     | 10     | 10     | 20   | 30   |
	FrameRate float64 `protobuf:"fixed64,20,opt,name=frame_rate,json=frameRate,proto3" json:"frame_rate,omitempty"`
	// Specify the intensity of the adaptive quantizer (AQ). Must be between 0 and
	// 1, where 0 disables the quantizer and 1 maximizes the quantizer. A
	// higher value equals a lower bitrate but smoother image. The default is 0.
	AqStrength float64 `protobuf:"fixed64,21,opt,name=aq_strength,json=aqStrength,proto3" json:"aq_strength,omitempty"`
}

func (x *VideoStream) Reset() {
	*x = VideoStream{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VideoStream) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VideoStream) ProtoMessage() {}

func (x *VideoStream) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VideoStream.ProtoReflect.Descriptor instead.
func (*VideoStream) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1beta1_resources_proto_rawDescGZIP(), []int{14}
}

func (x *VideoStream) GetCodec() string {
	if x != nil {
		return x.Codec
	}
	return ""
}

func (x *VideoStream) GetProfile() string {
	if x != nil {
		return x.Profile
	}
	return ""
}

func (x *VideoStream) GetTune() string {
	if x != nil {
		return x.Tune
	}
	return ""
}

func (x *VideoStream) GetPreset() string {
	if x != nil {
		return x.Preset
	}
	return ""
}

func (x *VideoStream) GetHeightPixels() int32 {
	if x != nil {
		return x.HeightPixels
	}
	return 0
}

func (x *VideoStream) GetWidthPixels() int32 {
	if x != nil {
		return x.WidthPixels
	}
	return 0
}

func (x *VideoStream) GetPixelFormat() string {
	if x != nil {
		return x.PixelFormat
	}
	return ""
}

func (x *VideoStream) GetBitrateBps() int32 {
	if x != nil {
		return x.BitrateBps
	}
	return 0
}

func (x *VideoStream) GetRateControlMode() string {
	if x != nil {
		return x.RateControlMode
	}
	return ""
}

func (x *VideoStream) GetEnableTwoPass() bool {
	if x != nil {
		return x.EnableTwoPass
	}
	return false
}

func (x *VideoStream) GetCrfLevel() int32 {
	if x != nil {
		return x.CrfLevel
	}
	return 0
}

func (x *VideoStream) GetVbvSizeBits() int32 {
	if x != nil {
		return x.VbvSizeBits
	}
	return 0
}

func (x *VideoStream) GetVbvFullnessBits() int32 {
	if x != nil {
		return x.VbvFullnessBits
	}
	return 0
}

func (x *VideoStream) GetAllowOpenGop() bool {
	if x != nil {
		return x.AllowOpenGop
	}
	return false
}

func (m *VideoStream) GetGopMode() isVideoStream_GopMode {
	if m != nil {
		return m.GopMode
	}
	return nil
}

func (x *VideoStream) GetGopFrameCount() int32 {
	if x, ok := x.GetGopMode().(*VideoStream_GopFrameCount); ok {
		return x.GopFrameCount
	}
	return 0
}

func (x *VideoStream) GetGopDuration() *durationpb.Duration {
	if x, ok := x.GetGopMode().(*VideoStream_GopDuration); ok {
		return x.GopDuration
	}
	return nil
}

func (x *VideoStream) GetEntropyCoder() string {
	if x != nil {
		return x.EntropyCoder
	}
	return ""
}

func (x *VideoStream) GetBPyramid() bool {
	if x != nil {
		return x.BPyramid
	}
	return false
}

func (x *VideoStream) GetBFrameCount() int32 {
	if x != nil {
		return x.BFrameCount
	}
	return 0
}

func (x *VideoStream) GetFrameRate() float64 {
	if x != nil {
		return x.FrameRate
	}
	return 0
}

func (x *VideoStream) GetAqStrength() float64 {
	if x != nil {
		return x.AqStrength
	}
	return 0
}

type isVideoStream_GopMode interface {
	isVideoStream_GopMode()
}

type VideoStream_GopFrameCount struct {
	// Select the GOP size based on the specified frame count. Must be greater
	// than zero.
	GopFrameCount int32 `protobuf:"varint,15,opt,name=gop_frame_count,json=gopFrameCount,proto3,oneof"`
}

type VideoStream_GopDuration struct {
	// Select the GOP size based on the specified duration. The default is
	// `"3s"`.
	GopDuration *durationpb.Duration `protobuf:"bytes,16,opt,name=gop_duration,json=gopDuration,proto3,oneof"`
}

func (*VideoStream_GopFrameCount) isVideoStream_GopMode() {}

func (*VideoStream_GopDuration) isVideoStream_GopMode() {}

// Audio stream resource.
type AudioStream struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The codec for this audio stream. The default is `"aac"`.
	//
	// Supported audio codecs:
	// - 'aac'
	// - 'aac-he'
	// - 'aac-he-v2'
	// - 'mp3'
	// - 'ac3'
	// - 'eac3'
	Codec string `protobuf:"bytes,1,opt,name=codec,proto3" json:"codec,omitempty"`
	// Required. Audio bitrate in bits per second. Must be between 1 and 10,000,000.
	BitrateBps int32 `protobuf:"varint,2,opt,name=bitrate_bps,json=bitrateBps,proto3" json:"bitrate_bps,omitempty"`
	// Number of audio channels. Must be between 1 and 6. The default is 2.
	ChannelCount int32 `protobuf:"varint,3,opt,name=channel_count,json=channelCount,proto3" json:"channel_count,omitempty"`
	// A list of channel names specifying layout of the audio channels.
	// This only affects the metadata embedded in the container headers, if
	// supported by the specified format. The default is `["fl", "fr"]`.
	//
	// Supported channel names:
	// - 'fl' - Front left channel
	// - 'fr' - Front right channel
	// - 'sl' - Side left channel
	// - 'sr' - Side right channel
	// - 'fc' - Front center channel
	// - 'lfe' - Low frequency
	ChannelLayout []string `protobuf:"bytes,4,rep,name=channel_layout,json=channelLayout,proto3" json:"channel_layout,omitempty"`
	// The mapping for the `Job.edit_list` atoms with audio `EditAtom.inputs`.
	Mapping []*AudioStream_AudioAtom `protobuf:"bytes,5,rep,name=mapping,proto3" json:"mapping,omitempty"`
	// The audio sample rate in Hertz. The default is 48000 Hertz.
	SampleRateHertz int32 `protobuf:"varint,6,opt,name=sample_rate_hertz,json=sampleRateHertz,proto3" json:"sample_rate_hertz,omitempty"`
}

func (x *AudioStream) Reset() {
	*x = AudioStream{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AudioStream) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AudioStream) ProtoMessage() {}

func (x *AudioStream) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AudioStream.ProtoReflect.Descriptor instead.
func (*AudioStream) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1beta1_resources_proto_rawDescGZIP(), []int{15}
}

func (x *AudioStream) GetCodec() string {
	if x != nil {
		return x.Codec
	}
	return ""
}

func (x *AudioStream) GetBitrateBps() int32 {
	if x != nil {
		return x.BitrateBps
	}
	return 0
}

func (x *AudioStream) GetChannelCount() int32 {
	if x != nil {
		return x.ChannelCount
	}
	return 0
}

func (x *AudioStream) GetChannelLayout() []string {
	if x != nil {
		return x.ChannelLayout
	}
	return nil
}

func (x *AudioStream) GetMapping() []*AudioStream_AudioAtom {
	if x != nil {
		return x.Mapping
	}
	return nil
}

func (x *AudioStream) GetSampleRateHertz() int32 {
	if x != nil {
		return x.SampleRateHertz
	}
	return 0
}

// Encoding of a text stream. For example, closed captions or subtitles.
type TextStream struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The codec for this text stream. The default is `"webvtt"`.
	//
	// Supported text codecs:
	// - 'srt'
	// - 'ttml'
	// - 'cea608'
	// - 'cea708'
	// - 'webvtt'
	Codec string `protobuf:"bytes,1,opt,name=codec,proto3" json:"codec,omitempty"`
	// Required. The BCP-47 language code, such as `"en-US"` or `"sr-Latn"`. For more
	// information, see
	// https://www.unicode.org/reports/tr35/#Unicode_locale_identifier.
	LanguageCode string `protobuf:"bytes,2,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// The mapping for the `Job.edit_list` atoms with text `EditAtom.inputs`.
	Mapping []*TextStream_TextAtom `protobuf:"bytes,3,rep,name=mapping,proto3" json:"mapping,omitempty"`
}

func (x *TextStream) Reset() {
	*x = TextStream{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TextStream) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TextStream) ProtoMessage() {}

func (x *TextStream) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TextStream.ProtoReflect.Descriptor instead.
func (*TextStream) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1beta1_resources_proto_rawDescGZIP(), []int{16}
}

func (x *TextStream) GetCodec() string {
	if x != nil {
		return x.Codec
	}
	return ""
}

func (x *TextStream) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *TextStream) GetMapping() []*TextStream_TextAtom {
	if x != nil {
		return x.Mapping
	}
	return nil
}

// Segment settings for `"ts"`, `"fmp4"` and `"vtt"`.
type SegmentSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Duration of the segments in seconds. The default is `"6.0s"`.
	SegmentDuration *durationpb.Duration `protobuf:"bytes,1,opt,name=segment_duration,json=segmentDuration,proto3" json:"segment_duration,omitempty"`
	// Required. Create an individual segment file. The default is `false`.
	IndividualSegments bool `protobuf:"varint,3,opt,name=individual_segments,json=individualSegments,proto3" json:"individual_segments,omitempty"`
}

func (x *SegmentSettings) Reset() {
	*x = SegmentSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SegmentSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SegmentSettings) ProtoMessage() {}

func (x *SegmentSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SegmentSettings.ProtoReflect.Descriptor instead.
func (*SegmentSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1beta1_resources_proto_rawDescGZIP(), []int{17}
}

func (x *SegmentSettings) GetSegmentDuration() *durationpb.Duration {
	if x != nil {
		return x.SegmentDuration
	}
	return nil
}

func (x *SegmentSettings) GetIndividualSegments() bool {
	if x != nil {
		return x.IndividualSegments
	}
	return false
}

// Encryption settings.
type Encryption struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. 128 bit encryption key represented as lowercase hexadecimal digits.
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// Required. 128 bit Initialization Vector (IV) represented as lowercase hexadecimal
	// digits.
	Iv string `protobuf:"bytes,2,opt,name=iv,proto3" json:"iv,omitempty"`
	// Encryption mode can be either `aes` or `cenc`.
	//
	// Types that are assignable to EncryptionMode:
	//	*Encryption_Aes_128
	//	*Encryption_SampleAes
	//	*Encryption_MpegCenc
	EncryptionMode isEncryption_EncryptionMode `protobuf_oneof:"encryption_mode"`
}

func (x *Encryption) Reset() {
	*x = Encryption{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Encryption) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Encryption) ProtoMessage() {}

func (x *Encryption) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Encryption.ProtoReflect.Descriptor instead.
func (*Encryption) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1beta1_resources_proto_rawDescGZIP(), []int{18}
}

func (x *Encryption) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *Encryption) GetIv() string {
	if x != nil {
		return x.Iv
	}
	return ""
}

func (m *Encryption) GetEncryptionMode() isEncryption_EncryptionMode {
	if m != nil {
		return m.EncryptionMode
	}
	return nil
}

func (x *Encryption) GetAes_128() *Encryption_Aes128Encryption {
	if x, ok := x.GetEncryptionMode().(*Encryption_Aes_128); ok {
		return x.Aes_128
	}
	return nil
}

func (x *Encryption) GetSampleAes() *Encryption_SampleAesEncryption {
	if x, ok := x.GetEncryptionMode().(*Encryption_SampleAes); ok {
		return x.SampleAes
	}
	return nil
}

func (x *Encryption) GetMpegCenc() *Encryption_MpegCommonEncryption {
	if x, ok := x.GetEncryptionMode().(*Encryption_MpegCenc); ok {
		return x.MpegCenc
	}
	return nil
}

type isEncryption_EncryptionMode interface {
	isEncryption_EncryptionMode()
}

type Encryption_Aes_128 struct {
	// Configuration for AES-128 encryption.
	Aes_128 *Encryption_Aes128Encryption `protobuf:"bytes,3,opt,name=aes_128,json=aes128,proto3,oneof"`
}

type Encryption_SampleAes struct {
	// Configuration for SAMPLE-AES encryption.
	SampleAes *Encryption_SampleAesEncryption `protobuf:"bytes,4,opt,name=sample_aes,json=sampleAes,proto3,oneof"`
}

type Encryption_MpegCenc struct {
	// Configuration for MPEG Common Encryption (MPEG-CENC).
	MpegCenc *Encryption_MpegCommonEncryption `protobuf:"bytes,5,opt,name=mpeg_cenc,json=mpegCenc,proto3,oneof"`
}

func (*Encryption_Aes_128) isEncryption_EncryptionMode() {}

func (*Encryption_SampleAes) isEncryption_EncryptionMode() {}

func (*Encryption_MpegCenc) isEncryption_EncryptionMode() {}

// Estimated fractional progress for each step, from `0` to `1`.
type Progress struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Estimated fractional progress for `analyzing` step.
	Analyzed float64 `protobuf:"fixed64,1,opt,name=analyzed,proto3" json:"analyzed,omitempty"`
	// Estimated fractional progress for `encoding` step.
	Encoded float64 `protobuf:"fixed64,2,opt,name=encoded,proto3" json:"encoded,omitempty"`
	// Estimated fractional progress for `uploading` step.
	Uploaded float64 `protobuf:"fixed64,3,opt,name=uploaded,proto3" json:"uploaded,omitempty"`
	// Estimated fractional progress for `notifying` step.
	Notified float64 `protobuf:"fixed64,4,opt,name=notified,proto3" json:"notified,omitempty"`
}

func (x *Progress) Reset() {
	*x = Progress{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Progress) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Progress) ProtoMessage() {}

func (x *Progress) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Progress.ProtoReflect.Descriptor instead.
func (*Progress) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1beta1_resources_proto_rawDescGZIP(), []int{19}
}

func (x *Progress) GetAnalyzed() float64 {
	if x != nil {
		return x.Analyzed
	}
	return 0
}

func (x *Progress) GetEncoded() float64 {
	if x != nil {
		return x.Encoded
	}
	return 0
}

func (x *Progress) GetUploaded() float64 {
	if x != nil {
		return x.Uploaded
	}
	return 0
}

func (x *Progress) GetNotified() float64 {
	if x != nil {
		return x.Notified
	}
	return 0
}

// Additional information about the reasons for the failure.
type FailureDetail struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A description of the failure.
	Description string `protobuf:"bytes,1,opt,name=description,proto3" json:"description,omitempty"`
}

func (x *FailureDetail) Reset() {
	*x = FailureDetail{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FailureDetail) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FailureDetail) ProtoMessage() {}

func (x *FailureDetail) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FailureDetail.ProtoReflect.Descriptor instead.
func (*FailureDetail) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1beta1_resources_proto_rawDescGZIP(), []int{20}
}

func (x *FailureDetail) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

// The origin URI.
type Job_OriginUri struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// HLS master manifest URI. If multiple HLS master manifests are created
	// only first one is listed.
	Hls string `protobuf:"bytes,1,opt,name=hls,proto3" json:"hls,omitempty"`
	// Dash manifest URI. If multiple Dash manifests are created, only the first
	// one is listed.
	Dash string `protobuf:"bytes,2,opt,name=dash,proto3" json:"dash,omitempty"`
}

func (x *Job_OriginUri) Reset() {
	*x = Job_OriginUri{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Job_OriginUri) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Job_OriginUri) ProtoMessage() {}

func (x *Job_OriginUri) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Job_OriginUri.ProtoReflect.Descriptor instead.
func (*Job_OriginUri) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1beta1_resources_proto_rawDescGZIP(), []int{0, 0}
}

func (x *Job_OriginUri) GetHls() string {
	if x != nil {
		return x.Hls
	}
	return ""
}

func (x *Job_OriginUri) GetDash() string {
	if x != nil {
		return x.Dash
	}
	return ""
}

// 2D normalized coordinates. Default: `{0.0, 0.0}`
type Overlay_NormalizedCoordinate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Normalized x coordinate.
	X float64 `protobuf:"fixed64,1,opt,name=x,proto3" json:"x,omitempty"`
	// Normalized y coordinate.
	Y float64 `protobuf:"fixed64,2,opt,name=y,proto3" json:"y,omitempty"`
}

func (x *Overlay_NormalizedCoordinate) Reset() {
	*x = Overlay_NormalizedCoordinate{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Overlay_NormalizedCoordinate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Overlay_NormalizedCoordinate) ProtoMessage() {}

func (x *Overlay_NormalizedCoordinate) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Overlay_NormalizedCoordinate.ProtoReflect.Descriptor instead.
func (*Overlay_NormalizedCoordinate) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1beta1_resources_proto_rawDescGZIP(), []int{12, 0}
}

func (x *Overlay_NormalizedCoordinate) GetX() float64 {
	if x != nil {
		return x.X
	}
	return 0
}

func (x *Overlay_NormalizedCoordinate) GetY() float64 {
	if x != nil {
		return x.Y
	}
	return 0
}

// Overlaid jpeg image.
type Overlay_Image struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. URI of the image in Cloud Storage. For example,
	// `gs://bucket/inputs/image.jpeg`.
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
	// Normalized image resolution, based on output video resolution. Valid
	// values: `0.0`–`1.0`. To respect the original image aspect ratio, set
	// either `x` or `y` to `0.0`. To use the original image resolution, set
	// both `x` and `y` to `0.0`.
	Resolution *Overlay_NormalizedCoordinate `protobuf:"bytes,2,opt,name=resolution,proto3" json:"resolution,omitempty"`
	// Target image opacity. Valid values: `1` (solid, default),
	// `0` (transparent).
	Alpha float64 `protobuf:"fixed64,3,opt,name=alpha,proto3" json:"alpha,omitempty"`
}

func (x *Overlay_Image) Reset() {
	*x = Overlay_Image{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Overlay_Image) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Overlay_Image) ProtoMessage() {}

func (x *Overlay_Image) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Overlay_Image.ProtoReflect.Descriptor instead.
func (*Overlay_Image) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1beta1_resources_proto_rawDescGZIP(), []int{12, 1}
}

func (x *Overlay_Image) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *Overlay_Image) GetResolution() *Overlay_NormalizedCoordinate {
	if x != nil {
		return x.Resolution
	}
	return nil
}

func (x *Overlay_Image) GetAlpha() float64 {
	if x != nil {
		return x.Alpha
	}
	return 0
}

// Display static overlay object.
type Overlay_AnimationStatic struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Normalized coordinates based on output video resolution. Valid
	// values: `0.0`–`1.0`. `xy` is the upper-left coordinate of the overlay
	// object.
	Xy *Overlay_NormalizedCoordinate `protobuf:"bytes,1,opt,name=xy,proto3" json:"xy,omitempty"`
	// The time to start displaying the overlay object, in seconds. Default: 0
	StartTimeOffset *durationpb.Duration `protobuf:"bytes,2,opt,name=start_time_offset,json=startTimeOffset,proto3" json:"start_time_offset,omitempty"`
}

func (x *Overlay_AnimationStatic) Reset() {
	*x = Overlay_AnimationStatic{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Overlay_AnimationStatic) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Overlay_AnimationStatic) ProtoMessage() {}

func (x *Overlay_AnimationStatic) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Overlay_AnimationStatic.ProtoReflect.Descriptor instead.
func (*Overlay_AnimationStatic) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1beta1_resources_proto_rawDescGZIP(), []int{12, 2}
}

func (x *Overlay_AnimationStatic) GetXy() *Overlay_NormalizedCoordinate {
	if x != nil {
		return x.Xy
	}
	return nil
}

func (x *Overlay_AnimationStatic) GetStartTimeOffset() *durationpb.Duration {
	if x != nil {
		return x.StartTimeOffset
	}
	return nil
}

// Display overlay object with fade animation.
type Overlay_AnimationFade struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Type of fade animation: `FADE_IN` or `FADE_OUT`.
	FadeType Overlay_FadeType `protobuf:"varint,1,opt,name=fade_type,json=fadeType,proto3,enum=google.cloud.video.transcoder.v1beta1.Overlay_FadeType" json:"fade_type,omitempty"`
	// Normalized coordinates based on output video resolution. Valid
	// values: `0.0`–`1.0`. `xy` is the upper-left coordinate of the overlay
	// object.
	Xy *Overlay_NormalizedCoordinate `protobuf:"bytes,2,opt,name=xy,proto3" json:"xy,omitempty"`
	// The time to start the fade animation, in seconds. Default: 0
	StartTimeOffset *durationpb.Duration `protobuf:"bytes,3,opt,name=start_time_offset,json=startTimeOffset,proto3" json:"start_time_offset,omitempty"`
	// The time to end the fade animation, in seconds. Default:
	// `start_time_offset` + 1s
	EndTimeOffset *durationpb.Duration `protobuf:"bytes,4,opt,name=end_time_offset,json=endTimeOffset,proto3" json:"end_time_offset,omitempty"`
}

func (x *Overlay_AnimationFade) Reset() {
	*x = Overlay_AnimationFade{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Overlay_AnimationFade) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Overlay_AnimationFade) ProtoMessage() {}

func (x *Overlay_AnimationFade) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Overlay_AnimationFade.ProtoReflect.Descriptor instead.
func (*Overlay_AnimationFade) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1beta1_resources_proto_rawDescGZIP(), []int{12, 3}
}

func (x *Overlay_AnimationFade) GetFadeType() Overlay_FadeType {
	if x != nil {
		return x.FadeType
	}
	return Overlay_FADE_TYPE_UNSPECIFIED
}

func (x *Overlay_AnimationFade) GetXy() *Overlay_NormalizedCoordinate {
	if x != nil {
		return x.Xy
	}
	return nil
}

func (x *Overlay_AnimationFade) GetStartTimeOffset() *durationpb.Duration {
	if x != nil {
		return x.StartTimeOffset
	}
	return nil
}

func (x *Overlay_AnimationFade) GetEndTimeOffset() *durationpb.Duration {
	if x != nil {
		return x.EndTimeOffset
	}
	return nil
}

// End previous overlay animation from the video. Without AnimationEnd, the
// overlay object will keep the state of previous animation until the end of
// the video.
type Overlay_AnimationEnd struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The time to end overlay object, in seconds. Default: 0
	StartTimeOffset *durationpb.Duration `protobuf:"bytes,1,opt,name=start_time_offset,json=startTimeOffset,proto3" json:"start_time_offset,omitempty"`
}

func (x *Overlay_AnimationEnd) Reset() {
	*x = Overlay_AnimationEnd{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Overlay_AnimationEnd) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Overlay_AnimationEnd) ProtoMessage() {}

func (x *Overlay_AnimationEnd) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Overlay_AnimationEnd.ProtoReflect.Descriptor instead.
func (*Overlay_AnimationEnd) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1beta1_resources_proto_rawDescGZIP(), []int{12, 4}
}

func (x *Overlay_AnimationEnd) GetStartTimeOffset() *durationpb.Duration {
	if x != nil {
		return x.StartTimeOffset
	}
	return nil
}

// Animation types.
type Overlay_Animation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Animations can be static or fade, or they can end the previous animation.
	//
	// Types that are assignable to AnimationType:
	//	*Overlay_Animation_AnimationStatic
	//	*Overlay_Animation_AnimationFade
	//	*Overlay_Animation_AnimationEnd
	AnimationType isOverlay_Animation_AnimationType `protobuf_oneof:"animation_type"`
}

func (x *Overlay_Animation) Reset() {
	*x = Overlay_Animation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Overlay_Animation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Overlay_Animation) ProtoMessage() {}

func (x *Overlay_Animation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Overlay_Animation.ProtoReflect.Descriptor instead.
func (*Overlay_Animation) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1beta1_resources_proto_rawDescGZIP(), []int{12, 5}
}

func (m *Overlay_Animation) GetAnimationType() isOverlay_Animation_AnimationType {
	if m != nil {
		return m.AnimationType
	}
	return nil
}

func (x *Overlay_Animation) GetAnimationStatic() *Overlay_AnimationStatic {
	if x, ok := x.GetAnimationType().(*Overlay_Animation_AnimationStatic); ok {
		return x.AnimationStatic
	}
	return nil
}

func (x *Overlay_Animation) GetAnimationFade() *Overlay_AnimationFade {
	if x, ok := x.GetAnimationType().(*Overlay_Animation_AnimationFade); ok {
		return x.AnimationFade
	}
	return nil
}

func (x *Overlay_Animation) GetAnimationEnd() *Overlay_AnimationEnd {
	if x, ok := x.GetAnimationType().(*Overlay_Animation_AnimationEnd); ok {
		return x.AnimationEnd
	}
	return nil
}

type isOverlay_Animation_AnimationType interface {
	isOverlay_Animation_AnimationType()
}

type Overlay_Animation_AnimationStatic struct {
	// Display static overlay object.
	AnimationStatic *Overlay_AnimationStatic `protobuf:"bytes,1,opt,name=animation_static,json=animationStatic,proto3,oneof"`
}

type Overlay_Animation_AnimationFade struct {
	// Display overlay object with fade animation.
	AnimationFade *Overlay_AnimationFade `protobuf:"bytes,2,opt,name=animation_fade,json=animationFade,proto3,oneof"`
}

type Overlay_Animation_AnimationEnd struct {
	// End previous animation.
	AnimationEnd *Overlay_AnimationEnd `protobuf:"bytes,3,opt,name=animation_end,json=animationEnd,proto3,oneof"`
}

func (*Overlay_Animation_AnimationStatic) isOverlay_Animation_AnimationType() {}

func (*Overlay_Animation_AnimationFade) isOverlay_Animation_AnimationType() {}

func (*Overlay_Animation_AnimationEnd) isOverlay_Animation_AnimationType() {}

// Color preprocessing configuration.
type PreprocessingConfig_Color struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Control color saturation of the video. Enter a value between -1 and 1,
	// where -1 is fully desaturated and 1 is maximum saturation. 0 is no
	// change. The default is 0.
	Saturation float64 `protobuf:"fixed64,1,opt,name=saturation,proto3" json:"saturation,omitempty"`
	// Control black and white contrast of the video. Enter a value between -1
	// and 1, where -1 is minimum contrast and 1 is maximum contrast. 0 is no
	// change. The default is 0.
	Contrast float64 `protobuf:"fixed64,2,opt,name=contrast,proto3" json:"contrast,omitempty"`
	// Control brightness of the video. Enter a value between -1 and 1, where -1
	// is minimum brightness and 1 is maximum brightness. 0 is no change. The
	// default is 0.
	Brightness float64 `protobuf:"fixed64,3,opt,name=brightness,proto3" json:"brightness,omitempty"`
}

func (x *PreprocessingConfig_Color) Reset() {
	*x = PreprocessingConfig_Color{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PreprocessingConfig_Color) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PreprocessingConfig_Color) ProtoMessage() {}

func (x *PreprocessingConfig_Color) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PreprocessingConfig_Color.ProtoReflect.Descriptor instead.
func (*PreprocessingConfig_Color) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1beta1_resources_proto_rawDescGZIP(), []int{13, 0}
}

func (x *PreprocessingConfig_Color) GetSaturation() float64 {
	if x != nil {
		return x.Saturation
	}
	return 0
}

func (x *PreprocessingConfig_Color) GetContrast() float64 {
	if x != nil {
		return x.Contrast
	}
	return 0
}

func (x *PreprocessingConfig_Color) GetBrightness() float64 {
	if x != nil {
		return x.Brightness
	}
	return 0
}

// Denoise preprocessing configuration.
type PreprocessingConfig_Denoise struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Set strength of the denoise. Enter a value between 0 and 1. The higher
	// the value, the smoother the image. 0 is no denoising. The default is 0.
	Strength float64 `protobuf:"fixed64,1,opt,name=strength,proto3" json:"strength,omitempty"`
	// Set the denoiser mode. The default is `"standard"`.
	//
	// Supported denoiser modes:
	// - 'standard'
	// - 'grain'
	Tune string `protobuf:"bytes,2,opt,name=tune,proto3" json:"tune,omitempty"`
}

func (x *PreprocessingConfig_Denoise) Reset() {
	*x = PreprocessingConfig_Denoise{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PreprocessingConfig_Denoise) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PreprocessingConfig_Denoise) ProtoMessage() {}

func (x *PreprocessingConfig_Denoise) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PreprocessingConfig_Denoise.ProtoReflect.Descriptor instead.
func (*PreprocessingConfig_Denoise) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1beta1_resources_proto_rawDescGZIP(), []int{13, 1}
}

func (x *PreprocessingConfig_Denoise) GetStrength() float64 {
	if x != nil {
		return x.Strength
	}
	return 0
}

func (x *PreprocessingConfig_Denoise) GetTune() string {
	if x != nil {
		return x.Tune
	}
	return ""
}

// Deblock preprocessing configuration.
type PreprocessingConfig_Deblock struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Set strength of the deblocker. Enter a value between 0 and 1. The higher
	// the value, the stronger the block removal. 0 is no deblocking. The
	// default is 0.
	Strength float64 `protobuf:"fixed64,1,opt,name=strength,proto3" json:"strength,omitempty"`
	// Enable deblocker. The default is `false`.
	Enabled bool `protobuf:"varint,2,opt,name=enabled,proto3" json:"enabled,omitempty"`
}

func (x *PreprocessingConfig_Deblock) Reset() {
	*x = PreprocessingConfig_Deblock{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PreprocessingConfig_Deblock) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PreprocessingConfig_Deblock) ProtoMessage() {}

func (x *PreprocessingConfig_Deblock) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PreprocessingConfig_Deblock.ProtoReflect.Descriptor instead.
func (*PreprocessingConfig_Deblock) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1beta1_resources_proto_rawDescGZIP(), []int{13, 2}
}

func (x *PreprocessingConfig_Deblock) GetStrength() float64 {
	if x != nil {
		return x.Strength
	}
	return 0
}

func (x *PreprocessingConfig_Deblock) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

// Audio preprocessing configuration.
type PreprocessingConfig_Audio struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specify audio loudness normalization in loudness units relative to full
	// scale (LUFS). Enter a value between -24 and 0, where -24 is the Advanced
	// Television Systems Committee (ATSC A/85), -23 is the EU R128 broadcast
	// standard, -19 is the prior standard for online mono audio, -18 is the
	// ReplayGain standard, -16 is the prior standard for stereo audio, -14 is
	// the new online audio standard recommended by Spotify, as well as Amazon
	// Echo, and 0 disables normalization. The default is 0.
	Lufs float64 `protobuf:"fixed64,1,opt,name=lufs,proto3" json:"lufs,omitempty"`
	// Enable boosting high frequency components. The default is `false`.
	HighBoost bool `protobuf:"varint,2,opt,name=high_boost,json=highBoost,proto3" json:"high_boost,omitempty"`
	// Enable boosting low frequency components. The default is `false`.
	LowBoost bool `protobuf:"varint,3,opt,name=low_boost,json=lowBoost,proto3" json:"low_boost,omitempty"`
}

func (x *PreprocessingConfig_Audio) Reset() {
	*x = PreprocessingConfig_Audio{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PreprocessingConfig_Audio) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PreprocessingConfig_Audio) ProtoMessage() {}

func (x *PreprocessingConfig_Audio) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PreprocessingConfig_Audio.ProtoReflect.Descriptor instead.
func (*PreprocessingConfig_Audio) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1beta1_resources_proto_rawDescGZIP(), []int{13, 3}
}

func (x *PreprocessingConfig_Audio) GetLufs() float64 {
	if x != nil {
		return x.Lufs
	}
	return 0
}

func (x *PreprocessingConfig_Audio) GetHighBoost() bool {
	if x != nil {
		return x.HighBoost
	}
	return false
}

func (x *PreprocessingConfig_Audio) GetLowBoost() bool {
	if x != nil {
		return x.LowBoost
	}
	return false
}

// The mapping for the `Job.edit_list` atoms with audio `EditAtom.inputs`.
type AudioStream_AudioAtom struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The `EditAtom.key` that references the atom with audio inputs in the
	// `Job.edit_list`.
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// List of `Channel`s for this audio stream.
	// for in-depth explanation.
	Channels []*AudioStream_AudioAtom_AudioChannel `protobuf:"bytes,2,rep,name=channels,proto3" json:"channels,omitempty"`
}

func (x *AudioStream_AudioAtom) Reset() {
	*x = AudioStream_AudioAtom{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AudioStream_AudioAtom) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AudioStream_AudioAtom) ProtoMessage() {}

func (x *AudioStream_AudioAtom) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AudioStream_AudioAtom.ProtoReflect.Descriptor instead.
func (*AudioStream_AudioAtom) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1beta1_resources_proto_rawDescGZIP(), []int{15, 0}
}

func (x *AudioStream_AudioAtom) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *AudioStream_AudioAtom) GetChannels() []*AudioStream_AudioAtom_AudioChannel {
	if x != nil {
		return x.Channels
	}
	return nil
}

// The audio channel.
type AudioStream_AudioAtom_AudioChannel struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of `Job.inputs` for this audio channel.
	Inputs []*AudioStream_AudioAtom_AudioChannel_AudioChannelInput `protobuf:"bytes,2,rep,name=inputs,proto3" json:"inputs,omitempty"`
}

func (x *AudioStream_AudioAtom_AudioChannel) Reset() {
	*x = AudioStream_AudioAtom_AudioChannel{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AudioStream_AudioAtom_AudioChannel) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AudioStream_AudioAtom_AudioChannel) ProtoMessage() {}

func (x *AudioStream_AudioAtom_AudioChannel) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AudioStream_AudioAtom_AudioChannel.ProtoReflect.Descriptor instead.
func (*AudioStream_AudioAtom_AudioChannel) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1beta1_resources_proto_rawDescGZIP(), []int{15, 0, 0}
}

func (x *AudioStream_AudioAtom_AudioChannel) GetInputs() []*AudioStream_AudioAtom_AudioChannel_AudioChannelInput {
	if x != nil {
		return x.Inputs
	}
	return nil
}

// Identifies which input file, track, and channel should be used.
type AudioStream_AudioAtom_AudioChannel_AudioChannelInput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The `Input.key` that identifies the input file.
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// Required. The zero-based index of the track in the input file.
	Track int32 `protobuf:"varint,2,opt,name=track,proto3" json:"track,omitempty"`
	// Required. The zero-based index of the channel in the input file.
	Channel int32 `protobuf:"varint,3,opt,name=channel,proto3" json:"channel,omitempty"`
	// Audio volume control in dB. Negative values decrease volume,
	// positive values increase. The default is 0.
	GainDb float64 `protobuf:"fixed64,4,opt,name=gain_db,json=gainDb,proto3" json:"gain_db,omitempty"`
}

func (x *AudioStream_AudioAtom_AudioChannel_AudioChannelInput) Reset() {
	*x = AudioStream_AudioAtom_AudioChannel_AudioChannelInput{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AudioStream_AudioAtom_AudioChannel_AudioChannelInput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AudioStream_AudioAtom_AudioChannel_AudioChannelInput) ProtoMessage() {}

func (x *AudioStream_AudioAtom_AudioChannel_AudioChannelInput) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AudioStream_AudioAtom_AudioChannel_AudioChannelInput.ProtoReflect.Descriptor instead.
func (*AudioStream_AudioAtom_AudioChannel_AudioChannelInput) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1beta1_resources_proto_rawDescGZIP(), []int{15, 0, 0, 0}
}

func (x *AudioStream_AudioAtom_AudioChannel_AudioChannelInput) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *AudioStream_AudioAtom_AudioChannel_AudioChannelInput) GetTrack() int32 {
	if x != nil {
		return x.Track
	}
	return 0
}

func (x *AudioStream_AudioAtom_AudioChannel_AudioChannelInput) GetChannel() int32 {
	if x != nil {
		return x.Channel
	}
	return 0
}

func (x *AudioStream_AudioAtom_AudioChannel_AudioChannelInput) GetGainDb() float64 {
	if x != nil {
		return x.GainDb
	}
	return 0
}

// The mapping for the `Job.edit_list` atoms with text `EditAtom.inputs`.
type TextStream_TextAtom struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The `EditAtom.key` that references atom with text inputs in the
	// `Job.edit_list`.
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// List of `Job.inputs` that should be embedded in this atom. Only one
	// input is supported.
	Inputs []*TextStream_TextAtom_TextInput `protobuf:"bytes,2,rep,name=inputs,proto3" json:"inputs,omitempty"`
}

func (x *TextStream_TextAtom) Reset() {
	*x = TextStream_TextAtom{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TextStream_TextAtom) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TextStream_TextAtom) ProtoMessage() {}

func (x *TextStream_TextAtom) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TextStream_TextAtom.ProtoReflect.Descriptor instead.
func (*TextStream_TextAtom) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1beta1_resources_proto_rawDescGZIP(), []int{16, 0}
}

func (x *TextStream_TextAtom) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *TextStream_TextAtom) GetInputs() []*TextStream_TextAtom_TextInput {
	if x != nil {
		return x.Inputs
	}
	return nil
}

// Identifies which input file and track should be used.
type TextStream_TextAtom_TextInput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The `Input.key` that identifies the input file.
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// Required. The zero-based index of the track in the input file.
	Track int32 `protobuf:"varint,2,opt,name=track,proto3" json:"track,omitempty"`
}

func (x *TextStream_TextAtom_TextInput) Reset() {
	*x = TextStream_TextAtom_TextInput{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TextStream_TextAtom_TextInput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TextStream_TextAtom_TextInput) ProtoMessage() {}

func (x *TextStream_TextAtom_TextInput) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TextStream_TextAtom_TextInput.ProtoReflect.Descriptor instead.
func (*TextStream_TextAtom_TextInput) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1beta1_resources_proto_rawDescGZIP(), []int{16, 0, 0}
}

func (x *TextStream_TextAtom_TextInput) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *TextStream_TextAtom_TextInput) GetTrack() int32 {
	if x != nil {
		return x.Track
	}
	return 0
}

// Configuration for AES-128 encryption.
type Encryption_Aes128Encryption struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. URI of the key delivery service. This URI is inserted into the M3U8
	// header.
	KeyUri string `protobuf:"bytes,1,opt,name=key_uri,json=keyUri,proto3" json:"key_uri,omitempty"`
}

func (x *Encryption_Aes128Encryption) Reset() {
	*x = Encryption_Aes128Encryption{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Encryption_Aes128Encryption) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Encryption_Aes128Encryption) ProtoMessage() {}

func (x *Encryption_Aes128Encryption) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Encryption_Aes128Encryption.ProtoReflect.Descriptor instead.
func (*Encryption_Aes128Encryption) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1beta1_resources_proto_rawDescGZIP(), []int{18, 0}
}

func (x *Encryption_Aes128Encryption) GetKeyUri() string {
	if x != nil {
		return x.KeyUri
	}
	return ""
}

// Configuration for SAMPLE-AES encryption.
type Encryption_SampleAesEncryption struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. URI of the key delivery service. This URI is inserted into the M3U8
	// header.
	KeyUri string `protobuf:"bytes,1,opt,name=key_uri,json=keyUri,proto3" json:"key_uri,omitempty"`
}

func (x *Encryption_SampleAesEncryption) Reset() {
	*x = Encryption_SampleAesEncryption{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Encryption_SampleAesEncryption) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Encryption_SampleAesEncryption) ProtoMessage() {}

func (x *Encryption_SampleAesEncryption) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Encryption_SampleAesEncryption.ProtoReflect.Descriptor instead.
func (*Encryption_SampleAesEncryption) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1beta1_resources_proto_rawDescGZIP(), []int{18, 1}
}

func (x *Encryption_SampleAesEncryption) GetKeyUri() string {
	if x != nil {
		return x.KeyUri
	}
	return ""
}

// Configuration for MPEG Common Encryption (MPEG-CENC).
type Encryption_MpegCommonEncryption struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. 128 bit Key ID represented as lowercase hexadecimal digits for use with
	// common encryption.
	KeyId string `protobuf:"bytes,1,opt,name=key_id,json=keyId,proto3" json:"key_id,omitempty"`
	// Required. Specify the encryption scheme.
	//
	// Supported encryption schemes:
	// - 'cenc'
	// - 'cbcs'
	Scheme string `protobuf:"bytes,2,opt,name=scheme,proto3" json:"scheme,omitempty"`
}

func (x *Encryption_MpegCommonEncryption) Reset() {
	*x = Encryption_MpegCommonEncryption{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Encryption_MpegCommonEncryption) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Encryption_MpegCommonEncryption) ProtoMessage() {}

func (x *Encryption_MpegCommonEncryption) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Encryption_MpegCommonEncryption.ProtoReflect.Descriptor instead.
func (*Encryption_MpegCommonEncryption) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1beta1_resources_proto_rawDescGZIP(), []int{18, 2}
}

func (x *Encryption_MpegCommonEncryption) GetKeyId() string {
	if x != nil {
		return x.KeyId
	}
	return ""
}

func (x *Encryption_MpegCommonEncryption) GetScheme() string {
	if x != nil {
		return x.Scheme
	}
	return ""
}

var File_google_cloud_video_transcoder_v1beta1_resources_proto protoreflect.FileDescriptor

var file_google_cloud_video_transcoder_v1beta1_resources_proto_rawDesc = []byte{
	0x0a, 0x35, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76,
	0x69, 0x64, 0x65, 0x6f, 0x2f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x25, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x1f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xc3, 0x08, 0x0a, 0x03,
	0x4a, 0x6f, 0x62, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x09, 0x69, 0x6e, 0x70, 0x75, 0x74,
	0x5f, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x04, 0x52,
	0x08, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x55, 0x72, 0x69, 0x12, 0x22, 0x0a, 0x0a, 0x6f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x04, 0x52, 0x09, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x55, 0x72, 0x69, 0x12, 0x26, 0x0a,
	0x0b, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x04, 0x48, 0x00, 0x52, 0x0a, 0x74, 0x65, 0x6d, 0x70, 0x6c,
	0x61, 0x74, 0x65, 0x49, 0x64, 0x12, 0x4a, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x63, 0x6f, 0x64, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4a, 0x6f,
	0x62, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x1a, 0x0a, 0x08, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x12, 0x58, 0x0a,
	0x0a, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x6f, 0x64, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x2e, 0x4f, 0x72,
	0x69, 0x67, 0x69, 0x6e, 0x55, 0x72, 0x69, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x6f, 0x72,
	0x69, 0x67, 0x69, 0x6e, 0x55, 0x72, 0x69, 0x12, 0x55, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4a,
	0x6f, 0x62, 0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x50,
	0x0a, 0x08, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x6f, 0x64, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73,
	0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73,
	0x12, 0x2a, 0x0a, 0x0e, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x5f, 0x72, 0x65, 0x61, 0x73,
	0x6f, 0x6e, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x66,
	0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x62, 0x0a, 0x0f,
	0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18,
	0x0b, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x63, 0x6f, 0x64, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x46, 0x61,
	0x69, 0x6c, 0x75, 0x72, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0e, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73,
	0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x3e, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0e,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x1a, 0x31,
	0x0a, 0x09, 0x4f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x55, 0x72, 0x69, 0x12, 0x10, 0x0a, 0x03, 0x68,
	0x6c, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x68, 0x6c, 0x73, 0x12, 0x12, 0x0a,
	0x04, 0x64, 0x61, 0x73, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x64, 0x61, 0x73,
	0x68, 0x22, 0x68, 0x0a, 0x0f, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x12, 0x20, 0x0a, 0x1c, 0x50, 0x52, 0x4f, 0x43, 0x45, 0x53, 0x53, 0x49,
	0x4e, 0x47, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e,
	0x47, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x02,
	0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x03, 0x12,
	0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x04, 0x3a, 0x56, 0xea, 0x41, 0x53,
	0x0a, 0x1d, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4a, 0x6f, 0x62, 0x12,
	0x32, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6a, 0x6f, 0x62, 0x73, 0x2f, 0x7b, 0x6a,
	0x6f, 0x62, 0x7d, 0x42, 0x0c, 0x0a, 0x0a, 0x6a, 0x6f, 0x62, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x22, 0xdc, 0x01, 0x0a, 0x0b, 0x4a, 0x6f, 0x62, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74,
	0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x48, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x63, 0x6f, 0x64, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4a, 0x6f,
	0x62, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x3a,
	0x6f, 0xea, 0x41, 0x6c, 0x0a, 0x25, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x6f, 0x64, 0x65, 0x72,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x4a, 0x6f, 0x62, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x43, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6a, 0x6f, 0x62, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65,
	0x73, 0x2f, 0x7b, 0x6a, 0x6f, 0x62, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x7d,
	0x22, 0xcb, 0x06, 0x0a, 0x09, 0x4a, 0x6f, 0x62, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x44,
	0x0a, 0x06, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x64, 0x65, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x52, 0x06, 0x69, 0x6e,
	0x70, 0x75, 0x74, 0x73, 0x12, 0x4c, 0x0a, 0x09, 0x65, 0x64, 0x69, 0x74, 0x5f, 0x6c, 0x69, 0x73,
	0x74, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x45, 0x64, 0x69, 0x74, 0x41, 0x74, 0x6f, 0x6d, 0x52, 0x08, 0x65, 0x64, 0x69, 0x74, 0x4c, 0x69,
	0x73, 0x74, 0x12, 0x66, 0x0a, 0x12, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x72, 0x79,
	0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x64, 0x65, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x72,
	0x79, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x11, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x72, 0x79, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x12, 0x51, 0x0a, 0x0b, 0x6d, 0x75,
	0x78, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x64, 0x65, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x75, 0x78, 0x53, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x52, 0x0a, 0x6d, 0x75, 0x78, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x12, 0x4d, 0x0a,
	0x09, 0x6d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x6f, 0x64, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73,
	0x74, 0x52, 0x09, 0x6d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x73, 0x12, 0x45, 0x0a, 0x06,
	0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65,
	0x6f, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x52, 0x06, 0x6f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x12, 0x4b, 0x0a, 0x09, 0x61, 0x64, 0x5f, 0x62, 0x72, 0x65, 0x61, 0x6b, 0x73,
	0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41,
	0x64, 0x42, 0x72, 0x65, 0x61, 0x6b, 0x52, 0x08, 0x61, 0x64, 0x42, 0x72, 0x65, 0x61, 0x6b, 0x73,
	0x12, 0x67, 0x0a, 0x12, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x5f, 0x64, 0x65, 0x73, 0x74, 0x69,
	0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65,
	0x6f, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x75, 0x62, 0x73, 0x75, 0x62, 0x44, 0x65, 0x73, 0x74, 0x69,
	0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x11, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x44, 0x65,
	0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x57, 0x0a, 0x0d, 0x73, 0x70, 0x72,
	0x69, 0x74, 0x65, 0x5f, 0x73, 0x68, 0x65, 0x65, 0x74, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x6f, 0x64, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x70, 0x72, 0x69, 0x74, 0x65, 0x53,
	0x68, 0x65, 0x65, 0x74, 0x52, 0x0c, 0x73, 0x70, 0x72, 0x69, 0x74, 0x65, 0x53, 0x68, 0x65, 0x65,
	0x74, 0x73, 0x12, 0x4a, 0x0a, 0x08, 0x6f, 0x76, 0x65, 0x72, 0x6c, 0x61, 0x79, 0x73, 0x18, 0x0a,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63,
	0x6f, 0x64, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4f, 0x76, 0x65,
	0x72, 0x6c, 0x61, 0x79, 0x52, 0x08, 0x6f, 0x76, 0x65, 0x72, 0x6c, 0x61, 0x79, 0x73, 0x22, 0x9a,
	0x01, 0x0a, 0x05, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72,
	0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x69, 0x12, 0x6d, 0x0a, 0x14,
	0x70, 0x72, 0x65, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x50, 0x72, 0x65, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x13, 0x70, 0x72, 0x65, 0x70, 0x72, 0x6f, 0x63, 0x65,
	0x73, 0x73, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x1a, 0x0a, 0x06, 0x4f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x69, 0x22, 0xbe, 0x01, 0x0a, 0x08, 0x45, 0x64, 0x69, 0x74,
	0x41, 0x74, 0x6f, 0x6d, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x16, 0x0a, 0x06, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x06, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x12, 0x41,
	0x0a, 0x0f, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65,
	0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x0d, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x4f, 0x66, 0x66, 0x73, 0x65,
	0x74, 0x12, 0x45, 0x0a, 0x11, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f,
	0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69,
	0x6d, 0x65, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x22, 0x50, 0x0a, 0x07, 0x41, 0x64, 0x42, 0x72,
	0x65, 0x61, 0x6b, 0x12, 0x45, 0x0a, 0x11, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x73, 0x74, 0x61, 0x72, 0x74,
	0x54, 0x69, 0x6d, 0x65, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x22, 0xc1, 0x02, 0x0a, 0x10, 0x45,
	0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x72, 0x79, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x57, 0x0a, 0x0c, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x56, 0x69, 0x64, 0x65, 0x6f, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x48, 0x00, 0x52, 0x0b, 0x76,
	0x69, 0x64, 0x65, 0x6f, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x57, 0x0a, 0x0c, 0x61, 0x75,
	0x64, 0x69, 0x6f, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x6f, 0x64, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x48, 0x00, 0x52, 0x0b, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x53, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x12, 0x54, 0x0a, 0x0b, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x73, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x54, 0x65, 0x78, 0x74, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x48, 0x00, 0x52, 0x0a, 0x74,
	0x65, 0x78, 0x74, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x42, 0x13, 0x0a, 0x11, 0x65, 0x6c, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x61, 0x72, 0x79, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x22, 0xbd,
	0x02, 0x0a, 0x09, 0x4d, 0x75, 0x78, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x1b,
	0x0a, 0x09, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x66, 0x69, 0x6c, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x12, 0x2d, 0x0a, 0x12, 0x65, 0x6c, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x61, 0x72, 0x79, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x18,
	0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x11, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x72,
	0x79, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x12, 0x61, 0x0a, 0x10, 0x73, 0x65, 0x67, 0x6d,
	0x65, 0x6e, 0x74, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x6f, 0x64,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x67, 0x6d, 0x65,
	0x6e, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x0f, 0x73, 0x65, 0x67, 0x6d,
	0x65, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x51, 0x0a, 0x0a, 0x65,
	0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x64, 0x65, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x0a, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xe6,
	0x01, 0x0a, 0x08, 0x4d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x66,
	0x69, 0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08,
	0x66, 0x69, 0x6c, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x55, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d,
	0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x2e, 0x4d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74,
	0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12,
	0x24, 0x0a, 0x0b, 0x6d, 0x75, 0x78, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x6d, 0x75, 0x78, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x73, 0x22, 0x40, 0x0a, 0x0c, 0x4d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73,
	0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1d, 0x0a, 0x19, 0x4d, 0x41, 0x4e, 0x49, 0x46, 0x45, 0x53,
	0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x07, 0x0a, 0x03, 0x48, 0x4c, 0x53, 0x10, 0x01, 0x12, 0x08, 0x0a,
	0x04, 0x44, 0x41, 0x53, 0x48, 0x10, 0x02, 0x22, 0x29, 0x0a, 0x11, 0x50, 0x75, 0x62, 0x73, 0x75,
	0x62, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x14, 0x0a, 0x05,
	0x74, 0x6f, 0x70, 0x69, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x6f, 0x70,
	0x69, 0x63, 0x22, 0xf4, 0x03, 0x0a, 0x0b, 0x53, 0x70, 0x72, 0x69, 0x74, 0x65, 0x53, 0x68, 0x65,
	0x65, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x06, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x24, 0x0a, 0x0b, 0x66, 0x69,
	0x6c, 0x65, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x66, 0x69, 0x6c, 0x65, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78,
	0x12, 0x33, 0x0a, 0x13, 0x73, 0x70, 0x72, 0x69, 0x74, 0x65, 0x5f, 0x77, 0x69, 0x64, 0x74, 0x68,
	0x5f, 0x70, 0x69, 0x78, 0x65, 0x6c, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x11, 0x73, 0x70, 0x72, 0x69, 0x74, 0x65, 0x57, 0x69, 0x64, 0x74, 0x68, 0x50,
	0x69, 0x78, 0x65, 0x6c, 0x73, 0x12, 0x35, 0x0a, 0x14, 0x73, 0x70, 0x72, 0x69, 0x74, 0x65, 0x5f,
	0x68, 0x65, 0x69, 0x67, 0x68, 0x74, 0x5f, 0x70, 0x69, 0x78, 0x65, 0x6c, 0x73, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x12, 0x73, 0x70, 0x72, 0x69, 0x74, 0x65,
	0x48, 0x65, 0x69, 0x67, 0x68, 0x74, 0x50, 0x69, 0x78, 0x65, 0x6c, 0x73, 0x12, 0x21, 0x0a, 0x0c,
	0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x0b, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12,
	0x1b, 0x0a, 0x09, 0x72, 0x6f, 0x77, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x08, 0x72, 0x6f, 0x77, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x45, 0x0a, 0x11,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65,
	0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x0f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x4f, 0x66, 0x66,
	0x73, 0x65, 0x74, 0x12, 0x41, 0x0a, 0x0f, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f,
	0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65,
	0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x12, 0x21, 0x0a, 0x0b, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x09, 0x20, 0x01, 0x28, 0x05, 0x48, 0x00, 0x52, 0x0a, 0x74,
	0x6f, 0x74, 0x61, 0x6c, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x37, 0x0a, 0x08, 0x69, 0x6e, 0x74,
	0x65, 0x72, 0x76, 0x61, 0x6c, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x08, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76,
	0x61, 0x6c, 0x42, 0x15, 0x0a, 0x13, 0x65, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x73, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x22, 0xec, 0x0a, 0x0a, 0x07, 0x4f, 0x76,
	0x65, 0x72, 0x6c, 0x61, 0x79, 0x12, 0x4a, 0x0a, 0x05, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63,
	0x6f, 0x64, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4f, 0x76, 0x65,
	0x72, 0x6c, 0x61, 0x79, 0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x52, 0x05, 0x69, 0x6d, 0x61, 0x67,
	0x65, 0x12, 0x58, 0x0a, 0x0a, 0x61, 0x6e, 0x69, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x63, 0x6f, 0x64, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4f, 0x76,
	0x65, 0x72, 0x6c, 0x61, 0x79, 0x2e, 0x41, 0x6e, 0x69, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x0a, 0x61, 0x6e, 0x69, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x32, 0x0a, 0x14, 0x4e,
	0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x43, 0x6f, 0x6f, 0x72, 0x64, 0x69, 0x6e,
	0x61, 0x74, 0x65, 0x12, 0x0c, 0x0a, 0x01, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x01, 0x52, 0x01,
	0x78, 0x12, 0x0c, 0x0a, 0x01, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x52, 0x01, 0x79, 0x1a,
	0x99, 0x01, 0x0a, 0x05, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x12, 0x15, 0x0a, 0x03, 0x75, 0x72, 0x69,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x03, 0x75, 0x72, 0x69,
	0x12, 0x63, 0x0a, 0x0a, 0x72, 0x65, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63,
	0x6f, 0x64, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4f, 0x76, 0x65,
	0x72, 0x6c, 0x61, 0x79, 0x2e, 0x4e, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x43,
	0x6f, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x61, 0x74, 0x65, 0x52, 0x0a, 0x72, 0x65, 0x73, 0x6f, 0x6c,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x14, 0x0a, 0x05, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x01, 0x52, 0x05, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x1a, 0xad, 0x01, 0x0a, 0x0f,
	0x41, 0x6e, 0x69, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x69, 0x63, 0x12,
	0x53, 0x0a, 0x02, 0x78, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f,
	0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x4f, 0x76, 0x65, 0x72, 0x6c, 0x61, 0x79, 0x2e, 0x4e, 0x6f, 0x72, 0x6d,
	0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x43, 0x6f, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x61, 0x74, 0x65,
	0x52, 0x02, 0x78, 0x79, 0x12, 0x45, 0x0a, 0x11, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x73, 0x74, 0x61, 0x72,
	0x74, 0x54, 0x69, 0x6d, 0x65, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x1a, 0xc9, 0x02, 0x0a, 0x0d,
	0x41, 0x6e, 0x69, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x61, 0x64, 0x65, 0x12, 0x59, 0x0a,
	0x09, 0x66, 0x61, 0x64, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x6f, 0x64, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4f, 0x76, 0x65, 0x72, 0x6c, 0x61, 0x79,
	0x2e, 0x46, 0x61, 0x64, 0x65, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08,
	0x66, 0x61, 0x64, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x53, 0x0a, 0x02, 0x78, 0x79, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63,
	0x6f, 0x64, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4f, 0x76, 0x65,
	0x72, 0x6c, 0x61, 0x79, 0x2e, 0x4e, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x43,
	0x6f, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x61, 0x74, 0x65, 0x52, 0x02, 0x78, 0x79, 0x12, 0x45, 0x0a,
	0x11, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x6f, 0x66, 0x66, 0x73,
	0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x4f, 0x66,
	0x66, 0x73, 0x65, 0x74, 0x12, 0x41, 0x0a, 0x0f, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d,
	0x65, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x1a, 0x55, 0x0a, 0x0c, 0x41, 0x6e, 0x69, 0x6d, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6e, 0x64, 0x12, 0x45, 0x0a, 0x11, 0x73, 0x74, 0x61, 0x72, 0x74,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x73,
	0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x1a, 0xd5,
	0x02, 0x0a, 0x09, 0x41, 0x6e, 0x69, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x6b, 0x0a, 0x10,
	0x61, 0x6e, 0x69, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x69, 0x63,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4f,
	0x76, 0x65, 0x72, 0x6c, 0x61, 0x79, 0x2e, 0x41, 0x6e, 0x69, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x74, 0x61, 0x74, 0x69, 0x63, 0x48, 0x00, 0x52, 0x0f, 0x61, 0x6e, 0x69, 0x6d, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x69, 0x63, 0x12, 0x65, 0x0a, 0x0e, 0x61, 0x6e, 0x69,
	0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x61, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x6f, 0x64, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4f, 0x76, 0x65, 0x72, 0x6c, 0x61,
	0x79, 0x2e, 0x41, 0x6e, 0x69, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x61, 0x64, 0x65, 0x48,
	0x00, 0x52, 0x0d, 0x61, 0x6e, 0x69, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x61, 0x64, 0x65,
	0x12, 0x62, 0x0a, 0x0d, 0x61, 0x6e, 0x69, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x6e,
	0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x4f, 0x76, 0x65, 0x72, 0x6c, 0x61, 0x79, 0x2e, 0x41, 0x6e, 0x69, 0x6d, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x45, 0x6e, 0x64, 0x48, 0x00, 0x52, 0x0c, 0x61, 0x6e, 0x69, 0x6d, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x45, 0x6e, 0x64, 0x42, 0x10, 0x0a, 0x0e, 0x61, 0x6e, 0x69, 0x6d, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x22, 0x40, 0x0a, 0x08, 0x46, 0x61, 0x64, 0x65, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x19, 0x0a, 0x15, 0x46, 0x41, 0x44, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a,
	0x07, 0x46, 0x41, 0x44, 0x45, 0x5f, 0x49, 0x4e, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x46, 0x41,
	0x44, 0x45, 0x5f, 0x4f, 0x55, 0x54, 0x10, 0x02, 0x22, 0xbb, 0x05, 0x0a, 0x13, 0x50, 0x72, 0x65,
	0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x56, 0x0a, 0x05, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x64, 0x65, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x72, 0x65, 0x70, 0x72, 0x6f, 0x63, 0x65,
	0x73, 0x73, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x43, 0x6f, 0x6c, 0x6f,
	0x72, 0x52, 0x05, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x12, 0x5c, 0x0a, 0x07, 0x64, 0x65, 0x6e, 0x6f,
	0x69, 0x73, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x74,
	0x72, 0x61, 0x6e, 0x73, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x50, 0x72, 0x65, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x44, 0x65, 0x6e, 0x6f, 0x69, 0x73, 0x65, 0x52, 0x07, 0x64,
	0x65, 0x6e, 0x6f, 0x69, 0x73, 0x65, 0x12, 0x5c, 0x0a, 0x07, 0x64, 0x65, 0x62, 0x6c, 0x6f, 0x63,
	0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x50, 0x72, 0x65, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x44, 0x65, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x52, 0x07, 0x64, 0x65, 0x62,
	0x6c, 0x6f, 0x63, 0x6b, 0x12, 0x56, 0x0a, 0x05, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x6f,
	0x64, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x72, 0x65, 0x70,
	0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x41, 0x75, 0x64, 0x69, 0x6f, 0x52, 0x05, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x1a, 0x63, 0x0a, 0x05,
	0x43, 0x6f, 0x6c, 0x6f, 0x72, 0x12, 0x1e, 0x0a, 0x0a, 0x73, 0x61, 0x74, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x01, 0x52, 0x0a, 0x73, 0x61, 0x74, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1a, 0x0a, 0x08, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x61, 0x73,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x52, 0x08, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x61, 0x73,
	0x74, 0x12, 0x1e, 0x0a, 0x0a, 0x62, 0x72, 0x69, 0x67, 0x68, 0x74, 0x6e, 0x65, 0x73, 0x73, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x01, 0x52, 0x0a, 0x62, 0x72, 0x69, 0x67, 0x68, 0x74, 0x6e, 0x65, 0x73,
	0x73, 0x1a, 0x39, 0x0a, 0x07, 0x44, 0x65, 0x6e, 0x6f, 0x69, 0x73, 0x65, 0x12, 0x1a, 0x0a, 0x08,
	0x73, 0x74, 0x72, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x01, 0x52, 0x08,
	0x73, 0x74, 0x72, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x75, 0x6e, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x75, 0x6e, 0x65, 0x1a, 0x3f, 0x0a, 0x07,
	0x44, 0x65, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x12, 0x1a, 0x0a, 0x08, 0x73, 0x74, 0x72, 0x65, 0x6e,
	0x67, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x01, 0x52, 0x08, 0x73, 0x74, 0x72, 0x65, 0x6e,
	0x67, 0x74, 0x68, 0x12, 0x18, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x1a, 0x57, 0x0a,
	0x05, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x12, 0x12, 0x0a, 0x04, 0x6c, 0x75, 0x66, 0x73, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x01, 0x52, 0x04, 0x6c, 0x75, 0x66, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x68, 0x69,
	0x67, 0x68, 0x5f, 0x62, 0x6f, 0x6f, 0x73, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09,
	0x68, 0x69, 0x67, 0x68, 0x42, 0x6f, 0x6f, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x6c, 0x6f, 0x77,
	0x5f, 0x62, 0x6f, 0x6f, 0x73, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x6c, 0x6f,
	0x77, 0x42, 0x6f, 0x6f, 0x73, 0x74, 0x22, 0x82, 0x06, 0x0a, 0x0b, 0x56, 0x69, 0x64, 0x65, 0x6f,
	0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x14, 0x0a, 0x05, 0x63, 0x6f, 0x64, 0x65, 0x63, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x63, 0x6f, 0x64, 0x65, 0x63, 0x12, 0x18, 0x0a, 0x07,
	0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70,
	0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x75, 0x6e, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x75, 0x6e, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x72,
	0x65, 0x73, 0x65, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x70, 0x72, 0x65, 0x73,
	0x65, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74, 0x5f, 0x70, 0x69, 0x78,
	0x65, 0x6c, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0c, 0x68, 0x65, 0x69, 0x67, 0x68,
	0x74, 0x50, 0x69, 0x78, 0x65, 0x6c, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x77, 0x69, 0x64, 0x74, 0x68,
	0x5f, 0x70, 0x69, 0x78, 0x65, 0x6c, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0b, 0x77,
	0x69, 0x64, 0x74, 0x68, 0x50, 0x69, 0x78, 0x65, 0x6c, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x70, 0x69,
	0x78, 0x65, 0x6c, 0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0b, 0x70, 0x69, 0x78, 0x65, 0x6c, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x24, 0x0a,
	0x0b, 0x62, 0x69, 0x74, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x62, 0x70, 0x73, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x62, 0x69, 0x74, 0x72, 0x61, 0x74, 0x65,
	0x42, 0x70, 0x73, 0x12, 0x2a, 0x0a, 0x11, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x74,
	0x72, 0x6f, 0x6c, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f,
	0x72, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x4d, 0x6f, 0x64, 0x65, 0x12,
	0x26, 0x0a, 0x0f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x74, 0x77, 0x6f, 0x5f, 0x70, 0x61,
	0x73, 0x73, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x54, 0x77, 0x6f, 0x50, 0x61, 0x73, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x63, 0x72, 0x66, 0x5f, 0x6c,
	0x65, 0x76, 0x65, 0x6c, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x63, 0x72, 0x66, 0x4c,
	0x65, 0x76, 0x65, 0x6c, 0x12, 0x22, 0x0a, 0x0d, 0x76, 0x62, 0x76, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x5f, 0x62, 0x69, 0x74, 0x73, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0b, 0x76, 0x62, 0x76,
	0x53, 0x69, 0x7a, 0x65, 0x42, 0x69, 0x74, 0x73, 0x12, 0x2a, 0x0a, 0x11, 0x76, 0x62, 0x76, 0x5f,
	0x66, 0x75, 0x6c, 0x6c, 0x6e, 0x65, 0x73, 0x73, 0x5f, 0x62, 0x69, 0x74, 0x73, 0x18, 0x0d, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x0f, 0x76, 0x62, 0x76, 0x46, 0x75, 0x6c, 0x6c, 0x6e, 0x65, 0x73, 0x73,
	0x42, 0x69, 0x74, 0x73, 0x12, 0x24, 0x0a, 0x0e, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x6f, 0x70,
	0x65, 0x6e, 0x5f, 0x67, 0x6f, 0x70, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x61, 0x6c,
	0x6c, 0x6f, 0x77, 0x4f, 0x70, 0x65, 0x6e, 0x47, 0x6f, 0x70, 0x12, 0x28, 0x0a, 0x0f, 0x67, 0x6f,
	0x70, 0x5f, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x0f, 0x20,
	0x01, 0x28, 0x05, 0x48, 0x00, 0x52, 0x0d, 0x67, 0x6f, 0x70, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x43,
	0x6f, 0x75, 0x6e, 0x74, 0x12, 0x3e, 0x0a, 0x0c, 0x67, 0x6f, 0x70, 0x5f, 0x64, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0b, 0x67, 0x6f, 0x70, 0x44, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x23, 0x0a, 0x0d, 0x65, 0x6e, 0x74, 0x72, 0x6f, 0x70, 0x79, 0x5f,
	0x63, 0x6f, 0x64, 0x65, 0x72, 0x18, 0x11, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x65, 0x6e, 0x74,
	0x72, 0x6f, 0x70, 0x79, 0x43, 0x6f, 0x64, 0x65, 0x72, 0x12, 0x1b, 0x0a, 0x09, 0x62, 0x5f, 0x70,
	0x79, 0x72, 0x61, 0x6d, 0x69, 0x64, 0x18, 0x12, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x62, 0x50,
	0x79, 0x72, 0x61, 0x6d, 0x69, 0x64, 0x12, 0x22, 0x0a, 0x0d, 0x62, 0x5f, 0x66, 0x72, 0x61, 0x6d,
	0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x13, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0b, 0x62,
	0x46, 0x72, 0x61, 0x6d, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x66, 0x72,
	0x61, 0x6d, 0x65, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x18, 0x14, 0x20, 0x01, 0x28, 0x01, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x09, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x52, 0x61, 0x74, 0x65, 0x12, 0x1f,
	0x0a, 0x0b, 0x61, 0x71, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x15, 0x20,
	0x01, 0x28, 0x01, 0x52, 0x0a, 0x61, 0x71, 0x53, 0x74, 0x72, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x42,
	0x0a, 0x0a, 0x08, 0x67, 0x6f, 0x70, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x22, 0xaa, 0x05, 0x0a, 0x0b,
	0x41, 0x75, 0x64, 0x69, 0x6f, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x14, 0x0a, 0x05, 0x63,
	0x6f, 0x64, 0x65, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x63, 0x6f, 0x64, 0x65,
	0x63, 0x12, 0x24, 0x0a, 0x0b, 0x62, 0x69, 0x74, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x62, 0x70, 0x73,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x62, 0x69, 0x74,
	0x72, 0x61, 0x74, 0x65, 0x42, 0x70, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x63, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0c,
	0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x25, 0x0a, 0x0e,
	0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x6c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x18, 0x04,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x4c, 0x61, 0x79,
	0x6f, 0x75, 0x74, 0x12, 0x56, 0x0a, 0x07, 0x6d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x18, 0x05,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63,
	0x6f, 0x64, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x75, 0x64,
	0x69, 0x6f, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x41, 0x74,
	0x6f, 0x6d, 0x52, 0x07, 0x6d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x12, 0x2a, 0x0a, 0x11, 0x73,
	0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x68, 0x65, 0x72, 0x74, 0x7a,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0f, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x52, 0x61,
	0x74, 0x65, 0x48, 0x65, 0x72, 0x74, 0x7a, 0x1a, 0x8e, 0x03, 0x0a, 0x09, 0x41, 0x75, 0x64, 0x69,
	0x6f, 0x41, 0x74, 0x6f, 0x6d, 0x12, 0x15, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x65, 0x0a, 0x08,
	0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x49,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x64, 0x65, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x53, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x2e, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x41, 0x74, 0x6f, 0x6d, 0x2e, 0x41, 0x75, 0x64,
	0x69, 0x6f, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x52, 0x08, 0x63, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x73, 0x1a, 0x82, 0x02, 0x0a, 0x0c, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x43, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x12, 0x73, 0x0a, 0x06, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x5b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63,
	0x6f, 0x64, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x75, 0x64,
	0x69, 0x6f, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x41, 0x74,
	0x6f, 0x6d, 0x2e, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e,
	0x41, 0x75, 0x64, 0x69, 0x6f, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x49, 0x6e, 0x70, 0x75,
	0x74, 0x52, 0x06, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x1a, 0x7d, 0x0a, 0x11, 0x41, 0x75, 0x64,
	0x69, 0x6f, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x15,
	0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x19, 0x0a, 0x05, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x74, 0x72, 0x61, 0x63, 0x6b,
	0x12, 0x1d, 0x0a, 0x07, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x05, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x12,
	0x17, 0x0a, 0x07, 0x67, 0x61, 0x69, 0x6e, 0x5f, 0x64, 0x62, 0x18, 0x04, 0x20, 0x01, 0x28, 0x01,
	0x52, 0x06, 0x67, 0x61, 0x69, 0x6e, 0x44, 0x62, 0x22, 0xe3, 0x02, 0x0a, 0x0a, 0x54, 0x65, 0x78,
	0x74, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x14, 0x0a, 0x05, 0x63, 0x6f, 0x64, 0x65, 0x63,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x63, 0x6f, 0x64, 0x65, 0x63, 0x12, 0x28, 0x0a,
	0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75,
	0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x54, 0x0a, 0x07, 0x6d, 0x61, 0x70, 0x70, 0x69,
	0x6e, 0x67, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x54, 0x65, 0x78, 0x74, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x54, 0x65, 0x78, 0x74,
	0x41, 0x74, 0x6f, 0x6d, 0x52, 0x07, 0x6d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x1a, 0xbe, 0x01,
	0x0a, 0x08, 0x54, 0x65, 0x78, 0x74, 0x41, 0x74, 0x6f, 0x6d, 0x12, 0x15, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x5c, 0x0a, 0x06, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x6f, 0x64, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x65, 0x78, 0x74, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x2e, 0x54, 0x65, 0x78, 0x74, 0x41, 0x74, 0x6f, 0x6d, 0x2e, 0x54, 0x65,
	0x78, 0x74, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x52, 0x06, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x1a,
	0x3d, 0x0a, 0x09, 0x54, 0x65, 0x78, 0x74, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x15, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x03,
	0x6b, 0x65, 0x79, 0x12, 0x19, 0x0a, 0x05, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x22, 0x8d,
	0x01, 0x0a, 0x0f, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x12, 0x44, 0x0a, 0x10, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x64, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74,
	0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x34, 0x0a, 0x13, 0x69, 0x6e, 0x64, 0x69,
	0x76, 0x69, 0x64, 0x75, 0x61, 0x6c, 0x5f, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x12, 0x69, 0x6e, 0x64, 0x69,
	0x76, 0x69, 0x64, 0x75, 0x61, 0x6c, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x22, 0xb1,
	0x04, 0x0a, 0x0a, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x15, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x13, 0x0a, 0x02, 0x69, 0x76, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x02, 0x69, 0x76, 0x12, 0x5d, 0x0a, 0x07, 0x61, 0x65, 0x73,
	0x5f, 0x31, 0x32, 0x38, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x41, 0x65,
	0x73, 0x31, 0x32, 0x38, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00,
	0x52, 0x06, 0x61, 0x65, 0x73, 0x31, 0x32, 0x38, 0x12, 0x66, 0x0a, 0x0a, 0x73, 0x61, 0x6d, 0x70,
	0x6c, 0x65, 0x5f, 0x61, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x45, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65,
	0x6f, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x41, 0x65, 0x73, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x09, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x41, 0x65, 0x73,
	0x12, 0x65, 0x0a, 0x09, 0x6d, 0x70, 0x65, 0x67, 0x5f, 0x63, 0x65, 0x6e, 0x63, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x6f,
	0x64, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x6e, 0x63, 0x72,
	0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4d, 0x70, 0x65, 0x67, 0x43, 0x6f, 0x6d, 0x6d, 0x6f,
	0x6e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x08, 0x6d,
	0x70, 0x65, 0x67, 0x43, 0x65, 0x6e, 0x63, 0x1a, 0x30, 0x0a, 0x10, 0x41, 0x65, 0x73, 0x31, 0x32,
	0x38, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1c, 0x0a, 0x07, 0x6b,
	0x65, 0x79, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x06, 0x6b, 0x65, 0x79, 0x55, 0x72, 0x69, 0x1a, 0x33, 0x0a, 0x13, 0x53, 0x61, 0x6d,
	0x70, 0x6c, 0x65, 0x41, 0x65, 0x73, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x1c, 0x0a, 0x07, 0x6b, 0x65, 0x79, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x6b, 0x65, 0x79, 0x55, 0x72, 0x69, 0x1a, 0x4f,
	0x0a, 0x14, 0x4d, 0x70, 0x65, 0x67, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x45, 0x6e, 0x63, 0x72,
	0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1a, 0x0a, 0x06, 0x6b, 0x65, 0x79, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x6b, 0x65, 0x79,
	0x49, 0x64, 0x12, 0x1b, 0x0a, 0x06, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x65, 0x42,
	0x11, 0x0a, 0x0f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x6f,
	0x64, 0x65, 0x22, 0x78, 0x0a, 0x08, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x12, 0x1a,
	0x0a, 0x08, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x01,
	0x52, 0x08, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x64, 0x12, 0x18, 0x0a, 0x07, 0x65, 0x6e,
	0x63, 0x6f, 0x64, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x52, 0x07, 0x65, 0x6e, 0x63,
	0x6f, 0x64, 0x65, 0x64, 0x12, 0x1a, 0x0a, 0x08, 0x75, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x65, 0x64,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x01, 0x52, 0x08, 0x75, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x65, 0x64,
	0x12, 0x1a, 0x0a, 0x08, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x65, 0x64, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x01, 0x52, 0x08, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x65, 0x64, 0x22, 0x31, 0x0a, 0x0d,
	0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x12, 0x20, 0x0a,
	0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x42,
	0x8e, 0x01, 0x0a, 0x29, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x63, 0x6f, 0x64, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x42, 0x0e, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a,
	0x4f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f,
	0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76, 0x69, 0x64,
	0x65, 0x6f, 0x2f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x3b, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x6f, 0x64, 0x65, 0x72,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_video_transcoder_v1beta1_resources_proto_rawDescOnce sync.Once
	file_google_cloud_video_transcoder_v1beta1_resources_proto_rawDescData = file_google_cloud_video_transcoder_v1beta1_resources_proto_rawDesc
)

func file_google_cloud_video_transcoder_v1beta1_resources_proto_rawDescGZIP() []byte {
	file_google_cloud_video_transcoder_v1beta1_resources_proto_rawDescOnce.Do(func() {
		file_google_cloud_video_transcoder_v1beta1_resources_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_video_transcoder_v1beta1_resources_proto_rawDescData)
	})
	return file_google_cloud_video_transcoder_v1beta1_resources_proto_rawDescData
}

var file_google_cloud_video_transcoder_v1beta1_resources_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes = make([]protoimpl.MessageInfo, 40)
var file_google_cloud_video_transcoder_v1beta1_resources_proto_goTypes = []interface{}{
	(Job_ProcessingState)(0),                   // 0: google.cloud.video.transcoder.v1beta1.Job.ProcessingState
	(Manifest_ManifestType)(0),                 // 1: google.cloud.video.transcoder.v1beta1.Manifest.ManifestType
	(Overlay_FadeType)(0),                      // 2: google.cloud.video.transcoder.v1beta1.Overlay.FadeType
	(*Job)(nil),                                // 3: google.cloud.video.transcoder.v1beta1.Job
	(*JobTemplate)(nil),                        // 4: google.cloud.video.transcoder.v1beta1.JobTemplate
	(*JobConfig)(nil),                          // 5: google.cloud.video.transcoder.v1beta1.JobConfig
	(*Input)(nil),                              // 6: google.cloud.video.transcoder.v1beta1.Input
	(*Output)(nil),                             // 7: google.cloud.video.transcoder.v1beta1.Output
	(*EditAtom)(nil),                           // 8: google.cloud.video.transcoder.v1beta1.EditAtom
	(*AdBreak)(nil),                            // 9: google.cloud.video.transcoder.v1beta1.AdBreak
	(*ElementaryStream)(nil),                   // 10: google.cloud.video.transcoder.v1beta1.ElementaryStream
	(*MuxStream)(nil),                          // 11: google.cloud.video.transcoder.v1beta1.MuxStream
	(*Manifest)(nil),                           // 12: google.cloud.video.transcoder.v1beta1.Manifest
	(*PubsubDestination)(nil),                  // 13: google.cloud.video.transcoder.v1beta1.PubsubDestination
	(*SpriteSheet)(nil),                        // 14: google.cloud.video.transcoder.v1beta1.SpriteSheet
	(*Overlay)(nil),                            // 15: google.cloud.video.transcoder.v1beta1.Overlay
	(*PreprocessingConfig)(nil),                // 16: google.cloud.video.transcoder.v1beta1.PreprocessingConfig
	(*VideoStream)(nil),                        // 17: google.cloud.video.transcoder.v1beta1.VideoStream
	(*AudioStream)(nil),                        // 18: google.cloud.video.transcoder.v1beta1.AudioStream
	(*TextStream)(nil),                         // 19: google.cloud.video.transcoder.v1beta1.TextStream
	(*SegmentSettings)(nil),                    // 20: google.cloud.video.transcoder.v1beta1.SegmentSettings
	(*Encryption)(nil),                         // 21: google.cloud.video.transcoder.v1beta1.Encryption
	(*Progress)(nil),                           // 22: google.cloud.video.transcoder.v1beta1.Progress
	(*FailureDetail)(nil),                      // 23: google.cloud.video.transcoder.v1beta1.FailureDetail
	(*Job_OriginUri)(nil),                      // 24: google.cloud.video.transcoder.v1beta1.Job.OriginUri
	(*Overlay_NormalizedCoordinate)(nil),       // 25: google.cloud.video.transcoder.v1beta1.Overlay.NormalizedCoordinate
	(*Overlay_Image)(nil),                      // 26: google.cloud.video.transcoder.v1beta1.Overlay.Image
	(*Overlay_AnimationStatic)(nil),            // 27: google.cloud.video.transcoder.v1beta1.Overlay.AnimationStatic
	(*Overlay_AnimationFade)(nil),              // 28: google.cloud.video.transcoder.v1beta1.Overlay.AnimationFade
	(*Overlay_AnimationEnd)(nil),               // 29: google.cloud.video.transcoder.v1beta1.Overlay.AnimationEnd
	(*Overlay_Animation)(nil),                  // 30: google.cloud.video.transcoder.v1beta1.Overlay.Animation
	(*PreprocessingConfig_Color)(nil),          // 31: google.cloud.video.transcoder.v1beta1.PreprocessingConfig.Color
	(*PreprocessingConfig_Denoise)(nil),        // 32: google.cloud.video.transcoder.v1beta1.PreprocessingConfig.Denoise
	(*PreprocessingConfig_Deblock)(nil),        // 33: google.cloud.video.transcoder.v1beta1.PreprocessingConfig.Deblock
	(*PreprocessingConfig_Audio)(nil),          // 34: google.cloud.video.transcoder.v1beta1.PreprocessingConfig.Audio
	(*AudioStream_AudioAtom)(nil),              // 35: google.cloud.video.transcoder.v1beta1.AudioStream.AudioAtom
	(*AudioStream_AudioAtom_AudioChannel)(nil), // 36: google.cloud.video.transcoder.v1beta1.AudioStream.AudioAtom.AudioChannel
	(*AudioStream_AudioAtom_AudioChannel_AudioChannelInput)(nil), // 37: google.cloud.video.transcoder.v1beta1.AudioStream.AudioAtom.AudioChannel.AudioChannelInput
	(*TextStream_TextAtom)(nil),                                  // 38: google.cloud.video.transcoder.v1beta1.TextStream.TextAtom
	(*TextStream_TextAtom_TextInput)(nil),                        // 39: google.cloud.video.transcoder.v1beta1.TextStream.TextAtom.TextInput
	(*Encryption_Aes128Encryption)(nil),                          // 40: google.cloud.video.transcoder.v1beta1.Encryption.Aes128Encryption
	(*Encryption_SampleAesEncryption)(nil),                       // 41: google.cloud.video.transcoder.v1beta1.Encryption.SampleAesEncryption
	(*Encryption_MpegCommonEncryption)(nil),                      // 42: google.cloud.video.transcoder.v1beta1.Encryption.MpegCommonEncryption
	(*timestamppb.Timestamp)(nil),                                // 43: google.protobuf.Timestamp
	(*durationpb.Duration)(nil),                                  // 44: google.protobuf.Duration
}
var file_google_cloud_video_transcoder_v1beta1_resources_proto_depIdxs = []int32{
	5,  // 0: google.cloud.video.transcoder.v1beta1.Job.config:type_name -> google.cloud.video.transcoder.v1beta1.JobConfig
	24, // 1: google.cloud.video.transcoder.v1beta1.Job.origin_uri:type_name -> google.cloud.video.transcoder.v1beta1.Job.OriginUri
	0,  // 2: google.cloud.video.transcoder.v1beta1.Job.state:type_name -> google.cloud.video.transcoder.v1beta1.Job.ProcessingState
	22, // 3: google.cloud.video.transcoder.v1beta1.Job.progress:type_name -> google.cloud.video.transcoder.v1beta1.Progress
	23, // 4: google.cloud.video.transcoder.v1beta1.Job.failure_details:type_name -> google.cloud.video.transcoder.v1beta1.FailureDetail
	43, // 5: google.cloud.video.transcoder.v1beta1.Job.create_time:type_name -> google.protobuf.Timestamp
	43, // 6: google.cloud.video.transcoder.v1beta1.Job.start_time:type_name -> google.protobuf.Timestamp
	43, // 7: google.cloud.video.transcoder.v1beta1.Job.end_time:type_name -> google.protobuf.Timestamp
	5,  // 8: google.cloud.video.transcoder.v1beta1.JobTemplate.config:type_name -> google.cloud.video.transcoder.v1beta1.JobConfig
	6,  // 9: google.cloud.video.transcoder.v1beta1.JobConfig.inputs:type_name -> google.cloud.video.transcoder.v1beta1.Input
	8,  // 10: google.cloud.video.transcoder.v1beta1.JobConfig.edit_list:type_name -> google.cloud.video.transcoder.v1beta1.EditAtom
	10, // 11: google.cloud.video.transcoder.v1beta1.JobConfig.elementary_streams:type_name -> google.cloud.video.transcoder.v1beta1.ElementaryStream
	11, // 12: google.cloud.video.transcoder.v1beta1.JobConfig.mux_streams:type_name -> google.cloud.video.transcoder.v1beta1.MuxStream
	12, // 13: google.cloud.video.transcoder.v1beta1.JobConfig.manifests:type_name -> google.cloud.video.transcoder.v1beta1.Manifest
	7,  // 14: google.cloud.video.transcoder.v1beta1.JobConfig.output:type_name -> google.cloud.video.transcoder.v1beta1.Output
	9,  // 15: google.cloud.video.transcoder.v1beta1.JobConfig.ad_breaks:type_name -> google.cloud.video.transcoder.v1beta1.AdBreak
	13, // 16: google.cloud.video.transcoder.v1beta1.JobConfig.pubsub_destination:type_name -> google.cloud.video.transcoder.v1beta1.PubsubDestination
	14, // 17: google.cloud.video.transcoder.v1beta1.JobConfig.sprite_sheets:type_name -> google.cloud.video.transcoder.v1beta1.SpriteSheet
	15, // 18: google.cloud.video.transcoder.v1beta1.JobConfig.overlays:type_name -> google.cloud.video.transcoder.v1beta1.Overlay
	16, // 19: google.cloud.video.transcoder.v1beta1.Input.preprocessing_config:type_name -> google.cloud.video.transcoder.v1beta1.PreprocessingConfig
	44, // 20: google.cloud.video.transcoder.v1beta1.EditAtom.end_time_offset:type_name -> google.protobuf.Duration
	44, // 21: google.cloud.video.transcoder.v1beta1.EditAtom.start_time_offset:type_name -> google.protobuf.Duration
	44, // 22: google.cloud.video.transcoder.v1beta1.AdBreak.start_time_offset:type_name -> google.protobuf.Duration
	17, // 23: google.cloud.video.transcoder.v1beta1.ElementaryStream.video_stream:type_name -> google.cloud.video.transcoder.v1beta1.VideoStream
	18, // 24: google.cloud.video.transcoder.v1beta1.ElementaryStream.audio_stream:type_name -> google.cloud.video.transcoder.v1beta1.AudioStream
	19, // 25: google.cloud.video.transcoder.v1beta1.ElementaryStream.text_stream:type_name -> google.cloud.video.transcoder.v1beta1.TextStream
	20, // 26: google.cloud.video.transcoder.v1beta1.MuxStream.segment_settings:type_name -> google.cloud.video.transcoder.v1beta1.SegmentSettings
	21, // 27: google.cloud.video.transcoder.v1beta1.MuxStream.encryption:type_name -> google.cloud.video.transcoder.v1beta1.Encryption
	1,  // 28: google.cloud.video.transcoder.v1beta1.Manifest.type:type_name -> google.cloud.video.transcoder.v1beta1.Manifest.ManifestType
	44, // 29: google.cloud.video.transcoder.v1beta1.SpriteSheet.start_time_offset:type_name -> google.protobuf.Duration
	44, // 30: google.cloud.video.transcoder.v1beta1.SpriteSheet.end_time_offset:type_name -> google.protobuf.Duration
	44, // 31: google.cloud.video.transcoder.v1beta1.SpriteSheet.interval:type_name -> google.protobuf.Duration
	26, // 32: google.cloud.video.transcoder.v1beta1.Overlay.image:type_name -> google.cloud.video.transcoder.v1beta1.Overlay.Image
	30, // 33: google.cloud.video.transcoder.v1beta1.Overlay.animations:type_name -> google.cloud.video.transcoder.v1beta1.Overlay.Animation
	31, // 34: google.cloud.video.transcoder.v1beta1.PreprocessingConfig.color:type_name -> google.cloud.video.transcoder.v1beta1.PreprocessingConfig.Color
	32, // 35: google.cloud.video.transcoder.v1beta1.PreprocessingConfig.denoise:type_name -> google.cloud.video.transcoder.v1beta1.PreprocessingConfig.Denoise
	33, // 36: google.cloud.video.transcoder.v1beta1.PreprocessingConfig.deblock:type_name -> google.cloud.video.transcoder.v1beta1.PreprocessingConfig.Deblock
	34, // 37: google.cloud.video.transcoder.v1beta1.PreprocessingConfig.audio:type_name -> google.cloud.video.transcoder.v1beta1.PreprocessingConfig.Audio
	44, // 38: google.cloud.video.transcoder.v1beta1.VideoStream.gop_duration:type_name -> google.protobuf.Duration
	35, // 39: google.cloud.video.transcoder.v1beta1.AudioStream.mapping:type_name -> google.cloud.video.transcoder.v1beta1.AudioStream.AudioAtom
	38, // 40: google.cloud.video.transcoder.v1beta1.TextStream.mapping:type_name -> google.cloud.video.transcoder.v1beta1.TextStream.TextAtom
	44, // 41: google.cloud.video.transcoder.v1beta1.SegmentSettings.segment_duration:type_name -> google.protobuf.Duration
	40, // 42: google.cloud.video.transcoder.v1beta1.Encryption.aes_128:type_name -> google.cloud.video.transcoder.v1beta1.Encryption.Aes128Encryption
	41, // 43: google.cloud.video.transcoder.v1beta1.Encryption.sample_aes:type_name -> google.cloud.video.transcoder.v1beta1.Encryption.SampleAesEncryption
	42, // 44: google.cloud.video.transcoder.v1beta1.Encryption.mpeg_cenc:type_name -> google.cloud.video.transcoder.v1beta1.Encryption.MpegCommonEncryption
	25, // 45: google.cloud.video.transcoder.v1beta1.Overlay.Image.resolution:type_name -> google.cloud.video.transcoder.v1beta1.Overlay.NormalizedCoordinate
	25, // 46: google.cloud.video.transcoder.v1beta1.Overlay.AnimationStatic.xy:type_name -> google.cloud.video.transcoder.v1beta1.Overlay.NormalizedCoordinate
	44, // 47: google.cloud.video.transcoder.v1beta1.Overlay.AnimationStatic.start_time_offset:type_name -> google.protobuf.Duration
	2,  // 48: google.cloud.video.transcoder.v1beta1.Overlay.AnimationFade.fade_type:type_name -> google.cloud.video.transcoder.v1beta1.Overlay.FadeType
	25, // 49: google.cloud.video.transcoder.v1beta1.Overlay.AnimationFade.xy:type_name -> google.cloud.video.transcoder.v1beta1.Overlay.NormalizedCoordinate
	44, // 50: google.cloud.video.transcoder.v1beta1.Overlay.AnimationFade.start_time_offset:type_name -> google.protobuf.Duration
	44, // 51: google.cloud.video.transcoder.v1beta1.Overlay.AnimationFade.end_time_offset:type_name -> google.protobuf.Duration
	44, // 52: google.cloud.video.transcoder.v1beta1.Overlay.AnimationEnd.start_time_offset:type_name -> google.protobuf.Duration
	27, // 53: google.cloud.video.transcoder.v1beta1.Overlay.Animation.animation_static:type_name -> google.cloud.video.transcoder.v1beta1.Overlay.AnimationStatic
	28, // 54: google.cloud.video.transcoder.v1beta1.Overlay.Animation.animation_fade:type_name -> google.cloud.video.transcoder.v1beta1.Overlay.AnimationFade
	29, // 55: google.cloud.video.transcoder.v1beta1.Overlay.Animation.animation_end:type_name -> google.cloud.video.transcoder.v1beta1.Overlay.AnimationEnd
	36, // 56: google.cloud.video.transcoder.v1beta1.AudioStream.AudioAtom.channels:type_name -> google.cloud.video.transcoder.v1beta1.AudioStream.AudioAtom.AudioChannel
	37, // 57: google.cloud.video.transcoder.v1beta1.AudioStream.AudioAtom.AudioChannel.inputs:type_name -> google.cloud.video.transcoder.v1beta1.AudioStream.AudioAtom.AudioChannel.AudioChannelInput
	39, // 58: google.cloud.video.transcoder.v1beta1.TextStream.TextAtom.inputs:type_name -> google.cloud.video.transcoder.v1beta1.TextStream.TextAtom.TextInput
	59, // [59:59] is the sub-list for method output_type
	59, // [59:59] is the sub-list for method input_type
	59, // [59:59] is the sub-list for extension type_name
	59, // [59:59] is the sub-list for extension extendee
	0,  // [0:59] is the sub-list for field type_name
}

func init() { file_google_cloud_video_transcoder_v1beta1_resources_proto_init() }
func file_google_cloud_video_transcoder_v1beta1_resources_proto_init() {
	if File_google_cloud_video_transcoder_v1beta1_resources_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Job); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JobTemplate); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JobConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Input); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Output); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EditAtom); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AdBreak); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ElementaryStream); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MuxStream); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Manifest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PubsubDestination); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SpriteSheet); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Overlay); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PreprocessingConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VideoStream); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AudioStream); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TextStream); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SegmentSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Encryption); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Progress); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FailureDetail); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Job_OriginUri); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Overlay_NormalizedCoordinate); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Overlay_Image); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Overlay_AnimationStatic); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Overlay_AnimationFade); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Overlay_AnimationEnd); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Overlay_Animation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PreprocessingConfig_Color); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PreprocessingConfig_Denoise); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PreprocessingConfig_Deblock); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PreprocessingConfig_Audio); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AudioStream_AudioAtom); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AudioStream_AudioAtom_AudioChannel); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AudioStream_AudioAtom_AudioChannel_AudioChannelInput); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TextStream_TextAtom); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TextStream_TextAtom_TextInput); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Encryption_Aes128Encryption); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Encryption_SampleAesEncryption); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Encryption_MpegCommonEncryption); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*Job_TemplateId)(nil),
		(*Job_Config)(nil),
	}
	file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[7].OneofWrappers = []interface{}{
		(*ElementaryStream_VideoStream)(nil),
		(*ElementaryStream_AudioStream)(nil),
		(*ElementaryStream_TextStream)(nil),
	}
	file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[11].OneofWrappers = []interface{}{
		(*SpriteSheet_TotalCount)(nil),
		(*SpriteSheet_Interval)(nil),
	}
	file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[14].OneofWrappers = []interface{}{
		(*VideoStream_GopFrameCount)(nil),
		(*VideoStream_GopDuration)(nil),
	}
	file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[18].OneofWrappers = []interface{}{
		(*Encryption_Aes_128)(nil),
		(*Encryption_SampleAes)(nil),
		(*Encryption_MpegCenc)(nil),
	}
	file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes[27].OneofWrappers = []interface{}{
		(*Overlay_Animation_AnimationStatic)(nil),
		(*Overlay_Animation_AnimationFade)(nil),
		(*Overlay_Animation_AnimationEnd)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_video_transcoder_v1beta1_resources_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   40,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_video_transcoder_v1beta1_resources_proto_goTypes,
		DependencyIndexes: file_google_cloud_video_transcoder_v1beta1_resources_proto_depIdxs,
		EnumInfos:         file_google_cloud_video_transcoder_v1beta1_resources_proto_enumTypes,
		MessageInfos:      file_google_cloud_video_transcoder_v1beta1_resources_proto_msgTypes,
	}.Build()
	File_google_cloud_video_transcoder_v1beta1_resources_proto = out.File
	file_google_cloud_video_transcoder_v1beta1_resources_proto_rawDesc = nil
	file_google_cloud_video_transcoder_v1beta1_resources_proto_goTypes = nil
	file_google_cloud_video_transcoder_v1beta1_resources_proto_depIdxs = nil
}
