/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"time"

	v1alpha1 "github.com/kubernetes-sigs/kube-storage-version-migrator/pkg/apis/migration/v1alpha1"
	scheme "github.com/kubernetes-sigs/kube-storage-version-migrator/pkg/clients/clientset/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// StorageStatesGetter has a method to return a StorageStateInterface.
// A group's client should implement this interface.
type StorageStatesGetter interface {
	StorageStates() StorageStateInterface
}

// StorageStateInterface has methods to work with StorageState resources.
type StorageStateInterface interface {
	Create(*v1alpha1.StorageState) (*v1alpha1.StorageState, error)
	Update(*v1alpha1.StorageState) (*v1alpha1.StorageState, error)
	UpdateStatus(*v1alpha1.StorageState) (*v1alpha1.StorageState, error)
	Delete(name string, options *v1.DeleteOptions) error
	DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error
	Get(name string, options v1.GetOptions) (*v1alpha1.StorageState, error)
	List(opts v1.ListOptions) (*v1alpha1.StorageStateList, error)
	Watch(opts v1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.StorageState, err error)
	StorageStateExpansion
}

// storageStates implements StorageStateInterface
type storageStates struct {
	client rest.Interface
}

// newStorageStates returns a StorageStates
func newStorageStates(c *MigrationV1alpha1Client) *storageStates {
	return &storageStates{
		client: c.RESTClient(),
	}
}

// Get takes name of the storageState, and returns the corresponding storageState object, and an error if there is any.
func (c *storageStates) Get(name string, options v1.GetOptions) (result *v1alpha1.StorageState, err error) {
	result = &v1alpha1.StorageState{}
	err = c.client.Get().
		Resource("storagestates").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of StorageStates that match those selectors.
func (c *storageStates) List(opts v1.ListOptions) (result *v1alpha1.StorageStateList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.StorageStateList{}
	err = c.client.Get().
		Resource("storagestates").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested storageStates.
func (c *storageStates) Watch(opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("storagestates").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch()
}

// Create takes the representation of a storageState and creates it.  Returns the server's representation of the storageState, and an error, if there is any.
func (c *storageStates) Create(storageState *v1alpha1.StorageState) (result *v1alpha1.StorageState, err error) {
	result = &v1alpha1.StorageState{}
	err = c.client.Post().
		Resource("storagestates").
		Body(storageState).
		Do().
		Into(result)
	return
}

// Update takes the representation of a storageState and updates it. Returns the server's representation of the storageState, and an error, if there is any.
func (c *storageStates) Update(storageState *v1alpha1.StorageState) (result *v1alpha1.StorageState, err error) {
	result = &v1alpha1.StorageState{}
	err = c.client.Put().
		Resource("storagestates").
		Name(storageState.Name).
		Body(storageState).
		Do().
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().

func (c *storageStates) UpdateStatus(storageState *v1alpha1.StorageState) (result *v1alpha1.StorageState, err error) {
	result = &v1alpha1.StorageState{}
	err = c.client.Put().
		Resource("storagestates").
		Name(storageState.Name).
		SubResource("status").
		Body(storageState).
		Do().
		Into(result)
	return
}

// Delete takes name of the storageState and deletes it. Returns an error if one occurs.
func (c *storageStates) Delete(name string, options *v1.DeleteOptions) error {
	return c.client.Delete().
		Resource("storagestates").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *storageStates) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	var timeout time.Duration
	if listOptions.TimeoutSeconds != nil {
		timeout = time.Duration(*listOptions.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("storagestates").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Timeout(timeout).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched storageState.
func (c *storageStates) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.StorageState, err error) {
	result = &v1alpha1.StorageState{}
	err = c.client.Patch(pt).
		Resource("storagestates").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
