import * as React from 'react';
import { TextInputTypes } from '@patternfly/react-core';
import { InputField } from '@console/shared';
import FormSection from '@console/dev-console/src/components/import/section/FormSection';

interface PingSourceSectionProps {
  title: string;
}

const PingSourceSection: React.FC<PingSourceSectionProps> = ({ title }) => (
  <FormSection title={title} extraMargin>
    <InputField
      type={TextInputTypes.text}
      name="data.pingsource.jsonData"
      label="Data"
      helpText="The data posted to the target function"
    />
    <InputField
      type={TextInputTypes.text}
      name="data.pingsource.schedule"
      label="Schedule"
      helpText="Schedule is described using the unix-cron string format (* * * * *)"
      required
    />
  </FormSection>
);

export default PingSourceSection;
