/* @(#)netdb.h	2.1 88/07/29 3.9 RPCSRC */
/*
 * Copyright (c) 2010, Oracle America, Inc.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above
 *       copyright notice, this list of conditions and the following
 *       disclaimer in the documentation and/or other materials
 *       provided with the distribution.
 *     * Neither the name of the "Oracle America, Inc." nor the names of its
 *       contributors may be used to endorse or promote products derived
 *       from this software without specific prior written permission.
 *
 *   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 *   COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *   INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 *   DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 *   GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 *   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *   WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *   OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/* Cleaned up for GNU C library roland@gnu.ai.mit.edu:
   added multiple inclusion protection and use of <sys/cdefs.h>.
   In GNU this file is #include'd by <netdb.h>.  */

#ifndef _RPC_NETDB_H
#define _RPC_NETDB_H	1

#include <features.h>

#define __need_size_t
#include <stddef.h>

__BEGIN_DECLS struct rpcent {
	char *r_name;		/* Name of server for this rpc program.  */
	char **r_aliases;	/* Alias list.  */
	int r_number;		/* RPC program number.  */
};

extern void setrpcent(int __stayopen) __THROW;
extern void endrpcent(void) __THROW;
extern struct rpcent *getrpcbyname(const char *__name) __THROW;
extern struct rpcent *getrpcbynumber(int __number) __THROW;
extern struct rpcent *getrpcent(void) __THROW;

#ifdef __USE_MISC
extern int getrpcbyname_r(const char *__name, struct rpcent *__result_buf, char *__buffer, size_t __buflen, struct rpcent **__result) __THROW;

extern int getrpcbynumber_r(int __number, struct rpcent *__result_buf, char *__buffer, size_t __buflen, struct rpcent **__result) __THROW;

extern int getrpcent_r(struct rpcent *__result_buf, char *__buffer, size_t __buflen, struct rpcent **__result) __THROW;
#endif

__END_DECLS
#endif				/* rpc/netdb.h */
