// DO NOT EDIT.
//
// Generated by the Swift generator plugin for the protocol buffer compiler.
// Source: github.com/googleapis/gnostic/plugins/plugin.proto
//
// For information on using the generated types, please see the documenation:
//   https://github.com/apple/swift-protobuf/

// Copyright 2017 Google Inc. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// gnostic can be extended with plugins.  
// A plugin is uset a program that reads a Request from stdin 
// and writes a Response to stdout.
//
// A plugin executable needs only to be placed somewhere in the path.  The
// plugin should be named "gnostic_$NAME", and will then be used when the
// flag "--${NAME}_out" is passed to gnostic.

import Foundation
import SwiftProtobuf

// If the compiler emits an error on this type, it is because this file
// was generated by a version of the `protoc` Swift plug-in that is
// incompatible with the version of SwiftProtobuf to which you are linking.
// Please ensure that your are building against the same version of the API
// that was used to generate this file.
fileprivate struct _GeneratedWithProtocGenSwiftVersion: SwiftProtobuf.ProtobufAPIVersionCheck {
  struct _2: SwiftProtobuf.ProtobufAPIVersion_2 {}
  typealias Version = _2
}

/// The version number of gnostic.
public struct Gnostic_Plugin_V1_Version: SwiftProtobuf.Message {
  public static let protoMessageName: String = _protobuf_package + ".Version"

  public var major: Int32 = 0

  public var minor: Int32 = 0

  public var patch: Int32 = 0

  /// A suffix for alpha, beta or rc release, e.g., "alpha-1", "rc2". It should
  /// be empty for mainline stable releases.
  public var suffix: String = String()

  public var unknownFields = SwiftProtobuf.UnknownStorage()

  public init() {}

  /// Used by the decoding initializers in the SwiftProtobuf library, not generally
  /// used directly. `init(serializedData:)`, `init(jsonUTF8Data:)`, and other decoding
  /// initializers are defined in the SwiftProtobuf library. See the Message and
  /// Message+*Additions` files.
  public mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      switch fieldNumber {
      case 1: try decoder.decodeSingularInt32Field(value: &self.major)
      case 2: try decoder.decodeSingularInt32Field(value: &self.minor)
      case 3: try decoder.decodeSingularInt32Field(value: &self.patch)
      case 4: try decoder.decodeSingularStringField(value: &self.suffix)
      default: break
      }
    }
  }

  /// Used by the encoding methods of the SwiftProtobuf library, not generally
  /// used directly. `Message.serializedData()`, `Message.jsonUTF8Data()`, and
  /// other serializer methods are defined in the SwiftProtobuf library. See the
  /// `Message` and `Message+*Additions` files.
  public func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.major != 0 {
      try visitor.visitSingularInt32Field(value: self.major, fieldNumber: 1)
    }
    if self.minor != 0 {
      try visitor.visitSingularInt32Field(value: self.minor, fieldNumber: 2)
    }
    if self.patch != 0 {
      try visitor.visitSingularInt32Field(value: self.patch, fieldNumber: 3)
    }
    if !self.suffix.isEmpty {
      try visitor.visitSingularStringField(value: self.suffix, fieldNumber: 4)
    }
    try unknownFields.traverse(visitor: &visitor)
  }
}

/// A parameter passed to the plugin from (or through) gnostic.
public struct Gnostic_Plugin_V1_Parameter: SwiftProtobuf.Message {
  public static let protoMessageName: String = _protobuf_package + ".Parameter"

  /// The name of the parameter as specified in the option string
  public var name: String = String()

  /// The parameter value as specified in the option string
  public var value: String = String()

  public var unknownFields = SwiftProtobuf.UnknownStorage()

  public init() {}

  /// Used by the decoding initializers in the SwiftProtobuf library, not generally
  /// used directly. `init(serializedData:)`, `init(jsonUTF8Data:)`, and other decoding
  /// initializers are defined in the SwiftProtobuf library. See the Message and
  /// Message+*Additions` files.
  public mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      switch fieldNumber {
      case 1: try decoder.decodeSingularStringField(value: &self.name)
      case 2: try decoder.decodeSingularStringField(value: &self.value)
      default: break
      }
    }
  }

  /// Used by the encoding methods of the SwiftProtobuf library, not generally
  /// used directly. `Message.serializedData()`, `Message.jsonUTF8Data()`, and
  /// other serializer methods are defined in the SwiftProtobuf library. See the
  /// `Message` and `Message+*Additions` files.
  public func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.name.isEmpty {
      try visitor.visitSingularStringField(value: self.name, fieldNumber: 1)
    }
    if !self.value.isEmpty {
      try visitor.visitSingularStringField(value: self.value, fieldNumber: 2)
    }
    try unknownFields.traverse(visitor: &visitor)
  }
}

/// An encoded Request is written to the plugin's stdin.
public struct Gnostic_Plugin_V1_Request: SwiftProtobuf.Message {
  public static let protoMessageName: String = _protobuf_package + ".Request"

  /// filename or URL of the original source document
  public var sourceName: String {
    get {return _storage._sourceName}
    set {_uniqueStorage()._sourceName = newValue}
  }

  /// Output path specified in the plugin invocation.
  public var outputPath: String {
    get {return _storage._outputPath}
    set {_uniqueStorage()._outputPath = newValue}
  }

  /// Plugin parameters parsed from the invocation string.
  public var parameters: [Gnostic_Plugin_V1_Parameter] {
    get {return _storage._parameters}
    set {_uniqueStorage()._parameters = newValue}
  }

  /// The version number of gnostic.
  public var compilerVersion: Gnostic_Plugin_V1_Version {
    get {return _storage._compilerVersion ?? Gnostic_Plugin_V1_Version()}
    set {_uniqueStorage()._compilerVersion = newValue}
  }
  /// Returns true if `compilerVersion` has been explicitly set.
  public var hasCompilerVersion: Bool {return _storage._compilerVersion != nil}
  /// Clears the value of `compilerVersion`. Subsequent reads from it will return its default value.
  public mutating func clearCompilerVersion() {_storage._compilerVersion = nil}

  /// OpenAPI v2 API representation
  public var openapi2: Openapi_V2_Document {
    get {return _storage._openapi2 ?? Openapi_V2_Document()}
    set {_uniqueStorage()._openapi2 = newValue}
  }
  /// Returns true if `openapi2` has been explicitly set.
  public var hasOpenapi2: Bool {return _storage._openapi2 != nil}
  /// Clears the value of `openapi2`. Subsequent reads from it will return its default value.
  public mutating func clearOpenapi2() {_storage._openapi2 = nil}

  /// OpenAPI v3 API representation
  public var openapi3: Openapi_V3_Document {
    get {return _storage._openapi3 ?? Openapi_V3_Document()}
    set {_uniqueStorage()._openapi3 = newValue}
  }
  /// Returns true if `openapi3` has been explicitly set.
  public var hasOpenapi3: Bool {return _storage._openapi3 != nil}
  /// Clears the value of `openapi3`. Subsequent reads from it will return its default value.
  public mutating func clearOpenapi3() {_storage._openapi3 = nil}

  /// Discovery API representation
  public var discovery: Discovery_V1_Document {
    get {return _storage._discovery ?? Discovery_V1_Document()}
    set {_uniqueStorage()._discovery = newValue}
  }
  /// Returns true if `discovery` has been explicitly set.
  public var hasDiscovery: Bool {return _storage._discovery != nil}
  /// Clears the value of `discovery`. Subsequent reads from it will return its default value.
  public mutating func clearDiscovery() {_storage._discovery = nil}

  /// generated code surface representation
  public var surface: Surface_V1_Model {
    get {return _storage._surface ?? Surface_V1_Model()}
    set {_uniqueStorage()._surface = newValue}
  }
  /// Returns true if `surface` has been explicitly set.
  public var hasSurface: Bool {return _storage._surface != nil}
  /// Clears the value of `surface`. Subsequent reads from it will return its default value.
  public mutating func clearSurface() {_storage._surface = nil}

  public var unknownFields = SwiftProtobuf.UnknownStorage()

  public init() {}

  /// Used by the decoding initializers in the SwiftProtobuf library, not generally
  /// used directly. `init(serializedData:)`, `init(jsonUTF8Data:)`, and other decoding
  /// initializers are defined in the SwiftProtobuf library. See the Message and
  /// Message+*Additions` files.
  public mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    _ = _uniqueStorage()
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      while let fieldNumber = try decoder.nextFieldNumber() {
        switch fieldNumber {
        case 1: try decoder.decodeSingularStringField(value: &_storage._sourceName)
        case 2: try decoder.decodeSingularStringField(value: &_storage._outputPath)
        case 3: try decoder.decodeRepeatedMessageField(value: &_storage._parameters)
        case 4: try decoder.decodeSingularMessageField(value: &_storage._compilerVersion)
        case 5: try decoder.decodeSingularMessageField(value: &_storage._openapi2)
        case 6: try decoder.decodeSingularMessageField(value: &_storage._openapi3)
        case 7: try decoder.decodeSingularMessageField(value: &_storage._discovery)
        case 8: try decoder.decodeSingularMessageField(value: &_storage._surface)
        default: break
        }
      }
    }
  }

  /// Used by the encoding methods of the SwiftProtobuf library, not generally
  /// used directly. `Message.serializedData()`, `Message.jsonUTF8Data()`, and
  /// other serializer methods are defined in the SwiftProtobuf library. See the
  /// `Message` and `Message+*Additions` files.
  public func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      if !_storage._sourceName.isEmpty {
        try visitor.visitSingularStringField(value: _storage._sourceName, fieldNumber: 1)
      }
      if !_storage._outputPath.isEmpty {
        try visitor.visitSingularStringField(value: _storage._outputPath, fieldNumber: 2)
      }
      if !_storage._parameters.isEmpty {
        try visitor.visitRepeatedMessageField(value: _storage._parameters, fieldNumber: 3)
      }
      if let v = _storage._compilerVersion {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 4)
      }
      if let v = _storage._openapi2 {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 5)
      }
      if let v = _storage._openapi3 {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 6)
      }
      if let v = _storage._discovery {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 7)
      }
      if let v = _storage._surface {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 8)
      }
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  fileprivate var _storage = _StorageClass.defaultInstance
}

/// The plugin writes an encoded Response to stdout.
public struct Gnostic_Plugin_V1_Response: SwiftProtobuf.Message {
  public static let protoMessageName: String = _protobuf_package + ".Response"

  /// Error message.  If non-empty, the plugin failed. 
  /// The plugin process should exit with status code zero 
  /// even if it reports an error in this way.
  ///
  /// This should be used to indicate errors which prevent the plugin from 
  /// operating as intended.  Errors which indicate a problem in openapic 
  /// itself -- such as the input Document being unparseable -- should be 
  /// reported by writing a message to stderr and exiting with a non-zero 
  /// status code.
  public var errors: [String] = []

  /// file output, each file will be written by openapic to an appropriate location.
  public var files: [Gnostic_Plugin_V1_File] = []

  public var unknownFields = SwiftProtobuf.UnknownStorage()

  public init() {}

  /// Used by the decoding initializers in the SwiftProtobuf library, not generally
  /// used directly. `init(serializedData:)`, `init(jsonUTF8Data:)`, and other decoding
  /// initializers are defined in the SwiftProtobuf library. See the Message and
  /// Message+*Additions` files.
  public mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      switch fieldNumber {
      case 1: try decoder.decodeRepeatedStringField(value: &self.errors)
      case 2: try decoder.decodeRepeatedMessageField(value: &self.files)
      default: break
      }
    }
  }

  /// Used by the encoding methods of the SwiftProtobuf library, not generally
  /// used directly. `Message.serializedData()`, `Message.jsonUTF8Data()`, and
  /// other serializer methods are defined in the SwiftProtobuf library. See the
  /// `Message` and `Message+*Additions` files.
  public func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.errors.isEmpty {
      try visitor.visitRepeatedStringField(value: self.errors, fieldNumber: 1)
    }
    if !self.files.isEmpty {
      try visitor.visitRepeatedMessageField(value: self.files, fieldNumber: 2)
    }
    try unknownFields.traverse(visitor: &visitor)
  }
}

/// File describes a file generated by a plugin.
public struct Gnostic_Plugin_V1_File: SwiftProtobuf.Message {
  public static let protoMessageName: String = _protobuf_package + ".File"

  /// name of the file
  public var name: String = String()

  /// data to be written to the file
  public var data: Data = SwiftProtobuf.Internal.emptyData

  public var unknownFields = SwiftProtobuf.UnknownStorage()

  public init() {}

  /// Used by the decoding initializers in the SwiftProtobuf library, not generally
  /// used directly. `init(serializedData:)`, `init(jsonUTF8Data:)`, and other decoding
  /// initializers are defined in the SwiftProtobuf library. See the Message and
  /// Message+*Additions` files.
  public mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      switch fieldNumber {
      case 1: try decoder.decodeSingularStringField(value: &self.name)
      case 2: try decoder.decodeSingularBytesField(value: &self.data)
      default: break
      }
    }
  }

  /// Used by the encoding methods of the SwiftProtobuf library, not generally
  /// used directly. `Message.serializedData()`, `Message.jsonUTF8Data()`, and
  /// other serializer methods are defined in the SwiftProtobuf library. See the
  /// `Message` and `Message+*Additions` files.
  public func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.name.isEmpty {
      try visitor.visitSingularStringField(value: self.name, fieldNumber: 1)
    }
    if !self.data.isEmpty {
      try visitor.visitSingularBytesField(value: self.data, fieldNumber: 2)
    }
    try unknownFields.traverse(visitor: &visitor)
  }
}

// MARK: - Code below here is support for the SwiftProtobuf runtime.

fileprivate let _protobuf_package = "gnostic.plugin.v1"

extension Gnostic_Plugin_V1_Version: SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  public static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "major"),
    2: .same(proto: "minor"),
    3: .same(proto: "patch"),
    4: .same(proto: "suffix"),
  ]

  public func _protobuf_generated_isEqualTo(other: Gnostic_Plugin_V1_Version) -> Bool {
    if self.major != other.major {return false}
    if self.minor != other.minor {return false}
    if self.patch != other.patch {return false}
    if self.suffix != other.suffix {return false}
    if unknownFields != other.unknownFields {return false}
    return true
  }
}

extension Gnostic_Plugin_V1_Parameter: SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  public static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "name"),
    2: .same(proto: "value"),
  ]

  public func _protobuf_generated_isEqualTo(other: Gnostic_Plugin_V1_Parameter) -> Bool {
    if self.name != other.name {return false}
    if self.value != other.value {return false}
    if unknownFields != other.unknownFields {return false}
    return true
  }
}

extension Gnostic_Plugin_V1_Request: SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  public static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "source_name"),
    2: .standard(proto: "output_path"),
    3: .same(proto: "parameters"),
    4: .standard(proto: "compiler_version"),
    5: .same(proto: "openapi2"),
    6: .same(proto: "openapi3"),
    7: .same(proto: "discovery"),
    8: .same(proto: "surface"),
  ]

  fileprivate class _StorageClass {
    var _sourceName: String = String()
    var _outputPath: String = String()
    var _parameters: [Gnostic_Plugin_V1_Parameter] = []
    var _compilerVersion: Gnostic_Plugin_V1_Version? = nil
    var _openapi2: Openapi_V2_Document? = nil
    var _openapi3: Openapi_V3_Document? = nil
    var _discovery: Discovery_V1_Document? = nil
    var _surface: Surface_V1_Model? = nil

    static let defaultInstance = _StorageClass()

    private init() {}

    init(copying source: _StorageClass) {
      _sourceName = source._sourceName
      _outputPath = source._outputPath
      _parameters = source._parameters
      _compilerVersion = source._compilerVersion
      _openapi2 = source._openapi2
      _openapi3 = source._openapi3
      _discovery = source._discovery
      _surface = source._surface
    }
  }

  fileprivate mutating func _uniqueStorage() -> _StorageClass {
    if !isKnownUniquelyReferenced(&_storage) {
      _storage = _StorageClass(copying: _storage)
    }
    return _storage
  }

  public func _protobuf_generated_isEqualTo(other: Gnostic_Plugin_V1_Request) -> Bool {
    if _storage !== other._storage {
      let storagesAreEqual: Bool = withExtendedLifetime((_storage, other._storage)) { (_storage, other_storage) in
        if _storage._sourceName != other_storage._sourceName {return false}
        if _storage._outputPath != other_storage._outputPath {return false}
        if _storage._parameters != other_storage._parameters {return false}
        if _storage._compilerVersion != other_storage._compilerVersion {return false}
        if _storage._openapi2 != other_storage._openapi2 {return false}
        if _storage._openapi3 != other_storage._openapi3 {return false}
        if _storage._discovery != other_storage._discovery {return false}
        if _storage._surface != other_storage._surface {return false}
        return true
      }
      if !storagesAreEqual {return false}
    }
    if unknownFields != other.unknownFields {return false}
    return true
  }
}

extension Gnostic_Plugin_V1_Response: SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  public static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "errors"),
    2: .same(proto: "files"),
  ]

  public func _protobuf_generated_isEqualTo(other: Gnostic_Plugin_V1_Response) -> Bool {
    if self.errors != other.errors {return false}
    if self.files != other.files {return false}
    if unknownFields != other.unknownFields {return false}
    return true
  }
}

extension Gnostic_Plugin_V1_File: SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  public static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "name"),
    2: .same(proto: "data"),
  ]

  public func _protobuf_generated_isEqualTo(other: Gnostic_Plugin_V1_File) -> Bool {
    if self.name != other.name {return false}
    if self.data != other.data {return false}
    if unknownFields != other.unknownFields {return false}
    return true
  }
}
