package insights

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/monitor/mgmt/2017-05-01-preview/insights"

// AggregationType enumerates the values for aggregation type.
type AggregationType string

const (
	// Average ...
	Average AggregationType = "Average"
	// Count ...
	Count AggregationType = "Count"
	// Maximum ...
	Maximum AggregationType = "Maximum"
	// Minimum ...
	Minimum AggregationType = "Minimum"
	// None ...
	None AggregationType = "None"
	// Total ...
	Total AggregationType = "Total"
)

// PossibleAggregationTypeValues returns an array of possible values for the AggregationType const type.
func PossibleAggregationTypeValues() []AggregationType {
	return []AggregationType{Average, Count, Maximum, Minimum, None, Total}
}

// CategoryType enumerates the values for category type.
type CategoryType string

const (
	// Logs ...
	Logs CategoryType = "Logs"
	// Metrics ...
	Metrics CategoryType = "Metrics"
)

// PossibleCategoryTypeValues returns an array of possible values for the CategoryType const type.
func PossibleCategoryTypeValues() []CategoryType {
	return []CategoryType{Logs, Metrics}
}

// ComparisonOperationType enumerates the values for comparison operation type.
type ComparisonOperationType string

const (
	// Equals ...
	Equals ComparisonOperationType = "Equals"
	// GreaterThan ...
	GreaterThan ComparisonOperationType = "GreaterThan"
	// GreaterThanOrEqual ...
	GreaterThanOrEqual ComparisonOperationType = "GreaterThanOrEqual"
	// LessThan ...
	LessThan ComparisonOperationType = "LessThan"
	// LessThanOrEqual ...
	LessThanOrEqual ComparisonOperationType = "LessThanOrEqual"
	// NotEquals ...
	NotEquals ComparisonOperationType = "NotEquals"
)

// PossibleComparisonOperationTypeValues returns an array of possible values for the ComparisonOperationType const type.
func PossibleComparisonOperationTypeValues() []ComparisonOperationType {
	return []ComparisonOperationType{Equals, GreaterThan, GreaterThanOrEqual, LessThan, LessThanOrEqual, NotEquals}
}

// ConditionOperator enumerates the values for condition operator.
type ConditionOperator string

const (
	// ConditionOperatorGreaterThan ...
	ConditionOperatorGreaterThan ConditionOperator = "GreaterThan"
	// ConditionOperatorGreaterThanOrEqual ...
	ConditionOperatorGreaterThanOrEqual ConditionOperator = "GreaterThanOrEqual"
	// ConditionOperatorLessThan ...
	ConditionOperatorLessThan ConditionOperator = "LessThan"
	// ConditionOperatorLessThanOrEqual ...
	ConditionOperatorLessThanOrEqual ConditionOperator = "LessThanOrEqual"
)

// PossibleConditionOperatorValues returns an array of possible values for the ConditionOperator const type.
func PossibleConditionOperatorValues() []ConditionOperator {
	return []ConditionOperator{ConditionOperatorGreaterThan, ConditionOperatorGreaterThanOrEqual, ConditionOperatorLessThan, ConditionOperatorLessThanOrEqual}
}

// EventLevel enumerates the values for event level.
type EventLevel string

const (
	// Critical ...
	Critical EventLevel = "Critical"
	// Error ...
	Error EventLevel = "Error"
	// Informational ...
	Informational EventLevel = "Informational"
	// Verbose ...
	Verbose EventLevel = "Verbose"
	// Warning ...
	Warning EventLevel = "Warning"
)

// PossibleEventLevelValues returns an array of possible values for the EventLevel const type.
func PossibleEventLevelValues() []EventLevel {
	return []EventLevel{Critical, Error, Informational, Verbose, Warning}
}

// MetricStatisticType enumerates the values for metric statistic type.
type MetricStatisticType string

const (
	// MetricStatisticTypeAverage ...
	MetricStatisticTypeAverage MetricStatisticType = "Average"
	// MetricStatisticTypeMax ...
	MetricStatisticTypeMax MetricStatisticType = "Max"
	// MetricStatisticTypeMin ...
	MetricStatisticTypeMin MetricStatisticType = "Min"
	// MetricStatisticTypeSum ...
	MetricStatisticTypeSum MetricStatisticType = "Sum"
)

// PossibleMetricStatisticTypeValues returns an array of possible values for the MetricStatisticType const type.
func PossibleMetricStatisticTypeValues() []MetricStatisticType {
	return []MetricStatisticType{MetricStatisticTypeAverage, MetricStatisticTypeMax, MetricStatisticTypeMin, MetricStatisticTypeSum}
}

// OdataType enumerates the values for odata type.
type OdataType string

const (
	// OdataTypeMicrosoftAzureManagementInsightsModelsRuleManagementEventDataSource ...
	OdataTypeMicrosoftAzureManagementInsightsModelsRuleManagementEventDataSource OdataType = "Microsoft.Azure.Management.Insights.Models.RuleManagementEventDataSource"
	// OdataTypeMicrosoftAzureManagementInsightsModelsRuleMetricDataSource ...
	OdataTypeMicrosoftAzureManagementInsightsModelsRuleMetricDataSource OdataType = "Microsoft.Azure.Management.Insights.Models.RuleMetricDataSource"
	// OdataTypeRuleDataSource ...
	OdataTypeRuleDataSource OdataType = "RuleDataSource"
)

// PossibleOdataTypeValues returns an array of possible values for the OdataType const type.
func PossibleOdataTypeValues() []OdataType {
	return []OdataType{OdataTypeMicrosoftAzureManagementInsightsModelsRuleManagementEventDataSource, OdataTypeMicrosoftAzureManagementInsightsModelsRuleMetricDataSource, OdataTypeRuleDataSource}
}

// OdataTypeBasicRuleAction enumerates the values for odata type basic rule action.
type OdataTypeBasicRuleAction string

const (
	// OdataTypeMicrosoftAzureManagementInsightsModelsRuleEmailAction ...
	OdataTypeMicrosoftAzureManagementInsightsModelsRuleEmailAction OdataTypeBasicRuleAction = "Microsoft.Azure.Management.Insights.Models.RuleEmailAction"
	// OdataTypeMicrosoftAzureManagementInsightsModelsRuleWebhookAction ...
	OdataTypeMicrosoftAzureManagementInsightsModelsRuleWebhookAction OdataTypeBasicRuleAction = "Microsoft.Azure.Management.Insights.Models.RuleWebhookAction"
	// OdataTypeRuleAction ...
	OdataTypeRuleAction OdataTypeBasicRuleAction = "RuleAction"
)

// PossibleOdataTypeBasicRuleActionValues returns an array of possible values for the OdataTypeBasicRuleAction const type.
func PossibleOdataTypeBasicRuleActionValues() []OdataTypeBasicRuleAction {
	return []OdataTypeBasicRuleAction{OdataTypeMicrosoftAzureManagementInsightsModelsRuleEmailAction, OdataTypeMicrosoftAzureManagementInsightsModelsRuleWebhookAction, OdataTypeRuleAction}
}

// OdataTypeBasicRuleCondition enumerates the values for odata type basic rule condition.
type OdataTypeBasicRuleCondition string

const (
	// OdataTypeMicrosoftAzureManagementInsightsModelsLocationThresholdRuleCondition ...
	OdataTypeMicrosoftAzureManagementInsightsModelsLocationThresholdRuleCondition OdataTypeBasicRuleCondition = "Microsoft.Azure.Management.Insights.Models.LocationThresholdRuleCondition"
	// OdataTypeMicrosoftAzureManagementInsightsModelsManagementEventRuleCondition ...
	OdataTypeMicrosoftAzureManagementInsightsModelsManagementEventRuleCondition OdataTypeBasicRuleCondition = "Microsoft.Azure.Management.Insights.Models.ManagementEventRuleCondition"
	// OdataTypeMicrosoftAzureManagementInsightsModelsThresholdRuleCondition ...
	OdataTypeMicrosoftAzureManagementInsightsModelsThresholdRuleCondition OdataTypeBasicRuleCondition = "Microsoft.Azure.Management.Insights.Models.ThresholdRuleCondition"
	// OdataTypeRuleCondition ...
	OdataTypeRuleCondition OdataTypeBasicRuleCondition = "RuleCondition"
)

// PossibleOdataTypeBasicRuleConditionValues returns an array of possible values for the OdataTypeBasicRuleCondition const type.
func PossibleOdataTypeBasicRuleConditionValues() []OdataTypeBasicRuleCondition {
	return []OdataTypeBasicRuleCondition{OdataTypeMicrosoftAzureManagementInsightsModelsLocationThresholdRuleCondition, OdataTypeMicrosoftAzureManagementInsightsModelsManagementEventRuleCondition, OdataTypeMicrosoftAzureManagementInsightsModelsThresholdRuleCondition, OdataTypeRuleCondition}
}

// ReceiverStatus enumerates the values for receiver status.
type ReceiverStatus string

const (
	// Disabled ...
	Disabled ReceiverStatus = "Disabled"
	// Enabled ...
	Enabled ReceiverStatus = "Enabled"
	// NotSpecified ...
	NotSpecified ReceiverStatus = "NotSpecified"
)

// PossibleReceiverStatusValues returns an array of possible values for the ReceiverStatus const type.
func PossibleReceiverStatusValues() []ReceiverStatus {
	return []ReceiverStatus{Disabled, Enabled, NotSpecified}
}

// RecurrenceFrequency enumerates the values for recurrence frequency.
type RecurrenceFrequency string

const (
	// RecurrenceFrequencyDay ...
	RecurrenceFrequencyDay RecurrenceFrequency = "Day"
	// RecurrenceFrequencyHour ...
	RecurrenceFrequencyHour RecurrenceFrequency = "Hour"
	// RecurrenceFrequencyMinute ...
	RecurrenceFrequencyMinute RecurrenceFrequency = "Minute"
	// RecurrenceFrequencyMonth ...
	RecurrenceFrequencyMonth RecurrenceFrequency = "Month"
	// RecurrenceFrequencyNone ...
	RecurrenceFrequencyNone RecurrenceFrequency = "None"
	// RecurrenceFrequencySecond ...
	RecurrenceFrequencySecond RecurrenceFrequency = "Second"
	// RecurrenceFrequencyWeek ...
	RecurrenceFrequencyWeek RecurrenceFrequency = "Week"
	// RecurrenceFrequencyYear ...
	RecurrenceFrequencyYear RecurrenceFrequency = "Year"
)

// PossibleRecurrenceFrequencyValues returns an array of possible values for the RecurrenceFrequency const type.
func PossibleRecurrenceFrequencyValues() []RecurrenceFrequency {
	return []RecurrenceFrequency{RecurrenceFrequencyDay, RecurrenceFrequencyHour, RecurrenceFrequencyMinute, RecurrenceFrequencyMonth, RecurrenceFrequencyNone, RecurrenceFrequencySecond, RecurrenceFrequencyWeek, RecurrenceFrequencyYear}
}

// ResultType enumerates the values for result type.
type ResultType string

const (
	// Data ...
	Data ResultType = "Data"
	// Metadata ...
	Metadata ResultType = "Metadata"
)

// PossibleResultTypeValues returns an array of possible values for the ResultType const type.
func PossibleResultTypeValues() []ResultType {
	return []ResultType{Data, Metadata}
}

// ScaleDirection enumerates the values for scale direction.
type ScaleDirection string

const (
	// ScaleDirectionDecrease ...
	ScaleDirectionDecrease ScaleDirection = "Decrease"
	// ScaleDirectionIncrease ...
	ScaleDirectionIncrease ScaleDirection = "Increase"
	// ScaleDirectionNone ...
	ScaleDirectionNone ScaleDirection = "None"
)

// PossibleScaleDirectionValues returns an array of possible values for the ScaleDirection const type.
func PossibleScaleDirectionValues() []ScaleDirection {
	return []ScaleDirection{ScaleDirectionDecrease, ScaleDirectionIncrease, ScaleDirectionNone}
}

// ScaleType enumerates the values for scale type.
type ScaleType string

const (
	// ChangeCount ...
	ChangeCount ScaleType = "ChangeCount"
	// ExactCount ...
	ExactCount ScaleType = "ExactCount"
	// PercentChangeCount ...
	PercentChangeCount ScaleType = "PercentChangeCount"
)

// PossibleScaleTypeValues returns an array of possible values for the ScaleType const type.
func PossibleScaleTypeValues() []ScaleType {
	return []ScaleType{ChangeCount, ExactCount, PercentChangeCount}
}

// Sensitivity enumerates the values for sensitivity.
type Sensitivity string

const (
	// High ...
	High Sensitivity = "High"
	// Low ...
	Low Sensitivity = "Low"
	// Medium ...
	Medium Sensitivity = "Medium"
)

// PossibleSensitivityValues returns an array of possible values for the Sensitivity const type.
func PossibleSensitivityValues() []Sensitivity {
	return []Sensitivity{High, Low, Medium}
}

// TimeAggregationOperator enumerates the values for time aggregation operator.
type TimeAggregationOperator string

const (
	// TimeAggregationOperatorAverage ...
	TimeAggregationOperatorAverage TimeAggregationOperator = "Average"
	// TimeAggregationOperatorLast ...
	TimeAggregationOperatorLast TimeAggregationOperator = "Last"
	// TimeAggregationOperatorMaximum ...
	TimeAggregationOperatorMaximum TimeAggregationOperator = "Maximum"
	// TimeAggregationOperatorMinimum ...
	TimeAggregationOperatorMinimum TimeAggregationOperator = "Minimum"
	// TimeAggregationOperatorTotal ...
	TimeAggregationOperatorTotal TimeAggregationOperator = "Total"
)

// PossibleTimeAggregationOperatorValues returns an array of possible values for the TimeAggregationOperator const type.
func PossibleTimeAggregationOperatorValues() []TimeAggregationOperator {
	return []TimeAggregationOperator{TimeAggregationOperatorAverage, TimeAggregationOperatorLast, TimeAggregationOperatorMaximum, TimeAggregationOperatorMinimum, TimeAggregationOperatorTotal}
}

// TimeAggregationType enumerates the values for time aggregation type.
type TimeAggregationType string

const (
	// TimeAggregationTypeAverage ...
	TimeAggregationTypeAverage TimeAggregationType = "Average"
	// TimeAggregationTypeCount ...
	TimeAggregationTypeCount TimeAggregationType = "Count"
	// TimeAggregationTypeLast ...
	TimeAggregationTypeLast TimeAggregationType = "Last"
	// TimeAggregationTypeMaximum ...
	TimeAggregationTypeMaximum TimeAggregationType = "Maximum"
	// TimeAggregationTypeMinimum ...
	TimeAggregationTypeMinimum TimeAggregationType = "Minimum"
	// TimeAggregationTypeTotal ...
	TimeAggregationTypeTotal TimeAggregationType = "Total"
)

// PossibleTimeAggregationTypeValues returns an array of possible values for the TimeAggregationType const type.
func PossibleTimeAggregationTypeValues() []TimeAggregationType {
	return []TimeAggregationType{TimeAggregationTypeAverage, TimeAggregationTypeCount, TimeAggregationTypeLast, TimeAggregationTypeMaximum, TimeAggregationTypeMinimum, TimeAggregationTypeTotal}
}

// Unit enumerates the values for unit.
type Unit string

const (
	// UnitBytes ...
	UnitBytes Unit = "Bytes"
	// UnitByteSeconds ...
	UnitByteSeconds Unit = "ByteSeconds"
	// UnitBytesPerSecond ...
	UnitBytesPerSecond Unit = "BytesPerSecond"
	// UnitCount ...
	UnitCount Unit = "Count"
	// UnitCountPerSecond ...
	UnitCountPerSecond Unit = "CountPerSecond"
	// UnitMilliSeconds ...
	UnitMilliSeconds Unit = "MilliSeconds"
	// UnitPercent ...
	UnitPercent Unit = "Percent"
	// UnitSeconds ...
	UnitSeconds Unit = "Seconds"
	// UnitUnspecified ...
	UnitUnspecified Unit = "Unspecified"
)

// PossibleUnitValues returns an array of possible values for the Unit const type.
func PossibleUnitValues() []Unit {
	return []Unit{UnitBytes, UnitByteSeconds, UnitBytesPerSecond, UnitCount, UnitCountPerSecond, UnitMilliSeconds, UnitPercent, UnitSeconds, UnitUnspecified}
}

// ActionGroup an Azure action group.
type ActionGroup struct {
	// GroupShortName - The short name of the action group. This will be used in SMS messages.
	GroupShortName *string `json:"groupShortName,omitempty"`
	// Enabled - Indicates whether this action group is enabled. If an action group is not enabled, then none of its receivers will receive communications.
	Enabled *bool `json:"enabled,omitempty"`
	// EmailReceivers - The list of email receivers that are part of this action group.
	EmailReceivers *[]EmailReceiver `json:"emailReceivers,omitempty"`
	// SmsReceivers - The list of SMS receivers that are part of this action group.
	SmsReceivers *[]SmsReceiver `json:"smsReceivers,omitempty"`
	// WebhookReceivers - The list of webhook receivers that are part of this action group.
	WebhookReceivers *[]WebhookReceiver `json:"webhookReceivers,omitempty"`
	// ItsmReceivers - The list of ITSM receivers that are part of this action group.
	ItsmReceivers *[]ItsmReceiver `json:"itsmReceivers,omitempty"`
	// AzureAppPushReceivers - The list of AzureAppPush receivers that are part of this action group.
	AzureAppPushReceivers *[]AzureAppPushReceiver `json:"azureAppPushReceivers,omitempty"`
	// AutomationRunbookReceivers - The list of AutomationRunbook receivers that are part of this action group.
	AutomationRunbookReceivers *[]AutomationRunbookReceiver `json:"automationRunbookReceivers,omitempty"`
	// VoiceReceivers - The list of voice receivers that are part of this action group.
	VoiceReceivers *[]VoiceReceiver `json:"voiceReceivers,omitempty"`
	// LogicAppReceivers - The list of logic app receivers that are part of this action group.
	LogicAppReceivers *[]LogicAppReceiver `json:"logicAppReceivers,omitempty"`
	// AzureFunctionReceivers - The list of azure function receivers that are part of this action group.
	AzureFunctionReceivers *[]AzureFunctionReceiver `json:"azureFunctionReceivers,omitempty"`
	// ArmRoleReceivers - The list of ARM role receivers that are part of this action group. Roles are Azure RBAC roles and only built-in roles are supported.
	ArmRoleReceivers *[]ArmRoleReceiver `json:"armRoleReceivers,omitempty"`
}

// ActionGroupList a list of action groups.
type ActionGroupList struct {
	autorest.Response `json:"-"`
	// Value - The list of action groups.
	Value *[]ActionGroupResource `json:"value,omitempty"`
	// NextLink - Provides the link to retrieve the next set of elements.
	NextLink *string `json:"nextLink,omitempty"`
}

// ActionGroupPatch an Azure action group for patch operations.
type ActionGroupPatch struct {
	// Enabled - Indicates whether this action group is enabled. If an action group is not enabled, then none of its actions will be activated.
	Enabled *bool `json:"enabled,omitempty"`
}

// ActionGroupPatchBody an action group object for the body of patch operations.
type ActionGroupPatchBody struct {
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// ActionGroupPatch - The action group settings for an update operation.
	*ActionGroupPatch `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ActionGroupPatchBody.
func (agpb ActionGroupPatchBody) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agpb.Tags != nil {
		objectMap["tags"] = agpb.Tags
	}
	if agpb.ActionGroupPatch != nil {
		objectMap["properties"] = agpb.ActionGroupPatch
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ActionGroupPatchBody struct.
func (agpb *ActionGroupPatchBody) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				agpb.Tags = tags
			}
		case "properties":
			if v != nil {
				var actionGroupPatch ActionGroupPatch
				err = json.Unmarshal(*v, &actionGroupPatch)
				if err != nil {
					return err
				}
				agpb.ActionGroupPatch = &actionGroupPatch
			}
		}
	}

	return nil
}

// ActionGroupResource an action group resource.
type ActionGroupResource struct {
	autorest.Response `json:"-"`
	// ActionGroup - The action groups properties of the resource.
	*ActionGroup `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ActionGroupResource.
func (agr ActionGroupResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agr.ActionGroup != nil {
		objectMap["properties"] = agr.ActionGroup
	}
	if agr.Location != nil {
		objectMap["location"] = agr.Location
	}
	if agr.Tags != nil {
		objectMap["tags"] = agr.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ActionGroupResource struct.
func (agr *ActionGroupResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var actionGroup ActionGroup
				err = json.Unmarshal(*v, &actionGroup)
				if err != nil {
					return err
				}
				agr.ActionGroup = &actionGroup
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				agr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				agr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				agr.Tags = tags
			}
		}
	}

	return nil
}

// ActivityLogAlert an Azure activity log alert.
type ActivityLogAlert struct {
	// Scopes - A list of resourceIds that will be used as prefixes. The alert will only apply to activityLogs with resourceIds that fall under one of these prefixes. This list must include at least one item.
	Scopes *[]string `json:"scopes,omitempty"`
	// Enabled - Indicates whether this activity log alert is enabled. If an activity log alert is not enabled, then none of its actions will be activated.
	Enabled *bool `json:"enabled,omitempty"`
	// Condition - The condition that will cause this alert to activate.
	Condition *ActivityLogAlertAllOfCondition `json:"condition,omitempty"`
	// Actions - The actions that will activate when the condition is met.
	Actions *ActivityLogAlertActionList `json:"actions,omitempty"`
	// Description - A description of this activity log alert.
	Description *string `json:"description,omitempty"`
}

// ActivityLogAlertActionGroup a pointer to an Azure Action Group.
type ActivityLogAlertActionGroup struct {
	// ActionGroupID - The resourceId of the action group. This cannot be null or empty.
	ActionGroupID *string `json:"actionGroupId,omitempty"`
	// WebhookProperties - the dictionary of custom properties to include with the post operation. These data are appended to the webhook payload.
	WebhookProperties map[string]*string `json:"webhookProperties"`
}

// MarshalJSON is the custom marshaler for ActivityLogAlertActionGroup.
func (alaag ActivityLogAlertActionGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if alaag.ActionGroupID != nil {
		objectMap["actionGroupId"] = alaag.ActionGroupID
	}
	if alaag.WebhookProperties != nil {
		objectMap["webhookProperties"] = alaag.WebhookProperties
	}
	return json.Marshal(objectMap)
}

// ActivityLogAlertActionList a list of activity log alert actions.
type ActivityLogAlertActionList struct {
	// ActionGroups - The list of activity log alerts.
	ActionGroups *[]ActivityLogAlertActionGroup `json:"actionGroups,omitempty"`
}

// ActivityLogAlertAllOfCondition an Activity Log alert condition that is met when all its member
// conditions are met.
type ActivityLogAlertAllOfCondition struct {
	// AllOf - The list of activity log alert conditions.
	AllOf *[]ActivityLogAlertLeafCondition `json:"allOf,omitempty"`
}

// ActivityLogAlertLeafCondition an Activity Log alert condition that is met by comparing an activity log
// field and value.
type ActivityLogAlertLeafCondition struct {
	// Field - The name of the field that this condition will examine. The possible values for this field are (case-insensitive): 'resourceId', 'category', 'caller', 'level', 'operationName', 'resourceGroup', 'resourceProvider', 'status', 'subStatus', 'resourceType', or anything beginning with 'properties.'.
	Field *string `json:"field,omitempty"`
	// Equals - The field value will be compared to this value (case-insensitive) to determine if the condition is met.
	Equals *string `json:"equals,omitempty"`
}

// ActivityLogAlertList a list of activity log alerts.
type ActivityLogAlertList struct {
	autorest.Response `json:"-"`
	// Value - The list of activity log alerts.
	Value *[]ActivityLogAlertResource `json:"value,omitempty"`
	// NextLink - Provides the link to retrieve the next set of elements.
	NextLink *string `json:"nextLink,omitempty"`
}

// ActivityLogAlertPatch an Azure activity log alert for patch operations.
type ActivityLogAlertPatch struct {
	// Enabled - Indicates whether this activity log alert is enabled. If an activity log alert is not enabled, then none of its actions will be activated.
	Enabled *bool `json:"enabled,omitempty"`
}

// ActivityLogAlertPatchBody an activity log alert object for the body of patch operations.
type ActivityLogAlertPatchBody struct {
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// ActivityLogAlertPatch - The activity log alert settings for an update operation.
	*ActivityLogAlertPatch `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ActivityLogAlertPatchBody.
func (alapb ActivityLogAlertPatchBody) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if alapb.Tags != nil {
		objectMap["tags"] = alapb.Tags
	}
	if alapb.ActivityLogAlertPatch != nil {
		objectMap["properties"] = alapb.ActivityLogAlertPatch
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ActivityLogAlertPatchBody struct.
func (alapb *ActivityLogAlertPatchBody) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				alapb.Tags = tags
			}
		case "properties":
			if v != nil {
				var activityLogAlertPatch ActivityLogAlertPatch
				err = json.Unmarshal(*v, &activityLogAlertPatch)
				if err != nil {
					return err
				}
				alapb.ActivityLogAlertPatch = &activityLogAlertPatch
			}
		}
	}

	return nil
}

// ActivityLogAlertResource an activity log alert resource.
type ActivityLogAlertResource struct {
	autorest.Response `json:"-"`
	// ActivityLogAlert - The activity log alert properties of the resource.
	*ActivityLogAlert `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ActivityLogAlertResource.
func (alar ActivityLogAlertResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if alar.ActivityLogAlert != nil {
		objectMap["properties"] = alar.ActivityLogAlert
	}
	if alar.Location != nil {
		objectMap["location"] = alar.Location
	}
	if alar.Tags != nil {
		objectMap["tags"] = alar.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ActivityLogAlertResource struct.
func (alar *ActivityLogAlertResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var activityLogAlert ActivityLogAlert
				err = json.Unmarshal(*v, &activityLogAlert)
				if err != nil {
					return err
				}
				alar.ActivityLogAlert = &activityLogAlert
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				alar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				alar.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				alar.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				alar.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				alar.Tags = tags
			}
		}
	}

	return nil
}

// AlertRule an alert rule.
type AlertRule struct {
	// Name - the name of the alert rule.
	Name *string `json:"name,omitempty"`
	// Description - the description of the alert rule that will be included in the alert email.
	Description *string `json:"description,omitempty"`
	// IsEnabled - the flag that indicates whether the alert rule is enabled.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// Condition - the condition that results in the alert rule being activated.
	Condition BasicRuleCondition `json:"condition,omitempty"`
	// Actions - the array of actions that are performed when the alert rule becomes active, and when an alert condition is resolved.
	Actions *[]BasicRuleAction `json:"actions,omitempty"`
	// LastUpdatedTime - READ-ONLY; Last time the rule was updated in ISO8601 format.
	LastUpdatedTime *date.Time `json:"lastUpdatedTime,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AlertRule struct.
func (ar *AlertRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ar.Name = &name
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				ar.Description = &description
			}
		case "isEnabled":
			if v != nil {
				var isEnabled bool
				err = json.Unmarshal(*v, &isEnabled)
				if err != nil {
					return err
				}
				ar.IsEnabled = &isEnabled
			}
		case "condition":
			if v != nil {
				condition, err := unmarshalBasicRuleCondition(*v)
				if err != nil {
					return err
				}
				ar.Condition = condition
			}
		case "actions":
			if v != nil {
				actions, err := unmarshalBasicRuleActionArray(*v)
				if err != nil {
					return err
				}
				ar.Actions = &actions
			}
		case "lastUpdatedTime":
			if v != nil {
				var lastUpdatedTime date.Time
				err = json.Unmarshal(*v, &lastUpdatedTime)
				if err != nil {
					return err
				}
				ar.LastUpdatedTime = &lastUpdatedTime
			}
		}
	}

	return nil
}

// AlertRuleResource the alert rule resource.
type AlertRuleResource struct {
	autorest.Response `json:"-"`
	// AlertRule - The alert rule properties of the resource.
	*AlertRule `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for AlertRuleResource.
func (arr AlertRuleResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if arr.AlertRule != nil {
		objectMap["properties"] = arr.AlertRule
	}
	if arr.Location != nil {
		objectMap["location"] = arr.Location
	}
	if arr.Tags != nil {
		objectMap["tags"] = arr.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AlertRuleResource struct.
func (arr *AlertRuleResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var alertRule AlertRule
				err = json.Unmarshal(*v, &alertRule)
				if err != nil {
					return err
				}
				arr.AlertRule = &alertRule
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				arr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				arr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				arr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				arr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				arr.Tags = tags
			}
		}
	}

	return nil
}

// AlertRuleResourceCollection represents a collection of alert rule resources.
type AlertRuleResourceCollection struct {
	autorest.Response `json:"-"`
	// Value - the values for the alert rule resources.
	Value *[]AlertRuleResource `json:"value,omitempty"`
}

// AlertRuleResourcePatch the alert rule object for patch operations.
type AlertRuleResourcePatch struct {
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// AlertRule - The properties of an alert rule.
	*AlertRule `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for AlertRuleResourcePatch.
func (arrp AlertRuleResourcePatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if arrp.Tags != nil {
		objectMap["tags"] = arrp.Tags
	}
	if arrp.AlertRule != nil {
		objectMap["properties"] = arrp.AlertRule
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AlertRuleResourcePatch struct.
func (arrp *AlertRuleResourcePatch) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				arrp.Tags = tags
			}
		case "properties":
			if v != nil {
				var alertRule AlertRule
				err = json.Unmarshal(*v, &alertRule)
				if err != nil {
					return err
				}
				arrp.AlertRule = &alertRule
			}
		}
	}

	return nil
}

// ArmRoleReceiver an arm role receiver.
type ArmRoleReceiver struct {
	// Name - The name of the arm role receiver. Names must be unique across all receivers within an action group.
	Name *string `json:"name,omitempty"`
	// RoleID - The arm role id.
	RoleID *string `json:"roleId,omitempty"`
}

// AutomationRunbookReceiver the Azure Automation Runbook notification receiver.
type AutomationRunbookReceiver struct {
	// AutomationAccountID - The Azure automation account Id which holds this runbook and authenticate to Azure resource.
	AutomationAccountID *string `json:"automationAccountId,omitempty"`
	// RunbookName - The name for this runbook.
	RunbookName *string `json:"runbookName,omitempty"`
	// WebhookResourceID - The resource id for webhook linked to this runbook.
	WebhookResourceID *string `json:"webhookResourceId,omitempty"`
	// IsGlobalRunbook - Indicates whether this instance is global runbook.
	IsGlobalRunbook *bool `json:"isGlobalRunbook,omitempty"`
	// Name - Indicates name of the webhook.
	Name *string `json:"name,omitempty"`
	// ServiceURI - The URI where webhooks should be sent.
	ServiceURI *string `json:"serviceUri,omitempty"`
}

// AutoscaleNotification autoscale notification.
type AutoscaleNotification struct {
	// Operation - the operation associated with the notification and its value must be "scale"
	Operation *string `json:"operation,omitempty"`
	// Email - the email notification.
	Email *EmailNotification `json:"email,omitempty"`
	// Webhooks - the collection of webhook notifications.
	Webhooks *[]WebhookNotification `json:"webhooks,omitempty"`
}

// AutoscaleProfile autoscale profile.
type AutoscaleProfile struct {
	// Name - the name of the profile.
	Name *string `json:"name,omitempty"`
	// Capacity - the number of instances that can be used during this profile.
	Capacity *ScaleCapacity `json:"capacity,omitempty"`
	// Rules - the collection of rules that provide the triggers and parameters for the scaling action. A maximum of 10 rules can be specified.
	Rules *[]ScaleRule `json:"rules,omitempty"`
	// FixedDate - the specific date-time for the profile. This element is not used if the Recurrence element is used.
	FixedDate *TimeWindow `json:"fixedDate,omitempty"`
	// Recurrence - the repeating times at which this profile begins. This element is not used if the FixedDate element is used.
	Recurrence *Recurrence `json:"recurrence,omitempty"`
}

// AutoscaleSetting a setting that contains all of the configuration for the automatic scaling of a
// resource.
type AutoscaleSetting struct {
	// Profiles - the collection of automatic scaling profiles that specify different scaling parameters for different time periods. A maximum of 20 profiles can be specified.
	Profiles *[]AutoscaleProfile `json:"profiles,omitempty"`
	// Notifications - the collection of notifications.
	Notifications *[]AutoscaleNotification `json:"notifications,omitempty"`
	// Enabled - the enabled flag. Specifies whether automatic scaling is enabled for the resource. The default value is 'true'.
	Enabled *bool `json:"enabled,omitempty"`
	// Name - the name of the autoscale setting.
	Name *string `json:"name,omitempty"`
	// TargetResourceURI - the resource identifier of the resource that the autoscale setting should be added to.
	TargetResourceURI *string `json:"targetResourceUri,omitempty"`
}

// AutoscaleSettingResource the autoscale setting resource.
type AutoscaleSettingResource struct {
	autorest.Response `json:"-"`
	// AutoscaleSetting - The autoscale setting of the resource.
	*AutoscaleSetting `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for AutoscaleSettingResource.
func (asr AutoscaleSettingResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if asr.AutoscaleSetting != nil {
		objectMap["properties"] = asr.AutoscaleSetting
	}
	if asr.Location != nil {
		objectMap["location"] = asr.Location
	}
	if asr.Tags != nil {
		objectMap["tags"] = asr.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AutoscaleSettingResource struct.
func (asr *AutoscaleSettingResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var autoscaleSetting AutoscaleSetting
				err = json.Unmarshal(*v, &autoscaleSetting)
				if err != nil {
					return err
				}
				asr.AutoscaleSetting = &autoscaleSetting
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				asr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				asr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				asr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				asr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				asr.Tags = tags
			}
		}
	}

	return nil
}

// AutoscaleSettingResourceCollection represents a collection of autoscale setting resources.
type AutoscaleSettingResourceCollection struct {
	autorest.Response `json:"-"`
	// Value - the values for the autoscale setting resources.
	Value *[]AutoscaleSettingResource `json:"value,omitempty"`
	// NextLink - URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// AutoscaleSettingResourceCollectionIterator provides access to a complete listing of
// AutoscaleSettingResource values.
type AutoscaleSettingResourceCollectionIterator struct {
	i    int
	page AutoscaleSettingResourceCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AutoscaleSettingResourceCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AutoscaleSettingResourceCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AutoscaleSettingResourceCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AutoscaleSettingResourceCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AutoscaleSettingResourceCollectionIterator) Response() AutoscaleSettingResourceCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AutoscaleSettingResourceCollectionIterator) Value() AutoscaleSettingResource {
	if !iter.page.NotDone() {
		return AutoscaleSettingResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AutoscaleSettingResourceCollectionIterator type.
func NewAutoscaleSettingResourceCollectionIterator(page AutoscaleSettingResourceCollectionPage) AutoscaleSettingResourceCollectionIterator {
	return AutoscaleSettingResourceCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (asrc AutoscaleSettingResourceCollection) IsEmpty() bool {
	return asrc.Value == nil || len(*asrc.Value) == 0
}

// autoscaleSettingResourceCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (asrc AutoscaleSettingResourceCollection) autoscaleSettingResourceCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if asrc.NextLink == nil || len(to.String(asrc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(asrc.NextLink)))
}

// AutoscaleSettingResourceCollectionPage contains a page of AutoscaleSettingResource values.
type AutoscaleSettingResourceCollectionPage struct {
	fn   func(context.Context, AutoscaleSettingResourceCollection) (AutoscaleSettingResourceCollection, error)
	asrc AutoscaleSettingResourceCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AutoscaleSettingResourceCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AutoscaleSettingResourceCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.asrc)
	if err != nil {
		return err
	}
	page.asrc = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AutoscaleSettingResourceCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AutoscaleSettingResourceCollectionPage) NotDone() bool {
	return !page.asrc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AutoscaleSettingResourceCollectionPage) Response() AutoscaleSettingResourceCollection {
	return page.asrc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AutoscaleSettingResourceCollectionPage) Values() []AutoscaleSettingResource {
	if page.asrc.IsEmpty() {
		return nil
	}
	return *page.asrc.Value
}

// Creates a new instance of the AutoscaleSettingResourceCollectionPage type.
func NewAutoscaleSettingResourceCollectionPage(getNextPage func(context.Context, AutoscaleSettingResourceCollection) (AutoscaleSettingResourceCollection, error)) AutoscaleSettingResourceCollectionPage {
	return AutoscaleSettingResourceCollectionPage{fn: getNextPage}
}

// AutoscaleSettingResourcePatch the autoscale setting object for patch operations.
type AutoscaleSettingResourcePatch struct {
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// AutoscaleSetting - The autoscale setting properties of the update operation.
	*AutoscaleSetting `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for AutoscaleSettingResourcePatch.
func (asrp AutoscaleSettingResourcePatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if asrp.Tags != nil {
		objectMap["tags"] = asrp.Tags
	}
	if asrp.AutoscaleSetting != nil {
		objectMap["properties"] = asrp.AutoscaleSetting
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AutoscaleSettingResourcePatch struct.
func (asrp *AutoscaleSettingResourcePatch) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				asrp.Tags = tags
			}
		case "properties":
			if v != nil {
				var autoscaleSetting AutoscaleSetting
				err = json.Unmarshal(*v, &autoscaleSetting)
				if err != nil {
					return err
				}
				asrp.AutoscaleSetting = &autoscaleSetting
			}
		}
	}

	return nil
}

// AzureAppPushReceiver the Azure mobile App push notification receiver.
type AzureAppPushReceiver struct {
	// Name - The name of the Azure mobile app push receiver. Names must be unique across all receivers within an action group.
	Name *string `json:"name,omitempty"`
	// EmailAddress - The email address registered for the Azure mobile app.
	EmailAddress *string `json:"emailAddress,omitempty"`
}

// AzureFunctionReceiver an azure function receiver.
type AzureFunctionReceiver struct {
	// Name - The name of the azure function receiver. Names must be unique across all receivers within an action group.
	Name *string `json:"name,omitempty"`
	// FunctionAppResourceID - The azure resource id of the function app.
	FunctionAppResourceID *string `json:"functionAppResourceId,omitempty"`
	// FunctionName - The function name in the function app.
	FunctionName *string `json:"functionName,omitempty"`
	// HTTPTriggerURL - The http trigger url where http request sent to.
	HTTPTriggerURL *string `json:"httpTriggerUrl,omitempty"`
}

// Baseline the baseline values for a single sensitivity value.
type Baseline struct {
	// Sensitivity - the sensitivity of the baseline. Possible values include: 'Low', 'Medium', 'High'
	Sensitivity Sensitivity `json:"sensitivity,omitempty"`
	// LowThresholds - The low thresholds of the baseline.
	LowThresholds *[]float64 `json:"lowThresholds,omitempty"`
	// HighThresholds - The high thresholds of the baseline.
	HighThresholds *[]float64 `json:"highThresholds,omitempty"`
}

// BaselineMetadataValue represents a baseline metadata value.
type BaselineMetadataValue struct {
	// Name - the name of the metadata.
	Name *LocalizableString `json:"name,omitempty"`
	// Value - the value of the metadata.
	Value *string `json:"value,omitempty"`
}

// BaselineProperties the baseline properties class.
type BaselineProperties struct {
	// Timespan - The timespan for which the data was retrieved. Its value consists of two datetimes concatenated, separated by '/'.  This may be adjusted in the future and returned back from what was originally requested.
	Timespan *string `json:"timespan,omitempty"`
	// Interval - The interval (window size) for which the metric data was returned in.  This may be adjusted in the future and returned back from what was originally requested.  This is not present if a metadata request was made.
	Interval *string `json:"interval,omitempty"`
	// Aggregation - The aggregation type of the metric.
	Aggregation *string `json:"aggregation,omitempty"`
	// Timestamps - the array of timestamps of the baselines.
	Timestamps *[]date.Time `json:"timestamps,omitempty"`
	// Baseline - the baseline values for each sensitivity.
	Baseline *[]Baseline `json:"baseline,omitempty"`
	// Metadata - the baseline metadata values.
	Metadata *[]BaselineMetadataValue `json:"metadata,omitempty"`
}

// BaselineResponse the response to a baseline query.
type BaselineResponse struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; the metric baseline Id.
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; the resource type of the baseline resource.
	Type *string `json:"type,omitempty"`
	// Name - READ-ONLY; the name and the display name of the metric, i.e. it is localizable string.
	Name *LocalizableString `json:"name,omitempty"`
	// BaselineProperties - the properties of the baseline.
	*BaselineProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for BaselineResponse.
func (br BaselineResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if br.BaselineProperties != nil {
		objectMap["properties"] = br.BaselineProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for BaselineResponse struct.
func (br *BaselineResponse) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				br.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				br.Type = &typeVar
			}
		case "name":
			if v != nil {
				var name LocalizableString
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				br.Name = &name
			}
		case "properties":
			if v != nil {
				var baselineProperties BaselineProperties
				err = json.Unmarshal(*v, &baselineProperties)
				if err != nil {
					return err
				}
				br.BaselineProperties = &baselineProperties
			}
		}
	}

	return nil
}

// CalculateBaselineResponse the response to a calculate baseline call.
type CalculateBaselineResponse struct {
	autorest.Response `json:"-"`
	// Type - the resource type of the baseline resource.
	Type *string `json:"type,omitempty"`
	// Timestamps - the array of timestamps of the baselines.
	Timestamps *[]date.Time `json:"timestamps,omitempty"`
	// Baseline - the baseline values for each sensitivity.
	Baseline *[]Baseline `json:"baseline,omitempty"`
}

// DiagnosticSettings the diagnostic settings.
type DiagnosticSettings struct {
	// StorageAccountID - The resource ID of the storage account to which you would like to send Diagnostic Logs.
	StorageAccountID *string `json:"storageAccountId,omitempty"`
	// ServiceBusRuleID - The service bus rule Id of the diagnostic setting. This is here to maintain backwards compatibility.
	ServiceBusRuleID *string `json:"serviceBusRuleId,omitempty"`
	// EventHubAuthorizationRuleID - The resource Id for the event hub authorization rule.
	EventHubAuthorizationRuleID *string `json:"eventHubAuthorizationRuleId,omitempty"`
	// EventHubName - The name of the event hub. If none is specified, the default event hub will be selected.
	EventHubName *string `json:"eventHubName,omitempty"`
	// Metrics - the list of metric settings.
	Metrics *[]MetricSettings `json:"metrics,omitempty"`
	// Logs - the list of logs settings.
	Logs *[]LogSettings `json:"logs,omitempty"`
	// WorkspaceID - The workspace ID (resource ID of a Log Analytics workspace) for a Log Analytics workspace to which you would like to send Diagnostic Logs. Example: /subscriptions/4b9e8510-67ab-4e9a-95a9-e2f1e570ea9c/resourceGroups/insights-integration/providers/Microsoft.OperationalInsights/workspaces/viruela2
	WorkspaceID *string `json:"workspaceId,omitempty"`
}

// DiagnosticSettingsCategory the diagnostic settings Category.
type DiagnosticSettingsCategory struct {
	// CategoryType - The type of the diagnostic settings category. Possible values include: 'Metrics', 'Logs'
	CategoryType CategoryType `json:"categoryType,omitempty"`
}

// DiagnosticSettingsCategoryResource the diagnostic settings category resource.
type DiagnosticSettingsCategoryResource struct {
	autorest.Response `json:"-"`
	// DiagnosticSettingsCategory - The properties of a Diagnostic Settings Category.
	*DiagnosticSettingsCategory `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DiagnosticSettingsCategoryResource.
func (dscr DiagnosticSettingsCategoryResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dscr.DiagnosticSettingsCategory != nil {
		objectMap["properties"] = dscr.DiagnosticSettingsCategory
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DiagnosticSettingsCategoryResource struct.
func (dscr *DiagnosticSettingsCategoryResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var diagnosticSettingsCategory DiagnosticSettingsCategory
				err = json.Unmarshal(*v, &diagnosticSettingsCategory)
				if err != nil {
					return err
				}
				dscr.DiagnosticSettingsCategory = &diagnosticSettingsCategory
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dscr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dscr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dscr.Type = &typeVar
			}
		}
	}

	return nil
}

// DiagnosticSettingsCategoryResourceCollection represents a collection of diagnostic setting category
// resources.
type DiagnosticSettingsCategoryResourceCollection struct {
	autorest.Response `json:"-"`
	// Value - The collection of diagnostic settings category resources.
	Value *[]DiagnosticSettingsCategoryResource `json:"value,omitempty"`
}

// DiagnosticSettingsResource the diagnostic setting resource.
type DiagnosticSettingsResource struct {
	autorest.Response `json:"-"`
	// DiagnosticSettings - Properties of a Diagnostic Settings Resource.
	*DiagnosticSettings `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DiagnosticSettingsResource.
func (dsr DiagnosticSettingsResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dsr.DiagnosticSettings != nil {
		objectMap["properties"] = dsr.DiagnosticSettings
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DiagnosticSettingsResource struct.
func (dsr *DiagnosticSettingsResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var diagnosticSettings DiagnosticSettings
				err = json.Unmarshal(*v, &diagnosticSettings)
				if err != nil {
					return err
				}
				dsr.DiagnosticSettings = &diagnosticSettings
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dsr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dsr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dsr.Type = &typeVar
			}
		}
	}

	return nil
}

// DiagnosticSettingsResourceCollection represents a collection of alert rule resources.
type DiagnosticSettingsResourceCollection struct {
	autorest.Response `json:"-"`
	// Value - The collection of diagnostic settings resources;.
	Value *[]DiagnosticSettingsResource `json:"value,omitempty"`
}

// EmailNotification email notification of an autoscale event.
type EmailNotification struct {
	// SendToSubscriptionAdministrator - a value indicating whether to send email to subscription administrator.
	SendToSubscriptionAdministrator *bool `json:"sendToSubscriptionAdministrator,omitempty"`
	// SendToSubscriptionCoAdministrators - a value indicating whether to send email to subscription co-administrators.
	SendToSubscriptionCoAdministrators *bool `json:"sendToSubscriptionCoAdministrators,omitempty"`
	// CustomEmails - the custom e-mails list. This value can be null or empty, in which case this attribute will be ignored.
	CustomEmails *[]string `json:"customEmails,omitempty"`
}

// EmailReceiver an email receiver.
type EmailReceiver struct {
	// Name - The name of the email receiver. Names must be unique across all receivers within an action group.
	Name *string `json:"name,omitempty"`
	// EmailAddress - The email address of this receiver.
	EmailAddress *string `json:"emailAddress,omitempty"`
	// Status - READ-ONLY; The receiver status of the e-mail. Possible values include: 'NotSpecified', 'Enabled', 'Disabled'
	Status ReceiverStatus `json:"status,omitempty"`
}

// EnableRequest describes a receiver that should be resubscribed.
type EnableRequest struct {
	// ReceiverName - The name of the receiver to resubscribe.
	ReceiverName *string `json:"receiverName,omitempty"`
}

// ErrorResponse describes the format of Error response.
type ErrorResponse struct {
	// Code - Error code
	Code *string `json:"code,omitempty"`
	// Message - Error message indicating why the operation failed.
	Message *string `json:"message,omitempty"`
}

// EventCategoryCollection a collection of event categories. Currently possible values are: Administrative,
// Security, ServiceHealth, Alert, Recommendation, Policy.
type EventCategoryCollection struct {
	autorest.Response `json:"-"`
	// Value - the list that includes the Azure event categories.
	Value *[]LocalizableString `json:"value,omitempty"`
}

// EventData the Azure event log entries are of type EventData
type EventData struct {
	// Authorization - READ-ONLY; The sender authorization information.
	Authorization *SenderAuthorization `json:"authorization,omitempty"`
	// Claims - READ-ONLY; key value pairs to identify ARM permissions.
	Claims map[string]*string `json:"claims"`
	// Caller - READ-ONLY; the email address of the user who has performed the operation, the UPN claim or SPN claim based on availability.
	Caller *string `json:"caller,omitempty"`
	// Description - READ-ONLY; the description of the event.
	Description *string `json:"description,omitempty"`
	// ID - READ-ONLY; the Id of this event as required by ARM for RBAC. It contains the EventDataID and a timestamp information.
	ID *string `json:"id,omitempty"`
	// EventDataID - READ-ONLY; the event data Id. This is a unique identifier for an event.
	EventDataID *string `json:"eventDataId,omitempty"`
	// CorrelationID - READ-ONLY; the correlation Id, usually a GUID in the string format. The correlation Id is shared among the events that belong to the same uber operation.
	CorrelationID *string `json:"correlationId,omitempty"`
	// EventName - READ-ONLY; the event name. This value should not be confused with OperationName. For practical purposes, OperationName might be more appealing to end users.
	EventName *LocalizableString `json:"eventName,omitempty"`
	// Category - READ-ONLY; the event category.
	Category *LocalizableString `json:"category,omitempty"`
	// HTTPRequest - READ-ONLY; the HTTP request info. Usually includes the 'clientRequestId', 'clientIpAddress' (IP address of the user who initiated the event) and 'method' (HTTP method e.g. PUT).
	HTTPRequest *HTTPRequestInfo `json:"httpRequest,omitempty"`
	// Level - READ-ONLY; the event level. Possible values include: 'Critical', 'Error', 'Warning', 'Informational', 'Verbose'
	Level EventLevel `json:"level,omitempty"`
	// ResourceGroupName - READ-ONLY; the resource group name of the impacted resource.
	ResourceGroupName *string `json:"resourceGroupName,omitempty"`
	// ResourceProviderName - READ-ONLY; the resource provider name of the impacted resource.
	ResourceProviderName *LocalizableString `json:"resourceProviderName,omitempty"`
	// ResourceID - READ-ONLY; the resource uri that uniquely identifies the resource that caused this event.
	ResourceID *string `json:"resourceId,omitempty"`
	// ResourceType - READ-ONLY; the resource type
	ResourceType *LocalizableString `json:"resourceType,omitempty"`
	// OperationID - READ-ONLY; It is usually a GUID shared among the events corresponding to single operation. This value should not be confused with EventName.
	OperationID *string `json:"operationId,omitempty"`
	// OperationName - READ-ONLY; the operation name.
	OperationName *LocalizableString `json:"operationName,omitempty"`
	// Properties - READ-ONLY; the set of <Key, Value> pairs (usually a Dictionary<String, String>) that includes details about the event.
	Properties map[string]*string `json:"properties"`
	// Status - READ-ONLY; a string describing the status of the operation. Some typical values are: Started, In progress, Succeeded, Failed, Resolved.
	Status *LocalizableString `json:"status,omitempty"`
	// SubStatus - READ-ONLY; the event sub status. Most of the time, when included, this captures the HTTP status code of the REST call. Common values are: OK (HTTP Status Code: 200), Created (HTTP Status Code: 201), Accepted (HTTP Status Code: 202), No Content (HTTP Status Code: 204), Bad Request(HTTP Status Code: 400), Not Found (HTTP Status Code: 404), Conflict (HTTP Status Code: 409), Internal Server Error (HTTP Status Code: 500), Service Unavailable (HTTP Status Code:503), Gateway Timeout (HTTP Status Code: 504)
	SubStatus *LocalizableString `json:"subStatus,omitempty"`
	// EventTimestamp - READ-ONLY; the timestamp of when the event was generated by the Azure service processing the request corresponding the event. It in ISO 8601 format.
	EventTimestamp *date.Time `json:"eventTimestamp,omitempty"`
	// SubmissionTimestamp - READ-ONLY; the timestamp of when the event became available for querying via this API. It is in ISO 8601 format. This value should not be confused eventTimestamp. As there might be a delay between the occurrence time of the event, and the time that the event is submitted to the Azure logging infrastructure.
	SubmissionTimestamp *date.Time `json:"submissionTimestamp,omitempty"`
	// SubscriptionID - READ-ONLY; the Azure subscription Id usually a GUID.
	SubscriptionID *string `json:"subscriptionId,omitempty"`
	// TenantID - READ-ONLY; the Azure tenant Id
	TenantID *string `json:"tenantId,omitempty"`
}

// MarshalJSON is the custom marshaler for EventData.
func (ed EventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// EventDataCollection represents collection of events.
type EventDataCollection struct {
	autorest.Response `json:"-"`
	// Value - this list that includes the Azure audit logs.
	Value *[]EventData `json:"value,omitempty"`
	// NextLink - Provides the link to retrieve the next set of events.
	NextLink *string `json:"nextLink,omitempty"`
}

// EventDataCollectionIterator provides access to a complete listing of EventData values.
type EventDataCollectionIterator struct {
	i    int
	page EventDataCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *EventDataCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EventDataCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *EventDataCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter EventDataCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter EventDataCollectionIterator) Response() EventDataCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter EventDataCollectionIterator) Value() EventData {
	if !iter.page.NotDone() {
		return EventData{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the EventDataCollectionIterator type.
func NewEventDataCollectionIterator(page EventDataCollectionPage) EventDataCollectionIterator {
	return EventDataCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (edc EventDataCollection) IsEmpty() bool {
	return edc.Value == nil || len(*edc.Value) == 0
}

// eventDataCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (edc EventDataCollection) eventDataCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if edc.NextLink == nil || len(to.String(edc.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(edc.NextLink)))
}

// EventDataCollectionPage contains a page of EventData values.
type EventDataCollectionPage struct {
	fn  func(context.Context, EventDataCollection) (EventDataCollection, error)
	edc EventDataCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *EventDataCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EventDataCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.edc)
	if err != nil {
		return err
	}
	page.edc = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *EventDataCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page EventDataCollectionPage) NotDone() bool {
	return !page.edc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page EventDataCollectionPage) Response() EventDataCollection {
	return page.edc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page EventDataCollectionPage) Values() []EventData {
	if page.edc.IsEmpty() {
		return nil
	}
	return *page.edc.Value
}

// Creates a new instance of the EventDataCollectionPage type.
func NewEventDataCollectionPage(getNextPage func(context.Context, EventDataCollection) (EventDataCollection, error)) EventDataCollectionPage {
	return EventDataCollectionPage{fn: getNextPage}
}

// HTTPRequestInfo the Http request info.
type HTTPRequestInfo struct {
	// ClientRequestID - the client request id.
	ClientRequestID *string `json:"clientRequestId,omitempty"`
	// ClientIPAddress - the client Ip Address
	ClientIPAddress *string `json:"clientIpAddress,omitempty"`
	// Method - the Http request method.
	Method *string `json:"method,omitempty"`
	// URI - the Uri.
	URI *string `json:"uri,omitempty"`
}

// Incident an alert incident indicates the activation status of an alert rule.
type Incident struct {
	autorest.Response `json:"-"`
	// Name - READ-ONLY; Incident name.
	Name *string `json:"name,omitempty"`
	// RuleName - READ-ONLY; Rule name that is associated with the incident.
	RuleName *string `json:"ruleName,omitempty"`
	// IsActive - READ-ONLY; A boolean to indicate whether the incident is active or resolved.
	IsActive *bool `json:"isActive,omitempty"`
	// ActivatedTime - READ-ONLY; The time at which the incident was activated in ISO8601 format.
	ActivatedTime *date.Time `json:"activatedTime,omitempty"`
	// ResolvedTime - READ-ONLY; The time at which the incident was resolved in ISO8601 format. If null, it means the incident is still active.
	ResolvedTime *date.Time `json:"resolvedTime,omitempty"`
}

// IncidentListResult the List incidents operation response.
type IncidentListResult struct {
	autorest.Response `json:"-"`
	// Value - the incident collection.
	Value *[]Incident `json:"value,omitempty"`
}

// ItsmReceiver an Itsm receiver.
type ItsmReceiver struct {
	// Name - The name of the Itsm receiver. Names must be unique across all receivers within an action group.
	Name *string `json:"name,omitempty"`
	// WorkspaceID - OMS LA instance identifier.
	WorkspaceID *string `json:"workspaceId,omitempty"`
	// ConnectionID - Unique identification of ITSM connection among multiple defined in above workspace.
	ConnectionID *string `json:"connectionId,omitempty"`
	// TicketConfiguration - JSON blob for the configurations of the ITSM action. CreateMultipleWorkItems option will be part of this blob as well.
	TicketConfiguration *string `json:"ticketConfiguration,omitempty"`
	// Region - Region in which workspace resides. Supported values:'centralindia','japaneast','southeastasia','australiasoutheast','uksouth','westcentralus','canadacentral','eastus','westeurope'
	Region *string `json:"region,omitempty"`
}

// LocalizableString the localizable string class.
type LocalizableString struct {
	// Value - the invariant value.
	Value *string `json:"value,omitempty"`
	// LocalizedValue - the locale specific value.
	LocalizedValue *string `json:"localizedValue,omitempty"`
}

// LocationThresholdRuleCondition a rule condition based on a certain number of locations failing.
type LocationThresholdRuleCondition struct {
	// WindowSize - the period of time (in ISO 8601 duration format) that is used to monitor alert activity based on the threshold. If specified then it must be between 5 minutes and 1 day.
	WindowSize *string `json:"windowSize,omitempty"`
	// FailedLocationCount - the number of locations that must fail to activate the alert.
	FailedLocationCount *int32 `json:"failedLocationCount,omitempty"`
	// DataSource - the resource from which the rule collects its data. For this type dataSource will always be of type RuleMetricDataSource.
	DataSource BasicRuleDataSource `json:"dataSource,omitempty"`
	// OdataType - Possible values include: 'OdataTypeRuleCondition', 'OdataTypeMicrosoftAzureManagementInsightsModelsThresholdRuleCondition', 'OdataTypeMicrosoftAzureManagementInsightsModelsLocationThresholdRuleCondition', 'OdataTypeMicrosoftAzureManagementInsightsModelsManagementEventRuleCondition'
	OdataType OdataTypeBasicRuleCondition `json:"odata.type,omitempty"`
}

// MarshalJSON is the custom marshaler for LocationThresholdRuleCondition.
func (ltrc LocationThresholdRuleCondition) MarshalJSON() ([]byte, error) {
	ltrc.OdataType = OdataTypeMicrosoftAzureManagementInsightsModelsLocationThresholdRuleCondition
	objectMap := make(map[string]interface{})
	if ltrc.WindowSize != nil {
		objectMap["windowSize"] = ltrc.WindowSize
	}
	if ltrc.FailedLocationCount != nil {
		objectMap["failedLocationCount"] = ltrc.FailedLocationCount
	}
	objectMap["dataSource"] = ltrc.DataSource
	if ltrc.OdataType != "" {
		objectMap["odata.type"] = ltrc.OdataType
	}
	return json.Marshal(objectMap)
}

// AsThresholdRuleCondition is the BasicRuleCondition implementation for LocationThresholdRuleCondition.
func (ltrc LocationThresholdRuleCondition) AsThresholdRuleCondition() (*ThresholdRuleCondition, bool) {
	return nil, false
}

// AsLocationThresholdRuleCondition is the BasicRuleCondition implementation for LocationThresholdRuleCondition.
func (ltrc LocationThresholdRuleCondition) AsLocationThresholdRuleCondition() (*LocationThresholdRuleCondition, bool) {
	return &ltrc, true
}

// AsManagementEventRuleCondition is the BasicRuleCondition implementation for LocationThresholdRuleCondition.
func (ltrc LocationThresholdRuleCondition) AsManagementEventRuleCondition() (*ManagementEventRuleCondition, bool) {
	return nil, false
}

// AsRuleCondition is the BasicRuleCondition implementation for LocationThresholdRuleCondition.
func (ltrc LocationThresholdRuleCondition) AsRuleCondition() (*RuleCondition, bool) {
	return nil, false
}

// AsBasicRuleCondition is the BasicRuleCondition implementation for LocationThresholdRuleCondition.
func (ltrc LocationThresholdRuleCondition) AsBasicRuleCondition() (BasicRuleCondition, bool) {
	return &ltrc, true
}

// UnmarshalJSON is the custom unmarshaler for LocationThresholdRuleCondition struct.
func (ltrc *LocationThresholdRuleCondition) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "windowSize":
			if v != nil {
				var windowSize string
				err = json.Unmarshal(*v, &windowSize)
				if err != nil {
					return err
				}
				ltrc.WindowSize = &windowSize
			}
		case "failedLocationCount":
			if v != nil {
				var failedLocationCount int32
				err = json.Unmarshal(*v, &failedLocationCount)
				if err != nil {
					return err
				}
				ltrc.FailedLocationCount = &failedLocationCount
			}
		case "dataSource":
			if v != nil {
				dataSource, err := unmarshalBasicRuleDataSource(*v)
				if err != nil {
					return err
				}
				ltrc.DataSource = dataSource
			}
		case "odata.type":
			if v != nil {
				var odataType OdataTypeBasicRuleCondition
				err = json.Unmarshal(*v, &odataType)
				if err != nil {
					return err
				}
				ltrc.OdataType = odataType
			}
		}
	}

	return nil
}

// LogicAppReceiver a logic app receiver.
type LogicAppReceiver struct {
	// Name - The name of the logic app receiver. Names must be unique across all receivers within an action group.
	Name *string `json:"name,omitempty"`
	// ResourceID - The azure resource id of the logic app receiver.
	ResourceID *string `json:"resourceId,omitempty"`
	// CallbackURL - The callback url where http request sent to.
	CallbackURL *string `json:"callbackUrl,omitempty"`
}

// LogProfileCollection represents a collection of log profiles.
type LogProfileCollection struct {
	autorest.Response `json:"-"`
	// Value - the values of the log profiles.
	Value *[]LogProfileResource `json:"value,omitempty"`
}

// LogProfileProperties the log profile properties.
type LogProfileProperties struct {
	// StorageAccountID - the resource id of the storage account to which you would like to send the Activity Log.
	StorageAccountID *string `json:"storageAccountId,omitempty"`
	// ServiceBusRuleID - The service bus rule ID of the service bus namespace in which you would like to have Event Hubs created for streaming the Activity Log. The rule ID is of the format: '{service bus resource ID}/authorizationrules/{key name}'.
	ServiceBusRuleID *string `json:"serviceBusRuleId,omitempty"`
	// Locations - List of regions for which Activity Log events should be stored or streamed. It is a comma separated list of valid ARM locations including the 'global' location.
	Locations *[]string `json:"locations,omitempty"`
	// Categories - the categories of the logs. These categories are created as is convenient to the user. Some values are: 'Write', 'Delete', and/or 'Action.'
	Categories *[]string `json:"categories,omitempty"`
	// RetentionPolicy - the retention policy for the events in the log.
	RetentionPolicy *RetentionPolicy `json:"retentionPolicy,omitempty"`
}

// LogProfileResource the log profile resource.
type LogProfileResource struct {
	autorest.Response `json:"-"`
	// LogProfileProperties - The log profile properties of the resource.
	*LogProfileProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for LogProfileResource.
func (lpr LogProfileResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lpr.LogProfileProperties != nil {
		objectMap["properties"] = lpr.LogProfileProperties
	}
	if lpr.Location != nil {
		objectMap["location"] = lpr.Location
	}
	if lpr.Tags != nil {
		objectMap["tags"] = lpr.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for LogProfileResource struct.
func (lpr *LogProfileResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var logProfileProperties LogProfileProperties
				err = json.Unmarshal(*v, &logProfileProperties)
				if err != nil {
					return err
				}
				lpr.LogProfileProperties = &logProfileProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				lpr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				lpr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				lpr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				lpr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				lpr.Tags = tags
			}
		}
	}

	return nil
}

// LogProfileResourcePatch the log profile resource for patch operations.
type LogProfileResourcePatch struct {
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// LogProfileProperties - The log profile properties for an update operation.
	*LogProfileProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for LogProfileResourcePatch.
func (lprp LogProfileResourcePatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lprp.Tags != nil {
		objectMap["tags"] = lprp.Tags
	}
	if lprp.LogProfileProperties != nil {
		objectMap["properties"] = lprp.LogProfileProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for LogProfileResourcePatch struct.
func (lprp *LogProfileResourcePatch) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				lprp.Tags = tags
			}
		case "properties":
			if v != nil {
				var logProfileProperties LogProfileProperties
				err = json.Unmarshal(*v, &logProfileProperties)
				if err != nil {
					return err
				}
				lprp.LogProfileProperties = &logProfileProperties
			}
		}
	}

	return nil
}

// LogSettings part of MultiTenantDiagnosticSettings. Specifies the settings for a particular log.
type LogSettings struct {
	// Category - Name of a Diagnostic Log category for a resource type this setting is applied to. To obtain the list of Diagnostic Log categories for a resource, first perform a GET diagnostic settings operation.
	Category *string `json:"category,omitempty"`
	// Enabled - a value indicating whether this log is enabled.
	Enabled *bool `json:"enabled,omitempty"`
	// RetentionPolicy - the retention policy for this log.
	RetentionPolicy *RetentionPolicy `json:"retentionPolicy,omitempty"`
}

// ManagementEventAggregationCondition how the data that is collected should be combined over time.
type ManagementEventAggregationCondition struct {
	// Operator - the condition operator. Possible values include: 'ConditionOperatorGreaterThan', 'ConditionOperatorGreaterThanOrEqual', 'ConditionOperatorLessThan', 'ConditionOperatorLessThanOrEqual'
	Operator ConditionOperator `json:"operator,omitempty"`
	// Threshold - The threshold value that activates the alert.
	Threshold *float64 `json:"threshold,omitempty"`
	// WindowSize - the period of time (in ISO 8601 duration format) that is used to monitor alert activity based on the threshold. If specified then it must be between 5 minutes and 1 day.
	WindowSize *string `json:"windowSize,omitempty"`
}

// ManagementEventRuleCondition a management event rule condition.
type ManagementEventRuleCondition struct {
	// Aggregation - How the data that is collected should be combined over time and when the alert is activated. Note that for management event alerts aggregation is optional – if it is not provided then any event will cause the alert to activate.
	Aggregation *ManagementEventAggregationCondition `json:"aggregation,omitempty"`
	// DataSource - the resource from which the rule collects its data. For this type dataSource will always be of type RuleMetricDataSource.
	DataSource BasicRuleDataSource `json:"dataSource,omitempty"`
	// OdataType - Possible values include: 'OdataTypeRuleCondition', 'OdataTypeMicrosoftAzureManagementInsightsModelsThresholdRuleCondition', 'OdataTypeMicrosoftAzureManagementInsightsModelsLocationThresholdRuleCondition', 'OdataTypeMicrosoftAzureManagementInsightsModelsManagementEventRuleCondition'
	OdataType OdataTypeBasicRuleCondition `json:"odata.type,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagementEventRuleCondition.
func (merc ManagementEventRuleCondition) MarshalJSON() ([]byte, error) {
	merc.OdataType = OdataTypeMicrosoftAzureManagementInsightsModelsManagementEventRuleCondition
	objectMap := make(map[string]interface{})
	if merc.Aggregation != nil {
		objectMap["aggregation"] = merc.Aggregation
	}
	objectMap["dataSource"] = merc.DataSource
	if merc.OdataType != "" {
		objectMap["odata.type"] = merc.OdataType
	}
	return json.Marshal(objectMap)
}

// AsThresholdRuleCondition is the BasicRuleCondition implementation for ManagementEventRuleCondition.
func (merc ManagementEventRuleCondition) AsThresholdRuleCondition() (*ThresholdRuleCondition, bool) {
	return nil, false
}

// AsLocationThresholdRuleCondition is the BasicRuleCondition implementation for ManagementEventRuleCondition.
func (merc ManagementEventRuleCondition) AsLocationThresholdRuleCondition() (*LocationThresholdRuleCondition, bool) {
	return nil, false
}

// AsManagementEventRuleCondition is the BasicRuleCondition implementation for ManagementEventRuleCondition.
func (merc ManagementEventRuleCondition) AsManagementEventRuleCondition() (*ManagementEventRuleCondition, bool) {
	return &merc, true
}

// AsRuleCondition is the BasicRuleCondition implementation for ManagementEventRuleCondition.
func (merc ManagementEventRuleCondition) AsRuleCondition() (*RuleCondition, bool) {
	return nil, false
}

// AsBasicRuleCondition is the BasicRuleCondition implementation for ManagementEventRuleCondition.
func (merc ManagementEventRuleCondition) AsBasicRuleCondition() (BasicRuleCondition, bool) {
	return &merc, true
}

// UnmarshalJSON is the custom unmarshaler for ManagementEventRuleCondition struct.
func (merc *ManagementEventRuleCondition) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "aggregation":
			if v != nil {
				var aggregation ManagementEventAggregationCondition
				err = json.Unmarshal(*v, &aggregation)
				if err != nil {
					return err
				}
				merc.Aggregation = &aggregation
			}
		case "dataSource":
			if v != nil {
				dataSource, err := unmarshalBasicRuleDataSource(*v)
				if err != nil {
					return err
				}
				merc.DataSource = dataSource
			}
		case "odata.type":
			if v != nil {
				var odataType OdataTypeBasicRuleCondition
				err = json.Unmarshal(*v, &odataType)
				if err != nil {
					return err
				}
				merc.OdataType = odataType
			}
		}
	}

	return nil
}

// MetadataValue represents a metric metadata value.
type MetadataValue struct {
	// Name - the name of the metadata.
	Name *LocalizableString `json:"name,omitempty"`
	// Value - the value of the metadata.
	Value *string `json:"value,omitempty"`
}

// Metric the result data of a query.
type Metric struct {
	// ID - the metric Id.
	ID *string `json:"id,omitempty"`
	// Type - the resource type of the metric resource.
	Type *string `json:"type,omitempty"`
	// Name - the name and the display name of the metric, i.e. it is localizable string.
	Name *LocalizableString `json:"name,omitempty"`
	// Unit - the unit of the metric. Possible values include: 'UnitCount', 'UnitBytes', 'UnitSeconds', 'UnitCountPerSecond', 'UnitBytesPerSecond', 'UnitPercent', 'UnitMilliSeconds', 'UnitByteSeconds', 'UnitUnspecified'
	Unit Unit `json:"unit,omitempty"`
	// Timeseries - the time series returned when a data query is performed.
	Timeseries *[]TimeSeriesElement `json:"timeseries,omitempty"`
}

// MetricAvailability metric availability specifies the time grain (aggregation interval or frequency) and
// the retention period for that time grain.
type MetricAvailability struct {
	// TimeGrain - the time grain specifies the aggregation interval for the metric. Expressed as a duration 'PT1M', 'P1D', etc.
	TimeGrain *string `json:"timeGrain,omitempty"`
	// Retention - the retention period for the metric at the specified timegrain.  Expressed as a duration 'PT1M', 'P1D', etc.
	Retention *string `json:"retention,omitempty"`
}

// MetricDefinition metric definition class specifies the metadata for a metric.
type MetricDefinition struct {
	// IsDimensionRequired - Flag to indicate whether the dimension is required.
	IsDimensionRequired *bool `json:"isDimensionRequired,omitempty"`
	// ResourceID - the resource identifier of the resource that emitted the metric.
	ResourceID *string `json:"resourceId,omitempty"`
	// Name - the name and the display name of the metric, i.e. it is a localizable string.
	Name *LocalizableString `json:"name,omitempty"`
	// Unit - the unit of the metric. Possible values include: 'UnitCount', 'UnitBytes', 'UnitSeconds', 'UnitCountPerSecond', 'UnitBytesPerSecond', 'UnitPercent', 'UnitMilliSeconds', 'UnitByteSeconds', 'UnitUnspecified'
	Unit Unit `json:"unit,omitempty"`
	// PrimaryAggregationType - the primary aggregation type value defining how to use the values for display. Possible values include: 'None', 'Average', 'Count', 'Minimum', 'Maximum', 'Total'
	PrimaryAggregationType AggregationType `json:"primaryAggregationType,omitempty"`
	// MetricAvailabilities - the collection of what aggregation intervals are available to be queried.
	MetricAvailabilities *[]MetricAvailability `json:"metricAvailabilities,omitempty"`
	// ID - the resource identifier of the metric definition.
	ID *string `json:"id,omitempty"`
	// Dimensions - the name and the display name of the dimension, i.e. it is a localizable string.
	Dimensions *[]LocalizableString `json:"dimensions,omitempty"`
}

// MetricDefinitionCollection represents collection of metric definitions.
type MetricDefinitionCollection struct {
	autorest.Response `json:"-"`
	// Value - the values for the metric definitions.
	Value *[]MetricDefinition `json:"value,omitempty"`
}

// MetricSettings part of MultiTenantDiagnosticSettings. Specifies the settings for a particular metric.
type MetricSettings struct {
	// TimeGrain - the timegrain of the metric in ISO8601 format.
	TimeGrain *string `json:"timeGrain,omitempty"`
	// Category - Name of a Diagnostic Metric category for a resource type this setting is applied to. To obtain the list of Diagnostic metric categories for a resource, first perform a GET diagnostic settings operation.
	Category *string `json:"category,omitempty"`
	// Enabled - a value indicating whether this category is enabled.
	Enabled *bool `json:"enabled,omitempty"`
	// RetentionPolicy - the retention policy for this category.
	RetentionPolicy *RetentionPolicy `json:"retentionPolicy,omitempty"`
}

// MetricTrigger the trigger that results in a scaling action.
type MetricTrigger struct {
	// MetricName - the name of the metric that defines what the rule monitors.
	MetricName *string `json:"metricName,omitempty"`
	// MetricResourceURI - the resource identifier of the resource the rule monitors.
	MetricResourceURI *string `json:"metricResourceUri,omitempty"`
	// TimeGrain - the granularity of metrics the rule monitors. Must be one of the predefined values returned from metric definitions for the metric. Must be between 12 hours and 1 minute.
	TimeGrain *string `json:"timeGrain,omitempty"`
	// Statistic - the metric statistic type. How the metrics from multiple instances are combined. Possible values include: 'MetricStatisticTypeAverage', 'MetricStatisticTypeMin', 'MetricStatisticTypeMax', 'MetricStatisticTypeSum'
	Statistic MetricStatisticType `json:"statistic,omitempty"`
	// TimeWindow - the range of time in which instance data is collected. This value must be greater than the delay in metric collection, which can vary from resource-to-resource. Must be between 12 hours and 5 minutes.
	TimeWindow *string `json:"timeWindow,omitempty"`
	// TimeAggregation - time aggregation type. How the data that is collected should be combined over time. The default value is Average. Possible values include: 'TimeAggregationTypeAverage', 'TimeAggregationTypeMinimum', 'TimeAggregationTypeMaximum', 'TimeAggregationTypeTotal', 'TimeAggregationTypeCount', 'TimeAggregationTypeLast'
	TimeAggregation TimeAggregationType `json:"timeAggregation,omitempty"`
	// Operator - the operator that is used to compare the metric data and the threshold. Possible values include: 'Equals', 'NotEquals', 'GreaterThan', 'GreaterThanOrEqual', 'LessThan', 'LessThanOrEqual'
	Operator ComparisonOperationType `json:"operator,omitempty"`
	// Threshold - the threshold of the metric that triggers the scale action.
	Threshold *float64 `json:"threshold,omitempty"`
}

// MetricValue represents a metric value.
type MetricValue struct {
	// TimeStamp - the timestamp for the metric value in ISO 8601 format.
	TimeStamp *date.Time `json:"timeStamp,omitempty"`
	// Average - the average value in the time range.
	Average *float64 `json:"average,omitempty"`
	// Minimum - the least value in the time range.
	Minimum *float64 `json:"minimum,omitempty"`
	// Maximum - the greatest value in the time range.
	Maximum *float64 `json:"maximum,omitempty"`
	// Total - the sum of all of the values in the time range.
	Total *float64 `json:"total,omitempty"`
	// Count - the number of samples in the time range. Can be used to determine the number of values that contributed to the average value.
	Count *int64 `json:"count,omitempty"`
}

// Operation microsoft Insights API operation definition.
type Operation struct {
	// Name - Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
	// Display - Display metadata associated with the operation.
	Display *OperationDisplay `json:"display,omitempty"`
}

// OperationDisplay display metadata associated with the operation.
type OperationDisplay struct {
	// Provider - Service provider: Microsoft.Insights
	Provider *string `json:"provider,omitempty"`
	// Resource - Resource on which the operation is performed: AlertRules, Autoscale, etc.
	Resource *string `json:"resource,omitempty"`
	// Operation - Operation type: Read, write, delete, etc.
	Operation *string `json:"operation,omitempty"`
}

// OperationListResult result of the request to list Microsoft.Insights operations. It contains a list of
// operations and a URL link to get the next set of results.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - List of operations supported by the Microsoft.Insights provider.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// ProxyOnlyResource a proxy only azure resource object
type ProxyOnlyResource struct {
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
}

// Recurrence the repeating times at which this profile begins. This element is not used if the FixedDate
// element is used.
type Recurrence struct {
	// Frequency - the recurrence frequency. How often the schedule profile should take effect. This value must be Week, meaning each week will have the same set of profiles. For example, to set a daily schedule, set **schedule** to every day of the week. The frequency property specifies that the schedule is repeated weekly. Possible values include: 'RecurrenceFrequencyNone', 'RecurrenceFrequencySecond', 'RecurrenceFrequencyMinute', 'RecurrenceFrequencyHour', 'RecurrenceFrequencyDay', 'RecurrenceFrequencyWeek', 'RecurrenceFrequencyMonth', 'RecurrenceFrequencyYear'
	Frequency RecurrenceFrequency `json:"frequency,omitempty"`
	// Schedule - the scheduling constraints for when the profile begins.
	Schedule *RecurrentSchedule `json:"schedule,omitempty"`
}

// RecurrentSchedule the scheduling constraints for when the profile begins.
type RecurrentSchedule struct {
	// TimeZone - the timezone for the hours of the profile. Some examples of valid time zones are: Dateline Standard Time, UTC-11, Hawaiian Standard Time, Alaskan Standard Time, Pacific Standard Time (Mexico), Pacific Standard Time, US Mountain Standard Time, Mountain Standard Time (Mexico), Mountain Standard Time, Central America Standard Time, Central Standard Time, Central Standard Time (Mexico), Canada Central Standard Time, SA Pacific Standard Time, Eastern Standard Time, US Eastern Standard Time, Venezuela Standard Time, Paraguay Standard Time, Atlantic Standard Time, Central Brazilian Standard Time, SA Western Standard Time, Pacific SA Standard Time, Newfoundland Standard Time, E. South America Standard Time, Argentina Standard Time, SA Eastern Standard Time, Greenland Standard Time, Montevideo Standard Time, Bahia Standard Time, UTC-02, Mid-Atlantic Standard Time, Azores Standard Time, Cape Verde Standard Time, Morocco Standard Time, UTC, GMT Standard Time, Greenwich Standard Time, W. Europe Standard Time, Central Europe Standard Time, Romance Standard Time, Central European Standard Time, W. Central Africa Standard Time, Namibia Standard Time, Jordan Standard Time, GTB Standard Time, Middle East Standard Time, Egypt Standard Time, Syria Standard Time, E. Europe Standard Time, South Africa Standard Time, FLE Standard Time, Turkey Standard Time, Israel Standard Time, Kaliningrad Standard Time, Libya Standard Time, Arabic Standard Time, Arab Standard Time, Belarus Standard Time, Russian Standard Time, E. Africa Standard Time, Iran Standard Time, Arabian Standard Time, Azerbaijan Standard Time, Russia Time Zone 3, Mauritius Standard Time, Georgian Standard Time, Caucasus Standard Time, Afghanistan Standard Time, West Asia Standard Time, Ekaterinburg Standard Time, Pakistan Standard Time, India Standard Time, Sri Lanka Standard Time, Nepal Standard Time, Central Asia Standard Time, Bangladesh Standard Time, N. Central Asia Standard Time, Myanmar Standard Time, SE Asia Standard Time, North Asia Standard Time, China Standard Time, North Asia East Standard Time, Singapore Standard Time, W. Australia Standard Time, Taipei Standard Time, Ulaanbaatar Standard Time, Tokyo Standard Time, Korea Standard Time, Yakutsk Standard Time, Cen. Australia Standard Time, AUS Central Standard Time, E. Australia Standard Time, AUS Eastern Standard Time, West Pacific Standard Time, Tasmania Standard Time, Magadan Standard Time, Vladivostok Standard Time, Russia Time Zone 10, Central Pacific Standard Time, Russia Time Zone 11, New Zealand Standard Time, UTC+12, Fiji Standard Time, Kamchatka Standard Time, Tonga Standard Time, Samoa Standard Time, Line Islands Standard Time
	TimeZone *string `json:"timeZone,omitempty"`
	// Days - the collection of days that the profile takes effect on. Possible values are Sunday through Saturday.
	Days *[]string `json:"days,omitempty"`
	// Hours - A collection of hours that the profile takes effect on. Values supported are 0 to 23 on the 24-hour clock (AM/PM times are not supported).
	Hours *[]int32 `json:"hours,omitempty"`
	// Minutes - A collection of minutes at which the profile takes effect at.
	Minutes *[]int32 `json:"minutes,omitempty"`
}

// Resource an azure resource object
type Resource struct {
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	return json.Marshal(objectMap)
}

// Response the response to a metrics query.
type Response struct {
	autorest.Response `json:"-"`
	// Cost - The integer value representing the cost of the query, for data case.
	Cost *float64 `json:"cost,omitempty"`
	// Timespan - The timespan for which the data was retrieved. Its value consists of two datetimes concatenated, separated by '/'.  This may be adjusted in the future and returned back from what was originally requested.
	Timespan *string `json:"timespan,omitempty"`
	// Interval - The interval (window size) for which the metric data was returned in.  This may be adjusted in the future and returned back from what was originally requested.  This is not present if a metadata request was made.
	Interval *string `json:"interval,omitempty"`
	// Value - the value of the collection.
	Value *[]Metric `json:"value,omitempty"`
}

// RetentionPolicy specifies the retention policy for the log.
type RetentionPolicy struct {
	// Enabled - a value indicating whether the retention policy is enabled.
	Enabled *bool `json:"enabled,omitempty"`
	// Days - the number of days for the retention in days. A value of 0 will retain the events indefinitely.
	Days *int32 `json:"days,omitempty"`
}

// BasicRuleAction the action that is performed when the alert rule becomes active, and when an alert condition is
// resolved.
type BasicRuleAction interface {
	AsRuleEmailAction() (*RuleEmailAction, bool)
	AsRuleWebhookAction() (*RuleWebhookAction, bool)
	AsRuleAction() (*RuleAction, bool)
}

// RuleAction the action that is performed when the alert rule becomes active, and when an alert condition is
// resolved.
type RuleAction struct {
	// OdataType - Possible values include: 'OdataTypeRuleAction', 'OdataTypeMicrosoftAzureManagementInsightsModelsRuleEmailAction', 'OdataTypeMicrosoftAzureManagementInsightsModelsRuleWebhookAction'
	OdataType OdataTypeBasicRuleAction `json:"odata.type,omitempty"`
}

func unmarshalBasicRuleAction(body []byte) (BasicRuleAction, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["odata.type"] {
	case string(OdataTypeMicrosoftAzureManagementInsightsModelsRuleEmailAction):
		var rea RuleEmailAction
		err := json.Unmarshal(body, &rea)
		return rea, err
	case string(OdataTypeMicrosoftAzureManagementInsightsModelsRuleWebhookAction):
		var rwa RuleWebhookAction
		err := json.Unmarshal(body, &rwa)
		return rwa, err
	default:
		var ra RuleAction
		err := json.Unmarshal(body, &ra)
		return ra, err
	}
}
func unmarshalBasicRuleActionArray(body []byte) ([]BasicRuleAction, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	raArray := make([]BasicRuleAction, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ra, err := unmarshalBasicRuleAction(*rawMessage)
		if err != nil {
			return nil, err
		}
		raArray[index] = ra
	}
	return raArray, nil
}

// MarshalJSON is the custom marshaler for RuleAction.
func (ra RuleAction) MarshalJSON() ([]byte, error) {
	ra.OdataType = OdataTypeRuleAction
	objectMap := make(map[string]interface{})
	if ra.OdataType != "" {
		objectMap["odata.type"] = ra.OdataType
	}
	return json.Marshal(objectMap)
}

// AsRuleEmailAction is the BasicRuleAction implementation for RuleAction.
func (ra RuleAction) AsRuleEmailAction() (*RuleEmailAction, bool) {
	return nil, false
}

// AsRuleWebhookAction is the BasicRuleAction implementation for RuleAction.
func (ra RuleAction) AsRuleWebhookAction() (*RuleWebhookAction, bool) {
	return nil, false
}

// AsRuleAction is the BasicRuleAction implementation for RuleAction.
func (ra RuleAction) AsRuleAction() (*RuleAction, bool) {
	return &ra, true
}

// AsBasicRuleAction is the BasicRuleAction implementation for RuleAction.
func (ra RuleAction) AsBasicRuleAction() (BasicRuleAction, bool) {
	return &ra, true
}

// BasicRuleCondition the condition that results in the alert rule being activated.
type BasicRuleCondition interface {
	AsThresholdRuleCondition() (*ThresholdRuleCondition, bool)
	AsLocationThresholdRuleCondition() (*LocationThresholdRuleCondition, bool)
	AsManagementEventRuleCondition() (*ManagementEventRuleCondition, bool)
	AsRuleCondition() (*RuleCondition, bool)
}

// RuleCondition the condition that results in the alert rule being activated.
type RuleCondition struct {
	// DataSource - the resource from which the rule collects its data. For this type dataSource will always be of type RuleMetricDataSource.
	DataSource BasicRuleDataSource `json:"dataSource,omitempty"`
	// OdataType - Possible values include: 'OdataTypeRuleCondition', 'OdataTypeMicrosoftAzureManagementInsightsModelsThresholdRuleCondition', 'OdataTypeMicrosoftAzureManagementInsightsModelsLocationThresholdRuleCondition', 'OdataTypeMicrosoftAzureManagementInsightsModelsManagementEventRuleCondition'
	OdataType OdataTypeBasicRuleCondition `json:"odata.type,omitempty"`
}

func unmarshalBasicRuleCondition(body []byte) (BasicRuleCondition, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["odata.type"] {
	case string(OdataTypeMicrosoftAzureManagementInsightsModelsThresholdRuleCondition):
		var trc ThresholdRuleCondition
		err := json.Unmarshal(body, &trc)
		return trc, err
	case string(OdataTypeMicrosoftAzureManagementInsightsModelsLocationThresholdRuleCondition):
		var ltrc LocationThresholdRuleCondition
		err := json.Unmarshal(body, &ltrc)
		return ltrc, err
	case string(OdataTypeMicrosoftAzureManagementInsightsModelsManagementEventRuleCondition):
		var merc ManagementEventRuleCondition
		err := json.Unmarshal(body, &merc)
		return merc, err
	default:
		var rc RuleCondition
		err := json.Unmarshal(body, &rc)
		return rc, err
	}
}
func unmarshalBasicRuleConditionArray(body []byte) ([]BasicRuleCondition, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rcArray := make([]BasicRuleCondition, len(rawMessages))

	for index, rawMessage := range rawMessages {
		rc, err := unmarshalBasicRuleCondition(*rawMessage)
		if err != nil {
			return nil, err
		}
		rcArray[index] = rc
	}
	return rcArray, nil
}

// MarshalJSON is the custom marshaler for RuleCondition.
func (rc RuleCondition) MarshalJSON() ([]byte, error) {
	rc.OdataType = OdataTypeRuleCondition
	objectMap := make(map[string]interface{})
	objectMap["dataSource"] = rc.DataSource
	if rc.OdataType != "" {
		objectMap["odata.type"] = rc.OdataType
	}
	return json.Marshal(objectMap)
}

// AsThresholdRuleCondition is the BasicRuleCondition implementation for RuleCondition.
func (rc RuleCondition) AsThresholdRuleCondition() (*ThresholdRuleCondition, bool) {
	return nil, false
}

// AsLocationThresholdRuleCondition is the BasicRuleCondition implementation for RuleCondition.
func (rc RuleCondition) AsLocationThresholdRuleCondition() (*LocationThresholdRuleCondition, bool) {
	return nil, false
}

// AsManagementEventRuleCondition is the BasicRuleCondition implementation for RuleCondition.
func (rc RuleCondition) AsManagementEventRuleCondition() (*ManagementEventRuleCondition, bool) {
	return nil, false
}

// AsRuleCondition is the BasicRuleCondition implementation for RuleCondition.
func (rc RuleCondition) AsRuleCondition() (*RuleCondition, bool) {
	return &rc, true
}

// AsBasicRuleCondition is the BasicRuleCondition implementation for RuleCondition.
func (rc RuleCondition) AsBasicRuleCondition() (BasicRuleCondition, bool) {
	return &rc, true
}

// UnmarshalJSON is the custom unmarshaler for RuleCondition struct.
func (rc *RuleCondition) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "dataSource":
			if v != nil {
				dataSource, err := unmarshalBasicRuleDataSource(*v)
				if err != nil {
					return err
				}
				rc.DataSource = dataSource
			}
		case "odata.type":
			if v != nil {
				var odataType OdataTypeBasicRuleCondition
				err = json.Unmarshal(*v, &odataType)
				if err != nil {
					return err
				}
				rc.OdataType = odataType
			}
		}
	}

	return nil
}

// BasicRuleDataSource the resource from which the rule collects its data.
type BasicRuleDataSource interface {
	AsRuleMetricDataSource() (*RuleMetricDataSource, bool)
	AsRuleManagementEventDataSource() (*RuleManagementEventDataSource, bool)
	AsRuleDataSource() (*RuleDataSource, bool)
}

// RuleDataSource the resource from which the rule collects its data.
type RuleDataSource struct {
	// ResourceURI - the resource identifier of the resource the rule monitors. **NOTE**: this property cannot be updated for an existing rule.
	ResourceURI *string `json:"resourceUri,omitempty"`
	// OdataType - Possible values include: 'OdataTypeRuleDataSource', 'OdataTypeMicrosoftAzureManagementInsightsModelsRuleMetricDataSource', 'OdataTypeMicrosoftAzureManagementInsightsModelsRuleManagementEventDataSource'
	OdataType OdataType `json:"odata.type,omitempty"`
}

func unmarshalBasicRuleDataSource(body []byte) (BasicRuleDataSource, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["odata.type"] {
	case string(OdataTypeMicrosoftAzureManagementInsightsModelsRuleMetricDataSource):
		var rmds RuleMetricDataSource
		err := json.Unmarshal(body, &rmds)
		return rmds, err
	case string(OdataTypeMicrosoftAzureManagementInsightsModelsRuleManagementEventDataSource):
		var rmeds RuleManagementEventDataSource
		err := json.Unmarshal(body, &rmeds)
		return rmeds, err
	default:
		var rds RuleDataSource
		err := json.Unmarshal(body, &rds)
		return rds, err
	}
}
func unmarshalBasicRuleDataSourceArray(body []byte) ([]BasicRuleDataSource, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rdsArray := make([]BasicRuleDataSource, len(rawMessages))

	for index, rawMessage := range rawMessages {
		rds, err := unmarshalBasicRuleDataSource(*rawMessage)
		if err != nil {
			return nil, err
		}
		rdsArray[index] = rds
	}
	return rdsArray, nil
}

// MarshalJSON is the custom marshaler for RuleDataSource.
func (rds RuleDataSource) MarshalJSON() ([]byte, error) {
	rds.OdataType = OdataTypeRuleDataSource
	objectMap := make(map[string]interface{})
	if rds.ResourceURI != nil {
		objectMap["resourceUri"] = rds.ResourceURI
	}
	if rds.OdataType != "" {
		objectMap["odata.type"] = rds.OdataType
	}
	return json.Marshal(objectMap)
}

// AsRuleMetricDataSource is the BasicRuleDataSource implementation for RuleDataSource.
func (rds RuleDataSource) AsRuleMetricDataSource() (*RuleMetricDataSource, bool) {
	return nil, false
}

// AsRuleManagementEventDataSource is the BasicRuleDataSource implementation for RuleDataSource.
func (rds RuleDataSource) AsRuleManagementEventDataSource() (*RuleManagementEventDataSource, bool) {
	return nil, false
}

// AsRuleDataSource is the BasicRuleDataSource implementation for RuleDataSource.
func (rds RuleDataSource) AsRuleDataSource() (*RuleDataSource, bool) {
	return &rds, true
}

// AsBasicRuleDataSource is the BasicRuleDataSource implementation for RuleDataSource.
func (rds RuleDataSource) AsBasicRuleDataSource() (BasicRuleDataSource, bool) {
	return &rds, true
}

// RuleEmailAction specifies the action to send email when the rule condition is evaluated. The
// discriminator is always RuleEmailAction in this case.
type RuleEmailAction struct {
	// SendToServiceOwners - Whether the administrators (service and co-administrators) of the service should be notified when the alert is activated.
	SendToServiceOwners *bool `json:"sendToServiceOwners,omitempty"`
	// CustomEmails - the list of administrator's custom email addresses to notify of the activation of the alert.
	CustomEmails *[]string `json:"customEmails,omitempty"`
	// OdataType - Possible values include: 'OdataTypeRuleAction', 'OdataTypeMicrosoftAzureManagementInsightsModelsRuleEmailAction', 'OdataTypeMicrosoftAzureManagementInsightsModelsRuleWebhookAction'
	OdataType OdataTypeBasicRuleAction `json:"odata.type,omitempty"`
}

// MarshalJSON is the custom marshaler for RuleEmailAction.
func (rea RuleEmailAction) MarshalJSON() ([]byte, error) {
	rea.OdataType = OdataTypeMicrosoftAzureManagementInsightsModelsRuleEmailAction
	objectMap := make(map[string]interface{})
	if rea.SendToServiceOwners != nil {
		objectMap["sendToServiceOwners"] = rea.SendToServiceOwners
	}
	if rea.CustomEmails != nil {
		objectMap["customEmails"] = rea.CustomEmails
	}
	if rea.OdataType != "" {
		objectMap["odata.type"] = rea.OdataType
	}
	return json.Marshal(objectMap)
}

// AsRuleEmailAction is the BasicRuleAction implementation for RuleEmailAction.
func (rea RuleEmailAction) AsRuleEmailAction() (*RuleEmailAction, bool) {
	return &rea, true
}

// AsRuleWebhookAction is the BasicRuleAction implementation for RuleEmailAction.
func (rea RuleEmailAction) AsRuleWebhookAction() (*RuleWebhookAction, bool) {
	return nil, false
}

// AsRuleAction is the BasicRuleAction implementation for RuleEmailAction.
func (rea RuleEmailAction) AsRuleAction() (*RuleAction, bool) {
	return nil, false
}

// AsBasicRuleAction is the BasicRuleAction implementation for RuleEmailAction.
func (rea RuleEmailAction) AsBasicRuleAction() (BasicRuleAction, bool) {
	return &rea, true
}

// RuleManagementEventClaimsDataSource the claims for a rule management event data source.
type RuleManagementEventClaimsDataSource struct {
	// EmailAddress - the email address.
	EmailAddress *string `json:"emailAddress,omitempty"`
}

// RuleManagementEventDataSource a rule management event data source. The discriminator fields is always
// RuleManagementEventDataSource in this case.
type RuleManagementEventDataSource struct {
	// EventName - the event name.
	EventName *string `json:"eventName,omitempty"`
	// EventSource - the event source.
	EventSource *string `json:"eventSource,omitempty"`
	// Level - the level.
	Level *string `json:"level,omitempty"`
	// OperationName - The name of the operation that should be checked for. If no name is provided, any operation will match.
	OperationName *string `json:"operationName,omitempty"`
	// ResourceGroupName - the resource group name.
	ResourceGroupName *string `json:"resourceGroupName,omitempty"`
	// ResourceProviderName - the resource provider name.
	ResourceProviderName *string `json:"resourceProviderName,omitempty"`
	// Status - The status of the operation that should be checked for. If no status is provided, any status will match.
	Status *string `json:"status,omitempty"`
	// SubStatus - the substatus.
	SubStatus *string `json:"subStatus,omitempty"`
	// Claims - the claims.
	Claims *RuleManagementEventClaimsDataSource `json:"claims,omitempty"`
	// ResourceURI - the resource identifier of the resource the rule monitors. **NOTE**: this property cannot be updated for an existing rule.
	ResourceURI *string `json:"resourceUri,omitempty"`
	// OdataType - Possible values include: 'OdataTypeRuleDataSource', 'OdataTypeMicrosoftAzureManagementInsightsModelsRuleMetricDataSource', 'OdataTypeMicrosoftAzureManagementInsightsModelsRuleManagementEventDataSource'
	OdataType OdataType `json:"odata.type,omitempty"`
}

// MarshalJSON is the custom marshaler for RuleManagementEventDataSource.
func (rmeds RuleManagementEventDataSource) MarshalJSON() ([]byte, error) {
	rmeds.OdataType = OdataTypeMicrosoftAzureManagementInsightsModelsRuleManagementEventDataSource
	objectMap := make(map[string]interface{})
	if rmeds.EventName != nil {
		objectMap["eventName"] = rmeds.EventName
	}
	if rmeds.EventSource != nil {
		objectMap["eventSource"] = rmeds.EventSource
	}
	if rmeds.Level != nil {
		objectMap["level"] = rmeds.Level
	}
	if rmeds.OperationName != nil {
		objectMap["operationName"] = rmeds.OperationName
	}
	if rmeds.ResourceGroupName != nil {
		objectMap["resourceGroupName"] = rmeds.ResourceGroupName
	}
	if rmeds.ResourceProviderName != nil {
		objectMap["resourceProviderName"] = rmeds.ResourceProviderName
	}
	if rmeds.Status != nil {
		objectMap["status"] = rmeds.Status
	}
	if rmeds.SubStatus != nil {
		objectMap["subStatus"] = rmeds.SubStatus
	}
	if rmeds.Claims != nil {
		objectMap["claims"] = rmeds.Claims
	}
	if rmeds.ResourceURI != nil {
		objectMap["resourceUri"] = rmeds.ResourceURI
	}
	if rmeds.OdataType != "" {
		objectMap["odata.type"] = rmeds.OdataType
	}
	return json.Marshal(objectMap)
}

// AsRuleMetricDataSource is the BasicRuleDataSource implementation for RuleManagementEventDataSource.
func (rmeds RuleManagementEventDataSource) AsRuleMetricDataSource() (*RuleMetricDataSource, bool) {
	return nil, false
}

// AsRuleManagementEventDataSource is the BasicRuleDataSource implementation for RuleManagementEventDataSource.
func (rmeds RuleManagementEventDataSource) AsRuleManagementEventDataSource() (*RuleManagementEventDataSource, bool) {
	return &rmeds, true
}

// AsRuleDataSource is the BasicRuleDataSource implementation for RuleManagementEventDataSource.
func (rmeds RuleManagementEventDataSource) AsRuleDataSource() (*RuleDataSource, bool) {
	return nil, false
}

// AsBasicRuleDataSource is the BasicRuleDataSource implementation for RuleManagementEventDataSource.
func (rmeds RuleManagementEventDataSource) AsBasicRuleDataSource() (BasicRuleDataSource, bool) {
	return &rmeds, true
}

// RuleMetricDataSource a rule metric data source. The discriminator value is always RuleMetricDataSource
// in this case.
type RuleMetricDataSource struct {
	// MetricName - the name of the metric that defines what the rule monitors.
	MetricName *string `json:"metricName,omitempty"`
	// ResourceURI - the resource identifier of the resource the rule monitors. **NOTE**: this property cannot be updated for an existing rule.
	ResourceURI *string `json:"resourceUri,omitempty"`
	// OdataType - Possible values include: 'OdataTypeRuleDataSource', 'OdataTypeMicrosoftAzureManagementInsightsModelsRuleMetricDataSource', 'OdataTypeMicrosoftAzureManagementInsightsModelsRuleManagementEventDataSource'
	OdataType OdataType `json:"odata.type,omitempty"`
}

// MarshalJSON is the custom marshaler for RuleMetricDataSource.
func (rmds RuleMetricDataSource) MarshalJSON() ([]byte, error) {
	rmds.OdataType = OdataTypeMicrosoftAzureManagementInsightsModelsRuleMetricDataSource
	objectMap := make(map[string]interface{})
	if rmds.MetricName != nil {
		objectMap["metricName"] = rmds.MetricName
	}
	if rmds.ResourceURI != nil {
		objectMap["resourceUri"] = rmds.ResourceURI
	}
	if rmds.OdataType != "" {
		objectMap["odata.type"] = rmds.OdataType
	}
	return json.Marshal(objectMap)
}

// AsRuleMetricDataSource is the BasicRuleDataSource implementation for RuleMetricDataSource.
func (rmds RuleMetricDataSource) AsRuleMetricDataSource() (*RuleMetricDataSource, bool) {
	return &rmds, true
}

// AsRuleManagementEventDataSource is the BasicRuleDataSource implementation for RuleMetricDataSource.
func (rmds RuleMetricDataSource) AsRuleManagementEventDataSource() (*RuleManagementEventDataSource, bool) {
	return nil, false
}

// AsRuleDataSource is the BasicRuleDataSource implementation for RuleMetricDataSource.
func (rmds RuleMetricDataSource) AsRuleDataSource() (*RuleDataSource, bool) {
	return nil, false
}

// AsBasicRuleDataSource is the BasicRuleDataSource implementation for RuleMetricDataSource.
func (rmds RuleMetricDataSource) AsBasicRuleDataSource() (BasicRuleDataSource, bool) {
	return &rmds, true
}

// RuleWebhookAction specifies the action to post to service when the rule condition is evaluated. The
// discriminator is always RuleWebhookAction in this case.
type RuleWebhookAction struct {
	// ServiceURI - the service uri to Post the notification when the alert activates or resolves.
	ServiceURI *string `json:"serviceUri,omitempty"`
	// Properties - the dictionary of custom properties to include with the post operation. These data are appended to the webhook payload.
	Properties map[string]*string `json:"properties"`
	// OdataType - Possible values include: 'OdataTypeRuleAction', 'OdataTypeMicrosoftAzureManagementInsightsModelsRuleEmailAction', 'OdataTypeMicrosoftAzureManagementInsightsModelsRuleWebhookAction'
	OdataType OdataTypeBasicRuleAction `json:"odata.type,omitempty"`
}

// MarshalJSON is the custom marshaler for RuleWebhookAction.
func (rwa RuleWebhookAction) MarshalJSON() ([]byte, error) {
	rwa.OdataType = OdataTypeMicrosoftAzureManagementInsightsModelsRuleWebhookAction
	objectMap := make(map[string]interface{})
	if rwa.ServiceURI != nil {
		objectMap["serviceUri"] = rwa.ServiceURI
	}
	if rwa.Properties != nil {
		objectMap["properties"] = rwa.Properties
	}
	if rwa.OdataType != "" {
		objectMap["odata.type"] = rwa.OdataType
	}
	return json.Marshal(objectMap)
}

// AsRuleEmailAction is the BasicRuleAction implementation for RuleWebhookAction.
func (rwa RuleWebhookAction) AsRuleEmailAction() (*RuleEmailAction, bool) {
	return nil, false
}

// AsRuleWebhookAction is the BasicRuleAction implementation for RuleWebhookAction.
func (rwa RuleWebhookAction) AsRuleWebhookAction() (*RuleWebhookAction, bool) {
	return &rwa, true
}

// AsRuleAction is the BasicRuleAction implementation for RuleWebhookAction.
func (rwa RuleWebhookAction) AsRuleAction() (*RuleAction, bool) {
	return nil, false
}

// AsBasicRuleAction is the BasicRuleAction implementation for RuleWebhookAction.
func (rwa RuleWebhookAction) AsBasicRuleAction() (BasicRuleAction, bool) {
	return &rwa, true
}

// ScaleAction the parameters for the scaling action.
type ScaleAction struct {
	// Direction - the scale direction. Whether the scaling action increases or decreases the number of instances. Possible values include: 'ScaleDirectionNone', 'ScaleDirectionIncrease', 'ScaleDirectionDecrease'
	Direction ScaleDirection `json:"direction,omitempty"`
	// Type - the type of action that should occur when the scale rule fires. Possible values include: 'ChangeCount', 'PercentChangeCount', 'ExactCount'
	Type ScaleType `json:"type,omitempty"`
	// Value - the number of instances that are involved in the scaling action. This value must be 1 or greater. The default value is 1.
	Value *string `json:"value,omitempty"`
	// Cooldown - the amount of time to wait since the last scaling action before this action occurs. It must be between 1 week and 1 minute in ISO 8601 format.
	Cooldown *string `json:"cooldown,omitempty"`
}

// ScaleCapacity the number of instances that can be used during this profile.
type ScaleCapacity struct {
	// Minimum - the minimum number of instances for the resource.
	Minimum *string `json:"minimum,omitempty"`
	// Maximum - the maximum number of instances for the resource. The actual maximum number of instances is limited by the cores that are available in the subscription.
	Maximum *string `json:"maximum,omitempty"`
	// Default - the number of instances that will be set if metrics are not available for evaluation. The default is only used if the current instance count is lower than the default.
	Default *string `json:"default,omitempty"`
}

// ScaleRule a rule that provide the triggers and parameters for the scaling action.
type ScaleRule struct {
	// MetricTrigger - the trigger that results in a scaling action.
	MetricTrigger *MetricTrigger `json:"metricTrigger,omitempty"`
	// ScaleAction - the parameters for the scaling action.
	ScaleAction *ScaleAction `json:"scaleAction,omitempty"`
}

// SenderAuthorization the authorization used by the user who has performed the operation that led to this
// event. This captures the RBAC properties of the event. These usually include the 'action', 'role' and
// the 'scope'
type SenderAuthorization struct {
	// Action - the permissible actions. For instance: microsoft.support/supporttickets/write
	Action *string `json:"action,omitempty"`
	// Role - the role of the user. For instance: Subscription Admin
	Role *string `json:"role,omitempty"`
	// Scope - the scope.
	Scope *string `json:"scope,omitempty"`
}

// SmsReceiver an SMS receiver.
type SmsReceiver struct {
	// Name - The name of the SMS receiver. Names must be unique across all receivers within an action group.
	Name *string `json:"name,omitempty"`
	// CountryCode - The country code of the SMS receiver.
	CountryCode *string `json:"countryCode,omitempty"`
	// PhoneNumber - The phone number of the SMS receiver.
	PhoneNumber *string `json:"phoneNumber,omitempty"`
	// Status - READ-ONLY; The status of the receiver. Possible values include: 'NotSpecified', 'Enabled', 'Disabled'
	Status ReceiverStatus `json:"status,omitempty"`
}

// ThresholdRuleCondition a rule condition based on a metric crossing a threshold.
type ThresholdRuleCondition struct {
	// Operator - the operator used to compare the data and the threshold. Possible values include: 'ConditionOperatorGreaterThan', 'ConditionOperatorGreaterThanOrEqual', 'ConditionOperatorLessThan', 'ConditionOperatorLessThanOrEqual'
	Operator ConditionOperator `json:"operator,omitempty"`
	// Threshold - the threshold value that activates the alert.
	Threshold *float64 `json:"threshold,omitempty"`
	// WindowSize - the period of time (in ISO 8601 duration format) that is used to monitor alert activity based on the threshold. If specified then it must be between 5 minutes and 1 day.
	WindowSize *string `json:"windowSize,omitempty"`
	// TimeAggregation - the time aggregation operator. How the data that are collected should be combined over time. The default value is the PrimaryAggregationType of the Metric. Possible values include: 'TimeAggregationOperatorAverage', 'TimeAggregationOperatorMinimum', 'TimeAggregationOperatorMaximum', 'TimeAggregationOperatorTotal', 'TimeAggregationOperatorLast'
	TimeAggregation TimeAggregationOperator `json:"timeAggregation,omitempty"`
	// DataSource - the resource from which the rule collects its data. For this type dataSource will always be of type RuleMetricDataSource.
	DataSource BasicRuleDataSource `json:"dataSource,omitempty"`
	// OdataType - Possible values include: 'OdataTypeRuleCondition', 'OdataTypeMicrosoftAzureManagementInsightsModelsThresholdRuleCondition', 'OdataTypeMicrosoftAzureManagementInsightsModelsLocationThresholdRuleCondition', 'OdataTypeMicrosoftAzureManagementInsightsModelsManagementEventRuleCondition'
	OdataType OdataTypeBasicRuleCondition `json:"odata.type,omitempty"`
}

// MarshalJSON is the custom marshaler for ThresholdRuleCondition.
func (trc ThresholdRuleCondition) MarshalJSON() ([]byte, error) {
	trc.OdataType = OdataTypeMicrosoftAzureManagementInsightsModelsThresholdRuleCondition
	objectMap := make(map[string]interface{})
	if trc.Operator != "" {
		objectMap["operator"] = trc.Operator
	}
	if trc.Threshold != nil {
		objectMap["threshold"] = trc.Threshold
	}
	if trc.WindowSize != nil {
		objectMap["windowSize"] = trc.WindowSize
	}
	if trc.TimeAggregation != "" {
		objectMap["timeAggregation"] = trc.TimeAggregation
	}
	objectMap["dataSource"] = trc.DataSource
	if trc.OdataType != "" {
		objectMap["odata.type"] = trc.OdataType
	}
	return json.Marshal(objectMap)
}

// AsThresholdRuleCondition is the BasicRuleCondition implementation for ThresholdRuleCondition.
func (trc ThresholdRuleCondition) AsThresholdRuleCondition() (*ThresholdRuleCondition, bool) {
	return &trc, true
}

// AsLocationThresholdRuleCondition is the BasicRuleCondition implementation for ThresholdRuleCondition.
func (trc ThresholdRuleCondition) AsLocationThresholdRuleCondition() (*LocationThresholdRuleCondition, bool) {
	return nil, false
}

// AsManagementEventRuleCondition is the BasicRuleCondition implementation for ThresholdRuleCondition.
func (trc ThresholdRuleCondition) AsManagementEventRuleCondition() (*ManagementEventRuleCondition, bool) {
	return nil, false
}

// AsRuleCondition is the BasicRuleCondition implementation for ThresholdRuleCondition.
func (trc ThresholdRuleCondition) AsRuleCondition() (*RuleCondition, bool) {
	return nil, false
}

// AsBasicRuleCondition is the BasicRuleCondition implementation for ThresholdRuleCondition.
func (trc ThresholdRuleCondition) AsBasicRuleCondition() (BasicRuleCondition, bool) {
	return &trc, true
}

// UnmarshalJSON is the custom unmarshaler for ThresholdRuleCondition struct.
func (trc *ThresholdRuleCondition) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "operator":
			if v != nil {
				var operator ConditionOperator
				err = json.Unmarshal(*v, &operator)
				if err != nil {
					return err
				}
				trc.Operator = operator
			}
		case "threshold":
			if v != nil {
				var threshold float64
				err = json.Unmarshal(*v, &threshold)
				if err != nil {
					return err
				}
				trc.Threshold = &threshold
			}
		case "windowSize":
			if v != nil {
				var windowSize string
				err = json.Unmarshal(*v, &windowSize)
				if err != nil {
					return err
				}
				trc.WindowSize = &windowSize
			}
		case "timeAggregation":
			if v != nil {
				var timeAggregation TimeAggregationOperator
				err = json.Unmarshal(*v, &timeAggregation)
				if err != nil {
					return err
				}
				trc.TimeAggregation = timeAggregation
			}
		case "dataSource":
			if v != nil {
				dataSource, err := unmarshalBasicRuleDataSource(*v)
				if err != nil {
					return err
				}
				trc.DataSource = dataSource
			}
		case "odata.type":
			if v != nil {
				var odataType OdataTypeBasicRuleCondition
				err = json.Unmarshal(*v, &odataType)
				if err != nil {
					return err
				}
				trc.OdataType = odataType
			}
		}
	}

	return nil
}

// TimeSeriesElement a time series result type. The discriminator value is always TimeSeries in this case.
type TimeSeriesElement struct {
	// Metadatavalues - the metadata values returned if $filter was specified in the call.
	Metadatavalues *[]MetadataValue `json:"metadatavalues,omitempty"`
	// Data - An array of data points representing the metric values.  This is only returned if a result type of data is specified.
	Data *[]MetricValue `json:"data,omitempty"`
}

// TimeSeriesInformation the time series info needed for calculating the baseline.
type TimeSeriesInformation struct {
	// Sensitivities - the list of sensitivities for calculating the baseline.
	Sensitivities *[]string `json:"sensitivities,omitempty"`
	// Values - The metric values to calculate the baseline.
	Values *[]float64 `json:"values,omitempty"`
	// Timestamps - the array of timestamps of the baselines.
	Timestamps *[]date.Time `json:"timestamps,omitempty"`
}

// TimeWindow a specific date-time for the profile.
type TimeWindow struct {
	// TimeZone - the timezone of the start and end times for the profile. Some examples of valid time zones are: Dateline Standard Time, UTC-11, Hawaiian Standard Time, Alaskan Standard Time, Pacific Standard Time (Mexico), Pacific Standard Time, US Mountain Standard Time, Mountain Standard Time (Mexico), Mountain Standard Time, Central America Standard Time, Central Standard Time, Central Standard Time (Mexico), Canada Central Standard Time, SA Pacific Standard Time, Eastern Standard Time, US Eastern Standard Time, Venezuela Standard Time, Paraguay Standard Time, Atlantic Standard Time, Central Brazilian Standard Time, SA Western Standard Time, Pacific SA Standard Time, Newfoundland Standard Time, E. South America Standard Time, Argentina Standard Time, SA Eastern Standard Time, Greenland Standard Time, Montevideo Standard Time, Bahia Standard Time, UTC-02, Mid-Atlantic Standard Time, Azores Standard Time, Cape Verde Standard Time, Morocco Standard Time, UTC, GMT Standard Time, Greenwich Standard Time, W. Europe Standard Time, Central Europe Standard Time, Romance Standard Time, Central European Standard Time, W. Central Africa Standard Time, Namibia Standard Time, Jordan Standard Time, GTB Standard Time, Middle East Standard Time, Egypt Standard Time, Syria Standard Time, E. Europe Standard Time, South Africa Standard Time, FLE Standard Time, Turkey Standard Time, Israel Standard Time, Kaliningrad Standard Time, Libya Standard Time, Arabic Standard Time, Arab Standard Time, Belarus Standard Time, Russian Standard Time, E. Africa Standard Time, Iran Standard Time, Arabian Standard Time, Azerbaijan Standard Time, Russia Time Zone 3, Mauritius Standard Time, Georgian Standard Time, Caucasus Standard Time, Afghanistan Standard Time, West Asia Standard Time, Ekaterinburg Standard Time, Pakistan Standard Time, India Standard Time, Sri Lanka Standard Time, Nepal Standard Time, Central Asia Standard Time, Bangladesh Standard Time, N. Central Asia Standard Time, Myanmar Standard Time, SE Asia Standard Time, North Asia Standard Time, China Standard Time, North Asia East Standard Time, Singapore Standard Time, W. Australia Standard Time, Taipei Standard Time, Ulaanbaatar Standard Time, Tokyo Standard Time, Korea Standard Time, Yakutsk Standard Time, Cen. Australia Standard Time, AUS Central Standard Time, E. Australia Standard Time, AUS Eastern Standard Time, West Pacific Standard Time, Tasmania Standard Time, Magadan Standard Time, Vladivostok Standard Time, Russia Time Zone 10, Central Pacific Standard Time, Russia Time Zone 11, New Zealand Standard Time, UTC+12, Fiji Standard Time, Kamchatka Standard Time, Tonga Standard Time, Samoa Standard Time, Line Islands Standard Time
	TimeZone *string `json:"timeZone,omitempty"`
	// Start - the start time for the profile in ISO 8601 format.
	Start *date.Time `json:"start,omitempty"`
	// End - the end time for the profile in ISO 8601 format.
	End *date.Time `json:"end,omitempty"`
}

// VoiceReceiver a voice receiver.
type VoiceReceiver struct {
	// Name - The name of the voice receiver. Names must be unique across all receivers within an action group.
	Name *string `json:"name,omitempty"`
	// CountryCode - The country code of the voice receiver.
	CountryCode *string `json:"countryCode,omitempty"`
	// PhoneNumber - The phone number of the voice receiver.
	PhoneNumber *string `json:"phoneNumber,omitempty"`
}

// WebhookNotification webhook notification of an autoscale event.
type WebhookNotification struct {
	// ServiceURI - the service address to receive the notification.
	ServiceURI *string `json:"serviceUri,omitempty"`
	// Properties - a property bag of settings. This value can be empty.
	Properties map[string]*string `json:"properties"`
}

// MarshalJSON is the custom marshaler for WebhookNotification.
func (wn WebhookNotification) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wn.ServiceURI != nil {
		objectMap["serviceUri"] = wn.ServiceURI
	}
	if wn.Properties != nil {
		objectMap["properties"] = wn.Properties
	}
	return json.Marshal(objectMap)
}

// WebhookReceiver a webhook receiver.
type WebhookReceiver struct {
	// Name - The name of the webhook receiver. Names must be unique across all receivers within an action group.
	Name *string `json:"name,omitempty"`
	// ServiceURI - The URI where webhooks should be sent.
	ServiceURI *string `json:"serviceUri,omitempty"`
}
