package datamigration

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/datamigration/mgmt/2018-04-19/datamigration"

// AuthenticationType enumerates the values for authentication type.
type AuthenticationType string

const (
	// ActiveDirectoryIntegrated ...
	ActiveDirectoryIntegrated AuthenticationType = "ActiveDirectoryIntegrated"
	// ActiveDirectoryPassword ...
	ActiveDirectoryPassword AuthenticationType = "ActiveDirectoryPassword"
	// None ...
	None AuthenticationType = "None"
	// SQLAuthentication ...
	SQLAuthentication AuthenticationType = "SqlAuthentication"
	// WindowsAuthentication ...
	WindowsAuthentication AuthenticationType = "WindowsAuthentication"
)

// PossibleAuthenticationTypeValues returns an array of possible values for the AuthenticationType const type.
func PossibleAuthenticationTypeValues() []AuthenticationType {
	return []AuthenticationType{ActiveDirectoryIntegrated, ActiveDirectoryPassword, None, SQLAuthentication, WindowsAuthentication}
}

// BackupFileStatus enumerates the values for backup file status.
type BackupFileStatus string

const (
	// Arrived ...
	Arrived BackupFileStatus = "Arrived"
	// Cancelled ...
	Cancelled BackupFileStatus = "Cancelled"
	// Queued ...
	Queued BackupFileStatus = "Queued"
	// Restored ...
	Restored BackupFileStatus = "Restored"
	// Restoring ...
	Restoring BackupFileStatus = "Restoring"
	// Uploaded ...
	Uploaded BackupFileStatus = "Uploaded"
	// Uploading ...
	Uploading BackupFileStatus = "Uploading"
)

// PossibleBackupFileStatusValues returns an array of possible values for the BackupFileStatus const type.
func PossibleBackupFileStatusValues() []BackupFileStatus {
	return []BackupFileStatus{Arrived, Cancelled, Queued, Restored, Restoring, Uploaded, Uploading}
}

// BackupMode enumerates the values for backup mode.
type BackupMode string

const (
	// CreateBackup ...
	CreateBackup BackupMode = "CreateBackup"
	// ExistingBackup ...
	ExistingBackup BackupMode = "ExistingBackup"
)

// PossibleBackupModeValues returns an array of possible values for the BackupMode const type.
func PossibleBackupModeValues() []BackupMode {
	return []BackupMode{CreateBackup, ExistingBackup}
}

// BackupType enumerates the values for backup type.
type BackupType string

const (
	// BackupTypeDatabase ...
	BackupTypeDatabase BackupType = "Database"
	// BackupTypeDifferentialDatabase ...
	BackupTypeDifferentialDatabase BackupType = "DifferentialDatabase"
	// BackupTypeDifferentialFile ...
	BackupTypeDifferentialFile BackupType = "DifferentialFile"
	// BackupTypeDifferentialPartial ...
	BackupTypeDifferentialPartial BackupType = "DifferentialPartial"
	// BackupTypeFile ...
	BackupTypeFile BackupType = "File"
	// BackupTypePartial ...
	BackupTypePartial BackupType = "Partial"
	// BackupTypeTransactionLog ...
	BackupTypeTransactionLog BackupType = "TransactionLog"
)

// PossibleBackupTypeValues returns an array of possible values for the BackupType const type.
func PossibleBackupTypeValues() []BackupType {
	return []BackupType{BackupTypeDatabase, BackupTypeDifferentialDatabase, BackupTypeDifferentialFile, BackupTypeDifferentialPartial, BackupTypeFile, BackupTypePartial, BackupTypeTransactionLog}
}

// CommandState enumerates the values for command state.
type CommandState string

const (
	// Accepted ...
	Accepted CommandState = "Accepted"
	// Failed ...
	Failed CommandState = "Failed"
	// Running ...
	Running CommandState = "Running"
	// Succeeded ...
	Succeeded CommandState = "Succeeded"
	// Unknown ...
	Unknown CommandState = "Unknown"
)

// PossibleCommandStateValues returns an array of possible values for the CommandState const type.
func PossibleCommandStateValues() []CommandState {
	return []CommandState{Accepted, Failed, Running, Succeeded, Unknown}
}

// CommandType enumerates the values for command type.
type CommandType string

const (
	// CommandTypeMigrateSQLServerAzureDbSQLMiComplete ...
	CommandTypeMigrateSQLServerAzureDbSQLMiComplete CommandType = "Migrate.SqlServer.AzureDbSqlMi.Complete"
	// CommandTypeMigrateSyncCompleteDatabase ...
	CommandTypeMigrateSyncCompleteDatabase CommandType = "Migrate.Sync.Complete.Database"
	// CommandTypeUnknown ...
	CommandTypeUnknown CommandType = "Unknown"
)

// PossibleCommandTypeValues returns an array of possible values for the CommandType const type.
func PossibleCommandTypeValues() []CommandType {
	return []CommandType{CommandTypeMigrateSQLServerAzureDbSQLMiComplete, CommandTypeMigrateSyncCompleteDatabase, CommandTypeUnknown}
}

// DatabaseCompatLevel enumerates the values for database compat level.
type DatabaseCompatLevel string

const (
	// CompatLevel100 ...
	CompatLevel100 DatabaseCompatLevel = "CompatLevel100"
	// CompatLevel110 ...
	CompatLevel110 DatabaseCompatLevel = "CompatLevel110"
	// CompatLevel120 ...
	CompatLevel120 DatabaseCompatLevel = "CompatLevel120"
	// CompatLevel130 ...
	CompatLevel130 DatabaseCompatLevel = "CompatLevel130"
	// CompatLevel140 ...
	CompatLevel140 DatabaseCompatLevel = "CompatLevel140"
	// CompatLevel80 ...
	CompatLevel80 DatabaseCompatLevel = "CompatLevel80"
	// CompatLevel90 ...
	CompatLevel90 DatabaseCompatLevel = "CompatLevel90"
)

// PossibleDatabaseCompatLevelValues returns an array of possible values for the DatabaseCompatLevel const type.
func PossibleDatabaseCompatLevelValues() []DatabaseCompatLevel {
	return []DatabaseCompatLevel{CompatLevel100, CompatLevel110, CompatLevel120, CompatLevel130, CompatLevel140, CompatLevel80, CompatLevel90}
}

// DatabaseFileType enumerates the values for database file type.
type DatabaseFileType string

const (
	// Filestream ...
	Filestream DatabaseFileType = "Filestream"
	// Fulltext ...
	Fulltext DatabaseFileType = "Fulltext"
	// Log ...
	Log DatabaseFileType = "Log"
	// NotSupported ...
	NotSupported DatabaseFileType = "NotSupported"
	// Rows ...
	Rows DatabaseFileType = "Rows"
)

// PossibleDatabaseFileTypeValues returns an array of possible values for the DatabaseFileType const type.
func PossibleDatabaseFileTypeValues() []DatabaseFileType {
	return []DatabaseFileType{Filestream, Fulltext, Log, NotSupported, Rows}
}

// DatabaseMigrationStage enumerates the values for database migration stage.
type DatabaseMigrationStage string

const (
	// DatabaseMigrationStageBackup ...
	DatabaseMigrationStageBackup DatabaseMigrationStage = "Backup"
	// DatabaseMigrationStageCompleted ...
	DatabaseMigrationStageCompleted DatabaseMigrationStage = "Completed"
	// DatabaseMigrationStageFileCopy ...
	DatabaseMigrationStageFileCopy DatabaseMigrationStage = "FileCopy"
	// DatabaseMigrationStageInitialize ...
	DatabaseMigrationStageInitialize DatabaseMigrationStage = "Initialize"
	// DatabaseMigrationStageNone ...
	DatabaseMigrationStageNone DatabaseMigrationStage = "None"
	// DatabaseMigrationStageRestore ...
	DatabaseMigrationStageRestore DatabaseMigrationStage = "Restore"
)

// PossibleDatabaseMigrationStageValues returns an array of possible values for the DatabaseMigrationStage const type.
func PossibleDatabaseMigrationStageValues() []DatabaseMigrationStage {
	return []DatabaseMigrationStage{DatabaseMigrationStageBackup, DatabaseMigrationStageCompleted, DatabaseMigrationStageFileCopy, DatabaseMigrationStageInitialize, DatabaseMigrationStageNone, DatabaseMigrationStageRestore}
}

// DatabaseMigrationState enumerates the values for database migration state.
type DatabaseMigrationState string

const (
	// CANCELLED ...
	CANCELLED DatabaseMigrationState = "CANCELLED"
	// COMPLETED ...
	COMPLETED DatabaseMigrationState = "COMPLETED"
	// CUTOVERSTART ...
	CUTOVERSTART DatabaseMigrationState = "CUTOVER_START"
	// FAILED ...
	FAILED DatabaseMigrationState = "FAILED"
	// FULLBACKUPUPLOADSTART ...
	FULLBACKUPUPLOADSTART DatabaseMigrationState = "FULL_BACKUP_UPLOAD_START"
	// INITIAL ...
	INITIAL DatabaseMigrationState = "INITIAL"
	// LOGSHIPPINGSTART ...
	LOGSHIPPINGSTART DatabaseMigrationState = "LOG_SHIPPING_START"
	// POSTCUTOVERCOMPLETE ...
	POSTCUTOVERCOMPLETE DatabaseMigrationState = "POST_CUTOVER_COMPLETE"
	// UNDEFINED ...
	UNDEFINED DatabaseMigrationState = "UNDEFINED"
	// UPLOADLOGFILESSTART ...
	UPLOADLOGFILESSTART DatabaseMigrationState = "UPLOAD_LOG_FILES_START"
)

// PossibleDatabaseMigrationStateValues returns an array of possible values for the DatabaseMigrationState const type.
func PossibleDatabaseMigrationStateValues() []DatabaseMigrationState {
	return []DatabaseMigrationState{CANCELLED, COMPLETED, CUTOVERSTART, FAILED, FULLBACKUPUPLOADSTART, INITIAL, LOGSHIPPINGSTART, POSTCUTOVERCOMPLETE, UNDEFINED, UPLOADLOGFILESSTART}
}

// DatabaseState enumerates the values for database state.
type DatabaseState string

const (
	// DatabaseStateCopying ...
	DatabaseStateCopying DatabaseState = "Copying"
	// DatabaseStateEmergency ...
	DatabaseStateEmergency DatabaseState = "Emergency"
	// DatabaseStateOffline ...
	DatabaseStateOffline DatabaseState = "Offline"
	// DatabaseStateOfflineSecondary ...
	DatabaseStateOfflineSecondary DatabaseState = "OfflineSecondary"
	// DatabaseStateOnline ...
	DatabaseStateOnline DatabaseState = "Online"
	// DatabaseStateRecovering ...
	DatabaseStateRecovering DatabaseState = "Recovering"
	// DatabaseStateRecoveryPending ...
	DatabaseStateRecoveryPending DatabaseState = "RecoveryPending"
	// DatabaseStateRestoring ...
	DatabaseStateRestoring DatabaseState = "Restoring"
	// DatabaseStateSuspect ...
	DatabaseStateSuspect DatabaseState = "Suspect"
)

// PossibleDatabaseStateValues returns an array of possible values for the DatabaseState const type.
func PossibleDatabaseStateValues() []DatabaseState {
	return []DatabaseState{DatabaseStateCopying, DatabaseStateEmergency, DatabaseStateOffline, DatabaseStateOfflineSecondary, DatabaseStateOnline, DatabaseStateRecovering, DatabaseStateRecoveryPending, DatabaseStateRestoring, DatabaseStateSuspect}
}

// ErrorType enumerates the values for error type.
type ErrorType string

const (
	// ErrorTypeDefault ...
	ErrorTypeDefault ErrorType = "Default"
	// ErrorTypeError ...
	ErrorTypeError ErrorType = "Error"
	// ErrorTypeWarning ...
	ErrorTypeWarning ErrorType = "Warning"
)

// PossibleErrorTypeValues returns an array of possible values for the ErrorType const type.
func PossibleErrorTypeValues() []ErrorType {
	return []ErrorType{ErrorTypeDefault, ErrorTypeError, ErrorTypeWarning}
}

// LoginMigrationStage enumerates the values for login migration stage.
type LoginMigrationStage string

const (
	// LoginMigrationStageAssignRoleMembership ...
	LoginMigrationStageAssignRoleMembership LoginMigrationStage = "AssignRoleMembership"
	// LoginMigrationStageAssignRoleOwnership ...
	LoginMigrationStageAssignRoleOwnership LoginMigrationStage = "AssignRoleOwnership"
	// LoginMigrationStageCompleted ...
	LoginMigrationStageCompleted LoginMigrationStage = "Completed"
	// LoginMigrationStageEstablishObjectPermissions ...
	LoginMigrationStageEstablishObjectPermissions LoginMigrationStage = "EstablishObjectPermissions"
	// LoginMigrationStageEstablishServerPermissions ...
	LoginMigrationStageEstablishServerPermissions LoginMigrationStage = "EstablishServerPermissions"
	// LoginMigrationStageEstablishUserMapping ...
	LoginMigrationStageEstablishUserMapping LoginMigrationStage = "EstablishUserMapping"
	// LoginMigrationStageInitialize ...
	LoginMigrationStageInitialize LoginMigrationStage = "Initialize"
	// LoginMigrationStageLoginMigration ...
	LoginMigrationStageLoginMigration LoginMigrationStage = "LoginMigration"
	// LoginMigrationStageNone ...
	LoginMigrationStageNone LoginMigrationStage = "None"
)

// PossibleLoginMigrationStageValues returns an array of possible values for the LoginMigrationStage const type.
func PossibleLoginMigrationStageValues() []LoginMigrationStage {
	return []LoginMigrationStage{LoginMigrationStageAssignRoleMembership, LoginMigrationStageAssignRoleOwnership, LoginMigrationStageCompleted, LoginMigrationStageEstablishObjectPermissions, LoginMigrationStageEstablishServerPermissions, LoginMigrationStageEstablishUserMapping, LoginMigrationStageInitialize, LoginMigrationStageLoginMigration, LoginMigrationStageNone}
}

// LoginType enumerates the values for login type.
type LoginType string

const (
	// AsymmetricKey ...
	AsymmetricKey LoginType = "AsymmetricKey"
	// Certificate ...
	Certificate LoginType = "Certificate"
	// ExternalGroup ...
	ExternalGroup LoginType = "ExternalGroup"
	// ExternalUser ...
	ExternalUser LoginType = "ExternalUser"
	// SQLLogin ...
	SQLLogin LoginType = "SqlLogin"
	// WindowsGroup ...
	WindowsGroup LoginType = "WindowsGroup"
	// WindowsUser ...
	WindowsUser LoginType = "WindowsUser"
)

// PossibleLoginTypeValues returns an array of possible values for the LoginType const type.
func PossibleLoginTypeValues() []LoginType {
	return []LoginType{AsymmetricKey, Certificate, ExternalGroup, ExternalUser, SQLLogin, WindowsGroup, WindowsUser}
}

// MigrationState enumerates the values for migration state.
type MigrationState string

const (
	// MigrationStateCompleted ...
	MigrationStateCompleted MigrationState = "Completed"
	// MigrationStateFailed ...
	MigrationStateFailed MigrationState = "Failed"
	// MigrationStateInProgress ...
	MigrationStateInProgress MigrationState = "InProgress"
	// MigrationStateNone ...
	MigrationStateNone MigrationState = "None"
	// MigrationStateSkipped ...
	MigrationStateSkipped MigrationState = "Skipped"
	// MigrationStateStopped ...
	MigrationStateStopped MigrationState = "Stopped"
	// MigrationStateWarning ...
	MigrationStateWarning MigrationState = "Warning"
)

// PossibleMigrationStateValues returns an array of possible values for the MigrationState const type.
func PossibleMigrationStateValues() []MigrationState {
	return []MigrationState{MigrationStateCompleted, MigrationStateFailed, MigrationStateInProgress, MigrationStateNone, MigrationStateSkipped, MigrationStateStopped, MigrationStateWarning}
}

// MigrationStatus enumerates the values for migration status.
type MigrationStatus string

const (
	// MigrationStatusCompleted ...
	MigrationStatusCompleted MigrationStatus = "Completed"
	// MigrationStatusCompletedWithWarnings ...
	MigrationStatusCompletedWithWarnings MigrationStatus = "CompletedWithWarnings"
	// MigrationStatusConfigured ...
	MigrationStatusConfigured MigrationStatus = "Configured"
	// MigrationStatusConnecting ...
	MigrationStatusConnecting MigrationStatus = "Connecting"
	// MigrationStatusDefault ...
	MigrationStatusDefault MigrationStatus = "Default"
	// MigrationStatusError ...
	MigrationStatusError MigrationStatus = "Error"
	// MigrationStatusRunning ...
	MigrationStatusRunning MigrationStatus = "Running"
	// MigrationStatusSelectLogins ...
	MigrationStatusSelectLogins MigrationStatus = "SelectLogins"
	// MigrationStatusSourceAndTargetSelected ...
	MigrationStatusSourceAndTargetSelected MigrationStatus = "SourceAndTargetSelected"
	// MigrationStatusStopped ...
	MigrationStatusStopped MigrationStatus = "Stopped"
)

// PossibleMigrationStatusValues returns an array of possible values for the MigrationStatus const type.
func PossibleMigrationStatusValues() []MigrationStatus {
	return []MigrationStatus{MigrationStatusCompleted, MigrationStatusCompletedWithWarnings, MigrationStatusConfigured, MigrationStatusConnecting, MigrationStatusDefault, MigrationStatusError, MigrationStatusRunning, MigrationStatusSelectLogins, MigrationStatusSourceAndTargetSelected, MigrationStatusStopped}
}

// MySQLTargetPlatformType enumerates the values for my sql target platform type.
type MySQLTargetPlatformType string

const (
	// AzureDbForMySQL ...
	AzureDbForMySQL MySQLTargetPlatformType = "AzureDbForMySQL"
	// SQLServer ...
	SQLServer MySQLTargetPlatformType = "SqlServer"
)

// PossibleMySQLTargetPlatformTypeValues returns an array of possible values for the MySQLTargetPlatformType const type.
func PossibleMySQLTargetPlatformTypeValues() []MySQLTargetPlatformType {
	return []MySQLTargetPlatformType{AzureDbForMySQL, SQLServer}
}

// NameCheckFailureReason enumerates the values for name check failure reason.
type NameCheckFailureReason string

const (
	// AlreadyExists ...
	AlreadyExists NameCheckFailureReason = "AlreadyExists"
	// Invalid ...
	Invalid NameCheckFailureReason = "Invalid"
)

// PossibleNameCheckFailureReasonValues returns an array of possible values for the NameCheckFailureReason const type.
func PossibleNameCheckFailureReasonValues() []NameCheckFailureReason {
	return []NameCheckFailureReason{AlreadyExists, Invalid}
}

// ObjectType enumerates the values for object type.
type ObjectType string

const (
	// Function ...
	Function ObjectType = "Function"
	// StoredProcedures ...
	StoredProcedures ObjectType = "StoredProcedures"
	// Table ...
	Table ObjectType = "Table"
	// User ...
	User ObjectType = "User"
	// View ...
	View ObjectType = "View"
)

// PossibleObjectTypeValues returns an array of possible values for the ObjectType const type.
func PossibleObjectTypeValues() []ObjectType {
	return []ObjectType{Function, StoredProcedures, Table, User, View}
}

// ProjectProvisioningState enumerates the values for project provisioning state.
type ProjectProvisioningState string

const (
	// ProjectProvisioningStateDeleting ...
	ProjectProvisioningStateDeleting ProjectProvisioningState = "Deleting"
	// ProjectProvisioningStateSucceeded ...
	ProjectProvisioningStateSucceeded ProjectProvisioningState = "Succeeded"
)

// PossibleProjectProvisioningStateValues returns an array of possible values for the ProjectProvisioningState const type.
func PossibleProjectProvisioningStateValues() []ProjectProvisioningState {
	return []ProjectProvisioningState{ProjectProvisioningStateDeleting, ProjectProvisioningStateSucceeded}
}

// ProjectSourcePlatform enumerates the values for project source platform.
type ProjectSourcePlatform string

const (
	// ProjectSourcePlatformSQL ...
	ProjectSourcePlatformSQL ProjectSourcePlatform = "SQL"
	// ProjectSourcePlatformUnknown ...
	ProjectSourcePlatformUnknown ProjectSourcePlatform = "Unknown"
)

// PossibleProjectSourcePlatformValues returns an array of possible values for the ProjectSourcePlatform const type.
func PossibleProjectSourcePlatformValues() []ProjectSourcePlatform {
	return []ProjectSourcePlatform{ProjectSourcePlatformSQL, ProjectSourcePlatformUnknown}
}

// ProjectTargetPlatform enumerates the values for project target platform.
type ProjectTargetPlatform string

const (
	// ProjectTargetPlatformSQLDB ...
	ProjectTargetPlatformSQLDB ProjectTargetPlatform = "SQLDB"
	// ProjectTargetPlatformUnknown ...
	ProjectTargetPlatformUnknown ProjectTargetPlatform = "Unknown"
)

// PossibleProjectTargetPlatformValues returns an array of possible values for the ProjectTargetPlatform const type.
func PossibleProjectTargetPlatformValues() []ProjectTargetPlatform {
	return []ProjectTargetPlatform{ProjectTargetPlatformSQLDB, ProjectTargetPlatformUnknown}
}

// ResourceSkuCapacityScaleType enumerates the values for resource sku capacity scale type.
type ResourceSkuCapacityScaleType string

const (
	// ResourceSkuCapacityScaleTypeAutomatic ...
	ResourceSkuCapacityScaleTypeAutomatic ResourceSkuCapacityScaleType = "Automatic"
	// ResourceSkuCapacityScaleTypeManual ...
	ResourceSkuCapacityScaleTypeManual ResourceSkuCapacityScaleType = "Manual"
	// ResourceSkuCapacityScaleTypeNone ...
	ResourceSkuCapacityScaleTypeNone ResourceSkuCapacityScaleType = "None"
)

// PossibleResourceSkuCapacityScaleTypeValues returns an array of possible values for the ResourceSkuCapacityScaleType const type.
func PossibleResourceSkuCapacityScaleTypeValues() []ResourceSkuCapacityScaleType {
	return []ResourceSkuCapacityScaleType{ResourceSkuCapacityScaleTypeAutomatic, ResourceSkuCapacityScaleTypeManual, ResourceSkuCapacityScaleTypeNone}
}

// ResourceSkuRestrictionsReasonCode enumerates the values for resource sku restrictions reason code.
type ResourceSkuRestrictionsReasonCode string

const (
	// NotAvailableForSubscription ...
	NotAvailableForSubscription ResourceSkuRestrictionsReasonCode = "NotAvailableForSubscription"
	// QuotaID ...
	QuotaID ResourceSkuRestrictionsReasonCode = "QuotaId"
)

// PossibleResourceSkuRestrictionsReasonCodeValues returns an array of possible values for the ResourceSkuRestrictionsReasonCode const type.
func PossibleResourceSkuRestrictionsReasonCodeValues() []ResourceSkuRestrictionsReasonCode {
	return []ResourceSkuRestrictionsReasonCode{NotAvailableForSubscription, QuotaID}
}

// ResourceSkuRestrictionsType enumerates the values for resource sku restrictions type.
type ResourceSkuRestrictionsType string

const (
	// Location ...
	Location ResourceSkuRestrictionsType = "location"
)

// PossibleResourceSkuRestrictionsTypeValues returns an array of possible values for the ResourceSkuRestrictionsType const type.
func PossibleResourceSkuRestrictionsTypeValues() []ResourceSkuRestrictionsType {
	return []ResourceSkuRestrictionsType{Location}
}

// ResultCode enumerates the values for result code.
type ResultCode string

const (
	// Completed ...
	Completed ResultCode = "Completed"
	// FatalError ...
	FatalError ResultCode = "FatalError"
	// Initial ...
	Initial ResultCode = "Initial"
	// ObjectNotExistsInSource ...
	ObjectNotExistsInSource ResultCode = "ObjectNotExistsInSource"
	// ObjectNotExistsInTarget ...
	ObjectNotExistsInTarget ResultCode = "ObjectNotExistsInTarget"
	// TargetObjectIsInaccessible ...
	TargetObjectIsInaccessible ResultCode = "TargetObjectIsInaccessible"
)

// PossibleResultCodeValues returns an array of possible values for the ResultCode const type.
func PossibleResultCodeValues() []ResultCode {
	return []ResultCode{Completed, FatalError, Initial, ObjectNotExistsInSource, ObjectNotExistsInTarget, TargetObjectIsInaccessible}
}

// ResultType enumerates the values for result type.
type ResultType string

const (
	// ResultTypeDatabaseLevelErrorOutput ...
	ResultTypeDatabaseLevelErrorOutput ResultType = "DatabaseLevelErrorOutput"
	// ResultTypeDatabaseLevelOutput ...
	ResultTypeDatabaseLevelOutput ResultType = "DatabaseLevelOutput"
	// ResultTypeErrorOutput ...
	ResultTypeErrorOutput ResultType = "ErrorOutput"
	// ResultTypeMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput ...
	ResultTypeMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput ResultType = "MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutput"
	// ResultTypeMigrationLevelOutput ...
	ResultTypeMigrationLevelOutput ResultType = "MigrationLevelOutput"
	// ResultTypeTableLevelOutput ...
	ResultTypeTableLevelOutput ResultType = "TableLevelOutput"
)

// PossibleResultTypeValues returns an array of possible values for the ResultType const type.
func PossibleResultTypeValues() []ResultType {
	return []ResultType{ResultTypeDatabaseLevelErrorOutput, ResultTypeDatabaseLevelOutput, ResultTypeErrorOutput, ResultTypeMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput, ResultTypeMigrationLevelOutput, ResultTypeTableLevelOutput}
}

// ResultTypeBasicConnectToSourceSQLServerTaskOutput enumerates the values for result type basic connect to
// source sql server task output.
type ResultTypeBasicConnectToSourceSQLServerTaskOutput string

const (
	// ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeAgentJobLevelOutput ...
	ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeAgentJobLevelOutput ResultTypeBasicConnectToSourceSQLServerTaskOutput = "AgentJobLevelOutput"
	// ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeConnectToSourceSQLServerTaskOutput ...
	ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeConnectToSourceSQLServerTaskOutput ResultTypeBasicConnectToSourceSQLServerTaskOutput = "ConnectToSourceSqlServerTaskOutput"
	// ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeDatabaseLevelOutput ...
	ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeDatabaseLevelOutput ResultTypeBasicConnectToSourceSQLServerTaskOutput = "DatabaseLevelOutput"
	// ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeLoginLevelOutput ...
	ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeLoginLevelOutput ResultTypeBasicConnectToSourceSQLServerTaskOutput = "LoginLevelOutput"
	// ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeTaskLevelOutput ...
	ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeTaskLevelOutput ResultTypeBasicConnectToSourceSQLServerTaskOutput = "TaskLevelOutput"
)

// PossibleResultTypeBasicConnectToSourceSQLServerTaskOutputValues returns an array of possible values for the ResultTypeBasicConnectToSourceSQLServerTaskOutput const type.
func PossibleResultTypeBasicConnectToSourceSQLServerTaskOutputValues() []ResultTypeBasicConnectToSourceSQLServerTaskOutput {
	return []ResultTypeBasicConnectToSourceSQLServerTaskOutput{ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeAgentJobLevelOutput, ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeConnectToSourceSQLServerTaskOutput, ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeDatabaseLevelOutput, ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeLoginLevelOutput, ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeTaskLevelOutput}
}

// ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput enumerates the values for result type basic migrate
// my sql azure db for my sql sync task output.
type ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput string

const (
	// ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeDatabaseLevelErrorOutput ...
	ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeDatabaseLevelErrorOutput ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput = "DatabaseLevelErrorOutput"
	// ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeDatabaseLevelOutput ...
	ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeDatabaseLevelOutput ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput = "DatabaseLevelOutput"
	// ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeErrorOutput ...
	ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeErrorOutput ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput = "ErrorOutput"
	// ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeMigrateMySQLAzureDbForMySQLSyncTaskOutput ...
	ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeMigrateMySQLAzureDbForMySQLSyncTaskOutput ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput = "MigrateMySqlAzureDbForMySqlSyncTaskOutput"
	// ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeMigrationLevelOutput ...
	ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeMigrationLevelOutput ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput = "MigrationLevelOutput"
	// ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeTableLevelOutput ...
	ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeTableLevelOutput ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput = "TableLevelOutput"
)

// PossibleResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputValues returns an array of possible values for the ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput const type.
func PossibleResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputValues() []ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput {
	return []ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput{ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeDatabaseLevelErrorOutput, ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeDatabaseLevelOutput, ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeErrorOutput, ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeMigrateMySQLAzureDbForMySQLSyncTaskOutput, ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeMigrationLevelOutput, ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeTableLevelOutput}
}

// ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutput enumerates the values for result type basic migrate sql
// server sql db sync task output.
type ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutput string

const (
	// ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeDatabaseLevelErrorOutput ...
	ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeDatabaseLevelErrorOutput ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutput = "DatabaseLevelErrorOutput"
	// ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeDatabaseLevelOutput ...
	ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeDatabaseLevelOutput ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutput = "DatabaseLevelOutput"
	// ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeErrorOutput ...
	ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeErrorOutput ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutput = "ErrorOutput"
	// ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeMigrateSQLServerSQLDbSyncTaskOutput ...
	ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeMigrateSQLServerSQLDbSyncTaskOutput ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutput = "MigrateSqlServerSqlDbSyncTaskOutput"
	// ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeMigrationLevelOutput ...
	ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeMigrationLevelOutput ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutput = "MigrationLevelOutput"
	// ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeTableLevelOutput ...
	ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeTableLevelOutput ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutput = "TableLevelOutput"
)

// PossibleResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputValues returns an array of possible values for the ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutput const type.
func PossibleResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputValues() []ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutput {
	return []ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutput{ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeDatabaseLevelErrorOutput, ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeDatabaseLevelOutput, ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeErrorOutput, ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeMigrateSQLServerSQLDbSyncTaskOutput, ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeMigrationLevelOutput, ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeTableLevelOutput}
}

// ResultTypeBasicMigrateSQLServerSQLDbTaskOutput enumerates the values for result type basic migrate sql
// server sql db task output.
type ResultTypeBasicMigrateSQLServerSQLDbTaskOutput string

const (
	// ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeDatabaseLevelOutput ...
	ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeDatabaseLevelOutput ResultTypeBasicMigrateSQLServerSQLDbTaskOutput = "DatabaseLevelOutput"
	// ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeErrorOutput ...
	ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeErrorOutput ResultTypeBasicMigrateSQLServerSQLDbTaskOutput = "ErrorOutput"
	// ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrateSQLServerSQLDbTaskOutput ...
	ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrateSQLServerSQLDbTaskOutput ResultTypeBasicMigrateSQLServerSQLDbTaskOutput = "MigrateSqlServerSqlDbTaskOutput"
	// ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrationDatabaseLevelValidationOutput ...
	ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrationDatabaseLevelValidationOutput ResultTypeBasicMigrateSQLServerSQLDbTaskOutput = "MigrationDatabaseLevelValidationOutput"
	// ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrationLevelOutput ...
	ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrationLevelOutput ResultTypeBasicMigrateSQLServerSQLDbTaskOutput = "MigrationLevelOutput"
	// ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrationValidationOutput ...
	ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrationValidationOutput ResultTypeBasicMigrateSQLServerSQLDbTaskOutput = "MigrationValidationOutput"
	// ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeTableLevelOutput ...
	ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeTableLevelOutput ResultTypeBasicMigrateSQLServerSQLDbTaskOutput = "TableLevelOutput"
)

// PossibleResultTypeBasicMigrateSQLServerSQLDbTaskOutputValues returns an array of possible values for the ResultTypeBasicMigrateSQLServerSQLDbTaskOutput const type.
func PossibleResultTypeBasicMigrateSQLServerSQLDbTaskOutputValues() []ResultTypeBasicMigrateSQLServerSQLDbTaskOutput {
	return []ResultTypeBasicMigrateSQLServerSQLDbTaskOutput{ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeDatabaseLevelOutput, ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeErrorOutput, ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrateSQLServerSQLDbTaskOutput, ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrationDatabaseLevelValidationOutput, ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrationLevelOutput, ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrationValidationOutput, ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeTableLevelOutput}
}

// ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutput enumerates the values for result type basic migrate sql
// server sqlmi sync task output.
type ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutput string

const (
	// ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeDatabaseLevelOutput ...
	ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeDatabaseLevelOutput ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutput = "DatabaseLevelOutput"
	// ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeErrorOutput ...
	ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeErrorOutput ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutput = "ErrorOutput"
	// ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeMigrateSQLServerSQLMISyncTaskOutput ...
	ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeMigrateSQLServerSQLMISyncTaskOutput ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutput = "MigrateSqlServerSqlMISyncTaskOutput"
	// ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeMigrationLevelOutput ...
	ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeMigrationLevelOutput ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutput = "MigrationLevelOutput"
)

// PossibleResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputValues returns an array of possible values for the ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutput const type.
func PossibleResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputValues() []ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutput {
	return []ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutput{ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeDatabaseLevelOutput, ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeErrorOutput, ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeMigrateSQLServerSQLMISyncTaskOutput, ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeMigrationLevelOutput}
}

// ResultTypeBasicMigrateSQLServerSQLMITaskOutput enumerates the values for result type basic migrate sql
// server sqlmi task output.
type ResultTypeBasicMigrateSQLServerSQLMITaskOutput string

const (
	// ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeAgentJobLevelOutput ...
	ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeAgentJobLevelOutput ResultTypeBasicMigrateSQLServerSQLMITaskOutput = "AgentJobLevelOutput"
	// ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeDatabaseLevelOutput ...
	ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeDatabaseLevelOutput ResultTypeBasicMigrateSQLServerSQLMITaskOutput = "DatabaseLevelOutput"
	// ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeErrorOutput ...
	ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeErrorOutput ResultTypeBasicMigrateSQLServerSQLMITaskOutput = "ErrorOutput"
	// ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeLoginLevelOutput ...
	ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeLoginLevelOutput ResultTypeBasicMigrateSQLServerSQLMITaskOutput = "LoginLevelOutput"
	// ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeMigrateSQLServerSQLMITaskOutput ...
	ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeMigrateSQLServerSQLMITaskOutput ResultTypeBasicMigrateSQLServerSQLMITaskOutput = "MigrateSqlServerSqlMITaskOutput"
	// ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeMigrationLevelOutput ...
	ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeMigrationLevelOutput ResultTypeBasicMigrateSQLServerSQLMITaskOutput = "MigrationLevelOutput"
)

// PossibleResultTypeBasicMigrateSQLServerSQLMITaskOutputValues returns an array of possible values for the ResultTypeBasicMigrateSQLServerSQLMITaskOutput const type.
func PossibleResultTypeBasicMigrateSQLServerSQLMITaskOutputValues() []ResultTypeBasicMigrateSQLServerSQLMITaskOutput {
	return []ResultTypeBasicMigrateSQLServerSQLMITaskOutput{ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeAgentJobLevelOutput, ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeDatabaseLevelOutput, ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeErrorOutput, ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeLoginLevelOutput, ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeMigrateSQLServerSQLMITaskOutput, ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeMigrationLevelOutput}
}

// SchemaMigrationStage enumerates the values for schema migration stage.
type SchemaMigrationStage string

const (
	// SchemaMigrationStageCollectingObjects ...
	SchemaMigrationStageCollectingObjects SchemaMigrationStage = "CollectingObjects"
	// SchemaMigrationStageCompleted ...
	SchemaMigrationStageCompleted SchemaMigrationStage = "Completed"
	// SchemaMigrationStageCompletedWithWarnings ...
	SchemaMigrationStageCompletedWithWarnings SchemaMigrationStage = "CompletedWithWarnings"
	// SchemaMigrationStageDeployingSchema ...
	SchemaMigrationStageDeployingSchema SchemaMigrationStage = "DeployingSchema"
	// SchemaMigrationStageDownloadingScript ...
	SchemaMigrationStageDownloadingScript SchemaMigrationStage = "DownloadingScript"
	// SchemaMigrationStageFailed ...
	SchemaMigrationStageFailed SchemaMigrationStage = "Failed"
	// SchemaMigrationStageGeneratingScript ...
	SchemaMigrationStageGeneratingScript SchemaMigrationStage = "GeneratingScript"
	// SchemaMigrationStageNotStarted ...
	SchemaMigrationStageNotStarted SchemaMigrationStage = "NotStarted"
	// SchemaMigrationStageUploadingScript ...
	SchemaMigrationStageUploadingScript SchemaMigrationStage = "UploadingScript"
	// SchemaMigrationStageValidatingInputs ...
	SchemaMigrationStageValidatingInputs SchemaMigrationStage = "ValidatingInputs"
)

// PossibleSchemaMigrationStageValues returns an array of possible values for the SchemaMigrationStage const type.
func PossibleSchemaMigrationStageValues() []SchemaMigrationStage {
	return []SchemaMigrationStage{SchemaMigrationStageCollectingObjects, SchemaMigrationStageCompleted, SchemaMigrationStageCompletedWithWarnings, SchemaMigrationStageDeployingSchema, SchemaMigrationStageDownloadingScript, SchemaMigrationStageFailed, SchemaMigrationStageGeneratingScript, SchemaMigrationStageNotStarted, SchemaMigrationStageUploadingScript, SchemaMigrationStageValidatingInputs}
}

// ServerLevelPermissionsGroup enumerates the values for server level permissions group.
type ServerLevelPermissionsGroup string

const (
	// Default ...
	Default ServerLevelPermissionsGroup = "Default"
	// MigrationFromMySQLToAzureDBForMySQL ...
	MigrationFromMySQLToAzureDBForMySQL ServerLevelPermissionsGroup = "MigrationFromMySQLToAzureDBForMySQL"
	// MigrationFromSQLServerToAzureDB ...
	MigrationFromSQLServerToAzureDB ServerLevelPermissionsGroup = "MigrationFromSqlServerToAzureDB"
	// MigrationFromSQLServerToAzureMI ...
	MigrationFromSQLServerToAzureMI ServerLevelPermissionsGroup = "MigrationFromSqlServerToAzureMI"
)

// PossibleServerLevelPermissionsGroupValues returns an array of possible values for the ServerLevelPermissionsGroup const type.
func PossibleServerLevelPermissionsGroupValues() []ServerLevelPermissionsGroup {
	return []ServerLevelPermissionsGroup{Default, MigrationFromMySQLToAzureDBForMySQL, MigrationFromSQLServerToAzureDB, MigrationFromSQLServerToAzureMI}
}

// ServiceProvisioningState enumerates the values for service provisioning state.
type ServiceProvisioningState string

const (
	// ServiceProvisioningStateAccepted ...
	ServiceProvisioningStateAccepted ServiceProvisioningState = "Accepted"
	// ServiceProvisioningStateDeleting ...
	ServiceProvisioningStateDeleting ServiceProvisioningState = "Deleting"
	// ServiceProvisioningStateDeploying ...
	ServiceProvisioningStateDeploying ServiceProvisioningState = "Deploying"
	// ServiceProvisioningStateFailed ...
	ServiceProvisioningStateFailed ServiceProvisioningState = "Failed"
	// ServiceProvisioningStateFailedToStart ...
	ServiceProvisioningStateFailedToStart ServiceProvisioningState = "FailedToStart"
	// ServiceProvisioningStateFailedToStop ...
	ServiceProvisioningStateFailedToStop ServiceProvisioningState = "FailedToStop"
	// ServiceProvisioningStateStarting ...
	ServiceProvisioningStateStarting ServiceProvisioningState = "Starting"
	// ServiceProvisioningStateStopped ...
	ServiceProvisioningStateStopped ServiceProvisioningState = "Stopped"
	// ServiceProvisioningStateStopping ...
	ServiceProvisioningStateStopping ServiceProvisioningState = "Stopping"
	// ServiceProvisioningStateSucceeded ...
	ServiceProvisioningStateSucceeded ServiceProvisioningState = "Succeeded"
)

// PossibleServiceProvisioningStateValues returns an array of possible values for the ServiceProvisioningState const type.
func PossibleServiceProvisioningStateValues() []ServiceProvisioningState {
	return []ServiceProvisioningState{ServiceProvisioningStateAccepted, ServiceProvisioningStateDeleting, ServiceProvisioningStateDeploying, ServiceProvisioningStateFailed, ServiceProvisioningStateFailedToStart, ServiceProvisioningStateFailedToStop, ServiceProvisioningStateStarting, ServiceProvisioningStateStopped, ServiceProvisioningStateStopping, ServiceProvisioningStateSucceeded}
}

// ServiceScalability enumerates the values for service scalability.
type ServiceScalability string

const (
	// ServiceScalabilityAutomatic ...
	ServiceScalabilityAutomatic ServiceScalability = "automatic"
	// ServiceScalabilityManual ...
	ServiceScalabilityManual ServiceScalability = "manual"
	// ServiceScalabilityNone ...
	ServiceScalabilityNone ServiceScalability = "none"
)

// PossibleServiceScalabilityValues returns an array of possible values for the ServiceScalability const type.
func PossibleServiceScalabilityValues() []ServiceScalability {
	return []ServiceScalability{ServiceScalabilityAutomatic, ServiceScalabilityManual, ServiceScalabilityNone}
}

// Severity enumerates the values for severity.
type Severity string

const (
	// SeverityError ...
	SeverityError Severity = "Error"
	// SeverityMessage ...
	SeverityMessage Severity = "Message"
	// SeverityWarning ...
	SeverityWarning Severity = "Warning"
)

// PossibleSeverityValues returns an array of possible values for the Severity const type.
func PossibleSeverityValues() []Severity {
	return []Severity{SeverityError, SeverityMessage, SeverityWarning}
}

// SQLSourcePlatform enumerates the values for sql source platform.
type SQLSourcePlatform string

const (
	// SQLOnPrem ...
	SQLOnPrem SQLSourcePlatform = "SqlOnPrem"
)

// PossibleSQLSourcePlatformValues returns an array of possible values for the SQLSourcePlatform const type.
func PossibleSQLSourcePlatformValues() []SQLSourcePlatform {
	return []SQLSourcePlatform{SQLOnPrem}
}

// SyncDatabaseMigrationReportingState enumerates the values for sync database migration reporting state.
type SyncDatabaseMigrationReportingState string

const (
	// SyncDatabaseMigrationReportingStateCANCELLED ...
	SyncDatabaseMigrationReportingStateCANCELLED SyncDatabaseMigrationReportingState = "CANCELLED"
	// SyncDatabaseMigrationReportingStateCANCELLING ...
	SyncDatabaseMigrationReportingStateCANCELLING SyncDatabaseMigrationReportingState = "CANCELLING"
	// SyncDatabaseMigrationReportingStateCOMPLETE ...
	SyncDatabaseMigrationReportingStateCOMPLETE SyncDatabaseMigrationReportingState = "COMPLETE"
	// SyncDatabaseMigrationReportingStateCOMPLETING ...
	SyncDatabaseMigrationReportingStateCOMPLETING SyncDatabaseMigrationReportingState = "COMPLETING"
	// SyncDatabaseMigrationReportingStateCONFIGURING ...
	SyncDatabaseMigrationReportingStateCONFIGURING SyncDatabaseMigrationReportingState = "CONFIGURING"
	// SyncDatabaseMigrationReportingStateFAILED ...
	SyncDatabaseMigrationReportingStateFAILED SyncDatabaseMigrationReportingState = "FAILED"
	// SyncDatabaseMigrationReportingStateINITIALIAZING ...
	SyncDatabaseMigrationReportingStateINITIALIAZING SyncDatabaseMigrationReportingState = "INITIALIAZING"
	// SyncDatabaseMigrationReportingStateREADYTOCOMPLETE ...
	SyncDatabaseMigrationReportingStateREADYTOCOMPLETE SyncDatabaseMigrationReportingState = "READY_TO_COMPLETE"
	// SyncDatabaseMigrationReportingStateRUNNING ...
	SyncDatabaseMigrationReportingStateRUNNING SyncDatabaseMigrationReportingState = "RUNNING"
	// SyncDatabaseMigrationReportingStateSTARTING ...
	SyncDatabaseMigrationReportingStateSTARTING SyncDatabaseMigrationReportingState = "STARTING"
	// SyncDatabaseMigrationReportingStateUNDEFINED ...
	SyncDatabaseMigrationReportingStateUNDEFINED SyncDatabaseMigrationReportingState = "UNDEFINED"
)

// PossibleSyncDatabaseMigrationReportingStateValues returns an array of possible values for the SyncDatabaseMigrationReportingState const type.
func PossibleSyncDatabaseMigrationReportingStateValues() []SyncDatabaseMigrationReportingState {
	return []SyncDatabaseMigrationReportingState{SyncDatabaseMigrationReportingStateCANCELLED, SyncDatabaseMigrationReportingStateCANCELLING, SyncDatabaseMigrationReportingStateCOMPLETE, SyncDatabaseMigrationReportingStateCOMPLETING, SyncDatabaseMigrationReportingStateCONFIGURING, SyncDatabaseMigrationReportingStateFAILED, SyncDatabaseMigrationReportingStateINITIALIAZING, SyncDatabaseMigrationReportingStateREADYTOCOMPLETE, SyncDatabaseMigrationReportingStateRUNNING, SyncDatabaseMigrationReportingStateSTARTING, SyncDatabaseMigrationReportingStateUNDEFINED}
}

// SyncTableMigrationState enumerates the values for sync table migration state.
type SyncTableMigrationState string

const (
	// SyncTableMigrationStateBEFORELOAD ...
	SyncTableMigrationStateBEFORELOAD SyncTableMigrationState = "BEFORE_LOAD"
	// SyncTableMigrationStateCANCELED ...
	SyncTableMigrationStateCANCELED SyncTableMigrationState = "CANCELED"
	// SyncTableMigrationStateCOMPLETED ...
	SyncTableMigrationStateCOMPLETED SyncTableMigrationState = "COMPLETED"
	// SyncTableMigrationStateERROR ...
	SyncTableMigrationStateERROR SyncTableMigrationState = "ERROR"
	// SyncTableMigrationStateFAILED ...
	SyncTableMigrationStateFAILED SyncTableMigrationState = "FAILED"
	// SyncTableMigrationStateFULLLOAD ...
	SyncTableMigrationStateFULLLOAD SyncTableMigrationState = "FULL_LOAD"
)

// PossibleSyncTableMigrationStateValues returns an array of possible values for the SyncTableMigrationState const type.
func PossibleSyncTableMigrationStateValues() []SyncTableMigrationState {
	return []SyncTableMigrationState{SyncTableMigrationStateBEFORELOAD, SyncTableMigrationStateCANCELED, SyncTableMigrationStateCOMPLETED, SyncTableMigrationStateERROR, SyncTableMigrationStateFAILED, SyncTableMigrationStateFULLLOAD}
}

// TaskState enumerates the values for task state.
type TaskState string

const (
	// TaskStateCanceled ...
	TaskStateCanceled TaskState = "Canceled"
	// TaskStateFailed ...
	TaskStateFailed TaskState = "Failed"
	// TaskStateFailedInputValidation ...
	TaskStateFailedInputValidation TaskState = "FailedInputValidation"
	// TaskStateFaulted ...
	TaskStateFaulted TaskState = "Faulted"
	// TaskStateQueued ...
	TaskStateQueued TaskState = "Queued"
	// TaskStateRunning ...
	TaskStateRunning TaskState = "Running"
	// TaskStateSucceeded ...
	TaskStateSucceeded TaskState = "Succeeded"
	// TaskStateUnknown ...
	TaskStateUnknown TaskState = "Unknown"
)

// PossibleTaskStateValues returns an array of possible values for the TaskState const type.
func PossibleTaskStateValues() []TaskState {
	return []TaskState{TaskStateCanceled, TaskStateFailed, TaskStateFailedInputValidation, TaskStateFaulted, TaskStateQueued, TaskStateRunning, TaskStateSucceeded, TaskStateUnknown}
}

// TaskType enumerates the values for task type.
type TaskType string

const (
	// TaskTypeConnectToSourceMySQL ...
	TaskTypeConnectToSourceMySQL TaskType = "ConnectToSource.MySql"
	// TaskTypeConnectToSourcePostgreSQLSync ...
	TaskTypeConnectToSourcePostgreSQLSync TaskType = "ConnectToSource.PostgreSql.Sync"
	// TaskTypeConnectToSourceSQLServer ...
	TaskTypeConnectToSourceSQLServer TaskType = "ConnectToSource.SqlServer"
	// TaskTypeConnectToSourceSQLServerSync ...
	TaskTypeConnectToSourceSQLServerSync TaskType = "ConnectToSource.SqlServer.Sync"
	// TaskTypeConnectToTargetAzureDbForMySQL ...
	TaskTypeConnectToTargetAzureDbForMySQL TaskType = "ConnectToTarget.AzureDbForMySql"
	// TaskTypeConnectToTargetAzureDbForPostgreSQLSync ...
	TaskTypeConnectToTargetAzureDbForPostgreSQLSync TaskType = "ConnectToTarget.AzureDbForPostgreSql.Sync"
	// TaskTypeConnectToTargetAzureSQLDbMI ...
	TaskTypeConnectToTargetAzureSQLDbMI TaskType = "ConnectToTarget.AzureSqlDbMI"
	// TaskTypeConnectToTargetAzureSQLDbMISyncLRS ...
	TaskTypeConnectToTargetAzureSQLDbMISyncLRS TaskType = "ConnectToTarget.AzureSqlDbMI.Sync.LRS"
	// TaskTypeConnectToTargetSQLDb ...
	TaskTypeConnectToTargetSQLDb TaskType = "ConnectToTarget.SqlDb"
	// TaskTypeConnectToTargetSQLDbSync ...
	TaskTypeConnectToTargetSQLDbSync TaskType = "ConnectToTarget.SqlDb.Sync"
	// TaskTypeGetTDECertificatesSQL ...
	TaskTypeGetTDECertificatesSQL TaskType = "GetTDECertificates.Sql"
	// TaskTypeGetUserTablesAzureSQLDbSync ...
	TaskTypeGetUserTablesAzureSQLDbSync TaskType = "GetUserTables.AzureSqlDb.Sync"
	// TaskTypeGetUserTablesSQL ...
	TaskTypeGetUserTablesSQL TaskType = "GetUserTables.Sql"
	// TaskTypeMigrateMySQLAzureDbForMySQLSync ...
	TaskTypeMigrateMySQLAzureDbForMySQLSync TaskType = "Migrate.MySql.AzureDbForMySql.Sync"
	// TaskTypeMigratePostgreSQLAzureDbForPostgreSQLSync ...
	TaskTypeMigratePostgreSQLAzureDbForPostgreSQLSync TaskType = "Migrate.PostgreSql.AzureDbForPostgreSql.Sync"
	// TaskTypeMigrateSQLServerAzureSQLDbMI ...
	TaskTypeMigrateSQLServerAzureSQLDbMI TaskType = "Migrate.SqlServer.AzureSqlDbMI"
	// TaskTypeMigrateSQLServerAzureSQLDbMISyncLRS ...
	TaskTypeMigrateSQLServerAzureSQLDbMISyncLRS TaskType = "Migrate.SqlServer.AzureSqlDbMI.Sync.LRS"
	// TaskTypeMigrateSQLServerAzureSQLDbSync ...
	TaskTypeMigrateSQLServerAzureSQLDbSync TaskType = "Migrate.SqlServer.AzureSqlDb.Sync"
	// TaskTypeMigrateSQLServerSQLDb ...
	TaskTypeMigrateSQLServerSQLDb TaskType = "Migrate.SqlServer.SqlDb"
	// TaskTypeUnknown ...
	TaskTypeUnknown TaskType = "Unknown"
	// TaskTypeValidateMigrationInputSQLServerAzureSQLDbMI ...
	TaskTypeValidateMigrationInputSQLServerAzureSQLDbMI TaskType = "ValidateMigrationInput.SqlServer.AzureSqlDbMI"
	// TaskTypeValidateMigrationInputSQLServerAzureSQLDbMISyncLRS ...
	TaskTypeValidateMigrationInputSQLServerAzureSQLDbMISyncLRS TaskType = "ValidateMigrationInput.SqlServer.AzureSqlDbMI.Sync.LRS"
	// TaskTypeValidateMigrationInputSQLServerSQLDbSync ...
	TaskTypeValidateMigrationInputSQLServerSQLDbSync TaskType = "ValidateMigrationInput.SqlServer.SqlDb.Sync"
)

// PossibleTaskTypeValues returns an array of possible values for the TaskType const type.
func PossibleTaskTypeValues() []TaskType {
	return []TaskType{TaskTypeConnectToSourceMySQL, TaskTypeConnectToSourcePostgreSQLSync, TaskTypeConnectToSourceSQLServer, TaskTypeConnectToSourceSQLServerSync, TaskTypeConnectToTargetAzureDbForMySQL, TaskTypeConnectToTargetAzureDbForPostgreSQLSync, TaskTypeConnectToTargetAzureSQLDbMI, TaskTypeConnectToTargetAzureSQLDbMISyncLRS, TaskTypeConnectToTargetSQLDb, TaskTypeConnectToTargetSQLDbSync, TaskTypeGetTDECertificatesSQL, TaskTypeGetUserTablesAzureSQLDbSync, TaskTypeGetUserTablesSQL, TaskTypeMigrateMySQLAzureDbForMySQLSync, TaskTypeMigratePostgreSQLAzureDbForPostgreSQLSync, TaskTypeMigrateSQLServerAzureSQLDbMI, TaskTypeMigrateSQLServerAzureSQLDbMISyncLRS, TaskTypeMigrateSQLServerAzureSQLDbSync, TaskTypeMigrateSQLServerSQLDb, TaskTypeUnknown, TaskTypeValidateMigrationInputSQLServerAzureSQLDbMI, TaskTypeValidateMigrationInputSQLServerAzureSQLDbMISyncLRS, TaskTypeValidateMigrationInputSQLServerSQLDbSync}
}

// Type enumerates the values for type.
type Type string

const (
	// TypeMiSQLConnectionInfo ...
	TypeMiSQLConnectionInfo Type = "MiSqlConnectionInfo"
	// TypeMySQLConnectionInfo ...
	TypeMySQLConnectionInfo Type = "MySqlConnectionInfo"
	// TypePostgreSQLConnectionInfo ...
	TypePostgreSQLConnectionInfo Type = "PostgreSqlConnectionInfo"
	// TypeSQLConnectionInfo ...
	TypeSQLConnectionInfo Type = "SqlConnectionInfo"
	// TypeUnknown ...
	TypeUnknown Type = "Unknown"
)

// PossibleTypeValues returns an array of possible values for the Type const type.
func PossibleTypeValues() []Type {
	return []Type{TypeMiSQLConnectionInfo, TypeMySQLConnectionInfo, TypePostgreSQLConnectionInfo, TypeSQLConnectionInfo, TypeUnknown}
}

// UpdateActionType enumerates the values for update action type.
type UpdateActionType string

const (
	// AddedOnTarget ...
	AddedOnTarget UpdateActionType = "AddedOnTarget"
	// ChangedOnTarget ...
	ChangedOnTarget UpdateActionType = "ChangedOnTarget"
	// DeletedOnTarget ...
	DeletedOnTarget UpdateActionType = "DeletedOnTarget"
)

// PossibleUpdateActionTypeValues returns an array of possible values for the UpdateActionType const type.
func PossibleUpdateActionTypeValues() []UpdateActionType {
	return []UpdateActionType{AddedOnTarget, ChangedOnTarget, DeletedOnTarget}
}

// ValidationStatus enumerates the values for validation status.
type ValidationStatus string

const (
	// ValidationStatusCompleted ...
	ValidationStatusCompleted ValidationStatus = "Completed"
	// ValidationStatusCompletedWithIssues ...
	ValidationStatusCompletedWithIssues ValidationStatus = "CompletedWithIssues"
	// ValidationStatusDefault ...
	ValidationStatusDefault ValidationStatus = "Default"
	// ValidationStatusFailed ...
	ValidationStatusFailed ValidationStatus = "Failed"
	// ValidationStatusInitialized ...
	ValidationStatusInitialized ValidationStatus = "Initialized"
	// ValidationStatusInProgress ...
	ValidationStatusInProgress ValidationStatus = "InProgress"
	// ValidationStatusNotStarted ...
	ValidationStatusNotStarted ValidationStatus = "NotStarted"
	// ValidationStatusStopped ...
	ValidationStatusStopped ValidationStatus = "Stopped"
)

// PossibleValidationStatusValues returns an array of possible values for the ValidationStatus const type.
func PossibleValidationStatusValues() []ValidationStatus {
	return []ValidationStatus{ValidationStatusCompleted, ValidationStatusCompletedWithIssues, ValidationStatusDefault, ValidationStatusFailed, ValidationStatusInitialized, ValidationStatusInProgress, ValidationStatusNotStarted, ValidationStatusStopped}
}

// APIError error information.
type APIError struct {
	// Error - Error information in OData format
	Error *ODataError `json:"error,omitempty"`
}

// AvailableServiceSku describes the available service SKU.
type AvailableServiceSku struct {
	// ResourceType - The resource type, including the provider namespace
	ResourceType *string `json:"resourceType,omitempty"`
	// Sku - SKU name, tier, etc.
	Sku *AvailableServiceSkuSku `json:"sku,omitempty"`
	// Capacity - A description of the scaling capacities of the SKU
	Capacity *AvailableServiceSkuCapacity `json:"capacity,omitempty"`
}

// AvailableServiceSkuCapacity a description of the scaling capacities of the SKU
type AvailableServiceSkuCapacity struct {
	// Minimum - The minimum capacity, usually 0 or 1.
	Minimum *int32 `json:"minimum,omitempty"`
	// Maximum - The maximum capacity
	Maximum *int32 `json:"maximum,omitempty"`
	// Default - The default capacity
	Default *int32 `json:"default,omitempty"`
	// ScaleType - The scalability approach. Possible values include: 'ServiceScalabilityNone', 'ServiceScalabilityManual', 'ServiceScalabilityAutomatic'
	ScaleType ServiceScalability `json:"scaleType,omitempty"`
}

// AvailableServiceSkuSku SKU name, tier, etc.
type AvailableServiceSkuSku struct {
	// Name - The name of the SKU
	Name *string `json:"name,omitempty"`
	// Family - SKU family
	Family *string `json:"family,omitempty"`
	// Size - SKU size
	Size *string `json:"size,omitempty"`
	// Tier - The tier of the SKU, such as "Free", "Basic", "Standard", or "Premium"
	Tier *string `json:"tier,omitempty"`
}

// AzureActiveDirectoryApp azure Active Directory Application
type AzureActiveDirectoryApp struct {
	// ApplicationID - Application ID of the Azure Active Directory Application
	ApplicationID *string `json:"applicationId,omitempty"`
	// AppKey - Key used to authenticate to the Azure Active Directory Application
	AppKey *string `json:"appKey,omitempty"`
	// TenantID - Tenant id of the customer
	TenantID *string `json:"tenantId,omitempty"`
}

// BackupFileInfo information of the backup file
type BackupFileInfo struct {
	// FileLocation - Location of the backup file in shared folder
	FileLocation *string `json:"fileLocation,omitempty"`
	// FamilySequenceNumber - Sequence number of the backup file in the backup set
	FamilySequenceNumber *int32 `json:"familySequenceNumber,omitempty"`
	// Status - Status of the backup file during migration. Possible values include: 'Arrived', 'Queued', 'Uploading', 'Uploaded', 'Restoring', 'Restored', 'Cancelled'
	Status BackupFileStatus `json:"status,omitempty"`
}

// BackupSetInfo information of backup set
type BackupSetInfo struct {
	// BackupSetID - Id for the set of backup files
	BackupSetID *string `json:"backupSetId,omitempty"`
	// FirstLsn - First log sequence number of the backup file
	FirstLsn *string `json:"firstLsn,omitempty"`
	// LastLsn - Last log sequence number of the backup file
	LastLsn *string `json:"lastLsn,omitempty"`
	// LastModifiedTime - Last modified time of the backup file in share location
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
	// BackupType - Enum of the different backup types. Possible values include: 'BackupTypeDatabase', 'BackupTypeTransactionLog', 'BackupTypeFile', 'BackupTypeDifferentialDatabase', 'BackupTypeDifferentialFile', 'BackupTypePartial', 'BackupTypeDifferentialPartial'
	BackupType BackupType `json:"backupType,omitempty"`
	// ListOfBackupFiles - List of files in the backup set
	ListOfBackupFiles *[]BackupFileInfo `json:"listOfBackupFiles,omitempty"`
	// DatabaseName - Name of the database to which the backup set belongs
	DatabaseName *string `json:"databaseName,omitempty"`
	// BackupStartDate - Date and time that the backup operation began
	BackupStartDate *date.Time `json:"backupStartDate,omitempty"`
	// BackupFinishedDate - Date and time that the backup operation finished
	BackupFinishedDate *date.Time `json:"backupFinishedDate,omitempty"`
	// IsBackupRestored - Whether the backup set is restored or not
	IsBackupRestored *bool `json:"isBackupRestored,omitempty"`
}

// BlobShare blob container storage information.
type BlobShare struct {
	// SasURI - SAS URI of Azure Storage Account Container.
	SasURI *string `json:"sasUri,omitempty"`
}

// BasicCommandProperties base class for all types of DMS command properties. If command is not supported by current
// client, this object is returned.
type BasicCommandProperties interface {
	AsMigrateMISyncCompleteCommandProperties() (*MigrateMISyncCompleteCommandProperties, bool)
	AsMigrateSyncCompleteCommandProperties() (*MigrateSyncCompleteCommandProperties, bool)
	AsCommandProperties() (*CommandProperties, bool)
}

// CommandProperties base class for all types of DMS command properties. If command is not supported by current
// client, this object is returned.
type CommandProperties struct {
	// Errors - READ-ONLY; Array of errors. This is ignored if submitted.
	Errors *[]ODataError `json:"errors,omitempty"`
	// State - READ-ONLY; The state of the command. This is ignored if submitted. Possible values include: 'Unknown', 'Accepted', 'Running', 'Succeeded', 'Failed'
	State CommandState `json:"state,omitempty"`
	// CommandType - Possible values include: 'CommandTypeUnknown', 'CommandTypeMigrateSQLServerAzureDbSQLMiComplete', 'CommandTypeMigrateSyncCompleteDatabase'
	CommandType CommandType `json:"commandType,omitempty"`
}

func unmarshalBasicCommandProperties(body []byte) (BasicCommandProperties, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["commandType"] {
	case string(CommandTypeMigrateSQLServerAzureDbSQLMiComplete):
		var mmsccp MigrateMISyncCompleteCommandProperties
		err := json.Unmarshal(body, &mmsccp)
		return mmsccp, err
	case string(CommandTypeMigrateSyncCompleteDatabase):
		var msccp MigrateSyncCompleteCommandProperties
		err := json.Unmarshal(body, &msccp)
		return msccp, err
	default:
		var cp CommandProperties
		err := json.Unmarshal(body, &cp)
		return cp, err
	}
}
func unmarshalBasicCommandPropertiesArray(body []byte) ([]BasicCommandProperties, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	cpArray := make([]BasicCommandProperties, len(rawMessages))

	for index, rawMessage := range rawMessages {
		cp, err := unmarshalBasicCommandProperties(*rawMessage)
		if err != nil {
			return nil, err
		}
		cpArray[index] = cp
	}
	return cpArray, nil
}

// MarshalJSON is the custom marshaler for CommandProperties.
func (cp CommandProperties) MarshalJSON() ([]byte, error) {
	cp.CommandType = CommandTypeUnknown
	objectMap := make(map[string]interface{})
	if cp.CommandType != "" {
		objectMap["commandType"] = cp.CommandType
	}
	return json.Marshal(objectMap)
}

// AsMigrateMISyncCompleteCommandProperties is the BasicCommandProperties implementation for CommandProperties.
func (cp CommandProperties) AsMigrateMISyncCompleteCommandProperties() (*MigrateMISyncCompleteCommandProperties, bool) {
	return nil, false
}

// AsMigrateSyncCompleteCommandProperties is the BasicCommandProperties implementation for CommandProperties.
func (cp CommandProperties) AsMigrateSyncCompleteCommandProperties() (*MigrateSyncCompleteCommandProperties, bool) {
	return nil, false
}

// AsCommandProperties is the BasicCommandProperties implementation for CommandProperties.
func (cp CommandProperties) AsCommandProperties() (*CommandProperties, bool) {
	return &cp, true
}

// AsBasicCommandProperties is the BasicCommandProperties implementation for CommandProperties.
func (cp CommandProperties) AsBasicCommandProperties() (BasicCommandProperties, bool) {
	return &cp, true
}

// BasicConnectionInfo defines the connection properties of a server
type BasicConnectionInfo interface {
	AsMiSQLConnectionInfo() (*MiSQLConnectionInfo, bool)
	AsPostgreSQLConnectionInfo() (*PostgreSQLConnectionInfo, bool)
	AsMySQLConnectionInfo() (*MySQLConnectionInfo, bool)
	AsSQLConnectionInfo() (*SQLConnectionInfo, bool)
	AsConnectionInfo() (*ConnectionInfo, bool)
}

// ConnectionInfo defines the connection properties of a server
type ConnectionInfo struct {
	// UserName - User name
	UserName *string `json:"userName,omitempty"`
	// Password - Password credential.
	Password *string `json:"password,omitempty"`
	// Type - Possible values include: 'TypeUnknown', 'TypeMiSQLConnectionInfo', 'TypePostgreSQLConnectionInfo', 'TypeMySQLConnectionInfo', 'TypeSQLConnectionInfo'
	Type Type `json:"type,omitempty"`
}

func unmarshalBasicConnectionInfo(body []byte) (BasicConnectionInfo, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["type"] {
	case string(TypeMiSQLConnectionInfo):
		var msci MiSQLConnectionInfo
		err := json.Unmarshal(body, &msci)
		return msci, err
	case string(TypePostgreSQLConnectionInfo):
		var psci PostgreSQLConnectionInfo
		err := json.Unmarshal(body, &psci)
		return psci, err
	case string(TypeMySQLConnectionInfo):
		var msci MySQLConnectionInfo
		err := json.Unmarshal(body, &msci)
		return msci, err
	case string(TypeSQLConnectionInfo):
		var sci SQLConnectionInfo
		err := json.Unmarshal(body, &sci)
		return sci, err
	default:
		var ci ConnectionInfo
		err := json.Unmarshal(body, &ci)
		return ci, err
	}
}
func unmarshalBasicConnectionInfoArray(body []byte) ([]BasicConnectionInfo, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	ciArray := make([]BasicConnectionInfo, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ci, err := unmarshalBasicConnectionInfo(*rawMessage)
		if err != nil {
			return nil, err
		}
		ciArray[index] = ci
	}
	return ciArray, nil
}

// MarshalJSON is the custom marshaler for ConnectionInfo.
func (ci ConnectionInfo) MarshalJSON() ([]byte, error) {
	ci.Type = TypeUnknown
	objectMap := make(map[string]interface{})
	if ci.UserName != nil {
		objectMap["userName"] = ci.UserName
	}
	if ci.Password != nil {
		objectMap["password"] = ci.Password
	}
	if ci.Type != "" {
		objectMap["type"] = ci.Type
	}
	return json.Marshal(objectMap)
}

// AsMiSQLConnectionInfo is the BasicConnectionInfo implementation for ConnectionInfo.
func (ci ConnectionInfo) AsMiSQLConnectionInfo() (*MiSQLConnectionInfo, bool) {
	return nil, false
}

// AsPostgreSQLConnectionInfo is the BasicConnectionInfo implementation for ConnectionInfo.
func (ci ConnectionInfo) AsPostgreSQLConnectionInfo() (*PostgreSQLConnectionInfo, bool) {
	return nil, false
}

// AsMySQLConnectionInfo is the BasicConnectionInfo implementation for ConnectionInfo.
func (ci ConnectionInfo) AsMySQLConnectionInfo() (*MySQLConnectionInfo, bool) {
	return nil, false
}

// AsSQLConnectionInfo is the BasicConnectionInfo implementation for ConnectionInfo.
func (ci ConnectionInfo) AsSQLConnectionInfo() (*SQLConnectionInfo, bool) {
	return nil, false
}

// AsConnectionInfo is the BasicConnectionInfo implementation for ConnectionInfo.
func (ci ConnectionInfo) AsConnectionInfo() (*ConnectionInfo, bool) {
	return &ci, true
}

// AsBasicConnectionInfo is the BasicConnectionInfo implementation for ConnectionInfo.
func (ci ConnectionInfo) AsBasicConnectionInfo() (BasicConnectionInfo, bool) {
	return &ci, true
}

// ConnectToSourceMySQLTaskInput input for the task that validates MySQL database connection
type ConnectToSourceMySQLTaskInput struct {
	// SourceConnectionInfo - Information for connecting to MySQL source
	SourceConnectionInfo *MySQLConnectionInfo `json:"sourceConnectionInfo,omitempty"`
	// TargetPlatform - Target Platform for the migration. Possible values include: 'SQLServer', 'AzureDbForMySQL'
	TargetPlatform MySQLTargetPlatformType `json:"targetPlatform,omitempty"`
	// CheckPermissionsGroup - Permission group for validations. Possible values include: 'Default', 'MigrationFromSQLServerToAzureDB', 'MigrationFromSQLServerToAzureMI', 'MigrationFromMySQLToAzureDBForMySQL'
	CheckPermissionsGroup ServerLevelPermissionsGroup `json:"checkPermissionsGroup,omitempty"`
}

// ConnectToSourceMySQLTaskProperties properties for the task that validates MySQL database connection
type ConnectToSourceMySQLTaskProperties struct {
	// Input - Task input
	Input *ConnectToSourceMySQLTaskInput `json:"input,omitempty"`
	// Output - READ-ONLY; Task output. This is ignored if submitted.
	Output *[]ConnectToSourceNonSQLTaskOutput `json:"output,omitempty"`
	// Errors - READ-ONLY; Array of errors. This is ignored if submitted.
	Errors *[]ODataError `json:"errors,omitempty"`
	// State - READ-ONLY; The state of the task. This is ignored if submitted. Possible values include: 'TaskStateUnknown', 'TaskStateQueued', 'TaskStateRunning', 'TaskStateCanceled', 'TaskStateSucceeded', 'TaskStateFailed', 'TaskStateFailedInputValidation', 'TaskStateFaulted'
	State TaskState `json:"state,omitempty"`
	// Commands - READ-ONLY; Array of command properties.
	Commands *[]BasicCommandProperties `json:"commands,omitempty"`
	// TaskType - Possible values include: 'TaskTypeUnknown', 'TaskTypeGetTDECertificatesSQL', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMISyncLRS', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMI', 'TaskTypeValidateMigrationInputSQLServerSQLDbSync', 'TaskTypeMigratePostgreSQLAzureDbForPostgreSQLSync', 'TaskTypeMigrateMySQLAzureDbForMySQLSync', 'TaskTypeMigrateSQLServerAzureSQLDbSync', 'TaskTypeMigrateSQLServerSQLDb', 'TaskTypeMigrateSQLServerAzureSQLDbMISyncLRS', 'TaskTypeMigrateSQLServerAzureSQLDbMI', 'TaskTypeConnectToTargetAzureDbForMySQL', 'TaskTypeConnectToTargetAzureSQLDbMISyncLRS', 'TaskTypeConnectToTargetAzureSQLDbMI', 'TaskTypeGetUserTablesAzureSQLDbSync', 'TaskTypeGetUserTablesSQL', 'TaskTypeConnectToTargetAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetSQLDbSync', 'TaskTypeConnectToTargetSQLDb', 'TaskTypeConnectToSourcePostgreSQLSync', 'TaskTypeConnectToSourceSQLServerSync', 'TaskTypeConnectToSourceSQLServer', 'TaskTypeConnectToSourceMySQL'
	TaskType TaskType `json:"taskType,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectToSourceMySQLTaskProperties.
func (ctsmstp ConnectToSourceMySQLTaskProperties) MarshalJSON() ([]byte, error) {
	ctsmstp.TaskType = TaskTypeConnectToSourceMySQL
	objectMap := make(map[string]interface{})
	if ctsmstp.Input != nil {
		objectMap["input"] = ctsmstp.Input
	}
	if ctsmstp.TaskType != "" {
		objectMap["taskType"] = ctsmstp.TaskType
	}
	return json.Marshal(objectMap)
}

// AsGetTdeCertificatesSQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceMySQLTaskProperties.
func (ctsmstp ConnectToSourceMySQLTaskProperties) AsGetTdeCertificatesSQLTaskProperties() (*GetTdeCertificatesSQLTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceMySQLTaskProperties.
func (ctsmstp ConnectToSourceMySQLTaskProperties) AsValidateMigrationInputSQLServerSQLMISyncTaskProperties() (*ValidateMigrationInputSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceMySQLTaskProperties.
func (ctsmstp ConnectToSourceMySQLTaskProperties) AsValidateMigrationInputSQLServerSQLMITaskProperties() (*ValidateMigrationInputSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceMySQLTaskProperties.
func (ctsmstp ConnectToSourceMySQLTaskProperties) AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties() (*ValidateMigrationInputSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceMySQLTaskProperties.
func (ctsmstp ConnectToSourceMySQLTaskProperties) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceMySQLTaskProperties.
func (ctsmstp ConnectToSourceMySQLTaskProperties) AsMigrateMySQLAzureDbForMySQLSyncTaskProperties() (*MigrateMySQLAzureDbForMySQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceMySQLTaskProperties.
func (ctsmstp ConnectToSourceMySQLTaskProperties) AsMigrateSQLServerSQLDbSyncTaskProperties() (*MigrateSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceMySQLTaskProperties.
func (ctsmstp ConnectToSourceMySQLTaskProperties) AsMigrateSQLServerSQLDbTaskProperties() (*MigrateSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceMySQLTaskProperties.
func (ctsmstp ConnectToSourceMySQLTaskProperties) AsMigrateSQLServerSQLMISyncTaskProperties() (*MigrateSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceMySQLTaskProperties.
func (ctsmstp ConnectToSourceMySQLTaskProperties) AsMigrateSQLServerSQLMITaskProperties() (*MigrateSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForMySQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceMySQLTaskProperties.
func (ctsmstp ConnectToSourceMySQLTaskProperties) AsConnectToTargetAzureDbForMySQLTaskProperties() (*ConnectToTargetAzureDbForMySQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceMySQLTaskProperties.
func (ctsmstp ConnectToSourceMySQLTaskProperties) AsConnectToTargetSQLMISyncTaskProperties() (*ConnectToTargetSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMITaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceMySQLTaskProperties.
func (ctsmstp ConnectToSourceMySQLTaskProperties) AsConnectToTargetSQLMITaskProperties() (*ConnectToTargetSQLMITaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceMySQLTaskProperties.
func (ctsmstp ConnectToSourceMySQLTaskProperties) AsGetUserTablesSQLSyncTaskProperties() (*GetUserTablesSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceMySQLTaskProperties.
func (ctsmstp ConnectToSourceMySQLTaskProperties) AsGetUserTablesSQLTaskProperties() (*GetUserTablesSQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceMySQLTaskProperties.
func (ctsmstp ConnectToSourceMySQLTaskProperties) AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceMySQLTaskProperties.
func (ctsmstp ConnectToSourceMySQLTaskProperties) AsConnectToTargetSQLSQLDbSyncTaskProperties() (*ConnectToTargetSQLSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceMySQLTaskProperties.
func (ctsmstp ConnectToSourceMySQLTaskProperties) AsConnectToTargetSQLDbTaskProperties() (*ConnectToTargetSQLDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourcePostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceMySQLTaskProperties.
func (ctsmstp ConnectToSourceMySQLTaskProperties) AsConnectToSourcePostgreSQLSyncTaskProperties() (*ConnectToSourcePostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceMySQLTaskProperties.
func (ctsmstp ConnectToSourceMySQLTaskProperties) AsConnectToSourceSQLServerSyncTaskProperties() (*ConnectToSourceSQLServerSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceMySQLTaskProperties.
func (ctsmstp ConnectToSourceMySQLTaskProperties) AsConnectToSourceSQLServerTaskProperties() (*ConnectToSourceSQLServerTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceMySQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceMySQLTaskProperties.
func (ctsmstp ConnectToSourceMySQLTaskProperties) AsConnectToSourceMySQLTaskProperties() (*ConnectToSourceMySQLTaskProperties, bool) {
	return &ctsmstp, true
}

// AsProjectTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceMySQLTaskProperties.
func (ctsmstp ConnectToSourceMySQLTaskProperties) AsProjectTaskProperties() (*ProjectTaskProperties, bool) {
	return nil, false
}

// AsBasicProjectTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceMySQLTaskProperties.
func (ctsmstp ConnectToSourceMySQLTaskProperties) AsBasicProjectTaskProperties() (BasicProjectTaskProperties, bool) {
	return &ctsmstp, true
}

// UnmarshalJSON is the custom unmarshaler for ConnectToSourceMySQLTaskProperties struct.
func (ctsmstp *ConnectToSourceMySQLTaskProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "input":
			if v != nil {
				var input ConnectToSourceMySQLTaskInput
				err = json.Unmarshal(*v, &input)
				if err != nil {
					return err
				}
				ctsmstp.Input = &input
			}
		case "output":
			if v != nil {
				var output []ConnectToSourceNonSQLTaskOutput
				err = json.Unmarshal(*v, &output)
				if err != nil {
					return err
				}
				ctsmstp.Output = &output
			}
		case "errors":
			if v != nil {
				var errorsVar []ODataError
				err = json.Unmarshal(*v, &errorsVar)
				if err != nil {
					return err
				}
				ctsmstp.Errors = &errorsVar
			}
		case "state":
			if v != nil {
				var state TaskState
				err = json.Unmarshal(*v, &state)
				if err != nil {
					return err
				}
				ctsmstp.State = state
			}
		case "commands":
			if v != nil {
				commands, err := unmarshalBasicCommandPropertiesArray(*v)
				if err != nil {
					return err
				}
				ctsmstp.Commands = &commands
			}
		case "taskType":
			if v != nil {
				var taskType TaskType
				err = json.Unmarshal(*v, &taskType)
				if err != nil {
					return err
				}
				ctsmstp.TaskType = taskType
			}
		}
	}

	return nil
}

// ConnectToSourceNonSQLTaskOutput output for connect to Oracle, MySQL type source
type ConnectToSourceNonSQLTaskOutput struct {
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// SourceServerBrandVersion - READ-ONLY; Server brand version
	SourceServerBrandVersion *string `json:"sourceServerBrandVersion,omitempty"`
	// ServerProperties - READ-ONLY; Server properties
	ServerProperties *ServerProperties `json:"serverProperties,omitempty"`
	// Databases - READ-ONLY; List of databases on the server
	Databases *[]string `json:"databases,omitempty"`
	// ValidationErrors - READ-ONLY; Validation errors associated with the task
	ValidationErrors *[]ReportableException `json:"validationErrors,omitempty"`
}

// ConnectToSourcePostgreSQLSyncTaskInput input for the task that validates connection to PostgreSQL and
// source server requirements
type ConnectToSourcePostgreSQLSyncTaskInput struct {
	// SourceConnectionInfo - Connection information for source PostgreSQL server
	SourceConnectionInfo *PostgreSQLConnectionInfo `json:"sourceConnectionInfo,omitempty"`
}

// ConnectToSourcePostgreSQLSyncTaskOutput output for the task that validates connection to PostgreSQL and
// source server requirements
type ConnectToSourcePostgreSQLSyncTaskOutput struct {
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// SourceServerVersion - READ-ONLY; Version of the source server
	SourceServerVersion *string `json:"sourceServerVersion,omitempty"`
	// Databases - READ-ONLY; List of databases on source server
	Databases *[]string `json:"databases,omitempty"`
	// SourceServerBrandVersion - READ-ONLY; Source server brand version
	SourceServerBrandVersion *string `json:"sourceServerBrandVersion,omitempty"`
	// ValidationErrors - READ-ONLY; Validation errors associated with the task
	ValidationErrors *[]ReportableException `json:"validationErrors,omitempty"`
}

// ConnectToSourcePostgreSQLSyncTaskProperties properties for the task that validates connection to
// PostgreSQL server and source server requirements for online migration
type ConnectToSourcePostgreSQLSyncTaskProperties struct {
	// Input - Task input
	Input *ConnectToSourcePostgreSQLSyncTaskInput `json:"input,omitempty"`
	// Output - READ-ONLY; Task output. This is ignored if submitted.
	Output *[]ConnectToSourcePostgreSQLSyncTaskOutput `json:"output,omitempty"`
	// Errors - READ-ONLY; Array of errors. This is ignored if submitted.
	Errors *[]ODataError `json:"errors,omitempty"`
	// State - READ-ONLY; The state of the task. This is ignored if submitted. Possible values include: 'TaskStateUnknown', 'TaskStateQueued', 'TaskStateRunning', 'TaskStateCanceled', 'TaskStateSucceeded', 'TaskStateFailed', 'TaskStateFailedInputValidation', 'TaskStateFaulted'
	State TaskState `json:"state,omitempty"`
	// Commands - READ-ONLY; Array of command properties.
	Commands *[]BasicCommandProperties `json:"commands,omitempty"`
	// TaskType - Possible values include: 'TaskTypeUnknown', 'TaskTypeGetTDECertificatesSQL', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMISyncLRS', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMI', 'TaskTypeValidateMigrationInputSQLServerSQLDbSync', 'TaskTypeMigratePostgreSQLAzureDbForPostgreSQLSync', 'TaskTypeMigrateMySQLAzureDbForMySQLSync', 'TaskTypeMigrateSQLServerAzureSQLDbSync', 'TaskTypeMigrateSQLServerSQLDb', 'TaskTypeMigrateSQLServerAzureSQLDbMISyncLRS', 'TaskTypeMigrateSQLServerAzureSQLDbMI', 'TaskTypeConnectToTargetAzureDbForMySQL', 'TaskTypeConnectToTargetAzureSQLDbMISyncLRS', 'TaskTypeConnectToTargetAzureSQLDbMI', 'TaskTypeGetUserTablesAzureSQLDbSync', 'TaskTypeGetUserTablesSQL', 'TaskTypeConnectToTargetAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetSQLDbSync', 'TaskTypeConnectToTargetSQLDb', 'TaskTypeConnectToSourcePostgreSQLSync', 'TaskTypeConnectToSourceSQLServerSync', 'TaskTypeConnectToSourceSQLServer', 'TaskTypeConnectToSourceMySQL'
	TaskType TaskType `json:"taskType,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectToSourcePostgreSQLSyncTaskProperties.
func (ctspsstp ConnectToSourcePostgreSQLSyncTaskProperties) MarshalJSON() ([]byte, error) {
	ctspsstp.TaskType = TaskTypeConnectToSourcePostgreSQLSync
	objectMap := make(map[string]interface{})
	if ctspsstp.Input != nil {
		objectMap["input"] = ctspsstp.Input
	}
	if ctspsstp.TaskType != "" {
		objectMap["taskType"] = ctspsstp.TaskType
	}
	return json.Marshal(objectMap)
}

// AsGetTdeCertificatesSQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourcePostgreSQLSyncTaskProperties.
func (ctspsstp ConnectToSourcePostgreSQLSyncTaskProperties) AsGetTdeCertificatesSQLTaskProperties() (*GetTdeCertificatesSQLTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourcePostgreSQLSyncTaskProperties.
func (ctspsstp ConnectToSourcePostgreSQLSyncTaskProperties) AsValidateMigrationInputSQLServerSQLMISyncTaskProperties() (*ValidateMigrationInputSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourcePostgreSQLSyncTaskProperties.
func (ctspsstp ConnectToSourcePostgreSQLSyncTaskProperties) AsValidateMigrationInputSQLServerSQLMITaskProperties() (*ValidateMigrationInputSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourcePostgreSQLSyncTaskProperties.
func (ctspsstp ConnectToSourcePostgreSQLSyncTaskProperties) AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties() (*ValidateMigrationInputSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourcePostgreSQLSyncTaskProperties.
func (ctspsstp ConnectToSourcePostgreSQLSyncTaskProperties) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourcePostgreSQLSyncTaskProperties.
func (ctspsstp ConnectToSourcePostgreSQLSyncTaskProperties) AsMigrateMySQLAzureDbForMySQLSyncTaskProperties() (*MigrateMySQLAzureDbForMySQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourcePostgreSQLSyncTaskProperties.
func (ctspsstp ConnectToSourcePostgreSQLSyncTaskProperties) AsMigrateSQLServerSQLDbSyncTaskProperties() (*MigrateSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourcePostgreSQLSyncTaskProperties.
func (ctspsstp ConnectToSourcePostgreSQLSyncTaskProperties) AsMigrateSQLServerSQLDbTaskProperties() (*MigrateSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourcePostgreSQLSyncTaskProperties.
func (ctspsstp ConnectToSourcePostgreSQLSyncTaskProperties) AsMigrateSQLServerSQLMISyncTaskProperties() (*MigrateSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourcePostgreSQLSyncTaskProperties.
func (ctspsstp ConnectToSourcePostgreSQLSyncTaskProperties) AsMigrateSQLServerSQLMITaskProperties() (*MigrateSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForMySQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourcePostgreSQLSyncTaskProperties.
func (ctspsstp ConnectToSourcePostgreSQLSyncTaskProperties) AsConnectToTargetAzureDbForMySQLTaskProperties() (*ConnectToTargetAzureDbForMySQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourcePostgreSQLSyncTaskProperties.
func (ctspsstp ConnectToSourcePostgreSQLSyncTaskProperties) AsConnectToTargetSQLMISyncTaskProperties() (*ConnectToTargetSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMITaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourcePostgreSQLSyncTaskProperties.
func (ctspsstp ConnectToSourcePostgreSQLSyncTaskProperties) AsConnectToTargetSQLMITaskProperties() (*ConnectToTargetSQLMITaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourcePostgreSQLSyncTaskProperties.
func (ctspsstp ConnectToSourcePostgreSQLSyncTaskProperties) AsGetUserTablesSQLSyncTaskProperties() (*GetUserTablesSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourcePostgreSQLSyncTaskProperties.
func (ctspsstp ConnectToSourcePostgreSQLSyncTaskProperties) AsGetUserTablesSQLTaskProperties() (*GetUserTablesSQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourcePostgreSQLSyncTaskProperties.
func (ctspsstp ConnectToSourcePostgreSQLSyncTaskProperties) AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourcePostgreSQLSyncTaskProperties.
func (ctspsstp ConnectToSourcePostgreSQLSyncTaskProperties) AsConnectToTargetSQLSQLDbSyncTaskProperties() (*ConnectToTargetSQLSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourcePostgreSQLSyncTaskProperties.
func (ctspsstp ConnectToSourcePostgreSQLSyncTaskProperties) AsConnectToTargetSQLDbTaskProperties() (*ConnectToTargetSQLDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourcePostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourcePostgreSQLSyncTaskProperties.
func (ctspsstp ConnectToSourcePostgreSQLSyncTaskProperties) AsConnectToSourcePostgreSQLSyncTaskProperties() (*ConnectToSourcePostgreSQLSyncTaskProperties, bool) {
	return &ctspsstp, true
}

// AsConnectToSourceSQLServerSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourcePostgreSQLSyncTaskProperties.
func (ctspsstp ConnectToSourcePostgreSQLSyncTaskProperties) AsConnectToSourceSQLServerSyncTaskProperties() (*ConnectToSourceSQLServerSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourcePostgreSQLSyncTaskProperties.
func (ctspsstp ConnectToSourcePostgreSQLSyncTaskProperties) AsConnectToSourceSQLServerTaskProperties() (*ConnectToSourceSQLServerTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceMySQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourcePostgreSQLSyncTaskProperties.
func (ctspsstp ConnectToSourcePostgreSQLSyncTaskProperties) AsConnectToSourceMySQLTaskProperties() (*ConnectToSourceMySQLTaskProperties, bool) {
	return nil, false
}

// AsProjectTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourcePostgreSQLSyncTaskProperties.
func (ctspsstp ConnectToSourcePostgreSQLSyncTaskProperties) AsProjectTaskProperties() (*ProjectTaskProperties, bool) {
	return nil, false
}

// AsBasicProjectTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourcePostgreSQLSyncTaskProperties.
func (ctspsstp ConnectToSourcePostgreSQLSyncTaskProperties) AsBasicProjectTaskProperties() (BasicProjectTaskProperties, bool) {
	return &ctspsstp, true
}

// UnmarshalJSON is the custom unmarshaler for ConnectToSourcePostgreSQLSyncTaskProperties struct.
func (ctspsstp *ConnectToSourcePostgreSQLSyncTaskProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "input":
			if v != nil {
				var input ConnectToSourcePostgreSQLSyncTaskInput
				err = json.Unmarshal(*v, &input)
				if err != nil {
					return err
				}
				ctspsstp.Input = &input
			}
		case "output":
			if v != nil {
				var output []ConnectToSourcePostgreSQLSyncTaskOutput
				err = json.Unmarshal(*v, &output)
				if err != nil {
					return err
				}
				ctspsstp.Output = &output
			}
		case "errors":
			if v != nil {
				var errorsVar []ODataError
				err = json.Unmarshal(*v, &errorsVar)
				if err != nil {
					return err
				}
				ctspsstp.Errors = &errorsVar
			}
		case "state":
			if v != nil {
				var state TaskState
				err = json.Unmarshal(*v, &state)
				if err != nil {
					return err
				}
				ctspsstp.State = state
			}
		case "commands":
			if v != nil {
				commands, err := unmarshalBasicCommandPropertiesArray(*v)
				if err != nil {
					return err
				}
				ctspsstp.Commands = &commands
			}
		case "taskType":
			if v != nil {
				var taskType TaskType
				err = json.Unmarshal(*v, &taskType)
				if err != nil {
					return err
				}
				ctspsstp.TaskType = taskType
			}
		}
	}

	return nil
}

// ConnectToSourceSQLServerSyncTaskProperties properties for the task that validates connection to SQL
// Server and source server requirements for online migration
type ConnectToSourceSQLServerSyncTaskProperties struct {
	// Input - Task input
	Input *ConnectToSourceSQLServerTaskInput `json:"input,omitempty"`
	// Output - READ-ONLY; Task output. This is ignored if submitted.
	Output *[]BasicConnectToSourceSQLServerTaskOutput `json:"output,omitempty"`
	// Errors - READ-ONLY; Array of errors. This is ignored if submitted.
	Errors *[]ODataError `json:"errors,omitempty"`
	// State - READ-ONLY; The state of the task. This is ignored if submitted. Possible values include: 'TaskStateUnknown', 'TaskStateQueued', 'TaskStateRunning', 'TaskStateCanceled', 'TaskStateSucceeded', 'TaskStateFailed', 'TaskStateFailedInputValidation', 'TaskStateFaulted'
	State TaskState `json:"state,omitempty"`
	// Commands - READ-ONLY; Array of command properties.
	Commands *[]BasicCommandProperties `json:"commands,omitempty"`
	// TaskType - Possible values include: 'TaskTypeUnknown', 'TaskTypeGetTDECertificatesSQL', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMISyncLRS', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMI', 'TaskTypeValidateMigrationInputSQLServerSQLDbSync', 'TaskTypeMigratePostgreSQLAzureDbForPostgreSQLSync', 'TaskTypeMigrateMySQLAzureDbForMySQLSync', 'TaskTypeMigrateSQLServerAzureSQLDbSync', 'TaskTypeMigrateSQLServerSQLDb', 'TaskTypeMigrateSQLServerAzureSQLDbMISyncLRS', 'TaskTypeMigrateSQLServerAzureSQLDbMI', 'TaskTypeConnectToTargetAzureDbForMySQL', 'TaskTypeConnectToTargetAzureSQLDbMISyncLRS', 'TaskTypeConnectToTargetAzureSQLDbMI', 'TaskTypeGetUserTablesAzureSQLDbSync', 'TaskTypeGetUserTablesSQL', 'TaskTypeConnectToTargetAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetSQLDbSync', 'TaskTypeConnectToTargetSQLDb', 'TaskTypeConnectToSourcePostgreSQLSync', 'TaskTypeConnectToSourceSQLServerSync', 'TaskTypeConnectToSourceSQLServer', 'TaskTypeConnectToSourceMySQL'
	TaskType TaskType `json:"taskType,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectToSourceSQLServerSyncTaskProperties.
func (ctsssstp ConnectToSourceSQLServerSyncTaskProperties) MarshalJSON() ([]byte, error) {
	ctsssstp.TaskType = TaskTypeConnectToSourceSQLServerSync
	objectMap := make(map[string]interface{})
	if ctsssstp.Input != nil {
		objectMap["input"] = ctsssstp.Input
	}
	if ctsssstp.TaskType != "" {
		objectMap["taskType"] = ctsssstp.TaskType
	}
	return json.Marshal(objectMap)
}

// AsGetTdeCertificatesSQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerSyncTaskProperties.
func (ctsssstp ConnectToSourceSQLServerSyncTaskProperties) AsGetTdeCertificatesSQLTaskProperties() (*GetTdeCertificatesSQLTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerSyncTaskProperties.
func (ctsssstp ConnectToSourceSQLServerSyncTaskProperties) AsValidateMigrationInputSQLServerSQLMISyncTaskProperties() (*ValidateMigrationInputSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerSyncTaskProperties.
func (ctsssstp ConnectToSourceSQLServerSyncTaskProperties) AsValidateMigrationInputSQLServerSQLMITaskProperties() (*ValidateMigrationInputSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerSyncTaskProperties.
func (ctsssstp ConnectToSourceSQLServerSyncTaskProperties) AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties() (*ValidateMigrationInputSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerSyncTaskProperties.
func (ctsssstp ConnectToSourceSQLServerSyncTaskProperties) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerSyncTaskProperties.
func (ctsssstp ConnectToSourceSQLServerSyncTaskProperties) AsMigrateMySQLAzureDbForMySQLSyncTaskProperties() (*MigrateMySQLAzureDbForMySQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerSyncTaskProperties.
func (ctsssstp ConnectToSourceSQLServerSyncTaskProperties) AsMigrateSQLServerSQLDbSyncTaskProperties() (*MigrateSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerSyncTaskProperties.
func (ctsssstp ConnectToSourceSQLServerSyncTaskProperties) AsMigrateSQLServerSQLDbTaskProperties() (*MigrateSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerSyncTaskProperties.
func (ctsssstp ConnectToSourceSQLServerSyncTaskProperties) AsMigrateSQLServerSQLMISyncTaskProperties() (*MigrateSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerSyncTaskProperties.
func (ctsssstp ConnectToSourceSQLServerSyncTaskProperties) AsMigrateSQLServerSQLMITaskProperties() (*MigrateSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForMySQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerSyncTaskProperties.
func (ctsssstp ConnectToSourceSQLServerSyncTaskProperties) AsConnectToTargetAzureDbForMySQLTaskProperties() (*ConnectToTargetAzureDbForMySQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerSyncTaskProperties.
func (ctsssstp ConnectToSourceSQLServerSyncTaskProperties) AsConnectToTargetSQLMISyncTaskProperties() (*ConnectToTargetSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMITaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerSyncTaskProperties.
func (ctsssstp ConnectToSourceSQLServerSyncTaskProperties) AsConnectToTargetSQLMITaskProperties() (*ConnectToTargetSQLMITaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerSyncTaskProperties.
func (ctsssstp ConnectToSourceSQLServerSyncTaskProperties) AsGetUserTablesSQLSyncTaskProperties() (*GetUserTablesSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerSyncTaskProperties.
func (ctsssstp ConnectToSourceSQLServerSyncTaskProperties) AsGetUserTablesSQLTaskProperties() (*GetUserTablesSQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerSyncTaskProperties.
func (ctsssstp ConnectToSourceSQLServerSyncTaskProperties) AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerSyncTaskProperties.
func (ctsssstp ConnectToSourceSQLServerSyncTaskProperties) AsConnectToTargetSQLSQLDbSyncTaskProperties() (*ConnectToTargetSQLSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerSyncTaskProperties.
func (ctsssstp ConnectToSourceSQLServerSyncTaskProperties) AsConnectToTargetSQLDbTaskProperties() (*ConnectToTargetSQLDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourcePostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerSyncTaskProperties.
func (ctsssstp ConnectToSourceSQLServerSyncTaskProperties) AsConnectToSourcePostgreSQLSyncTaskProperties() (*ConnectToSourcePostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerSyncTaskProperties.
func (ctsssstp ConnectToSourceSQLServerSyncTaskProperties) AsConnectToSourceSQLServerSyncTaskProperties() (*ConnectToSourceSQLServerSyncTaskProperties, bool) {
	return &ctsssstp, true
}

// AsConnectToSourceSQLServerTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerSyncTaskProperties.
func (ctsssstp ConnectToSourceSQLServerSyncTaskProperties) AsConnectToSourceSQLServerTaskProperties() (*ConnectToSourceSQLServerTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceMySQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerSyncTaskProperties.
func (ctsssstp ConnectToSourceSQLServerSyncTaskProperties) AsConnectToSourceMySQLTaskProperties() (*ConnectToSourceMySQLTaskProperties, bool) {
	return nil, false
}

// AsProjectTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerSyncTaskProperties.
func (ctsssstp ConnectToSourceSQLServerSyncTaskProperties) AsProjectTaskProperties() (*ProjectTaskProperties, bool) {
	return nil, false
}

// AsBasicProjectTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerSyncTaskProperties.
func (ctsssstp ConnectToSourceSQLServerSyncTaskProperties) AsBasicProjectTaskProperties() (BasicProjectTaskProperties, bool) {
	return &ctsssstp, true
}

// UnmarshalJSON is the custom unmarshaler for ConnectToSourceSQLServerSyncTaskProperties struct.
func (ctsssstp *ConnectToSourceSQLServerSyncTaskProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "input":
			if v != nil {
				var input ConnectToSourceSQLServerTaskInput
				err = json.Unmarshal(*v, &input)
				if err != nil {
					return err
				}
				ctsssstp.Input = &input
			}
		case "output":
			if v != nil {
				output, err := unmarshalBasicConnectToSourceSQLServerTaskOutputArray(*v)
				if err != nil {
					return err
				}
				ctsssstp.Output = &output
			}
		case "errors":
			if v != nil {
				var errorsVar []ODataError
				err = json.Unmarshal(*v, &errorsVar)
				if err != nil {
					return err
				}
				ctsssstp.Errors = &errorsVar
			}
		case "state":
			if v != nil {
				var state TaskState
				err = json.Unmarshal(*v, &state)
				if err != nil {
					return err
				}
				ctsssstp.State = state
			}
		case "commands":
			if v != nil {
				commands, err := unmarshalBasicCommandPropertiesArray(*v)
				if err != nil {
					return err
				}
				ctsssstp.Commands = &commands
			}
		case "taskType":
			if v != nil {
				var taskType TaskType
				err = json.Unmarshal(*v, &taskType)
				if err != nil {
					return err
				}
				ctsssstp.TaskType = taskType
			}
		}
	}

	return nil
}

// ConnectToSourceSQLServerTaskInput input for the task that validates connection to SQL Server and also
// validates source server requirements
type ConnectToSourceSQLServerTaskInput struct {
	// SourceConnectionInfo - Connection information for Source SQL Server
	SourceConnectionInfo *SQLConnectionInfo `json:"sourceConnectionInfo,omitempty"`
	// CheckPermissionsGroup - Permission group for validations. Possible values include: 'Default', 'MigrationFromSQLServerToAzureDB', 'MigrationFromSQLServerToAzureMI', 'MigrationFromMySQLToAzureDBForMySQL'
	CheckPermissionsGroup ServerLevelPermissionsGroup `json:"checkPermissionsGroup,omitempty"`
	// CollectLogins - Flag for whether to collect logins from source server.
	CollectLogins *bool `json:"collectLogins,omitempty"`
	// CollectAgentJobs - Flag for whether to collect agent jobs from source server.
	CollectAgentJobs *bool `json:"collectAgentJobs,omitempty"`
}

// BasicConnectToSourceSQLServerTaskOutput output for the task that validates connection to SQL Server and also
// validates source server requirements
type BasicConnectToSourceSQLServerTaskOutput interface {
	AsConnectToSourceSQLServerTaskOutputAgentJobLevel() (*ConnectToSourceSQLServerTaskOutputAgentJobLevel, bool)
	AsConnectToSourceSQLServerTaskOutputLoginLevel() (*ConnectToSourceSQLServerTaskOutputLoginLevel, bool)
	AsConnectToSourceSQLServerTaskOutputDatabaseLevel() (*ConnectToSourceSQLServerTaskOutputDatabaseLevel, bool)
	AsConnectToSourceSQLServerTaskOutputTaskLevel() (*ConnectToSourceSQLServerTaskOutputTaskLevel, bool)
	AsConnectToSourceSQLServerTaskOutput() (*ConnectToSourceSQLServerTaskOutput, bool)
}

// ConnectToSourceSQLServerTaskOutput output for the task that validates connection to SQL Server and also
// validates source server requirements
type ConnectToSourceSQLServerTaskOutput struct {
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeConnectToSourceSQLServerTaskOutput', 'ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeAgentJobLevelOutput', 'ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeLoginLevelOutput', 'ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeTaskLevelOutput'
	ResultType ResultTypeBasicConnectToSourceSQLServerTaskOutput `json:"resultType,omitempty"`
}

func unmarshalBasicConnectToSourceSQLServerTaskOutput(body []byte) (BasicConnectToSourceSQLServerTaskOutput, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["resultType"] {
	case string(ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeAgentJobLevelOutput):
		var ctssstoajl ConnectToSourceSQLServerTaskOutputAgentJobLevel
		err := json.Unmarshal(body, &ctssstoajl)
		return ctssstoajl, err
	case string(ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeLoginLevelOutput):
		var ctssstoll ConnectToSourceSQLServerTaskOutputLoginLevel
		err := json.Unmarshal(body, &ctssstoll)
		return ctssstoll, err
	case string(ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeDatabaseLevelOutput):
		var ctssstodl ConnectToSourceSQLServerTaskOutputDatabaseLevel
		err := json.Unmarshal(body, &ctssstodl)
		return ctssstodl, err
	case string(ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeTaskLevelOutput):
		var ctssstotl ConnectToSourceSQLServerTaskOutputTaskLevel
		err := json.Unmarshal(body, &ctssstotl)
		return ctssstotl, err
	default:
		var ctsssto ConnectToSourceSQLServerTaskOutput
		err := json.Unmarshal(body, &ctsssto)
		return ctsssto, err
	}
}
func unmarshalBasicConnectToSourceSQLServerTaskOutputArray(body []byte) ([]BasicConnectToSourceSQLServerTaskOutput, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	ctssstoArray := make([]BasicConnectToSourceSQLServerTaskOutput, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ctsssto, err := unmarshalBasicConnectToSourceSQLServerTaskOutput(*rawMessage)
		if err != nil {
			return nil, err
		}
		ctssstoArray[index] = ctsssto
	}
	return ctssstoArray, nil
}

// MarshalJSON is the custom marshaler for ConnectToSourceSQLServerTaskOutput.
func (ctsssto ConnectToSourceSQLServerTaskOutput) MarshalJSON() ([]byte, error) {
	ctsssto.ResultType = ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeConnectToSourceSQLServerTaskOutput
	objectMap := make(map[string]interface{})
	if ctsssto.ResultType != "" {
		objectMap["resultType"] = ctsssto.ResultType
	}
	return json.Marshal(objectMap)
}

// AsConnectToSourceSQLServerTaskOutputAgentJobLevel is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutput.
func (ctsssto ConnectToSourceSQLServerTaskOutput) AsConnectToSourceSQLServerTaskOutputAgentJobLevel() (*ConnectToSourceSQLServerTaskOutputAgentJobLevel, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskOutputLoginLevel is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutput.
func (ctsssto ConnectToSourceSQLServerTaskOutput) AsConnectToSourceSQLServerTaskOutputLoginLevel() (*ConnectToSourceSQLServerTaskOutputLoginLevel, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskOutputDatabaseLevel is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutput.
func (ctsssto ConnectToSourceSQLServerTaskOutput) AsConnectToSourceSQLServerTaskOutputDatabaseLevel() (*ConnectToSourceSQLServerTaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskOutputTaskLevel is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutput.
func (ctsssto ConnectToSourceSQLServerTaskOutput) AsConnectToSourceSQLServerTaskOutputTaskLevel() (*ConnectToSourceSQLServerTaskOutputTaskLevel, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskOutput is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutput.
func (ctsssto ConnectToSourceSQLServerTaskOutput) AsConnectToSourceSQLServerTaskOutput() (*ConnectToSourceSQLServerTaskOutput, bool) {
	return &ctsssto, true
}

// AsBasicConnectToSourceSQLServerTaskOutput is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutput.
func (ctsssto ConnectToSourceSQLServerTaskOutput) AsBasicConnectToSourceSQLServerTaskOutput() (BasicConnectToSourceSQLServerTaskOutput, bool) {
	return &ctsssto, true
}

// ConnectToSourceSQLServerTaskOutputAgentJobLevel agentJob level output for the task that validates
// connection to SQL Server and also validates source server requirements
type ConnectToSourceSQLServerTaskOutputAgentJobLevel struct {
	// Name - READ-ONLY; AgentJob name
	Name *string `json:"name,omitempty"`
	// JobCategory - READ-ONLY; The type of AgentJob.
	JobCategory *string `json:"jobCategory,omitempty"`
	// IsEnabled - READ-ONLY; The state of the original AgentJob.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// JobOwner - READ-ONLY; The owner of the AgentJob
	JobOwner *string `json:"jobOwner,omitempty"`
	// LastExecutedOn - READ-ONLY; UTC Date and time when the AgentJob was last executed.
	LastExecutedOn *date.Time `json:"lastExecutedOn,omitempty"`
	// MigrationEligibility - READ-ONLY; Information about eligibility of agent job for migration.
	MigrationEligibility *MigrationEligibilityInfo `json:"migrationEligibility,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeConnectToSourceSQLServerTaskOutput', 'ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeAgentJobLevelOutput', 'ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeLoginLevelOutput', 'ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeTaskLevelOutput'
	ResultType ResultTypeBasicConnectToSourceSQLServerTaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectToSourceSQLServerTaskOutputAgentJobLevel.
func (ctssstoajl ConnectToSourceSQLServerTaskOutputAgentJobLevel) MarshalJSON() ([]byte, error) {
	ctssstoajl.ResultType = ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeAgentJobLevelOutput
	objectMap := make(map[string]interface{})
	if ctssstoajl.ResultType != "" {
		objectMap["resultType"] = ctssstoajl.ResultType
	}
	return json.Marshal(objectMap)
}

// AsConnectToSourceSQLServerTaskOutputAgentJobLevel is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutputAgentJobLevel.
func (ctssstoajl ConnectToSourceSQLServerTaskOutputAgentJobLevel) AsConnectToSourceSQLServerTaskOutputAgentJobLevel() (*ConnectToSourceSQLServerTaskOutputAgentJobLevel, bool) {
	return &ctssstoajl, true
}

// AsConnectToSourceSQLServerTaskOutputLoginLevel is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutputAgentJobLevel.
func (ctssstoajl ConnectToSourceSQLServerTaskOutputAgentJobLevel) AsConnectToSourceSQLServerTaskOutputLoginLevel() (*ConnectToSourceSQLServerTaskOutputLoginLevel, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskOutputDatabaseLevel is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutputAgentJobLevel.
func (ctssstoajl ConnectToSourceSQLServerTaskOutputAgentJobLevel) AsConnectToSourceSQLServerTaskOutputDatabaseLevel() (*ConnectToSourceSQLServerTaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskOutputTaskLevel is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutputAgentJobLevel.
func (ctssstoajl ConnectToSourceSQLServerTaskOutputAgentJobLevel) AsConnectToSourceSQLServerTaskOutputTaskLevel() (*ConnectToSourceSQLServerTaskOutputTaskLevel, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskOutput is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutputAgentJobLevel.
func (ctssstoajl ConnectToSourceSQLServerTaskOutputAgentJobLevel) AsConnectToSourceSQLServerTaskOutput() (*ConnectToSourceSQLServerTaskOutput, bool) {
	return nil, false
}

// AsBasicConnectToSourceSQLServerTaskOutput is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutputAgentJobLevel.
func (ctssstoajl ConnectToSourceSQLServerTaskOutputAgentJobLevel) AsBasicConnectToSourceSQLServerTaskOutput() (BasicConnectToSourceSQLServerTaskOutput, bool) {
	return &ctssstoajl, true
}

// ConnectToSourceSQLServerTaskOutputDatabaseLevel database level output for the task that validates
// connection to SQL Server and also validates source server requirements
type ConnectToSourceSQLServerTaskOutputDatabaseLevel struct {
	// Name - READ-ONLY; Database name
	Name *string `json:"name,omitempty"`
	// SizeMB - READ-ONLY; Size of the file in megabytes
	SizeMB *float64 `json:"sizeMB,omitempty"`
	// DatabaseFiles - READ-ONLY; The list of database files
	DatabaseFiles *[]DatabaseFileInfo `json:"databaseFiles,omitempty"`
	// CompatibilityLevel - READ-ONLY; SQL Server compatibility level of database. Possible values include: 'CompatLevel80', 'CompatLevel90', 'CompatLevel100', 'CompatLevel110', 'CompatLevel120', 'CompatLevel130', 'CompatLevel140'
	CompatibilityLevel DatabaseCompatLevel `json:"compatibilityLevel,omitempty"`
	// DatabaseState - READ-ONLY; State of the database. Possible values include: 'DatabaseStateOnline', 'DatabaseStateRestoring', 'DatabaseStateRecovering', 'DatabaseStateRecoveryPending', 'DatabaseStateSuspect', 'DatabaseStateEmergency', 'DatabaseStateOffline', 'DatabaseStateCopying', 'DatabaseStateOfflineSecondary'
	DatabaseState DatabaseState `json:"databaseState,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeConnectToSourceSQLServerTaskOutput', 'ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeAgentJobLevelOutput', 'ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeLoginLevelOutput', 'ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeTaskLevelOutput'
	ResultType ResultTypeBasicConnectToSourceSQLServerTaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectToSourceSQLServerTaskOutputDatabaseLevel.
func (ctssstodl ConnectToSourceSQLServerTaskOutputDatabaseLevel) MarshalJSON() ([]byte, error) {
	ctssstodl.ResultType = ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeDatabaseLevelOutput
	objectMap := make(map[string]interface{})
	if ctssstodl.ResultType != "" {
		objectMap["resultType"] = ctssstodl.ResultType
	}
	return json.Marshal(objectMap)
}

// AsConnectToSourceSQLServerTaskOutputAgentJobLevel is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutputDatabaseLevel.
func (ctssstodl ConnectToSourceSQLServerTaskOutputDatabaseLevel) AsConnectToSourceSQLServerTaskOutputAgentJobLevel() (*ConnectToSourceSQLServerTaskOutputAgentJobLevel, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskOutputLoginLevel is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutputDatabaseLevel.
func (ctssstodl ConnectToSourceSQLServerTaskOutputDatabaseLevel) AsConnectToSourceSQLServerTaskOutputLoginLevel() (*ConnectToSourceSQLServerTaskOutputLoginLevel, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskOutputDatabaseLevel is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutputDatabaseLevel.
func (ctssstodl ConnectToSourceSQLServerTaskOutputDatabaseLevel) AsConnectToSourceSQLServerTaskOutputDatabaseLevel() (*ConnectToSourceSQLServerTaskOutputDatabaseLevel, bool) {
	return &ctssstodl, true
}

// AsConnectToSourceSQLServerTaskOutputTaskLevel is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutputDatabaseLevel.
func (ctssstodl ConnectToSourceSQLServerTaskOutputDatabaseLevel) AsConnectToSourceSQLServerTaskOutputTaskLevel() (*ConnectToSourceSQLServerTaskOutputTaskLevel, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskOutput is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutputDatabaseLevel.
func (ctssstodl ConnectToSourceSQLServerTaskOutputDatabaseLevel) AsConnectToSourceSQLServerTaskOutput() (*ConnectToSourceSQLServerTaskOutput, bool) {
	return nil, false
}

// AsBasicConnectToSourceSQLServerTaskOutput is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutputDatabaseLevel.
func (ctssstodl ConnectToSourceSQLServerTaskOutputDatabaseLevel) AsBasicConnectToSourceSQLServerTaskOutput() (BasicConnectToSourceSQLServerTaskOutput, bool) {
	return &ctssstodl, true
}

// ConnectToSourceSQLServerTaskOutputLoginLevel login level output for the task that validates connection
// to SQL Server and also validates source server requirements
type ConnectToSourceSQLServerTaskOutputLoginLevel struct {
	// Name - READ-ONLY; Login name.
	Name *string `json:"name,omitempty"`
	// LoginType - READ-ONLY; The type of login. Possible values include: 'WindowsUser', 'WindowsGroup', 'SQLLogin', 'Certificate', 'AsymmetricKey', 'ExternalUser', 'ExternalGroup'
	LoginType LoginType `json:"loginType,omitempty"`
	// DefaultDatabase - READ-ONLY; The default database for the login.
	DefaultDatabase *string `json:"defaultDatabase,omitempty"`
	// IsEnabled - READ-ONLY; The state of the login.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// MigrationEligibility - READ-ONLY; Information about eligibility of login for migration.
	MigrationEligibility *MigrationEligibilityInfo `json:"migrationEligibility,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeConnectToSourceSQLServerTaskOutput', 'ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeAgentJobLevelOutput', 'ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeLoginLevelOutput', 'ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeTaskLevelOutput'
	ResultType ResultTypeBasicConnectToSourceSQLServerTaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectToSourceSQLServerTaskOutputLoginLevel.
func (ctssstoll ConnectToSourceSQLServerTaskOutputLoginLevel) MarshalJSON() ([]byte, error) {
	ctssstoll.ResultType = ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeLoginLevelOutput
	objectMap := make(map[string]interface{})
	if ctssstoll.ResultType != "" {
		objectMap["resultType"] = ctssstoll.ResultType
	}
	return json.Marshal(objectMap)
}

// AsConnectToSourceSQLServerTaskOutputAgentJobLevel is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutputLoginLevel.
func (ctssstoll ConnectToSourceSQLServerTaskOutputLoginLevel) AsConnectToSourceSQLServerTaskOutputAgentJobLevel() (*ConnectToSourceSQLServerTaskOutputAgentJobLevel, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskOutputLoginLevel is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutputLoginLevel.
func (ctssstoll ConnectToSourceSQLServerTaskOutputLoginLevel) AsConnectToSourceSQLServerTaskOutputLoginLevel() (*ConnectToSourceSQLServerTaskOutputLoginLevel, bool) {
	return &ctssstoll, true
}

// AsConnectToSourceSQLServerTaskOutputDatabaseLevel is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutputLoginLevel.
func (ctssstoll ConnectToSourceSQLServerTaskOutputLoginLevel) AsConnectToSourceSQLServerTaskOutputDatabaseLevel() (*ConnectToSourceSQLServerTaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskOutputTaskLevel is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutputLoginLevel.
func (ctssstoll ConnectToSourceSQLServerTaskOutputLoginLevel) AsConnectToSourceSQLServerTaskOutputTaskLevel() (*ConnectToSourceSQLServerTaskOutputTaskLevel, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskOutput is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutputLoginLevel.
func (ctssstoll ConnectToSourceSQLServerTaskOutputLoginLevel) AsConnectToSourceSQLServerTaskOutput() (*ConnectToSourceSQLServerTaskOutput, bool) {
	return nil, false
}

// AsBasicConnectToSourceSQLServerTaskOutput is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutputLoginLevel.
func (ctssstoll ConnectToSourceSQLServerTaskOutputLoginLevel) AsBasicConnectToSourceSQLServerTaskOutput() (BasicConnectToSourceSQLServerTaskOutput, bool) {
	return &ctssstoll, true
}

// ConnectToSourceSQLServerTaskOutputTaskLevel task level output for the task that validates connection to
// SQL Server and also validates source server requirements
type ConnectToSourceSQLServerTaskOutputTaskLevel struct {
	// Databases - READ-ONLY; Source databases as a map from database name to database id
	Databases map[string]*string `json:"databases"`
	// Logins - READ-ONLY; Source logins as a map from login name to login id.
	Logins map[string]*string `json:"logins"`
	// AgentJobs - READ-ONLY; Source agent jobs as a map from agent job name to id.
	AgentJobs map[string]*string `json:"agentJobs"`
	// SourceServerVersion - READ-ONLY; Source server version
	SourceServerVersion *string `json:"sourceServerVersion,omitempty"`
	// SourceServerBrandVersion - READ-ONLY; Source server brand version
	SourceServerBrandVersion *string `json:"sourceServerBrandVersion,omitempty"`
	// ValidationErrors - READ-ONLY; Validation errors
	ValidationErrors *[]ReportableException `json:"validationErrors,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeConnectToSourceSQLServerTaskOutput', 'ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeAgentJobLevelOutput', 'ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeLoginLevelOutput', 'ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeTaskLevelOutput'
	ResultType ResultTypeBasicConnectToSourceSQLServerTaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectToSourceSQLServerTaskOutputTaskLevel.
func (ctssstotl ConnectToSourceSQLServerTaskOutputTaskLevel) MarshalJSON() ([]byte, error) {
	ctssstotl.ResultType = ResultTypeBasicConnectToSourceSQLServerTaskOutputResultTypeTaskLevelOutput
	objectMap := make(map[string]interface{})
	if ctssstotl.ResultType != "" {
		objectMap["resultType"] = ctssstotl.ResultType
	}
	return json.Marshal(objectMap)
}

// AsConnectToSourceSQLServerTaskOutputAgentJobLevel is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutputTaskLevel.
func (ctssstotl ConnectToSourceSQLServerTaskOutputTaskLevel) AsConnectToSourceSQLServerTaskOutputAgentJobLevel() (*ConnectToSourceSQLServerTaskOutputAgentJobLevel, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskOutputLoginLevel is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutputTaskLevel.
func (ctssstotl ConnectToSourceSQLServerTaskOutputTaskLevel) AsConnectToSourceSQLServerTaskOutputLoginLevel() (*ConnectToSourceSQLServerTaskOutputLoginLevel, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskOutputDatabaseLevel is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutputTaskLevel.
func (ctssstotl ConnectToSourceSQLServerTaskOutputTaskLevel) AsConnectToSourceSQLServerTaskOutputDatabaseLevel() (*ConnectToSourceSQLServerTaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskOutputTaskLevel is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutputTaskLevel.
func (ctssstotl ConnectToSourceSQLServerTaskOutputTaskLevel) AsConnectToSourceSQLServerTaskOutputTaskLevel() (*ConnectToSourceSQLServerTaskOutputTaskLevel, bool) {
	return &ctssstotl, true
}

// AsConnectToSourceSQLServerTaskOutput is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutputTaskLevel.
func (ctssstotl ConnectToSourceSQLServerTaskOutputTaskLevel) AsConnectToSourceSQLServerTaskOutput() (*ConnectToSourceSQLServerTaskOutput, bool) {
	return nil, false
}

// AsBasicConnectToSourceSQLServerTaskOutput is the BasicConnectToSourceSQLServerTaskOutput implementation for ConnectToSourceSQLServerTaskOutputTaskLevel.
func (ctssstotl ConnectToSourceSQLServerTaskOutputTaskLevel) AsBasicConnectToSourceSQLServerTaskOutput() (BasicConnectToSourceSQLServerTaskOutput, bool) {
	return &ctssstotl, true
}

// ConnectToSourceSQLServerTaskProperties properties for the task that validates connection to SQL Server
// and also validates source server requirements
type ConnectToSourceSQLServerTaskProperties struct {
	// Input - Task input
	Input *ConnectToSourceSQLServerTaskInput `json:"input,omitempty"`
	// Output - READ-ONLY; Task output. This is ignored if submitted.
	Output *[]BasicConnectToSourceSQLServerTaskOutput `json:"output,omitempty"`
	// Errors - READ-ONLY; Array of errors. This is ignored if submitted.
	Errors *[]ODataError `json:"errors,omitempty"`
	// State - READ-ONLY; The state of the task. This is ignored if submitted. Possible values include: 'TaskStateUnknown', 'TaskStateQueued', 'TaskStateRunning', 'TaskStateCanceled', 'TaskStateSucceeded', 'TaskStateFailed', 'TaskStateFailedInputValidation', 'TaskStateFaulted'
	State TaskState `json:"state,omitempty"`
	// Commands - READ-ONLY; Array of command properties.
	Commands *[]BasicCommandProperties `json:"commands,omitempty"`
	// TaskType - Possible values include: 'TaskTypeUnknown', 'TaskTypeGetTDECertificatesSQL', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMISyncLRS', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMI', 'TaskTypeValidateMigrationInputSQLServerSQLDbSync', 'TaskTypeMigratePostgreSQLAzureDbForPostgreSQLSync', 'TaskTypeMigrateMySQLAzureDbForMySQLSync', 'TaskTypeMigrateSQLServerAzureSQLDbSync', 'TaskTypeMigrateSQLServerSQLDb', 'TaskTypeMigrateSQLServerAzureSQLDbMISyncLRS', 'TaskTypeMigrateSQLServerAzureSQLDbMI', 'TaskTypeConnectToTargetAzureDbForMySQL', 'TaskTypeConnectToTargetAzureSQLDbMISyncLRS', 'TaskTypeConnectToTargetAzureSQLDbMI', 'TaskTypeGetUserTablesAzureSQLDbSync', 'TaskTypeGetUserTablesSQL', 'TaskTypeConnectToTargetAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetSQLDbSync', 'TaskTypeConnectToTargetSQLDb', 'TaskTypeConnectToSourcePostgreSQLSync', 'TaskTypeConnectToSourceSQLServerSync', 'TaskTypeConnectToSourceSQLServer', 'TaskTypeConnectToSourceMySQL'
	TaskType TaskType `json:"taskType,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) MarshalJSON() ([]byte, error) {
	ctssstp.TaskType = TaskTypeConnectToSourceSQLServer
	objectMap := make(map[string]interface{})
	if ctssstp.Input != nil {
		objectMap["input"] = ctssstp.Input
	}
	if ctssstp.TaskType != "" {
		objectMap["taskType"] = ctssstp.TaskType
	}
	return json.Marshal(objectMap)
}

// AsGetTdeCertificatesSQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) AsGetTdeCertificatesSQLTaskProperties() (*GetTdeCertificatesSQLTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) AsValidateMigrationInputSQLServerSQLMISyncTaskProperties() (*ValidateMigrationInputSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) AsValidateMigrationInputSQLServerSQLMITaskProperties() (*ValidateMigrationInputSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties() (*ValidateMigrationInputSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) AsMigrateMySQLAzureDbForMySQLSyncTaskProperties() (*MigrateMySQLAzureDbForMySQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) AsMigrateSQLServerSQLDbSyncTaskProperties() (*MigrateSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) AsMigrateSQLServerSQLDbTaskProperties() (*MigrateSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) AsMigrateSQLServerSQLMISyncTaskProperties() (*MigrateSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) AsMigrateSQLServerSQLMITaskProperties() (*MigrateSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForMySQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) AsConnectToTargetAzureDbForMySQLTaskProperties() (*ConnectToTargetAzureDbForMySQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) AsConnectToTargetSQLMISyncTaskProperties() (*ConnectToTargetSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMITaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) AsConnectToTargetSQLMITaskProperties() (*ConnectToTargetSQLMITaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) AsGetUserTablesSQLSyncTaskProperties() (*GetUserTablesSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) AsGetUserTablesSQLTaskProperties() (*GetUserTablesSQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) AsConnectToTargetSQLSQLDbSyncTaskProperties() (*ConnectToTargetSQLSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) AsConnectToTargetSQLDbTaskProperties() (*ConnectToTargetSQLDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourcePostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) AsConnectToSourcePostgreSQLSyncTaskProperties() (*ConnectToSourcePostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) AsConnectToSourceSQLServerSyncTaskProperties() (*ConnectToSourceSQLServerSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) AsConnectToSourceSQLServerTaskProperties() (*ConnectToSourceSQLServerTaskProperties, bool) {
	return &ctssstp, true
}

// AsConnectToSourceMySQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) AsConnectToSourceMySQLTaskProperties() (*ConnectToSourceMySQLTaskProperties, bool) {
	return nil, false
}

// AsProjectTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) AsProjectTaskProperties() (*ProjectTaskProperties, bool) {
	return nil, false
}

// AsBasicProjectTaskProperties is the BasicProjectTaskProperties implementation for ConnectToSourceSQLServerTaskProperties.
func (ctssstp ConnectToSourceSQLServerTaskProperties) AsBasicProjectTaskProperties() (BasicProjectTaskProperties, bool) {
	return &ctssstp, true
}

// UnmarshalJSON is the custom unmarshaler for ConnectToSourceSQLServerTaskProperties struct.
func (ctssstp *ConnectToSourceSQLServerTaskProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "input":
			if v != nil {
				var input ConnectToSourceSQLServerTaskInput
				err = json.Unmarshal(*v, &input)
				if err != nil {
					return err
				}
				ctssstp.Input = &input
			}
		case "output":
			if v != nil {
				output, err := unmarshalBasicConnectToSourceSQLServerTaskOutputArray(*v)
				if err != nil {
					return err
				}
				ctssstp.Output = &output
			}
		case "errors":
			if v != nil {
				var errorsVar []ODataError
				err = json.Unmarshal(*v, &errorsVar)
				if err != nil {
					return err
				}
				ctssstp.Errors = &errorsVar
			}
		case "state":
			if v != nil {
				var state TaskState
				err = json.Unmarshal(*v, &state)
				if err != nil {
					return err
				}
				ctssstp.State = state
			}
		case "commands":
			if v != nil {
				commands, err := unmarshalBasicCommandPropertiesArray(*v)
				if err != nil {
					return err
				}
				ctssstp.Commands = &commands
			}
		case "taskType":
			if v != nil {
				var taskType TaskType
				err = json.Unmarshal(*v, &taskType)
				if err != nil {
					return err
				}
				ctssstp.TaskType = taskType
			}
		}
	}

	return nil
}

// ConnectToTargetAzureDbForMySQLTaskInput input for the task that validates connection to Azure Database
// for MySQL and target server requirements
type ConnectToTargetAzureDbForMySQLTaskInput struct {
	// SourceConnectionInfo - Connection information for source MySQL server
	SourceConnectionInfo *MySQLConnectionInfo `json:"sourceConnectionInfo,omitempty"`
	// TargetConnectionInfo - Connection information for target Azure Database for MySQL server
	TargetConnectionInfo *MySQLConnectionInfo `json:"targetConnectionInfo,omitempty"`
}

// ConnectToTargetAzureDbForMySQLTaskOutput output for the task that validates connection to Azure Database
// for MySQL and target server requirements
type ConnectToTargetAzureDbForMySQLTaskOutput struct {
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ServerVersion - READ-ONLY; Version of the target server
	ServerVersion *string `json:"serverVersion,omitempty"`
	// Databases - READ-ONLY; List of databases on target server
	Databases *[]string `json:"databases,omitempty"`
	// TargetServerBrandVersion - READ-ONLY; Target server brand version
	TargetServerBrandVersion *string `json:"targetServerBrandVersion,omitempty"`
	// ValidationErrors - READ-ONLY; Validation errors associated with the task
	ValidationErrors *[]ReportableException `json:"validationErrors,omitempty"`
}

// ConnectToTargetAzureDbForMySQLTaskProperties properties for the task that validates connection to Azure
// Database for MySQL and target server requirements
type ConnectToTargetAzureDbForMySQLTaskProperties struct {
	// Input - Task input
	Input *ConnectToTargetAzureDbForMySQLTaskInput `json:"input,omitempty"`
	// Output - READ-ONLY; Task output. This is ignored if submitted.
	Output *[]ConnectToTargetAzureDbForMySQLTaskOutput `json:"output,omitempty"`
	// Errors - READ-ONLY; Array of errors. This is ignored if submitted.
	Errors *[]ODataError `json:"errors,omitempty"`
	// State - READ-ONLY; The state of the task. This is ignored if submitted. Possible values include: 'TaskStateUnknown', 'TaskStateQueued', 'TaskStateRunning', 'TaskStateCanceled', 'TaskStateSucceeded', 'TaskStateFailed', 'TaskStateFailedInputValidation', 'TaskStateFaulted'
	State TaskState `json:"state,omitempty"`
	// Commands - READ-ONLY; Array of command properties.
	Commands *[]BasicCommandProperties `json:"commands,omitempty"`
	// TaskType - Possible values include: 'TaskTypeUnknown', 'TaskTypeGetTDECertificatesSQL', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMISyncLRS', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMI', 'TaskTypeValidateMigrationInputSQLServerSQLDbSync', 'TaskTypeMigratePostgreSQLAzureDbForPostgreSQLSync', 'TaskTypeMigrateMySQLAzureDbForMySQLSync', 'TaskTypeMigrateSQLServerAzureSQLDbSync', 'TaskTypeMigrateSQLServerSQLDb', 'TaskTypeMigrateSQLServerAzureSQLDbMISyncLRS', 'TaskTypeMigrateSQLServerAzureSQLDbMI', 'TaskTypeConnectToTargetAzureDbForMySQL', 'TaskTypeConnectToTargetAzureSQLDbMISyncLRS', 'TaskTypeConnectToTargetAzureSQLDbMI', 'TaskTypeGetUserTablesAzureSQLDbSync', 'TaskTypeGetUserTablesSQL', 'TaskTypeConnectToTargetAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetSQLDbSync', 'TaskTypeConnectToTargetSQLDb', 'TaskTypeConnectToSourcePostgreSQLSync', 'TaskTypeConnectToSourceSQLServerSync', 'TaskTypeConnectToSourceSQLServer', 'TaskTypeConnectToSourceMySQL'
	TaskType TaskType `json:"taskType,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectToTargetAzureDbForMySQLTaskProperties.
func (cttadfmstp ConnectToTargetAzureDbForMySQLTaskProperties) MarshalJSON() ([]byte, error) {
	cttadfmstp.TaskType = TaskTypeConnectToTargetAzureDbForMySQL
	objectMap := make(map[string]interface{})
	if cttadfmstp.Input != nil {
		objectMap["input"] = cttadfmstp.Input
	}
	if cttadfmstp.TaskType != "" {
		objectMap["taskType"] = cttadfmstp.TaskType
	}
	return json.Marshal(objectMap)
}

// AsGetTdeCertificatesSQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForMySQLTaskProperties.
func (cttadfmstp ConnectToTargetAzureDbForMySQLTaskProperties) AsGetTdeCertificatesSQLTaskProperties() (*GetTdeCertificatesSQLTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForMySQLTaskProperties.
func (cttadfmstp ConnectToTargetAzureDbForMySQLTaskProperties) AsValidateMigrationInputSQLServerSQLMISyncTaskProperties() (*ValidateMigrationInputSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForMySQLTaskProperties.
func (cttadfmstp ConnectToTargetAzureDbForMySQLTaskProperties) AsValidateMigrationInputSQLServerSQLMITaskProperties() (*ValidateMigrationInputSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForMySQLTaskProperties.
func (cttadfmstp ConnectToTargetAzureDbForMySQLTaskProperties) AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties() (*ValidateMigrationInputSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForMySQLTaskProperties.
func (cttadfmstp ConnectToTargetAzureDbForMySQLTaskProperties) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForMySQLTaskProperties.
func (cttadfmstp ConnectToTargetAzureDbForMySQLTaskProperties) AsMigrateMySQLAzureDbForMySQLSyncTaskProperties() (*MigrateMySQLAzureDbForMySQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForMySQLTaskProperties.
func (cttadfmstp ConnectToTargetAzureDbForMySQLTaskProperties) AsMigrateSQLServerSQLDbSyncTaskProperties() (*MigrateSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForMySQLTaskProperties.
func (cttadfmstp ConnectToTargetAzureDbForMySQLTaskProperties) AsMigrateSQLServerSQLDbTaskProperties() (*MigrateSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForMySQLTaskProperties.
func (cttadfmstp ConnectToTargetAzureDbForMySQLTaskProperties) AsMigrateSQLServerSQLMISyncTaskProperties() (*MigrateSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForMySQLTaskProperties.
func (cttadfmstp ConnectToTargetAzureDbForMySQLTaskProperties) AsMigrateSQLServerSQLMITaskProperties() (*MigrateSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForMySQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForMySQLTaskProperties.
func (cttadfmstp ConnectToTargetAzureDbForMySQLTaskProperties) AsConnectToTargetAzureDbForMySQLTaskProperties() (*ConnectToTargetAzureDbForMySQLTaskProperties, bool) {
	return &cttadfmstp, true
}

// AsConnectToTargetSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForMySQLTaskProperties.
func (cttadfmstp ConnectToTargetAzureDbForMySQLTaskProperties) AsConnectToTargetSQLMISyncTaskProperties() (*ConnectToTargetSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMITaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForMySQLTaskProperties.
func (cttadfmstp ConnectToTargetAzureDbForMySQLTaskProperties) AsConnectToTargetSQLMITaskProperties() (*ConnectToTargetSQLMITaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForMySQLTaskProperties.
func (cttadfmstp ConnectToTargetAzureDbForMySQLTaskProperties) AsGetUserTablesSQLSyncTaskProperties() (*GetUserTablesSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForMySQLTaskProperties.
func (cttadfmstp ConnectToTargetAzureDbForMySQLTaskProperties) AsGetUserTablesSQLTaskProperties() (*GetUserTablesSQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForMySQLTaskProperties.
func (cttadfmstp ConnectToTargetAzureDbForMySQLTaskProperties) AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForMySQLTaskProperties.
func (cttadfmstp ConnectToTargetAzureDbForMySQLTaskProperties) AsConnectToTargetSQLSQLDbSyncTaskProperties() (*ConnectToTargetSQLSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForMySQLTaskProperties.
func (cttadfmstp ConnectToTargetAzureDbForMySQLTaskProperties) AsConnectToTargetSQLDbTaskProperties() (*ConnectToTargetSQLDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourcePostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForMySQLTaskProperties.
func (cttadfmstp ConnectToTargetAzureDbForMySQLTaskProperties) AsConnectToSourcePostgreSQLSyncTaskProperties() (*ConnectToSourcePostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForMySQLTaskProperties.
func (cttadfmstp ConnectToTargetAzureDbForMySQLTaskProperties) AsConnectToSourceSQLServerSyncTaskProperties() (*ConnectToSourceSQLServerSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForMySQLTaskProperties.
func (cttadfmstp ConnectToTargetAzureDbForMySQLTaskProperties) AsConnectToSourceSQLServerTaskProperties() (*ConnectToSourceSQLServerTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceMySQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForMySQLTaskProperties.
func (cttadfmstp ConnectToTargetAzureDbForMySQLTaskProperties) AsConnectToSourceMySQLTaskProperties() (*ConnectToSourceMySQLTaskProperties, bool) {
	return nil, false
}

// AsProjectTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForMySQLTaskProperties.
func (cttadfmstp ConnectToTargetAzureDbForMySQLTaskProperties) AsProjectTaskProperties() (*ProjectTaskProperties, bool) {
	return nil, false
}

// AsBasicProjectTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForMySQLTaskProperties.
func (cttadfmstp ConnectToTargetAzureDbForMySQLTaskProperties) AsBasicProjectTaskProperties() (BasicProjectTaskProperties, bool) {
	return &cttadfmstp, true
}

// UnmarshalJSON is the custom unmarshaler for ConnectToTargetAzureDbForMySQLTaskProperties struct.
func (cttadfmstp *ConnectToTargetAzureDbForMySQLTaskProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "input":
			if v != nil {
				var input ConnectToTargetAzureDbForMySQLTaskInput
				err = json.Unmarshal(*v, &input)
				if err != nil {
					return err
				}
				cttadfmstp.Input = &input
			}
		case "output":
			if v != nil {
				var output []ConnectToTargetAzureDbForMySQLTaskOutput
				err = json.Unmarshal(*v, &output)
				if err != nil {
					return err
				}
				cttadfmstp.Output = &output
			}
		case "errors":
			if v != nil {
				var errorsVar []ODataError
				err = json.Unmarshal(*v, &errorsVar)
				if err != nil {
					return err
				}
				cttadfmstp.Errors = &errorsVar
			}
		case "state":
			if v != nil {
				var state TaskState
				err = json.Unmarshal(*v, &state)
				if err != nil {
					return err
				}
				cttadfmstp.State = state
			}
		case "commands":
			if v != nil {
				commands, err := unmarshalBasicCommandPropertiesArray(*v)
				if err != nil {
					return err
				}
				cttadfmstp.Commands = &commands
			}
		case "taskType":
			if v != nil {
				var taskType TaskType
				err = json.Unmarshal(*v, &taskType)
				if err != nil {
					return err
				}
				cttadfmstp.TaskType = taskType
			}
		}
	}

	return nil
}

// ConnectToTargetAzureDbForPostgreSQLSyncTaskInput input for the task that validates connection to Azure
// Database for PostgreSQL and target server requirements
type ConnectToTargetAzureDbForPostgreSQLSyncTaskInput struct {
	// SourceConnectionInfo - Connection information for source PostgreSQL server
	SourceConnectionInfo *PostgreSQLConnectionInfo `json:"sourceConnectionInfo,omitempty"`
	// TargetConnectionInfo - Connection information for target Azure Database for PostgreSQL server
	TargetConnectionInfo *PostgreSQLConnectionInfo `json:"targetConnectionInfo,omitempty"`
}

// ConnectToTargetAzureDbForPostgreSQLSyncTaskOutput output for the task that validates connection to Azure
// Database for PostgreSQL and target server requirements
type ConnectToTargetAzureDbForPostgreSQLSyncTaskOutput struct {
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// TargetServerVersion - READ-ONLY; Version of the target server
	TargetServerVersion *string `json:"targetServerVersion,omitempty"`
	// Databases - READ-ONLY; List of databases on target server
	Databases *[]string `json:"databases,omitempty"`
	// TargetServerBrandVersion - READ-ONLY; Target server brand version
	TargetServerBrandVersion *string `json:"targetServerBrandVersion,omitempty"`
	// ValidationErrors - READ-ONLY; Validation errors associated with the task
	ValidationErrors *[]ReportableException `json:"validationErrors,omitempty"`
}

// ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties properties for the task that validates connection
// to Azure Database For PostgreSQL server and target server requirements for online migration
type ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties struct {
	// Input - Task input
	Input *ConnectToTargetAzureDbForPostgreSQLSyncTaskInput `json:"input,omitempty"`
	// Output - READ-ONLY; Task output. This is ignored if submitted.
	Output *[]ConnectToTargetAzureDbForPostgreSQLSyncTaskOutput `json:"output,omitempty"`
	// Errors - READ-ONLY; Array of errors. This is ignored if submitted.
	Errors *[]ODataError `json:"errors,omitempty"`
	// State - READ-ONLY; The state of the task. This is ignored if submitted. Possible values include: 'TaskStateUnknown', 'TaskStateQueued', 'TaskStateRunning', 'TaskStateCanceled', 'TaskStateSucceeded', 'TaskStateFailed', 'TaskStateFailedInputValidation', 'TaskStateFaulted'
	State TaskState `json:"state,omitempty"`
	// Commands - READ-ONLY; Array of command properties.
	Commands *[]BasicCommandProperties `json:"commands,omitempty"`
	// TaskType - Possible values include: 'TaskTypeUnknown', 'TaskTypeGetTDECertificatesSQL', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMISyncLRS', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMI', 'TaskTypeValidateMigrationInputSQLServerSQLDbSync', 'TaskTypeMigratePostgreSQLAzureDbForPostgreSQLSync', 'TaskTypeMigrateMySQLAzureDbForMySQLSync', 'TaskTypeMigrateSQLServerAzureSQLDbSync', 'TaskTypeMigrateSQLServerSQLDb', 'TaskTypeMigrateSQLServerAzureSQLDbMISyncLRS', 'TaskTypeMigrateSQLServerAzureSQLDbMI', 'TaskTypeConnectToTargetAzureDbForMySQL', 'TaskTypeConnectToTargetAzureSQLDbMISyncLRS', 'TaskTypeConnectToTargetAzureSQLDbMI', 'TaskTypeGetUserTablesAzureSQLDbSync', 'TaskTypeGetUserTablesSQL', 'TaskTypeConnectToTargetAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetSQLDbSync', 'TaskTypeConnectToTargetSQLDb', 'TaskTypeConnectToSourcePostgreSQLSync', 'TaskTypeConnectToSourceSQLServerSync', 'TaskTypeConnectToSourceSQLServer', 'TaskTypeConnectToSourceMySQL'
	TaskType TaskType `json:"taskType,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties.
func (cttadfpsstp ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties) MarshalJSON() ([]byte, error) {
	cttadfpsstp.TaskType = TaskTypeConnectToTargetAzureDbForPostgreSQLSync
	objectMap := make(map[string]interface{})
	if cttadfpsstp.Input != nil {
		objectMap["input"] = cttadfpsstp.Input
	}
	if cttadfpsstp.TaskType != "" {
		objectMap["taskType"] = cttadfpsstp.TaskType
	}
	return json.Marshal(objectMap)
}

// AsGetTdeCertificatesSQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties.
func (cttadfpsstp ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties) AsGetTdeCertificatesSQLTaskProperties() (*GetTdeCertificatesSQLTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties.
func (cttadfpsstp ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties) AsValidateMigrationInputSQLServerSQLMISyncTaskProperties() (*ValidateMigrationInputSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties.
func (cttadfpsstp ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties) AsValidateMigrationInputSQLServerSQLMITaskProperties() (*ValidateMigrationInputSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties.
func (cttadfpsstp ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties) AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties() (*ValidateMigrationInputSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties.
func (cttadfpsstp ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties.
func (cttadfpsstp ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties) AsMigrateMySQLAzureDbForMySQLSyncTaskProperties() (*MigrateMySQLAzureDbForMySQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties.
func (cttadfpsstp ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties) AsMigrateSQLServerSQLDbSyncTaskProperties() (*MigrateSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties.
func (cttadfpsstp ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties) AsMigrateSQLServerSQLDbTaskProperties() (*MigrateSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties.
func (cttadfpsstp ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties) AsMigrateSQLServerSQLMISyncTaskProperties() (*MigrateSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties.
func (cttadfpsstp ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties) AsMigrateSQLServerSQLMITaskProperties() (*MigrateSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForMySQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties.
func (cttadfpsstp ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties) AsConnectToTargetAzureDbForMySQLTaskProperties() (*ConnectToTargetAzureDbForMySQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties.
func (cttadfpsstp ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties) AsConnectToTargetSQLMISyncTaskProperties() (*ConnectToTargetSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMITaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties.
func (cttadfpsstp ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties) AsConnectToTargetSQLMITaskProperties() (*ConnectToTargetSQLMITaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties.
func (cttadfpsstp ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties) AsGetUserTablesSQLSyncTaskProperties() (*GetUserTablesSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties.
func (cttadfpsstp ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties) AsGetUserTablesSQLTaskProperties() (*GetUserTablesSQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties.
func (cttadfpsstp ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties) AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return &cttadfpsstp, true
}

// AsConnectToTargetSQLSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties.
func (cttadfpsstp ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties) AsConnectToTargetSQLSQLDbSyncTaskProperties() (*ConnectToTargetSQLSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties.
func (cttadfpsstp ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties) AsConnectToTargetSQLDbTaskProperties() (*ConnectToTargetSQLDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourcePostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties.
func (cttadfpsstp ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties) AsConnectToSourcePostgreSQLSyncTaskProperties() (*ConnectToSourcePostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties.
func (cttadfpsstp ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties) AsConnectToSourceSQLServerSyncTaskProperties() (*ConnectToSourceSQLServerSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties.
func (cttadfpsstp ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties) AsConnectToSourceSQLServerTaskProperties() (*ConnectToSourceSQLServerTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceMySQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties.
func (cttadfpsstp ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties) AsConnectToSourceMySQLTaskProperties() (*ConnectToSourceMySQLTaskProperties, bool) {
	return nil, false
}

// AsProjectTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties.
func (cttadfpsstp ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties) AsProjectTaskProperties() (*ProjectTaskProperties, bool) {
	return nil, false
}

// AsBasicProjectTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties.
func (cttadfpsstp ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties) AsBasicProjectTaskProperties() (BasicProjectTaskProperties, bool) {
	return &cttadfpsstp, true
}

// UnmarshalJSON is the custom unmarshaler for ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties struct.
func (cttadfpsstp *ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "input":
			if v != nil {
				var input ConnectToTargetAzureDbForPostgreSQLSyncTaskInput
				err = json.Unmarshal(*v, &input)
				if err != nil {
					return err
				}
				cttadfpsstp.Input = &input
			}
		case "output":
			if v != nil {
				var output []ConnectToTargetAzureDbForPostgreSQLSyncTaskOutput
				err = json.Unmarshal(*v, &output)
				if err != nil {
					return err
				}
				cttadfpsstp.Output = &output
			}
		case "errors":
			if v != nil {
				var errorsVar []ODataError
				err = json.Unmarshal(*v, &errorsVar)
				if err != nil {
					return err
				}
				cttadfpsstp.Errors = &errorsVar
			}
		case "state":
			if v != nil {
				var state TaskState
				err = json.Unmarshal(*v, &state)
				if err != nil {
					return err
				}
				cttadfpsstp.State = state
			}
		case "commands":
			if v != nil {
				commands, err := unmarshalBasicCommandPropertiesArray(*v)
				if err != nil {
					return err
				}
				cttadfpsstp.Commands = &commands
			}
		case "taskType":
			if v != nil {
				var taskType TaskType
				err = json.Unmarshal(*v, &taskType)
				if err != nil {
					return err
				}
				cttadfpsstp.TaskType = taskType
			}
		}
	}

	return nil
}

// ConnectToTargetSQLDbTaskInput input for the task that validates connection to SQL DB and target server
// requirements
type ConnectToTargetSQLDbTaskInput struct {
	// TargetConnectionInfo - Connection information for target SQL DB
	TargetConnectionInfo *SQLConnectionInfo `json:"targetConnectionInfo,omitempty"`
}

// ConnectToTargetSQLDbTaskOutput output for the task that validates connection to SQL DB and target server
// requirements
type ConnectToTargetSQLDbTaskOutput struct {
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// Databases - READ-ONLY; Source databases as a map from database name to database id
	Databases map[string]*string `json:"databases"`
	// TargetServerVersion - READ-ONLY; Version of the target server
	TargetServerVersion *string `json:"targetServerVersion,omitempty"`
	// TargetServerBrandVersion - READ-ONLY; Target server brand version
	TargetServerBrandVersion *string `json:"targetServerBrandVersion,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectToTargetSQLDbTaskOutput.
func (cttsdto ConnectToTargetSQLDbTaskOutput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ConnectToTargetSQLDbTaskProperties properties for the task that validates connection to SQL DB and
// target server requirements
type ConnectToTargetSQLDbTaskProperties struct {
	// Input - Task input
	Input *ConnectToTargetSQLDbTaskInput `json:"input,omitempty"`
	// Output - READ-ONLY; Task output. This is ignored if submitted.
	Output *[]ConnectToTargetSQLDbTaskOutput `json:"output,omitempty"`
	// Errors - READ-ONLY; Array of errors. This is ignored if submitted.
	Errors *[]ODataError `json:"errors,omitempty"`
	// State - READ-ONLY; The state of the task. This is ignored if submitted. Possible values include: 'TaskStateUnknown', 'TaskStateQueued', 'TaskStateRunning', 'TaskStateCanceled', 'TaskStateSucceeded', 'TaskStateFailed', 'TaskStateFailedInputValidation', 'TaskStateFaulted'
	State TaskState `json:"state,omitempty"`
	// Commands - READ-ONLY; Array of command properties.
	Commands *[]BasicCommandProperties `json:"commands,omitempty"`
	// TaskType - Possible values include: 'TaskTypeUnknown', 'TaskTypeGetTDECertificatesSQL', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMISyncLRS', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMI', 'TaskTypeValidateMigrationInputSQLServerSQLDbSync', 'TaskTypeMigratePostgreSQLAzureDbForPostgreSQLSync', 'TaskTypeMigrateMySQLAzureDbForMySQLSync', 'TaskTypeMigrateSQLServerAzureSQLDbSync', 'TaskTypeMigrateSQLServerSQLDb', 'TaskTypeMigrateSQLServerAzureSQLDbMISyncLRS', 'TaskTypeMigrateSQLServerAzureSQLDbMI', 'TaskTypeConnectToTargetAzureDbForMySQL', 'TaskTypeConnectToTargetAzureSQLDbMISyncLRS', 'TaskTypeConnectToTargetAzureSQLDbMI', 'TaskTypeGetUserTablesAzureSQLDbSync', 'TaskTypeGetUserTablesSQL', 'TaskTypeConnectToTargetAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetSQLDbSync', 'TaskTypeConnectToTargetSQLDb', 'TaskTypeConnectToSourcePostgreSQLSync', 'TaskTypeConnectToSourceSQLServerSync', 'TaskTypeConnectToSourceSQLServer', 'TaskTypeConnectToSourceMySQL'
	TaskType TaskType `json:"taskType,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) MarshalJSON() ([]byte, error) {
	cttsdtp.TaskType = TaskTypeConnectToTargetSQLDb
	objectMap := make(map[string]interface{})
	if cttsdtp.Input != nil {
		objectMap["input"] = cttsdtp.Input
	}
	if cttsdtp.TaskType != "" {
		objectMap["taskType"] = cttsdtp.TaskType
	}
	return json.Marshal(objectMap)
}

// AsGetTdeCertificatesSQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) AsGetTdeCertificatesSQLTaskProperties() (*GetTdeCertificatesSQLTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) AsValidateMigrationInputSQLServerSQLMISyncTaskProperties() (*ValidateMigrationInputSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) AsValidateMigrationInputSQLServerSQLMITaskProperties() (*ValidateMigrationInputSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties() (*ValidateMigrationInputSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) AsMigrateMySQLAzureDbForMySQLSyncTaskProperties() (*MigrateMySQLAzureDbForMySQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) AsMigrateSQLServerSQLDbSyncTaskProperties() (*MigrateSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) AsMigrateSQLServerSQLDbTaskProperties() (*MigrateSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) AsMigrateSQLServerSQLMISyncTaskProperties() (*MigrateSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) AsMigrateSQLServerSQLMITaskProperties() (*MigrateSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForMySQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) AsConnectToTargetAzureDbForMySQLTaskProperties() (*ConnectToTargetAzureDbForMySQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) AsConnectToTargetSQLMISyncTaskProperties() (*ConnectToTargetSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMITaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) AsConnectToTargetSQLMITaskProperties() (*ConnectToTargetSQLMITaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) AsGetUserTablesSQLSyncTaskProperties() (*GetUserTablesSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) AsGetUserTablesSQLTaskProperties() (*GetUserTablesSQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) AsConnectToTargetSQLSQLDbSyncTaskProperties() (*ConnectToTargetSQLSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) AsConnectToTargetSQLDbTaskProperties() (*ConnectToTargetSQLDbTaskProperties, bool) {
	return &cttsdtp, true
}

// AsConnectToSourcePostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) AsConnectToSourcePostgreSQLSyncTaskProperties() (*ConnectToSourcePostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) AsConnectToSourceSQLServerSyncTaskProperties() (*ConnectToSourceSQLServerSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) AsConnectToSourceSQLServerTaskProperties() (*ConnectToSourceSQLServerTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceMySQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) AsConnectToSourceMySQLTaskProperties() (*ConnectToSourceMySQLTaskProperties, bool) {
	return nil, false
}

// AsProjectTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) AsProjectTaskProperties() (*ProjectTaskProperties, bool) {
	return nil, false
}

// AsBasicProjectTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLDbTaskProperties.
func (cttsdtp ConnectToTargetSQLDbTaskProperties) AsBasicProjectTaskProperties() (BasicProjectTaskProperties, bool) {
	return &cttsdtp, true
}

// UnmarshalJSON is the custom unmarshaler for ConnectToTargetSQLDbTaskProperties struct.
func (cttsdtp *ConnectToTargetSQLDbTaskProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "input":
			if v != nil {
				var input ConnectToTargetSQLDbTaskInput
				err = json.Unmarshal(*v, &input)
				if err != nil {
					return err
				}
				cttsdtp.Input = &input
			}
		case "output":
			if v != nil {
				var output []ConnectToTargetSQLDbTaskOutput
				err = json.Unmarshal(*v, &output)
				if err != nil {
					return err
				}
				cttsdtp.Output = &output
			}
		case "errors":
			if v != nil {
				var errorsVar []ODataError
				err = json.Unmarshal(*v, &errorsVar)
				if err != nil {
					return err
				}
				cttsdtp.Errors = &errorsVar
			}
		case "state":
			if v != nil {
				var state TaskState
				err = json.Unmarshal(*v, &state)
				if err != nil {
					return err
				}
				cttsdtp.State = state
			}
		case "commands":
			if v != nil {
				commands, err := unmarshalBasicCommandPropertiesArray(*v)
				if err != nil {
					return err
				}
				cttsdtp.Commands = &commands
			}
		case "taskType":
			if v != nil {
				var taskType TaskType
				err = json.Unmarshal(*v, &taskType)
				if err != nil {
					return err
				}
				cttsdtp.TaskType = taskType
			}
		}
	}

	return nil
}

// ConnectToTargetSQLMISyncTaskInput input for the task that validates connection to Azure SQL Database
// Managed Instance online scenario.
type ConnectToTargetSQLMISyncTaskInput struct {
	// TargetConnectionInfo - Connection information for Azure SQL Database Managed Instance
	TargetConnectionInfo *MiSQLConnectionInfo `json:"targetConnectionInfo,omitempty"`
	// AzureApp - Azure Active Directory Application the DMS instance will use to connect to the target instance of Azure SQL Database Managed Instance and the Azure Storage Account
	AzureApp *AzureActiveDirectoryApp `json:"azureApp,omitempty"`
}

// ConnectToTargetSQLMISyncTaskOutput output for the task that validates connection to Azure SQL Database
// Managed Instance.
type ConnectToTargetSQLMISyncTaskOutput struct {
	// TargetServerVersion - READ-ONLY; Target server version
	TargetServerVersion *string `json:"targetServerVersion,omitempty"`
	// TargetServerBrandVersion - READ-ONLY; Target server brand version
	TargetServerBrandVersion *string `json:"targetServerBrandVersion,omitempty"`
	// ValidationErrors - READ-ONLY; Validation errors
	ValidationErrors *[]ReportableException `json:"validationErrors,omitempty"`
}

// ConnectToTargetSQLMISyncTaskProperties properties for the task that validates connection to Azure SQL
// Database Managed Instance
type ConnectToTargetSQLMISyncTaskProperties struct {
	// Input - Task input
	Input *ConnectToTargetSQLMISyncTaskInput `json:"input,omitempty"`
	// Output - READ-ONLY; Task output. This is ignored if submitted.
	Output *[]ConnectToTargetSQLMISyncTaskOutput `json:"output,omitempty"`
	// Errors - READ-ONLY; Array of errors. This is ignored if submitted.
	Errors *[]ODataError `json:"errors,omitempty"`
	// State - READ-ONLY; The state of the task. This is ignored if submitted. Possible values include: 'TaskStateUnknown', 'TaskStateQueued', 'TaskStateRunning', 'TaskStateCanceled', 'TaskStateSucceeded', 'TaskStateFailed', 'TaskStateFailedInputValidation', 'TaskStateFaulted'
	State TaskState `json:"state,omitempty"`
	// Commands - READ-ONLY; Array of command properties.
	Commands *[]BasicCommandProperties `json:"commands,omitempty"`
	// TaskType - Possible values include: 'TaskTypeUnknown', 'TaskTypeGetTDECertificatesSQL', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMISyncLRS', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMI', 'TaskTypeValidateMigrationInputSQLServerSQLDbSync', 'TaskTypeMigratePostgreSQLAzureDbForPostgreSQLSync', 'TaskTypeMigrateMySQLAzureDbForMySQLSync', 'TaskTypeMigrateSQLServerAzureSQLDbSync', 'TaskTypeMigrateSQLServerSQLDb', 'TaskTypeMigrateSQLServerAzureSQLDbMISyncLRS', 'TaskTypeMigrateSQLServerAzureSQLDbMI', 'TaskTypeConnectToTargetAzureDbForMySQL', 'TaskTypeConnectToTargetAzureSQLDbMISyncLRS', 'TaskTypeConnectToTargetAzureSQLDbMI', 'TaskTypeGetUserTablesAzureSQLDbSync', 'TaskTypeGetUserTablesSQL', 'TaskTypeConnectToTargetAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetSQLDbSync', 'TaskTypeConnectToTargetSQLDb', 'TaskTypeConnectToSourcePostgreSQLSync', 'TaskTypeConnectToSourceSQLServerSync', 'TaskTypeConnectToSourceSQLServer', 'TaskTypeConnectToSourceMySQL'
	TaskType TaskType `json:"taskType,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectToTargetSQLMISyncTaskProperties.
func (cttsmstp ConnectToTargetSQLMISyncTaskProperties) MarshalJSON() ([]byte, error) {
	cttsmstp.TaskType = TaskTypeConnectToTargetAzureSQLDbMISyncLRS
	objectMap := make(map[string]interface{})
	if cttsmstp.Input != nil {
		objectMap["input"] = cttsmstp.Input
	}
	if cttsmstp.TaskType != "" {
		objectMap["taskType"] = cttsmstp.TaskType
	}
	return json.Marshal(objectMap)
}

// AsGetTdeCertificatesSQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMISyncTaskProperties.
func (cttsmstp ConnectToTargetSQLMISyncTaskProperties) AsGetTdeCertificatesSQLTaskProperties() (*GetTdeCertificatesSQLTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMISyncTaskProperties.
func (cttsmstp ConnectToTargetSQLMISyncTaskProperties) AsValidateMigrationInputSQLServerSQLMISyncTaskProperties() (*ValidateMigrationInputSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMISyncTaskProperties.
func (cttsmstp ConnectToTargetSQLMISyncTaskProperties) AsValidateMigrationInputSQLServerSQLMITaskProperties() (*ValidateMigrationInputSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMISyncTaskProperties.
func (cttsmstp ConnectToTargetSQLMISyncTaskProperties) AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties() (*ValidateMigrationInputSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMISyncTaskProperties.
func (cttsmstp ConnectToTargetSQLMISyncTaskProperties) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMISyncTaskProperties.
func (cttsmstp ConnectToTargetSQLMISyncTaskProperties) AsMigrateMySQLAzureDbForMySQLSyncTaskProperties() (*MigrateMySQLAzureDbForMySQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMISyncTaskProperties.
func (cttsmstp ConnectToTargetSQLMISyncTaskProperties) AsMigrateSQLServerSQLDbSyncTaskProperties() (*MigrateSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMISyncTaskProperties.
func (cttsmstp ConnectToTargetSQLMISyncTaskProperties) AsMigrateSQLServerSQLDbTaskProperties() (*MigrateSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMISyncTaskProperties.
func (cttsmstp ConnectToTargetSQLMISyncTaskProperties) AsMigrateSQLServerSQLMISyncTaskProperties() (*MigrateSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMISyncTaskProperties.
func (cttsmstp ConnectToTargetSQLMISyncTaskProperties) AsMigrateSQLServerSQLMITaskProperties() (*MigrateSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForMySQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMISyncTaskProperties.
func (cttsmstp ConnectToTargetSQLMISyncTaskProperties) AsConnectToTargetAzureDbForMySQLTaskProperties() (*ConnectToTargetAzureDbForMySQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMISyncTaskProperties.
func (cttsmstp ConnectToTargetSQLMISyncTaskProperties) AsConnectToTargetSQLMISyncTaskProperties() (*ConnectToTargetSQLMISyncTaskProperties, bool) {
	return &cttsmstp, true
}

// AsConnectToTargetSQLMITaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMISyncTaskProperties.
func (cttsmstp ConnectToTargetSQLMISyncTaskProperties) AsConnectToTargetSQLMITaskProperties() (*ConnectToTargetSQLMITaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMISyncTaskProperties.
func (cttsmstp ConnectToTargetSQLMISyncTaskProperties) AsGetUserTablesSQLSyncTaskProperties() (*GetUserTablesSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMISyncTaskProperties.
func (cttsmstp ConnectToTargetSQLMISyncTaskProperties) AsGetUserTablesSQLTaskProperties() (*GetUserTablesSQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMISyncTaskProperties.
func (cttsmstp ConnectToTargetSQLMISyncTaskProperties) AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMISyncTaskProperties.
func (cttsmstp ConnectToTargetSQLMISyncTaskProperties) AsConnectToTargetSQLSQLDbSyncTaskProperties() (*ConnectToTargetSQLSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMISyncTaskProperties.
func (cttsmstp ConnectToTargetSQLMISyncTaskProperties) AsConnectToTargetSQLDbTaskProperties() (*ConnectToTargetSQLDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourcePostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMISyncTaskProperties.
func (cttsmstp ConnectToTargetSQLMISyncTaskProperties) AsConnectToSourcePostgreSQLSyncTaskProperties() (*ConnectToSourcePostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMISyncTaskProperties.
func (cttsmstp ConnectToTargetSQLMISyncTaskProperties) AsConnectToSourceSQLServerSyncTaskProperties() (*ConnectToSourceSQLServerSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMISyncTaskProperties.
func (cttsmstp ConnectToTargetSQLMISyncTaskProperties) AsConnectToSourceSQLServerTaskProperties() (*ConnectToSourceSQLServerTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceMySQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMISyncTaskProperties.
func (cttsmstp ConnectToTargetSQLMISyncTaskProperties) AsConnectToSourceMySQLTaskProperties() (*ConnectToSourceMySQLTaskProperties, bool) {
	return nil, false
}

// AsProjectTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMISyncTaskProperties.
func (cttsmstp ConnectToTargetSQLMISyncTaskProperties) AsProjectTaskProperties() (*ProjectTaskProperties, bool) {
	return nil, false
}

// AsBasicProjectTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMISyncTaskProperties.
func (cttsmstp ConnectToTargetSQLMISyncTaskProperties) AsBasicProjectTaskProperties() (BasicProjectTaskProperties, bool) {
	return &cttsmstp, true
}

// UnmarshalJSON is the custom unmarshaler for ConnectToTargetSQLMISyncTaskProperties struct.
func (cttsmstp *ConnectToTargetSQLMISyncTaskProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "input":
			if v != nil {
				var input ConnectToTargetSQLMISyncTaskInput
				err = json.Unmarshal(*v, &input)
				if err != nil {
					return err
				}
				cttsmstp.Input = &input
			}
		case "output":
			if v != nil {
				var output []ConnectToTargetSQLMISyncTaskOutput
				err = json.Unmarshal(*v, &output)
				if err != nil {
					return err
				}
				cttsmstp.Output = &output
			}
		case "errors":
			if v != nil {
				var errorsVar []ODataError
				err = json.Unmarshal(*v, &errorsVar)
				if err != nil {
					return err
				}
				cttsmstp.Errors = &errorsVar
			}
		case "state":
			if v != nil {
				var state TaskState
				err = json.Unmarshal(*v, &state)
				if err != nil {
					return err
				}
				cttsmstp.State = state
			}
		case "commands":
			if v != nil {
				commands, err := unmarshalBasicCommandPropertiesArray(*v)
				if err != nil {
					return err
				}
				cttsmstp.Commands = &commands
			}
		case "taskType":
			if v != nil {
				var taskType TaskType
				err = json.Unmarshal(*v, &taskType)
				if err != nil {
					return err
				}
				cttsmstp.TaskType = taskType
			}
		}
	}

	return nil
}

// ConnectToTargetSQLMITaskInput input for the task that validates connection to Azure SQL Database Managed
// Instance.
type ConnectToTargetSQLMITaskInput struct {
	// TargetConnectionInfo - Connection information for target SQL Server
	TargetConnectionInfo *SQLConnectionInfo `json:"targetConnectionInfo,omitempty"`
}

// ConnectToTargetSQLMITaskOutput output for the task that validates connection to Azure SQL Database
// Managed Instance.
type ConnectToTargetSQLMITaskOutput struct {
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// TargetServerVersion - READ-ONLY; Target server version
	TargetServerVersion *string `json:"targetServerVersion,omitempty"`
	// TargetServerBrandVersion - READ-ONLY; Target server brand version
	TargetServerBrandVersion *string `json:"targetServerBrandVersion,omitempty"`
	// Logins - READ-ONLY; List of logins on the target server.
	Logins *[]string `json:"logins,omitempty"`
	// AgentJobs - READ-ONLY; List of agent jobs on the target server.
	AgentJobs *[]string `json:"agentJobs,omitempty"`
	// ValidationErrors - READ-ONLY; Validation errors
	ValidationErrors *[]ReportableException `json:"validationErrors,omitempty"`
}

// ConnectToTargetSQLMITaskProperties properties for the task that validates connection to Azure SQL
// Database Managed Instance
type ConnectToTargetSQLMITaskProperties struct {
	// Input - Task input
	Input *ConnectToTargetSQLMITaskInput `json:"input,omitempty"`
	// Output - READ-ONLY; Task output. This is ignored if submitted.
	Output *[]ConnectToTargetSQLMITaskOutput `json:"output,omitempty"`
	// Errors - READ-ONLY; Array of errors. This is ignored if submitted.
	Errors *[]ODataError `json:"errors,omitempty"`
	// State - READ-ONLY; The state of the task. This is ignored if submitted. Possible values include: 'TaskStateUnknown', 'TaskStateQueued', 'TaskStateRunning', 'TaskStateCanceled', 'TaskStateSucceeded', 'TaskStateFailed', 'TaskStateFailedInputValidation', 'TaskStateFaulted'
	State TaskState `json:"state,omitempty"`
	// Commands - READ-ONLY; Array of command properties.
	Commands *[]BasicCommandProperties `json:"commands,omitempty"`
	// TaskType - Possible values include: 'TaskTypeUnknown', 'TaskTypeGetTDECertificatesSQL', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMISyncLRS', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMI', 'TaskTypeValidateMigrationInputSQLServerSQLDbSync', 'TaskTypeMigratePostgreSQLAzureDbForPostgreSQLSync', 'TaskTypeMigrateMySQLAzureDbForMySQLSync', 'TaskTypeMigrateSQLServerAzureSQLDbSync', 'TaskTypeMigrateSQLServerSQLDb', 'TaskTypeMigrateSQLServerAzureSQLDbMISyncLRS', 'TaskTypeMigrateSQLServerAzureSQLDbMI', 'TaskTypeConnectToTargetAzureDbForMySQL', 'TaskTypeConnectToTargetAzureSQLDbMISyncLRS', 'TaskTypeConnectToTargetAzureSQLDbMI', 'TaskTypeGetUserTablesAzureSQLDbSync', 'TaskTypeGetUserTablesSQL', 'TaskTypeConnectToTargetAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetSQLDbSync', 'TaskTypeConnectToTargetSQLDb', 'TaskTypeConnectToSourcePostgreSQLSync', 'TaskTypeConnectToSourceSQLServerSync', 'TaskTypeConnectToSourceSQLServer', 'TaskTypeConnectToSourceMySQL'
	TaskType TaskType `json:"taskType,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectToTargetSQLMITaskProperties.
func (cttsmtp ConnectToTargetSQLMITaskProperties) MarshalJSON() ([]byte, error) {
	cttsmtp.TaskType = TaskTypeConnectToTargetAzureSQLDbMI
	objectMap := make(map[string]interface{})
	if cttsmtp.Input != nil {
		objectMap["input"] = cttsmtp.Input
	}
	if cttsmtp.TaskType != "" {
		objectMap["taskType"] = cttsmtp.TaskType
	}
	return json.Marshal(objectMap)
}

// AsGetTdeCertificatesSQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMITaskProperties.
func (cttsmtp ConnectToTargetSQLMITaskProperties) AsGetTdeCertificatesSQLTaskProperties() (*GetTdeCertificatesSQLTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMITaskProperties.
func (cttsmtp ConnectToTargetSQLMITaskProperties) AsValidateMigrationInputSQLServerSQLMISyncTaskProperties() (*ValidateMigrationInputSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMITaskProperties.
func (cttsmtp ConnectToTargetSQLMITaskProperties) AsValidateMigrationInputSQLServerSQLMITaskProperties() (*ValidateMigrationInputSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMITaskProperties.
func (cttsmtp ConnectToTargetSQLMITaskProperties) AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties() (*ValidateMigrationInputSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMITaskProperties.
func (cttsmtp ConnectToTargetSQLMITaskProperties) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMITaskProperties.
func (cttsmtp ConnectToTargetSQLMITaskProperties) AsMigrateMySQLAzureDbForMySQLSyncTaskProperties() (*MigrateMySQLAzureDbForMySQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMITaskProperties.
func (cttsmtp ConnectToTargetSQLMITaskProperties) AsMigrateSQLServerSQLDbSyncTaskProperties() (*MigrateSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMITaskProperties.
func (cttsmtp ConnectToTargetSQLMITaskProperties) AsMigrateSQLServerSQLDbTaskProperties() (*MigrateSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMITaskProperties.
func (cttsmtp ConnectToTargetSQLMITaskProperties) AsMigrateSQLServerSQLMISyncTaskProperties() (*MigrateSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMITaskProperties.
func (cttsmtp ConnectToTargetSQLMITaskProperties) AsMigrateSQLServerSQLMITaskProperties() (*MigrateSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForMySQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMITaskProperties.
func (cttsmtp ConnectToTargetSQLMITaskProperties) AsConnectToTargetAzureDbForMySQLTaskProperties() (*ConnectToTargetAzureDbForMySQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMITaskProperties.
func (cttsmtp ConnectToTargetSQLMITaskProperties) AsConnectToTargetSQLMISyncTaskProperties() (*ConnectToTargetSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMITaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMITaskProperties.
func (cttsmtp ConnectToTargetSQLMITaskProperties) AsConnectToTargetSQLMITaskProperties() (*ConnectToTargetSQLMITaskProperties, bool) {
	return &cttsmtp, true
}

// AsGetUserTablesSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMITaskProperties.
func (cttsmtp ConnectToTargetSQLMITaskProperties) AsGetUserTablesSQLSyncTaskProperties() (*GetUserTablesSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMITaskProperties.
func (cttsmtp ConnectToTargetSQLMITaskProperties) AsGetUserTablesSQLTaskProperties() (*GetUserTablesSQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMITaskProperties.
func (cttsmtp ConnectToTargetSQLMITaskProperties) AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMITaskProperties.
func (cttsmtp ConnectToTargetSQLMITaskProperties) AsConnectToTargetSQLSQLDbSyncTaskProperties() (*ConnectToTargetSQLSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMITaskProperties.
func (cttsmtp ConnectToTargetSQLMITaskProperties) AsConnectToTargetSQLDbTaskProperties() (*ConnectToTargetSQLDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourcePostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMITaskProperties.
func (cttsmtp ConnectToTargetSQLMITaskProperties) AsConnectToSourcePostgreSQLSyncTaskProperties() (*ConnectToSourcePostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMITaskProperties.
func (cttsmtp ConnectToTargetSQLMITaskProperties) AsConnectToSourceSQLServerSyncTaskProperties() (*ConnectToSourceSQLServerSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMITaskProperties.
func (cttsmtp ConnectToTargetSQLMITaskProperties) AsConnectToSourceSQLServerTaskProperties() (*ConnectToSourceSQLServerTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceMySQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMITaskProperties.
func (cttsmtp ConnectToTargetSQLMITaskProperties) AsConnectToSourceMySQLTaskProperties() (*ConnectToSourceMySQLTaskProperties, bool) {
	return nil, false
}

// AsProjectTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMITaskProperties.
func (cttsmtp ConnectToTargetSQLMITaskProperties) AsProjectTaskProperties() (*ProjectTaskProperties, bool) {
	return nil, false
}

// AsBasicProjectTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLMITaskProperties.
func (cttsmtp ConnectToTargetSQLMITaskProperties) AsBasicProjectTaskProperties() (BasicProjectTaskProperties, bool) {
	return &cttsmtp, true
}

// UnmarshalJSON is the custom unmarshaler for ConnectToTargetSQLMITaskProperties struct.
func (cttsmtp *ConnectToTargetSQLMITaskProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "input":
			if v != nil {
				var input ConnectToTargetSQLMITaskInput
				err = json.Unmarshal(*v, &input)
				if err != nil {
					return err
				}
				cttsmtp.Input = &input
			}
		case "output":
			if v != nil {
				var output []ConnectToTargetSQLMITaskOutput
				err = json.Unmarshal(*v, &output)
				if err != nil {
					return err
				}
				cttsmtp.Output = &output
			}
		case "errors":
			if v != nil {
				var errorsVar []ODataError
				err = json.Unmarshal(*v, &errorsVar)
				if err != nil {
					return err
				}
				cttsmtp.Errors = &errorsVar
			}
		case "state":
			if v != nil {
				var state TaskState
				err = json.Unmarshal(*v, &state)
				if err != nil {
					return err
				}
				cttsmtp.State = state
			}
		case "commands":
			if v != nil {
				commands, err := unmarshalBasicCommandPropertiesArray(*v)
				if err != nil {
					return err
				}
				cttsmtp.Commands = &commands
			}
		case "taskType":
			if v != nil {
				var taskType TaskType
				err = json.Unmarshal(*v, &taskType)
				if err != nil {
					return err
				}
				cttsmtp.TaskType = taskType
			}
		}
	}

	return nil
}

// ConnectToTargetSQLSQLDbSyncTaskInput input for the task that validates connection to Azure SQL DB and
// target server requirements
type ConnectToTargetSQLSQLDbSyncTaskInput struct {
	// SourceConnectionInfo - Connection information for source SQL Server
	SourceConnectionInfo *SQLConnectionInfo `json:"sourceConnectionInfo,omitempty"`
	// TargetConnectionInfo - Connection information for target SQL DB
	TargetConnectionInfo *SQLConnectionInfo `json:"targetConnectionInfo,omitempty"`
}

// ConnectToTargetSQLSQLDbSyncTaskProperties properties for the task that validates connection to SQL DB
// and target server requirements for online migration
type ConnectToTargetSQLSQLDbSyncTaskProperties struct {
	// Input - Task input
	Input *ConnectToTargetSQLSQLDbSyncTaskInput `json:"input,omitempty"`
	// Output - READ-ONLY; Task output. This is ignored if submitted.
	Output *[]ConnectToTargetSQLDbTaskOutput `json:"output,omitempty"`
	// Errors - READ-ONLY; Array of errors. This is ignored if submitted.
	Errors *[]ODataError `json:"errors,omitempty"`
	// State - READ-ONLY; The state of the task. This is ignored if submitted. Possible values include: 'TaskStateUnknown', 'TaskStateQueued', 'TaskStateRunning', 'TaskStateCanceled', 'TaskStateSucceeded', 'TaskStateFailed', 'TaskStateFailedInputValidation', 'TaskStateFaulted'
	State TaskState `json:"state,omitempty"`
	// Commands - READ-ONLY; Array of command properties.
	Commands *[]BasicCommandProperties `json:"commands,omitempty"`
	// TaskType - Possible values include: 'TaskTypeUnknown', 'TaskTypeGetTDECertificatesSQL', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMISyncLRS', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMI', 'TaskTypeValidateMigrationInputSQLServerSQLDbSync', 'TaskTypeMigratePostgreSQLAzureDbForPostgreSQLSync', 'TaskTypeMigrateMySQLAzureDbForMySQLSync', 'TaskTypeMigrateSQLServerAzureSQLDbSync', 'TaskTypeMigrateSQLServerSQLDb', 'TaskTypeMigrateSQLServerAzureSQLDbMISyncLRS', 'TaskTypeMigrateSQLServerAzureSQLDbMI', 'TaskTypeConnectToTargetAzureDbForMySQL', 'TaskTypeConnectToTargetAzureSQLDbMISyncLRS', 'TaskTypeConnectToTargetAzureSQLDbMI', 'TaskTypeGetUserTablesAzureSQLDbSync', 'TaskTypeGetUserTablesSQL', 'TaskTypeConnectToTargetAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetSQLDbSync', 'TaskTypeConnectToTargetSQLDb', 'TaskTypeConnectToSourcePostgreSQLSync', 'TaskTypeConnectToSourceSQLServerSync', 'TaskTypeConnectToSourceSQLServer', 'TaskTypeConnectToSourceMySQL'
	TaskType TaskType `json:"taskType,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectToTargetSQLSQLDbSyncTaskProperties.
func (cttssdstp ConnectToTargetSQLSQLDbSyncTaskProperties) MarshalJSON() ([]byte, error) {
	cttssdstp.TaskType = TaskTypeConnectToTargetSQLDbSync
	objectMap := make(map[string]interface{})
	if cttssdstp.Input != nil {
		objectMap["input"] = cttssdstp.Input
	}
	if cttssdstp.TaskType != "" {
		objectMap["taskType"] = cttssdstp.TaskType
	}
	return json.Marshal(objectMap)
}

// AsGetTdeCertificatesSQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLSQLDbSyncTaskProperties.
func (cttssdstp ConnectToTargetSQLSQLDbSyncTaskProperties) AsGetTdeCertificatesSQLTaskProperties() (*GetTdeCertificatesSQLTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLSQLDbSyncTaskProperties.
func (cttssdstp ConnectToTargetSQLSQLDbSyncTaskProperties) AsValidateMigrationInputSQLServerSQLMISyncTaskProperties() (*ValidateMigrationInputSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLSQLDbSyncTaskProperties.
func (cttssdstp ConnectToTargetSQLSQLDbSyncTaskProperties) AsValidateMigrationInputSQLServerSQLMITaskProperties() (*ValidateMigrationInputSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLSQLDbSyncTaskProperties.
func (cttssdstp ConnectToTargetSQLSQLDbSyncTaskProperties) AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties() (*ValidateMigrationInputSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLSQLDbSyncTaskProperties.
func (cttssdstp ConnectToTargetSQLSQLDbSyncTaskProperties) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLSQLDbSyncTaskProperties.
func (cttssdstp ConnectToTargetSQLSQLDbSyncTaskProperties) AsMigrateMySQLAzureDbForMySQLSyncTaskProperties() (*MigrateMySQLAzureDbForMySQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLSQLDbSyncTaskProperties.
func (cttssdstp ConnectToTargetSQLSQLDbSyncTaskProperties) AsMigrateSQLServerSQLDbSyncTaskProperties() (*MigrateSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLSQLDbSyncTaskProperties.
func (cttssdstp ConnectToTargetSQLSQLDbSyncTaskProperties) AsMigrateSQLServerSQLDbTaskProperties() (*MigrateSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLSQLDbSyncTaskProperties.
func (cttssdstp ConnectToTargetSQLSQLDbSyncTaskProperties) AsMigrateSQLServerSQLMISyncTaskProperties() (*MigrateSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLSQLDbSyncTaskProperties.
func (cttssdstp ConnectToTargetSQLSQLDbSyncTaskProperties) AsMigrateSQLServerSQLMITaskProperties() (*MigrateSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForMySQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLSQLDbSyncTaskProperties.
func (cttssdstp ConnectToTargetSQLSQLDbSyncTaskProperties) AsConnectToTargetAzureDbForMySQLTaskProperties() (*ConnectToTargetAzureDbForMySQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLSQLDbSyncTaskProperties.
func (cttssdstp ConnectToTargetSQLSQLDbSyncTaskProperties) AsConnectToTargetSQLMISyncTaskProperties() (*ConnectToTargetSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMITaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLSQLDbSyncTaskProperties.
func (cttssdstp ConnectToTargetSQLSQLDbSyncTaskProperties) AsConnectToTargetSQLMITaskProperties() (*ConnectToTargetSQLMITaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLSQLDbSyncTaskProperties.
func (cttssdstp ConnectToTargetSQLSQLDbSyncTaskProperties) AsGetUserTablesSQLSyncTaskProperties() (*GetUserTablesSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLSQLDbSyncTaskProperties.
func (cttssdstp ConnectToTargetSQLSQLDbSyncTaskProperties) AsGetUserTablesSQLTaskProperties() (*GetUserTablesSQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLSQLDbSyncTaskProperties.
func (cttssdstp ConnectToTargetSQLSQLDbSyncTaskProperties) AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLSQLDbSyncTaskProperties.
func (cttssdstp ConnectToTargetSQLSQLDbSyncTaskProperties) AsConnectToTargetSQLSQLDbSyncTaskProperties() (*ConnectToTargetSQLSQLDbSyncTaskProperties, bool) {
	return &cttssdstp, true
}

// AsConnectToTargetSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLSQLDbSyncTaskProperties.
func (cttssdstp ConnectToTargetSQLSQLDbSyncTaskProperties) AsConnectToTargetSQLDbTaskProperties() (*ConnectToTargetSQLDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourcePostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLSQLDbSyncTaskProperties.
func (cttssdstp ConnectToTargetSQLSQLDbSyncTaskProperties) AsConnectToSourcePostgreSQLSyncTaskProperties() (*ConnectToSourcePostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerSyncTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLSQLDbSyncTaskProperties.
func (cttssdstp ConnectToTargetSQLSQLDbSyncTaskProperties) AsConnectToSourceSQLServerSyncTaskProperties() (*ConnectToSourceSQLServerSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLSQLDbSyncTaskProperties.
func (cttssdstp ConnectToTargetSQLSQLDbSyncTaskProperties) AsConnectToSourceSQLServerTaskProperties() (*ConnectToSourceSQLServerTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceMySQLTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLSQLDbSyncTaskProperties.
func (cttssdstp ConnectToTargetSQLSQLDbSyncTaskProperties) AsConnectToSourceMySQLTaskProperties() (*ConnectToSourceMySQLTaskProperties, bool) {
	return nil, false
}

// AsProjectTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLSQLDbSyncTaskProperties.
func (cttssdstp ConnectToTargetSQLSQLDbSyncTaskProperties) AsProjectTaskProperties() (*ProjectTaskProperties, bool) {
	return nil, false
}

// AsBasicProjectTaskProperties is the BasicProjectTaskProperties implementation for ConnectToTargetSQLSQLDbSyncTaskProperties.
func (cttssdstp ConnectToTargetSQLSQLDbSyncTaskProperties) AsBasicProjectTaskProperties() (BasicProjectTaskProperties, bool) {
	return &cttssdstp, true
}

// UnmarshalJSON is the custom unmarshaler for ConnectToTargetSQLSQLDbSyncTaskProperties struct.
func (cttssdstp *ConnectToTargetSQLSQLDbSyncTaskProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "input":
			if v != nil {
				var input ConnectToTargetSQLSQLDbSyncTaskInput
				err = json.Unmarshal(*v, &input)
				if err != nil {
					return err
				}
				cttssdstp.Input = &input
			}
		case "output":
			if v != nil {
				var output []ConnectToTargetSQLDbTaskOutput
				err = json.Unmarshal(*v, &output)
				if err != nil {
					return err
				}
				cttssdstp.Output = &output
			}
		case "errors":
			if v != nil {
				var errorsVar []ODataError
				err = json.Unmarshal(*v, &errorsVar)
				if err != nil {
					return err
				}
				cttssdstp.Errors = &errorsVar
			}
		case "state":
			if v != nil {
				var state TaskState
				err = json.Unmarshal(*v, &state)
				if err != nil {
					return err
				}
				cttssdstp.State = state
			}
		case "commands":
			if v != nil {
				commands, err := unmarshalBasicCommandPropertiesArray(*v)
				if err != nil {
					return err
				}
				cttssdstp.Commands = &commands
			}
		case "taskType":
			if v != nil {
				var taskType TaskType
				err = json.Unmarshal(*v, &taskType)
				if err != nil {
					return err
				}
				cttssdstp.TaskType = taskType
			}
		}
	}

	return nil
}

// Database information about a single database
type Database struct {
	// ID - READ-ONLY; Unique identifier for the database
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Name of the database
	Name *string `json:"name,omitempty"`
	// CompatibilityLevel - READ-ONLY; SQL Server compatibility level of database. Possible values include: 'CompatLevel80', 'CompatLevel90', 'CompatLevel100', 'CompatLevel110', 'CompatLevel120', 'CompatLevel130', 'CompatLevel140'
	CompatibilityLevel DatabaseCompatLevel `json:"compatibilityLevel,omitempty"`
	// Collation - READ-ONLY; Collation name of the database
	Collation *string `json:"collation,omitempty"`
	// ServerName - READ-ONLY; Name of the server
	ServerName *string `json:"serverName,omitempty"`
	// Fqdn - READ-ONLY; Fully qualified name
	Fqdn *string `json:"fqdn,omitempty"`
	// InstallID - READ-ONLY; Install id of the database
	InstallID *string `json:"installId,omitempty"`
	// ServerVersion - READ-ONLY; Version of the server
	ServerVersion *string `json:"serverVersion,omitempty"`
	// ServerEdition - READ-ONLY; Edition of the server
	ServerEdition *string `json:"serverEdition,omitempty"`
	// ServerLevel - READ-ONLY; Product level of the server (RTM, SP, CTP).
	ServerLevel *string `json:"serverLevel,omitempty"`
	// ServerDefaultDataPath - READ-ONLY; Default path of the data files
	ServerDefaultDataPath *string `json:"serverDefaultDataPath,omitempty"`
	// ServerDefaultLogPath - READ-ONLY; Default path of the log files
	ServerDefaultLogPath *string `json:"serverDefaultLogPath,omitempty"`
	// ServerDefaultBackupPath - READ-ONLY; Default path of the backup folder
	ServerDefaultBackupPath *string `json:"serverDefaultBackupPath,omitempty"`
	// ServerCoreCount - READ-ONLY; Number of cores on the server
	ServerCoreCount *int32 `json:"serverCoreCount,omitempty"`
	// ServerVisibleOnlineCoreCount - READ-ONLY; Number of cores on the server that have VISIBLE ONLINE status
	ServerVisibleOnlineCoreCount *int32 `json:"serverVisibleOnlineCoreCount,omitempty"`
	// DatabaseState - READ-ONLY; State of the database. Possible values include: 'DatabaseStateOnline', 'DatabaseStateRestoring', 'DatabaseStateRecovering', 'DatabaseStateRecoveryPending', 'DatabaseStateSuspect', 'DatabaseStateEmergency', 'DatabaseStateOffline', 'DatabaseStateCopying', 'DatabaseStateOfflineSecondary'
	DatabaseState DatabaseState `json:"databaseState,omitempty"`
	// ServerID - READ-ONLY; The unique Server Id
	ServerID *string `json:"serverId,omitempty"`
}

// DatabaseBackupInfo information about backup files when existing backup mode is used.
type DatabaseBackupInfo struct {
	// DatabaseName - READ-ONLY; Database name.
	DatabaseName *string `json:"databaseName,omitempty"`
	// BackupType - READ-ONLY; Backup Type. Possible values include: 'BackupTypeDatabase', 'BackupTypeTransactionLog', 'BackupTypeFile', 'BackupTypeDifferentialDatabase', 'BackupTypeDifferentialFile', 'BackupTypePartial', 'BackupTypeDifferentialPartial'
	BackupType BackupType `json:"backupType,omitempty"`
	// BackupFiles - READ-ONLY; The list of backup files for the current database.
	BackupFiles *[]string `json:"backupFiles,omitempty"`
	// Position - READ-ONLY; Position of current database backup in the file.
	Position *int32 `json:"position,omitempty"`
	// IsDamaged - READ-ONLY; Database was damaged when backed up, but the backup operation was requested to continue despite errors.
	IsDamaged *bool `json:"isDamaged,omitempty"`
	// IsCompressed - READ-ONLY; Whether the backup set is compressed
	IsCompressed *bool `json:"isCompressed,omitempty"`
	// FamilyCount - READ-ONLY; Number of files in the backup set.
	FamilyCount *int32 `json:"familyCount,omitempty"`
	// BackupFinishDate - READ-ONLY; Date and time when the backup operation finished.
	BackupFinishDate *date.Time `json:"backupFinishDate,omitempty"`
}

// DatabaseFileInfo database file specific information
type DatabaseFileInfo struct {
	// DatabaseName - Name of the database
	DatabaseName *string `json:"databaseName,omitempty"`
	// ID - Unique identifier for database file
	ID *string `json:"id,omitempty"`
	// LogicalName - Logical name of the file
	LogicalName *string `json:"logicalName,omitempty"`
	// PhysicalFullName - Operating-system full path of the file
	PhysicalFullName *string `json:"physicalFullName,omitempty"`
	// RestoreFullName - Suggested full path of the file for restoring
	RestoreFullName *string `json:"restoreFullName,omitempty"`
	// FileType - Database file type. Possible values include: 'Rows', 'Log', 'Filestream', 'NotSupported', 'Fulltext'
	FileType DatabaseFileType `json:"fileType,omitempty"`
	// SizeMB - Size of the file in megabytes
	SizeMB *float64 `json:"sizeMB,omitempty"`
}

// DatabaseFileInput database file specific information for input
type DatabaseFileInput struct {
	// ID - Unique identifier for database file
	ID *string `json:"id,omitempty"`
	// LogicalName - Logical name of the file
	LogicalName *string `json:"logicalName,omitempty"`
	// PhysicalFullName - Operating-system full path of the file
	PhysicalFullName *string `json:"physicalFullName,omitempty"`
	// RestoreFullName - Suggested full path of the file for restoring
	RestoreFullName *string `json:"restoreFullName,omitempty"`
	// FileType - Database file type. Possible values include: 'Rows', 'Log', 'Filestream', 'NotSupported', 'Fulltext'
	FileType DatabaseFileType `json:"fileType,omitempty"`
}

// DatabaseInfo project Database Details
type DatabaseInfo struct {
	// SourceDatabaseName - Name of the database
	SourceDatabaseName *string `json:"sourceDatabaseName,omitempty"`
}

// DatabaseObjectName a representation of the name of an object in a database
type DatabaseObjectName struct {
	// DatabaseName - READ-ONLY; The unescaped name of the database containing the object
	DatabaseName *string `json:"databaseName,omitempty"`
	// ObjectName - READ-ONLY; The unescaped name of the object
	ObjectName *string `json:"objectName,omitempty"`
	// SchemaName - READ-ONLY; The unescaped name of the schema containing the object
	SchemaName *string `json:"schemaName,omitempty"`
	// ObjectType - Type of the object in the database. Possible values include: 'StoredProcedures', 'Table', 'User', 'View', 'Function'
	ObjectType ObjectType `json:"objectType,omitempty"`
}

// DatabaseSummaryResult summary of database results in the migration
type DatabaseSummaryResult struct {
	// SizeMB - READ-ONLY; Size of the database in megabytes
	SizeMB *float64 `json:"sizeMB,omitempty"`
	// Name - READ-ONLY; Name of the item
	Name *string `json:"name,omitempty"`
	// StartedOn - READ-ONLY; Migration start time
	StartedOn *date.Time `json:"startedOn,omitempty"`
	// EndedOn - READ-ONLY; Migration end time
	EndedOn *date.Time `json:"endedOn,omitempty"`
	// State - READ-ONLY; Current state of migration. Possible values include: 'MigrationStateNone', 'MigrationStateInProgress', 'MigrationStateFailed', 'MigrationStateWarning', 'MigrationStateCompleted', 'MigrationStateSkipped', 'MigrationStateStopped'
	State MigrationState `json:"state,omitempty"`
	// StatusMessage - READ-ONLY; Status message
	StatusMessage *string `json:"statusMessage,omitempty"`
	// ItemsCount - READ-ONLY; Number of items
	ItemsCount *int64 `json:"itemsCount,omitempty"`
	// ItemsCompletedCount - READ-ONLY; Number of successfully completed items
	ItemsCompletedCount *int64 `json:"itemsCompletedCount,omitempty"`
	// ErrorPrefix - READ-ONLY; Wildcard string prefix to use for querying all errors of the item
	ErrorPrefix *string `json:"errorPrefix,omitempty"`
	// ResultPrefix - READ-ONLY; Wildcard string prefix to use for querying all sub-tem results of the item
	ResultPrefix *string `json:"resultPrefix,omitempty"`
}

// DatabaseTable table properties
type DatabaseTable struct {
	// HasRows - READ-ONLY; Indicates whether table is empty or not
	HasRows *bool `json:"hasRows,omitempty"`
	// Name - READ-ONLY; Schema-qualified name of the table
	Name *string `json:"name,omitempty"`
}

// DataIntegrityValidationResult results for checksum based Data Integrity validation results
type DataIntegrityValidationResult struct {
	// FailedObjects - READ-ONLY; List of failed table names of source and target pair
	FailedObjects map[string]*string `json:"failedObjects"`
	// ValidationErrors - READ-ONLY; List of errors that happened while performing data integrity validation
	ValidationErrors *ValidationError `json:"validationErrors,omitempty"`
}

// MarshalJSON is the custom marshaler for DataIntegrityValidationResult.
func (divr DataIntegrityValidationResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// DataItemMigrationSummaryResult basic summary of a data item migration
type DataItemMigrationSummaryResult struct {
	// Name - READ-ONLY; Name of the item
	Name *string `json:"name,omitempty"`
	// StartedOn - READ-ONLY; Migration start time
	StartedOn *date.Time `json:"startedOn,omitempty"`
	// EndedOn - READ-ONLY; Migration end time
	EndedOn *date.Time `json:"endedOn,omitempty"`
	// State - READ-ONLY; Current state of migration. Possible values include: 'MigrationStateNone', 'MigrationStateInProgress', 'MigrationStateFailed', 'MigrationStateWarning', 'MigrationStateCompleted', 'MigrationStateSkipped', 'MigrationStateStopped'
	State MigrationState `json:"state,omitempty"`
	// StatusMessage - READ-ONLY; Status message
	StatusMessage *string `json:"statusMessage,omitempty"`
	// ItemsCount - READ-ONLY; Number of items
	ItemsCount *int64 `json:"itemsCount,omitempty"`
	// ItemsCompletedCount - READ-ONLY; Number of successfully completed items
	ItemsCompletedCount *int64 `json:"itemsCompletedCount,omitempty"`
	// ErrorPrefix - READ-ONLY; Wildcard string prefix to use for querying all errors of the item
	ErrorPrefix *string `json:"errorPrefix,omitempty"`
	// ResultPrefix - READ-ONLY; Wildcard string prefix to use for querying all sub-tem results of the item
	ResultPrefix *string `json:"resultPrefix,omitempty"`
}

// Error migration Task errors
type Error struct {
	// Message - READ-ONLY; Error description
	Message *string `json:"message,omitempty"`
	// Type - Type of error. Possible values include: 'ErrorTypeDefault', 'ErrorTypeWarning', 'ErrorTypeError'
	Type ErrorType `json:"type,omitempty"`
}

// ExecutionStatistics description about the errors happen while performing migration validation
type ExecutionStatistics struct {
	// ExecutionCount - READ-ONLY; No. of query executions
	ExecutionCount *int64 `json:"executionCount,omitempty"`
	// CPUTimeMs - READ-ONLY; CPU Time in millisecond(s) for the query execution
	CPUTimeMs *float64 `json:"cpuTimeMs,omitempty"`
	// ElapsedTimeMs - READ-ONLY; Time taken in millisecond(s) for executing the query
	ElapsedTimeMs *float64 `json:"elapsedTimeMs,omitempty"`
	// WaitStats - Dictionary of sql query execution wait types and the respective statistics
	WaitStats map[string]*WaitStatistics `json:"waitStats"`
	// HasErrors - READ-ONLY; Indicates whether the query resulted in an error
	HasErrors *bool `json:"hasErrors,omitempty"`
	// SQLErrors - READ-ONLY; List of sql Errors
	SQLErrors *[]string `json:"sqlErrors,omitempty"`
}

// MarshalJSON is the custom marshaler for ExecutionStatistics.
func (es ExecutionStatistics) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if es.WaitStats != nil {
		objectMap["waitStats"] = es.WaitStats
	}
	return json.Marshal(objectMap)
}

// FileShare file share information with Path, Username, and Password.
type FileShare struct {
	// UserName - User name credential to connect to the share location
	UserName *string `json:"userName,omitempty"`
	// Password - Password credential used to connect to the share location.
	Password *string `json:"password,omitempty"`
	// Path - The folder path for this share.
	Path *string `json:"path,omitempty"`
}

// GetProjectDetailsNonSQLTaskInput input for the task that reads configuration from project artifacts
type GetProjectDetailsNonSQLTaskInput struct {
	// ProjectName - Name of the migration project
	ProjectName *string `json:"projectName,omitempty"`
	// ProjectLocation - A URL that points to the location to access project artifacts
	ProjectLocation *string `json:"projectLocation,omitempty"`
}

// GetTdeCertificatesSQLTaskInput input for the task that gets TDE certificates in Base64 encoded format.
type GetTdeCertificatesSQLTaskInput struct {
	// ConnectionInfo - Connection information for SQL Server
	ConnectionInfo *SQLConnectionInfo `json:"connectionInfo,omitempty"`
	// BackupFileShare - Backup file share information for file share to be used for temporarily storing files.
	BackupFileShare *FileShare `json:"backupFileShare,omitempty"`
	// SelectedCertificates - List containing certificate names and corresponding password to use for encrypting the exported certificate.
	SelectedCertificates *[]SelectedCertificateInput `json:"selectedCertificates,omitempty"`
}

// GetTdeCertificatesSQLTaskOutput output of the task that gets TDE certificates in Base64 encoded format.
type GetTdeCertificatesSQLTaskOutput struct {
	// Base64EncodedCertificates - READ-ONLY; Mapping from certificate name to base 64 encoded format.
	Base64EncodedCertificates map[string][]string `json:"base64EncodedCertificates"`
	// ValidationErrors - READ-ONLY; Validation errors
	ValidationErrors *[]ReportableException `json:"validationErrors,omitempty"`
}

// MarshalJSON is the custom marshaler for GetTdeCertificatesSQLTaskOutput.
func (gtcsto GetTdeCertificatesSQLTaskOutput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// GetTdeCertificatesSQLTaskProperties properties for the task that gets TDE certificates in Base64 encoded
// format.
type GetTdeCertificatesSQLTaskProperties struct {
	// Input - Task input
	Input *GetTdeCertificatesSQLTaskInput `json:"input,omitempty"`
	// Output - READ-ONLY; Task output. This is ignored if submitted.
	Output *[]GetTdeCertificatesSQLTaskOutput `json:"output,omitempty"`
	// Errors - READ-ONLY; Array of errors. This is ignored if submitted.
	Errors *[]ODataError `json:"errors,omitempty"`
	// State - READ-ONLY; The state of the task. This is ignored if submitted. Possible values include: 'TaskStateUnknown', 'TaskStateQueued', 'TaskStateRunning', 'TaskStateCanceled', 'TaskStateSucceeded', 'TaskStateFailed', 'TaskStateFailedInputValidation', 'TaskStateFaulted'
	State TaskState `json:"state,omitempty"`
	// Commands - READ-ONLY; Array of command properties.
	Commands *[]BasicCommandProperties `json:"commands,omitempty"`
	// TaskType - Possible values include: 'TaskTypeUnknown', 'TaskTypeGetTDECertificatesSQL', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMISyncLRS', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMI', 'TaskTypeValidateMigrationInputSQLServerSQLDbSync', 'TaskTypeMigratePostgreSQLAzureDbForPostgreSQLSync', 'TaskTypeMigrateMySQLAzureDbForMySQLSync', 'TaskTypeMigrateSQLServerAzureSQLDbSync', 'TaskTypeMigrateSQLServerSQLDb', 'TaskTypeMigrateSQLServerAzureSQLDbMISyncLRS', 'TaskTypeMigrateSQLServerAzureSQLDbMI', 'TaskTypeConnectToTargetAzureDbForMySQL', 'TaskTypeConnectToTargetAzureSQLDbMISyncLRS', 'TaskTypeConnectToTargetAzureSQLDbMI', 'TaskTypeGetUserTablesAzureSQLDbSync', 'TaskTypeGetUserTablesSQL', 'TaskTypeConnectToTargetAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetSQLDbSync', 'TaskTypeConnectToTargetSQLDb', 'TaskTypeConnectToSourcePostgreSQLSync', 'TaskTypeConnectToSourceSQLServerSync', 'TaskTypeConnectToSourceSQLServer', 'TaskTypeConnectToSourceMySQL'
	TaskType TaskType `json:"taskType,omitempty"`
}

// MarshalJSON is the custom marshaler for GetTdeCertificatesSQLTaskProperties.
func (gtcstp GetTdeCertificatesSQLTaskProperties) MarshalJSON() ([]byte, error) {
	gtcstp.TaskType = TaskTypeGetTDECertificatesSQL
	objectMap := make(map[string]interface{})
	if gtcstp.Input != nil {
		objectMap["input"] = gtcstp.Input
	}
	if gtcstp.TaskType != "" {
		objectMap["taskType"] = gtcstp.TaskType
	}
	return json.Marshal(objectMap)
}

// AsGetTdeCertificatesSQLTaskProperties is the BasicProjectTaskProperties implementation for GetTdeCertificatesSQLTaskProperties.
func (gtcstp GetTdeCertificatesSQLTaskProperties) AsGetTdeCertificatesSQLTaskProperties() (*GetTdeCertificatesSQLTaskProperties, bool) {
	return &gtcstp, true
}

// AsValidateMigrationInputSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for GetTdeCertificatesSQLTaskProperties.
func (gtcstp GetTdeCertificatesSQLTaskProperties) AsValidateMigrationInputSQLServerSQLMISyncTaskProperties() (*ValidateMigrationInputSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for GetTdeCertificatesSQLTaskProperties.
func (gtcstp GetTdeCertificatesSQLTaskProperties) AsValidateMigrationInputSQLServerSQLMITaskProperties() (*ValidateMigrationInputSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for GetTdeCertificatesSQLTaskProperties.
func (gtcstp GetTdeCertificatesSQLTaskProperties) AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties() (*ValidateMigrationInputSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for GetTdeCertificatesSQLTaskProperties.
func (gtcstp GetTdeCertificatesSQLTaskProperties) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskProperties is the BasicProjectTaskProperties implementation for GetTdeCertificatesSQLTaskProperties.
func (gtcstp GetTdeCertificatesSQLTaskProperties) AsMigrateMySQLAzureDbForMySQLSyncTaskProperties() (*MigrateMySQLAzureDbForMySQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for GetTdeCertificatesSQLTaskProperties.
func (gtcstp GetTdeCertificatesSQLTaskProperties) AsMigrateSQLServerSQLDbSyncTaskProperties() (*MigrateSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for GetTdeCertificatesSQLTaskProperties.
func (gtcstp GetTdeCertificatesSQLTaskProperties) AsMigrateSQLServerSQLDbTaskProperties() (*MigrateSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for GetTdeCertificatesSQLTaskProperties.
func (gtcstp GetTdeCertificatesSQLTaskProperties) AsMigrateSQLServerSQLMISyncTaskProperties() (*MigrateSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for GetTdeCertificatesSQLTaskProperties.
func (gtcstp GetTdeCertificatesSQLTaskProperties) AsMigrateSQLServerSQLMITaskProperties() (*MigrateSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForMySQLTaskProperties is the BasicProjectTaskProperties implementation for GetTdeCertificatesSQLTaskProperties.
func (gtcstp GetTdeCertificatesSQLTaskProperties) AsConnectToTargetAzureDbForMySQLTaskProperties() (*ConnectToTargetAzureDbForMySQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for GetTdeCertificatesSQLTaskProperties.
func (gtcstp GetTdeCertificatesSQLTaskProperties) AsConnectToTargetSQLMISyncTaskProperties() (*ConnectToTargetSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMITaskProperties is the BasicProjectTaskProperties implementation for GetTdeCertificatesSQLTaskProperties.
func (gtcstp GetTdeCertificatesSQLTaskProperties) AsConnectToTargetSQLMITaskProperties() (*ConnectToTargetSQLMITaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for GetTdeCertificatesSQLTaskProperties.
func (gtcstp GetTdeCertificatesSQLTaskProperties) AsGetUserTablesSQLSyncTaskProperties() (*GetUserTablesSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLTaskProperties is the BasicProjectTaskProperties implementation for GetTdeCertificatesSQLTaskProperties.
func (gtcstp GetTdeCertificatesSQLTaskProperties) AsGetUserTablesSQLTaskProperties() (*GetUserTablesSQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for GetTdeCertificatesSQLTaskProperties.
func (gtcstp GetTdeCertificatesSQLTaskProperties) AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for GetTdeCertificatesSQLTaskProperties.
func (gtcstp GetTdeCertificatesSQLTaskProperties) AsConnectToTargetSQLSQLDbSyncTaskProperties() (*ConnectToTargetSQLSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLDbTaskProperties is the BasicProjectTaskProperties implementation for GetTdeCertificatesSQLTaskProperties.
func (gtcstp GetTdeCertificatesSQLTaskProperties) AsConnectToTargetSQLDbTaskProperties() (*ConnectToTargetSQLDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourcePostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for GetTdeCertificatesSQLTaskProperties.
func (gtcstp GetTdeCertificatesSQLTaskProperties) AsConnectToSourcePostgreSQLSyncTaskProperties() (*ConnectToSourcePostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerSyncTaskProperties is the BasicProjectTaskProperties implementation for GetTdeCertificatesSQLTaskProperties.
func (gtcstp GetTdeCertificatesSQLTaskProperties) AsConnectToSourceSQLServerSyncTaskProperties() (*ConnectToSourceSQLServerSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskProperties is the BasicProjectTaskProperties implementation for GetTdeCertificatesSQLTaskProperties.
func (gtcstp GetTdeCertificatesSQLTaskProperties) AsConnectToSourceSQLServerTaskProperties() (*ConnectToSourceSQLServerTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceMySQLTaskProperties is the BasicProjectTaskProperties implementation for GetTdeCertificatesSQLTaskProperties.
func (gtcstp GetTdeCertificatesSQLTaskProperties) AsConnectToSourceMySQLTaskProperties() (*ConnectToSourceMySQLTaskProperties, bool) {
	return nil, false
}

// AsProjectTaskProperties is the BasicProjectTaskProperties implementation for GetTdeCertificatesSQLTaskProperties.
func (gtcstp GetTdeCertificatesSQLTaskProperties) AsProjectTaskProperties() (*ProjectTaskProperties, bool) {
	return nil, false
}

// AsBasicProjectTaskProperties is the BasicProjectTaskProperties implementation for GetTdeCertificatesSQLTaskProperties.
func (gtcstp GetTdeCertificatesSQLTaskProperties) AsBasicProjectTaskProperties() (BasicProjectTaskProperties, bool) {
	return &gtcstp, true
}

// UnmarshalJSON is the custom unmarshaler for GetTdeCertificatesSQLTaskProperties struct.
func (gtcstp *GetTdeCertificatesSQLTaskProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "input":
			if v != nil {
				var input GetTdeCertificatesSQLTaskInput
				err = json.Unmarshal(*v, &input)
				if err != nil {
					return err
				}
				gtcstp.Input = &input
			}
		case "output":
			if v != nil {
				var output []GetTdeCertificatesSQLTaskOutput
				err = json.Unmarshal(*v, &output)
				if err != nil {
					return err
				}
				gtcstp.Output = &output
			}
		case "errors":
			if v != nil {
				var errorsVar []ODataError
				err = json.Unmarshal(*v, &errorsVar)
				if err != nil {
					return err
				}
				gtcstp.Errors = &errorsVar
			}
		case "state":
			if v != nil {
				var state TaskState
				err = json.Unmarshal(*v, &state)
				if err != nil {
					return err
				}
				gtcstp.State = state
			}
		case "commands":
			if v != nil {
				commands, err := unmarshalBasicCommandPropertiesArray(*v)
				if err != nil {
					return err
				}
				gtcstp.Commands = &commands
			}
		case "taskType":
			if v != nil {
				var taskType TaskType
				err = json.Unmarshal(*v, &taskType)
				if err != nil {
					return err
				}
				gtcstp.TaskType = taskType
			}
		}
	}

	return nil
}

// GetUserTablesSQLSyncTaskInput input for the task that collects user tables for the given list of
// databases
type GetUserTablesSQLSyncTaskInput struct {
	// SourceConnectionInfo - Connection information for SQL Server
	SourceConnectionInfo *SQLConnectionInfo `json:"sourceConnectionInfo,omitempty"`
	// TargetConnectionInfo - Connection information for SQL DB
	TargetConnectionInfo *SQLConnectionInfo `json:"targetConnectionInfo,omitempty"`
	// SelectedSourceDatabases - List of source database names to collect tables for
	SelectedSourceDatabases *[]string `json:"selectedSourceDatabases,omitempty"`
	// SelectedTargetDatabases - List of target database names to collect tables for
	SelectedTargetDatabases *[]string `json:"selectedTargetDatabases,omitempty"`
}

// GetUserTablesSQLSyncTaskOutput output of the task that collects user tables for the given list of
// databases
type GetUserTablesSQLSyncTaskOutput struct {
	// DatabasesToSourceTables - READ-ONLY; Mapping from database name to list of source tables
	DatabasesToSourceTables map[string][]DatabaseTable `json:"databasesToSourceTables"`
	// DatabasesToTargetTables - READ-ONLY; Mapping from database name to list of target tables
	DatabasesToTargetTables map[string][]DatabaseTable `json:"databasesToTargetTables"`
	// TableValidationErrors - READ-ONLY; Mapping from database name to list of validation errors
	TableValidationErrors map[string][]string `json:"tableValidationErrors"`
	// ValidationErrors - READ-ONLY; Validation errors
	ValidationErrors *[]ReportableException `json:"validationErrors,omitempty"`
}

// MarshalJSON is the custom marshaler for GetUserTablesSQLSyncTaskOutput.
func (gutssto GetUserTablesSQLSyncTaskOutput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// GetUserTablesSQLSyncTaskProperties properties for the task that collects user tables for the given list
// of databases
type GetUserTablesSQLSyncTaskProperties struct {
	// Input - Task input
	Input *GetUserTablesSQLSyncTaskInput `json:"input,omitempty"`
	// Output - READ-ONLY; Task output. This is ignored if submitted.
	Output *[]GetUserTablesSQLSyncTaskOutput `json:"output,omitempty"`
	// Errors - READ-ONLY; Array of errors. This is ignored if submitted.
	Errors *[]ODataError `json:"errors,omitempty"`
	// State - READ-ONLY; The state of the task. This is ignored if submitted. Possible values include: 'TaskStateUnknown', 'TaskStateQueued', 'TaskStateRunning', 'TaskStateCanceled', 'TaskStateSucceeded', 'TaskStateFailed', 'TaskStateFailedInputValidation', 'TaskStateFaulted'
	State TaskState `json:"state,omitempty"`
	// Commands - READ-ONLY; Array of command properties.
	Commands *[]BasicCommandProperties `json:"commands,omitempty"`
	// TaskType - Possible values include: 'TaskTypeUnknown', 'TaskTypeGetTDECertificatesSQL', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMISyncLRS', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMI', 'TaskTypeValidateMigrationInputSQLServerSQLDbSync', 'TaskTypeMigratePostgreSQLAzureDbForPostgreSQLSync', 'TaskTypeMigrateMySQLAzureDbForMySQLSync', 'TaskTypeMigrateSQLServerAzureSQLDbSync', 'TaskTypeMigrateSQLServerSQLDb', 'TaskTypeMigrateSQLServerAzureSQLDbMISyncLRS', 'TaskTypeMigrateSQLServerAzureSQLDbMI', 'TaskTypeConnectToTargetAzureDbForMySQL', 'TaskTypeConnectToTargetAzureSQLDbMISyncLRS', 'TaskTypeConnectToTargetAzureSQLDbMI', 'TaskTypeGetUserTablesAzureSQLDbSync', 'TaskTypeGetUserTablesSQL', 'TaskTypeConnectToTargetAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetSQLDbSync', 'TaskTypeConnectToTargetSQLDb', 'TaskTypeConnectToSourcePostgreSQLSync', 'TaskTypeConnectToSourceSQLServerSync', 'TaskTypeConnectToSourceSQLServer', 'TaskTypeConnectToSourceMySQL'
	TaskType TaskType `json:"taskType,omitempty"`
}

// MarshalJSON is the custom marshaler for GetUserTablesSQLSyncTaskProperties.
func (gutsstp GetUserTablesSQLSyncTaskProperties) MarshalJSON() ([]byte, error) {
	gutsstp.TaskType = TaskTypeGetUserTablesAzureSQLDbSync
	objectMap := make(map[string]interface{})
	if gutsstp.Input != nil {
		objectMap["input"] = gutsstp.Input
	}
	if gutsstp.TaskType != "" {
		objectMap["taskType"] = gutsstp.TaskType
	}
	return json.Marshal(objectMap)
}

// AsGetTdeCertificatesSQLTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLSyncTaskProperties.
func (gutsstp GetUserTablesSQLSyncTaskProperties) AsGetTdeCertificatesSQLTaskProperties() (*GetTdeCertificatesSQLTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLSyncTaskProperties.
func (gutsstp GetUserTablesSQLSyncTaskProperties) AsValidateMigrationInputSQLServerSQLMISyncTaskProperties() (*ValidateMigrationInputSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLSyncTaskProperties.
func (gutsstp GetUserTablesSQLSyncTaskProperties) AsValidateMigrationInputSQLServerSQLMITaskProperties() (*ValidateMigrationInputSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLSyncTaskProperties.
func (gutsstp GetUserTablesSQLSyncTaskProperties) AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties() (*ValidateMigrationInputSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLSyncTaskProperties.
func (gutsstp GetUserTablesSQLSyncTaskProperties) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLSyncTaskProperties.
func (gutsstp GetUserTablesSQLSyncTaskProperties) AsMigrateMySQLAzureDbForMySQLSyncTaskProperties() (*MigrateMySQLAzureDbForMySQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLSyncTaskProperties.
func (gutsstp GetUserTablesSQLSyncTaskProperties) AsMigrateSQLServerSQLDbSyncTaskProperties() (*MigrateSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLSyncTaskProperties.
func (gutsstp GetUserTablesSQLSyncTaskProperties) AsMigrateSQLServerSQLDbTaskProperties() (*MigrateSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLSyncTaskProperties.
func (gutsstp GetUserTablesSQLSyncTaskProperties) AsMigrateSQLServerSQLMISyncTaskProperties() (*MigrateSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLSyncTaskProperties.
func (gutsstp GetUserTablesSQLSyncTaskProperties) AsMigrateSQLServerSQLMITaskProperties() (*MigrateSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForMySQLTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLSyncTaskProperties.
func (gutsstp GetUserTablesSQLSyncTaskProperties) AsConnectToTargetAzureDbForMySQLTaskProperties() (*ConnectToTargetAzureDbForMySQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLSyncTaskProperties.
func (gutsstp GetUserTablesSQLSyncTaskProperties) AsConnectToTargetSQLMISyncTaskProperties() (*ConnectToTargetSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMITaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLSyncTaskProperties.
func (gutsstp GetUserTablesSQLSyncTaskProperties) AsConnectToTargetSQLMITaskProperties() (*ConnectToTargetSQLMITaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLSyncTaskProperties.
func (gutsstp GetUserTablesSQLSyncTaskProperties) AsGetUserTablesSQLSyncTaskProperties() (*GetUserTablesSQLSyncTaskProperties, bool) {
	return &gutsstp, true
}

// AsGetUserTablesSQLTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLSyncTaskProperties.
func (gutsstp GetUserTablesSQLSyncTaskProperties) AsGetUserTablesSQLTaskProperties() (*GetUserTablesSQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLSyncTaskProperties.
func (gutsstp GetUserTablesSQLSyncTaskProperties) AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLSyncTaskProperties.
func (gutsstp GetUserTablesSQLSyncTaskProperties) AsConnectToTargetSQLSQLDbSyncTaskProperties() (*ConnectToTargetSQLSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLDbTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLSyncTaskProperties.
func (gutsstp GetUserTablesSQLSyncTaskProperties) AsConnectToTargetSQLDbTaskProperties() (*ConnectToTargetSQLDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourcePostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLSyncTaskProperties.
func (gutsstp GetUserTablesSQLSyncTaskProperties) AsConnectToSourcePostgreSQLSyncTaskProperties() (*ConnectToSourcePostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerSyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLSyncTaskProperties.
func (gutsstp GetUserTablesSQLSyncTaskProperties) AsConnectToSourceSQLServerSyncTaskProperties() (*ConnectToSourceSQLServerSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLSyncTaskProperties.
func (gutsstp GetUserTablesSQLSyncTaskProperties) AsConnectToSourceSQLServerTaskProperties() (*ConnectToSourceSQLServerTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceMySQLTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLSyncTaskProperties.
func (gutsstp GetUserTablesSQLSyncTaskProperties) AsConnectToSourceMySQLTaskProperties() (*ConnectToSourceMySQLTaskProperties, bool) {
	return nil, false
}

// AsProjectTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLSyncTaskProperties.
func (gutsstp GetUserTablesSQLSyncTaskProperties) AsProjectTaskProperties() (*ProjectTaskProperties, bool) {
	return nil, false
}

// AsBasicProjectTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLSyncTaskProperties.
func (gutsstp GetUserTablesSQLSyncTaskProperties) AsBasicProjectTaskProperties() (BasicProjectTaskProperties, bool) {
	return &gutsstp, true
}

// UnmarshalJSON is the custom unmarshaler for GetUserTablesSQLSyncTaskProperties struct.
func (gutsstp *GetUserTablesSQLSyncTaskProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "input":
			if v != nil {
				var input GetUserTablesSQLSyncTaskInput
				err = json.Unmarshal(*v, &input)
				if err != nil {
					return err
				}
				gutsstp.Input = &input
			}
		case "output":
			if v != nil {
				var output []GetUserTablesSQLSyncTaskOutput
				err = json.Unmarshal(*v, &output)
				if err != nil {
					return err
				}
				gutsstp.Output = &output
			}
		case "errors":
			if v != nil {
				var errorsVar []ODataError
				err = json.Unmarshal(*v, &errorsVar)
				if err != nil {
					return err
				}
				gutsstp.Errors = &errorsVar
			}
		case "state":
			if v != nil {
				var state TaskState
				err = json.Unmarshal(*v, &state)
				if err != nil {
					return err
				}
				gutsstp.State = state
			}
		case "commands":
			if v != nil {
				commands, err := unmarshalBasicCommandPropertiesArray(*v)
				if err != nil {
					return err
				}
				gutsstp.Commands = &commands
			}
		case "taskType":
			if v != nil {
				var taskType TaskType
				err = json.Unmarshal(*v, &taskType)
				if err != nil {
					return err
				}
				gutsstp.TaskType = taskType
			}
		}
	}

	return nil
}

// GetUserTablesSQLTaskInput input for the task that collects user tables for the given list of databases
type GetUserTablesSQLTaskInput struct {
	// ConnectionInfo - Connection information for SQL Server
	ConnectionInfo *SQLConnectionInfo `json:"connectionInfo,omitempty"`
	// SelectedDatabases - List of database names to collect tables for
	SelectedDatabases *[]string `json:"selectedDatabases,omitempty"`
}

// GetUserTablesSQLTaskOutput output of the task that collects user tables for the given list of databases
type GetUserTablesSQLTaskOutput struct {
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// DatabasesToTables - READ-ONLY; Mapping from database name to list of tables
	DatabasesToTables map[string][]DatabaseTable `json:"databasesToTables"`
	// ValidationErrors - READ-ONLY; Validation errors
	ValidationErrors *[]ReportableException `json:"validationErrors,omitempty"`
}

// MarshalJSON is the custom marshaler for GetUserTablesSQLTaskOutput.
func (gutsto GetUserTablesSQLTaskOutput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// GetUserTablesSQLTaskProperties properties for the task that collects user tables for the given list of
// databases
type GetUserTablesSQLTaskProperties struct {
	// Input - Task input
	Input *GetUserTablesSQLTaskInput `json:"input,omitempty"`
	// Output - READ-ONLY; Task output. This is ignored if submitted.
	Output *[]GetUserTablesSQLTaskOutput `json:"output,omitempty"`
	// Errors - READ-ONLY; Array of errors. This is ignored if submitted.
	Errors *[]ODataError `json:"errors,omitempty"`
	// State - READ-ONLY; The state of the task. This is ignored if submitted. Possible values include: 'TaskStateUnknown', 'TaskStateQueued', 'TaskStateRunning', 'TaskStateCanceled', 'TaskStateSucceeded', 'TaskStateFailed', 'TaskStateFailedInputValidation', 'TaskStateFaulted'
	State TaskState `json:"state,omitempty"`
	// Commands - READ-ONLY; Array of command properties.
	Commands *[]BasicCommandProperties `json:"commands,omitempty"`
	// TaskType - Possible values include: 'TaskTypeUnknown', 'TaskTypeGetTDECertificatesSQL', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMISyncLRS', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMI', 'TaskTypeValidateMigrationInputSQLServerSQLDbSync', 'TaskTypeMigratePostgreSQLAzureDbForPostgreSQLSync', 'TaskTypeMigrateMySQLAzureDbForMySQLSync', 'TaskTypeMigrateSQLServerAzureSQLDbSync', 'TaskTypeMigrateSQLServerSQLDb', 'TaskTypeMigrateSQLServerAzureSQLDbMISyncLRS', 'TaskTypeMigrateSQLServerAzureSQLDbMI', 'TaskTypeConnectToTargetAzureDbForMySQL', 'TaskTypeConnectToTargetAzureSQLDbMISyncLRS', 'TaskTypeConnectToTargetAzureSQLDbMI', 'TaskTypeGetUserTablesAzureSQLDbSync', 'TaskTypeGetUserTablesSQL', 'TaskTypeConnectToTargetAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetSQLDbSync', 'TaskTypeConnectToTargetSQLDb', 'TaskTypeConnectToSourcePostgreSQLSync', 'TaskTypeConnectToSourceSQLServerSync', 'TaskTypeConnectToSourceSQLServer', 'TaskTypeConnectToSourceMySQL'
	TaskType TaskType `json:"taskType,omitempty"`
}

// MarshalJSON is the custom marshaler for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) MarshalJSON() ([]byte, error) {
	gutstp.TaskType = TaskTypeGetUserTablesSQL
	objectMap := make(map[string]interface{})
	if gutstp.Input != nil {
		objectMap["input"] = gutstp.Input
	}
	if gutstp.TaskType != "" {
		objectMap["taskType"] = gutstp.TaskType
	}
	return json.Marshal(objectMap)
}

// AsGetTdeCertificatesSQLTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) AsGetTdeCertificatesSQLTaskProperties() (*GetTdeCertificatesSQLTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) AsValidateMigrationInputSQLServerSQLMISyncTaskProperties() (*ValidateMigrationInputSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) AsValidateMigrationInputSQLServerSQLMITaskProperties() (*ValidateMigrationInputSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties() (*ValidateMigrationInputSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) AsMigrateMySQLAzureDbForMySQLSyncTaskProperties() (*MigrateMySQLAzureDbForMySQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) AsMigrateSQLServerSQLDbSyncTaskProperties() (*MigrateSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) AsMigrateSQLServerSQLDbTaskProperties() (*MigrateSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) AsMigrateSQLServerSQLMISyncTaskProperties() (*MigrateSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) AsMigrateSQLServerSQLMITaskProperties() (*MigrateSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForMySQLTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) AsConnectToTargetAzureDbForMySQLTaskProperties() (*ConnectToTargetAzureDbForMySQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) AsConnectToTargetSQLMISyncTaskProperties() (*ConnectToTargetSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMITaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) AsConnectToTargetSQLMITaskProperties() (*ConnectToTargetSQLMITaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) AsGetUserTablesSQLSyncTaskProperties() (*GetUserTablesSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) AsGetUserTablesSQLTaskProperties() (*GetUserTablesSQLTaskProperties, bool) {
	return &gutstp, true
}

// AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) AsConnectToTargetSQLSQLDbSyncTaskProperties() (*ConnectToTargetSQLSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLDbTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) AsConnectToTargetSQLDbTaskProperties() (*ConnectToTargetSQLDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourcePostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) AsConnectToSourcePostgreSQLSyncTaskProperties() (*ConnectToSourcePostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerSyncTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) AsConnectToSourceSQLServerSyncTaskProperties() (*ConnectToSourceSQLServerSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) AsConnectToSourceSQLServerTaskProperties() (*ConnectToSourceSQLServerTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceMySQLTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) AsConnectToSourceMySQLTaskProperties() (*ConnectToSourceMySQLTaskProperties, bool) {
	return nil, false
}

// AsProjectTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) AsProjectTaskProperties() (*ProjectTaskProperties, bool) {
	return nil, false
}

// AsBasicProjectTaskProperties is the BasicProjectTaskProperties implementation for GetUserTablesSQLTaskProperties.
func (gutstp GetUserTablesSQLTaskProperties) AsBasicProjectTaskProperties() (BasicProjectTaskProperties, bool) {
	return &gutstp, true
}

// UnmarshalJSON is the custom unmarshaler for GetUserTablesSQLTaskProperties struct.
func (gutstp *GetUserTablesSQLTaskProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "input":
			if v != nil {
				var input GetUserTablesSQLTaskInput
				err = json.Unmarshal(*v, &input)
				if err != nil {
					return err
				}
				gutstp.Input = &input
			}
		case "output":
			if v != nil {
				var output []GetUserTablesSQLTaskOutput
				err = json.Unmarshal(*v, &output)
				if err != nil {
					return err
				}
				gutstp.Output = &output
			}
		case "errors":
			if v != nil {
				var errorsVar []ODataError
				err = json.Unmarshal(*v, &errorsVar)
				if err != nil {
					return err
				}
				gutstp.Errors = &errorsVar
			}
		case "state":
			if v != nil {
				var state TaskState
				err = json.Unmarshal(*v, &state)
				if err != nil {
					return err
				}
				gutstp.State = state
			}
		case "commands":
			if v != nil {
				commands, err := unmarshalBasicCommandPropertiesArray(*v)
				if err != nil {
					return err
				}
				gutstp.Commands = &commands
			}
		case "taskType":
			if v != nil {
				var taskType TaskType
				err = json.Unmarshal(*v, &taskType)
				if err != nil {
					return err
				}
				gutstp.TaskType = taskType
			}
		}
	}

	return nil
}

// MigrateMISyncCompleteCommandInput input for command that completes online migration for an Azure SQL
// Database Managed Instance.
type MigrateMISyncCompleteCommandInput struct {
	// SourceDatabaseName - Name of managed instance database
	SourceDatabaseName *string `json:"sourceDatabaseName,omitempty"`
}

// MigrateMISyncCompleteCommandOutput output for command that completes online migration for an Azure SQL
// Database Managed Instance.
type MigrateMISyncCompleteCommandOutput struct {
	// Errors - List of errors that happened during the command execution
	Errors *[]ReportableException `json:"errors,omitempty"`
}

// MigrateMISyncCompleteCommandProperties properties for the command that completes online migration for an
// Azure SQL Database Managed Instance.
type MigrateMISyncCompleteCommandProperties struct {
	// Input - Command input
	Input *MigrateMISyncCompleteCommandInput `json:"input,omitempty"`
	// Output - READ-ONLY; Command output. This is ignored if submitted.
	Output *MigrateMISyncCompleteCommandOutput `json:"output,omitempty"`
	// Errors - READ-ONLY; Array of errors. This is ignored if submitted.
	Errors *[]ODataError `json:"errors,omitempty"`
	// State - READ-ONLY; The state of the command. This is ignored if submitted. Possible values include: 'Unknown', 'Accepted', 'Running', 'Succeeded', 'Failed'
	State CommandState `json:"state,omitempty"`
	// CommandType - Possible values include: 'CommandTypeUnknown', 'CommandTypeMigrateSQLServerAzureDbSQLMiComplete', 'CommandTypeMigrateSyncCompleteDatabase'
	CommandType CommandType `json:"commandType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateMISyncCompleteCommandProperties.
func (mmsccp MigrateMISyncCompleteCommandProperties) MarshalJSON() ([]byte, error) {
	mmsccp.CommandType = CommandTypeMigrateSQLServerAzureDbSQLMiComplete
	objectMap := make(map[string]interface{})
	if mmsccp.Input != nil {
		objectMap["input"] = mmsccp.Input
	}
	if mmsccp.CommandType != "" {
		objectMap["commandType"] = mmsccp.CommandType
	}
	return json.Marshal(objectMap)
}

// AsMigrateMISyncCompleteCommandProperties is the BasicCommandProperties implementation for MigrateMISyncCompleteCommandProperties.
func (mmsccp MigrateMISyncCompleteCommandProperties) AsMigrateMISyncCompleteCommandProperties() (*MigrateMISyncCompleteCommandProperties, bool) {
	return &mmsccp, true
}

// AsMigrateSyncCompleteCommandProperties is the BasicCommandProperties implementation for MigrateMISyncCompleteCommandProperties.
func (mmsccp MigrateMISyncCompleteCommandProperties) AsMigrateSyncCompleteCommandProperties() (*MigrateSyncCompleteCommandProperties, bool) {
	return nil, false
}

// AsCommandProperties is the BasicCommandProperties implementation for MigrateMISyncCompleteCommandProperties.
func (mmsccp MigrateMISyncCompleteCommandProperties) AsCommandProperties() (*CommandProperties, bool) {
	return nil, false
}

// AsBasicCommandProperties is the BasicCommandProperties implementation for MigrateMISyncCompleteCommandProperties.
func (mmsccp MigrateMISyncCompleteCommandProperties) AsBasicCommandProperties() (BasicCommandProperties, bool) {
	return &mmsccp, true
}

// MigrateMySQLAzureDbForMySQLSyncDatabaseInput database specific information for MySQL to Azure Database
// for MySQL migration task inputs
type MigrateMySQLAzureDbForMySQLSyncDatabaseInput struct {
	// Name - Name of the database
	Name *string `json:"name,omitempty"`
	// TargetDatabaseName - Name of target database. Note: Target database will be truncated before starting migration.
	TargetDatabaseName *string `json:"targetDatabaseName,omitempty"`
	// MigrationSetting - Migration settings which tune the migration behavior
	MigrationSetting map[string]*string `json:"migrationSetting"`
	// SourceSetting - Source settings to tune source endpoint migration behavior
	SourceSetting map[string]*string `json:"sourceSetting"`
	// TargetSetting - Target settings to tune target endpoint migration behavior
	TargetSetting map[string]*string `json:"targetSetting"`
}

// MarshalJSON is the custom marshaler for MigrateMySQLAzureDbForMySQLSyncDatabaseInput.
func (mmsadfmssdi MigrateMySQLAzureDbForMySQLSyncDatabaseInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mmsadfmssdi.Name != nil {
		objectMap["name"] = mmsadfmssdi.Name
	}
	if mmsadfmssdi.TargetDatabaseName != nil {
		objectMap["targetDatabaseName"] = mmsadfmssdi.TargetDatabaseName
	}
	if mmsadfmssdi.MigrationSetting != nil {
		objectMap["migrationSetting"] = mmsadfmssdi.MigrationSetting
	}
	if mmsadfmssdi.SourceSetting != nil {
		objectMap["sourceSetting"] = mmsadfmssdi.SourceSetting
	}
	if mmsadfmssdi.TargetSetting != nil {
		objectMap["targetSetting"] = mmsadfmssdi.TargetSetting
	}
	return json.Marshal(objectMap)
}

// MigrateMySQLAzureDbForMySQLSyncTaskInput input for the task that migrates MySQL databases to Azure
// Database for MySQL for online migrations
type MigrateMySQLAzureDbForMySQLSyncTaskInput struct {
	// SourceConnectionInfo - Connection information for source MySQL
	SourceConnectionInfo *MySQLConnectionInfo `json:"sourceConnectionInfo,omitempty"`
	// TargetConnectionInfo - Connection information for target Azure Database for MySQL
	TargetConnectionInfo *MySQLConnectionInfo `json:"targetConnectionInfo,omitempty"`
	// SelectedDatabases - Databases to migrate
	SelectedDatabases *[]MigrateMySQLAzureDbForMySQLSyncDatabaseInput `json:"selectedDatabases,omitempty"`
}

// BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput output for the task that migrates MySQL databases to Azure Database
// for MySQL for online migrations
type BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput interface {
	AsMigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError() (*MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError, bool)
	AsMigrateMySQLAzureDbForMySQLSyncTaskOutputError() (*MigrateMySQLAzureDbForMySQLSyncTaskOutputError, bool)
	AsMigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel() (*MigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel, bool)
	AsMigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel() (*MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel, bool)
	AsMigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel() (*MigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel, bool)
	AsMigrateMySQLAzureDbForMySQLSyncTaskOutput() (*MigrateMySQLAzureDbForMySQLSyncTaskOutput, bool)
}

// MigrateMySQLAzureDbForMySQLSyncTaskOutput output for the task that migrates MySQL databases to Azure
// Database for MySQL for online migrations
type MigrateMySQLAzureDbForMySQLSyncTaskOutput struct {
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeMigrateMySQLAzureDbForMySQLSyncTaskOutput', 'ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeDatabaseLevelErrorOutput', 'ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeErrorOutput', 'ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeTableLevelOutput', 'ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeMigrationLevelOutput'
	ResultType ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput `json:"resultType,omitempty"`
}

func unmarshalBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput(body []byte) (BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["resultType"] {
	case string(ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeDatabaseLevelErrorOutput):
		var mmsadfmsstode MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError
		err := json.Unmarshal(body, &mmsadfmsstode)
		return mmsadfmsstode, err
	case string(ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeErrorOutput):
		var mmsadfmsstoe MigrateMySQLAzureDbForMySQLSyncTaskOutputError
		err := json.Unmarshal(body, &mmsadfmsstoe)
		return mmsadfmsstoe, err
	case string(ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeTableLevelOutput):
		var mmsadfmsstotl MigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel
		err := json.Unmarshal(body, &mmsadfmsstotl)
		return mmsadfmsstotl, err
	case string(ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeDatabaseLevelOutput):
		var mmsadfmsstodl MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel
		err := json.Unmarshal(body, &mmsadfmsstodl)
		return mmsadfmsstodl, err
	case string(ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeMigrationLevelOutput):
		var mmsadfmsstoml MigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel
		err := json.Unmarshal(body, &mmsadfmsstoml)
		return mmsadfmsstoml, err
	default:
		var mmsadfmssto MigrateMySQLAzureDbForMySQLSyncTaskOutput
		err := json.Unmarshal(body, &mmsadfmssto)
		return mmsadfmssto, err
	}
}
func unmarshalBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputArray(body []byte) ([]BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	mmsadfmsstoArray := make([]BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput, len(rawMessages))

	for index, rawMessage := range rawMessages {
		mmsadfmssto, err := unmarshalBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput(*rawMessage)
		if err != nil {
			return nil, err
		}
		mmsadfmsstoArray[index] = mmsadfmssto
	}
	return mmsadfmsstoArray, nil
}

// MarshalJSON is the custom marshaler for MigrateMySQLAzureDbForMySQLSyncTaskOutput.
func (mmsadfmssto MigrateMySQLAzureDbForMySQLSyncTaskOutput) MarshalJSON() ([]byte, error) {
	mmsadfmssto.ResultType = ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeMigrateMySQLAzureDbForMySQLSyncTaskOutput
	objectMap := make(map[string]interface{})
	if mmsadfmssto.ResultType != "" {
		objectMap["resultType"] = mmsadfmssto.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutput.
func (mmsadfmssto MigrateMySQLAzureDbForMySQLSyncTaskOutput) AsMigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError() (*MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskOutputError is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutput.
func (mmsadfmssto MigrateMySQLAzureDbForMySQLSyncTaskOutput) AsMigrateMySQLAzureDbForMySQLSyncTaskOutputError() (*MigrateMySQLAzureDbForMySQLSyncTaskOutputError, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutput.
func (mmsadfmssto MigrateMySQLAzureDbForMySQLSyncTaskOutput) AsMigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel() (*MigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutput.
func (mmsadfmssto MigrateMySQLAzureDbForMySQLSyncTaskOutput) AsMigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel() (*MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutput.
func (mmsadfmssto MigrateMySQLAzureDbForMySQLSyncTaskOutput) AsMigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel() (*MigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskOutput is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutput.
func (mmsadfmssto MigrateMySQLAzureDbForMySQLSyncTaskOutput) AsMigrateMySQLAzureDbForMySQLSyncTaskOutput() (*MigrateMySQLAzureDbForMySQLSyncTaskOutput, bool) {
	return &mmsadfmssto, true
}

// AsBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutput.
func (mmsadfmssto MigrateMySQLAzureDbForMySQLSyncTaskOutput) AsBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput() (BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput, bool) {
	return &mmsadfmssto, true
}

// MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError ...
type MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError struct {
	// ErrorMessage - Error message
	ErrorMessage *string `json:"errorMessage,omitempty"`
	// Events - List of error events.
	Events *[]SyncMigrationDatabaseErrorEvent `json:"events,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeMigrateMySQLAzureDbForMySQLSyncTaskOutput', 'ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeDatabaseLevelErrorOutput', 'ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeErrorOutput', 'ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeTableLevelOutput', 'ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeMigrationLevelOutput'
	ResultType ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError.
func (mmsadfmsstode MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError) MarshalJSON() ([]byte, error) {
	mmsadfmsstode.ResultType = ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeDatabaseLevelErrorOutput
	objectMap := make(map[string]interface{})
	if mmsadfmsstode.ErrorMessage != nil {
		objectMap["errorMessage"] = mmsadfmsstode.ErrorMessage
	}
	if mmsadfmsstode.Events != nil {
		objectMap["events"] = mmsadfmsstode.Events
	}
	if mmsadfmsstode.ResultType != "" {
		objectMap["resultType"] = mmsadfmsstode.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError.
func (mmsadfmsstode MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError) AsMigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError() (*MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError, bool) {
	return &mmsadfmsstode, true
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskOutputError is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError.
func (mmsadfmsstode MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError) AsMigrateMySQLAzureDbForMySQLSyncTaskOutputError() (*MigrateMySQLAzureDbForMySQLSyncTaskOutputError, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError.
func (mmsadfmsstode MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError) AsMigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel() (*MigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError.
func (mmsadfmsstode MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError) AsMigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel() (*MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError.
func (mmsadfmsstode MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError) AsMigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel() (*MigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskOutput is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError.
func (mmsadfmsstode MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError) AsMigrateMySQLAzureDbForMySQLSyncTaskOutput() (*MigrateMySQLAzureDbForMySQLSyncTaskOutput, bool) {
	return nil, false
}

// AsBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError.
func (mmsadfmsstode MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError) AsBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput() (BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput, bool) {
	return &mmsadfmsstode, true
}

// MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel ...
type MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel struct {
	// DatabaseName - READ-ONLY; Name of the database
	DatabaseName *string `json:"databaseName,omitempty"`
	// StartedOn - READ-ONLY; Migration start time
	StartedOn *date.Time `json:"startedOn,omitempty"`
	// EndedOn - READ-ONLY; Migration end time
	EndedOn *date.Time `json:"endedOn,omitempty"`
	// MigrationState - READ-ONLY; Migration state that this database is in. Possible values include: 'SyncDatabaseMigrationReportingStateUNDEFINED', 'SyncDatabaseMigrationReportingStateCONFIGURING', 'SyncDatabaseMigrationReportingStateINITIALIAZING', 'SyncDatabaseMigrationReportingStateSTARTING', 'SyncDatabaseMigrationReportingStateRUNNING', 'SyncDatabaseMigrationReportingStateREADYTOCOMPLETE', 'SyncDatabaseMigrationReportingStateCOMPLETING', 'SyncDatabaseMigrationReportingStateCOMPLETE', 'SyncDatabaseMigrationReportingStateCANCELLING', 'SyncDatabaseMigrationReportingStateCANCELLED', 'SyncDatabaseMigrationReportingStateFAILED'
	MigrationState SyncDatabaseMigrationReportingState `json:"migrationState,omitempty"`
	// IncomingChanges - READ-ONLY; Number of incoming changes
	IncomingChanges *int64 `json:"incomingChanges,omitempty"`
	// AppliedChanges - READ-ONLY; Number of applied changes
	AppliedChanges *int64 `json:"appliedChanges,omitempty"`
	// CdcInsertCounter - READ-ONLY; Number of cdc inserts
	CdcInsertCounter *int64 `json:"cdcInsertCounter,omitempty"`
	// CdcDeleteCounter - READ-ONLY; Number of cdc deletes
	CdcDeleteCounter *int64 `json:"cdcDeleteCounter,omitempty"`
	// CdcUpdateCounter - READ-ONLY; Number of cdc updates
	CdcUpdateCounter *int64 `json:"cdcUpdateCounter,omitempty"`
	// FullLoadCompletedTables - READ-ONLY; Number of tables completed in full load
	FullLoadCompletedTables *int64 `json:"fullLoadCompletedTables,omitempty"`
	// FullLoadLoadingTables - READ-ONLY; Number of tables loading in full load
	FullLoadLoadingTables *int64 `json:"fullLoadLoadingTables,omitempty"`
	// FullLoadQueuedTables - READ-ONLY; Number of tables queued in full load
	FullLoadQueuedTables *int64 `json:"fullLoadQueuedTables,omitempty"`
	// FullLoadErroredTables - READ-ONLY; Number of tables errored in full load
	FullLoadErroredTables *int64 `json:"fullLoadErroredTables,omitempty"`
	// InitializationCompleted - READ-ONLY; Indicates if initial load (full load) has been completed
	InitializationCompleted *bool `json:"initializationCompleted,omitempty"`
	// Latency - READ-ONLY; CDC apply latency
	Latency *int64 `json:"latency,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeMigrateMySQLAzureDbForMySQLSyncTaskOutput', 'ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeDatabaseLevelErrorOutput', 'ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeErrorOutput', 'ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeTableLevelOutput', 'ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeMigrationLevelOutput'
	ResultType ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel.
func (mmsadfmsstodl MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel) MarshalJSON() ([]byte, error) {
	mmsadfmsstodl.ResultType = ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeDatabaseLevelOutput
	objectMap := make(map[string]interface{})
	if mmsadfmsstodl.ResultType != "" {
		objectMap["resultType"] = mmsadfmsstodl.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel.
func (mmsadfmsstodl MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel) AsMigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError() (*MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskOutputError is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel.
func (mmsadfmsstodl MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel) AsMigrateMySQLAzureDbForMySQLSyncTaskOutputError() (*MigrateMySQLAzureDbForMySQLSyncTaskOutputError, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel.
func (mmsadfmsstodl MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel) AsMigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel() (*MigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel.
func (mmsadfmsstodl MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel) AsMigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel() (*MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel, bool) {
	return &mmsadfmsstodl, true
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel.
func (mmsadfmsstodl MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel) AsMigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel() (*MigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskOutput is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel.
func (mmsadfmsstodl MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel) AsMigrateMySQLAzureDbForMySQLSyncTaskOutput() (*MigrateMySQLAzureDbForMySQLSyncTaskOutput, bool) {
	return nil, false
}

// AsBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel.
func (mmsadfmsstodl MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel) AsBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput() (BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput, bool) {
	return &mmsadfmsstodl, true
}

// MigrateMySQLAzureDbForMySQLSyncTaskOutputError ...
type MigrateMySQLAzureDbForMySQLSyncTaskOutputError struct {
	// Error - READ-ONLY; Migration error
	Error *ReportableException `json:"error,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeMigrateMySQLAzureDbForMySQLSyncTaskOutput', 'ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeDatabaseLevelErrorOutput', 'ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeErrorOutput', 'ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeTableLevelOutput', 'ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeMigrationLevelOutput'
	ResultType ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateMySQLAzureDbForMySQLSyncTaskOutputError.
func (mmsadfmsstoe MigrateMySQLAzureDbForMySQLSyncTaskOutputError) MarshalJSON() ([]byte, error) {
	mmsadfmsstoe.ResultType = ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeErrorOutput
	objectMap := make(map[string]interface{})
	if mmsadfmsstoe.ResultType != "" {
		objectMap["resultType"] = mmsadfmsstoe.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutputError.
func (mmsadfmsstoe MigrateMySQLAzureDbForMySQLSyncTaskOutputError) AsMigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError() (*MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskOutputError is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutputError.
func (mmsadfmsstoe MigrateMySQLAzureDbForMySQLSyncTaskOutputError) AsMigrateMySQLAzureDbForMySQLSyncTaskOutputError() (*MigrateMySQLAzureDbForMySQLSyncTaskOutputError, bool) {
	return &mmsadfmsstoe, true
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutputError.
func (mmsadfmsstoe MigrateMySQLAzureDbForMySQLSyncTaskOutputError) AsMigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel() (*MigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutputError.
func (mmsadfmsstoe MigrateMySQLAzureDbForMySQLSyncTaskOutputError) AsMigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel() (*MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutputError.
func (mmsadfmsstoe MigrateMySQLAzureDbForMySQLSyncTaskOutputError) AsMigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel() (*MigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskOutput is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutputError.
func (mmsadfmsstoe MigrateMySQLAzureDbForMySQLSyncTaskOutputError) AsMigrateMySQLAzureDbForMySQLSyncTaskOutput() (*MigrateMySQLAzureDbForMySQLSyncTaskOutput, bool) {
	return nil, false
}

// AsBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutputError.
func (mmsadfmsstoe MigrateMySQLAzureDbForMySQLSyncTaskOutputError) AsBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput() (BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput, bool) {
	return &mmsadfmsstoe, true
}

// MigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel ...
type MigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel struct {
	// StartedOn - READ-ONLY; Migration start time
	StartedOn *date.Time `json:"startedOn,omitempty"`
	// EndedOn - READ-ONLY; Migration end time
	EndedOn *date.Time `json:"endedOn,omitempty"`
	// SourceServerVersion - READ-ONLY; Source server version
	SourceServerVersion *string `json:"sourceServerVersion,omitempty"`
	// SourceServer - READ-ONLY; Source server name
	SourceServer *string `json:"sourceServer,omitempty"`
	// TargetServerVersion - READ-ONLY; Target server version
	TargetServerVersion *string `json:"targetServerVersion,omitempty"`
	// TargetServer - READ-ONLY; Target server name
	TargetServer *string `json:"targetServer,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeMigrateMySQLAzureDbForMySQLSyncTaskOutput', 'ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeDatabaseLevelErrorOutput', 'ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeErrorOutput', 'ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeTableLevelOutput', 'ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeMigrationLevelOutput'
	ResultType ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel.
func (mmsadfmsstoml MigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel) MarshalJSON() ([]byte, error) {
	mmsadfmsstoml.ResultType = ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeMigrationLevelOutput
	objectMap := make(map[string]interface{})
	if mmsadfmsstoml.ResultType != "" {
		objectMap["resultType"] = mmsadfmsstoml.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel.
func (mmsadfmsstoml MigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel) AsMigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError() (*MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskOutputError is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel.
func (mmsadfmsstoml MigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel) AsMigrateMySQLAzureDbForMySQLSyncTaskOutputError() (*MigrateMySQLAzureDbForMySQLSyncTaskOutputError, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel.
func (mmsadfmsstoml MigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel) AsMigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel() (*MigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel.
func (mmsadfmsstoml MigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel) AsMigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel() (*MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel.
func (mmsadfmsstoml MigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel) AsMigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel() (*MigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel, bool) {
	return &mmsadfmsstoml, true
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskOutput is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel.
func (mmsadfmsstoml MigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel) AsMigrateMySQLAzureDbForMySQLSyncTaskOutput() (*MigrateMySQLAzureDbForMySQLSyncTaskOutput, bool) {
	return nil, false
}

// AsBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel.
func (mmsadfmsstoml MigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel) AsBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput() (BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput, bool) {
	return &mmsadfmsstoml, true
}

// MigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel ...
type MigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel struct {
	// TableName - READ-ONLY; Name of the table
	TableName *string `json:"tableName,omitempty"`
	// DatabaseName - READ-ONLY; Name of the database
	DatabaseName *string `json:"databaseName,omitempty"`
	// CdcInsertCounter - READ-ONLY; Number of applied inserts
	CdcInsertCounter *string `json:"cdcInsertCounter,omitempty"`
	// CdcUpdateCounter - READ-ONLY; Number of applied updates
	CdcUpdateCounter *string `json:"cdcUpdateCounter,omitempty"`
	// CdcDeleteCounter - READ-ONLY; Number of applied deletes
	CdcDeleteCounter *string `json:"cdcDeleteCounter,omitempty"`
	// FullLoadEstFinishTime - READ-ONLY; Estimate to finish full load
	FullLoadEstFinishTime *date.Time `json:"fullLoadEstFinishTime,omitempty"`
	// FullLoadStartedOn - READ-ONLY; Full load start time
	FullLoadStartedOn *date.Time `json:"fullLoadStartedOn,omitempty"`
	// FullLoadEndedOn - READ-ONLY; Full load end time
	FullLoadEndedOn *date.Time `json:"fullLoadEndedOn,omitempty"`
	// FullLoadTotalRows - READ-ONLY; Number of rows applied in full load
	FullLoadTotalRows *int64 `json:"fullLoadTotalRows,omitempty"`
	// State - READ-ONLY; Current state of the table migration. Possible values include: 'SyncTableMigrationStateBEFORELOAD', 'SyncTableMigrationStateFULLLOAD', 'SyncTableMigrationStateCOMPLETED', 'SyncTableMigrationStateCANCELED', 'SyncTableMigrationStateERROR', 'SyncTableMigrationStateFAILED'
	State SyncTableMigrationState `json:"state,omitempty"`
	// TotalChangesApplied - READ-ONLY; Total number of applied changes
	TotalChangesApplied *int64 `json:"totalChangesApplied,omitempty"`
	// DataErrorsCounter - READ-ONLY; Number of data errors occurred
	DataErrorsCounter *int64 `json:"dataErrorsCounter,omitempty"`
	// LastModifiedTime - READ-ONLY; Last modified time on target
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeMigrateMySQLAzureDbForMySQLSyncTaskOutput', 'ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeDatabaseLevelErrorOutput', 'ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeErrorOutput', 'ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeTableLevelOutput', 'ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeMigrationLevelOutput'
	ResultType ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel.
func (mmsadfmsstotl MigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel) MarshalJSON() ([]byte, error) {
	mmsadfmsstotl.ResultType = ResultTypeBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputResultTypeTableLevelOutput
	objectMap := make(map[string]interface{})
	if mmsadfmsstotl.ResultType != "" {
		objectMap["resultType"] = mmsadfmsstotl.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel.
func (mmsadfmsstotl MigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel) AsMigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError() (*MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseError, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskOutputError is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel.
func (mmsadfmsstotl MigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel) AsMigrateMySQLAzureDbForMySQLSyncTaskOutputError() (*MigrateMySQLAzureDbForMySQLSyncTaskOutputError, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel.
func (mmsadfmsstotl MigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel) AsMigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel() (*MigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel, bool) {
	return &mmsadfmsstotl, true
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel.
func (mmsadfmsstotl MigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel) AsMigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel() (*MigrateMySQLAzureDbForMySQLSyncTaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel.
func (mmsadfmsstotl MigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel) AsMigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel() (*MigrateMySQLAzureDbForMySQLSyncTaskOutputMigrationLevel, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskOutput is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel.
func (mmsadfmsstotl MigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel) AsMigrateMySQLAzureDbForMySQLSyncTaskOutput() (*MigrateMySQLAzureDbForMySQLSyncTaskOutput, bool) {
	return nil, false
}

// AsBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput is the BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput implementation for MigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel.
func (mmsadfmsstotl MigrateMySQLAzureDbForMySQLSyncTaskOutputTableLevel) AsBasicMigrateMySQLAzureDbForMySQLSyncTaskOutput() (BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput, bool) {
	return &mmsadfmsstotl, true
}

// MigrateMySQLAzureDbForMySQLSyncTaskProperties properties for the task that migrates MySQL databases to
// Azure Database for MySQL for online migrations
type MigrateMySQLAzureDbForMySQLSyncTaskProperties struct {
	// Input - Task input
	Input *MigrateMySQLAzureDbForMySQLSyncTaskInput `json:"input,omitempty"`
	// Output - READ-ONLY; Task output. This is ignored if submitted.
	Output *[]BasicMigrateMySQLAzureDbForMySQLSyncTaskOutput `json:"output,omitempty"`
	// Errors - READ-ONLY; Array of errors. This is ignored if submitted.
	Errors *[]ODataError `json:"errors,omitempty"`
	// State - READ-ONLY; The state of the task. This is ignored if submitted. Possible values include: 'TaskStateUnknown', 'TaskStateQueued', 'TaskStateRunning', 'TaskStateCanceled', 'TaskStateSucceeded', 'TaskStateFailed', 'TaskStateFailedInputValidation', 'TaskStateFaulted'
	State TaskState `json:"state,omitempty"`
	// Commands - READ-ONLY; Array of command properties.
	Commands *[]BasicCommandProperties `json:"commands,omitempty"`
	// TaskType - Possible values include: 'TaskTypeUnknown', 'TaskTypeGetTDECertificatesSQL', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMISyncLRS', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMI', 'TaskTypeValidateMigrationInputSQLServerSQLDbSync', 'TaskTypeMigratePostgreSQLAzureDbForPostgreSQLSync', 'TaskTypeMigrateMySQLAzureDbForMySQLSync', 'TaskTypeMigrateSQLServerAzureSQLDbSync', 'TaskTypeMigrateSQLServerSQLDb', 'TaskTypeMigrateSQLServerAzureSQLDbMISyncLRS', 'TaskTypeMigrateSQLServerAzureSQLDbMI', 'TaskTypeConnectToTargetAzureDbForMySQL', 'TaskTypeConnectToTargetAzureSQLDbMISyncLRS', 'TaskTypeConnectToTargetAzureSQLDbMI', 'TaskTypeGetUserTablesAzureSQLDbSync', 'TaskTypeGetUserTablesSQL', 'TaskTypeConnectToTargetAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetSQLDbSync', 'TaskTypeConnectToTargetSQLDb', 'TaskTypeConnectToSourcePostgreSQLSync', 'TaskTypeConnectToSourceSQLServerSync', 'TaskTypeConnectToSourceSQLServer', 'TaskTypeConnectToSourceMySQL'
	TaskType TaskType `json:"taskType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateMySQLAzureDbForMySQLSyncTaskProperties.
func (mmsadfmsstp MigrateMySQLAzureDbForMySQLSyncTaskProperties) MarshalJSON() ([]byte, error) {
	mmsadfmsstp.TaskType = TaskTypeMigrateMySQLAzureDbForMySQLSync
	objectMap := make(map[string]interface{})
	if mmsadfmsstp.Input != nil {
		objectMap["input"] = mmsadfmsstp.Input
	}
	if mmsadfmsstp.TaskType != "" {
		objectMap["taskType"] = mmsadfmsstp.TaskType
	}
	return json.Marshal(objectMap)
}

// AsGetTdeCertificatesSQLTaskProperties is the BasicProjectTaskProperties implementation for MigrateMySQLAzureDbForMySQLSyncTaskProperties.
func (mmsadfmsstp MigrateMySQLAzureDbForMySQLSyncTaskProperties) AsGetTdeCertificatesSQLTaskProperties() (*GetTdeCertificatesSQLTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateMySQLAzureDbForMySQLSyncTaskProperties.
func (mmsadfmsstp MigrateMySQLAzureDbForMySQLSyncTaskProperties) AsValidateMigrationInputSQLServerSQLMISyncTaskProperties() (*ValidateMigrationInputSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for MigrateMySQLAzureDbForMySQLSyncTaskProperties.
func (mmsadfmsstp MigrateMySQLAzureDbForMySQLSyncTaskProperties) AsValidateMigrationInputSQLServerSQLMITaskProperties() (*ValidateMigrationInputSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateMySQLAzureDbForMySQLSyncTaskProperties.
func (mmsadfmsstp MigrateMySQLAzureDbForMySQLSyncTaskProperties) AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties() (*ValidateMigrationInputSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateMySQLAzureDbForMySQLSyncTaskProperties.
func (mmsadfmsstp MigrateMySQLAzureDbForMySQLSyncTaskProperties) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateMySQLAzureDbForMySQLSyncTaskProperties.
func (mmsadfmsstp MigrateMySQLAzureDbForMySQLSyncTaskProperties) AsMigrateMySQLAzureDbForMySQLSyncTaskProperties() (*MigrateMySQLAzureDbForMySQLSyncTaskProperties, bool) {
	return &mmsadfmsstp, true
}

// AsMigrateSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateMySQLAzureDbForMySQLSyncTaskProperties.
func (mmsadfmsstp MigrateMySQLAzureDbForMySQLSyncTaskProperties) AsMigrateSQLServerSQLDbSyncTaskProperties() (*MigrateSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for MigrateMySQLAzureDbForMySQLSyncTaskProperties.
func (mmsadfmsstp MigrateMySQLAzureDbForMySQLSyncTaskProperties) AsMigrateSQLServerSQLDbTaskProperties() (*MigrateSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateMySQLAzureDbForMySQLSyncTaskProperties.
func (mmsadfmsstp MigrateMySQLAzureDbForMySQLSyncTaskProperties) AsMigrateSQLServerSQLMISyncTaskProperties() (*MigrateSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for MigrateMySQLAzureDbForMySQLSyncTaskProperties.
func (mmsadfmsstp MigrateMySQLAzureDbForMySQLSyncTaskProperties) AsMigrateSQLServerSQLMITaskProperties() (*MigrateSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForMySQLTaskProperties is the BasicProjectTaskProperties implementation for MigrateMySQLAzureDbForMySQLSyncTaskProperties.
func (mmsadfmsstp MigrateMySQLAzureDbForMySQLSyncTaskProperties) AsConnectToTargetAzureDbForMySQLTaskProperties() (*ConnectToTargetAzureDbForMySQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateMySQLAzureDbForMySQLSyncTaskProperties.
func (mmsadfmsstp MigrateMySQLAzureDbForMySQLSyncTaskProperties) AsConnectToTargetSQLMISyncTaskProperties() (*ConnectToTargetSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMITaskProperties is the BasicProjectTaskProperties implementation for MigrateMySQLAzureDbForMySQLSyncTaskProperties.
func (mmsadfmsstp MigrateMySQLAzureDbForMySQLSyncTaskProperties) AsConnectToTargetSQLMITaskProperties() (*ConnectToTargetSQLMITaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateMySQLAzureDbForMySQLSyncTaskProperties.
func (mmsadfmsstp MigrateMySQLAzureDbForMySQLSyncTaskProperties) AsGetUserTablesSQLSyncTaskProperties() (*GetUserTablesSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLTaskProperties is the BasicProjectTaskProperties implementation for MigrateMySQLAzureDbForMySQLSyncTaskProperties.
func (mmsadfmsstp MigrateMySQLAzureDbForMySQLSyncTaskProperties) AsGetUserTablesSQLTaskProperties() (*GetUserTablesSQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateMySQLAzureDbForMySQLSyncTaskProperties.
func (mmsadfmsstp MigrateMySQLAzureDbForMySQLSyncTaskProperties) AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateMySQLAzureDbForMySQLSyncTaskProperties.
func (mmsadfmsstp MigrateMySQLAzureDbForMySQLSyncTaskProperties) AsConnectToTargetSQLSQLDbSyncTaskProperties() (*ConnectToTargetSQLSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLDbTaskProperties is the BasicProjectTaskProperties implementation for MigrateMySQLAzureDbForMySQLSyncTaskProperties.
func (mmsadfmsstp MigrateMySQLAzureDbForMySQLSyncTaskProperties) AsConnectToTargetSQLDbTaskProperties() (*ConnectToTargetSQLDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourcePostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateMySQLAzureDbForMySQLSyncTaskProperties.
func (mmsadfmsstp MigrateMySQLAzureDbForMySQLSyncTaskProperties) AsConnectToSourcePostgreSQLSyncTaskProperties() (*ConnectToSourcePostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateMySQLAzureDbForMySQLSyncTaskProperties.
func (mmsadfmsstp MigrateMySQLAzureDbForMySQLSyncTaskProperties) AsConnectToSourceSQLServerSyncTaskProperties() (*ConnectToSourceSQLServerSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskProperties is the BasicProjectTaskProperties implementation for MigrateMySQLAzureDbForMySQLSyncTaskProperties.
func (mmsadfmsstp MigrateMySQLAzureDbForMySQLSyncTaskProperties) AsConnectToSourceSQLServerTaskProperties() (*ConnectToSourceSQLServerTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceMySQLTaskProperties is the BasicProjectTaskProperties implementation for MigrateMySQLAzureDbForMySQLSyncTaskProperties.
func (mmsadfmsstp MigrateMySQLAzureDbForMySQLSyncTaskProperties) AsConnectToSourceMySQLTaskProperties() (*ConnectToSourceMySQLTaskProperties, bool) {
	return nil, false
}

// AsProjectTaskProperties is the BasicProjectTaskProperties implementation for MigrateMySQLAzureDbForMySQLSyncTaskProperties.
func (mmsadfmsstp MigrateMySQLAzureDbForMySQLSyncTaskProperties) AsProjectTaskProperties() (*ProjectTaskProperties, bool) {
	return nil, false
}

// AsBasicProjectTaskProperties is the BasicProjectTaskProperties implementation for MigrateMySQLAzureDbForMySQLSyncTaskProperties.
func (mmsadfmsstp MigrateMySQLAzureDbForMySQLSyncTaskProperties) AsBasicProjectTaskProperties() (BasicProjectTaskProperties, bool) {
	return &mmsadfmsstp, true
}

// UnmarshalJSON is the custom unmarshaler for MigrateMySQLAzureDbForMySQLSyncTaskProperties struct.
func (mmsadfmsstp *MigrateMySQLAzureDbForMySQLSyncTaskProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "input":
			if v != nil {
				var input MigrateMySQLAzureDbForMySQLSyncTaskInput
				err = json.Unmarshal(*v, &input)
				if err != nil {
					return err
				}
				mmsadfmsstp.Input = &input
			}
		case "output":
			if v != nil {
				output, err := unmarshalBasicMigrateMySQLAzureDbForMySQLSyncTaskOutputArray(*v)
				if err != nil {
					return err
				}
				mmsadfmsstp.Output = &output
			}
		case "errors":
			if v != nil {
				var errorsVar []ODataError
				err = json.Unmarshal(*v, &errorsVar)
				if err != nil {
					return err
				}
				mmsadfmsstp.Errors = &errorsVar
			}
		case "state":
			if v != nil {
				var state TaskState
				err = json.Unmarshal(*v, &state)
				if err != nil {
					return err
				}
				mmsadfmsstp.State = state
			}
		case "commands":
			if v != nil {
				commands, err := unmarshalBasicCommandPropertiesArray(*v)
				if err != nil {
					return err
				}
				mmsadfmsstp.Commands = &commands
			}
		case "taskType":
			if v != nil {
				var taskType TaskType
				err = json.Unmarshal(*v, &taskType)
				if err != nil {
					return err
				}
				mmsadfmsstp.TaskType = taskType
			}
		}
	}

	return nil
}

// MigratePostgreSQLAzureDbForPostgreSQLSyncDatabaseInput database specific information for PostgreSQL to
// Azure Database for PostgreSQL migration task inputs
type MigratePostgreSQLAzureDbForPostgreSQLSyncDatabaseInput struct {
	// Name - Name of the database
	Name *string `json:"name,omitempty"`
	// TargetDatabaseName - Name of target database. Note: Target database will be truncated before starting migration.
	TargetDatabaseName *string `json:"targetDatabaseName,omitempty"`
	// MigrationSetting - Migration settings which tune the migration behavior
	MigrationSetting map[string]*string `json:"migrationSetting"`
	// SourceSetting - Source settings to tune source endpoint migration behavior
	SourceSetting map[string]*string `json:"sourceSetting"`
	// TargetSetting - Target settings to tune target endpoint migration behavior
	TargetSetting map[string]*string `json:"targetSetting"`
}

// MarshalJSON is the custom marshaler for MigratePostgreSQLAzureDbForPostgreSQLSyncDatabaseInput.
func (mpsadfpssdi MigratePostgreSQLAzureDbForPostgreSQLSyncDatabaseInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mpsadfpssdi.Name != nil {
		objectMap["name"] = mpsadfpssdi.Name
	}
	if mpsadfpssdi.TargetDatabaseName != nil {
		objectMap["targetDatabaseName"] = mpsadfpssdi.TargetDatabaseName
	}
	if mpsadfpssdi.MigrationSetting != nil {
		objectMap["migrationSetting"] = mpsadfpssdi.MigrationSetting
	}
	if mpsadfpssdi.SourceSetting != nil {
		objectMap["sourceSetting"] = mpsadfpssdi.SourceSetting
	}
	if mpsadfpssdi.TargetSetting != nil {
		objectMap["targetSetting"] = mpsadfpssdi.TargetSetting
	}
	return json.Marshal(objectMap)
}

// MigratePostgreSQLAzureDbForPostgreSQLSyncTaskInput input for the task that migrates PostgreSQL databases
// to Azure Database for PostgreSQL for online migrations
type MigratePostgreSQLAzureDbForPostgreSQLSyncTaskInput struct {
	// SelectedDatabases - Databases to migrate
	SelectedDatabases *[]MigratePostgreSQLAzureDbForPostgreSQLSyncDatabaseInput `json:"selectedDatabases,omitempty"`
	// TargetConnectionInfo - Connection information for target Azure Database for PostgreSQL
	TargetConnectionInfo *PostgreSQLConnectionInfo `json:"targetConnectionInfo,omitempty"`
	// SourceConnectionInfo - Connection information for source PostgreSQL
	SourceConnectionInfo *PostgreSQLConnectionInfo `json:"sourceConnectionInfo,omitempty"`
}

// BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput output for the task that migrates PostgreSQL databases to
// Azure Database for PostgreSQL for online migrations
type BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput interface {
	AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError, bool)
	AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError, bool)
	AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel, bool)
	AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel, bool)
	AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel, bool)
	AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput, bool)
}

// MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput output for the task that migrates PostgreSQL databases
// to Azure Database for PostgreSQL for online migrations
type MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput struct {
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput', 'ResultTypeDatabaseLevelErrorOutput', 'ResultTypeErrorOutput', 'ResultTypeTableLevelOutput', 'ResultTypeDatabaseLevelOutput', 'ResultTypeMigrationLevelOutput'
	ResultType ResultType `json:"resultType,omitempty"`
}

func unmarshalBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput(body []byte) (BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["resultType"] {
	case string(ResultTypeDatabaseLevelErrorOutput):
		var mpsadfpsstode MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError
		err := json.Unmarshal(body, &mpsadfpsstode)
		return mpsadfpsstode, err
	case string(ResultTypeErrorOutput):
		var mpsadfpsstoe MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError
		err := json.Unmarshal(body, &mpsadfpsstoe)
		return mpsadfpsstoe, err
	case string(ResultTypeTableLevelOutput):
		var mpsadfpsstotl MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel
		err := json.Unmarshal(body, &mpsadfpsstotl)
		return mpsadfpsstotl, err
	case string(ResultTypeDatabaseLevelOutput):
		var mpsadfpsstodl MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel
		err := json.Unmarshal(body, &mpsadfpsstodl)
		return mpsadfpsstodl, err
	case string(ResultTypeMigrationLevelOutput):
		var mpsadfpsstoml MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel
		err := json.Unmarshal(body, &mpsadfpsstoml)
		return mpsadfpsstoml, err
	default:
		var mpsadfpssto MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput
		err := json.Unmarshal(body, &mpsadfpssto)
		return mpsadfpssto, err
	}
}
func unmarshalBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputArray(body []byte) ([]BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	mpsadfpsstoArray := make([]BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput, len(rawMessages))

	for index, rawMessage := range rawMessages {
		mpsadfpssto, err := unmarshalBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput(*rawMessage)
		if err != nil {
			return nil, err
		}
		mpsadfpsstoArray[index] = mpsadfpssto
	}
	return mpsadfpsstoArray, nil
}

// MarshalJSON is the custom marshaler for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput.
func (mpsadfpssto MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput) MarshalJSON() ([]byte, error) {
	mpsadfpssto.ResultType = ResultTypeMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput
	objectMap := make(map[string]interface{})
	if mpsadfpssto.ResultType != "" {
		objectMap["resultType"] = mpsadfpssto.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput.
func (mpsadfpssto MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput.
func (mpsadfpssto MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput.
func (mpsadfpssto MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput.
func (mpsadfpssto MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput.
func (mpsadfpssto MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput.
func (mpsadfpssto MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput, bool) {
	return &mpsadfpssto, true
}

// AsBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput.
func (mpsadfpssto MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput) AsBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput() (BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput, bool) {
	return &mpsadfpssto, true
}

// MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError ...
type MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError struct {
	// ErrorMessage - Error message
	ErrorMessage *string `json:"errorMessage,omitempty"`
	// Events - List of error events.
	Events *[]SyncMigrationDatabaseErrorEvent `json:"events,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput', 'ResultTypeDatabaseLevelErrorOutput', 'ResultTypeErrorOutput', 'ResultTypeTableLevelOutput', 'ResultTypeDatabaseLevelOutput', 'ResultTypeMigrationLevelOutput'
	ResultType ResultType `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError.
func (mpsadfpsstode MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError) MarshalJSON() ([]byte, error) {
	mpsadfpsstode.ResultType = ResultTypeDatabaseLevelErrorOutput
	objectMap := make(map[string]interface{})
	if mpsadfpsstode.ErrorMessage != nil {
		objectMap["errorMessage"] = mpsadfpsstode.ErrorMessage
	}
	if mpsadfpsstode.Events != nil {
		objectMap["events"] = mpsadfpsstode.Events
	}
	if mpsadfpsstode.ResultType != "" {
		objectMap["resultType"] = mpsadfpsstode.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError.
func (mpsadfpsstode MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError, bool) {
	return &mpsadfpsstode, true
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError.
func (mpsadfpsstode MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError.
func (mpsadfpsstode MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError.
func (mpsadfpsstode MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError.
func (mpsadfpsstode MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError.
func (mpsadfpsstode MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput, bool) {
	return nil, false
}

// AsBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError.
func (mpsadfpsstode MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError) AsBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput() (BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput, bool) {
	return &mpsadfpsstode, true
}

// MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel ...
type MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel struct {
	// DatabaseName - READ-ONLY; Name of the database
	DatabaseName *string `json:"databaseName,omitempty"`
	// StartedOn - READ-ONLY; Migration start time
	StartedOn *date.Time `json:"startedOn,omitempty"`
	// EndedOn - READ-ONLY; Migration end time
	EndedOn *date.Time `json:"endedOn,omitempty"`
	// MigrationState - READ-ONLY; Migration state that this database is in. Possible values include: 'SyncDatabaseMigrationReportingStateUNDEFINED', 'SyncDatabaseMigrationReportingStateCONFIGURING', 'SyncDatabaseMigrationReportingStateINITIALIAZING', 'SyncDatabaseMigrationReportingStateSTARTING', 'SyncDatabaseMigrationReportingStateRUNNING', 'SyncDatabaseMigrationReportingStateREADYTOCOMPLETE', 'SyncDatabaseMigrationReportingStateCOMPLETING', 'SyncDatabaseMigrationReportingStateCOMPLETE', 'SyncDatabaseMigrationReportingStateCANCELLING', 'SyncDatabaseMigrationReportingStateCANCELLED', 'SyncDatabaseMigrationReportingStateFAILED'
	MigrationState SyncDatabaseMigrationReportingState `json:"migrationState,omitempty"`
	// IncomingChanges - READ-ONLY; Number of incoming changes
	IncomingChanges *int64 `json:"incomingChanges,omitempty"`
	// AppliedChanges - READ-ONLY; Number of applied changes
	AppliedChanges *int64 `json:"appliedChanges,omitempty"`
	// CdcInsertCounter - READ-ONLY; Number of cdc inserts
	CdcInsertCounter *int64 `json:"cdcInsertCounter,omitempty"`
	// CdcDeleteCounter - READ-ONLY; Number of cdc deletes
	CdcDeleteCounter *int64 `json:"cdcDeleteCounter,omitempty"`
	// CdcUpdateCounter - READ-ONLY; Number of cdc updates
	CdcUpdateCounter *int64 `json:"cdcUpdateCounter,omitempty"`
	// FullLoadCompletedTables - READ-ONLY; Number of tables completed in full load
	FullLoadCompletedTables *int64 `json:"fullLoadCompletedTables,omitempty"`
	// FullLoadLoadingTables - READ-ONLY; Number of tables loading in full load
	FullLoadLoadingTables *int64 `json:"fullLoadLoadingTables,omitempty"`
	// FullLoadQueuedTables - READ-ONLY; Number of tables queued in full load
	FullLoadQueuedTables *int64 `json:"fullLoadQueuedTables,omitempty"`
	// FullLoadErroredTables - READ-ONLY; Number of tables errored in full load
	FullLoadErroredTables *int64 `json:"fullLoadErroredTables,omitempty"`
	// InitializationCompleted - READ-ONLY; Indicates if initial load (full load) has been completed
	InitializationCompleted *bool `json:"initializationCompleted,omitempty"`
	// Latency - READ-ONLY; CDC apply latency
	Latency *int64 `json:"latency,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput', 'ResultTypeDatabaseLevelErrorOutput', 'ResultTypeErrorOutput', 'ResultTypeTableLevelOutput', 'ResultTypeDatabaseLevelOutput', 'ResultTypeMigrationLevelOutput'
	ResultType ResultType `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel.
func (mpsadfpsstodl MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel) MarshalJSON() ([]byte, error) {
	mpsadfpsstodl.ResultType = ResultTypeDatabaseLevelOutput
	objectMap := make(map[string]interface{})
	if mpsadfpsstodl.ResultType != "" {
		objectMap["resultType"] = mpsadfpsstodl.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel.
func (mpsadfpsstodl MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel.
func (mpsadfpsstodl MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel.
func (mpsadfpsstodl MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel.
func (mpsadfpsstodl MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel, bool) {
	return &mpsadfpsstodl, true
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel.
func (mpsadfpsstodl MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel.
func (mpsadfpsstodl MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput, bool) {
	return nil, false
}

// AsBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel.
func (mpsadfpsstodl MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel) AsBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput() (BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput, bool) {
	return &mpsadfpsstodl, true
}

// MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError ...
type MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError struct {
	// Error - READ-ONLY; Migration error
	Error *ReportableException `json:"error,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput', 'ResultTypeDatabaseLevelErrorOutput', 'ResultTypeErrorOutput', 'ResultTypeTableLevelOutput', 'ResultTypeDatabaseLevelOutput', 'ResultTypeMigrationLevelOutput'
	ResultType ResultType `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError.
func (mpsadfpsstoe MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError) MarshalJSON() ([]byte, error) {
	mpsadfpsstoe.ResultType = ResultTypeErrorOutput
	objectMap := make(map[string]interface{})
	if mpsadfpsstoe.ResultType != "" {
		objectMap["resultType"] = mpsadfpsstoe.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError.
func (mpsadfpsstoe MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError.
func (mpsadfpsstoe MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError, bool) {
	return &mpsadfpsstoe, true
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError.
func (mpsadfpsstoe MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError.
func (mpsadfpsstoe MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError.
func (mpsadfpsstoe MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError.
func (mpsadfpsstoe MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput, bool) {
	return nil, false
}

// AsBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError.
func (mpsadfpsstoe MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError) AsBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput() (BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput, bool) {
	return &mpsadfpsstoe, true
}

// MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel ...
type MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel struct {
	// StartedOn - READ-ONLY; Migration start time
	StartedOn *date.Time `json:"startedOn,omitempty"`
	// EndedOn - READ-ONLY; Migration end time
	EndedOn *date.Time `json:"endedOn,omitempty"`
	// SourceServerVersion - READ-ONLY; Source server version
	SourceServerVersion *string `json:"sourceServerVersion,omitempty"`
	// SourceServer - READ-ONLY; Source server name
	SourceServer *string `json:"sourceServer,omitempty"`
	// TargetServerVersion - READ-ONLY; Target server version
	TargetServerVersion *string `json:"targetServerVersion,omitempty"`
	// TargetServer - READ-ONLY; Target server name
	TargetServer *string `json:"targetServer,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput', 'ResultTypeDatabaseLevelErrorOutput', 'ResultTypeErrorOutput', 'ResultTypeTableLevelOutput', 'ResultTypeDatabaseLevelOutput', 'ResultTypeMigrationLevelOutput'
	ResultType ResultType `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel.
func (mpsadfpsstoml MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel) MarshalJSON() ([]byte, error) {
	mpsadfpsstoml.ResultType = ResultTypeMigrationLevelOutput
	objectMap := make(map[string]interface{})
	if mpsadfpsstoml.ResultType != "" {
		objectMap["resultType"] = mpsadfpsstoml.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel.
func (mpsadfpsstoml MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel.
func (mpsadfpsstoml MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel.
func (mpsadfpsstoml MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel.
func (mpsadfpsstoml MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel.
func (mpsadfpsstoml MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel, bool) {
	return &mpsadfpsstoml, true
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel.
func (mpsadfpsstoml MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput, bool) {
	return nil, false
}

// AsBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel.
func (mpsadfpsstoml MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel) AsBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput() (BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput, bool) {
	return &mpsadfpsstoml, true
}

// MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel ...
type MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel struct {
	// TableName - READ-ONLY; Name of the table
	TableName *string `json:"tableName,omitempty"`
	// DatabaseName - READ-ONLY; Name of the database
	DatabaseName *string `json:"databaseName,omitempty"`
	// CdcInsertCounter - READ-ONLY; Number of applied inserts
	CdcInsertCounter *int64 `json:"cdcInsertCounter,omitempty"`
	// CdcUpdateCounter - READ-ONLY; Number of applied updates
	CdcUpdateCounter *int64 `json:"cdcUpdateCounter,omitempty"`
	// CdcDeleteCounter - READ-ONLY; Number of applied deletes
	CdcDeleteCounter *int64 `json:"cdcDeleteCounter,omitempty"`
	// FullLoadEstFinishTime - READ-ONLY; Estimate to finish full load
	FullLoadEstFinishTime *date.Time `json:"fullLoadEstFinishTime,omitempty"`
	// FullLoadStartedOn - READ-ONLY; Full load start time
	FullLoadStartedOn *date.Time `json:"fullLoadStartedOn,omitempty"`
	// FullLoadEndedOn - READ-ONLY; Full load end time
	FullLoadEndedOn *date.Time `json:"fullLoadEndedOn,omitempty"`
	// FullLoadTotalRows - READ-ONLY; Number of rows applied in full load
	FullLoadTotalRows *int64 `json:"fullLoadTotalRows,omitempty"`
	// State - READ-ONLY; Current state of the table migration. Possible values include: 'SyncTableMigrationStateBEFORELOAD', 'SyncTableMigrationStateFULLLOAD', 'SyncTableMigrationStateCOMPLETED', 'SyncTableMigrationStateCANCELED', 'SyncTableMigrationStateERROR', 'SyncTableMigrationStateFAILED'
	State SyncTableMigrationState `json:"state,omitempty"`
	// TotalChangesApplied - READ-ONLY; Total number of applied changes
	TotalChangesApplied *int64 `json:"totalChangesApplied,omitempty"`
	// DataErrorsCounter - READ-ONLY; Number of data errors occurred
	DataErrorsCounter *int64 `json:"dataErrorsCounter,omitempty"`
	// LastModifiedTime - READ-ONLY; Last modified time on target
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput', 'ResultTypeDatabaseLevelErrorOutput', 'ResultTypeErrorOutput', 'ResultTypeTableLevelOutput', 'ResultTypeDatabaseLevelOutput', 'ResultTypeMigrationLevelOutput'
	ResultType ResultType `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel.
func (mpsadfpsstotl MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel) MarshalJSON() ([]byte, error) {
	mpsadfpsstotl.ResultType = ResultTypeTableLevelOutput
	objectMap := make(map[string]interface{})
	if mpsadfpsstotl.ResultType != "" {
		objectMap["resultType"] = mpsadfpsstotl.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel.
func (mpsadfpsstotl MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseError, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel.
func (mpsadfpsstotl MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputError, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel.
func (mpsadfpsstotl MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel, bool) {
	return &mpsadfpsstotl, true
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel.
func (mpsadfpsstotl MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel.
func (mpsadfpsstotl MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputMigrationLevel, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel.
func (mpsadfpsstotl MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput, bool) {
	return nil, false
}

// AsBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput is the BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel.
func (mpsadfpsstotl MigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputTableLevel) AsBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput() (BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput, bool) {
	return &mpsadfpsstotl, true
}

// MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties properties for the task that migrates PostgreSQL
// databases to Azure Database for PostgreSQL for online migrations
type MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties struct {
	// Input - Task input
	Input *MigratePostgreSQLAzureDbForPostgreSQLSyncTaskInput `json:"input,omitempty"`
	// Output - READ-ONLY; Task output. This is ignored if submitted.
	Output *[]BasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutput `json:"output,omitempty"`
	// Errors - READ-ONLY; Array of errors. This is ignored if submitted.
	Errors *[]ODataError `json:"errors,omitempty"`
	// State - READ-ONLY; The state of the task. This is ignored if submitted. Possible values include: 'TaskStateUnknown', 'TaskStateQueued', 'TaskStateRunning', 'TaskStateCanceled', 'TaskStateSucceeded', 'TaskStateFailed', 'TaskStateFailedInputValidation', 'TaskStateFaulted'
	State TaskState `json:"state,omitempty"`
	// Commands - READ-ONLY; Array of command properties.
	Commands *[]BasicCommandProperties `json:"commands,omitempty"`
	// TaskType - Possible values include: 'TaskTypeUnknown', 'TaskTypeGetTDECertificatesSQL', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMISyncLRS', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMI', 'TaskTypeValidateMigrationInputSQLServerSQLDbSync', 'TaskTypeMigratePostgreSQLAzureDbForPostgreSQLSync', 'TaskTypeMigrateMySQLAzureDbForMySQLSync', 'TaskTypeMigrateSQLServerAzureSQLDbSync', 'TaskTypeMigrateSQLServerSQLDb', 'TaskTypeMigrateSQLServerAzureSQLDbMISyncLRS', 'TaskTypeMigrateSQLServerAzureSQLDbMI', 'TaskTypeConnectToTargetAzureDbForMySQL', 'TaskTypeConnectToTargetAzureSQLDbMISyncLRS', 'TaskTypeConnectToTargetAzureSQLDbMI', 'TaskTypeGetUserTablesAzureSQLDbSync', 'TaskTypeGetUserTablesSQL', 'TaskTypeConnectToTargetAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetSQLDbSync', 'TaskTypeConnectToTargetSQLDb', 'TaskTypeConnectToSourcePostgreSQLSync', 'TaskTypeConnectToSourceSQLServerSync', 'TaskTypeConnectToSourceSQLServer', 'TaskTypeConnectToSourceMySQL'
	TaskType TaskType `json:"taskType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties.
func (mpsadfpsstp MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties) MarshalJSON() ([]byte, error) {
	mpsadfpsstp.TaskType = TaskTypeMigratePostgreSQLAzureDbForPostgreSQLSync
	objectMap := make(map[string]interface{})
	if mpsadfpsstp.Input != nil {
		objectMap["input"] = mpsadfpsstp.Input
	}
	if mpsadfpsstp.TaskType != "" {
		objectMap["taskType"] = mpsadfpsstp.TaskType
	}
	return json.Marshal(objectMap)
}

// AsGetTdeCertificatesSQLTaskProperties is the BasicProjectTaskProperties implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties.
func (mpsadfpsstp MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties) AsGetTdeCertificatesSQLTaskProperties() (*GetTdeCertificatesSQLTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties.
func (mpsadfpsstp MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties) AsValidateMigrationInputSQLServerSQLMISyncTaskProperties() (*ValidateMigrationInputSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties.
func (mpsadfpsstp MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties) AsValidateMigrationInputSQLServerSQLMITaskProperties() (*ValidateMigrationInputSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties.
func (mpsadfpsstp MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties) AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties() (*ValidateMigrationInputSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties.
func (mpsadfpsstp MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return &mpsadfpsstp, true
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties.
func (mpsadfpsstp MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties) AsMigrateMySQLAzureDbForMySQLSyncTaskProperties() (*MigrateMySQLAzureDbForMySQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties.
func (mpsadfpsstp MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties) AsMigrateSQLServerSQLDbSyncTaskProperties() (*MigrateSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties.
func (mpsadfpsstp MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties) AsMigrateSQLServerSQLDbTaskProperties() (*MigrateSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties.
func (mpsadfpsstp MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties) AsMigrateSQLServerSQLMISyncTaskProperties() (*MigrateSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties.
func (mpsadfpsstp MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties) AsMigrateSQLServerSQLMITaskProperties() (*MigrateSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForMySQLTaskProperties is the BasicProjectTaskProperties implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties.
func (mpsadfpsstp MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties) AsConnectToTargetAzureDbForMySQLTaskProperties() (*ConnectToTargetAzureDbForMySQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties.
func (mpsadfpsstp MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties) AsConnectToTargetSQLMISyncTaskProperties() (*ConnectToTargetSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMITaskProperties is the BasicProjectTaskProperties implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties.
func (mpsadfpsstp MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties) AsConnectToTargetSQLMITaskProperties() (*ConnectToTargetSQLMITaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties.
func (mpsadfpsstp MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties) AsGetUserTablesSQLSyncTaskProperties() (*GetUserTablesSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLTaskProperties is the BasicProjectTaskProperties implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties.
func (mpsadfpsstp MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties) AsGetUserTablesSQLTaskProperties() (*GetUserTablesSQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties.
func (mpsadfpsstp MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties) AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties.
func (mpsadfpsstp MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties) AsConnectToTargetSQLSQLDbSyncTaskProperties() (*ConnectToTargetSQLSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLDbTaskProperties is the BasicProjectTaskProperties implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties.
func (mpsadfpsstp MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties) AsConnectToTargetSQLDbTaskProperties() (*ConnectToTargetSQLDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourcePostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties.
func (mpsadfpsstp MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties) AsConnectToSourcePostgreSQLSyncTaskProperties() (*ConnectToSourcePostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerSyncTaskProperties is the BasicProjectTaskProperties implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties.
func (mpsadfpsstp MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties) AsConnectToSourceSQLServerSyncTaskProperties() (*ConnectToSourceSQLServerSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskProperties is the BasicProjectTaskProperties implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties.
func (mpsadfpsstp MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties) AsConnectToSourceSQLServerTaskProperties() (*ConnectToSourceSQLServerTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceMySQLTaskProperties is the BasicProjectTaskProperties implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties.
func (mpsadfpsstp MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties) AsConnectToSourceMySQLTaskProperties() (*ConnectToSourceMySQLTaskProperties, bool) {
	return nil, false
}

// AsProjectTaskProperties is the BasicProjectTaskProperties implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties.
func (mpsadfpsstp MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties) AsProjectTaskProperties() (*ProjectTaskProperties, bool) {
	return nil, false
}

// AsBasicProjectTaskProperties is the BasicProjectTaskProperties implementation for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties.
func (mpsadfpsstp MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties) AsBasicProjectTaskProperties() (BasicProjectTaskProperties, bool) {
	return &mpsadfpsstp, true
}

// UnmarshalJSON is the custom unmarshaler for MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties struct.
func (mpsadfpsstp *MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "input":
			if v != nil {
				var input MigratePostgreSQLAzureDbForPostgreSQLSyncTaskInput
				err = json.Unmarshal(*v, &input)
				if err != nil {
					return err
				}
				mpsadfpsstp.Input = &input
			}
		case "output":
			if v != nil {
				output, err := unmarshalBasicMigratePostgreSQLAzureDbForPostgreSQLSyncTaskOutputArray(*v)
				if err != nil {
					return err
				}
				mpsadfpsstp.Output = &output
			}
		case "errors":
			if v != nil {
				var errorsVar []ODataError
				err = json.Unmarshal(*v, &errorsVar)
				if err != nil {
					return err
				}
				mpsadfpsstp.Errors = &errorsVar
			}
		case "state":
			if v != nil {
				var state TaskState
				err = json.Unmarshal(*v, &state)
				if err != nil {
					return err
				}
				mpsadfpsstp.State = state
			}
		case "commands":
			if v != nil {
				commands, err := unmarshalBasicCommandPropertiesArray(*v)
				if err != nil {
					return err
				}
				mpsadfpsstp.Commands = &commands
			}
		case "taskType":
			if v != nil {
				var taskType TaskType
				err = json.Unmarshal(*v, &taskType)
				if err != nil {
					return err
				}
				mpsadfpsstp.TaskType = taskType
			}
		}
	}

	return nil
}

// MigrateSQLServerSQLDbDatabaseInput database specific information for SQL to Azure SQL DB migration task
// inputs
type MigrateSQLServerSQLDbDatabaseInput struct {
	// Name - Name of the database
	Name *string `json:"name,omitempty"`
	// TargetDatabaseName - Name of target database. Note: Target database will be truncated before starting migration.
	TargetDatabaseName *string `json:"targetDatabaseName,omitempty"`
	// MakeSourceDbReadOnly - Whether to set database read only before migration
	MakeSourceDbReadOnly *bool `json:"makeSourceDbReadOnly,omitempty"`
	// TableMap - Mapping of source to target tables
	TableMap map[string]*string `json:"tableMap"`
}

// MarshalJSON is the custom marshaler for MigrateSQLServerSQLDbDatabaseInput.
func (msssddi MigrateSQLServerSQLDbDatabaseInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if msssddi.Name != nil {
		objectMap["name"] = msssddi.Name
	}
	if msssddi.TargetDatabaseName != nil {
		objectMap["targetDatabaseName"] = msssddi.TargetDatabaseName
	}
	if msssddi.MakeSourceDbReadOnly != nil {
		objectMap["makeSourceDbReadOnly"] = msssddi.MakeSourceDbReadOnly
	}
	if msssddi.TableMap != nil {
		objectMap["tableMap"] = msssddi.TableMap
	}
	return json.Marshal(objectMap)
}

// MigrateSQLServerSQLDbSyncDatabaseInput database specific information for SQL to Azure SQL DB sync
// migration task inputs
type MigrateSQLServerSQLDbSyncDatabaseInput struct {
	// ID - Unique identifier for database
	ID *string `json:"id,omitempty"`
	// Name - Name of database
	Name *string `json:"name,omitempty"`
	// TargetDatabaseName - Target database name
	TargetDatabaseName *string `json:"targetDatabaseName,omitempty"`
	// SchemaName - Schema name to be migrated
	SchemaName *string `json:"schemaName,omitempty"`
	// TableMap - Mapping of source to target tables
	TableMap map[string]*string `json:"tableMap"`
	// MigrationSetting - Migration settings which tune the migration behavior
	MigrationSetting map[string]*string `json:"migrationSetting"`
	// SourceSetting - Source settings to tune source endpoint migration behavior
	SourceSetting map[string]*string `json:"sourceSetting"`
	// TargetSetting - Target settings to tune target endpoint migration behavior
	TargetSetting map[string]*string `json:"targetSetting"`
}

// MarshalJSON is the custom marshaler for MigrateSQLServerSQLDbSyncDatabaseInput.
func (msssdsdi MigrateSQLServerSQLDbSyncDatabaseInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if msssdsdi.ID != nil {
		objectMap["id"] = msssdsdi.ID
	}
	if msssdsdi.Name != nil {
		objectMap["name"] = msssdsdi.Name
	}
	if msssdsdi.TargetDatabaseName != nil {
		objectMap["targetDatabaseName"] = msssdsdi.TargetDatabaseName
	}
	if msssdsdi.SchemaName != nil {
		objectMap["schemaName"] = msssdsdi.SchemaName
	}
	if msssdsdi.TableMap != nil {
		objectMap["tableMap"] = msssdsdi.TableMap
	}
	if msssdsdi.MigrationSetting != nil {
		objectMap["migrationSetting"] = msssdsdi.MigrationSetting
	}
	if msssdsdi.SourceSetting != nil {
		objectMap["sourceSetting"] = msssdsdi.SourceSetting
	}
	if msssdsdi.TargetSetting != nil {
		objectMap["targetSetting"] = msssdsdi.TargetSetting
	}
	return json.Marshal(objectMap)
}

// MigrateSQLServerSQLDbSyncTaskInput input for the task that migrates on-prem SQL Server databases to
// Azure SQL Database for online migrations
type MigrateSQLServerSQLDbSyncTaskInput struct {
	// SelectedDatabases - Databases to migrate
	SelectedDatabases *[]MigrateSQLServerSQLDbSyncDatabaseInput `json:"selectedDatabases,omitempty"`
	// ValidationOptions - Validation options
	ValidationOptions *MigrationValidationOptions `json:"validationOptions,omitempty"`
	// SourceConnectionInfo - Information for connecting to source
	SourceConnectionInfo *SQLConnectionInfo `json:"sourceConnectionInfo,omitempty"`
	// TargetConnectionInfo - Information for connecting to target
	TargetConnectionInfo *SQLConnectionInfo `json:"targetConnectionInfo,omitempty"`
}

// BasicMigrateSQLServerSQLDbSyncTaskOutput output for the task that migrates on-prem SQL Server databases to Azure SQL
// Database for online migrations
type BasicMigrateSQLServerSQLDbSyncTaskOutput interface {
	AsMigrateSQLServerSQLDbSyncTaskOutputDatabaseError() (*MigrateSQLServerSQLDbSyncTaskOutputDatabaseError, bool)
	AsMigrateSQLServerSQLDbSyncTaskOutputError() (*MigrateSQLServerSQLDbSyncTaskOutputError, bool)
	AsMigrateSQLServerSQLDbSyncTaskOutputTableLevel() (*MigrateSQLServerSQLDbSyncTaskOutputTableLevel, bool)
	AsMigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel() (*MigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel, bool)
	AsMigrateSQLServerSQLDbSyncTaskOutputMigrationLevel() (*MigrateSQLServerSQLDbSyncTaskOutputMigrationLevel, bool)
	AsMigrateSQLServerSQLDbSyncTaskOutput() (*MigrateSQLServerSQLDbSyncTaskOutput, bool)
}

// MigrateSQLServerSQLDbSyncTaskOutput output for the task that migrates on-prem SQL Server databases to Azure
// SQL Database for online migrations
type MigrateSQLServerSQLDbSyncTaskOutput struct {
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeMigrateSQLServerSQLDbSyncTaskOutput', 'ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeDatabaseLevelErrorOutput', 'ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeErrorOutput', 'ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeTableLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeMigrationLevelOutput'
	ResultType ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutput `json:"resultType,omitempty"`
}

func unmarshalBasicMigrateSQLServerSQLDbSyncTaskOutput(body []byte) (BasicMigrateSQLServerSQLDbSyncTaskOutput, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["resultType"] {
	case string(ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeDatabaseLevelErrorOutput):
		var msssdstode MigrateSQLServerSQLDbSyncTaskOutputDatabaseError
		err := json.Unmarshal(body, &msssdstode)
		return msssdstode, err
	case string(ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeErrorOutput):
		var msssdstoe MigrateSQLServerSQLDbSyncTaskOutputError
		err := json.Unmarshal(body, &msssdstoe)
		return msssdstoe, err
	case string(ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeTableLevelOutput):
		var msssdstotl MigrateSQLServerSQLDbSyncTaskOutputTableLevel
		err := json.Unmarshal(body, &msssdstotl)
		return msssdstotl, err
	case string(ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeDatabaseLevelOutput):
		var msssdstodl MigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel
		err := json.Unmarshal(body, &msssdstodl)
		return msssdstodl, err
	case string(ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeMigrationLevelOutput):
		var msssdstoml MigrateSQLServerSQLDbSyncTaskOutputMigrationLevel
		err := json.Unmarshal(body, &msssdstoml)
		return msssdstoml, err
	default:
		var msssdsto MigrateSQLServerSQLDbSyncTaskOutput
		err := json.Unmarshal(body, &msssdsto)
		return msssdsto, err
	}
}
func unmarshalBasicMigrateSQLServerSQLDbSyncTaskOutputArray(body []byte) ([]BasicMigrateSQLServerSQLDbSyncTaskOutput, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	msssdstoArray := make([]BasicMigrateSQLServerSQLDbSyncTaskOutput, len(rawMessages))

	for index, rawMessage := range rawMessages {
		msssdsto, err := unmarshalBasicMigrateSQLServerSQLDbSyncTaskOutput(*rawMessage)
		if err != nil {
			return nil, err
		}
		msssdstoArray[index] = msssdsto
	}
	return msssdstoArray, nil
}

// MarshalJSON is the custom marshaler for MigrateSQLServerSQLDbSyncTaskOutput.
func (msssdsto MigrateSQLServerSQLDbSyncTaskOutput) MarshalJSON() ([]byte, error) {
	msssdsto.ResultType = ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeMigrateSQLServerSQLDbSyncTaskOutput
	objectMap := make(map[string]interface{})
	if msssdsto.ResultType != "" {
		objectMap["resultType"] = msssdsto.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSQLServerSQLDbSyncTaskOutputDatabaseError is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutput.
func (msssdsto MigrateSQLServerSQLDbSyncTaskOutput) AsMigrateSQLServerSQLDbSyncTaskOutputDatabaseError() (*MigrateSQLServerSQLDbSyncTaskOutputDatabaseError, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskOutputError is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutput.
func (msssdsto MigrateSQLServerSQLDbSyncTaskOutput) AsMigrateSQLServerSQLDbSyncTaskOutputError() (*MigrateSQLServerSQLDbSyncTaskOutputError, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskOutputTableLevel is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutput.
func (msssdsto MigrateSQLServerSQLDbSyncTaskOutput) AsMigrateSQLServerSQLDbSyncTaskOutputTableLevel() (*MigrateSQLServerSQLDbSyncTaskOutputTableLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutput.
func (msssdsto MigrateSQLServerSQLDbSyncTaskOutput) AsMigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel() (*MigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskOutputMigrationLevel is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutput.
func (msssdsto MigrateSQLServerSQLDbSyncTaskOutput) AsMigrateSQLServerSQLDbSyncTaskOutputMigrationLevel() (*MigrateSQLServerSQLDbSyncTaskOutputMigrationLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskOutput is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutput.
func (msssdsto MigrateSQLServerSQLDbSyncTaskOutput) AsMigrateSQLServerSQLDbSyncTaskOutput() (*MigrateSQLServerSQLDbSyncTaskOutput, bool) {
	return &msssdsto, true
}

// AsBasicMigrateSQLServerSQLDbSyncTaskOutput is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutput.
func (msssdsto MigrateSQLServerSQLDbSyncTaskOutput) AsBasicMigrateSQLServerSQLDbSyncTaskOutput() (BasicMigrateSQLServerSQLDbSyncTaskOutput, bool) {
	return &msssdsto, true
}

// MigrateSQLServerSQLDbSyncTaskOutputDatabaseError ...
type MigrateSQLServerSQLDbSyncTaskOutputDatabaseError struct {
	// ErrorMessage - Error message
	ErrorMessage *string `json:"errorMessage,omitempty"`
	// Events - List of error events.
	Events *[]SyncMigrationDatabaseErrorEvent `json:"events,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeMigrateSQLServerSQLDbSyncTaskOutput', 'ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeDatabaseLevelErrorOutput', 'ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeErrorOutput', 'ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeTableLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeMigrationLevelOutput'
	ResultType ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateSQLServerSQLDbSyncTaskOutputDatabaseError.
func (msssdstode MigrateSQLServerSQLDbSyncTaskOutputDatabaseError) MarshalJSON() ([]byte, error) {
	msssdstode.ResultType = ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeDatabaseLevelErrorOutput
	objectMap := make(map[string]interface{})
	if msssdstode.ErrorMessage != nil {
		objectMap["errorMessage"] = msssdstode.ErrorMessage
	}
	if msssdstode.Events != nil {
		objectMap["events"] = msssdstode.Events
	}
	if msssdstode.ResultType != "" {
		objectMap["resultType"] = msssdstode.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSQLServerSQLDbSyncTaskOutputDatabaseError is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutputDatabaseError.
func (msssdstode MigrateSQLServerSQLDbSyncTaskOutputDatabaseError) AsMigrateSQLServerSQLDbSyncTaskOutputDatabaseError() (*MigrateSQLServerSQLDbSyncTaskOutputDatabaseError, bool) {
	return &msssdstode, true
}

// AsMigrateSQLServerSQLDbSyncTaskOutputError is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutputDatabaseError.
func (msssdstode MigrateSQLServerSQLDbSyncTaskOutputDatabaseError) AsMigrateSQLServerSQLDbSyncTaskOutputError() (*MigrateSQLServerSQLDbSyncTaskOutputError, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskOutputTableLevel is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutputDatabaseError.
func (msssdstode MigrateSQLServerSQLDbSyncTaskOutputDatabaseError) AsMigrateSQLServerSQLDbSyncTaskOutputTableLevel() (*MigrateSQLServerSQLDbSyncTaskOutputTableLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutputDatabaseError.
func (msssdstode MigrateSQLServerSQLDbSyncTaskOutputDatabaseError) AsMigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel() (*MigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskOutputMigrationLevel is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutputDatabaseError.
func (msssdstode MigrateSQLServerSQLDbSyncTaskOutputDatabaseError) AsMigrateSQLServerSQLDbSyncTaskOutputMigrationLevel() (*MigrateSQLServerSQLDbSyncTaskOutputMigrationLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskOutput is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutputDatabaseError.
func (msssdstode MigrateSQLServerSQLDbSyncTaskOutputDatabaseError) AsMigrateSQLServerSQLDbSyncTaskOutput() (*MigrateSQLServerSQLDbSyncTaskOutput, bool) {
	return nil, false
}

// AsBasicMigrateSQLServerSQLDbSyncTaskOutput is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutputDatabaseError.
func (msssdstode MigrateSQLServerSQLDbSyncTaskOutputDatabaseError) AsBasicMigrateSQLServerSQLDbSyncTaskOutput() (BasicMigrateSQLServerSQLDbSyncTaskOutput, bool) {
	return &msssdstode, true
}

// MigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel ...
type MigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel struct {
	// DatabaseName - READ-ONLY; Name of the database
	DatabaseName *string `json:"databaseName,omitempty"`
	// StartedOn - READ-ONLY; Migration start time
	StartedOn *date.Time `json:"startedOn,omitempty"`
	// EndedOn - READ-ONLY; Migration end time
	EndedOn *date.Time `json:"endedOn,omitempty"`
	// MigrationState - READ-ONLY; Migration state that this database is in. Possible values include: 'SyncDatabaseMigrationReportingStateUNDEFINED', 'SyncDatabaseMigrationReportingStateCONFIGURING', 'SyncDatabaseMigrationReportingStateINITIALIAZING', 'SyncDatabaseMigrationReportingStateSTARTING', 'SyncDatabaseMigrationReportingStateRUNNING', 'SyncDatabaseMigrationReportingStateREADYTOCOMPLETE', 'SyncDatabaseMigrationReportingStateCOMPLETING', 'SyncDatabaseMigrationReportingStateCOMPLETE', 'SyncDatabaseMigrationReportingStateCANCELLING', 'SyncDatabaseMigrationReportingStateCANCELLED', 'SyncDatabaseMigrationReportingStateFAILED'
	MigrationState SyncDatabaseMigrationReportingState `json:"migrationState,omitempty"`
	// IncomingChanges - READ-ONLY; Number of incoming changes
	IncomingChanges *int64 `json:"incomingChanges,omitempty"`
	// AppliedChanges - READ-ONLY; Number of applied changes
	AppliedChanges *int64 `json:"appliedChanges,omitempty"`
	// CdcInsertCounter - READ-ONLY; Number of cdc inserts
	CdcInsertCounter *int64 `json:"cdcInsertCounter,omitempty"`
	// CdcDeleteCounter - READ-ONLY; Number of cdc deletes
	CdcDeleteCounter *int64 `json:"cdcDeleteCounter,omitempty"`
	// CdcUpdateCounter - READ-ONLY; Number of cdc updates
	CdcUpdateCounter *int64 `json:"cdcUpdateCounter,omitempty"`
	// FullLoadCompletedTables - READ-ONLY; Number of tables completed in full load
	FullLoadCompletedTables *int64 `json:"fullLoadCompletedTables,omitempty"`
	// FullLoadLoadingTables - READ-ONLY; Number of tables loading in full load
	FullLoadLoadingTables *int64 `json:"fullLoadLoadingTables,omitempty"`
	// FullLoadQueuedTables - READ-ONLY; Number of tables queued in full load
	FullLoadQueuedTables *int64 `json:"fullLoadQueuedTables,omitempty"`
	// FullLoadErroredTables - READ-ONLY; Number of tables errored in full load
	FullLoadErroredTables *int64 `json:"fullLoadErroredTables,omitempty"`
	// InitializationCompleted - READ-ONLY; Indicates if initial load (full load) has been completed
	InitializationCompleted *bool `json:"initializationCompleted,omitempty"`
	// Latency - READ-ONLY; CDC apply latency
	Latency *int64 `json:"latency,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeMigrateSQLServerSQLDbSyncTaskOutput', 'ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeDatabaseLevelErrorOutput', 'ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeErrorOutput', 'ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeTableLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeMigrationLevelOutput'
	ResultType ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel.
func (msssdstodl MigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel) MarshalJSON() ([]byte, error) {
	msssdstodl.ResultType = ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeDatabaseLevelOutput
	objectMap := make(map[string]interface{})
	if msssdstodl.ResultType != "" {
		objectMap["resultType"] = msssdstodl.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSQLServerSQLDbSyncTaskOutputDatabaseError is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel.
func (msssdstodl MigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel) AsMigrateSQLServerSQLDbSyncTaskOutputDatabaseError() (*MigrateSQLServerSQLDbSyncTaskOutputDatabaseError, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskOutputError is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel.
func (msssdstodl MigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel) AsMigrateSQLServerSQLDbSyncTaskOutputError() (*MigrateSQLServerSQLDbSyncTaskOutputError, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskOutputTableLevel is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel.
func (msssdstodl MigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel) AsMigrateSQLServerSQLDbSyncTaskOutputTableLevel() (*MigrateSQLServerSQLDbSyncTaskOutputTableLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel.
func (msssdstodl MigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel) AsMigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel() (*MigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel, bool) {
	return &msssdstodl, true
}

// AsMigrateSQLServerSQLDbSyncTaskOutputMigrationLevel is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel.
func (msssdstodl MigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel) AsMigrateSQLServerSQLDbSyncTaskOutputMigrationLevel() (*MigrateSQLServerSQLDbSyncTaskOutputMigrationLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskOutput is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel.
func (msssdstodl MigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel) AsMigrateSQLServerSQLDbSyncTaskOutput() (*MigrateSQLServerSQLDbSyncTaskOutput, bool) {
	return nil, false
}

// AsBasicMigrateSQLServerSQLDbSyncTaskOutput is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel.
func (msssdstodl MigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel) AsBasicMigrateSQLServerSQLDbSyncTaskOutput() (BasicMigrateSQLServerSQLDbSyncTaskOutput, bool) {
	return &msssdstodl, true
}

// MigrateSQLServerSQLDbSyncTaskOutputError ...
type MigrateSQLServerSQLDbSyncTaskOutputError struct {
	// Error - READ-ONLY; Migration error
	Error *ReportableException `json:"error,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeMigrateSQLServerSQLDbSyncTaskOutput', 'ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeDatabaseLevelErrorOutput', 'ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeErrorOutput', 'ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeTableLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeMigrationLevelOutput'
	ResultType ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateSQLServerSQLDbSyncTaskOutputError.
func (msssdstoe MigrateSQLServerSQLDbSyncTaskOutputError) MarshalJSON() ([]byte, error) {
	msssdstoe.ResultType = ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeErrorOutput
	objectMap := make(map[string]interface{})
	if msssdstoe.ResultType != "" {
		objectMap["resultType"] = msssdstoe.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSQLServerSQLDbSyncTaskOutputDatabaseError is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutputError.
func (msssdstoe MigrateSQLServerSQLDbSyncTaskOutputError) AsMigrateSQLServerSQLDbSyncTaskOutputDatabaseError() (*MigrateSQLServerSQLDbSyncTaskOutputDatabaseError, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskOutputError is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutputError.
func (msssdstoe MigrateSQLServerSQLDbSyncTaskOutputError) AsMigrateSQLServerSQLDbSyncTaskOutputError() (*MigrateSQLServerSQLDbSyncTaskOutputError, bool) {
	return &msssdstoe, true
}

// AsMigrateSQLServerSQLDbSyncTaskOutputTableLevel is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutputError.
func (msssdstoe MigrateSQLServerSQLDbSyncTaskOutputError) AsMigrateSQLServerSQLDbSyncTaskOutputTableLevel() (*MigrateSQLServerSQLDbSyncTaskOutputTableLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutputError.
func (msssdstoe MigrateSQLServerSQLDbSyncTaskOutputError) AsMigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel() (*MigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskOutputMigrationLevel is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutputError.
func (msssdstoe MigrateSQLServerSQLDbSyncTaskOutputError) AsMigrateSQLServerSQLDbSyncTaskOutputMigrationLevel() (*MigrateSQLServerSQLDbSyncTaskOutputMigrationLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskOutput is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutputError.
func (msssdstoe MigrateSQLServerSQLDbSyncTaskOutputError) AsMigrateSQLServerSQLDbSyncTaskOutput() (*MigrateSQLServerSQLDbSyncTaskOutput, bool) {
	return nil, false
}

// AsBasicMigrateSQLServerSQLDbSyncTaskOutput is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutputError.
func (msssdstoe MigrateSQLServerSQLDbSyncTaskOutputError) AsBasicMigrateSQLServerSQLDbSyncTaskOutput() (BasicMigrateSQLServerSQLDbSyncTaskOutput, bool) {
	return &msssdstoe, true
}

// MigrateSQLServerSQLDbSyncTaskOutputMigrationLevel ...
type MigrateSQLServerSQLDbSyncTaskOutputMigrationLevel struct {
	// StartedOn - READ-ONLY; Migration start time
	StartedOn *date.Time `json:"startedOn,omitempty"`
	// EndedOn - READ-ONLY; Migration end time
	EndedOn *date.Time `json:"endedOn,omitempty"`
	// SourceServerVersion - READ-ONLY; Source server version
	SourceServerVersion *string `json:"sourceServerVersion,omitempty"`
	// SourceServer - READ-ONLY; Source server name
	SourceServer *string `json:"sourceServer,omitempty"`
	// TargetServerVersion - READ-ONLY; Target server version
	TargetServerVersion *string `json:"targetServerVersion,omitempty"`
	// TargetServer - READ-ONLY; Target server name
	TargetServer *string `json:"targetServer,omitempty"`
	// DatabaseCount - READ-ONLY; Count of databases
	DatabaseCount *int32 `json:"databaseCount,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeMigrateSQLServerSQLDbSyncTaskOutput', 'ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeDatabaseLevelErrorOutput', 'ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeErrorOutput', 'ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeTableLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeMigrationLevelOutput'
	ResultType ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateSQLServerSQLDbSyncTaskOutputMigrationLevel.
func (msssdstoml MigrateSQLServerSQLDbSyncTaskOutputMigrationLevel) MarshalJSON() ([]byte, error) {
	msssdstoml.ResultType = ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeMigrationLevelOutput
	objectMap := make(map[string]interface{})
	if msssdstoml.ResultType != "" {
		objectMap["resultType"] = msssdstoml.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSQLServerSQLDbSyncTaskOutputDatabaseError is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutputMigrationLevel.
func (msssdstoml MigrateSQLServerSQLDbSyncTaskOutputMigrationLevel) AsMigrateSQLServerSQLDbSyncTaskOutputDatabaseError() (*MigrateSQLServerSQLDbSyncTaskOutputDatabaseError, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskOutputError is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutputMigrationLevel.
func (msssdstoml MigrateSQLServerSQLDbSyncTaskOutputMigrationLevel) AsMigrateSQLServerSQLDbSyncTaskOutputError() (*MigrateSQLServerSQLDbSyncTaskOutputError, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskOutputTableLevel is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutputMigrationLevel.
func (msssdstoml MigrateSQLServerSQLDbSyncTaskOutputMigrationLevel) AsMigrateSQLServerSQLDbSyncTaskOutputTableLevel() (*MigrateSQLServerSQLDbSyncTaskOutputTableLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutputMigrationLevel.
func (msssdstoml MigrateSQLServerSQLDbSyncTaskOutputMigrationLevel) AsMigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel() (*MigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskOutputMigrationLevel is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutputMigrationLevel.
func (msssdstoml MigrateSQLServerSQLDbSyncTaskOutputMigrationLevel) AsMigrateSQLServerSQLDbSyncTaskOutputMigrationLevel() (*MigrateSQLServerSQLDbSyncTaskOutputMigrationLevel, bool) {
	return &msssdstoml, true
}

// AsMigrateSQLServerSQLDbSyncTaskOutput is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutputMigrationLevel.
func (msssdstoml MigrateSQLServerSQLDbSyncTaskOutputMigrationLevel) AsMigrateSQLServerSQLDbSyncTaskOutput() (*MigrateSQLServerSQLDbSyncTaskOutput, bool) {
	return nil, false
}

// AsBasicMigrateSQLServerSQLDbSyncTaskOutput is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutputMigrationLevel.
func (msssdstoml MigrateSQLServerSQLDbSyncTaskOutputMigrationLevel) AsBasicMigrateSQLServerSQLDbSyncTaskOutput() (BasicMigrateSQLServerSQLDbSyncTaskOutput, bool) {
	return &msssdstoml, true
}

// MigrateSQLServerSQLDbSyncTaskOutputTableLevel ...
type MigrateSQLServerSQLDbSyncTaskOutputTableLevel struct {
	// TableName - READ-ONLY; Name of the table
	TableName *string `json:"tableName,omitempty"`
	// DatabaseName - READ-ONLY; Name of the database
	DatabaseName *string `json:"databaseName,omitempty"`
	// CdcInsertCounter - READ-ONLY; Number of applied inserts
	CdcInsertCounter *int64 `json:"cdcInsertCounter,omitempty"`
	// CdcUpdateCounter - READ-ONLY; Number of applied updates
	CdcUpdateCounter *int64 `json:"cdcUpdateCounter,omitempty"`
	// CdcDeleteCounter - READ-ONLY; Number of applied deletes
	CdcDeleteCounter *int64 `json:"cdcDeleteCounter,omitempty"`
	// FullLoadEstFinishTime - READ-ONLY; Estimate to finish full load
	FullLoadEstFinishTime *date.Time `json:"fullLoadEstFinishTime,omitempty"`
	// FullLoadStartedOn - READ-ONLY; Full load start time
	FullLoadStartedOn *date.Time `json:"fullLoadStartedOn,omitempty"`
	// FullLoadEndedOn - READ-ONLY; Full load end time
	FullLoadEndedOn *date.Time `json:"fullLoadEndedOn,omitempty"`
	// FullLoadTotalRows - READ-ONLY; Number of rows applied in full load
	FullLoadTotalRows *int64 `json:"fullLoadTotalRows,omitempty"`
	// State - READ-ONLY; Current state of the table migration. Possible values include: 'SyncTableMigrationStateBEFORELOAD', 'SyncTableMigrationStateFULLLOAD', 'SyncTableMigrationStateCOMPLETED', 'SyncTableMigrationStateCANCELED', 'SyncTableMigrationStateERROR', 'SyncTableMigrationStateFAILED'
	State SyncTableMigrationState `json:"state,omitempty"`
	// TotalChangesApplied - READ-ONLY; Total number of applied changes
	TotalChangesApplied *int64 `json:"totalChangesApplied,omitempty"`
	// DataErrorsCounter - READ-ONLY; Number of data errors occurred
	DataErrorsCounter *int64 `json:"dataErrorsCounter,omitempty"`
	// LastModifiedTime - READ-ONLY; Last modified time on target
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeMigrateSQLServerSQLDbSyncTaskOutput', 'ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeDatabaseLevelErrorOutput', 'ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeErrorOutput', 'ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeTableLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeMigrationLevelOutput'
	ResultType ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateSQLServerSQLDbSyncTaskOutputTableLevel.
func (msssdstotl MigrateSQLServerSQLDbSyncTaskOutputTableLevel) MarshalJSON() ([]byte, error) {
	msssdstotl.ResultType = ResultTypeBasicMigrateSQLServerSQLDbSyncTaskOutputResultTypeTableLevelOutput
	objectMap := make(map[string]interface{})
	if msssdstotl.ResultType != "" {
		objectMap["resultType"] = msssdstotl.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSQLServerSQLDbSyncTaskOutputDatabaseError is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutputTableLevel.
func (msssdstotl MigrateSQLServerSQLDbSyncTaskOutputTableLevel) AsMigrateSQLServerSQLDbSyncTaskOutputDatabaseError() (*MigrateSQLServerSQLDbSyncTaskOutputDatabaseError, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskOutputError is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutputTableLevel.
func (msssdstotl MigrateSQLServerSQLDbSyncTaskOutputTableLevel) AsMigrateSQLServerSQLDbSyncTaskOutputError() (*MigrateSQLServerSQLDbSyncTaskOutputError, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskOutputTableLevel is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutputTableLevel.
func (msssdstotl MigrateSQLServerSQLDbSyncTaskOutputTableLevel) AsMigrateSQLServerSQLDbSyncTaskOutputTableLevel() (*MigrateSQLServerSQLDbSyncTaskOutputTableLevel, bool) {
	return &msssdstotl, true
}

// AsMigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutputTableLevel.
func (msssdstotl MigrateSQLServerSQLDbSyncTaskOutputTableLevel) AsMigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel() (*MigrateSQLServerSQLDbSyncTaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskOutputMigrationLevel is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutputTableLevel.
func (msssdstotl MigrateSQLServerSQLDbSyncTaskOutputTableLevel) AsMigrateSQLServerSQLDbSyncTaskOutputMigrationLevel() (*MigrateSQLServerSQLDbSyncTaskOutputMigrationLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskOutput is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutputTableLevel.
func (msssdstotl MigrateSQLServerSQLDbSyncTaskOutputTableLevel) AsMigrateSQLServerSQLDbSyncTaskOutput() (*MigrateSQLServerSQLDbSyncTaskOutput, bool) {
	return nil, false
}

// AsBasicMigrateSQLServerSQLDbSyncTaskOutput is the BasicMigrateSQLServerSQLDbSyncTaskOutput implementation for MigrateSQLServerSQLDbSyncTaskOutputTableLevel.
func (msssdstotl MigrateSQLServerSQLDbSyncTaskOutputTableLevel) AsBasicMigrateSQLServerSQLDbSyncTaskOutput() (BasicMigrateSQLServerSQLDbSyncTaskOutput, bool) {
	return &msssdstotl, true
}

// MigrateSQLServerSQLDbSyncTaskProperties properties for the task that migrates on-prem SQL Server
// databases to Azure SQL Database for online migrations
type MigrateSQLServerSQLDbSyncTaskProperties struct {
	// Input - Task input
	Input *MigrateSQLServerSQLDbSyncTaskInput `json:"input,omitempty"`
	// Output - READ-ONLY; Task output. This is ignored if submitted.
	Output *[]BasicMigrateSQLServerSQLDbSyncTaskOutput `json:"output,omitempty"`
	// Errors - READ-ONLY; Array of errors. This is ignored if submitted.
	Errors *[]ODataError `json:"errors,omitempty"`
	// State - READ-ONLY; The state of the task. This is ignored if submitted. Possible values include: 'TaskStateUnknown', 'TaskStateQueued', 'TaskStateRunning', 'TaskStateCanceled', 'TaskStateSucceeded', 'TaskStateFailed', 'TaskStateFailedInputValidation', 'TaskStateFaulted'
	State TaskState `json:"state,omitempty"`
	// Commands - READ-ONLY; Array of command properties.
	Commands *[]BasicCommandProperties `json:"commands,omitempty"`
	// TaskType - Possible values include: 'TaskTypeUnknown', 'TaskTypeGetTDECertificatesSQL', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMISyncLRS', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMI', 'TaskTypeValidateMigrationInputSQLServerSQLDbSync', 'TaskTypeMigratePostgreSQLAzureDbForPostgreSQLSync', 'TaskTypeMigrateMySQLAzureDbForMySQLSync', 'TaskTypeMigrateSQLServerAzureSQLDbSync', 'TaskTypeMigrateSQLServerSQLDb', 'TaskTypeMigrateSQLServerAzureSQLDbMISyncLRS', 'TaskTypeMigrateSQLServerAzureSQLDbMI', 'TaskTypeConnectToTargetAzureDbForMySQL', 'TaskTypeConnectToTargetAzureSQLDbMISyncLRS', 'TaskTypeConnectToTargetAzureSQLDbMI', 'TaskTypeGetUserTablesAzureSQLDbSync', 'TaskTypeGetUserTablesSQL', 'TaskTypeConnectToTargetAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetSQLDbSync', 'TaskTypeConnectToTargetSQLDb', 'TaskTypeConnectToSourcePostgreSQLSync', 'TaskTypeConnectToSourceSQLServerSync', 'TaskTypeConnectToSourceSQLServer', 'TaskTypeConnectToSourceMySQL'
	TaskType TaskType `json:"taskType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateSQLServerSQLDbSyncTaskProperties.
func (msssdstp MigrateSQLServerSQLDbSyncTaskProperties) MarshalJSON() ([]byte, error) {
	msssdstp.TaskType = TaskTypeMigrateSQLServerAzureSQLDbSync
	objectMap := make(map[string]interface{})
	if msssdstp.Input != nil {
		objectMap["input"] = msssdstp.Input
	}
	if msssdstp.TaskType != "" {
		objectMap["taskType"] = msssdstp.TaskType
	}
	return json.Marshal(objectMap)
}

// AsGetTdeCertificatesSQLTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbSyncTaskProperties.
func (msssdstp MigrateSQLServerSQLDbSyncTaskProperties) AsGetTdeCertificatesSQLTaskProperties() (*GetTdeCertificatesSQLTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbSyncTaskProperties.
func (msssdstp MigrateSQLServerSQLDbSyncTaskProperties) AsValidateMigrationInputSQLServerSQLMISyncTaskProperties() (*ValidateMigrationInputSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbSyncTaskProperties.
func (msssdstp MigrateSQLServerSQLDbSyncTaskProperties) AsValidateMigrationInputSQLServerSQLMITaskProperties() (*ValidateMigrationInputSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbSyncTaskProperties.
func (msssdstp MigrateSQLServerSQLDbSyncTaskProperties) AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties() (*ValidateMigrationInputSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbSyncTaskProperties.
func (msssdstp MigrateSQLServerSQLDbSyncTaskProperties) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbSyncTaskProperties.
func (msssdstp MigrateSQLServerSQLDbSyncTaskProperties) AsMigrateMySQLAzureDbForMySQLSyncTaskProperties() (*MigrateMySQLAzureDbForMySQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbSyncTaskProperties.
func (msssdstp MigrateSQLServerSQLDbSyncTaskProperties) AsMigrateSQLServerSQLDbSyncTaskProperties() (*MigrateSQLServerSQLDbSyncTaskProperties, bool) {
	return &msssdstp, true
}

// AsMigrateSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbSyncTaskProperties.
func (msssdstp MigrateSQLServerSQLDbSyncTaskProperties) AsMigrateSQLServerSQLDbTaskProperties() (*MigrateSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbSyncTaskProperties.
func (msssdstp MigrateSQLServerSQLDbSyncTaskProperties) AsMigrateSQLServerSQLMISyncTaskProperties() (*MigrateSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbSyncTaskProperties.
func (msssdstp MigrateSQLServerSQLDbSyncTaskProperties) AsMigrateSQLServerSQLMITaskProperties() (*MigrateSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForMySQLTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbSyncTaskProperties.
func (msssdstp MigrateSQLServerSQLDbSyncTaskProperties) AsConnectToTargetAzureDbForMySQLTaskProperties() (*ConnectToTargetAzureDbForMySQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbSyncTaskProperties.
func (msssdstp MigrateSQLServerSQLDbSyncTaskProperties) AsConnectToTargetSQLMISyncTaskProperties() (*ConnectToTargetSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMITaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbSyncTaskProperties.
func (msssdstp MigrateSQLServerSQLDbSyncTaskProperties) AsConnectToTargetSQLMITaskProperties() (*ConnectToTargetSQLMITaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbSyncTaskProperties.
func (msssdstp MigrateSQLServerSQLDbSyncTaskProperties) AsGetUserTablesSQLSyncTaskProperties() (*GetUserTablesSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbSyncTaskProperties.
func (msssdstp MigrateSQLServerSQLDbSyncTaskProperties) AsGetUserTablesSQLTaskProperties() (*GetUserTablesSQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbSyncTaskProperties.
func (msssdstp MigrateSQLServerSQLDbSyncTaskProperties) AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbSyncTaskProperties.
func (msssdstp MigrateSQLServerSQLDbSyncTaskProperties) AsConnectToTargetSQLSQLDbSyncTaskProperties() (*ConnectToTargetSQLSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLDbTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbSyncTaskProperties.
func (msssdstp MigrateSQLServerSQLDbSyncTaskProperties) AsConnectToTargetSQLDbTaskProperties() (*ConnectToTargetSQLDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourcePostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbSyncTaskProperties.
func (msssdstp MigrateSQLServerSQLDbSyncTaskProperties) AsConnectToSourcePostgreSQLSyncTaskProperties() (*ConnectToSourcePostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbSyncTaskProperties.
func (msssdstp MigrateSQLServerSQLDbSyncTaskProperties) AsConnectToSourceSQLServerSyncTaskProperties() (*ConnectToSourceSQLServerSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbSyncTaskProperties.
func (msssdstp MigrateSQLServerSQLDbSyncTaskProperties) AsConnectToSourceSQLServerTaskProperties() (*ConnectToSourceSQLServerTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceMySQLTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbSyncTaskProperties.
func (msssdstp MigrateSQLServerSQLDbSyncTaskProperties) AsConnectToSourceMySQLTaskProperties() (*ConnectToSourceMySQLTaskProperties, bool) {
	return nil, false
}

// AsProjectTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbSyncTaskProperties.
func (msssdstp MigrateSQLServerSQLDbSyncTaskProperties) AsProjectTaskProperties() (*ProjectTaskProperties, bool) {
	return nil, false
}

// AsBasicProjectTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbSyncTaskProperties.
func (msssdstp MigrateSQLServerSQLDbSyncTaskProperties) AsBasicProjectTaskProperties() (BasicProjectTaskProperties, bool) {
	return &msssdstp, true
}

// UnmarshalJSON is the custom unmarshaler for MigrateSQLServerSQLDbSyncTaskProperties struct.
func (msssdstp *MigrateSQLServerSQLDbSyncTaskProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "input":
			if v != nil {
				var input MigrateSQLServerSQLDbSyncTaskInput
				err = json.Unmarshal(*v, &input)
				if err != nil {
					return err
				}
				msssdstp.Input = &input
			}
		case "output":
			if v != nil {
				output, err := unmarshalBasicMigrateSQLServerSQLDbSyncTaskOutputArray(*v)
				if err != nil {
					return err
				}
				msssdstp.Output = &output
			}
		case "errors":
			if v != nil {
				var errorsVar []ODataError
				err = json.Unmarshal(*v, &errorsVar)
				if err != nil {
					return err
				}
				msssdstp.Errors = &errorsVar
			}
		case "state":
			if v != nil {
				var state TaskState
				err = json.Unmarshal(*v, &state)
				if err != nil {
					return err
				}
				msssdstp.State = state
			}
		case "commands":
			if v != nil {
				commands, err := unmarshalBasicCommandPropertiesArray(*v)
				if err != nil {
					return err
				}
				msssdstp.Commands = &commands
			}
		case "taskType":
			if v != nil {
				var taskType TaskType
				err = json.Unmarshal(*v, &taskType)
				if err != nil {
					return err
				}
				msssdstp.TaskType = taskType
			}
		}
	}

	return nil
}

// MigrateSQLServerSQLDbTaskInput input for the task that migrates on-prem SQL Server databases to Azure
// SQL Database
type MigrateSQLServerSQLDbTaskInput struct {
	// SelectedDatabases - Databases to migrate
	SelectedDatabases *[]MigrateSQLServerSQLDbDatabaseInput `json:"selectedDatabases,omitempty"`
	// ValidationOptions - Options for enabling various post migration validations. Available options,
	//  1.) Data Integrity Check: Performs a checksum based comparison on source and target tables after the migration to ensure the correctness of the data.
	//  2.) Schema Validation: Performs a thorough schema comparison between the source and target tables and provides a list of differences between the source and target database, 3.) Query Analysis: Executes a set of queries picked up automatically either from the Query Plan Cache or Query Store and execute them and compares the execution time between the source and target database.
	ValidationOptions *MigrationValidationOptions `json:"validationOptions,omitempty"`
	// SourceConnectionInfo - Information for connecting to source
	SourceConnectionInfo *SQLConnectionInfo `json:"sourceConnectionInfo,omitempty"`
	// TargetConnectionInfo - Information for connecting to target
	TargetConnectionInfo *SQLConnectionInfo `json:"targetConnectionInfo,omitempty"`
}

// BasicMigrateSQLServerSQLDbTaskOutput output for the task that migrates on-prem SQL Server databases to Azure SQL
// Database
type BasicMigrateSQLServerSQLDbTaskOutput interface {
	AsMigrateSQLServerSQLDbTaskOutputDatabaseLevelValidationResult() (*MigrateSQLServerSQLDbTaskOutputDatabaseLevelValidationResult, bool)
	AsMigrateSQLServerSQLDbTaskOutputValidationResult() (*MigrateSQLServerSQLDbTaskOutputValidationResult, bool)
	AsMigrateSQLServerSQLDbTaskOutputError() (*MigrateSQLServerSQLDbTaskOutputError, bool)
	AsMigrateSQLServerSQLDbTaskOutputTableLevel() (*MigrateSQLServerSQLDbTaskOutputTableLevel, bool)
	AsMigrateSQLServerSQLDbTaskOutputDatabaseLevel() (*MigrateSQLServerSQLDbTaskOutputDatabaseLevel, bool)
	AsMigrateSQLServerSQLDbTaskOutputMigrationLevel() (*MigrateSQLServerSQLDbTaskOutputMigrationLevel, bool)
	AsMigrateSQLServerSQLDbTaskOutput() (*MigrateSQLServerSQLDbTaskOutput, bool)
}

// MigrateSQLServerSQLDbTaskOutput output for the task that migrates on-prem SQL Server databases to Azure SQL
// Database
type MigrateSQLServerSQLDbTaskOutput struct {
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrateSQLServerSQLDbTaskOutput', 'ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrationDatabaseLevelValidationOutput', 'ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrationValidationOutput', 'ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeErrorOutput', 'ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeTableLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrationLevelOutput'
	ResultType ResultTypeBasicMigrateSQLServerSQLDbTaskOutput `json:"resultType,omitempty"`
}

func unmarshalBasicMigrateSQLServerSQLDbTaskOutput(body []byte) (BasicMigrateSQLServerSQLDbTaskOutput, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["resultType"] {
	case string(ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrationDatabaseLevelValidationOutput):
		var msssdtodlvr MigrateSQLServerSQLDbTaskOutputDatabaseLevelValidationResult
		err := json.Unmarshal(body, &msssdtodlvr)
		return msssdtodlvr, err
	case string(ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrationValidationOutput):
		var msssdtovr MigrateSQLServerSQLDbTaskOutputValidationResult
		err := json.Unmarshal(body, &msssdtovr)
		return msssdtovr, err
	case string(ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeErrorOutput):
		var msssdtoe MigrateSQLServerSQLDbTaskOutputError
		err := json.Unmarshal(body, &msssdtoe)
		return msssdtoe, err
	case string(ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeTableLevelOutput):
		var msssdtotl MigrateSQLServerSQLDbTaskOutputTableLevel
		err := json.Unmarshal(body, &msssdtotl)
		return msssdtotl, err
	case string(ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeDatabaseLevelOutput):
		var msssdtodl MigrateSQLServerSQLDbTaskOutputDatabaseLevel
		err := json.Unmarshal(body, &msssdtodl)
		return msssdtodl, err
	case string(ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrationLevelOutput):
		var msssdtoml MigrateSQLServerSQLDbTaskOutputMigrationLevel
		err := json.Unmarshal(body, &msssdtoml)
		return msssdtoml, err
	default:
		var msssdto MigrateSQLServerSQLDbTaskOutput
		err := json.Unmarshal(body, &msssdto)
		return msssdto, err
	}
}
func unmarshalBasicMigrateSQLServerSQLDbTaskOutputArray(body []byte) ([]BasicMigrateSQLServerSQLDbTaskOutput, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	msssdtoArray := make([]BasicMigrateSQLServerSQLDbTaskOutput, len(rawMessages))

	for index, rawMessage := range rawMessages {
		msssdto, err := unmarshalBasicMigrateSQLServerSQLDbTaskOutput(*rawMessage)
		if err != nil {
			return nil, err
		}
		msssdtoArray[index] = msssdto
	}
	return msssdtoArray, nil
}

// MarshalJSON is the custom marshaler for MigrateSQLServerSQLDbTaskOutput.
func (msssdto MigrateSQLServerSQLDbTaskOutput) MarshalJSON() ([]byte, error) {
	msssdto.ResultType = ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrateSQLServerSQLDbTaskOutput
	objectMap := make(map[string]interface{})
	if msssdto.ResultType != "" {
		objectMap["resultType"] = msssdto.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSQLServerSQLDbTaskOutputDatabaseLevelValidationResult is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutput.
func (msssdto MigrateSQLServerSQLDbTaskOutput) AsMigrateSQLServerSQLDbTaskOutputDatabaseLevelValidationResult() (*MigrateSQLServerSQLDbTaskOutputDatabaseLevelValidationResult, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutputValidationResult is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutput.
func (msssdto MigrateSQLServerSQLDbTaskOutput) AsMigrateSQLServerSQLDbTaskOutputValidationResult() (*MigrateSQLServerSQLDbTaskOutputValidationResult, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutputError is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutput.
func (msssdto MigrateSQLServerSQLDbTaskOutput) AsMigrateSQLServerSQLDbTaskOutputError() (*MigrateSQLServerSQLDbTaskOutputError, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutputTableLevel is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutput.
func (msssdto MigrateSQLServerSQLDbTaskOutput) AsMigrateSQLServerSQLDbTaskOutputTableLevel() (*MigrateSQLServerSQLDbTaskOutputTableLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutputDatabaseLevel is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutput.
func (msssdto MigrateSQLServerSQLDbTaskOutput) AsMigrateSQLServerSQLDbTaskOutputDatabaseLevel() (*MigrateSQLServerSQLDbTaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutputMigrationLevel is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutput.
func (msssdto MigrateSQLServerSQLDbTaskOutput) AsMigrateSQLServerSQLDbTaskOutputMigrationLevel() (*MigrateSQLServerSQLDbTaskOutputMigrationLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutput is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutput.
func (msssdto MigrateSQLServerSQLDbTaskOutput) AsMigrateSQLServerSQLDbTaskOutput() (*MigrateSQLServerSQLDbTaskOutput, bool) {
	return &msssdto, true
}

// AsBasicMigrateSQLServerSQLDbTaskOutput is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutput.
func (msssdto MigrateSQLServerSQLDbTaskOutput) AsBasicMigrateSQLServerSQLDbTaskOutput() (BasicMigrateSQLServerSQLDbTaskOutput, bool) {
	return &msssdto, true
}

// MigrateSQLServerSQLDbTaskOutputDatabaseLevel database level result for Sql Server to Azure Sql DB
// migration.
type MigrateSQLServerSQLDbTaskOutputDatabaseLevel struct {
	// DatabaseName - READ-ONLY; Name of the item
	DatabaseName *string `json:"databaseName,omitempty"`
	// StartedOn - READ-ONLY; Migration start time
	StartedOn *date.Time `json:"startedOn,omitempty"`
	// EndedOn - READ-ONLY; Migration end time
	EndedOn *date.Time `json:"endedOn,omitempty"`
	// State - READ-ONLY; Current state of migration. Possible values include: 'MigrationStateNone', 'MigrationStateInProgress', 'MigrationStateFailed', 'MigrationStateWarning', 'MigrationStateCompleted', 'MigrationStateSkipped', 'MigrationStateStopped'
	State MigrationState `json:"state,omitempty"`
	// Stage - READ-ONLY; Migration stage that this database is in. Possible values include: 'DatabaseMigrationStageNone', 'DatabaseMigrationStageInitialize', 'DatabaseMigrationStageBackup', 'DatabaseMigrationStageFileCopy', 'DatabaseMigrationStageRestore', 'DatabaseMigrationStageCompleted'
	Stage DatabaseMigrationStage `json:"stage,omitempty"`
	// StatusMessage - READ-ONLY; Status message
	StatusMessage *string `json:"statusMessage,omitempty"`
	// Message - READ-ONLY; Migration progress message
	Message *string `json:"message,omitempty"`
	// NumberOfObjects - READ-ONLY; Number of objects
	NumberOfObjects *int64 `json:"numberOfObjects,omitempty"`
	// NumberOfObjectsCompleted - READ-ONLY; Number of successfully completed objects
	NumberOfObjectsCompleted *int64 `json:"numberOfObjectsCompleted,omitempty"`
	// ErrorCount - READ-ONLY; Number of database/object errors.
	ErrorCount *int64 `json:"errorCount,omitempty"`
	// ErrorPrefix - READ-ONLY; Wildcard string prefix to use for querying all errors of the item
	ErrorPrefix *string `json:"errorPrefix,omitempty"`
	// ResultPrefix - READ-ONLY; Wildcard string prefix to use for querying all sub-tem results of the item
	ResultPrefix *string `json:"resultPrefix,omitempty"`
	// ExceptionsAndWarnings - READ-ONLY; Migration exceptions and warnings.
	ExceptionsAndWarnings *[]ReportableException `json:"exceptionsAndWarnings,omitempty"`
	// ObjectSummary - READ-ONLY; Summary of object results in the migration
	ObjectSummary map[string]*DataItemMigrationSummaryResult `json:"objectSummary"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrateSQLServerSQLDbTaskOutput', 'ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrationDatabaseLevelValidationOutput', 'ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrationValidationOutput', 'ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeErrorOutput', 'ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeTableLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrationLevelOutput'
	ResultType ResultTypeBasicMigrateSQLServerSQLDbTaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateSQLServerSQLDbTaskOutputDatabaseLevel.
func (msssdtodl MigrateSQLServerSQLDbTaskOutputDatabaseLevel) MarshalJSON() ([]byte, error) {
	msssdtodl.ResultType = ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeDatabaseLevelOutput
	objectMap := make(map[string]interface{})
	if msssdtodl.ResultType != "" {
		objectMap["resultType"] = msssdtodl.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSQLServerSQLDbTaskOutputDatabaseLevelValidationResult is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputDatabaseLevel.
func (msssdtodl MigrateSQLServerSQLDbTaskOutputDatabaseLevel) AsMigrateSQLServerSQLDbTaskOutputDatabaseLevelValidationResult() (*MigrateSQLServerSQLDbTaskOutputDatabaseLevelValidationResult, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutputValidationResult is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputDatabaseLevel.
func (msssdtodl MigrateSQLServerSQLDbTaskOutputDatabaseLevel) AsMigrateSQLServerSQLDbTaskOutputValidationResult() (*MigrateSQLServerSQLDbTaskOutputValidationResult, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutputError is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputDatabaseLevel.
func (msssdtodl MigrateSQLServerSQLDbTaskOutputDatabaseLevel) AsMigrateSQLServerSQLDbTaskOutputError() (*MigrateSQLServerSQLDbTaskOutputError, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutputTableLevel is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputDatabaseLevel.
func (msssdtodl MigrateSQLServerSQLDbTaskOutputDatabaseLevel) AsMigrateSQLServerSQLDbTaskOutputTableLevel() (*MigrateSQLServerSQLDbTaskOutputTableLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutputDatabaseLevel is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputDatabaseLevel.
func (msssdtodl MigrateSQLServerSQLDbTaskOutputDatabaseLevel) AsMigrateSQLServerSQLDbTaskOutputDatabaseLevel() (*MigrateSQLServerSQLDbTaskOutputDatabaseLevel, bool) {
	return &msssdtodl, true
}

// AsMigrateSQLServerSQLDbTaskOutputMigrationLevel is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputDatabaseLevel.
func (msssdtodl MigrateSQLServerSQLDbTaskOutputDatabaseLevel) AsMigrateSQLServerSQLDbTaskOutputMigrationLevel() (*MigrateSQLServerSQLDbTaskOutputMigrationLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutput is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputDatabaseLevel.
func (msssdtodl MigrateSQLServerSQLDbTaskOutputDatabaseLevel) AsMigrateSQLServerSQLDbTaskOutput() (*MigrateSQLServerSQLDbTaskOutput, bool) {
	return nil, false
}

// AsBasicMigrateSQLServerSQLDbTaskOutput is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputDatabaseLevel.
func (msssdtodl MigrateSQLServerSQLDbTaskOutputDatabaseLevel) AsBasicMigrateSQLServerSQLDbTaskOutput() (BasicMigrateSQLServerSQLDbTaskOutput, bool) {
	return &msssdtodl, true
}

// MigrateSQLServerSQLDbTaskOutputDatabaseLevelValidationResult database validation result for Sql Server
// to Azure Sql DB migration.
type MigrateSQLServerSQLDbTaskOutputDatabaseLevelValidationResult struct {
	// MigrationID - READ-ONLY; Migration Identifier
	MigrationID *string `json:"migrationId,omitempty"`
	// SourceDatabaseName - READ-ONLY; Name of the source database
	SourceDatabaseName *string `json:"sourceDatabaseName,omitempty"`
	// TargetDatabaseName - READ-ONLY; Name of the target database
	TargetDatabaseName *string `json:"targetDatabaseName,omitempty"`
	// StartedOn - READ-ONLY; Validation start time
	StartedOn *date.Time `json:"startedOn,omitempty"`
	// EndedOn - READ-ONLY; Validation end time
	EndedOn *date.Time `json:"endedOn,omitempty"`
	// DataIntegrityValidationResult - READ-ONLY; Provides data integrity validation result between the source and target tables that are migrated.
	DataIntegrityValidationResult *DataIntegrityValidationResult `json:"dataIntegrityValidationResult,omitempty"`
	// SchemaValidationResult - READ-ONLY; Provides schema comparison result between source and target database
	SchemaValidationResult *SchemaComparisonValidationResult `json:"schemaValidationResult,omitempty"`
	// QueryAnalysisValidationResult - READ-ONLY; Results of some of the query execution result between source and target database
	QueryAnalysisValidationResult *QueryAnalysisValidationResult `json:"queryAnalysisValidationResult,omitempty"`
	// Status - READ-ONLY; Current status of validation at the database level. Possible values include: 'ValidationStatusDefault', 'ValidationStatusNotStarted', 'ValidationStatusInitialized', 'ValidationStatusInProgress', 'ValidationStatusCompleted', 'ValidationStatusCompletedWithIssues', 'ValidationStatusFailed', 'ValidationStatusStopped'
	Status ValidationStatus `json:"status,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrateSQLServerSQLDbTaskOutput', 'ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrationDatabaseLevelValidationOutput', 'ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrationValidationOutput', 'ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeErrorOutput', 'ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeTableLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrationLevelOutput'
	ResultType ResultTypeBasicMigrateSQLServerSQLDbTaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateSQLServerSQLDbTaskOutputDatabaseLevelValidationResult.
func (msssdtodlvr MigrateSQLServerSQLDbTaskOutputDatabaseLevelValidationResult) MarshalJSON() ([]byte, error) {
	msssdtodlvr.ResultType = ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrationDatabaseLevelValidationOutput
	objectMap := make(map[string]interface{})
	if msssdtodlvr.ResultType != "" {
		objectMap["resultType"] = msssdtodlvr.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSQLServerSQLDbTaskOutputDatabaseLevelValidationResult is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputDatabaseLevelValidationResult.
func (msssdtodlvr MigrateSQLServerSQLDbTaskOutputDatabaseLevelValidationResult) AsMigrateSQLServerSQLDbTaskOutputDatabaseLevelValidationResult() (*MigrateSQLServerSQLDbTaskOutputDatabaseLevelValidationResult, bool) {
	return &msssdtodlvr, true
}

// AsMigrateSQLServerSQLDbTaskOutputValidationResult is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputDatabaseLevelValidationResult.
func (msssdtodlvr MigrateSQLServerSQLDbTaskOutputDatabaseLevelValidationResult) AsMigrateSQLServerSQLDbTaskOutputValidationResult() (*MigrateSQLServerSQLDbTaskOutputValidationResult, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutputError is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputDatabaseLevelValidationResult.
func (msssdtodlvr MigrateSQLServerSQLDbTaskOutputDatabaseLevelValidationResult) AsMigrateSQLServerSQLDbTaskOutputError() (*MigrateSQLServerSQLDbTaskOutputError, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutputTableLevel is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputDatabaseLevelValidationResult.
func (msssdtodlvr MigrateSQLServerSQLDbTaskOutputDatabaseLevelValidationResult) AsMigrateSQLServerSQLDbTaskOutputTableLevel() (*MigrateSQLServerSQLDbTaskOutputTableLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutputDatabaseLevel is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputDatabaseLevelValidationResult.
func (msssdtodlvr MigrateSQLServerSQLDbTaskOutputDatabaseLevelValidationResult) AsMigrateSQLServerSQLDbTaskOutputDatabaseLevel() (*MigrateSQLServerSQLDbTaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutputMigrationLevel is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputDatabaseLevelValidationResult.
func (msssdtodlvr MigrateSQLServerSQLDbTaskOutputDatabaseLevelValidationResult) AsMigrateSQLServerSQLDbTaskOutputMigrationLevel() (*MigrateSQLServerSQLDbTaskOutputMigrationLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutput is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputDatabaseLevelValidationResult.
func (msssdtodlvr MigrateSQLServerSQLDbTaskOutputDatabaseLevelValidationResult) AsMigrateSQLServerSQLDbTaskOutput() (*MigrateSQLServerSQLDbTaskOutput, bool) {
	return nil, false
}

// AsBasicMigrateSQLServerSQLDbTaskOutput is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputDatabaseLevelValidationResult.
func (msssdtodlvr MigrateSQLServerSQLDbTaskOutputDatabaseLevelValidationResult) AsBasicMigrateSQLServerSQLDbTaskOutput() (BasicMigrateSQLServerSQLDbTaskOutput, bool) {
	return &msssdtodlvr, true
}

// MigrateSQLServerSQLDbTaskOutputError task errors for Sql Server to Azure Sql DB migration.
type MigrateSQLServerSQLDbTaskOutputError struct {
	// Error - READ-ONLY; Migration error
	Error *ReportableException `json:"error,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrateSQLServerSQLDbTaskOutput', 'ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrationDatabaseLevelValidationOutput', 'ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrationValidationOutput', 'ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeErrorOutput', 'ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeTableLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrationLevelOutput'
	ResultType ResultTypeBasicMigrateSQLServerSQLDbTaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateSQLServerSQLDbTaskOutputError.
func (msssdtoe MigrateSQLServerSQLDbTaskOutputError) MarshalJSON() ([]byte, error) {
	msssdtoe.ResultType = ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeErrorOutput
	objectMap := make(map[string]interface{})
	if msssdtoe.ResultType != "" {
		objectMap["resultType"] = msssdtoe.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSQLServerSQLDbTaskOutputDatabaseLevelValidationResult is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputError.
func (msssdtoe MigrateSQLServerSQLDbTaskOutputError) AsMigrateSQLServerSQLDbTaskOutputDatabaseLevelValidationResult() (*MigrateSQLServerSQLDbTaskOutputDatabaseLevelValidationResult, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutputValidationResult is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputError.
func (msssdtoe MigrateSQLServerSQLDbTaskOutputError) AsMigrateSQLServerSQLDbTaskOutputValidationResult() (*MigrateSQLServerSQLDbTaskOutputValidationResult, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutputError is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputError.
func (msssdtoe MigrateSQLServerSQLDbTaskOutputError) AsMigrateSQLServerSQLDbTaskOutputError() (*MigrateSQLServerSQLDbTaskOutputError, bool) {
	return &msssdtoe, true
}

// AsMigrateSQLServerSQLDbTaskOutputTableLevel is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputError.
func (msssdtoe MigrateSQLServerSQLDbTaskOutputError) AsMigrateSQLServerSQLDbTaskOutputTableLevel() (*MigrateSQLServerSQLDbTaskOutputTableLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutputDatabaseLevel is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputError.
func (msssdtoe MigrateSQLServerSQLDbTaskOutputError) AsMigrateSQLServerSQLDbTaskOutputDatabaseLevel() (*MigrateSQLServerSQLDbTaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutputMigrationLevel is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputError.
func (msssdtoe MigrateSQLServerSQLDbTaskOutputError) AsMigrateSQLServerSQLDbTaskOutputMigrationLevel() (*MigrateSQLServerSQLDbTaskOutputMigrationLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutput is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputError.
func (msssdtoe MigrateSQLServerSQLDbTaskOutputError) AsMigrateSQLServerSQLDbTaskOutput() (*MigrateSQLServerSQLDbTaskOutput, bool) {
	return nil, false
}

// AsBasicMigrateSQLServerSQLDbTaskOutput is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputError.
func (msssdtoe MigrateSQLServerSQLDbTaskOutputError) AsBasicMigrateSQLServerSQLDbTaskOutput() (BasicMigrateSQLServerSQLDbTaskOutput, bool) {
	return &msssdtoe, true
}

// MigrateSQLServerSQLDbTaskOutputMigrationLevel migration level result for Sql server to Azure Sql DB
// migration.
type MigrateSQLServerSQLDbTaskOutputMigrationLevel struct {
	// StartedOn - READ-ONLY; Migration start time
	StartedOn *date.Time `json:"startedOn,omitempty"`
	// EndedOn - READ-ONLY; Migration end time
	EndedOn *date.Time `json:"endedOn,omitempty"`
	// DurationInSeconds - READ-ONLY; Duration of task execution in seconds.
	DurationInSeconds *int64 `json:"durationInSeconds,omitempty"`
	// Status - READ-ONLY; Current status of migration. Possible values include: 'MigrationStatusDefault', 'MigrationStatusConnecting', 'MigrationStatusSourceAndTargetSelected', 'MigrationStatusSelectLogins', 'MigrationStatusConfigured', 'MigrationStatusRunning', 'MigrationStatusError', 'MigrationStatusStopped', 'MigrationStatusCompleted', 'MigrationStatusCompletedWithWarnings'
	Status MigrationStatus `json:"status,omitempty"`
	// StatusMessage - READ-ONLY; Migration status message
	StatusMessage *string `json:"statusMessage,omitempty"`
	// Message - READ-ONLY; Migration progress message
	Message *string `json:"message,omitempty"`
	// Databases - READ-ONLY; Selected databases as a map from database name to database id
	Databases map[string]*string `json:"databases"`
	// DatabaseSummary - READ-ONLY; Summary of database results in the migration
	DatabaseSummary map[string]*DatabaseSummaryResult `json:"databaseSummary"`
	// MigrationReport - READ-ONLY; Migration Report Result, provides unique url for downloading your migration report.
	MigrationReport *MigrationReportResult `json:"migrationReport,omitempty"`
	// SourceServerVersion - READ-ONLY; Source server version
	SourceServerVersion *string `json:"sourceServerVersion,omitempty"`
	// SourceServerBrandVersion - READ-ONLY; Source server brand version
	SourceServerBrandVersion *string `json:"sourceServerBrandVersion,omitempty"`
	// TargetServerVersion - READ-ONLY; Target server version
	TargetServerVersion *string `json:"targetServerVersion,omitempty"`
	// TargetServerBrandVersion - READ-ONLY; Target server brand version
	TargetServerBrandVersion *string `json:"targetServerBrandVersion,omitempty"`
	// ExceptionsAndWarnings - READ-ONLY; Migration exceptions and warnings.
	ExceptionsAndWarnings *[]ReportableException `json:"exceptionsAndWarnings,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrateSQLServerSQLDbTaskOutput', 'ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrationDatabaseLevelValidationOutput', 'ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrationValidationOutput', 'ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeErrorOutput', 'ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeTableLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrationLevelOutput'
	ResultType ResultTypeBasicMigrateSQLServerSQLDbTaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateSQLServerSQLDbTaskOutputMigrationLevel.
func (msssdtoml MigrateSQLServerSQLDbTaskOutputMigrationLevel) MarshalJSON() ([]byte, error) {
	msssdtoml.ResultType = ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrationLevelOutput
	objectMap := make(map[string]interface{})
	if msssdtoml.ResultType != "" {
		objectMap["resultType"] = msssdtoml.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSQLServerSQLDbTaskOutputDatabaseLevelValidationResult is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputMigrationLevel.
func (msssdtoml MigrateSQLServerSQLDbTaskOutputMigrationLevel) AsMigrateSQLServerSQLDbTaskOutputDatabaseLevelValidationResult() (*MigrateSQLServerSQLDbTaskOutputDatabaseLevelValidationResult, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutputValidationResult is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputMigrationLevel.
func (msssdtoml MigrateSQLServerSQLDbTaskOutputMigrationLevel) AsMigrateSQLServerSQLDbTaskOutputValidationResult() (*MigrateSQLServerSQLDbTaskOutputValidationResult, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutputError is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputMigrationLevel.
func (msssdtoml MigrateSQLServerSQLDbTaskOutputMigrationLevel) AsMigrateSQLServerSQLDbTaskOutputError() (*MigrateSQLServerSQLDbTaskOutputError, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutputTableLevel is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputMigrationLevel.
func (msssdtoml MigrateSQLServerSQLDbTaskOutputMigrationLevel) AsMigrateSQLServerSQLDbTaskOutputTableLevel() (*MigrateSQLServerSQLDbTaskOutputTableLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutputDatabaseLevel is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputMigrationLevel.
func (msssdtoml MigrateSQLServerSQLDbTaskOutputMigrationLevel) AsMigrateSQLServerSQLDbTaskOutputDatabaseLevel() (*MigrateSQLServerSQLDbTaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutputMigrationLevel is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputMigrationLevel.
func (msssdtoml MigrateSQLServerSQLDbTaskOutputMigrationLevel) AsMigrateSQLServerSQLDbTaskOutputMigrationLevel() (*MigrateSQLServerSQLDbTaskOutputMigrationLevel, bool) {
	return &msssdtoml, true
}

// AsMigrateSQLServerSQLDbTaskOutput is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputMigrationLevel.
func (msssdtoml MigrateSQLServerSQLDbTaskOutputMigrationLevel) AsMigrateSQLServerSQLDbTaskOutput() (*MigrateSQLServerSQLDbTaskOutput, bool) {
	return nil, false
}

// AsBasicMigrateSQLServerSQLDbTaskOutput is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputMigrationLevel.
func (msssdtoml MigrateSQLServerSQLDbTaskOutputMigrationLevel) AsBasicMigrateSQLServerSQLDbTaskOutput() (BasicMigrateSQLServerSQLDbTaskOutput, bool) {
	return &msssdtoml, true
}

// MigrateSQLServerSQLDbTaskOutputTableLevel table level result for Sql Server to Azure Sql DB migration.
type MigrateSQLServerSQLDbTaskOutputTableLevel struct {
	// ObjectName - READ-ONLY; Name of the item
	ObjectName *string `json:"objectName,omitempty"`
	// StartedOn - READ-ONLY; Migration start time
	StartedOn *date.Time `json:"startedOn,omitempty"`
	// EndedOn - READ-ONLY; Migration end time
	EndedOn *date.Time `json:"endedOn,omitempty"`
	// State - READ-ONLY; Current state of migration. Possible values include: 'MigrationStateNone', 'MigrationStateInProgress', 'MigrationStateFailed', 'MigrationStateWarning', 'MigrationStateCompleted', 'MigrationStateSkipped', 'MigrationStateStopped'
	State MigrationState `json:"state,omitempty"`
	// StatusMessage - READ-ONLY; Status message
	StatusMessage *string `json:"statusMessage,omitempty"`
	// ItemsCount - READ-ONLY; Number of items
	ItemsCount *int64 `json:"itemsCount,omitempty"`
	// ItemsCompletedCount - READ-ONLY; Number of successfully completed items
	ItemsCompletedCount *int64 `json:"itemsCompletedCount,omitempty"`
	// ErrorPrefix - READ-ONLY; Wildcard string prefix to use for querying all errors of the item
	ErrorPrefix *string `json:"errorPrefix,omitempty"`
	// ResultPrefix - READ-ONLY; Wildcard string prefix to use for querying all sub-tem results of the item
	ResultPrefix *string `json:"resultPrefix,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrateSQLServerSQLDbTaskOutput', 'ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrationDatabaseLevelValidationOutput', 'ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrationValidationOutput', 'ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeErrorOutput', 'ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeTableLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrationLevelOutput'
	ResultType ResultTypeBasicMigrateSQLServerSQLDbTaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateSQLServerSQLDbTaskOutputTableLevel.
func (msssdtotl MigrateSQLServerSQLDbTaskOutputTableLevel) MarshalJSON() ([]byte, error) {
	msssdtotl.ResultType = ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeTableLevelOutput
	objectMap := make(map[string]interface{})
	if msssdtotl.ResultType != "" {
		objectMap["resultType"] = msssdtotl.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSQLServerSQLDbTaskOutputDatabaseLevelValidationResult is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputTableLevel.
func (msssdtotl MigrateSQLServerSQLDbTaskOutputTableLevel) AsMigrateSQLServerSQLDbTaskOutputDatabaseLevelValidationResult() (*MigrateSQLServerSQLDbTaskOutputDatabaseLevelValidationResult, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutputValidationResult is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputTableLevel.
func (msssdtotl MigrateSQLServerSQLDbTaskOutputTableLevel) AsMigrateSQLServerSQLDbTaskOutputValidationResult() (*MigrateSQLServerSQLDbTaskOutputValidationResult, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutputError is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputTableLevel.
func (msssdtotl MigrateSQLServerSQLDbTaskOutputTableLevel) AsMigrateSQLServerSQLDbTaskOutputError() (*MigrateSQLServerSQLDbTaskOutputError, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutputTableLevel is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputTableLevel.
func (msssdtotl MigrateSQLServerSQLDbTaskOutputTableLevel) AsMigrateSQLServerSQLDbTaskOutputTableLevel() (*MigrateSQLServerSQLDbTaskOutputTableLevel, bool) {
	return &msssdtotl, true
}

// AsMigrateSQLServerSQLDbTaskOutputDatabaseLevel is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputTableLevel.
func (msssdtotl MigrateSQLServerSQLDbTaskOutputTableLevel) AsMigrateSQLServerSQLDbTaskOutputDatabaseLevel() (*MigrateSQLServerSQLDbTaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutputMigrationLevel is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputTableLevel.
func (msssdtotl MigrateSQLServerSQLDbTaskOutputTableLevel) AsMigrateSQLServerSQLDbTaskOutputMigrationLevel() (*MigrateSQLServerSQLDbTaskOutputMigrationLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutput is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputTableLevel.
func (msssdtotl MigrateSQLServerSQLDbTaskOutputTableLevel) AsMigrateSQLServerSQLDbTaskOutput() (*MigrateSQLServerSQLDbTaskOutput, bool) {
	return nil, false
}

// AsBasicMigrateSQLServerSQLDbTaskOutput is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputTableLevel.
func (msssdtotl MigrateSQLServerSQLDbTaskOutputTableLevel) AsBasicMigrateSQLServerSQLDbTaskOutput() (BasicMigrateSQLServerSQLDbTaskOutput, bool) {
	return &msssdtotl, true
}

// MigrateSQLServerSQLDbTaskOutputValidationResult validation result for Sql Server to Azure Sql DB
// migration.
type MigrateSQLServerSQLDbTaskOutputValidationResult struct {
	// MigrationID - READ-ONLY; Migration Identifier
	MigrationID *string `json:"migrationId,omitempty"`
	// SummaryResults - Validation summary results for each database
	SummaryResults map[string]*MigrationValidationDatabaseSummaryResult `json:"summaryResults"`
	// Status - READ-ONLY; Current status of validation at the migration level. Status from the database validation result status will be aggregated here. Possible values include: 'ValidationStatusDefault', 'ValidationStatusNotStarted', 'ValidationStatusInitialized', 'ValidationStatusInProgress', 'ValidationStatusCompleted', 'ValidationStatusCompletedWithIssues', 'ValidationStatusFailed', 'ValidationStatusStopped'
	Status ValidationStatus `json:"status,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrateSQLServerSQLDbTaskOutput', 'ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrationDatabaseLevelValidationOutput', 'ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrationValidationOutput', 'ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeErrorOutput', 'ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeTableLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrationLevelOutput'
	ResultType ResultTypeBasicMigrateSQLServerSQLDbTaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateSQLServerSQLDbTaskOutputValidationResult.
func (msssdtovr MigrateSQLServerSQLDbTaskOutputValidationResult) MarshalJSON() ([]byte, error) {
	msssdtovr.ResultType = ResultTypeBasicMigrateSQLServerSQLDbTaskOutputResultTypeMigrationValidationOutput
	objectMap := make(map[string]interface{})
	if msssdtovr.SummaryResults != nil {
		objectMap["summaryResults"] = msssdtovr.SummaryResults
	}
	if msssdtovr.ResultType != "" {
		objectMap["resultType"] = msssdtovr.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSQLServerSQLDbTaskOutputDatabaseLevelValidationResult is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputValidationResult.
func (msssdtovr MigrateSQLServerSQLDbTaskOutputValidationResult) AsMigrateSQLServerSQLDbTaskOutputDatabaseLevelValidationResult() (*MigrateSQLServerSQLDbTaskOutputDatabaseLevelValidationResult, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutputValidationResult is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputValidationResult.
func (msssdtovr MigrateSQLServerSQLDbTaskOutputValidationResult) AsMigrateSQLServerSQLDbTaskOutputValidationResult() (*MigrateSQLServerSQLDbTaskOutputValidationResult, bool) {
	return &msssdtovr, true
}

// AsMigrateSQLServerSQLDbTaskOutputError is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputValidationResult.
func (msssdtovr MigrateSQLServerSQLDbTaskOutputValidationResult) AsMigrateSQLServerSQLDbTaskOutputError() (*MigrateSQLServerSQLDbTaskOutputError, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutputTableLevel is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputValidationResult.
func (msssdtovr MigrateSQLServerSQLDbTaskOutputValidationResult) AsMigrateSQLServerSQLDbTaskOutputTableLevel() (*MigrateSQLServerSQLDbTaskOutputTableLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutputDatabaseLevel is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputValidationResult.
func (msssdtovr MigrateSQLServerSQLDbTaskOutputValidationResult) AsMigrateSQLServerSQLDbTaskOutputDatabaseLevel() (*MigrateSQLServerSQLDbTaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutputMigrationLevel is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputValidationResult.
func (msssdtovr MigrateSQLServerSQLDbTaskOutputValidationResult) AsMigrateSQLServerSQLDbTaskOutputMigrationLevel() (*MigrateSQLServerSQLDbTaskOutputMigrationLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskOutput is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputValidationResult.
func (msssdtovr MigrateSQLServerSQLDbTaskOutputValidationResult) AsMigrateSQLServerSQLDbTaskOutput() (*MigrateSQLServerSQLDbTaskOutput, bool) {
	return nil, false
}

// AsBasicMigrateSQLServerSQLDbTaskOutput is the BasicMigrateSQLServerSQLDbTaskOutput implementation for MigrateSQLServerSQLDbTaskOutputValidationResult.
func (msssdtovr MigrateSQLServerSQLDbTaskOutputValidationResult) AsBasicMigrateSQLServerSQLDbTaskOutput() (BasicMigrateSQLServerSQLDbTaskOutput, bool) {
	return &msssdtovr, true
}

// MigrateSQLServerSQLDbTaskProperties properties for the task that migrates on-prem SQL Server databases
// to Azure SQL Database
type MigrateSQLServerSQLDbTaskProperties struct {
	// Input - Task input
	Input *MigrateSQLServerSQLDbTaskInput `json:"input,omitempty"`
	// Output - READ-ONLY; Task output. This is ignored if submitted.
	Output *[]BasicMigrateSQLServerSQLDbTaskOutput `json:"output,omitempty"`
	// Errors - READ-ONLY; Array of errors. This is ignored if submitted.
	Errors *[]ODataError `json:"errors,omitempty"`
	// State - READ-ONLY; The state of the task. This is ignored if submitted. Possible values include: 'TaskStateUnknown', 'TaskStateQueued', 'TaskStateRunning', 'TaskStateCanceled', 'TaskStateSucceeded', 'TaskStateFailed', 'TaskStateFailedInputValidation', 'TaskStateFaulted'
	State TaskState `json:"state,omitempty"`
	// Commands - READ-ONLY; Array of command properties.
	Commands *[]BasicCommandProperties `json:"commands,omitempty"`
	// TaskType - Possible values include: 'TaskTypeUnknown', 'TaskTypeGetTDECertificatesSQL', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMISyncLRS', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMI', 'TaskTypeValidateMigrationInputSQLServerSQLDbSync', 'TaskTypeMigratePostgreSQLAzureDbForPostgreSQLSync', 'TaskTypeMigrateMySQLAzureDbForMySQLSync', 'TaskTypeMigrateSQLServerAzureSQLDbSync', 'TaskTypeMigrateSQLServerSQLDb', 'TaskTypeMigrateSQLServerAzureSQLDbMISyncLRS', 'TaskTypeMigrateSQLServerAzureSQLDbMI', 'TaskTypeConnectToTargetAzureDbForMySQL', 'TaskTypeConnectToTargetAzureSQLDbMISyncLRS', 'TaskTypeConnectToTargetAzureSQLDbMI', 'TaskTypeGetUserTablesAzureSQLDbSync', 'TaskTypeGetUserTablesSQL', 'TaskTypeConnectToTargetAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetSQLDbSync', 'TaskTypeConnectToTargetSQLDb', 'TaskTypeConnectToSourcePostgreSQLSync', 'TaskTypeConnectToSourceSQLServerSync', 'TaskTypeConnectToSourceSQLServer', 'TaskTypeConnectToSourceMySQL'
	TaskType TaskType `json:"taskType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) MarshalJSON() ([]byte, error) {
	msssdtp.TaskType = TaskTypeMigrateSQLServerSQLDb
	objectMap := make(map[string]interface{})
	if msssdtp.Input != nil {
		objectMap["input"] = msssdtp.Input
	}
	if msssdtp.TaskType != "" {
		objectMap["taskType"] = msssdtp.TaskType
	}
	return json.Marshal(objectMap)
}

// AsGetTdeCertificatesSQLTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) AsGetTdeCertificatesSQLTaskProperties() (*GetTdeCertificatesSQLTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) AsValidateMigrationInputSQLServerSQLMISyncTaskProperties() (*ValidateMigrationInputSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) AsValidateMigrationInputSQLServerSQLMITaskProperties() (*ValidateMigrationInputSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties() (*ValidateMigrationInputSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) AsMigrateMySQLAzureDbForMySQLSyncTaskProperties() (*MigrateMySQLAzureDbForMySQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) AsMigrateSQLServerSQLDbSyncTaskProperties() (*MigrateSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) AsMigrateSQLServerSQLDbTaskProperties() (*MigrateSQLServerSQLDbTaskProperties, bool) {
	return &msssdtp, true
}

// AsMigrateSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) AsMigrateSQLServerSQLMISyncTaskProperties() (*MigrateSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) AsMigrateSQLServerSQLMITaskProperties() (*MigrateSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForMySQLTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) AsConnectToTargetAzureDbForMySQLTaskProperties() (*ConnectToTargetAzureDbForMySQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) AsConnectToTargetSQLMISyncTaskProperties() (*ConnectToTargetSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMITaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) AsConnectToTargetSQLMITaskProperties() (*ConnectToTargetSQLMITaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) AsGetUserTablesSQLSyncTaskProperties() (*GetUserTablesSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) AsGetUserTablesSQLTaskProperties() (*GetUserTablesSQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) AsConnectToTargetSQLSQLDbSyncTaskProperties() (*ConnectToTargetSQLSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLDbTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) AsConnectToTargetSQLDbTaskProperties() (*ConnectToTargetSQLDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourcePostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) AsConnectToSourcePostgreSQLSyncTaskProperties() (*ConnectToSourcePostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) AsConnectToSourceSQLServerSyncTaskProperties() (*ConnectToSourceSQLServerSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) AsConnectToSourceSQLServerTaskProperties() (*ConnectToSourceSQLServerTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceMySQLTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) AsConnectToSourceMySQLTaskProperties() (*ConnectToSourceMySQLTaskProperties, bool) {
	return nil, false
}

// AsProjectTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) AsProjectTaskProperties() (*ProjectTaskProperties, bool) {
	return nil, false
}

// AsBasicProjectTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLDbTaskProperties.
func (msssdtp MigrateSQLServerSQLDbTaskProperties) AsBasicProjectTaskProperties() (BasicProjectTaskProperties, bool) {
	return &msssdtp, true
}

// UnmarshalJSON is the custom unmarshaler for MigrateSQLServerSQLDbTaskProperties struct.
func (msssdtp *MigrateSQLServerSQLDbTaskProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "input":
			if v != nil {
				var input MigrateSQLServerSQLDbTaskInput
				err = json.Unmarshal(*v, &input)
				if err != nil {
					return err
				}
				msssdtp.Input = &input
			}
		case "output":
			if v != nil {
				output, err := unmarshalBasicMigrateSQLServerSQLDbTaskOutputArray(*v)
				if err != nil {
					return err
				}
				msssdtp.Output = &output
			}
		case "errors":
			if v != nil {
				var errorsVar []ODataError
				err = json.Unmarshal(*v, &errorsVar)
				if err != nil {
					return err
				}
				msssdtp.Errors = &errorsVar
			}
		case "state":
			if v != nil {
				var state TaskState
				err = json.Unmarshal(*v, &state)
				if err != nil {
					return err
				}
				msssdtp.State = state
			}
		case "commands":
			if v != nil {
				commands, err := unmarshalBasicCommandPropertiesArray(*v)
				if err != nil {
					return err
				}
				msssdtp.Commands = &commands
			}
		case "taskType":
			if v != nil {
				var taskType TaskType
				err = json.Unmarshal(*v, &taskType)
				if err != nil {
					return err
				}
				msssdtp.TaskType = taskType
			}
		}
	}

	return nil
}

// MigrateSQLServerSQLMIDatabaseInput database specific information for SQL to Azure SQL DB Managed
// Instance migration task inputs
type MigrateSQLServerSQLMIDatabaseInput struct {
	// Name - Name of the database
	Name *string `json:"name,omitempty"`
	// RestoreDatabaseName - Name of the database at destination
	RestoreDatabaseName *string `json:"restoreDatabaseName,omitempty"`
	// BackupFileShare - Backup file share information for backing up this database.
	BackupFileShare *FileShare `json:"backupFileShare,omitempty"`
	// BackupFilePaths - The list of backup files to be used in case of existing backups.
	BackupFilePaths *[]string `json:"backupFilePaths,omitempty"`
}

// MigrateSQLServerSQLMISyncTaskInput input for task that migrates SQL Server databases to Azure SQL
// Database Managed Instance online scenario.
type MigrateSQLServerSQLMISyncTaskInput struct {
	// SelectedDatabases - Databases to migrate
	SelectedDatabases *[]MigrateSQLServerSQLMIDatabaseInput `json:"selectedDatabases,omitempty"`
	// BackupFileShare - Backup file share information for all selected databases.
	BackupFileShare *FileShare `json:"backupFileShare,omitempty"`
	// StorageResourceID - Fully qualified resourceId of storage
	StorageResourceID *string `json:"storageResourceId,omitempty"`
	// SourceConnectionInfo - Connection information for source SQL Server
	SourceConnectionInfo *SQLConnectionInfo `json:"sourceConnectionInfo,omitempty"`
	// TargetConnectionInfo - Connection information for Azure SQL Database Managed Instance
	TargetConnectionInfo *MiSQLConnectionInfo `json:"targetConnectionInfo,omitempty"`
	// AzureApp - Azure Active Directory Application the DMS instance will use to connect to the target instance of Azure SQL Database Managed Instance and the Azure Storage Account
	AzureApp *AzureActiveDirectoryApp `json:"azureApp,omitempty"`
}

// BasicMigrateSQLServerSQLMISyncTaskOutput output for task that migrates SQL Server databases to Azure SQL Database
// Managed Instance using Log Replay Service.
type BasicMigrateSQLServerSQLMISyncTaskOutput interface {
	AsMigrateSQLServerSQLMISyncTaskOutputError() (*MigrateSQLServerSQLMISyncTaskOutputError, bool)
	AsMigrateSQLServerSQLMISyncTaskOutputDatabaseLevel() (*MigrateSQLServerSQLMISyncTaskOutputDatabaseLevel, bool)
	AsMigrateSQLServerSQLMISyncTaskOutputMigrationLevel() (*MigrateSQLServerSQLMISyncTaskOutputMigrationLevel, bool)
	AsMigrateSQLServerSQLMISyncTaskOutput() (*MigrateSQLServerSQLMISyncTaskOutput, bool)
}

// MigrateSQLServerSQLMISyncTaskOutput output for task that migrates SQL Server databases to Azure SQL Database
// Managed Instance using Log Replay Service.
type MigrateSQLServerSQLMISyncTaskOutput struct {
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeMigrateSQLServerSQLMISyncTaskOutput', 'ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeErrorOutput', 'ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeMigrationLevelOutput'
	ResultType ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutput `json:"resultType,omitempty"`
}

func unmarshalBasicMigrateSQLServerSQLMISyncTaskOutput(body []byte) (BasicMigrateSQLServerSQLMISyncTaskOutput, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["resultType"] {
	case string(ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeErrorOutput):
		var msssmstoe MigrateSQLServerSQLMISyncTaskOutputError
		err := json.Unmarshal(body, &msssmstoe)
		return msssmstoe, err
	case string(ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeDatabaseLevelOutput):
		var msssmstodl MigrateSQLServerSQLMISyncTaskOutputDatabaseLevel
		err := json.Unmarshal(body, &msssmstodl)
		return msssmstodl, err
	case string(ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeMigrationLevelOutput):
		var msssmstoml MigrateSQLServerSQLMISyncTaskOutputMigrationLevel
		err := json.Unmarshal(body, &msssmstoml)
		return msssmstoml, err
	default:
		var msssmsto MigrateSQLServerSQLMISyncTaskOutput
		err := json.Unmarshal(body, &msssmsto)
		return msssmsto, err
	}
}
func unmarshalBasicMigrateSQLServerSQLMISyncTaskOutputArray(body []byte) ([]BasicMigrateSQLServerSQLMISyncTaskOutput, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	msssmstoArray := make([]BasicMigrateSQLServerSQLMISyncTaskOutput, len(rawMessages))

	for index, rawMessage := range rawMessages {
		msssmsto, err := unmarshalBasicMigrateSQLServerSQLMISyncTaskOutput(*rawMessage)
		if err != nil {
			return nil, err
		}
		msssmstoArray[index] = msssmsto
	}
	return msssmstoArray, nil
}

// MarshalJSON is the custom marshaler for MigrateSQLServerSQLMISyncTaskOutput.
func (msssmsto MigrateSQLServerSQLMISyncTaskOutput) MarshalJSON() ([]byte, error) {
	msssmsto.ResultType = ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeMigrateSQLServerSQLMISyncTaskOutput
	objectMap := make(map[string]interface{})
	if msssmsto.ResultType != "" {
		objectMap["resultType"] = msssmsto.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSQLServerSQLMISyncTaskOutputError is the BasicMigrateSQLServerSQLMISyncTaskOutput implementation for MigrateSQLServerSQLMISyncTaskOutput.
func (msssmsto MigrateSQLServerSQLMISyncTaskOutput) AsMigrateSQLServerSQLMISyncTaskOutputError() (*MigrateSQLServerSQLMISyncTaskOutputError, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMISyncTaskOutputDatabaseLevel is the BasicMigrateSQLServerSQLMISyncTaskOutput implementation for MigrateSQLServerSQLMISyncTaskOutput.
func (msssmsto MigrateSQLServerSQLMISyncTaskOutput) AsMigrateSQLServerSQLMISyncTaskOutputDatabaseLevel() (*MigrateSQLServerSQLMISyncTaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMISyncTaskOutputMigrationLevel is the BasicMigrateSQLServerSQLMISyncTaskOutput implementation for MigrateSQLServerSQLMISyncTaskOutput.
func (msssmsto MigrateSQLServerSQLMISyncTaskOutput) AsMigrateSQLServerSQLMISyncTaskOutputMigrationLevel() (*MigrateSQLServerSQLMISyncTaskOutputMigrationLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMISyncTaskOutput is the BasicMigrateSQLServerSQLMISyncTaskOutput implementation for MigrateSQLServerSQLMISyncTaskOutput.
func (msssmsto MigrateSQLServerSQLMISyncTaskOutput) AsMigrateSQLServerSQLMISyncTaskOutput() (*MigrateSQLServerSQLMISyncTaskOutput, bool) {
	return &msssmsto, true
}

// AsBasicMigrateSQLServerSQLMISyncTaskOutput is the BasicMigrateSQLServerSQLMISyncTaskOutput implementation for MigrateSQLServerSQLMISyncTaskOutput.
func (msssmsto MigrateSQLServerSQLMISyncTaskOutput) AsBasicMigrateSQLServerSQLMISyncTaskOutput() (BasicMigrateSQLServerSQLMISyncTaskOutput, bool) {
	return &msssmsto, true
}

// MigrateSQLServerSQLMISyncTaskOutputDatabaseLevel ...
type MigrateSQLServerSQLMISyncTaskOutputDatabaseLevel struct {
	// SourceDatabaseName - READ-ONLY; Name of the database
	SourceDatabaseName *string `json:"sourceDatabaseName,omitempty"`
	// MigrationState - READ-ONLY; Current state of database. Possible values include: 'UNDEFINED', 'INITIAL', 'FULLBACKUPUPLOADSTART', 'LOGSHIPPINGSTART', 'UPLOADLOGFILESSTART', 'CUTOVERSTART', 'POSTCUTOVERCOMPLETE', 'COMPLETED', 'CANCELLED', 'FAILED'
	MigrationState DatabaseMigrationState `json:"migrationState,omitempty"`
	// StartedOn - READ-ONLY; Database migration start time
	StartedOn *date.Time `json:"startedOn,omitempty"`
	// EndedOn - READ-ONLY; Database migration end time
	EndedOn *date.Time `json:"endedOn,omitempty"`
	// FullBackupSetInfo - READ-ONLY; Details of full backup set
	FullBackupSetInfo *BackupSetInfo `json:"fullBackupSetInfo,omitempty"`
	// LastRestoredBackupSetInfo - READ-ONLY; Last applied backup set information
	LastRestoredBackupSetInfo *BackupSetInfo `json:"lastRestoredBackupSetInfo,omitempty"`
	// ActiveBackupSets - READ-ONLY; Backup sets that are currently active (Either being uploaded or getting restored)
	ActiveBackupSets *[]BackupSetInfo `json:"activeBackupSets,omitempty"`
	// ContainerName - READ-ONLY; Name of container created in the Azure Storage account where backups are copied to
	ContainerName *string `json:"containerName,omitempty"`
	// ErrorPrefix - READ-ONLY; prefix string to use for querying errors for this database
	ErrorPrefix *string `json:"errorPrefix,omitempty"`
	// IsFullBackupRestored - READ-ONLY; Whether full backup has been applied to the target database or not
	IsFullBackupRestored *bool `json:"isFullBackupRestored,omitempty"`
	// ExceptionsAndWarnings - READ-ONLY; Migration exceptions and warnings
	ExceptionsAndWarnings *[]ReportableException `json:"exceptionsAndWarnings,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeMigrateSQLServerSQLMISyncTaskOutput', 'ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeErrorOutput', 'ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeMigrationLevelOutput'
	ResultType ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateSQLServerSQLMISyncTaskOutputDatabaseLevel.
func (msssmstodl MigrateSQLServerSQLMISyncTaskOutputDatabaseLevel) MarshalJSON() ([]byte, error) {
	msssmstodl.ResultType = ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeDatabaseLevelOutput
	objectMap := make(map[string]interface{})
	if msssmstodl.ResultType != "" {
		objectMap["resultType"] = msssmstodl.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSQLServerSQLMISyncTaskOutputError is the BasicMigrateSQLServerSQLMISyncTaskOutput implementation for MigrateSQLServerSQLMISyncTaskOutputDatabaseLevel.
func (msssmstodl MigrateSQLServerSQLMISyncTaskOutputDatabaseLevel) AsMigrateSQLServerSQLMISyncTaskOutputError() (*MigrateSQLServerSQLMISyncTaskOutputError, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMISyncTaskOutputDatabaseLevel is the BasicMigrateSQLServerSQLMISyncTaskOutput implementation for MigrateSQLServerSQLMISyncTaskOutputDatabaseLevel.
func (msssmstodl MigrateSQLServerSQLMISyncTaskOutputDatabaseLevel) AsMigrateSQLServerSQLMISyncTaskOutputDatabaseLevel() (*MigrateSQLServerSQLMISyncTaskOutputDatabaseLevel, bool) {
	return &msssmstodl, true
}

// AsMigrateSQLServerSQLMISyncTaskOutputMigrationLevel is the BasicMigrateSQLServerSQLMISyncTaskOutput implementation for MigrateSQLServerSQLMISyncTaskOutputDatabaseLevel.
func (msssmstodl MigrateSQLServerSQLMISyncTaskOutputDatabaseLevel) AsMigrateSQLServerSQLMISyncTaskOutputMigrationLevel() (*MigrateSQLServerSQLMISyncTaskOutputMigrationLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMISyncTaskOutput is the BasicMigrateSQLServerSQLMISyncTaskOutput implementation for MigrateSQLServerSQLMISyncTaskOutputDatabaseLevel.
func (msssmstodl MigrateSQLServerSQLMISyncTaskOutputDatabaseLevel) AsMigrateSQLServerSQLMISyncTaskOutput() (*MigrateSQLServerSQLMISyncTaskOutput, bool) {
	return nil, false
}

// AsBasicMigrateSQLServerSQLMISyncTaskOutput is the BasicMigrateSQLServerSQLMISyncTaskOutput implementation for MigrateSQLServerSQLMISyncTaskOutputDatabaseLevel.
func (msssmstodl MigrateSQLServerSQLMISyncTaskOutputDatabaseLevel) AsBasicMigrateSQLServerSQLMISyncTaskOutput() (BasicMigrateSQLServerSQLMISyncTaskOutput, bool) {
	return &msssmstodl, true
}

// MigrateSQLServerSQLMISyncTaskOutputError ...
type MigrateSQLServerSQLMISyncTaskOutputError struct {
	// Error - READ-ONLY; Migration error
	Error *ReportableException `json:"error,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeMigrateSQLServerSQLMISyncTaskOutput', 'ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeErrorOutput', 'ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeMigrationLevelOutput'
	ResultType ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateSQLServerSQLMISyncTaskOutputError.
func (msssmstoe MigrateSQLServerSQLMISyncTaskOutputError) MarshalJSON() ([]byte, error) {
	msssmstoe.ResultType = ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeErrorOutput
	objectMap := make(map[string]interface{})
	if msssmstoe.ResultType != "" {
		objectMap["resultType"] = msssmstoe.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSQLServerSQLMISyncTaskOutputError is the BasicMigrateSQLServerSQLMISyncTaskOutput implementation for MigrateSQLServerSQLMISyncTaskOutputError.
func (msssmstoe MigrateSQLServerSQLMISyncTaskOutputError) AsMigrateSQLServerSQLMISyncTaskOutputError() (*MigrateSQLServerSQLMISyncTaskOutputError, bool) {
	return &msssmstoe, true
}

// AsMigrateSQLServerSQLMISyncTaskOutputDatabaseLevel is the BasicMigrateSQLServerSQLMISyncTaskOutput implementation for MigrateSQLServerSQLMISyncTaskOutputError.
func (msssmstoe MigrateSQLServerSQLMISyncTaskOutputError) AsMigrateSQLServerSQLMISyncTaskOutputDatabaseLevel() (*MigrateSQLServerSQLMISyncTaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMISyncTaskOutputMigrationLevel is the BasicMigrateSQLServerSQLMISyncTaskOutput implementation for MigrateSQLServerSQLMISyncTaskOutputError.
func (msssmstoe MigrateSQLServerSQLMISyncTaskOutputError) AsMigrateSQLServerSQLMISyncTaskOutputMigrationLevel() (*MigrateSQLServerSQLMISyncTaskOutputMigrationLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMISyncTaskOutput is the BasicMigrateSQLServerSQLMISyncTaskOutput implementation for MigrateSQLServerSQLMISyncTaskOutputError.
func (msssmstoe MigrateSQLServerSQLMISyncTaskOutputError) AsMigrateSQLServerSQLMISyncTaskOutput() (*MigrateSQLServerSQLMISyncTaskOutput, bool) {
	return nil, false
}

// AsBasicMigrateSQLServerSQLMISyncTaskOutput is the BasicMigrateSQLServerSQLMISyncTaskOutput implementation for MigrateSQLServerSQLMISyncTaskOutputError.
func (msssmstoe MigrateSQLServerSQLMISyncTaskOutputError) AsBasicMigrateSQLServerSQLMISyncTaskOutput() (BasicMigrateSQLServerSQLMISyncTaskOutput, bool) {
	return &msssmstoe, true
}

// MigrateSQLServerSQLMISyncTaskOutputMigrationLevel ...
type MigrateSQLServerSQLMISyncTaskOutputMigrationLevel struct {
	// DatabaseCount - READ-ONLY; Count of databases
	DatabaseCount *int32 `json:"databaseCount,omitempty"`
	// State - READ-ONLY; Current state of migration. Possible values include: 'MigrationStateNone', 'MigrationStateInProgress', 'MigrationStateFailed', 'MigrationStateWarning', 'MigrationStateCompleted', 'MigrationStateSkipped', 'MigrationStateStopped'
	State MigrationState `json:"state,omitempty"`
	// StartedOn - READ-ONLY; Migration start time
	StartedOn *date.Time `json:"startedOn,omitempty"`
	// EndedOn - READ-ONLY; Migration end time
	EndedOn *date.Time `json:"endedOn,omitempty"`
	// SourceServerName - READ-ONLY; Source server name
	SourceServerName *string `json:"sourceServerName,omitempty"`
	// SourceServerVersion - READ-ONLY; Source server version
	SourceServerVersion *string `json:"sourceServerVersion,omitempty"`
	// SourceServerBrandVersion - READ-ONLY; Source server brand version
	SourceServerBrandVersion *string `json:"sourceServerBrandVersion,omitempty"`
	// TargetServerName - READ-ONLY; Target server name
	TargetServerName *string `json:"targetServerName,omitempty"`
	// TargetServerVersion - READ-ONLY; Target server version
	TargetServerVersion *string `json:"targetServerVersion,omitempty"`
	// TargetServerBrandVersion - READ-ONLY; Target server brand version
	TargetServerBrandVersion *string `json:"targetServerBrandVersion,omitempty"`
	// DatabaseErrorCount - READ-ONLY; Number of database level errors
	DatabaseErrorCount *int32 `json:"databaseErrorCount,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeMigrateSQLServerSQLMISyncTaskOutput', 'ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeErrorOutput', 'ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeMigrationLevelOutput'
	ResultType ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateSQLServerSQLMISyncTaskOutputMigrationLevel.
func (msssmstoml MigrateSQLServerSQLMISyncTaskOutputMigrationLevel) MarshalJSON() ([]byte, error) {
	msssmstoml.ResultType = ResultTypeBasicMigrateSQLServerSQLMISyncTaskOutputResultTypeMigrationLevelOutput
	objectMap := make(map[string]interface{})
	if msssmstoml.ResultType != "" {
		objectMap["resultType"] = msssmstoml.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSQLServerSQLMISyncTaskOutputError is the BasicMigrateSQLServerSQLMISyncTaskOutput implementation for MigrateSQLServerSQLMISyncTaskOutputMigrationLevel.
func (msssmstoml MigrateSQLServerSQLMISyncTaskOutputMigrationLevel) AsMigrateSQLServerSQLMISyncTaskOutputError() (*MigrateSQLServerSQLMISyncTaskOutputError, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMISyncTaskOutputDatabaseLevel is the BasicMigrateSQLServerSQLMISyncTaskOutput implementation for MigrateSQLServerSQLMISyncTaskOutputMigrationLevel.
func (msssmstoml MigrateSQLServerSQLMISyncTaskOutputMigrationLevel) AsMigrateSQLServerSQLMISyncTaskOutputDatabaseLevel() (*MigrateSQLServerSQLMISyncTaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMISyncTaskOutputMigrationLevel is the BasicMigrateSQLServerSQLMISyncTaskOutput implementation for MigrateSQLServerSQLMISyncTaskOutputMigrationLevel.
func (msssmstoml MigrateSQLServerSQLMISyncTaskOutputMigrationLevel) AsMigrateSQLServerSQLMISyncTaskOutputMigrationLevel() (*MigrateSQLServerSQLMISyncTaskOutputMigrationLevel, bool) {
	return &msssmstoml, true
}

// AsMigrateSQLServerSQLMISyncTaskOutput is the BasicMigrateSQLServerSQLMISyncTaskOutput implementation for MigrateSQLServerSQLMISyncTaskOutputMigrationLevel.
func (msssmstoml MigrateSQLServerSQLMISyncTaskOutputMigrationLevel) AsMigrateSQLServerSQLMISyncTaskOutput() (*MigrateSQLServerSQLMISyncTaskOutput, bool) {
	return nil, false
}

// AsBasicMigrateSQLServerSQLMISyncTaskOutput is the BasicMigrateSQLServerSQLMISyncTaskOutput implementation for MigrateSQLServerSQLMISyncTaskOutputMigrationLevel.
func (msssmstoml MigrateSQLServerSQLMISyncTaskOutputMigrationLevel) AsBasicMigrateSQLServerSQLMISyncTaskOutput() (BasicMigrateSQLServerSQLMISyncTaskOutput, bool) {
	return &msssmstoml, true
}

// MigrateSQLServerSQLMISyncTaskProperties properties for task that migrates SQL Server databases to Azure
// SQL Database Managed Instance sync scenario
type MigrateSQLServerSQLMISyncTaskProperties struct {
	// Input - Task input
	Input *MigrateSQLServerSQLMISyncTaskInput `json:"input,omitempty"`
	// Output - READ-ONLY; Task output. This is ignored if submitted.
	Output *[]BasicMigrateSQLServerSQLMISyncTaskOutput `json:"output,omitempty"`
	// Errors - READ-ONLY; Array of errors. This is ignored if submitted.
	Errors *[]ODataError `json:"errors,omitempty"`
	// State - READ-ONLY; The state of the task. This is ignored if submitted. Possible values include: 'TaskStateUnknown', 'TaskStateQueued', 'TaskStateRunning', 'TaskStateCanceled', 'TaskStateSucceeded', 'TaskStateFailed', 'TaskStateFailedInputValidation', 'TaskStateFaulted'
	State TaskState `json:"state,omitempty"`
	// Commands - READ-ONLY; Array of command properties.
	Commands *[]BasicCommandProperties `json:"commands,omitempty"`
	// TaskType - Possible values include: 'TaskTypeUnknown', 'TaskTypeGetTDECertificatesSQL', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMISyncLRS', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMI', 'TaskTypeValidateMigrationInputSQLServerSQLDbSync', 'TaskTypeMigratePostgreSQLAzureDbForPostgreSQLSync', 'TaskTypeMigrateMySQLAzureDbForMySQLSync', 'TaskTypeMigrateSQLServerAzureSQLDbSync', 'TaskTypeMigrateSQLServerSQLDb', 'TaskTypeMigrateSQLServerAzureSQLDbMISyncLRS', 'TaskTypeMigrateSQLServerAzureSQLDbMI', 'TaskTypeConnectToTargetAzureDbForMySQL', 'TaskTypeConnectToTargetAzureSQLDbMISyncLRS', 'TaskTypeConnectToTargetAzureSQLDbMI', 'TaskTypeGetUserTablesAzureSQLDbSync', 'TaskTypeGetUserTablesSQL', 'TaskTypeConnectToTargetAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetSQLDbSync', 'TaskTypeConnectToTargetSQLDb', 'TaskTypeConnectToSourcePostgreSQLSync', 'TaskTypeConnectToSourceSQLServerSync', 'TaskTypeConnectToSourceSQLServer', 'TaskTypeConnectToSourceMySQL'
	TaskType TaskType `json:"taskType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateSQLServerSQLMISyncTaskProperties.
func (msssmstp MigrateSQLServerSQLMISyncTaskProperties) MarshalJSON() ([]byte, error) {
	msssmstp.TaskType = TaskTypeMigrateSQLServerAzureSQLDbMISyncLRS
	objectMap := make(map[string]interface{})
	if msssmstp.Input != nil {
		objectMap["input"] = msssmstp.Input
	}
	if msssmstp.TaskType != "" {
		objectMap["taskType"] = msssmstp.TaskType
	}
	return json.Marshal(objectMap)
}

// AsGetTdeCertificatesSQLTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMISyncTaskProperties.
func (msssmstp MigrateSQLServerSQLMISyncTaskProperties) AsGetTdeCertificatesSQLTaskProperties() (*GetTdeCertificatesSQLTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMISyncTaskProperties.
func (msssmstp MigrateSQLServerSQLMISyncTaskProperties) AsValidateMigrationInputSQLServerSQLMISyncTaskProperties() (*ValidateMigrationInputSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMISyncTaskProperties.
func (msssmstp MigrateSQLServerSQLMISyncTaskProperties) AsValidateMigrationInputSQLServerSQLMITaskProperties() (*ValidateMigrationInputSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMISyncTaskProperties.
func (msssmstp MigrateSQLServerSQLMISyncTaskProperties) AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties() (*ValidateMigrationInputSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMISyncTaskProperties.
func (msssmstp MigrateSQLServerSQLMISyncTaskProperties) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMISyncTaskProperties.
func (msssmstp MigrateSQLServerSQLMISyncTaskProperties) AsMigrateMySQLAzureDbForMySQLSyncTaskProperties() (*MigrateMySQLAzureDbForMySQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMISyncTaskProperties.
func (msssmstp MigrateSQLServerSQLMISyncTaskProperties) AsMigrateSQLServerSQLDbSyncTaskProperties() (*MigrateSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMISyncTaskProperties.
func (msssmstp MigrateSQLServerSQLMISyncTaskProperties) AsMigrateSQLServerSQLDbTaskProperties() (*MigrateSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMISyncTaskProperties.
func (msssmstp MigrateSQLServerSQLMISyncTaskProperties) AsMigrateSQLServerSQLMISyncTaskProperties() (*MigrateSQLServerSQLMISyncTaskProperties, bool) {
	return &msssmstp, true
}

// AsMigrateSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMISyncTaskProperties.
func (msssmstp MigrateSQLServerSQLMISyncTaskProperties) AsMigrateSQLServerSQLMITaskProperties() (*MigrateSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForMySQLTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMISyncTaskProperties.
func (msssmstp MigrateSQLServerSQLMISyncTaskProperties) AsConnectToTargetAzureDbForMySQLTaskProperties() (*ConnectToTargetAzureDbForMySQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMISyncTaskProperties.
func (msssmstp MigrateSQLServerSQLMISyncTaskProperties) AsConnectToTargetSQLMISyncTaskProperties() (*ConnectToTargetSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMITaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMISyncTaskProperties.
func (msssmstp MigrateSQLServerSQLMISyncTaskProperties) AsConnectToTargetSQLMITaskProperties() (*ConnectToTargetSQLMITaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMISyncTaskProperties.
func (msssmstp MigrateSQLServerSQLMISyncTaskProperties) AsGetUserTablesSQLSyncTaskProperties() (*GetUserTablesSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMISyncTaskProperties.
func (msssmstp MigrateSQLServerSQLMISyncTaskProperties) AsGetUserTablesSQLTaskProperties() (*GetUserTablesSQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMISyncTaskProperties.
func (msssmstp MigrateSQLServerSQLMISyncTaskProperties) AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMISyncTaskProperties.
func (msssmstp MigrateSQLServerSQLMISyncTaskProperties) AsConnectToTargetSQLSQLDbSyncTaskProperties() (*ConnectToTargetSQLSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLDbTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMISyncTaskProperties.
func (msssmstp MigrateSQLServerSQLMISyncTaskProperties) AsConnectToTargetSQLDbTaskProperties() (*ConnectToTargetSQLDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourcePostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMISyncTaskProperties.
func (msssmstp MigrateSQLServerSQLMISyncTaskProperties) AsConnectToSourcePostgreSQLSyncTaskProperties() (*ConnectToSourcePostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMISyncTaskProperties.
func (msssmstp MigrateSQLServerSQLMISyncTaskProperties) AsConnectToSourceSQLServerSyncTaskProperties() (*ConnectToSourceSQLServerSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMISyncTaskProperties.
func (msssmstp MigrateSQLServerSQLMISyncTaskProperties) AsConnectToSourceSQLServerTaskProperties() (*ConnectToSourceSQLServerTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceMySQLTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMISyncTaskProperties.
func (msssmstp MigrateSQLServerSQLMISyncTaskProperties) AsConnectToSourceMySQLTaskProperties() (*ConnectToSourceMySQLTaskProperties, bool) {
	return nil, false
}

// AsProjectTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMISyncTaskProperties.
func (msssmstp MigrateSQLServerSQLMISyncTaskProperties) AsProjectTaskProperties() (*ProjectTaskProperties, bool) {
	return nil, false
}

// AsBasicProjectTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMISyncTaskProperties.
func (msssmstp MigrateSQLServerSQLMISyncTaskProperties) AsBasicProjectTaskProperties() (BasicProjectTaskProperties, bool) {
	return &msssmstp, true
}

// UnmarshalJSON is the custom unmarshaler for MigrateSQLServerSQLMISyncTaskProperties struct.
func (msssmstp *MigrateSQLServerSQLMISyncTaskProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "input":
			if v != nil {
				var input MigrateSQLServerSQLMISyncTaskInput
				err = json.Unmarshal(*v, &input)
				if err != nil {
					return err
				}
				msssmstp.Input = &input
			}
		case "output":
			if v != nil {
				output, err := unmarshalBasicMigrateSQLServerSQLMISyncTaskOutputArray(*v)
				if err != nil {
					return err
				}
				msssmstp.Output = &output
			}
		case "errors":
			if v != nil {
				var errorsVar []ODataError
				err = json.Unmarshal(*v, &errorsVar)
				if err != nil {
					return err
				}
				msssmstp.Errors = &errorsVar
			}
		case "state":
			if v != nil {
				var state TaskState
				err = json.Unmarshal(*v, &state)
				if err != nil {
					return err
				}
				msssmstp.State = state
			}
		case "commands":
			if v != nil {
				commands, err := unmarshalBasicCommandPropertiesArray(*v)
				if err != nil {
					return err
				}
				msssmstp.Commands = &commands
			}
		case "taskType":
			if v != nil {
				var taskType TaskType
				err = json.Unmarshal(*v, &taskType)
				if err != nil {
					return err
				}
				msssmstp.TaskType = taskType
			}
		}
	}

	return nil
}

// MigrateSQLServerSQLMITaskInput input for task that migrates SQL Server databases to Azure SQL Database
// Managed Instance.
type MigrateSQLServerSQLMITaskInput struct {
	// SelectedDatabases - Databases to migrate
	SelectedDatabases *[]MigrateSQLServerSQLMIDatabaseInput `json:"selectedDatabases,omitempty"`
	// SelectedLogins - Logins to migrate.
	SelectedLogins *[]string `json:"selectedLogins,omitempty"`
	// SelectedAgentJobs - Agent Jobs to migrate.
	SelectedAgentJobs *[]string `json:"selectedAgentJobs,omitempty"`
	// BackupFileShare - Backup file share information for all selected databases.
	BackupFileShare *FileShare `json:"backupFileShare,omitempty"`
	// BackupBlobShare - SAS URI of Azure Storage Account Container to be used for storing backup files.
	BackupBlobShare *BlobShare `json:"backupBlobShare,omitempty"`
	// BackupMode - Backup Mode to specify whether to use existing backup or create new backup. If using existing backups, backup file paths are required to be provided in selectedDatabases. Possible values include: 'CreateBackup', 'ExistingBackup'
	BackupMode BackupMode `json:"backupMode,omitempty"`
	// SourceConnectionInfo - Information for connecting to source
	SourceConnectionInfo *SQLConnectionInfo `json:"sourceConnectionInfo,omitempty"`
	// TargetConnectionInfo - Information for connecting to target
	TargetConnectionInfo *SQLConnectionInfo `json:"targetConnectionInfo,omitempty"`
}

// BasicMigrateSQLServerSQLMITaskOutput output for task that migrates SQL Server databases to Azure SQL Database
// Managed Instance.
type BasicMigrateSQLServerSQLMITaskOutput interface {
	AsMigrateSQLServerSQLMITaskOutputError() (*MigrateSQLServerSQLMITaskOutputError, bool)
	AsMigrateSQLServerSQLMITaskOutputLoginLevel() (*MigrateSQLServerSQLMITaskOutputLoginLevel, bool)
	AsMigrateSQLServerSQLMITaskOutputAgentJobLevel() (*MigrateSQLServerSQLMITaskOutputAgentJobLevel, bool)
	AsMigrateSQLServerSQLMITaskOutputDatabaseLevel() (*MigrateSQLServerSQLMITaskOutputDatabaseLevel, bool)
	AsMigrateSQLServerSQLMITaskOutputMigrationLevel() (*MigrateSQLServerSQLMITaskOutputMigrationLevel, bool)
	AsMigrateSQLServerSQLMITaskOutput() (*MigrateSQLServerSQLMITaskOutput, bool)
}

// MigrateSQLServerSQLMITaskOutput output for task that migrates SQL Server databases to Azure SQL Database
// Managed Instance.
type MigrateSQLServerSQLMITaskOutput struct {
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeMigrateSQLServerSQLMITaskOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeErrorOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeLoginLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeAgentJobLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeMigrationLevelOutput'
	ResultType ResultTypeBasicMigrateSQLServerSQLMITaskOutput `json:"resultType,omitempty"`
}

func unmarshalBasicMigrateSQLServerSQLMITaskOutput(body []byte) (BasicMigrateSQLServerSQLMITaskOutput, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["resultType"] {
	case string(ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeErrorOutput):
		var msssmtoe MigrateSQLServerSQLMITaskOutputError
		err := json.Unmarshal(body, &msssmtoe)
		return msssmtoe, err
	case string(ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeLoginLevelOutput):
		var msssmtoll MigrateSQLServerSQLMITaskOutputLoginLevel
		err := json.Unmarshal(body, &msssmtoll)
		return msssmtoll, err
	case string(ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeAgentJobLevelOutput):
		var msssmtoajl MigrateSQLServerSQLMITaskOutputAgentJobLevel
		err := json.Unmarshal(body, &msssmtoajl)
		return msssmtoajl, err
	case string(ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeDatabaseLevelOutput):
		var msssmtodl MigrateSQLServerSQLMITaskOutputDatabaseLevel
		err := json.Unmarshal(body, &msssmtodl)
		return msssmtodl, err
	case string(ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeMigrationLevelOutput):
		var msssmtoml MigrateSQLServerSQLMITaskOutputMigrationLevel
		err := json.Unmarshal(body, &msssmtoml)
		return msssmtoml, err
	default:
		var msssmto MigrateSQLServerSQLMITaskOutput
		err := json.Unmarshal(body, &msssmto)
		return msssmto, err
	}
}
func unmarshalBasicMigrateSQLServerSQLMITaskOutputArray(body []byte) ([]BasicMigrateSQLServerSQLMITaskOutput, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	msssmtoArray := make([]BasicMigrateSQLServerSQLMITaskOutput, len(rawMessages))

	for index, rawMessage := range rawMessages {
		msssmto, err := unmarshalBasicMigrateSQLServerSQLMITaskOutput(*rawMessage)
		if err != nil {
			return nil, err
		}
		msssmtoArray[index] = msssmto
	}
	return msssmtoArray, nil
}

// MarshalJSON is the custom marshaler for MigrateSQLServerSQLMITaskOutput.
func (msssmto MigrateSQLServerSQLMITaskOutput) MarshalJSON() ([]byte, error) {
	msssmto.ResultType = ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeMigrateSQLServerSQLMITaskOutput
	objectMap := make(map[string]interface{})
	if msssmto.ResultType != "" {
		objectMap["resultType"] = msssmto.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSQLServerSQLMITaskOutputError is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutput.
func (msssmto MigrateSQLServerSQLMITaskOutput) AsMigrateSQLServerSQLMITaskOutputError() (*MigrateSQLServerSQLMITaskOutputError, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskOutputLoginLevel is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutput.
func (msssmto MigrateSQLServerSQLMITaskOutput) AsMigrateSQLServerSQLMITaskOutputLoginLevel() (*MigrateSQLServerSQLMITaskOutputLoginLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskOutputAgentJobLevel is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutput.
func (msssmto MigrateSQLServerSQLMITaskOutput) AsMigrateSQLServerSQLMITaskOutputAgentJobLevel() (*MigrateSQLServerSQLMITaskOutputAgentJobLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskOutputDatabaseLevel is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutput.
func (msssmto MigrateSQLServerSQLMITaskOutput) AsMigrateSQLServerSQLMITaskOutputDatabaseLevel() (*MigrateSQLServerSQLMITaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskOutputMigrationLevel is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutput.
func (msssmto MigrateSQLServerSQLMITaskOutput) AsMigrateSQLServerSQLMITaskOutputMigrationLevel() (*MigrateSQLServerSQLMITaskOutputMigrationLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskOutput is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutput.
func (msssmto MigrateSQLServerSQLMITaskOutput) AsMigrateSQLServerSQLMITaskOutput() (*MigrateSQLServerSQLMITaskOutput, bool) {
	return &msssmto, true
}

// AsBasicMigrateSQLServerSQLMITaskOutput is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutput.
func (msssmto MigrateSQLServerSQLMITaskOutput) AsBasicMigrateSQLServerSQLMITaskOutput() (BasicMigrateSQLServerSQLMITaskOutput, bool) {
	return &msssmto, true
}

// MigrateSQLServerSQLMITaskOutputAgentJobLevel ...
type MigrateSQLServerSQLMITaskOutputAgentJobLevel struct {
	// Name - READ-ONLY; Agent Job name.
	Name *string `json:"name,omitempty"`
	// IsEnabled - READ-ONLY; The state of the original Agent Job.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// State - READ-ONLY; Current state of migration. Possible values include: 'MigrationStateNone', 'MigrationStateInProgress', 'MigrationStateFailed', 'MigrationStateWarning', 'MigrationStateCompleted', 'MigrationStateSkipped', 'MigrationStateStopped'
	State MigrationState `json:"state,omitempty"`
	// StartedOn - READ-ONLY; Migration start time
	StartedOn *date.Time `json:"startedOn,omitempty"`
	// EndedOn - READ-ONLY; Migration end time
	EndedOn *date.Time `json:"endedOn,omitempty"`
	// Message - READ-ONLY; Migration progress message
	Message *string `json:"message,omitempty"`
	// ExceptionsAndWarnings - READ-ONLY; Migration errors and warnings per job
	ExceptionsAndWarnings *[]ReportableException `json:"exceptionsAndWarnings,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeMigrateSQLServerSQLMITaskOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeErrorOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeLoginLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeAgentJobLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeMigrationLevelOutput'
	ResultType ResultTypeBasicMigrateSQLServerSQLMITaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateSQLServerSQLMITaskOutputAgentJobLevel.
func (msssmtoajl MigrateSQLServerSQLMITaskOutputAgentJobLevel) MarshalJSON() ([]byte, error) {
	msssmtoajl.ResultType = ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeAgentJobLevelOutput
	objectMap := make(map[string]interface{})
	if msssmtoajl.ResultType != "" {
		objectMap["resultType"] = msssmtoajl.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSQLServerSQLMITaskOutputError is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputAgentJobLevel.
func (msssmtoajl MigrateSQLServerSQLMITaskOutputAgentJobLevel) AsMigrateSQLServerSQLMITaskOutputError() (*MigrateSQLServerSQLMITaskOutputError, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskOutputLoginLevel is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputAgentJobLevel.
func (msssmtoajl MigrateSQLServerSQLMITaskOutputAgentJobLevel) AsMigrateSQLServerSQLMITaskOutputLoginLevel() (*MigrateSQLServerSQLMITaskOutputLoginLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskOutputAgentJobLevel is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputAgentJobLevel.
func (msssmtoajl MigrateSQLServerSQLMITaskOutputAgentJobLevel) AsMigrateSQLServerSQLMITaskOutputAgentJobLevel() (*MigrateSQLServerSQLMITaskOutputAgentJobLevel, bool) {
	return &msssmtoajl, true
}

// AsMigrateSQLServerSQLMITaskOutputDatabaseLevel is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputAgentJobLevel.
func (msssmtoajl MigrateSQLServerSQLMITaskOutputAgentJobLevel) AsMigrateSQLServerSQLMITaskOutputDatabaseLevel() (*MigrateSQLServerSQLMITaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskOutputMigrationLevel is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputAgentJobLevel.
func (msssmtoajl MigrateSQLServerSQLMITaskOutputAgentJobLevel) AsMigrateSQLServerSQLMITaskOutputMigrationLevel() (*MigrateSQLServerSQLMITaskOutputMigrationLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskOutput is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputAgentJobLevel.
func (msssmtoajl MigrateSQLServerSQLMITaskOutputAgentJobLevel) AsMigrateSQLServerSQLMITaskOutput() (*MigrateSQLServerSQLMITaskOutput, bool) {
	return nil, false
}

// AsBasicMigrateSQLServerSQLMITaskOutput is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputAgentJobLevel.
func (msssmtoajl MigrateSQLServerSQLMITaskOutputAgentJobLevel) AsBasicMigrateSQLServerSQLMITaskOutput() (BasicMigrateSQLServerSQLMITaskOutput, bool) {
	return &msssmtoajl, true
}

// MigrateSQLServerSQLMITaskOutputDatabaseLevel ...
type MigrateSQLServerSQLMITaskOutputDatabaseLevel struct {
	// DatabaseName - READ-ONLY; Name of the database
	DatabaseName *string `json:"databaseName,omitempty"`
	// SizeMB - READ-ONLY; Size of the database in megabytes
	SizeMB *float64 `json:"sizeMB,omitempty"`
	// State - READ-ONLY; Current state of migration. Possible values include: 'MigrationStateNone', 'MigrationStateInProgress', 'MigrationStateFailed', 'MigrationStateWarning', 'MigrationStateCompleted', 'MigrationStateSkipped', 'MigrationStateStopped'
	State MigrationState `json:"state,omitempty"`
	// Stage - READ-ONLY; Current stage of migration. Possible values include: 'DatabaseMigrationStageNone', 'DatabaseMigrationStageInitialize', 'DatabaseMigrationStageBackup', 'DatabaseMigrationStageFileCopy', 'DatabaseMigrationStageRestore', 'DatabaseMigrationStageCompleted'
	Stage DatabaseMigrationStage `json:"stage,omitempty"`
	// StartedOn - READ-ONLY; Migration start time
	StartedOn *date.Time `json:"startedOn,omitempty"`
	// EndedOn - READ-ONLY; Migration end time
	EndedOn *date.Time `json:"endedOn,omitempty"`
	// Message - READ-ONLY; Migration progress message
	Message *string `json:"message,omitempty"`
	// ExceptionsAndWarnings - READ-ONLY; Migration exceptions and warnings
	ExceptionsAndWarnings *[]ReportableException `json:"exceptionsAndWarnings,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeMigrateSQLServerSQLMITaskOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeErrorOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeLoginLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeAgentJobLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeMigrationLevelOutput'
	ResultType ResultTypeBasicMigrateSQLServerSQLMITaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateSQLServerSQLMITaskOutputDatabaseLevel.
func (msssmtodl MigrateSQLServerSQLMITaskOutputDatabaseLevel) MarshalJSON() ([]byte, error) {
	msssmtodl.ResultType = ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeDatabaseLevelOutput
	objectMap := make(map[string]interface{})
	if msssmtodl.ResultType != "" {
		objectMap["resultType"] = msssmtodl.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSQLServerSQLMITaskOutputError is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputDatabaseLevel.
func (msssmtodl MigrateSQLServerSQLMITaskOutputDatabaseLevel) AsMigrateSQLServerSQLMITaskOutputError() (*MigrateSQLServerSQLMITaskOutputError, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskOutputLoginLevel is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputDatabaseLevel.
func (msssmtodl MigrateSQLServerSQLMITaskOutputDatabaseLevel) AsMigrateSQLServerSQLMITaskOutputLoginLevel() (*MigrateSQLServerSQLMITaskOutputLoginLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskOutputAgentJobLevel is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputDatabaseLevel.
func (msssmtodl MigrateSQLServerSQLMITaskOutputDatabaseLevel) AsMigrateSQLServerSQLMITaskOutputAgentJobLevel() (*MigrateSQLServerSQLMITaskOutputAgentJobLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskOutputDatabaseLevel is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputDatabaseLevel.
func (msssmtodl MigrateSQLServerSQLMITaskOutputDatabaseLevel) AsMigrateSQLServerSQLMITaskOutputDatabaseLevel() (*MigrateSQLServerSQLMITaskOutputDatabaseLevel, bool) {
	return &msssmtodl, true
}

// AsMigrateSQLServerSQLMITaskOutputMigrationLevel is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputDatabaseLevel.
func (msssmtodl MigrateSQLServerSQLMITaskOutputDatabaseLevel) AsMigrateSQLServerSQLMITaskOutputMigrationLevel() (*MigrateSQLServerSQLMITaskOutputMigrationLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskOutput is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputDatabaseLevel.
func (msssmtodl MigrateSQLServerSQLMITaskOutputDatabaseLevel) AsMigrateSQLServerSQLMITaskOutput() (*MigrateSQLServerSQLMITaskOutput, bool) {
	return nil, false
}

// AsBasicMigrateSQLServerSQLMITaskOutput is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputDatabaseLevel.
func (msssmtodl MigrateSQLServerSQLMITaskOutputDatabaseLevel) AsBasicMigrateSQLServerSQLMITaskOutput() (BasicMigrateSQLServerSQLMITaskOutput, bool) {
	return &msssmtodl, true
}

// MigrateSQLServerSQLMITaskOutputError ...
type MigrateSQLServerSQLMITaskOutputError struct {
	// Error - READ-ONLY; Migration error
	Error *ReportableException `json:"error,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeMigrateSQLServerSQLMITaskOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeErrorOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeLoginLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeAgentJobLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeMigrationLevelOutput'
	ResultType ResultTypeBasicMigrateSQLServerSQLMITaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateSQLServerSQLMITaskOutputError.
func (msssmtoe MigrateSQLServerSQLMITaskOutputError) MarshalJSON() ([]byte, error) {
	msssmtoe.ResultType = ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeErrorOutput
	objectMap := make(map[string]interface{})
	if msssmtoe.ResultType != "" {
		objectMap["resultType"] = msssmtoe.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSQLServerSQLMITaskOutputError is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputError.
func (msssmtoe MigrateSQLServerSQLMITaskOutputError) AsMigrateSQLServerSQLMITaskOutputError() (*MigrateSQLServerSQLMITaskOutputError, bool) {
	return &msssmtoe, true
}

// AsMigrateSQLServerSQLMITaskOutputLoginLevel is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputError.
func (msssmtoe MigrateSQLServerSQLMITaskOutputError) AsMigrateSQLServerSQLMITaskOutputLoginLevel() (*MigrateSQLServerSQLMITaskOutputLoginLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskOutputAgentJobLevel is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputError.
func (msssmtoe MigrateSQLServerSQLMITaskOutputError) AsMigrateSQLServerSQLMITaskOutputAgentJobLevel() (*MigrateSQLServerSQLMITaskOutputAgentJobLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskOutputDatabaseLevel is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputError.
func (msssmtoe MigrateSQLServerSQLMITaskOutputError) AsMigrateSQLServerSQLMITaskOutputDatabaseLevel() (*MigrateSQLServerSQLMITaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskOutputMigrationLevel is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputError.
func (msssmtoe MigrateSQLServerSQLMITaskOutputError) AsMigrateSQLServerSQLMITaskOutputMigrationLevel() (*MigrateSQLServerSQLMITaskOutputMigrationLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskOutput is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputError.
func (msssmtoe MigrateSQLServerSQLMITaskOutputError) AsMigrateSQLServerSQLMITaskOutput() (*MigrateSQLServerSQLMITaskOutput, bool) {
	return nil, false
}

// AsBasicMigrateSQLServerSQLMITaskOutput is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputError.
func (msssmtoe MigrateSQLServerSQLMITaskOutputError) AsBasicMigrateSQLServerSQLMITaskOutput() (BasicMigrateSQLServerSQLMITaskOutput, bool) {
	return &msssmtoe, true
}

// MigrateSQLServerSQLMITaskOutputLoginLevel ...
type MigrateSQLServerSQLMITaskOutputLoginLevel struct {
	// LoginName - READ-ONLY; Login name.
	LoginName *string `json:"loginName,omitempty"`
	// State - READ-ONLY; Current state of login. Possible values include: 'MigrationStateNone', 'MigrationStateInProgress', 'MigrationStateFailed', 'MigrationStateWarning', 'MigrationStateCompleted', 'MigrationStateSkipped', 'MigrationStateStopped'
	State MigrationState `json:"state,omitempty"`
	// Stage - READ-ONLY; Current stage of login. Possible values include: 'LoginMigrationStageNone', 'LoginMigrationStageInitialize', 'LoginMigrationStageLoginMigration', 'LoginMigrationStageEstablishUserMapping', 'LoginMigrationStageAssignRoleMembership', 'LoginMigrationStageAssignRoleOwnership', 'LoginMigrationStageEstablishServerPermissions', 'LoginMigrationStageEstablishObjectPermissions', 'LoginMigrationStageCompleted'
	Stage LoginMigrationStage `json:"stage,omitempty"`
	// StartedOn - READ-ONLY; Login migration start time
	StartedOn *date.Time `json:"startedOn,omitempty"`
	// EndedOn - READ-ONLY; Login migration end time
	EndedOn *date.Time `json:"endedOn,omitempty"`
	// Message - READ-ONLY; Login migration progress message
	Message *string `json:"message,omitempty"`
	// ExceptionsAndWarnings - READ-ONLY; Login migration errors and warnings per login
	ExceptionsAndWarnings *[]ReportableException `json:"exceptionsAndWarnings,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeMigrateSQLServerSQLMITaskOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeErrorOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeLoginLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeAgentJobLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeMigrationLevelOutput'
	ResultType ResultTypeBasicMigrateSQLServerSQLMITaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateSQLServerSQLMITaskOutputLoginLevel.
func (msssmtoll MigrateSQLServerSQLMITaskOutputLoginLevel) MarshalJSON() ([]byte, error) {
	msssmtoll.ResultType = ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeLoginLevelOutput
	objectMap := make(map[string]interface{})
	if msssmtoll.ResultType != "" {
		objectMap["resultType"] = msssmtoll.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSQLServerSQLMITaskOutputError is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputLoginLevel.
func (msssmtoll MigrateSQLServerSQLMITaskOutputLoginLevel) AsMigrateSQLServerSQLMITaskOutputError() (*MigrateSQLServerSQLMITaskOutputError, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskOutputLoginLevel is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputLoginLevel.
func (msssmtoll MigrateSQLServerSQLMITaskOutputLoginLevel) AsMigrateSQLServerSQLMITaskOutputLoginLevel() (*MigrateSQLServerSQLMITaskOutputLoginLevel, bool) {
	return &msssmtoll, true
}

// AsMigrateSQLServerSQLMITaskOutputAgentJobLevel is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputLoginLevel.
func (msssmtoll MigrateSQLServerSQLMITaskOutputLoginLevel) AsMigrateSQLServerSQLMITaskOutputAgentJobLevel() (*MigrateSQLServerSQLMITaskOutputAgentJobLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskOutputDatabaseLevel is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputLoginLevel.
func (msssmtoll MigrateSQLServerSQLMITaskOutputLoginLevel) AsMigrateSQLServerSQLMITaskOutputDatabaseLevel() (*MigrateSQLServerSQLMITaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskOutputMigrationLevel is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputLoginLevel.
func (msssmtoll MigrateSQLServerSQLMITaskOutputLoginLevel) AsMigrateSQLServerSQLMITaskOutputMigrationLevel() (*MigrateSQLServerSQLMITaskOutputMigrationLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskOutput is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputLoginLevel.
func (msssmtoll MigrateSQLServerSQLMITaskOutputLoginLevel) AsMigrateSQLServerSQLMITaskOutput() (*MigrateSQLServerSQLMITaskOutput, bool) {
	return nil, false
}

// AsBasicMigrateSQLServerSQLMITaskOutput is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputLoginLevel.
func (msssmtoll MigrateSQLServerSQLMITaskOutputLoginLevel) AsBasicMigrateSQLServerSQLMITaskOutput() (BasicMigrateSQLServerSQLMITaskOutput, bool) {
	return &msssmtoll, true
}

// MigrateSQLServerSQLMITaskOutputMigrationLevel ...
type MigrateSQLServerSQLMITaskOutputMigrationLevel struct {
	// StartedOn - READ-ONLY; Migration start time
	StartedOn *date.Time `json:"startedOn,omitempty"`
	// EndedOn - READ-ONLY; Migration end time
	EndedOn *date.Time `json:"endedOn,omitempty"`
	// Status - READ-ONLY; Current status of migration. Possible values include: 'MigrationStatusDefault', 'MigrationStatusConnecting', 'MigrationStatusSourceAndTargetSelected', 'MigrationStatusSelectLogins', 'MigrationStatusConfigured', 'MigrationStatusRunning', 'MigrationStatusError', 'MigrationStatusStopped', 'MigrationStatusCompleted', 'MigrationStatusCompletedWithWarnings'
	Status MigrationStatus `json:"status,omitempty"`
	// State - READ-ONLY; Current state of migration. Possible values include: 'MigrationStateNone', 'MigrationStateInProgress', 'MigrationStateFailed', 'MigrationStateWarning', 'MigrationStateCompleted', 'MigrationStateSkipped', 'MigrationStateStopped'
	State MigrationState `json:"state,omitempty"`
	// AgentJobs - READ-ONLY; Selected agent jobs as a map from name to id
	AgentJobs map[string]*string `json:"agentJobs"`
	// Logins - READ-ONLY; Selected logins as a map from name to id
	Logins map[string]*string `json:"logins"`
	// Message - READ-ONLY; Migration progress message
	Message *string `json:"message,omitempty"`
	// ServerRoleResults - READ-ONLY; Map of server role migration results.
	ServerRoleResults map[string]*StartMigrationScenarioServerRoleResult `json:"serverRoleResults"`
	// OrphanedUsersInfo - READ-ONLY; List of orphaned users.
	OrphanedUsersInfo *[]OrphanedUserInfo `json:"orphanedUsersInfo,omitempty"`
	// Databases - READ-ONLY; Selected databases as a map from database name to database id
	Databases map[string]*string `json:"databases"`
	// SourceServerVersion - READ-ONLY; Source server version
	SourceServerVersion *string `json:"sourceServerVersion,omitempty"`
	// SourceServerBrandVersion - READ-ONLY; Source server brand version
	SourceServerBrandVersion *string `json:"sourceServerBrandVersion,omitempty"`
	// TargetServerVersion - READ-ONLY; Target server version
	TargetServerVersion *string `json:"targetServerVersion,omitempty"`
	// TargetServerBrandVersion - READ-ONLY; Target server brand version
	TargetServerBrandVersion *string `json:"targetServerBrandVersion,omitempty"`
	// ExceptionsAndWarnings - READ-ONLY; Migration exceptions and warnings.
	ExceptionsAndWarnings *[]ReportableException `json:"exceptionsAndWarnings,omitempty"`
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// ResultType - Possible values include: 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeMigrateSQLServerSQLMITaskOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeErrorOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeLoginLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeAgentJobLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeDatabaseLevelOutput', 'ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeMigrationLevelOutput'
	ResultType ResultTypeBasicMigrateSQLServerSQLMITaskOutput `json:"resultType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateSQLServerSQLMITaskOutputMigrationLevel.
func (msssmtoml MigrateSQLServerSQLMITaskOutputMigrationLevel) MarshalJSON() ([]byte, error) {
	msssmtoml.ResultType = ResultTypeBasicMigrateSQLServerSQLMITaskOutputResultTypeMigrationLevelOutput
	objectMap := make(map[string]interface{})
	if msssmtoml.ResultType != "" {
		objectMap["resultType"] = msssmtoml.ResultType
	}
	return json.Marshal(objectMap)
}

// AsMigrateSQLServerSQLMITaskOutputError is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputMigrationLevel.
func (msssmtoml MigrateSQLServerSQLMITaskOutputMigrationLevel) AsMigrateSQLServerSQLMITaskOutputError() (*MigrateSQLServerSQLMITaskOutputError, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskOutputLoginLevel is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputMigrationLevel.
func (msssmtoml MigrateSQLServerSQLMITaskOutputMigrationLevel) AsMigrateSQLServerSQLMITaskOutputLoginLevel() (*MigrateSQLServerSQLMITaskOutputLoginLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskOutputAgentJobLevel is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputMigrationLevel.
func (msssmtoml MigrateSQLServerSQLMITaskOutputMigrationLevel) AsMigrateSQLServerSQLMITaskOutputAgentJobLevel() (*MigrateSQLServerSQLMITaskOutputAgentJobLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskOutputDatabaseLevel is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputMigrationLevel.
func (msssmtoml MigrateSQLServerSQLMITaskOutputMigrationLevel) AsMigrateSQLServerSQLMITaskOutputDatabaseLevel() (*MigrateSQLServerSQLMITaskOutputDatabaseLevel, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskOutputMigrationLevel is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputMigrationLevel.
func (msssmtoml MigrateSQLServerSQLMITaskOutputMigrationLevel) AsMigrateSQLServerSQLMITaskOutputMigrationLevel() (*MigrateSQLServerSQLMITaskOutputMigrationLevel, bool) {
	return &msssmtoml, true
}

// AsMigrateSQLServerSQLMITaskOutput is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputMigrationLevel.
func (msssmtoml MigrateSQLServerSQLMITaskOutputMigrationLevel) AsMigrateSQLServerSQLMITaskOutput() (*MigrateSQLServerSQLMITaskOutput, bool) {
	return nil, false
}

// AsBasicMigrateSQLServerSQLMITaskOutput is the BasicMigrateSQLServerSQLMITaskOutput implementation for MigrateSQLServerSQLMITaskOutputMigrationLevel.
func (msssmtoml MigrateSQLServerSQLMITaskOutputMigrationLevel) AsBasicMigrateSQLServerSQLMITaskOutput() (BasicMigrateSQLServerSQLMITaskOutput, bool) {
	return &msssmtoml, true
}

// MigrateSQLServerSQLMITaskProperties properties for task that migrates SQL Server databases to Azure SQL
// Database Managed Instance
type MigrateSQLServerSQLMITaskProperties struct {
	// Input - Task input
	Input *MigrateSQLServerSQLMITaskInput `json:"input,omitempty"`
	// Output - READ-ONLY; Task output. This is ignored if submitted.
	Output *[]BasicMigrateSQLServerSQLMITaskOutput `json:"output,omitempty"`
	// Errors - READ-ONLY; Array of errors. This is ignored if submitted.
	Errors *[]ODataError `json:"errors,omitempty"`
	// State - READ-ONLY; The state of the task. This is ignored if submitted. Possible values include: 'TaskStateUnknown', 'TaskStateQueued', 'TaskStateRunning', 'TaskStateCanceled', 'TaskStateSucceeded', 'TaskStateFailed', 'TaskStateFailedInputValidation', 'TaskStateFaulted'
	State TaskState `json:"state,omitempty"`
	// Commands - READ-ONLY; Array of command properties.
	Commands *[]BasicCommandProperties `json:"commands,omitempty"`
	// TaskType - Possible values include: 'TaskTypeUnknown', 'TaskTypeGetTDECertificatesSQL', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMISyncLRS', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMI', 'TaskTypeValidateMigrationInputSQLServerSQLDbSync', 'TaskTypeMigratePostgreSQLAzureDbForPostgreSQLSync', 'TaskTypeMigrateMySQLAzureDbForMySQLSync', 'TaskTypeMigrateSQLServerAzureSQLDbSync', 'TaskTypeMigrateSQLServerSQLDb', 'TaskTypeMigrateSQLServerAzureSQLDbMISyncLRS', 'TaskTypeMigrateSQLServerAzureSQLDbMI', 'TaskTypeConnectToTargetAzureDbForMySQL', 'TaskTypeConnectToTargetAzureSQLDbMISyncLRS', 'TaskTypeConnectToTargetAzureSQLDbMI', 'TaskTypeGetUserTablesAzureSQLDbSync', 'TaskTypeGetUserTablesSQL', 'TaskTypeConnectToTargetAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetSQLDbSync', 'TaskTypeConnectToTargetSQLDb', 'TaskTypeConnectToSourcePostgreSQLSync', 'TaskTypeConnectToSourceSQLServerSync', 'TaskTypeConnectToSourceSQLServer', 'TaskTypeConnectToSourceMySQL'
	TaskType TaskType `json:"taskType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateSQLServerSQLMITaskProperties.
func (msssmtp MigrateSQLServerSQLMITaskProperties) MarshalJSON() ([]byte, error) {
	msssmtp.TaskType = TaskTypeMigrateSQLServerAzureSQLDbMI
	objectMap := make(map[string]interface{})
	if msssmtp.Input != nil {
		objectMap["input"] = msssmtp.Input
	}
	if msssmtp.TaskType != "" {
		objectMap["taskType"] = msssmtp.TaskType
	}
	return json.Marshal(objectMap)
}

// AsGetTdeCertificatesSQLTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMITaskProperties.
func (msssmtp MigrateSQLServerSQLMITaskProperties) AsGetTdeCertificatesSQLTaskProperties() (*GetTdeCertificatesSQLTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMITaskProperties.
func (msssmtp MigrateSQLServerSQLMITaskProperties) AsValidateMigrationInputSQLServerSQLMISyncTaskProperties() (*ValidateMigrationInputSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMITaskProperties.
func (msssmtp MigrateSQLServerSQLMITaskProperties) AsValidateMigrationInputSQLServerSQLMITaskProperties() (*ValidateMigrationInputSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMITaskProperties.
func (msssmtp MigrateSQLServerSQLMITaskProperties) AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties() (*ValidateMigrationInputSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMITaskProperties.
func (msssmtp MigrateSQLServerSQLMITaskProperties) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMITaskProperties.
func (msssmtp MigrateSQLServerSQLMITaskProperties) AsMigrateMySQLAzureDbForMySQLSyncTaskProperties() (*MigrateMySQLAzureDbForMySQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMITaskProperties.
func (msssmtp MigrateSQLServerSQLMITaskProperties) AsMigrateSQLServerSQLDbSyncTaskProperties() (*MigrateSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMITaskProperties.
func (msssmtp MigrateSQLServerSQLMITaskProperties) AsMigrateSQLServerSQLDbTaskProperties() (*MigrateSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMITaskProperties.
func (msssmtp MigrateSQLServerSQLMITaskProperties) AsMigrateSQLServerSQLMISyncTaskProperties() (*MigrateSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMITaskProperties.
func (msssmtp MigrateSQLServerSQLMITaskProperties) AsMigrateSQLServerSQLMITaskProperties() (*MigrateSQLServerSQLMITaskProperties, bool) {
	return &msssmtp, true
}

// AsConnectToTargetAzureDbForMySQLTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMITaskProperties.
func (msssmtp MigrateSQLServerSQLMITaskProperties) AsConnectToTargetAzureDbForMySQLTaskProperties() (*ConnectToTargetAzureDbForMySQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMITaskProperties.
func (msssmtp MigrateSQLServerSQLMITaskProperties) AsConnectToTargetSQLMISyncTaskProperties() (*ConnectToTargetSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMITaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMITaskProperties.
func (msssmtp MigrateSQLServerSQLMITaskProperties) AsConnectToTargetSQLMITaskProperties() (*ConnectToTargetSQLMITaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMITaskProperties.
func (msssmtp MigrateSQLServerSQLMITaskProperties) AsGetUserTablesSQLSyncTaskProperties() (*GetUserTablesSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMITaskProperties.
func (msssmtp MigrateSQLServerSQLMITaskProperties) AsGetUserTablesSQLTaskProperties() (*GetUserTablesSQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMITaskProperties.
func (msssmtp MigrateSQLServerSQLMITaskProperties) AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMITaskProperties.
func (msssmtp MigrateSQLServerSQLMITaskProperties) AsConnectToTargetSQLSQLDbSyncTaskProperties() (*ConnectToTargetSQLSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLDbTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMITaskProperties.
func (msssmtp MigrateSQLServerSQLMITaskProperties) AsConnectToTargetSQLDbTaskProperties() (*ConnectToTargetSQLDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourcePostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMITaskProperties.
func (msssmtp MigrateSQLServerSQLMITaskProperties) AsConnectToSourcePostgreSQLSyncTaskProperties() (*ConnectToSourcePostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerSyncTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMITaskProperties.
func (msssmtp MigrateSQLServerSQLMITaskProperties) AsConnectToSourceSQLServerSyncTaskProperties() (*ConnectToSourceSQLServerSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMITaskProperties.
func (msssmtp MigrateSQLServerSQLMITaskProperties) AsConnectToSourceSQLServerTaskProperties() (*ConnectToSourceSQLServerTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceMySQLTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMITaskProperties.
func (msssmtp MigrateSQLServerSQLMITaskProperties) AsConnectToSourceMySQLTaskProperties() (*ConnectToSourceMySQLTaskProperties, bool) {
	return nil, false
}

// AsProjectTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMITaskProperties.
func (msssmtp MigrateSQLServerSQLMITaskProperties) AsProjectTaskProperties() (*ProjectTaskProperties, bool) {
	return nil, false
}

// AsBasicProjectTaskProperties is the BasicProjectTaskProperties implementation for MigrateSQLServerSQLMITaskProperties.
func (msssmtp MigrateSQLServerSQLMITaskProperties) AsBasicProjectTaskProperties() (BasicProjectTaskProperties, bool) {
	return &msssmtp, true
}

// UnmarshalJSON is the custom unmarshaler for MigrateSQLServerSQLMITaskProperties struct.
func (msssmtp *MigrateSQLServerSQLMITaskProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "input":
			if v != nil {
				var input MigrateSQLServerSQLMITaskInput
				err = json.Unmarshal(*v, &input)
				if err != nil {
					return err
				}
				msssmtp.Input = &input
			}
		case "output":
			if v != nil {
				output, err := unmarshalBasicMigrateSQLServerSQLMITaskOutputArray(*v)
				if err != nil {
					return err
				}
				msssmtp.Output = &output
			}
		case "errors":
			if v != nil {
				var errorsVar []ODataError
				err = json.Unmarshal(*v, &errorsVar)
				if err != nil {
					return err
				}
				msssmtp.Errors = &errorsVar
			}
		case "state":
			if v != nil {
				var state TaskState
				err = json.Unmarshal(*v, &state)
				if err != nil {
					return err
				}
				msssmtp.State = state
			}
		case "commands":
			if v != nil {
				commands, err := unmarshalBasicCommandPropertiesArray(*v)
				if err != nil {
					return err
				}
				msssmtp.Commands = &commands
			}
		case "taskType":
			if v != nil {
				var taskType TaskType
				err = json.Unmarshal(*v, &taskType)
				if err != nil {
					return err
				}
				msssmtp.TaskType = taskType
			}
		}
	}

	return nil
}

// MigrateSQLServerSQLServerDatabaseInput database specific information for SQL to SQL migration task
// inputs
type MigrateSQLServerSQLServerDatabaseInput struct {
	// Name - Name of the database
	Name *string `json:"name,omitempty"`
	// RestoreDatabaseName - Name of the database at destination
	RestoreDatabaseName *string `json:"restoreDatabaseName,omitempty"`
	// BackupAndRestoreFolder - The backup and restore folder
	BackupAndRestoreFolder *string `json:"backupAndRestoreFolder,omitempty"`
	// DatabaseFiles - The list of database files
	DatabaseFiles *[]DatabaseFileInput `json:"databaseFiles,omitempty"`
}

// MigrateSyncCompleteCommandInput input for command that completes sync migration for a database.
type MigrateSyncCompleteCommandInput struct {
	// DatabaseName - Name of database
	DatabaseName *string `json:"databaseName,omitempty"`
	// CommitTimeStamp - Time stamp to complete
	CommitTimeStamp *date.Time `json:"commitTimeStamp,omitempty"`
}

// MigrateSyncCompleteCommandOutput output for command that completes sync migration for a database.
type MigrateSyncCompleteCommandOutput struct {
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// Errors - READ-ONLY; List of errors that happened during the command execution
	Errors *[]ReportableException `json:"errors,omitempty"`
}

// MigrateSyncCompleteCommandProperties properties for the command that completes sync migration for a
// database.
type MigrateSyncCompleteCommandProperties struct {
	// Input - Command input
	Input *MigrateSyncCompleteCommandInput `json:"input,omitempty"`
	// Output - READ-ONLY; Command output. This is ignored if submitted.
	Output *MigrateSyncCompleteCommandOutput `json:"output,omitempty"`
	// Errors - READ-ONLY; Array of errors. This is ignored if submitted.
	Errors *[]ODataError `json:"errors,omitempty"`
	// State - READ-ONLY; The state of the command. This is ignored if submitted. Possible values include: 'Unknown', 'Accepted', 'Running', 'Succeeded', 'Failed'
	State CommandState `json:"state,omitempty"`
	// CommandType - Possible values include: 'CommandTypeUnknown', 'CommandTypeMigrateSQLServerAzureDbSQLMiComplete', 'CommandTypeMigrateSyncCompleteDatabase'
	CommandType CommandType `json:"commandType,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateSyncCompleteCommandProperties.
func (msccp MigrateSyncCompleteCommandProperties) MarshalJSON() ([]byte, error) {
	msccp.CommandType = CommandTypeMigrateSyncCompleteDatabase
	objectMap := make(map[string]interface{})
	if msccp.Input != nil {
		objectMap["input"] = msccp.Input
	}
	if msccp.CommandType != "" {
		objectMap["commandType"] = msccp.CommandType
	}
	return json.Marshal(objectMap)
}

// AsMigrateMISyncCompleteCommandProperties is the BasicCommandProperties implementation for MigrateSyncCompleteCommandProperties.
func (msccp MigrateSyncCompleteCommandProperties) AsMigrateMISyncCompleteCommandProperties() (*MigrateMISyncCompleteCommandProperties, bool) {
	return nil, false
}

// AsMigrateSyncCompleteCommandProperties is the BasicCommandProperties implementation for MigrateSyncCompleteCommandProperties.
func (msccp MigrateSyncCompleteCommandProperties) AsMigrateSyncCompleteCommandProperties() (*MigrateSyncCompleteCommandProperties, bool) {
	return &msccp, true
}

// AsCommandProperties is the BasicCommandProperties implementation for MigrateSyncCompleteCommandProperties.
func (msccp MigrateSyncCompleteCommandProperties) AsCommandProperties() (*CommandProperties, bool) {
	return nil, false
}

// AsBasicCommandProperties is the BasicCommandProperties implementation for MigrateSyncCompleteCommandProperties.
func (msccp MigrateSyncCompleteCommandProperties) AsBasicCommandProperties() (BasicCommandProperties, bool) {
	return &msccp, true
}

// MigrationEligibilityInfo information about migration eligibility of a server object
type MigrationEligibilityInfo struct {
	// IsEligibileForMigration - READ-ONLY; Whether object is eligible for migration or not.
	IsEligibileForMigration *bool `json:"isEligibileForMigration,omitempty"`
	// ValidationMessages - READ-ONLY; Information about eligibility failure for the server object.
	ValidationMessages *[]string `json:"validationMessages,omitempty"`
}

// MigrationReportResult migration validation report result, contains the url for downloading the generated
// report.
type MigrationReportResult struct {
	// ID - READ-ONLY; Migration validation result identifier
	ID *string `json:"id,omitempty"`
	// ReportURL - READ-ONLY; The url of the report.
	ReportURL *string `json:"reportUrl,omitempty"`
}

// MigrationTableMetadata metadata for tables selected in migration project
type MigrationTableMetadata struct {
	// SourceTableName - READ-ONLY; Source table name
	SourceTableName *string `json:"sourceTableName,omitempty"`
	// TargetTableName - READ-ONLY; Target table name
	TargetTableName *string `json:"targetTableName,omitempty"`
}

// MigrationValidationDatabaseSummaryResult migration Validation Database level summary result
type MigrationValidationDatabaseSummaryResult struct {
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// MigrationID - READ-ONLY; Migration Identifier
	MigrationID *string `json:"migrationId,omitempty"`
	// SourceDatabaseName - READ-ONLY; Name of the source database
	SourceDatabaseName *string `json:"sourceDatabaseName,omitempty"`
	// TargetDatabaseName - READ-ONLY; Name of the target database
	TargetDatabaseName *string `json:"targetDatabaseName,omitempty"`
	// StartedOn - READ-ONLY; Validation start time
	StartedOn *date.Time `json:"startedOn,omitempty"`
	// EndedOn - READ-ONLY; Validation end time
	EndedOn *date.Time `json:"endedOn,omitempty"`
	// Status - READ-ONLY; Current status of validation at the database level. Possible values include: 'ValidationStatusDefault', 'ValidationStatusNotStarted', 'ValidationStatusInitialized', 'ValidationStatusInProgress', 'ValidationStatusCompleted', 'ValidationStatusCompletedWithIssues', 'ValidationStatusFailed', 'ValidationStatusStopped'
	Status ValidationStatus `json:"status,omitempty"`
}

// MigrationValidationOptions types of validations to run after the migration
type MigrationValidationOptions struct {
	// EnableSchemaValidation - Allows to compare the schema information between source and target.
	EnableSchemaValidation *bool `json:"enableSchemaValidation,omitempty"`
	// EnableDataIntegrityValidation - Allows to perform a checksum based data integrity validation between source and target for the selected database / tables .
	EnableDataIntegrityValidation *bool `json:"enableDataIntegrityValidation,omitempty"`
	// EnableQueryAnalysisValidation - Allows to perform a quick and intelligent query analysis by retrieving queries from the source database and executes them in the target. The result will have execution statistics for executions in source and target databases for the extracted queries.
	EnableQueryAnalysisValidation *bool `json:"enableQueryAnalysisValidation,omitempty"`
}

// MiSQLConnectionInfo properties required to create a connection to Azure SQL database Managed instance
type MiSQLConnectionInfo struct {
	// ManagedInstanceResourceID - Resource id for Azure SQL database Managed instance
	ManagedInstanceResourceID *string `json:"managedInstanceResourceId,omitempty"`
	// UserName - User name
	UserName *string `json:"userName,omitempty"`
	// Password - Password credential.
	Password *string `json:"password,omitempty"`
	// Type - Possible values include: 'TypeUnknown', 'TypeMiSQLConnectionInfo', 'TypePostgreSQLConnectionInfo', 'TypeMySQLConnectionInfo', 'TypeSQLConnectionInfo'
	Type Type `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for MiSQLConnectionInfo.
func (msci MiSQLConnectionInfo) MarshalJSON() ([]byte, error) {
	msci.Type = TypeMiSQLConnectionInfo
	objectMap := make(map[string]interface{})
	if msci.ManagedInstanceResourceID != nil {
		objectMap["managedInstanceResourceId"] = msci.ManagedInstanceResourceID
	}
	if msci.UserName != nil {
		objectMap["userName"] = msci.UserName
	}
	if msci.Password != nil {
		objectMap["password"] = msci.Password
	}
	if msci.Type != "" {
		objectMap["type"] = msci.Type
	}
	return json.Marshal(objectMap)
}

// AsMiSQLConnectionInfo is the BasicConnectionInfo implementation for MiSQLConnectionInfo.
func (msci MiSQLConnectionInfo) AsMiSQLConnectionInfo() (*MiSQLConnectionInfo, bool) {
	return &msci, true
}

// AsPostgreSQLConnectionInfo is the BasicConnectionInfo implementation for MiSQLConnectionInfo.
func (msci MiSQLConnectionInfo) AsPostgreSQLConnectionInfo() (*PostgreSQLConnectionInfo, bool) {
	return nil, false
}

// AsMySQLConnectionInfo is the BasicConnectionInfo implementation for MiSQLConnectionInfo.
func (msci MiSQLConnectionInfo) AsMySQLConnectionInfo() (*MySQLConnectionInfo, bool) {
	return nil, false
}

// AsSQLConnectionInfo is the BasicConnectionInfo implementation for MiSQLConnectionInfo.
func (msci MiSQLConnectionInfo) AsSQLConnectionInfo() (*SQLConnectionInfo, bool) {
	return nil, false
}

// AsConnectionInfo is the BasicConnectionInfo implementation for MiSQLConnectionInfo.
func (msci MiSQLConnectionInfo) AsConnectionInfo() (*ConnectionInfo, bool) {
	return nil, false
}

// AsBasicConnectionInfo is the BasicConnectionInfo implementation for MiSQLConnectionInfo.
func (msci MiSQLConnectionInfo) AsBasicConnectionInfo() (BasicConnectionInfo, bool) {
	return &msci, true
}

// MySQLConnectionInfo information for connecting to MySQL server
type MySQLConnectionInfo struct {
	// ServerName - Name of the server
	ServerName *string `json:"serverName,omitempty"`
	// Port - Port for Server
	Port *int32 `json:"port,omitempty"`
	// UserName - User name
	UserName *string `json:"userName,omitempty"`
	// Password - Password credential.
	Password *string `json:"password,omitempty"`
	// Type - Possible values include: 'TypeUnknown', 'TypeMiSQLConnectionInfo', 'TypePostgreSQLConnectionInfo', 'TypeMySQLConnectionInfo', 'TypeSQLConnectionInfo'
	Type Type `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for MySQLConnectionInfo.
func (msci MySQLConnectionInfo) MarshalJSON() ([]byte, error) {
	msci.Type = TypeMySQLConnectionInfo
	objectMap := make(map[string]interface{})
	if msci.ServerName != nil {
		objectMap["serverName"] = msci.ServerName
	}
	if msci.Port != nil {
		objectMap["port"] = msci.Port
	}
	if msci.UserName != nil {
		objectMap["userName"] = msci.UserName
	}
	if msci.Password != nil {
		objectMap["password"] = msci.Password
	}
	if msci.Type != "" {
		objectMap["type"] = msci.Type
	}
	return json.Marshal(objectMap)
}

// AsMiSQLConnectionInfo is the BasicConnectionInfo implementation for MySQLConnectionInfo.
func (msci MySQLConnectionInfo) AsMiSQLConnectionInfo() (*MiSQLConnectionInfo, bool) {
	return nil, false
}

// AsPostgreSQLConnectionInfo is the BasicConnectionInfo implementation for MySQLConnectionInfo.
func (msci MySQLConnectionInfo) AsPostgreSQLConnectionInfo() (*PostgreSQLConnectionInfo, bool) {
	return nil, false
}

// AsMySQLConnectionInfo is the BasicConnectionInfo implementation for MySQLConnectionInfo.
func (msci MySQLConnectionInfo) AsMySQLConnectionInfo() (*MySQLConnectionInfo, bool) {
	return &msci, true
}

// AsSQLConnectionInfo is the BasicConnectionInfo implementation for MySQLConnectionInfo.
func (msci MySQLConnectionInfo) AsSQLConnectionInfo() (*SQLConnectionInfo, bool) {
	return nil, false
}

// AsConnectionInfo is the BasicConnectionInfo implementation for MySQLConnectionInfo.
func (msci MySQLConnectionInfo) AsConnectionInfo() (*ConnectionInfo, bool) {
	return nil, false
}

// AsBasicConnectionInfo is the BasicConnectionInfo implementation for MySQLConnectionInfo.
func (msci MySQLConnectionInfo) AsBasicConnectionInfo() (BasicConnectionInfo, bool) {
	return &msci, true
}

// NameAvailabilityRequest a resource type and proposed name
type NameAvailabilityRequest struct {
	// Name - The proposed resource name
	Name *string `json:"name,omitempty"`
	// Type - The resource type chain (e.g. virtualMachines/extensions)
	Type *string `json:"type,omitempty"`
}

// NameAvailabilityResponse indicates whether a proposed resource name is available
type NameAvailabilityResponse struct {
	autorest.Response `json:"-"`
	// NameAvailable - READ-ONLY; If true, the name is valid and available. If false, 'reason' describes why not.
	NameAvailable *bool `json:"nameAvailable,omitempty"`
	// Reason - READ-ONLY; The reason why the name is not available, if nameAvailable is false. Possible values include: 'AlreadyExists', 'Invalid'
	Reason NameCheckFailureReason `json:"reason,omitempty"`
	// Message - READ-ONLY; The localized reason why the name is not available, if nameAvailable is false
	Message *string `json:"message,omitempty"`
}

// NonSQLDataMigrationTable defines metadata for table to be migrated
type NonSQLDataMigrationTable struct {
	// SourceName - Source table name
	SourceName *string `json:"sourceName,omitempty"`
}

// NonSQLDataMigrationTableResult object used to report the data migration results of a table
type NonSQLDataMigrationTableResult struct {
	// ResultCode - READ-ONLY; Result code of the data migration. Possible values include: 'Initial', 'Completed', 'ObjectNotExistsInSource', 'ObjectNotExistsInTarget', 'TargetObjectIsInaccessible', 'FatalError'
	ResultCode ResultCode `json:"resultCode,omitempty"`
	// SourceName - READ-ONLY; Name of the source table
	SourceName *string `json:"sourceName,omitempty"`
	// TargetName - READ-ONLY; Name of the target table
	TargetName *string `json:"targetName,omitempty"`
	// SourceRowCount - READ-ONLY; Number of rows in the source table
	SourceRowCount *int64 `json:"sourceRowCount,omitempty"`
	// TargetRowCount - READ-ONLY; Number of rows in the target table
	TargetRowCount *int64 `json:"targetRowCount,omitempty"`
	// ElapsedTimeInMiliseconds - READ-ONLY; Time taken to migrate the data
	ElapsedTimeInMiliseconds *float64 `json:"elapsedTimeInMiliseconds,omitempty"`
	// Errors - READ-ONLY; List of errors, if any, during migration
	Errors *[]Error `json:"errors,omitempty"`
}

// NonSQLMigrationTaskInput base class for non sql migration task input
type NonSQLMigrationTaskInput struct {
	// TargetConnectionInfo - Information for connecting to target
	TargetConnectionInfo *SQLConnectionInfo `json:"targetConnectionInfo,omitempty"`
	// TargetDatabaseName - Target database name
	TargetDatabaseName *string `json:"targetDatabaseName,omitempty"`
	// ProjectName - Name of the migration project
	ProjectName *string `json:"projectName,omitempty"`
	// ProjectLocation - A URL that points to the drop location to access project artifacts
	ProjectLocation *string `json:"projectLocation,omitempty"`
	// SelectedTables - Metadata of the tables selected for migration
	SelectedTables *[]NonSQLDataMigrationTable `json:"selectedTables,omitempty"`
}

// NonSQLMigrationTaskOutput base class for non sql migration task output
type NonSQLMigrationTaskOutput struct {
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// StartedOn - READ-ONLY; Migration start time
	StartedOn *date.Time `json:"startedOn,omitempty"`
	// EndedOn - READ-ONLY; Migration end time
	EndedOn *date.Time `json:"endedOn,omitempty"`
	// Status - READ-ONLY; Current state of migration. Possible values include: 'MigrationStatusDefault', 'MigrationStatusConnecting', 'MigrationStatusSourceAndTargetSelected', 'MigrationStatusSelectLogins', 'MigrationStatusConfigured', 'MigrationStatusRunning', 'MigrationStatusError', 'MigrationStatusStopped', 'MigrationStatusCompleted', 'MigrationStatusCompletedWithWarnings'
	Status MigrationStatus `json:"status,omitempty"`
	// DataMigrationTableResults - READ-ONLY; Results of the migration. The key contains the table name and the value the table result object
	DataMigrationTableResults map[string]*NonSQLDataMigrationTableResult `json:"dataMigrationTableResults"`
	// ProgressMessage - READ-ONLY; Message about the progress of the migration
	ProgressMessage *string `json:"progressMessage,omitempty"`
	// SourceServerName - READ-ONLY; Name of source server
	SourceServerName *string `json:"sourceServerName,omitempty"`
	// TargetServerName - READ-ONLY; Name of target server
	TargetServerName *string `json:"targetServerName,omitempty"`
}

// MarshalJSON is the custom marshaler for NonSQLMigrationTaskOutput.
func (nsmto NonSQLMigrationTaskOutput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ODataError error information in OData format.
type ODataError struct {
	// Code - READ-ONLY; The machine-readable description of the error, such as 'InvalidRequest' or 'InternalServerError'
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; The human-readable description of the error
	Message *string `json:"message,omitempty"`
	// Details - READ-ONLY; Inner errors that caused this error
	Details *[]ODataError `json:"details,omitempty"`
}

// OrphanedUserInfo information of orphaned users on the SQL server database.
type OrphanedUserInfo struct {
	// Name - Name of the orphaned user
	Name *string `json:"name,omitempty"`
	// DatabaseName - Parent database of the user
	DatabaseName *string `json:"databaseName,omitempty"`
}

// PostgreSQLConnectionInfo information for connecting to PostgreSQL server
type PostgreSQLConnectionInfo struct {
	// ServerName - Name of the server
	ServerName *string `json:"serverName,omitempty"`
	// DatabaseName - Name of the database
	DatabaseName *string `json:"databaseName,omitempty"`
	// Port - Port for Server
	Port *int32 `json:"port,omitempty"`
	// UserName - User name
	UserName *string `json:"userName,omitempty"`
	// Password - Password credential.
	Password *string `json:"password,omitempty"`
	// Type - Possible values include: 'TypeUnknown', 'TypeMiSQLConnectionInfo', 'TypePostgreSQLConnectionInfo', 'TypeMySQLConnectionInfo', 'TypeSQLConnectionInfo'
	Type Type `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for PostgreSQLConnectionInfo.
func (psci PostgreSQLConnectionInfo) MarshalJSON() ([]byte, error) {
	psci.Type = TypePostgreSQLConnectionInfo
	objectMap := make(map[string]interface{})
	if psci.ServerName != nil {
		objectMap["serverName"] = psci.ServerName
	}
	if psci.DatabaseName != nil {
		objectMap["databaseName"] = psci.DatabaseName
	}
	if psci.Port != nil {
		objectMap["port"] = psci.Port
	}
	if psci.UserName != nil {
		objectMap["userName"] = psci.UserName
	}
	if psci.Password != nil {
		objectMap["password"] = psci.Password
	}
	if psci.Type != "" {
		objectMap["type"] = psci.Type
	}
	return json.Marshal(objectMap)
}

// AsMiSQLConnectionInfo is the BasicConnectionInfo implementation for PostgreSQLConnectionInfo.
func (psci PostgreSQLConnectionInfo) AsMiSQLConnectionInfo() (*MiSQLConnectionInfo, bool) {
	return nil, false
}

// AsPostgreSQLConnectionInfo is the BasicConnectionInfo implementation for PostgreSQLConnectionInfo.
func (psci PostgreSQLConnectionInfo) AsPostgreSQLConnectionInfo() (*PostgreSQLConnectionInfo, bool) {
	return &psci, true
}

// AsMySQLConnectionInfo is the BasicConnectionInfo implementation for PostgreSQLConnectionInfo.
func (psci PostgreSQLConnectionInfo) AsMySQLConnectionInfo() (*MySQLConnectionInfo, bool) {
	return nil, false
}

// AsSQLConnectionInfo is the BasicConnectionInfo implementation for PostgreSQLConnectionInfo.
func (psci PostgreSQLConnectionInfo) AsSQLConnectionInfo() (*SQLConnectionInfo, bool) {
	return nil, false
}

// AsConnectionInfo is the BasicConnectionInfo implementation for PostgreSQLConnectionInfo.
func (psci PostgreSQLConnectionInfo) AsConnectionInfo() (*ConnectionInfo, bool) {
	return nil, false
}

// AsBasicConnectionInfo is the BasicConnectionInfo implementation for PostgreSQLConnectionInfo.
func (psci PostgreSQLConnectionInfo) AsBasicConnectionInfo() (BasicConnectionInfo, bool) {
	return &psci, true
}

// Project a project resource
type Project struct {
	autorest.Response `json:"-"`
	// ProjectProperties - Project properties
	*ProjectProperties `json:"properties,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Project.
func (p Project) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if p.ProjectProperties != nil {
		objectMap["properties"] = p.ProjectProperties
	}
	if p.Tags != nil {
		objectMap["tags"] = p.Tags
	}
	if p.Location != nil {
		objectMap["location"] = p.Location
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Project struct.
func (p *Project) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var projectProperties ProjectProperties
				err = json.Unmarshal(*v, &projectProperties)
				if err != nil {
					return err
				}
				p.ProjectProperties = &projectProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				p.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				p.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				p.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				p.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				p.Type = &typeVar
			}
		}
	}

	return nil
}

// ProjectList oData page of project resources
type ProjectList struct {
	autorest.Response `json:"-"`
	// Value - List of projects
	Value *[]Project `json:"value,omitempty"`
	// NextLink - URL to load the next page of projects
	NextLink *string `json:"nextLink,omitempty"`
}

// ProjectListIterator provides access to a complete listing of Project values.
type ProjectListIterator struct {
	i    int
	page ProjectListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ProjectListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProjectListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ProjectListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ProjectListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ProjectListIterator) Response() ProjectList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ProjectListIterator) Value() Project {
	if !iter.page.NotDone() {
		return Project{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ProjectListIterator type.
func NewProjectListIterator(page ProjectListPage) ProjectListIterator {
	return ProjectListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (pl ProjectList) IsEmpty() bool {
	return pl.Value == nil || len(*pl.Value) == 0
}

// projectListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pl ProjectList) projectListPreparer(ctx context.Context) (*http.Request, error) {
	if pl.NextLink == nil || len(to.String(pl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pl.NextLink)))
}

// ProjectListPage contains a page of Project values.
type ProjectListPage struct {
	fn func(context.Context, ProjectList) (ProjectList, error)
	pl ProjectList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ProjectListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProjectListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.pl)
	if err != nil {
		return err
	}
	page.pl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ProjectListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ProjectListPage) NotDone() bool {
	return !page.pl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ProjectListPage) Response() ProjectList {
	return page.pl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ProjectListPage) Values() []Project {
	if page.pl.IsEmpty() {
		return nil
	}
	return *page.pl.Value
}

// Creates a new instance of the ProjectListPage type.
func NewProjectListPage(getNextPage func(context.Context, ProjectList) (ProjectList, error)) ProjectListPage {
	return ProjectListPage{fn: getNextPage}
}

// ProjectMetadata common metadata for migration projects
type ProjectMetadata struct {
	// SourceServerName - READ-ONLY; Source server name
	SourceServerName *string `json:"sourceServerName,omitempty"`
	// SourceServerPort - READ-ONLY; Source server port number
	SourceServerPort *string `json:"sourceServerPort,omitempty"`
	// SourceUsername - READ-ONLY; Source username
	SourceUsername *string `json:"sourceUsername,omitempty"`
	// TargetServerName - READ-ONLY; Target server name
	TargetServerName *string `json:"targetServerName,omitempty"`
	// TargetUsername - READ-ONLY; Target username
	TargetUsername *string `json:"targetUsername,omitempty"`
	// TargetDbName - READ-ONLY; Target database name
	TargetDbName *string `json:"targetDbName,omitempty"`
	// TargetUsingWinAuth - READ-ONLY; Whether target connection is Windows authentication
	TargetUsingWinAuth *bool `json:"targetUsingWinAuth,omitempty"`
	// SelectedMigrationTables - READ-ONLY; List of tables selected for migration
	SelectedMigrationTables *[]MigrationTableMetadata `json:"selectedMigrationTables,omitempty"`
}

// ProjectProperties project-specific properties
type ProjectProperties struct {
	// SourcePlatform - Source platform for the project. Possible values include: 'ProjectSourcePlatformSQL', 'ProjectSourcePlatformUnknown'
	SourcePlatform ProjectSourcePlatform `json:"sourcePlatform,omitempty"`
	// TargetPlatform - Target platform for the project. Possible values include: 'ProjectTargetPlatformSQLDB', 'ProjectTargetPlatformUnknown'
	TargetPlatform ProjectTargetPlatform `json:"targetPlatform,omitempty"`
	// CreationTime - READ-ONLY; UTC Date and time when project was created
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// SourceConnectionInfo - Information for connecting to source
	SourceConnectionInfo BasicConnectionInfo `json:"sourceConnectionInfo,omitempty"`
	// TargetConnectionInfo - Information for connecting to target
	TargetConnectionInfo BasicConnectionInfo `json:"targetConnectionInfo,omitempty"`
	// DatabasesInfo - List of DatabaseInfo
	DatabasesInfo *[]DatabaseInfo `json:"databasesInfo,omitempty"`
	// ProvisioningState - READ-ONLY; The project's provisioning state. Possible values include: 'ProjectProvisioningStateDeleting', 'ProjectProvisioningStateSucceeded'
	ProvisioningState ProjectProvisioningState `json:"provisioningState,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for ProjectProperties struct.
func (pp *ProjectProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sourcePlatform":
			if v != nil {
				var sourcePlatform ProjectSourcePlatform
				err = json.Unmarshal(*v, &sourcePlatform)
				if err != nil {
					return err
				}
				pp.SourcePlatform = sourcePlatform
			}
		case "targetPlatform":
			if v != nil {
				var targetPlatform ProjectTargetPlatform
				err = json.Unmarshal(*v, &targetPlatform)
				if err != nil {
					return err
				}
				pp.TargetPlatform = targetPlatform
			}
		case "creationTime":
			if v != nil {
				var creationTime date.Time
				err = json.Unmarshal(*v, &creationTime)
				if err != nil {
					return err
				}
				pp.CreationTime = &creationTime
			}
		case "sourceConnectionInfo":
			if v != nil {
				sourceConnectionInfo, err := unmarshalBasicConnectionInfo(*v)
				if err != nil {
					return err
				}
				pp.SourceConnectionInfo = sourceConnectionInfo
			}
		case "targetConnectionInfo":
			if v != nil {
				targetConnectionInfo, err := unmarshalBasicConnectionInfo(*v)
				if err != nil {
					return err
				}
				pp.TargetConnectionInfo = targetConnectionInfo
			}
		case "databasesInfo":
			if v != nil {
				var databasesInfo []DatabaseInfo
				err = json.Unmarshal(*v, &databasesInfo)
				if err != nil {
					return err
				}
				pp.DatabasesInfo = &databasesInfo
			}
		case "provisioningState":
			if v != nil {
				var provisioningState ProjectProvisioningState
				err = json.Unmarshal(*v, &provisioningState)
				if err != nil {
					return err
				}
				pp.ProvisioningState = provisioningState
			}
		}
	}

	return nil
}

// ProjectTask a task resource
type ProjectTask struct {
	autorest.Response `json:"-"`
	// Etag - HTTP strong entity tag value. This is ignored if submitted.
	Etag *string `json:"etag,omitempty"`
	// Properties - Custom task properties
	Properties BasicProjectTaskProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for ProjectTask struct.
func (pt *ProjectTask) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				pt.Etag = &etag
			}
		case "properties":
			if v != nil {
				properties, err := unmarshalBasicProjectTaskProperties(*v)
				if err != nil {
					return err
				}
				pt.Properties = properties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pt.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pt.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pt.Type = &typeVar
			}
		}
	}

	return nil
}

// BasicProjectTaskProperties base class for all types of DMS task properties. If task is not supported by current
// client, this object is returned.
type BasicProjectTaskProperties interface {
	AsGetTdeCertificatesSQLTaskProperties() (*GetTdeCertificatesSQLTaskProperties, bool)
	AsValidateMigrationInputSQLServerSQLMISyncTaskProperties() (*ValidateMigrationInputSQLServerSQLMISyncTaskProperties, bool)
	AsValidateMigrationInputSQLServerSQLMITaskProperties() (*ValidateMigrationInputSQLServerSQLMITaskProperties, bool)
	AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties() (*ValidateMigrationInputSQLServerSQLDbSyncTaskProperties, bool)
	AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties, bool)
	AsMigrateMySQLAzureDbForMySQLSyncTaskProperties() (*MigrateMySQLAzureDbForMySQLSyncTaskProperties, bool)
	AsMigrateSQLServerSQLDbSyncTaskProperties() (*MigrateSQLServerSQLDbSyncTaskProperties, bool)
	AsMigrateSQLServerSQLDbTaskProperties() (*MigrateSQLServerSQLDbTaskProperties, bool)
	AsMigrateSQLServerSQLMISyncTaskProperties() (*MigrateSQLServerSQLMISyncTaskProperties, bool)
	AsMigrateSQLServerSQLMITaskProperties() (*MigrateSQLServerSQLMITaskProperties, bool)
	AsConnectToTargetAzureDbForMySQLTaskProperties() (*ConnectToTargetAzureDbForMySQLTaskProperties, bool)
	AsConnectToTargetSQLMISyncTaskProperties() (*ConnectToTargetSQLMISyncTaskProperties, bool)
	AsConnectToTargetSQLMITaskProperties() (*ConnectToTargetSQLMITaskProperties, bool)
	AsGetUserTablesSQLSyncTaskProperties() (*GetUserTablesSQLSyncTaskProperties, bool)
	AsGetUserTablesSQLTaskProperties() (*GetUserTablesSQLTaskProperties, bool)
	AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties, bool)
	AsConnectToTargetSQLSQLDbSyncTaskProperties() (*ConnectToTargetSQLSQLDbSyncTaskProperties, bool)
	AsConnectToTargetSQLDbTaskProperties() (*ConnectToTargetSQLDbTaskProperties, bool)
	AsConnectToSourcePostgreSQLSyncTaskProperties() (*ConnectToSourcePostgreSQLSyncTaskProperties, bool)
	AsConnectToSourceSQLServerSyncTaskProperties() (*ConnectToSourceSQLServerSyncTaskProperties, bool)
	AsConnectToSourceSQLServerTaskProperties() (*ConnectToSourceSQLServerTaskProperties, bool)
	AsConnectToSourceMySQLTaskProperties() (*ConnectToSourceMySQLTaskProperties, bool)
	AsProjectTaskProperties() (*ProjectTaskProperties, bool)
}

// ProjectTaskProperties base class for all types of DMS task properties. If task is not supported by current
// client, this object is returned.
type ProjectTaskProperties struct {
	// Errors - READ-ONLY; Array of errors. This is ignored if submitted.
	Errors *[]ODataError `json:"errors,omitempty"`
	// State - READ-ONLY; The state of the task. This is ignored if submitted. Possible values include: 'TaskStateUnknown', 'TaskStateQueued', 'TaskStateRunning', 'TaskStateCanceled', 'TaskStateSucceeded', 'TaskStateFailed', 'TaskStateFailedInputValidation', 'TaskStateFaulted'
	State TaskState `json:"state,omitempty"`
	// Commands - READ-ONLY; Array of command properties.
	Commands *[]BasicCommandProperties `json:"commands,omitempty"`
	// TaskType - Possible values include: 'TaskTypeUnknown', 'TaskTypeGetTDECertificatesSQL', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMISyncLRS', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMI', 'TaskTypeValidateMigrationInputSQLServerSQLDbSync', 'TaskTypeMigratePostgreSQLAzureDbForPostgreSQLSync', 'TaskTypeMigrateMySQLAzureDbForMySQLSync', 'TaskTypeMigrateSQLServerAzureSQLDbSync', 'TaskTypeMigrateSQLServerSQLDb', 'TaskTypeMigrateSQLServerAzureSQLDbMISyncLRS', 'TaskTypeMigrateSQLServerAzureSQLDbMI', 'TaskTypeConnectToTargetAzureDbForMySQL', 'TaskTypeConnectToTargetAzureSQLDbMISyncLRS', 'TaskTypeConnectToTargetAzureSQLDbMI', 'TaskTypeGetUserTablesAzureSQLDbSync', 'TaskTypeGetUserTablesSQL', 'TaskTypeConnectToTargetAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetSQLDbSync', 'TaskTypeConnectToTargetSQLDb', 'TaskTypeConnectToSourcePostgreSQLSync', 'TaskTypeConnectToSourceSQLServerSync', 'TaskTypeConnectToSourceSQLServer', 'TaskTypeConnectToSourceMySQL'
	TaskType TaskType `json:"taskType,omitempty"`
}

func unmarshalBasicProjectTaskProperties(body []byte) (BasicProjectTaskProperties, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["taskType"] {
	case string(TaskTypeGetTDECertificatesSQL):
		var gtcstp GetTdeCertificatesSQLTaskProperties
		err := json.Unmarshal(body, &gtcstp)
		return gtcstp, err
	case string(TaskTypeValidateMigrationInputSQLServerAzureSQLDbMISyncLRS):
		var vmisssmstp ValidateMigrationInputSQLServerSQLMISyncTaskProperties
		err := json.Unmarshal(body, &vmisssmstp)
		return vmisssmstp, err
	case string(TaskTypeValidateMigrationInputSQLServerAzureSQLDbMI):
		var vmisssmtp ValidateMigrationInputSQLServerSQLMITaskProperties
		err := json.Unmarshal(body, &vmisssmtp)
		return vmisssmtp, err
	case string(TaskTypeValidateMigrationInputSQLServerSQLDbSync):
		var vmisssdstp ValidateMigrationInputSQLServerSQLDbSyncTaskProperties
		err := json.Unmarshal(body, &vmisssdstp)
		return vmisssdstp, err
	case string(TaskTypeMigratePostgreSQLAzureDbForPostgreSQLSync):
		var mpsadfpsstp MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties
		err := json.Unmarshal(body, &mpsadfpsstp)
		return mpsadfpsstp, err
	case string(TaskTypeMigrateMySQLAzureDbForMySQLSync):
		var mmsadfmsstp MigrateMySQLAzureDbForMySQLSyncTaskProperties
		err := json.Unmarshal(body, &mmsadfmsstp)
		return mmsadfmsstp, err
	case string(TaskTypeMigrateSQLServerAzureSQLDbSync):
		var msssdstp MigrateSQLServerSQLDbSyncTaskProperties
		err := json.Unmarshal(body, &msssdstp)
		return msssdstp, err
	case string(TaskTypeMigrateSQLServerSQLDb):
		var msssdtp MigrateSQLServerSQLDbTaskProperties
		err := json.Unmarshal(body, &msssdtp)
		return msssdtp, err
	case string(TaskTypeMigrateSQLServerAzureSQLDbMISyncLRS):
		var msssmstp MigrateSQLServerSQLMISyncTaskProperties
		err := json.Unmarshal(body, &msssmstp)
		return msssmstp, err
	case string(TaskTypeMigrateSQLServerAzureSQLDbMI):
		var msssmtp MigrateSQLServerSQLMITaskProperties
		err := json.Unmarshal(body, &msssmtp)
		return msssmtp, err
	case string(TaskTypeConnectToTargetAzureDbForMySQL):
		var cttadfmstp ConnectToTargetAzureDbForMySQLTaskProperties
		err := json.Unmarshal(body, &cttadfmstp)
		return cttadfmstp, err
	case string(TaskTypeConnectToTargetAzureSQLDbMISyncLRS):
		var cttsmstp ConnectToTargetSQLMISyncTaskProperties
		err := json.Unmarshal(body, &cttsmstp)
		return cttsmstp, err
	case string(TaskTypeConnectToTargetAzureSQLDbMI):
		var cttsmtp ConnectToTargetSQLMITaskProperties
		err := json.Unmarshal(body, &cttsmtp)
		return cttsmtp, err
	case string(TaskTypeGetUserTablesAzureSQLDbSync):
		var gutsstp GetUserTablesSQLSyncTaskProperties
		err := json.Unmarshal(body, &gutsstp)
		return gutsstp, err
	case string(TaskTypeGetUserTablesSQL):
		var gutstp GetUserTablesSQLTaskProperties
		err := json.Unmarshal(body, &gutstp)
		return gutstp, err
	case string(TaskTypeConnectToTargetAzureDbForPostgreSQLSync):
		var cttadfpsstp ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties
		err := json.Unmarshal(body, &cttadfpsstp)
		return cttadfpsstp, err
	case string(TaskTypeConnectToTargetSQLDbSync):
		var cttssdstp ConnectToTargetSQLSQLDbSyncTaskProperties
		err := json.Unmarshal(body, &cttssdstp)
		return cttssdstp, err
	case string(TaskTypeConnectToTargetSQLDb):
		var cttsdtp ConnectToTargetSQLDbTaskProperties
		err := json.Unmarshal(body, &cttsdtp)
		return cttsdtp, err
	case string(TaskTypeConnectToSourcePostgreSQLSync):
		var ctspsstp ConnectToSourcePostgreSQLSyncTaskProperties
		err := json.Unmarshal(body, &ctspsstp)
		return ctspsstp, err
	case string(TaskTypeConnectToSourceSQLServerSync):
		var ctsssstp ConnectToSourceSQLServerSyncTaskProperties
		err := json.Unmarshal(body, &ctsssstp)
		return ctsssstp, err
	case string(TaskTypeConnectToSourceSQLServer):
		var ctssstp ConnectToSourceSQLServerTaskProperties
		err := json.Unmarshal(body, &ctssstp)
		return ctssstp, err
	case string(TaskTypeConnectToSourceMySQL):
		var ctsmstp ConnectToSourceMySQLTaskProperties
		err := json.Unmarshal(body, &ctsmstp)
		return ctsmstp, err
	default:
		var ptp ProjectTaskProperties
		err := json.Unmarshal(body, &ptp)
		return ptp, err
	}
}
func unmarshalBasicProjectTaskPropertiesArray(body []byte) ([]BasicProjectTaskProperties, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	ptpArray := make([]BasicProjectTaskProperties, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ptp, err := unmarshalBasicProjectTaskProperties(*rawMessage)
		if err != nil {
			return nil, err
		}
		ptpArray[index] = ptp
	}
	return ptpArray, nil
}

// MarshalJSON is the custom marshaler for ProjectTaskProperties.
func (ptp ProjectTaskProperties) MarshalJSON() ([]byte, error) {
	ptp.TaskType = TaskTypeUnknown
	objectMap := make(map[string]interface{})
	if ptp.TaskType != "" {
		objectMap["taskType"] = ptp.TaskType
	}
	return json.Marshal(objectMap)
}

// AsGetTdeCertificatesSQLTaskProperties is the BasicProjectTaskProperties implementation for ProjectTaskProperties.
func (ptp ProjectTaskProperties) AsGetTdeCertificatesSQLTaskProperties() (*GetTdeCertificatesSQLTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ProjectTaskProperties.
func (ptp ProjectTaskProperties) AsValidateMigrationInputSQLServerSQLMISyncTaskProperties() (*ValidateMigrationInputSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for ProjectTaskProperties.
func (ptp ProjectTaskProperties) AsValidateMigrationInputSQLServerSQLMITaskProperties() (*ValidateMigrationInputSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ProjectTaskProperties.
func (ptp ProjectTaskProperties) AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties() (*ValidateMigrationInputSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ProjectTaskProperties.
func (ptp ProjectTaskProperties) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ProjectTaskProperties.
func (ptp ProjectTaskProperties) AsMigrateMySQLAzureDbForMySQLSyncTaskProperties() (*MigrateMySQLAzureDbForMySQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ProjectTaskProperties.
func (ptp ProjectTaskProperties) AsMigrateSQLServerSQLDbSyncTaskProperties() (*MigrateSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ProjectTaskProperties.
func (ptp ProjectTaskProperties) AsMigrateSQLServerSQLDbTaskProperties() (*MigrateSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ProjectTaskProperties.
func (ptp ProjectTaskProperties) AsMigrateSQLServerSQLMISyncTaskProperties() (*MigrateSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for ProjectTaskProperties.
func (ptp ProjectTaskProperties) AsMigrateSQLServerSQLMITaskProperties() (*MigrateSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForMySQLTaskProperties is the BasicProjectTaskProperties implementation for ProjectTaskProperties.
func (ptp ProjectTaskProperties) AsConnectToTargetAzureDbForMySQLTaskProperties() (*ConnectToTargetAzureDbForMySQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ProjectTaskProperties.
func (ptp ProjectTaskProperties) AsConnectToTargetSQLMISyncTaskProperties() (*ConnectToTargetSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMITaskProperties is the BasicProjectTaskProperties implementation for ProjectTaskProperties.
func (ptp ProjectTaskProperties) AsConnectToTargetSQLMITaskProperties() (*ConnectToTargetSQLMITaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ProjectTaskProperties.
func (ptp ProjectTaskProperties) AsGetUserTablesSQLSyncTaskProperties() (*GetUserTablesSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLTaskProperties is the BasicProjectTaskProperties implementation for ProjectTaskProperties.
func (ptp ProjectTaskProperties) AsGetUserTablesSQLTaskProperties() (*GetUserTablesSQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ProjectTaskProperties.
func (ptp ProjectTaskProperties) AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ProjectTaskProperties.
func (ptp ProjectTaskProperties) AsConnectToTargetSQLSQLDbSyncTaskProperties() (*ConnectToTargetSQLSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ProjectTaskProperties.
func (ptp ProjectTaskProperties) AsConnectToTargetSQLDbTaskProperties() (*ConnectToTargetSQLDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourcePostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ProjectTaskProperties.
func (ptp ProjectTaskProperties) AsConnectToSourcePostgreSQLSyncTaskProperties() (*ConnectToSourcePostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerSyncTaskProperties is the BasicProjectTaskProperties implementation for ProjectTaskProperties.
func (ptp ProjectTaskProperties) AsConnectToSourceSQLServerSyncTaskProperties() (*ConnectToSourceSQLServerSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskProperties is the BasicProjectTaskProperties implementation for ProjectTaskProperties.
func (ptp ProjectTaskProperties) AsConnectToSourceSQLServerTaskProperties() (*ConnectToSourceSQLServerTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceMySQLTaskProperties is the BasicProjectTaskProperties implementation for ProjectTaskProperties.
func (ptp ProjectTaskProperties) AsConnectToSourceMySQLTaskProperties() (*ConnectToSourceMySQLTaskProperties, bool) {
	return nil, false
}

// AsProjectTaskProperties is the BasicProjectTaskProperties implementation for ProjectTaskProperties.
func (ptp ProjectTaskProperties) AsProjectTaskProperties() (*ProjectTaskProperties, bool) {
	return &ptp, true
}

// AsBasicProjectTaskProperties is the BasicProjectTaskProperties implementation for ProjectTaskProperties.
func (ptp ProjectTaskProperties) AsBasicProjectTaskProperties() (BasicProjectTaskProperties, bool) {
	return &ptp, true
}

// UnmarshalJSON is the custom unmarshaler for ProjectTaskProperties struct.
func (ptp *ProjectTaskProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "errors":
			if v != nil {
				var errorsVar []ODataError
				err = json.Unmarshal(*v, &errorsVar)
				if err != nil {
					return err
				}
				ptp.Errors = &errorsVar
			}
		case "state":
			if v != nil {
				var state TaskState
				err = json.Unmarshal(*v, &state)
				if err != nil {
					return err
				}
				ptp.State = state
			}
		case "commands":
			if v != nil {
				commands, err := unmarshalBasicCommandPropertiesArray(*v)
				if err != nil {
					return err
				}
				ptp.Commands = &commands
			}
		case "taskType":
			if v != nil {
				var taskType TaskType
				err = json.Unmarshal(*v, &taskType)
				if err != nil {
					return err
				}
				ptp.TaskType = taskType
			}
		}
	}

	return nil
}

// QueryAnalysisValidationResult results for query analysis comparison between the source and target
type QueryAnalysisValidationResult struct {
	// QueryResults - READ-ONLY; List of queries executed and it's execution results in source and target
	QueryResults *QueryExecutionResult `json:"queryResults,omitempty"`
	// ValidationErrors - READ-ONLY; Errors that are part of the execution
	ValidationErrors *ValidationError `json:"validationErrors,omitempty"`
}

// QueryExecutionResult describes query analysis results for execution in source and target
type QueryExecutionResult struct {
	// QueryText - READ-ONLY; Query text retrieved from the source server
	QueryText *string `json:"queryText,omitempty"`
	// StatementsInBatch - READ-ONLY; Total no. of statements in the batch
	StatementsInBatch *int64 `json:"statementsInBatch,omitempty"`
	// SourceResult - READ-ONLY; Query analysis result from the source
	SourceResult *ExecutionStatistics `json:"sourceResult,omitempty"`
	// TargetResult - READ-ONLY; Query analysis result from the target
	TargetResult *ExecutionStatistics `json:"targetResult,omitempty"`
}

// Quota describes a quota for or usage details about a resource
type Quota struct {
	// CurrentValue - The current value of the quota. If null or missing, the current value cannot be determined in the context of the request.
	CurrentValue *float64 `json:"currentValue,omitempty"`
	// ID - The resource ID of the quota object
	ID *string `json:"id,omitempty"`
	// Limit - The maximum value of the quota. If null or missing, the quota has no maximum, in which case it merely tracks usage.
	Limit *float64 `json:"limit,omitempty"`
	// Name - The name of the quota
	Name *QuotaName `json:"name,omitempty"`
	// Unit - The unit for the quota, such as Count, Bytes, BytesPerSecond, etc.
	Unit *string `json:"unit,omitempty"`
}

// QuotaList oData page of quota objects
type QuotaList struct {
	autorest.Response `json:"-"`
	// Value - List of quotas
	Value *[]Quota `json:"value,omitempty"`
	// NextLink - URL to load the next page of quotas, or null or missing if this is the last page
	NextLink *string `json:"nextLink,omitempty"`
}

// QuotaListIterator provides access to a complete listing of Quota values.
type QuotaListIterator struct {
	i    int
	page QuotaListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *QuotaListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/QuotaListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *QuotaListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter QuotaListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter QuotaListIterator) Response() QuotaList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter QuotaListIterator) Value() Quota {
	if !iter.page.NotDone() {
		return Quota{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the QuotaListIterator type.
func NewQuotaListIterator(page QuotaListPage) QuotaListIterator {
	return QuotaListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ql QuotaList) IsEmpty() bool {
	return ql.Value == nil || len(*ql.Value) == 0
}

// quotaListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ql QuotaList) quotaListPreparer(ctx context.Context) (*http.Request, error) {
	if ql.NextLink == nil || len(to.String(ql.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ql.NextLink)))
}

// QuotaListPage contains a page of Quota values.
type QuotaListPage struct {
	fn func(context.Context, QuotaList) (QuotaList, error)
	ql QuotaList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *QuotaListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/QuotaListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.ql)
	if err != nil {
		return err
	}
	page.ql = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *QuotaListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page QuotaListPage) NotDone() bool {
	return !page.ql.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page QuotaListPage) Response() QuotaList {
	return page.ql
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page QuotaListPage) Values() []Quota {
	if page.ql.IsEmpty() {
		return nil
	}
	return *page.ql.Value
}

// Creates a new instance of the QuotaListPage type.
func NewQuotaListPage(getNextPage func(context.Context, QuotaList) (QuotaList, error)) QuotaListPage {
	return QuotaListPage{fn: getNextPage}
}

// QuotaName the name of the quota
type QuotaName struct {
	// LocalizedValue - The localized name of the quota
	LocalizedValue *string `json:"localizedValue,omitempty"`
	// Value - The unlocalized name (or ID) of the quota
	Value *string `json:"value,omitempty"`
}

// ReportableException exception object for all custom exceptions
type ReportableException struct {
	// Message - READ-ONLY; Error message
	Message *string `json:"message,omitempty"`
	// ActionableMessage - Actionable steps for this exception
	ActionableMessage *string `json:"actionableMessage,omitempty"`
	// FilePath - READ-ONLY; The path to the file where exception occurred
	FilePath *string `json:"filePath,omitempty"`
	// LineNumber - READ-ONLY; The line number where exception occurred
	LineNumber *string `json:"lineNumber,omitempty"`
	// HResult - READ-ONLY; Coded numerical value that is assigned to a specific exception
	HResult *int32 `json:"hResult,omitempty"`
	// StackTrace - READ-ONLY; Stack trace
	StackTrace *string `json:"stackTrace,omitempty"`
}

// Resource ARM resource.
type Resource struct {
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// ResourceSku describes an available DMS SKU.
type ResourceSku struct {
	// ResourceType - READ-ONLY; The type of resource the SKU applies to.
	ResourceType *string `json:"resourceType,omitempty"`
	// Name - READ-ONLY; The name of SKU.
	Name *string `json:"name,omitempty"`
	// Tier - READ-ONLY; Specifies the tier of DMS in a scale set.
	Tier *string `json:"tier,omitempty"`
	// Size - READ-ONLY; The Size of the SKU.
	Size *string `json:"size,omitempty"`
	// Family - READ-ONLY; The Family of this particular SKU.
	Family *string `json:"family,omitempty"`
	// Kind - READ-ONLY; The Kind of resources that are supported in this SKU.
	Kind *string `json:"kind,omitempty"`
	// Capacity - READ-ONLY; Not used.
	Capacity *ResourceSkuCapacity `json:"capacity,omitempty"`
	// Locations - READ-ONLY; The set of locations that the SKU is available.
	Locations *[]string `json:"locations,omitempty"`
	// APIVersions - READ-ONLY; The api versions that support this SKU.
	APIVersions *[]string `json:"apiVersions,omitempty"`
	// Costs - READ-ONLY; Metadata for retrieving price info.
	Costs *[]ResourceSkuCosts `json:"costs,omitempty"`
	// Capabilities - READ-ONLY; A name value pair to describe the capability.
	Capabilities *[]ResourceSkuCapabilities `json:"capabilities,omitempty"`
	// Restrictions - READ-ONLY; The restrictions because of which SKU cannot be used. This is empty if there are no restrictions.
	Restrictions *[]ResourceSkuRestrictions `json:"restrictions,omitempty"`
}

// ResourceSkuCapabilities describes The SKU capabilities object.
type ResourceSkuCapabilities struct {
	// Name - READ-ONLY; An invariant to describe the feature.
	Name *string `json:"name,omitempty"`
	// Value - READ-ONLY; An invariant if the feature is measured by quantity.
	Value *string `json:"value,omitempty"`
}

// ResourceSkuCapacity describes scaling information of a SKU.
type ResourceSkuCapacity struct {
	// Minimum - READ-ONLY; The minimum capacity.
	Minimum *int64 `json:"minimum,omitempty"`
	// Maximum - READ-ONLY; The maximum capacity.
	Maximum *int64 `json:"maximum,omitempty"`
	// Default - READ-ONLY; The default capacity.
	Default *int64 `json:"default,omitempty"`
	// ScaleType - READ-ONLY; The scale type applicable to the SKU. Possible values include: 'ResourceSkuCapacityScaleTypeAutomatic', 'ResourceSkuCapacityScaleTypeManual', 'ResourceSkuCapacityScaleTypeNone'
	ScaleType ResourceSkuCapacityScaleType `json:"scaleType,omitempty"`
}

// ResourceSkuCosts describes metadata for retrieving price info.
type ResourceSkuCosts struct {
	// MeterID - READ-ONLY; Used for querying price from commerce.
	MeterID *string `json:"meterID,omitempty"`
	// Quantity - READ-ONLY; The multiplier is needed to extend the base metered cost.
	Quantity *int64 `json:"quantity,omitempty"`
	// ExtendedUnit - READ-ONLY; An invariant to show the extended unit.
	ExtendedUnit *string `json:"extendedUnit,omitempty"`
}

// ResourceSkuRestrictions describes scaling information of a SKU.
type ResourceSkuRestrictions struct {
	// Type - READ-ONLY; The type of restrictions. Possible values include: 'Location'
	Type ResourceSkuRestrictionsType `json:"type,omitempty"`
	// Values - READ-ONLY; The value of restrictions. If the restriction type is set to location. This would be different locations where the SKU is restricted.
	Values *[]string `json:"values,omitempty"`
	// ReasonCode - READ-ONLY; The reason code for restriction. Possible values include: 'QuotaID', 'NotAvailableForSubscription'
	ReasonCode ResourceSkuRestrictionsReasonCode `json:"reasonCode,omitempty"`
}

// ResourceSkusResult the DMS List SKUs operation response.
type ResourceSkusResult struct {
	autorest.Response `json:"-"`
	// Value - The list of SKUs available for the subscription.
	Value *[]ResourceSku `json:"value,omitempty"`
	// NextLink - The uri to fetch the next page of DMS SKUs. Call ListNext() with this to fetch the next page of DMS SKUs.
	NextLink *string `json:"nextLink,omitempty"`
}

// ResourceSkusResultIterator provides access to a complete listing of ResourceSku values.
type ResourceSkusResultIterator struct {
	i    int
	page ResourceSkusResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ResourceSkusResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceSkusResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ResourceSkusResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ResourceSkusResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ResourceSkusResultIterator) Response() ResourceSkusResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ResourceSkusResultIterator) Value() ResourceSku {
	if !iter.page.NotDone() {
		return ResourceSku{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ResourceSkusResultIterator type.
func NewResourceSkusResultIterator(page ResourceSkusResultPage) ResourceSkusResultIterator {
	return ResourceSkusResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rsr ResourceSkusResult) IsEmpty() bool {
	return rsr.Value == nil || len(*rsr.Value) == 0
}

// resourceSkusResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rsr ResourceSkusResult) resourceSkusResultPreparer(ctx context.Context) (*http.Request, error) {
	if rsr.NextLink == nil || len(to.String(rsr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rsr.NextLink)))
}

// ResourceSkusResultPage contains a page of ResourceSku values.
type ResourceSkusResultPage struct {
	fn  func(context.Context, ResourceSkusResult) (ResourceSkusResult, error)
	rsr ResourceSkusResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ResourceSkusResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceSkusResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.rsr)
	if err != nil {
		return err
	}
	page.rsr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ResourceSkusResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ResourceSkusResultPage) NotDone() bool {
	return !page.rsr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ResourceSkusResultPage) Response() ResourceSkusResult {
	return page.rsr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ResourceSkusResultPage) Values() []ResourceSku {
	if page.rsr.IsEmpty() {
		return nil
	}
	return *page.rsr.Value
}

// Creates a new instance of the ResourceSkusResultPage type.
func NewResourceSkusResultPage(getNextPage func(context.Context, ResourceSkusResult) (ResourceSkusResult, error)) ResourceSkusResultPage {
	return ResourceSkusResultPage{fn: getNextPage}
}

// SchemaComparisonValidationResult results for schema comparison between the source and target
type SchemaComparisonValidationResult struct {
	// SchemaDifferences - READ-ONLY; List of schema differences between the source and target databases
	SchemaDifferences *SchemaComparisonValidationResultType `json:"schemaDifferences,omitempty"`
	// ValidationErrors - READ-ONLY; List of errors that happened while performing schema compare validation
	ValidationErrors *ValidationError `json:"validationErrors,omitempty"`
	// SourceDatabaseObjectCount - Count of source database objects
	SourceDatabaseObjectCount map[string]*int64 `json:"sourceDatabaseObjectCount"`
	// TargetDatabaseObjectCount - Count of target database objects
	TargetDatabaseObjectCount map[string]*int64 `json:"targetDatabaseObjectCount"`
}

// MarshalJSON is the custom marshaler for SchemaComparisonValidationResult.
func (scvr SchemaComparisonValidationResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if scvr.SourceDatabaseObjectCount != nil {
		objectMap["sourceDatabaseObjectCount"] = scvr.SourceDatabaseObjectCount
	}
	if scvr.TargetDatabaseObjectCount != nil {
		objectMap["targetDatabaseObjectCount"] = scvr.TargetDatabaseObjectCount
	}
	return json.Marshal(objectMap)
}

// SchemaComparisonValidationResultType description about the errors happen while performing migration
// validation
type SchemaComparisonValidationResultType struct {
	// ObjectName - READ-ONLY; Name of the object that has the difference
	ObjectName *string `json:"objectName,omitempty"`
	// ObjectType - READ-ONLY; Type of the object that has the difference. e.g (Table/View/StoredProcedure). Possible values include: 'StoredProcedures', 'Table', 'User', 'View', 'Function'
	ObjectType ObjectType `json:"objectType,omitempty"`
	// UpdateAction - READ-ONLY; Update action type with respect to target. Possible values include: 'DeletedOnTarget', 'ChangedOnTarget', 'AddedOnTarget'
	UpdateAction UpdateActionType `json:"updateAction,omitempty"`
}

// SelectedCertificateInput info for certificate to be exported for TDE enabled databases.
type SelectedCertificateInput struct {
	// CertificateName - Name of certificate to be exported.
	CertificateName *string `json:"certificateName,omitempty"`
	// Password - Password to use for encrypting the exported certificate.
	Password *string `json:"password,omitempty"`
}

// ServerProperties server properties for Oracle, MySQL type source
type ServerProperties struct {
	// ServerPlatform - READ-ONLY; Name of the server platform
	ServerPlatform *string `json:"serverPlatform,omitempty"`
	// ServerName - READ-ONLY; Name of the server
	ServerName *string `json:"serverName,omitempty"`
	// ServerVersion - READ-ONLY; Version of the database server
	ServerVersion *string `json:"serverVersion,omitempty"`
	// ServerEdition - READ-ONLY; Edition of the database server
	ServerEdition *string `json:"serverEdition,omitempty"`
	// ServerOperatingSystemVersion - READ-ONLY; Version of the operating system
	ServerOperatingSystemVersion *string `json:"serverOperatingSystemVersion,omitempty"`
	// ServerDatabaseCount - READ-ONLY; Number of databases in the server
	ServerDatabaseCount *int32 `json:"serverDatabaseCount,omitempty"`
}

// Service a Database Migration Service resource
type Service struct {
	autorest.Response `json:"-"`
	// Etag - HTTP strong entity tag value. Ignored if submitted
	Etag *string `json:"etag,omitempty"`
	// Kind - The resource kind. Only 'vm' (the default) is supported.
	Kind *string `json:"kind,omitempty"`
	// ServiceProperties - Custom service properties
	*ServiceProperties `json:"properties,omitempty"`
	// Sku - Service SKU
	Sku *ServiceSku `json:"sku,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Service.
func (s Service) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if s.Etag != nil {
		objectMap["etag"] = s.Etag
	}
	if s.Kind != nil {
		objectMap["kind"] = s.Kind
	}
	if s.ServiceProperties != nil {
		objectMap["properties"] = s.ServiceProperties
	}
	if s.Sku != nil {
		objectMap["sku"] = s.Sku
	}
	if s.Tags != nil {
		objectMap["tags"] = s.Tags
	}
	if s.Location != nil {
		objectMap["location"] = s.Location
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Service struct.
func (s *Service) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				s.Etag = &etag
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				s.Kind = &kind
			}
		case "properties":
			if v != nil {
				var serviceProperties ServiceProperties
				err = json.Unmarshal(*v, &serviceProperties)
				if err != nil {
					return err
				}
				s.ServiceProperties = &serviceProperties
			}
		case "sku":
			if v != nil {
				var sku ServiceSku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				s.Sku = &sku
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				s.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				s.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				s.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				s.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				s.Type = &typeVar
			}
		}
	}

	return nil
}

// ServiceList oData page of service objects
type ServiceList struct {
	autorest.Response `json:"-"`
	// Value - List of services
	Value *[]Service `json:"value,omitempty"`
	// NextLink - URL to load the next page of services
	NextLink *string `json:"nextLink,omitempty"`
}

// ServiceListIterator provides access to a complete listing of Service values.
type ServiceListIterator struct {
	i    int
	page ServiceListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ServiceListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ServiceListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ServiceListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ServiceListIterator) Response() ServiceList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ServiceListIterator) Value() Service {
	if !iter.page.NotDone() {
		return Service{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ServiceListIterator type.
func NewServiceListIterator(page ServiceListPage) ServiceListIterator {
	return ServiceListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sl ServiceList) IsEmpty() bool {
	return sl.Value == nil || len(*sl.Value) == 0
}

// serviceListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sl ServiceList) serviceListPreparer(ctx context.Context) (*http.Request, error) {
	if sl.NextLink == nil || len(to.String(sl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sl.NextLink)))
}

// ServiceListPage contains a page of Service values.
type ServiceListPage struct {
	fn func(context.Context, ServiceList) (ServiceList, error)
	sl ServiceList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ServiceListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.sl)
	if err != nil {
		return err
	}
	page.sl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ServiceListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ServiceListPage) NotDone() bool {
	return !page.sl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ServiceListPage) Response() ServiceList {
	return page.sl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ServiceListPage) Values() []Service {
	if page.sl.IsEmpty() {
		return nil
	}
	return *page.sl.Value
}

// Creates a new instance of the ServiceListPage type.
func NewServiceListPage(getNextPage func(context.Context, ServiceList) (ServiceList, error)) ServiceListPage {
	return ServiceListPage{fn: getNextPage}
}

// ServiceOperation description of an action supported by the Database Migration Service
type ServiceOperation struct {
	// Name - The fully qualified action name, e.g. Microsoft.DataMigration/services/read
	Name *string `json:"name,omitempty"`
	// Display - Localized display text
	Display *ServiceOperationDisplay `json:"display,omitempty"`
}

// ServiceOperationDisplay localized display text
type ServiceOperationDisplay struct {
	// Provider - The localized resource provider name
	Provider *string `json:"provider,omitempty"`
	// Resource - The localized resource type name
	Resource *string `json:"resource,omitempty"`
	// Operation - The localized operation name
	Operation *string `json:"operation,omitempty"`
	// Description - The localized operation description
	Description *string `json:"description,omitempty"`
}

// ServiceOperationList oData page of action (operation) objects
type ServiceOperationList struct {
	autorest.Response `json:"-"`
	// Value - List of actions
	Value *[]ServiceOperation `json:"value,omitempty"`
	// NextLink - URL to load the next page of actions
	NextLink *string `json:"nextLink,omitempty"`
}

// ServiceOperationListIterator provides access to a complete listing of ServiceOperation values.
type ServiceOperationListIterator struct {
	i    int
	page ServiceOperationListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ServiceOperationListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceOperationListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ServiceOperationListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ServiceOperationListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ServiceOperationListIterator) Response() ServiceOperationList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ServiceOperationListIterator) Value() ServiceOperation {
	if !iter.page.NotDone() {
		return ServiceOperation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ServiceOperationListIterator type.
func NewServiceOperationListIterator(page ServiceOperationListPage) ServiceOperationListIterator {
	return ServiceOperationListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sol ServiceOperationList) IsEmpty() bool {
	return sol.Value == nil || len(*sol.Value) == 0
}

// serviceOperationListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sol ServiceOperationList) serviceOperationListPreparer(ctx context.Context) (*http.Request, error) {
	if sol.NextLink == nil || len(to.String(sol.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sol.NextLink)))
}

// ServiceOperationListPage contains a page of ServiceOperation values.
type ServiceOperationListPage struct {
	fn  func(context.Context, ServiceOperationList) (ServiceOperationList, error)
	sol ServiceOperationList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ServiceOperationListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceOperationListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.sol)
	if err != nil {
		return err
	}
	page.sol = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ServiceOperationListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ServiceOperationListPage) NotDone() bool {
	return !page.sol.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ServiceOperationListPage) Response() ServiceOperationList {
	return page.sol
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ServiceOperationListPage) Values() []ServiceOperation {
	if page.sol.IsEmpty() {
		return nil
	}
	return *page.sol.Value
}

// Creates a new instance of the ServiceOperationListPage type.
func NewServiceOperationListPage(getNextPage func(context.Context, ServiceOperationList) (ServiceOperationList, error)) ServiceOperationListPage {
	return ServiceOperationListPage{fn: getNextPage}
}

// ServiceProperties properties of the Data Migration service instance
type ServiceProperties struct {
	// ProvisioningState - READ-ONLY; The resource's provisioning state. Possible values include: 'ServiceProvisioningStateAccepted', 'ServiceProvisioningStateDeleting', 'ServiceProvisioningStateDeploying', 'ServiceProvisioningStateStopped', 'ServiceProvisioningStateStopping', 'ServiceProvisioningStateStarting', 'ServiceProvisioningStateFailedToStart', 'ServiceProvisioningStateFailedToStop', 'ServiceProvisioningStateSucceeded', 'ServiceProvisioningStateFailed'
	ProvisioningState ServiceProvisioningState `json:"provisioningState,omitempty"`
	// PublicKey - The public key of the service, used to encrypt secrets sent to the service
	PublicKey *string `json:"publicKey,omitempty"`
	// VirtualSubnetID - The ID of the Microsoft.Network/virtualNetworks/subnets resource to which the service should be joined
	VirtualSubnetID *string `json:"virtualSubnetId,omitempty"`
}

// ServicesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ServicesCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ServicesCreateOrUpdateFuture) Result(client ServicesClient) (s Service, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "datamigration.ServicesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("datamigration.ServicesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if s.Response.Response, err = future.GetResult(sender); err == nil && s.Response.Response.StatusCode != http.StatusNoContent {
		s, err = client.CreateOrUpdateResponder(s.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "datamigration.ServicesCreateOrUpdateFuture", "Result", s.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ServicesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ServicesDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ServicesDeleteFuture) Result(client ServicesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "datamigration.ServicesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("datamigration.ServicesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ServiceSku an Azure SKU instance
type ServiceSku struct {
	// Name - The unique name of the SKU, such as 'P3'
	Name *string `json:"name,omitempty"`
	// Tier - The tier of the SKU, such as 'Free', 'Basic', 'Standard', or 'Premium'
	Tier *string `json:"tier,omitempty"`
	// Family - The SKU family, used when the service has multiple performance classes within a tier, such as 'A', 'D', etc. for virtual machines
	Family *string `json:"family,omitempty"`
	// Size - The size of the SKU, used when the name alone does not denote a service size or when a SKU has multiple performance classes within a family, e.g. 'A1' for virtual machines
	Size *string `json:"size,omitempty"`
	// Capacity - The capacity of the SKU, if it supports scaling
	Capacity *int32 `json:"capacity,omitempty"`
}

// ServiceSkuList oData page of available SKUs
type ServiceSkuList struct {
	autorest.Response `json:"-"`
	// Value - List of service SKUs
	Value *[]AvailableServiceSku `json:"value,omitempty"`
	// NextLink - URL to load the next page of service SKUs
	NextLink *string `json:"nextLink,omitempty"`
}

// ServiceSkuListIterator provides access to a complete listing of AvailableServiceSku values.
type ServiceSkuListIterator struct {
	i    int
	page ServiceSkuListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ServiceSkuListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceSkuListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ServiceSkuListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ServiceSkuListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ServiceSkuListIterator) Response() ServiceSkuList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ServiceSkuListIterator) Value() AvailableServiceSku {
	if !iter.page.NotDone() {
		return AvailableServiceSku{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ServiceSkuListIterator type.
func NewServiceSkuListIterator(page ServiceSkuListPage) ServiceSkuListIterator {
	return ServiceSkuListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ssl ServiceSkuList) IsEmpty() bool {
	return ssl.Value == nil || len(*ssl.Value) == 0
}

// serviceSkuListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ssl ServiceSkuList) serviceSkuListPreparer(ctx context.Context) (*http.Request, error) {
	if ssl.NextLink == nil || len(to.String(ssl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ssl.NextLink)))
}

// ServiceSkuListPage contains a page of AvailableServiceSku values.
type ServiceSkuListPage struct {
	fn  func(context.Context, ServiceSkuList) (ServiceSkuList, error)
	ssl ServiceSkuList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ServiceSkuListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceSkuListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.ssl)
	if err != nil {
		return err
	}
	page.ssl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ServiceSkuListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ServiceSkuListPage) NotDone() bool {
	return !page.ssl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ServiceSkuListPage) Response() ServiceSkuList {
	return page.ssl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ServiceSkuListPage) Values() []AvailableServiceSku {
	if page.ssl.IsEmpty() {
		return nil
	}
	return *page.ssl.Value
}

// Creates a new instance of the ServiceSkuListPage type.
func NewServiceSkuListPage(getNextPage func(context.Context, ServiceSkuList) (ServiceSkuList, error)) ServiceSkuListPage {
	return ServiceSkuListPage{fn: getNextPage}
}

// ServicesStartFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ServicesStartFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ServicesStartFuture) Result(client ServicesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "datamigration.ServicesStartFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("datamigration.ServicesStartFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ServicesStopFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type ServicesStopFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ServicesStopFuture) Result(client ServicesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "datamigration.ServicesStopFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("datamigration.ServicesStopFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ServiceStatusResponse service health status
type ServiceStatusResponse struct {
	autorest.Response `json:"-"`
	// AgentVersion - The DMS instance agent version
	AgentVersion *string `json:"agentVersion,omitempty"`
	// Status - The machine-readable status, such as 'Initializing', 'Offline', 'Online', 'Deploying', 'Deleting', 'Stopped', 'Stopping', 'Starting', 'FailedToStart', 'FailedToStop' or 'Failed'
	Status *string `json:"status,omitempty"`
	// VMSize - The services virtual machine size, such as 'Standard_D2_v2'
	VMSize *string `json:"vmSize,omitempty"`
	// SupportedTaskTypes - The list of supported task types
	SupportedTaskTypes *[]string `json:"supportedTaskTypes,omitempty"`
}

// ServicesUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ServicesUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ServicesUpdateFuture) Result(client ServicesClient) (s Service, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "datamigration.ServicesUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("datamigration.ServicesUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if s.Response.Response, err = future.GetResult(sender); err == nil && s.Response.Response.StatusCode != http.StatusNoContent {
		s, err = client.UpdateResponder(s.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "datamigration.ServicesUpdateFuture", "Result", s.Response.Response, "Failure responding to request")
		}
	}
	return
}

// SQLConnectionInfo information for connecting to SQL database server
type SQLConnectionInfo struct {
	// DataSource - Data source in the format Protocol:MachineName\SQLServerInstanceName,PortNumber
	DataSource *string `json:"dataSource,omitempty"`
	// Authentication - Authentication type to use for connection. Possible values include: 'None', 'WindowsAuthentication', 'SQLAuthentication', 'ActiveDirectoryIntegrated', 'ActiveDirectoryPassword'
	Authentication AuthenticationType `json:"authentication,omitempty"`
	// EncryptConnection - Whether to encrypt the connection
	EncryptConnection *bool `json:"encryptConnection,omitempty"`
	// AdditionalSettings - Additional connection settings
	AdditionalSettings *string `json:"additionalSettings,omitempty"`
	// TrustServerCertificate - Whether to trust the server certificate
	TrustServerCertificate *bool `json:"trustServerCertificate,omitempty"`
	// Platform - Server platform type for connection. Possible values include: 'SQLOnPrem'
	Platform SQLSourcePlatform `json:"platform,omitempty"`
	// UserName - User name
	UserName *string `json:"userName,omitempty"`
	// Password - Password credential.
	Password *string `json:"password,omitempty"`
	// Type - Possible values include: 'TypeUnknown', 'TypeMiSQLConnectionInfo', 'TypePostgreSQLConnectionInfo', 'TypeMySQLConnectionInfo', 'TypeSQLConnectionInfo'
	Type Type `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SQLConnectionInfo.
func (sci SQLConnectionInfo) MarshalJSON() ([]byte, error) {
	sci.Type = TypeSQLConnectionInfo
	objectMap := make(map[string]interface{})
	if sci.DataSource != nil {
		objectMap["dataSource"] = sci.DataSource
	}
	if sci.Authentication != "" {
		objectMap["authentication"] = sci.Authentication
	}
	if sci.EncryptConnection != nil {
		objectMap["encryptConnection"] = sci.EncryptConnection
	}
	if sci.AdditionalSettings != nil {
		objectMap["additionalSettings"] = sci.AdditionalSettings
	}
	if sci.TrustServerCertificate != nil {
		objectMap["trustServerCertificate"] = sci.TrustServerCertificate
	}
	if sci.Platform != "" {
		objectMap["platform"] = sci.Platform
	}
	if sci.UserName != nil {
		objectMap["userName"] = sci.UserName
	}
	if sci.Password != nil {
		objectMap["password"] = sci.Password
	}
	if sci.Type != "" {
		objectMap["type"] = sci.Type
	}
	return json.Marshal(objectMap)
}

// AsMiSQLConnectionInfo is the BasicConnectionInfo implementation for SQLConnectionInfo.
func (sci SQLConnectionInfo) AsMiSQLConnectionInfo() (*MiSQLConnectionInfo, bool) {
	return nil, false
}

// AsPostgreSQLConnectionInfo is the BasicConnectionInfo implementation for SQLConnectionInfo.
func (sci SQLConnectionInfo) AsPostgreSQLConnectionInfo() (*PostgreSQLConnectionInfo, bool) {
	return nil, false
}

// AsMySQLConnectionInfo is the BasicConnectionInfo implementation for SQLConnectionInfo.
func (sci SQLConnectionInfo) AsMySQLConnectionInfo() (*MySQLConnectionInfo, bool) {
	return nil, false
}

// AsSQLConnectionInfo is the BasicConnectionInfo implementation for SQLConnectionInfo.
func (sci SQLConnectionInfo) AsSQLConnectionInfo() (*SQLConnectionInfo, bool) {
	return &sci, true
}

// AsConnectionInfo is the BasicConnectionInfo implementation for SQLConnectionInfo.
func (sci SQLConnectionInfo) AsConnectionInfo() (*ConnectionInfo, bool) {
	return nil, false
}

// AsBasicConnectionInfo is the BasicConnectionInfo implementation for SQLConnectionInfo.
func (sci SQLConnectionInfo) AsBasicConnectionInfo() (BasicConnectionInfo, bool) {
	return &sci, true
}

// SQLMigrationTaskInput base class for migration task input
type SQLMigrationTaskInput struct {
	// SourceConnectionInfo - Information for connecting to source
	SourceConnectionInfo *SQLConnectionInfo `json:"sourceConnectionInfo,omitempty"`
	// TargetConnectionInfo - Information for connecting to target
	TargetConnectionInfo *SQLConnectionInfo `json:"targetConnectionInfo,omitempty"`
}

// SQLServerSQLMISyncTaskInput input for task that migrates SQL Server databases to Azure SQL Database
// Managed Instance online scenario.
type SQLServerSQLMISyncTaskInput struct {
	// SelectedDatabases - Databases to migrate
	SelectedDatabases *[]MigrateSQLServerSQLMIDatabaseInput `json:"selectedDatabases,omitempty"`
	// BackupFileShare - Backup file share information for all selected databases.
	BackupFileShare *FileShare `json:"backupFileShare,omitempty"`
	// StorageResourceID - Fully qualified resourceId of storage
	StorageResourceID *string `json:"storageResourceId,omitempty"`
	// SourceConnectionInfo - Connection information for source SQL Server
	SourceConnectionInfo *SQLConnectionInfo `json:"sourceConnectionInfo,omitempty"`
	// TargetConnectionInfo - Connection information for Azure SQL Database Managed Instance
	TargetConnectionInfo *MiSQLConnectionInfo `json:"targetConnectionInfo,omitempty"`
	// AzureApp - Azure Active Directory Application the DMS instance will use to connect to the target instance of Azure SQL Database Managed Instance and the Azure Storage Account
	AzureApp *AzureActiveDirectoryApp `json:"azureApp,omitempty"`
}

// StartMigrationScenarioServerRoleResult server role migration result
type StartMigrationScenarioServerRoleResult struct {
	// Name - READ-ONLY; Name of server role.
	Name *string `json:"name,omitempty"`
	// State - READ-ONLY; Current state of migration. Possible values include: 'MigrationStateNone', 'MigrationStateInProgress', 'MigrationStateFailed', 'MigrationStateWarning', 'MigrationStateCompleted', 'MigrationStateSkipped', 'MigrationStateStopped'
	State MigrationState `json:"state,omitempty"`
	// ExceptionsAndWarnings - READ-ONLY; Migration exceptions and warnings.
	ExceptionsAndWarnings *[]ReportableException `json:"exceptionsAndWarnings,omitempty"`
}

// SyncMigrationDatabaseErrorEvent database migration errors for online migration
type SyncMigrationDatabaseErrorEvent struct {
	// TimestampString - READ-ONLY; String value of timestamp.
	TimestampString *string `json:"timestampString,omitempty"`
	// EventTypeString - READ-ONLY; Event type.
	EventTypeString *string `json:"eventTypeString,omitempty"`
	// EventText - READ-ONLY; Event text.
	EventText *string `json:"eventText,omitempty"`
}

// TaskList oData page of tasks
type TaskList struct {
	autorest.Response `json:"-"`
	// Value - List of tasks
	Value *[]ProjectTask `json:"value,omitempty"`
	// NextLink - URL to load the next page of tasks
	NextLink *string `json:"nextLink,omitempty"`
}

// TaskListIterator provides access to a complete listing of ProjectTask values.
type TaskListIterator struct {
	i    int
	page TaskListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *TaskListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TaskListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *TaskListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter TaskListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter TaskListIterator) Response() TaskList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter TaskListIterator) Value() ProjectTask {
	if !iter.page.NotDone() {
		return ProjectTask{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the TaskListIterator type.
func NewTaskListIterator(page TaskListPage) TaskListIterator {
	return TaskListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (tl TaskList) IsEmpty() bool {
	return tl.Value == nil || len(*tl.Value) == 0
}

// taskListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (tl TaskList) taskListPreparer(ctx context.Context) (*http.Request, error) {
	if tl.NextLink == nil || len(to.String(tl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(tl.NextLink)))
}

// TaskListPage contains a page of ProjectTask values.
type TaskListPage struct {
	fn func(context.Context, TaskList) (TaskList, error)
	tl TaskList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *TaskListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TaskListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.tl)
	if err != nil {
		return err
	}
	page.tl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *TaskListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page TaskListPage) NotDone() bool {
	return !page.tl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page TaskListPage) Response() TaskList {
	return page.tl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page TaskListPage) Values() []ProjectTask {
	if page.tl.IsEmpty() {
		return nil
	}
	return *page.tl.Value
}

// Creates a new instance of the TaskListPage type.
func NewTaskListPage(getNextPage func(context.Context, TaskList) (TaskList, error)) TaskListPage {
	return TaskListPage{fn: getNextPage}
}

// TrackedResource ARM tracked top level resource.
type TrackedResource struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	return json.Marshal(objectMap)
}

// ValidateMigrationInputSQLServerSQLDbSyncTaskProperties properties for task that validates migration
// input for SQL to Azure SQL DB sync migrations
type ValidateMigrationInputSQLServerSQLDbSyncTaskProperties struct {
	// Input - Task input
	Input *ValidateSyncMigrationInputSQLServerTaskInput `json:"input,omitempty"`
	// Output - READ-ONLY; Task output. This is ignored if submitted.
	Output *[]ValidateSyncMigrationInputSQLServerTaskOutput `json:"output,omitempty"`
	// Errors - READ-ONLY; Array of errors. This is ignored if submitted.
	Errors *[]ODataError `json:"errors,omitempty"`
	// State - READ-ONLY; The state of the task. This is ignored if submitted. Possible values include: 'TaskStateUnknown', 'TaskStateQueued', 'TaskStateRunning', 'TaskStateCanceled', 'TaskStateSucceeded', 'TaskStateFailed', 'TaskStateFailedInputValidation', 'TaskStateFaulted'
	State TaskState `json:"state,omitempty"`
	// Commands - READ-ONLY; Array of command properties.
	Commands *[]BasicCommandProperties `json:"commands,omitempty"`
	// TaskType - Possible values include: 'TaskTypeUnknown', 'TaskTypeGetTDECertificatesSQL', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMISyncLRS', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMI', 'TaskTypeValidateMigrationInputSQLServerSQLDbSync', 'TaskTypeMigratePostgreSQLAzureDbForPostgreSQLSync', 'TaskTypeMigrateMySQLAzureDbForMySQLSync', 'TaskTypeMigrateSQLServerAzureSQLDbSync', 'TaskTypeMigrateSQLServerSQLDb', 'TaskTypeMigrateSQLServerAzureSQLDbMISyncLRS', 'TaskTypeMigrateSQLServerAzureSQLDbMI', 'TaskTypeConnectToTargetAzureDbForMySQL', 'TaskTypeConnectToTargetAzureSQLDbMISyncLRS', 'TaskTypeConnectToTargetAzureSQLDbMI', 'TaskTypeGetUserTablesAzureSQLDbSync', 'TaskTypeGetUserTablesSQL', 'TaskTypeConnectToTargetAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetSQLDbSync', 'TaskTypeConnectToTargetSQLDb', 'TaskTypeConnectToSourcePostgreSQLSync', 'TaskTypeConnectToSourceSQLServerSync', 'TaskTypeConnectToSourceSQLServer', 'TaskTypeConnectToSourceMySQL'
	TaskType TaskType `json:"taskType,omitempty"`
}

// MarshalJSON is the custom marshaler for ValidateMigrationInputSQLServerSQLDbSyncTaskProperties.
func (vmisssdstp ValidateMigrationInputSQLServerSQLDbSyncTaskProperties) MarshalJSON() ([]byte, error) {
	vmisssdstp.TaskType = TaskTypeValidateMigrationInputSQLServerSQLDbSync
	objectMap := make(map[string]interface{})
	if vmisssdstp.Input != nil {
		objectMap["input"] = vmisssdstp.Input
	}
	if vmisssdstp.TaskType != "" {
		objectMap["taskType"] = vmisssdstp.TaskType
	}
	return json.Marshal(objectMap)
}

// AsGetTdeCertificatesSQLTaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLDbSyncTaskProperties.
func (vmisssdstp ValidateMigrationInputSQLServerSQLDbSyncTaskProperties) AsGetTdeCertificatesSQLTaskProperties() (*GetTdeCertificatesSQLTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLDbSyncTaskProperties.
func (vmisssdstp ValidateMigrationInputSQLServerSQLDbSyncTaskProperties) AsValidateMigrationInputSQLServerSQLMISyncTaskProperties() (*ValidateMigrationInputSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLDbSyncTaskProperties.
func (vmisssdstp ValidateMigrationInputSQLServerSQLDbSyncTaskProperties) AsValidateMigrationInputSQLServerSQLMITaskProperties() (*ValidateMigrationInputSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLDbSyncTaskProperties.
func (vmisssdstp ValidateMigrationInputSQLServerSQLDbSyncTaskProperties) AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties() (*ValidateMigrationInputSQLServerSQLDbSyncTaskProperties, bool) {
	return &vmisssdstp, true
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLDbSyncTaskProperties.
func (vmisssdstp ValidateMigrationInputSQLServerSQLDbSyncTaskProperties) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLDbSyncTaskProperties.
func (vmisssdstp ValidateMigrationInputSQLServerSQLDbSyncTaskProperties) AsMigrateMySQLAzureDbForMySQLSyncTaskProperties() (*MigrateMySQLAzureDbForMySQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLDbSyncTaskProperties.
func (vmisssdstp ValidateMigrationInputSQLServerSQLDbSyncTaskProperties) AsMigrateSQLServerSQLDbSyncTaskProperties() (*MigrateSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLDbSyncTaskProperties.
func (vmisssdstp ValidateMigrationInputSQLServerSQLDbSyncTaskProperties) AsMigrateSQLServerSQLDbTaskProperties() (*MigrateSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLDbSyncTaskProperties.
func (vmisssdstp ValidateMigrationInputSQLServerSQLDbSyncTaskProperties) AsMigrateSQLServerSQLMISyncTaskProperties() (*MigrateSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLDbSyncTaskProperties.
func (vmisssdstp ValidateMigrationInputSQLServerSQLDbSyncTaskProperties) AsMigrateSQLServerSQLMITaskProperties() (*MigrateSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForMySQLTaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLDbSyncTaskProperties.
func (vmisssdstp ValidateMigrationInputSQLServerSQLDbSyncTaskProperties) AsConnectToTargetAzureDbForMySQLTaskProperties() (*ConnectToTargetAzureDbForMySQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLDbSyncTaskProperties.
func (vmisssdstp ValidateMigrationInputSQLServerSQLDbSyncTaskProperties) AsConnectToTargetSQLMISyncTaskProperties() (*ConnectToTargetSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMITaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLDbSyncTaskProperties.
func (vmisssdstp ValidateMigrationInputSQLServerSQLDbSyncTaskProperties) AsConnectToTargetSQLMITaskProperties() (*ConnectToTargetSQLMITaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLDbSyncTaskProperties.
func (vmisssdstp ValidateMigrationInputSQLServerSQLDbSyncTaskProperties) AsGetUserTablesSQLSyncTaskProperties() (*GetUserTablesSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLTaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLDbSyncTaskProperties.
func (vmisssdstp ValidateMigrationInputSQLServerSQLDbSyncTaskProperties) AsGetUserTablesSQLTaskProperties() (*GetUserTablesSQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLDbSyncTaskProperties.
func (vmisssdstp ValidateMigrationInputSQLServerSQLDbSyncTaskProperties) AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLDbSyncTaskProperties.
func (vmisssdstp ValidateMigrationInputSQLServerSQLDbSyncTaskProperties) AsConnectToTargetSQLSQLDbSyncTaskProperties() (*ConnectToTargetSQLSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLDbSyncTaskProperties.
func (vmisssdstp ValidateMigrationInputSQLServerSQLDbSyncTaskProperties) AsConnectToTargetSQLDbTaskProperties() (*ConnectToTargetSQLDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourcePostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLDbSyncTaskProperties.
func (vmisssdstp ValidateMigrationInputSQLServerSQLDbSyncTaskProperties) AsConnectToSourcePostgreSQLSyncTaskProperties() (*ConnectToSourcePostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerSyncTaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLDbSyncTaskProperties.
func (vmisssdstp ValidateMigrationInputSQLServerSQLDbSyncTaskProperties) AsConnectToSourceSQLServerSyncTaskProperties() (*ConnectToSourceSQLServerSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLDbSyncTaskProperties.
func (vmisssdstp ValidateMigrationInputSQLServerSQLDbSyncTaskProperties) AsConnectToSourceSQLServerTaskProperties() (*ConnectToSourceSQLServerTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceMySQLTaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLDbSyncTaskProperties.
func (vmisssdstp ValidateMigrationInputSQLServerSQLDbSyncTaskProperties) AsConnectToSourceMySQLTaskProperties() (*ConnectToSourceMySQLTaskProperties, bool) {
	return nil, false
}

// AsProjectTaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLDbSyncTaskProperties.
func (vmisssdstp ValidateMigrationInputSQLServerSQLDbSyncTaskProperties) AsProjectTaskProperties() (*ProjectTaskProperties, bool) {
	return nil, false
}

// AsBasicProjectTaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLDbSyncTaskProperties.
func (vmisssdstp ValidateMigrationInputSQLServerSQLDbSyncTaskProperties) AsBasicProjectTaskProperties() (BasicProjectTaskProperties, bool) {
	return &vmisssdstp, true
}

// UnmarshalJSON is the custom unmarshaler for ValidateMigrationInputSQLServerSQLDbSyncTaskProperties struct.
func (vmisssdstp *ValidateMigrationInputSQLServerSQLDbSyncTaskProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "input":
			if v != nil {
				var input ValidateSyncMigrationInputSQLServerTaskInput
				err = json.Unmarshal(*v, &input)
				if err != nil {
					return err
				}
				vmisssdstp.Input = &input
			}
		case "output":
			if v != nil {
				var output []ValidateSyncMigrationInputSQLServerTaskOutput
				err = json.Unmarshal(*v, &output)
				if err != nil {
					return err
				}
				vmisssdstp.Output = &output
			}
		case "errors":
			if v != nil {
				var errorsVar []ODataError
				err = json.Unmarshal(*v, &errorsVar)
				if err != nil {
					return err
				}
				vmisssdstp.Errors = &errorsVar
			}
		case "state":
			if v != nil {
				var state TaskState
				err = json.Unmarshal(*v, &state)
				if err != nil {
					return err
				}
				vmisssdstp.State = state
			}
		case "commands":
			if v != nil {
				commands, err := unmarshalBasicCommandPropertiesArray(*v)
				if err != nil {
					return err
				}
				vmisssdstp.Commands = &commands
			}
		case "taskType":
			if v != nil {
				var taskType TaskType
				err = json.Unmarshal(*v, &taskType)
				if err != nil {
					return err
				}
				vmisssdstp.TaskType = taskType
			}
		}
	}

	return nil
}

// ValidateMigrationInputSQLServerSQLMISyncTaskInput input for task that migrates SQL Server databases to
// Azure SQL Database Managed Instance online scenario.
type ValidateMigrationInputSQLServerSQLMISyncTaskInput struct {
	// SelectedDatabases - Databases to migrate
	SelectedDatabases *[]MigrateSQLServerSQLMIDatabaseInput `json:"selectedDatabases,omitempty"`
	// BackupFileShare - Backup file share information for all selected databases.
	BackupFileShare *FileShare `json:"backupFileShare,omitempty"`
	// StorageResourceID - Fully qualified resourceId of storage
	StorageResourceID *string `json:"storageResourceId,omitempty"`
	// SourceConnectionInfo - Connection information for source SQL Server
	SourceConnectionInfo *SQLConnectionInfo `json:"sourceConnectionInfo,omitempty"`
	// TargetConnectionInfo - Connection information for Azure SQL Database Managed Instance
	TargetConnectionInfo *MiSQLConnectionInfo `json:"targetConnectionInfo,omitempty"`
	// AzureApp - Azure Active Directory Application the DMS instance will use to connect to the target instance of Azure SQL Database Managed Instance and the Azure Storage Account
	AzureApp *AzureActiveDirectoryApp `json:"azureApp,omitempty"`
}

// ValidateMigrationInputSQLServerSQLMISyncTaskOutput output for task that validates migration input for
// Azure SQL Database Managed Instance online migration
type ValidateMigrationInputSQLServerSQLMISyncTaskOutput struct {
	// ID - READ-ONLY; Database identifier
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Name of database
	Name *string `json:"name,omitempty"`
	// ValidationErrors - READ-ONLY; Errors associated with a selected database object
	ValidationErrors *[]ReportableException `json:"validationErrors,omitempty"`
}

// ValidateMigrationInputSQLServerSQLMISyncTaskProperties properties for task that validates migration
// input for SQL to Azure SQL Database Managed Instance sync scenario
type ValidateMigrationInputSQLServerSQLMISyncTaskProperties struct {
	// Input - Task input
	Input *ValidateMigrationInputSQLServerSQLMISyncTaskInput `json:"input,omitempty"`
	// Output - READ-ONLY; Task output. This is ignored if submitted.
	Output *[]ValidateMigrationInputSQLServerSQLMISyncTaskOutput `json:"output,omitempty"`
	// Errors - READ-ONLY; Array of errors. This is ignored if submitted.
	Errors *[]ODataError `json:"errors,omitempty"`
	// State - READ-ONLY; The state of the task. This is ignored if submitted. Possible values include: 'TaskStateUnknown', 'TaskStateQueued', 'TaskStateRunning', 'TaskStateCanceled', 'TaskStateSucceeded', 'TaskStateFailed', 'TaskStateFailedInputValidation', 'TaskStateFaulted'
	State TaskState `json:"state,omitempty"`
	// Commands - READ-ONLY; Array of command properties.
	Commands *[]BasicCommandProperties `json:"commands,omitempty"`
	// TaskType - Possible values include: 'TaskTypeUnknown', 'TaskTypeGetTDECertificatesSQL', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMISyncLRS', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMI', 'TaskTypeValidateMigrationInputSQLServerSQLDbSync', 'TaskTypeMigratePostgreSQLAzureDbForPostgreSQLSync', 'TaskTypeMigrateMySQLAzureDbForMySQLSync', 'TaskTypeMigrateSQLServerAzureSQLDbSync', 'TaskTypeMigrateSQLServerSQLDb', 'TaskTypeMigrateSQLServerAzureSQLDbMISyncLRS', 'TaskTypeMigrateSQLServerAzureSQLDbMI', 'TaskTypeConnectToTargetAzureDbForMySQL', 'TaskTypeConnectToTargetAzureSQLDbMISyncLRS', 'TaskTypeConnectToTargetAzureSQLDbMI', 'TaskTypeGetUserTablesAzureSQLDbSync', 'TaskTypeGetUserTablesSQL', 'TaskTypeConnectToTargetAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetSQLDbSync', 'TaskTypeConnectToTargetSQLDb', 'TaskTypeConnectToSourcePostgreSQLSync', 'TaskTypeConnectToSourceSQLServerSync', 'TaskTypeConnectToSourceSQLServer', 'TaskTypeConnectToSourceMySQL'
	TaskType TaskType `json:"taskType,omitempty"`
}

// MarshalJSON is the custom marshaler for ValidateMigrationInputSQLServerSQLMISyncTaskProperties.
func (vmisssmstp ValidateMigrationInputSQLServerSQLMISyncTaskProperties) MarshalJSON() ([]byte, error) {
	vmisssmstp.TaskType = TaskTypeValidateMigrationInputSQLServerAzureSQLDbMISyncLRS
	objectMap := make(map[string]interface{})
	if vmisssmstp.Input != nil {
		objectMap["input"] = vmisssmstp.Input
	}
	if vmisssmstp.TaskType != "" {
		objectMap["taskType"] = vmisssmstp.TaskType
	}
	return json.Marshal(objectMap)
}

// AsGetTdeCertificatesSQLTaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLMISyncTaskProperties.
func (vmisssmstp ValidateMigrationInputSQLServerSQLMISyncTaskProperties) AsGetTdeCertificatesSQLTaskProperties() (*GetTdeCertificatesSQLTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLMISyncTaskProperties.
func (vmisssmstp ValidateMigrationInputSQLServerSQLMISyncTaskProperties) AsValidateMigrationInputSQLServerSQLMISyncTaskProperties() (*ValidateMigrationInputSQLServerSQLMISyncTaskProperties, bool) {
	return &vmisssmstp, true
}

// AsValidateMigrationInputSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLMISyncTaskProperties.
func (vmisssmstp ValidateMigrationInputSQLServerSQLMISyncTaskProperties) AsValidateMigrationInputSQLServerSQLMITaskProperties() (*ValidateMigrationInputSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLMISyncTaskProperties.
func (vmisssmstp ValidateMigrationInputSQLServerSQLMISyncTaskProperties) AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties() (*ValidateMigrationInputSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLMISyncTaskProperties.
func (vmisssmstp ValidateMigrationInputSQLServerSQLMISyncTaskProperties) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLMISyncTaskProperties.
func (vmisssmstp ValidateMigrationInputSQLServerSQLMISyncTaskProperties) AsMigrateMySQLAzureDbForMySQLSyncTaskProperties() (*MigrateMySQLAzureDbForMySQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLMISyncTaskProperties.
func (vmisssmstp ValidateMigrationInputSQLServerSQLMISyncTaskProperties) AsMigrateSQLServerSQLDbSyncTaskProperties() (*MigrateSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLMISyncTaskProperties.
func (vmisssmstp ValidateMigrationInputSQLServerSQLMISyncTaskProperties) AsMigrateSQLServerSQLDbTaskProperties() (*MigrateSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLMISyncTaskProperties.
func (vmisssmstp ValidateMigrationInputSQLServerSQLMISyncTaskProperties) AsMigrateSQLServerSQLMISyncTaskProperties() (*MigrateSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLMISyncTaskProperties.
func (vmisssmstp ValidateMigrationInputSQLServerSQLMISyncTaskProperties) AsMigrateSQLServerSQLMITaskProperties() (*MigrateSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForMySQLTaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLMISyncTaskProperties.
func (vmisssmstp ValidateMigrationInputSQLServerSQLMISyncTaskProperties) AsConnectToTargetAzureDbForMySQLTaskProperties() (*ConnectToTargetAzureDbForMySQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLMISyncTaskProperties.
func (vmisssmstp ValidateMigrationInputSQLServerSQLMISyncTaskProperties) AsConnectToTargetSQLMISyncTaskProperties() (*ConnectToTargetSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMITaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLMISyncTaskProperties.
func (vmisssmstp ValidateMigrationInputSQLServerSQLMISyncTaskProperties) AsConnectToTargetSQLMITaskProperties() (*ConnectToTargetSQLMITaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLMISyncTaskProperties.
func (vmisssmstp ValidateMigrationInputSQLServerSQLMISyncTaskProperties) AsGetUserTablesSQLSyncTaskProperties() (*GetUserTablesSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLTaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLMISyncTaskProperties.
func (vmisssmstp ValidateMigrationInputSQLServerSQLMISyncTaskProperties) AsGetUserTablesSQLTaskProperties() (*GetUserTablesSQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLMISyncTaskProperties.
func (vmisssmstp ValidateMigrationInputSQLServerSQLMISyncTaskProperties) AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLMISyncTaskProperties.
func (vmisssmstp ValidateMigrationInputSQLServerSQLMISyncTaskProperties) AsConnectToTargetSQLSQLDbSyncTaskProperties() (*ConnectToTargetSQLSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLMISyncTaskProperties.
func (vmisssmstp ValidateMigrationInputSQLServerSQLMISyncTaskProperties) AsConnectToTargetSQLDbTaskProperties() (*ConnectToTargetSQLDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourcePostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLMISyncTaskProperties.
func (vmisssmstp ValidateMigrationInputSQLServerSQLMISyncTaskProperties) AsConnectToSourcePostgreSQLSyncTaskProperties() (*ConnectToSourcePostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerSyncTaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLMISyncTaskProperties.
func (vmisssmstp ValidateMigrationInputSQLServerSQLMISyncTaskProperties) AsConnectToSourceSQLServerSyncTaskProperties() (*ConnectToSourceSQLServerSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLMISyncTaskProperties.
func (vmisssmstp ValidateMigrationInputSQLServerSQLMISyncTaskProperties) AsConnectToSourceSQLServerTaskProperties() (*ConnectToSourceSQLServerTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceMySQLTaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLMISyncTaskProperties.
func (vmisssmstp ValidateMigrationInputSQLServerSQLMISyncTaskProperties) AsConnectToSourceMySQLTaskProperties() (*ConnectToSourceMySQLTaskProperties, bool) {
	return nil, false
}

// AsProjectTaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLMISyncTaskProperties.
func (vmisssmstp ValidateMigrationInputSQLServerSQLMISyncTaskProperties) AsProjectTaskProperties() (*ProjectTaskProperties, bool) {
	return nil, false
}

// AsBasicProjectTaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLMISyncTaskProperties.
func (vmisssmstp ValidateMigrationInputSQLServerSQLMISyncTaskProperties) AsBasicProjectTaskProperties() (BasicProjectTaskProperties, bool) {
	return &vmisssmstp, true
}

// UnmarshalJSON is the custom unmarshaler for ValidateMigrationInputSQLServerSQLMISyncTaskProperties struct.
func (vmisssmstp *ValidateMigrationInputSQLServerSQLMISyncTaskProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "input":
			if v != nil {
				var input ValidateMigrationInputSQLServerSQLMISyncTaskInput
				err = json.Unmarshal(*v, &input)
				if err != nil {
					return err
				}
				vmisssmstp.Input = &input
			}
		case "output":
			if v != nil {
				var output []ValidateMigrationInputSQLServerSQLMISyncTaskOutput
				err = json.Unmarshal(*v, &output)
				if err != nil {
					return err
				}
				vmisssmstp.Output = &output
			}
		case "errors":
			if v != nil {
				var errorsVar []ODataError
				err = json.Unmarshal(*v, &errorsVar)
				if err != nil {
					return err
				}
				vmisssmstp.Errors = &errorsVar
			}
		case "state":
			if v != nil {
				var state TaskState
				err = json.Unmarshal(*v, &state)
				if err != nil {
					return err
				}
				vmisssmstp.State = state
			}
		case "commands":
			if v != nil {
				commands, err := unmarshalBasicCommandPropertiesArray(*v)
				if err != nil {
					return err
				}
				vmisssmstp.Commands = &commands
			}
		case "taskType":
			if v != nil {
				var taskType TaskType
				err = json.Unmarshal(*v, &taskType)
				if err != nil {
					return err
				}
				vmisssmstp.TaskType = taskType
			}
		}
	}

	return nil
}

// ValidateMigrationInputSQLServerSQLMITaskInput input for task that validates migration input for SQL to
// Azure SQL Managed Instance
type ValidateMigrationInputSQLServerSQLMITaskInput struct {
	// SourceConnectionInfo - Information for connecting to source
	SourceConnectionInfo *SQLConnectionInfo `json:"sourceConnectionInfo,omitempty"`
	// TargetConnectionInfo - Information for connecting to target
	TargetConnectionInfo *SQLConnectionInfo `json:"targetConnectionInfo,omitempty"`
	// SelectedDatabases - Databases to migrate
	SelectedDatabases *[]MigrateSQLServerSQLMIDatabaseInput `json:"selectedDatabases,omitempty"`
	// SelectedLogins - Logins to migrate
	SelectedLogins *[]string `json:"selectedLogins,omitempty"`
	// BackupFileShare - Backup file share information for all selected databases.
	BackupFileShare *FileShare `json:"backupFileShare,omitempty"`
	// BackupBlobShare - SAS URI of Azure Storage Account Container to be used for storing backup files.
	BackupBlobShare *BlobShare `json:"backupBlobShare,omitempty"`
	// BackupMode - Backup Mode to specify whether to use existing backup or create new backup. Possible values include: 'CreateBackup', 'ExistingBackup'
	BackupMode BackupMode `json:"backupMode,omitempty"`
}

// ValidateMigrationInputSQLServerSQLMITaskOutput output for task that validates migration input for SQL to
// Azure SQL Managed Instance migrations
type ValidateMigrationInputSQLServerSQLMITaskOutput struct {
	// ID - READ-ONLY; Result identifier
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Name of database
	Name *string `json:"name,omitempty"`
	// RestoreDatabaseNameErrors - READ-ONLY; Errors associated with the RestoreDatabaseName
	RestoreDatabaseNameErrors *[]ReportableException `json:"restoreDatabaseNameErrors,omitempty"`
	// BackupFolderErrors - READ-ONLY; Errors associated with the BackupFolder path
	BackupFolderErrors *[]ReportableException `json:"backupFolderErrors,omitempty"`
	// BackupShareCredentialsErrors - READ-ONLY; Errors associated with backup share user name and password credentials
	BackupShareCredentialsErrors *[]ReportableException `json:"backupShareCredentialsErrors,omitempty"`
	// BackupStorageAccountErrors - READ-ONLY; Errors associated with the storage account provided.
	BackupStorageAccountErrors *[]ReportableException `json:"backupStorageAccountErrors,omitempty"`
	// ExistingBackupErrors - READ-ONLY; Errors associated with existing backup files.
	ExistingBackupErrors *[]ReportableException `json:"existingBackupErrors,omitempty"`
	// DatabaseBackupInfo - Information about backup files when existing backup mode is used.
	DatabaseBackupInfo *DatabaseBackupInfo `json:"databaseBackupInfo,omitempty"`
}

// ValidateMigrationInputSQLServerSQLMITaskProperties properties for task that validates migration input
// for SQL to Azure SQL Database Managed Instance
type ValidateMigrationInputSQLServerSQLMITaskProperties struct {
	// Input - Task input
	Input *ValidateMigrationInputSQLServerSQLMITaskInput `json:"input,omitempty"`
	// Output - READ-ONLY; Task output. This is ignored if submitted.
	Output *[]ValidateMigrationInputSQLServerSQLMITaskOutput `json:"output,omitempty"`
	// Errors - READ-ONLY; Array of errors. This is ignored if submitted.
	Errors *[]ODataError `json:"errors,omitempty"`
	// State - READ-ONLY; The state of the task. This is ignored if submitted. Possible values include: 'TaskStateUnknown', 'TaskStateQueued', 'TaskStateRunning', 'TaskStateCanceled', 'TaskStateSucceeded', 'TaskStateFailed', 'TaskStateFailedInputValidation', 'TaskStateFaulted'
	State TaskState `json:"state,omitempty"`
	// Commands - READ-ONLY; Array of command properties.
	Commands *[]BasicCommandProperties `json:"commands,omitempty"`
	// TaskType - Possible values include: 'TaskTypeUnknown', 'TaskTypeGetTDECertificatesSQL', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMISyncLRS', 'TaskTypeValidateMigrationInputSQLServerAzureSQLDbMI', 'TaskTypeValidateMigrationInputSQLServerSQLDbSync', 'TaskTypeMigratePostgreSQLAzureDbForPostgreSQLSync', 'TaskTypeMigrateMySQLAzureDbForMySQLSync', 'TaskTypeMigrateSQLServerAzureSQLDbSync', 'TaskTypeMigrateSQLServerSQLDb', 'TaskTypeMigrateSQLServerAzureSQLDbMISyncLRS', 'TaskTypeMigrateSQLServerAzureSQLDbMI', 'TaskTypeConnectToTargetAzureDbForMySQL', 'TaskTypeConnectToTargetAzureSQLDbMISyncLRS', 'TaskTypeConnectToTargetAzureSQLDbMI', 'TaskTypeGetUserTablesAzureSQLDbSync', 'TaskTypeGetUserTablesSQL', 'TaskTypeConnectToTargetAzureDbForPostgreSQLSync', 'TaskTypeConnectToTargetSQLDbSync', 'TaskTypeConnectToTargetSQLDb', 'TaskTypeConnectToSourcePostgreSQLSync', 'TaskTypeConnectToSourceSQLServerSync', 'TaskTypeConnectToSourceSQLServer', 'TaskTypeConnectToSourceMySQL'
	TaskType TaskType `json:"taskType,omitempty"`
}

// MarshalJSON is the custom marshaler for ValidateMigrationInputSQLServerSQLMITaskProperties.
func (vmisssmtp ValidateMigrationInputSQLServerSQLMITaskProperties) MarshalJSON() ([]byte, error) {
	vmisssmtp.TaskType = TaskTypeValidateMigrationInputSQLServerAzureSQLDbMI
	objectMap := make(map[string]interface{})
	if vmisssmtp.Input != nil {
		objectMap["input"] = vmisssmtp.Input
	}
	if vmisssmtp.TaskType != "" {
		objectMap["taskType"] = vmisssmtp.TaskType
	}
	return json.Marshal(objectMap)
}

// AsGetTdeCertificatesSQLTaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLMITaskProperties.
func (vmisssmtp ValidateMigrationInputSQLServerSQLMITaskProperties) AsGetTdeCertificatesSQLTaskProperties() (*GetTdeCertificatesSQLTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLMITaskProperties.
func (vmisssmtp ValidateMigrationInputSQLServerSQLMITaskProperties) AsValidateMigrationInputSQLServerSQLMISyncTaskProperties() (*ValidateMigrationInputSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsValidateMigrationInputSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLMITaskProperties.
func (vmisssmtp ValidateMigrationInputSQLServerSQLMITaskProperties) AsValidateMigrationInputSQLServerSQLMITaskProperties() (*ValidateMigrationInputSQLServerSQLMITaskProperties, bool) {
	return &vmisssmtp, true
}

// AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLMITaskProperties.
func (vmisssmtp ValidateMigrationInputSQLServerSQLMITaskProperties) AsValidateMigrationInputSQLServerSQLDbSyncTaskProperties() (*ValidateMigrationInputSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLMITaskProperties.
func (vmisssmtp ValidateMigrationInputSQLServerSQLMITaskProperties) AsMigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties() (*MigratePostgreSQLAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateMySQLAzureDbForMySQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLMITaskProperties.
func (vmisssmtp ValidateMigrationInputSQLServerSQLMITaskProperties) AsMigrateMySQLAzureDbForMySQLSyncTaskProperties() (*MigrateMySQLAzureDbForMySQLSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLMITaskProperties.
func (vmisssmtp ValidateMigrationInputSQLServerSQLMITaskProperties) AsMigrateSQLServerSQLDbSyncTaskProperties() (*MigrateSQLServerSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLMITaskProperties.
func (vmisssmtp ValidateMigrationInputSQLServerSQLMITaskProperties) AsMigrateSQLServerSQLDbTaskProperties() (*MigrateSQLServerSQLDbTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLMITaskProperties.
func (vmisssmtp ValidateMigrationInputSQLServerSQLMITaskProperties) AsMigrateSQLServerSQLMISyncTaskProperties() (*MigrateSQLServerSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsMigrateSQLServerSQLMITaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLMITaskProperties.
func (vmisssmtp ValidateMigrationInputSQLServerSQLMITaskProperties) AsMigrateSQLServerSQLMITaskProperties() (*MigrateSQLServerSQLMITaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForMySQLTaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLMITaskProperties.
func (vmisssmtp ValidateMigrationInputSQLServerSQLMITaskProperties) AsConnectToTargetAzureDbForMySQLTaskProperties() (*ConnectToTargetAzureDbForMySQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMISyncTaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLMITaskProperties.
func (vmisssmtp ValidateMigrationInputSQLServerSQLMITaskProperties) AsConnectToTargetSQLMISyncTaskProperties() (*ConnectToTargetSQLMISyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLMITaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLMITaskProperties.
func (vmisssmtp ValidateMigrationInputSQLServerSQLMITaskProperties) AsConnectToTargetSQLMITaskProperties() (*ConnectToTargetSQLMITaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLMITaskProperties.
func (vmisssmtp ValidateMigrationInputSQLServerSQLMITaskProperties) AsGetUserTablesSQLSyncTaskProperties() (*GetUserTablesSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsGetUserTablesSQLTaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLMITaskProperties.
func (vmisssmtp ValidateMigrationInputSQLServerSQLMITaskProperties) AsGetUserTablesSQLTaskProperties() (*GetUserTablesSQLTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLMITaskProperties.
func (vmisssmtp ValidateMigrationInputSQLServerSQLMITaskProperties) AsConnectToTargetAzureDbForPostgreSQLSyncTaskProperties() (*ConnectToTargetAzureDbForPostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLSQLDbSyncTaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLMITaskProperties.
func (vmisssmtp ValidateMigrationInputSQLServerSQLMITaskProperties) AsConnectToTargetSQLSQLDbSyncTaskProperties() (*ConnectToTargetSQLSQLDbSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToTargetSQLDbTaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLMITaskProperties.
func (vmisssmtp ValidateMigrationInputSQLServerSQLMITaskProperties) AsConnectToTargetSQLDbTaskProperties() (*ConnectToTargetSQLDbTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourcePostgreSQLSyncTaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLMITaskProperties.
func (vmisssmtp ValidateMigrationInputSQLServerSQLMITaskProperties) AsConnectToSourcePostgreSQLSyncTaskProperties() (*ConnectToSourcePostgreSQLSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerSyncTaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLMITaskProperties.
func (vmisssmtp ValidateMigrationInputSQLServerSQLMITaskProperties) AsConnectToSourceSQLServerSyncTaskProperties() (*ConnectToSourceSQLServerSyncTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceSQLServerTaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLMITaskProperties.
func (vmisssmtp ValidateMigrationInputSQLServerSQLMITaskProperties) AsConnectToSourceSQLServerTaskProperties() (*ConnectToSourceSQLServerTaskProperties, bool) {
	return nil, false
}

// AsConnectToSourceMySQLTaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLMITaskProperties.
func (vmisssmtp ValidateMigrationInputSQLServerSQLMITaskProperties) AsConnectToSourceMySQLTaskProperties() (*ConnectToSourceMySQLTaskProperties, bool) {
	return nil, false
}

// AsProjectTaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLMITaskProperties.
func (vmisssmtp ValidateMigrationInputSQLServerSQLMITaskProperties) AsProjectTaskProperties() (*ProjectTaskProperties, bool) {
	return nil, false
}

// AsBasicProjectTaskProperties is the BasicProjectTaskProperties implementation for ValidateMigrationInputSQLServerSQLMITaskProperties.
func (vmisssmtp ValidateMigrationInputSQLServerSQLMITaskProperties) AsBasicProjectTaskProperties() (BasicProjectTaskProperties, bool) {
	return &vmisssmtp, true
}

// UnmarshalJSON is the custom unmarshaler for ValidateMigrationInputSQLServerSQLMITaskProperties struct.
func (vmisssmtp *ValidateMigrationInputSQLServerSQLMITaskProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "input":
			if v != nil {
				var input ValidateMigrationInputSQLServerSQLMITaskInput
				err = json.Unmarshal(*v, &input)
				if err != nil {
					return err
				}
				vmisssmtp.Input = &input
			}
		case "output":
			if v != nil {
				var output []ValidateMigrationInputSQLServerSQLMITaskOutput
				err = json.Unmarshal(*v, &output)
				if err != nil {
					return err
				}
				vmisssmtp.Output = &output
			}
		case "errors":
			if v != nil {
				var errorsVar []ODataError
				err = json.Unmarshal(*v, &errorsVar)
				if err != nil {
					return err
				}
				vmisssmtp.Errors = &errorsVar
			}
		case "state":
			if v != nil {
				var state TaskState
				err = json.Unmarshal(*v, &state)
				if err != nil {
					return err
				}
				vmisssmtp.State = state
			}
		case "commands":
			if v != nil {
				commands, err := unmarshalBasicCommandPropertiesArray(*v)
				if err != nil {
					return err
				}
				vmisssmtp.Commands = &commands
			}
		case "taskType":
			if v != nil {
				var taskType TaskType
				err = json.Unmarshal(*v, &taskType)
				if err != nil {
					return err
				}
				vmisssmtp.TaskType = taskType
			}
		}
	}

	return nil
}

// ValidateSyncMigrationInputSQLServerTaskInput input for task that validates migration input for SQL sync
// migrations
type ValidateSyncMigrationInputSQLServerTaskInput struct {
	// SourceConnectionInfo - Information for connecting to source SQL server
	SourceConnectionInfo *SQLConnectionInfo `json:"sourceConnectionInfo,omitempty"`
	// TargetConnectionInfo - Information for connecting to target
	TargetConnectionInfo *SQLConnectionInfo `json:"targetConnectionInfo,omitempty"`
	// SelectedDatabases - Databases to migrate
	SelectedDatabases *[]MigrateSQLServerSQLDbSyncDatabaseInput `json:"selectedDatabases,omitempty"`
}

// ValidateSyncMigrationInputSQLServerTaskOutput output for task that validates migration input for SQL
// sync migrations
type ValidateSyncMigrationInputSQLServerTaskOutput struct {
	// ID - READ-ONLY; Database identifier
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Name of database
	Name *string `json:"name,omitempty"`
	// ValidationErrors - READ-ONLY; Errors associated with a selected database object
	ValidationErrors *[]ReportableException `json:"validationErrors,omitempty"`
}

// ValidationError description about the errors happen while performing migration validation
type ValidationError struct {
	// Text - READ-ONLY; Error Text
	Text *string `json:"text,omitempty"`
	// Severity - READ-ONLY; Severity of the error. Possible values include: 'SeverityMessage', 'SeverityWarning', 'SeverityError'
	Severity Severity `json:"severity,omitempty"`
}

// WaitStatistics wait statistics gathered during query batch execution
type WaitStatistics struct {
	// WaitType - READ-ONLY; Type of the Wait
	WaitType *string `json:"waitType,omitempty"`
	// WaitTimeMs - READ-ONLY; Total wait time in millisecond(s)
	WaitTimeMs *float64 `json:"waitTimeMs,omitempty"`
	// WaitCount - READ-ONLY; Total no. of waits
	WaitCount *int64 `json:"waitCount,omitempty"`
}
