// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package computeoptimizer

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
)

const opDescribeRecommendationExportJobs = "DescribeRecommendationExportJobs"

// DescribeRecommendationExportJobsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeRecommendationExportJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeRecommendationExportJobs for more information on using the DescribeRecommendationExportJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeRecommendationExportJobsRequest method.
//    req, resp := client.DescribeRecommendationExportJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/DescribeRecommendationExportJobs
func (c *ComputeOptimizer) DescribeRecommendationExportJobsRequest(input *DescribeRecommendationExportJobsInput) (req *request.Request, output *DescribeRecommendationExportJobsOutput) {
	op := &request.Operation{
		Name:       opDescribeRecommendationExportJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeRecommendationExportJobsInput{}
	}

	output = &DescribeRecommendationExportJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeRecommendationExportJobs API operation for AWS Compute Optimizer.
//
// Describes recommendation export jobs created in the last seven days.
//
// Use the ExportAutoScalingGroupRecommendations or ExportEC2InstanceRecommendations
// actions to request an export of your recommendations. Then use the DescribeRecommendationExportJobs
// action to view your export jobs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Compute Optimizer's
// API operation DescribeRecommendationExportJobs for usage and error information.
//
// Returned Error Types:
//   * OptInRequiredException
//   The account is not opted in to AWS Compute Optimizer.
//
//   * InternalServerException
//   An internal error has occurred. Try your call again.
//
//   * ServiceUnavailableException
//   The request has failed due to a temporary failure of the server.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * InvalidParameterValueException
//   An invalid or out-of-range value was supplied for the input parameter.
//
//   * ResourceNotFoundException
//   A resource that is required for the action doesn't exist.
//
//   * MissingAuthenticationToken
//   The request must contain either a valid (registered) AWS access key ID or
//   X.509 certificate.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/DescribeRecommendationExportJobs
func (c *ComputeOptimizer) DescribeRecommendationExportJobs(input *DescribeRecommendationExportJobsInput) (*DescribeRecommendationExportJobsOutput, error) {
	req, out := c.DescribeRecommendationExportJobsRequest(input)
	return out, req.Send()
}

// DescribeRecommendationExportJobsWithContext is the same as DescribeRecommendationExportJobs with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeRecommendationExportJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ComputeOptimizer) DescribeRecommendationExportJobsWithContext(ctx aws.Context, input *DescribeRecommendationExportJobsInput, opts ...request.Option) (*DescribeRecommendationExportJobsOutput, error) {
	req, out := c.DescribeRecommendationExportJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opExportAutoScalingGroupRecommendations = "ExportAutoScalingGroupRecommendations"

// ExportAutoScalingGroupRecommendationsRequest generates a "aws/request.Request" representing the
// client's request for the ExportAutoScalingGroupRecommendations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ExportAutoScalingGroupRecommendations for more information on using the ExportAutoScalingGroupRecommendations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ExportAutoScalingGroupRecommendationsRequest method.
//    req, resp := client.ExportAutoScalingGroupRecommendationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/ExportAutoScalingGroupRecommendations
func (c *ComputeOptimizer) ExportAutoScalingGroupRecommendationsRequest(input *ExportAutoScalingGroupRecommendationsInput) (req *request.Request, output *ExportAutoScalingGroupRecommendationsOutput) {
	op := &request.Operation{
		Name:       opExportAutoScalingGroupRecommendations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ExportAutoScalingGroupRecommendationsInput{}
	}

	output = &ExportAutoScalingGroupRecommendationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ExportAutoScalingGroupRecommendations API operation for AWS Compute Optimizer.
//
// Exports optimization recommendations for Auto Scaling groups.
//
// Recommendations are exported in a comma-separated values (.csv) file, and
// its metadata in a JavaScript Object Notation (.json) file, to an existing
// Amazon Simple Storage Service (Amazon S3) bucket that you specify. For more
// information, see Exporting Recommendations (https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html)
// in the Compute Optimizer User Guide.
//
// You can have only one Auto Scaling group export job in progress per AWS Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Compute Optimizer's
// API operation ExportAutoScalingGroupRecommendations for usage and error information.
//
// Returned Error Types:
//   * OptInRequiredException
//   The account is not opted in to AWS Compute Optimizer.
//
//   * InternalServerException
//   An internal error has occurred. Try your call again.
//
//   * ServiceUnavailableException
//   The request has failed due to a temporary failure of the server.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * InvalidParameterValueException
//   An invalid or out-of-range value was supplied for the input parameter.
//
//   * MissingAuthenticationToken
//   The request must contain either a valid (registered) AWS access key ID or
//   X.509 certificate.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
//   * LimitExceededException
//   The request exceeds a limit of the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/ExportAutoScalingGroupRecommendations
func (c *ComputeOptimizer) ExportAutoScalingGroupRecommendations(input *ExportAutoScalingGroupRecommendationsInput) (*ExportAutoScalingGroupRecommendationsOutput, error) {
	req, out := c.ExportAutoScalingGroupRecommendationsRequest(input)
	return out, req.Send()
}

// ExportAutoScalingGroupRecommendationsWithContext is the same as ExportAutoScalingGroupRecommendations with the addition of
// the ability to pass a context and additional request options.
//
// See ExportAutoScalingGroupRecommendations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ComputeOptimizer) ExportAutoScalingGroupRecommendationsWithContext(ctx aws.Context, input *ExportAutoScalingGroupRecommendationsInput, opts ...request.Option) (*ExportAutoScalingGroupRecommendationsOutput, error) {
	req, out := c.ExportAutoScalingGroupRecommendationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opExportEC2InstanceRecommendations = "ExportEC2InstanceRecommendations"

// ExportEC2InstanceRecommendationsRequest generates a "aws/request.Request" representing the
// client's request for the ExportEC2InstanceRecommendations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ExportEC2InstanceRecommendations for more information on using the ExportEC2InstanceRecommendations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ExportEC2InstanceRecommendationsRequest method.
//    req, resp := client.ExportEC2InstanceRecommendationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/ExportEC2InstanceRecommendations
func (c *ComputeOptimizer) ExportEC2InstanceRecommendationsRequest(input *ExportEC2InstanceRecommendationsInput) (req *request.Request, output *ExportEC2InstanceRecommendationsOutput) {
	op := &request.Operation{
		Name:       opExportEC2InstanceRecommendations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ExportEC2InstanceRecommendationsInput{}
	}

	output = &ExportEC2InstanceRecommendationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ExportEC2InstanceRecommendations API operation for AWS Compute Optimizer.
//
// Exports optimization recommendations for Amazon EC2 instances.
//
// Recommendations are exported in a comma-separated values (.csv) file, and
// its metadata in a JavaScript Object Notation (.json) file, to an existing
// Amazon Simple Storage Service (Amazon S3) bucket that you specify. For more
// information, see Exporting Recommendations (https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html)
// in the Compute Optimizer User Guide.
//
// You can have only one Amazon EC2 instance export job in progress per AWS
// Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Compute Optimizer's
// API operation ExportEC2InstanceRecommendations for usage and error information.
//
// Returned Error Types:
//   * OptInRequiredException
//   The account is not opted in to AWS Compute Optimizer.
//
//   * InternalServerException
//   An internal error has occurred. Try your call again.
//
//   * ServiceUnavailableException
//   The request has failed due to a temporary failure of the server.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * InvalidParameterValueException
//   An invalid or out-of-range value was supplied for the input parameter.
//
//   * MissingAuthenticationToken
//   The request must contain either a valid (registered) AWS access key ID or
//   X.509 certificate.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
//   * LimitExceededException
//   The request exceeds a limit of the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/ExportEC2InstanceRecommendations
func (c *ComputeOptimizer) ExportEC2InstanceRecommendations(input *ExportEC2InstanceRecommendationsInput) (*ExportEC2InstanceRecommendationsOutput, error) {
	req, out := c.ExportEC2InstanceRecommendationsRequest(input)
	return out, req.Send()
}

// ExportEC2InstanceRecommendationsWithContext is the same as ExportEC2InstanceRecommendations with the addition of
// the ability to pass a context and additional request options.
//
// See ExportEC2InstanceRecommendations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ComputeOptimizer) ExportEC2InstanceRecommendationsWithContext(ctx aws.Context, input *ExportEC2InstanceRecommendationsInput, opts ...request.Option) (*ExportEC2InstanceRecommendationsOutput, error) {
	req, out := c.ExportEC2InstanceRecommendationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAutoScalingGroupRecommendations = "GetAutoScalingGroupRecommendations"

// GetAutoScalingGroupRecommendationsRequest generates a "aws/request.Request" representing the
// client's request for the GetAutoScalingGroupRecommendations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAutoScalingGroupRecommendations for more information on using the GetAutoScalingGroupRecommendations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAutoScalingGroupRecommendationsRequest method.
//    req, resp := client.GetAutoScalingGroupRecommendationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/GetAutoScalingGroupRecommendations
func (c *ComputeOptimizer) GetAutoScalingGroupRecommendationsRequest(input *GetAutoScalingGroupRecommendationsInput) (req *request.Request, output *GetAutoScalingGroupRecommendationsOutput) {
	op := &request.Operation{
		Name:       opGetAutoScalingGroupRecommendations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetAutoScalingGroupRecommendationsInput{}
	}

	output = &GetAutoScalingGroupRecommendationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAutoScalingGroupRecommendations API operation for AWS Compute Optimizer.
//
// Returns Auto Scaling group recommendations.
//
// AWS Compute Optimizer currently generates recommendations for Auto Scaling
// groups that are configured to run instances of the M, C, R, T, and X instance
// families. The service does not generate recommendations for Auto Scaling
// groups that have a scaling policy attached to them, or that do not have the
// same values for desired, minimum, and maximum capacity. In order for Compute
// Optimizer to analyze your Auto Scaling groups, they must be of a fixed size.
// For more information, see the AWS Compute Optimizer User Guide (https://docs.aws.amazon.com/compute-optimizer/latest/ug/what-is.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Compute Optimizer's
// API operation GetAutoScalingGroupRecommendations for usage and error information.
//
// Returned Error Types:
//   * OptInRequiredException
//   The account is not opted in to AWS Compute Optimizer.
//
//   * InternalServerException
//   An internal error has occurred. Try your call again.
//
//   * ServiceUnavailableException
//   The request has failed due to a temporary failure of the server.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * InvalidParameterValueException
//   An invalid or out-of-range value was supplied for the input parameter.
//
//   * ResourceNotFoundException
//   A resource that is required for the action doesn't exist.
//
//   * MissingAuthenticationToken
//   The request must contain either a valid (registered) AWS access key ID or
//   X.509 certificate.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/GetAutoScalingGroupRecommendations
func (c *ComputeOptimizer) GetAutoScalingGroupRecommendations(input *GetAutoScalingGroupRecommendationsInput) (*GetAutoScalingGroupRecommendationsOutput, error) {
	req, out := c.GetAutoScalingGroupRecommendationsRequest(input)
	return out, req.Send()
}

// GetAutoScalingGroupRecommendationsWithContext is the same as GetAutoScalingGroupRecommendations with the addition of
// the ability to pass a context and additional request options.
//
// See GetAutoScalingGroupRecommendations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ComputeOptimizer) GetAutoScalingGroupRecommendationsWithContext(ctx aws.Context, input *GetAutoScalingGroupRecommendationsInput, opts ...request.Option) (*GetAutoScalingGroupRecommendationsOutput, error) {
	req, out := c.GetAutoScalingGroupRecommendationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetEC2InstanceRecommendations = "GetEC2InstanceRecommendations"

// GetEC2InstanceRecommendationsRequest generates a "aws/request.Request" representing the
// client's request for the GetEC2InstanceRecommendations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEC2InstanceRecommendations for more information on using the GetEC2InstanceRecommendations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetEC2InstanceRecommendationsRequest method.
//    req, resp := client.GetEC2InstanceRecommendationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/GetEC2InstanceRecommendations
func (c *ComputeOptimizer) GetEC2InstanceRecommendationsRequest(input *GetEC2InstanceRecommendationsInput) (req *request.Request, output *GetEC2InstanceRecommendationsOutput) {
	op := &request.Operation{
		Name:       opGetEC2InstanceRecommendations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetEC2InstanceRecommendationsInput{}
	}

	output = &GetEC2InstanceRecommendationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetEC2InstanceRecommendations API operation for AWS Compute Optimizer.
//
// Returns Amazon EC2 instance recommendations.
//
// AWS Compute Optimizer currently generates recommendations for Amazon Elastic
// Compute Cloud (Amazon EC2) and Amazon EC2 Auto Scaling. It generates recommendations
// for M, C, R, T, and X instance families. For more information, see the AWS
// Compute Optimizer User Guide (https://docs.aws.amazon.com/compute-optimizer/latest/ug/what-is.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Compute Optimizer's
// API operation GetEC2InstanceRecommendations for usage and error information.
//
// Returned Error Types:
//   * OptInRequiredException
//   The account is not opted in to AWS Compute Optimizer.
//
//   * InternalServerException
//   An internal error has occurred. Try your call again.
//
//   * ServiceUnavailableException
//   The request has failed due to a temporary failure of the server.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * InvalidParameterValueException
//   An invalid or out-of-range value was supplied for the input parameter.
//
//   * ResourceNotFoundException
//   A resource that is required for the action doesn't exist.
//
//   * MissingAuthenticationToken
//   The request must contain either a valid (registered) AWS access key ID or
//   X.509 certificate.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/GetEC2InstanceRecommendations
func (c *ComputeOptimizer) GetEC2InstanceRecommendations(input *GetEC2InstanceRecommendationsInput) (*GetEC2InstanceRecommendationsOutput, error) {
	req, out := c.GetEC2InstanceRecommendationsRequest(input)
	return out, req.Send()
}

// GetEC2InstanceRecommendationsWithContext is the same as GetEC2InstanceRecommendations with the addition of
// the ability to pass a context and additional request options.
//
// See GetEC2InstanceRecommendations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ComputeOptimizer) GetEC2InstanceRecommendationsWithContext(ctx aws.Context, input *GetEC2InstanceRecommendationsInput, opts ...request.Option) (*GetEC2InstanceRecommendationsOutput, error) {
	req, out := c.GetEC2InstanceRecommendationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetEC2RecommendationProjectedMetrics = "GetEC2RecommendationProjectedMetrics"

// GetEC2RecommendationProjectedMetricsRequest generates a "aws/request.Request" representing the
// client's request for the GetEC2RecommendationProjectedMetrics operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEC2RecommendationProjectedMetrics for more information on using the GetEC2RecommendationProjectedMetrics
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetEC2RecommendationProjectedMetricsRequest method.
//    req, resp := client.GetEC2RecommendationProjectedMetricsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/GetEC2RecommendationProjectedMetrics
func (c *ComputeOptimizer) GetEC2RecommendationProjectedMetricsRequest(input *GetEC2RecommendationProjectedMetricsInput) (req *request.Request, output *GetEC2RecommendationProjectedMetricsOutput) {
	op := &request.Operation{
		Name:       opGetEC2RecommendationProjectedMetrics,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetEC2RecommendationProjectedMetricsInput{}
	}

	output = &GetEC2RecommendationProjectedMetricsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetEC2RecommendationProjectedMetrics API operation for AWS Compute Optimizer.
//
// Returns the projected utilization metrics of Amazon EC2 instance recommendations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Compute Optimizer's
// API operation GetEC2RecommendationProjectedMetrics for usage and error information.
//
// Returned Error Types:
//   * OptInRequiredException
//   The account is not opted in to AWS Compute Optimizer.
//
//   * InternalServerException
//   An internal error has occurred. Try your call again.
//
//   * ServiceUnavailableException
//   The request has failed due to a temporary failure of the server.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * InvalidParameterValueException
//   An invalid or out-of-range value was supplied for the input parameter.
//
//   * ResourceNotFoundException
//   A resource that is required for the action doesn't exist.
//
//   * MissingAuthenticationToken
//   The request must contain either a valid (registered) AWS access key ID or
//   X.509 certificate.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/GetEC2RecommendationProjectedMetrics
func (c *ComputeOptimizer) GetEC2RecommendationProjectedMetrics(input *GetEC2RecommendationProjectedMetricsInput) (*GetEC2RecommendationProjectedMetricsOutput, error) {
	req, out := c.GetEC2RecommendationProjectedMetricsRequest(input)
	return out, req.Send()
}

// GetEC2RecommendationProjectedMetricsWithContext is the same as GetEC2RecommendationProjectedMetrics with the addition of
// the ability to pass a context and additional request options.
//
// See GetEC2RecommendationProjectedMetrics for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ComputeOptimizer) GetEC2RecommendationProjectedMetricsWithContext(ctx aws.Context, input *GetEC2RecommendationProjectedMetricsInput, opts ...request.Option) (*GetEC2RecommendationProjectedMetricsOutput, error) {
	req, out := c.GetEC2RecommendationProjectedMetricsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetEnrollmentStatus = "GetEnrollmentStatus"

// GetEnrollmentStatusRequest generates a "aws/request.Request" representing the
// client's request for the GetEnrollmentStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEnrollmentStatus for more information on using the GetEnrollmentStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetEnrollmentStatusRequest method.
//    req, resp := client.GetEnrollmentStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/GetEnrollmentStatus
func (c *ComputeOptimizer) GetEnrollmentStatusRequest(input *GetEnrollmentStatusInput) (req *request.Request, output *GetEnrollmentStatusOutput) {
	op := &request.Operation{
		Name:       opGetEnrollmentStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetEnrollmentStatusInput{}
	}

	output = &GetEnrollmentStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetEnrollmentStatus API operation for AWS Compute Optimizer.
//
// Returns the enrollment (opt in) status of an account to the AWS Compute Optimizer
// service.
//
// If the account is the master account of an organization, this action also
// confirms the enrollment status of member accounts within the organization.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Compute Optimizer's
// API operation GetEnrollmentStatus for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   An internal error has occurred. Try your call again.
//
//   * ServiceUnavailableException
//   The request has failed due to a temporary failure of the server.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * InvalidParameterValueException
//   An invalid or out-of-range value was supplied for the input parameter.
//
//   * MissingAuthenticationToken
//   The request must contain either a valid (registered) AWS access key ID or
//   X.509 certificate.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/GetEnrollmentStatus
func (c *ComputeOptimizer) GetEnrollmentStatus(input *GetEnrollmentStatusInput) (*GetEnrollmentStatusOutput, error) {
	req, out := c.GetEnrollmentStatusRequest(input)
	return out, req.Send()
}

// GetEnrollmentStatusWithContext is the same as GetEnrollmentStatus with the addition of
// the ability to pass a context and additional request options.
//
// See GetEnrollmentStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ComputeOptimizer) GetEnrollmentStatusWithContext(ctx aws.Context, input *GetEnrollmentStatusInput, opts ...request.Option) (*GetEnrollmentStatusOutput, error) {
	req, out := c.GetEnrollmentStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRecommendationSummaries = "GetRecommendationSummaries"

// GetRecommendationSummariesRequest generates a "aws/request.Request" representing the
// client's request for the GetRecommendationSummaries operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRecommendationSummaries for more information on using the GetRecommendationSummaries
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetRecommendationSummariesRequest method.
//    req, resp := client.GetRecommendationSummariesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/GetRecommendationSummaries
func (c *ComputeOptimizer) GetRecommendationSummariesRequest(input *GetRecommendationSummariesInput) (req *request.Request, output *GetRecommendationSummariesOutput) {
	op := &request.Operation{
		Name:       opGetRecommendationSummaries,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRecommendationSummariesInput{}
	}

	output = &GetRecommendationSummariesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRecommendationSummaries API operation for AWS Compute Optimizer.
//
// Returns the optimization findings for an account.
//
// For example, it returns the number of Amazon EC2 instances in an account
// that are under-provisioned, over-provisioned, or optimized. It also returns
// the number of Auto Scaling groups in an account that are not optimized, or
// optimized.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Compute Optimizer's
// API operation GetRecommendationSummaries for usage and error information.
//
// Returned Error Types:
//   * OptInRequiredException
//   The account is not opted in to AWS Compute Optimizer.
//
//   * InternalServerException
//   An internal error has occurred. Try your call again.
//
//   * ServiceUnavailableException
//   The request has failed due to a temporary failure of the server.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * InvalidParameterValueException
//   An invalid or out-of-range value was supplied for the input parameter.
//
//   * MissingAuthenticationToken
//   The request must contain either a valid (registered) AWS access key ID or
//   X.509 certificate.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/GetRecommendationSummaries
func (c *ComputeOptimizer) GetRecommendationSummaries(input *GetRecommendationSummariesInput) (*GetRecommendationSummariesOutput, error) {
	req, out := c.GetRecommendationSummariesRequest(input)
	return out, req.Send()
}

// GetRecommendationSummariesWithContext is the same as GetRecommendationSummaries with the addition of
// the ability to pass a context and additional request options.
//
// See GetRecommendationSummaries for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ComputeOptimizer) GetRecommendationSummariesWithContext(ctx aws.Context, input *GetRecommendationSummariesInput, opts ...request.Option) (*GetRecommendationSummariesOutput, error) {
	req, out := c.GetRecommendationSummariesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateEnrollmentStatus = "UpdateEnrollmentStatus"

// UpdateEnrollmentStatusRequest generates a "aws/request.Request" representing the
// client's request for the UpdateEnrollmentStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateEnrollmentStatus for more information on using the UpdateEnrollmentStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateEnrollmentStatusRequest method.
//    req, resp := client.UpdateEnrollmentStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/UpdateEnrollmentStatus
func (c *ComputeOptimizer) UpdateEnrollmentStatusRequest(input *UpdateEnrollmentStatusInput) (req *request.Request, output *UpdateEnrollmentStatusOutput) {
	op := &request.Operation{
		Name:       opUpdateEnrollmentStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateEnrollmentStatusInput{}
	}

	output = &UpdateEnrollmentStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateEnrollmentStatus API operation for AWS Compute Optimizer.
//
// Updates the enrollment (opt in) status of an account to the AWS Compute Optimizer
// service.
//
// If the account is a master account of an organization, this action can also
// be used to enroll member accounts within the organization.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Compute Optimizer's
// API operation UpdateEnrollmentStatus for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   An internal error has occurred. Try your call again.
//
//   * ServiceUnavailableException
//   The request has failed due to a temporary failure of the server.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * InvalidParameterValueException
//   An invalid or out-of-range value was supplied for the input parameter.
//
//   * MissingAuthenticationToken
//   The request must contain either a valid (registered) AWS access key ID or
//   X.509 certificate.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/UpdateEnrollmentStatus
func (c *ComputeOptimizer) UpdateEnrollmentStatus(input *UpdateEnrollmentStatusInput) (*UpdateEnrollmentStatusOutput, error) {
	req, out := c.UpdateEnrollmentStatusRequest(input)
	return out, req.Send()
}

// UpdateEnrollmentStatusWithContext is the same as UpdateEnrollmentStatus with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateEnrollmentStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ComputeOptimizer) UpdateEnrollmentStatusWithContext(ctx aws.Context, input *UpdateEnrollmentStatusInput, opts ...request.Option) (*UpdateEnrollmentStatusOutput, error) {
	req, out := c.UpdateEnrollmentStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You do not have sufficient access to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Describes the configuration of an Auto Scaling group.
type AutoScalingGroupConfiguration struct {
	_ struct{} `type:"structure"`

	// The desired capacity, or number of instances, for the Auto Scaling group.
	DesiredCapacity *int64 `locationName:"desiredCapacity" type:"integer"`

	// The instance type for the Auto Scaling group.
	InstanceType *string `locationName:"instanceType" type:"string"`

	// The maximum size, or maximum number of instances, for the Auto Scaling group.
	MaxSize *int64 `locationName:"maxSize" type:"integer"`

	// The minimum size, or minimum number of instances, for the Auto Scaling group.
	MinSize *int64 `locationName:"minSize" type:"integer"`
}

// String returns the string representation
func (s AutoScalingGroupConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AutoScalingGroupConfiguration) GoString() string {
	return s.String()
}

// SetDesiredCapacity sets the DesiredCapacity field's value.
func (s *AutoScalingGroupConfiguration) SetDesiredCapacity(v int64) *AutoScalingGroupConfiguration {
	s.DesiredCapacity = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *AutoScalingGroupConfiguration) SetInstanceType(v string) *AutoScalingGroupConfiguration {
	s.InstanceType = &v
	return s
}

// SetMaxSize sets the MaxSize field's value.
func (s *AutoScalingGroupConfiguration) SetMaxSize(v int64) *AutoScalingGroupConfiguration {
	s.MaxSize = &v
	return s
}

// SetMinSize sets the MinSize field's value.
func (s *AutoScalingGroupConfiguration) SetMinSize(v int64) *AutoScalingGroupConfiguration {
	s.MinSize = &v
	return s
}

// Describes an Auto Scaling group recommendation.
type AutoScalingGroupRecommendation struct {
	_ struct{} `type:"structure"`

	// The AWS account ID of the Auto Scaling group.
	AccountId *string `locationName:"accountId" type:"string"`

	// The Amazon Resource Name (ARN) of the Auto Scaling group.
	AutoScalingGroupArn *string `locationName:"autoScalingGroupArn" type:"string"`

	// The name of the Auto Scaling group.
	AutoScalingGroupName *string `locationName:"autoScalingGroupName" type:"string"`

	// An array of objects that describe the current configuration of the Auto Scaling
	// group.
	CurrentConfiguration *AutoScalingGroupConfiguration `locationName:"currentConfiguration" type:"structure"`

	// The finding classification for the Auto Scaling group.
	//
	// Findings for Auto Scaling groups include:
	//
	//    * NotOptimized —An Auto Scaling group is considered not optimized when
	//    AWS Compute Optimizer identifies a recommendation that can provide better
	//    performance for your workload.
	//
	//    * Optimized —An Auto Scaling group is considered optimized when Compute
	//    Optimizer determines that the group is correctly provisioned to run your
	//    workload based on the chosen instance type. For optimized resources, Compute
	//    Optimizer might recommend a new generation instance type.
	//
	// The values that are returned might be NOT_OPTIMIZED or OPTIMIZED.
	Finding *string `locationName:"finding" type:"string" enum:"Finding"`

	// The time stamp of when the Auto Scaling group recommendation was last refreshed.
	LastRefreshTimestamp *time.Time `locationName:"lastRefreshTimestamp" type:"timestamp"`

	// The number of days for which utilization metrics were analyzed for the Auto
	// Scaling group.
	LookBackPeriodInDays *float64 `locationName:"lookBackPeriodInDays" type:"double"`

	// An array of objects that describe the recommendation options for the Auto
	// Scaling group.
	RecommendationOptions []*AutoScalingGroupRecommendationOption `locationName:"recommendationOptions" type:"list"`

	// An array of objects that describe the utilization metrics of the Auto Scaling
	// group.
	UtilizationMetrics []*UtilizationMetric `locationName:"utilizationMetrics" type:"list"`
}

// String returns the string representation
func (s AutoScalingGroupRecommendation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AutoScalingGroupRecommendation) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *AutoScalingGroupRecommendation) SetAccountId(v string) *AutoScalingGroupRecommendation {
	s.AccountId = &v
	return s
}

// SetAutoScalingGroupArn sets the AutoScalingGroupArn field's value.
func (s *AutoScalingGroupRecommendation) SetAutoScalingGroupArn(v string) *AutoScalingGroupRecommendation {
	s.AutoScalingGroupArn = &v
	return s
}

// SetAutoScalingGroupName sets the AutoScalingGroupName field's value.
func (s *AutoScalingGroupRecommendation) SetAutoScalingGroupName(v string) *AutoScalingGroupRecommendation {
	s.AutoScalingGroupName = &v
	return s
}

// SetCurrentConfiguration sets the CurrentConfiguration field's value.
func (s *AutoScalingGroupRecommendation) SetCurrentConfiguration(v *AutoScalingGroupConfiguration) *AutoScalingGroupRecommendation {
	s.CurrentConfiguration = v
	return s
}

// SetFinding sets the Finding field's value.
func (s *AutoScalingGroupRecommendation) SetFinding(v string) *AutoScalingGroupRecommendation {
	s.Finding = &v
	return s
}

// SetLastRefreshTimestamp sets the LastRefreshTimestamp field's value.
func (s *AutoScalingGroupRecommendation) SetLastRefreshTimestamp(v time.Time) *AutoScalingGroupRecommendation {
	s.LastRefreshTimestamp = &v
	return s
}

// SetLookBackPeriodInDays sets the LookBackPeriodInDays field's value.
func (s *AutoScalingGroupRecommendation) SetLookBackPeriodInDays(v float64) *AutoScalingGroupRecommendation {
	s.LookBackPeriodInDays = &v
	return s
}

// SetRecommendationOptions sets the RecommendationOptions field's value.
func (s *AutoScalingGroupRecommendation) SetRecommendationOptions(v []*AutoScalingGroupRecommendationOption) *AutoScalingGroupRecommendation {
	s.RecommendationOptions = v
	return s
}

// SetUtilizationMetrics sets the UtilizationMetrics field's value.
func (s *AutoScalingGroupRecommendation) SetUtilizationMetrics(v []*UtilizationMetric) *AutoScalingGroupRecommendation {
	s.UtilizationMetrics = v
	return s
}

// Describes a recommendation option for an Auto Scaling group.
type AutoScalingGroupRecommendationOption struct {
	_ struct{} `type:"structure"`

	// An array of objects that describe an Auto Scaling group configuration.
	Configuration *AutoScalingGroupConfiguration `locationName:"configuration" type:"structure"`

	// The performance risk of the Auto Scaling group configuration recommendation.
	//
	// Performance risk is the likelihood of the recommended instance type not meeting
	// the performance requirement of your workload.
	//
	// The lowest performance risk is categorized as 0, and the highest as 5.
	PerformanceRisk *float64 `locationName:"performanceRisk" type:"double"`

	// An array of objects that describe the projected utilization metrics of the
	// Auto Scaling group recommendation option.
	ProjectedUtilizationMetrics []*UtilizationMetric `locationName:"projectedUtilizationMetrics" type:"list"`

	// The rank of the Auto Scaling group recommendation option.
	//
	// The top recommendation option is ranked as 1.
	Rank *int64 `locationName:"rank" type:"integer"`
}

// String returns the string representation
func (s AutoScalingGroupRecommendationOption) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AutoScalingGroupRecommendationOption) GoString() string {
	return s.String()
}

// SetConfiguration sets the Configuration field's value.
func (s *AutoScalingGroupRecommendationOption) SetConfiguration(v *AutoScalingGroupConfiguration) *AutoScalingGroupRecommendationOption {
	s.Configuration = v
	return s
}

// SetPerformanceRisk sets the PerformanceRisk field's value.
func (s *AutoScalingGroupRecommendationOption) SetPerformanceRisk(v float64) *AutoScalingGroupRecommendationOption {
	s.PerformanceRisk = &v
	return s
}

// SetProjectedUtilizationMetrics sets the ProjectedUtilizationMetrics field's value.
func (s *AutoScalingGroupRecommendationOption) SetProjectedUtilizationMetrics(v []*UtilizationMetric) *AutoScalingGroupRecommendationOption {
	s.ProjectedUtilizationMetrics = v
	return s
}

// SetRank sets the Rank field's value.
func (s *AutoScalingGroupRecommendationOption) SetRank(v int64) *AutoScalingGroupRecommendationOption {
	s.Rank = &v
	return s
}

type DescribeRecommendationExportJobsInput struct {
	_ struct{} `type:"structure"`

	// An array of objects that describe a filter to return a more specific list
	// of export jobs.
	Filters []*JobFilter `locationName:"filters" type:"list"`

	// The identification numbers of the export jobs to return.
	//
	// An export job ID is returned when you create an export using the ExportAutoScalingGroupRecommendations
	// or ExportEC2InstanceRecommendations actions.
	//
	// All export jobs created in the last seven days are returned if this parameter
	// is omitted.
	JobIds []*string `locationName:"jobIds" type:"list"`

	// The maximum number of export jobs to return with a single request.
	//
	// To retrieve the remaining results, make another request with the returned
	// NextToken value.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The token to advance to the next page of export jobs.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeRecommendationExportJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRecommendationExportJobsInput) GoString() string {
	return s.String()
}

// SetFilters sets the Filters field's value.
func (s *DescribeRecommendationExportJobsInput) SetFilters(v []*JobFilter) *DescribeRecommendationExportJobsInput {
	s.Filters = v
	return s
}

// SetJobIds sets the JobIds field's value.
func (s *DescribeRecommendationExportJobsInput) SetJobIds(v []*string) *DescribeRecommendationExportJobsInput {
	s.JobIds = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeRecommendationExportJobsInput) SetMaxResults(v int64) *DescribeRecommendationExportJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeRecommendationExportJobsInput) SetNextToken(v string) *DescribeRecommendationExportJobsInput {
	s.NextToken = &v
	return s
}

type DescribeRecommendationExportJobsOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to advance to the next page of export jobs.
	//
	// This value is null when there are no more pages of export jobs to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// An array of objects that describe recommendation export jobs.
	RecommendationExportJobs []*RecommendationExportJob `locationName:"recommendationExportJobs" type:"list"`
}

// String returns the string representation
func (s DescribeRecommendationExportJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRecommendationExportJobsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeRecommendationExportJobsOutput) SetNextToken(v string) *DescribeRecommendationExportJobsOutput {
	s.NextToken = &v
	return s
}

// SetRecommendationExportJobs sets the RecommendationExportJobs field's value.
func (s *DescribeRecommendationExportJobsOutput) SetRecommendationExportJobs(v []*RecommendationExportJob) *DescribeRecommendationExportJobsOutput {
	s.RecommendationExportJobs = v
	return s
}

type ExportAutoScalingGroupRecommendationsInput struct {
	_ struct{} `type:"structure"`

	// The IDs of the AWS accounts for which to export Auto Scaling group recommendations.
	//
	// If your account is the master account of an organization, use this parameter
	// to specify the member accounts for which you want to export recommendations.
	//
	// This parameter cannot be specified together with the include member accounts
	// parameter. The parameters are mutually exclusive.
	//
	// Recommendations for member accounts are not included in the export if this
	// parameter, or the include member accounts parameter, is omitted.
	//
	// You can specify multiple account IDs per request.
	AccountIds []*string `locationName:"accountIds" type:"list"`

	// The recommendations data to include in the export file.
	FieldsToExport []*string `locationName:"fieldsToExport" type:"list"`

	// The format of the export file.
	//
	// The only export file format currently supported is Csv.
	FileFormat *string `locationName:"fileFormat" type:"string" enum:"FileFormat"`

	// An array of objects that describe a filter to export a more specific set
	// of Auto Scaling group recommendations.
	Filters []*Filter `locationName:"filters" type:"list"`

	// Indicates whether to include recommendations for resources in all member
	// accounts of the organization if your account is the master account of an
	// organization.
	//
	// The member accounts must also be opted in to Compute Optimizer.
	//
	// Recommendations for member accounts of the organization are not included
	// in the export file if this parameter is omitted.
	//
	// This parameter cannot be specified together with the account IDs parameter.
	// The parameters are mutually exclusive.
	//
	// Recommendations for member accounts are not included in the export if this
	// parameter, or the account IDs parameter, is omitted.
	IncludeMemberAccounts *bool `locationName:"includeMemberAccounts" type:"boolean"`

	// An object to specify the destination Amazon Simple Storage Service (Amazon
	// S3) bucket name and key prefix for the export job.
	//
	// You must create the destination Amazon S3 bucket for your recommendations
	// export before you create the export job. Compute Optimizer does not create
	// the S3 bucket for you. After you create the S3 bucket, ensure that it has
	// the required permission policy to allow Compute Optimizer to write the export
	// file to it. If you plan to specify an object prefix when you create the export
	// job, you must include the object prefix in the policy that you add to the
	// S3 bucket. For more information, see Amazon S3 Bucket Policy for Compute
	// Optimizer (https://docs.aws.amazon.com/compute-optimizer/latest/ug/create-s3-bucket-policy-for-compute-optimizer.html)
	// in the Compute Optimizer user guide.
	//
	// S3DestinationConfig is a required field
	S3DestinationConfig *S3DestinationConfig `locationName:"s3DestinationConfig" type:"structure" required:"true"`
}

// String returns the string representation
func (s ExportAutoScalingGroupRecommendationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExportAutoScalingGroupRecommendationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExportAutoScalingGroupRecommendationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExportAutoScalingGroupRecommendationsInput"}
	if s.S3DestinationConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("S3DestinationConfig"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountIds sets the AccountIds field's value.
func (s *ExportAutoScalingGroupRecommendationsInput) SetAccountIds(v []*string) *ExportAutoScalingGroupRecommendationsInput {
	s.AccountIds = v
	return s
}

// SetFieldsToExport sets the FieldsToExport field's value.
func (s *ExportAutoScalingGroupRecommendationsInput) SetFieldsToExport(v []*string) *ExportAutoScalingGroupRecommendationsInput {
	s.FieldsToExport = v
	return s
}

// SetFileFormat sets the FileFormat field's value.
func (s *ExportAutoScalingGroupRecommendationsInput) SetFileFormat(v string) *ExportAutoScalingGroupRecommendationsInput {
	s.FileFormat = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *ExportAutoScalingGroupRecommendationsInput) SetFilters(v []*Filter) *ExportAutoScalingGroupRecommendationsInput {
	s.Filters = v
	return s
}

// SetIncludeMemberAccounts sets the IncludeMemberAccounts field's value.
func (s *ExportAutoScalingGroupRecommendationsInput) SetIncludeMemberAccounts(v bool) *ExportAutoScalingGroupRecommendationsInput {
	s.IncludeMemberAccounts = &v
	return s
}

// SetS3DestinationConfig sets the S3DestinationConfig field's value.
func (s *ExportAutoScalingGroupRecommendationsInput) SetS3DestinationConfig(v *S3DestinationConfig) *ExportAutoScalingGroupRecommendationsInput {
	s.S3DestinationConfig = v
	return s
}

type ExportAutoScalingGroupRecommendationsOutput struct {
	_ struct{} `type:"structure"`

	// The identification number of the export job.
	//
	// Use the DescribeRecommendationExportJobs action, and specify the job ID to
	// view the status of an export job.
	JobId *string `locationName:"jobId" type:"string"`

	// An object that describes the destination Amazon S3 bucket of a recommendations
	// export file.
	S3Destination *S3Destination `locationName:"s3Destination" type:"structure"`
}

// String returns the string representation
func (s ExportAutoScalingGroupRecommendationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExportAutoScalingGroupRecommendationsOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *ExportAutoScalingGroupRecommendationsOutput) SetJobId(v string) *ExportAutoScalingGroupRecommendationsOutput {
	s.JobId = &v
	return s
}

// SetS3Destination sets the S3Destination field's value.
func (s *ExportAutoScalingGroupRecommendationsOutput) SetS3Destination(v *S3Destination) *ExportAutoScalingGroupRecommendationsOutput {
	s.S3Destination = v
	return s
}

// Describes the destination of the recommendations export and metadata files.
type ExportDestination struct {
	_ struct{} `type:"structure"`

	// An object that describes the destination Amazon Simple Storage Service (Amazon
	// S3) bucket name and object keys of a recommendations export file, and its
	// associated metadata file.
	S3 *S3Destination `locationName:"s3" type:"structure"`
}

// String returns the string representation
func (s ExportDestination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExportDestination) GoString() string {
	return s.String()
}

// SetS3 sets the S3 field's value.
func (s *ExportDestination) SetS3(v *S3Destination) *ExportDestination {
	s.S3 = v
	return s
}

type ExportEC2InstanceRecommendationsInput struct {
	_ struct{} `type:"structure"`

	// The IDs of the AWS accounts for which to export instance recommendations.
	//
	// If your account is the master account of an organization, use this parameter
	// to specify the member accounts for which you want to export recommendations.
	//
	// This parameter cannot be specified together with the include member accounts
	// parameter. The parameters are mutually exclusive.
	//
	// Recommendations for member accounts are not included in the export if this
	// parameter, or the include member accounts parameter, is omitted.
	//
	// You can specify multiple account IDs per request.
	AccountIds []*string `locationName:"accountIds" type:"list"`

	// The recommendations data to include in the export file.
	FieldsToExport []*string `locationName:"fieldsToExport" type:"list"`

	// The format of the export file.
	//
	// The only export file format currently supported is Csv.
	FileFormat *string `locationName:"fileFormat" type:"string" enum:"FileFormat"`

	// An array of objects that describe a filter to export a more specific set
	// of instance recommendations.
	Filters []*Filter `locationName:"filters" type:"list"`

	// Indicates whether to include recommendations for resources in all member
	// accounts of the organization if your account is the master account of an
	// organization.
	//
	// The member accounts must also be opted in to Compute Optimizer.
	//
	// Recommendations for member accounts of the organization are not included
	// in the export file if this parameter is omitted.
	//
	// Recommendations for member accounts are not included in the export if this
	// parameter, or the account IDs parameter, is omitted.
	IncludeMemberAccounts *bool `locationName:"includeMemberAccounts" type:"boolean"`

	// An object to specify the destination Amazon Simple Storage Service (Amazon
	// S3) bucket name and key prefix for the export job.
	//
	// You must create the destination Amazon S3 bucket for your recommendations
	// export before you create the export job. Compute Optimizer does not create
	// the S3 bucket for you. After you create the S3 bucket, ensure that it has
	// the required permission policy to allow Compute Optimizer to write the export
	// file to it. If you plan to specify an object prefix when you create the export
	// job, you must include the object prefix in the policy that you add to the
	// S3 bucket. For more information, see Amazon S3 Bucket Policy for Compute
	// Optimizer (https://docs.aws.amazon.com/compute-optimizer/latest/ug/create-s3-bucket-policy-for-compute-optimizer.html)
	// in the Compute Optimizer user guide.
	//
	// S3DestinationConfig is a required field
	S3DestinationConfig *S3DestinationConfig `locationName:"s3DestinationConfig" type:"structure" required:"true"`
}

// String returns the string representation
func (s ExportEC2InstanceRecommendationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExportEC2InstanceRecommendationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExportEC2InstanceRecommendationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExportEC2InstanceRecommendationsInput"}
	if s.S3DestinationConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("S3DestinationConfig"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountIds sets the AccountIds field's value.
func (s *ExportEC2InstanceRecommendationsInput) SetAccountIds(v []*string) *ExportEC2InstanceRecommendationsInput {
	s.AccountIds = v
	return s
}

// SetFieldsToExport sets the FieldsToExport field's value.
func (s *ExportEC2InstanceRecommendationsInput) SetFieldsToExport(v []*string) *ExportEC2InstanceRecommendationsInput {
	s.FieldsToExport = v
	return s
}

// SetFileFormat sets the FileFormat field's value.
func (s *ExportEC2InstanceRecommendationsInput) SetFileFormat(v string) *ExportEC2InstanceRecommendationsInput {
	s.FileFormat = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *ExportEC2InstanceRecommendationsInput) SetFilters(v []*Filter) *ExportEC2InstanceRecommendationsInput {
	s.Filters = v
	return s
}

// SetIncludeMemberAccounts sets the IncludeMemberAccounts field's value.
func (s *ExportEC2InstanceRecommendationsInput) SetIncludeMemberAccounts(v bool) *ExportEC2InstanceRecommendationsInput {
	s.IncludeMemberAccounts = &v
	return s
}

// SetS3DestinationConfig sets the S3DestinationConfig field's value.
func (s *ExportEC2InstanceRecommendationsInput) SetS3DestinationConfig(v *S3DestinationConfig) *ExportEC2InstanceRecommendationsInput {
	s.S3DestinationConfig = v
	return s
}

type ExportEC2InstanceRecommendationsOutput struct {
	_ struct{} `type:"structure"`

	// The identification number of the export job.
	//
	// Use the DescribeRecommendationExportJobs action, and specify the job ID to
	// view the status of an export job.
	JobId *string `locationName:"jobId" type:"string"`

	// An object that describes the destination Amazon S3 bucket of a recommendations
	// export file.
	S3Destination *S3Destination `locationName:"s3Destination" type:"structure"`
}

// String returns the string representation
func (s ExportEC2InstanceRecommendationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExportEC2InstanceRecommendationsOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *ExportEC2InstanceRecommendationsOutput) SetJobId(v string) *ExportEC2InstanceRecommendationsOutput {
	s.JobId = &v
	return s
}

// SetS3Destination sets the S3Destination field's value.
func (s *ExportEC2InstanceRecommendationsOutput) SetS3Destination(v *S3Destination) *ExportEC2InstanceRecommendationsOutput {
	s.S3Destination = v
	return s
}

// Describes a filter that returns a more specific list of recommendations.
type Filter struct {
	_ struct{} `type:"structure"`

	// The name of the filter.
	//
	// Specify Finding to return recommendations with a specific findings classification
	// (e.g., Overprovisioned).
	//
	// Specify RecommendationSourceType to return recommendations of a specific
	// resource type (e.g., AutoScalingGroup).
	Name *string `locationName:"name" type:"string" enum:"FilterName"`

	// The value of the filter.
	//
	// If you specify the name parameter as Finding, and you request recommendations
	// for an instance, then the valid values are Underprovisioned, Overprovisioned,
	// NotOptimized, or Optimized.
	//
	// If you specify the name parameter as Finding, and you request recommendations
	// for an Auto Scaling group, then the valid values are Optimized, or NotOptimized.
	//
	// If you specify the name parameter as RecommendationSourceType, then the valid
	// values are Ec2Instance, or AutoScalingGroup.
	Values []*string `locationName:"values" type:"list"`
}

// String returns the string representation
func (s Filter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Filter) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *Filter) SetName(v string) *Filter {
	s.Name = &v
	return s
}

// SetValues sets the Values field's value.
func (s *Filter) SetValues(v []*string) *Filter {
	s.Values = v
	return s
}

type GetAutoScalingGroupRecommendationsInput struct {
	_ struct{} `type:"structure"`

	// The IDs of the AWS accounts for which to return Auto Scaling group recommendations.
	//
	// If your account is the master account of an organization, use this parameter
	// to specify the member accounts for which you want to return Auto Scaling
	// group recommendations.
	//
	// Only one account ID can be specified per request.
	AccountIds []*string `locationName:"accountIds" type:"list"`

	// The Amazon Resource Name (ARN) of the Auto Scaling groups for which to return
	// recommendations.
	AutoScalingGroupArns []*string `locationName:"autoScalingGroupArns" type:"list"`

	// An array of objects that describe a filter that returns a more specific list
	// of Auto Scaling group recommendations.
	Filters []*Filter `locationName:"filters" type:"list"`

	// The maximum number of Auto Scaling group recommendations to return with a
	// single request.
	//
	// To retrieve the remaining results, make another request with the returned
	// NextToken value.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The token to advance to the next page of Auto Scaling group recommendations.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetAutoScalingGroupRecommendationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAutoScalingGroupRecommendationsInput) GoString() string {
	return s.String()
}

// SetAccountIds sets the AccountIds field's value.
func (s *GetAutoScalingGroupRecommendationsInput) SetAccountIds(v []*string) *GetAutoScalingGroupRecommendationsInput {
	s.AccountIds = v
	return s
}

// SetAutoScalingGroupArns sets the AutoScalingGroupArns field's value.
func (s *GetAutoScalingGroupRecommendationsInput) SetAutoScalingGroupArns(v []*string) *GetAutoScalingGroupRecommendationsInput {
	s.AutoScalingGroupArns = v
	return s
}

// SetFilters sets the Filters field's value.
func (s *GetAutoScalingGroupRecommendationsInput) SetFilters(v []*Filter) *GetAutoScalingGroupRecommendationsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetAutoScalingGroupRecommendationsInput) SetMaxResults(v int64) *GetAutoScalingGroupRecommendationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetAutoScalingGroupRecommendationsInput) SetNextToken(v string) *GetAutoScalingGroupRecommendationsInput {
	s.NextToken = &v
	return s
}

type GetAutoScalingGroupRecommendationsOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that describe Auto Scaling group recommendations.
	AutoScalingGroupRecommendations []*AutoScalingGroupRecommendation `locationName:"autoScalingGroupRecommendations" type:"list"`

	// An array of objects that describe errors of the request.
	//
	// For example, an error is returned if you request recommendations for an unsupported
	// Auto Scaling group.
	Errors []*GetRecommendationError `locationName:"errors" type:"list"`

	// The token to use to advance to the next page of Auto Scaling group recommendations.
	//
	// This value is null when there are no more pages of Auto Scaling group recommendations
	// to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetAutoScalingGroupRecommendationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAutoScalingGroupRecommendationsOutput) GoString() string {
	return s.String()
}

// SetAutoScalingGroupRecommendations sets the AutoScalingGroupRecommendations field's value.
func (s *GetAutoScalingGroupRecommendationsOutput) SetAutoScalingGroupRecommendations(v []*AutoScalingGroupRecommendation) *GetAutoScalingGroupRecommendationsOutput {
	s.AutoScalingGroupRecommendations = v
	return s
}

// SetErrors sets the Errors field's value.
func (s *GetAutoScalingGroupRecommendationsOutput) SetErrors(v []*GetRecommendationError) *GetAutoScalingGroupRecommendationsOutput {
	s.Errors = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetAutoScalingGroupRecommendationsOutput) SetNextToken(v string) *GetAutoScalingGroupRecommendationsOutput {
	s.NextToken = &v
	return s
}

type GetEC2InstanceRecommendationsInput struct {
	_ struct{} `type:"structure"`

	// The IDs of the AWS accounts for which to return instance recommendations.
	//
	// If your account is the master account of an organization, use this parameter
	// to specify the member accounts for which you want to return instance recommendations.
	//
	// Only one account ID can be specified per request.
	AccountIds []*string `locationName:"accountIds" type:"list"`

	// An array of objects that describe a filter that returns a more specific list
	// of instance recommendations.
	Filters []*Filter `locationName:"filters" type:"list"`

	// The Amazon Resource Name (ARN) of the instances for which to return recommendations.
	InstanceArns []*string `locationName:"instanceArns" type:"list"`

	// The maximum number of instance recommendations to return with a single request.
	//
	// To retrieve the remaining results, make another request with the returned
	// NextToken value.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The token to advance to the next page of instance recommendations.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetEC2InstanceRecommendationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEC2InstanceRecommendationsInput) GoString() string {
	return s.String()
}

// SetAccountIds sets the AccountIds field's value.
func (s *GetEC2InstanceRecommendationsInput) SetAccountIds(v []*string) *GetEC2InstanceRecommendationsInput {
	s.AccountIds = v
	return s
}

// SetFilters sets the Filters field's value.
func (s *GetEC2InstanceRecommendationsInput) SetFilters(v []*Filter) *GetEC2InstanceRecommendationsInput {
	s.Filters = v
	return s
}

// SetInstanceArns sets the InstanceArns field's value.
func (s *GetEC2InstanceRecommendationsInput) SetInstanceArns(v []*string) *GetEC2InstanceRecommendationsInput {
	s.InstanceArns = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetEC2InstanceRecommendationsInput) SetMaxResults(v int64) *GetEC2InstanceRecommendationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetEC2InstanceRecommendationsInput) SetNextToken(v string) *GetEC2InstanceRecommendationsInput {
	s.NextToken = &v
	return s
}

type GetEC2InstanceRecommendationsOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that describe errors of the request.
	//
	// For example, an error is returned if you request recommendations for an instance
	// of an unsupported instance family.
	Errors []*GetRecommendationError `locationName:"errors" type:"list"`

	// An array of objects that describe instance recommendations.
	InstanceRecommendations []*InstanceRecommendation `locationName:"instanceRecommendations" type:"list"`

	// The token to use to advance to the next page of instance recommendations.
	//
	// This value is null when there are no more pages of instance recommendations
	// to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetEC2InstanceRecommendationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEC2InstanceRecommendationsOutput) GoString() string {
	return s.String()
}

// SetErrors sets the Errors field's value.
func (s *GetEC2InstanceRecommendationsOutput) SetErrors(v []*GetRecommendationError) *GetEC2InstanceRecommendationsOutput {
	s.Errors = v
	return s
}

// SetInstanceRecommendations sets the InstanceRecommendations field's value.
func (s *GetEC2InstanceRecommendationsOutput) SetInstanceRecommendations(v []*InstanceRecommendation) *GetEC2InstanceRecommendationsOutput {
	s.InstanceRecommendations = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetEC2InstanceRecommendationsOutput) SetNextToken(v string) *GetEC2InstanceRecommendationsOutput {
	s.NextToken = &v
	return s
}

type GetEC2RecommendationProjectedMetricsInput struct {
	_ struct{} `type:"structure"`

	// The time stamp of the last projected metrics data point to return.
	//
	// EndTime is a required field
	EndTime *time.Time `locationName:"endTime" type:"timestamp" required:"true"`

	// The Amazon Resource Name (ARN) of the instances for which to return recommendation
	// projected metrics.
	//
	// InstanceArn is a required field
	InstanceArn *string `locationName:"instanceArn" type:"string" required:"true"`

	// The granularity, in seconds, of the projected metrics data points.
	//
	// Period is a required field
	Period *int64 `locationName:"period" type:"integer" required:"true"`

	// The time stamp of the first projected metrics data point to return.
	//
	// StartTime is a required field
	StartTime *time.Time `locationName:"startTime" type:"timestamp" required:"true"`

	// The statistic of the projected metrics.
	//
	// Stat is a required field
	Stat *string `locationName:"stat" type:"string" required:"true" enum:"MetricStatistic"`
}

// String returns the string representation
func (s GetEC2RecommendationProjectedMetricsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEC2RecommendationProjectedMetricsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEC2RecommendationProjectedMetricsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetEC2RecommendationProjectedMetricsInput"}
	if s.EndTime == nil {
		invalidParams.Add(request.NewErrParamRequired("EndTime"))
	}
	if s.InstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceArn"))
	}
	if s.Period == nil {
		invalidParams.Add(request.NewErrParamRequired("Period"))
	}
	if s.StartTime == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTime"))
	}
	if s.Stat == nil {
		invalidParams.Add(request.NewErrParamRequired("Stat"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndTime sets the EndTime field's value.
func (s *GetEC2RecommendationProjectedMetricsInput) SetEndTime(v time.Time) *GetEC2RecommendationProjectedMetricsInput {
	s.EndTime = &v
	return s
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *GetEC2RecommendationProjectedMetricsInput) SetInstanceArn(v string) *GetEC2RecommendationProjectedMetricsInput {
	s.InstanceArn = &v
	return s
}

// SetPeriod sets the Period field's value.
func (s *GetEC2RecommendationProjectedMetricsInput) SetPeriod(v int64) *GetEC2RecommendationProjectedMetricsInput {
	s.Period = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *GetEC2RecommendationProjectedMetricsInput) SetStartTime(v time.Time) *GetEC2RecommendationProjectedMetricsInput {
	s.StartTime = &v
	return s
}

// SetStat sets the Stat field's value.
func (s *GetEC2RecommendationProjectedMetricsInput) SetStat(v string) *GetEC2RecommendationProjectedMetricsInput {
	s.Stat = &v
	return s
}

type GetEC2RecommendationProjectedMetricsOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that describe a projected metrics.
	RecommendedOptionProjectedMetrics []*RecommendedOptionProjectedMetric `locationName:"recommendedOptionProjectedMetrics" type:"list"`
}

// String returns the string representation
func (s GetEC2RecommendationProjectedMetricsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEC2RecommendationProjectedMetricsOutput) GoString() string {
	return s.String()
}

// SetRecommendedOptionProjectedMetrics sets the RecommendedOptionProjectedMetrics field's value.
func (s *GetEC2RecommendationProjectedMetricsOutput) SetRecommendedOptionProjectedMetrics(v []*RecommendedOptionProjectedMetric) *GetEC2RecommendationProjectedMetricsOutput {
	s.RecommendedOptionProjectedMetrics = v
	return s
}

type GetEnrollmentStatusInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetEnrollmentStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEnrollmentStatusInput) GoString() string {
	return s.String()
}

type GetEnrollmentStatusOutput struct {
	_ struct{} `type:"structure"`

	// Confirms the enrollment status of member accounts within the organization,
	// if the account is a master account of an organization.
	MemberAccountsEnrolled *bool `locationName:"memberAccountsEnrolled" type:"boolean"`

	// The enrollment status of the account.
	Status *string `locationName:"status" type:"string" enum:"Status"`

	// The reason for the enrollment status of the account.
	//
	// For example, an account might show a status of Pending because member accounts
	// of an organization require more time to be enrolled in the service.
	StatusReason *string `locationName:"statusReason" type:"string"`
}

// String returns the string representation
func (s GetEnrollmentStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEnrollmentStatusOutput) GoString() string {
	return s.String()
}

// SetMemberAccountsEnrolled sets the MemberAccountsEnrolled field's value.
func (s *GetEnrollmentStatusOutput) SetMemberAccountsEnrolled(v bool) *GetEnrollmentStatusOutput {
	s.MemberAccountsEnrolled = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetEnrollmentStatusOutput) SetStatus(v string) *GetEnrollmentStatusOutput {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *GetEnrollmentStatusOutput) SetStatusReason(v string) *GetEnrollmentStatusOutput {
	s.StatusReason = &v
	return s
}

// Describes an error experienced when getting recommendations.
//
// For example, an error is returned if you request recommendations for an unsupported
// Auto Scaling group, or if you request recommendations for an instance of
// an unsupported instance family.
type GetRecommendationError struct {
	_ struct{} `type:"structure"`

	// The error code.
	Code *string `locationName:"code" type:"string"`

	// The ID of the error.
	Identifier *string `locationName:"identifier" type:"string"`

	// The message, or reason, for the error.
	Message *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s GetRecommendationError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRecommendationError) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *GetRecommendationError) SetCode(v string) *GetRecommendationError {
	s.Code = &v
	return s
}

// SetIdentifier sets the Identifier field's value.
func (s *GetRecommendationError) SetIdentifier(v string) *GetRecommendationError {
	s.Identifier = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *GetRecommendationError) SetMessage(v string) *GetRecommendationError {
	s.Message = &v
	return s
}

type GetRecommendationSummariesInput struct {
	_ struct{} `type:"structure"`

	// The IDs of the AWS accounts for which to return recommendation summaries.
	//
	// If your account is the master account of an organization, use this parameter
	// to specify the member accounts for which you want to return recommendation
	// summaries.
	//
	// Only one account ID can be specified per request.
	AccountIds []*string `locationName:"accountIds" type:"list"`

	// The maximum number of recommendation summaries to return with a single request.
	//
	// To retrieve the remaining results, make another request with the returned
	// NextToken value.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The token to advance to the next page of recommendation summaries.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetRecommendationSummariesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRecommendationSummariesInput) GoString() string {
	return s.String()
}

// SetAccountIds sets the AccountIds field's value.
func (s *GetRecommendationSummariesInput) SetAccountIds(v []*string) *GetRecommendationSummariesInput {
	s.AccountIds = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetRecommendationSummariesInput) SetMaxResults(v int64) *GetRecommendationSummariesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetRecommendationSummariesInput) SetNextToken(v string) *GetRecommendationSummariesInput {
	s.NextToken = &v
	return s
}

type GetRecommendationSummariesOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to advance to the next page of recommendation summaries.
	//
	// This value is null when there are no more pages of recommendation summaries
	// to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// An array of objects that summarize a recommendation.
	RecommendationSummaries []*RecommendationSummary `locationName:"recommendationSummaries" type:"list"`
}

// String returns the string representation
func (s GetRecommendationSummariesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRecommendationSummariesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetRecommendationSummariesOutput) SetNextToken(v string) *GetRecommendationSummariesOutput {
	s.NextToken = &v
	return s
}

// SetRecommendationSummaries sets the RecommendationSummaries field's value.
func (s *GetRecommendationSummariesOutput) SetRecommendationSummaries(v []*RecommendationSummary) *GetRecommendationSummariesOutput {
	s.RecommendationSummaries = v
	return s
}

// Describes an Amazon EC2 instance recommendation.
type InstanceRecommendation struct {
	_ struct{} `type:"structure"`

	// The AWS account ID of the instance.
	AccountId *string `locationName:"accountId" type:"string"`

	// The instance type of the current instance.
	CurrentInstanceType *string `locationName:"currentInstanceType" type:"string"`

	// The finding classification for the instance.
	//
	// Findings for instances include:
	//
	//    * Underprovisioned —An instance is considered under-provisioned when
	//    at least one specification of your instance, such as CPU, memory, or network,
	//    does not meet the performance requirements of your workload. Under-provisioned
	//    instances may lead to poor application performance.
	//
	//    * Overprovisioned —An instance is considered over-provisioned when at
	//    least one specification of your instance, such as CPU, memory, or network,
	//    can be sized down while still meeting the performance requirements of
	//    your workload, and no specification is under-provisioned. Over-provisioned
	//    instances may lead to unnecessary infrastructure cost.
	//
	//    * Optimized —An instance is considered optimized when all specifications
	//    of your instance, such as CPU, memory, and network, meet the performance
	//    requirements of your workload and is not over provisioned. An optimized
	//    instance runs your workloads with optimal performance and infrastructure
	//    cost. For optimized resources, AWS Compute Optimizer might recommend a
	//    new generation instance type.
	//
	// The values that are returned might be UNDER_PROVISIONED, OVER_PROVISIONED,
	// or OPTIMIZED.
	Finding *string `locationName:"finding" type:"string" enum:"Finding"`

	// The Amazon Resource Name (ARN) of the current instance.
	InstanceArn *string `locationName:"instanceArn" type:"string"`

	// The name of the current instance.
	InstanceName *string `locationName:"instanceName" type:"string"`

	// The time stamp of when the instance recommendation was last refreshed.
	LastRefreshTimestamp *time.Time `locationName:"lastRefreshTimestamp" type:"timestamp"`

	// The number of days for which utilization metrics were analyzed for the instance.
	LookBackPeriodInDays *float64 `locationName:"lookBackPeriodInDays" type:"double"`

	// An array of objects that describe the recommendation options for the instance.
	RecommendationOptions []*InstanceRecommendationOption `locationName:"recommendationOptions" type:"list"`

	// An array of objects that describe the source resource of the recommendation.
	RecommendationSources []*RecommendationSource `locationName:"recommendationSources" type:"list"`

	// An array of objects that describe the utilization metrics of the instance.
	UtilizationMetrics []*UtilizationMetric `locationName:"utilizationMetrics" type:"list"`
}

// String returns the string representation
func (s InstanceRecommendation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceRecommendation) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *InstanceRecommendation) SetAccountId(v string) *InstanceRecommendation {
	s.AccountId = &v
	return s
}

// SetCurrentInstanceType sets the CurrentInstanceType field's value.
func (s *InstanceRecommendation) SetCurrentInstanceType(v string) *InstanceRecommendation {
	s.CurrentInstanceType = &v
	return s
}

// SetFinding sets the Finding field's value.
func (s *InstanceRecommendation) SetFinding(v string) *InstanceRecommendation {
	s.Finding = &v
	return s
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *InstanceRecommendation) SetInstanceArn(v string) *InstanceRecommendation {
	s.InstanceArn = &v
	return s
}

// SetInstanceName sets the InstanceName field's value.
func (s *InstanceRecommendation) SetInstanceName(v string) *InstanceRecommendation {
	s.InstanceName = &v
	return s
}

// SetLastRefreshTimestamp sets the LastRefreshTimestamp field's value.
func (s *InstanceRecommendation) SetLastRefreshTimestamp(v time.Time) *InstanceRecommendation {
	s.LastRefreshTimestamp = &v
	return s
}

// SetLookBackPeriodInDays sets the LookBackPeriodInDays field's value.
func (s *InstanceRecommendation) SetLookBackPeriodInDays(v float64) *InstanceRecommendation {
	s.LookBackPeriodInDays = &v
	return s
}

// SetRecommendationOptions sets the RecommendationOptions field's value.
func (s *InstanceRecommendation) SetRecommendationOptions(v []*InstanceRecommendationOption) *InstanceRecommendation {
	s.RecommendationOptions = v
	return s
}

// SetRecommendationSources sets the RecommendationSources field's value.
func (s *InstanceRecommendation) SetRecommendationSources(v []*RecommendationSource) *InstanceRecommendation {
	s.RecommendationSources = v
	return s
}

// SetUtilizationMetrics sets the UtilizationMetrics field's value.
func (s *InstanceRecommendation) SetUtilizationMetrics(v []*UtilizationMetric) *InstanceRecommendation {
	s.UtilizationMetrics = v
	return s
}

// Describes a recommendation option for an Amazon EC2 instance.
type InstanceRecommendationOption struct {
	_ struct{} `type:"structure"`

	// The instance type of the instance recommendation.
	InstanceType *string `locationName:"instanceType" type:"string"`

	// The performance risk of the instance recommendation option.
	//
	// Performance risk is the likelihood of the recommended instance type not meeting
	// the performance requirement of your workload.
	//
	// The lowest performance risk is categorized as 0, and the highest as 5.
	PerformanceRisk *float64 `locationName:"performanceRisk" type:"double"`

	// An array of objects that describe the projected utilization metrics of the
	// instance recommendation option.
	ProjectedUtilizationMetrics []*UtilizationMetric `locationName:"projectedUtilizationMetrics" type:"list"`

	// The rank of the instance recommendation option.
	//
	// The top recommendation option is ranked as 1.
	Rank *int64 `locationName:"rank" type:"integer"`
}

// String returns the string representation
func (s InstanceRecommendationOption) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceRecommendationOption) GoString() string {
	return s.String()
}

// SetInstanceType sets the InstanceType field's value.
func (s *InstanceRecommendationOption) SetInstanceType(v string) *InstanceRecommendationOption {
	s.InstanceType = &v
	return s
}

// SetPerformanceRisk sets the PerformanceRisk field's value.
func (s *InstanceRecommendationOption) SetPerformanceRisk(v float64) *InstanceRecommendationOption {
	s.PerformanceRisk = &v
	return s
}

// SetProjectedUtilizationMetrics sets the ProjectedUtilizationMetrics field's value.
func (s *InstanceRecommendationOption) SetProjectedUtilizationMetrics(v []*UtilizationMetric) *InstanceRecommendationOption {
	s.ProjectedUtilizationMetrics = v
	return s
}

// SetRank sets the Rank field's value.
func (s *InstanceRecommendationOption) SetRank(v int64) *InstanceRecommendationOption {
	s.Rank = &v
	return s
}

// An internal error has occurred. Try your call again.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An invalid or out-of-range value was supplied for the input parameter.
type InvalidParameterValueException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InvalidParameterValueException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidParameterValueException) GoString() string {
	return s.String()
}

func newErrorInvalidParameterValueException(v protocol.ResponseMetadata) error {
	return &InvalidParameterValueException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidParameterValueException) Code() string {
	return "InvalidParameterValueException"
}

// Message returns the exception's message.
func (s *InvalidParameterValueException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidParameterValueException) OrigErr() error {
	return nil
}

func (s *InvalidParameterValueException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidParameterValueException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidParameterValueException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Describes a filter that returns a more specific list of recommendation export
// jobs.
//
// This filter is used with the DescribeRecommendationExportJobs action.
type JobFilter struct {
	_ struct{} `type:"structure"`

	// The name of the filter.
	//
	// Specify ResourceType to return export jobs of a specific resource type (e.g.,
	// Ec2Instance).
	//
	// Specify JobStatus to return export jobs with a specific status (e.g, Complete).
	Name *string `locationName:"name" type:"string" enum:"JobFilterName"`

	// The value of the filter.
	//
	// If you specify the name parameter as ResourceType, the valid values are Ec2Instance
	// or AutoScalingGroup.
	//
	// If you specify the name parameter as JobStatus, the valid values are Queued,
	// InProgress, Complete, or Failed.
	Values []*string `locationName:"values" type:"list"`
}

// String returns the string representation
func (s JobFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JobFilter) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *JobFilter) SetName(v string) *JobFilter {
	s.Name = &v
	return s
}

// SetValues sets the Values field's value.
func (s *JobFilter) SetValues(v []*string) *JobFilter {
	s.Values = v
	return s
}

// The request exceeds a limit of the service.
type LimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s LimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LimitExceededException) GoString() string {
	return s.String()
}

func newErrorLimitExceededException(v protocol.ResponseMetadata) error {
	return &LimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LimitExceededException) Code() string {
	return "LimitExceededException"
}

// Message returns the exception's message.
func (s *LimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LimitExceededException) OrigErr() error {
	return nil
}

func (s *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request must contain either a valid (registered) AWS access key ID or
// X.509 certificate.
type MissingAuthenticationToken struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s MissingAuthenticationToken) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MissingAuthenticationToken) GoString() string {
	return s.String()
}

func newErrorMissingAuthenticationToken(v protocol.ResponseMetadata) error {
	return &MissingAuthenticationToken{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *MissingAuthenticationToken) Code() string {
	return "MissingAuthenticationToken"
}

// Message returns the exception's message.
func (s *MissingAuthenticationToken) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *MissingAuthenticationToken) OrigErr() error {
	return nil
}

func (s *MissingAuthenticationToken) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *MissingAuthenticationToken) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *MissingAuthenticationToken) RequestID() string {
	return s.RespMetadata.RequestID
}

// The account is not opted in to AWS Compute Optimizer.
type OptInRequiredException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s OptInRequiredException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OptInRequiredException) GoString() string {
	return s.String()
}

func newErrorOptInRequiredException(v protocol.ResponseMetadata) error {
	return &OptInRequiredException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *OptInRequiredException) Code() string {
	return "OptInRequiredException"
}

// Message returns the exception's message.
func (s *OptInRequiredException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *OptInRequiredException) OrigErr() error {
	return nil
}

func (s *OptInRequiredException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *OptInRequiredException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *OptInRequiredException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Describes a projected utilization metric of a recommendation option, such
// as an Amazon EC2 instance.
type ProjectedMetric struct {
	_ struct{} `type:"structure"`

	// The name of the projected utilization metric.
	//
	// Memory metrics are only returned for resources that have the unified CloudWatch
	// agent installed on them. For more information, see Enabling Memory Utilization
	// with the CloudWatch Agent (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Install-CloudWatch-Agent.html).
	Name *string `locationName:"name" type:"string" enum:"MetricName"`

	// The time stamps of the projected utilization metric.
	Timestamps []*time.Time `locationName:"timestamps" type:"list"`

	// The values of the projected utilization metrics.
	Values []*float64 `locationName:"values" type:"list"`
}

// String returns the string representation
func (s ProjectedMetric) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProjectedMetric) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *ProjectedMetric) SetName(v string) *ProjectedMetric {
	s.Name = &v
	return s
}

// SetTimestamps sets the Timestamps field's value.
func (s *ProjectedMetric) SetTimestamps(v []*time.Time) *ProjectedMetric {
	s.Timestamps = v
	return s
}

// SetValues sets the Values field's value.
func (s *ProjectedMetric) SetValues(v []*float64) *ProjectedMetric {
	s.Values = v
	return s
}

// Describes a recommendation export job.
//
// Use the DescribeRecommendationExportJobs action to view your recommendation
// export jobs.
//
// Use the ExportAutoScalingGroupRecommendations or ExportEC2InstanceRecommendations
// actions to request an export of your recommendations.
type RecommendationExportJob struct {
	_ struct{} `type:"structure"`

	// The timestamp of when the export job was created.
	CreationTimestamp *time.Time `locationName:"creationTimestamp" type:"timestamp"`

	// An object that describes the destination of the export file.
	Destination *ExportDestination `locationName:"destination" type:"structure"`

	// The reason for an export job failure.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// The identification number of the export job.
	JobId *string `locationName:"jobId" type:"string"`

	// The timestamp of when the export job was last updated.
	LastUpdatedTimestamp *time.Time `locationName:"lastUpdatedTimestamp" type:"timestamp"`

	// The resource type of the exported recommendations.
	ResourceType *string `locationName:"resourceType" type:"string" enum:"ResourceType"`

	// The status of the export job.
	Status *string `locationName:"status" type:"string" enum:"JobStatus"`
}

// String returns the string representation
func (s RecommendationExportJob) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RecommendationExportJob) GoString() string {
	return s.String()
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *RecommendationExportJob) SetCreationTimestamp(v time.Time) *RecommendationExportJob {
	s.CreationTimestamp = &v
	return s
}

// SetDestination sets the Destination field's value.
func (s *RecommendationExportJob) SetDestination(v *ExportDestination) *RecommendationExportJob {
	s.Destination = v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *RecommendationExportJob) SetFailureReason(v string) *RecommendationExportJob {
	s.FailureReason = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *RecommendationExportJob) SetJobId(v string) *RecommendationExportJob {
	s.JobId = &v
	return s
}

// SetLastUpdatedTimestamp sets the LastUpdatedTimestamp field's value.
func (s *RecommendationExportJob) SetLastUpdatedTimestamp(v time.Time) *RecommendationExportJob {
	s.LastUpdatedTimestamp = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *RecommendationExportJob) SetResourceType(v string) *RecommendationExportJob {
	s.ResourceType = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *RecommendationExportJob) SetStatus(v string) *RecommendationExportJob {
	s.Status = &v
	return s
}

// Describes the source of a recommendation, such as an Amazon EC2 instance
// or Auto Scaling group.
type RecommendationSource struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the recommendation source.
	RecommendationSourceArn *string `locationName:"recommendationSourceArn" type:"string"`

	// The resource type of the recommendation source.
	RecommendationSourceType *string `locationName:"recommendationSourceType" type:"string" enum:"RecommendationSourceType"`
}

// String returns the string representation
func (s RecommendationSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RecommendationSource) GoString() string {
	return s.String()
}

// SetRecommendationSourceArn sets the RecommendationSourceArn field's value.
func (s *RecommendationSource) SetRecommendationSourceArn(v string) *RecommendationSource {
	s.RecommendationSourceArn = &v
	return s
}

// SetRecommendationSourceType sets the RecommendationSourceType field's value.
func (s *RecommendationSource) SetRecommendationSourceType(v string) *RecommendationSource {
	s.RecommendationSourceType = &v
	return s
}

// A summary of a recommendation.
type RecommendationSummary struct {
	_ struct{} `type:"structure"`

	// The AWS account ID of the recommendation summary.
	AccountId *string `locationName:"accountId" type:"string"`

	// The resource type of the recommendation.
	RecommendationResourceType *string `locationName:"recommendationResourceType" type:"string" enum:"RecommendationSourceType"`

	// An array of objects that describe a recommendation summary.
	Summaries []*Summary `locationName:"summaries" type:"list"`
}

// String returns the string representation
func (s RecommendationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RecommendationSummary) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *RecommendationSummary) SetAccountId(v string) *RecommendationSummary {
	s.AccountId = &v
	return s
}

// SetRecommendationResourceType sets the RecommendationResourceType field's value.
func (s *RecommendationSummary) SetRecommendationResourceType(v string) *RecommendationSummary {
	s.RecommendationResourceType = &v
	return s
}

// SetSummaries sets the Summaries field's value.
func (s *RecommendationSummary) SetSummaries(v []*Summary) *RecommendationSummary {
	s.Summaries = v
	return s
}

// Describes a projected utilization metric of a recommendation option.
type RecommendedOptionProjectedMetric struct {
	_ struct{} `type:"structure"`

	// An array of objects that describe a projected utilization metric.
	ProjectedMetrics []*ProjectedMetric `locationName:"projectedMetrics" type:"list"`

	// The rank of the recommendation option projected metric.
	//
	// The top recommendation option is ranked as 1.
	//
	// The projected metric rank correlates to the recommendation option rank. For
	// example, the projected metric ranked as 1 is related to the recommendation
	// option that is also ranked as 1 in the same response.
	Rank *int64 `locationName:"rank" type:"integer"`

	// The recommended instance type.
	RecommendedInstanceType *string `locationName:"recommendedInstanceType" type:"string"`
}

// String returns the string representation
func (s RecommendedOptionProjectedMetric) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RecommendedOptionProjectedMetric) GoString() string {
	return s.String()
}

// SetProjectedMetrics sets the ProjectedMetrics field's value.
func (s *RecommendedOptionProjectedMetric) SetProjectedMetrics(v []*ProjectedMetric) *RecommendedOptionProjectedMetric {
	s.ProjectedMetrics = v
	return s
}

// SetRank sets the Rank field's value.
func (s *RecommendedOptionProjectedMetric) SetRank(v int64) *RecommendedOptionProjectedMetric {
	s.Rank = &v
	return s
}

// SetRecommendedInstanceType sets the RecommendedInstanceType field's value.
func (s *RecommendedOptionProjectedMetric) SetRecommendedInstanceType(v string) *RecommendedOptionProjectedMetric {
	s.RecommendedInstanceType = &v
	return s
}

// A resource that is required for the action doesn't exist.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Describes the destination Amazon Simple Storage Service (Amazon S3) bucket
// name and object keys of a recommendations export file, and its associated
// metadata file.
type S3Destination struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon S3 bucket used as the destination of an export file.
	Bucket *string `locationName:"bucket" type:"string"`

	// The Amazon S3 bucket key of an export file.
	//
	// The key uniquely identifies the object, or export file, in the S3 bucket.
	Key *string `locationName:"key" type:"string"`

	// The Amazon S3 bucket key of a metadata file.
	//
	// The key uniquely identifies the object, or metadata file, in the S3 bucket.
	MetadataKey *string `locationName:"metadataKey" type:"string"`
}

// String returns the string representation
func (s S3Destination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3Destination) GoString() string {
	return s.String()
}

// SetBucket sets the Bucket field's value.
func (s *S3Destination) SetBucket(v string) *S3Destination {
	s.Bucket = &v
	return s
}

// SetKey sets the Key field's value.
func (s *S3Destination) SetKey(v string) *S3Destination {
	s.Key = &v
	return s
}

// SetMetadataKey sets the MetadataKey field's value.
func (s *S3Destination) SetMetadataKey(v string) *S3Destination {
	s.MetadataKey = &v
	return s
}

// Describes the destination Amazon Simple Storage Service (Amazon S3) bucket
// name and key prefix for a recommendations export job.
//
// You must create the destination Amazon S3 bucket for your recommendations
// export before you create the export job. Compute Optimizer does not create
// the S3 bucket for you. After you create the S3 bucket, ensure that it has
// the required permission policy to allow Compute Optimizer to write the export
// file to it. If you plan to specify an object prefix when you create the export
// job, you must include the object prefix in the policy that you add to the
// S3 bucket. For more information, see Amazon S3 Bucket Policy for Compute
// Optimizer (https://docs.aws.amazon.com/compute-optimizer/latest/ug/create-s3-bucket-policy-for-compute-optimizer.html)
// in the Compute Optimizer user guide.
type S3DestinationConfig struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon S3 bucket to use as the destination for an export
	// job.
	Bucket *string `locationName:"bucket" type:"string"`

	// The Amazon S3 bucket prefix for an export job.
	KeyPrefix *string `locationName:"keyPrefix" type:"string"`
}

// String returns the string representation
func (s S3DestinationConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3DestinationConfig) GoString() string {
	return s.String()
}

// SetBucket sets the Bucket field's value.
func (s *S3DestinationConfig) SetBucket(v string) *S3DestinationConfig {
	s.Bucket = &v
	return s
}

// SetKeyPrefix sets the KeyPrefix field's value.
func (s *S3DestinationConfig) SetKeyPrefix(v string) *S3DestinationConfig {
	s.KeyPrefix = &v
	return s
}

// The request has failed due to a temporary failure of the server.
type ServiceUnavailableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ServiceUnavailableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceUnavailableException) GoString() string {
	return s.String()
}

func newErrorServiceUnavailableException(v protocol.ResponseMetadata) error {
	return &ServiceUnavailableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceUnavailableException) Code() string {
	return "ServiceUnavailableException"
}

// Message returns the exception's message.
func (s *ServiceUnavailableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceUnavailableException) OrigErr() error {
	return nil
}

func (s *ServiceUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceUnavailableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceUnavailableException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The summary of a recommendation.
type Summary struct {
	_ struct{} `type:"structure"`

	// The finding classification of the recommendation.
	Name *string `locationName:"name" type:"string" enum:"Finding"`

	// The value of the recommendation summary.
	Value *float64 `locationName:"value" type:"double"`
}

// String returns the string representation
func (s Summary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Summary) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *Summary) SetName(v string) *Summary {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Summary) SetValue(v float64) *Summary {
	s.Value = &v
	return s
}

// The request was denied due to request throttling.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UpdateEnrollmentStatusInput struct {
	_ struct{} `type:"structure"`

	// Indicates whether to enroll member accounts of the organization if the your
	// account is the master account of an organization.
	IncludeMemberAccounts *bool `locationName:"includeMemberAccounts" type:"boolean"`

	// The new enrollment status of the account.
	//
	// Accepted options are Active or Inactive. You will get an error if Pending
	// or Failed are specified.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"Status"`
}

// String returns the string representation
func (s UpdateEnrollmentStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateEnrollmentStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateEnrollmentStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateEnrollmentStatusInput"}
	if s.Status == nil {
		invalidParams.Add(request.NewErrParamRequired("Status"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIncludeMemberAccounts sets the IncludeMemberAccounts field's value.
func (s *UpdateEnrollmentStatusInput) SetIncludeMemberAccounts(v bool) *UpdateEnrollmentStatusInput {
	s.IncludeMemberAccounts = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateEnrollmentStatusInput) SetStatus(v string) *UpdateEnrollmentStatusInput {
	s.Status = &v
	return s
}

type UpdateEnrollmentStatusOutput struct {
	_ struct{} `type:"structure"`

	// The enrollment status of the account.
	Status *string `locationName:"status" type:"string" enum:"Status"`

	// The reason for the enrollment status of the account. For example, an account
	// might show a status of Pending because member accounts of an organization
	// require more time to be enrolled in the service.
	StatusReason *string `locationName:"statusReason" type:"string"`
}

// String returns the string representation
func (s UpdateEnrollmentStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateEnrollmentStatusOutput) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *UpdateEnrollmentStatusOutput) SetStatus(v string) *UpdateEnrollmentStatusOutput {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *UpdateEnrollmentStatusOutput) SetStatusReason(v string) *UpdateEnrollmentStatusOutput {
	s.StatusReason = &v
	return s
}

// Describes a utilization metric of a resource, such as an Amazon EC2 instance.
type UtilizationMetric struct {
	_ struct{} `type:"structure"`

	// The name of the utilization metric.
	//
	// Memory metrics are only returned for resources that have the unified CloudWatch
	// agent installed on them. For more information, see Enabling Memory Utilization
	// with the CloudWatch Agent (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Install-CloudWatch-Agent.html).
	Name *string `locationName:"name" type:"string" enum:"MetricName"`

	// The statistic of the utilization metric.
	Statistic *string `locationName:"statistic" type:"string" enum:"MetricStatistic"`

	// The value of the utilization metric.
	Value *float64 `locationName:"value" type:"double"`
}

// String returns the string representation
func (s UtilizationMetric) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UtilizationMetric) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *UtilizationMetric) SetName(v string) *UtilizationMetric {
	s.Name = &v
	return s
}

// SetStatistic sets the Statistic field's value.
func (s *UtilizationMetric) SetStatistic(v string) *UtilizationMetric {
	s.Statistic = &v
	return s
}

// SetValue sets the Value field's value.
func (s *UtilizationMetric) SetValue(v float64) *UtilizationMetric {
	s.Value = &v
	return s
}

const (
	// ExportableAutoScalingGroupFieldAccountId is a ExportableAutoScalingGroupField enum value
	ExportableAutoScalingGroupFieldAccountId = "AccountId"

	// ExportableAutoScalingGroupFieldAutoScalingGroupArn is a ExportableAutoScalingGroupField enum value
	ExportableAutoScalingGroupFieldAutoScalingGroupArn = "AutoScalingGroupArn"

	// ExportableAutoScalingGroupFieldAutoScalingGroupName is a ExportableAutoScalingGroupField enum value
	ExportableAutoScalingGroupFieldAutoScalingGroupName = "AutoScalingGroupName"

	// ExportableAutoScalingGroupFieldFinding is a ExportableAutoScalingGroupField enum value
	ExportableAutoScalingGroupFieldFinding = "Finding"

	// ExportableAutoScalingGroupFieldUtilizationMetricsCpuMaximum is a ExportableAutoScalingGroupField enum value
	ExportableAutoScalingGroupFieldUtilizationMetricsCpuMaximum = "UtilizationMetricsCpuMaximum"

	// ExportableAutoScalingGroupFieldUtilizationMetricsMemoryMaximum is a ExportableAutoScalingGroupField enum value
	ExportableAutoScalingGroupFieldUtilizationMetricsMemoryMaximum = "UtilizationMetricsMemoryMaximum"

	// ExportableAutoScalingGroupFieldLookbackPeriodInDays is a ExportableAutoScalingGroupField enum value
	ExportableAutoScalingGroupFieldLookbackPeriodInDays = "LookbackPeriodInDays"

	// ExportableAutoScalingGroupFieldCurrentConfigurationInstanceType is a ExportableAutoScalingGroupField enum value
	ExportableAutoScalingGroupFieldCurrentConfigurationInstanceType = "CurrentConfigurationInstanceType"

	// ExportableAutoScalingGroupFieldCurrentConfigurationDesiredCapacity is a ExportableAutoScalingGroupField enum value
	ExportableAutoScalingGroupFieldCurrentConfigurationDesiredCapacity = "CurrentConfigurationDesiredCapacity"

	// ExportableAutoScalingGroupFieldCurrentConfigurationMinSize is a ExportableAutoScalingGroupField enum value
	ExportableAutoScalingGroupFieldCurrentConfigurationMinSize = "CurrentConfigurationMinSize"

	// ExportableAutoScalingGroupFieldCurrentConfigurationMaxSize is a ExportableAutoScalingGroupField enum value
	ExportableAutoScalingGroupFieldCurrentConfigurationMaxSize = "CurrentConfigurationMaxSize"

	// ExportableAutoScalingGroupFieldCurrentOnDemandPrice is a ExportableAutoScalingGroupField enum value
	ExportableAutoScalingGroupFieldCurrentOnDemandPrice = "CurrentOnDemandPrice"

	// ExportableAutoScalingGroupFieldCurrentStandardOneYearNoUpfrontReservedPrice is a ExportableAutoScalingGroupField enum value
	ExportableAutoScalingGroupFieldCurrentStandardOneYearNoUpfrontReservedPrice = "CurrentStandardOneYearNoUpfrontReservedPrice"

	// ExportableAutoScalingGroupFieldCurrentStandardThreeYearNoUpfrontReservedPrice is a ExportableAutoScalingGroupField enum value
	ExportableAutoScalingGroupFieldCurrentStandardThreeYearNoUpfrontReservedPrice = "CurrentStandardThreeYearNoUpfrontReservedPrice"

	// ExportableAutoScalingGroupFieldCurrentVcpus is a ExportableAutoScalingGroupField enum value
	ExportableAutoScalingGroupFieldCurrentVcpus = "CurrentVCpus"

	// ExportableAutoScalingGroupFieldCurrentMemory is a ExportableAutoScalingGroupField enum value
	ExportableAutoScalingGroupFieldCurrentMemory = "CurrentMemory"

	// ExportableAutoScalingGroupFieldCurrentStorage is a ExportableAutoScalingGroupField enum value
	ExportableAutoScalingGroupFieldCurrentStorage = "CurrentStorage"

	// ExportableAutoScalingGroupFieldCurrentNetwork is a ExportableAutoScalingGroupField enum value
	ExportableAutoScalingGroupFieldCurrentNetwork = "CurrentNetwork"

	// ExportableAutoScalingGroupFieldRecommendationOptionsConfigurationInstanceType is a ExportableAutoScalingGroupField enum value
	ExportableAutoScalingGroupFieldRecommendationOptionsConfigurationInstanceType = "RecommendationOptionsConfigurationInstanceType"

	// ExportableAutoScalingGroupFieldRecommendationOptionsConfigurationDesiredCapacity is a ExportableAutoScalingGroupField enum value
	ExportableAutoScalingGroupFieldRecommendationOptionsConfigurationDesiredCapacity = "RecommendationOptionsConfigurationDesiredCapacity"

	// ExportableAutoScalingGroupFieldRecommendationOptionsConfigurationMinSize is a ExportableAutoScalingGroupField enum value
	ExportableAutoScalingGroupFieldRecommendationOptionsConfigurationMinSize = "RecommendationOptionsConfigurationMinSize"

	// ExportableAutoScalingGroupFieldRecommendationOptionsConfigurationMaxSize is a ExportableAutoScalingGroupField enum value
	ExportableAutoScalingGroupFieldRecommendationOptionsConfigurationMaxSize = "RecommendationOptionsConfigurationMaxSize"

	// ExportableAutoScalingGroupFieldRecommendationOptionsProjectedUtilizationMetricsCpuMaximum is a ExportableAutoScalingGroupField enum value
	ExportableAutoScalingGroupFieldRecommendationOptionsProjectedUtilizationMetricsCpuMaximum = "RecommendationOptionsProjectedUtilizationMetricsCpuMaximum"

	// ExportableAutoScalingGroupFieldRecommendationOptionsProjectedUtilizationMetricsMemoryMaximum is a ExportableAutoScalingGroupField enum value
	ExportableAutoScalingGroupFieldRecommendationOptionsProjectedUtilizationMetricsMemoryMaximum = "RecommendationOptionsProjectedUtilizationMetricsMemoryMaximum"

	// ExportableAutoScalingGroupFieldRecommendationOptionsPerformanceRisk is a ExportableAutoScalingGroupField enum value
	ExportableAutoScalingGroupFieldRecommendationOptionsPerformanceRisk = "RecommendationOptionsPerformanceRisk"

	// ExportableAutoScalingGroupFieldRecommendationOptionsOnDemandPrice is a ExportableAutoScalingGroupField enum value
	ExportableAutoScalingGroupFieldRecommendationOptionsOnDemandPrice = "RecommendationOptionsOnDemandPrice"

	// ExportableAutoScalingGroupFieldRecommendationOptionsStandardOneYearNoUpfrontReservedPrice is a ExportableAutoScalingGroupField enum value
	ExportableAutoScalingGroupFieldRecommendationOptionsStandardOneYearNoUpfrontReservedPrice = "RecommendationOptionsStandardOneYearNoUpfrontReservedPrice"

	// ExportableAutoScalingGroupFieldRecommendationOptionsStandardThreeYearNoUpfrontReservedPrice is a ExportableAutoScalingGroupField enum value
	ExportableAutoScalingGroupFieldRecommendationOptionsStandardThreeYearNoUpfrontReservedPrice = "RecommendationOptionsStandardThreeYearNoUpfrontReservedPrice"

	// ExportableAutoScalingGroupFieldRecommendationOptionsVcpus is a ExportableAutoScalingGroupField enum value
	ExportableAutoScalingGroupFieldRecommendationOptionsVcpus = "RecommendationOptionsVcpus"

	// ExportableAutoScalingGroupFieldRecommendationOptionsMemory is a ExportableAutoScalingGroupField enum value
	ExportableAutoScalingGroupFieldRecommendationOptionsMemory = "RecommendationOptionsMemory"

	// ExportableAutoScalingGroupFieldRecommendationOptionsStorage is a ExportableAutoScalingGroupField enum value
	ExportableAutoScalingGroupFieldRecommendationOptionsStorage = "RecommendationOptionsStorage"

	// ExportableAutoScalingGroupFieldRecommendationOptionsNetwork is a ExportableAutoScalingGroupField enum value
	ExportableAutoScalingGroupFieldRecommendationOptionsNetwork = "RecommendationOptionsNetwork"

	// ExportableAutoScalingGroupFieldLastRefreshTimestamp is a ExportableAutoScalingGroupField enum value
	ExportableAutoScalingGroupFieldLastRefreshTimestamp = "LastRefreshTimestamp"
)

// ExportableAutoScalingGroupField_Values returns all elements of the ExportableAutoScalingGroupField enum
func ExportableAutoScalingGroupField_Values() []string {
	return []string{
		ExportableAutoScalingGroupFieldAccountId,
		ExportableAutoScalingGroupFieldAutoScalingGroupArn,
		ExportableAutoScalingGroupFieldAutoScalingGroupName,
		ExportableAutoScalingGroupFieldFinding,
		ExportableAutoScalingGroupFieldUtilizationMetricsCpuMaximum,
		ExportableAutoScalingGroupFieldUtilizationMetricsMemoryMaximum,
		ExportableAutoScalingGroupFieldLookbackPeriodInDays,
		ExportableAutoScalingGroupFieldCurrentConfigurationInstanceType,
		ExportableAutoScalingGroupFieldCurrentConfigurationDesiredCapacity,
		ExportableAutoScalingGroupFieldCurrentConfigurationMinSize,
		ExportableAutoScalingGroupFieldCurrentConfigurationMaxSize,
		ExportableAutoScalingGroupFieldCurrentOnDemandPrice,
		ExportableAutoScalingGroupFieldCurrentStandardOneYearNoUpfrontReservedPrice,
		ExportableAutoScalingGroupFieldCurrentStandardThreeYearNoUpfrontReservedPrice,
		ExportableAutoScalingGroupFieldCurrentVcpus,
		ExportableAutoScalingGroupFieldCurrentMemory,
		ExportableAutoScalingGroupFieldCurrentStorage,
		ExportableAutoScalingGroupFieldCurrentNetwork,
		ExportableAutoScalingGroupFieldRecommendationOptionsConfigurationInstanceType,
		ExportableAutoScalingGroupFieldRecommendationOptionsConfigurationDesiredCapacity,
		ExportableAutoScalingGroupFieldRecommendationOptionsConfigurationMinSize,
		ExportableAutoScalingGroupFieldRecommendationOptionsConfigurationMaxSize,
		ExportableAutoScalingGroupFieldRecommendationOptionsProjectedUtilizationMetricsCpuMaximum,
		ExportableAutoScalingGroupFieldRecommendationOptionsProjectedUtilizationMetricsMemoryMaximum,
		ExportableAutoScalingGroupFieldRecommendationOptionsPerformanceRisk,
		ExportableAutoScalingGroupFieldRecommendationOptionsOnDemandPrice,
		ExportableAutoScalingGroupFieldRecommendationOptionsStandardOneYearNoUpfrontReservedPrice,
		ExportableAutoScalingGroupFieldRecommendationOptionsStandardThreeYearNoUpfrontReservedPrice,
		ExportableAutoScalingGroupFieldRecommendationOptionsVcpus,
		ExportableAutoScalingGroupFieldRecommendationOptionsMemory,
		ExportableAutoScalingGroupFieldRecommendationOptionsStorage,
		ExportableAutoScalingGroupFieldRecommendationOptionsNetwork,
		ExportableAutoScalingGroupFieldLastRefreshTimestamp,
	}
}

const (
	// ExportableInstanceFieldAccountId is a ExportableInstanceField enum value
	ExportableInstanceFieldAccountId = "AccountId"

	// ExportableInstanceFieldInstanceArn is a ExportableInstanceField enum value
	ExportableInstanceFieldInstanceArn = "InstanceArn"

	// ExportableInstanceFieldInstanceName is a ExportableInstanceField enum value
	ExportableInstanceFieldInstanceName = "InstanceName"

	// ExportableInstanceFieldFinding is a ExportableInstanceField enum value
	ExportableInstanceFieldFinding = "Finding"

	// ExportableInstanceFieldLookbackPeriodInDays is a ExportableInstanceField enum value
	ExportableInstanceFieldLookbackPeriodInDays = "LookbackPeriodInDays"

	// ExportableInstanceFieldCurrentInstanceType is a ExportableInstanceField enum value
	ExportableInstanceFieldCurrentInstanceType = "CurrentInstanceType"

	// ExportableInstanceFieldUtilizationMetricsCpuMaximum is a ExportableInstanceField enum value
	ExportableInstanceFieldUtilizationMetricsCpuMaximum = "UtilizationMetricsCpuMaximum"

	// ExportableInstanceFieldUtilizationMetricsMemoryMaximum is a ExportableInstanceField enum value
	ExportableInstanceFieldUtilizationMetricsMemoryMaximum = "UtilizationMetricsMemoryMaximum"

	// ExportableInstanceFieldCurrentOnDemandPrice is a ExportableInstanceField enum value
	ExportableInstanceFieldCurrentOnDemandPrice = "CurrentOnDemandPrice"

	// ExportableInstanceFieldCurrentStandardOneYearNoUpfrontReservedPrice is a ExportableInstanceField enum value
	ExportableInstanceFieldCurrentStandardOneYearNoUpfrontReservedPrice = "CurrentStandardOneYearNoUpfrontReservedPrice"

	// ExportableInstanceFieldCurrentStandardThreeYearNoUpfrontReservedPrice is a ExportableInstanceField enum value
	ExportableInstanceFieldCurrentStandardThreeYearNoUpfrontReservedPrice = "CurrentStandardThreeYearNoUpfrontReservedPrice"

	// ExportableInstanceFieldCurrentVcpus is a ExportableInstanceField enum value
	ExportableInstanceFieldCurrentVcpus = "CurrentVCpus"

	// ExportableInstanceFieldCurrentMemory is a ExportableInstanceField enum value
	ExportableInstanceFieldCurrentMemory = "CurrentMemory"

	// ExportableInstanceFieldCurrentStorage is a ExportableInstanceField enum value
	ExportableInstanceFieldCurrentStorage = "CurrentStorage"

	// ExportableInstanceFieldCurrentNetwork is a ExportableInstanceField enum value
	ExportableInstanceFieldCurrentNetwork = "CurrentNetwork"

	// ExportableInstanceFieldRecommendationOptionsInstanceType is a ExportableInstanceField enum value
	ExportableInstanceFieldRecommendationOptionsInstanceType = "RecommendationOptionsInstanceType"

	// ExportableInstanceFieldRecommendationOptionsProjectedUtilizationMetricsCpuMaximum is a ExportableInstanceField enum value
	ExportableInstanceFieldRecommendationOptionsProjectedUtilizationMetricsCpuMaximum = "RecommendationOptionsProjectedUtilizationMetricsCpuMaximum"

	// ExportableInstanceFieldRecommendationOptionsProjectedUtilizationMetricsMemoryMaximum is a ExportableInstanceField enum value
	ExportableInstanceFieldRecommendationOptionsProjectedUtilizationMetricsMemoryMaximum = "RecommendationOptionsProjectedUtilizationMetricsMemoryMaximum"

	// ExportableInstanceFieldRecommendationOptionsPerformanceRisk is a ExportableInstanceField enum value
	ExportableInstanceFieldRecommendationOptionsPerformanceRisk = "RecommendationOptionsPerformanceRisk"

	// ExportableInstanceFieldRecommendationOptionsVcpus is a ExportableInstanceField enum value
	ExportableInstanceFieldRecommendationOptionsVcpus = "RecommendationOptionsVcpus"

	// ExportableInstanceFieldRecommendationOptionsMemory is a ExportableInstanceField enum value
	ExportableInstanceFieldRecommendationOptionsMemory = "RecommendationOptionsMemory"

	// ExportableInstanceFieldRecommendationOptionsStorage is a ExportableInstanceField enum value
	ExportableInstanceFieldRecommendationOptionsStorage = "RecommendationOptionsStorage"

	// ExportableInstanceFieldRecommendationOptionsNetwork is a ExportableInstanceField enum value
	ExportableInstanceFieldRecommendationOptionsNetwork = "RecommendationOptionsNetwork"

	// ExportableInstanceFieldRecommendationOptionsOnDemandPrice is a ExportableInstanceField enum value
	ExportableInstanceFieldRecommendationOptionsOnDemandPrice = "RecommendationOptionsOnDemandPrice"

	// ExportableInstanceFieldRecommendationOptionsStandardOneYearNoUpfrontReservedPrice is a ExportableInstanceField enum value
	ExportableInstanceFieldRecommendationOptionsStandardOneYearNoUpfrontReservedPrice = "RecommendationOptionsStandardOneYearNoUpfrontReservedPrice"

	// ExportableInstanceFieldRecommendationOptionsStandardThreeYearNoUpfrontReservedPrice is a ExportableInstanceField enum value
	ExportableInstanceFieldRecommendationOptionsStandardThreeYearNoUpfrontReservedPrice = "RecommendationOptionsStandardThreeYearNoUpfrontReservedPrice"

	// ExportableInstanceFieldRecommendationsSourcesRecommendationSourceArn is a ExportableInstanceField enum value
	ExportableInstanceFieldRecommendationsSourcesRecommendationSourceArn = "RecommendationsSourcesRecommendationSourceArn"

	// ExportableInstanceFieldRecommendationsSourcesRecommendationSourceType is a ExportableInstanceField enum value
	ExportableInstanceFieldRecommendationsSourcesRecommendationSourceType = "RecommendationsSourcesRecommendationSourceType"

	// ExportableInstanceFieldLastRefreshTimestamp is a ExportableInstanceField enum value
	ExportableInstanceFieldLastRefreshTimestamp = "LastRefreshTimestamp"
)

// ExportableInstanceField_Values returns all elements of the ExportableInstanceField enum
func ExportableInstanceField_Values() []string {
	return []string{
		ExportableInstanceFieldAccountId,
		ExportableInstanceFieldInstanceArn,
		ExportableInstanceFieldInstanceName,
		ExportableInstanceFieldFinding,
		ExportableInstanceFieldLookbackPeriodInDays,
		ExportableInstanceFieldCurrentInstanceType,
		ExportableInstanceFieldUtilizationMetricsCpuMaximum,
		ExportableInstanceFieldUtilizationMetricsMemoryMaximum,
		ExportableInstanceFieldCurrentOnDemandPrice,
		ExportableInstanceFieldCurrentStandardOneYearNoUpfrontReservedPrice,
		ExportableInstanceFieldCurrentStandardThreeYearNoUpfrontReservedPrice,
		ExportableInstanceFieldCurrentVcpus,
		ExportableInstanceFieldCurrentMemory,
		ExportableInstanceFieldCurrentStorage,
		ExportableInstanceFieldCurrentNetwork,
		ExportableInstanceFieldRecommendationOptionsInstanceType,
		ExportableInstanceFieldRecommendationOptionsProjectedUtilizationMetricsCpuMaximum,
		ExportableInstanceFieldRecommendationOptionsProjectedUtilizationMetricsMemoryMaximum,
		ExportableInstanceFieldRecommendationOptionsPerformanceRisk,
		ExportableInstanceFieldRecommendationOptionsVcpus,
		ExportableInstanceFieldRecommendationOptionsMemory,
		ExportableInstanceFieldRecommendationOptionsStorage,
		ExportableInstanceFieldRecommendationOptionsNetwork,
		ExportableInstanceFieldRecommendationOptionsOnDemandPrice,
		ExportableInstanceFieldRecommendationOptionsStandardOneYearNoUpfrontReservedPrice,
		ExportableInstanceFieldRecommendationOptionsStandardThreeYearNoUpfrontReservedPrice,
		ExportableInstanceFieldRecommendationsSourcesRecommendationSourceArn,
		ExportableInstanceFieldRecommendationsSourcesRecommendationSourceType,
		ExportableInstanceFieldLastRefreshTimestamp,
	}
}

const (
	// FileFormatCsv is a FileFormat enum value
	FileFormatCsv = "Csv"
)

// FileFormat_Values returns all elements of the FileFormat enum
func FileFormat_Values() []string {
	return []string{
		FileFormatCsv,
	}
}

const (
	// FilterNameFinding is a FilterName enum value
	FilterNameFinding = "Finding"

	// FilterNameRecommendationSourceType is a FilterName enum value
	FilterNameRecommendationSourceType = "RecommendationSourceType"
)

// FilterName_Values returns all elements of the FilterName enum
func FilterName_Values() []string {
	return []string{
		FilterNameFinding,
		FilterNameRecommendationSourceType,
	}
}

const (
	// FindingUnderprovisioned is a Finding enum value
	FindingUnderprovisioned = "Underprovisioned"

	// FindingOverprovisioned is a Finding enum value
	FindingOverprovisioned = "Overprovisioned"

	// FindingOptimized is a Finding enum value
	FindingOptimized = "Optimized"

	// FindingNotOptimized is a Finding enum value
	FindingNotOptimized = "NotOptimized"
)

// Finding_Values returns all elements of the Finding enum
func Finding_Values() []string {
	return []string{
		FindingUnderprovisioned,
		FindingOverprovisioned,
		FindingOptimized,
		FindingNotOptimized,
	}
}

const (
	// JobFilterNameResourceType is a JobFilterName enum value
	JobFilterNameResourceType = "ResourceType"

	// JobFilterNameJobStatus is a JobFilterName enum value
	JobFilterNameJobStatus = "JobStatus"
)

// JobFilterName_Values returns all elements of the JobFilterName enum
func JobFilterName_Values() []string {
	return []string{
		JobFilterNameResourceType,
		JobFilterNameJobStatus,
	}
}

const (
	// JobStatusQueued is a JobStatus enum value
	JobStatusQueued = "Queued"

	// JobStatusInProgress is a JobStatus enum value
	JobStatusInProgress = "InProgress"

	// JobStatusComplete is a JobStatus enum value
	JobStatusComplete = "Complete"

	// JobStatusFailed is a JobStatus enum value
	JobStatusFailed = "Failed"
)

// JobStatus_Values returns all elements of the JobStatus enum
func JobStatus_Values() []string {
	return []string{
		JobStatusQueued,
		JobStatusInProgress,
		JobStatusComplete,
		JobStatusFailed,
	}
}

const (
	// MetricNameCpu is a MetricName enum value
	MetricNameCpu = "Cpu"

	// MetricNameMemory is a MetricName enum value
	MetricNameMemory = "Memory"
)

// MetricName_Values returns all elements of the MetricName enum
func MetricName_Values() []string {
	return []string{
		MetricNameCpu,
		MetricNameMemory,
	}
}

const (
	// MetricStatisticMaximum is a MetricStatistic enum value
	MetricStatisticMaximum = "Maximum"

	// MetricStatisticAverage is a MetricStatistic enum value
	MetricStatisticAverage = "Average"
)

// MetricStatistic_Values returns all elements of the MetricStatistic enum
func MetricStatistic_Values() []string {
	return []string{
		MetricStatisticMaximum,
		MetricStatisticAverage,
	}
}

const (
	// RecommendationSourceTypeEc2instance is a RecommendationSourceType enum value
	RecommendationSourceTypeEc2instance = "Ec2Instance"

	// RecommendationSourceTypeAutoScalingGroup is a RecommendationSourceType enum value
	RecommendationSourceTypeAutoScalingGroup = "AutoScalingGroup"
)

// RecommendationSourceType_Values returns all elements of the RecommendationSourceType enum
func RecommendationSourceType_Values() []string {
	return []string{
		RecommendationSourceTypeEc2instance,
		RecommendationSourceTypeAutoScalingGroup,
	}
}

const (
	// ResourceTypeEc2instance is a ResourceType enum value
	ResourceTypeEc2instance = "Ec2Instance"

	// ResourceTypeAutoScalingGroup is a ResourceType enum value
	ResourceTypeAutoScalingGroup = "AutoScalingGroup"
)

// ResourceType_Values returns all elements of the ResourceType enum
func ResourceType_Values() []string {
	return []string{
		ResourceTypeEc2instance,
		ResourceTypeAutoScalingGroup,
	}
}

const (
	// StatusActive is a Status enum value
	StatusActive = "Active"

	// StatusInactive is a Status enum value
	StatusInactive = "Inactive"

	// StatusPending is a Status enum value
	StatusPending = "Pending"

	// StatusFailed is a Status enum value
	StatusFailed = "Failed"
)

// Status_Values returns all elements of the Status enum
func Status_Values() []string {
	return []string{
		StatusActive,
		StatusInactive,
		StatusPending,
		StatusFailed,
	}
}
