package backup

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AzureFileShareType enumerates the values for azure file share type.
type AzureFileShareType string

const (
	// Invalid ...
	Invalid AzureFileShareType = "Invalid"
	// XSMB ...
	XSMB AzureFileShareType = "XSMB"
	// XSync ...
	XSync AzureFileShareType = "XSync"
)

// PossibleAzureFileShareTypeValues returns an array of possible values for the AzureFileShareType const type.
func PossibleAzureFileShareTypeValues() []AzureFileShareType {
	return []AzureFileShareType{Invalid, XSMB, XSync}
}

// ContainerType enumerates the values for container type.
type ContainerType string

const (
	// ContainerTypeAzureBackupServerContainer ...
	ContainerTypeAzureBackupServerContainer ContainerType = "AzureBackupServerContainer"
	// ContainerTypeAzureSQLContainer ...
	ContainerTypeAzureSQLContainer ContainerType = "AzureSqlContainer"
	// ContainerTypeCluster ...
	ContainerTypeCluster ContainerType = "Cluster"
	// ContainerTypeDPMContainer ...
	ContainerTypeDPMContainer ContainerType = "DPMContainer"
	// ContainerTypeGenericContainer ...
	ContainerTypeGenericContainer ContainerType = "GenericContainer"
	// ContainerTypeIaasVMContainer ...
	ContainerTypeIaasVMContainer ContainerType = "IaasVMContainer"
	// ContainerTypeIaasVMServiceContainer ...
	ContainerTypeIaasVMServiceContainer ContainerType = "IaasVMServiceContainer"
	// ContainerTypeInvalid ...
	ContainerTypeInvalid ContainerType = "Invalid"
	// ContainerTypeMABContainer ...
	ContainerTypeMABContainer ContainerType = "MABContainer"
	// ContainerTypeSQLAGWorkLoadContainer ...
	ContainerTypeSQLAGWorkLoadContainer ContainerType = "SQLAGWorkLoadContainer"
	// ContainerTypeStorageContainer ...
	ContainerTypeStorageContainer ContainerType = "StorageContainer"
	// ContainerTypeUnknown ...
	ContainerTypeUnknown ContainerType = "Unknown"
	// ContainerTypeVCenter ...
	ContainerTypeVCenter ContainerType = "VCenter"
	// ContainerTypeVMAppContainer ...
	ContainerTypeVMAppContainer ContainerType = "VMAppContainer"
	// ContainerTypeWindows ...
	ContainerTypeWindows ContainerType = "Windows"
)

// PossibleContainerTypeValues returns an array of possible values for the ContainerType const type.
func PossibleContainerTypeValues() []ContainerType {
	return []ContainerType{ContainerTypeAzureBackupServerContainer, ContainerTypeAzureSQLContainer, ContainerTypeCluster, ContainerTypeDPMContainer, ContainerTypeGenericContainer, ContainerTypeIaasVMContainer, ContainerTypeIaasVMServiceContainer, ContainerTypeInvalid, ContainerTypeMABContainer, ContainerTypeSQLAGWorkLoadContainer, ContainerTypeStorageContainer, ContainerTypeUnknown, ContainerTypeVCenter, ContainerTypeVMAppContainer, ContainerTypeWindows}
}

// ContainerTypeBasicProtectionContainer enumerates the values for container type basic protection container.
type ContainerTypeBasicProtectionContainer string

const (
	// ContainerTypeAzureBackupServerContainer1 ...
	ContainerTypeAzureBackupServerContainer1 ContainerTypeBasicProtectionContainer = "AzureBackupServerContainer"
	// ContainerTypeAzureSQLContainer1 ...
	ContainerTypeAzureSQLContainer1 ContainerTypeBasicProtectionContainer = "AzureSqlContainer"
	// ContainerTypeAzureWorkloadContainer ...
	ContainerTypeAzureWorkloadContainer ContainerTypeBasicProtectionContainer = "AzureWorkloadContainer"
	// ContainerTypeDPMContainer1 ...
	ContainerTypeDPMContainer1 ContainerTypeBasicProtectionContainer = "DPMContainer"
	// ContainerTypeGenericContainer1 ...
	ContainerTypeGenericContainer1 ContainerTypeBasicProtectionContainer = "GenericContainer"
	// ContainerTypeIaaSVMContainer ...
	ContainerTypeIaaSVMContainer ContainerTypeBasicProtectionContainer = "IaaSVMContainer"
	// ContainerTypeMicrosoftClassicComputevirtualMachines ...
	ContainerTypeMicrosoftClassicComputevirtualMachines ContainerTypeBasicProtectionContainer = "Microsoft.ClassicCompute/virtualMachines"
	// ContainerTypeMicrosoftComputevirtualMachines ...
	ContainerTypeMicrosoftComputevirtualMachines ContainerTypeBasicProtectionContainer = "Microsoft.Compute/virtualMachines"
	// ContainerTypeProtectionContainer ...
	ContainerTypeProtectionContainer ContainerTypeBasicProtectionContainer = "ProtectionContainer"
	// ContainerTypeSQLAGWorkLoadContainer1 ...
	ContainerTypeSQLAGWorkLoadContainer1 ContainerTypeBasicProtectionContainer = "SQLAGWorkLoadContainer"
	// ContainerTypeStorageContainer1 ...
	ContainerTypeStorageContainer1 ContainerTypeBasicProtectionContainer = "StorageContainer"
	// ContainerTypeVMAppContainer1 ...
	ContainerTypeVMAppContainer1 ContainerTypeBasicProtectionContainer = "VMAppContainer"
	// ContainerTypeWindows1 ...
	ContainerTypeWindows1 ContainerTypeBasicProtectionContainer = "Windows"
)

// PossibleContainerTypeBasicProtectionContainerValues returns an array of possible values for the ContainerTypeBasicProtectionContainer const type.
func PossibleContainerTypeBasicProtectionContainerValues() []ContainerTypeBasicProtectionContainer {
	return []ContainerTypeBasicProtectionContainer{ContainerTypeAzureBackupServerContainer1, ContainerTypeAzureSQLContainer1, ContainerTypeAzureWorkloadContainer, ContainerTypeDPMContainer1, ContainerTypeGenericContainer1, ContainerTypeIaaSVMContainer, ContainerTypeMicrosoftClassicComputevirtualMachines, ContainerTypeMicrosoftComputevirtualMachines, ContainerTypeProtectionContainer, ContainerTypeSQLAGWorkLoadContainer1, ContainerTypeStorageContainer1, ContainerTypeVMAppContainer1, ContainerTypeWindows1}
}

// CopyOptions enumerates the values for copy options.
type CopyOptions string

const (
	// CopyOptionsCreateCopy ...
	CopyOptionsCreateCopy CopyOptions = "CreateCopy"
	// CopyOptionsFailOnConflict ...
	CopyOptionsFailOnConflict CopyOptions = "FailOnConflict"
	// CopyOptionsInvalid ...
	CopyOptionsInvalid CopyOptions = "Invalid"
	// CopyOptionsOverwrite ...
	CopyOptionsOverwrite CopyOptions = "Overwrite"
	// CopyOptionsSkip ...
	CopyOptionsSkip CopyOptions = "Skip"
)

// PossibleCopyOptionsValues returns an array of possible values for the CopyOptions const type.
func PossibleCopyOptionsValues() []CopyOptions {
	return []CopyOptions{CopyOptionsCreateCopy, CopyOptionsFailOnConflict, CopyOptionsInvalid, CopyOptionsOverwrite, CopyOptionsSkip}
}

// CreateMode enumerates the values for create mode.
type CreateMode string

const (
	// CreateModeDefault ...
	CreateModeDefault CreateMode = "Default"
	// CreateModeInvalid ...
	CreateModeInvalid CreateMode = "Invalid"
	// CreateModeRecover ...
	CreateModeRecover CreateMode = "Recover"
)

// PossibleCreateModeValues returns an array of possible values for the CreateMode const type.
func PossibleCreateModeValues() []CreateMode {
	return []CreateMode{CreateModeDefault, CreateModeInvalid, CreateModeRecover}
}

// DataSourceType enumerates the values for data source type.
type DataSourceType string

const (
	// DataSourceTypeAzureFileShare ...
	DataSourceTypeAzureFileShare DataSourceType = "AzureFileShare"
	// DataSourceTypeAzureSQLDb ...
	DataSourceTypeAzureSQLDb DataSourceType = "AzureSqlDb"
	// DataSourceTypeClient ...
	DataSourceTypeClient DataSourceType = "Client"
	// DataSourceTypeExchange ...
	DataSourceTypeExchange DataSourceType = "Exchange"
	// DataSourceTypeFileFolder ...
	DataSourceTypeFileFolder DataSourceType = "FileFolder"
	// DataSourceTypeGenericDataSource ...
	DataSourceTypeGenericDataSource DataSourceType = "GenericDataSource"
	// DataSourceTypeInvalid ...
	DataSourceTypeInvalid DataSourceType = "Invalid"
	// DataSourceTypeSAPAseDatabase ...
	DataSourceTypeSAPAseDatabase DataSourceType = "SAPAseDatabase"
	// DataSourceTypeSAPHanaDatabase ...
	DataSourceTypeSAPHanaDatabase DataSourceType = "SAPHanaDatabase"
	// DataSourceTypeSharepoint ...
	DataSourceTypeSharepoint DataSourceType = "Sharepoint"
	// DataSourceTypeSQLDataBase ...
	DataSourceTypeSQLDataBase DataSourceType = "SQLDataBase"
	// DataSourceTypeSQLDB ...
	DataSourceTypeSQLDB DataSourceType = "SQLDB"
	// DataSourceTypeSystemState ...
	DataSourceTypeSystemState DataSourceType = "SystemState"
	// DataSourceTypeVM ...
	DataSourceTypeVM DataSourceType = "VM"
	// DataSourceTypeVMwareVM ...
	DataSourceTypeVMwareVM DataSourceType = "VMwareVM"
)

// PossibleDataSourceTypeValues returns an array of possible values for the DataSourceType const type.
func PossibleDataSourceTypeValues() []DataSourceType {
	return []DataSourceType{DataSourceTypeAzureFileShare, DataSourceTypeAzureSQLDb, DataSourceTypeClient, DataSourceTypeExchange, DataSourceTypeFileFolder, DataSourceTypeGenericDataSource, DataSourceTypeInvalid, DataSourceTypeSAPAseDatabase, DataSourceTypeSAPHanaDatabase, DataSourceTypeSharepoint, DataSourceTypeSQLDataBase, DataSourceTypeSQLDB, DataSourceTypeSystemState, DataSourceTypeVM, DataSourceTypeVMwareVM}
}

// DayOfWeek enumerates the values for day of week.
type DayOfWeek string

const (
	// Friday ...
	Friday DayOfWeek = "Friday"
	// Monday ...
	Monday DayOfWeek = "Monday"
	// Saturday ...
	Saturday DayOfWeek = "Saturday"
	// Sunday ...
	Sunday DayOfWeek = "Sunday"
	// Thursday ...
	Thursday DayOfWeek = "Thursday"
	// Tuesday ...
	Tuesday DayOfWeek = "Tuesday"
	// Wednesday ...
	Wednesday DayOfWeek = "Wednesday"
)

// PossibleDayOfWeekValues returns an array of possible values for the DayOfWeek const type.
func PossibleDayOfWeekValues() []DayOfWeek {
	return []DayOfWeek{Friday, Monday, Saturday, Sunday, Thursday, Tuesday, Wednesday}
}

// EngineType enumerates the values for engine type.
type EngineType string

const (
	// BackupEngineTypeAzureBackupServerEngine ...
	BackupEngineTypeAzureBackupServerEngine EngineType = "AzureBackupServerEngine"
	// BackupEngineTypeBackupEngineBase ...
	BackupEngineTypeBackupEngineBase EngineType = "BackupEngineBase"
	// BackupEngineTypeDpmBackupEngine ...
	BackupEngineTypeDpmBackupEngine EngineType = "DpmBackupEngine"
)

// PossibleEngineTypeValues returns an array of possible values for the EngineType const type.
func PossibleEngineTypeValues() []EngineType {
	return []EngineType{BackupEngineTypeAzureBackupServerEngine, BackupEngineTypeBackupEngineBase, BackupEngineTypeDpmBackupEngine}
}

// EnhancedSecurityState enumerates the values for enhanced security state.
type EnhancedSecurityState string

const (
	// EnhancedSecurityStateDisabled ...
	EnhancedSecurityStateDisabled EnhancedSecurityState = "Disabled"
	// EnhancedSecurityStateEnabled ...
	EnhancedSecurityStateEnabled EnhancedSecurityState = "Enabled"
	// EnhancedSecurityStateInvalid ...
	EnhancedSecurityStateInvalid EnhancedSecurityState = "Invalid"
)

// PossibleEnhancedSecurityStateValues returns an array of possible values for the EnhancedSecurityState const type.
func PossibleEnhancedSecurityStateValues() []EnhancedSecurityState {
	return []EnhancedSecurityState{EnhancedSecurityStateDisabled, EnhancedSecurityStateEnabled, EnhancedSecurityStateInvalid}
}

// FabricName enumerates the values for fabric name.
type FabricName string

const (
	// FabricNameAzure ...
	FabricNameAzure FabricName = "Azure"
	// FabricNameInvalid ...
	FabricNameInvalid FabricName = "Invalid"
)

// PossibleFabricNameValues returns an array of possible values for the FabricName const type.
func PossibleFabricNameValues() []FabricName {
	return []FabricName{FabricNameAzure, FabricNameInvalid}
}

// FeatureType enumerates the values for feature type.
type FeatureType string

const (
	// FeatureTypeAzureBackupGoals ...
	FeatureTypeAzureBackupGoals FeatureType = "AzureBackupGoals"
	// FeatureTypeAzureVMResourceBackup ...
	FeatureTypeAzureVMResourceBackup FeatureType = "AzureVMResourceBackup"
	// FeatureTypeFeatureSupportRequest ...
	FeatureTypeFeatureSupportRequest FeatureType = "FeatureSupportRequest"
)

// PossibleFeatureTypeValues returns an array of possible values for the FeatureType const type.
func PossibleFeatureTypeValues() []FeatureType {
	return []FeatureType{FeatureTypeAzureBackupGoals, FeatureTypeAzureVMResourceBackup, FeatureTypeFeatureSupportRequest}
}

// HealthState enumerates the values for health state.
type HealthState string

const (
	// HealthStateActionRequired ...
	HealthStateActionRequired HealthState = "ActionRequired"
	// HealthStateActionSuggested ...
	HealthStateActionSuggested HealthState = "ActionSuggested"
	// HealthStateInvalid ...
	HealthStateInvalid HealthState = "Invalid"
	// HealthStatePassed ...
	HealthStatePassed HealthState = "Passed"
)

// PossibleHealthStateValues returns an array of possible values for the HealthState const type.
func PossibleHealthStateValues() []HealthState {
	return []HealthState{HealthStateActionRequired, HealthStateActionSuggested, HealthStateInvalid, HealthStatePassed}
}

// HealthStatus enumerates the values for health status.
type HealthStatus string

const (
	// HealthStatusActionRequired ...
	HealthStatusActionRequired HealthStatus = "ActionRequired"
	// HealthStatusActionSuggested ...
	HealthStatusActionSuggested HealthStatus = "ActionSuggested"
	// HealthStatusInvalid ...
	HealthStatusInvalid HealthStatus = "Invalid"
	// HealthStatusPassed ...
	HealthStatusPassed HealthStatus = "Passed"
)

// PossibleHealthStatusValues returns an array of possible values for the HealthStatus const type.
func PossibleHealthStatusValues() []HealthStatus {
	return []HealthStatus{HealthStatusActionRequired, HealthStatusActionSuggested, HealthStatusInvalid, HealthStatusPassed}
}

// HTTPStatusCode enumerates the values for http status code.
type HTTPStatusCode string

const (
	// Accepted ...
	Accepted HTTPStatusCode = "Accepted"
	// Ambiguous ...
	Ambiguous HTTPStatusCode = "Ambiguous"
	// BadGateway ...
	BadGateway HTTPStatusCode = "BadGateway"
	// BadRequest ...
	BadRequest HTTPStatusCode = "BadRequest"
	// Conflict ...
	Conflict HTTPStatusCode = "Conflict"
	// Continue ...
	Continue HTTPStatusCode = "Continue"
	// Created ...
	Created HTTPStatusCode = "Created"
	// ExpectationFailed ...
	ExpectationFailed HTTPStatusCode = "ExpectationFailed"
	// Forbidden ...
	Forbidden HTTPStatusCode = "Forbidden"
	// Found ...
	Found HTTPStatusCode = "Found"
	// GatewayTimeout ...
	GatewayTimeout HTTPStatusCode = "GatewayTimeout"
	// Gone ...
	Gone HTTPStatusCode = "Gone"
	// HTTPVersionNotSupported ...
	HTTPVersionNotSupported HTTPStatusCode = "HttpVersionNotSupported"
	// InternalServerError ...
	InternalServerError HTTPStatusCode = "InternalServerError"
	// LengthRequired ...
	LengthRequired HTTPStatusCode = "LengthRequired"
	// MethodNotAllowed ...
	MethodNotAllowed HTTPStatusCode = "MethodNotAllowed"
	// Moved ...
	Moved HTTPStatusCode = "Moved"
	// MovedPermanently ...
	MovedPermanently HTTPStatusCode = "MovedPermanently"
	// MultipleChoices ...
	MultipleChoices HTTPStatusCode = "MultipleChoices"
	// NoContent ...
	NoContent HTTPStatusCode = "NoContent"
	// NonAuthoritativeInformation ...
	NonAuthoritativeInformation HTTPStatusCode = "NonAuthoritativeInformation"
	// NotAcceptable ...
	NotAcceptable HTTPStatusCode = "NotAcceptable"
	// NotFound ...
	NotFound HTTPStatusCode = "NotFound"
	// NotImplemented ...
	NotImplemented HTTPStatusCode = "NotImplemented"
	// NotModified ...
	NotModified HTTPStatusCode = "NotModified"
	// OK ...
	OK HTTPStatusCode = "OK"
	// PartialContent ...
	PartialContent HTTPStatusCode = "PartialContent"
	// PaymentRequired ...
	PaymentRequired HTTPStatusCode = "PaymentRequired"
	// PreconditionFailed ...
	PreconditionFailed HTTPStatusCode = "PreconditionFailed"
	// ProxyAuthenticationRequired ...
	ProxyAuthenticationRequired HTTPStatusCode = "ProxyAuthenticationRequired"
	// Redirect ...
	Redirect HTTPStatusCode = "Redirect"
	// RedirectKeepVerb ...
	RedirectKeepVerb HTTPStatusCode = "RedirectKeepVerb"
	// RedirectMethod ...
	RedirectMethod HTTPStatusCode = "RedirectMethod"
	// RequestedRangeNotSatisfiable ...
	RequestedRangeNotSatisfiable HTTPStatusCode = "RequestedRangeNotSatisfiable"
	// RequestEntityTooLarge ...
	RequestEntityTooLarge HTTPStatusCode = "RequestEntityTooLarge"
	// RequestTimeout ...
	RequestTimeout HTTPStatusCode = "RequestTimeout"
	// RequestURITooLong ...
	RequestURITooLong HTTPStatusCode = "RequestUriTooLong"
	// ResetContent ...
	ResetContent HTTPStatusCode = "ResetContent"
	// SeeOther ...
	SeeOther HTTPStatusCode = "SeeOther"
	// ServiceUnavailable ...
	ServiceUnavailable HTTPStatusCode = "ServiceUnavailable"
	// SwitchingProtocols ...
	SwitchingProtocols HTTPStatusCode = "SwitchingProtocols"
	// TemporaryRedirect ...
	TemporaryRedirect HTTPStatusCode = "TemporaryRedirect"
	// Unauthorized ...
	Unauthorized HTTPStatusCode = "Unauthorized"
	// UnsupportedMediaType ...
	UnsupportedMediaType HTTPStatusCode = "UnsupportedMediaType"
	// Unused ...
	Unused HTTPStatusCode = "Unused"
	// UpgradeRequired ...
	UpgradeRequired HTTPStatusCode = "UpgradeRequired"
	// UseProxy ...
	UseProxy HTTPStatusCode = "UseProxy"
)

// PossibleHTTPStatusCodeValues returns an array of possible values for the HTTPStatusCode const type.
func PossibleHTTPStatusCodeValues() []HTTPStatusCode {
	return []HTTPStatusCode{Accepted, Ambiguous, BadGateway, BadRequest, Conflict, Continue, Created, ExpectationFailed, Forbidden, Found, GatewayTimeout, Gone, HTTPVersionNotSupported, InternalServerError, LengthRequired, MethodNotAllowed, Moved, MovedPermanently, MultipleChoices, NoContent, NonAuthoritativeInformation, NotAcceptable, NotFound, NotImplemented, NotModified, OK, PartialContent, PaymentRequired, PreconditionFailed, ProxyAuthenticationRequired, Redirect, RedirectKeepVerb, RedirectMethod, RequestedRangeNotSatisfiable, RequestEntityTooLarge, RequestTimeout, RequestURITooLong, ResetContent, SeeOther, ServiceUnavailable, SwitchingProtocols, TemporaryRedirect, Unauthorized, UnsupportedMediaType, Unused, UpgradeRequired, UseProxy}
}

// InquiryStatus enumerates the values for inquiry status.
type InquiryStatus string

const (
	// InquiryStatusFailed ...
	InquiryStatusFailed InquiryStatus = "Failed"
	// InquiryStatusInvalid ...
	InquiryStatusInvalid InquiryStatus = "Invalid"
	// InquiryStatusSuccess ...
	InquiryStatusSuccess InquiryStatus = "Success"
)

// PossibleInquiryStatusValues returns an array of possible values for the InquiryStatus const type.
func PossibleInquiryStatusValues() []InquiryStatus {
	return []InquiryStatus{InquiryStatusFailed, InquiryStatusInvalid, InquiryStatusSuccess}
}

// IntentItemType enumerates the values for intent item type.
type IntentItemType string

const (
	// IntentItemTypeInvalid ...
	IntentItemTypeInvalid IntentItemType = "Invalid"
	// IntentItemTypeSQLAvailabilityGroupContainer ...
	IntentItemTypeSQLAvailabilityGroupContainer IntentItemType = "SQLAvailabilityGroupContainer"
	// IntentItemTypeSQLInstance ...
	IntentItemTypeSQLInstance IntentItemType = "SQLInstance"
)

// PossibleIntentItemTypeValues returns an array of possible values for the IntentItemType const type.
func PossibleIntentItemTypeValues() []IntentItemType {
	return []IntentItemType{IntentItemTypeInvalid, IntentItemTypeSQLAvailabilityGroupContainer, IntentItemTypeSQLInstance}
}

// ItemType enumerates the values for item type.
type ItemType string

const (
	// ItemTypeAzureFileShare ...
	ItemTypeAzureFileShare ItemType = "AzureFileShare"
	// ItemTypeAzureSQLDb ...
	ItemTypeAzureSQLDb ItemType = "AzureSqlDb"
	// ItemTypeClient ...
	ItemTypeClient ItemType = "Client"
	// ItemTypeExchange ...
	ItemTypeExchange ItemType = "Exchange"
	// ItemTypeFileFolder ...
	ItemTypeFileFolder ItemType = "FileFolder"
	// ItemTypeGenericDataSource ...
	ItemTypeGenericDataSource ItemType = "GenericDataSource"
	// ItemTypeInvalid ...
	ItemTypeInvalid ItemType = "Invalid"
	// ItemTypeSAPAseDatabase ...
	ItemTypeSAPAseDatabase ItemType = "SAPAseDatabase"
	// ItemTypeSAPHanaDatabase ...
	ItemTypeSAPHanaDatabase ItemType = "SAPHanaDatabase"
	// ItemTypeSharepoint ...
	ItemTypeSharepoint ItemType = "Sharepoint"
	// ItemTypeSQLDataBase ...
	ItemTypeSQLDataBase ItemType = "SQLDataBase"
	// ItemTypeSQLDB ...
	ItemTypeSQLDB ItemType = "SQLDB"
	// ItemTypeSystemState ...
	ItemTypeSystemState ItemType = "SystemState"
	// ItemTypeVM ...
	ItemTypeVM ItemType = "VM"
	// ItemTypeVMwareVM ...
	ItemTypeVMwareVM ItemType = "VMwareVM"
)

// PossibleItemTypeValues returns an array of possible values for the ItemType const type.
func PossibleItemTypeValues() []ItemType {
	return []ItemType{ItemTypeAzureFileShare, ItemTypeAzureSQLDb, ItemTypeClient, ItemTypeExchange, ItemTypeFileFolder, ItemTypeGenericDataSource, ItemTypeInvalid, ItemTypeSAPAseDatabase, ItemTypeSAPHanaDatabase, ItemTypeSharepoint, ItemTypeSQLDataBase, ItemTypeSQLDB, ItemTypeSystemState, ItemTypeVM, ItemTypeVMwareVM}
}

// JobOperationType enumerates the values for job operation type.
type JobOperationType string

const (
	// JobOperationTypeBackup ...
	JobOperationTypeBackup JobOperationType = "Backup"
	// JobOperationTypeConfigureBackup ...
	JobOperationTypeConfigureBackup JobOperationType = "ConfigureBackup"
	// JobOperationTypeCrossRegionRestore ...
	JobOperationTypeCrossRegionRestore JobOperationType = "CrossRegionRestore"
	// JobOperationTypeDeleteBackupData ...
	JobOperationTypeDeleteBackupData JobOperationType = "DeleteBackupData"
	// JobOperationTypeDisableBackup ...
	JobOperationTypeDisableBackup JobOperationType = "DisableBackup"
	// JobOperationTypeInvalid ...
	JobOperationTypeInvalid JobOperationType = "Invalid"
	// JobOperationTypeRegister ...
	JobOperationTypeRegister JobOperationType = "Register"
	// JobOperationTypeRestore ...
	JobOperationTypeRestore JobOperationType = "Restore"
	// JobOperationTypeUndelete ...
	JobOperationTypeUndelete JobOperationType = "Undelete"
	// JobOperationTypeUnRegister ...
	JobOperationTypeUnRegister JobOperationType = "UnRegister"
)

// PossibleJobOperationTypeValues returns an array of possible values for the JobOperationType const type.
func PossibleJobOperationTypeValues() []JobOperationType {
	return []JobOperationType{JobOperationTypeBackup, JobOperationTypeConfigureBackup, JobOperationTypeCrossRegionRestore, JobOperationTypeDeleteBackupData, JobOperationTypeDisableBackup, JobOperationTypeInvalid, JobOperationTypeRegister, JobOperationTypeRestore, JobOperationTypeUndelete, JobOperationTypeUnRegister}
}

// JobStatus enumerates the values for job status.
type JobStatus string

const (
	// JobStatusCancelled ...
	JobStatusCancelled JobStatus = "Cancelled"
	// JobStatusCancelling ...
	JobStatusCancelling JobStatus = "Cancelling"
	// JobStatusCompleted ...
	JobStatusCompleted JobStatus = "Completed"
	// JobStatusCompletedWithWarnings ...
	JobStatusCompletedWithWarnings JobStatus = "CompletedWithWarnings"
	// JobStatusFailed ...
	JobStatusFailed JobStatus = "Failed"
	// JobStatusInProgress ...
	JobStatusInProgress JobStatus = "InProgress"
	// JobStatusInvalid ...
	JobStatusInvalid JobStatus = "Invalid"
)

// PossibleJobStatusValues returns an array of possible values for the JobStatus const type.
func PossibleJobStatusValues() []JobStatus {
	return []JobStatus{JobStatusCancelled, JobStatusCancelling, JobStatusCompleted, JobStatusCompletedWithWarnings, JobStatusFailed, JobStatusInProgress, JobStatusInvalid}
}

// JobSupportedAction enumerates the values for job supported action.
type JobSupportedAction string

const (
	// JobSupportedActionCancellable ...
	JobSupportedActionCancellable JobSupportedAction = "Cancellable"
	// JobSupportedActionInvalid ...
	JobSupportedActionInvalid JobSupportedAction = "Invalid"
	// JobSupportedActionRetriable ...
	JobSupportedActionRetriable JobSupportedAction = "Retriable"
)

// PossibleJobSupportedActionValues returns an array of possible values for the JobSupportedAction const type.
func PossibleJobSupportedActionValues() []JobSupportedAction {
	return []JobSupportedAction{JobSupportedActionCancellable, JobSupportedActionInvalid, JobSupportedActionRetriable}
}

// JobType enumerates the values for job type.
type JobType string

const (
	// JobTypeAzureIaaSVMJob ...
	JobTypeAzureIaaSVMJob JobType = "AzureIaaSVMJob"
	// JobTypeAzureStorageJob ...
	JobTypeAzureStorageJob JobType = "AzureStorageJob"
	// JobTypeAzureWorkloadJob ...
	JobTypeAzureWorkloadJob JobType = "AzureWorkloadJob"
	// JobTypeDpmJob ...
	JobTypeDpmJob JobType = "DpmJob"
	// JobTypeJob ...
	JobTypeJob JobType = "Job"
	// JobTypeMabJob ...
	JobTypeMabJob JobType = "MabJob"
)

// PossibleJobTypeValues returns an array of possible values for the JobType const type.
func PossibleJobTypeValues() []JobType {
	return []JobType{JobTypeAzureIaaSVMJob, JobTypeAzureStorageJob, JobTypeAzureWorkloadJob, JobTypeDpmJob, JobTypeJob, JobTypeMabJob}
}

// LastBackupStatus enumerates the values for last backup status.
type LastBackupStatus string

const (
	// LastBackupStatusHealthy ...
	LastBackupStatusHealthy LastBackupStatus = "Healthy"
	// LastBackupStatusInvalid ...
	LastBackupStatusInvalid LastBackupStatus = "Invalid"
	// LastBackupStatusIRPending ...
	LastBackupStatusIRPending LastBackupStatus = "IRPending"
	// LastBackupStatusUnhealthy ...
	LastBackupStatusUnhealthy LastBackupStatus = "Unhealthy"
)

// PossibleLastBackupStatusValues returns an array of possible values for the LastBackupStatus const type.
func PossibleLastBackupStatusValues() []LastBackupStatus {
	return []LastBackupStatus{LastBackupStatusHealthy, LastBackupStatusInvalid, LastBackupStatusIRPending, LastBackupStatusUnhealthy}
}

// MabServerType enumerates the values for mab server type.
type MabServerType string

const (
	// MabServerTypeAzureBackupServerContainer ...
	MabServerTypeAzureBackupServerContainer MabServerType = "AzureBackupServerContainer"
	// MabServerTypeAzureSQLContainer ...
	MabServerTypeAzureSQLContainer MabServerType = "AzureSqlContainer"
	// MabServerTypeCluster ...
	MabServerTypeCluster MabServerType = "Cluster"
	// MabServerTypeDPMContainer ...
	MabServerTypeDPMContainer MabServerType = "DPMContainer"
	// MabServerTypeGenericContainer ...
	MabServerTypeGenericContainer MabServerType = "GenericContainer"
	// MabServerTypeIaasVMContainer ...
	MabServerTypeIaasVMContainer MabServerType = "IaasVMContainer"
	// MabServerTypeIaasVMServiceContainer ...
	MabServerTypeIaasVMServiceContainer MabServerType = "IaasVMServiceContainer"
	// MabServerTypeInvalid ...
	MabServerTypeInvalid MabServerType = "Invalid"
	// MabServerTypeMABContainer ...
	MabServerTypeMABContainer MabServerType = "MABContainer"
	// MabServerTypeSQLAGWorkLoadContainer ...
	MabServerTypeSQLAGWorkLoadContainer MabServerType = "SQLAGWorkLoadContainer"
	// MabServerTypeStorageContainer ...
	MabServerTypeStorageContainer MabServerType = "StorageContainer"
	// MabServerTypeUnknown ...
	MabServerTypeUnknown MabServerType = "Unknown"
	// MabServerTypeVCenter ...
	MabServerTypeVCenter MabServerType = "VCenter"
	// MabServerTypeVMAppContainer ...
	MabServerTypeVMAppContainer MabServerType = "VMAppContainer"
	// MabServerTypeWindows ...
	MabServerTypeWindows MabServerType = "Windows"
)

// PossibleMabServerTypeValues returns an array of possible values for the MabServerType const type.
func PossibleMabServerTypeValues() []MabServerType {
	return []MabServerType{MabServerTypeAzureBackupServerContainer, MabServerTypeAzureSQLContainer, MabServerTypeCluster, MabServerTypeDPMContainer, MabServerTypeGenericContainer, MabServerTypeIaasVMContainer, MabServerTypeIaasVMServiceContainer, MabServerTypeInvalid, MabServerTypeMABContainer, MabServerTypeSQLAGWorkLoadContainer, MabServerTypeStorageContainer, MabServerTypeUnknown, MabServerTypeVCenter, MabServerTypeVMAppContainer, MabServerTypeWindows}
}

// ManagementType enumerates the values for management type.
type ManagementType string

const (
	// ManagementTypeAzureBackupServer ...
	ManagementTypeAzureBackupServer ManagementType = "AzureBackupServer"
	// ManagementTypeAzureIaasVM ...
	ManagementTypeAzureIaasVM ManagementType = "AzureIaasVM"
	// ManagementTypeAzureSQL ...
	ManagementTypeAzureSQL ManagementType = "AzureSql"
	// ManagementTypeAzureStorage ...
	ManagementTypeAzureStorage ManagementType = "AzureStorage"
	// ManagementTypeAzureWorkload ...
	ManagementTypeAzureWorkload ManagementType = "AzureWorkload"
	// ManagementTypeDefaultBackup ...
	ManagementTypeDefaultBackup ManagementType = "DefaultBackup"
	// ManagementTypeDPM ...
	ManagementTypeDPM ManagementType = "DPM"
	// ManagementTypeInvalid ...
	ManagementTypeInvalid ManagementType = "Invalid"
	// ManagementTypeMAB ...
	ManagementTypeMAB ManagementType = "MAB"
)

// PossibleManagementTypeValues returns an array of possible values for the ManagementType const type.
func PossibleManagementTypeValues() []ManagementType {
	return []ManagementType{ManagementTypeAzureBackupServer, ManagementTypeAzureIaasVM, ManagementTypeAzureSQL, ManagementTypeAzureStorage, ManagementTypeAzureWorkload, ManagementTypeDefaultBackup, ManagementTypeDPM, ManagementTypeInvalid, ManagementTypeMAB}
}

// ManagementTypeBasicProtectionPolicy enumerates the values for management type basic protection policy.
type ManagementTypeBasicProtectionPolicy string

const (
	// BackupManagementTypeAzureIaasVM ...
	BackupManagementTypeAzureIaasVM ManagementTypeBasicProtectionPolicy = "AzureIaasVM"
	// BackupManagementTypeAzureSQL ...
	BackupManagementTypeAzureSQL ManagementTypeBasicProtectionPolicy = "AzureSql"
	// BackupManagementTypeAzureStorage ...
	BackupManagementTypeAzureStorage ManagementTypeBasicProtectionPolicy = "AzureStorage"
	// BackupManagementTypeAzureWorkload ...
	BackupManagementTypeAzureWorkload ManagementTypeBasicProtectionPolicy = "AzureWorkload"
	// BackupManagementTypeGenericProtectionPolicy ...
	BackupManagementTypeGenericProtectionPolicy ManagementTypeBasicProtectionPolicy = "GenericProtectionPolicy"
	// BackupManagementTypeMAB ...
	BackupManagementTypeMAB ManagementTypeBasicProtectionPolicy = "MAB"
	// BackupManagementTypeProtectionPolicy ...
	BackupManagementTypeProtectionPolicy ManagementTypeBasicProtectionPolicy = "ProtectionPolicy"
)

// PossibleManagementTypeBasicProtectionPolicyValues returns an array of possible values for the ManagementTypeBasicProtectionPolicy const type.
func PossibleManagementTypeBasicProtectionPolicyValues() []ManagementTypeBasicProtectionPolicy {
	return []ManagementTypeBasicProtectionPolicy{BackupManagementTypeAzureIaasVM, BackupManagementTypeAzureSQL, BackupManagementTypeAzureStorage, BackupManagementTypeAzureWorkload, BackupManagementTypeGenericProtectionPolicy, BackupManagementTypeMAB, BackupManagementTypeProtectionPolicy}
}

// MonthOfYear enumerates the values for month of year.
type MonthOfYear string

const (
	// MonthOfYearApril ...
	MonthOfYearApril MonthOfYear = "April"
	// MonthOfYearAugust ...
	MonthOfYearAugust MonthOfYear = "August"
	// MonthOfYearDecember ...
	MonthOfYearDecember MonthOfYear = "December"
	// MonthOfYearFebruary ...
	MonthOfYearFebruary MonthOfYear = "February"
	// MonthOfYearInvalid ...
	MonthOfYearInvalid MonthOfYear = "Invalid"
	// MonthOfYearJanuary ...
	MonthOfYearJanuary MonthOfYear = "January"
	// MonthOfYearJuly ...
	MonthOfYearJuly MonthOfYear = "July"
	// MonthOfYearJune ...
	MonthOfYearJune MonthOfYear = "June"
	// MonthOfYearMarch ...
	MonthOfYearMarch MonthOfYear = "March"
	// MonthOfYearMay ...
	MonthOfYearMay MonthOfYear = "May"
	// MonthOfYearNovember ...
	MonthOfYearNovember MonthOfYear = "November"
	// MonthOfYearOctober ...
	MonthOfYearOctober MonthOfYear = "October"
	// MonthOfYearSeptember ...
	MonthOfYearSeptember MonthOfYear = "September"
)

// PossibleMonthOfYearValues returns an array of possible values for the MonthOfYear const type.
func PossibleMonthOfYearValues() []MonthOfYear {
	return []MonthOfYear{MonthOfYearApril, MonthOfYearAugust, MonthOfYearDecember, MonthOfYearFebruary, MonthOfYearInvalid, MonthOfYearJanuary, MonthOfYearJuly, MonthOfYearJune, MonthOfYearMarch, MonthOfYearMay, MonthOfYearNovember, MonthOfYearOctober, MonthOfYearSeptember}
}

// ObjectType enumerates the values for object type.
type ObjectType string

const (
	// ObjectTypeOperationStatusExtendedInfo ...
	ObjectTypeOperationStatusExtendedInfo ObjectType = "OperationStatusExtendedInfo"
	// ObjectTypeOperationStatusJobExtendedInfo ...
	ObjectTypeOperationStatusJobExtendedInfo ObjectType = "OperationStatusJobExtendedInfo"
	// ObjectTypeOperationStatusJobsExtendedInfo ...
	ObjectTypeOperationStatusJobsExtendedInfo ObjectType = "OperationStatusJobsExtendedInfo"
	// ObjectTypeOperationStatusProvisionILRExtendedInfo ...
	ObjectTypeOperationStatusProvisionILRExtendedInfo ObjectType = "OperationStatusProvisionILRExtendedInfo"
)

// PossibleObjectTypeValues returns an array of possible values for the ObjectType const type.
func PossibleObjectTypeValues() []ObjectType {
	return []ObjectType{ObjectTypeOperationStatusExtendedInfo, ObjectTypeOperationStatusJobExtendedInfo, ObjectTypeOperationStatusJobsExtendedInfo, ObjectTypeOperationStatusProvisionILRExtendedInfo}
}

// ObjectTypeBasicILRRequest enumerates the values for object type basic ilr request.
type ObjectTypeBasicILRRequest string

const (
	// ObjectTypeAzureFileShareProvisionILRRequest ...
	ObjectTypeAzureFileShareProvisionILRRequest ObjectTypeBasicILRRequest = "AzureFileShareProvisionILRRequest"
	// ObjectTypeIaasVMILRRegistrationRequest ...
	ObjectTypeIaasVMILRRegistrationRequest ObjectTypeBasicILRRequest = "IaasVMILRRegistrationRequest"
	// ObjectTypeILRRequest ...
	ObjectTypeILRRequest ObjectTypeBasicILRRequest = "ILRRequest"
)

// PossibleObjectTypeBasicILRRequestValues returns an array of possible values for the ObjectTypeBasicILRRequest const type.
func PossibleObjectTypeBasicILRRequestValues() []ObjectTypeBasicILRRequest {
	return []ObjectTypeBasicILRRequest{ObjectTypeAzureFileShareProvisionILRRequest, ObjectTypeIaasVMILRRegistrationRequest, ObjectTypeILRRequest}
}

// ObjectTypeBasicOperationResultInfoBase enumerates the values for object type basic operation result info
// base.
type ObjectTypeBasicOperationResultInfoBase string

const (
	// ObjectTypeExportJobsOperationResultInfo ...
	ObjectTypeExportJobsOperationResultInfo ObjectTypeBasicOperationResultInfoBase = "ExportJobsOperationResultInfo"
	// ObjectTypeOperationResultInfo ...
	ObjectTypeOperationResultInfo ObjectTypeBasicOperationResultInfoBase = "OperationResultInfo"
	// ObjectTypeOperationResultInfoBase ...
	ObjectTypeOperationResultInfoBase ObjectTypeBasicOperationResultInfoBase = "OperationResultInfoBase"
)

// PossibleObjectTypeBasicOperationResultInfoBaseValues returns an array of possible values for the ObjectTypeBasicOperationResultInfoBase const type.
func PossibleObjectTypeBasicOperationResultInfoBaseValues() []ObjectTypeBasicOperationResultInfoBase {
	return []ObjectTypeBasicOperationResultInfoBase{ObjectTypeExportJobsOperationResultInfo, ObjectTypeOperationResultInfo, ObjectTypeOperationResultInfoBase}
}

// ObjectTypeBasicRecoveryPoint enumerates the values for object type basic recovery point.
type ObjectTypeBasicRecoveryPoint string

const (
	// ObjectTypeAzureFileShareRecoveryPoint ...
	ObjectTypeAzureFileShareRecoveryPoint ObjectTypeBasicRecoveryPoint = "AzureFileShareRecoveryPoint"
	// ObjectTypeAzureWorkloadPointInTimeRecoveryPoint ...
	ObjectTypeAzureWorkloadPointInTimeRecoveryPoint ObjectTypeBasicRecoveryPoint = "AzureWorkloadPointInTimeRecoveryPoint"
	// ObjectTypeAzureWorkloadRecoveryPoint ...
	ObjectTypeAzureWorkloadRecoveryPoint ObjectTypeBasicRecoveryPoint = "AzureWorkloadRecoveryPoint"
	// ObjectTypeAzureWorkloadSAPHanaPointInTimeRecoveryPoint ...
	ObjectTypeAzureWorkloadSAPHanaPointInTimeRecoveryPoint ObjectTypeBasicRecoveryPoint = "AzureWorkloadSAPHanaPointInTimeRecoveryPoint"
	// ObjectTypeAzureWorkloadSAPHanaRecoveryPoint ...
	ObjectTypeAzureWorkloadSAPHanaRecoveryPoint ObjectTypeBasicRecoveryPoint = "AzureWorkloadSAPHanaRecoveryPoint"
	// ObjectTypeAzureWorkloadSQLPointInTimeRecoveryPoint ...
	ObjectTypeAzureWorkloadSQLPointInTimeRecoveryPoint ObjectTypeBasicRecoveryPoint = "AzureWorkloadSQLPointInTimeRecoveryPoint"
	// ObjectTypeAzureWorkloadSQLRecoveryPoint ...
	ObjectTypeAzureWorkloadSQLRecoveryPoint ObjectTypeBasicRecoveryPoint = "AzureWorkloadSQLRecoveryPoint"
	// ObjectTypeGenericRecoveryPoint ...
	ObjectTypeGenericRecoveryPoint ObjectTypeBasicRecoveryPoint = "GenericRecoveryPoint"
	// ObjectTypeIaasVMRecoveryPoint ...
	ObjectTypeIaasVMRecoveryPoint ObjectTypeBasicRecoveryPoint = "IaasVMRecoveryPoint"
	// ObjectTypeRecoveryPoint ...
	ObjectTypeRecoveryPoint ObjectTypeBasicRecoveryPoint = "RecoveryPoint"
)

// PossibleObjectTypeBasicRecoveryPointValues returns an array of possible values for the ObjectTypeBasicRecoveryPoint const type.
func PossibleObjectTypeBasicRecoveryPointValues() []ObjectTypeBasicRecoveryPoint {
	return []ObjectTypeBasicRecoveryPoint{ObjectTypeAzureFileShareRecoveryPoint, ObjectTypeAzureWorkloadPointInTimeRecoveryPoint, ObjectTypeAzureWorkloadRecoveryPoint, ObjectTypeAzureWorkloadSAPHanaPointInTimeRecoveryPoint, ObjectTypeAzureWorkloadSAPHanaRecoveryPoint, ObjectTypeAzureWorkloadSQLPointInTimeRecoveryPoint, ObjectTypeAzureWorkloadSQLRecoveryPoint, ObjectTypeGenericRecoveryPoint, ObjectTypeIaasVMRecoveryPoint, ObjectTypeRecoveryPoint}
}

// ObjectTypeBasicRequest enumerates the values for object type basic request.
type ObjectTypeBasicRequest string

const (
	// ObjectTypeAzureFileShareBackupRequest ...
	ObjectTypeAzureFileShareBackupRequest ObjectTypeBasicRequest = "AzureFileShareBackupRequest"
	// ObjectTypeAzureWorkloadBackupRequest ...
	ObjectTypeAzureWorkloadBackupRequest ObjectTypeBasicRequest = "AzureWorkloadBackupRequest"
	// ObjectTypeBackupRequest ...
	ObjectTypeBackupRequest ObjectTypeBasicRequest = "BackupRequest"
	// ObjectTypeIaasVMBackupRequest ...
	ObjectTypeIaasVMBackupRequest ObjectTypeBasicRequest = "IaasVMBackupRequest"
)

// PossibleObjectTypeBasicRequestValues returns an array of possible values for the ObjectTypeBasicRequest const type.
func PossibleObjectTypeBasicRequestValues() []ObjectTypeBasicRequest {
	return []ObjectTypeBasicRequest{ObjectTypeAzureFileShareBackupRequest, ObjectTypeAzureWorkloadBackupRequest, ObjectTypeBackupRequest, ObjectTypeIaasVMBackupRequest}
}

// ObjectTypeBasicRestoreRequest enumerates the values for object type basic restore request.
type ObjectTypeBasicRestoreRequest string

const (
	// ObjectTypeAzureFileShareRestoreRequest ...
	ObjectTypeAzureFileShareRestoreRequest ObjectTypeBasicRestoreRequest = "AzureFileShareRestoreRequest"
	// ObjectTypeAzureWorkloadPointInTimeRestoreRequest ...
	ObjectTypeAzureWorkloadPointInTimeRestoreRequest ObjectTypeBasicRestoreRequest = "AzureWorkloadPointInTimeRestoreRequest"
	// ObjectTypeAzureWorkloadRestoreRequest ...
	ObjectTypeAzureWorkloadRestoreRequest ObjectTypeBasicRestoreRequest = "AzureWorkloadRestoreRequest"
	// ObjectTypeAzureWorkloadSAPHanaPointInTimeRestoreRequest ...
	ObjectTypeAzureWorkloadSAPHanaPointInTimeRestoreRequest ObjectTypeBasicRestoreRequest = "AzureWorkloadSAPHanaPointInTimeRestoreRequest"
	// ObjectTypeAzureWorkloadSAPHanaRestoreRequest ...
	ObjectTypeAzureWorkloadSAPHanaRestoreRequest ObjectTypeBasicRestoreRequest = "AzureWorkloadSAPHanaRestoreRequest"
	// ObjectTypeAzureWorkloadSQLPointInTimeRestoreRequest ...
	ObjectTypeAzureWorkloadSQLPointInTimeRestoreRequest ObjectTypeBasicRestoreRequest = "AzureWorkloadSQLPointInTimeRestoreRequest"
	// ObjectTypeAzureWorkloadSQLRestoreRequest ...
	ObjectTypeAzureWorkloadSQLRestoreRequest ObjectTypeBasicRestoreRequest = "AzureWorkloadSQLRestoreRequest"
	// ObjectTypeIaasVMRestoreRequest ...
	ObjectTypeIaasVMRestoreRequest ObjectTypeBasicRestoreRequest = "IaasVMRestoreRequest"
	// ObjectTypeRestoreRequest ...
	ObjectTypeRestoreRequest ObjectTypeBasicRestoreRequest = "RestoreRequest"
)

// PossibleObjectTypeBasicRestoreRequestValues returns an array of possible values for the ObjectTypeBasicRestoreRequest const type.
func PossibleObjectTypeBasicRestoreRequestValues() []ObjectTypeBasicRestoreRequest {
	return []ObjectTypeBasicRestoreRequest{ObjectTypeAzureFileShareRestoreRequest, ObjectTypeAzureWorkloadPointInTimeRestoreRequest, ObjectTypeAzureWorkloadRestoreRequest, ObjectTypeAzureWorkloadSAPHanaPointInTimeRestoreRequest, ObjectTypeAzureWorkloadSAPHanaRestoreRequest, ObjectTypeAzureWorkloadSQLPointInTimeRestoreRequest, ObjectTypeAzureWorkloadSQLRestoreRequest, ObjectTypeIaasVMRestoreRequest, ObjectTypeRestoreRequest}
}

// ObjectTypeBasicValidateOperationRequest enumerates the values for object type basic validate operation
// request.
type ObjectTypeBasicValidateOperationRequest string

const (
	// ObjectTypeValidateIaasVMRestoreOperationRequest ...
	ObjectTypeValidateIaasVMRestoreOperationRequest ObjectTypeBasicValidateOperationRequest = "ValidateIaasVMRestoreOperationRequest"
	// ObjectTypeValidateOperationRequest ...
	ObjectTypeValidateOperationRequest ObjectTypeBasicValidateOperationRequest = "ValidateOperationRequest"
	// ObjectTypeValidateRestoreOperationRequest ...
	ObjectTypeValidateRestoreOperationRequest ObjectTypeBasicValidateOperationRequest = "ValidateRestoreOperationRequest"
)

// PossibleObjectTypeBasicValidateOperationRequestValues returns an array of possible values for the ObjectTypeBasicValidateOperationRequest const type.
func PossibleObjectTypeBasicValidateOperationRequestValues() []ObjectTypeBasicValidateOperationRequest {
	return []ObjectTypeBasicValidateOperationRequest{ObjectTypeValidateIaasVMRestoreOperationRequest, ObjectTypeValidateOperationRequest, ObjectTypeValidateRestoreOperationRequest}
}

// OperationStatusValues enumerates the values for operation status values.
type OperationStatusValues string

const (
	// OperationStatusValuesCanceled ...
	OperationStatusValuesCanceled OperationStatusValues = "Canceled"
	// OperationStatusValuesFailed ...
	OperationStatusValuesFailed OperationStatusValues = "Failed"
	// OperationStatusValuesInProgress ...
	OperationStatusValuesInProgress OperationStatusValues = "InProgress"
	// OperationStatusValuesInvalid ...
	OperationStatusValuesInvalid OperationStatusValues = "Invalid"
	// OperationStatusValuesSucceeded ...
	OperationStatusValuesSucceeded OperationStatusValues = "Succeeded"
)

// PossibleOperationStatusValuesValues returns an array of possible values for the OperationStatusValues const type.
func PossibleOperationStatusValuesValues() []OperationStatusValues {
	return []OperationStatusValues{OperationStatusValuesCanceled, OperationStatusValuesFailed, OperationStatusValuesInProgress, OperationStatusValuesInvalid, OperationStatusValuesSucceeded}
}

// OperationType enumerates the values for operation type.
type OperationType string

const (
	// OperationTypeInvalid ...
	OperationTypeInvalid OperationType = "Invalid"
	// OperationTypeRegister ...
	OperationTypeRegister OperationType = "Register"
	// OperationTypeReregister ...
	OperationTypeReregister OperationType = "Reregister"
)

// PossibleOperationTypeValues returns an array of possible values for the OperationType const type.
func PossibleOperationTypeValues() []OperationType {
	return []OperationType{OperationTypeInvalid, OperationTypeRegister, OperationTypeReregister}
}

// OverwriteOptions enumerates the values for overwrite options.
type OverwriteOptions string

const (
	// OverwriteOptionsFailOnConflict ...
	OverwriteOptionsFailOnConflict OverwriteOptions = "FailOnConflict"
	// OverwriteOptionsInvalid ...
	OverwriteOptionsInvalid OverwriteOptions = "Invalid"
	// OverwriteOptionsOverwrite ...
	OverwriteOptionsOverwrite OverwriteOptions = "Overwrite"
)

// PossibleOverwriteOptionsValues returns an array of possible values for the OverwriteOptions const type.
func PossibleOverwriteOptionsValues() []OverwriteOptions {
	return []OverwriteOptions{OverwriteOptionsFailOnConflict, OverwriteOptionsInvalid, OverwriteOptionsOverwrite}
}

// PolicyType enumerates the values for policy type.
type PolicyType string

const (
	// PolicyTypeCopyOnlyFull ...
	PolicyTypeCopyOnlyFull PolicyType = "CopyOnlyFull"
	// PolicyTypeDifferential ...
	PolicyTypeDifferential PolicyType = "Differential"
	// PolicyTypeFull ...
	PolicyTypeFull PolicyType = "Full"
	// PolicyTypeInvalid ...
	PolicyTypeInvalid PolicyType = "Invalid"
	// PolicyTypeLog ...
	PolicyTypeLog PolicyType = "Log"
)

// PossiblePolicyTypeValues returns an array of possible values for the PolicyType const type.
func PossiblePolicyTypeValues() []PolicyType {
	return []PolicyType{PolicyTypeCopyOnlyFull, PolicyTypeDifferential, PolicyTypeFull, PolicyTypeInvalid, PolicyTypeLog}
}

// PrivateEndpointConnectionStatus enumerates the values for private endpoint connection status.
type PrivateEndpointConnectionStatus string

const (
	// Approved ...
	Approved PrivateEndpointConnectionStatus = "Approved"
	// Disconnected ...
	Disconnected PrivateEndpointConnectionStatus = "Disconnected"
	// Pending ...
	Pending PrivateEndpointConnectionStatus = "Pending"
	// Rejected ...
	Rejected PrivateEndpointConnectionStatus = "Rejected"
)

// PossiblePrivateEndpointConnectionStatusValues returns an array of possible values for the PrivateEndpointConnectionStatus const type.
func PossiblePrivateEndpointConnectionStatusValues() []PrivateEndpointConnectionStatus {
	return []PrivateEndpointConnectionStatus{Approved, Disconnected, Pending, Rejected}
}

// ProtectableContainerType enumerates the values for protectable container type.
type ProtectableContainerType string

const (
	// ProtectableContainerTypeProtectableContainer ...
	ProtectableContainerTypeProtectableContainer ProtectableContainerType = "ProtectableContainer"
	// ProtectableContainerTypeStorageContainer ...
	ProtectableContainerTypeStorageContainer ProtectableContainerType = "StorageContainer"
	// ProtectableContainerTypeVMAppContainer ...
	ProtectableContainerTypeVMAppContainer ProtectableContainerType = "VMAppContainer"
)

// PossibleProtectableContainerTypeValues returns an array of possible values for the ProtectableContainerType const type.
func PossibleProtectableContainerTypeValues() []ProtectableContainerType {
	return []ProtectableContainerType{ProtectableContainerTypeProtectableContainer, ProtectableContainerTypeStorageContainer, ProtectableContainerTypeVMAppContainer}
}

// ProtectableItemType enumerates the values for protectable item type.
type ProtectableItemType string

const (
	// ProtectableItemTypeAzureFileShare ...
	ProtectableItemTypeAzureFileShare ProtectableItemType = "AzureFileShare"
	// ProtectableItemTypeAzureVMWorkloadProtectableItem ...
	ProtectableItemTypeAzureVMWorkloadProtectableItem ProtectableItemType = "AzureVmWorkloadProtectableItem"
	// ProtectableItemTypeIaaSVMProtectableItem ...
	ProtectableItemTypeIaaSVMProtectableItem ProtectableItemType = "IaaSVMProtectableItem"
	// ProtectableItemTypeMicrosoftClassicComputevirtualMachines ...
	ProtectableItemTypeMicrosoftClassicComputevirtualMachines ProtectableItemType = "Microsoft.ClassicCompute/virtualMachines"
	// ProtectableItemTypeMicrosoftComputevirtualMachines ...
	ProtectableItemTypeMicrosoftComputevirtualMachines ProtectableItemType = "Microsoft.Compute/virtualMachines"
	// ProtectableItemTypeSAPAseSystem ...
	ProtectableItemTypeSAPAseSystem ProtectableItemType = "SAPAseSystem"
	// ProtectableItemTypeSAPHanaDatabase ...
	ProtectableItemTypeSAPHanaDatabase ProtectableItemType = "SAPHanaDatabase"
	// ProtectableItemTypeSAPHanaSystem ...
	ProtectableItemTypeSAPHanaSystem ProtectableItemType = "SAPHanaSystem"
	// ProtectableItemTypeSQLAvailabilityGroupContainer ...
	ProtectableItemTypeSQLAvailabilityGroupContainer ProtectableItemType = "SQLAvailabilityGroupContainer"
	// ProtectableItemTypeSQLDataBase ...
	ProtectableItemTypeSQLDataBase ProtectableItemType = "SQLDataBase"
	// ProtectableItemTypeSQLInstance ...
	ProtectableItemTypeSQLInstance ProtectableItemType = "SQLInstance"
	// ProtectableItemTypeWorkloadProtectableItem ...
	ProtectableItemTypeWorkloadProtectableItem ProtectableItemType = "WorkloadProtectableItem"
)

// PossibleProtectableItemTypeValues returns an array of possible values for the ProtectableItemType const type.
func PossibleProtectableItemTypeValues() []ProtectableItemType {
	return []ProtectableItemType{ProtectableItemTypeAzureFileShare, ProtectableItemTypeAzureVMWorkloadProtectableItem, ProtectableItemTypeIaaSVMProtectableItem, ProtectableItemTypeMicrosoftClassicComputevirtualMachines, ProtectableItemTypeMicrosoftComputevirtualMachines, ProtectableItemTypeSAPAseSystem, ProtectableItemTypeSAPHanaDatabase, ProtectableItemTypeSAPHanaSystem, ProtectableItemTypeSQLAvailabilityGroupContainer, ProtectableItemTypeSQLDataBase, ProtectableItemTypeSQLInstance, ProtectableItemTypeWorkloadProtectableItem}
}

// ProtectedItemHealthStatus enumerates the values for protected item health status.
type ProtectedItemHealthStatus string

const (
	// ProtectedItemHealthStatusHealthy ...
	ProtectedItemHealthStatusHealthy ProtectedItemHealthStatus = "Healthy"
	// ProtectedItemHealthStatusInvalid ...
	ProtectedItemHealthStatusInvalid ProtectedItemHealthStatus = "Invalid"
	// ProtectedItemHealthStatusIRPending ...
	ProtectedItemHealthStatusIRPending ProtectedItemHealthStatus = "IRPending"
	// ProtectedItemHealthStatusNotReachable ...
	ProtectedItemHealthStatusNotReachable ProtectedItemHealthStatus = "NotReachable"
	// ProtectedItemHealthStatusUnhealthy ...
	ProtectedItemHealthStatusUnhealthy ProtectedItemHealthStatus = "Unhealthy"
)

// PossibleProtectedItemHealthStatusValues returns an array of possible values for the ProtectedItemHealthStatus const type.
func PossibleProtectedItemHealthStatusValues() []ProtectedItemHealthStatus {
	return []ProtectedItemHealthStatus{ProtectedItemHealthStatusHealthy, ProtectedItemHealthStatusInvalid, ProtectedItemHealthStatusIRPending, ProtectedItemHealthStatusNotReachable, ProtectedItemHealthStatusUnhealthy}
}

// ProtectedItemState enumerates the values for protected item state.
type ProtectedItemState string

const (
	// ProtectedItemStateInvalid ...
	ProtectedItemStateInvalid ProtectedItemState = "Invalid"
	// ProtectedItemStateIRPending ...
	ProtectedItemStateIRPending ProtectedItemState = "IRPending"
	// ProtectedItemStateProtected ...
	ProtectedItemStateProtected ProtectedItemState = "Protected"
	// ProtectedItemStateProtectionError ...
	ProtectedItemStateProtectionError ProtectedItemState = "ProtectionError"
	// ProtectedItemStateProtectionPaused ...
	ProtectedItemStateProtectionPaused ProtectedItemState = "ProtectionPaused"
	// ProtectedItemStateProtectionStopped ...
	ProtectedItemStateProtectionStopped ProtectedItemState = "ProtectionStopped"
)

// PossibleProtectedItemStateValues returns an array of possible values for the ProtectedItemState const type.
func PossibleProtectedItemStateValues() []ProtectedItemState {
	return []ProtectedItemState{ProtectedItemStateInvalid, ProtectedItemStateIRPending, ProtectedItemStateProtected, ProtectedItemStateProtectionError, ProtectedItemStateProtectionPaused, ProtectedItemStateProtectionStopped}
}

// ProtectedItemType enumerates the values for protected item type.
type ProtectedItemType string

const (
	// ProtectedItemTypeAzureFileShareProtectedItem ...
	ProtectedItemTypeAzureFileShareProtectedItem ProtectedItemType = "AzureFileShareProtectedItem"
	// ProtectedItemTypeAzureIaaSVMProtectedItem ...
	ProtectedItemTypeAzureIaaSVMProtectedItem ProtectedItemType = "AzureIaaSVMProtectedItem"
	// ProtectedItemTypeAzureVMWorkloadProtectedItem ...
	ProtectedItemTypeAzureVMWorkloadProtectedItem ProtectedItemType = "AzureVmWorkloadProtectedItem"
	// ProtectedItemTypeAzureVMWorkloadSAPAseDatabase ...
	ProtectedItemTypeAzureVMWorkloadSAPAseDatabase ProtectedItemType = "AzureVmWorkloadSAPAseDatabase"
	// ProtectedItemTypeAzureVMWorkloadSAPHanaDatabase ...
	ProtectedItemTypeAzureVMWorkloadSAPHanaDatabase ProtectedItemType = "AzureVmWorkloadSAPHanaDatabase"
	// ProtectedItemTypeAzureVMWorkloadSQLDatabase ...
	ProtectedItemTypeAzureVMWorkloadSQLDatabase ProtectedItemType = "AzureVmWorkloadSQLDatabase"
	// ProtectedItemTypeDPMProtectedItem ...
	ProtectedItemTypeDPMProtectedItem ProtectedItemType = "DPMProtectedItem"
	// ProtectedItemTypeGenericProtectedItem ...
	ProtectedItemTypeGenericProtectedItem ProtectedItemType = "GenericProtectedItem"
	// ProtectedItemTypeMabFileFolderProtectedItem ...
	ProtectedItemTypeMabFileFolderProtectedItem ProtectedItemType = "MabFileFolderProtectedItem"
	// ProtectedItemTypeMicrosoftClassicComputevirtualMachines ...
	ProtectedItemTypeMicrosoftClassicComputevirtualMachines ProtectedItemType = "Microsoft.ClassicCompute/virtualMachines"
	// ProtectedItemTypeMicrosoftComputevirtualMachines ...
	ProtectedItemTypeMicrosoftComputevirtualMachines ProtectedItemType = "Microsoft.Compute/virtualMachines"
	// ProtectedItemTypeMicrosoftSqlserversdatabases ...
	ProtectedItemTypeMicrosoftSqlserversdatabases ProtectedItemType = "Microsoft.Sql/servers/databases"
	// ProtectedItemTypeProtectedItem ...
	ProtectedItemTypeProtectedItem ProtectedItemType = "ProtectedItem"
)

// PossibleProtectedItemTypeValues returns an array of possible values for the ProtectedItemType const type.
func PossibleProtectedItemTypeValues() []ProtectedItemType {
	return []ProtectedItemType{ProtectedItemTypeAzureFileShareProtectedItem, ProtectedItemTypeAzureIaaSVMProtectedItem, ProtectedItemTypeAzureVMWorkloadProtectedItem, ProtectedItemTypeAzureVMWorkloadSAPAseDatabase, ProtectedItemTypeAzureVMWorkloadSAPHanaDatabase, ProtectedItemTypeAzureVMWorkloadSQLDatabase, ProtectedItemTypeDPMProtectedItem, ProtectedItemTypeGenericProtectedItem, ProtectedItemTypeMabFileFolderProtectedItem, ProtectedItemTypeMicrosoftClassicComputevirtualMachines, ProtectedItemTypeMicrosoftComputevirtualMachines, ProtectedItemTypeMicrosoftSqlserversdatabases, ProtectedItemTypeProtectedItem}
}

// ProtectionIntentItemType enumerates the values for protection intent item type.
type ProtectionIntentItemType string

const (
	// ProtectionIntentItemTypeAzureResourceItem ...
	ProtectionIntentItemTypeAzureResourceItem ProtectionIntentItemType = "AzureResourceItem"
	// ProtectionIntentItemTypeAzureWorkloadAutoProtectionIntent ...
	ProtectionIntentItemTypeAzureWorkloadAutoProtectionIntent ProtectionIntentItemType = "AzureWorkloadAutoProtectionIntent"
	// ProtectionIntentItemTypeAzureWorkloadSQLAutoProtectionIntent ...
	ProtectionIntentItemTypeAzureWorkloadSQLAutoProtectionIntent ProtectionIntentItemType = "AzureWorkloadSQLAutoProtectionIntent"
	// ProtectionIntentItemTypeProtectionIntent ...
	ProtectionIntentItemTypeProtectionIntent ProtectionIntentItemType = "ProtectionIntent"
	// ProtectionIntentItemTypeRecoveryServiceVaultItem ...
	ProtectionIntentItemTypeRecoveryServiceVaultItem ProtectionIntentItemType = "RecoveryServiceVaultItem"
)

// PossibleProtectionIntentItemTypeValues returns an array of possible values for the ProtectionIntentItemType const type.
func PossibleProtectionIntentItemTypeValues() []ProtectionIntentItemType {
	return []ProtectionIntentItemType{ProtectionIntentItemTypeAzureResourceItem, ProtectionIntentItemTypeAzureWorkloadAutoProtectionIntent, ProtectionIntentItemTypeAzureWorkloadSQLAutoProtectionIntent, ProtectionIntentItemTypeProtectionIntent, ProtectionIntentItemTypeRecoveryServiceVaultItem}
}

// ProtectionState enumerates the values for protection state.
type ProtectionState string

const (
	// ProtectionStateInvalid ...
	ProtectionStateInvalid ProtectionState = "Invalid"
	// ProtectionStateIRPending ...
	ProtectionStateIRPending ProtectionState = "IRPending"
	// ProtectionStateProtected ...
	ProtectionStateProtected ProtectionState = "Protected"
	// ProtectionStateProtectionError ...
	ProtectionStateProtectionError ProtectionState = "ProtectionError"
	// ProtectionStateProtectionPaused ...
	ProtectionStateProtectionPaused ProtectionState = "ProtectionPaused"
	// ProtectionStateProtectionStopped ...
	ProtectionStateProtectionStopped ProtectionState = "ProtectionStopped"
)

// PossibleProtectionStateValues returns an array of possible values for the ProtectionState const type.
func PossibleProtectionStateValues() []ProtectionState {
	return []ProtectionState{ProtectionStateInvalid, ProtectionStateIRPending, ProtectionStateProtected, ProtectionStateProtectionError, ProtectionStateProtectionPaused, ProtectionStateProtectionStopped}
}

// ProtectionStatus enumerates the values for protection status.
type ProtectionStatus string

const (
	// ProtectionStatusInvalid ...
	ProtectionStatusInvalid ProtectionStatus = "Invalid"
	// ProtectionStatusNotProtected ...
	ProtectionStatusNotProtected ProtectionStatus = "NotProtected"
	// ProtectionStatusProtected ...
	ProtectionStatusProtected ProtectionStatus = "Protected"
	// ProtectionStatusProtecting ...
	ProtectionStatusProtecting ProtectionStatus = "Protecting"
	// ProtectionStatusProtectionFailed ...
	ProtectionStatusProtectionFailed ProtectionStatus = "ProtectionFailed"
)

// PossibleProtectionStatusValues returns an array of possible values for the ProtectionStatus const type.
func PossibleProtectionStatusValues() []ProtectionStatus {
	return []ProtectionStatus{ProtectionStatusInvalid, ProtectionStatusNotProtected, ProtectionStatusProtected, ProtectionStatusProtecting, ProtectionStatusProtectionFailed}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// ProvisioningStateDeleting ...
	ProvisioningStateDeleting ProvisioningState = "Deleting"
	// ProvisioningStateFailed ...
	ProvisioningStateFailed ProvisioningState = "Failed"
	// ProvisioningStatePending ...
	ProvisioningStatePending ProvisioningState = "Pending"
	// ProvisioningStateSucceeded ...
	ProvisioningStateSucceeded ProvisioningState = "Succeeded"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{ProvisioningStateDeleting, ProvisioningStateFailed, ProvisioningStatePending, ProvisioningStateSucceeded}
}

// RecoveryMode enumerates the values for recovery mode.
type RecoveryMode string

const (
	// RecoveryModeFileRecovery ...
	RecoveryModeFileRecovery RecoveryMode = "FileRecovery"
	// RecoveryModeInvalid ...
	RecoveryModeInvalid RecoveryMode = "Invalid"
	// RecoveryModeWorkloadRecovery ...
	RecoveryModeWorkloadRecovery RecoveryMode = "WorkloadRecovery"
)

// PossibleRecoveryModeValues returns an array of possible values for the RecoveryMode const type.
func PossibleRecoveryModeValues() []RecoveryMode {
	return []RecoveryMode{RecoveryModeFileRecovery, RecoveryModeInvalid, RecoveryModeWorkloadRecovery}
}

// RecoveryPointTierStatus enumerates the values for recovery point tier status.
type RecoveryPointTierStatus string

const (
	// RecoveryPointTierStatusDeleted ...
	RecoveryPointTierStatusDeleted RecoveryPointTierStatus = "Deleted"
	// RecoveryPointTierStatusDisabled ...
	RecoveryPointTierStatusDisabled RecoveryPointTierStatus = "Disabled"
	// RecoveryPointTierStatusInvalid ...
	RecoveryPointTierStatusInvalid RecoveryPointTierStatus = "Invalid"
	// RecoveryPointTierStatusValid ...
	RecoveryPointTierStatusValid RecoveryPointTierStatus = "Valid"
)

// PossibleRecoveryPointTierStatusValues returns an array of possible values for the RecoveryPointTierStatus const type.
func PossibleRecoveryPointTierStatusValues() []RecoveryPointTierStatus {
	return []RecoveryPointTierStatus{RecoveryPointTierStatusDeleted, RecoveryPointTierStatusDisabled, RecoveryPointTierStatusInvalid, RecoveryPointTierStatusValid}
}

// RecoveryPointTierType enumerates the values for recovery point tier type.
type RecoveryPointTierType string

const (
	// RecoveryPointTierTypeHardenedRP ...
	RecoveryPointTierTypeHardenedRP RecoveryPointTierType = "HardenedRP"
	// RecoveryPointTierTypeInstantRP ...
	RecoveryPointTierTypeInstantRP RecoveryPointTierType = "InstantRP"
	// RecoveryPointTierTypeInvalid ...
	RecoveryPointTierTypeInvalid RecoveryPointTierType = "Invalid"
)

// PossibleRecoveryPointTierTypeValues returns an array of possible values for the RecoveryPointTierType const type.
func PossibleRecoveryPointTierTypeValues() []RecoveryPointTierType {
	return []RecoveryPointTierType{RecoveryPointTierTypeHardenedRP, RecoveryPointTierTypeInstantRP, RecoveryPointTierTypeInvalid}
}

// RecoveryType enumerates the values for recovery type.
type RecoveryType string

const (
	// RecoveryTypeAlternateLocation ...
	RecoveryTypeAlternateLocation RecoveryType = "AlternateLocation"
	// RecoveryTypeInvalid ...
	RecoveryTypeInvalid RecoveryType = "Invalid"
	// RecoveryTypeOffline ...
	RecoveryTypeOffline RecoveryType = "Offline"
	// RecoveryTypeOriginalLocation ...
	RecoveryTypeOriginalLocation RecoveryType = "OriginalLocation"
	// RecoveryTypeRestoreDisks ...
	RecoveryTypeRestoreDisks RecoveryType = "RestoreDisks"
)

// PossibleRecoveryTypeValues returns an array of possible values for the RecoveryType const type.
func PossibleRecoveryTypeValues() []RecoveryType {
	return []RecoveryType{RecoveryTypeAlternateLocation, RecoveryTypeInvalid, RecoveryTypeOffline, RecoveryTypeOriginalLocation, RecoveryTypeRestoreDisks}
}

// ResourceHealthStatus enumerates the values for resource health status.
type ResourceHealthStatus string

const (
	// ResourceHealthStatusHealthy ...
	ResourceHealthStatusHealthy ResourceHealthStatus = "Healthy"
	// ResourceHealthStatusInvalid ...
	ResourceHealthStatusInvalid ResourceHealthStatus = "Invalid"
	// ResourceHealthStatusPersistentDegraded ...
	ResourceHealthStatusPersistentDegraded ResourceHealthStatus = "PersistentDegraded"
	// ResourceHealthStatusPersistentUnhealthy ...
	ResourceHealthStatusPersistentUnhealthy ResourceHealthStatus = "PersistentUnhealthy"
	// ResourceHealthStatusTransientDegraded ...
	ResourceHealthStatusTransientDegraded ResourceHealthStatus = "TransientDegraded"
	// ResourceHealthStatusTransientUnhealthy ...
	ResourceHealthStatusTransientUnhealthy ResourceHealthStatus = "TransientUnhealthy"
)

// PossibleResourceHealthStatusValues returns an array of possible values for the ResourceHealthStatus const type.
func PossibleResourceHealthStatusValues() []ResourceHealthStatus {
	return []ResourceHealthStatus{ResourceHealthStatusHealthy, ResourceHealthStatusInvalid, ResourceHealthStatusPersistentDegraded, ResourceHealthStatusPersistentUnhealthy, ResourceHealthStatusTransientDegraded, ResourceHealthStatusTransientUnhealthy}
}

// RestorePointQueryType enumerates the values for restore point query type.
type RestorePointQueryType string

const (
	// RestorePointQueryTypeAll ...
	RestorePointQueryTypeAll RestorePointQueryType = "All"
	// RestorePointQueryTypeDifferential ...
	RestorePointQueryTypeDifferential RestorePointQueryType = "Differential"
	// RestorePointQueryTypeFull ...
	RestorePointQueryTypeFull RestorePointQueryType = "Full"
	// RestorePointQueryTypeFullAndDifferential ...
	RestorePointQueryTypeFullAndDifferential RestorePointQueryType = "FullAndDifferential"
	// RestorePointQueryTypeInvalid ...
	RestorePointQueryTypeInvalid RestorePointQueryType = "Invalid"
	// RestorePointQueryTypeLog ...
	RestorePointQueryTypeLog RestorePointQueryType = "Log"
)

// PossibleRestorePointQueryTypeValues returns an array of possible values for the RestorePointQueryType const type.
func PossibleRestorePointQueryTypeValues() []RestorePointQueryType {
	return []RestorePointQueryType{RestorePointQueryTypeAll, RestorePointQueryTypeDifferential, RestorePointQueryTypeFull, RestorePointQueryTypeFullAndDifferential, RestorePointQueryTypeInvalid, RestorePointQueryTypeLog}
}

// RestorePointType enumerates the values for restore point type.
type RestorePointType string

const (
	// RestorePointTypeDifferential ...
	RestorePointTypeDifferential RestorePointType = "Differential"
	// RestorePointTypeFull ...
	RestorePointTypeFull RestorePointType = "Full"
	// RestorePointTypeInvalid ...
	RestorePointTypeInvalid RestorePointType = "Invalid"
	// RestorePointTypeLog ...
	RestorePointTypeLog RestorePointType = "Log"
)

// PossibleRestorePointTypeValues returns an array of possible values for the RestorePointType const type.
func PossibleRestorePointTypeValues() []RestorePointType {
	return []RestorePointType{RestorePointTypeDifferential, RestorePointTypeFull, RestorePointTypeInvalid, RestorePointTypeLog}
}

// RestoreRequestType enumerates the values for restore request type.
type RestoreRequestType string

const (
	// RestoreRequestTypeFullShareRestore ...
	RestoreRequestTypeFullShareRestore RestoreRequestType = "FullShareRestore"
	// RestoreRequestTypeInvalid ...
	RestoreRequestTypeInvalid RestoreRequestType = "Invalid"
	// RestoreRequestTypeItemLevelRestore ...
	RestoreRequestTypeItemLevelRestore RestoreRequestType = "ItemLevelRestore"
)

// PossibleRestoreRequestTypeValues returns an array of possible values for the RestoreRequestType const type.
func PossibleRestoreRequestTypeValues() []RestoreRequestType {
	return []RestoreRequestType{RestoreRequestTypeFullShareRestore, RestoreRequestTypeInvalid, RestoreRequestTypeItemLevelRestore}
}

// RetentionDurationType enumerates the values for retention duration type.
type RetentionDurationType string

const (
	// RetentionDurationTypeDays ...
	RetentionDurationTypeDays RetentionDurationType = "Days"
	// RetentionDurationTypeInvalid ...
	RetentionDurationTypeInvalid RetentionDurationType = "Invalid"
	// RetentionDurationTypeMonths ...
	RetentionDurationTypeMonths RetentionDurationType = "Months"
	// RetentionDurationTypeWeeks ...
	RetentionDurationTypeWeeks RetentionDurationType = "Weeks"
	// RetentionDurationTypeYears ...
	RetentionDurationTypeYears RetentionDurationType = "Years"
)

// PossibleRetentionDurationTypeValues returns an array of possible values for the RetentionDurationType const type.
func PossibleRetentionDurationTypeValues() []RetentionDurationType {
	return []RetentionDurationType{RetentionDurationTypeDays, RetentionDurationTypeInvalid, RetentionDurationTypeMonths, RetentionDurationTypeWeeks, RetentionDurationTypeYears}
}

// RetentionPolicyType enumerates the values for retention policy type.
type RetentionPolicyType string

const (
	// RetentionPolicyTypeLongTermRetentionPolicy ...
	RetentionPolicyTypeLongTermRetentionPolicy RetentionPolicyType = "LongTermRetentionPolicy"
	// RetentionPolicyTypeRetentionPolicy ...
	RetentionPolicyTypeRetentionPolicy RetentionPolicyType = "RetentionPolicy"
	// RetentionPolicyTypeSimpleRetentionPolicy ...
	RetentionPolicyTypeSimpleRetentionPolicy RetentionPolicyType = "SimpleRetentionPolicy"
)

// PossibleRetentionPolicyTypeValues returns an array of possible values for the RetentionPolicyType const type.
func PossibleRetentionPolicyTypeValues() []RetentionPolicyType {
	return []RetentionPolicyType{RetentionPolicyTypeLongTermRetentionPolicy, RetentionPolicyTypeRetentionPolicy, RetentionPolicyTypeSimpleRetentionPolicy}
}

// RetentionScheduleFormat enumerates the values for retention schedule format.
type RetentionScheduleFormat string

const (
	// RetentionScheduleFormatDaily ...
	RetentionScheduleFormatDaily RetentionScheduleFormat = "Daily"
	// RetentionScheduleFormatInvalid ...
	RetentionScheduleFormatInvalid RetentionScheduleFormat = "Invalid"
	// RetentionScheduleFormatWeekly ...
	RetentionScheduleFormatWeekly RetentionScheduleFormat = "Weekly"
)

// PossibleRetentionScheduleFormatValues returns an array of possible values for the RetentionScheduleFormat const type.
func PossibleRetentionScheduleFormatValues() []RetentionScheduleFormat {
	return []RetentionScheduleFormat{RetentionScheduleFormatDaily, RetentionScheduleFormatInvalid, RetentionScheduleFormatWeekly}
}

// SchedulePolicyType enumerates the values for schedule policy type.
type SchedulePolicyType string

const (
	// SchedulePolicyTypeLogSchedulePolicy ...
	SchedulePolicyTypeLogSchedulePolicy SchedulePolicyType = "LogSchedulePolicy"
	// SchedulePolicyTypeLongTermSchedulePolicy ...
	SchedulePolicyTypeLongTermSchedulePolicy SchedulePolicyType = "LongTermSchedulePolicy"
	// SchedulePolicyTypeSchedulePolicy ...
	SchedulePolicyTypeSchedulePolicy SchedulePolicyType = "SchedulePolicy"
	// SchedulePolicyTypeSimpleSchedulePolicy ...
	SchedulePolicyTypeSimpleSchedulePolicy SchedulePolicyType = "SimpleSchedulePolicy"
)

// PossibleSchedulePolicyTypeValues returns an array of possible values for the SchedulePolicyType const type.
func PossibleSchedulePolicyTypeValues() []SchedulePolicyType {
	return []SchedulePolicyType{SchedulePolicyTypeLogSchedulePolicy, SchedulePolicyTypeLongTermSchedulePolicy, SchedulePolicyTypeSchedulePolicy, SchedulePolicyTypeSimpleSchedulePolicy}
}

// ScheduleRunType enumerates the values for schedule run type.
type ScheduleRunType string

const (
	// ScheduleRunTypeDaily ...
	ScheduleRunTypeDaily ScheduleRunType = "Daily"
	// ScheduleRunTypeInvalid ...
	ScheduleRunTypeInvalid ScheduleRunType = "Invalid"
	// ScheduleRunTypeWeekly ...
	ScheduleRunTypeWeekly ScheduleRunType = "Weekly"
)

// PossibleScheduleRunTypeValues returns an array of possible values for the ScheduleRunType const type.
func PossibleScheduleRunTypeValues() []ScheduleRunType {
	return []ScheduleRunType{ScheduleRunTypeDaily, ScheduleRunTypeInvalid, ScheduleRunTypeWeekly}
}

// SoftDeleteFeatureState enumerates the values for soft delete feature state.
type SoftDeleteFeatureState string

const (
	// SoftDeleteFeatureStateDisabled ...
	SoftDeleteFeatureStateDisabled SoftDeleteFeatureState = "Disabled"
	// SoftDeleteFeatureStateEnabled ...
	SoftDeleteFeatureStateEnabled SoftDeleteFeatureState = "Enabled"
	// SoftDeleteFeatureStateInvalid ...
	SoftDeleteFeatureStateInvalid SoftDeleteFeatureState = "Invalid"
)

// PossibleSoftDeleteFeatureStateValues returns an array of possible values for the SoftDeleteFeatureState const type.
func PossibleSoftDeleteFeatureStateValues() []SoftDeleteFeatureState {
	return []SoftDeleteFeatureState{SoftDeleteFeatureStateDisabled, SoftDeleteFeatureStateEnabled, SoftDeleteFeatureStateInvalid}
}

// SQLDataDirectoryType enumerates the values for sql data directory type.
type SQLDataDirectoryType string

const (
	// SQLDataDirectoryTypeData ...
	SQLDataDirectoryTypeData SQLDataDirectoryType = "Data"
	// SQLDataDirectoryTypeInvalid ...
	SQLDataDirectoryTypeInvalid SQLDataDirectoryType = "Invalid"
	// SQLDataDirectoryTypeLog ...
	SQLDataDirectoryTypeLog SQLDataDirectoryType = "Log"
)

// PossibleSQLDataDirectoryTypeValues returns an array of possible values for the SQLDataDirectoryType const type.
func PossibleSQLDataDirectoryTypeValues() []SQLDataDirectoryType {
	return []SQLDataDirectoryType{SQLDataDirectoryTypeData, SQLDataDirectoryTypeInvalid, SQLDataDirectoryTypeLog}
}

// StorageType enumerates the values for storage type.
type StorageType string

const (
	// StorageTypeGeoRedundant ...
	StorageTypeGeoRedundant StorageType = "GeoRedundant"
	// StorageTypeInvalid ...
	StorageTypeInvalid StorageType = "Invalid"
	// StorageTypeLocallyRedundant ...
	StorageTypeLocallyRedundant StorageType = "LocallyRedundant"
)

// PossibleStorageTypeValues returns an array of possible values for the StorageType const type.
func PossibleStorageTypeValues() []StorageType {
	return []StorageType{StorageTypeGeoRedundant, StorageTypeInvalid, StorageTypeLocallyRedundant}
}

// StorageTypeState enumerates the values for storage type state.
type StorageTypeState string

const (
	// StorageTypeStateInvalid ...
	StorageTypeStateInvalid StorageTypeState = "Invalid"
	// StorageTypeStateLocked ...
	StorageTypeStateLocked StorageTypeState = "Locked"
	// StorageTypeStateUnlocked ...
	StorageTypeStateUnlocked StorageTypeState = "Unlocked"
)

// PossibleStorageTypeStateValues returns an array of possible values for the StorageTypeState const type.
func PossibleStorageTypeStateValues() []StorageTypeState {
	return []StorageTypeState{StorageTypeStateInvalid, StorageTypeStateLocked, StorageTypeStateUnlocked}
}

// SupportStatus enumerates the values for support status.
type SupportStatus string

const (
	// SupportStatusDefaultOFF ...
	SupportStatusDefaultOFF SupportStatus = "DefaultOFF"
	// SupportStatusDefaultON ...
	SupportStatusDefaultON SupportStatus = "DefaultON"
	// SupportStatusInvalid ...
	SupportStatusInvalid SupportStatus = "Invalid"
	// SupportStatusNotSupported ...
	SupportStatusNotSupported SupportStatus = "NotSupported"
	// SupportStatusSupported ...
	SupportStatusSupported SupportStatus = "Supported"
)

// PossibleSupportStatusValues returns an array of possible values for the SupportStatus const type.
func PossibleSupportStatusValues() []SupportStatus {
	return []SupportStatus{SupportStatusDefaultOFF, SupportStatusDefaultON, SupportStatusInvalid, SupportStatusNotSupported, SupportStatusSupported}
}

// Type enumerates the values for type.
type Type string

const (
	// TypeBackupProtectedItemCountSummary ...
	TypeBackupProtectedItemCountSummary Type = "BackupProtectedItemCountSummary"
	// TypeBackupProtectionContainerCountSummary ...
	TypeBackupProtectionContainerCountSummary Type = "BackupProtectionContainerCountSummary"
	// TypeInvalid ...
	TypeInvalid Type = "Invalid"
)

// PossibleTypeValues returns an array of possible values for the Type const type.
func PossibleTypeValues() []Type {
	return []Type{TypeBackupProtectedItemCountSummary, TypeBackupProtectionContainerCountSummary, TypeInvalid}
}

// TypeEnum enumerates the values for type enum.
type TypeEnum string

const (
	// TypeEnumCopyOnlyFull ...
	TypeEnumCopyOnlyFull TypeEnum = "CopyOnlyFull"
	// TypeEnumDifferential ...
	TypeEnumDifferential TypeEnum = "Differential"
	// TypeEnumFull ...
	TypeEnumFull TypeEnum = "Full"
	// TypeEnumInvalid ...
	TypeEnumInvalid TypeEnum = "Invalid"
	// TypeEnumLog ...
	TypeEnumLog TypeEnum = "Log"
)

// PossibleTypeEnumValues returns an array of possible values for the TypeEnum const type.
func PossibleTypeEnumValues() []TypeEnum {
	return []TypeEnum{TypeEnumCopyOnlyFull, TypeEnumDifferential, TypeEnumFull, TypeEnumInvalid, TypeEnumLog}
}

// UsagesUnit enumerates the values for usages unit.
type UsagesUnit string

const (
	// Bytes ...
	Bytes UsagesUnit = "Bytes"
	// BytesPerSecond ...
	BytesPerSecond UsagesUnit = "BytesPerSecond"
	// Count ...
	Count UsagesUnit = "Count"
	// CountPerSecond ...
	CountPerSecond UsagesUnit = "CountPerSecond"
	// Percent ...
	Percent UsagesUnit = "Percent"
	// Seconds ...
	Seconds UsagesUnit = "Seconds"
)

// PossibleUsagesUnitValues returns an array of possible values for the UsagesUnit const type.
func PossibleUsagesUnitValues() []UsagesUnit {
	return []UsagesUnit{Bytes, BytesPerSecond, Count, CountPerSecond, Percent, Seconds}
}

// ValidationStatus enumerates the values for validation status.
type ValidationStatus string

const (
	// ValidationStatusFailed ...
	ValidationStatusFailed ValidationStatus = "Failed"
	// ValidationStatusInvalid ...
	ValidationStatusInvalid ValidationStatus = "Invalid"
	// ValidationStatusSucceeded ...
	ValidationStatusSucceeded ValidationStatus = "Succeeded"
)

// PossibleValidationStatusValues returns an array of possible values for the ValidationStatus const type.
func PossibleValidationStatusValues() []ValidationStatus {
	return []ValidationStatus{ValidationStatusFailed, ValidationStatusInvalid, ValidationStatusSucceeded}
}

// WeekOfMonth enumerates the values for week of month.
type WeekOfMonth string

const (
	// WeekOfMonthFirst ...
	WeekOfMonthFirst WeekOfMonth = "First"
	// WeekOfMonthFourth ...
	WeekOfMonthFourth WeekOfMonth = "Fourth"
	// WeekOfMonthInvalid ...
	WeekOfMonthInvalid WeekOfMonth = "Invalid"
	// WeekOfMonthLast ...
	WeekOfMonthLast WeekOfMonth = "Last"
	// WeekOfMonthSecond ...
	WeekOfMonthSecond WeekOfMonth = "Second"
	// WeekOfMonthThird ...
	WeekOfMonthThird WeekOfMonth = "Third"
)

// PossibleWeekOfMonthValues returns an array of possible values for the WeekOfMonth const type.
func PossibleWeekOfMonthValues() []WeekOfMonth {
	return []WeekOfMonth{WeekOfMonthFirst, WeekOfMonthFourth, WeekOfMonthInvalid, WeekOfMonthLast, WeekOfMonthSecond, WeekOfMonthThird}
}

// WorkloadItemType enumerates the values for workload item type.
type WorkloadItemType string

const (
	// WorkloadItemTypeInvalid ...
	WorkloadItemTypeInvalid WorkloadItemType = "Invalid"
	// WorkloadItemTypeSAPAseDatabase ...
	WorkloadItemTypeSAPAseDatabase WorkloadItemType = "SAPAseDatabase"
	// WorkloadItemTypeSAPAseSystem ...
	WorkloadItemTypeSAPAseSystem WorkloadItemType = "SAPAseSystem"
	// WorkloadItemTypeSAPHanaDatabase ...
	WorkloadItemTypeSAPHanaDatabase WorkloadItemType = "SAPHanaDatabase"
	// WorkloadItemTypeSAPHanaSystem ...
	WorkloadItemTypeSAPHanaSystem WorkloadItemType = "SAPHanaSystem"
	// WorkloadItemTypeSQLDataBase ...
	WorkloadItemTypeSQLDataBase WorkloadItemType = "SQLDataBase"
	// WorkloadItemTypeSQLInstance ...
	WorkloadItemTypeSQLInstance WorkloadItemType = "SQLInstance"
)

// PossibleWorkloadItemTypeValues returns an array of possible values for the WorkloadItemType const type.
func PossibleWorkloadItemTypeValues() []WorkloadItemType {
	return []WorkloadItemType{WorkloadItemTypeInvalid, WorkloadItemTypeSAPAseDatabase, WorkloadItemTypeSAPAseSystem, WorkloadItemTypeSAPHanaDatabase, WorkloadItemTypeSAPHanaSystem, WorkloadItemTypeSQLDataBase, WorkloadItemTypeSQLInstance}
}

// WorkloadItemTypeBasicWorkloadItem enumerates the values for workload item type basic workload item.
type WorkloadItemTypeBasicWorkloadItem string

const (
	// WorkloadItemTypeAzureVMWorkloadItem ...
	WorkloadItemTypeAzureVMWorkloadItem WorkloadItemTypeBasicWorkloadItem = "AzureVmWorkloadItem"
	// WorkloadItemTypeSAPAseDatabase1 ...
	WorkloadItemTypeSAPAseDatabase1 WorkloadItemTypeBasicWorkloadItem = "SAPAseDatabase"
	// WorkloadItemTypeSAPAseSystem1 ...
	WorkloadItemTypeSAPAseSystem1 WorkloadItemTypeBasicWorkloadItem = "SAPAseSystem"
	// WorkloadItemTypeSAPHanaDatabase1 ...
	WorkloadItemTypeSAPHanaDatabase1 WorkloadItemTypeBasicWorkloadItem = "SAPHanaDatabase"
	// WorkloadItemTypeSAPHanaSystem1 ...
	WorkloadItemTypeSAPHanaSystem1 WorkloadItemTypeBasicWorkloadItem = "SAPHanaSystem"
	// WorkloadItemTypeSQLDataBase1 ...
	WorkloadItemTypeSQLDataBase1 WorkloadItemTypeBasicWorkloadItem = "SQLDataBase"
	// WorkloadItemTypeSQLInstance1 ...
	WorkloadItemTypeSQLInstance1 WorkloadItemTypeBasicWorkloadItem = "SQLInstance"
	// WorkloadItemTypeWorkloadItem ...
	WorkloadItemTypeWorkloadItem WorkloadItemTypeBasicWorkloadItem = "WorkloadItem"
)

// PossibleWorkloadItemTypeBasicWorkloadItemValues returns an array of possible values for the WorkloadItemTypeBasicWorkloadItem const type.
func PossibleWorkloadItemTypeBasicWorkloadItemValues() []WorkloadItemTypeBasicWorkloadItem {
	return []WorkloadItemTypeBasicWorkloadItem{WorkloadItemTypeAzureVMWorkloadItem, WorkloadItemTypeSAPAseDatabase1, WorkloadItemTypeSAPAseSystem1, WorkloadItemTypeSAPHanaDatabase1, WorkloadItemTypeSAPHanaSystem1, WorkloadItemTypeSQLDataBase1, WorkloadItemTypeSQLInstance1, WorkloadItemTypeWorkloadItem}
}

// WorkloadType enumerates the values for workload type.
type WorkloadType string

const (
	// WorkloadTypeAzureFileShare ...
	WorkloadTypeAzureFileShare WorkloadType = "AzureFileShare"
	// WorkloadTypeAzureSQLDb ...
	WorkloadTypeAzureSQLDb WorkloadType = "AzureSqlDb"
	// WorkloadTypeClient ...
	WorkloadTypeClient WorkloadType = "Client"
	// WorkloadTypeExchange ...
	WorkloadTypeExchange WorkloadType = "Exchange"
	// WorkloadTypeFileFolder ...
	WorkloadTypeFileFolder WorkloadType = "FileFolder"
	// WorkloadTypeGenericDataSource ...
	WorkloadTypeGenericDataSource WorkloadType = "GenericDataSource"
	// WorkloadTypeInvalid ...
	WorkloadTypeInvalid WorkloadType = "Invalid"
	// WorkloadTypeSAPAseDatabase ...
	WorkloadTypeSAPAseDatabase WorkloadType = "SAPAseDatabase"
	// WorkloadTypeSAPHanaDatabase ...
	WorkloadTypeSAPHanaDatabase WorkloadType = "SAPHanaDatabase"
	// WorkloadTypeSharepoint ...
	WorkloadTypeSharepoint WorkloadType = "Sharepoint"
	// WorkloadTypeSQLDataBase ...
	WorkloadTypeSQLDataBase WorkloadType = "SQLDataBase"
	// WorkloadTypeSQLDB ...
	WorkloadTypeSQLDB WorkloadType = "SQLDB"
	// WorkloadTypeSystemState ...
	WorkloadTypeSystemState WorkloadType = "SystemState"
	// WorkloadTypeVM ...
	WorkloadTypeVM WorkloadType = "VM"
	// WorkloadTypeVMwareVM ...
	WorkloadTypeVMwareVM WorkloadType = "VMwareVM"
)

// PossibleWorkloadTypeValues returns an array of possible values for the WorkloadType const type.
func PossibleWorkloadTypeValues() []WorkloadType {
	return []WorkloadType{WorkloadTypeAzureFileShare, WorkloadTypeAzureSQLDb, WorkloadTypeClient, WorkloadTypeExchange, WorkloadTypeFileFolder, WorkloadTypeGenericDataSource, WorkloadTypeInvalid, WorkloadTypeSAPAseDatabase, WorkloadTypeSAPHanaDatabase, WorkloadTypeSharepoint, WorkloadTypeSQLDataBase, WorkloadTypeSQLDB, WorkloadTypeSystemState, WorkloadTypeVM, WorkloadTypeVMwareVM}
}
