// Package domain provides primitives to interact the openapi HTTP API.
//
// Code generated by github.com/deepmap/oapi-codegen DO NOT EDIT.
package domain

import (
	"bytes"
	"context"
	"encoding/json"
	"fmt"
	"github.com/deepmap/oapi-codegen/pkg/runtime"
	"gopkg.in/yaml.v2"
	"io"
	"io/ioutil"
	"net/http"
	"net/url"
	"strings"

	ihttp "github.com/influxdata/influxdb-client-go/v2/api/http"
)

// Client which conforms to the OpenAPI3 specification for this service.
type Client struct {
	service ihttp.Service
}

// Creates a new Client, with reasonable defaults
func NewClient(service ihttp.Service) *Client {
	// create a client with sane default values
	client := Client{
		service: service,
	}
	return &client
}

// The interface specification for the client above.
type ClientInterface interface {
	// GetRoutes request
	GetRoutes(ctx context.Context, params *GetRoutesParams) (*http.Response, error)

	// GetAuthorizations request
	GetAuthorizations(ctx context.Context, params *GetAuthorizationsParams) (*http.Response, error)

	// PostAuthorizations request  with any body
	PostAuthorizationsWithBody(ctx context.Context, params *PostAuthorizationsParams, contentType string, body io.Reader) (*http.Response, error)

	PostAuthorizations(ctx context.Context, params *PostAuthorizationsParams, body PostAuthorizationsJSONRequestBody) (*http.Response, error)

	// DeleteAuthorizationsID request
	DeleteAuthorizationsID(ctx context.Context, authID string, params *DeleteAuthorizationsIDParams) (*http.Response, error)

	// GetAuthorizationsID request
	GetAuthorizationsID(ctx context.Context, authID string, params *GetAuthorizationsIDParams) (*http.Response, error)

	// PatchAuthorizationsID request  with any body
	PatchAuthorizationsIDWithBody(ctx context.Context, authID string, params *PatchAuthorizationsIDParams, contentType string, body io.Reader) (*http.Response, error)

	PatchAuthorizationsID(ctx context.Context, authID string, params *PatchAuthorizationsIDParams, body PatchAuthorizationsIDJSONRequestBody) (*http.Response, error)

	// GetBuckets request
	GetBuckets(ctx context.Context, params *GetBucketsParams) (*http.Response, error)

	// PostBuckets request  with any body
	PostBucketsWithBody(ctx context.Context, params *PostBucketsParams, contentType string, body io.Reader) (*http.Response, error)

	PostBuckets(ctx context.Context, params *PostBucketsParams, body PostBucketsJSONRequestBody) (*http.Response, error)

	// DeleteBucketsID request
	DeleteBucketsID(ctx context.Context, bucketID string, params *DeleteBucketsIDParams) (*http.Response, error)

	// GetBucketsID request
	GetBucketsID(ctx context.Context, bucketID string, params *GetBucketsIDParams) (*http.Response, error)

	// PatchBucketsID request  with any body
	PatchBucketsIDWithBody(ctx context.Context, bucketID string, params *PatchBucketsIDParams, contentType string, body io.Reader) (*http.Response, error)

	PatchBucketsID(ctx context.Context, bucketID string, params *PatchBucketsIDParams, body PatchBucketsIDJSONRequestBody) (*http.Response, error)

	// GetBucketsIDLabels request
	GetBucketsIDLabels(ctx context.Context, bucketID string, params *GetBucketsIDLabelsParams) (*http.Response, error)

	// PostBucketsIDLabels request  with any body
	PostBucketsIDLabelsWithBody(ctx context.Context, bucketID string, params *PostBucketsIDLabelsParams, contentType string, body io.Reader) (*http.Response, error)

	PostBucketsIDLabels(ctx context.Context, bucketID string, params *PostBucketsIDLabelsParams, body PostBucketsIDLabelsJSONRequestBody) (*http.Response, error)

	// DeleteBucketsIDLabelsID request
	DeleteBucketsIDLabelsID(ctx context.Context, bucketID string, labelID string, params *DeleteBucketsIDLabelsIDParams) (*http.Response, error)

	// GetBucketsIDMembers request
	GetBucketsIDMembers(ctx context.Context, bucketID string, params *GetBucketsIDMembersParams) (*http.Response, error)

	// PostBucketsIDMembers request  with any body
	PostBucketsIDMembersWithBody(ctx context.Context, bucketID string, params *PostBucketsIDMembersParams, contentType string, body io.Reader) (*http.Response, error)

	PostBucketsIDMembers(ctx context.Context, bucketID string, params *PostBucketsIDMembersParams, body PostBucketsIDMembersJSONRequestBody) (*http.Response, error)

	// DeleteBucketsIDMembersID request
	DeleteBucketsIDMembersID(ctx context.Context, bucketID string, userID string, params *DeleteBucketsIDMembersIDParams) (*http.Response, error)

	// GetBucketsIDOwners request
	GetBucketsIDOwners(ctx context.Context, bucketID string, params *GetBucketsIDOwnersParams) (*http.Response, error)

	// PostBucketsIDOwners request  with any body
	PostBucketsIDOwnersWithBody(ctx context.Context, bucketID string, params *PostBucketsIDOwnersParams, contentType string, body io.Reader) (*http.Response, error)

	PostBucketsIDOwners(ctx context.Context, bucketID string, params *PostBucketsIDOwnersParams, body PostBucketsIDOwnersJSONRequestBody) (*http.Response, error)

	// DeleteBucketsIDOwnersID request
	DeleteBucketsIDOwnersID(ctx context.Context, bucketID string, userID string, params *DeleteBucketsIDOwnersIDParams) (*http.Response, error)

	// GetChecks request
	GetChecks(ctx context.Context, params *GetChecksParams) (*http.Response, error)

	// CreateCheck request  with any body
	CreateCheckWithBody(ctx context.Context, contentType string, body io.Reader) (*http.Response, error)

	CreateCheck(ctx context.Context, body CreateCheckJSONRequestBody) (*http.Response, error)

	// DeleteChecksID request
	DeleteChecksID(ctx context.Context, checkID string, params *DeleteChecksIDParams) (*http.Response, error)

	// GetChecksID request
	GetChecksID(ctx context.Context, checkID string, params *GetChecksIDParams) (*http.Response, error)

	// PatchChecksID request  with any body
	PatchChecksIDWithBody(ctx context.Context, checkID string, params *PatchChecksIDParams, contentType string, body io.Reader) (*http.Response, error)

	PatchChecksID(ctx context.Context, checkID string, params *PatchChecksIDParams, body PatchChecksIDJSONRequestBody) (*http.Response, error)

	// PutChecksID request  with any body
	PutChecksIDWithBody(ctx context.Context, checkID string, params *PutChecksIDParams, contentType string, body io.Reader) (*http.Response, error)

	PutChecksID(ctx context.Context, checkID string, params *PutChecksIDParams, body PutChecksIDJSONRequestBody) (*http.Response, error)

	// GetChecksIDLabels request
	GetChecksIDLabels(ctx context.Context, checkID string, params *GetChecksIDLabelsParams) (*http.Response, error)

	// PostChecksIDLabels request  with any body
	PostChecksIDLabelsWithBody(ctx context.Context, checkID string, params *PostChecksIDLabelsParams, contentType string, body io.Reader) (*http.Response, error)

	PostChecksIDLabels(ctx context.Context, checkID string, params *PostChecksIDLabelsParams, body PostChecksIDLabelsJSONRequestBody) (*http.Response, error)

	// DeleteChecksIDLabelsID request
	DeleteChecksIDLabelsID(ctx context.Context, checkID string, labelID string, params *DeleteChecksIDLabelsIDParams) (*http.Response, error)

	// GetChecksIDQuery request
	GetChecksIDQuery(ctx context.Context, checkID string, params *GetChecksIDQueryParams) (*http.Response, error)

	// GetDashboards request
	GetDashboards(ctx context.Context, params *GetDashboardsParams) (*http.Response, error)

	// PostDashboards request  with any body
	PostDashboardsWithBody(ctx context.Context, params *PostDashboardsParams, contentType string, body io.Reader) (*http.Response, error)

	PostDashboards(ctx context.Context, params *PostDashboardsParams, body PostDashboardsJSONRequestBody) (*http.Response, error)

	// DeleteDashboardsID request
	DeleteDashboardsID(ctx context.Context, dashboardID string, params *DeleteDashboardsIDParams) (*http.Response, error)

	// GetDashboardsID request
	GetDashboardsID(ctx context.Context, dashboardID string, params *GetDashboardsIDParams) (*http.Response, error)

	// PatchDashboardsID request  with any body
	PatchDashboardsIDWithBody(ctx context.Context, dashboardID string, params *PatchDashboardsIDParams, contentType string, body io.Reader) (*http.Response, error)

	PatchDashboardsID(ctx context.Context, dashboardID string, params *PatchDashboardsIDParams, body PatchDashboardsIDJSONRequestBody) (*http.Response, error)

	// PostDashboardsIDCells request  with any body
	PostDashboardsIDCellsWithBody(ctx context.Context, dashboardID string, params *PostDashboardsIDCellsParams, contentType string, body io.Reader) (*http.Response, error)

	PostDashboardsIDCells(ctx context.Context, dashboardID string, params *PostDashboardsIDCellsParams, body PostDashboardsIDCellsJSONRequestBody) (*http.Response, error)

	// PutDashboardsIDCells request  with any body
	PutDashboardsIDCellsWithBody(ctx context.Context, dashboardID string, params *PutDashboardsIDCellsParams, contentType string, body io.Reader) (*http.Response, error)

	PutDashboardsIDCells(ctx context.Context, dashboardID string, params *PutDashboardsIDCellsParams, body PutDashboardsIDCellsJSONRequestBody) (*http.Response, error)

	// DeleteDashboardsIDCellsID request
	DeleteDashboardsIDCellsID(ctx context.Context, dashboardID string, cellID string, params *DeleteDashboardsIDCellsIDParams) (*http.Response, error)

	// PatchDashboardsIDCellsID request  with any body
	PatchDashboardsIDCellsIDWithBody(ctx context.Context, dashboardID string, cellID string, params *PatchDashboardsIDCellsIDParams, contentType string, body io.Reader) (*http.Response, error)

	PatchDashboardsIDCellsID(ctx context.Context, dashboardID string, cellID string, params *PatchDashboardsIDCellsIDParams, body PatchDashboardsIDCellsIDJSONRequestBody) (*http.Response, error)

	// GetDashboardsIDCellsIDView request
	GetDashboardsIDCellsIDView(ctx context.Context, dashboardID string, cellID string, params *GetDashboardsIDCellsIDViewParams) (*http.Response, error)

	// PatchDashboardsIDCellsIDView request  with any body
	PatchDashboardsIDCellsIDViewWithBody(ctx context.Context, dashboardID string, cellID string, params *PatchDashboardsIDCellsIDViewParams, contentType string, body io.Reader) (*http.Response, error)

	PatchDashboardsIDCellsIDView(ctx context.Context, dashboardID string, cellID string, params *PatchDashboardsIDCellsIDViewParams, body PatchDashboardsIDCellsIDViewJSONRequestBody) (*http.Response, error)

	// GetDashboardsIDLabels request
	GetDashboardsIDLabels(ctx context.Context, dashboardID string, params *GetDashboardsIDLabelsParams) (*http.Response, error)

	// PostDashboardsIDLabels request  with any body
	PostDashboardsIDLabelsWithBody(ctx context.Context, dashboardID string, params *PostDashboardsIDLabelsParams, contentType string, body io.Reader) (*http.Response, error)

	PostDashboardsIDLabels(ctx context.Context, dashboardID string, params *PostDashboardsIDLabelsParams, body PostDashboardsIDLabelsJSONRequestBody) (*http.Response, error)

	// DeleteDashboardsIDLabelsID request
	DeleteDashboardsIDLabelsID(ctx context.Context, dashboardID string, labelID string, params *DeleteDashboardsIDLabelsIDParams) (*http.Response, error)

	// GetDashboardsIDMembers request
	GetDashboardsIDMembers(ctx context.Context, dashboardID string, params *GetDashboardsIDMembersParams) (*http.Response, error)

	// PostDashboardsIDMembers request  with any body
	PostDashboardsIDMembersWithBody(ctx context.Context, dashboardID string, params *PostDashboardsIDMembersParams, contentType string, body io.Reader) (*http.Response, error)

	PostDashboardsIDMembers(ctx context.Context, dashboardID string, params *PostDashboardsIDMembersParams, body PostDashboardsIDMembersJSONRequestBody) (*http.Response, error)

	// DeleteDashboardsIDMembersID request
	DeleteDashboardsIDMembersID(ctx context.Context, dashboardID string, userID string, params *DeleteDashboardsIDMembersIDParams) (*http.Response, error)

	// GetDashboardsIDOwners request
	GetDashboardsIDOwners(ctx context.Context, dashboardID string, params *GetDashboardsIDOwnersParams) (*http.Response, error)

	// PostDashboardsIDOwners request  with any body
	PostDashboardsIDOwnersWithBody(ctx context.Context, dashboardID string, params *PostDashboardsIDOwnersParams, contentType string, body io.Reader) (*http.Response, error)

	PostDashboardsIDOwners(ctx context.Context, dashboardID string, params *PostDashboardsIDOwnersParams, body PostDashboardsIDOwnersJSONRequestBody) (*http.Response, error)

	// DeleteDashboardsIDOwnersID request
	DeleteDashboardsIDOwnersID(ctx context.Context, dashboardID string, userID string, params *DeleteDashboardsIDOwnersIDParams) (*http.Response, error)

	// GetDBRPs request
	GetDBRPs(ctx context.Context, params *GetDBRPsParams) (*http.Response, error)

	// PostDBRP request  with any body
	PostDBRPWithBody(ctx context.Context, params *PostDBRPParams, contentType string, body io.Reader) (*http.Response, error)

	PostDBRP(ctx context.Context, params *PostDBRPParams, body PostDBRPJSONRequestBody) (*http.Response, error)

	// DeleteDBRPID request
	DeleteDBRPID(ctx context.Context, dbrpID string, params *DeleteDBRPIDParams) (*http.Response, error)

	// GetDBRPsID request
	GetDBRPsID(ctx context.Context, dbrpID string, params *GetDBRPsIDParams) (*http.Response, error)

	// PatchDBRPID request  with any body
	PatchDBRPIDWithBody(ctx context.Context, dbrpID string, params *PatchDBRPIDParams, contentType string, body io.Reader) (*http.Response, error)

	PatchDBRPID(ctx context.Context, dbrpID string, params *PatchDBRPIDParams, body PatchDBRPIDJSONRequestBody) (*http.Response, error)

	// PostDelete request  with any body
	PostDeleteWithBody(ctx context.Context, params *PostDeleteParams, contentType string, body io.Reader) (*http.Response, error)

	PostDelete(ctx context.Context, params *PostDeleteParams, body PostDeleteJSONRequestBody) (*http.Response, error)

	// GetDocumentsTemplates request
	GetDocumentsTemplates(ctx context.Context, params *GetDocumentsTemplatesParams) (*http.Response, error)

	// PostDocumentsTemplates request  with any body
	PostDocumentsTemplatesWithBody(ctx context.Context, params *PostDocumentsTemplatesParams, contentType string, body io.Reader) (*http.Response, error)

	PostDocumentsTemplates(ctx context.Context, params *PostDocumentsTemplatesParams, body PostDocumentsTemplatesJSONRequestBody) (*http.Response, error)

	// DeleteDocumentsTemplatesID request
	DeleteDocumentsTemplatesID(ctx context.Context, templateID string, params *DeleteDocumentsTemplatesIDParams) (*http.Response, error)

	// GetDocumentsTemplatesID request
	GetDocumentsTemplatesID(ctx context.Context, templateID string, params *GetDocumentsTemplatesIDParams) (*http.Response, error)

	// PutDocumentsTemplatesID request  with any body
	PutDocumentsTemplatesIDWithBody(ctx context.Context, templateID string, params *PutDocumentsTemplatesIDParams, contentType string, body io.Reader) (*http.Response, error)

	PutDocumentsTemplatesID(ctx context.Context, templateID string, params *PutDocumentsTemplatesIDParams, body PutDocumentsTemplatesIDJSONRequestBody) (*http.Response, error)

	// GetDocumentsTemplatesIDLabels request
	GetDocumentsTemplatesIDLabels(ctx context.Context, templateID string, params *GetDocumentsTemplatesIDLabelsParams) (*http.Response, error)

	// PostDocumentsTemplatesIDLabels request  with any body
	PostDocumentsTemplatesIDLabelsWithBody(ctx context.Context, templateID string, params *PostDocumentsTemplatesIDLabelsParams, contentType string, body io.Reader) (*http.Response, error)

	PostDocumentsTemplatesIDLabels(ctx context.Context, templateID string, params *PostDocumentsTemplatesIDLabelsParams, body PostDocumentsTemplatesIDLabelsJSONRequestBody) (*http.Response, error)

	// DeleteDocumentsTemplatesIDLabelsID request
	DeleteDocumentsTemplatesIDLabelsID(ctx context.Context, templateID string, labelID string, params *DeleteDocumentsTemplatesIDLabelsIDParams) (*http.Response, error)

	// GetFlags request
	GetFlags(ctx context.Context, params *GetFlagsParams) (*http.Response, error)

	// GetHealth request
	GetHealth(ctx context.Context, params *GetHealthParams) (*http.Response, error)

	// GetLabels request
	GetLabels(ctx context.Context, params *GetLabelsParams) (*http.Response, error)

	// PostLabels request  with any body
	PostLabelsWithBody(ctx context.Context, contentType string, body io.Reader) (*http.Response, error)

	PostLabels(ctx context.Context, body PostLabelsJSONRequestBody) (*http.Response, error)

	// DeleteLabelsID request
	DeleteLabelsID(ctx context.Context, labelID string, params *DeleteLabelsIDParams) (*http.Response, error)

	// GetLabelsID request
	GetLabelsID(ctx context.Context, labelID string, params *GetLabelsIDParams) (*http.Response, error)

	// PatchLabelsID request  with any body
	PatchLabelsIDWithBody(ctx context.Context, labelID string, params *PatchLabelsIDParams, contentType string, body io.Reader) (*http.Response, error)

	PatchLabelsID(ctx context.Context, labelID string, params *PatchLabelsIDParams, body PatchLabelsIDJSONRequestBody) (*http.Response, error)

	// GetMe request
	GetMe(ctx context.Context, params *GetMeParams) (*http.Response, error)

	// PutMePassword request  with any body
	PutMePasswordWithBody(ctx context.Context, params *PutMePasswordParams, contentType string, body io.Reader) (*http.Response, error)

	PutMePassword(ctx context.Context, params *PutMePasswordParams, body PutMePasswordJSONRequestBody) (*http.Response, error)

	// GetNotificationEndpoints request
	GetNotificationEndpoints(ctx context.Context, params *GetNotificationEndpointsParams) (*http.Response, error)

	// CreateNotificationEndpoint request  with any body
	CreateNotificationEndpointWithBody(ctx context.Context, contentType string, body io.Reader) (*http.Response, error)

	CreateNotificationEndpoint(ctx context.Context, body CreateNotificationEndpointJSONRequestBody) (*http.Response, error)

	// DeleteNotificationEndpointsID request
	DeleteNotificationEndpointsID(ctx context.Context, endpointID string, params *DeleteNotificationEndpointsIDParams) (*http.Response, error)

	// GetNotificationEndpointsID request
	GetNotificationEndpointsID(ctx context.Context, endpointID string, params *GetNotificationEndpointsIDParams) (*http.Response, error)

	// PatchNotificationEndpointsID request  with any body
	PatchNotificationEndpointsIDWithBody(ctx context.Context, endpointID string, params *PatchNotificationEndpointsIDParams, contentType string, body io.Reader) (*http.Response, error)

	PatchNotificationEndpointsID(ctx context.Context, endpointID string, params *PatchNotificationEndpointsIDParams, body PatchNotificationEndpointsIDJSONRequestBody) (*http.Response, error)

	// PutNotificationEndpointsID request  with any body
	PutNotificationEndpointsIDWithBody(ctx context.Context, endpointID string, params *PutNotificationEndpointsIDParams, contentType string, body io.Reader) (*http.Response, error)

	PutNotificationEndpointsID(ctx context.Context, endpointID string, params *PutNotificationEndpointsIDParams, body PutNotificationEndpointsIDJSONRequestBody) (*http.Response, error)

	// GetNotificationEndpointsIDLabels request
	GetNotificationEndpointsIDLabels(ctx context.Context, endpointID string, params *GetNotificationEndpointsIDLabelsParams) (*http.Response, error)

	// PostNotificationEndpointIDLabels request  with any body
	PostNotificationEndpointIDLabelsWithBody(ctx context.Context, endpointID string, params *PostNotificationEndpointIDLabelsParams, contentType string, body io.Reader) (*http.Response, error)

	PostNotificationEndpointIDLabels(ctx context.Context, endpointID string, params *PostNotificationEndpointIDLabelsParams, body PostNotificationEndpointIDLabelsJSONRequestBody) (*http.Response, error)

	// DeleteNotificationEndpointsIDLabelsID request
	DeleteNotificationEndpointsIDLabelsID(ctx context.Context, endpointID string, labelID string, params *DeleteNotificationEndpointsIDLabelsIDParams) (*http.Response, error)

	// GetNotificationRules request
	GetNotificationRules(ctx context.Context, params *GetNotificationRulesParams) (*http.Response, error)

	// CreateNotificationRule request  with any body
	CreateNotificationRuleWithBody(ctx context.Context, contentType string, body io.Reader) (*http.Response, error)

	CreateNotificationRule(ctx context.Context, body CreateNotificationRuleJSONRequestBody) (*http.Response, error)

	// DeleteNotificationRulesID request
	DeleteNotificationRulesID(ctx context.Context, ruleID string, params *DeleteNotificationRulesIDParams) (*http.Response, error)

	// GetNotificationRulesID request
	GetNotificationRulesID(ctx context.Context, ruleID string, params *GetNotificationRulesIDParams) (*http.Response, error)

	// PatchNotificationRulesID request  with any body
	PatchNotificationRulesIDWithBody(ctx context.Context, ruleID string, params *PatchNotificationRulesIDParams, contentType string, body io.Reader) (*http.Response, error)

	PatchNotificationRulesID(ctx context.Context, ruleID string, params *PatchNotificationRulesIDParams, body PatchNotificationRulesIDJSONRequestBody) (*http.Response, error)

	// PutNotificationRulesID request  with any body
	PutNotificationRulesIDWithBody(ctx context.Context, ruleID string, params *PutNotificationRulesIDParams, contentType string, body io.Reader) (*http.Response, error)

	PutNotificationRulesID(ctx context.Context, ruleID string, params *PutNotificationRulesIDParams, body PutNotificationRulesIDJSONRequestBody) (*http.Response, error)

	// GetNotificationRulesIDLabels request
	GetNotificationRulesIDLabels(ctx context.Context, ruleID string, params *GetNotificationRulesIDLabelsParams) (*http.Response, error)

	// PostNotificationRuleIDLabels request  with any body
	PostNotificationRuleIDLabelsWithBody(ctx context.Context, ruleID string, params *PostNotificationRuleIDLabelsParams, contentType string, body io.Reader) (*http.Response, error)

	PostNotificationRuleIDLabels(ctx context.Context, ruleID string, params *PostNotificationRuleIDLabelsParams, body PostNotificationRuleIDLabelsJSONRequestBody) (*http.Response, error)

	// DeleteNotificationRulesIDLabelsID request
	DeleteNotificationRulesIDLabelsID(ctx context.Context, ruleID string, labelID string, params *DeleteNotificationRulesIDLabelsIDParams) (*http.Response, error)

	// GetNotificationRulesIDQuery request
	GetNotificationRulesIDQuery(ctx context.Context, ruleID string, params *GetNotificationRulesIDQueryParams) (*http.Response, error)

	// GetOrgs request
	GetOrgs(ctx context.Context, params *GetOrgsParams) (*http.Response, error)

	// PostOrgs request  with any body
	PostOrgsWithBody(ctx context.Context, params *PostOrgsParams, contentType string, body io.Reader) (*http.Response, error)

	PostOrgs(ctx context.Context, params *PostOrgsParams, body PostOrgsJSONRequestBody) (*http.Response, error)

	// DeleteOrgsID request
	DeleteOrgsID(ctx context.Context, orgID string, params *DeleteOrgsIDParams) (*http.Response, error)

	// GetOrgsID request
	GetOrgsID(ctx context.Context, orgID string, params *GetOrgsIDParams) (*http.Response, error)

	// PatchOrgsID request  with any body
	PatchOrgsIDWithBody(ctx context.Context, orgID string, params *PatchOrgsIDParams, contentType string, body io.Reader) (*http.Response, error)

	PatchOrgsID(ctx context.Context, orgID string, params *PatchOrgsIDParams, body PatchOrgsIDJSONRequestBody) (*http.Response, error)

	// GetOrgsIDMembers request
	GetOrgsIDMembers(ctx context.Context, orgID string, params *GetOrgsIDMembersParams) (*http.Response, error)

	// PostOrgsIDMembers request  with any body
	PostOrgsIDMembersWithBody(ctx context.Context, orgID string, params *PostOrgsIDMembersParams, contentType string, body io.Reader) (*http.Response, error)

	PostOrgsIDMembers(ctx context.Context, orgID string, params *PostOrgsIDMembersParams, body PostOrgsIDMembersJSONRequestBody) (*http.Response, error)

	// DeleteOrgsIDMembersID request
	DeleteOrgsIDMembersID(ctx context.Context, orgID string, userID string, params *DeleteOrgsIDMembersIDParams) (*http.Response, error)

	// GetOrgsIDOwners request
	GetOrgsIDOwners(ctx context.Context, orgID string, params *GetOrgsIDOwnersParams) (*http.Response, error)

	// PostOrgsIDOwners request  with any body
	PostOrgsIDOwnersWithBody(ctx context.Context, orgID string, params *PostOrgsIDOwnersParams, contentType string, body io.Reader) (*http.Response, error)

	PostOrgsIDOwners(ctx context.Context, orgID string, params *PostOrgsIDOwnersParams, body PostOrgsIDOwnersJSONRequestBody) (*http.Response, error)

	// DeleteOrgsIDOwnersID request
	DeleteOrgsIDOwnersID(ctx context.Context, orgID string, userID string, params *DeleteOrgsIDOwnersIDParams) (*http.Response, error)

	// GetOrgsIDSecrets request
	GetOrgsIDSecrets(ctx context.Context, orgID string, params *GetOrgsIDSecretsParams) (*http.Response, error)

	// PatchOrgsIDSecrets request  with any body
	PatchOrgsIDSecretsWithBody(ctx context.Context, orgID string, params *PatchOrgsIDSecretsParams, contentType string, body io.Reader) (*http.Response, error)

	PatchOrgsIDSecrets(ctx context.Context, orgID string, params *PatchOrgsIDSecretsParams, body PatchOrgsIDSecretsJSONRequestBody) (*http.Response, error)

	// PostOrgsIDSecrets request  with any body
	PostOrgsIDSecretsWithBody(ctx context.Context, orgID string, params *PostOrgsIDSecretsParams, contentType string, body io.Reader) (*http.Response, error)

	PostOrgsIDSecrets(ctx context.Context, orgID string, params *PostOrgsIDSecretsParams, body PostOrgsIDSecretsJSONRequestBody) (*http.Response, error)

	// PostQuery request  with any body
	PostQueryWithBody(ctx context.Context, params *PostQueryParams, contentType string, body io.Reader) (*http.Response, error)

	PostQuery(ctx context.Context, params *PostQueryParams, body PostQueryJSONRequestBody) (*http.Response, error)

	// PostQueryAnalyze request  with any body
	PostQueryAnalyzeWithBody(ctx context.Context, params *PostQueryAnalyzeParams, contentType string, body io.Reader) (*http.Response, error)

	PostQueryAnalyze(ctx context.Context, params *PostQueryAnalyzeParams, body PostQueryAnalyzeJSONRequestBody) (*http.Response, error)

	// PostQueryAst request  with any body
	PostQueryAstWithBody(ctx context.Context, params *PostQueryAstParams, contentType string, body io.Reader) (*http.Response, error)

	PostQueryAst(ctx context.Context, params *PostQueryAstParams, body PostQueryAstJSONRequestBody) (*http.Response, error)

	// GetQuerySuggestions request
	GetQuerySuggestions(ctx context.Context, params *GetQuerySuggestionsParams) (*http.Response, error)

	// GetQuerySuggestionsName request
	GetQuerySuggestionsName(ctx context.Context, name string, params *GetQuerySuggestionsNameParams) (*http.Response, error)

	// GetReady request
	GetReady(ctx context.Context, params *GetReadyParams) (*http.Response, error)

	// GetScrapers request
	GetScrapers(ctx context.Context, params *GetScrapersParams) (*http.Response, error)

	// PostScrapers request  with any body
	PostScrapersWithBody(ctx context.Context, params *PostScrapersParams, contentType string, body io.Reader) (*http.Response, error)

	PostScrapers(ctx context.Context, params *PostScrapersParams, body PostScrapersJSONRequestBody) (*http.Response, error)

	// DeleteScrapersID request
	DeleteScrapersID(ctx context.Context, scraperTargetID string, params *DeleteScrapersIDParams) (*http.Response, error)

	// GetScrapersID request
	GetScrapersID(ctx context.Context, scraperTargetID string, params *GetScrapersIDParams) (*http.Response, error)

	// PatchScrapersID request  with any body
	PatchScrapersIDWithBody(ctx context.Context, scraperTargetID string, params *PatchScrapersIDParams, contentType string, body io.Reader) (*http.Response, error)

	PatchScrapersID(ctx context.Context, scraperTargetID string, params *PatchScrapersIDParams, body PatchScrapersIDJSONRequestBody) (*http.Response, error)

	// GetScrapersIDLabels request
	GetScrapersIDLabels(ctx context.Context, scraperTargetID string, params *GetScrapersIDLabelsParams) (*http.Response, error)

	// PostScrapersIDLabels request  with any body
	PostScrapersIDLabelsWithBody(ctx context.Context, scraperTargetID string, params *PostScrapersIDLabelsParams, contentType string, body io.Reader) (*http.Response, error)

	PostScrapersIDLabels(ctx context.Context, scraperTargetID string, params *PostScrapersIDLabelsParams, body PostScrapersIDLabelsJSONRequestBody) (*http.Response, error)

	// DeleteScrapersIDLabelsID request
	DeleteScrapersIDLabelsID(ctx context.Context, scraperTargetID string, labelID string, params *DeleteScrapersIDLabelsIDParams) (*http.Response, error)

	// PatchScrapersIDLabelsID request  with any body
	PatchScrapersIDLabelsIDWithBody(ctx context.Context, scraperTargetID string, labelID string, params *PatchScrapersIDLabelsIDParams, contentType string, body io.Reader) (*http.Response, error)

	PatchScrapersIDLabelsID(ctx context.Context, scraperTargetID string, labelID string, params *PatchScrapersIDLabelsIDParams, body PatchScrapersIDLabelsIDJSONRequestBody) (*http.Response, error)

	// GetScrapersIDMembers request
	GetScrapersIDMembers(ctx context.Context, scraperTargetID string, params *GetScrapersIDMembersParams) (*http.Response, error)

	// PostScrapersIDMembers request  with any body
	PostScrapersIDMembersWithBody(ctx context.Context, scraperTargetID string, params *PostScrapersIDMembersParams, contentType string, body io.Reader) (*http.Response, error)

	PostScrapersIDMembers(ctx context.Context, scraperTargetID string, params *PostScrapersIDMembersParams, body PostScrapersIDMembersJSONRequestBody) (*http.Response, error)

	// DeleteScrapersIDMembersID request
	DeleteScrapersIDMembersID(ctx context.Context, scraperTargetID string, userID string, params *DeleteScrapersIDMembersIDParams) (*http.Response, error)

	// GetScrapersIDOwners request
	GetScrapersIDOwners(ctx context.Context, scraperTargetID string, params *GetScrapersIDOwnersParams) (*http.Response, error)

	// PostScrapersIDOwners request  with any body
	PostScrapersIDOwnersWithBody(ctx context.Context, scraperTargetID string, params *PostScrapersIDOwnersParams, contentType string, body io.Reader) (*http.Response, error)

	PostScrapersIDOwners(ctx context.Context, scraperTargetID string, params *PostScrapersIDOwnersParams, body PostScrapersIDOwnersJSONRequestBody) (*http.Response, error)

	// DeleteScrapersIDOwnersID request
	DeleteScrapersIDOwnersID(ctx context.Context, scraperTargetID string, userID string, params *DeleteScrapersIDOwnersIDParams) (*http.Response, error)

	// GetSetup request
	GetSetup(ctx context.Context, params *GetSetupParams) (*http.Response, error)

	// PostSetup request  with any body
	PostSetupWithBody(ctx context.Context, params *PostSetupParams, contentType string, body io.Reader) (*http.Response, error)

	PostSetup(ctx context.Context, params *PostSetupParams, body PostSetupJSONRequestBody) (*http.Response, error)

	// PostSetupUser request  with any body
	PostSetupUserWithBody(ctx context.Context, params *PostSetupUserParams, contentType string, body io.Reader) (*http.Response, error)

	PostSetupUser(ctx context.Context, params *PostSetupUserParams, body PostSetupUserJSONRequestBody) (*http.Response, error)

	// PostSignin request
	PostSignin(ctx context.Context, params *PostSigninParams) (*http.Response, error)

	// PostSignout request
	PostSignout(ctx context.Context, params *PostSignoutParams) (*http.Response, error)

	// GetSources request
	GetSources(ctx context.Context, params *GetSourcesParams) (*http.Response, error)

	// PostSources request  with any body
	PostSourcesWithBody(ctx context.Context, params *PostSourcesParams, contentType string, body io.Reader) (*http.Response, error)

	PostSources(ctx context.Context, params *PostSourcesParams, body PostSourcesJSONRequestBody) (*http.Response, error)

	// DeleteSourcesID request
	DeleteSourcesID(ctx context.Context, sourceID string, params *DeleteSourcesIDParams) (*http.Response, error)

	// GetSourcesID request
	GetSourcesID(ctx context.Context, sourceID string, params *GetSourcesIDParams) (*http.Response, error)

	// PatchSourcesID request  with any body
	PatchSourcesIDWithBody(ctx context.Context, sourceID string, params *PatchSourcesIDParams, contentType string, body io.Reader) (*http.Response, error)

	PatchSourcesID(ctx context.Context, sourceID string, params *PatchSourcesIDParams, body PatchSourcesIDJSONRequestBody) (*http.Response, error)

	// GetSourcesIDBuckets request
	GetSourcesIDBuckets(ctx context.Context, sourceID string, params *GetSourcesIDBucketsParams) (*http.Response, error)

	// GetSourcesIDHealth request
	GetSourcesIDHealth(ctx context.Context, sourceID string, params *GetSourcesIDHealthParams) (*http.Response, error)

	// ListStacks request
	ListStacks(ctx context.Context, params *ListStacksParams) (*http.Response, error)

	// CreateStack request  with any body
	CreateStackWithBody(ctx context.Context, contentType string, body io.Reader) (*http.Response, error)

	CreateStack(ctx context.Context, body CreateStackJSONRequestBody) (*http.Response, error)

	// DeleteStack request
	DeleteStack(ctx context.Context, stackId string, params *DeleteStackParams) (*http.Response, error)

	// ReadStack request
	ReadStack(ctx context.Context, stackId string) (*http.Response, error)

	// UpdateStack request  with any body
	UpdateStackWithBody(ctx context.Context, stackId string, contentType string, body io.Reader) (*http.Response, error)

	UpdateStack(ctx context.Context, stackId string, body UpdateStackJSONRequestBody) (*http.Response, error)

	// UninstallStack request
	UninstallStack(ctx context.Context, stackId string) (*http.Response, error)

	// GetTasks request
	GetTasks(ctx context.Context, params *GetTasksParams) (*http.Response, error)

	// PostTasks request  with any body
	PostTasksWithBody(ctx context.Context, params *PostTasksParams, contentType string, body io.Reader) (*http.Response, error)

	PostTasks(ctx context.Context, params *PostTasksParams, body PostTasksJSONRequestBody) (*http.Response, error)

	// DeleteTasksID request
	DeleteTasksID(ctx context.Context, taskID string, params *DeleteTasksIDParams) (*http.Response, error)

	// GetTasksID request
	GetTasksID(ctx context.Context, taskID string, params *GetTasksIDParams) (*http.Response, error)

	// PatchTasksID request  with any body
	PatchTasksIDWithBody(ctx context.Context, taskID string, params *PatchTasksIDParams, contentType string, body io.Reader) (*http.Response, error)

	PatchTasksID(ctx context.Context, taskID string, params *PatchTasksIDParams, body PatchTasksIDJSONRequestBody) (*http.Response, error)

	// GetTasksIDLabels request
	GetTasksIDLabels(ctx context.Context, taskID string, params *GetTasksIDLabelsParams) (*http.Response, error)

	// PostTasksIDLabels request  with any body
	PostTasksIDLabelsWithBody(ctx context.Context, taskID string, params *PostTasksIDLabelsParams, contentType string, body io.Reader) (*http.Response, error)

	PostTasksIDLabels(ctx context.Context, taskID string, params *PostTasksIDLabelsParams, body PostTasksIDLabelsJSONRequestBody) (*http.Response, error)

	// DeleteTasksIDLabelsID request
	DeleteTasksIDLabelsID(ctx context.Context, taskID string, labelID string, params *DeleteTasksIDLabelsIDParams) (*http.Response, error)

	// GetTasksIDLogs request
	GetTasksIDLogs(ctx context.Context, taskID string, params *GetTasksIDLogsParams) (*http.Response, error)

	// GetTasksIDMembers request
	GetTasksIDMembers(ctx context.Context, taskID string, params *GetTasksIDMembersParams) (*http.Response, error)

	// PostTasksIDMembers request  with any body
	PostTasksIDMembersWithBody(ctx context.Context, taskID string, params *PostTasksIDMembersParams, contentType string, body io.Reader) (*http.Response, error)

	PostTasksIDMembers(ctx context.Context, taskID string, params *PostTasksIDMembersParams, body PostTasksIDMembersJSONRequestBody) (*http.Response, error)

	// DeleteTasksIDMembersID request
	DeleteTasksIDMembersID(ctx context.Context, taskID string, userID string, params *DeleteTasksIDMembersIDParams) (*http.Response, error)

	// GetTasksIDOwners request
	GetTasksIDOwners(ctx context.Context, taskID string, params *GetTasksIDOwnersParams) (*http.Response, error)

	// PostTasksIDOwners request  with any body
	PostTasksIDOwnersWithBody(ctx context.Context, taskID string, params *PostTasksIDOwnersParams, contentType string, body io.Reader) (*http.Response, error)

	PostTasksIDOwners(ctx context.Context, taskID string, params *PostTasksIDOwnersParams, body PostTasksIDOwnersJSONRequestBody) (*http.Response, error)

	// DeleteTasksIDOwnersID request
	DeleteTasksIDOwnersID(ctx context.Context, taskID string, userID string, params *DeleteTasksIDOwnersIDParams) (*http.Response, error)

	// GetTasksIDRuns request
	GetTasksIDRuns(ctx context.Context, taskID string, params *GetTasksIDRunsParams) (*http.Response, error)

	// PostTasksIDRuns request  with any body
	PostTasksIDRunsWithBody(ctx context.Context, taskID string, params *PostTasksIDRunsParams, contentType string, body io.Reader) (*http.Response, error)

	PostTasksIDRuns(ctx context.Context, taskID string, params *PostTasksIDRunsParams, body PostTasksIDRunsJSONRequestBody) (*http.Response, error)

	// DeleteTasksIDRunsID request
	DeleteTasksIDRunsID(ctx context.Context, taskID string, runID string, params *DeleteTasksIDRunsIDParams) (*http.Response, error)

	// GetTasksIDRunsID request
	GetTasksIDRunsID(ctx context.Context, taskID string, runID string, params *GetTasksIDRunsIDParams) (*http.Response, error)

	// GetTasksIDRunsIDLogs request
	GetTasksIDRunsIDLogs(ctx context.Context, taskID string, runID string, params *GetTasksIDRunsIDLogsParams) (*http.Response, error)

	// PostTasksIDRunsIDRetry request
	PostTasksIDRunsIDRetry(ctx context.Context, taskID string, runID string, params *PostTasksIDRunsIDRetryParams) (*http.Response, error)

	// GetTelegrafPlugins request
	GetTelegrafPlugins(ctx context.Context, params *GetTelegrafPluginsParams) (*http.Response, error)

	// GetTelegrafs request
	GetTelegrafs(ctx context.Context, params *GetTelegrafsParams) (*http.Response, error)

	// PostTelegrafs request  with any body
	PostTelegrafsWithBody(ctx context.Context, params *PostTelegrafsParams, contentType string, body io.Reader) (*http.Response, error)

	PostTelegrafs(ctx context.Context, params *PostTelegrafsParams, body PostTelegrafsJSONRequestBody) (*http.Response, error)

	// DeleteTelegrafsID request
	DeleteTelegrafsID(ctx context.Context, telegrafID string, params *DeleteTelegrafsIDParams) (*http.Response, error)

	// GetTelegrafsID request
	GetTelegrafsID(ctx context.Context, telegrafID string, params *GetTelegrafsIDParams) (*http.Response, error)

	// PutTelegrafsID request  with any body
	PutTelegrafsIDWithBody(ctx context.Context, telegrafID string, params *PutTelegrafsIDParams, contentType string, body io.Reader) (*http.Response, error)

	PutTelegrafsID(ctx context.Context, telegrafID string, params *PutTelegrafsIDParams, body PutTelegrafsIDJSONRequestBody) (*http.Response, error)

	// GetTelegrafsIDLabels request
	GetTelegrafsIDLabels(ctx context.Context, telegrafID string, params *GetTelegrafsIDLabelsParams) (*http.Response, error)

	// PostTelegrafsIDLabels request  with any body
	PostTelegrafsIDLabelsWithBody(ctx context.Context, telegrafID string, params *PostTelegrafsIDLabelsParams, contentType string, body io.Reader) (*http.Response, error)

	PostTelegrafsIDLabels(ctx context.Context, telegrafID string, params *PostTelegrafsIDLabelsParams, body PostTelegrafsIDLabelsJSONRequestBody) (*http.Response, error)

	// DeleteTelegrafsIDLabelsID request
	DeleteTelegrafsIDLabelsID(ctx context.Context, telegrafID string, labelID string, params *DeleteTelegrafsIDLabelsIDParams) (*http.Response, error)

	// GetTelegrafsIDMembers request
	GetTelegrafsIDMembers(ctx context.Context, telegrafID string, params *GetTelegrafsIDMembersParams) (*http.Response, error)

	// PostTelegrafsIDMembers request  with any body
	PostTelegrafsIDMembersWithBody(ctx context.Context, telegrafID string, params *PostTelegrafsIDMembersParams, contentType string, body io.Reader) (*http.Response, error)

	PostTelegrafsIDMembers(ctx context.Context, telegrafID string, params *PostTelegrafsIDMembersParams, body PostTelegrafsIDMembersJSONRequestBody) (*http.Response, error)

	// DeleteTelegrafsIDMembersID request
	DeleteTelegrafsIDMembersID(ctx context.Context, telegrafID string, userID string, params *DeleteTelegrafsIDMembersIDParams) (*http.Response, error)

	// GetTelegrafsIDOwners request
	GetTelegrafsIDOwners(ctx context.Context, telegrafID string, params *GetTelegrafsIDOwnersParams) (*http.Response, error)

	// PostTelegrafsIDOwners request  with any body
	PostTelegrafsIDOwnersWithBody(ctx context.Context, telegrafID string, params *PostTelegrafsIDOwnersParams, contentType string, body io.Reader) (*http.Response, error)

	PostTelegrafsIDOwners(ctx context.Context, telegrafID string, params *PostTelegrafsIDOwnersParams, body PostTelegrafsIDOwnersJSONRequestBody) (*http.Response, error)

	// DeleteTelegrafsIDOwnersID request
	DeleteTelegrafsIDOwnersID(ctx context.Context, telegrafID string, userID string, params *DeleteTelegrafsIDOwnersIDParams) (*http.Response, error)

	// ApplyTemplate request  with any body
	ApplyTemplateWithBody(ctx context.Context, contentType string, body io.Reader) (*http.Response, error)

	ApplyTemplate(ctx context.Context, body ApplyTemplateJSONRequestBody) (*http.Response, error)

	// ExportTemplate request  with any body
	ExportTemplateWithBody(ctx context.Context, contentType string, body io.Reader) (*http.Response, error)

	ExportTemplate(ctx context.Context, body ExportTemplateJSONRequestBody) (*http.Response, error)

	// GetUsers request
	GetUsers(ctx context.Context, params *GetUsersParams) (*http.Response, error)

	// PostUsers request  with any body
	PostUsersWithBody(ctx context.Context, params *PostUsersParams, contentType string, body io.Reader) (*http.Response, error)

	PostUsers(ctx context.Context, params *PostUsersParams, body PostUsersJSONRequestBody) (*http.Response, error)

	// DeleteUsersID request
	DeleteUsersID(ctx context.Context, userID string, params *DeleteUsersIDParams) (*http.Response, error)

	// GetUsersID request
	GetUsersID(ctx context.Context, userID string, params *GetUsersIDParams) (*http.Response, error)

	// PatchUsersID request  with any body
	PatchUsersIDWithBody(ctx context.Context, userID string, params *PatchUsersIDParams, contentType string, body io.Reader) (*http.Response, error)

	PatchUsersID(ctx context.Context, userID string, params *PatchUsersIDParams, body PatchUsersIDJSONRequestBody) (*http.Response, error)

	// PostUsersIDPassword request  with any body
	PostUsersIDPasswordWithBody(ctx context.Context, userID string, params *PostUsersIDPasswordParams, contentType string, body io.Reader) (*http.Response, error)

	PostUsersIDPassword(ctx context.Context, userID string, params *PostUsersIDPasswordParams, body PostUsersIDPasswordJSONRequestBody) (*http.Response, error)

	// GetVariables request
	GetVariables(ctx context.Context, params *GetVariablesParams) (*http.Response, error)

	// PostVariables request  with any body
	PostVariablesWithBody(ctx context.Context, params *PostVariablesParams, contentType string, body io.Reader) (*http.Response, error)

	PostVariables(ctx context.Context, params *PostVariablesParams, body PostVariablesJSONRequestBody) (*http.Response, error)

	// DeleteVariablesID request
	DeleteVariablesID(ctx context.Context, variableID string, params *DeleteVariablesIDParams) (*http.Response, error)

	// GetVariablesID request
	GetVariablesID(ctx context.Context, variableID string, params *GetVariablesIDParams) (*http.Response, error)

	// PatchVariablesID request  with any body
	PatchVariablesIDWithBody(ctx context.Context, variableID string, params *PatchVariablesIDParams, contentType string, body io.Reader) (*http.Response, error)

	PatchVariablesID(ctx context.Context, variableID string, params *PatchVariablesIDParams, body PatchVariablesIDJSONRequestBody) (*http.Response, error)

	// PutVariablesID request  with any body
	PutVariablesIDWithBody(ctx context.Context, variableID string, params *PutVariablesIDParams, contentType string, body io.Reader) (*http.Response, error)

	PutVariablesID(ctx context.Context, variableID string, params *PutVariablesIDParams, body PutVariablesIDJSONRequestBody) (*http.Response, error)

	// GetVariablesIDLabels request
	GetVariablesIDLabels(ctx context.Context, variableID string, params *GetVariablesIDLabelsParams) (*http.Response, error)

	// PostVariablesIDLabels request  with any body
	PostVariablesIDLabelsWithBody(ctx context.Context, variableID string, params *PostVariablesIDLabelsParams, contentType string, body io.Reader) (*http.Response, error)

	PostVariablesIDLabels(ctx context.Context, variableID string, params *PostVariablesIDLabelsParams, body PostVariablesIDLabelsJSONRequestBody) (*http.Response, error)

	// DeleteVariablesIDLabelsID request
	DeleteVariablesIDLabelsID(ctx context.Context, variableID string, labelID string, params *DeleteVariablesIDLabelsIDParams) (*http.Response, error)

	// PostWrite request  with any body
	PostWriteWithBody(ctx context.Context, params *PostWriteParams, contentType string, body io.Reader) (*http.Response, error)
}

func (c *Client) GetRoutes(ctx context.Context, params *GetRoutesParams) (*http.Response, error) {
	req, err := NewGetRoutesRequest(c.service.ServerAPIURL(), params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetAuthorizations(ctx context.Context, params *GetAuthorizationsParams) (*http.Response, error) {
	req, err := NewGetAuthorizationsRequest(c.service.ServerAPIURL(), params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostAuthorizationsWithBody(ctx context.Context, params *PostAuthorizationsParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostAuthorizationsRequestWithBody(c.service.ServerAPIURL(), params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostAuthorizations(ctx context.Context, params *PostAuthorizationsParams, body PostAuthorizationsJSONRequestBody) (*http.Response, error) {
	req, err := NewPostAuthorizationsRequest(c.service.ServerAPIURL(), params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteAuthorizationsID(ctx context.Context, authID string, params *DeleteAuthorizationsIDParams) (*http.Response, error) {
	req, err := NewDeleteAuthorizationsIDRequest(c.service.ServerAPIURL(), authID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetAuthorizationsID(ctx context.Context, authID string, params *GetAuthorizationsIDParams) (*http.Response, error) {
	req, err := NewGetAuthorizationsIDRequest(c.service.ServerAPIURL(), authID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PatchAuthorizationsIDWithBody(ctx context.Context, authID string, params *PatchAuthorizationsIDParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPatchAuthorizationsIDRequestWithBody(c.service.ServerAPIURL(), authID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PatchAuthorizationsID(ctx context.Context, authID string, params *PatchAuthorizationsIDParams, body PatchAuthorizationsIDJSONRequestBody) (*http.Response, error) {
	req, err := NewPatchAuthorizationsIDRequest(c.service.ServerAPIURL(), authID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetBuckets(ctx context.Context, params *GetBucketsParams) (*http.Response, error) {
	req, err := NewGetBucketsRequest(c.service.ServerAPIURL(), params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostBucketsWithBody(ctx context.Context, params *PostBucketsParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostBucketsRequestWithBody(c.service.ServerAPIURL(), params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostBuckets(ctx context.Context, params *PostBucketsParams, body PostBucketsJSONRequestBody) (*http.Response, error) {
	req, err := NewPostBucketsRequest(c.service.ServerAPIURL(), params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteBucketsID(ctx context.Context, bucketID string, params *DeleteBucketsIDParams) (*http.Response, error) {
	req, err := NewDeleteBucketsIDRequest(c.service.ServerAPIURL(), bucketID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetBucketsID(ctx context.Context, bucketID string, params *GetBucketsIDParams) (*http.Response, error) {
	req, err := NewGetBucketsIDRequest(c.service.ServerAPIURL(), bucketID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PatchBucketsIDWithBody(ctx context.Context, bucketID string, params *PatchBucketsIDParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPatchBucketsIDRequestWithBody(c.service.ServerAPIURL(), bucketID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PatchBucketsID(ctx context.Context, bucketID string, params *PatchBucketsIDParams, body PatchBucketsIDJSONRequestBody) (*http.Response, error) {
	req, err := NewPatchBucketsIDRequest(c.service.ServerAPIURL(), bucketID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetBucketsIDLabels(ctx context.Context, bucketID string, params *GetBucketsIDLabelsParams) (*http.Response, error) {
	req, err := NewGetBucketsIDLabelsRequest(c.service.ServerAPIURL(), bucketID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostBucketsIDLabelsWithBody(ctx context.Context, bucketID string, params *PostBucketsIDLabelsParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostBucketsIDLabelsRequestWithBody(c.service.ServerAPIURL(), bucketID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostBucketsIDLabels(ctx context.Context, bucketID string, params *PostBucketsIDLabelsParams, body PostBucketsIDLabelsJSONRequestBody) (*http.Response, error) {
	req, err := NewPostBucketsIDLabelsRequest(c.service.ServerAPIURL(), bucketID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteBucketsIDLabelsID(ctx context.Context, bucketID string, labelID string, params *DeleteBucketsIDLabelsIDParams) (*http.Response, error) {
	req, err := NewDeleteBucketsIDLabelsIDRequest(c.service.ServerAPIURL(), bucketID, labelID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetBucketsIDMembers(ctx context.Context, bucketID string, params *GetBucketsIDMembersParams) (*http.Response, error) {
	req, err := NewGetBucketsIDMembersRequest(c.service.ServerAPIURL(), bucketID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostBucketsIDMembersWithBody(ctx context.Context, bucketID string, params *PostBucketsIDMembersParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostBucketsIDMembersRequestWithBody(c.service.ServerAPIURL(), bucketID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostBucketsIDMembers(ctx context.Context, bucketID string, params *PostBucketsIDMembersParams, body PostBucketsIDMembersJSONRequestBody) (*http.Response, error) {
	req, err := NewPostBucketsIDMembersRequest(c.service.ServerAPIURL(), bucketID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteBucketsIDMembersID(ctx context.Context, bucketID string, userID string, params *DeleteBucketsIDMembersIDParams) (*http.Response, error) {
	req, err := NewDeleteBucketsIDMembersIDRequest(c.service.ServerAPIURL(), bucketID, userID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetBucketsIDOwners(ctx context.Context, bucketID string, params *GetBucketsIDOwnersParams) (*http.Response, error) {
	req, err := NewGetBucketsIDOwnersRequest(c.service.ServerAPIURL(), bucketID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostBucketsIDOwnersWithBody(ctx context.Context, bucketID string, params *PostBucketsIDOwnersParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostBucketsIDOwnersRequestWithBody(c.service.ServerAPIURL(), bucketID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostBucketsIDOwners(ctx context.Context, bucketID string, params *PostBucketsIDOwnersParams, body PostBucketsIDOwnersJSONRequestBody) (*http.Response, error) {
	req, err := NewPostBucketsIDOwnersRequest(c.service.ServerAPIURL(), bucketID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteBucketsIDOwnersID(ctx context.Context, bucketID string, userID string, params *DeleteBucketsIDOwnersIDParams) (*http.Response, error) {
	req, err := NewDeleteBucketsIDOwnersIDRequest(c.service.ServerAPIURL(), bucketID, userID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetChecks(ctx context.Context, params *GetChecksParams) (*http.Response, error) {
	req, err := NewGetChecksRequest(c.service.ServerAPIURL(), params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) CreateCheckWithBody(ctx context.Context, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewCreateCheckRequestWithBody(c.service.ServerAPIURL(), contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) CreateCheck(ctx context.Context, body CreateCheckJSONRequestBody) (*http.Response, error) {
	req, err := NewCreateCheckRequest(c.service.ServerAPIURL(), body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteChecksID(ctx context.Context, checkID string, params *DeleteChecksIDParams) (*http.Response, error) {
	req, err := NewDeleteChecksIDRequest(c.service.ServerAPIURL(), checkID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetChecksID(ctx context.Context, checkID string, params *GetChecksIDParams) (*http.Response, error) {
	req, err := NewGetChecksIDRequest(c.service.ServerAPIURL(), checkID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PatchChecksIDWithBody(ctx context.Context, checkID string, params *PatchChecksIDParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPatchChecksIDRequestWithBody(c.service.ServerAPIURL(), checkID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PatchChecksID(ctx context.Context, checkID string, params *PatchChecksIDParams, body PatchChecksIDJSONRequestBody) (*http.Response, error) {
	req, err := NewPatchChecksIDRequest(c.service.ServerAPIURL(), checkID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PutChecksIDWithBody(ctx context.Context, checkID string, params *PutChecksIDParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPutChecksIDRequestWithBody(c.service.ServerAPIURL(), checkID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PutChecksID(ctx context.Context, checkID string, params *PutChecksIDParams, body PutChecksIDJSONRequestBody) (*http.Response, error) {
	req, err := NewPutChecksIDRequest(c.service.ServerAPIURL(), checkID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetChecksIDLabels(ctx context.Context, checkID string, params *GetChecksIDLabelsParams) (*http.Response, error) {
	req, err := NewGetChecksIDLabelsRequest(c.service.ServerAPIURL(), checkID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostChecksIDLabelsWithBody(ctx context.Context, checkID string, params *PostChecksIDLabelsParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostChecksIDLabelsRequestWithBody(c.service.ServerAPIURL(), checkID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostChecksIDLabels(ctx context.Context, checkID string, params *PostChecksIDLabelsParams, body PostChecksIDLabelsJSONRequestBody) (*http.Response, error) {
	req, err := NewPostChecksIDLabelsRequest(c.service.ServerAPIURL(), checkID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteChecksIDLabelsID(ctx context.Context, checkID string, labelID string, params *DeleteChecksIDLabelsIDParams) (*http.Response, error) {
	req, err := NewDeleteChecksIDLabelsIDRequest(c.service.ServerAPIURL(), checkID, labelID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetChecksIDQuery(ctx context.Context, checkID string, params *GetChecksIDQueryParams) (*http.Response, error) {
	req, err := NewGetChecksIDQueryRequest(c.service.ServerAPIURL(), checkID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetDashboards(ctx context.Context, params *GetDashboardsParams) (*http.Response, error) {
	req, err := NewGetDashboardsRequest(c.service.ServerAPIURL(), params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostDashboardsWithBody(ctx context.Context, params *PostDashboardsParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostDashboardsRequestWithBody(c.service.ServerAPIURL(), params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostDashboards(ctx context.Context, params *PostDashboardsParams, body PostDashboardsJSONRequestBody) (*http.Response, error) {
	req, err := NewPostDashboardsRequest(c.service.ServerAPIURL(), params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteDashboardsID(ctx context.Context, dashboardID string, params *DeleteDashboardsIDParams) (*http.Response, error) {
	req, err := NewDeleteDashboardsIDRequest(c.service.ServerAPIURL(), dashboardID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetDashboardsID(ctx context.Context, dashboardID string, params *GetDashboardsIDParams) (*http.Response, error) {
	req, err := NewGetDashboardsIDRequest(c.service.ServerAPIURL(), dashboardID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PatchDashboardsIDWithBody(ctx context.Context, dashboardID string, params *PatchDashboardsIDParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPatchDashboardsIDRequestWithBody(c.service.ServerAPIURL(), dashboardID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PatchDashboardsID(ctx context.Context, dashboardID string, params *PatchDashboardsIDParams, body PatchDashboardsIDJSONRequestBody) (*http.Response, error) {
	req, err := NewPatchDashboardsIDRequest(c.service.ServerAPIURL(), dashboardID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostDashboardsIDCellsWithBody(ctx context.Context, dashboardID string, params *PostDashboardsIDCellsParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostDashboardsIDCellsRequestWithBody(c.service.ServerAPIURL(), dashboardID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostDashboardsIDCells(ctx context.Context, dashboardID string, params *PostDashboardsIDCellsParams, body PostDashboardsIDCellsJSONRequestBody) (*http.Response, error) {
	req, err := NewPostDashboardsIDCellsRequest(c.service.ServerAPIURL(), dashboardID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PutDashboardsIDCellsWithBody(ctx context.Context, dashboardID string, params *PutDashboardsIDCellsParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPutDashboardsIDCellsRequestWithBody(c.service.ServerAPIURL(), dashboardID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PutDashboardsIDCells(ctx context.Context, dashboardID string, params *PutDashboardsIDCellsParams, body PutDashboardsIDCellsJSONRequestBody) (*http.Response, error) {
	req, err := NewPutDashboardsIDCellsRequest(c.service.ServerAPIURL(), dashboardID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteDashboardsIDCellsID(ctx context.Context, dashboardID string, cellID string, params *DeleteDashboardsIDCellsIDParams) (*http.Response, error) {
	req, err := NewDeleteDashboardsIDCellsIDRequest(c.service.ServerAPIURL(), dashboardID, cellID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PatchDashboardsIDCellsIDWithBody(ctx context.Context, dashboardID string, cellID string, params *PatchDashboardsIDCellsIDParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPatchDashboardsIDCellsIDRequestWithBody(c.service.ServerAPIURL(), dashboardID, cellID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PatchDashboardsIDCellsID(ctx context.Context, dashboardID string, cellID string, params *PatchDashboardsIDCellsIDParams, body PatchDashboardsIDCellsIDJSONRequestBody) (*http.Response, error) {
	req, err := NewPatchDashboardsIDCellsIDRequest(c.service.ServerAPIURL(), dashboardID, cellID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetDashboardsIDCellsIDView(ctx context.Context, dashboardID string, cellID string, params *GetDashboardsIDCellsIDViewParams) (*http.Response, error) {
	req, err := NewGetDashboardsIDCellsIDViewRequest(c.service.ServerAPIURL(), dashboardID, cellID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PatchDashboardsIDCellsIDViewWithBody(ctx context.Context, dashboardID string, cellID string, params *PatchDashboardsIDCellsIDViewParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPatchDashboardsIDCellsIDViewRequestWithBody(c.service.ServerAPIURL(), dashboardID, cellID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PatchDashboardsIDCellsIDView(ctx context.Context, dashboardID string, cellID string, params *PatchDashboardsIDCellsIDViewParams, body PatchDashboardsIDCellsIDViewJSONRequestBody) (*http.Response, error) {
	req, err := NewPatchDashboardsIDCellsIDViewRequest(c.service.ServerAPIURL(), dashboardID, cellID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetDashboardsIDLabels(ctx context.Context, dashboardID string, params *GetDashboardsIDLabelsParams) (*http.Response, error) {
	req, err := NewGetDashboardsIDLabelsRequest(c.service.ServerAPIURL(), dashboardID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostDashboardsIDLabelsWithBody(ctx context.Context, dashboardID string, params *PostDashboardsIDLabelsParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostDashboardsIDLabelsRequestWithBody(c.service.ServerAPIURL(), dashboardID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostDashboardsIDLabels(ctx context.Context, dashboardID string, params *PostDashboardsIDLabelsParams, body PostDashboardsIDLabelsJSONRequestBody) (*http.Response, error) {
	req, err := NewPostDashboardsIDLabelsRequest(c.service.ServerAPIURL(), dashboardID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteDashboardsIDLabelsID(ctx context.Context, dashboardID string, labelID string, params *DeleteDashboardsIDLabelsIDParams) (*http.Response, error) {
	req, err := NewDeleteDashboardsIDLabelsIDRequest(c.service.ServerAPIURL(), dashboardID, labelID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetDashboardsIDMembers(ctx context.Context, dashboardID string, params *GetDashboardsIDMembersParams) (*http.Response, error) {
	req, err := NewGetDashboardsIDMembersRequest(c.service.ServerAPIURL(), dashboardID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostDashboardsIDMembersWithBody(ctx context.Context, dashboardID string, params *PostDashboardsIDMembersParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostDashboardsIDMembersRequestWithBody(c.service.ServerAPIURL(), dashboardID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostDashboardsIDMembers(ctx context.Context, dashboardID string, params *PostDashboardsIDMembersParams, body PostDashboardsIDMembersJSONRequestBody) (*http.Response, error) {
	req, err := NewPostDashboardsIDMembersRequest(c.service.ServerAPIURL(), dashboardID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteDashboardsIDMembersID(ctx context.Context, dashboardID string, userID string, params *DeleteDashboardsIDMembersIDParams) (*http.Response, error) {
	req, err := NewDeleteDashboardsIDMembersIDRequest(c.service.ServerAPIURL(), dashboardID, userID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetDashboardsIDOwners(ctx context.Context, dashboardID string, params *GetDashboardsIDOwnersParams) (*http.Response, error) {
	req, err := NewGetDashboardsIDOwnersRequest(c.service.ServerAPIURL(), dashboardID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostDashboardsIDOwnersWithBody(ctx context.Context, dashboardID string, params *PostDashboardsIDOwnersParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostDashboardsIDOwnersRequestWithBody(c.service.ServerAPIURL(), dashboardID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostDashboardsIDOwners(ctx context.Context, dashboardID string, params *PostDashboardsIDOwnersParams, body PostDashboardsIDOwnersJSONRequestBody) (*http.Response, error) {
	req, err := NewPostDashboardsIDOwnersRequest(c.service.ServerAPIURL(), dashboardID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteDashboardsIDOwnersID(ctx context.Context, dashboardID string, userID string, params *DeleteDashboardsIDOwnersIDParams) (*http.Response, error) {
	req, err := NewDeleteDashboardsIDOwnersIDRequest(c.service.ServerAPIURL(), dashboardID, userID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetDBRPs(ctx context.Context, params *GetDBRPsParams) (*http.Response, error) {
	req, err := NewGetDBRPsRequest(c.service.ServerAPIURL(), params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostDBRPWithBody(ctx context.Context, params *PostDBRPParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostDBRPRequestWithBody(c.service.ServerAPIURL(), params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostDBRP(ctx context.Context, params *PostDBRPParams, body PostDBRPJSONRequestBody) (*http.Response, error) {
	req, err := NewPostDBRPRequest(c.service.ServerAPIURL(), params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteDBRPID(ctx context.Context, dbrpID string, params *DeleteDBRPIDParams) (*http.Response, error) {
	req, err := NewDeleteDBRPIDRequest(c.service.ServerAPIURL(), dbrpID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetDBRPsID(ctx context.Context, dbrpID string, params *GetDBRPsIDParams) (*http.Response, error) {
	req, err := NewGetDBRPsIDRequest(c.service.ServerAPIURL(), dbrpID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PatchDBRPIDWithBody(ctx context.Context, dbrpID string, params *PatchDBRPIDParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPatchDBRPIDRequestWithBody(c.service.ServerAPIURL(), dbrpID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PatchDBRPID(ctx context.Context, dbrpID string, params *PatchDBRPIDParams, body PatchDBRPIDJSONRequestBody) (*http.Response, error) {
	req, err := NewPatchDBRPIDRequest(c.service.ServerAPIURL(), dbrpID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostDeleteWithBody(ctx context.Context, params *PostDeleteParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostDeleteRequestWithBody(c.service.ServerAPIURL(), params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostDelete(ctx context.Context, params *PostDeleteParams, body PostDeleteJSONRequestBody) (*http.Response, error) {
	req, err := NewPostDeleteRequest(c.service.ServerAPIURL(), params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetDocumentsTemplates(ctx context.Context, params *GetDocumentsTemplatesParams) (*http.Response, error) {
	req, err := NewGetDocumentsTemplatesRequest(c.service.ServerAPIURL(), params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostDocumentsTemplatesWithBody(ctx context.Context, params *PostDocumentsTemplatesParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostDocumentsTemplatesRequestWithBody(c.service.ServerAPIURL(), params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostDocumentsTemplates(ctx context.Context, params *PostDocumentsTemplatesParams, body PostDocumentsTemplatesJSONRequestBody) (*http.Response, error) {
	req, err := NewPostDocumentsTemplatesRequest(c.service.ServerAPIURL(), params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteDocumentsTemplatesID(ctx context.Context, templateID string, params *DeleteDocumentsTemplatesIDParams) (*http.Response, error) {
	req, err := NewDeleteDocumentsTemplatesIDRequest(c.service.ServerAPIURL(), templateID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetDocumentsTemplatesID(ctx context.Context, templateID string, params *GetDocumentsTemplatesIDParams) (*http.Response, error) {
	req, err := NewGetDocumentsTemplatesIDRequest(c.service.ServerAPIURL(), templateID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PutDocumentsTemplatesIDWithBody(ctx context.Context, templateID string, params *PutDocumentsTemplatesIDParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPutDocumentsTemplatesIDRequestWithBody(c.service.ServerAPIURL(), templateID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PutDocumentsTemplatesID(ctx context.Context, templateID string, params *PutDocumentsTemplatesIDParams, body PutDocumentsTemplatesIDJSONRequestBody) (*http.Response, error) {
	req, err := NewPutDocumentsTemplatesIDRequest(c.service.ServerAPIURL(), templateID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetDocumentsTemplatesIDLabels(ctx context.Context, templateID string, params *GetDocumentsTemplatesIDLabelsParams) (*http.Response, error) {
	req, err := NewGetDocumentsTemplatesIDLabelsRequest(c.service.ServerAPIURL(), templateID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostDocumentsTemplatesIDLabelsWithBody(ctx context.Context, templateID string, params *PostDocumentsTemplatesIDLabelsParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostDocumentsTemplatesIDLabelsRequestWithBody(c.service.ServerAPIURL(), templateID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostDocumentsTemplatesIDLabels(ctx context.Context, templateID string, params *PostDocumentsTemplatesIDLabelsParams, body PostDocumentsTemplatesIDLabelsJSONRequestBody) (*http.Response, error) {
	req, err := NewPostDocumentsTemplatesIDLabelsRequest(c.service.ServerAPIURL(), templateID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteDocumentsTemplatesIDLabelsID(ctx context.Context, templateID string, labelID string, params *DeleteDocumentsTemplatesIDLabelsIDParams) (*http.Response, error) {
	req, err := NewDeleteDocumentsTemplatesIDLabelsIDRequest(c.service.ServerAPIURL(), templateID, labelID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetFlags(ctx context.Context, params *GetFlagsParams) (*http.Response, error) {
	req, err := NewGetFlagsRequest(c.service.ServerAPIURL(), params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetHealth(ctx context.Context, params *GetHealthParams) (*http.Response, error) {
	req, err := NewGetHealthRequest(c.service.ServerURL(), params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetLabels(ctx context.Context, params *GetLabelsParams) (*http.Response, error) {
	req, err := NewGetLabelsRequest(c.service.ServerAPIURL(), params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostLabelsWithBody(ctx context.Context, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostLabelsRequestWithBody(c.service.ServerAPIURL(), contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostLabels(ctx context.Context, body PostLabelsJSONRequestBody) (*http.Response, error) {
	req, err := NewPostLabelsRequest(c.service.ServerAPIURL(), body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteLabelsID(ctx context.Context, labelID string, params *DeleteLabelsIDParams) (*http.Response, error) {
	req, err := NewDeleteLabelsIDRequest(c.service.ServerAPIURL(), labelID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetLabelsID(ctx context.Context, labelID string, params *GetLabelsIDParams) (*http.Response, error) {
	req, err := NewGetLabelsIDRequest(c.service.ServerAPIURL(), labelID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PatchLabelsIDWithBody(ctx context.Context, labelID string, params *PatchLabelsIDParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPatchLabelsIDRequestWithBody(c.service.ServerAPIURL(), labelID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PatchLabelsID(ctx context.Context, labelID string, params *PatchLabelsIDParams, body PatchLabelsIDJSONRequestBody) (*http.Response, error) {
	req, err := NewPatchLabelsIDRequest(c.service.ServerAPIURL(), labelID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetMe(ctx context.Context, params *GetMeParams) (*http.Response, error) {
	req, err := NewGetMeRequest(c.service.ServerAPIURL(), params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PutMePasswordWithBody(ctx context.Context, params *PutMePasswordParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPutMePasswordRequestWithBody(c.service.ServerAPIURL(), params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PutMePassword(ctx context.Context, params *PutMePasswordParams, body PutMePasswordJSONRequestBody) (*http.Response, error) {
	req, err := NewPutMePasswordRequest(c.service.ServerAPIURL(), params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetNotificationEndpoints(ctx context.Context, params *GetNotificationEndpointsParams) (*http.Response, error) {
	req, err := NewGetNotificationEndpointsRequest(c.service.ServerAPIURL(), params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) CreateNotificationEndpointWithBody(ctx context.Context, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewCreateNotificationEndpointRequestWithBody(c.service.ServerAPIURL(), contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) CreateNotificationEndpoint(ctx context.Context, body CreateNotificationEndpointJSONRequestBody) (*http.Response, error) {
	req, err := NewCreateNotificationEndpointRequest(c.service.ServerAPIURL(), body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteNotificationEndpointsID(ctx context.Context, endpointID string, params *DeleteNotificationEndpointsIDParams) (*http.Response, error) {
	req, err := NewDeleteNotificationEndpointsIDRequest(c.service.ServerAPIURL(), endpointID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetNotificationEndpointsID(ctx context.Context, endpointID string, params *GetNotificationEndpointsIDParams) (*http.Response, error) {
	req, err := NewGetNotificationEndpointsIDRequest(c.service.ServerAPIURL(), endpointID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PatchNotificationEndpointsIDWithBody(ctx context.Context, endpointID string, params *PatchNotificationEndpointsIDParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPatchNotificationEndpointsIDRequestWithBody(c.service.ServerAPIURL(), endpointID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PatchNotificationEndpointsID(ctx context.Context, endpointID string, params *PatchNotificationEndpointsIDParams, body PatchNotificationEndpointsIDJSONRequestBody) (*http.Response, error) {
	req, err := NewPatchNotificationEndpointsIDRequest(c.service.ServerAPIURL(), endpointID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PutNotificationEndpointsIDWithBody(ctx context.Context, endpointID string, params *PutNotificationEndpointsIDParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPutNotificationEndpointsIDRequestWithBody(c.service.ServerAPIURL(), endpointID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PutNotificationEndpointsID(ctx context.Context, endpointID string, params *PutNotificationEndpointsIDParams, body PutNotificationEndpointsIDJSONRequestBody) (*http.Response, error) {
	req, err := NewPutNotificationEndpointsIDRequest(c.service.ServerAPIURL(), endpointID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetNotificationEndpointsIDLabels(ctx context.Context, endpointID string, params *GetNotificationEndpointsIDLabelsParams) (*http.Response, error) {
	req, err := NewGetNotificationEndpointsIDLabelsRequest(c.service.ServerAPIURL(), endpointID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostNotificationEndpointIDLabelsWithBody(ctx context.Context, endpointID string, params *PostNotificationEndpointIDLabelsParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostNotificationEndpointIDLabelsRequestWithBody(c.service.ServerAPIURL(), endpointID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostNotificationEndpointIDLabels(ctx context.Context, endpointID string, params *PostNotificationEndpointIDLabelsParams, body PostNotificationEndpointIDLabelsJSONRequestBody) (*http.Response, error) {
	req, err := NewPostNotificationEndpointIDLabelsRequest(c.service.ServerAPIURL(), endpointID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteNotificationEndpointsIDLabelsID(ctx context.Context, endpointID string, labelID string, params *DeleteNotificationEndpointsIDLabelsIDParams) (*http.Response, error) {
	req, err := NewDeleteNotificationEndpointsIDLabelsIDRequest(c.service.ServerAPIURL(), endpointID, labelID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetNotificationRules(ctx context.Context, params *GetNotificationRulesParams) (*http.Response, error) {
	req, err := NewGetNotificationRulesRequest(c.service.ServerAPIURL(), params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) CreateNotificationRuleWithBody(ctx context.Context, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewCreateNotificationRuleRequestWithBody(c.service.ServerAPIURL(), contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) CreateNotificationRule(ctx context.Context, body CreateNotificationRuleJSONRequestBody) (*http.Response, error) {
	req, err := NewCreateNotificationRuleRequest(c.service.ServerAPIURL(), body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteNotificationRulesID(ctx context.Context, ruleID string, params *DeleteNotificationRulesIDParams) (*http.Response, error) {
	req, err := NewDeleteNotificationRulesIDRequest(c.service.ServerAPIURL(), ruleID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetNotificationRulesID(ctx context.Context, ruleID string, params *GetNotificationRulesIDParams) (*http.Response, error) {
	req, err := NewGetNotificationRulesIDRequest(c.service.ServerAPIURL(), ruleID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PatchNotificationRulesIDWithBody(ctx context.Context, ruleID string, params *PatchNotificationRulesIDParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPatchNotificationRulesIDRequestWithBody(c.service.ServerAPIURL(), ruleID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PatchNotificationRulesID(ctx context.Context, ruleID string, params *PatchNotificationRulesIDParams, body PatchNotificationRulesIDJSONRequestBody) (*http.Response, error) {
	req, err := NewPatchNotificationRulesIDRequest(c.service.ServerAPIURL(), ruleID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PutNotificationRulesIDWithBody(ctx context.Context, ruleID string, params *PutNotificationRulesIDParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPutNotificationRulesIDRequestWithBody(c.service.ServerAPIURL(), ruleID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PutNotificationRulesID(ctx context.Context, ruleID string, params *PutNotificationRulesIDParams, body PutNotificationRulesIDJSONRequestBody) (*http.Response, error) {
	req, err := NewPutNotificationRulesIDRequest(c.service.ServerAPIURL(), ruleID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetNotificationRulesIDLabels(ctx context.Context, ruleID string, params *GetNotificationRulesIDLabelsParams) (*http.Response, error) {
	req, err := NewGetNotificationRulesIDLabelsRequest(c.service.ServerAPIURL(), ruleID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostNotificationRuleIDLabelsWithBody(ctx context.Context, ruleID string, params *PostNotificationRuleIDLabelsParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostNotificationRuleIDLabelsRequestWithBody(c.service.ServerAPIURL(), ruleID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostNotificationRuleIDLabels(ctx context.Context, ruleID string, params *PostNotificationRuleIDLabelsParams, body PostNotificationRuleIDLabelsJSONRequestBody) (*http.Response, error) {
	req, err := NewPostNotificationRuleIDLabelsRequest(c.service.ServerAPIURL(), ruleID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteNotificationRulesIDLabelsID(ctx context.Context, ruleID string, labelID string, params *DeleteNotificationRulesIDLabelsIDParams) (*http.Response, error) {
	req, err := NewDeleteNotificationRulesIDLabelsIDRequest(c.service.ServerAPIURL(), ruleID, labelID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetNotificationRulesIDQuery(ctx context.Context, ruleID string, params *GetNotificationRulesIDQueryParams) (*http.Response, error) {
	req, err := NewGetNotificationRulesIDQueryRequest(c.service.ServerAPIURL(), ruleID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetOrgs(ctx context.Context, params *GetOrgsParams) (*http.Response, error) {
	req, err := NewGetOrgsRequest(c.service.ServerAPIURL(), params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostOrgsWithBody(ctx context.Context, params *PostOrgsParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostOrgsRequestWithBody(c.service.ServerAPIURL(), params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostOrgs(ctx context.Context, params *PostOrgsParams, body PostOrgsJSONRequestBody) (*http.Response, error) {
	req, err := NewPostOrgsRequest(c.service.ServerAPIURL(), params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteOrgsID(ctx context.Context, orgID string, params *DeleteOrgsIDParams) (*http.Response, error) {
	req, err := NewDeleteOrgsIDRequest(c.service.ServerAPIURL(), orgID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetOrgsID(ctx context.Context, orgID string, params *GetOrgsIDParams) (*http.Response, error) {
	req, err := NewGetOrgsIDRequest(c.service.ServerAPIURL(), orgID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PatchOrgsIDWithBody(ctx context.Context, orgID string, params *PatchOrgsIDParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPatchOrgsIDRequestWithBody(c.service.ServerAPIURL(), orgID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PatchOrgsID(ctx context.Context, orgID string, params *PatchOrgsIDParams, body PatchOrgsIDJSONRequestBody) (*http.Response, error) {
	req, err := NewPatchOrgsIDRequest(c.service.ServerAPIURL(), orgID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetOrgsIDMembers(ctx context.Context, orgID string, params *GetOrgsIDMembersParams) (*http.Response, error) {
	req, err := NewGetOrgsIDMembersRequest(c.service.ServerAPIURL(), orgID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostOrgsIDMembersWithBody(ctx context.Context, orgID string, params *PostOrgsIDMembersParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostOrgsIDMembersRequestWithBody(c.service.ServerAPIURL(), orgID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostOrgsIDMembers(ctx context.Context, orgID string, params *PostOrgsIDMembersParams, body PostOrgsIDMembersJSONRequestBody) (*http.Response, error) {
	req, err := NewPostOrgsIDMembersRequest(c.service.ServerAPIURL(), orgID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteOrgsIDMembersID(ctx context.Context, orgID string, userID string, params *DeleteOrgsIDMembersIDParams) (*http.Response, error) {
	req, err := NewDeleteOrgsIDMembersIDRequest(c.service.ServerAPIURL(), orgID, userID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetOrgsIDOwners(ctx context.Context, orgID string, params *GetOrgsIDOwnersParams) (*http.Response, error) {
	req, err := NewGetOrgsIDOwnersRequest(c.service.ServerAPIURL(), orgID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostOrgsIDOwnersWithBody(ctx context.Context, orgID string, params *PostOrgsIDOwnersParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostOrgsIDOwnersRequestWithBody(c.service.ServerAPIURL(), orgID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostOrgsIDOwners(ctx context.Context, orgID string, params *PostOrgsIDOwnersParams, body PostOrgsIDOwnersJSONRequestBody) (*http.Response, error) {
	req, err := NewPostOrgsIDOwnersRequest(c.service.ServerAPIURL(), orgID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteOrgsIDOwnersID(ctx context.Context, orgID string, userID string, params *DeleteOrgsIDOwnersIDParams) (*http.Response, error) {
	req, err := NewDeleteOrgsIDOwnersIDRequest(c.service.ServerAPIURL(), orgID, userID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetOrgsIDSecrets(ctx context.Context, orgID string, params *GetOrgsIDSecretsParams) (*http.Response, error) {
	req, err := NewGetOrgsIDSecretsRequest(c.service.ServerAPIURL(), orgID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PatchOrgsIDSecretsWithBody(ctx context.Context, orgID string, params *PatchOrgsIDSecretsParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPatchOrgsIDSecretsRequestWithBody(c.service.ServerAPIURL(), orgID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PatchOrgsIDSecrets(ctx context.Context, orgID string, params *PatchOrgsIDSecretsParams, body PatchOrgsIDSecretsJSONRequestBody) (*http.Response, error) {
	req, err := NewPatchOrgsIDSecretsRequest(c.service.ServerAPIURL(), orgID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostOrgsIDSecretsWithBody(ctx context.Context, orgID string, params *PostOrgsIDSecretsParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostOrgsIDSecretsRequestWithBody(c.service.ServerAPIURL(), orgID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostOrgsIDSecrets(ctx context.Context, orgID string, params *PostOrgsIDSecretsParams, body PostOrgsIDSecretsJSONRequestBody) (*http.Response, error) {
	req, err := NewPostOrgsIDSecretsRequest(c.service.ServerAPIURL(), orgID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostQueryWithBody(ctx context.Context, params *PostQueryParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostQueryRequestWithBody(c.service.ServerAPIURL(), params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostQuery(ctx context.Context, params *PostQueryParams, body PostQueryJSONRequestBody) (*http.Response, error) {
	req, err := NewPostQueryRequest(c.service.ServerAPIURL(), params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostQueryAnalyzeWithBody(ctx context.Context, params *PostQueryAnalyzeParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostQueryAnalyzeRequestWithBody(c.service.ServerAPIURL(), params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostQueryAnalyze(ctx context.Context, params *PostQueryAnalyzeParams, body PostQueryAnalyzeJSONRequestBody) (*http.Response, error) {
	req, err := NewPostQueryAnalyzeRequest(c.service.ServerAPIURL(), params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostQueryAstWithBody(ctx context.Context, params *PostQueryAstParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostQueryAstRequestWithBody(c.service.ServerAPIURL(), params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostQueryAst(ctx context.Context, params *PostQueryAstParams, body PostQueryAstJSONRequestBody) (*http.Response, error) {
	req, err := NewPostQueryAstRequest(c.service.ServerAPIURL(), params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetQuerySuggestions(ctx context.Context, params *GetQuerySuggestionsParams) (*http.Response, error) {
	req, err := NewGetQuerySuggestionsRequest(c.service.ServerAPIURL(), params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetQuerySuggestionsName(ctx context.Context, name string, params *GetQuerySuggestionsNameParams) (*http.Response, error) {
	req, err := NewGetQuerySuggestionsNameRequest(c.service.ServerAPIURL(), name, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetReady(ctx context.Context, params *GetReadyParams) (*http.Response, error) {
	req, err := NewGetReadyRequest(c.service.ServerURL(), params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetScrapers(ctx context.Context, params *GetScrapersParams) (*http.Response, error) {
	req, err := NewGetScrapersRequest(c.service.ServerAPIURL(), params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostScrapersWithBody(ctx context.Context, params *PostScrapersParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostScrapersRequestWithBody(c.service.ServerAPIURL(), params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostScrapers(ctx context.Context, params *PostScrapersParams, body PostScrapersJSONRequestBody) (*http.Response, error) {
	req, err := NewPostScrapersRequest(c.service.ServerAPIURL(), params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteScrapersID(ctx context.Context, scraperTargetID string, params *DeleteScrapersIDParams) (*http.Response, error) {
	req, err := NewDeleteScrapersIDRequest(c.service.ServerAPIURL(), scraperTargetID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetScrapersID(ctx context.Context, scraperTargetID string, params *GetScrapersIDParams) (*http.Response, error) {
	req, err := NewGetScrapersIDRequest(c.service.ServerAPIURL(), scraperTargetID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PatchScrapersIDWithBody(ctx context.Context, scraperTargetID string, params *PatchScrapersIDParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPatchScrapersIDRequestWithBody(c.service.ServerAPIURL(), scraperTargetID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PatchScrapersID(ctx context.Context, scraperTargetID string, params *PatchScrapersIDParams, body PatchScrapersIDJSONRequestBody) (*http.Response, error) {
	req, err := NewPatchScrapersIDRequest(c.service.ServerAPIURL(), scraperTargetID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetScrapersIDLabels(ctx context.Context, scraperTargetID string, params *GetScrapersIDLabelsParams) (*http.Response, error) {
	req, err := NewGetScrapersIDLabelsRequest(c.service.ServerAPIURL(), scraperTargetID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostScrapersIDLabelsWithBody(ctx context.Context, scraperTargetID string, params *PostScrapersIDLabelsParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostScrapersIDLabelsRequestWithBody(c.service.ServerAPIURL(), scraperTargetID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostScrapersIDLabels(ctx context.Context, scraperTargetID string, params *PostScrapersIDLabelsParams, body PostScrapersIDLabelsJSONRequestBody) (*http.Response, error) {
	req, err := NewPostScrapersIDLabelsRequest(c.service.ServerAPIURL(), scraperTargetID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteScrapersIDLabelsID(ctx context.Context, scraperTargetID string, labelID string, params *DeleteScrapersIDLabelsIDParams) (*http.Response, error) {
	req, err := NewDeleteScrapersIDLabelsIDRequest(c.service.ServerAPIURL(), scraperTargetID, labelID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PatchScrapersIDLabelsIDWithBody(ctx context.Context, scraperTargetID string, labelID string, params *PatchScrapersIDLabelsIDParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPatchScrapersIDLabelsIDRequestWithBody(c.service.ServerAPIURL(), scraperTargetID, labelID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PatchScrapersIDLabelsID(ctx context.Context, scraperTargetID string, labelID string, params *PatchScrapersIDLabelsIDParams, body PatchScrapersIDLabelsIDJSONRequestBody) (*http.Response, error) {
	req, err := NewPatchScrapersIDLabelsIDRequest(c.service.ServerAPIURL(), scraperTargetID, labelID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetScrapersIDMembers(ctx context.Context, scraperTargetID string, params *GetScrapersIDMembersParams) (*http.Response, error) {
	req, err := NewGetScrapersIDMembersRequest(c.service.ServerAPIURL(), scraperTargetID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostScrapersIDMembersWithBody(ctx context.Context, scraperTargetID string, params *PostScrapersIDMembersParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostScrapersIDMembersRequestWithBody(c.service.ServerAPIURL(), scraperTargetID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostScrapersIDMembers(ctx context.Context, scraperTargetID string, params *PostScrapersIDMembersParams, body PostScrapersIDMembersJSONRequestBody) (*http.Response, error) {
	req, err := NewPostScrapersIDMembersRequest(c.service.ServerAPIURL(), scraperTargetID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteScrapersIDMembersID(ctx context.Context, scraperTargetID string, userID string, params *DeleteScrapersIDMembersIDParams) (*http.Response, error) {
	req, err := NewDeleteScrapersIDMembersIDRequest(c.service.ServerAPIURL(), scraperTargetID, userID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetScrapersIDOwners(ctx context.Context, scraperTargetID string, params *GetScrapersIDOwnersParams) (*http.Response, error) {
	req, err := NewGetScrapersIDOwnersRequest(c.service.ServerAPIURL(), scraperTargetID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostScrapersIDOwnersWithBody(ctx context.Context, scraperTargetID string, params *PostScrapersIDOwnersParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostScrapersIDOwnersRequestWithBody(c.service.ServerAPIURL(), scraperTargetID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostScrapersIDOwners(ctx context.Context, scraperTargetID string, params *PostScrapersIDOwnersParams, body PostScrapersIDOwnersJSONRequestBody) (*http.Response, error) {
	req, err := NewPostScrapersIDOwnersRequest(c.service.ServerAPIURL(), scraperTargetID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteScrapersIDOwnersID(ctx context.Context, scraperTargetID string, userID string, params *DeleteScrapersIDOwnersIDParams) (*http.Response, error) {
	req, err := NewDeleteScrapersIDOwnersIDRequest(c.service.ServerAPIURL(), scraperTargetID, userID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetSetup(ctx context.Context, params *GetSetupParams) (*http.Response, error) {
	req, err := NewGetSetupRequest(c.service.ServerAPIURL(), params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostSetupWithBody(ctx context.Context, params *PostSetupParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostSetupRequestWithBody(c.service.ServerAPIURL(), params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostSetup(ctx context.Context, params *PostSetupParams, body PostSetupJSONRequestBody) (*http.Response, error) {
	req, err := NewPostSetupRequest(c.service.ServerAPIURL(), params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostSetupUserWithBody(ctx context.Context, params *PostSetupUserParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostSetupUserRequestWithBody(c.service.ServerAPIURL(), params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostSetupUser(ctx context.Context, params *PostSetupUserParams, body PostSetupUserJSONRequestBody) (*http.Response, error) {
	req, err := NewPostSetupUserRequest(c.service.ServerAPIURL(), params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostSignin(ctx context.Context, params *PostSigninParams) (*http.Response, error) {
	req, err := NewPostSigninRequest(c.service.ServerAPIURL(), params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostSignout(ctx context.Context, params *PostSignoutParams) (*http.Response, error) {
	req, err := NewPostSignoutRequest(c.service.ServerAPIURL(), params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetSources(ctx context.Context, params *GetSourcesParams) (*http.Response, error) {
	req, err := NewGetSourcesRequest(c.service.ServerAPIURL(), params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostSourcesWithBody(ctx context.Context, params *PostSourcesParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostSourcesRequestWithBody(c.service.ServerAPIURL(), params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostSources(ctx context.Context, params *PostSourcesParams, body PostSourcesJSONRequestBody) (*http.Response, error) {
	req, err := NewPostSourcesRequest(c.service.ServerAPIURL(), params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteSourcesID(ctx context.Context, sourceID string, params *DeleteSourcesIDParams) (*http.Response, error) {
	req, err := NewDeleteSourcesIDRequest(c.service.ServerAPIURL(), sourceID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetSourcesID(ctx context.Context, sourceID string, params *GetSourcesIDParams) (*http.Response, error) {
	req, err := NewGetSourcesIDRequest(c.service.ServerAPIURL(), sourceID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PatchSourcesIDWithBody(ctx context.Context, sourceID string, params *PatchSourcesIDParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPatchSourcesIDRequestWithBody(c.service.ServerAPIURL(), sourceID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PatchSourcesID(ctx context.Context, sourceID string, params *PatchSourcesIDParams, body PatchSourcesIDJSONRequestBody) (*http.Response, error) {
	req, err := NewPatchSourcesIDRequest(c.service.ServerAPIURL(), sourceID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetSourcesIDBuckets(ctx context.Context, sourceID string, params *GetSourcesIDBucketsParams) (*http.Response, error) {
	req, err := NewGetSourcesIDBucketsRequest(c.service.ServerAPIURL(), sourceID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetSourcesIDHealth(ctx context.Context, sourceID string, params *GetSourcesIDHealthParams) (*http.Response, error) {
	req, err := NewGetSourcesIDHealthRequest(c.service.ServerAPIURL(), sourceID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) ListStacks(ctx context.Context, params *ListStacksParams) (*http.Response, error) {
	req, err := NewListStacksRequest(c.service.ServerAPIURL(), params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) CreateStackWithBody(ctx context.Context, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewCreateStackRequestWithBody(c.service.ServerAPIURL(), contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) CreateStack(ctx context.Context, body CreateStackJSONRequestBody) (*http.Response, error) {
	req, err := NewCreateStackRequest(c.service.ServerAPIURL(), body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteStack(ctx context.Context, stackId string, params *DeleteStackParams) (*http.Response, error) {
	req, err := NewDeleteStackRequest(c.service.ServerAPIURL(), stackId, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) ReadStack(ctx context.Context, stackId string) (*http.Response, error) {
	req, err := NewReadStackRequest(c.service.ServerAPIURL(), stackId)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) UpdateStackWithBody(ctx context.Context, stackId string, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewUpdateStackRequestWithBody(c.service.ServerAPIURL(), stackId, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) UpdateStack(ctx context.Context, stackId string, body UpdateStackJSONRequestBody) (*http.Response, error) {
	req, err := NewUpdateStackRequest(c.service.ServerAPIURL(), stackId, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) UninstallStack(ctx context.Context, stackId string) (*http.Response, error) {
	req, err := NewUninstallStackRequest(c.service.ServerAPIURL(), stackId)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetTasks(ctx context.Context, params *GetTasksParams) (*http.Response, error) {
	req, err := NewGetTasksRequest(c.service.ServerAPIURL(), params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostTasksWithBody(ctx context.Context, params *PostTasksParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostTasksRequestWithBody(c.service.ServerAPIURL(), params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostTasks(ctx context.Context, params *PostTasksParams, body PostTasksJSONRequestBody) (*http.Response, error) {
	req, err := NewPostTasksRequest(c.service.ServerAPIURL(), params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteTasksID(ctx context.Context, taskID string, params *DeleteTasksIDParams) (*http.Response, error) {
	req, err := NewDeleteTasksIDRequest(c.service.ServerAPIURL(), taskID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetTasksID(ctx context.Context, taskID string, params *GetTasksIDParams) (*http.Response, error) {
	req, err := NewGetTasksIDRequest(c.service.ServerAPIURL(), taskID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PatchTasksIDWithBody(ctx context.Context, taskID string, params *PatchTasksIDParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPatchTasksIDRequestWithBody(c.service.ServerAPIURL(), taskID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PatchTasksID(ctx context.Context, taskID string, params *PatchTasksIDParams, body PatchTasksIDJSONRequestBody) (*http.Response, error) {
	req, err := NewPatchTasksIDRequest(c.service.ServerAPIURL(), taskID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetTasksIDLabels(ctx context.Context, taskID string, params *GetTasksIDLabelsParams) (*http.Response, error) {
	req, err := NewGetTasksIDLabelsRequest(c.service.ServerAPIURL(), taskID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostTasksIDLabelsWithBody(ctx context.Context, taskID string, params *PostTasksIDLabelsParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostTasksIDLabelsRequestWithBody(c.service.ServerAPIURL(), taskID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostTasksIDLabels(ctx context.Context, taskID string, params *PostTasksIDLabelsParams, body PostTasksIDLabelsJSONRequestBody) (*http.Response, error) {
	req, err := NewPostTasksIDLabelsRequest(c.service.ServerAPIURL(), taskID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteTasksIDLabelsID(ctx context.Context, taskID string, labelID string, params *DeleteTasksIDLabelsIDParams) (*http.Response, error) {
	req, err := NewDeleteTasksIDLabelsIDRequest(c.service.ServerAPIURL(), taskID, labelID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetTasksIDLogs(ctx context.Context, taskID string, params *GetTasksIDLogsParams) (*http.Response, error) {
	req, err := NewGetTasksIDLogsRequest(c.service.ServerAPIURL(), taskID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetTasksIDMembers(ctx context.Context, taskID string, params *GetTasksIDMembersParams) (*http.Response, error) {
	req, err := NewGetTasksIDMembersRequest(c.service.ServerAPIURL(), taskID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostTasksIDMembersWithBody(ctx context.Context, taskID string, params *PostTasksIDMembersParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostTasksIDMembersRequestWithBody(c.service.ServerAPIURL(), taskID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostTasksIDMembers(ctx context.Context, taskID string, params *PostTasksIDMembersParams, body PostTasksIDMembersJSONRequestBody) (*http.Response, error) {
	req, err := NewPostTasksIDMembersRequest(c.service.ServerAPIURL(), taskID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteTasksIDMembersID(ctx context.Context, taskID string, userID string, params *DeleteTasksIDMembersIDParams) (*http.Response, error) {
	req, err := NewDeleteTasksIDMembersIDRequest(c.service.ServerAPIURL(), taskID, userID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetTasksIDOwners(ctx context.Context, taskID string, params *GetTasksIDOwnersParams) (*http.Response, error) {
	req, err := NewGetTasksIDOwnersRequest(c.service.ServerAPIURL(), taskID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostTasksIDOwnersWithBody(ctx context.Context, taskID string, params *PostTasksIDOwnersParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostTasksIDOwnersRequestWithBody(c.service.ServerAPIURL(), taskID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostTasksIDOwners(ctx context.Context, taskID string, params *PostTasksIDOwnersParams, body PostTasksIDOwnersJSONRequestBody) (*http.Response, error) {
	req, err := NewPostTasksIDOwnersRequest(c.service.ServerAPIURL(), taskID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteTasksIDOwnersID(ctx context.Context, taskID string, userID string, params *DeleteTasksIDOwnersIDParams) (*http.Response, error) {
	req, err := NewDeleteTasksIDOwnersIDRequest(c.service.ServerAPIURL(), taskID, userID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetTasksIDRuns(ctx context.Context, taskID string, params *GetTasksIDRunsParams) (*http.Response, error) {
	req, err := NewGetTasksIDRunsRequest(c.service.ServerAPIURL(), taskID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostTasksIDRunsWithBody(ctx context.Context, taskID string, params *PostTasksIDRunsParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostTasksIDRunsRequestWithBody(c.service.ServerAPIURL(), taskID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostTasksIDRuns(ctx context.Context, taskID string, params *PostTasksIDRunsParams, body PostTasksIDRunsJSONRequestBody) (*http.Response, error) {
	req, err := NewPostTasksIDRunsRequest(c.service.ServerAPIURL(), taskID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteTasksIDRunsID(ctx context.Context, taskID string, runID string, params *DeleteTasksIDRunsIDParams) (*http.Response, error) {
	req, err := NewDeleteTasksIDRunsIDRequest(c.service.ServerAPIURL(), taskID, runID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetTasksIDRunsID(ctx context.Context, taskID string, runID string, params *GetTasksIDRunsIDParams) (*http.Response, error) {
	req, err := NewGetTasksIDRunsIDRequest(c.service.ServerAPIURL(), taskID, runID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetTasksIDRunsIDLogs(ctx context.Context, taskID string, runID string, params *GetTasksIDRunsIDLogsParams) (*http.Response, error) {
	req, err := NewGetTasksIDRunsIDLogsRequest(c.service.ServerAPIURL(), taskID, runID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostTasksIDRunsIDRetry(ctx context.Context, taskID string, runID string, params *PostTasksIDRunsIDRetryParams) (*http.Response, error) {
	req, err := NewPostTasksIDRunsIDRetryRequest(c.service.ServerAPIURL(), taskID, runID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetTelegrafPlugins(ctx context.Context, params *GetTelegrafPluginsParams) (*http.Response, error) {
	req, err := NewGetTelegrafPluginsRequest(c.service.ServerAPIURL(), params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetTelegrafs(ctx context.Context, params *GetTelegrafsParams) (*http.Response, error) {
	req, err := NewGetTelegrafsRequest(c.service.ServerAPIURL(), params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostTelegrafsWithBody(ctx context.Context, params *PostTelegrafsParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostTelegrafsRequestWithBody(c.service.ServerAPIURL(), params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostTelegrafs(ctx context.Context, params *PostTelegrafsParams, body PostTelegrafsJSONRequestBody) (*http.Response, error) {
	req, err := NewPostTelegrafsRequest(c.service.ServerAPIURL(), params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteTelegrafsID(ctx context.Context, telegrafID string, params *DeleteTelegrafsIDParams) (*http.Response, error) {
	req, err := NewDeleteTelegrafsIDRequest(c.service.ServerAPIURL(), telegrafID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetTelegrafsID(ctx context.Context, telegrafID string, params *GetTelegrafsIDParams) (*http.Response, error) {
	req, err := NewGetTelegrafsIDRequest(c.service.ServerAPIURL(), telegrafID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PutTelegrafsIDWithBody(ctx context.Context, telegrafID string, params *PutTelegrafsIDParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPutTelegrafsIDRequestWithBody(c.service.ServerAPIURL(), telegrafID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PutTelegrafsID(ctx context.Context, telegrafID string, params *PutTelegrafsIDParams, body PutTelegrafsIDJSONRequestBody) (*http.Response, error) {
	req, err := NewPutTelegrafsIDRequest(c.service.ServerAPIURL(), telegrafID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetTelegrafsIDLabels(ctx context.Context, telegrafID string, params *GetTelegrafsIDLabelsParams) (*http.Response, error) {
	req, err := NewGetTelegrafsIDLabelsRequest(c.service.ServerAPIURL(), telegrafID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostTelegrafsIDLabelsWithBody(ctx context.Context, telegrafID string, params *PostTelegrafsIDLabelsParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostTelegrafsIDLabelsRequestWithBody(c.service.ServerAPIURL(), telegrafID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostTelegrafsIDLabels(ctx context.Context, telegrafID string, params *PostTelegrafsIDLabelsParams, body PostTelegrafsIDLabelsJSONRequestBody) (*http.Response, error) {
	req, err := NewPostTelegrafsIDLabelsRequest(c.service.ServerAPIURL(), telegrafID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteTelegrafsIDLabelsID(ctx context.Context, telegrafID string, labelID string, params *DeleteTelegrafsIDLabelsIDParams) (*http.Response, error) {
	req, err := NewDeleteTelegrafsIDLabelsIDRequest(c.service.ServerAPIURL(), telegrafID, labelID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetTelegrafsIDMembers(ctx context.Context, telegrafID string, params *GetTelegrafsIDMembersParams) (*http.Response, error) {
	req, err := NewGetTelegrafsIDMembersRequest(c.service.ServerAPIURL(), telegrafID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostTelegrafsIDMembersWithBody(ctx context.Context, telegrafID string, params *PostTelegrafsIDMembersParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostTelegrafsIDMembersRequestWithBody(c.service.ServerAPIURL(), telegrafID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostTelegrafsIDMembers(ctx context.Context, telegrafID string, params *PostTelegrafsIDMembersParams, body PostTelegrafsIDMembersJSONRequestBody) (*http.Response, error) {
	req, err := NewPostTelegrafsIDMembersRequest(c.service.ServerAPIURL(), telegrafID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteTelegrafsIDMembersID(ctx context.Context, telegrafID string, userID string, params *DeleteTelegrafsIDMembersIDParams) (*http.Response, error) {
	req, err := NewDeleteTelegrafsIDMembersIDRequest(c.service.ServerAPIURL(), telegrafID, userID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetTelegrafsIDOwners(ctx context.Context, telegrafID string, params *GetTelegrafsIDOwnersParams) (*http.Response, error) {
	req, err := NewGetTelegrafsIDOwnersRequest(c.service.ServerAPIURL(), telegrafID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostTelegrafsIDOwnersWithBody(ctx context.Context, telegrafID string, params *PostTelegrafsIDOwnersParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostTelegrafsIDOwnersRequestWithBody(c.service.ServerAPIURL(), telegrafID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostTelegrafsIDOwners(ctx context.Context, telegrafID string, params *PostTelegrafsIDOwnersParams, body PostTelegrafsIDOwnersJSONRequestBody) (*http.Response, error) {
	req, err := NewPostTelegrafsIDOwnersRequest(c.service.ServerAPIURL(), telegrafID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteTelegrafsIDOwnersID(ctx context.Context, telegrafID string, userID string, params *DeleteTelegrafsIDOwnersIDParams) (*http.Response, error) {
	req, err := NewDeleteTelegrafsIDOwnersIDRequest(c.service.ServerAPIURL(), telegrafID, userID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) ApplyTemplateWithBody(ctx context.Context, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewApplyTemplateRequestWithBody(c.service.ServerAPIURL(), contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) ApplyTemplate(ctx context.Context, body ApplyTemplateJSONRequestBody) (*http.Response, error) {
	req, err := NewApplyTemplateRequest(c.service.ServerAPIURL(), body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) ExportTemplateWithBody(ctx context.Context, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewExportTemplateRequestWithBody(c.service.ServerAPIURL(), contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) ExportTemplate(ctx context.Context, body ExportTemplateJSONRequestBody) (*http.Response, error) {
	req, err := NewExportTemplateRequest(c.service.ServerAPIURL(), body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetUsers(ctx context.Context, params *GetUsersParams) (*http.Response, error) {
	req, err := NewGetUsersRequest(c.service.ServerAPIURL(), params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostUsersWithBody(ctx context.Context, params *PostUsersParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostUsersRequestWithBody(c.service.ServerAPIURL(), params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostUsers(ctx context.Context, params *PostUsersParams, body PostUsersJSONRequestBody) (*http.Response, error) {
	req, err := NewPostUsersRequest(c.service.ServerAPIURL(), params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteUsersID(ctx context.Context, userID string, params *DeleteUsersIDParams) (*http.Response, error) {
	req, err := NewDeleteUsersIDRequest(c.service.ServerAPIURL(), userID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetUsersID(ctx context.Context, userID string, params *GetUsersIDParams) (*http.Response, error) {
	req, err := NewGetUsersIDRequest(c.service.ServerAPIURL(), userID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PatchUsersIDWithBody(ctx context.Context, userID string, params *PatchUsersIDParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPatchUsersIDRequestWithBody(c.service.ServerAPIURL(), userID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PatchUsersID(ctx context.Context, userID string, params *PatchUsersIDParams, body PatchUsersIDJSONRequestBody) (*http.Response, error) {
	req, err := NewPatchUsersIDRequest(c.service.ServerAPIURL(), userID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostUsersIDPasswordWithBody(ctx context.Context, userID string, params *PostUsersIDPasswordParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostUsersIDPasswordRequestWithBody(c.service.ServerAPIURL(), userID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostUsersIDPassword(ctx context.Context, userID string, params *PostUsersIDPasswordParams, body PostUsersIDPasswordJSONRequestBody) (*http.Response, error) {
	req, err := NewPostUsersIDPasswordRequest(c.service.ServerAPIURL(), userID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetVariables(ctx context.Context, params *GetVariablesParams) (*http.Response, error) {
	req, err := NewGetVariablesRequest(c.service.ServerAPIURL(), params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostVariablesWithBody(ctx context.Context, params *PostVariablesParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostVariablesRequestWithBody(c.service.ServerAPIURL(), params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostVariables(ctx context.Context, params *PostVariablesParams, body PostVariablesJSONRequestBody) (*http.Response, error) {
	req, err := NewPostVariablesRequest(c.service.ServerAPIURL(), params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteVariablesID(ctx context.Context, variableID string, params *DeleteVariablesIDParams) (*http.Response, error) {
	req, err := NewDeleteVariablesIDRequest(c.service.ServerAPIURL(), variableID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetVariablesID(ctx context.Context, variableID string, params *GetVariablesIDParams) (*http.Response, error) {
	req, err := NewGetVariablesIDRequest(c.service.ServerAPIURL(), variableID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PatchVariablesIDWithBody(ctx context.Context, variableID string, params *PatchVariablesIDParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPatchVariablesIDRequestWithBody(c.service.ServerAPIURL(), variableID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PatchVariablesID(ctx context.Context, variableID string, params *PatchVariablesIDParams, body PatchVariablesIDJSONRequestBody) (*http.Response, error) {
	req, err := NewPatchVariablesIDRequest(c.service.ServerAPIURL(), variableID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PutVariablesIDWithBody(ctx context.Context, variableID string, params *PutVariablesIDParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPutVariablesIDRequestWithBody(c.service.ServerAPIURL(), variableID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PutVariablesID(ctx context.Context, variableID string, params *PutVariablesIDParams, body PutVariablesIDJSONRequestBody) (*http.Response, error) {
	req, err := NewPutVariablesIDRequest(c.service.ServerAPIURL(), variableID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetVariablesIDLabels(ctx context.Context, variableID string, params *GetVariablesIDLabelsParams) (*http.Response, error) {
	req, err := NewGetVariablesIDLabelsRequest(c.service.ServerAPIURL(), variableID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostVariablesIDLabelsWithBody(ctx context.Context, variableID string, params *PostVariablesIDLabelsParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostVariablesIDLabelsRequestWithBody(c.service.ServerAPIURL(), variableID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostVariablesIDLabels(ctx context.Context, variableID string, params *PostVariablesIDLabelsParams, body PostVariablesIDLabelsJSONRequestBody) (*http.Response, error) {
	req, err := NewPostVariablesIDLabelsRequest(c.service.ServerAPIURL(), variableID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteVariablesIDLabelsID(ctx context.Context, variableID string, labelID string, params *DeleteVariablesIDLabelsIDParams) (*http.Response, error) {
	req, err := NewDeleteVariablesIDLabelsIDRequest(c.service.ServerAPIURL(), variableID, labelID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostWriteWithBody(ctx context.Context, params *PostWriteParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostWriteRequestWithBody(c.service.ServerAPIURL(), params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

// NewGetRoutesRequest generates requests for GetRoutes
func NewGetRoutesRequest(server string, params *GetRoutesParams) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetAuthorizationsRequest generates requests for GetAuthorizations
func NewGetAuthorizationsRequest(server string, params *GetAuthorizationsParams) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/authorizations")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if params.UserID != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "userID", *params.UserID); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.User != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "user", *params.User); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.OrgID != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "orgID", *params.OrgID); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Org != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "org", *params.Org); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPostAuthorizationsRequest calls the generic PostAuthorizations builder with application/json body
func NewPostAuthorizationsRequest(server string, params *PostAuthorizationsParams, body PostAuthorizationsJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostAuthorizationsRequestWithBody(server, params, "application/json", bodyReader)
}

// NewPostAuthorizationsRequestWithBody generates requests for PostAuthorizations with any type of body
func NewPostAuthorizationsRequestWithBody(server string, params *PostAuthorizationsParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/authorizations")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteAuthorizationsIDRequest generates requests for DeleteAuthorizationsID
func NewDeleteAuthorizationsIDRequest(server string, authID string, params *DeleteAuthorizationsIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "authID", authID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/authorizations/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetAuthorizationsIDRequest generates requests for GetAuthorizationsID
func NewGetAuthorizationsIDRequest(server string, authID string, params *GetAuthorizationsIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "authID", authID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/authorizations/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPatchAuthorizationsIDRequest calls the generic PatchAuthorizationsID builder with application/json body
func NewPatchAuthorizationsIDRequest(server string, authID string, params *PatchAuthorizationsIDParams, body PatchAuthorizationsIDJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPatchAuthorizationsIDRequestWithBody(server, authID, params, "application/json", bodyReader)
}

// NewPatchAuthorizationsIDRequestWithBody generates requests for PatchAuthorizationsID with any type of body
func NewPatchAuthorizationsIDRequestWithBody(server string, authID string, params *PatchAuthorizationsIDParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "authID", authID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/authorizations/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PATCH", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewGetBucketsRequest generates requests for GetBuckets
func NewGetBucketsRequest(server string, params *GetBucketsParams) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/buckets")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if params.Offset != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "offset", *params.Offset); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Limit != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "limit", *params.Limit); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Org != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "org", *params.Org); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.OrgID != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "orgID", *params.OrgID); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Name != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "name", *params.Name); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPostBucketsRequest calls the generic PostBuckets builder with application/json body
func NewPostBucketsRequest(server string, params *PostBucketsParams, body PostBucketsJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostBucketsRequestWithBody(server, params, "application/json", bodyReader)
}

// NewPostBucketsRequestWithBody generates requests for PostBuckets with any type of body
func NewPostBucketsRequestWithBody(server string, params *PostBucketsParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/buckets")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteBucketsIDRequest generates requests for DeleteBucketsID
func NewDeleteBucketsIDRequest(server string, bucketID string, params *DeleteBucketsIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "bucketID", bucketID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/buckets/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetBucketsIDRequest generates requests for GetBucketsID
func NewGetBucketsIDRequest(server string, bucketID string, params *GetBucketsIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "bucketID", bucketID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/buckets/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPatchBucketsIDRequest calls the generic PatchBucketsID builder with application/json body
func NewPatchBucketsIDRequest(server string, bucketID string, params *PatchBucketsIDParams, body PatchBucketsIDJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPatchBucketsIDRequestWithBody(server, bucketID, params, "application/json", bodyReader)
}

// NewPatchBucketsIDRequestWithBody generates requests for PatchBucketsID with any type of body
func NewPatchBucketsIDRequestWithBody(server string, bucketID string, params *PatchBucketsIDParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "bucketID", bucketID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/buckets/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PATCH", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewGetBucketsIDLabelsRequest generates requests for GetBucketsIDLabels
func NewGetBucketsIDLabelsRequest(server string, bucketID string, params *GetBucketsIDLabelsParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "bucketID", bucketID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/buckets/%s/labels", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPostBucketsIDLabelsRequest calls the generic PostBucketsIDLabels builder with application/json body
func NewPostBucketsIDLabelsRequest(server string, bucketID string, params *PostBucketsIDLabelsParams, body PostBucketsIDLabelsJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostBucketsIDLabelsRequestWithBody(server, bucketID, params, "application/json", bodyReader)
}

// NewPostBucketsIDLabelsRequestWithBody generates requests for PostBucketsIDLabels with any type of body
func NewPostBucketsIDLabelsRequestWithBody(server string, bucketID string, params *PostBucketsIDLabelsParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "bucketID", bucketID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/buckets/%s/labels", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteBucketsIDLabelsIDRequest generates requests for DeleteBucketsIDLabelsID
func NewDeleteBucketsIDLabelsIDRequest(server string, bucketID string, labelID string, params *DeleteBucketsIDLabelsIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "bucketID", bucketID)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParam("simple", false, "labelID", labelID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/buckets/%s/labels/%s", pathParam0, pathParam1)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetBucketsIDMembersRequest generates requests for GetBucketsIDMembers
func NewGetBucketsIDMembersRequest(server string, bucketID string, params *GetBucketsIDMembersParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "bucketID", bucketID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/buckets/%s/members", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPostBucketsIDMembersRequest calls the generic PostBucketsIDMembers builder with application/json body
func NewPostBucketsIDMembersRequest(server string, bucketID string, params *PostBucketsIDMembersParams, body PostBucketsIDMembersJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostBucketsIDMembersRequestWithBody(server, bucketID, params, "application/json", bodyReader)
}

// NewPostBucketsIDMembersRequestWithBody generates requests for PostBucketsIDMembers with any type of body
func NewPostBucketsIDMembersRequestWithBody(server string, bucketID string, params *PostBucketsIDMembersParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "bucketID", bucketID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/buckets/%s/members", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteBucketsIDMembersIDRequest generates requests for DeleteBucketsIDMembersID
func NewDeleteBucketsIDMembersIDRequest(server string, bucketID string, userID string, params *DeleteBucketsIDMembersIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "bucketID", bucketID)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParam("simple", false, "userID", userID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/buckets/%s/members/%s", pathParam0, pathParam1)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetBucketsIDOwnersRequest generates requests for GetBucketsIDOwners
func NewGetBucketsIDOwnersRequest(server string, bucketID string, params *GetBucketsIDOwnersParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "bucketID", bucketID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/buckets/%s/owners", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPostBucketsIDOwnersRequest calls the generic PostBucketsIDOwners builder with application/json body
func NewPostBucketsIDOwnersRequest(server string, bucketID string, params *PostBucketsIDOwnersParams, body PostBucketsIDOwnersJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostBucketsIDOwnersRequestWithBody(server, bucketID, params, "application/json", bodyReader)
}

// NewPostBucketsIDOwnersRequestWithBody generates requests for PostBucketsIDOwners with any type of body
func NewPostBucketsIDOwnersRequestWithBody(server string, bucketID string, params *PostBucketsIDOwnersParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "bucketID", bucketID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/buckets/%s/owners", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteBucketsIDOwnersIDRequest generates requests for DeleteBucketsIDOwnersID
func NewDeleteBucketsIDOwnersIDRequest(server string, bucketID string, userID string, params *DeleteBucketsIDOwnersIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "bucketID", bucketID)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParam("simple", false, "userID", userID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/buckets/%s/owners/%s", pathParam0, pathParam1)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetChecksRequest generates requests for GetChecks
func NewGetChecksRequest(server string, params *GetChecksParams) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/checks")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if params.Offset != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "offset", *params.Offset); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Limit != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "limit", *params.Limit); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if queryFrag, err := runtime.StyleParam("form", true, "orgID", params.OrgID); err != nil {
		return nil, err
	} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
		return nil, err
	} else {
		for k, v := range parsed {
			for _, v2 := range v {
				queryValues.Add(k, v2)
			}
		}
	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewCreateCheckRequest calls the generic CreateCheck builder with application/json body
func NewCreateCheckRequest(server string, body CreateCheckJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewCreateCheckRequestWithBody(server, "application/json", bodyReader)
}

// NewCreateCheckRequestWithBody generates requests for CreateCheck with any type of body
func NewCreateCheckRequestWithBody(server string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/checks")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteChecksIDRequest generates requests for DeleteChecksID
func NewDeleteChecksIDRequest(server string, checkID string, params *DeleteChecksIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "checkID", checkID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/checks/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetChecksIDRequest generates requests for GetChecksID
func NewGetChecksIDRequest(server string, checkID string, params *GetChecksIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "checkID", checkID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/checks/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPatchChecksIDRequest calls the generic PatchChecksID builder with application/json body
func NewPatchChecksIDRequest(server string, checkID string, params *PatchChecksIDParams, body PatchChecksIDJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPatchChecksIDRequestWithBody(server, checkID, params, "application/json", bodyReader)
}

// NewPatchChecksIDRequestWithBody generates requests for PatchChecksID with any type of body
func NewPatchChecksIDRequestWithBody(server string, checkID string, params *PatchChecksIDParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "checkID", checkID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/checks/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PATCH", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewPutChecksIDRequest calls the generic PutChecksID builder with application/json body
func NewPutChecksIDRequest(server string, checkID string, params *PutChecksIDParams, body PutChecksIDJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPutChecksIDRequestWithBody(server, checkID, params, "application/json", bodyReader)
}

// NewPutChecksIDRequestWithBody generates requests for PutChecksID with any type of body
func NewPutChecksIDRequestWithBody(server string, checkID string, params *PutChecksIDParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "checkID", checkID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/checks/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewGetChecksIDLabelsRequest generates requests for GetChecksIDLabels
func NewGetChecksIDLabelsRequest(server string, checkID string, params *GetChecksIDLabelsParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "checkID", checkID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/checks/%s/labels", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPostChecksIDLabelsRequest calls the generic PostChecksIDLabels builder with application/json body
func NewPostChecksIDLabelsRequest(server string, checkID string, params *PostChecksIDLabelsParams, body PostChecksIDLabelsJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostChecksIDLabelsRequestWithBody(server, checkID, params, "application/json", bodyReader)
}

// NewPostChecksIDLabelsRequestWithBody generates requests for PostChecksIDLabels with any type of body
func NewPostChecksIDLabelsRequestWithBody(server string, checkID string, params *PostChecksIDLabelsParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "checkID", checkID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/checks/%s/labels", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteChecksIDLabelsIDRequest generates requests for DeleteChecksIDLabelsID
func NewDeleteChecksIDLabelsIDRequest(server string, checkID string, labelID string, params *DeleteChecksIDLabelsIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "checkID", checkID)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParam("simple", false, "labelID", labelID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/checks/%s/labels/%s", pathParam0, pathParam1)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetChecksIDQueryRequest generates requests for GetChecksIDQuery
func NewGetChecksIDQueryRequest(server string, checkID string, params *GetChecksIDQueryParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "checkID", checkID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/checks/%s/query", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetDashboardsRequest generates requests for GetDashboards
func NewGetDashboardsRequest(server string, params *GetDashboardsParams) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/dashboards")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if params.Owner != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "owner", *params.Owner); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.SortBy != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "sortBy", *params.SortBy); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Id != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "id", *params.Id); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.OrgID != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "orgID", *params.OrgID); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Org != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "org", *params.Org); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPostDashboardsRequest calls the generic PostDashboards builder with application/json body
func NewPostDashboardsRequest(server string, params *PostDashboardsParams, body PostDashboardsJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostDashboardsRequestWithBody(server, params, "application/json", bodyReader)
}

// NewPostDashboardsRequestWithBody generates requests for PostDashboards with any type of body
func NewPostDashboardsRequestWithBody(server string, params *PostDashboardsParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/dashboards")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteDashboardsIDRequest generates requests for DeleteDashboardsID
func NewDeleteDashboardsIDRequest(server string, dashboardID string, params *DeleteDashboardsIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "dashboardID", dashboardID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/dashboards/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetDashboardsIDRequest generates requests for GetDashboardsID
func NewGetDashboardsIDRequest(server string, dashboardID string, params *GetDashboardsIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "dashboardID", dashboardID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/dashboards/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if params.Include != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "include", *params.Include); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPatchDashboardsIDRequest calls the generic PatchDashboardsID builder with application/json body
func NewPatchDashboardsIDRequest(server string, dashboardID string, params *PatchDashboardsIDParams, body PatchDashboardsIDJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPatchDashboardsIDRequestWithBody(server, dashboardID, params, "application/json", bodyReader)
}

// NewPatchDashboardsIDRequestWithBody generates requests for PatchDashboardsID with any type of body
func NewPatchDashboardsIDRequestWithBody(server string, dashboardID string, params *PatchDashboardsIDParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "dashboardID", dashboardID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/dashboards/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PATCH", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewPostDashboardsIDCellsRequest calls the generic PostDashboardsIDCells builder with application/json body
func NewPostDashboardsIDCellsRequest(server string, dashboardID string, params *PostDashboardsIDCellsParams, body PostDashboardsIDCellsJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostDashboardsIDCellsRequestWithBody(server, dashboardID, params, "application/json", bodyReader)
}

// NewPostDashboardsIDCellsRequestWithBody generates requests for PostDashboardsIDCells with any type of body
func NewPostDashboardsIDCellsRequestWithBody(server string, dashboardID string, params *PostDashboardsIDCellsParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "dashboardID", dashboardID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/dashboards/%s/cells", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewPutDashboardsIDCellsRequest calls the generic PutDashboardsIDCells builder with application/json body
func NewPutDashboardsIDCellsRequest(server string, dashboardID string, params *PutDashboardsIDCellsParams, body PutDashboardsIDCellsJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPutDashboardsIDCellsRequestWithBody(server, dashboardID, params, "application/json", bodyReader)
}

// NewPutDashboardsIDCellsRequestWithBody generates requests for PutDashboardsIDCells with any type of body
func NewPutDashboardsIDCellsRequestWithBody(server string, dashboardID string, params *PutDashboardsIDCellsParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "dashboardID", dashboardID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/dashboards/%s/cells", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteDashboardsIDCellsIDRequest generates requests for DeleteDashboardsIDCellsID
func NewDeleteDashboardsIDCellsIDRequest(server string, dashboardID string, cellID string, params *DeleteDashboardsIDCellsIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "dashboardID", dashboardID)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParam("simple", false, "cellID", cellID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/dashboards/%s/cells/%s", pathParam0, pathParam1)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPatchDashboardsIDCellsIDRequest calls the generic PatchDashboardsIDCellsID builder with application/json body
func NewPatchDashboardsIDCellsIDRequest(server string, dashboardID string, cellID string, params *PatchDashboardsIDCellsIDParams, body PatchDashboardsIDCellsIDJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPatchDashboardsIDCellsIDRequestWithBody(server, dashboardID, cellID, params, "application/json", bodyReader)
}

// NewPatchDashboardsIDCellsIDRequestWithBody generates requests for PatchDashboardsIDCellsID with any type of body
func NewPatchDashboardsIDCellsIDRequestWithBody(server string, dashboardID string, cellID string, params *PatchDashboardsIDCellsIDParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "dashboardID", dashboardID)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParam("simple", false, "cellID", cellID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/dashboards/%s/cells/%s", pathParam0, pathParam1)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PATCH", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewGetDashboardsIDCellsIDViewRequest generates requests for GetDashboardsIDCellsIDView
func NewGetDashboardsIDCellsIDViewRequest(server string, dashboardID string, cellID string, params *GetDashboardsIDCellsIDViewParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "dashboardID", dashboardID)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParam("simple", false, "cellID", cellID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/dashboards/%s/cells/%s/view", pathParam0, pathParam1)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPatchDashboardsIDCellsIDViewRequest calls the generic PatchDashboardsIDCellsIDView builder with application/json body
func NewPatchDashboardsIDCellsIDViewRequest(server string, dashboardID string, cellID string, params *PatchDashboardsIDCellsIDViewParams, body PatchDashboardsIDCellsIDViewJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPatchDashboardsIDCellsIDViewRequestWithBody(server, dashboardID, cellID, params, "application/json", bodyReader)
}

// NewPatchDashboardsIDCellsIDViewRequestWithBody generates requests for PatchDashboardsIDCellsIDView with any type of body
func NewPatchDashboardsIDCellsIDViewRequestWithBody(server string, dashboardID string, cellID string, params *PatchDashboardsIDCellsIDViewParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "dashboardID", dashboardID)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParam("simple", false, "cellID", cellID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/dashboards/%s/cells/%s/view", pathParam0, pathParam1)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PATCH", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewGetDashboardsIDLabelsRequest generates requests for GetDashboardsIDLabels
func NewGetDashboardsIDLabelsRequest(server string, dashboardID string, params *GetDashboardsIDLabelsParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "dashboardID", dashboardID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/dashboards/%s/labels", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPostDashboardsIDLabelsRequest calls the generic PostDashboardsIDLabels builder with application/json body
func NewPostDashboardsIDLabelsRequest(server string, dashboardID string, params *PostDashboardsIDLabelsParams, body PostDashboardsIDLabelsJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostDashboardsIDLabelsRequestWithBody(server, dashboardID, params, "application/json", bodyReader)
}

// NewPostDashboardsIDLabelsRequestWithBody generates requests for PostDashboardsIDLabels with any type of body
func NewPostDashboardsIDLabelsRequestWithBody(server string, dashboardID string, params *PostDashboardsIDLabelsParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "dashboardID", dashboardID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/dashboards/%s/labels", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteDashboardsIDLabelsIDRequest generates requests for DeleteDashboardsIDLabelsID
func NewDeleteDashboardsIDLabelsIDRequest(server string, dashboardID string, labelID string, params *DeleteDashboardsIDLabelsIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "dashboardID", dashboardID)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParam("simple", false, "labelID", labelID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/dashboards/%s/labels/%s", pathParam0, pathParam1)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetDashboardsIDMembersRequest generates requests for GetDashboardsIDMembers
func NewGetDashboardsIDMembersRequest(server string, dashboardID string, params *GetDashboardsIDMembersParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "dashboardID", dashboardID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/dashboards/%s/members", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPostDashboardsIDMembersRequest calls the generic PostDashboardsIDMembers builder with application/json body
func NewPostDashboardsIDMembersRequest(server string, dashboardID string, params *PostDashboardsIDMembersParams, body PostDashboardsIDMembersJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostDashboardsIDMembersRequestWithBody(server, dashboardID, params, "application/json", bodyReader)
}

// NewPostDashboardsIDMembersRequestWithBody generates requests for PostDashboardsIDMembers with any type of body
func NewPostDashboardsIDMembersRequestWithBody(server string, dashboardID string, params *PostDashboardsIDMembersParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "dashboardID", dashboardID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/dashboards/%s/members", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteDashboardsIDMembersIDRequest generates requests for DeleteDashboardsIDMembersID
func NewDeleteDashboardsIDMembersIDRequest(server string, dashboardID string, userID string, params *DeleteDashboardsIDMembersIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "dashboardID", dashboardID)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParam("simple", false, "userID", userID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/dashboards/%s/members/%s", pathParam0, pathParam1)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetDashboardsIDOwnersRequest generates requests for GetDashboardsIDOwners
func NewGetDashboardsIDOwnersRequest(server string, dashboardID string, params *GetDashboardsIDOwnersParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "dashboardID", dashboardID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/dashboards/%s/owners", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPostDashboardsIDOwnersRequest calls the generic PostDashboardsIDOwners builder with application/json body
func NewPostDashboardsIDOwnersRequest(server string, dashboardID string, params *PostDashboardsIDOwnersParams, body PostDashboardsIDOwnersJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostDashboardsIDOwnersRequestWithBody(server, dashboardID, params, "application/json", bodyReader)
}

// NewPostDashboardsIDOwnersRequestWithBody generates requests for PostDashboardsIDOwners with any type of body
func NewPostDashboardsIDOwnersRequestWithBody(server string, dashboardID string, params *PostDashboardsIDOwnersParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "dashboardID", dashboardID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/dashboards/%s/owners", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteDashboardsIDOwnersIDRequest generates requests for DeleteDashboardsIDOwnersID
func NewDeleteDashboardsIDOwnersIDRequest(server string, dashboardID string, userID string, params *DeleteDashboardsIDOwnersIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "dashboardID", dashboardID)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParam("simple", false, "userID", userID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/dashboards/%s/owners/%s", pathParam0, pathParam1)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetDBRPsRequest generates requests for GetDBRPs
func NewGetDBRPsRequest(server string, params *GetDBRPsParams) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/dbrps")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if queryFrag, err := runtime.StyleParam("form", true, "orgID", params.OrgID); err != nil {
		return nil, err
	} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
		return nil, err
	} else {
		for k, v := range parsed {
			for _, v2 := range v {
				queryValues.Add(k, v2)
			}
		}
	}

	if params.Id != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "id", *params.Id); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.BucketID != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "bucketID", *params.BucketID); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Default != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "default", *params.Default); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Db != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "db", *params.Db); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Rp != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "rp", *params.Rp); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPostDBRPRequest calls the generic PostDBRP builder with application/json body
func NewPostDBRPRequest(server string, params *PostDBRPParams, body PostDBRPJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostDBRPRequestWithBody(server, params, "application/json", bodyReader)
}

// NewPostDBRPRequestWithBody generates requests for PostDBRP with any type of body
func NewPostDBRPRequestWithBody(server string, params *PostDBRPParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/dbrps")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteDBRPIDRequest generates requests for DeleteDBRPID
func NewDeleteDBRPIDRequest(server string, dbrpID string, params *DeleteDBRPIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "dbrpID", dbrpID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/dbrps/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if queryFrag, err := runtime.StyleParam("form", true, "orgID", params.OrgID); err != nil {
		return nil, err
	} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
		return nil, err
	} else {
		for k, v := range parsed {
			for _, v2 := range v {
				queryValues.Add(k, v2)
			}
		}
	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetDBRPsIDRequest generates requests for GetDBRPsID
func NewGetDBRPsIDRequest(server string, dbrpID string, params *GetDBRPsIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "dbrpID", dbrpID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/dbrps/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if queryFrag, err := runtime.StyleParam("form", true, "orgID", params.OrgID); err != nil {
		return nil, err
	} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
		return nil, err
	} else {
		for k, v := range parsed {
			for _, v2 := range v {
				queryValues.Add(k, v2)
			}
		}
	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPatchDBRPIDRequest calls the generic PatchDBRPID builder with application/json body
func NewPatchDBRPIDRequest(server string, dbrpID string, params *PatchDBRPIDParams, body PatchDBRPIDJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPatchDBRPIDRequestWithBody(server, dbrpID, params, "application/json", bodyReader)
}

// NewPatchDBRPIDRequestWithBody generates requests for PatchDBRPID with any type of body
func NewPatchDBRPIDRequestWithBody(server string, dbrpID string, params *PatchDBRPIDParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "dbrpID", dbrpID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/dbrps/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if queryFrag, err := runtime.StyleParam("form", true, "orgID", params.OrgID); err != nil {
		return nil, err
	} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
		return nil, err
	} else {
		for k, v := range parsed {
			for _, v2 := range v {
				queryValues.Add(k, v2)
			}
		}
	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("PATCH", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewPostDeleteRequest calls the generic PostDelete builder with application/json body
func NewPostDeleteRequest(server string, params *PostDeleteParams, body PostDeleteJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostDeleteRequestWithBody(server, params, "application/json", bodyReader)
}

// NewPostDeleteRequestWithBody generates requests for PostDelete with any type of body
func NewPostDeleteRequestWithBody(server string, params *PostDeleteParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/delete")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if params.Org != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "org", *params.Org); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Bucket != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "bucket", *params.Bucket); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.OrgID != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "orgID", *params.OrgID); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.BucketID != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "bucketID", *params.BucketID); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewGetDocumentsTemplatesRequest generates requests for GetDocumentsTemplates
func NewGetDocumentsTemplatesRequest(server string, params *GetDocumentsTemplatesParams) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/documents/templates")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if params.Org != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "org", *params.Org); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.OrgID != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "orgID", *params.OrgID); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPostDocumentsTemplatesRequest calls the generic PostDocumentsTemplates builder with application/json body
func NewPostDocumentsTemplatesRequest(server string, params *PostDocumentsTemplatesParams, body PostDocumentsTemplatesJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostDocumentsTemplatesRequestWithBody(server, params, "application/json", bodyReader)
}

// NewPostDocumentsTemplatesRequestWithBody generates requests for PostDocumentsTemplates with any type of body
func NewPostDocumentsTemplatesRequestWithBody(server string, params *PostDocumentsTemplatesParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/documents/templates")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteDocumentsTemplatesIDRequest generates requests for DeleteDocumentsTemplatesID
func NewDeleteDocumentsTemplatesIDRequest(server string, templateID string, params *DeleteDocumentsTemplatesIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "templateID", templateID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/documents/templates/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetDocumentsTemplatesIDRequest generates requests for GetDocumentsTemplatesID
func NewGetDocumentsTemplatesIDRequest(server string, templateID string, params *GetDocumentsTemplatesIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "templateID", templateID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/documents/templates/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPutDocumentsTemplatesIDRequest calls the generic PutDocumentsTemplatesID builder with application/json body
func NewPutDocumentsTemplatesIDRequest(server string, templateID string, params *PutDocumentsTemplatesIDParams, body PutDocumentsTemplatesIDJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPutDocumentsTemplatesIDRequestWithBody(server, templateID, params, "application/json", bodyReader)
}

// NewPutDocumentsTemplatesIDRequestWithBody generates requests for PutDocumentsTemplatesID with any type of body
func NewPutDocumentsTemplatesIDRequestWithBody(server string, templateID string, params *PutDocumentsTemplatesIDParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "templateID", templateID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/documents/templates/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewGetDocumentsTemplatesIDLabelsRequest generates requests for GetDocumentsTemplatesIDLabels
func NewGetDocumentsTemplatesIDLabelsRequest(server string, templateID string, params *GetDocumentsTemplatesIDLabelsParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "templateID", templateID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/documents/templates/%s/labels", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPostDocumentsTemplatesIDLabelsRequest calls the generic PostDocumentsTemplatesIDLabels builder with application/json body
func NewPostDocumentsTemplatesIDLabelsRequest(server string, templateID string, params *PostDocumentsTemplatesIDLabelsParams, body PostDocumentsTemplatesIDLabelsJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostDocumentsTemplatesIDLabelsRequestWithBody(server, templateID, params, "application/json", bodyReader)
}

// NewPostDocumentsTemplatesIDLabelsRequestWithBody generates requests for PostDocumentsTemplatesIDLabels with any type of body
func NewPostDocumentsTemplatesIDLabelsRequestWithBody(server string, templateID string, params *PostDocumentsTemplatesIDLabelsParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "templateID", templateID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/documents/templates/%s/labels", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteDocumentsTemplatesIDLabelsIDRequest generates requests for DeleteDocumentsTemplatesIDLabelsID
func NewDeleteDocumentsTemplatesIDLabelsIDRequest(server string, templateID string, labelID string, params *DeleteDocumentsTemplatesIDLabelsIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "templateID", templateID)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParam("simple", false, "labelID", labelID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/documents/templates/%s/labels/%s", pathParam0, pathParam1)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetFlagsRequest generates requests for GetFlags
func NewGetFlagsRequest(server string, params *GetFlagsParams) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/flags")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetHealthRequest generates requests for GetHealth
func NewGetHealthRequest(server string, params *GetHealthParams) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/health")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetLabelsRequest generates requests for GetLabels
func NewGetLabelsRequest(server string, params *GetLabelsParams) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/labels")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if params.OrgID != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "orgID", *params.OrgID); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPostLabelsRequest calls the generic PostLabels builder with application/json body
func NewPostLabelsRequest(server string, body PostLabelsJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostLabelsRequestWithBody(server, "application/json", bodyReader)
}

// NewPostLabelsRequestWithBody generates requests for PostLabels with any type of body
func NewPostLabelsRequestWithBody(server string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/labels")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteLabelsIDRequest generates requests for DeleteLabelsID
func NewDeleteLabelsIDRequest(server string, labelID string, params *DeleteLabelsIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "labelID", labelID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/labels/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetLabelsIDRequest generates requests for GetLabelsID
func NewGetLabelsIDRequest(server string, labelID string, params *GetLabelsIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "labelID", labelID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/labels/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPatchLabelsIDRequest calls the generic PatchLabelsID builder with application/json body
func NewPatchLabelsIDRequest(server string, labelID string, params *PatchLabelsIDParams, body PatchLabelsIDJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPatchLabelsIDRequestWithBody(server, labelID, params, "application/json", bodyReader)
}

// NewPatchLabelsIDRequestWithBody generates requests for PatchLabelsID with any type of body
func NewPatchLabelsIDRequestWithBody(server string, labelID string, params *PatchLabelsIDParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "labelID", labelID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/labels/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PATCH", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewGetMeRequest generates requests for GetMe
func NewGetMeRequest(server string, params *GetMeParams) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/me")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPutMePasswordRequest calls the generic PutMePassword builder with application/json body
func NewPutMePasswordRequest(server string, params *PutMePasswordParams, body PutMePasswordJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPutMePasswordRequestWithBody(server, params, "application/json", bodyReader)
}

// NewPutMePasswordRequestWithBody generates requests for PutMePassword with any type of body
func NewPutMePasswordRequestWithBody(server string, params *PutMePasswordParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/me/password")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewGetNotificationEndpointsRequest generates requests for GetNotificationEndpoints
func NewGetNotificationEndpointsRequest(server string, params *GetNotificationEndpointsParams) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/notificationEndpoints")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if params.Offset != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "offset", *params.Offset); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Limit != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "limit", *params.Limit); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if queryFrag, err := runtime.StyleParam("form", true, "orgID", params.OrgID); err != nil {
		return nil, err
	} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
		return nil, err
	} else {
		for k, v := range parsed {
			for _, v2 := range v {
				queryValues.Add(k, v2)
			}
		}
	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewCreateNotificationEndpointRequest calls the generic CreateNotificationEndpoint builder with application/json body
func NewCreateNotificationEndpointRequest(server string, body CreateNotificationEndpointJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewCreateNotificationEndpointRequestWithBody(server, "application/json", bodyReader)
}

// NewCreateNotificationEndpointRequestWithBody generates requests for CreateNotificationEndpoint with any type of body
func NewCreateNotificationEndpointRequestWithBody(server string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/notificationEndpoints")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteNotificationEndpointsIDRequest generates requests for DeleteNotificationEndpointsID
func NewDeleteNotificationEndpointsIDRequest(server string, endpointID string, params *DeleteNotificationEndpointsIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "endpointID", endpointID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/notificationEndpoints/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetNotificationEndpointsIDRequest generates requests for GetNotificationEndpointsID
func NewGetNotificationEndpointsIDRequest(server string, endpointID string, params *GetNotificationEndpointsIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "endpointID", endpointID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/notificationEndpoints/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPatchNotificationEndpointsIDRequest calls the generic PatchNotificationEndpointsID builder with application/json body
func NewPatchNotificationEndpointsIDRequest(server string, endpointID string, params *PatchNotificationEndpointsIDParams, body PatchNotificationEndpointsIDJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPatchNotificationEndpointsIDRequestWithBody(server, endpointID, params, "application/json", bodyReader)
}

// NewPatchNotificationEndpointsIDRequestWithBody generates requests for PatchNotificationEndpointsID with any type of body
func NewPatchNotificationEndpointsIDRequestWithBody(server string, endpointID string, params *PatchNotificationEndpointsIDParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "endpointID", endpointID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/notificationEndpoints/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PATCH", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewPutNotificationEndpointsIDRequest calls the generic PutNotificationEndpointsID builder with application/json body
func NewPutNotificationEndpointsIDRequest(server string, endpointID string, params *PutNotificationEndpointsIDParams, body PutNotificationEndpointsIDJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPutNotificationEndpointsIDRequestWithBody(server, endpointID, params, "application/json", bodyReader)
}

// NewPutNotificationEndpointsIDRequestWithBody generates requests for PutNotificationEndpointsID with any type of body
func NewPutNotificationEndpointsIDRequestWithBody(server string, endpointID string, params *PutNotificationEndpointsIDParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "endpointID", endpointID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/notificationEndpoints/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewGetNotificationEndpointsIDLabelsRequest generates requests for GetNotificationEndpointsIDLabels
func NewGetNotificationEndpointsIDLabelsRequest(server string, endpointID string, params *GetNotificationEndpointsIDLabelsParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "endpointID", endpointID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/notificationEndpoints/%s/labels", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPostNotificationEndpointIDLabelsRequest calls the generic PostNotificationEndpointIDLabels builder with application/json body
func NewPostNotificationEndpointIDLabelsRequest(server string, endpointID string, params *PostNotificationEndpointIDLabelsParams, body PostNotificationEndpointIDLabelsJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostNotificationEndpointIDLabelsRequestWithBody(server, endpointID, params, "application/json", bodyReader)
}

// NewPostNotificationEndpointIDLabelsRequestWithBody generates requests for PostNotificationEndpointIDLabels with any type of body
func NewPostNotificationEndpointIDLabelsRequestWithBody(server string, endpointID string, params *PostNotificationEndpointIDLabelsParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "endpointID", endpointID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/notificationEndpoints/%s/labels", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteNotificationEndpointsIDLabelsIDRequest generates requests for DeleteNotificationEndpointsIDLabelsID
func NewDeleteNotificationEndpointsIDLabelsIDRequest(server string, endpointID string, labelID string, params *DeleteNotificationEndpointsIDLabelsIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "endpointID", endpointID)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParam("simple", false, "labelID", labelID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/notificationEndpoints/%s/labels/%s", pathParam0, pathParam1)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetNotificationRulesRequest generates requests for GetNotificationRules
func NewGetNotificationRulesRequest(server string, params *GetNotificationRulesParams) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/notificationRules")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if params.Offset != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "offset", *params.Offset); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Limit != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "limit", *params.Limit); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if queryFrag, err := runtime.StyleParam("form", true, "orgID", params.OrgID); err != nil {
		return nil, err
	} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
		return nil, err
	} else {
		for k, v := range parsed {
			for _, v2 := range v {
				queryValues.Add(k, v2)
			}
		}
	}

	if params.CheckID != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "checkID", *params.CheckID); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Tag != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "tag", *params.Tag); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewCreateNotificationRuleRequest calls the generic CreateNotificationRule builder with application/json body
func NewCreateNotificationRuleRequest(server string, body CreateNotificationRuleJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewCreateNotificationRuleRequestWithBody(server, "application/json", bodyReader)
}

// NewCreateNotificationRuleRequestWithBody generates requests for CreateNotificationRule with any type of body
func NewCreateNotificationRuleRequestWithBody(server string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/notificationRules")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteNotificationRulesIDRequest generates requests for DeleteNotificationRulesID
func NewDeleteNotificationRulesIDRequest(server string, ruleID string, params *DeleteNotificationRulesIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "ruleID", ruleID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/notificationRules/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetNotificationRulesIDRequest generates requests for GetNotificationRulesID
func NewGetNotificationRulesIDRequest(server string, ruleID string, params *GetNotificationRulesIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "ruleID", ruleID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/notificationRules/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPatchNotificationRulesIDRequest calls the generic PatchNotificationRulesID builder with application/json body
func NewPatchNotificationRulesIDRequest(server string, ruleID string, params *PatchNotificationRulesIDParams, body PatchNotificationRulesIDJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPatchNotificationRulesIDRequestWithBody(server, ruleID, params, "application/json", bodyReader)
}

// NewPatchNotificationRulesIDRequestWithBody generates requests for PatchNotificationRulesID with any type of body
func NewPatchNotificationRulesIDRequestWithBody(server string, ruleID string, params *PatchNotificationRulesIDParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "ruleID", ruleID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/notificationRules/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PATCH", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewPutNotificationRulesIDRequest calls the generic PutNotificationRulesID builder with application/json body
func NewPutNotificationRulesIDRequest(server string, ruleID string, params *PutNotificationRulesIDParams, body PutNotificationRulesIDJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPutNotificationRulesIDRequestWithBody(server, ruleID, params, "application/json", bodyReader)
}

// NewPutNotificationRulesIDRequestWithBody generates requests for PutNotificationRulesID with any type of body
func NewPutNotificationRulesIDRequestWithBody(server string, ruleID string, params *PutNotificationRulesIDParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "ruleID", ruleID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/notificationRules/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewGetNotificationRulesIDLabelsRequest generates requests for GetNotificationRulesIDLabels
func NewGetNotificationRulesIDLabelsRequest(server string, ruleID string, params *GetNotificationRulesIDLabelsParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "ruleID", ruleID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/notificationRules/%s/labels", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPostNotificationRuleIDLabelsRequest calls the generic PostNotificationRuleIDLabels builder with application/json body
func NewPostNotificationRuleIDLabelsRequest(server string, ruleID string, params *PostNotificationRuleIDLabelsParams, body PostNotificationRuleIDLabelsJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostNotificationRuleIDLabelsRequestWithBody(server, ruleID, params, "application/json", bodyReader)
}

// NewPostNotificationRuleIDLabelsRequestWithBody generates requests for PostNotificationRuleIDLabels with any type of body
func NewPostNotificationRuleIDLabelsRequestWithBody(server string, ruleID string, params *PostNotificationRuleIDLabelsParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "ruleID", ruleID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/notificationRules/%s/labels", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteNotificationRulesIDLabelsIDRequest generates requests for DeleteNotificationRulesIDLabelsID
func NewDeleteNotificationRulesIDLabelsIDRequest(server string, ruleID string, labelID string, params *DeleteNotificationRulesIDLabelsIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "ruleID", ruleID)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParam("simple", false, "labelID", labelID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/notificationRules/%s/labels/%s", pathParam0, pathParam1)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetNotificationRulesIDQueryRequest generates requests for GetNotificationRulesIDQuery
func NewGetNotificationRulesIDQueryRequest(server string, ruleID string, params *GetNotificationRulesIDQueryParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "ruleID", ruleID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/notificationRules/%s/query", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetOrgsRequest generates requests for GetOrgs
func NewGetOrgsRequest(server string, params *GetOrgsParams) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/orgs")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if params.Org != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "org", *params.Org); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.OrgID != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "orgID", *params.OrgID); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.UserID != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "userID", *params.UserID); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPostOrgsRequest calls the generic PostOrgs builder with application/json body
func NewPostOrgsRequest(server string, params *PostOrgsParams, body PostOrgsJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostOrgsRequestWithBody(server, params, "application/json", bodyReader)
}

// NewPostOrgsRequestWithBody generates requests for PostOrgs with any type of body
func NewPostOrgsRequestWithBody(server string, params *PostOrgsParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/orgs")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteOrgsIDRequest generates requests for DeleteOrgsID
func NewDeleteOrgsIDRequest(server string, orgID string, params *DeleteOrgsIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "orgID", orgID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/orgs/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetOrgsIDRequest generates requests for GetOrgsID
func NewGetOrgsIDRequest(server string, orgID string, params *GetOrgsIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "orgID", orgID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/orgs/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPatchOrgsIDRequest calls the generic PatchOrgsID builder with application/json body
func NewPatchOrgsIDRequest(server string, orgID string, params *PatchOrgsIDParams, body PatchOrgsIDJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPatchOrgsIDRequestWithBody(server, orgID, params, "application/json", bodyReader)
}

// NewPatchOrgsIDRequestWithBody generates requests for PatchOrgsID with any type of body
func NewPatchOrgsIDRequestWithBody(server string, orgID string, params *PatchOrgsIDParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "orgID", orgID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/orgs/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PATCH", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewGetOrgsIDMembersRequest generates requests for GetOrgsIDMembers
func NewGetOrgsIDMembersRequest(server string, orgID string, params *GetOrgsIDMembersParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "orgID", orgID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/orgs/%s/members", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPostOrgsIDMembersRequest calls the generic PostOrgsIDMembers builder with application/json body
func NewPostOrgsIDMembersRequest(server string, orgID string, params *PostOrgsIDMembersParams, body PostOrgsIDMembersJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostOrgsIDMembersRequestWithBody(server, orgID, params, "application/json", bodyReader)
}

// NewPostOrgsIDMembersRequestWithBody generates requests for PostOrgsIDMembers with any type of body
func NewPostOrgsIDMembersRequestWithBody(server string, orgID string, params *PostOrgsIDMembersParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "orgID", orgID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/orgs/%s/members", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteOrgsIDMembersIDRequest generates requests for DeleteOrgsIDMembersID
func NewDeleteOrgsIDMembersIDRequest(server string, orgID string, userID string, params *DeleteOrgsIDMembersIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "orgID", orgID)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParam("simple", false, "userID", userID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/orgs/%s/members/%s", pathParam0, pathParam1)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetOrgsIDOwnersRequest generates requests for GetOrgsIDOwners
func NewGetOrgsIDOwnersRequest(server string, orgID string, params *GetOrgsIDOwnersParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "orgID", orgID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/orgs/%s/owners", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPostOrgsIDOwnersRequest calls the generic PostOrgsIDOwners builder with application/json body
func NewPostOrgsIDOwnersRequest(server string, orgID string, params *PostOrgsIDOwnersParams, body PostOrgsIDOwnersJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostOrgsIDOwnersRequestWithBody(server, orgID, params, "application/json", bodyReader)
}

// NewPostOrgsIDOwnersRequestWithBody generates requests for PostOrgsIDOwners with any type of body
func NewPostOrgsIDOwnersRequestWithBody(server string, orgID string, params *PostOrgsIDOwnersParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "orgID", orgID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/orgs/%s/owners", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteOrgsIDOwnersIDRequest generates requests for DeleteOrgsIDOwnersID
func NewDeleteOrgsIDOwnersIDRequest(server string, orgID string, userID string, params *DeleteOrgsIDOwnersIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "orgID", orgID)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParam("simple", false, "userID", userID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/orgs/%s/owners/%s", pathParam0, pathParam1)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetOrgsIDSecretsRequest generates requests for GetOrgsIDSecrets
func NewGetOrgsIDSecretsRequest(server string, orgID string, params *GetOrgsIDSecretsParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "orgID", orgID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/orgs/%s/secrets", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPatchOrgsIDSecretsRequest calls the generic PatchOrgsIDSecrets builder with application/json body
func NewPatchOrgsIDSecretsRequest(server string, orgID string, params *PatchOrgsIDSecretsParams, body PatchOrgsIDSecretsJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPatchOrgsIDSecretsRequestWithBody(server, orgID, params, "application/json", bodyReader)
}

// NewPatchOrgsIDSecretsRequestWithBody generates requests for PatchOrgsIDSecrets with any type of body
func NewPatchOrgsIDSecretsRequestWithBody(server string, orgID string, params *PatchOrgsIDSecretsParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "orgID", orgID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/orgs/%s/secrets", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PATCH", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewPostOrgsIDSecretsRequest calls the generic PostOrgsIDSecrets builder with application/json body
func NewPostOrgsIDSecretsRequest(server string, orgID string, params *PostOrgsIDSecretsParams, body PostOrgsIDSecretsJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostOrgsIDSecretsRequestWithBody(server, orgID, params, "application/json", bodyReader)
}

// NewPostOrgsIDSecretsRequestWithBody generates requests for PostOrgsIDSecrets with any type of body
func NewPostOrgsIDSecretsRequestWithBody(server string, orgID string, params *PostOrgsIDSecretsParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "orgID", orgID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/orgs/%s/secrets/delete", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewPostQueryRequest calls the generic PostQuery builder with application/json body
func NewPostQueryRequest(server string, params *PostQueryParams, body PostQueryJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostQueryRequestWithBody(server, params, "application/json", bodyReader)
}

// NewPostQueryRequestWithBody generates requests for PostQuery with any type of body
func NewPostQueryRequestWithBody(server string, params *PostQueryParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/query")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if params.Org != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "org", *params.Org); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.OrgID != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "orgID", *params.OrgID); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	if params.AcceptEncoding != nil {
		var headerParam1 string

		headerParam1, err = runtime.StyleParam("simple", false, "Accept-Encoding", *params.AcceptEncoding)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Accept-Encoding", headerParam1)
	}

	if params.ContentType != nil {
		var headerParam2 string

		headerParam2, err = runtime.StyleParam("simple", false, "Content-Type", *params.ContentType)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Content-Type", headerParam2)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewPostQueryAnalyzeRequest calls the generic PostQueryAnalyze builder with application/json body
func NewPostQueryAnalyzeRequest(server string, params *PostQueryAnalyzeParams, body PostQueryAnalyzeJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostQueryAnalyzeRequestWithBody(server, params, "application/json", bodyReader)
}

// NewPostQueryAnalyzeRequestWithBody generates requests for PostQueryAnalyze with any type of body
func NewPostQueryAnalyzeRequestWithBody(server string, params *PostQueryAnalyzeParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/query/analyze")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	if params.ContentType != nil {
		var headerParam1 string

		headerParam1, err = runtime.StyleParam("simple", false, "Content-Type", *params.ContentType)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Content-Type", headerParam1)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewPostQueryAstRequest calls the generic PostQueryAst builder with application/json body
func NewPostQueryAstRequest(server string, params *PostQueryAstParams, body PostQueryAstJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostQueryAstRequestWithBody(server, params, "application/json", bodyReader)
}

// NewPostQueryAstRequestWithBody generates requests for PostQueryAst with any type of body
func NewPostQueryAstRequestWithBody(server string, params *PostQueryAstParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/query/ast")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	if params.ContentType != nil {
		var headerParam1 string

		headerParam1, err = runtime.StyleParam("simple", false, "Content-Type", *params.ContentType)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Content-Type", headerParam1)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewGetQuerySuggestionsRequest generates requests for GetQuerySuggestions
func NewGetQuerySuggestionsRequest(server string, params *GetQuerySuggestionsParams) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/query/suggestions")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetQuerySuggestionsNameRequest generates requests for GetQuerySuggestionsName
func NewGetQuerySuggestionsNameRequest(server string, name string, params *GetQuerySuggestionsNameParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "name", name)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/query/suggestions/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetReadyRequest generates requests for GetReady
func NewGetReadyRequest(server string, params *GetReadyParams) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/ready")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetScrapersRequest generates requests for GetScrapers
func NewGetScrapersRequest(server string, params *GetScrapersParams) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/scrapers")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if params.Name != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "name", *params.Name); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Id != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "id", *params.Id); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.OrgID != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "orgID", *params.OrgID); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Org != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "org", *params.Org); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPostScrapersRequest calls the generic PostScrapers builder with application/json body
func NewPostScrapersRequest(server string, params *PostScrapersParams, body PostScrapersJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostScrapersRequestWithBody(server, params, "application/json", bodyReader)
}

// NewPostScrapersRequestWithBody generates requests for PostScrapers with any type of body
func NewPostScrapersRequestWithBody(server string, params *PostScrapersParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/scrapers")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteScrapersIDRequest generates requests for DeleteScrapersID
func NewDeleteScrapersIDRequest(server string, scraperTargetID string, params *DeleteScrapersIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "scraperTargetID", scraperTargetID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/scrapers/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetScrapersIDRequest generates requests for GetScrapersID
func NewGetScrapersIDRequest(server string, scraperTargetID string, params *GetScrapersIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "scraperTargetID", scraperTargetID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/scrapers/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPatchScrapersIDRequest calls the generic PatchScrapersID builder with application/json body
func NewPatchScrapersIDRequest(server string, scraperTargetID string, params *PatchScrapersIDParams, body PatchScrapersIDJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPatchScrapersIDRequestWithBody(server, scraperTargetID, params, "application/json", bodyReader)
}

// NewPatchScrapersIDRequestWithBody generates requests for PatchScrapersID with any type of body
func NewPatchScrapersIDRequestWithBody(server string, scraperTargetID string, params *PatchScrapersIDParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "scraperTargetID", scraperTargetID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/scrapers/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PATCH", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewGetScrapersIDLabelsRequest generates requests for GetScrapersIDLabels
func NewGetScrapersIDLabelsRequest(server string, scraperTargetID string, params *GetScrapersIDLabelsParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "scraperTargetID", scraperTargetID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/scrapers/%s/labels", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPostScrapersIDLabelsRequest calls the generic PostScrapersIDLabels builder with application/json body
func NewPostScrapersIDLabelsRequest(server string, scraperTargetID string, params *PostScrapersIDLabelsParams, body PostScrapersIDLabelsJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostScrapersIDLabelsRequestWithBody(server, scraperTargetID, params, "application/json", bodyReader)
}

// NewPostScrapersIDLabelsRequestWithBody generates requests for PostScrapersIDLabels with any type of body
func NewPostScrapersIDLabelsRequestWithBody(server string, scraperTargetID string, params *PostScrapersIDLabelsParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "scraperTargetID", scraperTargetID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/scrapers/%s/labels", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteScrapersIDLabelsIDRequest generates requests for DeleteScrapersIDLabelsID
func NewDeleteScrapersIDLabelsIDRequest(server string, scraperTargetID string, labelID string, params *DeleteScrapersIDLabelsIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "scraperTargetID", scraperTargetID)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParam("simple", false, "labelID", labelID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/scrapers/%s/labels/%s", pathParam0, pathParam1)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPatchScrapersIDLabelsIDRequest calls the generic PatchScrapersIDLabelsID builder with application/json body
func NewPatchScrapersIDLabelsIDRequest(server string, scraperTargetID string, labelID string, params *PatchScrapersIDLabelsIDParams, body PatchScrapersIDLabelsIDJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPatchScrapersIDLabelsIDRequestWithBody(server, scraperTargetID, labelID, params, "application/json", bodyReader)
}

// NewPatchScrapersIDLabelsIDRequestWithBody generates requests for PatchScrapersIDLabelsID with any type of body
func NewPatchScrapersIDLabelsIDRequestWithBody(server string, scraperTargetID string, labelID string, params *PatchScrapersIDLabelsIDParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "scraperTargetID", scraperTargetID)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParam("simple", false, "labelID", labelID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/scrapers/%s/labels/%s", pathParam0, pathParam1)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PATCH", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewGetScrapersIDMembersRequest generates requests for GetScrapersIDMembers
func NewGetScrapersIDMembersRequest(server string, scraperTargetID string, params *GetScrapersIDMembersParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "scraperTargetID", scraperTargetID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/scrapers/%s/members", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPostScrapersIDMembersRequest calls the generic PostScrapersIDMembers builder with application/json body
func NewPostScrapersIDMembersRequest(server string, scraperTargetID string, params *PostScrapersIDMembersParams, body PostScrapersIDMembersJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostScrapersIDMembersRequestWithBody(server, scraperTargetID, params, "application/json", bodyReader)
}

// NewPostScrapersIDMembersRequestWithBody generates requests for PostScrapersIDMembers with any type of body
func NewPostScrapersIDMembersRequestWithBody(server string, scraperTargetID string, params *PostScrapersIDMembersParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "scraperTargetID", scraperTargetID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/scrapers/%s/members", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteScrapersIDMembersIDRequest generates requests for DeleteScrapersIDMembersID
func NewDeleteScrapersIDMembersIDRequest(server string, scraperTargetID string, userID string, params *DeleteScrapersIDMembersIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "scraperTargetID", scraperTargetID)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParam("simple", false, "userID", userID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/scrapers/%s/members/%s", pathParam0, pathParam1)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetScrapersIDOwnersRequest generates requests for GetScrapersIDOwners
func NewGetScrapersIDOwnersRequest(server string, scraperTargetID string, params *GetScrapersIDOwnersParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "scraperTargetID", scraperTargetID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/scrapers/%s/owners", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPostScrapersIDOwnersRequest calls the generic PostScrapersIDOwners builder with application/json body
func NewPostScrapersIDOwnersRequest(server string, scraperTargetID string, params *PostScrapersIDOwnersParams, body PostScrapersIDOwnersJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostScrapersIDOwnersRequestWithBody(server, scraperTargetID, params, "application/json", bodyReader)
}

// NewPostScrapersIDOwnersRequestWithBody generates requests for PostScrapersIDOwners with any type of body
func NewPostScrapersIDOwnersRequestWithBody(server string, scraperTargetID string, params *PostScrapersIDOwnersParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "scraperTargetID", scraperTargetID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/scrapers/%s/owners", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteScrapersIDOwnersIDRequest generates requests for DeleteScrapersIDOwnersID
func NewDeleteScrapersIDOwnersIDRequest(server string, scraperTargetID string, userID string, params *DeleteScrapersIDOwnersIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "scraperTargetID", scraperTargetID)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParam("simple", false, "userID", userID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/scrapers/%s/owners/%s", pathParam0, pathParam1)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetSetupRequest generates requests for GetSetup
func NewGetSetupRequest(server string, params *GetSetupParams) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/setup")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPostSetupRequest calls the generic PostSetup builder with application/json body
func NewPostSetupRequest(server string, params *PostSetupParams, body PostSetupJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostSetupRequestWithBody(server, params, "application/json", bodyReader)
}

// NewPostSetupRequestWithBody generates requests for PostSetup with any type of body
func NewPostSetupRequestWithBody(server string, params *PostSetupParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/setup")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewPostSetupUserRequest calls the generic PostSetupUser builder with application/json body
func NewPostSetupUserRequest(server string, params *PostSetupUserParams, body PostSetupUserJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostSetupUserRequestWithBody(server, params, "application/json", bodyReader)
}

// NewPostSetupUserRequestWithBody generates requests for PostSetupUser with any type of body
func NewPostSetupUserRequestWithBody(server string, params *PostSetupUserParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/setup/user")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewPostSigninRequest generates requests for PostSignin
func NewPostSigninRequest(server string, params *PostSigninParams) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/signin")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPostSignoutRequest generates requests for PostSignout
func NewPostSignoutRequest(server string, params *PostSignoutParams) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/signout")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetSourcesRequest generates requests for GetSources
func NewGetSourcesRequest(server string, params *GetSourcesParams) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/sources")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if params.Org != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "org", *params.Org); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPostSourcesRequest calls the generic PostSources builder with application/json body
func NewPostSourcesRequest(server string, params *PostSourcesParams, body PostSourcesJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostSourcesRequestWithBody(server, params, "application/json", bodyReader)
}

// NewPostSourcesRequestWithBody generates requests for PostSources with any type of body
func NewPostSourcesRequestWithBody(server string, params *PostSourcesParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/sources")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteSourcesIDRequest generates requests for DeleteSourcesID
func NewDeleteSourcesIDRequest(server string, sourceID string, params *DeleteSourcesIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "sourceID", sourceID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/sources/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetSourcesIDRequest generates requests for GetSourcesID
func NewGetSourcesIDRequest(server string, sourceID string, params *GetSourcesIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "sourceID", sourceID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/sources/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPatchSourcesIDRequest calls the generic PatchSourcesID builder with application/json body
func NewPatchSourcesIDRequest(server string, sourceID string, params *PatchSourcesIDParams, body PatchSourcesIDJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPatchSourcesIDRequestWithBody(server, sourceID, params, "application/json", bodyReader)
}

// NewPatchSourcesIDRequestWithBody generates requests for PatchSourcesID with any type of body
func NewPatchSourcesIDRequestWithBody(server string, sourceID string, params *PatchSourcesIDParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "sourceID", sourceID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/sources/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PATCH", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewGetSourcesIDBucketsRequest generates requests for GetSourcesIDBuckets
func NewGetSourcesIDBucketsRequest(server string, sourceID string, params *GetSourcesIDBucketsParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "sourceID", sourceID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/sources/%s/buckets", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if params.Org != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "org", *params.Org); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetSourcesIDHealthRequest generates requests for GetSourcesIDHealth
func NewGetSourcesIDHealthRequest(server string, sourceID string, params *GetSourcesIDHealthParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "sourceID", sourceID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/sources/%s/health", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewListStacksRequest generates requests for ListStacks
func NewListStacksRequest(server string, params *ListStacksParams) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/stacks")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if queryFrag, err := runtime.StyleParam("form", true, "orgID", params.OrgID); err != nil {
		return nil, err
	} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
		return nil, err
	} else {
		for k, v := range parsed {
			for _, v2 := range v {
				queryValues.Add(k, v2)
			}
		}
	}

	if params.Name != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "name", *params.Name); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.StackID != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "stackID", *params.StackID); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewCreateStackRequest calls the generic CreateStack builder with application/json body
func NewCreateStackRequest(server string, body CreateStackJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewCreateStackRequestWithBody(server, "application/json", bodyReader)
}

// NewCreateStackRequestWithBody generates requests for CreateStack with any type of body
func NewCreateStackRequestWithBody(server string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/stacks")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteStackRequest generates requests for DeleteStack
func NewDeleteStackRequest(server string, stackId string, params *DeleteStackParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "stack_id", stackId)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/stacks/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if queryFrag, err := runtime.StyleParam("form", true, "orgID", params.OrgID); err != nil {
		return nil, err
	} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
		return nil, err
	} else {
		for k, v := range parsed {
			for _, v2 := range v {
				queryValues.Add(k, v2)
			}
		}
	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewReadStackRequest generates requests for ReadStack
func NewReadStackRequest(server string, stackId string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "stack_id", stackId)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/stacks/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewUpdateStackRequest calls the generic UpdateStack builder with application/json body
func NewUpdateStackRequest(server string, stackId string, body UpdateStackJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewUpdateStackRequestWithBody(server, stackId, "application/json", bodyReader)
}

// NewUpdateStackRequestWithBody generates requests for UpdateStack with any type of body
func NewUpdateStackRequestWithBody(server string, stackId string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "stack_id", stackId)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/stacks/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PATCH", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewUninstallStackRequest generates requests for UninstallStack
func NewUninstallStackRequest(server string, stackId string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "stack_id", stackId)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/stacks/%s/uninstall", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetTasksRequest generates requests for GetTasks
func NewGetTasksRequest(server string, params *GetTasksParams) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/tasks")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if params.Name != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "name", *params.Name); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.After != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "after", *params.After); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.User != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "user", *params.User); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Org != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "org", *params.Org); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.OrgID != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "orgID", *params.OrgID); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Status != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "status", *params.Status); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Limit != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "limit", *params.Limit); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPostTasksRequest calls the generic PostTasks builder with application/json body
func NewPostTasksRequest(server string, params *PostTasksParams, body PostTasksJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostTasksRequestWithBody(server, params, "application/json", bodyReader)
}

// NewPostTasksRequestWithBody generates requests for PostTasks with any type of body
func NewPostTasksRequestWithBody(server string, params *PostTasksParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/tasks")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteTasksIDRequest generates requests for DeleteTasksID
func NewDeleteTasksIDRequest(server string, taskID string, params *DeleteTasksIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "taskID", taskID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/tasks/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetTasksIDRequest generates requests for GetTasksID
func NewGetTasksIDRequest(server string, taskID string, params *GetTasksIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "taskID", taskID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/tasks/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPatchTasksIDRequest calls the generic PatchTasksID builder with application/json body
func NewPatchTasksIDRequest(server string, taskID string, params *PatchTasksIDParams, body PatchTasksIDJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPatchTasksIDRequestWithBody(server, taskID, params, "application/json", bodyReader)
}

// NewPatchTasksIDRequestWithBody generates requests for PatchTasksID with any type of body
func NewPatchTasksIDRequestWithBody(server string, taskID string, params *PatchTasksIDParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "taskID", taskID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/tasks/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PATCH", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewGetTasksIDLabelsRequest generates requests for GetTasksIDLabels
func NewGetTasksIDLabelsRequest(server string, taskID string, params *GetTasksIDLabelsParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "taskID", taskID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/tasks/%s/labels", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPostTasksIDLabelsRequest calls the generic PostTasksIDLabels builder with application/json body
func NewPostTasksIDLabelsRequest(server string, taskID string, params *PostTasksIDLabelsParams, body PostTasksIDLabelsJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostTasksIDLabelsRequestWithBody(server, taskID, params, "application/json", bodyReader)
}

// NewPostTasksIDLabelsRequestWithBody generates requests for PostTasksIDLabels with any type of body
func NewPostTasksIDLabelsRequestWithBody(server string, taskID string, params *PostTasksIDLabelsParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "taskID", taskID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/tasks/%s/labels", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteTasksIDLabelsIDRequest generates requests for DeleteTasksIDLabelsID
func NewDeleteTasksIDLabelsIDRequest(server string, taskID string, labelID string, params *DeleteTasksIDLabelsIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "taskID", taskID)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParam("simple", false, "labelID", labelID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/tasks/%s/labels/%s", pathParam0, pathParam1)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetTasksIDLogsRequest generates requests for GetTasksIDLogs
func NewGetTasksIDLogsRequest(server string, taskID string, params *GetTasksIDLogsParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "taskID", taskID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/tasks/%s/logs", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetTasksIDMembersRequest generates requests for GetTasksIDMembers
func NewGetTasksIDMembersRequest(server string, taskID string, params *GetTasksIDMembersParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "taskID", taskID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/tasks/%s/members", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPostTasksIDMembersRequest calls the generic PostTasksIDMembers builder with application/json body
func NewPostTasksIDMembersRequest(server string, taskID string, params *PostTasksIDMembersParams, body PostTasksIDMembersJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostTasksIDMembersRequestWithBody(server, taskID, params, "application/json", bodyReader)
}

// NewPostTasksIDMembersRequestWithBody generates requests for PostTasksIDMembers with any type of body
func NewPostTasksIDMembersRequestWithBody(server string, taskID string, params *PostTasksIDMembersParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "taskID", taskID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/tasks/%s/members", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteTasksIDMembersIDRequest generates requests for DeleteTasksIDMembersID
func NewDeleteTasksIDMembersIDRequest(server string, taskID string, userID string, params *DeleteTasksIDMembersIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "taskID", taskID)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParam("simple", false, "userID", userID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/tasks/%s/members/%s", pathParam0, pathParam1)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetTasksIDOwnersRequest generates requests for GetTasksIDOwners
func NewGetTasksIDOwnersRequest(server string, taskID string, params *GetTasksIDOwnersParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "taskID", taskID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/tasks/%s/owners", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPostTasksIDOwnersRequest calls the generic PostTasksIDOwners builder with application/json body
func NewPostTasksIDOwnersRequest(server string, taskID string, params *PostTasksIDOwnersParams, body PostTasksIDOwnersJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostTasksIDOwnersRequestWithBody(server, taskID, params, "application/json", bodyReader)
}

// NewPostTasksIDOwnersRequestWithBody generates requests for PostTasksIDOwners with any type of body
func NewPostTasksIDOwnersRequestWithBody(server string, taskID string, params *PostTasksIDOwnersParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "taskID", taskID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/tasks/%s/owners", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteTasksIDOwnersIDRequest generates requests for DeleteTasksIDOwnersID
func NewDeleteTasksIDOwnersIDRequest(server string, taskID string, userID string, params *DeleteTasksIDOwnersIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "taskID", taskID)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParam("simple", false, "userID", userID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/tasks/%s/owners/%s", pathParam0, pathParam1)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetTasksIDRunsRequest generates requests for GetTasksIDRuns
func NewGetTasksIDRunsRequest(server string, taskID string, params *GetTasksIDRunsParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "taskID", taskID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/tasks/%s/runs", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if params.After != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "after", *params.After); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Limit != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "limit", *params.Limit); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.AfterTime != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "afterTime", *params.AfterTime); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.BeforeTime != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "beforeTime", *params.BeforeTime); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPostTasksIDRunsRequest calls the generic PostTasksIDRuns builder with application/json body
func NewPostTasksIDRunsRequest(server string, taskID string, params *PostTasksIDRunsParams, body PostTasksIDRunsJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostTasksIDRunsRequestWithBody(server, taskID, params, "application/json", bodyReader)
}

// NewPostTasksIDRunsRequestWithBody generates requests for PostTasksIDRuns with any type of body
func NewPostTasksIDRunsRequestWithBody(server string, taskID string, params *PostTasksIDRunsParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "taskID", taskID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/tasks/%s/runs", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteTasksIDRunsIDRequest generates requests for DeleteTasksIDRunsID
func NewDeleteTasksIDRunsIDRequest(server string, taskID string, runID string, params *DeleteTasksIDRunsIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "taskID", taskID)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParam("simple", false, "runID", runID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/tasks/%s/runs/%s", pathParam0, pathParam1)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetTasksIDRunsIDRequest generates requests for GetTasksIDRunsID
func NewGetTasksIDRunsIDRequest(server string, taskID string, runID string, params *GetTasksIDRunsIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "taskID", taskID)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParam("simple", false, "runID", runID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/tasks/%s/runs/%s", pathParam0, pathParam1)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetTasksIDRunsIDLogsRequest generates requests for GetTasksIDRunsIDLogs
func NewGetTasksIDRunsIDLogsRequest(server string, taskID string, runID string, params *GetTasksIDRunsIDLogsParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "taskID", taskID)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParam("simple", false, "runID", runID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/tasks/%s/runs/%s/logs", pathParam0, pathParam1)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPostTasksIDRunsIDRetryRequest generates requests for PostTasksIDRunsIDRetry
func NewPostTasksIDRunsIDRetryRequest(server string, taskID string, runID string, params *PostTasksIDRunsIDRetryParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "taskID", taskID)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParam("simple", false, "runID", runID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/tasks/%s/runs/%s/retry", pathParam0, pathParam1)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetTelegrafPluginsRequest generates requests for GetTelegrafPlugins
func NewGetTelegrafPluginsRequest(server string, params *GetTelegrafPluginsParams) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/telegraf/plugins")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if params.Type != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "type", *params.Type); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetTelegrafsRequest generates requests for GetTelegrafs
func NewGetTelegrafsRequest(server string, params *GetTelegrafsParams) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/telegrafs")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if params.OrgID != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "orgID", *params.OrgID); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPostTelegrafsRequest calls the generic PostTelegrafs builder with application/json body
func NewPostTelegrafsRequest(server string, params *PostTelegrafsParams, body PostTelegrafsJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostTelegrafsRequestWithBody(server, params, "application/json", bodyReader)
}

// NewPostTelegrafsRequestWithBody generates requests for PostTelegrafs with any type of body
func NewPostTelegrafsRequestWithBody(server string, params *PostTelegrafsParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/telegrafs")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteTelegrafsIDRequest generates requests for DeleteTelegrafsID
func NewDeleteTelegrafsIDRequest(server string, telegrafID string, params *DeleteTelegrafsIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "telegrafID", telegrafID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/telegrafs/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetTelegrafsIDRequest generates requests for GetTelegrafsID
func NewGetTelegrafsIDRequest(server string, telegrafID string, params *GetTelegrafsIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "telegrafID", telegrafID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/telegrafs/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	if params.Accept != nil {
		var headerParam1 string

		headerParam1, err = runtime.StyleParam("simple", false, "Accept", *params.Accept)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Accept", headerParam1)
	}

	return req, nil
}

// NewPutTelegrafsIDRequest calls the generic PutTelegrafsID builder with application/json body
func NewPutTelegrafsIDRequest(server string, telegrafID string, params *PutTelegrafsIDParams, body PutTelegrafsIDJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPutTelegrafsIDRequestWithBody(server, telegrafID, params, "application/json", bodyReader)
}

// NewPutTelegrafsIDRequestWithBody generates requests for PutTelegrafsID with any type of body
func NewPutTelegrafsIDRequestWithBody(server string, telegrafID string, params *PutTelegrafsIDParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "telegrafID", telegrafID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/telegrafs/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewGetTelegrafsIDLabelsRequest generates requests for GetTelegrafsIDLabels
func NewGetTelegrafsIDLabelsRequest(server string, telegrafID string, params *GetTelegrafsIDLabelsParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "telegrafID", telegrafID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/telegrafs/%s/labels", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPostTelegrafsIDLabelsRequest calls the generic PostTelegrafsIDLabels builder with application/json body
func NewPostTelegrafsIDLabelsRequest(server string, telegrafID string, params *PostTelegrafsIDLabelsParams, body PostTelegrafsIDLabelsJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostTelegrafsIDLabelsRequestWithBody(server, telegrafID, params, "application/json", bodyReader)
}

// NewPostTelegrafsIDLabelsRequestWithBody generates requests for PostTelegrafsIDLabels with any type of body
func NewPostTelegrafsIDLabelsRequestWithBody(server string, telegrafID string, params *PostTelegrafsIDLabelsParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "telegrafID", telegrafID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/telegrafs/%s/labels", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteTelegrafsIDLabelsIDRequest generates requests for DeleteTelegrafsIDLabelsID
func NewDeleteTelegrafsIDLabelsIDRequest(server string, telegrafID string, labelID string, params *DeleteTelegrafsIDLabelsIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "telegrafID", telegrafID)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParam("simple", false, "labelID", labelID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/telegrafs/%s/labels/%s", pathParam0, pathParam1)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetTelegrafsIDMembersRequest generates requests for GetTelegrafsIDMembers
func NewGetTelegrafsIDMembersRequest(server string, telegrafID string, params *GetTelegrafsIDMembersParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "telegrafID", telegrafID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/telegrafs/%s/members", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPostTelegrafsIDMembersRequest calls the generic PostTelegrafsIDMembers builder with application/json body
func NewPostTelegrafsIDMembersRequest(server string, telegrafID string, params *PostTelegrafsIDMembersParams, body PostTelegrafsIDMembersJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostTelegrafsIDMembersRequestWithBody(server, telegrafID, params, "application/json", bodyReader)
}

// NewPostTelegrafsIDMembersRequestWithBody generates requests for PostTelegrafsIDMembers with any type of body
func NewPostTelegrafsIDMembersRequestWithBody(server string, telegrafID string, params *PostTelegrafsIDMembersParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "telegrafID", telegrafID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/telegrafs/%s/members", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteTelegrafsIDMembersIDRequest generates requests for DeleteTelegrafsIDMembersID
func NewDeleteTelegrafsIDMembersIDRequest(server string, telegrafID string, userID string, params *DeleteTelegrafsIDMembersIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "telegrafID", telegrafID)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParam("simple", false, "userID", userID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/telegrafs/%s/members/%s", pathParam0, pathParam1)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetTelegrafsIDOwnersRequest generates requests for GetTelegrafsIDOwners
func NewGetTelegrafsIDOwnersRequest(server string, telegrafID string, params *GetTelegrafsIDOwnersParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "telegrafID", telegrafID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/telegrafs/%s/owners", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPostTelegrafsIDOwnersRequest calls the generic PostTelegrafsIDOwners builder with application/json body
func NewPostTelegrafsIDOwnersRequest(server string, telegrafID string, params *PostTelegrafsIDOwnersParams, body PostTelegrafsIDOwnersJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostTelegrafsIDOwnersRequestWithBody(server, telegrafID, params, "application/json", bodyReader)
}

// NewPostTelegrafsIDOwnersRequestWithBody generates requests for PostTelegrafsIDOwners with any type of body
func NewPostTelegrafsIDOwnersRequestWithBody(server string, telegrafID string, params *PostTelegrafsIDOwnersParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "telegrafID", telegrafID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/telegrafs/%s/owners", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteTelegrafsIDOwnersIDRequest generates requests for DeleteTelegrafsIDOwnersID
func NewDeleteTelegrafsIDOwnersIDRequest(server string, telegrafID string, userID string, params *DeleteTelegrafsIDOwnersIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "telegrafID", telegrafID)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParam("simple", false, "userID", userID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/telegrafs/%s/owners/%s", pathParam0, pathParam1)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewApplyTemplateRequest calls the generic ApplyTemplate builder with application/json body
func NewApplyTemplateRequest(server string, body ApplyTemplateJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewApplyTemplateRequestWithBody(server, "application/json", bodyReader)
}

// NewApplyTemplateRequestWithBody generates requests for ApplyTemplate with any type of body
func NewApplyTemplateRequestWithBody(server string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/templates/apply")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewExportTemplateRequest calls the generic ExportTemplate builder with application/json body
func NewExportTemplateRequest(server string, body ExportTemplateJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewExportTemplateRequestWithBody(server, "application/json", bodyReader)
}

// NewExportTemplateRequestWithBody generates requests for ExportTemplate with any type of body
func NewExportTemplateRequestWithBody(server string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/templates/export")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewGetUsersRequest generates requests for GetUsers
func NewGetUsersRequest(server string, params *GetUsersParams) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/users")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPostUsersRequest calls the generic PostUsers builder with application/json body
func NewPostUsersRequest(server string, params *PostUsersParams, body PostUsersJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostUsersRequestWithBody(server, params, "application/json", bodyReader)
}

// NewPostUsersRequestWithBody generates requests for PostUsers with any type of body
func NewPostUsersRequestWithBody(server string, params *PostUsersParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/users")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteUsersIDRequest generates requests for DeleteUsersID
func NewDeleteUsersIDRequest(server string, userID string, params *DeleteUsersIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "userID", userID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/users/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetUsersIDRequest generates requests for GetUsersID
func NewGetUsersIDRequest(server string, userID string, params *GetUsersIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "userID", userID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/users/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPatchUsersIDRequest calls the generic PatchUsersID builder with application/json body
func NewPatchUsersIDRequest(server string, userID string, params *PatchUsersIDParams, body PatchUsersIDJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPatchUsersIDRequestWithBody(server, userID, params, "application/json", bodyReader)
}

// NewPatchUsersIDRequestWithBody generates requests for PatchUsersID with any type of body
func NewPatchUsersIDRequestWithBody(server string, userID string, params *PatchUsersIDParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "userID", userID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/users/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PATCH", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewPostUsersIDPasswordRequest calls the generic PostUsersIDPassword builder with application/json body
func NewPostUsersIDPasswordRequest(server string, userID string, params *PostUsersIDPasswordParams, body PostUsersIDPasswordJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostUsersIDPasswordRequestWithBody(server, userID, params, "application/json", bodyReader)
}

// NewPostUsersIDPasswordRequestWithBody generates requests for PostUsersIDPassword with any type of body
func NewPostUsersIDPasswordRequestWithBody(server string, userID string, params *PostUsersIDPasswordParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "userID", userID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/users/%s/password", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewGetVariablesRequest generates requests for GetVariables
func NewGetVariablesRequest(server string, params *GetVariablesParams) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/variables")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if params.Org != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "org", *params.Org); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.OrgID != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "orgID", *params.OrgID); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPostVariablesRequest calls the generic PostVariables builder with application/json body
func NewPostVariablesRequest(server string, params *PostVariablesParams, body PostVariablesJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostVariablesRequestWithBody(server, params, "application/json", bodyReader)
}

// NewPostVariablesRequestWithBody generates requests for PostVariables with any type of body
func NewPostVariablesRequestWithBody(server string, params *PostVariablesParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/variables")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteVariablesIDRequest generates requests for DeleteVariablesID
func NewDeleteVariablesIDRequest(server string, variableID string, params *DeleteVariablesIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "variableID", variableID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/variables/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetVariablesIDRequest generates requests for GetVariablesID
func NewGetVariablesIDRequest(server string, variableID string, params *GetVariablesIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "variableID", variableID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/variables/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPatchVariablesIDRequest calls the generic PatchVariablesID builder with application/json body
func NewPatchVariablesIDRequest(server string, variableID string, params *PatchVariablesIDParams, body PatchVariablesIDJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPatchVariablesIDRequestWithBody(server, variableID, params, "application/json", bodyReader)
}

// NewPatchVariablesIDRequestWithBody generates requests for PatchVariablesID with any type of body
func NewPatchVariablesIDRequestWithBody(server string, variableID string, params *PatchVariablesIDParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "variableID", variableID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/variables/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PATCH", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewPutVariablesIDRequest calls the generic PutVariablesID builder with application/json body
func NewPutVariablesIDRequest(server string, variableID string, params *PutVariablesIDParams, body PutVariablesIDJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPutVariablesIDRequestWithBody(server, variableID, params, "application/json", bodyReader)
}

// NewPutVariablesIDRequestWithBody generates requests for PutVariablesID with any type of body
func NewPutVariablesIDRequestWithBody(server string, variableID string, params *PutVariablesIDParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "variableID", variableID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/variables/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewGetVariablesIDLabelsRequest generates requests for GetVariablesIDLabels
func NewGetVariablesIDLabelsRequest(server string, variableID string, params *GetVariablesIDLabelsParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "variableID", variableID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/variables/%s/labels", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPostVariablesIDLabelsRequest calls the generic PostVariablesIDLabels builder with application/json body
func NewPostVariablesIDLabelsRequest(server string, variableID string, params *PostVariablesIDLabelsParams, body PostVariablesIDLabelsJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostVariablesIDLabelsRequestWithBody(server, variableID, params, "application/json", bodyReader)
}

// NewPostVariablesIDLabelsRequestWithBody generates requests for PostVariablesIDLabels with any type of body
func NewPostVariablesIDLabelsRequestWithBody(server string, variableID string, params *PostVariablesIDLabelsParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "variableID", variableID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/variables/%s/labels", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteVariablesIDLabelsIDRequest generates requests for DeleteVariablesIDLabelsID
func NewDeleteVariablesIDLabelsIDRequest(server string, variableID string, labelID string, params *DeleteVariablesIDLabelsIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "variableID", variableID)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParam("simple", false, "labelID", labelID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/variables/%s/labels/%s", pathParam0, pathParam1)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPostWriteRequestWithBody generates requests for PostWrite with any type of body
func NewPostWriteRequestWithBody(server string, params *PostWriteParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/write")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if queryFrag, err := runtime.StyleParam("form", true, "org", params.Org); err != nil {
		return nil, err
	} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
		return nil, err
	} else {
		for k, v := range parsed {
			for _, v2 := range v {
				queryValues.Add(k, v2)
			}
		}
	}

	if params.OrgID != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "orgID", *params.OrgID); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if queryFrag, err := runtime.StyleParam("form", true, "bucket", params.Bucket); err != nil {
		return nil, err
	} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
		return nil, err
	} else {
		for k, v := range parsed {
			for _, v2 := range v {
				queryValues.Add(k, v2)
			}
		}
	}

	if params.Precision != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "precision", *params.Precision); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	if params.ContentEncoding != nil {
		var headerParam1 string

		headerParam1, err = runtime.StyleParam("simple", false, "Content-Encoding", *params.ContentEncoding)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Content-Encoding", headerParam1)
	}

	if params.ContentType != nil {
		var headerParam2 string

		headerParam2, err = runtime.StyleParam("simple", false, "Content-Type", *params.ContentType)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Content-Type", headerParam2)
	}

	if params.ContentLength != nil {
		var headerParam3 string

		headerParam3, err = runtime.StyleParam("simple", false, "Content-Length", *params.ContentLength)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Content-Length", headerParam3)
	}

	if params.Accept != nil {
		var headerParam4 string

		headerParam4, err = runtime.StyleParam("simple", false, "Accept", *params.Accept)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Accept", headerParam4)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// ClientWithResponses builds on ClientInterface to offer response payloads
type ClientWithResponses struct {
	ClientInterface
}

// NewClientWithResponses creates a new ClientWithResponses, which wraps
// Client with return type handling
func NewClientWithResponses(service ihttp.Service) *ClientWithResponses {
	client := NewClient(service)
	return &ClientWithResponses{client}
}

type getRoutesResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSONDefault  *Routes
}

// Status returns HTTPResponse.Status
func (r getRoutesResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r getRoutesResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type getAuthorizationsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Authorizations
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r getAuthorizationsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r getAuthorizationsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type postAuthorizationsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *Authorization
	JSON400      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r postAuthorizationsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r postAuthorizationsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type deleteAuthorizationsIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r deleteAuthorizationsIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r deleteAuthorizationsIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type getAuthorizationsIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Authorization
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r getAuthorizationsIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r getAuthorizationsIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type patchAuthorizationsIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Authorization
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r patchAuthorizationsIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r patchAuthorizationsIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type getBucketsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Buckets
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r getBucketsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r getBucketsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type postBucketsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *Bucket
	JSON422      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r postBucketsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r postBucketsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type deleteBucketsIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r deleteBucketsIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r deleteBucketsIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type getBucketsIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Bucket
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r getBucketsIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r getBucketsIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type patchBucketsIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Bucket
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r patchBucketsIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r patchBucketsIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type getBucketsIDLabelsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *LabelsResponse
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r getBucketsIDLabelsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r getBucketsIDLabelsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type postBucketsIDLabelsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *LabelResponse
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r postBucketsIDLabelsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r postBucketsIDLabelsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type deleteBucketsIDLabelsIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r deleteBucketsIDLabelsIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r deleteBucketsIDLabelsIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type getBucketsIDMembersResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *ResourceMembers
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r getBucketsIDMembersResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r getBucketsIDMembersResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type postBucketsIDMembersResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *ResourceMember
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r postBucketsIDMembersResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r postBucketsIDMembersResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type deleteBucketsIDMembersIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r deleteBucketsIDMembersIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r deleteBucketsIDMembersIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type getBucketsIDOwnersResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *ResourceOwners
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r getBucketsIDOwnersResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r getBucketsIDOwnersResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type postBucketsIDOwnersResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *ResourceOwner
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r postBucketsIDOwnersResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r postBucketsIDOwnersResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type deleteBucketsIDOwnersIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r deleteBucketsIDOwnersIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r deleteBucketsIDOwnersIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type getChecksResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Checks
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r getChecksResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r getChecksResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type createCheckResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *Check
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r createCheckResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r createCheckResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type deleteChecksIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r deleteChecksIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r deleteChecksIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type getChecksIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Check
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r getChecksIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r getChecksIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type patchChecksIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Check
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r patchChecksIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r patchChecksIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type putChecksIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Check
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r putChecksIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r putChecksIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type getChecksIDLabelsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *LabelsResponse
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r getChecksIDLabelsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r getChecksIDLabelsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type postChecksIDLabelsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *LabelResponse
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r postChecksIDLabelsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r postChecksIDLabelsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type deleteChecksIDLabelsIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r deleteChecksIDLabelsIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r deleteChecksIDLabelsIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type getChecksIDQueryResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *FluxResponse
	JSON400      *Error
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r getChecksIDQueryResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r getChecksIDQueryResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type getDashboardsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Dashboards
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r getDashboardsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r getDashboardsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type postDashboardsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *interface{}
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r postDashboardsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r postDashboardsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type deleteDashboardsIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r deleteDashboardsIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r deleteDashboardsIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type getDashboardsIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *interface{}
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r getDashboardsIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r getDashboardsIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type patchDashboardsIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Dashboard
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r patchDashboardsIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r patchDashboardsIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type postDashboardsIDCellsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *Cell
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r postDashboardsIDCellsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r postDashboardsIDCellsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type putDashboardsIDCellsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *Dashboard
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r putDashboardsIDCellsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r putDashboardsIDCellsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type deleteDashboardsIDCellsIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r deleteDashboardsIDCellsIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r deleteDashboardsIDCellsIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type patchDashboardsIDCellsIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Cell
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r patchDashboardsIDCellsIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r patchDashboardsIDCellsIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type getDashboardsIDCellsIDViewResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *View
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r getDashboardsIDCellsIDViewResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r getDashboardsIDCellsIDViewResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type patchDashboardsIDCellsIDViewResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *View
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r patchDashboardsIDCellsIDViewResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r patchDashboardsIDCellsIDViewResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type getDashboardsIDLabelsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *LabelsResponse
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r getDashboardsIDLabelsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r getDashboardsIDLabelsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type postDashboardsIDLabelsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *LabelResponse
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r postDashboardsIDLabelsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r postDashboardsIDLabelsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type deleteDashboardsIDLabelsIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r deleteDashboardsIDLabelsIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r deleteDashboardsIDLabelsIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type getDashboardsIDMembersResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *ResourceMembers
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r getDashboardsIDMembersResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r getDashboardsIDMembersResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type postDashboardsIDMembersResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *ResourceMember
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r postDashboardsIDMembersResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r postDashboardsIDMembersResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type deleteDashboardsIDMembersIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r deleteDashboardsIDMembersIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r deleteDashboardsIDMembersIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type getDashboardsIDOwnersResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *ResourceOwners
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r getDashboardsIDOwnersResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r getDashboardsIDOwnersResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type postDashboardsIDOwnersResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *ResourceOwner
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r postDashboardsIDOwnersResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r postDashboardsIDOwnersResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type deleteDashboardsIDOwnersIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r deleteDashboardsIDOwnersIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r deleteDashboardsIDOwnersIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type getDBRPsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *DBRPs
	JSON400      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r getDBRPsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r getDBRPsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type postDBRPResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *DBRP
	JSON400      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r postDBRPResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r postDBRPResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type deleteDBRPIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON400      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r deleteDBRPIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r deleteDBRPIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type getDBRPsIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *DBRP
	JSON400      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r getDBRPsIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r getDBRPsIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type patchDBRPIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *DBRP
	JSON400      *Error
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r patchDBRPIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r patchDBRPIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type postDeleteResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON400      *Error
	JSON403      *Error
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r postDeleteResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r postDeleteResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type getDocumentsTemplatesResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Documents
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r getDocumentsTemplatesResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r getDocumentsTemplatesResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type postDocumentsTemplatesResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *Document
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r postDocumentsTemplatesResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r postDocumentsTemplatesResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type deleteDocumentsTemplatesIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r deleteDocumentsTemplatesIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r deleteDocumentsTemplatesIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type getDocumentsTemplatesIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Document
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r getDocumentsTemplatesIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r getDocumentsTemplatesIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type putDocumentsTemplatesIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Document
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r putDocumentsTemplatesIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r putDocumentsTemplatesIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type getDocumentsTemplatesIDLabelsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *LabelsResponse
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r getDocumentsTemplatesIDLabelsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r getDocumentsTemplatesIDLabelsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type postDocumentsTemplatesIDLabelsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *LabelResponse
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r postDocumentsTemplatesIDLabelsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r postDocumentsTemplatesIDLabelsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type deleteDocumentsTemplatesIDLabelsIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r deleteDocumentsTemplatesIDLabelsIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r deleteDocumentsTemplatesIDLabelsIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type getFlagsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Flags
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r getFlagsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r getFlagsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type getHealthResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *HealthCheck
	JSON503      *HealthCheck
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r getHealthResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r getHealthResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type getLabelsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *LabelsResponse
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r getLabelsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r getLabelsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type postLabelsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *LabelResponse
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r postLabelsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r postLabelsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type deleteLabelsIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r deleteLabelsIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r deleteLabelsIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type getLabelsIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *LabelResponse
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r getLabelsIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r getLabelsIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type patchLabelsIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *LabelResponse
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r patchLabelsIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r patchLabelsIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type getMeResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *User
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r getMeResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r getMeResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type putMePasswordResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r putMePasswordResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r putMePasswordResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type getNotificationEndpointsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *NotificationEndpoints
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r getNotificationEndpointsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r getNotificationEndpointsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type createNotificationEndpointResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *NotificationEndpoint
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r createNotificationEndpointResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r createNotificationEndpointResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type deleteNotificationEndpointsIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r deleteNotificationEndpointsIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r deleteNotificationEndpointsIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type getNotificationEndpointsIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *NotificationEndpoint
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r getNotificationEndpointsIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r getNotificationEndpointsIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type patchNotificationEndpointsIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *NotificationEndpoint
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r patchNotificationEndpointsIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r patchNotificationEndpointsIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type putNotificationEndpointsIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *NotificationEndpoint
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r putNotificationEndpointsIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r putNotificationEndpointsIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type getNotificationEndpointsIDLabelsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *LabelsResponse
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r getNotificationEndpointsIDLabelsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r getNotificationEndpointsIDLabelsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type postNotificationEndpointIDLabelsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *LabelResponse
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r postNotificationEndpointIDLabelsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r postNotificationEndpointIDLabelsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type deleteNotificationEndpointsIDLabelsIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r deleteNotificationEndpointsIDLabelsIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r deleteNotificationEndpointsIDLabelsIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type getNotificationRulesResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *NotificationRules
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r getNotificationRulesResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r getNotificationRulesResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type createNotificationRuleResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *NotificationRule
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r createNotificationRuleResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r createNotificationRuleResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type deleteNotificationRulesIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r deleteNotificationRulesIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r deleteNotificationRulesIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type getNotificationRulesIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *NotificationRule
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r getNotificationRulesIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r getNotificationRulesIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type patchNotificationRulesIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *NotificationRule
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r patchNotificationRulesIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r patchNotificationRulesIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type putNotificationRulesIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *NotificationRule
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r putNotificationRulesIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r putNotificationRulesIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type getNotificationRulesIDLabelsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *LabelsResponse
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r getNotificationRulesIDLabelsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r getNotificationRulesIDLabelsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type postNotificationRuleIDLabelsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *LabelResponse
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r postNotificationRuleIDLabelsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r postNotificationRuleIDLabelsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type deleteNotificationRulesIDLabelsIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r deleteNotificationRulesIDLabelsIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r deleteNotificationRulesIDLabelsIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type getNotificationRulesIDQueryResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *FluxResponse
	JSON400      *Error
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r getNotificationRulesIDQueryResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r getNotificationRulesIDQueryResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type getOrgsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Organizations
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r getOrgsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r getOrgsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type postOrgsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *Organization
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r postOrgsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r postOrgsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type deleteOrgsIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r deleteOrgsIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r deleteOrgsIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type getOrgsIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Organization
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r getOrgsIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r getOrgsIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type patchOrgsIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Organization
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r patchOrgsIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r patchOrgsIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type getOrgsIDMembersResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *ResourceMembers
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r getOrgsIDMembersResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r getOrgsIDMembersResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type postOrgsIDMembersResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *ResourceMember
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r postOrgsIDMembersResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r postOrgsIDMembersResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type deleteOrgsIDMembersIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r deleteOrgsIDMembersIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r deleteOrgsIDMembersIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type getOrgsIDOwnersResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *ResourceOwners
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r getOrgsIDOwnersResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r getOrgsIDOwnersResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type postOrgsIDOwnersResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *ResourceOwner
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r postOrgsIDOwnersResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r postOrgsIDOwnersResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type deleteOrgsIDOwnersIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r deleteOrgsIDOwnersIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r deleteOrgsIDOwnersIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type getOrgsIDSecretsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *SecretKeysResponse
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r getOrgsIDSecretsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r getOrgsIDSecretsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type patchOrgsIDSecretsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r patchOrgsIDSecretsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r patchOrgsIDSecretsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type postOrgsIDSecretsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r postOrgsIDSecretsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r postOrgsIDSecretsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type postQueryResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r postQueryResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r postQueryResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type postQueryAnalyzeResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *AnalyzeQueryResponse
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r postQueryAnalyzeResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r postQueryAnalyzeResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type postQueryAstResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *ASTResponse
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r postQueryAstResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r postQueryAstResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type getQuerySuggestionsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *FluxSuggestions
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r getQuerySuggestionsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r getQuerySuggestionsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type getQuerySuggestionsNameResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *FluxSuggestion
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r getQuerySuggestionsNameResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r getQuerySuggestionsNameResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type getReadyResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Ready
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r getReadyResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r getReadyResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type getScrapersResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *ScraperTargetResponses
}

// Status returns HTTPResponse.Status
func (r getScrapersResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r getScrapersResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type postScrapersResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *ScraperTargetResponse
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r postScrapersResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r postScrapersResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type deleteScrapersIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r deleteScrapersIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r deleteScrapersIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type getScrapersIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *ScraperTargetResponse
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r getScrapersIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r getScrapersIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type patchScrapersIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *ScraperTargetResponse
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r patchScrapersIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r patchScrapersIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type getScrapersIDLabelsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *LabelsResponse
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r getScrapersIDLabelsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r getScrapersIDLabelsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type postScrapersIDLabelsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *LabelResponse
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r postScrapersIDLabelsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r postScrapersIDLabelsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type deleteScrapersIDLabelsIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r deleteScrapersIDLabelsIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r deleteScrapersIDLabelsIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type patchScrapersIDLabelsIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r patchScrapersIDLabelsIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r patchScrapersIDLabelsIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type getScrapersIDMembersResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *ResourceMembers
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r getScrapersIDMembersResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r getScrapersIDMembersResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type postScrapersIDMembersResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *ResourceMember
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r postScrapersIDMembersResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r postScrapersIDMembersResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type deleteScrapersIDMembersIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r deleteScrapersIDMembersIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r deleteScrapersIDMembersIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type getScrapersIDOwnersResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *ResourceOwners
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r getScrapersIDOwnersResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r getScrapersIDOwnersResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type postScrapersIDOwnersResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *ResourceOwner
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r postScrapersIDOwnersResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r postScrapersIDOwnersResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type deleteScrapersIDOwnersIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r deleteScrapersIDOwnersIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r deleteScrapersIDOwnersIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type getSetupResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *IsOnboarding
}

// Status returns HTTPResponse.Status
func (r getSetupResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r getSetupResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type postSetupResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *OnboardingResponse
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r postSetupResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r postSetupResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type postSetupUserResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *OnboardingResponse
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r postSetupUserResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r postSetupUserResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type postSigninResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON401      *Error
	JSON403      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r postSigninResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r postSigninResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type postSignoutResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON401      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r postSignoutResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r postSignoutResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type getSourcesResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Sources
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r getSourcesResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r getSourcesResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type postSourcesResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *Source
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r postSourcesResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r postSourcesResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type deleteSourcesIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r deleteSourcesIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r deleteSourcesIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type getSourcesIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Source
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r getSourcesIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r getSourcesIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type patchSourcesIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Source
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r patchSourcesIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r patchSourcesIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type getSourcesIDBucketsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Buckets
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r getSourcesIDBucketsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r getSourcesIDBucketsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type getSourcesIDHealthResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *HealthCheck
	JSON503      *HealthCheck
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r getSourcesIDHealthResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r getSourcesIDHealthResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type listStacksResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		Stacks *[]Stack `json:"stacks,omitempty"`
	}
	JSONDefault *Error
}

// Status returns HTTPResponse.Status
func (r listStacksResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r listStacksResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type createStackResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *Stack
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r createStackResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r createStackResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type deleteStackResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r deleteStackResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r deleteStackResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type readStackResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Stack
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r readStackResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r readStackResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type updateStackResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Stack
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r updateStackResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r updateStackResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type uninstallStackResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Stack
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r uninstallStackResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r uninstallStackResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type getTasksResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Tasks
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r getTasksResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r getTasksResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type postTasksResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *Task
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r postTasksResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r postTasksResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type deleteTasksIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r deleteTasksIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r deleteTasksIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type getTasksIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Task
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r getTasksIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r getTasksIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type patchTasksIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Task
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r patchTasksIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r patchTasksIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type getTasksIDLabelsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *LabelsResponse
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r getTasksIDLabelsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r getTasksIDLabelsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type postTasksIDLabelsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *LabelResponse
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r postTasksIDLabelsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r postTasksIDLabelsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type deleteTasksIDLabelsIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r deleteTasksIDLabelsIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r deleteTasksIDLabelsIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type getTasksIDLogsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Logs
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r getTasksIDLogsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r getTasksIDLogsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type getTasksIDMembersResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *ResourceMembers
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r getTasksIDMembersResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r getTasksIDMembersResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type postTasksIDMembersResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *ResourceMember
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r postTasksIDMembersResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r postTasksIDMembersResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type deleteTasksIDMembersIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r deleteTasksIDMembersIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r deleteTasksIDMembersIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type getTasksIDOwnersResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *ResourceOwners
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r getTasksIDOwnersResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r getTasksIDOwnersResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type postTasksIDOwnersResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *ResourceOwner
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r postTasksIDOwnersResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r postTasksIDOwnersResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type deleteTasksIDOwnersIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r deleteTasksIDOwnersIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r deleteTasksIDOwnersIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type getTasksIDRunsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Runs
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r getTasksIDRunsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r getTasksIDRunsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type postTasksIDRunsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *Run
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r postTasksIDRunsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r postTasksIDRunsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type deleteTasksIDRunsIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r deleteTasksIDRunsIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r deleteTasksIDRunsIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type getTasksIDRunsIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Run
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r getTasksIDRunsIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r getTasksIDRunsIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type getTasksIDRunsIDLogsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Logs
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r getTasksIDRunsIDLogsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r getTasksIDRunsIDLogsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type postTasksIDRunsIDRetryResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Run
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r postTasksIDRunsIDRetryResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r postTasksIDRunsIDRetryResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type getTelegrafPluginsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *TelegrafPlugins
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r getTelegrafPluginsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r getTelegrafPluginsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type getTelegrafsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Telegrafs
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r getTelegrafsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r getTelegrafsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type postTelegrafsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *Telegraf
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r postTelegrafsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r postTelegrafsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type deleteTelegrafsIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r deleteTelegrafsIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r deleteTelegrafsIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type getTelegrafsIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Telegraf
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r getTelegrafsIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r getTelegrafsIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type putTelegrafsIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Telegraf
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r putTelegrafsIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r putTelegrafsIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type getTelegrafsIDLabelsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *LabelsResponse
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r getTelegrafsIDLabelsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r getTelegrafsIDLabelsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type postTelegrafsIDLabelsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *LabelResponse
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r postTelegrafsIDLabelsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r postTelegrafsIDLabelsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type deleteTelegrafsIDLabelsIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r deleteTelegrafsIDLabelsIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r deleteTelegrafsIDLabelsIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type getTelegrafsIDMembersResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *ResourceMembers
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r getTelegrafsIDMembersResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r getTelegrafsIDMembersResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type postTelegrafsIDMembersResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *ResourceMember
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r postTelegrafsIDMembersResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r postTelegrafsIDMembersResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type deleteTelegrafsIDMembersIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r deleteTelegrafsIDMembersIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r deleteTelegrafsIDMembersIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type getTelegrafsIDOwnersResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *ResourceOwners
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r getTelegrafsIDOwnersResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r getTelegrafsIDOwnersResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type postTelegrafsIDOwnersResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *ResourceOwner
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r postTelegrafsIDOwnersResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r postTelegrafsIDOwnersResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type deleteTelegrafsIDOwnersIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r deleteTelegrafsIDOwnersIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r deleteTelegrafsIDOwnersIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type applyTemplateResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *TemplateSummary
	JSON201      *TemplateSummary
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r applyTemplateResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r applyTemplateResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type exportTemplateResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Template
	YAML200      *Template
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r exportTemplateResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r exportTemplateResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type getUsersResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Users
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r getUsersResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r getUsersResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type postUsersResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *User
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r postUsersResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r postUsersResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type deleteUsersIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r deleteUsersIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r deleteUsersIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type getUsersIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *User
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r getUsersIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r getUsersIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type patchUsersIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *User
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r patchUsersIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r patchUsersIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type postUsersIDPasswordResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r postUsersIDPasswordResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r postUsersIDPasswordResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type getVariablesResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Variables
	JSON400      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r getVariablesResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r getVariablesResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type postVariablesResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *Variable
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r postVariablesResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r postVariablesResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type deleteVariablesIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r deleteVariablesIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r deleteVariablesIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type getVariablesIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Variable
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r getVariablesIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r getVariablesIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type patchVariablesIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Variable
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r patchVariablesIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r patchVariablesIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type putVariablesIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Variable
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r putVariablesIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r putVariablesIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type getVariablesIDLabelsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *LabelsResponse
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r getVariablesIDLabelsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r getVariablesIDLabelsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type postVariablesIDLabelsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *LabelResponse
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r postVariablesIDLabelsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r postVariablesIDLabelsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type deleteVariablesIDLabelsIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r deleteVariablesIDLabelsIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r deleteVariablesIDLabelsIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type postWriteResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON400      *LineProtocolError
	JSON401      *Error
	JSON403      *Error
	JSON413      *LineProtocolLengthError
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r postWriteResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r postWriteResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

// GetRoutesWithResponse request returning *GetRoutesResponse
func (c *ClientWithResponses) GetRoutesWithResponse(ctx context.Context, params *GetRoutesParams) (*getRoutesResponse, error) {
	rsp, err := c.GetRoutes(ctx, params)
	if err != nil {
		return nil, err
	}
	return ParseGetRoutesResponse(rsp)
}

// GetAuthorizationsWithResponse request returning *GetAuthorizationsResponse
func (c *ClientWithResponses) GetAuthorizationsWithResponse(ctx context.Context, params *GetAuthorizationsParams) (*getAuthorizationsResponse, error) {
	rsp, err := c.GetAuthorizations(ctx, params)
	if err != nil {
		return nil, err
	}
	return ParseGetAuthorizationsResponse(rsp)
}

// PostAuthorizationsWithBodyWithResponse request with arbitrary body returning *PostAuthorizationsResponse
func (c *ClientWithResponses) PostAuthorizationsWithBodyWithResponse(ctx context.Context, params *PostAuthorizationsParams, contentType string, body io.Reader) (*postAuthorizationsResponse, error) {
	rsp, err := c.PostAuthorizationsWithBody(ctx, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostAuthorizationsResponse(rsp)
}

func (c *ClientWithResponses) PostAuthorizationsWithResponse(ctx context.Context, params *PostAuthorizationsParams, body PostAuthorizationsJSONRequestBody) (*postAuthorizationsResponse, error) {
	rsp, err := c.PostAuthorizations(ctx, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostAuthorizationsResponse(rsp)
}

// DeleteAuthorizationsIDWithResponse request returning *DeleteAuthorizationsIDResponse
func (c *ClientWithResponses) DeleteAuthorizationsIDWithResponse(ctx context.Context, authID string, params *DeleteAuthorizationsIDParams) (*deleteAuthorizationsIDResponse, error) {
	rsp, err := c.DeleteAuthorizationsID(ctx, authID, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteAuthorizationsIDResponse(rsp)
}

// GetAuthorizationsIDWithResponse request returning *GetAuthorizationsIDResponse
func (c *ClientWithResponses) GetAuthorizationsIDWithResponse(ctx context.Context, authID string, params *GetAuthorizationsIDParams) (*getAuthorizationsIDResponse, error) {
	rsp, err := c.GetAuthorizationsID(ctx, authID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetAuthorizationsIDResponse(rsp)
}

// PatchAuthorizationsIDWithBodyWithResponse request with arbitrary body returning *PatchAuthorizationsIDResponse
func (c *ClientWithResponses) PatchAuthorizationsIDWithBodyWithResponse(ctx context.Context, authID string, params *PatchAuthorizationsIDParams, contentType string, body io.Reader) (*patchAuthorizationsIDResponse, error) {
	rsp, err := c.PatchAuthorizationsIDWithBody(ctx, authID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePatchAuthorizationsIDResponse(rsp)
}

func (c *ClientWithResponses) PatchAuthorizationsIDWithResponse(ctx context.Context, authID string, params *PatchAuthorizationsIDParams, body PatchAuthorizationsIDJSONRequestBody) (*patchAuthorizationsIDResponse, error) {
	rsp, err := c.PatchAuthorizationsID(ctx, authID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePatchAuthorizationsIDResponse(rsp)
}

// GetBucketsWithResponse request returning *GetBucketsResponse
func (c *ClientWithResponses) GetBucketsWithResponse(ctx context.Context, params *GetBucketsParams) (*getBucketsResponse, error) {
	rsp, err := c.GetBuckets(ctx, params)
	if err != nil {
		return nil, err
	}
	return ParseGetBucketsResponse(rsp)
}

// PostBucketsWithBodyWithResponse request with arbitrary body returning *PostBucketsResponse
func (c *ClientWithResponses) PostBucketsWithBodyWithResponse(ctx context.Context, params *PostBucketsParams, contentType string, body io.Reader) (*postBucketsResponse, error) {
	rsp, err := c.PostBucketsWithBody(ctx, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostBucketsResponse(rsp)
}

func (c *ClientWithResponses) PostBucketsWithResponse(ctx context.Context, params *PostBucketsParams, body PostBucketsJSONRequestBody) (*postBucketsResponse, error) {
	rsp, err := c.PostBuckets(ctx, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostBucketsResponse(rsp)
}

// DeleteBucketsIDWithResponse request returning *DeleteBucketsIDResponse
func (c *ClientWithResponses) DeleteBucketsIDWithResponse(ctx context.Context, bucketID string, params *DeleteBucketsIDParams) (*deleteBucketsIDResponse, error) {
	rsp, err := c.DeleteBucketsID(ctx, bucketID, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteBucketsIDResponse(rsp)
}

// GetBucketsIDWithResponse request returning *GetBucketsIDResponse
func (c *ClientWithResponses) GetBucketsIDWithResponse(ctx context.Context, bucketID string, params *GetBucketsIDParams) (*getBucketsIDResponse, error) {
	rsp, err := c.GetBucketsID(ctx, bucketID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetBucketsIDResponse(rsp)
}

// PatchBucketsIDWithBodyWithResponse request with arbitrary body returning *PatchBucketsIDResponse
func (c *ClientWithResponses) PatchBucketsIDWithBodyWithResponse(ctx context.Context, bucketID string, params *PatchBucketsIDParams, contentType string, body io.Reader) (*patchBucketsIDResponse, error) {
	rsp, err := c.PatchBucketsIDWithBody(ctx, bucketID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePatchBucketsIDResponse(rsp)
}

func (c *ClientWithResponses) PatchBucketsIDWithResponse(ctx context.Context, bucketID string, params *PatchBucketsIDParams, body PatchBucketsIDJSONRequestBody) (*patchBucketsIDResponse, error) {
	rsp, err := c.PatchBucketsID(ctx, bucketID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePatchBucketsIDResponse(rsp)
}

// GetBucketsIDLabelsWithResponse request returning *GetBucketsIDLabelsResponse
func (c *ClientWithResponses) GetBucketsIDLabelsWithResponse(ctx context.Context, bucketID string, params *GetBucketsIDLabelsParams) (*getBucketsIDLabelsResponse, error) {
	rsp, err := c.GetBucketsIDLabels(ctx, bucketID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetBucketsIDLabelsResponse(rsp)
}

// PostBucketsIDLabelsWithBodyWithResponse request with arbitrary body returning *PostBucketsIDLabelsResponse
func (c *ClientWithResponses) PostBucketsIDLabelsWithBodyWithResponse(ctx context.Context, bucketID string, params *PostBucketsIDLabelsParams, contentType string, body io.Reader) (*postBucketsIDLabelsResponse, error) {
	rsp, err := c.PostBucketsIDLabelsWithBody(ctx, bucketID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostBucketsIDLabelsResponse(rsp)
}

func (c *ClientWithResponses) PostBucketsIDLabelsWithResponse(ctx context.Context, bucketID string, params *PostBucketsIDLabelsParams, body PostBucketsIDLabelsJSONRequestBody) (*postBucketsIDLabelsResponse, error) {
	rsp, err := c.PostBucketsIDLabels(ctx, bucketID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostBucketsIDLabelsResponse(rsp)
}

// DeleteBucketsIDLabelsIDWithResponse request returning *DeleteBucketsIDLabelsIDResponse
func (c *ClientWithResponses) DeleteBucketsIDLabelsIDWithResponse(ctx context.Context, bucketID string, labelID string, params *DeleteBucketsIDLabelsIDParams) (*deleteBucketsIDLabelsIDResponse, error) {
	rsp, err := c.DeleteBucketsIDLabelsID(ctx, bucketID, labelID, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteBucketsIDLabelsIDResponse(rsp)
}

// GetBucketsIDMembersWithResponse request returning *GetBucketsIDMembersResponse
func (c *ClientWithResponses) GetBucketsIDMembersWithResponse(ctx context.Context, bucketID string, params *GetBucketsIDMembersParams) (*getBucketsIDMembersResponse, error) {
	rsp, err := c.GetBucketsIDMembers(ctx, bucketID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetBucketsIDMembersResponse(rsp)
}

// PostBucketsIDMembersWithBodyWithResponse request with arbitrary body returning *PostBucketsIDMembersResponse
func (c *ClientWithResponses) PostBucketsIDMembersWithBodyWithResponse(ctx context.Context, bucketID string, params *PostBucketsIDMembersParams, contentType string, body io.Reader) (*postBucketsIDMembersResponse, error) {
	rsp, err := c.PostBucketsIDMembersWithBody(ctx, bucketID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostBucketsIDMembersResponse(rsp)
}

func (c *ClientWithResponses) PostBucketsIDMembersWithResponse(ctx context.Context, bucketID string, params *PostBucketsIDMembersParams, body PostBucketsIDMembersJSONRequestBody) (*postBucketsIDMembersResponse, error) {
	rsp, err := c.PostBucketsIDMembers(ctx, bucketID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostBucketsIDMembersResponse(rsp)
}

// DeleteBucketsIDMembersIDWithResponse request returning *DeleteBucketsIDMembersIDResponse
func (c *ClientWithResponses) DeleteBucketsIDMembersIDWithResponse(ctx context.Context, bucketID string, userID string, params *DeleteBucketsIDMembersIDParams) (*deleteBucketsIDMembersIDResponse, error) {
	rsp, err := c.DeleteBucketsIDMembersID(ctx, bucketID, userID, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteBucketsIDMembersIDResponse(rsp)
}

// GetBucketsIDOwnersWithResponse request returning *GetBucketsIDOwnersResponse
func (c *ClientWithResponses) GetBucketsIDOwnersWithResponse(ctx context.Context, bucketID string, params *GetBucketsIDOwnersParams) (*getBucketsIDOwnersResponse, error) {
	rsp, err := c.GetBucketsIDOwners(ctx, bucketID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetBucketsIDOwnersResponse(rsp)
}

// PostBucketsIDOwnersWithBodyWithResponse request with arbitrary body returning *PostBucketsIDOwnersResponse
func (c *ClientWithResponses) PostBucketsIDOwnersWithBodyWithResponse(ctx context.Context, bucketID string, params *PostBucketsIDOwnersParams, contentType string, body io.Reader) (*postBucketsIDOwnersResponse, error) {
	rsp, err := c.PostBucketsIDOwnersWithBody(ctx, bucketID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostBucketsIDOwnersResponse(rsp)
}

func (c *ClientWithResponses) PostBucketsIDOwnersWithResponse(ctx context.Context, bucketID string, params *PostBucketsIDOwnersParams, body PostBucketsIDOwnersJSONRequestBody) (*postBucketsIDOwnersResponse, error) {
	rsp, err := c.PostBucketsIDOwners(ctx, bucketID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostBucketsIDOwnersResponse(rsp)
}

// DeleteBucketsIDOwnersIDWithResponse request returning *DeleteBucketsIDOwnersIDResponse
func (c *ClientWithResponses) DeleteBucketsIDOwnersIDWithResponse(ctx context.Context, bucketID string, userID string, params *DeleteBucketsIDOwnersIDParams) (*deleteBucketsIDOwnersIDResponse, error) {
	rsp, err := c.DeleteBucketsIDOwnersID(ctx, bucketID, userID, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteBucketsIDOwnersIDResponse(rsp)
}

// GetChecksWithResponse request returning *GetChecksResponse
func (c *ClientWithResponses) GetChecksWithResponse(ctx context.Context, params *GetChecksParams) (*getChecksResponse, error) {
	rsp, err := c.GetChecks(ctx, params)
	if err != nil {
		return nil, err
	}
	return ParseGetChecksResponse(rsp)
}

// CreateCheckWithBodyWithResponse request with arbitrary body returning *CreateCheckResponse
func (c *ClientWithResponses) CreateCheckWithBodyWithResponse(ctx context.Context, contentType string, body io.Reader) (*createCheckResponse, error) {
	rsp, err := c.CreateCheckWithBody(ctx, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParseCreateCheckResponse(rsp)
}

func (c *ClientWithResponses) CreateCheckWithResponse(ctx context.Context, body CreateCheckJSONRequestBody) (*createCheckResponse, error) {
	rsp, err := c.CreateCheck(ctx, body)
	if err != nil {
		return nil, err
	}
	return ParseCreateCheckResponse(rsp)
}

// DeleteChecksIDWithResponse request returning *DeleteChecksIDResponse
func (c *ClientWithResponses) DeleteChecksIDWithResponse(ctx context.Context, checkID string, params *DeleteChecksIDParams) (*deleteChecksIDResponse, error) {
	rsp, err := c.DeleteChecksID(ctx, checkID, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteChecksIDResponse(rsp)
}

// GetChecksIDWithResponse request returning *GetChecksIDResponse
func (c *ClientWithResponses) GetChecksIDWithResponse(ctx context.Context, checkID string, params *GetChecksIDParams) (*getChecksIDResponse, error) {
	rsp, err := c.GetChecksID(ctx, checkID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetChecksIDResponse(rsp)
}

// PatchChecksIDWithBodyWithResponse request with arbitrary body returning *PatchChecksIDResponse
func (c *ClientWithResponses) PatchChecksIDWithBodyWithResponse(ctx context.Context, checkID string, params *PatchChecksIDParams, contentType string, body io.Reader) (*patchChecksIDResponse, error) {
	rsp, err := c.PatchChecksIDWithBody(ctx, checkID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePatchChecksIDResponse(rsp)
}

func (c *ClientWithResponses) PatchChecksIDWithResponse(ctx context.Context, checkID string, params *PatchChecksIDParams, body PatchChecksIDJSONRequestBody) (*patchChecksIDResponse, error) {
	rsp, err := c.PatchChecksID(ctx, checkID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePatchChecksIDResponse(rsp)
}

// PutChecksIDWithBodyWithResponse request with arbitrary body returning *PutChecksIDResponse
func (c *ClientWithResponses) PutChecksIDWithBodyWithResponse(ctx context.Context, checkID string, params *PutChecksIDParams, contentType string, body io.Reader) (*putChecksIDResponse, error) {
	rsp, err := c.PutChecksIDWithBody(ctx, checkID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePutChecksIDResponse(rsp)
}

func (c *ClientWithResponses) PutChecksIDWithResponse(ctx context.Context, checkID string, params *PutChecksIDParams, body PutChecksIDJSONRequestBody) (*putChecksIDResponse, error) {
	rsp, err := c.PutChecksID(ctx, checkID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePutChecksIDResponse(rsp)
}

// GetChecksIDLabelsWithResponse request returning *GetChecksIDLabelsResponse
func (c *ClientWithResponses) GetChecksIDLabelsWithResponse(ctx context.Context, checkID string, params *GetChecksIDLabelsParams) (*getChecksIDLabelsResponse, error) {
	rsp, err := c.GetChecksIDLabels(ctx, checkID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetChecksIDLabelsResponse(rsp)
}

// PostChecksIDLabelsWithBodyWithResponse request with arbitrary body returning *PostChecksIDLabelsResponse
func (c *ClientWithResponses) PostChecksIDLabelsWithBodyWithResponse(ctx context.Context, checkID string, params *PostChecksIDLabelsParams, contentType string, body io.Reader) (*postChecksIDLabelsResponse, error) {
	rsp, err := c.PostChecksIDLabelsWithBody(ctx, checkID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostChecksIDLabelsResponse(rsp)
}

func (c *ClientWithResponses) PostChecksIDLabelsWithResponse(ctx context.Context, checkID string, params *PostChecksIDLabelsParams, body PostChecksIDLabelsJSONRequestBody) (*postChecksIDLabelsResponse, error) {
	rsp, err := c.PostChecksIDLabels(ctx, checkID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostChecksIDLabelsResponse(rsp)
}

// DeleteChecksIDLabelsIDWithResponse request returning *DeleteChecksIDLabelsIDResponse
func (c *ClientWithResponses) DeleteChecksIDLabelsIDWithResponse(ctx context.Context, checkID string, labelID string, params *DeleteChecksIDLabelsIDParams) (*deleteChecksIDLabelsIDResponse, error) {
	rsp, err := c.DeleteChecksIDLabelsID(ctx, checkID, labelID, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteChecksIDLabelsIDResponse(rsp)
}

// GetChecksIDQueryWithResponse request returning *GetChecksIDQueryResponse
func (c *ClientWithResponses) GetChecksIDQueryWithResponse(ctx context.Context, checkID string, params *GetChecksIDQueryParams) (*getChecksIDQueryResponse, error) {
	rsp, err := c.GetChecksIDQuery(ctx, checkID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetChecksIDQueryResponse(rsp)
}

// GetDashboardsWithResponse request returning *GetDashboardsResponse
func (c *ClientWithResponses) GetDashboardsWithResponse(ctx context.Context, params *GetDashboardsParams) (*getDashboardsResponse, error) {
	rsp, err := c.GetDashboards(ctx, params)
	if err != nil {
		return nil, err
	}
	return ParseGetDashboardsResponse(rsp)
}

// PostDashboardsWithBodyWithResponse request with arbitrary body returning *PostDashboardsResponse
func (c *ClientWithResponses) PostDashboardsWithBodyWithResponse(ctx context.Context, params *PostDashboardsParams, contentType string, body io.Reader) (*postDashboardsResponse, error) {
	rsp, err := c.PostDashboardsWithBody(ctx, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostDashboardsResponse(rsp)
}

func (c *ClientWithResponses) PostDashboardsWithResponse(ctx context.Context, params *PostDashboardsParams, body PostDashboardsJSONRequestBody) (*postDashboardsResponse, error) {
	rsp, err := c.PostDashboards(ctx, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostDashboardsResponse(rsp)
}

// DeleteDashboardsIDWithResponse request returning *DeleteDashboardsIDResponse
func (c *ClientWithResponses) DeleteDashboardsIDWithResponse(ctx context.Context, dashboardID string, params *DeleteDashboardsIDParams) (*deleteDashboardsIDResponse, error) {
	rsp, err := c.DeleteDashboardsID(ctx, dashboardID, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteDashboardsIDResponse(rsp)
}

// GetDashboardsIDWithResponse request returning *GetDashboardsIDResponse
func (c *ClientWithResponses) GetDashboardsIDWithResponse(ctx context.Context, dashboardID string, params *GetDashboardsIDParams) (*getDashboardsIDResponse, error) {
	rsp, err := c.GetDashboardsID(ctx, dashboardID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetDashboardsIDResponse(rsp)
}

// PatchDashboardsIDWithBodyWithResponse request with arbitrary body returning *PatchDashboardsIDResponse
func (c *ClientWithResponses) PatchDashboardsIDWithBodyWithResponse(ctx context.Context, dashboardID string, params *PatchDashboardsIDParams, contentType string, body io.Reader) (*patchDashboardsIDResponse, error) {
	rsp, err := c.PatchDashboardsIDWithBody(ctx, dashboardID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePatchDashboardsIDResponse(rsp)
}

func (c *ClientWithResponses) PatchDashboardsIDWithResponse(ctx context.Context, dashboardID string, params *PatchDashboardsIDParams, body PatchDashboardsIDJSONRequestBody) (*patchDashboardsIDResponse, error) {
	rsp, err := c.PatchDashboardsID(ctx, dashboardID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePatchDashboardsIDResponse(rsp)
}

// PostDashboardsIDCellsWithBodyWithResponse request with arbitrary body returning *PostDashboardsIDCellsResponse
func (c *ClientWithResponses) PostDashboardsIDCellsWithBodyWithResponse(ctx context.Context, dashboardID string, params *PostDashboardsIDCellsParams, contentType string, body io.Reader) (*postDashboardsIDCellsResponse, error) {
	rsp, err := c.PostDashboardsIDCellsWithBody(ctx, dashboardID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostDashboardsIDCellsResponse(rsp)
}

func (c *ClientWithResponses) PostDashboardsIDCellsWithResponse(ctx context.Context, dashboardID string, params *PostDashboardsIDCellsParams, body PostDashboardsIDCellsJSONRequestBody) (*postDashboardsIDCellsResponse, error) {
	rsp, err := c.PostDashboardsIDCells(ctx, dashboardID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostDashboardsIDCellsResponse(rsp)
}

// PutDashboardsIDCellsWithBodyWithResponse request with arbitrary body returning *PutDashboardsIDCellsResponse
func (c *ClientWithResponses) PutDashboardsIDCellsWithBodyWithResponse(ctx context.Context, dashboardID string, params *PutDashboardsIDCellsParams, contentType string, body io.Reader) (*putDashboardsIDCellsResponse, error) {
	rsp, err := c.PutDashboardsIDCellsWithBody(ctx, dashboardID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePutDashboardsIDCellsResponse(rsp)
}

func (c *ClientWithResponses) PutDashboardsIDCellsWithResponse(ctx context.Context, dashboardID string, params *PutDashboardsIDCellsParams, body PutDashboardsIDCellsJSONRequestBody) (*putDashboardsIDCellsResponse, error) {
	rsp, err := c.PutDashboardsIDCells(ctx, dashboardID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePutDashboardsIDCellsResponse(rsp)
}

// DeleteDashboardsIDCellsIDWithResponse request returning *DeleteDashboardsIDCellsIDResponse
func (c *ClientWithResponses) DeleteDashboardsIDCellsIDWithResponse(ctx context.Context, dashboardID string, cellID string, params *DeleteDashboardsIDCellsIDParams) (*deleteDashboardsIDCellsIDResponse, error) {
	rsp, err := c.DeleteDashboardsIDCellsID(ctx, dashboardID, cellID, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteDashboardsIDCellsIDResponse(rsp)
}

// PatchDashboardsIDCellsIDWithBodyWithResponse request with arbitrary body returning *PatchDashboardsIDCellsIDResponse
func (c *ClientWithResponses) PatchDashboardsIDCellsIDWithBodyWithResponse(ctx context.Context, dashboardID string, cellID string, params *PatchDashboardsIDCellsIDParams, contentType string, body io.Reader) (*patchDashboardsIDCellsIDResponse, error) {
	rsp, err := c.PatchDashboardsIDCellsIDWithBody(ctx, dashboardID, cellID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePatchDashboardsIDCellsIDResponse(rsp)
}

func (c *ClientWithResponses) PatchDashboardsIDCellsIDWithResponse(ctx context.Context, dashboardID string, cellID string, params *PatchDashboardsIDCellsIDParams, body PatchDashboardsIDCellsIDJSONRequestBody) (*patchDashboardsIDCellsIDResponse, error) {
	rsp, err := c.PatchDashboardsIDCellsID(ctx, dashboardID, cellID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePatchDashboardsIDCellsIDResponse(rsp)
}

// GetDashboardsIDCellsIDViewWithResponse request returning *GetDashboardsIDCellsIDViewResponse
func (c *ClientWithResponses) GetDashboardsIDCellsIDViewWithResponse(ctx context.Context, dashboardID string, cellID string, params *GetDashboardsIDCellsIDViewParams) (*getDashboardsIDCellsIDViewResponse, error) {
	rsp, err := c.GetDashboardsIDCellsIDView(ctx, dashboardID, cellID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetDashboardsIDCellsIDViewResponse(rsp)
}

// PatchDashboardsIDCellsIDViewWithBodyWithResponse request with arbitrary body returning *PatchDashboardsIDCellsIDViewResponse
func (c *ClientWithResponses) PatchDashboardsIDCellsIDViewWithBodyWithResponse(ctx context.Context, dashboardID string, cellID string, params *PatchDashboardsIDCellsIDViewParams, contentType string, body io.Reader) (*patchDashboardsIDCellsIDViewResponse, error) {
	rsp, err := c.PatchDashboardsIDCellsIDViewWithBody(ctx, dashboardID, cellID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePatchDashboardsIDCellsIDViewResponse(rsp)
}

func (c *ClientWithResponses) PatchDashboardsIDCellsIDViewWithResponse(ctx context.Context, dashboardID string, cellID string, params *PatchDashboardsIDCellsIDViewParams, body PatchDashboardsIDCellsIDViewJSONRequestBody) (*patchDashboardsIDCellsIDViewResponse, error) {
	rsp, err := c.PatchDashboardsIDCellsIDView(ctx, dashboardID, cellID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePatchDashboardsIDCellsIDViewResponse(rsp)
}

// GetDashboardsIDLabelsWithResponse request returning *GetDashboardsIDLabelsResponse
func (c *ClientWithResponses) GetDashboardsIDLabelsWithResponse(ctx context.Context, dashboardID string, params *GetDashboardsIDLabelsParams) (*getDashboardsIDLabelsResponse, error) {
	rsp, err := c.GetDashboardsIDLabels(ctx, dashboardID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetDashboardsIDLabelsResponse(rsp)
}

// PostDashboardsIDLabelsWithBodyWithResponse request with arbitrary body returning *PostDashboardsIDLabelsResponse
func (c *ClientWithResponses) PostDashboardsIDLabelsWithBodyWithResponse(ctx context.Context, dashboardID string, params *PostDashboardsIDLabelsParams, contentType string, body io.Reader) (*postDashboardsIDLabelsResponse, error) {
	rsp, err := c.PostDashboardsIDLabelsWithBody(ctx, dashboardID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostDashboardsIDLabelsResponse(rsp)
}

func (c *ClientWithResponses) PostDashboardsIDLabelsWithResponse(ctx context.Context, dashboardID string, params *PostDashboardsIDLabelsParams, body PostDashboardsIDLabelsJSONRequestBody) (*postDashboardsIDLabelsResponse, error) {
	rsp, err := c.PostDashboardsIDLabels(ctx, dashboardID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostDashboardsIDLabelsResponse(rsp)
}

// DeleteDashboardsIDLabelsIDWithResponse request returning *DeleteDashboardsIDLabelsIDResponse
func (c *ClientWithResponses) DeleteDashboardsIDLabelsIDWithResponse(ctx context.Context, dashboardID string, labelID string, params *DeleteDashboardsIDLabelsIDParams) (*deleteDashboardsIDLabelsIDResponse, error) {
	rsp, err := c.DeleteDashboardsIDLabelsID(ctx, dashboardID, labelID, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteDashboardsIDLabelsIDResponse(rsp)
}

// GetDashboardsIDMembersWithResponse request returning *GetDashboardsIDMembersResponse
func (c *ClientWithResponses) GetDashboardsIDMembersWithResponse(ctx context.Context, dashboardID string, params *GetDashboardsIDMembersParams) (*getDashboardsIDMembersResponse, error) {
	rsp, err := c.GetDashboardsIDMembers(ctx, dashboardID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetDashboardsIDMembersResponse(rsp)
}

// PostDashboardsIDMembersWithBodyWithResponse request with arbitrary body returning *PostDashboardsIDMembersResponse
func (c *ClientWithResponses) PostDashboardsIDMembersWithBodyWithResponse(ctx context.Context, dashboardID string, params *PostDashboardsIDMembersParams, contentType string, body io.Reader) (*postDashboardsIDMembersResponse, error) {
	rsp, err := c.PostDashboardsIDMembersWithBody(ctx, dashboardID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostDashboardsIDMembersResponse(rsp)
}

func (c *ClientWithResponses) PostDashboardsIDMembersWithResponse(ctx context.Context, dashboardID string, params *PostDashboardsIDMembersParams, body PostDashboardsIDMembersJSONRequestBody) (*postDashboardsIDMembersResponse, error) {
	rsp, err := c.PostDashboardsIDMembers(ctx, dashboardID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostDashboardsIDMembersResponse(rsp)
}

// DeleteDashboardsIDMembersIDWithResponse request returning *DeleteDashboardsIDMembersIDResponse
func (c *ClientWithResponses) DeleteDashboardsIDMembersIDWithResponse(ctx context.Context, dashboardID string, userID string, params *DeleteDashboardsIDMembersIDParams) (*deleteDashboardsIDMembersIDResponse, error) {
	rsp, err := c.DeleteDashboardsIDMembersID(ctx, dashboardID, userID, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteDashboardsIDMembersIDResponse(rsp)
}

// GetDashboardsIDOwnersWithResponse request returning *GetDashboardsIDOwnersResponse
func (c *ClientWithResponses) GetDashboardsIDOwnersWithResponse(ctx context.Context, dashboardID string, params *GetDashboardsIDOwnersParams) (*getDashboardsIDOwnersResponse, error) {
	rsp, err := c.GetDashboardsIDOwners(ctx, dashboardID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetDashboardsIDOwnersResponse(rsp)
}

// PostDashboardsIDOwnersWithBodyWithResponse request with arbitrary body returning *PostDashboardsIDOwnersResponse
func (c *ClientWithResponses) PostDashboardsIDOwnersWithBodyWithResponse(ctx context.Context, dashboardID string, params *PostDashboardsIDOwnersParams, contentType string, body io.Reader) (*postDashboardsIDOwnersResponse, error) {
	rsp, err := c.PostDashboardsIDOwnersWithBody(ctx, dashboardID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostDashboardsIDOwnersResponse(rsp)
}

func (c *ClientWithResponses) PostDashboardsIDOwnersWithResponse(ctx context.Context, dashboardID string, params *PostDashboardsIDOwnersParams, body PostDashboardsIDOwnersJSONRequestBody) (*postDashboardsIDOwnersResponse, error) {
	rsp, err := c.PostDashboardsIDOwners(ctx, dashboardID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostDashboardsIDOwnersResponse(rsp)
}

// DeleteDashboardsIDOwnersIDWithResponse request returning *DeleteDashboardsIDOwnersIDResponse
func (c *ClientWithResponses) DeleteDashboardsIDOwnersIDWithResponse(ctx context.Context, dashboardID string, userID string, params *DeleteDashboardsIDOwnersIDParams) (*deleteDashboardsIDOwnersIDResponse, error) {
	rsp, err := c.DeleteDashboardsIDOwnersID(ctx, dashboardID, userID, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteDashboardsIDOwnersIDResponse(rsp)
}

// GetDBRPsWithResponse request returning *GetDBRPsResponse
func (c *ClientWithResponses) GetDBRPsWithResponse(ctx context.Context, params *GetDBRPsParams) (*getDBRPsResponse, error) {
	rsp, err := c.GetDBRPs(ctx, params)
	if err != nil {
		return nil, err
	}
	return ParseGetDBRPsResponse(rsp)
}

// PostDBRPWithBodyWithResponse request with arbitrary body returning *PostDBRPResponse
func (c *ClientWithResponses) PostDBRPWithBodyWithResponse(ctx context.Context, params *PostDBRPParams, contentType string, body io.Reader) (*postDBRPResponse, error) {
	rsp, err := c.PostDBRPWithBody(ctx, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostDBRPResponse(rsp)
}

func (c *ClientWithResponses) PostDBRPWithResponse(ctx context.Context, params *PostDBRPParams, body PostDBRPJSONRequestBody) (*postDBRPResponse, error) {
	rsp, err := c.PostDBRP(ctx, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostDBRPResponse(rsp)
}

// DeleteDBRPIDWithResponse request returning *DeleteDBRPIDResponse
func (c *ClientWithResponses) DeleteDBRPIDWithResponse(ctx context.Context, dbrpID string, params *DeleteDBRPIDParams) (*deleteDBRPIDResponse, error) {
	rsp, err := c.DeleteDBRPID(ctx, dbrpID, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteDBRPIDResponse(rsp)
}

// GetDBRPsIDWithResponse request returning *GetDBRPsIDResponse
func (c *ClientWithResponses) GetDBRPsIDWithResponse(ctx context.Context, dbrpID string, params *GetDBRPsIDParams) (*getDBRPsIDResponse, error) {
	rsp, err := c.GetDBRPsID(ctx, dbrpID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetDBRPsIDResponse(rsp)
}

// PatchDBRPIDWithBodyWithResponse request with arbitrary body returning *PatchDBRPIDResponse
func (c *ClientWithResponses) PatchDBRPIDWithBodyWithResponse(ctx context.Context, dbrpID string, params *PatchDBRPIDParams, contentType string, body io.Reader) (*patchDBRPIDResponse, error) {
	rsp, err := c.PatchDBRPIDWithBody(ctx, dbrpID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePatchDBRPIDResponse(rsp)
}

func (c *ClientWithResponses) PatchDBRPIDWithResponse(ctx context.Context, dbrpID string, params *PatchDBRPIDParams, body PatchDBRPIDJSONRequestBody) (*patchDBRPIDResponse, error) {
	rsp, err := c.PatchDBRPID(ctx, dbrpID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePatchDBRPIDResponse(rsp)
}

// PostDeleteWithBodyWithResponse request with arbitrary body returning *PostDeleteResponse
func (c *ClientWithResponses) PostDeleteWithBodyWithResponse(ctx context.Context, params *PostDeleteParams, contentType string, body io.Reader) (*postDeleteResponse, error) {
	rsp, err := c.PostDeleteWithBody(ctx, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostDeleteResponse(rsp)
}

func (c *ClientWithResponses) PostDeleteWithResponse(ctx context.Context, params *PostDeleteParams, body PostDeleteJSONRequestBody) (*postDeleteResponse, error) {
	rsp, err := c.PostDelete(ctx, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostDeleteResponse(rsp)
}

// GetDocumentsTemplatesWithResponse request returning *GetDocumentsTemplatesResponse
func (c *ClientWithResponses) GetDocumentsTemplatesWithResponse(ctx context.Context, params *GetDocumentsTemplatesParams) (*getDocumentsTemplatesResponse, error) {
	rsp, err := c.GetDocumentsTemplates(ctx, params)
	if err != nil {
		return nil, err
	}
	return ParseGetDocumentsTemplatesResponse(rsp)
}

// PostDocumentsTemplatesWithBodyWithResponse request with arbitrary body returning *PostDocumentsTemplatesResponse
func (c *ClientWithResponses) PostDocumentsTemplatesWithBodyWithResponse(ctx context.Context, params *PostDocumentsTemplatesParams, contentType string, body io.Reader) (*postDocumentsTemplatesResponse, error) {
	rsp, err := c.PostDocumentsTemplatesWithBody(ctx, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostDocumentsTemplatesResponse(rsp)
}

func (c *ClientWithResponses) PostDocumentsTemplatesWithResponse(ctx context.Context, params *PostDocumentsTemplatesParams, body PostDocumentsTemplatesJSONRequestBody) (*postDocumentsTemplatesResponse, error) {
	rsp, err := c.PostDocumentsTemplates(ctx, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostDocumentsTemplatesResponse(rsp)
}

// DeleteDocumentsTemplatesIDWithResponse request returning *DeleteDocumentsTemplatesIDResponse
func (c *ClientWithResponses) DeleteDocumentsTemplatesIDWithResponse(ctx context.Context, templateID string, params *DeleteDocumentsTemplatesIDParams) (*deleteDocumentsTemplatesIDResponse, error) {
	rsp, err := c.DeleteDocumentsTemplatesID(ctx, templateID, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteDocumentsTemplatesIDResponse(rsp)
}

// GetDocumentsTemplatesIDWithResponse request returning *GetDocumentsTemplatesIDResponse
func (c *ClientWithResponses) GetDocumentsTemplatesIDWithResponse(ctx context.Context, templateID string, params *GetDocumentsTemplatesIDParams) (*getDocumentsTemplatesIDResponse, error) {
	rsp, err := c.GetDocumentsTemplatesID(ctx, templateID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetDocumentsTemplatesIDResponse(rsp)
}

// PutDocumentsTemplatesIDWithBodyWithResponse request with arbitrary body returning *PutDocumentsTemplatesIDResponse
func (c *ClientWithResponses) PutDocumentsTemplatesIDWithBodyWithResponse(ctx context.Context, templateID string, params *PutDocumentsTemplatesIDParams, contentType string, body io.Reader) (*putDocumentsTemplatesIDResponse, error) {
	rsp, err := c.PutDocumentsTemplatesIDWithBody(ctx, templateID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePutDocumentsTemplatesIDResponse(rsp)
}

func (c *ClientWithResponses) PutDocumentsTemplatesIDWithResponse(ctx context.Context, templateID string, params *PutDocumentsTemplatesIDParams, body PutDocumentsTemplatesIDJSONRequestBody) (*putDocumentsTemplatesIDResponse, error) {
	rsp, err := c.PutDocumentsTemplatesID(ctx, templateID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePutDocumentsTemplatesIDResponse(rsp)
}

// GetDocumentsTemplatesIDLabelsWithResponse request returning *GetDocumentsTemplatesIDLabelsResponse
func (c *ClientWithResponses) GetDocumentsTemplatesIDLabelsWithResponse(ctx context.Context, templateID string, params *GetDocumentsTemplatesIDLabelsParams) (*getDocumentsTemplatesIDLabelsResponse, error) {
	rsp, err := c.GetDocumentsTemplatesIDLabels(ctx, templateID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetDocumentsTemplatesIDLabelsResponse(rsp)
}

// PostDocumentsTemplatesIDLabelsWithBodyWithResponse request with arbitrary body returning *PostDocumentsTemplatesIDLabelsResponse
func (c *ClientWithResponses) PostDocumentsTemplatesIDLabelsWithBodyWithResponse(ctx context.Context, templateID string, params *PostDocumentsTemplatesIDLabelsParams, contentType string, body io.Reader) (*postDocumentsTemplatesIDLabelsResponse, error) {
	rsp, err := c.PostDocumentsTemplatesIDLabelsWithBody(ctx, templateID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostDocumentsTemplatesIDLabelsResponse(rsp)
}

func (c *ClientWithResponses) PostDocumentsTemplatesIDLabelsWithResponse(ctx context.Context, templateID string, params *PostDocumentsTemplatesIDLabelsParams, body PostDocumentsTemplatesIDLabelsJSONRequestBody) (*postDocumentsTemplatesIDLabelsResponse, error) {
	rsp, err := c.PostDocumentsTemplatesIDLabels(ctx, templateID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostDocumentsTemplatesIDLabelsResponse(rsp)
}

// DeleteDocumentsTemplatesIDLabelsIDWithResponse request returning *DeleteDocumentsTemplatesIDLabelsIDResponse
func (c *ClientWithResponses) DeleteDocumentsTemplatesIDLabelsIDWithResponse(ctx context.Context, templateID string, labelID string, params *DeleteDocumentsTemplatesIDLabelsIDParams) (*deleteDocumentsTemplatesIDLabelsIDResponse, error) {
	rsp, err := c.DeleteDocumentsTemplatesIDLabelsID(ctx, templateID, labelID, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteDocumentsTemplatesIDLabelsIDResponse(rsp)
}

// GetFlagsWithResponse request returning *GetFlagsResponse
func (c *ClientWithResponses) GetFlagsWithResponse(ctx context.Context, params *GetFlagsParams) (*getFlagsResponse, error) {
	rsp, err := c.GetFlags(ctx, params)
	if err != nil {
		return nil, err
	}
	return ParseGetFlagsResponse(rsp)
}

// GetHealthWithResponse request returning *GetHealthResponse
func (c *ClientWithResponses) GetHealthWithResponse(ctx context.Context, params *GetHealthParams) (*getHealthResponse, error) {
	rsp, err := c.GetHealth(ctx, params)
	if err != nil {
		return nil, err
	}
	return ParseGetHealthResponse(rsp)
}

// GetLabelsWithResponse request returning *GetLabelsResponse
func (c *ClientWithResponses) GetLabelsWithResponse(ctx context.Context, params *GetLabelsParams) (*getLabelsResponse, error) {
	rsp, err := c.GetLabels(ctx, params)
	if err != nil {
		return nil, err
	}
	return ParseGetLabelsResponse(rsp)
}

// PostLabelsWithBodyWithResponse request with arbitrary body returning *PostLabelsResponse
func (c *ClientWithResponses) PostLabelsWithBodyWithResponse(ctx context.Context, contentType string, body io.Reader) (*postLabelsResponse, error) {
	rsp, err := c.PostLabelsWithBody(ctx, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostLabelsResponse(rsp)
}

func (c *ClientWithResponses) PostLabelsWithResponse(ctx context.Context, body PostLabelsJSONRequestBody) (*postLabelsResponse, error) {
	rsp, err := c.PostLabels(ctx, body)
	if err != nil {
		return nil, err
	}
	return ParsePostLabelsResponse(rsp)
}

// DeleteLabelsIDWithResponse request returning *DeleteLabelsIDResponse
func (c *ClientWithResponses) DeleteLabelsIDWithResponse(ctx context.Context, labelID string, params *DeleteLabelsIDParams) (*deleteLabelsIDResponse, error) {
	rsp, err := c.DeleteLabelsID(ctx, labelID, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteLabelsIDResponse(rsp)
}

// GetLabelsIDWithResponse request returning *GetLabelsIDResponse
func (c *ClientWithResponses) GetLabelsIDWithResponse(ctx context.Context, labelID string, params *GetLabelsIDParams) (*getLabelsIDResponse, error) {
	rsp, err := c.GetLabelsID(ctx, labelID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetLabelsIDResponse(rsp)
}

// PatchLabelsIDWithBodyWithResponse request with arbitrary body returning *PatchLabelsIDResponse
func (c *ClientWithResponses) PatchLabelsIDWithBodyWithResponse(ctx context.Context, labelID string, params *PatchLabelsIDParams, contentType string, body io.Reader) (*patchLabelsIDResponse, error) {
	rsp, err := c.PatchLabelsIDWithBody(ctx, labelID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePatchLabelsIDResponse(rsp)
}

func (c *ClientWithResponses) PatchLabelsIDWithResponse(ctx context.Context, labelID string, params *PatchLabelsIDParams, body PatchLabelsIDJSONRequestBody) (*patchLabelsIDResponse, error) {
	rsp, err := c.PatchLabelsID(ctx, labelID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePatchLabelsIDResponse(rsp)
}

// GetMeWithResponse request returning *GetMeResponse
func (c *ClientWithResponses) GetMeWithResponse(ctx context.Context, params *GetMeParams) (*getMeResponse, error) {
	rsp, err := c.GetMe(ctx, params)
	if err != nil {
		return nil, err
	}
	return ParseGetMeResponse(rsp)
}

// PutMePasswordWithBodyWithResponse request with arbitrary body returning *PutMePasswordResponse
func (c *ClientWithResponses) PutMePasswordWithBodyWithResponse(ctx context.Context, params *PutMePasswordParams, contentType string, body io.Reader) (*putMePasswordResponse, error) {
	rsp, err := c.PutMePasswordWithBody(ctx, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePutMePasswordResponse(rsp)
}

func (c *ClientWithResponses) PutMePasswordWithResponse(ctx context.Context, params *PutMePasswordParams, body PutMePasswordJSONRequestBody) (*putMePasswordResponse, error) {
	rsp, err := c.PutMePassword(ctx, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePutMePasswordResponse(rsp)
}

// GetNotificationEndpointsWithResponse request returning *GetNotificationEndpointsResponse
func (c *ClientWithResponses) GetNotificationEndpointsWithResponse(ctx context.Context, params *GetNotificationEndpointsParams) (*getNotificationEndpointsResponse, error) {
	rsp, err := c.GetNotificationEndpoints(ctx, params)
	if err != nil {
		return nil, err
	}
	return ParseGetNotificationEndpointsResponse(rsp)
}

// CreateNotificationEndpointWithBodyWithResponse request with arbitrary body returning *CreateNotificationEndpointResponse
func (c *ClientWithResponses) CreateNotificationEndpointWithBodyWithResponse(ctx context.Context, contentType string, body io.Reader) (*createNotificationEndpointResponse, error) {
	rsp, err := c.CreateNotificationEndpointWithBody(ctx, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParseCreateNotificationEndpointResponse(rsp)
}

func (c *ClientWithResponses) CreateNotificationEndpointWithResponse(ctx context.Context, body CreateNotificationEndpointJSONRequestBody) (*createNotificationEndpointResponse, error) {
	rsp, err := c.CreateNotificationEndpoint(ctx, body)
	if err != nil {
		return nil, err
	}
	return ParseCreateNotificationEndpointResponse(rsp)
}

// DeleteNotificationEndpointsIDWithResponse request returning *DeleteNotificationEndpointsIDResponse
func (c *ClientWithResponses) DeleteNotificationEndpointsIDWithResponse(ctx context.Context, endpointID string, params *DeleteNotificationEndpointsIDParams) (*deleteNotificationEndpointsIDResponse, error) {
	rsp, err := c.DeleteNotificationEndpointsID(ctx, endpointID, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteNotificationEndpointsIDResponse(rsp)
}

// GetNotificationEndpointsIDWithResponse request returning *GetNotificationEndpointsIDResponse
func (c *ClientWithResponses) GetNotificationEndpointsIDWithResponse(ctx context.Context, endpointID string, params *GetNotificationEndpointsIDParams) (*getNotificationEndpointsIDResponse, error) {
	rsp, err := c.GetNotificationEndpointsID(ctx, endpointID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetNotificationEndpointsIDResponse(rsp)
}

// PatchNotificationEndpointsIDWithBodyWithResponse request with arbitrary body returning *PatchNotificationEndpointsIDResponse
func (c *ClientWithResponses) PatchNotificationEndpointsIDWithBodyWithResponse(ctx context.Context, endpointID string, params *PatchNotificationEndpointsIDParams, contentType string, body io.Reader) (*patchNotificationEndpointsIDResponse, error) {
	rsp, err := c.PatchNotificationEndpointsIDWithBody(ctx, endpointID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePatchNotificationEndpointsIDResponse(rsp)
}

func (c *ClientWithResponses) PatchNotificationEndpointsIDWithResponse(ctx context.Context, endpointID string, params *PatchNotificationEndpointsIDParams, body PatchNotificationEndpointsIDJSONRequestBody) (*patchNotificationEndpointsIDResponse, error) {
	rsp, err := c.PatchNotificationEndpointsID(ctx, endpointID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePatchNotificationEndpointsIDResponse(rsp)
}

// PutNotificationEndpointsIDWithBodyWithResponse request with arbitrary body returning *PutNotificationEndpointsIDResponse
func (c *ClientWithResponses) PutNotificationEndpointsIDWithBodyWithResponse(ctx context.Context, endpointID string, params *PutNotificationEndpointsIDParams, contentType string, body io.Reader) (*putNotificationEndpointsIDResponse, error) {
	rsp, err := c.PutNotificationEndpointsIDWithBody(ctx, endpointID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePutNotificationEndpointsIDResponse(rsp)
}

func (c *ClientWithResponses) PutNotificationEndpointsIDWithResponse(ctx context.Context, endpointID string, params *PutNotificationEndpointsIDParams, body PutNotificationEndpointsIDJSONRequestBody) (*putNotificationEndpointsIDResponse, error) {
	rsp, err := c.PutNotificationEndpointsID(ctx, endpointID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePutNotificationEndpointsIDResponse(rsp)
}

// GetNotificationEndpointsIDLabelsWithResponse request returning *GetNotificationEndpointsIDLabelsResponse
func (c *ClientWithResponses) GetNotificationEndpointsIDLabelsWithResponse(ctx context.Context, endpointID string, params *GetNotificationEndpointsIDLabelsParams) (*getNotificationEndpointsIDLabelsResponse, error) {
	rsp, err := c.GetNotificationEndpointsIDLabels(ctx, endpointID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetNotificationEndpointsIDLabelsResponse(rsp)
}

// PostNotificationEndpointIDLabelsWithBodyWithResponse request with arbitrary body returning *PostNotificationEndpointIDLabelsResponse
func (c *ClientWithResponses) PostNotificationEndpointIDLabelsWithBodyWithResponse(ctx context.Context, endpointID string, params *PostNotificationEndpointIDLabelsParams, contentType string, body io.Reader) (*postNotificationEndpointIDLabelsResponse, error) {
	rsp, err := c.PostNotificationEndpointIDLabelsWithBody(ctx, endpointID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostNotificationEndpointIDLabelsResponse(rsp)
}

func (c *ClientWithResponses) PostNotificationEndpointIDLabelsWithResponse(ctx context.Context, endpointID string, params *PostNotificationEndpointIDLabelsParams, body PostNotificationEndpointIDLabelsJSONRequestBody) (*postNotificationEndpointIDLabelsResponse, error) {
	rsp, err := c.PostNotificationEndpointIDLabels(ctx, endpointID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostNotificationEndpointIDLabelsResponse(rsp)
}

// DeleteNotificationEndpointsIDLabelsIDWithResponse request returning *DeleteNotificationEndpointsIDLabelsIDResponse
func (c *ClientWithResponses) DeleteNotificationEndpointsIDLabelsIDWithResponse(ctx context.Context, endpointID string, labelID string, params *DeleteNotificationEndpointsIDLabelsIDParams) (*deleteNotificationEndpointsIDLabelsIDResponse, error) {
	rsp, err := c.DeleteNotificationEndpointsIDLabelsID(ctx, endpointID, labelID, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteNotificationEndpointsIDLabelsIDResponse(rsp)
}

// GetNotificationRulesWithResponse request returning *GetNotificationRulesResponse
func (c *ClientWithResponses) GetNotificationRulesWithResponse(ctx context.Context, params *GetNotificationRulesParams) (*getNotificationRulesResponse, error) {
	rsp, err := c.GetNotificationRules(ctx, params)
	if err != nil {
		return nil, err
	}
	return ParseGetNotificationRulesResponse(rsp)
}

// CreateNotificationRuleWithBodyWithResponse request with arbitrary body returning *CreateNotificationRuleResponse
func (c *ClientWithResponses) CreateNotificationRuleWithBodyWithResponse(ctx context.Context, contentType string, body io.Reader) (*createNotificationRuleResponse, error) {
	rsp, err := c.CreateNotificationRuleWithBody(ctx, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParseCreateNotificationRuleResponse(rsp)
}

func (c *ClientWithResponses) CreateNotificationRuleWithResponse(ctx context.Context, body CreateNotificationRuleJSONRequestBody) (*createNotificationRuleResponse, error) {
	rsp, err := c.CreateNotificationRule(ctx, body)
	if err != nil {
		return nil, err
	}
	return ParseCreateNotificationRuleResponse(rsp)
}

// DeleteNotificationRulesIDWithResponse request returning *DeleteNotificationRulesIDResponse
func (c *ClientWithResponses) DeleteNotificationRulesIDWithResponse(ctx context.Context, ruleID string, params *DeleteNotificationRulesIDParams) (*deleteNotificationRulesIDResponse, error) {
	rsp, err := c.DeleteNotificationRulesID(ctx, ruleID, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteNotificationRulesIDResponse(rsp)
}

// GetNotificationRulesIDWithResponse request returning *GetNotificationRulesIDResponse
func (c *ClientWithResponses) GetNotificationRulesIDWithResponse(ctx context.Context, ruleID string, params *GetNotificationRulesIDParams) (*getNotificationRulesIDResponse, error) {
	rsp, err := c.GetNotificationRulesID(ctx, ruleID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetNotificationRulesIDResponse(rsp)
}

// PatchNotificationRulesIDWithBodyWithResponse request with arbitrary body returning *PatchNotificationRulesIDResponse
func (c *ClientWithResponses) PatchNotificationRulesIDWithBodyWithResponse(ctx context.Context, ruleID string, params *PatchNotificationRulesIDParams, contentType string, body io.Reader) (*patchNotificationRulesIDResponse, error) {
	rsp, err := c.PatchNotificationRulesIDWithBody(ctx, ruleID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePatchNotificationRulesIDResponse(rsp)
}

func (c *ClientWithResponses) PatchNotificationRulesIDWithResponse(ctx context.Context, ruleID string, params *PatchNotificationRulesIDParams, body PatchNotificationRulesIDJSONRequestBody) (*patchNotificationRulesIDResponse, error) {
	rsp, err := c.PatchNotificationRulesID(ctx, ruleID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePatchNotificationRulesIDResponse(rsp)
}

// PutNotificationRulesIDWithBodyWithResponse request with arbitrary body returning *PutNotificationRulesIDResponse
func (c *ClientWithResponses) PutNotificationRulesIDWithBodyWithResponse(ctx context.Context, ruleID string, params *PutNotificationRulesIDParams, contentType string, body io.Reader) (*putNotificationRulesIDResponse, error) {
	rsp, err := c.PutNotificationRulesIDWithBody(ctx, ruleID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePutNotificationRulesIDResponse(rsp)
}

func (c *ClientWithResponses) PutNotificationRulesIDWithResponse(ctx context.Context, ruleID string, params *PutNotificationRulesIDParams, body PutNotificationRulesIDJSONRequestBody) (*putNotificationRulesIDResponse, error) {
	rsp, err := c.PutNotificationRulesID(ctx, ruleID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePutNotificationRulesIDResponse(rsp)
}

// GetNotificationRulesIDLabelsWithResponse request returning *GetNotificationRulesIDLabelsResponse
func (c *ClientWithResponses) GetNotificationRulesIDLabelsWithResponse(ctx context.Context, ruleID string, params *GetNotificationRulesIDLabelsParams) (*getNotificationRulesIDLabelsResponse, error) {
	rsp, err := c.GetNotificationRulesIDLabels(ctx, ruleID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetNotificationRulesIDLabelsResponse(rsp)
}

// PostNotificationRuleIDLabelsWithBodyWithResponse request with arbitrary body returning *PostNotificationRuleIDLabelsResponse
func (c *ClientWithResponses) PostNotificationRuleIDLabelsWithBodyWithResponse(ctx context.Context, ruleID string, params *PostNotificationRuleIDLabelsParams, contentType string, body io.Reader) (*postNotificationRuleIDLabelsResponse, error) {
	rsp, err := c.PostNotificationRuleIDLabelsWithBody(ctx, ruleID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostNotificationRuleIDLabelsResponse(rsp)
}

func (c *ClientWithResponses) PostNotificationRuleIDLabelsWithResponse(ctx context.Context, ruleID string, params *PostNotificationRuleIDLabelsParams, body PostNotificationRuleIDLabelsJSONRequestBody) (*postNotificationRuleIDLabelsResponse, error) {
	rsp, err := c.PostNotificationRuleIDLabels(ctx, ruleID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostNotificationRuleIDLabelsResponse(rsp)
}

// DeleteNotificationRulesIDLabelsIDWithResponse request returning *DeleteNotificationRulesIDLabelsIDResponse
func (c *ClientWithResponses) DeleteNotificationRulesIDLabelsIDWithResponse(ctx context.Context, ruleID string, labelID string, params *DeleteNotificationRulesIDLabelsIDParams) (*deleteNotificationRulesIDLabelsIDResponse, error) {
	rsp, err := c.DeleteNotificationRulesIDLabelsID(ctx, ruleID, labelID, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteNotificationRulesIDLabelsIDResponse(rsp)
}

// GetNotificationRulesIDQueryWithResponse request returning *GetNotificationRulesIDQueryResponse
func (c *ClientWithResponses) GetNotificationRulesIDQueryWithResponse(ctx context.Context, ruleID string, params *GetNotificationRulesIDQueryParams) (*getNotificationRulesIDQueryResponse, error) {
	rsp, err := c.GetNotificationRulesIDQuery(ctx, ruleID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetNotificationRulesIDQueryResponse(rsp)
}

// GetOrgsWithResponse request returning *GetOrgsResponse
func (c *ClientWithResponses) GetOrgsWithResponse(ctx context.Context, params *GetOrgsParams) (*getOrgsResponse, error) {
	rsp, err := c.GetOrgs(ctx, params)
	if err != nil {
		return nil, err
	}
	return ParseGetOrgsResponse(rsp)
}

// PostOrgsWithBodyWithResponse request with arbitrary body returning *PostOrgsResponse
func (c *ClientWithResponses) PostOrgsWithBodyWithResponse(ctx context.Context, params *PostOrgsParams, contentType string, body io.Reader) (*postOrgsResponse, error) {
	rsp, err := c.PostOrgsWithBody(ctx, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostOrgsResponse(rsp)
}

func (c *ClientWithResponses) PostOrgsWithResponse(ctx context.Context, params *PostOrgsParams, body PostOrgsJSONRequestBody) (*postOrgsResponse, error) {
	rsp, err := c.PostOrgs(ctx, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostOrgsResponse(rsp)
}

// DeleteOrgsIDWithResponse request returning *DeleteOrgsIDResponse
func (c *ClientWithResponses) DeleteOrgsIDWithResponse(ctx context.Context, orgID string, params *DeleteOrgsIDParams) (*deleteOrgsIDResponse, error) {
	rsp, err := c.DeleteOrgsID(ctx, orgID, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteOrgsIDResponse(rsp)
}

// GetOrgsIDWithResponse request returning *GetOrgsIDResponse
func (c *ClientWithResponses) GetOrgsIDWithResponse(ctx context.Context, orgID string, params *GetOrgsIDParams) (*getOrgsIDResponse, error) {
	rsp, err := c.GetOrgsID(ctx, orgID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetOrgsIDResponse(rsp)
}

// PatchOrgsIDWithBodyWithResponse request with arbitrary body returning *PatchOrgsIDResponse
func (c *ClientWithResponses) PatchOrgsIDWithBodyWithResponse(ctx context.Context, orgID string, params *PatchOrgsIDParams, contentType string, body io.Reader) (*patchOrgsIDResponse, error) {
	rsp, err := c.PatchOrgsIDWithBody(ctx, orgID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePatchOrgsIDResponse(rsp)
}

func (c *ClientWithResponses) PatchOrgsIDWithResponse(ctx context.Context, orgID string, params *PatchOrgsIDParams, body PatchOrgsIDJSONRequestBody) (*patchOrgsIDResponse, error) {
	rsp, err := c.PatchOrgsID(ctx, orgID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePatchOrgsIDResponse(rsp)
}

// GetOrgsIDMembersWithResponse request returning *GetOrgsIDMembersResponse
func (c *ClientWithResponses) GetOrgsIDMembersWithResponse(ctx context.Context, orgID string, params *GetOrgsIDMembersParams) (*getOrgsIDMembersResponse, error) {
	rsp, err := c.GetOrgsIDMembers(ctx, orgID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetOrgsIDMembersResponse(rsp)
}

// PostOrgsIDMembersWithBodyWithResponse request with arbitrary body returning *PostOrgsIDMembersResponse
func (c *ClientWithResponses) PostOrgsIDMembersWithBodyWithResponse(ctx context.Context, orgID string, params *PostOrgsIDMembersParams, contentType string, body io.Reader) (*postOrgsIDMembersResponse, error) {
	rsp, err := c.PostOrgsIDMembersWithBody(ctx, orgID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostOrgsIDMembersResponse(rsp)
}

func (c *ClientWithResponses) PostOrgsIDMembersWithResponse(ctx context.Context, orgID string, params *PostOrgsIDMembersParams, body PostOrgsIDMembersJSONRequestBody) (*postOrgsIDMembersResponse, error) {
	rsp, err := c.PostOrgsIDMembers(ctx, orgID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostOrgsIDMembersResponse(rsp)
}

// DeleteOrgsIDMembersIDWithResponse request returning *DeleteOrgsIDMembersIDResponse
func (c *ClientWithResponses) DeleteOrgsIDMembersIDWithResponse(ctx context.Context, orgID string, userID string, params *DeleteOrgsIDMembersIDParams) (*deleteOrgsIDMembersIDResponse, error) {
	rsp, err := c.DeleteOrgsIDMembersID(ctx, orgID, userID, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteOrgsIDMembersIDResponse(rsp)
}

// GetOrgsIDOwnersWithResponse request returning *GetOrgsIDOwnersResponse
func (c *ClientWithResponses) GetOrgsIDOwnersWithResponse(ctx context.Context, orgID string, params *GetOrgsIDOwnersParams) (*getOrgsIDOwnersResponse, error) {
	rsp, err := c.GetOrgsIDOwners(ctx, orgID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetOrgsIDOwnersResponse(rsp)
}

// PostOrgsIDOwnersWithBodyWithResponse request with arbitrary body returning *PostOrgsIDOwnersResponse
func (c *ClientWithResponses) PostOrgsIDOwnersWithBodyWithResponse(ctx context.Context, orgID string, params *PostOrgsIDOwnersParams, contentType string, body io.Reader) (*postOrgsIDOwnersResponse, error) {
	rsp, err := c.PostOrgsIDOwnersWithBody(ctx, orgID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostOrgsIDOwnersResponse(rsp)
}

func (c *ClientWithResponses) PostOrgsIDOwnersWithResponse(ctx context.Context, orgID string, params *PostOrgsIDOwnersParams, body PostOrgsIDOwnersJSONRequestBody) (*postOrgsIDOwnersResponse, error) {
	rsp, err := c.PostOrgsIDOwners(ctx, orgID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostOrgsIDOwnersResponse(rsp)
}

// DeleteOrgsIDOwnersIDWithResponse request returning *DeleteOrgsIDOwnersIDResponse
func (c *ClientWithResponses) DeleteOrgsIDOwnersIDWithResponse(ctx context.Context, orgID string, userID string, params *DeleteOrgsIDOwnersIDParams) (*deleteOrgsIDOwnersIDResponse, error) {
	rsp, err := c.DeleteOrgsIDOwnersID(ctx, orgID, userID, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteOrgsIDOwnersIDResponse(rsp)
}

// GetOrgsIDSecretsWithResponse request returning *GetOrgsIDSecretsResponse
func (c *ClientWithResponses) GetOrgsIDSecretsWithResponse(ctx context.Context, orgID string, params *GetOrgsIDSecretsParams) (*getOrgsIDSecretsResponse, error) {
	rsp, err := c.GetOrgsIDSecrets(ctx, orgID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetOrgsIDSecretsResponse(rsp)
}

// PatchOrgsIDSecretsWithBodyWithResponse request with arbitrary body returning *PatchOrgsIDSecretsResponse
func (c *ClientWithResponses) PatchOrgsIDSecretsWithBodyWithResponse(ctx context.Context, orgID string, params *PatchOrgsIDSecretsParams, contentType string, body io.Reader) (*patchOrgsIDSecretsResponse, error) {
	rsp, err := c.PatchOrgsIDSecretsWithBody(ctx, orgID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePatchOrgsIDSecretsResponse(rsp)
}

func (c *ClientWithResponses) PatchOrgsIDSecretsWithResponse(ctx context.Context, orgID string, params *PatchOrgsIDSecretsParams, body PatchOrgsIDSecretsJSONRequestBody) (*patchOrgsIDSecretsResponse, error) {
	rsp, err := c.PatchOrgsIDSecrets(ctx, orgID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePatchOrgsIDSecretsResponse(rsp)
}

// PostOrgsIDSecretsWithBodyWithResponse request with arbitrary body returning *PostOrgsIDSecretsResponse
func (c *ClientWithResponses) PostOrgsIDSecretsWithBodyWithResponse(ctx context.Context, orgID string, params *PostOrgsIDSecretsParams, contentType string, body io.Reader) (*postOrgsIDSecretsResponse, error) {
	rsp, err := c.PostOrgsIDSecretsWithBody(ctx, orgID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostOrgsIDSecretsResponse(rsp)
}

func (c *ClientWithResponses) PostOrgsIDSecretsWithResponse(ctx context.Context, orgID string, params *PostOrgsIDSecretsParams, body PostOrgsIDSecretsJSONRequestBody) (*postOrgsIDSecretsResponse, error) {
	rsp, err := c.PostOrgsIDSecrets(ctx, orgID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostOrgsIDSecretsResponse(rsp)
}

// PostQueryWithBodyWithResponse request with arbitrary body returning *PostQueryResponse
func (c *ClientWithResponses) PostQueryWithBodyWithResponse(ctx context.Context, params *PostQueryParams, contentType string, body io.Reader) (*postQueryResponse, error) {
	rsp, err := c.PostQueryWithBody(ctx, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostQueryResponse(rsp)
}

func (c *ClientWithResponses) PostQueryWithResponse(ctx context.Context, params *PostQueryParams, body PostQueryJSONRequestBody) (*postQueryResponse, error) {
	rsp, err := c.PostQuery(ctx, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostQueryResponse(rsp)
}

// PostQueryAnalyzeWithBodyWithResponse request with arbitrary body returning *PostQueryAnalyzeResponse
func (c *ClientWithResponses) PostQueryAnalyzeWithBodyWithResponse(ctx context.Context, params *PostQueryAnalyzeParams, contentType string, body io.Reader) (*postQueryAnalyzeResponse, error) {
	rsp, err := c.PostQueryAnalyzeWithBody(ctx, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostQueryAnalyzeResponse(rsp)
}

func (c *ClientWithResponses) PostQueryAnalyzeWithResponse(ctx context.Context, params *PostQueryAnalyzeParams, body PostQueryAnalyzeJSONRequestBody) (*postQueryAnalyzeResponse, error) {
	rsp, err := c.PostQueryAnalyze(ctx, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostQueryAnalyzeResponse(rsp)
}

// PostQueryAstWithBodyWithResponse request with arbitrary body returning *PostQueryAstResponse
func (c *ClientWithResponses) PostQueryAstWithBodyWithResponse(ctx context.Context, params *PostQueryAstParams, contentType string, body io.Reader) (*postQueryAstResponse, error) {
	rsp, err := c.PostQueryAstWithBody(ctx, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostQueryAstResponse(rsp)
}

func (c *ClientWithResponses) PostQueryAstWithResponse(ctx context.Context, params *PostQueryAstParams, body PostQueryAstJSONRequestBody) (*postQueryAstResponse, error) {
	rsp, err := c.PostQueryAst(ctx, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostQueryAstResponse(rsp)
}

// GetQuerySuggestionsWithResponse request returning *GetQuerySuggestionsResponse
func (c *ClientWithResponses) GetQuerySuggestionsWithResponse(ctx context.Context, params *GetQuerySuggestionsParams) (*getQuerySuggestionsResponse, error) {
	rsp, err := c.GetQuerySuggestions(ctx, params)
	if err != nil {
		return nil, err
	}
	return ParseGetQuerySuggestionsResponse(rsp)
}

// GetQuerySuggestionsNameWithResponse request returning *GetQuerySuggestionsNameResponse
func (c *ClientWithResponses) GetQuerySuggestionsNameWithResponse(ctx context.Context, name string, params *GetQuerySuggestionsNameParams) (*getQuerySuggestionsNameResponse, error) {
	rsp, err := c.GetQuerySuggestionsName(ctx, name, params)
	if err != nil {
		return nil, err
	}
	return ParseGetQuerySuggestionsNameResponse(rsp)
}

// GetReadyWithResponse request returning *GetReadyResponse
func (c *ClientWithResponses) GetReadyWithResponse(ctx context.Context, params *GetReadyParams) (*getReadyResponse, error) {
	rsp, err := c.GetReady(ctx, params)
	if err != nil {
		return nil, err
	}
	return ParseGetReadyResponse(rsp)
}

// GetScrapersWithResponse request returning *GetScrapersResponse
func (c *ClientWithResponses) GetScrapersWithResponse(ctx context.Context, params *GetScrapersParams) (*getScrapersResponse, error) {
	rsp, err := c.GetScrapers(ctx, params)
	if err != nil {
		return nil, err
	}
	return ParseGetScrapersResponse(rsp)
}

// PostScrapersWithBodyWithResponse request with arbitrary body returning *PostScrapersResponse
func (c *ClientWithResponses) PostScrapersWithBodyWithResponse(ctx context.Context, params *PostScrapersParams, contentType string, body io.Reader) (*postScrapersResponse, error) {
	rsp, err := c.PostScrapersWithBody(ctx, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostScrapersResponse(rsp)
}

func (c *ClientWithResponses) PostScrapersWithResponse(ctx context.Context, params *PostScrapersParams, body PostScrapersJSONRequestBody) (*postScrapersResponse, error) {
	rsp, err := c.PostScrapers(ctx, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostScrapersResponse(rsp)
}

// DeleteScrapersIDWithResponse request returning *DeleteScrapersIDResponse
func (c *ClientWithResponses) DeleteScrapersIDWithResponse(ctx context.Context, scraperTargetID string, params *DeleteScrapersIDParams) (*deleteScrapersIDResponse, error) {
	rsp, err := c.DeleteScrapersID(ctx, scraperTargetID, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteScrapersIDResponse(rsp)
}

// GetScrapersIDWithResponse request returning *GetScrapersIDResponse
func (c *ClientWithResponses) GetScrapersIDWithResponse(ctx context.Context, scraperTargetID string, params *GetScrapersIDParams) (*getScrapersIDResponse, error) {
	rsp, err := c.GetScrapersID(ctx, scraperTargetID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetScrapersIDResponse(rsp)
}

// PatchScrapersIDWithBodyWithResponse request with arbitrary body returning *PatchScrapersIDResponse
func (c *ClientWithResponses) PatchScrapersIDWithBodyWithResponse(ctx context.Context, scraperTargetID string, params *PatchScrapersIDParams, contentType string, body io.Reader) (*patchScrapersIDResponse, error) {
	rsp, err := c.PatchScrapersIDWithBody(ctx, scraperTargetID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePatchScrapersIDResponse(rsp)
}

func (c *ClientWithResponses) PatchScrapersIDWithResponse(ctx context.Context, scraperTargetID string, params *PatchScrapersIDParams, body PatchScrapersIDJSONRequestBody) (*patchScrapersIDResponse, error) {
	rsp, err := c.PatchScrapersID(ctx, scraperTargetID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePatchScrapersIDResponse(rsp)
}

// GetScrapersIDLabelsWithResponse request returning *GetScrapersIDLabelsResponse
func (c *ClientWithResponses) GetScrapersIDLabelsWithResponse(ctx context.Context, scraperTargetID string, params *GetScrapersIDLabelsParams) (*getScrapersIDLabelsResponse, error) {
	rsp, err := c.GetScrapersIDLabels(ctx, scraperTargetID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetScrapersIDLabelsResponse(rsp)
}

// PostScrapersIDLabelsWithBodyWithResponse request with arbitrary body returning *PostScrapersIDLabelsResponse
func (c *ClientWithResponses) PostScrapersIDLabelsWithBodyWithResponse(ctx context.Context, scraperTargetID string, params *PostScrapersIDLabelsParams, contentType string, body io.Reader) (*postScrapersIDLabelsResponse, error) {
	rsp, err := c.PostScrapersIDLabelsWithBody(ctx, scraperTargetID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostScrapersIDLabelsResponse(rsp)
}

func (c *ClientWithResponses) PostScrapersIDLabelsWithResponse(ctx context.Context, scraperTargetID string, params *PostScrapersIDLabelsParams, body PostScrapersIDLabelsJSONRequestBody) (*postScrapersIDLabelsResponse, error) {
	rsp, err := c.PostScrapersIDLabels(ctx, scraperTargetID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostScrapersIDLabelsResponse(rsp)
}

// DeleteScrapersIDLabelsIDWithResponse request returning *DeleteScrapersIDLabelsIDResponse
func (c *ClientWithResponses) DeleteScrapersIDLabelsIDWithResponse(ctx context.Context, scraperTargetID string, labelID string, params *DeleteScrapersIDLabelsIDParams) (*deleteScrapersIDLabelsIDResponse, error) {
	rsp, err := c.DeleteScrapersIDLabelsID(ctx, scraperTargetID, labelID, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteScrapersIDLabelsIDResponse(rsp)
}

// PatchScrapersIDLabelsIDWithBodyWithResponse request with arbitrary body returning *PatchScrapersIDLabelsIDResponse
func (c *ClientWithResponses) PatchScrapersIDLabelsIDWithBodyWithResponse(ctx context.Context, scraperTargetID string, labelID string, params *PatchScrapersIDLabelsIDParams, contentType string, body io.Reader) (*patchScrapersIDLabelsIDResponse, error) {
	rsp, err := c.PatchScrapersIDLabelsIDWithBody(ctx, scraperTargetID, labelID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePatchScrapersIDLabelsIDResponse(rsp)
}

func (c *ClientWithResponses) PatchScrapersIDLabelsIDWithResponse(ctx context.Context, scraperTargetID string, labelID string, params *PatchScrapersIDLabelsIDParams, body PatchScrapersIDLabelsIDJSONRequestBody) (*patchScrapersIDLabelsIDResponse, error) {
	rsp, err := c.PatchScrapersIDLabelsID(ctx, scraperTargetID, labelID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePatchScrapersIDLabelsIDResponse(rsp)
}

// GetScrapersIDMembersWithResponse request returning *GetScrapersIDMembersResponse
func (c *ClientWithResponses) GetScrapersIDMembersWithResponse(ctx context.Context, scraperTargetID string, params *GetScrapersIDMembersParams) (*getScrapersIDMembersResponse, error) {
	rsp, err := c.GetScrapersIDMembers(ctx, scraperTargetID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetScrapersIDMembersResponse(rsp)
}

// PostScrapersIDMembersWithBodyWithResponse request with arbitrary body returning *PostScrapersIDMembersResponse
func (c *ClientWithResponses) PostScrapersIDMembersWithBodyWithResponse(ctx context.Context, scraperTargetID string, params *PostScrapersIDMembersParams, contentType string, body io.Reader) (*postScrapersIDMembersResponse, error) {
	rsp, err := c.PostScrapersIDMembersWithBody(ctx, scraperTargetID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostScrapersIDMembersResponse(rsp)
}

func (c *ClientWithResponses) PostScrapersIDMembersWithResponse(ctx context.Context, scraperTargetID string, params *PostScrapersIDMembersParams, body PostScrapersIDMembersJSONRequestBody) (*postScrapersIDMembersResponse, error) {
	rsp, err := c.PostScrapersIDMembers(ctx, scraperTargetID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostScrapersIDMembersResponse(rsp)
}

// DeleteScrapersIDMembersIDWithResponse request returning *DeleteScrapersIDMembersIDResponse
func (c *ClientWithResponses) DeleteScrapersIDMembersIDWithResponse(ctx context.Context, scraperTargetID string, userID string, params *DeleteScrapersIDMembersIDParams) (*deleteScrapersIDMembersIDResponse, error) {
	rsp, err := c.DeleteScrapersIDMembersID(ctx, scraperTargetID, userID, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteScrapersIDMembersIDResponse(rsp)
}

// GetScrapersIDOwnersWithResponse request returning *GetScrapersIDOwnersResponse
func (c *ClientWithResponses) GetScrapersIDOwnersWithResponse(ctx context.Context, scraperTargetID string, params *GetScrapersIDOwnersParams) (*getScrapersIDOwnersResponse, error) {
	rsp, err := c.GetScrapersIDOwners(ctx, scraperTargetID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetScrapersIDOwnersResponse(rsp)
}

// PostScrapersIDOwnersWithBodyWithResponse request with arbitrary body returning *PostScrapersIDOwnersResponse
func (c *ClientWithResponses) PostScrapersIDOwnersWithBodyWithResponse(ctx context.Context, scraperTargetID string, params *PostScrapersIDOwnersParams, contentType string, body io.Reader) (*postScrapersIDOwnersResponse, error) {
	rsp, err := c.PostScrapersIDOwnersWithBody(ctx, scraperTargetID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostScrapersIDOwnersResponse(rsp)
}

func (c *ClientWithResponses) PostScrapersIDOwnersWithResponse(ctx context.Context, scraperTargetID string, params *PostScrapersIDOwnersParams, body PostScrapersIDOwnersJSONRequestBody) (*postScrapersIDOwnersResponse, error) {
	rsp, err := c.PostScrapersIDOwners(ctx, scraperTargetID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostScrapersIDOwnersResponse(rsp)
}

// DeleteScrapersIDOwnersIDWithResponse request returning *DeleteScrapersIDOwnersIDResponse
func (c *ClientWithResponses) DeleteScrapersIDOwnersIDWithResponse(ctx context.Context, scraperTargetID string, userID string, params *DeleteScrapersIDOwnersIDParams) (*deleteScrapersIDOwnersIDResponse, error) {
	rsp, err := c.DeleteScrapersIDOwnersID(ctx, scraperTargetID, userID, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteScrapersIDOwnersIDResponse(rsp)
}

// GetSetupWithResponse request returning *GetSetupResponse
func (c *ClientWithResponses) GetSetupWithResponse(ctx context.Context, params *GetSetupParams) (*getSetupResponse, error) {
	rsp, err := c.GetSetup(ctx, params)
	if err != nil {
		return nil, err
	}
	return ParseGetSetupResponse(rsp)
}

// PostSetupWithBodyWithResponse request with arbitrary body returning *PostSetupResponse
func (c *ClientWithResponses) PostSetupWithBodyWithResponse(ctx context.Context, params *PostSetupParams, contentType string, body io.Reader) (*postSetupResponse, error) {
	rsp, err := c.PostSetupWithBody(ctx, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostSetupResponse(rsp)
}

func (c *ClientWithResponses) PostSetupWithResponse(ctx context.Context, params *PostSetupParams, body PostSetupJSONRequestBody) (*postSetupResponse, error) {
	rsp, err := c.PostSetup(ctx, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostSetupResponse(rsp)
}

// PostSetupUserWithBodyWithResponse request with arbitrary body returning *PostSetupUserResponse
func (c *ClientWithResponses) PostSetupUserWithBodyWithResponse(ctx context.Context, params *PostSetupUserParams, contentType string, body io.Reader) (*postSetupUserResponse, error) {
	rsp, err := c.PostSetupUserWithBody(ctx, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostSetupUserResponse(rsp)
}

func (c *ClientWithResponses) PostSetupUserWithResponse(ctx context.Context, params *PostSetupUserParams, body PostSetupUserJSONRequestBody) (*postSetupUserResponse, error) {
	rsp, err := c.PostSetupUser(ctx, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostSetupUserResponse(rsp)
}

// PostSigninWithResponse request returning *PostSigninResponse
func (c *ClientWithResponses) PostSigninWithResponse(ctx context.Context, params *PostSigninParams) (*postSigninResponse, error) {
	rsp, err := c.PostSignin(ctx, params)
	if err != nil {
		return nil, err
	}
	return ParsePostSigninResponse(rsp)
}

// PostSignoutWithResponse request returning *PostSignoutResponse
func (c *ClientWithResponses) PostSignoutWithResponse(ctx context.Context, params *PostSignoutParams) (*postSignoutResponse, error) {
	rsp, err := c.PostSignout(ctx, params)
	if err != nil {
		return nil, err
	}
	return ParsePostSignoutResponse(rsp)
}

// GetSourcesWithResponse request returning *GetSourcesResponse
func (c *ClientWithResponses) GetSourcesWithResponse(ctx context.Context, params *GetSourcesParams) (*getSourcesResponse, error) {
	rsp, err := c.GetSources(ctx, params)
	if err != nil {
		return nil, err
	}
	return ParseGetSourcesResponse(rsp)
}

// PostSourcesWithBodyWithResponse request with arbitrary body returning *PostSourcesResponse
func (c *ClientWithResponses) PostSourcesWithBodyWithResponse(ctx context.Context, params *PostSourcesParams, contentType string, body io.Reader) (*postSourcesResponse, error) {
	rsp, err := c.PostSourcesWithBody(ctx, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostSourcesResponse(rsp)
}

func (c *ClientWithResponses) PostSourcesWithResponse(ctx context.Context, params *PostSourcesParams, body PostSourcesJSONRequestBody) (*postSourcesResponse, error) {
	rsp, err := c.PostSources(ctx, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostSourcesResponse(rsp)
}

// DeleteSourcesIDWithResponse request returning *DeleteSourcesIDResponse
func (c *ClientWithResponses) DeleteSourcesIDWithResponse(ctx context.Context, sourceID string, params *DeleteSourcesIDParams) (*deleteSourcesIDResponse, error) {
	rsp, err := c.DeleteSourcesID(ctx, sourceID, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteSourcesIDResponse(rsp)
}

// GetSourcesIDWithResponse request returning *GetSourcesIDResponse
func (c *ClientWithResponses) GetSourcesIDWithResponse(ctx context.Context, sourceID string, params *GetSourcesIDParams) (*getSourcesIDResponse, error) {
	rsp, err := c.GetSourcesID(ctx, sourceID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetSourcesIDResponse(rsp)
}

// PatchSourcesIDWithBodyWithResponse request with arbitrary body returning *PatchSourcesIDResponse
func (c *ClientWithResponses) PatchSourcesIDWithBodyWithResponse(ctx context.Context, sourceID string, params *PatchSourcesIDParams, contentType string, body io.Reader) (*patchSourcesIDResponse, error) {
	rsp, err := c.PatchSourcesIDWithBody(ctx, sourceID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePatchSourcesIDResponse(rsp)
}

func (c *ClientWithResponses) PatchSourcesIDWithResponse(ctx context.Context, sourceID string, params *PatchSourcesIDParams, body PatchSourcesIDJSONRequestBody) (*patchSourcesIDResponse, error) {
	rsp, err := c.PatchSourcesID(ctx, sourceID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePatchSourcesIDResponse(rsp)
}

// GetSourcesIDBucketsWithResponse request returning *GetSourcesIDBucketsResponse
func (c *ClientWithResponses) GetSourcesIDBucketsWithResponse(ctx context.Context, sourceID string, params *GetSourcesIDBucketsParams) (*getSourcesIDBucketsResponse, error) {
	rsp, err := c.GetSourcesIDBuckets(ctx, sourceID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetSourcesIDBucketsResponse(rsp)
}

// GetSourcesIDHealthWithResponse request returning *GetSourcesIDHealthResponse
func (c *ClientWithResponses) GetSourcesIDHealthWithResponse(ctx context.Context, sourceID string, params *GetSourcesIDHealthParams) (*getSourcesIDHealthResponse, error) {
	rsp, err := c.GetSourcesIDHealth(ctx, sourceID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetSourcesIDHealthResponse(rsp)
}

// ListStacksWithResponse request returning *ListStacksResponse
func (c *ClientWithResponses) ListStacksWithResponse(ctx context.Context, params *ListStacksParams) (*listStacksResponse, error) {
	rsp, err := c.ListStacks(ctx, params)
	if err != nil {
		return nil, err
	}
	return ParseListStacksResponse(rsp)
}

// CreateStackWithBodyWithResponse request with arbitrary body returning *CreateStackResponse
func (c *ClientWithResponses) CreateStackWithBodyWithResponse(ctx context.Context, contentType string, body io.Reader) (*createStackResponse, error) {
	rsp, err := c.CreateStackWithBody(ctx, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParseCreateStackResponse(rsp)
}

func (c *ClientWithResponses) CreateStackWithResponse(ctx context.Context, body CreateStackJSONRequestBody) (*createStackResponse, error) {
	rsp, err := c.CreateStack(ctx, body)
	if err != nil {
		return nil, err
	}
	return ParseCreateStackResponse(rsp)
}

// DeleteStackWithResponse request returning *DeleteStackResponse
func (c *ClientWithResponses) DeleteStackWithResponse(ctx context.Context, stackId string, params *DeleteStackParams) (*deleteStackResponse, error) {
	rsp, err := c.DeleteStack(ctx, stackId, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteStackResponse(rsp)
}

// ReadStackWithResponse request returning *ReadStackResponse
func (c *ClientWithResponses) ReadStackWithResponse(ctx context.Context, stackId string) (*readStackResponse, error) {
	rsp, err := c.ReadStack(ctx, stackId)
	if err != nil {
		return nil, err
	}
	return ParseReadStackResponse(rsp)
}

// UpdateStackWithBodyWithResponse request with arbitrary body returning *UpdateStackResponse
func (c *ClientWithResponses) UpdateStackWithBodyWithResponse(ctx context.Context, stackId string, contentType string, body io.Reader) (*updateStackResponse, error) {
	rsp, err := c.UpdateStackWithBody(ctx, stackId, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParseUpdateStackResponse(rsp)
}

func (c *ClientWithResponses) UpdateStackWithResponse(ctx context.Context, stackId string, body UpdateStackJSONRequestBody) (*updateStackResponse, error) {
	rsp, err := c.UpdateStack(ctx, stackId, body)
	if err != nil {
		return nil, err
	}
	return ParseUpdateStackResponse(rsp)
}

// UninstallStackWithResponse request returning *UninstallStackResponse
func (c *ClientWithResponses) UninstallStackWithResponse(ctx context.Context, stackId string) (*uninstallStackResponse, error) {
	rsp, err := c.UninstallStack(ctx, stackId)
	if err != nil {
		return nil, err
	}
	return ParseUninstallStackResponse(rsp)
}

// GetTasksWithResponse request returning *GetTasksResponse
func (c *ClientWithResponses) GetTasksWithResponse(ctx context.Context, params *GetTasksParams) (*getTasksResponse, error) {
	rsp, err := c.GetTasks(ctx, params)
	if err != nil {
		return nil, err
	}
	return ParseGetTasksResponse(rsp)
}

// PostTasksWithBodyWithResponse request with arbitrary body returning *PostTasksResponse
func (c *ClientWithResponses) PostTasksWithBodyWithResponse(ctx context.Context, params *PostTasksParams, contentType string, body io.Reader) (*postTasksResponse, error) {
	rsp, err := c.PostTasksWithBody(ctx, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostTasksResponse(rsp)
}

func (c *ClientWithResponses) PostTasksWithResponse(ctx context.Context, params *PostTasksParams, body PostTasksJSONRequestBody) (*postTasksResponse, error) {
	rsp, err := c.PostTasks(ctx, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostTasksResponse(rsp)
}

// DeleteTasksIDWithResponse request returning *DeleteTasksIDResponse
func (c *ClientWithResponses) DeleteTasksIDWithResponse(ctx context.Context, taskID string, params *DeleteTasksIDParams) (*deleteTasksIDResponse, error) {
	rsp, err := c.DeleteTasksID(ctx, taskID, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteTasksIDResponse(rsp)
}

// GetTasksIDWithResponse request returning *GetTasksIDResponse
func (c *ClientWithResponses) GetTasksIDWithResponse(ctx context.Context, taskID string, params *GetTasksIDParams) (*getTasksIDResponse, error) {
	rsp, err := c.GetTasksID(ctx, taskID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetTasksIDResponse(rsp)
}

// PatchTasksIDWithBodyWithResponse request with arbitrary body returning *PatchTasksIDResponse
func (c *ClientWithResponses) PatchTasksIDWithBodyWithResponse(ctx context.Context, taskID string, params *PatchTasksIDParams, contentType string, body io.Reader) (*patchTasksIDResponse, error) {
	rsp, err := c.PatchTasksIDWithBody(ctx, taskID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePatchTasksIDResponse(rsp)
}

func (c *ClientWithResponses) PatchTasksIDWithResponse(ctx context.Context, taskID string, params *PatchTasksIDParams, body PatchTasksIDJSONRequestBody) (*patchTasksIDResponse, error) {
	rsp, err := c.PatchTasksID(ctx, taskID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePatchTasksIDResponse(rsp)
}

// GetTasksIDLabelsWithResponse request returning *GetTasksIDLabelsResponse
func (c *ClientWithResponses) GetTasksIDLabelsWithResponse(ctx context.Context, taskID string, params *GetTasksIDLabelsParams) (*getTasksIDLabelsResponse, error) {
	rsp, err := c.GetTasksIDLabels(ctx, taskID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetTasksIDLabelsResponse(rsp)
}

// PostTasksIDLabelsWithBodyWithResponse request with arbitrary body returning *PostTasksIDLabelsResponse
func (c *ClientWithResponses) PostTasksIDLabelsWithBodyWithResponse(ctx context.Context, taskID string, params *PostTasksIDLabelsParams, contentType string, body io.Reader) (*postTasksIDLabelsResponse, error) {
	rsp, err := c.PostTasksIDLabelsWithBody(ctx, taskID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostTasksIDLabelsResponse(rsp)
}

func (c *ClientWithResponses) PostTasksIDLabelsWithResponse(ctx context.Context, taskID string, params *PostTasksIDLabelsParams, body PostTasksIDLabelsJSONRequestBody) (*postTasksIDLabelsResponse, error) {
	rsp, err := c.PostTasksIDLabels(ctx, taskID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostTasksIDLabelsResponse(rsp)
}

// DeleteTasksIDLabelsIDWithResponse request returning *DeleteTasksIDLabelsIDResponse
func (c *ClientWithResponses) DeleteTasksIDLabelsIDWithResponse(ctx context.Context, taskID string, labelID string, params *DeleteTasksIDLabelsIDParams) (*deleteTasksIDLabelsIDResponse, error) {
	rsp, err := c.DeleteTasksIDLabelsID(ctx, taskID, labelID, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteTasksIDLabelsIDResponse(rsp)
}

// GetTasksIDLogsWithResponse request returning *GetTasksIDLogsResponse
func (c *ClientWithResponses) GetTasksIDLogsWithResponse(ctx context.Context, taskID string, params *GetTasksIDLogsParams) (*getTasksIDLogsResponse, error) {
	rsp, err := c.GetTasksIDLogs(ctx, taskID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetTasksIDLogsResponse(rsp)
}

// GetTasksIDMembersWithResponse request returning *GetTasksIDMembersResponse
func (c *ClientWithResponses) GetTasksIDMembersWithResponse(ctx context.Context, taskID string, params *GetTasksIDMembersParams) (*getTasksIDMembersResponse, error) {
	rsp, err := c.GetTasksIDMembers(ctx, taskID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetTasksIDMembersResponse(rsp)
}

// PostTasksIDMembersWithBodyWithResponse request with arbitrary body returning *PostTasksIDMembersResponse
func (c *ClientWithResponses) PostTasksIDMembersWithBodyWithResponse(ctx context.Context, taskID string, params *PostTasksIDMembersParams, contentType string, body io.Reader) (*postTasksIDMembersResponse, error) {
	rsp, err := c.PostTasksIDMembersWithBody(ctx, taskID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostTasksIDMembersResponse(rsp)
}

func (c *ClientWithResponses) PostTasksIDMembersWithResponse(ctx context.Context, taskID string, params *PostTasksIDMembersParams, body PostTasksIDMembersJSONRequestBody) (*postTasksIDMembersResponse, error) {
	rsp, err := c.PostTasksIDMembers(ctx, taskID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostTasksIDMembersResponse(rsp)
}

// DeleteTasksIDMembersIDWithResponse request returning *DeleteTasksIDMembersIDResponse
func (c *ClientWithResponses) DeleteTasksIDMembersIDWithResponse(ctx context.Context, taskID string, userID string, params *DeleteTasksIDMembersIDParams) (*deleteTasksIDMembersIDResponse, error) {
	rsp, err := c.DeleteTasksIDMembersID(ctx, taskID, userID, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteTasksIDMembersIDResponse(rsp)
}

// GetTasksIDOwnersWithResponse request returning *GetTasksIDOwnersResponse
func (c *ClientWithResponses) GetTasksIDOwnersWithResponse(ctx context.Context, taskID string, params *GetTasksIDOwnersParams) (*getTasksIDOwnersResponse, error) {
	rsp, err := c.GetTasksIDOwners(ctx, taskID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetTasksIDOwnersResponse(rsp)
}

// PostTasksIDOwnersWithBodyWithResponse request with arbitrary body returning *PostTasksIDOwnersResponse
func (c *ClientWithResponses) PostTasksIDOwnersWithBodyWithResponse(ctx context.Context, taskID string, params *PostTasksIDOwnersParams, contentType string, body io.Reader) (*postTasksIDOwnersResponse, error) {
	rsp, err := c.PostTasksIDOwnersWithBody(ctx, taskID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostTasksIDOwnersResponse(rsp)
}

func (c *ClientWithResponses) PostTasksIDOwnersWithResponse(ctx context.Context, taskID string, params *PostTasksIDOwnersParams, body PostTasksIDOwnersJSONRequestBody) (*postTasksIDOwnersResponse, error) {
	rsp, err := c.PostTasksIDOwners(ctx, taskID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostTasksIDOwnersResponse(rsp)
}

// DeleteTasksIDOwnersIDWithResponse request returning *DeleteTasksIDOwnersIDResponse
func (c *ClientWithResponses) DeleteTasksIDOwnersIDWithResponse(ctx context.Context, taskID string, userID string, params *DeleteTasksIDOwnersIDParams) (*deleteTasksIDOwnersIDResponse, error) {
	rsp, err := c.DeleteTasksIDOwnersID(ctx, taskID, userID, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteTasksIDOwnersIDResponse(rsp)
}

// GetTasksIDRunsWithResponse request returning *GetTasksIDRunsResponse
func (c *ClientWithResponses) GetTasksIDRunsWithResponse(ctx context.Context, taskID string, params *GetTasksIDRunsParams) (*getTasksIDRunsResponse, error) {
	rsp, err := c.GetTasksIDRuns(ctx, taskID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetTasksIDRunsResponse(rsp)
}

// PostTasksIDRunsWithBodyWithResponse request with arbitrary body returning *PostTasksIDRunsResponse
func (c *ClientWithResponses) PostTasksIDRunsWithBodyWithResponse(ctx context.Context, taskID string, params *PostTasksIDRunsParams, contentType string, body io.Reader) (*postTasksIDRunsResponse, error) {
	rsp, err := c.PostTasksIDRunsWithBody(ctx, taskID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostTasksIDRunsResponse(rsp)
}

func (c *ClientWithResponses) PostTasksIDRunsWithResponse(ctx context.Context, taskID string, params *PostTasksIDRunsParams, body PostTasksIDRunsJSONRequestBody) (*postTasksIDRunsResponse, error) {
	rsp, err := c.PostTasksIDRuns(ctx, taskID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostTasksIDRunsResponse(rsp)
}

// DeleteTasksIDRunsIDWithResponse request returning *DeleteTasksIDRunsIDResponse
func (c *ClientWithResponses) DeleteTasksIDRunsIDWithResponse(ctx context.Context, taskID string, runID string, params *DeleteTasksIDRunsIDParams) (*deleteTasksIDRunsIDResponse, error) {
	rsp, err := c.DeleteTasksIDRunsID(ctx, taskID, runID, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteTasksIDRunsIDResponse(rsp)
}

// GetTasksIDRunsIDWithResponse request returning *GetTasksIDRunsIDResponse
func (c *ClientWithResponses) GetTasksIDRunsIDWithResponse(ctx context.Context, taskID string, runID string, params *GetTasksIDRunsIDParams) (*getTasksIDRunsIDResponse, error) {
	rsp, err := c.GetTasksIDRunsID(ctx, taskID, runID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetTasksIDRunsIDResponse(rsp)
}

// GetTasksIDRunsIDLogsWithResponse request returning *GetTasksIDRunsIDLogsResponse
func (c *ClientWithResponses) GetTasksIDRunsIDLogsWithResponse(ctx context.Context, taskID string, runID string, params *GetTasksIDRunsIDLogsParams) (*getTasksIDRunsIDLogsResponse, error) {
	rsp, err := c.GetTasksIDRunsIDLogs(ctx, taskID, runID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetTasksIDRunsIDLogsResponse(rsp)
}

// PostTasksIDRunsIDRetryWithResponse request returning *PostTasksIDRunsIDRetryResponse
func (c *ClientWithResponses) PostTasksIDRunsIDRetryWithResponse(ctx context.Context, taskID string, runID string, params *PostTasksIDRunsIDRetryParams) (*postTasksIDRunsIDRetryResponse, error) {
	rsp, err := c.PostTasksIDRunsIDRetry(ctx, taskID, runID, params)
	if err != nil {
		return nil, err
	}
	return ParsePostTasksIDRunsIDRetryResponse(rsp)
}

// GetTelegrafPluginsWithResponse request returning *GetTelegrafPluginsResponse
func (c *ClientWithResponses) GetTelegrafPluginsWithResponse(ctx context.Context, params *GetTelegrafPluginsParams) (*getTelegrafPluginsResponse, error) {
	rsp, err := c.GetTelegrafPlugins(ctx, params)
	if err != nil {
		return nil, err
	}
	return ParseGetTelegrafPluginsResponse(rsp)
}

// GetTelegrafsWithResponse request returning *GetTelegrafsResponse
func (c *ClientWithResponses) GetTelegrafsWithResponse(ctx context.Context, params *GetTelegrafsParams) (*getTelegrafsResponse, error) {
	rsp, err := c.GetTelegrafs(ctx, params)
	if err != nil {
		return nil, err
	}
	return ParseGetTelegrafsResponse(rsp)
}

// PostTelegrafsWithBodyWithResponse request with arbitrary body returning *PostTelegrafsResponse
func (c *ClientWithResponses) PostTelegrafsWithBodyWithResponse(ctx context.Context, params *PostTelegrafsParams, contentType string, body io.Reader) (*postTelegrafsResponse, error) {
	rsp, err := c.PostTelegrafsWithBody(ctx, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostTelegrafsResponse(rsp)
}

func (c *ClientWithResponses) PostTelegrafsWithResponse(ctx context.Context, params *PostTelegrafsParams, body PostTelegrafsJSONRequestBody) (*postTelegrafsResponse, error) {
	rsp, err := c.PostTelegrafs(ctx, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostTelegrafsResponse(rsp)
}

// DeleteTelegrafsIDWithResponse request returning *DeleteTelegrafsIDResponse
func (c *ClientWithResponses) DeleteTelegrafsIDWithResponse(ctx context.Context, telegrafID string, params *DeleteTelegrafsIDParams) (*deleteTelegrafsIDResponse, error) {
	rsp, err := c.DeleteTelegrafsID(ctx, telegrafID, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteTelegrafsIDResponse(rsp)
}

// GetTelegrafsIDWithResponse request returning *GetTelegrafsIDResponse
func (c *ClientWithResponses) GetTelegrafsIDWithResponse(ctx context.Context, telegrafID string, params *GetTelegrafsIDParams) (*getTelegrafsIDResponse, error) {
	rsp, err := c.GetTelegrafsID(ctx, telegrafID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetTelegrafsIDResponse(rsp)
}

// PutTelegrafsIDWithBodyWithResponse request with arbitrary body returning *PutTelegrafsIDResponse
func (c *ClientWithResponses) PutTelegrafsIDWithBodyWithResponse(ctx context.Context, telegrafID string, params *PutTelegrafsIDParams, contentType string, body io.Reader) (*putTelegrafsIDResponse, error) {
	rsp, err := c.PutTelegrafsIDWithBody(ctx, telegrafID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePutTelegrafsIDResponse(rsp)
}

func (c *ClientWithResponses) PutTelegrafsIDWithResponse(ctx context.Context, telegrafID string, params *PutTelegrafsIDParams, body PutTelegrafsIDJSONRequestBody) (*putTelegrafsIDResponse, error) {
	rsp, err := c.PutTelegrafsID(ctx, telegrafID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePutTelegrafsIDResponse(rsp)
}

// GetTelegrafsIDLabelsWithResponse request returning *GetTelegrafsIDLabelsResponse
func (c *ClientWithResponses) GetTelegrafsIDLabelsWithResponse(ctx context.Context, telegrafID string, params *GetTelegrafsIDLabelsParams) (*getTelegrafsIDLabelsResponse, error) {
	rsp, err := c.GetTelegrafsIDLabels(ctx, telegrafID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetTelegrafsIDLabelsResponse(rsp)
}

// PostTelegrafsIDLabelsWithBodyWithResponse request with arbitrary body returning *PostTelegrafsIDLabelsResponse
func (c *ClientWithResponses) PostTelegrafsIDLabelsWithBodyWithResponse(ctx context.Context, telegrafID string, params *PostTelegrafsIDLabelsParams, contentType string, body io.Reader) (*postTelegrafsIDLabelsResponse, error) {
	rsp, err := c.PostTelegrafsIDLabelsWithBody(ctx, telegrafID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostTelegrafsIDLabelsResponse(rsp)
}

func (c *ClientWithResponses) PostTelegrafsIDLabelsWithResponse(ctx context.Context, telegrafID string, params *PostTelegrafsIDLabelsParams, body PostTelegrafsIDLabelsJSONRequestBody) (*postTelegrafsIDLabelsResponse, error) {
	rsp, err := c.PostTelegrafsIDLabels(ctx, telegrafID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostTelegrafsIDLabelsResponse(rsp)
}

// DeleteTelegrafsIDLabelsIDWithResponse request returning *DeleteTelegrafsIDLabelsIDResponse
func (c *ClientWithResponses) DeleteTelegrafsIDLabelsIDWithResponse(ctx context.Context, telegrafID string, labelID string, params *DeleteTelegrafsIDLabelsIDParams) (*deleteTelegrafsIDLabelsIDResponse, error) {
	rsp, err := c.DeleteTelegrafsIDLabelsID(ctx, telegrafID, labelID, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteTelegrafsIDLabelsIDResponse(rsp)
}

// GetTelegrafsIDMembersWithResponse request returning *GetTelegrafsIDMembersResponse
func (c *ClientWithResponses) GetTelegrafsIDMembersWithResponse(ctx context.Context, telegrafID string, params *GetTelegrafsIDMembersParams) (*getTelegrafsIDMembersResponse, error) {
	rsp, err := c.GetTelegrafsIDMembers(ctx, telegrafID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetTelegrafsIDMembersResponse(rsp)
}

// PostTelegrafsIDMembersWithBodyWithResponse request with arbitrary body returning *PostTelegrafsIDMembersResponse
func (c *ClientWithResponses) PostTelegrafsIDMembersWithBodyWithResponse(ctx context.Context, telegrafID string, params *PostTelegrafsIDMembersParams, contentType string, body io.Reader) (*postTelegrafsIDMembersResponse, error) {
	rsp, err := c.PostTelegrafsIDMembersWithBody(ctx, telegrafID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostTelegrafsIDMembersResponse(rsp)
}

func (c *ClientWithResponses) PostTelegrafsIDMembersWithResponse(ctx context.Context, telegrafID string, params *PostTelegrafsIDMembersParams, body PostTelegrafsIDMembersJSONRequestBody) (*postTelegrafsIDMembersResponse, error) {
	rsp, err := c.PostTelegrafsIDMembers(ctx, telegrafID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostTelegrafsIDMembersResponse(rsp)
}

// DeleteTelegrafsIDMembersIDWithResponse request returning *DeleteTelegrafsIDMembersIDResponse
func (c *ClientWithResponses) DeleteTelegrafsIDMembersIDWithResponse(ctx context.Context, telegrafID string, userID string, params *DeleteTelegrafsIDMembersIDParams) (*deleteTelegrafsIDMembersIDResponse, error) {
	rsp, err := c.DeleteTelegrafsIDMembersID(ctx, telegrafID, userID, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteTelegrafsIDMembersIDResponse(rsp)
}

// GetTelegrafsIDOwnersWithResponse request returning *GetTelegrafsIDOwnersResponse
func (c *ClientWithResponses) GetTelegrafsIDOwnersWithResponse(ctx context.Context, telegrafID string, params *GetTelegrafsIDOwnersParams) (*getTelegrafsIDOwnersResponse, error) {
	rsp, err := c.GetTelegrafsIDOwners(ctx, telegrafID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetTelegrafsIDOwnersResponse(rsp)
}

// PostTelegrafsIDOwnersWithBodyWithResponse request with arbitrary body returning *PostTelegrafsIDOwnersResponse
func (c *ClientWithResponses) PostTelegrafsIDOwnersWithBodyWithResponse(ctx context.Context, telegrafID string, params *PostTelegrafsIDOwnersParams, contentType string, body io.Reader) (*postTelegrafsIDOwnersResponse, error) {
	rsp, err := c.PostTelegrafsIDOwnersWithBody(ctx, telegrafID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostTelegrafsIDOwnersResponse(rsp)
}

func (c *ClientWithResponses) PostTelegrafsIDOwnersWithResponse(ctx context.Context, telegrafID string, params *PostTelegrafsIDOwnersParams, body PostTelegrafsIDOwnersJSONRequestBody) (*postTelegrafsIDOwnersResponse, error) {
	rsp, err := c.PostTelegrafsIDOwners(ctx, telegrafID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostTelegrafsIDOwnersResponse(rsp)
}

// DeleteTelegrafsIDOwnersIDWithResponse request returning *DeleteTelegrafsIDOwnersIDResponse
func (c *ClientWithResponses) DeleteTelegrafsIDOwnersIDWithResponse(ctx context.Context, telegrafID string, userID string, params *DeleteTelegrafsIDOwnersIDParams) (*deleteTelegrafsIDOwnersIDResponse, error) {
	rsp, err := c.DeleteTelegrafsIDOwnersID(ctx, telegrafID, userID, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteTelegrafsIDOwnersIDResponse(rsp)
}

// ApplyTemplateWithBodyWithResponse request with arbitrary body returning *ApplyTemplateResponse
func (c *ClientWithResponses) ApplyTemplateWithBodyWithResponse(ctx context.Context, contentType string, body io.Reader) (*applyTemplateResponse, error) {
	rsp, err := c.ApplyTemplateWithBody(ctx, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParseApplyTemplateResponse(rsp)
}

func (c *ClientWithResponses) ApplyTemplateWithResponse(ctx context.Context, body ApplyTemplateJSONRequestBody) (*applyTemplateResponse, error) {
	rsp, err := c.ApplyTemplate(ctx, body)
	if err != nil {
		return nil, err
	}
	return ParseApplyTemplateResponse(rsp)
}

// ExportTemplateWithBodyWithResponse request with arbitrary body returning *ExportTemplateResponse
func (c *ClientWithResponses) ExportTemplateWithBodyWithResponse(ctx context.Context, contentType string, body io.Reader) (*exportTemplateResponse, error) {
	rsp, err := c.ExportTemplateWithBody(ctx, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParseExportTemplateResponse(rsp)
}

func (c *ClientWithResponses) ExportTemplateWithResponse(ctx context.Context, body ExportTemplateJSONRequestBody) (*exportTemplateResponse, error) {
	rsp, err := c.ExportTemplate(ctx, body)
	if err != nil {
		return nil, err
	}
	return ParseExportTemplateResponse(rsp)
}

// GetUsersWithResponse request returning *GetUsersResponse
func (c *ClientWithResponses) GetUsersWithResponse(ctx context.Context, params *GetUsersParams) (*getUsersResponse, error) {
	rsp, err := c.GetUsers(ctx, params)
	if err != nil {
		return nil, err
	}
	return ParseGetUsersResponse(rsp)
}

// PostUsersWithBodyWithResponse request with arbitrary body returning *PostUsersResponse
func (c *ClientWithResponses) PostUsersWithBodyWithResponse(ctx context.Context, params *PostUsersParams, contentType string, body io.Reader) (*postUsersResponse, error) {
	rsp, err := c.PostUsersWithBody(ctx, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostUsersResponse(rsp)
}

func (c *ClientWithResponses) PostUsersWithResponse(ctx context.Context, params *PostUsersParams, body PostUsersJSONRequestBody) (*postUsersResponse, error) {
	rsp, err := c.PostUsers(ctx, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostUsersResponse(rsp)
}

// DeleteUsersIDWithResponse request returning *DeleteUsersIDResponse
func (c *ClientWithResponses) DeleteUsersIDWithResponse(ctx context.Context, userID string, params *DeleteUsersIDParams) (*deleteUsersIDResponse, error) {
	rsp, err := c.DeleteUsersID(ctx, userID, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteUsersIDResponse(rsp)
}

// GetUsersIDWithResponse request returning *GetUsersIDResponse
func (c *ClientWithResponses) GetUsersIDWithResponse(ctx context.Context, userID string, params *GetUsersIDParams) (*getUsersIDResponse, error) {
	rsp, err := c.GetUsersID(ctx, userID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetUsersIDResponse(rsp)
}

// PatchUsersIDWithBodyWithResponse request with arbitrary body returning *PatchUsersIDResponse
func (c *ClientWithResponses) PatchUsersIDWithBodyWithResponse(ctx context.Context, userID string, params *PatchUsersIDParams, contentType string, body io.Reader) (*patchUsersIDResponse, error) {
	rsp, err := c.PatchUsersIDWithBody(ctx, userID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePatchUsersIDResponse(rsp)
}

func (c *ClientWithResponses) PatchUsersIDWithResponse(ctx context.Context, userID string, params *PatchUsersIDParams, body PatchUsersIDJSONRequestBody) (*patchUsersIDResponse, error) {
	rsp, err := c.PatchUsersID(ctx, userID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePatchUsersIDResponse(rsp)
}

// PostUsersIDPasswordWithBodyWithResponse request with arbitrary body returning *PostUsersIDPasswordResponse
func (c *ClientWithResponses) PostUsersIDPasswordWithBodyWithResponse(ctx context.Context, userID string, params *PostUsersIDPasswordParams, contentType string, body io.Reader) (*postUsersIDPasswordResponse, error) {
	rsp, err := c.PostUsersIDPasswordWithBody(ctx, userID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostUsersIDPasswordResponse(rsp)
}

func (c *ClientWithResponses) PostUsersIDPasswordWithResponse(ctx context.Context, userID string, params *PostUsersIDPasswordParams, body PostUsersIDPasswordJSONRequestBody) (*postUsersIDPasswordResponse, error) {
	rsp, err := c.PostUsersIDPassword(ctx, userID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostUsersIDPasswordResponse(rsp)
}

// GetVariablesWithResponse request returning *GetVariablesResponse
func (c *ClientWithResponses) GetVariablesWithResponse(ctx context.Context, params *GetVariablesParams) (*getVariablesResponse, error) {
	rsp, err := c.GetVariables(ctx, params)
	if err != nil {
		return nil, err
	}
	return ParseGetVariablesResponse(rsp)
}

// PostVariablesWithBodyWithResponse request with arbitrary body returning *PostVariablesResponse
func (c *ClientWithResponses) PostVariablesWithBodyWithResponse(ctx context.Context, params *PostVariablesParams, contentType string, body io.Reader) (*postVariablesResponse, error) {
	rsp, err := c.PostVariablesWithBody(ctx, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostVariablesResponse(rsp)
}

func (c *ClientWithResponses) PostVariablesWithResponse(ctx context.Context, params *PostVariablesParams, body PostVariablesJSONRequestBody) (*postVariablesResponse, error) {
	rsp, err := c.PostVariables(ctx, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostVariablesResponse(rsp)
}

// DeleteVariablesIDWithResponse request returning *DeleteVariablesIDResponse
func (c *ClientWithResponses) DeleteVariablesIDWithResponse(ctx context.Context, variableID string, params *DeleteVariablesIDParams) (*deleteVariablesIDResponse, error) {
	rsp, err := c.DeleteVariablesID(ctx, variableID, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteVariablesIDResponse(rsp)
}

// GetVariablesIDWithResponse request returning *GetVariablesIDResponse
func (c *ClientWithResponses) GetVariablesIDWithResponse(ctx context.Context, variableID string, params *GetVariablesIDParams) (*getVariablesIDResponse, error) {
	rsp, err := c.GetVariablesID(ctx, variableID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetVariablesIDResponse(rsp)
}

// PatchVariablesIDWithBodyWithResponse request with arbitrary body returning *PatchVariablesIDResponse
func (c *ClientWithResponses) PatchVariablesIDWithBodyWithResponse(ctx context.Context, variableID string, params *PatchVariablesIDParams, contentType string, body io.Reader) (*patchVariablesIDResponse, error) {
	rsp, err := c.PatchVariablesIDWithBody(ctx, variableID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePatchVariablesIDResponse(rsp)
}

func (c *ClientWithResponses) PatchVariablesIDWithResponse(ctx context.Context, variableID string, params *PatchVariablesIDParams, body PatchVariablesIDJSONRequestBody) (*patchVariablesIDResponse, error) {
	rsp, err := c.PatchVariablesID(ctx, variableID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePatchVariablesIDResponse(rsp)
}

// PutVariablesIDWithBodyWithResponse request with arbitrary body returning *PutVariablesIDResponse
func (c *ClientWithResponses) PutVariablesIDWithBodyWithResponse(ctx context.Context, variableID string, params *PutVariablesIDParams, contentType string, body io.Reader) (*putVariablesIDResponse, error) {
	rsp, err := c.PutVariablesIDWithBody(ctx, variableID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePutVariablesIDResponse(rsp)
}

func (c *ClientWithResponses) PutVariablesIDWithResponse(ctx context.Context, variableID string, params *PutVariablesIDParams, body PutVariablesIDJSONRequestBody) (*putVariablesIDResponse, error) {
	rsp, err := c.PutVariablesID(ctx, variableID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePutVariablesIDResponse(rsp)
}

// GetVariablesIDLabelsWithResponse request returning *GetVariablesIDLabelsResponse
func (c *ClientWithResponses) GetVariablesIDLabelsWithResponse(ctx context.Context, variableID string, params *GetVariablesIDLabelsParams) (*getVariablesIDLabelsResponse, error) {
	rsp, err := c.GetVariablesIDLabels(ctx, variableID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetVariablesIDLabelsResponse(rsp)
}

// PostVariablesIDLabelsWithBodyWithResponse request with arbitrary body returning *PostVariablesIDLabelsResponse
func (c *ClientWithResponses) PostVariablesIDLabelsWithBodyWithResponse(ctx context.Context, variableID string, params *PostVariablesIDLabelsParams, contentType string, body io.Reader) (*postVariablesIDLabelsResponse, error) {
	rsp, err := c.PostVariablesIDLabelsWithBody(ctx, variableID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostVariablesIDLabelsResponse(rsp)
}

func (c *ClientWithResponses) PostVariablesIDLabelsWithResponse(ctx context.Context, variableID string, params *PostVariablesIDLabelsParams, body PostVariablesIDLabelsJSONRequestBody) (*postVariablesIDLabelsResponse, error) {
	rsp, err := c.PostVariablesIDLabels(ctx, variableID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostVariablesIDLabelsResponse(rsp)
}

// DeleteVariablesIDLabelsIDWithResponse request returning *DeleteVariablesIDLabelsIDResponse
func (c *ClientWithResponses) DeleteVariablesIDLabelsIDWithResponse(ctx context.Context, variableID string, labelID string, params *DeleteVariablesIDLabelsIDParams) (*deleteVariablesIDLabelsIDResponse, error) {
	rsp, err := c.DeleteVariablesIDLabelsID(ctx, variableID, labelID, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteVariablesIDLabelsIDResponse(rsp)
}

// PostWriteWithBodyWithResponse request with arbitrary body returning *PostWriteResponse
func (c *ClientWithResponses) PostWriteWithBodyWithResponse(ctx context.Context, params *PostWriteParams, contentType string, body io.Reader) (*postWriteResponse, error) {
	rsp, err := c.PostWriteWithBody(ctx, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostWriteResponse(rsp)
}

// ParseGetRoutesResponse parses an HTTP response from a GetRoutesWithResponse call
func ParseGetRoutesResponse(rsp *http.Response) (*getRoutesResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getRoutesResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Routes
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseGetAuthorizationsResponse parses an HTTP response from a GetAuthorizationsWithResponse call
func ParseGetAuthorizationsResponse(rsp *http.Response) (*getAuthorizationsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getAuthorizationsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Authorizations
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParsePostAuthorizationsResponse parses an HTTP response from a PostAuthorizationsWithResponse call
func ParsePostAuthorizationsResponse(rsp *http.Response) (*postAuthorizationsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &postAuthorizationsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest Authorization
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 400:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON400 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseDeleteAuthorizationsIDResponse parses an HTTP response from a DeleteAuthorizationsIDWithResponse call
func ParseDeleteAuthorizationsIDResponse(rsp *http.Response) (*deleteAuthorizationsIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &deleteAuthorizationsIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseGetAuthorizationsIDResponse parses an HTTP response from a GetAuthorizationsIDWithResponse call
func ParseGetAuthorizationsIDResponse(rsp *http.Response) (*getAuthorizationsIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getAuthorizationsIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Authorization
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParsePatchAuthorizationsIDResponse parses an HTTP response from a PatchAuthorizationsIDWithResponse call
func ParsePatchAuthorizationsIDResponse(rsp *http.Response) (*patchAuthorizationsIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &patchAuthorizationsIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Authorization
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseGetBucketsResponse parses an HTTP response from a GetBucketsWithResponse call
func ParseGetBucketsResponse(rsp *http.Response) (*getBucketsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getBucketsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Buckets
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParsePostBucketsResponse parses an HTTP response from a PostBucketsWithResponse call
func ParsePostBucketsResponse(rsp *http.Response) (*postBucketsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &postBucketsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest Bucket
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 422:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON422 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseDeleteBucketsIDResponse parses an HTTP response from a DeleteBucketsIDWithResponse call
func ParseDeleteBucketsIDResponse(rsp *http.Response) (*deleteBucketsIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &deleteBucketsIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseGetBucketsIDResponse parses an HTTP response from a GetBucketsIDWithResponse call
func ParseGetBucketsIDResponse(rsp *http.Response) (*getBucketsIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getBucketsIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Bucket
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParsePatchBucketsIDResponse parses an HTTP response from a PatchBucketsIDWithResponse call
func ParsePatchBucketsIDResponse(rsp *http.Response) (*patchBucketsIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &patchBucketsIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Bucket
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseGetBucketsIDLabelsResponse parses an HTTP response from a GetBucketsIDLabelsWithResponse call
func ParseGetBucketsIDLabelsResponse(rsp *http.Response) (*getBucketsIDLabelsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getBucketsIDLabelsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest LabelsResponse
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParsePostBucketsIDLabelsResponse parses an HTTP response from a PostBucketsIDLabelsWithResponse call
func ParsePostBucketsIDLabelsResponse(rsp *http.Response) (*postBucketsIDLabelsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &postBucketsIDLabelsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest LabelResponse
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseDeleteBucketsIDLabelsIDResponse parses an HTTP response from a DeleteBucketsIDLabelsIDWithResponse call
func ParseDeleteBucketsIDLabelsIDResponse(rsp *http.Response) (*deleteBucketsIDLabelsIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &deleteBucketsIDLabelsIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseGetBucketsIDMembersResponse parses an HTTP response from a GetBucketsIDMembersWithResponse call
func ParseGetBucketsIDMembersResponse(rsp *http.Response) (*getBucketsIDMembersResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getBucketsIDMembersResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest ResourceMembers
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParsePostBucketsIDMembersResponse parses an HTTP response from a PostBucketsIDMembersWithResponse call
func ParsePostBucketsIDMembersResponse(rsp *http.Response) (*postBucketsIDMembersResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &postBucketsIDMembersResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest ResourceMember
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseDeleteBucketsIDMembersIDResponse parses an HTTP response from a DeleteBucketsIDMembersIDWithResponse call
func ParseDeleteBucketsIDMembersIDResponse(rsp *http.Response) (*deleteBucketsIDMembersIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &deleteBucketsIDMembersIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseGetBucketsIDOwnersResponse parses an HTTP response from a GetBucketsIDOwnersWithResponse call
func ParseGetBucketsIDOwnersResponse(rsp *http.Response) (*getBucketsIDOwnersResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getBucketsIDOwnersResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest ResourceOwners
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParsePostBucketsIDOwnersResponse parses an HTTP response from a PostBucketsIDOwnersWithResponse call
func ParsePostBucketsIDOwnersResponse(rsp *http.Response) (*postBucketsIDOwnersResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &postBucketsIDOwnersResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest ResourceOwner
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseDeleteBucketsIDOwnersIDResponse parses an HTTP response from a DeleteBucketsIDOwnersIDWithResponse call
func ParseDeleteBucketsIDOwnersIDResponse(rsp *http.Response) (*deleteBucketsIDOwnersIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &deleteBucketsIDOwnersIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseGetChecksResponse parses an HTTP response from a GetChecksWithResponse call
func ParseGetChecksResponse(rsp *http.Response) (*getChecksResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getChecksResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Checks
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseCreateCheckResponse parses an HTTP response from a CreateCheckWithResponse call
func ParseCreateCheckResponse(rsp *http.Response) (*createCheckResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &createCheckResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest Check
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseDeleteChecksIDResponse parses an HTTP response from a DeleteChecksIDWithResponse call
func ParseDeleteChecksIDResponse(rsp *http.Response) (*deleteChecksIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &deleteChecksIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseGetChecksIDResponse parses an HTTP response from a GetChecksIDWithResponse call
func ParseGetChecksIDResponse(rsp *http.Response) (*getChecksIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getChecksIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Check
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParsePatchChecksIDResponse parses an HTTP response from a PatchChecksIDWithResponse call
func ParsePatchChecksIDResponse(rsp *http.Response) (*patchChecksIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &patchChecksIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Check
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParsePutChecksIDResponse parses an HTTP response from a PutChecksIDWithResponse call
func ParsePutChecksIDResponse(rsp *http.Response) (*putChecksIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &putChecksIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Check
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseGetChecksIDLabelsResponse parses an HTTP response from a GetChecksIDLabelsWithResponse call
func ParseGetChecksIDLabelsResponse(rsp *http.Response) (*getChecksIDLabelsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getChecksIDLabelsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest LabelsResponse
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParsePostChecksIDLabelsResponse parses an HTTP response from a PostChecksIDLabelsWithResponse call
func ParsePostChecksIDLabelsResponse(rsp *http.Response) (*postChecksIDLabelsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &postChecksIDLabelsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest LabelResponse
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseDeleteChecksIDLabelsIDResponse parses an HTTP response from a DeleteChecksIDLabelsIDWithResponse call
func ParseDeleteChecksIDLabelsIDResponse(rsp *http.Response) (*deleteChecksIDLabelsIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &deleteChecksIDLabelsIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseGetChecksIDQueryResponse parses an HTTP response from a GetChecksIDQueryWithResponse call
func ParseGetChecksIDQueryResponse(rsp *http.Response) (*getChecksIDQueryResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getChecksIDQueryResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest FluxResponse
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 400:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON400 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseGetDashboardsResponse parses an HTTP response from a GetDashboardsWithResponse call
func ParseGetDashboardsResponse(rsp *http.Response) (*getDashboardsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getDashboardsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Dashboards
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParsePostDashboardsResponse parses an HTTP response from a PostDashboardsWithResponse call
func ParsePostDashboardsResponse(rsp *http.Response) (*postDashboardsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &postDashboardsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest interface{}
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseDeleteDashboardsIDResponse parses an HTTP response from a DeleteDashboardsIDWithResponse call
func ParseDeleteDashboardsIDResponse(rsp *http.Response) (*deleteDashboardsIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &deleteDashboardsIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseGetDashboardsIDResponse parses an HTTP response from a GetDashboardsIDWithResponse call
func ParseGetDashboardsIDResponse(rsp *http.Response) (*getDashboardsIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getDashboardsIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest interface{}
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParsePatchDashboardsIDResponse parses an HTTP response from a PatchDashboardsIDWithResponse call
func ParsePatchDashboardsIDResponse(rsp *http.Response) (*patchDashboardsIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &patchDashboardsIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Dashboard
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParsePostDashboardsIDCellsResponse parses an HTTP response from a PostDashboardsIDCellsWithResponse call
func ParsePostDashboardsIDCellsResponse(rsp *http.Response) (*postDashboardsIDCellsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &postDashboardsIDCellsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest Cell
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParsePutDashboardsIDCellsResponse parses an HTTP response from a PutDashboardsIDCellsWithResponse call
func ParsePutDashboardsIDCellsResponse(rsp *http.Response) (*putDashboardsIDCellsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &putDashboardsIDCellsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest Dashboard
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseDeleteDashboardsIDCellsIDResponse parses an HTTP response from a DeleteDashboardsIDCellsIDWithResponse call
func ParseDeleteDashboardsIDCellsIDResponse(rsp *http.Response) (*deleteDashboardsIDCellsIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &deleteDashboardsIDCellsIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParsePatchDashboardsIDCellsIDResponse parses an HTTP response from a PatchDashboardsIDCellsIDWithResponse call
func ParsePatchDashboardsIDCellsIDResponse(rsp *http.Response) (*patchDashboardsIDCellsIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &patchDashboardsIDCellsIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Cell
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseGetDashboardsIDCellsIDViewResponse parses an HTTP response from a GetDashboardsIDCellsIDViewWithResponse call
func ParseGetDashboardsIDCellsIDViewResponse(rsp *http.Response) (*getDashboardsIDCellsIDViewResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getDashboardsIDCellsIDViewResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest View
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParsePatchDashboardsIDCellsIDViewResponse parses an HTTP response from a PatchDashboardsIDCellsIDViewWithResponse call
func ParsePatchDashboardsIDCellsIDViewResponse(rsp *http.Response) (*patchDashboardsIDCellsIDViewResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &patchDashboardsIDCellsIDViewResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest View
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseGetDashboardsIDLabelsResponse parses an HTTP response from a GetDashboardsIDLabelsWithResponse call
func ParseGetDashboardsIDLabelsResponse(rsp *http.Response) (*getDashboardsIDLabelsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getDashboardsIDLabelsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest LabelsResponse
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParsePostDashboardsIDLabelsResponse parses an HTTP response from a PostDashboardsIDLabelsWithResponse call
func ParsePostDashboardsIDLabelsResponse(rsp *http.Response) (*postDashboardsIDLabelsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &postDashboardsIDLabelsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest LabelResponse
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseDeleteDashboardsIDLabelsIDResponse parses an HTTP response from a DeleteDashboardsIDLabelsIDWithResponse call
func ParseDeleteDashboardsIDLabelsIDResponse(rsp *http.Response) (*deleteDashboardsIDLabelsIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &deleteDashboardsIDLabelsIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseGetDashboardsIDMembersResponse parses an HTTP response from a GetDashboardsIDMembersWithResponse call
func ParseGetDashboardsIDMembersResponse(rsp *http.Response) (*getDashboardsIDMembersResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getDashboardsIDMembersResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest ResourceMembers
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParsePostDashboardsIDMembersResponse parses an HTTP response from a PostDashboardsIDMembersWithResponse call
func ParsePostDashboardsIDMembersResponse(rsp *http.Response) (*postDashboardsIDMembersResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &postDashboardsIDMembersResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest ResourceMember
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseDeleteDashboardsIDMembersIDResponse parses an HTTP response from a DeleteDashboardsIDMembersIDWithResponse call
func ParseDeleteDashboardsIDMembersIDResponse(rsp *http.Response) (*deleteDashboardsIDMembersIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &deleteDashboardsIDMembersIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseGetDashboardsIDOwnersResponse parses an HTTP response from a GetDashboardsIDOwnersWithResponse call
func ParseGetDashboardsIDOwnersResponse(rsp *http.Response) (*getDashboardsIDOwnersResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getDashboardsIDOwnersResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest ResourceOwners
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParsePostDashboardsIDOwnersResponse parses an HTTP response from a PostDashboardsIDOwnersWithResponse call
func ParsePostDashboardsIDOwnersResponse(rsp *http.Response) (*postDashboardsIDOwnersResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &postDashboardsIDOwnersResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest ResourceOwner
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseDeleteDashboardsIDOwnersIDResponse parses an HTTP response from a DeleteDashboardsIDOwnersIDWithResponse call
func ParseDeleteDashboardsIDOwnersIDResponse(rsp *http.Response) (*deleteDashboardsIDOwnersIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &deleteDashboardsIDOwnersIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseGetDBRPsResponse parses an HTTP response from a GetDBRPsWithResponse call
func ParseGetDBRPsResponse(rsp *http.Response) (*getDBRPsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getDBRPsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest DBRPs
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 400:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON400 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParsePostDBRPResponse parses an HTTP response from a PostDBRPWithResponse call
func ParsePostDBRPResponse(rsp *http.Response) (*postDBRPResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &postDBRPResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest DBRP
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 400:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON400 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseDeleteDBRPIDResponse parses an HTTP response from a DeleteDBRPIDWithResponse call
func ParseDeleteDBRPIDResponse(rsp *http.Response) (*deleteDBRPIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &deleteDBRPIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 400:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON400 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseGetDBRPsIDResponse parses an HTTP response from a GetDBRPsIDWithResponse call
func ParseGetDBRPsIDResponse(rsp *http.Response) (*getDBRPsIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getDBRPsIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest DBRP
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 400:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON400 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParsePatchDBRPIDResponse parses an HTTP response from a PatchDBRPIDWithResponse call
func ParsePatchDBRPIDResponse(rsp *http.Response) (*patchDBRPIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &patchDBRPIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest DBRP
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 400:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON400 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParsePostDeleteResponse parses an HTTP response from a PostDeleteWithResponse call
func ParsePostDeleteResponse(rsp *http.Response) (*postDeleteResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &postDeleteResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 400:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON400 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 403:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON403 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseGetDocumentsTemplatesResponse parses an HTTP response from a GetDocumentsTemplatesWithResponse call
func ParseGetDocumentsTemplatesResponse(rsp *http.Response) (*getDocumentsTemplatesResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getDocumentsTemplatesResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Documents
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParsePostDocumentsTemplatesResponse parses an HTTP response from a PostDocumentsTemplatesWithResponse call
func ParsePostDocumentsTemplatesResponse(rsp *http.Response) (*postDocumentsTemplatesResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &postDocumentsTemplatesResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest Document
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseDeleteDocumentsTemplatesIDResponse parses an HTTP response from a DeleteDocumentsTemplatesIDWithResponse call
func ParseDeleteDocumentsTemplatesIDResponse(rsp *http.Response) (*deleteDocumentsTemplatesIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &deleteDocumentsTemplatesIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseGetDocumentsTemplatesIDResponse parses an HTTP response from a GetDocumentsTemplatesIDWithResponse call
func ParseGetDocumentsTemplatesIDResponse(rsp *http.Response) (*getDocumentsTemplatesIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getDocumentsTemplatesIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Document
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParsePutDocumentsTemplatesIDResponse parses an HTTP response from a PutDocumentsTemplatesIDWithResponse call
func ParsePutDocumentsTemplatesIDResponse(rsp *http.Response) (*putDocumentsTemplatesIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &putDocumentsTemplatesIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Document
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseGetDocumentsTemplatesIDLabelsResponse parses an HTTP response from a GetDocumentsTemplatesIDLabelsWithResponse call
func ParseGetDocumentsTemplatesIDLabelsResponse(rsp *http.Response) (*getDocumentsTemplatesIDLabelsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getDocumentsTemplatesIDLabelsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest LabelsResponse
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParsePostDocumentsTemplatesIDLabelsResponse parses an HTTP response from a PostDocumentsTemplatesIDLabelsWithResponse call
func ParsePostDocumentsTemplatesIDLabelsResponse(rsp *http.Response) (*postDocumentsTemplatesIDLabelsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &postDocumentsTemplatesIDLabelsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest LabelResponse
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseDeleteDocumentsTemplatesIDLabelsIDResponse parses an HTTP response from a DeleteDocumentsTemplatesIDLabelsIDWithResponse call
func ParseDeleteDocumentsTemplatesIDLabelsIDResponse(rsp *http.Response) (*deleteDocumentsTemplatesIDLabelsIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &deleteDocumentsTemplatesIDLabelsIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseGetFlagsResponse parses an HTTP response from a GetFlagsWithResponse call
func ParseGetFlagsResponse(rsp *http.Response) (*getFlagsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getFlagsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Flags
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseGetHealthResponse parses an HTTP response from a GetHealthWithResponse call
func ParseGetHealthResponse(rsp *http.Response) (*getHealthResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getHealthResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest HealthCheck
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 503:
		var dest HealthCheck
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON503 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseGetLabelsResponse parses an HTTP response from a GetLabelsWithResponse call
func ParseGetLabelsResponse(rsp *http.Response) (*getLabelsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getLabelsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest LabelsResponse
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParsePostLabelsResponse parses an HTTP response from a PostLabelsWithResponse call
func ParsePostLabelsResponse(rsp *http.Response) (*postLabelsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &postLabelsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest LabelResponse
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseDeleteLabelsIDResponse parses an HTTP response from a DeleteLabelsIDWithResponse call
func ParseDeleteLabelsIDResponse(rsp *http.Response) (*deleteLabelsIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &deleteLabelsIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseGetLabelsIDResponse parses an HTTP response from a GetLabelsIDWithResponse call
func ParseGetLabelsIDResponse(rsp *http.Response) (*getLabelsIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getLabelsIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest LabelResponse
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParsePatchLabelsIDResponse parses an HTTP response from a PatchLabelsIDWithResponse call
func ParsePatchLabelsIDResponse(rsp *http.Response) (*patchLabelsIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &patchLabelsIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest LabelResponse
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseGetMeResponse parses an HTTP response from a GetMeWithResponse call
func ParseGetMeResponse(rsp *http.Response) (*getMeResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getMeResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest User
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParsePutMePasswordResponse parses an HTTP response from a PutMePasswordWithResponse call
func ParsePutMePasswordResponse(rsp *http.Response) (*putMePasswordResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &putMePasswordResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseGetNotificationEndpointsResponse parses an HTTP response from a GetNotificationEndpointsWithResponse call
func ParseGetNotificationEndpointsResponse(rsp *http.Response) (*getNotificationEndpointsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getNotificationEndpointsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest NotificationEndpoints
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseCreateNotificationEndpointResponse parses an HTTP response from a CreateNotificationEndpointWithResponse call
func ParseCreateNotificationEndpointResponse(rsp *http.Response) (*createNotificationEndpointResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &createNotificationEndpointResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest NotificationEndpoint
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseDeleteNotificationEndpointsIDResponse parses an HTTP response from a DeleteNotificationEndpointsIDWithResponse call
func ParseDeleteNotificationEndpointsIDResponse(rsp *http.Response) (*deleteNotificationEndpointsIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &deleteNotificationEndpointsIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseGetNotificationEndpointsIDResponse parses an HTTP response from a GetNotificationEndpointsIDWithResponse call
func ParseGetNotificationEndpointsIDResponse(rsp *http.Response) (*getNotificationEndpointsIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getNotificationEndpointsIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest NotificationEndpoint
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParsePatchNotificationEndpointsIDResponse parses an HTTP response from a PatchNotificationEndpointsIDWithResponse call
func ParsePatchNotificationEndpointsIDResponse(rsp *http.Response) (*patchNotificationEndpointsIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &patchNotificationEndpointsIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest NotificationEndpoint
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParsePutNotificationEndpointsIDResponse parses an HTTP response from a PutNotificationEndpointsIDWithResponse call
func ParsePutNotificationEndpointsIDResponse(rsp *http.Response) (*putNotificationEndpointsIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &putNotificationEndpointsIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest NotificationEndpoint
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseGetNotificationEndpointsIDLabelsResponse parses an HTTP response from a GetNotificationEndpointsIDLabelsWithResponse call
func ParseGetNotificationEndpointsIDLabelsResponse(rsp *http.Response) (*getNotificationEndpointsIDLabelsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getNotificationEndpointsIDLabelsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest LabelsResponse
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParsePostNotificationEndpointIDLabelsResponse parses an HTTP response from a PostNotificationEndpointIDLabelsWithResponse call
func ParsePostNotificationEndpointIDLabelsResponse(rsp *http.Response) (*postNotificationEndpointIDLabelsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &postNotificationEndpointIDLabelsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest LabelResponse
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseDeleteNotificationEndpointsIDLabelsIDResponse parses an HTTP response from a DeleteNotificationEndpointsIDLabelsIDWithResponse call
func ParseDeleteNotificationEndpointsIDLabelsIDResponse(rsp *http.Response) (*deleteNotificationEndpointsIDLabelsIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &deleteNotificationEndpointsIDLabelsIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseGetNotificationRulesResponse parses an HTTP response from a GetNotificationRulesWithResponse call
func ParseGetNotificationRulesResponse(rsp *http.Response) (*getNotificationRulesResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getNotificationRulesResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest NotificationRules
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseCreateNotificationRuleResponse parses an HTTP response from a CreateNotificationRuleWithResponse call
func ParseCreateNotificationRuleResponse(rsp *http.Response) (*createNotificationRuleResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &createNotificationRuleResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest NotificationRule
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseDeleteNotificationRulesIDResponse parses an HTTP response from a DeleteNotificationRulesIDWithResponse call
func ParseDeleteNotificationRulesIDResponse(rsp *http.Response) (*deleteNotificationRulesIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &deleteNotificationRulesIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseGetNotificationRulesIDResponse parses an HTTP response from a GetNotificationRulesIDWithResponse call
func ParseGetNotificationRulesIDResponse(rsp *http.Response) (*getNotificationRulesIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getNotificationRulesIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest NotificationRule
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParsePatchNotificationRulesIDResponse parses an HTTP response from a PatchNotificationRulesIDWithResponse call
func ParsePatchNotificationRulesIDResponse(rsp *http.Response) (*patchNotificationRulesIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &patchNotificationRulesIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest NotificationRule
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParsePutNotificationRulesIDResponse parses an HTTP response from a PutNotificationRulesIDWithResponse call
func ParsePutNotificationRulesIDResponse(rsp *http.Response) (*putNotificationRulesIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &putNotificationRulesIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest NotificationRule
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseGetNotificationRulesIDLabelsResponse parses an HTTP response from a GetNotificationRulesIDLabelsWithResponse call
func ParseGetNotificationRulesIDLabelsResponse(rsp *http.Response) (*getNotificationRulesIDLabelsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getNotificationRulesIDLabelsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest LabelsResponse
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParsePostNotificationRuleIDLabelsResponse parses an HTTP response from a PostNotificationRuleIDLabelsWithResponse call
func ParsePostNotificationRuleIDLabelsResponse(rsp *http.Response) (*postNotificationRuleIDLabelsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &postNotificationRuleIDLabelsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest LabelResponse
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseDeleteNotificationRulesIDLabelsIDResponse parses an HTTP response from a DeleteNotificationRulesIDLabelsIDWithResponse call
func ParseDeleteNotificationRulesIDLabelsIDResponse(rsp *http.Response) (*deleteNotificationRulesIDLabelsIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &deleteNotificationRulesIDLabelsIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseGetNotificationRulesIDQueryResponse parses an HTTP response from a GetNotificationRulesIDQueryWithResponse call
func ParseGetNotificationRulesIDQueryResponse(rsp *http.Response) (*getNotificationRulesIDQueryResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getNotificationRulesIDQueryResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest FluxResponse
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 400:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON400 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseGetOrgsResponse parses an HTTP response from a GetOrgsWithResponse call
func ParseGetOrgsResponse(rsp *http.Response) (*getOrgsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getOrgsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Organizations
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParsePostOrgsResponse parses an HTTP response from a PostOrgsWithResponse call
func ParsePostOrgsResponse(rsp *http.Response) (*postOrgsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &postOrgsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest Organization
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseDeleteOrgsIDResponse parses an HTTP response from a DeleteOrgsIDWithResponse call
func ParseDeleteOrgsIDResponse(rsp *http.Response) (*deleteOrgsIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &deleteOrgsIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseGetOrgsIDResponse parses an HTTP response from a GetOrgsIDWithResponse call
func ParseGetOrgsIDResponse(rsp *http.Response) (*getOrgsIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getOrgsIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Organization
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParsePatchOrgsIDResponse parses an HTTP response from a PatchOrgsIDWithResponse call
func ParsePatchOrgsIDResponse(rsp *http.Response) (*patchOrgsIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &patchOrgsIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Organization
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseGetOrgsIDMembersResponse parses an HTTP response from a GetOrgsIDMembersWithResponse call
func ParseGetOrgsIDMembersResponse(rsp *http.Response) (*getOrgsIDMembersResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getOrgsIDMembersResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest ResourceMembers
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParsePostOrgsIDMembersResponse parses an HTTP response from a PostOrgsIDMembersWithResponse call
func ParsePostOrgsIDMembersResponse(rsp *http.Response) (*postOrgsIDMembersResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &postOrgsIDMembersResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest ResourceMember
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseDeleteOrgsIDMembersIDResponse parses an HTTP response from a DeleteOrgsIDMembersIDWithResponse call
func ParseDeleteOrgsIDMembersIDResponse(rsp *http.Response) (*deleteOrgsIDMembersIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &deleteOrgsIDMembersIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseGetOrgsIDOwnersResponse parses an HTTP response from a GetOrgsIDOwnersWithResponse call
func ParseGetOrgsIDOwnersResponse(rsp *http.Response) (*getOrgsIDOwnersResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getOrgsIDOwnersResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest ResourceOwners
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParsePostOrgsIDOwnersResponse parses an HTTP response from a PostOrgsIDOwnersWithResponse call
func ParsePostOrgsIDOwnersResponse(rsp *http.Response) (*postOrgsIDOwnersResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &postOrgsIDOwnersResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest ResourceOwner
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseDeleteOrgsIDOwnersIDResponse parses an HTTP response from a DeleteOrgsIDOwnersIDWithResponse call
func ParseDeleteOrgsIDOwnersIDResponse(rsp *http.Response) (*deleteOrgsIDOwnersIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &deleteOrgsIDOwnersIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseGetOrgsIDSecretsResponse parses an HTTP response from a GetOrgsIDSecretsWithResponse call
func ParseGetOrgsIDSecretsResponse(rsp *http.Response) (*getOrgsIDSecretsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getOrgsIDSecretsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest SecretKeysResponse
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParsePatchOrgsIDSecretsResponse parses an HTTP response from a PatchOrgsIDSecretsWithResponse call
func ParsePatchOrgsIDSecretsResponse(rsp *http.Response) (*patchOrgsIDSecretsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &patchOrgsIDSecretsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParsePostOrgsIDSecretsResponse parses an HTTP response from a PostOrgsIDSecretsWithResponse call
func ParsePostOrgsIDSecretsResponse(rsp *http.Response) (*postOrgsIDSecretsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &postOrgsIDSecretsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParsePostQueryResponse parses an HTTP response from a PostQueryWithResponse call
func ParsePostQueryResponse(rsp *http.Response) (*postQueryResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &postQueryResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParsePostQueryAnalyzeResponse parses an HTTP response from a PostQueryAnalyzeWithResponse call
func ParsePostQueryAnalyzeResponse(rsp *http.Response) (*postQueryAnalyzeResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &postQueryAnalyzeResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest AnalyzeQueryResponse
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParsePostQueryAstResponse parses an HTTP response from a PostQueryAstWithResponse call
func ParsePostQueryAstResponse(rsp *http.Response) (*postQueryAstResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &postQueryAstResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest ASTResponse
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseGetQuerySuggestionsResponse parses an HTTP response from a GetQuerySuggestionsWithResponse call
func ParseGetQuerySuggestionsResponse(rsp *http.Response) (*getQuerySuggestionsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getQuerySuggestionsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest FluxSuggestions
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseGetQuerySuggestionsNameResponse parses an HTTP response from a GetQuerySuggestionsNameWithResponse call
func ParseGetQuerySuggestionsNameResponse(rsp *http.Response) (*getQuerySuggestionsNameResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getQuerySuggestionsNameResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest FluxSuggestion
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseGetReadyResponse parses an HTTP response from a GetReadyWithResponse call
func ParseGetReadyResponse(rsp *http.Response) (*getReadyResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getReadyResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Ready
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseGetScrapersResponse parses an HTTP response from a GetScrapersWithResponse call
func ParseGetScrapersResponse(rsp *http.Response) (*getScrapersResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getScrapersResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest ScraperTargetResponses
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParsePostScrapersResponse parses an HTTP response from a PostScrapersWithResponse call
func ParsePostScrapersResponse(rsp *http.Response) (*postScrapersResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &postScrapersResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest ScraperTargetResponse
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseDeleteScrapersIDResponse parses an HTTP response from a DeleteScrapersIDWithResponse call
func ParseDeleteScrapersIDResponse(rsp *http.Response) (*deleteScrapersIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &deleteScrapersIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseGetScrapersIDResponse parses an HTTP response from a GetScrapersIDWithResponse call
func ParseGetScrapersIDResponse(rsp *http.Response) (*getScrapersIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getScrapersIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest ScraperTargetResponse
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParsePatchScrapersIDResponse parses an HTTP response from a PatchScrapersIDWithResponse call
func ParsePatchScrapersIDResponse(rsp *http.Response) (*patchScrapersIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &patchScrapersIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest ScraperTargetResponse
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseGetScrapersIDLabelsResponse parses an HTTP response from a GetScrapersIDLabelsWithResponse call
func ParseGetScrapersIDLabelsResponse(rsp *http.Response) (*getScrapersIDLabelsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getScrapersIDLabelsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest LabelsResponse
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParsePostScrapersIDLabelsResponse parses an HTTP response from a PostScrapersIDLabelsWithResponse call
func ParsePostScrapersIDLabelsResponse(rsp *http.Response) (*postScrapersIDLabelsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &postScrapersIDLabelsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest LabelResponse
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseDeleteScrapersIDLabelsIDResponse parses an HTTP response from a DeleteScrapersIDLabelsIDWithResponse call
func ParseDeleteScrapersIDLabelsIDResponse(rsp *http.Response) (*deleteScrapersIDLabelsIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &deleteScrapersIDLabelsIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParsePatchScrapersIDLabelsIDResponse parses an HTTP response from a PatchScrapersIDLabelsIDWithResponse call
func ParsePatchScrapersIDLabelsIDResponse(rsp *http.Response) (*patchScrapersIDLabelsIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &patchScrapersIDLabelsIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseGetScrapersIDMembersResponse parses an HTTP response from a GetScrapersIDMembersWithResponse call
func ParseGetScrapersIDMembersResponse(rsp *http.Response) (*getScrapersIDMembersResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getScrapersIDMembersResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest ResourceMembers
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParsePostScrapersIDMembersResponse parses an HTTP response from a PostScrapersIDMembersWithResponse call
func ParsePostScrapersIDMembersResponse(rsp *http.Response) (*postScrapersIDMembersResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &postScrapersIDMembersResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest ResourceMember
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseDeleteScrapersIDMembersIDResponse parses an HTTP response from a DeleteScrapersIDMembersIDWithResponse call
func ParseDeleteScrapersIDMembersIDResponse(rsp *http.Response) (*deleteScrapersIDMembersIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &deleteScrapersIDMembersIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseGetScrapersIDOwnersResponse parses an HTTP response from a GetScrapersIDOwnersWithResponse call
func ParseGetScrapersIDOwnersResponse(rsp *http.Response) (*getScrapersIDOwnersResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getScrapersIDOwnersResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest ResourceOwners
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParsePostScrapersIDOwnersResponse parses an HTTP response from a PostScrapersIDOwnersWithResponse call
func ParsePostScrapersIDOwnersResponse(rsp *http.Response) (*postScrapersIDOwnersResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &postScrapersIDOwnersResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest ResourceOwner
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseDeleteScrapersIDOwnersIDResponse parses an HTTP response from a DeleteScrapersIDOwnersIDWithResponse call
func ParseDeleteScrapersIDOwnersIDResponse(rsp *http.Response) (*deleteScrapersIDOwnersIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &deleteScrapersIDOwnersIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseGetSetupResponse parses an HTTP response from a GetSetupWithResponse call
func ParseGetSetupResponse(rsp *http.Response) (*getSetupResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getSetupResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest IsOnboarding
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	}

	return response, nil
}

// ParsePostSetupResponse parses an HTTP response from a PostSetupWithResponse call
func ParsePostSetupResponse(rsp *http.Response) (*postSetupResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &postSetupResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest OnboardingResponse
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParsePostSetupUserResponse parses an HTTP response from a PostSetupUserWithResponse call
func ParsePostSetupUserResponse(rsp *http.Response) (*postSetupUserResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &postSetupUserResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest OnboardingResponse
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParsePostSigninResponse parses an HTTP response from a PostSigninWithResponse call
func ParsePostSigninResponse(rsp *http.Response) (*postSigninResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &postSigninResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 401:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON401 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 403:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON403 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParsePostSignoutResponse parses an HTTP response from a PostSignoutWithResponse call
func ParsePostSignoutResponse(rsp *http.Response) (*postSignoutResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &postSignoutResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 401:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON401 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseGetSourcesResponse parses an HTTP response from a GetSourcesWithResponse call
func ParseGetSourcesResponse(rsp *http.Response) (*getSourcesResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getSourcesResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Sources
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParsePostSourcesResponse parses an HTTP response from a PostSourcesWithResponse call
func ParsePostSourcesResponse(rsp *http.Response) (*postSourcesResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &postSourcesResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest Source
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseDeleteSourcesIDResponse parses an HTTP response from a DeleteSourcesIDWithResponse call
func ParseDeleteSourcesIDResponse(rsp *http.Response) (*deleteSourcesIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &deleteSourcesIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseGetSourcesIDResponse parses an HTTP response from a GetSourcesIDWithResponse call
func ParseGetSourcesIDResponse(rsp *http.Response) (*getSourcesIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getSourcesIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Source
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParsePatchSourcesIDResponse parses an HTTP response from a PatchSourcesIDWithResponse call
func ParsePatchSourcesIDResponse(rsp *http.Response) (*patchSourcesIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &patchSourcesIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Source
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseGetSourcesIDBucketsResponse parses an HTTP response from a GetSourcesIDBucketsWithResponse call
func ParseGetSourcesIDBucketsResponse(rsp *http.Response) (*getSourcesIDBucketsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getSourcesIDBucketsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Buckets
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseGetSourcesIDHealthResponse parses an HTTP response from a GetSourcesIDHealthWithResponse call
func ParseGetSourcesIDHealthResponse(rsp *http.Response) (*getSourcesIDHealthResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getSourcesIDHealthResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest HealthCheck
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 503:
		var dest HealthCheck
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON503 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseListStacksResponse parses an HTTP response from a ListStacksWithResponse call
func ParseListStacksResponse(rsp *http.Response) (*listStacksResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &listStacksResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest struct {
			Stacks *[]Stack `json:"stacks,omitempty"`
		}
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseCreateStackResponse parses an HTTP response from a CreateStackWithResponse call
func ParseCreateStackResponse(rsp *http.Response) (*createStackResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &createStackResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest Stack
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseDeleteStackResponse parses an HTTP response from a DeleteStackWithResponse call
func ParseDeleteStackResponse(rsp *http.Response) (*deleteStackResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &deleteStackResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseReadStackResponse parses an HTTP response from a ReadStackWithResponse call
func ParseReadStackResponse(rsp *http.Response) (*readStackResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &readStackResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Stack
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseUpdateStackResponse parses an HTTP response from a UpdateStackWithResponse call
func ParseUpdateStackResponse(rsp *http.Response) (*updateStackResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &updateStackResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Stack
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseUninstallStackResponse parses an HTTP response from a UninstallStackWithResponse call
func ParseUninstallStackResponse(rsp *http.Response) (*uninstallStackResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &uninstallStackResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Stack
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseGetTasksResponse parses an HTTP response from a GetTasksWithResponse call
func ParseGetTasksResponse(rsp *http.Response) (*getTasksResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getTasksResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Tasks
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParsePostTasksResponse parses an HTTP response from a PostTasksWithResponse call
func ParsePostTasksResponse(rsp *http.Response) (*postTasksResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &postTasksResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest Task
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseDeleteTasksIDResponse parses an HTTP response from a DeleteTasksIDWithResponse call
func ParseDeleteTasksIDResponse(rsp *http.Response) (*deleteTasksIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &deleteTasksIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseGetTasksIDResponse parses an HTTP response from a GetTasksIDWithResponse call
func ParseGetTasksIDResponse(rsp *http.Response) (*getTasksIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getTasksIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Task
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParsePatchTasksIDResponse parses an HTTP response from a PatchTasksIDWithResponse call
func ParsePatchTasksIDResponse(rsp *http.Response) (*patchTasksIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &patchTasksIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Task
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseGetTasksIDLabelsResponse parses an HTTP response from a GetTasksIDLabelsWithResponse call
func ParseGetTasksIDLabelsResponse(rsp *http.Response) (*getTasksIDLabelsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getTasksIDLabelsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest LabelsResponse
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParsePostTasksIDLabelsResponse parses an HTTP response from a PostTasksIDLabelsWithResponse call
func ParsePostTasksIDLabelsResponse(rsp *http.Response) (*postTasksIDLabelsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &postTasksIDLabelsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest LabelResponse
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseDeleteTasksIDLabelsIDResponse parses an HTTP response from a DeleteTasksIDLabelsIDWithResponse call
func ParseDeleteTasksIDLabelsIDResponse(rsp *http.Response) (*deleteTasksIDLabelsIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &deleteTasksIDLabelsIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseGetTasksIDLogsResponse parses an HTTP response from a GetTasksIDLogsWithResponse call
func ParseGetTasksIDLogsResponse(rsp *http.Response) (*getTasksIDLogsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getTasksIDLogsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Logs
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseGetTasksIDMembersResponse parses an HTTP response from a GetTasksIDMembersWithResponse call
func ParseGetTasksIDMembersResponse(rsp *http.Response) (*getTasksIDMembersResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getTasksIDMembersResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest ResourceMembers
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParsePostTasksIDMembersResponse parses an HTTP response from a PostTasksIDMembersWithResponse call
func ParsePostTasksIDMembersResponse(rsp *http.Response) (*postTasksIDMembersResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &postTasksIDMembersResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest ResourceMember
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseDeleteTasksIDMembersIDResponse parses an HTTP response from a DeleteTasksIDMembersIDWithResponse call
func ParseDeleteTasksIDMembersIDResponse(rsp *http.Response) (*deleteTasksIDMembersIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &deleteTasksIDMembersIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseGetTasksIDOwnersResponse parses an HTTP response from a GetTasksIDOwnersWithResponse call
func ParseGetTasksIDOwnersResponse(rsp *http.Response) (*getTasksIDOwnersResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getTasksIDOwnersResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest ResourceOwners
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParsePostTasksIDOwnersResponse parses an HTTP response from a PostTasksIDOwnersWithResponse call
func ParsePostTasksIDOwnersResponse(rsp *http.Response) (*postTasksIDOwnersResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &postTasksIDOwnersResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest ResourceOwner
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseDeleteTasksIDOwnersIDResponse parses an HTTP response from a DeleteTasksIDOwnersIDWithResponse call
func ParseDeleteTasksIDOwnersIDResponse(rsp *http.Response) (*deleteTasksIDOwnersIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &deleteTasksIDOwnersIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseGetTasksIDRunsResponse parses an HTTP response from a GetTasksIDRunsWithResponse call
func ParseGetTasksIDRunsResponse(rsp *http.Response) (*getTasksIDRunsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getTasksIDRunsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Runs
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParsePostTasksIDRunsResponse parses an HTTP response from a PostTasksIDRunsWithResponse call
func ParsePostTasksIDRunsResponse(rsp *http.Response) (*postTasksIDRunsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &postTasksIDRunsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest Run
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseDeleteTasksIDRunsIDResponse parses an HTTP response from a DeleteTasksIDRunsIDWithResponse call
func ParseDeleteTasksIDRunsIDResponse(rsp *http.Response) (*deleteTasksIDRunsIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &deleteTasksIDRunsIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseGetTasksIDRunsIDResponse parses an HTTP response from a GetTasksIDRunsIDWithResponse call
func ParseGetTasksIDRunsIDResponse(rsp *http.Response) (*getTasksIDRunsIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getTasksIDRunsIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Run
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseGetTasksIDRunsIDLogsResponse parses an HTTP response from a GetTasksIDRunsIDLogsWithResponse call
func ParseGetTasksIDRunsIDLogsResponse(rsp *http.Response) (*getTasksIDRunsIDLogsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getTasksIDRunsIDLogsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Logs
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParsePostTasksIDRunsIDRetryResponse parses an HTTP response from a PostTasksIDRunsIDRetryWithResponse call
func ParsePostTasksIDRunsIDRetryResponse(rsp *http.Response) (*postTasksIDRunsIDRetryResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &postTasksIDRunsIDRetryResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Run
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseGetTelegrafPluginsResponse parses an HTTP response from a GetTelegrafPluginsWithResponse call
func ParseGetTelegrafPluginsResponse(rsp *http.Response) (*getTelegrafPluginsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getTelegrafPluginsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest TelegrafPlugins
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseGetTelegrafsResponse parses an HTTP response from a GetTelegrafsWithResponse call
func ParseGetTelegrafsResponse(rsp *http.Response) (*getTelegrafsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getTelegrafsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Telegrafs
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParsePostTelegrafsResponse parses an HTTP response from a PostTelegrafsWithResponse call
func ParsePostTelegrafsResponse(rsp *http.Response) (*postTelegrafsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &postTelegrafsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest Telegraf
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseDeleteTelegrafsIDResponse parses an HTTP response from a DeleteTelegrafsIDWithResponse call
func ParseDeleteTelegrafsIDResponse(rsp *http.Response) (*deleteTelegrafsIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &deleteTelegrafsIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseGetTelegrafsIDResponse parses an HTTP response from a GetTelegrafsIDWithResponse call
func ParseGetTelegrafsIDResponse(rsp *http.Response) (*getTelegrafsIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getTelegrafsIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Telegraf
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	case rsp.StatusCode == 200:
		// Content-type (application/toml) unsupported

	}

	return response, nil
}

// ParsePutTelegrafsIDResponse parses an HTTP response from a PutTelegrafsIDWithResponse call
func ParsePutTelegrafsIDResponse(rsp *http.Response) (*putTelegrafsIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &putTelegrafsIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Telegraf
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseGetTelegrafsIDLabelsResponse parses an HTTP response from a GetTelegrafsIDLabelsWithResponse call
func ParseGetTelegrafsIDLabelsResponse(rsp *http.Response) (*getTelegrafsIDLabelsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getTelegrafsIDLabelsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest LabelsResponse
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParsePostTelegrafsIDLabelsResponse parses an HTTP response from a PostTelegrafsIDLabelsWithResponse call
func ParsePostTelegrafsIDLabelsResponse(rsp *http.Response) (*postTelegrafsIDLabelsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &postTelegrafsIDLabelsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest LabelResponse
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseDeleteTelegrafsIDLabelsIDResponse parses an HTTP response from a DeleteTelegrafsIDLabelsIDWithResponse call
func ParseDeleteTelegrafsIDLabelsIDResponse(rsp *http.Response) (*deleteTelegrafsIDLabelsIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &deleteTelegrafsIDLabelsIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseGetTelegrafsIDMembersResponse parses an HTTP response from a GetTelegrafsIDMembersWithResponse call
func ParseGetTelegrafsIDMembersResponse(rsp *http.Response) (*getTelegrafsIDMembersResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getTelegrafsIDMembersResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest ResourceMembers
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParsePostTelegrafsIDMembersResponse parses an HTTP response from a PostTelegrafsIDMembersWithResponse call
func ParsePostTelegrafsIDMembersResponse(rsp *http.Response) (*postTelegrafsIDMembersResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &postTelegrafsIDMembersResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest ResourceMember
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseDeleteTelegrafsIDMembersIDResponse parses an HTTP response from a DeleteTelegrafsIDMembersIDWithResponse call
func ParseDeleteTelegrafsIDMembersIDResponse(rsp *http.Response) (*deleteTelegrafsIDMembersIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &deleteTelegrafsIDMembersIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseGetTelegrafsIDOwnersResponse parses an HTTP response from a GetTelegrafsIDOwnersWithResponse call
func ParseGetTelegrafsIDOwnersResponse(rsp *http.Response) (*getTelegrafsIDOwnersResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getTelegrafsIDOwnersResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest ResourceOwners
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParsePostTelegrafsIDOwnersResponse parses an HTTP response from a PostTelegrafsIDOwnersWithResponse call
func ParsePostTelegrafsIDOwnersResponse(rsp *http.Response) (*postTelegrafsIDOwnersResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &postTelegrafsIDOwnersResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest ResourceOwner
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseDeleteTelegrafsIDOwnersIDResponse parses an HTTP response from a DeleteTelegrafsIDOwnersIDWithResponse call
func ParseDeleteTelegrafsIDOwnersIDResponse(rsp *http.Response) (*deleteTelegrafsIDOwnersIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &deleteTelegrafsIDOwnersIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseApplyTemplateResponse parses an HTTP response from a ApplyTemplateWithResponse call
func ParseApplyTemplateResponse(rsp *http.Response) (*applyTemplateResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &applyTemplateResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest TemplateSummary
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest TemplateSummary
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseExportTemplateResponse parses an HTTP response from a ExportTemplateWithResponse call
func ParseExportTemplateResponse(rsp *http.Response) (*exportTemplateResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &exportTemplateResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Template
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.YAML200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "yaml") && rsp.StatusCode == 200:
		var dest Template
		if err := yaml.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.YAML200 = &dest

	}

	return response, nil
}

// ParseGetUsersResponse parses an HTTP response from a GetUsersWithResponse call
func ParseGetUsersResponse(rsp *http.Response) (*getUsersResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getUsersResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Users
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParsePostUsersResponse parses an HTTP response from a PostUsersWithResponse call
func ParsePostUsersResponse(rsp *http.Response) (*postUsersResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &postUsersResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest User
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseDeleteUsersIDResponse parses an HTTP response from a DeleteUsersIDWithResponse call
func ParseDeleteUsersIDResponse(rsp *http.Response) (*deleteUsersIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &deleteUsersIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseGetUsersIDResponse parses an HTTP response from a GetUsersIDWithResponse call
func ParseGetUsersIDResponse(rsp *http.Response) (*getUsersIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getUsersIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest User
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParsePatchUsersIDResponse parses an HTTP response from a PatchUsersIDWithResponse call
func ParsePatchUsersIDResponse(rsp *http.Response) (*patchUsersIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &patchUsersIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest User
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParsePostUsersIDPasswordResponse parses an HTTP response from a PostUsersIDPasswordWithResponse call
func ParsePostUsersIDPasswordResponse(rsp *http.Response) (*postUsersIDPasswordResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &postUsersIDPasswordResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseGetVariablesResponse parses an HTTP response from a GetVariablesWithResponse call
func ParseGetVariablesResponse(rsp *http.Response) (*getVariablesResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getVariablesResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Variables
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 400:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON400 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParsePostVariablesResponse parses an HTTP response from a PostVariablesWithResponse call
func ParsePostVariablesResponse(rsp *http.Response) (*postVariablesResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &postVariablesResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest Variable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseDeleteVariablesIDResponse parses an HTTP response from a DeleteVariablesIDWithResponse call
func ParseDeleteVariablesIDResponse(rsp *http.Response) (*deleteVariablesIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &deleteVariablesIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseGetVariablesIDResponse parses an HTTP response from a GetVariablesIDWithResponse call
func ParseGetVariablesIDResponse(rsp *http.Response) (*getVariablesIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getVariablesIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Variable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParsePatchVariablesIDResponse parses an HTTP response from a PatchVariablesIDWithResponse call
func ParsePatchVariablesIDResponse(rsp *http.Response) (*patchVariablesIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &patchVariablesIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Variable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParsePutVariablesIDResponse parses an HTTP response from a PutVariablesIDWithResponse call
func ParsePutVariablesIDResponse(rsp *http.Response) (*putVariablesIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &putVariablesIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Variable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseGetVariablesIDLabelsResponse parses an HTTP response from a GetVariablesIDLabelsWithResponse call
func ParseGetVariablesIDLabelsResponse(rsp *http.Response) (*getVariablesIDLabelsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &getVariablesIDLabelsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest LabelsResponse
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParsePostVariablesIDLabelsResponse parses an HTTP response from a PostVariablesIDLabelsWithResponse call
func ParsePostVariablesIDLabelsResponse(rsp *http.Response) (*postVariablesIDLabelsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &postVariablesIDLabelsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest LabelResponse
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParseDeleteVariablesIDLabelsIDResponse parses an HTTP response from a DeleteVariablesIDLabelsIDWithResponse call
func ParseDeleteVariablesIDLabelsIDResponse(rsp *http.Response) (*deleteVariablesIDLabelsIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &deleteVariablesIDLabelsIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}

// ParsePostWriteResponse parses an HTTP response from a PostWriteWithResponse call
func ParsePostWriteResponse(rsp *http.Response) (*postWriteResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &postWriteResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 400:
		var dest LineProtocolError
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON400 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 401:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON401 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 403:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON403 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 413:
		var dest LineProtocolLengthError
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON413 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json"):
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	}

	return response, nil
}
