+++
# -----------------------------------------------------------------------
# Do not edit this file. It is automatically generated by API Documenter.
# -----------------------------------------------------------------------
title = "ansicolor"
keywords = ["grafana","documentation","sdk","@grafana/ui"]
type = "docs"
+++

## ansicolor class

Represents an ANSI-escaped string.

<b>Signature</b>

```typescript
export default class Colors 
```
<b>Import</b>

```typescript
import { ansicolor } from '@grafana/ui';
```
<b>Constructors</b>

|  Constructor | Modifiers | Description |
|  --- | --- | --- |
|  [constructor(s)](#constructor-s) |  | Constructs a new instance of the <code>Colors</code> class |

<b>Properties</b>

|  Property | Modifiers | Type | Description |
|  --- | --- | --- | --- |
|  [asChromeConsoleLogArguments](#aschromeconsolelogarguments-property) |  | <code>any[]</code> |  |
|  [browserConsoleArguments](#browserconsolearguments-property) |  | <code>any[]</code> |  |
|  [names](#names-property) | <code>static</code> | <code>(string &#124; number)[]</code> |  |
|  [nice](#nice-property) | <code>static</code> | <code>typeof Colors</code> |  installs String prototype extensions |
|  [parsed](#parsed-property) |  | <code>Colors &amp; {</code><br/><code>        spans: any[];</code><br/><code>    }</code> |  |
|  [rgb](#rgb-property) | <code>static</code> | <code>{</code><br/><code>        black: number[];</code><br/><code>        darkGray: number[];</code><br/><code>        lightGray: number[];</code><br/><code>        white: number[];</code><br/><code>        red: number[];</code><br/><code>        lightRed: number[];</code><br/><code>        green: number[];</code><br/><code>        lightGreen: number[];</code><br/><code>        yellow: number[];</code><br/><code>        lightYellow: number[];</code><br/><code>        blue: number[];</code><br/><code>        lightBlue: number[];</code><br/><code>        magenta: number[];</code><br/><code>        lightMagenta: number[];</code><br/><code>        cyan: number[];</code><br/><code>        lightCyan: number[];</code><br/><code>    }</code> |  |
|  [spans](#spans-property) |  | <code>any[]</code> |  |
|  [str](#str-property) |  | <code>any</code> |  |

<b>Methods</b>

|  Method | Modifiers | Description |
|  --- | --- | --- |
|  [\[Symbol.iterator\]()](#_symbol.iterator_-method) |  |  |
|  [parse(s)](#parse-method) | <code>static</code> |  parses a string containing ANSI escape codes  {<!-- -->Colors<!-- -->} parsed representation. |
|  [strip(s)](#strip-method) | <code>static</code> |  strips ANSI codes from a string |

### constructor(s)

Constructs a new instance of the `Colors` class

<b>Signature</b>

```typescript
constructor(s?: string);
```
<b>Parameters</b>

|  Parameter | Type | Description |
|  --- | --- | --- |
|  s | <code>string</code> | a string containing ANSI escape codes. |

### asChromeConsoleLogArguments property

<b>Signature</b>

```typescript
get asChromeConsoleLogArguments(): any[];
```

### browserConsoleArguments property

<b>Signature</b>

```typescript
get browserConsoleArguments(): any[];
```

### names property

<b>Signature</b>

```typescript
static names: (string | number)[];
```

### nice property

 installs String prototype extensions

<b>Signature</b>

```typescript
static get nice(): typeof Colors;
```

## Example

require ('ansicolor').nice console.log ('foo'.bright.red)

### parsed property

<b>Signature</b>

```typescript
get parsed(): Colors & {
        spans: any[];
    };
```

### rgb property

<b>Signature</b>

```typescript
static rgb: {
        black: number[];
        darkGray: number[];
        lightGray: number[];
        white: number[];
        red: number[];
        lightRed: number[];
        green: number[];
        lightGreen: number[];
        yellow: number[];
        lightYellow: number[];
        blue: number[];
        lightBlue: number[];
        magenta: number[];
        lightMagenta: number[];
        cyan: number[];
        lightCyan: number[];
    };
```

### spans property

<b>Signature</b>

```typescript
spans: any[];
```

### str property

<b>Signature</b>

```typescript
get str(): any;
```

### \[Symbol.iterator\] method

<b>Signature</b>

```typescript
[Symbol.iterator](): IterableIterator<any>;
```
<b>Returns:</b>

`IterableIterator<any>`

## Example

const spans = \[...ansi.parse ('<!-- -->\\<!-- -->u001b\[7m<!-- -->\\<!-- -->u001b\[7mfoo<!-- -->\\<!-- -->u001b\[7mbar<!-- -->\\<!-- -->u001b\[27m')\]

### parse method

 parses a string containing ANSI escape codes  {<!-- -->Colors<!-- -->} parsed representation.

<b>Signature</b>

```typescript
static parse(s: string): Colors & {
        spans: any[];
    };
```
<b>Parameters</b>

|  Parameter | Type | Description |
|  --- | --- | --- |
|  s | <code>string</code> |  |

<b>Returns:</b>

`Colors & {
        spans: any[];
    }`

### strip method

 strips ANSI codes from a string

<b>Signature</b>

```typescript
static strip(s: string): string;
```
<b>Parameters</b>

|  Parameter | Type | Description |
|  --- | --- | --- |
|  s | <code>string</code> | a string containing ANSI escape codes.  {<!-- -->string<!-- -->} clean string. |

<b>Returns:</b>

`string`

