+++
# -----------------------------------------------------------------------
# Do not edit this file. It is automatically generated by API Documenter.
# -----------------------------------------------------------------------
title = "@grafana/ui"
keywords = ["grafana","documentation","sdk","@grafana/ui"]
type = "docs"
+++

## @grafana/ui package

A library containing the different design components of the Grafana ecosystem.

## Classes

|  Class | Description |
|  --- | --- |
|  [ansicolor](./ansicolor/) | Represents an ANSI-escaped string. |
|  [BarGauge](./bargauge/) |  |
|  [BigValue](./bigvalue/) |  |
|  [Cascader](./cascader/) |  |
|  [ClickOutsideWrapper](./clickoutsidewrapper/) |  |
|  [ClipboardButton](./clipboardbutton/) |  |
|  [CustomScrollbar](./customscrollbar/) | Wraps component into <Scrollbars> component from <code>react-custom-scrollbars</code> |
|  [ErrorBoundary](./errorboundary/) |  |
|  [ErrorBoundaryAlert](./errorboundaryalert/) |  |
|  [Gauge](./gauge/) |  |
|  [Graph](./graph/) |  |
|  [GraphSeriesToggler](./graphseriestoggler/) |  |
|  [JsonExplorer](./jsonexplorer/) |  JsonExplorer<!-- -->JsonExplorer allows you to render JSON objects in HTML with a \*\*collapsible\*\* navigation. |
|  [JSONFormatter](./jsonformatter/) |  |
|  [List](./list/) |  |
|  [ModalsProvider](./modalsprovider/) |  |
|  [PieChart](./piechart/) |  |
|  [Popover](./popover/) |  |
|  [PopoverController](./popovercontroller/) |  |
|  [Portal](./portal/) |  |
|  [QueryField](./queryfield/) | Renders an editor field. Pass initial value as initialQuery and listen to changes in props.onValueChanged. This component can only process strings. Internally it uses Slate Value. Implement props.onTypeahead to use suggestions, see PromQueryField.tsx as an example. |
|  [SelectValueEditor](./selectvalueeditor/) |  |
|  [SetInterval](./setinterval/) |  |
|  [StatsPicker](./statspicker/) |  |
|  [StringArrayEditor](./stringarrayeditor/) |  |
|  [TableInputCSV](./tableinputcsv/) | Expects the container div to have size set and will fill it 100% |
|  [TagsInput](./tagsinput/) |  |
|  [ToggleButtonGroup](./togglebuttongroup/) |  |
|  [UnitPicker](./unitpicker/) |  |
|  [VizRepeater](./vizrepeater/) |  |

## Enumerations

|  Enumeration | Description |
|  --- | --- |
|  [BarGaugeDisplayMode](./bargaugedisplaymode/) |  |
|  [BigValueColorMode](./bigvaluecolormode/) |  |
|  [BigValueGraphMode](./bigvaluegraphmode/) |  |
|  [BigValueJustifyMode](./bigvaluejustifymode/) |  |
|  [CompletionItemKind](./completionitemkind/) |  |
|  [EventsWithValidation](./eventswithvalidation/) |  |
|  [LegacyInputStatus](./legacyinputstatus/) |  |
|  [LegendDisplayMode](./legenddisplaymode/) |  |
|  [PieChartType](./piecharttype/) |  |
|  [TableCellDisplayMode](./tablecelldisplaymode/) |  |

## Functions

|  Function | Description |
|  --- | --- |
|  [AsyncMultiSelect(props)](./asyncmultiselect/) |  |
|  [AsyncSelect(props)](./asyncselect/) |  |
|  [BracesPlugin()](./bracesplugin/) |  |
|  [ButtonSelect({ placeholder, icon, variant, size, className, disabled, ...selectProps })](./buttonselect/) |  |
|  [calculateFontSize(text, width, height, lineHeight, maxSize)](./calculatefontsize/) |  |
|  [ClearPlugin()](./clearplugin/) |  |
|  [ClipboardPlugin()](./clipboardplugin/) |  |
|  [convertOldAngularValueMapping(panel)](./convertoldangularvaluemapping/) | Convert the angular single stat mapping to new react style |
|  [FadeTransition(props)](./fadetransition/) |  |
|  [Form({ defaultValues, onSubmit, validateOnMount, validateFieldsOnMount, children, validateOn, maxWidth, })](./form/) |  |
|  [getScrollbarWidth()](./getscrollbarwidth/) |  |
|  [getTagColor(index)](./gettagcolor/) |  |
|  [getTagColorsFromName(name)](./gettagcolorsfromname/) | Returns tag badge background and border colors based on hashed tag name. |
|  [IndentationPlugin()](./indentationplugin/) |  |
|  [measureText(text, fontSize)](./measuretext/) |  |
|  [MultiSelect(props)](./multiselect/) |  |
|  [NewlinePlugin()](./newlineplugin/) |  |
|  [RadioButtonGroup({ options, value, onChange, disabled, disabledOptions, size, fullWidth, })](./radiobuttongroup/) |  |
|  [renderOrCallToRender(itemToRender, props)](./renderorcalltorender/) | Given react node or function returns element accordingly |
|  [resetSelectStyles()](./resetselectstyles/) |  |
|  [RunnerPlugin({ handler })](./runnerplugin/) |  |
|  [Segment({ options, value, onChange, Component, className, allowCustomValue, placeholder, })](./segment/) |  |
|  [SegmentAsync({ value, onChange, loadOptions, Component, className, allowCustomValue, placeholder, })](./segmentasync/) |  |
|  [SegmentInput({ value: initialValue, onChange, Component, className, placeholder, autofocus, })](./segmentinput/) |  |
|  [SegmentSelect({ value, options, onChange, onClickOutside, width, noOptionsMessage, allowCustomValue, })](./segmentselect/) |  |
|  [Select(props)](./select/) |  |
|  [SelectionShortcutsPlugin()](./selectionshortcutsplugin/) |  |
|  [sharedSingleStatMigrationHandler(panel)](./sharedsinglestatmigrationhandler/) |  |
|  [sharedSingleStatPanelChangedHandler(panel, prevPluginId, prevOptions)](./sharedsinglestatpanelchangedhandler/) |  |
|  [SlatePrism(optsParam)](./slateprism/) | A Slate plugin to highlight code syntax. |
|  [SlideOutTransition(props)](./slideouttransition/) |  |
|  [stylesFactory(stylesCreator)](./stylesfactory/) | Creates memoized version of styles creator |
|  [SuggestionsPlugin({ onTypeahead, cleanText, onWillApplySuggestion, portalOrigin, })](./suggestionsplugin/) |  |
|  [useTheme()](./usetheme/) |  |
|  [ValuePicker({ label, icon, options, onChange, variant, size, isFullWidth, menuPlacement, })](./valuepicker/) |  |

## Interfaces

|  Interface | Description |
|  --- | --- |
|  [BadgeProps](./badgeprops/) |  |
|  [BigValueSparkline](./bigvaluesparkline/) |  |
|  [CascaderOption](./cascaderoption/) |  |
|  [CompletionItem](./completionitem/) |  |
|  [CompletionItemGroup](./completionitemgroup/) |  |
|  [ContextMenuGroup](./contextmenugroup/) |  |
|  [ContextMenuItem](./contextmenuitem/) |  |
|  [ContextMenuProps](./contextmenuprops/) |  |
|  [GraphSeriesTogglerAPI](./graphseriestogglerapi/) |  |
|  [GraphTooltipOptions](./graphtooltipoptions/) |  |
|  [LegendBasicOptions](./legendbasicoptions/) |  |
|  [LegendItem](./legenditem/) |  |
|  [LegendOptions](./legendoptions/) |  |
|  [LegendRenderOptions](./legendrenderoptions/) |  |
|  [SingleStatBaseOptions](./singlestatbaseoptions/) |  |
|  [StyleProps](./styleprops/) |  |
|  [SuggestionsState](./suggestionsstate/) |  |
|  [TableSortByFieldState](./tablesortbyfieldstate/) |  |
|  [Themeable](./themeable/) |  |
|  [Token](./token/) |  |
|  [TypeaheadInput](./typeaheadinput/) |  |
|  [TypeaheadOutput](./typeaheadoutput/) |  |
|  [ValidationEvents](./validationevents/) |  |
|  [ValidationRule](./validationrule/) |  |
|  [VizRepeaterRenderValueProps](./vizrepeaterrendervalueprops/) |  |

## Namespaces

|  Namespace | Description |
|  --- | --- |
|  [DOMUtil](./domutil/) |  |
|  [RadioButtonGroup](./radiobuttongroup/) |  |
|  [styleMixins](./stylemixins/) |  |

## Variables

|  Variable | Description |
|  --- | --- |
|  [Alert](./alert/) |  |
|  [ALERTING\_COLOR](./alerting_color/) |  |
|  [AlphaNotice](./alphanotice/) |  |
|  [Badge](./badge/) |  |
|  [Button](./button/) |  |
|  [ButtonCascader](./buttoncascader/) |  |
|  [CallToActionCard](./calltoactioncard/) |  |
|  [Chart](./chart/) |  |
|  [Checkbox](./checkbox/) |  |
|  [CodeEditor](./codeeditor/) |  |
|  [Collapse](./collapse/) |  |
|  [ColorPicker](./colorpicker/) |  |
|  [colors](./colors/) |  |
|  [ConfirmButton](./confirmbutton/) |  |
|  [ConfirmModal](./confirmmodal/) |  |
|  [Container](./container/) |  |
|  [ContextMenu](./contextmenu/) |  |
|  [ControlledCollapse](./controlledcollapse/) |  |
|  [Counter](./counter/) |  |
|  [DataLinkInput](./datalinkinput/) |  |
|  [DataLinksContextMenu](./datalinkscontextmenu/) |  |
|  [DataLinksInlineEditor](./datalinksinlineeditor/) |  |
|  [DataSourceHttpSettings](./datasourcehttpsettings/) |  |
|  [DEFAULT\_ANNOTATION\_COLOR](./default_annotation_color/) |  |
|  [DeleteButton](./deletebutton/) |  |
|  [Drawer](./drawer/) |  |
|  [EmptySearchResult](./emptysearchresult/) |  |
|  [ErrorWithStack](./errorwithstack/) |  |
|  [FeatureInfoBox](./featureinfobox/) |  |
|  [Field](./field/) |  |
|  [FieldConfigItemHeaderTitle](./fieldconfigitemheadertitle/) |  |
|  [fieldMatchersUI](./fieldmatchersui/) |  |
|  [FieldSet](./fieldset/) |  |
|  [FileUpload](./fileupload/) |  |
|  [FilterPill](./filterpill/) |  |
|  [FullWidthButtonContainer](./fullwidthbuttoncontainer/) |  |
|  [getAvailableIcons](./getavailableicons/) |  |
|  [getButtonStyles](./getbuttonstyles/) |  |
|  [getFormStyles](./getformstyles/) |  |
|  [getLogRowStyles](./getlogrowstyles/) |  |
|  [getStandardFieldConfigs](./getstandardfieldconfigs/) | Returns collection of common field config properties definitions |
|  [getStandardOptionEditors](./getstandardoptioneditors/) | Returns collection of standard option editors definitions |
|  [getTheme](./gettheme/) |  |
|  [GraphContextMenu](./graphcontextmenu/) |  |
|  [GraphLegend](./graphlegend/) |  |
|  [graphTickFormatter](./graphtickformatter/) |  |
|  [graphTimeFormat](./graphtimeformat/) |  |
|  [GraphWithLegend](./graphwithlegend/) |  |
|  [hasValidationEvent](./hasvalidationevent/) |  |
|  [HorizontalGroup](./horizontalgroup/) |  |
|  [Icon](./icon/) |  |
|  [IconButton](./iconbutton/) |  |
|  [InlineFormLabel](./inlineformlabel/) |  |
|  [Input](./input/) |  |
|  [Label](./label/) |  |
|  [LegacyForms](./legacyforms/) |  |
|  [Legend](./legend/) |  |
|  [LegendList](./legendlist/) |  |
|  [LegendTable](./legendtable/) |  |
|  [LinkButton](./linkbutton/) |  |
|  [linkModelToContextMenuItems](./linkmodeltocontextmenuitems/) | Delays creating links until we need to open the ContextMenu |
|  [LoadingPlaceholder](./loadingplaceholder/) |  |
|  [LogLabels](./loglabels/) |  |
|  [LogRows](./logrows/) |  |
|  [makeFragment](./makefragment/) |  |
|  [makeValue](./makevalue/) |  |
|  [mockTheme](./mocktheme/) |  |
|  [mockThemeContext](./mockthemecontext/) | Enables theme context mocking |
|  [Modal](./modal/) |  |
|  [ModalHeader](./modalheader/) |  |
|  [ModalRoot](./modalroot/) |  |
|  [ModalsController](./modalscontroller/) |  |
|  [ModalTabContent](./modaltabcontent/) |  |
|  [ModalTabsHeader](./modaltabsheader/) |  |
|  [NO\_DATA\_COLOR](./no_data_color/) |  |
|  [NumberValueEditor](./numbervalueeditor/) |  |
|  [OK\_COLOR](./ok_color/) |  |
|  [Pagination](./pagination/) |  |
|  [PALETTE\_COLUMNS](./palette_columns/) |  |
|  [PALETTE\_ROWS](./palette_rows/) |  |
|  [PanelOptionsGrid](./paneloptionsgrid/) |  |
|  [PanelOptionsGroup](./paneloptionsgroup/) |  |
|  [PENDING\_COLOR](./pending_color/) |  |
|  [RefreshPicker](./refreshpicker/) |  |
|  [regexValidation](./regexvalidation/) |  |
|  [REGION\_FILL\_ALPHA](./region_fill_alpha/) |  |
|  [SCHEMA](./schema/) |  |
|  [selectThemeVariant](./selectthemevariant/) |  |
|  [SeriesColorPicker](./seriescolorpicker/) |  |
|  [SeriesColorPickerPopover](./seriescolorpickerpopover/) |  |
|  [SeriesColorPickerPopoverWithTheme](./seriescolorpickerpopoverwiththeme/) |  |
|  [SeriesIcon](./seriesicon/) |  |
|  [Slider](./slider/) |  |
|  [sortedColors](./sortedcolors/) |  |
|  [Spinner](./spinner/) |  |
|  [StringValueEditor](./stringvalueeditor/) |  |
|  [Switch](./switch/) |  |
|  [Tab](./tab/) |  |
|  [TabContent](./tabcontent/) |  |
|  [Table](./table/) |  |
|  [TabsBar](./tabsbar/) |  |
|  [Tag](./tag/) |  |
|  [TagList](./taglist/) |  |
|  [TextArea](./textarea/) |  |
|  [ThemeContext](./themecontext/) |  |
|  [TimeOfDayPicker](./timeofdaypicker/) |  |
|  [TimeRangePicker](./timerangepicker/) |  |
|  [TimeZonePicker](./timezonepicker/) |  |
|  [ToggleButton](./togglebutton/) |  |
|  [Tooltip](./tooltip/) |  |
|  [useStyles](./usestyles/) | Hook for using memoized styles with access to the theme. |
|  [validate](./validate/) |  |
|  [VerticalGroup](./verticalgroup/) |  |
|  [withTheme](./withtheme/) |  |

## Type Aliases

|  Type Alias | Description |
|  --- | --- |
|  [AlertVariant](./alertvariant/) |  |
|  [BadgeColor](./badgecolor/) |  |
|  [ButtonProps](./buttonprops/) |  |
|  [ButtonVariant](./buttonvariant/) |  |
|  [FormAPI](./formapi/) |  |
|  [FormInputSize](./forminputsize/) |  |
|  [IconName](./iconname/) |  |
|  [IconSize](./iconsize/) |  |
|  [IconType](./icontype/) |  |
|  [LegendPlacement](./legendplacement/) |  |
|  [PopoverContent](./popovercontent/) |  |
|  [Renderable](./renderable/) |  |
|  [RenderFunction](./renderfunction/) |  |

