// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package storagegateway_test

import (
	"context"
	"fmt"
	"strings"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/aws/awserr"
	"github.com/aws/aws-sdk-go-v2/aws/external"
	"github.com/aws/aws-sdk-go-v2/service/storagegateway"
)

var _ time.Duration
var _ strings.Reader
var _ aws.Config

func parseTime(layout, value string) *time.Time {
	t, err := time.Parse(layout, value)
	if err != nil {
		panic(err)
	}
	return &t
}

// To activate the gateway
//
// Activates the gateway you previously deployed on your host.
func ExampleClient_ActivateGatewayRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := storagegateway.New(cfg)
	input := &storagegateway.ActivateGatewayInput{
		ActivationKey:     aws.String("29AV1-3OFV9-VVIUB-NKT0I-LRO6V"),
		GatewayName:       aws.String("My_Gateway"),
		GatewayRegion:     aws.String("us-east-1"),
		GatewayTimezone:   aws.String("GMT-12:00"),
		GatewayType:       aws.String("STORED"),
		MediumChangerType: aws.String("AWS-Gateway-VTL"),
		TapeDriveType:     aws.String("IBM-ULT3580-TD5"),
	}

	req := svc.ActivateGatewayRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case storagegateway.ErrCodeInvalidGatewayRequestException:
				fmt.Println(storagegateway.ErrCodeInvalidGatewayRequestException, aerr.Error())
			case storagegateway.ErrCodeInternalServerError:
				fmt.Println(storagegateway.ErrCodeInternalServerError, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To add a cache
//
// The following example shows a request that activates a gateway-stored volume.
func ExampleClient_AddCacheRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := storagegateway.New(cfg)
	input := &storagegateway.AddCacheInput{
		DiskIds: []string{
			"pci-0000:03:00.0-scsi-0:0:0:0",
			"pci-0000:03:00.0-scsi-0:0:1:0",
		},
		GatewayARN: aws.String("arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B"),
	}

	req := svc.AddCacheRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case storagegateway.ErrCodeInvalidGatewayRequestException:
				fmt.Println(storagegateway.ErrCodeInvalidGatewayRequestException, aerr.Error())
			case storagegateway.ErrCodeInternalServerError:
				fmt.Println(storagegateway.ErrCodeInternalServerError, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To add tags to resource
//
// Adds one or more tags to the specified resource.
func ExampleClient_AddTagsToResourceRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := storagegateway.New(cfg)
	input := &storagegateway.AddTagsToResourceInput{
		ResourceARN: aws.String("arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-11A2222B"),
		Tags: []storagegateway.Tag{
			{
				Key:   aws.String("Dev Gatgeway Region"),
				Value: aws.String("East Coast"),
			},
		},
	}

	req := svc.AddTagsToResourceRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case storagegateway.ErrCodeInvalidGatewayRequestException:
				fmt.Println(storagegateway.ErrCodeInvalidGatewayRequestException, aerr.Error())
			case storagegateway.ErrCodeInternalServerError:
				fmt.Println(storagegateway.ErrCodeInternalServerError, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To add upload buffer on local disk
//
// Configures one or more gateway local disks as upload buffer for a specified gateway.
func ExampleClient_AddUploadBufferRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := storagegateway.New(cfg)
	input := &storagegateway.AddUploadBufferInput{
		DiskIds: []string{
			"pci-0000:03:00.0-scsi-0:0:0:0",
			"pci-0000:03:00.0-scsi-0:0:1:0",
		},
		GatewayARN: aws.String("arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B"),
	}

	req := svc.AddUploadBufferRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case storagegateway.ErrCodeInvalidGatewayRequestException:
				fmt.Println(storagegateway.ErrCodeInvalidGatewayRequestException, aerr.Error())
			case storagegateway.ErrCodeInternalServerError:
				fmt.Println(storagegateway.ErrCodeInternalServerError, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To add storage on local disk
//
// Configures one or more gateway local disks as working storage for a gateway. (Working
// storage is also referred to as upload buffer.)
func ExampleClient_AddWorkingStorageRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := storagegateway.New(cfg)
	input := &storagegateway.AddWorkingStorageInput{
		DiskIds: []string{
			"pci-0000:03:00.0-scsi-0:0:0:0",
			"pci-0000:03:00.0-scsi-0:0:1:0",
		},
		GatewayARN: aws.String("arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B"),
	}

	req := svc.AddWorkingStorageRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case storagegateway.ErrCodeInvalidGatewayRequestException:
				fmt.Println(storagegateway.ErrCodeInvalidGatewayRequestException, aerr.Error())
			case storagegateway.ErrCodeInternalServerError:
				fmt.Println(storagegateway.ErrCodeInternalServerError, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To cancel virtual tape archiving
//
// Cancels archiving of a virtual tape to the virtual tape shelf (VTS) after the archiving
// process is initiated.
func ExampleClient_CancelArchivalRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := storagegateway.New(cfg)
	input := &storagegateway.CancelArchivalInput{
		GatewayARN: aws.String("arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B"),
		TapeARN:    aws.String("arn:aws:storagegateway:us-east-1:999999999999:tape/AMZN01A2A4"),
	}

	req := svc.CancelArchivalRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case storagegateway.ErrCodeInvalidGatewayRequestException:
				fmt.Println(storagegateway.ErrCodeInvalidGatewayRequestException, aerr.Error())
			case storagegateway.ErrCodeInternalServerError:
				fmt.Println(storagegateway.ErrCodeInternalServerError, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To cancel virtual tape retrieval
//
// Cancels retrieval of a virtual tape from the virtual tape shelf (VTS) to a gateway
// after the retrieval process is initiated.
func ExampleClient_CancelRetrievalRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := storagegateway.New(cfg)
	input := &storagegateway.CancelRetrievalInput{
		GatewayARN: aws.String("arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B"),
		TapeARN:    aws.String("arn:aws:storagegateway:us-east-1:999999999999:tape/AMZN01A2A4"),
	}

	req := svc.CancelRetrievalRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case storagegateway.ErrCodeInvalidGatewayRequestException:
				fmt.Println(storagegateway.ErrCodeInvalidGatewayRequestException, aerr.Error())
			case storagegateway.ErrCodeInternalServerError:
				fmt.Println(storagegateway.ErrCodeInternalServerError, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a cached iSCSI volume
//
// Creates a cached volume on a specified cached gateway.
func ExampleClient_CreateCachediSCSIVolumeRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := storagegateway.New(cfg)
	input := &storagegateway.CreateCachediSCSIVolumeInput{
		ClientToken:        aws.String("cachedvol112233"),
		GatewayARN:         aws.String("arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B"),
		NetworkInterfaceId: aws.String("10.1.1.1"),
		SnapshotId:         aws.String("snap-f47b7b94"),
		TargetName:         aws.String("my-volume"),
		VolumeSizeInBytes:  aws.Int64(536870912000),
	}

	req := svc.CreateCachediSCSIVolumeRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case storagegateway.ErrCodeInvalidGatewayRequestException:
				fmt.Println(storagegateway.ErrCodeInvalidGatewayRequestException, aerr.Error())
			case storagegateway.ErrCodeInternalServerError:
				fmt.Println(storagegateway.ErrCodeInternalServerError, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a snapshot of a gateway volume
//
// Initiates an ad-hoc snapshot of a gateway volume.
func ExampleClient_CreateSnapshotRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := storagegateway.New(cfg)
	input := &storagegateway.CreateSnapshotInput{
		SnapshotDescription: aws.String("My root volume snapshot as of 10/03/2017"),
		VolumeARN:           aws.String("arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B/volume/vol-1122AABB"),
	}

	req := svc.CreateSnapshotRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case storagegateway.ErrCodeInvalidGatewayRequestException:
				fmt.Println(storagegateway.ErrCodeInvalidGatewayRequestException, aerr.Error())
			case storagegateway.ErrCodeInternalServerError:
				fmt.Println(storagegateway.ErrCodeInternalServerError, aerr.Error())
			case storagegateway.ErrCodeServiceUnavailableError:
				fmt.Println(storagegateway.ErrCodeServiceUnavailableError, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a snapshot of a gateway volume
//
// Initiates a snapshot of a gateway from a volume recovery point.
func ExampleClient_CreateSnapshotFromVolumeRecoveryPointRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := storagegateway.New(cfg)
	input := &storagegateway.CreateSnapshotFromVolumeRecoveryPointInput{
		SnapshotDescription: aws.String("My root volume snapshot as of 2017-06-30T10:10:10.000Z"),
		VolumeARN:           aws.String("arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B/volume/vol-1122AABB"),
	}

	req := svc.CreateSnapshotFromVolumeRecoveryPointRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case storagegateway.ErrCodeInvalidGatewayRequestException:
				fmt.Println(storagegateway.ErrCodeInvalidGatewayRequestException, aerr.Error())
			case storagegateway.ErrCodeInternalServerError:
				fmt.Println(storagegateway.ErrCodeInternalServerError, aerr.Error())
			case storagegateway.ErrCodeServiceUnavailableError:
				fmt.Println(storagegateway.ErrCodeServiceUnavailableError, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a stored iSCSI volume
//
// Creates a stored volume on a specified stored gateway.
func ExampleClient_CreateStorediSCSIVolumeRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := storagegateway.New(cfg)
	input := &storagegateway.CreateStorediSCSIVolumeInput{
		DiskId:               aws.String("pci-0000:03:00.0-scsi-0:0:0:0"),
		GatewayARN:           aws.String("arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B"),
		NetworkInterfaceId:   aws.String("10.1.1.1"),
		PreserveExistingData: aws.Bool(true),
		SnapshotId:           aws.String("snap-f47b7b94"),
		TargetName:           aws.String("my-volume"),
	}

	req := svc.CreateStorediSCSIVolumeRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case storagegateway.ErrCodeInvalidGatewayRequestException:
				fmt.Println(storagegateway.ErrCodeInvalidGatewayRequestException, aerr.Error())
			case storagegateway.ErrCodeInternalServerError:
				fmt.Println(storagegateway.ErrCodeInternalServerError, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a virtual tape using a barcode
//
// Creates a virtual tape by using your own barcode.
func ExampleClient_CreateTapeWithBarcodeRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := storagegateway.New(cfg)
	input := &storagegateway.CreateTapeWithBarcodeInput{
		GatewayARN:      aws.String("arn:aws:storagegateway:us-east-1:999999999999:gateway/sgw-12A3456B"),
		TapeBarcode:     aws.String("TEST12345"),
		TapeSizeInBytes: aws.Int64(107374182400),
	}

	req := svc.CreateTapeWithBarcodeRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case storagegateway.ErrCodeInvalidGatewayRequestException:
				fmt.Println(storagegateway.ErrCodeInvalidGatewayRequestException, aerr.Error())
			case storagegateway.ErrCodeInternalServerError:
				fmt.Println(storagegateway.ErrCodeInternalServerError, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a virtual tape
//
// Creates one or more virtual tapes.
func ExampleClient_CreateTapesRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := storagegateway.New(cfg)
	input := &storagegateway.CreateTapesInput{
		ClientToken:       aws.String("77777"),
		GatewayARN:        aws.String("arn:aws:storagegateway:us-east-1:999999999999:gateway/sgw-12A3456B"),
		NumTapesToCreate:  aws.Int64(3),
		TapeBarcodePrefix: aws.String("TEST"),
		TapeSizeInBytes:   aws.Int64(107374182400),
	}

	req := svc.CreateTapesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case storagegateway.ErrCodeInvalidGatewayRequestException:
				fmt.Println(storagegateway.ErrCodeInvalidGatewayRequestException, aerr.Error())
			case storagegateway.ErrCodeInternalServerError:
				fmt.Println(storagegateway.ErrCodeInternalServerError, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete bandwidth rate limits of gateway
//
// Deletes the bandwidth rate limits of a gateway; either the upload or download limit,
// or both.
func ExampleClient_DeleteBandwidthRateLimitRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := storagegateway.New(cfg)
	input := &storagegateway.DeleteBandwidthRateLimitInput{
		BandwidthType: aws.String("All"),
		GatewayARN:    aws.String("arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B"),
	}

	req := svc.DeleteBandwidthRateLimitRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case storagegateway.ErrCodeInvalidGatewayRequestException:
				fmt.Println(storagegateway.ErrCodeInvalidGatewayRequestException, aerr.Error())
			case storagegateway.ErrCodeInternalServerError:
				fmt.Println(storagegateway.ErrCodeInternalServerError, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete CHAP credentials
//
// Deletes Challenge-Handshake Authentication Protocol (CHAP) credentials for a specified
// iSCSI target and initiator pair.
func ExampleClient_DeleteChapCredentialsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := storagegateway.New(cfg)
	input := &storagegateway.DeleteChapCredentialsInput{
		InitiatorName: aws.String("iqn.1991-05.com.microsoft:computername.domain.example.com"),
		TargetARN:     aws.String("arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume"),
	}

	req := svc.DeleteChapCredentialsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case storagegateway.ErrCodeInvalidGatewayRequestException:
				fmt.Println(storagegateway.ErrCodeInvalidGatewayRequestException, aerr.Error())
			case storagegateway.ErrCodeInternalServerError:
				fmt.Println(storagegateway.ErrCodeInternalServerError, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a gatgeway
//
// This operation deletes the gateway, but not the gateway's VM from the host computer.
func ExampleClient_DeleteGatewayRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := storagegateway.New(cfg)
	input := &storagegateway.DeleteGatewayInput{
		GatewayARN: aws.String("arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B"),
	}

	req := svc.DeleteGatewayRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case storagegateway.ErrCodeInvalidGatewayRequestException:
				fmt.Println(storagegateway.ErrCodeInvalidGatewayRequestException, aerr.Error())
			case storagegateway.ErrCodeInternalServerError:
				fmt.Println(storagegateway.ErrCodeInternalServerError, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a snapshot of a volume
//
// This action enables you to delete a snapshot schedule for a volume.
func ExampleClient_DeleteSnapshotScheduleRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := storagegateway.New(cfg)
	input := &storagegateway.DeleteSnapshotScheduleInput{
		VolumeARN: aws.String("arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B/volume/vol-1122AABB"),
	}

	req := svc.DeleteSnapshotScheduleRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case storagegateway.ErrCodeInvalidGatewayRequestException:
				fmt.Println(storagegateway.ErrCodeInvalidGatewayRequestException, aerr.Error())
			case storagegateway.ErrCodeInternalServerError:
				fmt.Println(storagegateway.ErrCodeInternalServerError, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a virtual tape
//
// This example deletes the specified virtual tape.
func ExampleClient_DeleteTapeRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := storagegateway.New(cfg)
	input := &storagegateway.DeleteTapeInput{
		GatewayARN: aws.String("arn:aws:storagegateway:us-east-1:204469490176:gateway/sgw-12A3456B"),
		TapeARN:    aws.String("arn:aws:storagegateway:us-east-1:204469490176:tape/TEST05A2A0"),
	}

	req := svc.DeleteTapeRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case storagegateway.ErrCodeInvalidGatewayRequestException:
				fmt.Println(storagegateway.ErrCodeInvalidGatewayRequestException, aerr.Error())
			case storagegateway.ErrCodeInternalServerError:
				fmt.Println(storagegateway.ErrCodeInternalServerError, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a virtual tape from the shelf (VTS)
//
// Deletes the specified virtual tape from the virtual tape shelf (VTS).
func ExampleClient_DeleteTapeArchiveRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := storagegateway.New(cfg)
	input := &storagegateway.DeleteTapeArchiveInput{
		TapeARN: aws.String("arn:aws:storagegateway:us-east-1:204469490176:tape/TEST05A2A0"),
	}

	req := svc.DeleteTapeArchiveRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case storagegateway.ErrCodeInvalidGatewayRequestException:
				fmt.Println(storagegateway.ErrCodeInvalidGatewayRequestException, aerr.Error())
			case storagegateway.ErrCodeInternalServerError:
				fmt.Println(storagegateway.ErrCodeInternalServerError, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a gateway volume
//
// Deletes the specified gateway volume that you previously created using the CreateCachediSCSIVolume
// or CreateStorediSCSIVolume API.
func ExampleClient_DeleteVolumeRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := storagegateway.New(cfg)
	input := &storagegateway.DeleteVolumeInput{
		VolumeARN: aws.String("arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B/volume/vol-1122AABB"),
	}

	req := svc.DeleteVolumeRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case storagegateway.ErrCodeInvalidGatewayRequestException:
				fmt.Println(storagegateway.ErrCodeInvalidGatewayRequestException, aerr.Error())
			case storagegateway.ErrCodeInternalServerError:
				fmt.Println(storagegateway.ErrCodeInternalServerError, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the bandwidth rate limits of a gateway
//
// Returns a value for a bandwidth rate limit if set. If not set, then only the gateway
// ARN is returned.
func ExampleClient_DescribeBandwidthRateLimitRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := storagegateway.New(cfg)
	input := &storagegateway.DescribeBandwidthRateLimitInput{
		GatewayARN: aws.String("arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B"),
	}

	req := svc.DescribeBandwidthRateLimitRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case storagegateway.ErrCodeInvalidGatewayRequestException:
				fmt.Println(storagegateway.ErrCodeInvalidGatewayRequestException, aerr.Error())
			case storagegateway.ErrCodeInternalServerError:
				fmt.Println(storagegateway.ErrCodeInternalServerError, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe cache information
//
// Returns information about the cache of a gateway.
func ExampleClient_DescribeCacheRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := storagegateway.New(cfg)
	input := &storagegateway.DescribeCacheInput{
		GatewayARN: aws.String("arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B"),
	}

	req := svc.DescribeCacheRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case storagegateway.ErrCodeInvalidGatewayRequestException:
				fmt.Println(storagegateway.ErrCodeInvalidGatewayRequestException, aerr.Error())
			case storagegateway.ErrCodeInternalServerError:
				fmt.Println(storagegateway.ErrCodeInternalServerError, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe gateway cached iSCSI volumes
//
// Returns a description of the gateway cached iSCSI volumes specified in the request.
func ExampleClient_DescribeCachediSCSIVolumesRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := storagegateway.New(cfg)
	input := &storagegateway.DescribeCachediSCSIVolumesInput{
		VolumeARNs: []string{
			"arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B/volume/vol-1122AABB",
		},
	}

	req := svc.DescribeCachediSCSIVolumesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case storagegateway.ErrCodeInvalidGatewayRequestException:
				fmt.Println(storagegateway.ErrCodeInvalidGatewayRequestException, aerr.Error())
			case storagegateway.ErrCodeInternalServerError:
				fmt.Println(storagegateway.ErrCodeInternalServerError, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe CHAP credetnitals for an iSCSI
//
// Returns an array of Challenge-Handshake Authentication Protocol (CHAP) credentials
// information for a specified iSCSI target, one for each target-initiator pair.
func ExampleClient_DescribeChapCredentialsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := storagegateway.New(cfg)
	input := &storagegateway.DescribeChapCredentialsInput{
		TargetARN: aws.String("arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume"),
	}

	req := svc.DescribeChapCredentialsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case storagegateway.ErrCodeInvalidGatewayRequestException:
				fmt.Println(storagegateway.ErrCodeInvalidGatewayRequestException, aerr.Error())
			case storagegateway.ErrCodeInternalServerError:
				fmt.Println(storagegateway.ErrCodeInternalServerError, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe metadata about the gateway
//
// Returns metadata about a gateway such as its name, network interfaces, configured
// time zone, and the state (whether the gateway is running or not).
func ExampleClient_DescribeGatewayInformationRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := storagegateway.New(cfg)
	input := &storagegateway.DescribeGatewayInformationInput{
		GatewayARN: aws.String("arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B"),
	}

	req := svc.DescribeGatewayInformationRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case storagegateway.ErrCodeInvalidGatewayRequestException:
				fmt.Println(storagegateway.ErrCodeInvalidGatewayRequestException, aerr.Error())
			case storagegateway.ErrCodeInternalServerError:
				fmt.Println(storagegateway.ErrCodeInternalServerError, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe gateway's maintenance start time
//
// Returns your gateway's weekly maintenance start time including the day and time of
// the week.
func ExampleClient_DescribeMaintenanceStartTimeRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := storagegateway.New(cfg)
	input := &storagegateway.DescribeMaintenanceStartTimeInput{
		GatewayARN: aws.String("arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B"),
	}

	req := svc.DescribeMaintenanceStartTimeRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case storagegateway.ErrCodeInvalidGatewayRequestException:
				fmt.Println(storagegateway.ErrCodeInvalidGatewayRequestException, aerr.Error())
			case storagegateway.ErrCodeInternalServerError:
				fmt.Println(storagegateway.ErrCodeInternalServerError, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe snapshot schedule for gateway volume
//
// Describes the snapshot schedule for the specified gateway volume including intervals
// at which snapshots are automatically initiated.
func ExampleClient_DescribeSnapshotScheduleRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := storagegateway.New(cfg)
	input := &storagegateway.DescribeSnapshotScheduleInput{
		VolumeARN: aws.String("arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B/volume/vol-1122AABB"),
	}

	req := svc.DescribeSnapshotScheduleRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case storagegateway.ErrCodeInvalidGatewayRequestException:
				fmt.Println(storagegateway.ErrCodeInvalidGatewayRequestException, aerr.Error())
			case storagegateway.ErrCodeInternalServerError:
				fmt.Println(storagegateway.ErrCodeInternalServerError, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the volumes of a gateway
//
// Returns the description of the gateway volumes specified in the request belonging
// to the same gateway.
func ExampleClient_DescribeStorediSCSIVolumesRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := storagegateway.New(cfg)
	input := &storagegateway.DescribeStorediSCSIVolumesInput{
		VolumeARNs: []string{
			"arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B/volume/vol-1122AABB",
		},
	}

	req := svc.DescribeStorediSCSIVolumesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case storagegateway.ErrCodeInvalidGatewayRequestException:
				fmt.Println(storagegateway.ErrCodeInvalidGatewayRequestException, aerr.Error())
			case storagegateway.ErrCodeInternalServerError:
				fmt.Println(storagegateway.ErrCodeInternalServerError, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe virtual tapes in the VTS
//
// Returns a description of specified virtual tapes in the virtual tape shelf (VTS).
func ExampleClient_DescribeTapeArchivesRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := storagegateway.New(cfg)
	input := &storagegateway.DescribeTapeArchivesInput{
		Limit:  aws.Int64(123),
		Marker: aws.String("1"),
		TapeARNs: []string{
			"arn:aws:storagegateway:us-east-1:999999999999:tape/AM08A1AD",
			"arn:aws:storagegateway:us-east-1:999999999999:tape/AMZN01A2A4",
		},
	}

	req := svc.DescribeTapeArchivesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case storagegateway.ErrCodeInvalidGatewayRequestException:
				fmt.Println(storagegateway.ErrCodeInvalidGatewayRequestException, aerr.Error())
			case storagegateway.ErrCodeInternalServerError:
				fmt.Println(storagegateway.ErrCodeInternalServerError, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe virtual tape recovery points
//
// Returns a list of virtual tape recovery points that are available for the specified
// gateway-VTL.
func ExampleClient_DescribeTapeRecoveryPointsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := storagegateway.New(cfg)
	input := &storagegateway.DescribeTapeRecoveryPointsInput{
		GatewayARN: aws.String("arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B"),
		Limit:      aws.Int64(1),
		Marker:     aws.String("1"),
	}

	req := svc.DescribeTapeRecoveryPointsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case storagegateway.ErrCodeInvalidGatewayRequestException:
				fmt.Println(storagegateway.ErrCodeInvalidGatewayRequestException, aerr.Error())
			case storagegateway.ErrCodeInternalServerError:
				fmt.Println(storagegateway.ErrCodeInternalServerError, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe virtual tape(s) associated with gateway
//
// Returns a description of the specified Amazon Resource Name (ARN) of virtual tapes.
// If a TapeARN is not specified, returns a description of all virtual tapes.
func ExampleClient_DescribeTapesRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := storagegateway.New(cfg)
	input := &storagegateway.DescribeTapesInput{
		GatewayARN: aws.String("arn:aws:storagegateway:us-east-1:999999999999:gateway/sgw-12A3456B"),
		Limit:      aws.Int64(2),
		Marker:     aws.String("1"),
		TapeARNs: []string{
			"arn:aws:storagegateway:us-east-1:999999999999:tape/TEST04A2A1",
			"arn:aws:storagegateway:us-east-1:999999999999:tape/TEST05A2A0",
		},
	}

	req := svc.DescribeTapesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case storagegateway.ErrCodeInvalidGatewayRequestException:
				fmt.Println(storagegateway.ErrCodeInvalidGatewayRequestException, aerr.Error())
			case storagegateway.ErrCodeInternalServerError:
				fmt.Println(storagegateway.ErrCodeInternalServerError, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe upload buffer of gateway
//
// Returns information about the upload buffer of a gateway including disk IDs and the
// amount of upload buffer space allocated/used.
func ExampleClient_DescribeUploadBufferRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := storagegateway.New(cfg)
	input := &storagegateway.DescribeUploadBufferInput{
		GatewayARN: aws.String("arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B"),
	}

	req := svc.DescribeUploadBufferRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case storagegateway.ErrCodeInvalidGatewayRequestException:
				fmt.Println(storagegateway.ErrCodeInvalidGatewayRequestException, aerr.Error())
			case storagegateway.ErrCodeInternalServerError:
				fmt.Println(storagegateway.ErrCodeInternalServerError, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe upload buffer of a gateway
//
// Returns information about the upload buffer of a gateway including disk IDs and the
// amount of upload buffer space allocated and used.
func ExampleClient_DescribeUploadBufferRequest_shared01() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := storagegateway.New(cfg)
	input := &storagegateway.DescribeUploadBufferInput{
		GatewayARN: aws.String("arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B"),
	}

	req := svc.DescribeUploadBufferRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case storagegateway.ErrCodeInvalidGatewayRequestException:
				fmt.Println(storagegateway.ErrCodeInvalidGatewayRequestException, aerr.Error())
			case storagegateway.ErrCodeInternalServerError:
				fmt.Println(storagegateway.ErrCodeInternalServerError, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe virtual tape library (VTL) devices of a single gateway
//
// Returns a description of virtual tape library (VTL) devices for the specified gateway.
func ExampleClient_DescribeVTLDevicesRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := storagegateway.New(cfg)
	input := &storagegateway.DescribeVTLDevicesInput{
		GatewayARN: aws.String("arn:aws:storagegateway:us-east-1:999999999999:gateway/sgw-12A3456B"),
		Limit:      aws.Int64(123),
		Marker:     aws.String("1"),
	}

	req := svc.DescribeVTLDevicesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case storagegateway.ErrCodeInvalidGatewayRequestException:
				fmt.Println(storagegateway.ErrCodeInvalidGatewayRequestException, aerr.Error())
			case storagegateway.ErrCodeInternalServerError:
				fmt.Println(storagegateway.ErrCodeInternalServerError, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the working storage of a gateway [Depreciated]
//
// This operation is supported only for the gateway-stored volume architecture. This
// operation is deprecated in cached-volumes API version (20120630). Use DescribeUploadBuffer
// instead.
func ExampleClient_DescribeWorkingStorageRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := storagegateway.New(cfg)
	input := &storagegateway.DescribeWorkingStorageInput{
		GatewayARN: aws.String("arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B"),
	}

	req := svc.DescribeWorkingStorageRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case storagegateway.ErrCodeInvalidGatewayRequestException:
				fmt.Println(storagegateway.ErrCodeInvalidGatewayRequestException, aerr.Error())
			case storagegateway.ErrCodeInternalServerError:
				fmt.Println(storagegateway.ErrCodeInternalServerError, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To disable a gateway when it is no longer functioning
//
// Disables a gateway when the gateway is no longer functioning. Use this operation
// for a gateway-VTL that is not reachable or not functioning.
func ExampleClient_DisableGatewayRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := storagegateway.New(cfg)
	input := &storagegateway.DisableGatewayInput{
		GatewayARN: aws.String("arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B"),
	}

	req := svc.DisableGatewayRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case storagegateway.ErrCodeInvalidGatewayRequestException:
				fmt.Println(storagegateway.ErrCodeInvalidGatewayRequestException, aerr.Error())
			case storagegateway.ErrCodeInternalServerError:
				fmt.Println(storagegateway.ErrCodeInternalServerError, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To lists region specific gateways per AWS account
//
// Lists gateways owned by an AWS account in a specified region as requested. Results
// are sorted by gateway ARN up to a maximum of 100 gateways.
func ExampleClient_ListGatewaysRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := storagegateway.New(cfg)
	input := &storagegateway.ListGatewaysInput{
		Limit:  aws.Int64(2),
		Marker: aws.String("1"),
	}

	req := svc.ListGatewaysRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case storagegateway.ErrCodeInvalidGatewayRequestException:
				fmt.Println(storagegateway.ErrCodeInvalidGatewayRequestException, aerr.Error())
			case storagegateway.ErrCodeInternalServerError:
				fmt.Println(storagegateway.ErrCodeInternalServerError, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list the gateway's local disks
//
// The request returns a list of all disks, specifying which are configured as working
// storage, cache storage, or stored volume or not configured at all.
func ExampleClient_ListLocalDisksRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := storagegateway.New(cfg)
	input := &storagegateway.ListLocalDisksInput{
		GatewayARN: aws.String("arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B"),
	}

	req := svc.ListLocalDisksRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case storagegateway.ErrCodeInvalidGatewayRequestException:
				fmt.Println(storagegateway.ErrCodeInvalidGatewayRequestException, aerr.Error())
			case storagegateway.ErrCodeInternalServerError:
				fmt.Println(storagegateway.ErrCodeInternalServerError, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list tags that have been added to a resource
//
// Lists the tags that have been added to the specified resource.
func ExampleClient_ListTagsForResourceRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := storagegateway.New(cfg)
	input := &storagegateway.ListTagsForResourceInput{
		Limit:       aws.Int64(1),
		Marker:      aws.String("1"),
		ResourceARN: aws.String("arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-11A2222B"),
	}

	req := svc.ListTagsForResourceRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case storagegateway.ErrCodeInvalidGatewayRequestException:
				fmt.Println(storagegateway.ErrCodeInvalidGatewayRequestException, aerr.Error())
			case storagegateway.ErrCodeInternalServerError:
				fmt.Println(storagegateway.ErrCodeInternalServerError, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list recovery points for a gateway
//
// Lists the recovery points for a specified gateway in which all data of the volume
// is consistent and can be used to create a snapshot.
func ExampleClient_ListVolumeRecoveryPointsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := storagegateway.New(cfg)
	input := &storagegateway.ListVolumeRecoveryPointsInput{
		GatewayARN: aws.String("arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B"),
	}

	req := svc.ListVolumeRecoveryPointsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case storagegateway.ErrCodeInvalidGatewayRequestException:
				fmt.Println(storagegateway.ErrCodeInvalidGatewayRequestException, aerr.Error())
			case storagegateway.ErrCodeInternalServerError:
				fmt.Println(storagegateway.ErrCodeInternalServerError, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list the iSCSI stored volumes of a gateway
//
// Lists the iSCSI stored volumes of a gateway. Results are sorted by volume ARN up
// to a maximum of 100 volumes.
func ExampleClient_ListVolumesRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := storagegateway.New(cfg)
	input := &storagegateway.ListVolumesInput{
		GatewayARN: aws.String("arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B"),
		Limit:      aws.Int64(2),
		Marker:     aws.String("1"),
	}

	req := svc.ListVolumesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case storagegateway.ErrCodeInvalidGatewayRequestException:
				fmt.Println(storagegateway.ErrCodeInvalidGatewayRequestException, aerr.Error())
			case storagegateway.ErrCodeInternalServerError:
				fmt.Println(storagegateway.ErrCodeInternalServerError, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To remove tags from a resource
//
// Lists the iSCSI stored volumes of a gateway. Removes one or more tags from the specified
// resource.
func ExampleClient_RemoveTagsFromResourceRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := storagegateway.New(cfg)
	input := &storagegateway.RemoveTagsFromResourceInput{
		ResourceARN: aws.String("arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-11A2222B"),
		TagKeys: []string{
			"Dev Gatgeway Region",
			"East Coast",
		},
	}

	req := svc.RemoveTagsFromResourceRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case storagegateway.ErrCodeInvalidGatewayRequestException:
				fmt.Println(storagegateway.ErrCodeInvalidGatewayRequestException, aerr.Error())
			case storagegateway.ErrCodeInternalServerError:
				fmt.Println(storagegateway.ErrCodeInternalServerError, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To reset cache disks in error status
//
// Resets all cache disks that have encountered a error and makes the disks available
// for reconfiguration as cache storage.
func ExampleClient_ResetCacheRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := storagegateway.New(cfg)
	input := &storagegateway.ResetCacheInput{
		GatewayARN: aws.String("arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-13B4567C"),
	}

	req := svc.ResetCacheRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case storagegateway.ErrCodeInvalidGatewayRequestException:
				fmt.Println(storagegateway.ErrCodeInvalidGatewayRequestException, aerr.Error())
			case storagegateway.ErrCodeInternalServerError:
				fmt.Println(storagegateway.ErrCodeInternalServerError, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To retrieve an archived tape from the VTS
//
// Retrieves an archived virtual tape from the virtual tape shelf (VTS) to a gateway-VTL.
// Virtual tapes archived in the VTS are not associated with any gateway.
func ExampleClient_RetrieveTapeArchiveRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := storagegateway.New(cfg)
	input := &storagegateway.RetrieveTapeArchiveInput{
		GatewayARN: aws.String("arn:aws:storagegateway:us-east-1:999999999999:gateway/sgw-12A3456B"),
		TapeARN:    aws.String("arn:aws:storagegateway:us-east-1:999999999999:tape/TEST0AA2AF"),
	}

	req := svc.RetrieveTapeArchiveRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case storagegateway.ErrCodeInvalidGatewayRequestException:
				fmt.Println(storagegateway.ErrCodeInvalidGatewayRequestException, aerr.Error())
			case storagegateway.ErrCodeInternalServerError:
				fmt.Println(storagegateway.ErrCodeInternalServerError, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To retrieve the recovery point of a virtual tape
//
// Retrieves the recovery point for the specified virtual tape.
func ExampleClient_RetrieveTapeRecoveryPointRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := storagegateway.New(cfg)
	input := &storagegateway.RetrieveTapeRecoveryPointInput{
		GatewayARN: aws.String("arn:aws:storagegateway:us-east-1:999999999999:gateway/sgw-12A3456B"),
		TapeARN:    aws.String("arn:aws:storagegateway:us-east-1:999999999999:tape/TEST0AA2AF"),
	}

	req := svc.RetrieveTapeRecoveryPointRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case storagegateway.ErrCodeInvalidGatewayRequestException:
				fmt.Println(storagegateway.ErrCodeInvalidGatewayRequestException, aerr.Error())
			case storagegateway.ErrCodeInternalServerError:
				fmt.Println(storagegateway.ErrCodeInternalServerError, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To set a password for your VM
//
// Sets the password for your VM local console.
func ExampleClient_SetLocalConsolePasswordRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := storagegateway.New(cfg)
	input := &storagegateway.SetLocalConsolePasswordInput{
		GatewayARN:           aws.String("arn:aws:storagegateway:us-east-1:999999999999:gateway/sgw-12A3456B"),
		LocalConsolePassword: aws.String("PassWordMustBeAtLeast6Chars."),
	}

	req := svc.SetLocalConsolePasswordRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case storagegateway.ErrCodeInvalidGatewayRequestException:
				fmt.Println(storagegateway.ErrCodeInvalidGatewayRequestException, aerr.Error())
			case storagegateway.ErrCodeInternalServerError:
				fmt.Println(storagegateway.ErrCodeInternalServerError, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To shut down a gateway service
//
// This operation shuts down the gateway service component running in the storage gateway's
// virtual machine (VM) and not the VM.
func ExampleClient_ShutdownGatewayRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := storagegateway.New(cfg)
	input := &storagegateway.ShutdownGatewayInput{
		GatewayARN: aws.String("arn:aws:storagegateway:us-east-1:999999999999:gateway/sgw-12A3456B"),
	}

	req := svc.ShutdownGatewayRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case storagegateway.ErrCodeInvalidGatewayRequestException:
				fmt.Println(storagegateway.ErrCodeInvalidGatewayRequestException, aerr.Error())
			case storagegateway.ErrCodeInternalServerError:
				fmt.Println(storagegateway.ErrCodeInternalServerError, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To start a gateway service
//
// Starts a gateway service that was previously shut down.
func ExampleClient_StartGatewayRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := storagegateway.New(cfg)
	input := &storagegateway.StartGatewayInput{
		GatewayARN: aws.String("arn:aws:storagegateway:us-east-1:999999999999:gateway/sgw-12A3456B"),
	}

	req := svc.StartGatewayRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case storagegateway.ErrCodeInvalidGatewayRequestException:
				fmt.Println(storagegateway.ErrCodeInvalidGatewayRequestException, aerr.Error())
			case storagegateway.ErrCodeInternalServerError:
				fmt.Println(storagegateway.ErrCodeInternalServerError, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To update the bandwidth rate limits of a gateway
//
// Updates the bandwidth rate limits of a gateway. Both the upload and download bandwidth
// rate limit can be set, or either one of the two. If a new limit is not set, the existing
// rate limit remains.
func ExampleClient_UpdateBandwidthRateLimitRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := storagegateway.New(cfg)
	input := &storagegateway.UpdateBandwidthRateLimitInput{
		AverageDownloadRateLimitInBitsPerSec: aws.Int64(102400),
		AverageUploadRateLimitInBitsPerSec:   aws.Int64(51200),
		GatewayARN:                           aws.String("arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B"),
	}

	req := svc.UpdateBandwidthRateLimitRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case storagegateway.ErrCodeInvalidGatewayRequestException:
				fmt.Println(storagegateway.ErrCodeInvalidGatewayRequestException, aerr.Error())
			case storagegateway.ErrCodeInternalServerError:
				fmt.Println(storagegateway.ErrCodeInternalServerError, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To update CHAP credentials for an iSCSI target
//
// Updates the Challenge-Handshake Authentication Protocol (CHAP) credentials for a
// specified iSCSI target.
func ExampleClient_UpdateChapCredentialsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := storagegateway.New(cfg)
	input := &storagegateway.UpdateChapCredentialsInput{
		InitiatorName:                 aws.String("iqn.1991-05.com.microsoft:computername.domain.example.com"),
		SecretToAuthenticateInitiator: aws.String("111111111111"),
		SecretToAuthenticateTarget:    aws.String("222222222222"),
		TargetARN:                     aws.String("arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume"),
	}

	req := svc.UpdateChapCredentialsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case storagegateway.ErrCodeInvalidGatewayRequestException:
				fmt.Println(storagegateway.ErrCodeInvalidGatewayRequestException, aerr.Error())
			case storagegateway.ErrCodeInternalServerError:
				fmt.Println(storagegateway.ErrCodeInternalServerError, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To update a gateway's metadata
//
// Updates a gateway's metadata, which includes the gateway's name and time zone.
func ExampleClient_UpdateGatewayInformationRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := storagegateway.New(cfg)
	input := &storagegateway.UpdateGatewayInformationInput{
		GatewayARN:      aws.String("arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B"),
		GatewayName:     aws.String("MyGateway2"),
		GatewayTimezone: aws.String("GMT-12:00"),
	}

	req := svc.UpdateGatewayInformationRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case storagegateway.ErrCodeInvalidGatewayRequestException:
				fmt.Println(storagegateway.ErrCodeInvalidGatewayRequestException, aerr.Error())
			case storagegateway.ErrCodeInternalServerError:
				fmt.Println(storagegateway.ErrCodeInternalServerError, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To update a gateway's VM software
//
// Updates the gateway virtual machine (VM) software. The request immediately triggers
// the software update.
func ExampleClient_UpdateGatewaySoftwareNowRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := storagegateway.New(cfg)
	input := &storagegateway.UpdateGatewaySoftwareNowInput{
		GatewayARN: aws.String("arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B"),
	}

	req := svc.UpdateGatewaySoftwareNowRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case storagegateway.ErrCodeInvalidGatewayRequestException:
				fmt.Println(storagegateway.ErrCodeInvalidGatewayRequestException, aerr.Error())
			case storagegateway.ErrCodeInternalServerError:
				fmt.Println(storagegateway.ErrCodeInternalServerError, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To update a gateway's maintenance start time
//
// Updates a gateway's weekly maintenance start time information, including day and
// time of the week. The maintenance time is in your gateway's time zone.
func ExampleClient_UpdateMaintenanceStartTimeRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := storagegateway.New(cfg)
	input := &storagegateway.UpdateMaintenanceStartTimeInput{
		DayOfWeek:    aws.Int64(2),
		GatewayARN:   aws.String("arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B"),
		HourOfDay:    aws.Int64(0),
		MinuteOfHour: aws.Int64(30),
	}

	req := svc.UpdateMaintenanceStartTimeRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case storagegateway.ErrCodeInvalidGatewayRequestException:
				fmt.Println(storagegateway.ErrCodeInvalidGatewayRequestException, aerr.Error())
			case storagegateway.ErrCodeInternalServerError:
				fmt.Println(storagegateway.ErrCodeInternalServerError, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To update a volume snapshot schedule
//
// Updates a snapshot schedule configured for a gateway volume.
func ExampleClient_UpdateSnapshotScheduleRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := storagegateway.New(cfg)
	input := &storagegateway.UpdateSnapshotScheduleInput{
		Description:       aws.String("Hourly snapshot"),
		RecurrenceInHours: aws.Int64(1),
		StartAt:           aws.Int64(0),
		VolumeARN:         aws.String("arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B/volume/vol-1122AABB"),
	}

	req := svc.UpdateSnapshotScheduleRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case storagegateway.ErrCodeInvalidGatewayRequestException:
				fmt.Println(storagegateway.ErrCodeInvalidGatewayRequestException, aerr.Error())
			case storagegateway.ErrCodeInternalServerError:
				fmt.Println(storagegateway.ErrCodeInternalServerError, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To update a VTL device type
//
// Updates the type of medium changer in a gateway-VTL after a gateway-VTL is activated.
func ExampleClient_UpdateVTLDeviceTypeRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := storagegateway.New(cfg)
	input := &storagegateway.UpdateVTLDeviceTypeInput{
		DeviceType:   aws.String("Medium Changer"),
		VTLDeviceARN: aws.String("arn:aws:storagegateway:us-east-1:999999999999:gateway/sgw-12A3456B/device/AMZN_SGW-1FAD4876_MEDIACHANGER_00001"),
	}

	req := svc.UpdateVTLDeviceTypeRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case storagegateway.ErrCodeInvalidGatewayRequestException:
				fmt.Println(storagegateway.ErrCodeInvalidGatewayRequestException, aerr.Error())
			case storagegateway.ErrCodeInternalServerError:
				fmt.Println(storagegateway.ErrCodeInternalServerError, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}
