// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sagemaker

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type SearchInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return in a SearchResponse.
	MaxResults *int64 `min:"1" type:"integer"`

	// If more than MaxResults resource objects match the specified SearchExpression,
	// the SearchResponse includes a NextToken. The NextToken can be passed to the
	// next SearchRequest to continue retrieving results for the specified SearchExpression
	// and Sort parameters.
	NextToken *string `type:"string"`

	// The name of the Amazon SageMaker resource to search for. Currently, the only
	// valid Resource value is TrainingJob.
	//
	// Resource is a required field
	Resource ResourceType `type:"string" required:"true" enum:"true"`

	// A Boolean conditional statement. Resource objects must satisfy this condition
	// to be included in search results. You must provide at least one subexpression,
	// filter, or nested filter. The maximum number of recursive SubExpressions,
	// NestedFilters, and Filters that can be included in a SearchExpression object
	// is 50.
	SearchExpression *SearchExpression `type:"structure"`

	// The name of the resource property used to sort the SearchResults. The default
	// is LastModifiedTime.
	SortBy *string `min:"1" type:"string"`

	// How SearchResults are ordered. Valid values are Ascending or Descending.
	// The default is Descending.
	SortOrder SearchSortOrder `type:"string" enum:"true"`
}

// String returns the string representation
func (s SearchInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SearchInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if len(s.Resource) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Resource"))
	}
	if s.SortBy != nil && len(*s.SortBy) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SortBy", 1))
	}
	if s.SearchExpression != nil {
		if err := s.SearchExpression.Validate(); err != nil {
			invalidParams.AddNested("SearchExpression", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type SearchOutput struct {
	_ struct{} `type:"structure"`

	// If the result of the previous Search request was truncated, the response
	// includes a NextToken. To retrieve the next set of results, use the token
	// in the next request.
	NextToken *string `type:"string"`

	// A list of SearchResult objects.
	Results []SearchRecord `type:"list"`
}

// String returns the string representation
func (s SearchOutput) String() string {
	return awsutil.Prettify(s)
}

const opSearch = "Search"

// SearchRequest returns a request value for making API operation for
// Amazon SageMaker Service.
//
// Finds Amazon SageMaker resources that match a search query. Matching resource
// objects are returned as a list of SearchResult objects in the response. You
// can sort the search results by any resource property in a ascending or descending
// order.
//
// You can query against the following value types: numerical, text, Booleans,
// and timestamps.
//
//    // Example sending a request using SearchRequest.
//    req := client.SearchRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/Search
func (c *Client) SearchRequest(input *SearchInput) SearchRequest {
	op := &aws.Operation{
		Name:       opSearch,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchInput{}
	}

	req := c.newRequest(op, input, &SearchOutput{})
	return SearchRequest{Request: req, Input: input, Copy: c.SearchRequest}
}

// SearchRequest is the request type for the
// Search API operation.
type SearchRequest struct {
	*aws.Request
	Input *SearchInput
	Copy  func(*SearchInput) SearchRequest
}

// Send marshals and sends the Search API request.
func (r SearchRequest) Send(ctx context.Context) (*SearchResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &SearchResponse{
		SearchOutput: r.Request.Data.(*SearchOutput),
		response:     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewSearchRequestPaginator returns a paginator for Search.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.SearchRequest(input)
//   p := sagemaker.NewSearchRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewSearchPaginator(req SearchRequest) SearchPaginator {
	return SearchPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *SearchInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// SearchPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type SearchPaginator struct {
	aws.Pager
}

func (p *SearchPaginator) CurrentPage() *SearchOutput {
	return p.Pager.CurrentPage().(*SearchOutput)
}

// SearchResponse is the response type for the
// Search API operation.
type SearchResponse struct {
	*SearchOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// Search request.
func (r *SearchResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
