// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package route53

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// A request to get information about a specified hosted zone.
type GetHostedZoneInput struct {
	_ struct{} `type:"structure"`

	// The ID of the hosted zone that you want to get information about.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetHostedZoneInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetHostedZoneInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetHostedZoneInput"}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetHostedZoneInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Id", protocol.StringValue(v), metadata)
	}
	return nil
}

// A complex type that contain the response to a GetHostedZone request.
type GetHostedZoneOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that lists the Amazon Route 53 name servers for the specified
	// hosted zone.
	DelegationSet *DelegationSet `type:"structure"`

	// A complex type that contains general information about the specified hosted
	// zone.
	//
	// HostedZone is a required field
	HostedZone *HostedZone `type:"structure" required:"true"`

	// A complex type that contains information about the VPCs that are associated
	// with the specified hosted zone.
	VPCs []VPC `locationNameList:"VPC" min:"1" type:"list"`
}

// String returns the string representation
func (s GetHostedZoneOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetHostedZoneOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.DelegationSet != nil {
		v := s.DelegationSet

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "DelegationSet", v, metadata)
	}
	if s.HostedZone != nil {
		v := s.HostedZone

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "HostedZone", v, metadata)
	}
	if s.VPCs != nil {
		v := s.VPCs

		metadata := protocol.Metadata{ListLocationName: "VPC"}
		ls0 := e.List(protocol.BodyTarget, "VPCs", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opGetHostedZone = "GetHostedZone"

// GetHostedZoneRequest returns a request value for making API operation for
// Amazon Route 53.
//
// Gets information about a specified hosted zone including the four name servers
// assigned to the hosted zone.
//
//    // Example sending a request using GetHostedZoneRequest.
//    req := client.GetHostedZoneRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetHostedZone
func (c *Client) GetHostedZoneRequest(input *GetHostedZoneInput) GetHostedZoneRequest {
	op := &aws.Operation{
		Name:       opGetHostedZone,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/hostedzone/{Id}",
	}

	if input == nil {
		input = &GetHostedZoneInput{}
	}

	req := c.newRequest(op, input, &GetHostedZoneOutput{})
	return GetHostedZoneRequest{Request: req, Input: input, Copy: c.GetHostedZoneRequest}
}

// GetHostedZoneRequest is the request type for the
// GetHostedZone API operation.
type GetHostedZoneRequest struct {
	*aws.Request
	Input *GetHostedZoneInput
	Copy  func(*GetHostedZoneInput) GetHostedZoneRequest
}

// Send marshals and sends the GetHostedZone API request.
func (r GetHostedZoneRequest) Send(ctx context.Context) (*GetHostedZoneResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetHostedZoneResponse{
		GetHostedZoneOutput: r.Request.Data.(*GetHostedZoneOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetHostedZoneResponse is the response type for the
// GetHostedZone API operation.
type GetHostedZoneResponse struct {
	*GetHostedZoneOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetHostedZone request.
func (r *GetHostedZoneResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
