// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package pinpoint

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type UpdateEmailChannelInput struct {
	_ struct{} `type:"structure" payload:"EmailChannelRequest"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// Specifies the status and settings of the email channel for an application.
	//
	// EmailChannelRequest is a required field
	EmailChannelRequest *EmailChannelRequest `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateEmailChannelInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateEmailChannelInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateEmailChannelInput"}

	if s.ApplicationId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApplicationId"))
	}

	if s.EmailChannelRequest == nil {
		invalidParams.Add(aws.NewErrParamRequired("EmailChannelRequest"))
	}
	if s.EmailChannelRequest != nil {
		if err := s.EmailChannelRequest.Validate(); err != nil {
			invalidParams.AddNested("EmailChannelRequest", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateEmailChannelInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "application-id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.EmailChannelRequest != nil {
		v := s.EmailChannelRequest

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "EmailChannelRequest", v, metadata)
	}
	return nil
}

type UpdateEmailChannelOutput struct {
	_ struct{} `type:"structure" payload:"EmailChannelResponse"`

	// Provides information about the status and settings of the email channel for
	// an application.
	//
	// EmailChannelResponse is a required field
	EmailChannelResponse *EmailChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateEmailChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateEmailChannelOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.EmailChannelResponse != nil {
		v := s.EmailChannelResponse

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "EmailChannelResponse", v, metadata)
	}
	return nil
}

const opUpdateEmailChannel = "UpdateEmailChannel"

// UpdateEmailChannelRequest returns a request value for making API operation for
// Amazon Pinpoint.
//
// Enables the email channel for an application or updates the status and settings
// of the email channel for an application.
//
//    // Example sending a request using UpdateEmailChannelRequest.
//    req := client.UpdateEmailChannelRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateEmailChannel
func (c *Client) UpdateEmailChannelRequest(input *UpdateEmailChannelInput) UpdateEmailChannelRequest {
	op := &aws.Operation{
		Name:       opUpdateEmailChannel,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/apps/{application-id}/channels/email",
	}

	if input == nil {
		input = &UpdateEmailChannelInput{}
	}

	req := c.newRequest(op, input, &UpdateEmailChannelOutput{})
	return UpdateEmailChannelRequest{Request: req, Input: input, Copy: c.UpdateEmailChannelRequest}
}

// UpdateEmailChannelRequest is the request type for the
// UpdateEmailChannel API operation.
type UpdateEmailChannelRequest struct {
	*aws.Request
	Input *UpdateEmailChannelInput
	Copy  func(*UpdateEmailChannelInput) UpdateEmailChannelRequest
}

// Send marshals and sends the UpdateEmailChannel API request.
func (r UpdateEmailChannelRequest) Send(ctx context.Context) (*UpdateEmailChannelResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateEmailChannelResponse{
		UpdateEmailChannelOutput: r.Request.Data.(*UpdateEmailChannelOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateEmailChannelResponse is the response type for the
// UpdateEmailChannel API operation.
type UpdateEmailChannelResponse struct {
	*UpdateEmailChannelOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateEmailChannel request.
func (r *UpdateEmailChannelResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
