// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package glacier

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restjson"
)

// The input value for RemoveTagsFromVaultInput.
type RemoveTagsFromVaultInput struct {
	_ struct{} `type:"structure"`

	// The AccountId value is the AWS account ID of the account that owns the vault.
	// You can either specify an AWS account ID or optionally a single '-' (hyphen),
	// in which case Amazon S3 Glacier uses the AWS account ID associated with the
	// credentials used to sign the request. If you use an account ID, do not include
	// any hyphens ('-') in the ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// A list of tag keys. Each corresponding tag is removed from the vault.
	TagKeys []string `type:"list"`

	// The name of the vault.
	//
	// VaultName is a required field
	VaultName *string `location:"uri" locationName:"vaultName" type:"string" required:"true"`
}

// String returns the string representation
func (s RemoveTagsFromVaultInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveTagsFromVaultInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RemoveTagsFromVaultInput"}

	if s.AccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AccountId"))
	}

	if s.VaultName == nil {
		invalidParams.Add(aws.NewErrParamRequired("VaultName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RemoveTagsFromVaultInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.TagKeys != nil {
		v := s.TagKeys

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "TagKeys", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "accountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VaultName != nil {
		v := *s.VaultName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "vaultName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type RemoveTagsFromVaultOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RemoveTagsFromVaultOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RemoveTagsFromVaultOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opRemoveTagsFromVault = "RemoveTagsFromVault"

// RemoveTagsFromVaultRequest returns a request value for making API operation for
// Amazon Glacier.
//
// This operation removes one or more tags from the set of tags attached to
// a vault. For more information about tags, see Tagging Amazon S3 Glacier Resources
// (https://docs.aws.amazon.com/amazonglacier/latest/dev/tagging.html). This
// operation is idempotent. The operation will be successful, even if there
// are no tags attached to the vault.
//
//    // Example sending a request using RemoveTagsFromVaultRequest.
//    req := client.RemoveTagsFromVaultRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) RemoveTagsFromVaultRequest(input *RemoveTagsFromVaultInput) RemoveTagsFromVaultRequest {
	op := &aws.Operation{
		Name:       opRemoveTagsFromVault,
		HTTPMethod: "POST",
		HTTPPath:   "/{accountId}/vaults/{vaultName}/tags?operation=remove",
	}

	if input == nil {
		input = &RemoveTagsFromVaultInput{}
	}

	req := c.newRequest(op, input, &RemoveTagsFromVaultOutput{})
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return RemoveTagsFromVaultRequest{Request: req, Input: input, Copy: c.RemoveTagsFromVaultRequest}
}

// RemoveTagsFromVaultRequest is the request type for the
// RemoveTagsFromVault API operation.
type RemoveTagsFromVaultRequest struct {
	*aws.Request
	Input *RemoveTagsFromVaultInput
	Copy  func(*RemoveTagsFromVaultInput) RemoveTagsFromVaultRequest
}

// Send marshals and sends the RemoveTagsFromVault API request.
func (r RemoveTagsFromVaultRequest) Send(ctx context.Context) (*RemoveTagsFromVaultResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RemoveTagsFromVaultResponse{
		RemoveTagsFromVaultOutput: r.Request.Data.(*RemoveTagsFromVaultOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RemoveTagsFromVaultResponse is the response type for the
// RemoveTagsFromVault API operation.
type RemoveTagsFromVaultResponse struct {
	*RemoveTagsFromVaultOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RemoveTagsFromVault request.
func (r *RemoveTagsFromVaultResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
