// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package forecast

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeForecastExportJobInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the forecast export job.
	//
	// ForecastExportJobArn is a required field
	ForecastExportJobArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeForecastExportJobInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeForecastExportJobInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeForecastExportJobInput"}

	if s.ForecastExportJobArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("ForecastExportJobArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeForecastExportJobOutput struct {
	_ struct{} `type:"structure"`

	// When the forecast export job was created.
	CreationTime *time.Time `type:"timestamp"`

	// The path to the Amazon Simple Storage Service (Amazon S3) bucket where the
	// forecast is exported.
	Destination *DataDestination `type:"structure"`

	// The Amazon Resource Name (ARN) of the exported forecast.
	ForecastArn *string `type:"string"`

	// The ARN of the forecast export job.
	ForecastExportJobArn *string `type:"string"`

	// The name of the forecast export job.
	ForecastExportJobName *string `min:"1" type:"string"`

	// When the last successful export job finished.
	LastModificationTime *time.Time `type:"timestamp"`

	// If an error occurred, an informational message about the error.
	Message *string `type:"string"`

	// The status of the forecast export job. States include:
	//
	//    * ACTIVE
	//
	//    * CREATE_PENDING, CREATE_IN_PROGRESS, CREATE_FAILED
	//
	//    * DELETE_PENDING, DELETE_IN_PROGRESS, DELETE_FAILED
	//
	// The Status of the forecast export job must be ACTIVE before you can access
	// the forecast in your S3 bucket.
	Status *string `type:"string"`
}

// String returns the string representation
func (s DescribeForecastExportJobOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeForecastExportJob = "DescribeForecastExportJob"

// DescribeForecastExportJobRequest returns a request value for making API operation for
// Amazon Forecast Service.
//
// Describes a forecast export job created using the CreateForecastExportJob
// operation.
//
// In addition to listing the properties provided by the user in the CreateForecastExportJob
// request, this operation lists the following properties:
//
//    * CreationTime
//
//    * LastModificationTime
//
//    * Status
//
//    * Message - If an error occurred, information about the error.
//
//    // Example sending a request using DescribeForecastExportJobRequest.
//    req := client.DescribeForecastExportJobRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/DescribeForecastExportJob
func (c *Client) DescribeForecastExportJobRequest(input *DescribeForecastExportJobInput) DescribeForecastExportJobRequest {
	op := &aws.Operation{
		Name:       opDescribeForecastExportJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeForecastExportJobInput{}
	}

	req := c.newRequest(op, input, &DescribeForecastExportJobOutput{})
	return DescribeForecastExportJobRequest{Request: req, Input: input, Copy: c.DescribeForecastExportJobRequest}
}

// DescribeForecastExportJobRequest is the request type for the
// DescribeForecastExportJob API operation.
type DescribeForecastExportJobRequest struct {
	*aws.Request
	Input *DescribeForecastExportJobInput
	Copy  func(*DescribeForecastExportJobInput) DescribeForecastExportJobRequest
}

// Send marshals and sends the DescribeForecastExportJob API request.
func (r DescribeForecastExportJobRequest) Send(ctx context.Context) (*DescribeForecastExportJobResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeForecastExportJobResponse{
		DescribeForecastExportJobOutput: r.Request.Data.(*DescribeForecastExportJobOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeForecastExportJobResponse is the response type for the
// DescribeForecastExportJob API operation.
type DescribeForecastExportJobResponse struct {
	*DescribeForecastExportJobOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeForecastExportJob request.
func (r *DescribeForecastExportJobResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
