// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package fms

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListMemberAccountsInput struct {
	_ struct{} `type:"structure"`

	// Specifies the number of member account IDs that you want AWS Firewall Manager
	// to return for this request. If you have more IDs than the number that you
	// specify for MaxResults, the response includes a NextToken value that you
	// can use to get another batch of member account IDs.
	MaxResults *int64 `min:"1" type:"integer"`

	// If you specify a value for MaxResults and you have more account IDs than
	// the number that you specify for MaxResults, AWS Firewall Manager returns
	// a NextToken value in the response that allows you to list another group of
	// IDs. For the second and subsequent ListMemberAccountsRequest requests, specify
	// the value of NextToken from the previous response to get information about
	// another batch of member account IDs.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListMemberAccountsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListMemberAccountsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListMemberAccountsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListMemberAccountsOutput struct {
	_ struct{} `type:"structure"`

	// An array of account IDs.
	MemberAccounts []string `type:"list"`

	// If you have more member account IDs than the number that you specified for
	// MaxResults in the request, the response includes a NextToken value. To list
	// more IDs, submit another ListMemberAccounts request, and specify the NextToken
	// value from the response in the NextToken value in the next request.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListMemberAccountsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListMemberAccounts = "ListMemberAccounts"

// ListMemberAccountsRequest returns a request value for making API operation for
// Firewall Management Service.
//
// Returns a MemberAccounts object that lists the member accounts in the administrator's
// AWS organization.
//
// The ListMemberAccounts must be submitted by the account that is set as the
// AWS Firewall Manager administrator.
//
//    // Example sending a request using ListMemberAccountsRequest.
//    req := client.ListMemberAccountsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/ListMemberAccounts
func (c *Client) ListMemberAccountsRequest(input *ListMemberAccountsInput) ListMemberAccountsRequest {
	op := &aws.Operation{
		Name:       opListMemberAccounts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMemberAccountsInput{}
	}

	req := c.newRequest(op, input, &ListMemberAccountsOutput{})
	return ListMemberAccountsRequest{Request: req, Input: input, Copy: c.ListMemberAccountsRequest}
}

// ListMemberAccountsRequest is the request type for the
// ListMemberAccounts API operation.
type ListMemberAccountsRequest struct {
	*aws.Request
	Input *ListMemberAccountsInput
	Copy  func(*ListMemberAccountsInput) ListMemberAccountsRequest
}

// Send marshals and sends the ListMemberAccounts API request.
func (r ListMemberAccountsRequest) Send(ctx context.Context) (*ListMemberAccountsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListMemberAccountsResponse{
		ListMemberAccountsOutput: r.Request.Data.(*ListMemberAccountsOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListMemberAccountsRequestPaginator returns a paginator for ListMemberAccounts.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListMemberAccountsRequest(input)
//   p := fms.NewListMemberAccountsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListMemberAccountsPaginator(req ListMemberAccountsRequest) ListMemberAccountsPaginator {
	return ListMemberAccountsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListMemberAccountsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListMemberAccountsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListMemberAccountsPaginator struct {
	aws.Pager
}

func (p *ListMemberAccountsPaginator) CurrentPage() *ListMemberAccountsOutput {
	return p.Pager.CurrentPage().(*ListMemberAccountsOutput)
}

// ListMemberAccountsResponse is the response type for the
// ListMemberAccounts API operation.
type ListMemberAccountsResponse struct {
	*ListMemberAccountsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListMemberAccounts request.
func (r *ListMemberAccountsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
