// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package elasticbeanstalkiface provides an interface to enable mocking the AWS Elastic Beanstalk service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package elasticbeanstalkiface

import (
	"github.com/aws/aws-sdk-go-v2/service/elasticbeanstalk"
)

// ClientAPI provides an interface to enable mocking the
// elasticbeanstalk.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // Elastic Beanstalk.
//    func myFunc(svc elasticbeanstalkiface.ClientAPI) bool {
//        // Make svc.AbortEnvironmentUpdate request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := elasticbeanstalk.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        elasticbeanstalkiface.ClientPI
//    }
//    func (m *mockClientClient) AbortEnvironmentUpdate(input *elasticbeanstalk.AbortEnvironmentUpdateInput) (*elasticbeanstalk.AbortEnvironmentUpdateOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	AbortEnvironmentUpdateRequest(*elasticbeanstalk.AbortEnvironmentUpdateInput) elasticbeanstalk.AbortEnvironmentUpdateRequest

	ApplyEnvironmentManagedActionRequest(*elasticbeanstalk.ApplyEnvironmentManagedActionInput) elasticbeanstalk.ApplyEnvironmentManagedActionRequest

	CheckDNSAvailabilityRequest(*elasticbeanstalk.CheckDNSAvailabilityInput) elasticbeanstalk.CheckDNSAvailabilityRequest

	ComposeEnvironmentsRequest(*elasticbeanstalk.ComposeEnvironmentsInput) elasticbeanstalk.ComposeEnvironmentsRequest

	CreateApplicationRequest(*elasticbeanstalk.CreateApplicationInput) elasticbeanstalk.CreateApplicationRequest

	CreateApplicationVersionRequest(*elasticbeanstalk.CreateApplicationVersionInput) elasticbeanstalk.CreateApplicationVersionRequest

	CreateConfigurationTemplateRequest(*elasticbeanstalk.CreateConfigurationTemplateInput) elasticbeanstalk.CreateConfigurationTemplateRequest

	CreateEnvironmentRequest(*elasticbeanstalk.CreateEnvironmentInput) elasticbeanstalk.CreateEnvironmentRequest

	CreatePlatformVersionRequest(*elasticbeanstalk.CreatePlatformVersionInput) elasticbeanstalk.CreatePlatformVersionRequest

	CreateStorageLocationRequest(*elasticbeanstalk.CreateStorageLocationInput) elasticbeanstalk.CreateStorageLocationRequest

	DeleteApplicationRequest(*elasticbeanstalk.DeleteApplicationInput) elasticbeanstalk.DeleteApplicationRequest

	DeleteApplicationVersionRequest(*elasticbeanstalk.DeleteApplicationVersionInput) elasticbeanstalk.DeleteApplicationVersionRequest

	DeleteConfigurationTemplateRequest(*elasticbeanstalk.DeleteConfigurationTemplateInput) elasticbeanstalk.DeleteConfigurationTemplateRequest

	DeleteEnvironmentConfigurationRequest(*elasticbeanstalk.DeleteEnvironmentConfigurationInput) elasticbeanstalk.DeleteEnvironmentConfigurationRequest

	DeletePlatformVersionRequest(*elasticbeanstalk.DeletePlatformVersionInput) elasticbeanstalk.DeletePlatformVersionRequest

	DescribeAccountAttributesRequest(*elasticbeanstalk.DescribeAccountAttributesInput) elasticbeanstalk.DescribeAccountAttributesRequest

	DescribeApplicationVersionsRequest(*elasticbeanstalk.DescribeApplicationVersionsInput) elasticbeanstalk.DescribeApplicationVersionsRequest

	DescribeApplicationsRequest(*elasticbeanstalk.DescribeApplicationsInput) elasticbeanstalk.DescribeApplicationsRequest

	DescribeConfigurationOptionsRequest(*elasticbeanstalk.DescribeConfigurationOptionsInput) elasticbeanstalk.DescribeConfigurationOptionsRequest

	DescribeConfigurationSettingsRequest(*elasticbeanstalk.DescribeConfigurationSettingsInput) elasticbeanstalk.DescribeConfigurationSettingsRequest

	DescribeEnvironmentHealthRequest(*elasticbeanstalk.DescribeEnvironmentHealthInput) elasticbeanstalk.DescribeEnvironmentHealthRequest

	DescribeEnvironmentManagedActionHistoryRequest(*elasticbeanstalk.DescribeEnvironmentManagedActionHistoryInput) elasticbeanstalk.DescribeEnvironmentManagedActionHistoryRequest

	DescribeEnvironmentManagedActionsRequest(*elasticbeanstalk.DescribeEnvironmentManagedActionsInput) elasticbeanstalk.DescribeEnvironmentManagedActionsRequest

	DescribeEnvironmentResourcesRequest(*elasticbeanstalk.DescribeEnvironmentResourcesInput) elasticbeanstalk.DescribeEnvironmentResourcesRequest

	DescribeEnvironmentsRequest(*elasticbeanstalk.DescribeEnvironmentsInput) elasticbeanstalk.DescribeEnvironmentsRequest

	DescribeEventsRequest(*elasticbeanstalk.DescribeEventsInput) elasticbeanstalk.DescribeEventsRequest

	DescribeInstancesHealthRequest(*elasticbeanstalk.DescribeInstancesHealthInput) elasticbeanstalk.DescribeInstancesHealthRequest

	DescribePlatformVersionRequest(*elasticbeanstalk.DescribePlatformVersionInput) elasticbeanstalk.DescribePlatformVersionRequest

	ListAvailableSolutionStacksRequest(*elasticbeanstalk.ListAvailableSolutionStacksInput) elasticbeanstalk.ListAvailableSolutionStacksRequest

	ListPlatformVersionsRequest(*elasticbeanstalk.ListPlatformVersionsInput) elasticbeanstalk.ListPlatformVersionsRequest

	ListTagsForResourceRequest(*elasticbeanstalk.ListTagsForResourceInput) elasticbeanstalk.ListTagsForResourceRequest

	RebuildEnvironmentRequest(*elasticbeanstalk.RebuildEnvironmentInput) elasticbeanstalk.RebuildEnvironmentRequest

	RequestEnvironmentInfoRequest(*elasticbeanstalk.RequestEnvironmentInfoInput) elasticbeanstalk.RequestEnvironmentInfoRequest

	RestartAppServerRequest(*elasticbeanstalk.RestartAppServerInput) elasticbeanstalk.RestartAppServerRequest

	RetrieveEnvironmentInfoRequest(*elasticbeanstalk.RetrieveEnvironmentInfoInput) elasticbeanstalk.RetrieveEnvironmentInfoRequest

	SwapEnvironmentCNAMEsRequest(*elasticbeanstalk.SwapEnvironmentCNAMEsInput) elasticbeanstalk.SwapEnvironmentCNAMEsRequest

	TerminateEnvironmentRequest(*elasticbeanstalk.TerminateEnvironmentInput) elasticbeanstalk.TerminateEnvironmentRequest

	UpdateApplicationRequest(*elasticbeanstalk.UpdateApplicationInput) elasticbeanstalk.UpdateApplicationRequest

	UpdateApplicationResourceLifecycleRequest(*elasticbeanstalk.UpdateApplicationResourceLifecycleInput) elasticbeanstalk.UpdateApplicationResourceLifecycleRequest

	UpdateApplicationVersionRequest(*elasticbeanstalk.UpdateApplicationVersionInput) elasticbeanstalk.UpdateApplicationVersionRequest

	UpdateConfigurationTemplateRequest(*elasticbeanstalk.UpdateConfigurationTemplateInput) elasticbeanstalk.UpdateConfigurationTemplateRequest

	UpdateEnvironmentRequest(*elasticbeanstalk.UpdateEnvironmentInput) elasticbeanstalk.UpdateEnvironmentRequest

	UpdateTagsForResourceRequest(*elasticbeanstalk.UpdateTagsForResourceInput) elasticbeanstalk.UpdateTagsForResourceRequest

	ValidateConfigurationSettingsRequest(*elasticbeanstalk.ValidateConfigurationSettingsInput) elasticbeanstalk.ValidateConfigurationSettingsRequest
}

var _ ClientAPI = (*elasticbeanstalk.Client)(nil)
