// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticache

import (
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

var _ aws.Config
var _ = awsutil.Prettify

// Describes an Availability Zone in which the cluster is launched.
type AvailabilityZone struct {
	_ struct{} `type:"structure"`

	// The name of the Availability Zone.
	Name *string `type:"string"`
}

// String returns the string representation
func (s AvailabilityZone) String() string {
	return awsutil.Prettify(s)
}

// Contains all of the attributes of a specific cluster.
type CacheCluster struct {
	_ struct{} `type:"structure"`

	// A flag that enables encryption at-rest when set to true.
	//
	// You cannot modify the value of AtRestEncryptionEnabled after the cluster
	// is created. To enable at-rest encryption on a cluster you must set AtRestEncryptionEnabled
	// to true when you create a cluster.
	//
	// Required: Only available when creating a replication group in an Amazon VPC
	// using redis version 3.2.6, 4.x or later.
	//
	// Default: false
	AtRestEncryptionEnabled *bool `type:"boolean"`

	// A flag that enables using an AuthToken (password) when issuing Redis commands.
	//
	// Default: false
	AuthTokenEnabled *bool `type:"boolean"`

	// The date the auth token was last modified
	AuthTokenLastModifiedDate *time.Time `type:"timestamp"`

	// This parameter is currently disabled.
	AutoMinorVersionUpgrade *bool `type:"boolean"`

	// The date and time when the cluster was created.
	CacheClusterCreateTime *time.Time `type:"timestamp"`

	// The user-supplied identifier of the cluster. This identifier is a unique
	// key that identifies a cluster.
	CacheClusterId *string `type:"string"`

	// The current state of this cluster, one of the following values: available,
	// creating, deleted, deleting, incompatible-network, modifying, rebooting cluster
	// nodes, restore-failed, or snapshotting.
	CacheClusterStatus *string `type:"string"`

	// The name of the compute and memory capacity node type for the cluster.
	//
	// The following node types are supported by ElastiCache. Generally speaking,
	// the current generation types provide more memory and computational power
	// at lower cost when compared to their equivalent previous generation counterparts.
	//
	//    * General purpose: Current generation: M5 node types: cache.m5.large,
	//    cache.m5.xlarge, cache.m5.2xlarge, cache.m5.4xlarge, cache.m5.12xlarge,
	//    cache.m5.24xlarge M4 node types: cache.m4.large, cache.m4.xlarge, cache.m4.2xlarge,
	//    cache.m4.4xlarge, cache.m4.10xlarge T2 node types: cache.t2.micro, cache.t2.small,
	//    cache.t2.medium Previous generation: (not recommended) T1 node types:
	//    cache.t1.micro M1 node types: cache.m1.small, cache.m1.medium, cache.m1.large,
	//    cache.m1.xlarge M3 node types: cache.m3.medium, cache.m3.large, cache.m3.xlarge,
	//    cache.m3.2xlarge
	//
	//    * Compute optimized: Previous generation: (not recommended) C1 node types:
	//    cache.c1.xlarge
	//
	//    * Memory optimized: Current generation: R5 node types: cache.r5.large,
	//    cache.r5.xlarge, cache.r5.2xlarge, cache.r5.4xlarge, cache.r5.12xlarge,
	//    cache.r5.24xlarge R4 node types: cache.r4.large, cache.r4.xlarge, cache.r4.2xlarge,
	//    cache.r4.4xlarge, cache.r4.8xlarge, cache.r4.16xlarge Previous generation:
	//    (not recommended) M2 node types: cache.m2.xlarge, cache.m2.2xlarge, cache.m2.4xlarge
	//    R3 node types: cache.r3.large, cache.r3.xlarge, cache.r3.2xlarge, cache.r3.4xlarge,
	//    cache.r3.8xlarge
	//
	// Additional node type info
	//
	//    * All current generation instance types are created in Amazon VPC by default.
	//
	//    * Redis append-only files (AOF) are not supported for T1 or T2 instances.
	//
	//    * Redis Multi-AZ with automatic failover is not supported on T1 instances.
	//
	//    * Redis configuration variables appendonly and appendfsync are not supported
	//    on Redis version 2.8.22 and later.
	CacheNodeType *string `type:"string"`

	// A list of cache nodes that are members of the cluster.
	CacheNodes []CacheNode `locationNameList:"CacheNode" type:"list"`

	// Status of the cache parameter group.
	CacheParameterGroup *CacheParameterGroupStatus `type:"structure"`

	// A list of cache security group elements, composed of name and status sub-elements.
	CacheSecurityGroups []CacheSecurityGroupMembership `locationNameList:"CacheSecurityGroup" type:"list"`

	// The name of the cache subnet group associated with the cluster.
	CacheSubnetGroupName *string `type:"string"`

	// The URL of the web page where you can download the latest ElastiCache client
	// library.
	ClientDownloadLandingPage *string `type:"string"`

	// Represents a Memcached cluster endpoint which, if Automatic Discovery is
	// enabled on the cluster, can be used by an application to connect to any node
	// in the cluster. The configuration endpoint will always have .cfg in it.
	//
	// Example: mem-3.9dvc4r.cfg.usw2.cache.amazonaws.com:11211
	ConfigurationEndpoint *Endpoint `type:"structure"`

	// The name of the cache engine (memcached or redis) to be used for this cluster.
	Engine *string `type:"string"`

	// The version of the cache engine that is used in this cluster.
	EngineVersion *string `type:"string"`

	// Describes a notification topic and its status. Notification topics are used
	// for publishing ElastiCache events to subscribers using Amazon Simple Notification
	// Service (SNS).
	NotificationConfiguration *NotificationConfiguration `type:"structure"`

	// The number of cache nodes in the cluster.
	//
	// For clusters running Redis, this value must be 1. For clusters running Memcached,
	// this value must be between 1 and 20.
	NumCacheNodes *int64 `type:"integer"`

	// A group of settings that are applied to the cluster in the future, or that
	// are currently being applied.
	PendingModifiedValues *PendingModifiedValues `type:"structure"`

	// The name of the Availability Zone in which the cluster is located or "Multiple"
	// if the cache nodes are located in different Availability Zones.
	PreferredAvailabilityZone *string `type:"string"`

	// Specifies the weekly time range during which maintenance on the cluster is
	// performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi
	// (24H Clock UTC). The minimum maintenance window is a 60 minute period.
	//
	// Valid values for ddd are:
	//
	//    * sun
	//
	//    * mon
	//
	//    * tue
	//
	//    * wed
	//
	//    * thu
	//
	//    * fri
	//
	//    * sat
	//
	// Example: sun:23:00-mon:01:30
	PreferredMaintenanceWindow *string `type:"string"`

	// The replication group to which this cluster belongs. If this field is empty,
	// the cluster is not associated with any replication group.
	ReplicationGroupId *string `type:"string"`

	// A list of VPC Security Groups associated with the cluster.
	SecurityGroups []SecurityGroupMembership `type:"list"`

	// The number of days for which ElastiCache retains automatic cluster snapshots
	// before deleting them. For example, if you set SnapshotRetentionLimit to 5,
	// a snapshot that was taken today is retained for 5 days before being deleted.
	//
	// If the value of SnapshotRetentionLimit is set to zero (0), backups are turned
	// off.
	SnapshotRetentionLimit *int64 `type:"integer"`

	// The daily time range (in UTC) during which ElastiCache begins taking a daily
	// snapshot of your cluster.
	//
	// Example: 05:00-09:00
	SnapshotWindow *string `type:"string"`

	// A flag that enables in-transit encryption when set to true.
	//
	// You cannot modify the value of TransitEncryptionEnabled after the cluster
	// is created. To enable in-transit encryption on a cluster you must set TransitEncryptionEnabled
	// to true when you create a cluster.
	//
	// Required: Only available when creating a replication group in an Amazon VPC
	// using redis version 3.2.6, 4.x or later.
	//
	// Default: false
	TransitEncryptionEnabled *bool `type:"boolean"`
}

// String returns the string representation
func (s CacheCluster) String() string {
	return awsutil.Prettify(s)
}

// Provides all of the details about a particular cache engine version.
type CacheEngineVersion struct {
	_ struct{} `type:"structure"`

	// The description of the cache engine.
	CacheEngineDescription *string `type:"string"`

	// The description of the cache engine version.
	CacheEngineVersionDescription *string `type:"string"`

	// The name of the cache parameter group family associated with this cache engine.
	//
	// Valid values are: memcached1.4 | memcached1.5 | redis2.6 | redis2.8 | redis3.2
	// | redis4.0 | redis5.0 |
	CacheParameterGroupFamily *string `type:"string"`

	// The name of the cache engine.
	Engine *string `type:"string"`

	// The version number of the cache engine.
	EngineVersion *string `type:"string"`
}

// String returns the string representation
func (s CacheEngineVersion) String() string {
	return awsutil.Prettify(s)
}

// Represents an individual cache node within a cluster. Each cache node runs
// its own instance of the cluster's protocol-compliant caching software - either
// Memcached or Redis.
//
// The following node types are supported by ElastiCache. Generally speaking,
// the current generation types provide more memory and computational power
// at lower cost when compared to their equivalent previous generation counterparts.
//
//    * General purpose: Current generation: M5 node types: cache.m5.large,
//    cache.m5.xlarge, cache.m5.2xlarge, cache.m5.4xlarge, cache.m5.12xlarge,
//    cache.m5.24xlarge M4 node types: cache.m4.large, cache.m4.xlarge, cache.m4.2xlarge,
//    cache.m4.4xlarge, cache.m4.10xlarge T2 node types: cache.t2.micro, cache.t2.small,
//    cache.t2.medium Previous generation: (not recommended) T1 node types:
//    cache.t1.micro M1 node types: cache.m1.small, cache.m1.medium, cache.m1.large,
//    cache.m1.xlarge M3 node types: cache.m3.medium, cache.m3.large, cache.m3.xlarge,
//    cache.m3.2xlarge
//
//    * Compute optimized: Previous generation: (not recommended) C1 node types:
//    cache.c1.xlarge
//
//    * Memory optimized: Current generation: R5 node types: cache.r5.large,
//    cache.r5.xlarge, cache.r5.2xlarge, cache.r5.4xlarge, cache.r5.12xlarge,
//    cache.r5.24xlarge R4 node types: cache.r4.large, cache.r4.xlarge, cache.r4.2xlarge,
//    cache.r4.4xlarge, cache.r4.8xlarge, cache.r4.16xlarge Previous generation:
//    (not recommended) M2 node types: cache.m2.xlarge, cache.m2.2xlarge, cache.m2.4xlarge
//    R3 node types: cache.r3.large, cache.r3.xlarge, cache.r3.2xlarge, cache.r3.4xlarge,
//    cache.r3.8xlarge
//
// Additional node type info
//
//    * All current generation instance types are created in Amazon VPC by default.
//
//    * Redis append-only files (AOF) are not supported for T1 or T2 instances.
//
//    * Redis Multi-AZ with automatic failover is not supported on T1 instances.
//
//    * Redis configuration variables appendonly and appendfsync are not supported
//    on Redis version 2.8.22 and later.
type CacheNode struct {
	_ struct{} `type:"structure"`

	// The date and time when the cache node was created.
	CacheNodeCreateTime *time.Time `type:"timestamp"`

	// The cache node identifier. A node ID is a numeric identifier (0001, 0002,
	// etc.). The combination of cluster ID and node ID uniquely identifies every
	// cache node used in a customer's AWS account.
	CacheNodeId *string `type:"string"`

	// The current state of this cache node.
	CacheNodeStatus *string `type:"string"`

	// The Availability Zone where this node was created and now resides.
	CustomerAvailabilityZone *string `type:"string"`

	// The hostname for connecting to this cache node.
	Endpoint *Endpoint `type:"structure"`

	// The status of the parameter group applied to this cache node.
	ParameterGroupStatus *string `type:"string"`

	// The ID of the primary node to which this read replica node is synchronized.
	// If this field is empty, this node is not associated with a primary cluster.
	SourceCacheNodeId *string `type:"string"`
}

// String returns the string representation
func (s CacheNode) String() string {
	return awsutil.Prettify(s)
}

// A parameter that has a different value for each cache node type it is applied
// to. For example, in a Redis cluster, a cache.m1.large cache node type would
// have a larger maxmemory value than a cache.m1.small type.
type CacheNodeTypeSpecificParameter struct {
	_ struct{} `type:"structure"`

	// The valid range of values for the parameter.
	AllowedValues *string `type:"string"`

	// A list of cache node types and their corresponding values for this parameter.
	CacheNodeTypeSpecificValues []CacheNodeTypeSpecificValue `locationNameList:"CacheNodeTypeSpecificValue" type:"list"`

	// Indicates whether a change to the parameter is applied immediately or requires
	// a reboot for the change to be applied. You can force a reboot or wait until
	// the next maintenance window's reboot. For more information, see Rebooting
	// a Cluster (https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.Rebooting.html).
	ChangeType ChangeType `type:"string" enum:"true"`

	// The valid data type for the parameter.
	DataType *string `type:"string"`

	// A description of the parameter.
	Description *string `type:"string"`

	// Indicates whether (true) or not (false) the parameter can be modified. Some
	// parameters have security or operational implications that prevent them from
	// being changed.
	IsModifiable *bool `type:"boolean"`

	// The earliest cache engine version to which the parameter can apply.
	MinimumEngineVersion *string `type:"string"`

	// The name of the parameter.
	ParameterName *string `type:"string"`

	// The source of the parameter value.
	Source *string `type:"string"`
}

// String returns the string representation
func (s CacheNodeTypeSpecificParameter) String() string {
	return awsutil.Prettify(s)
}

// A value that applies only to a certain cache node type.
type CacheNodeTypeSpecificValue struct {
	_ struct{} `type:"structure"`

	// The cache node type for which this value applies.
	CacheNodeType *string `type:"string"`

	// The value for the cache node type.
	Value *string `type:"string"`
}

// String returns the string representation
func (s CacheNodeTypeSpecificValue) String() string {
	return awsutil.Prettify(s)
}

// The status of the service update on the cache node
type CacheNodeUpdateStatus struct {
	_ struct{} `type:"structure"`

	// The node ID of the cache cluster
	CacheNodeId *string `type:"string"`

	// The deletion date of the node
	NodeDeletionDate *time.Time `type:"timestamp"`

	// The end date of the update for a node
	NodeUpdateEndDate *time.Time `type:"timestamp"`

	// Reflects whether the update was initiated by the customer or automatically
	// applied
	NodeUpdateInitiatedBy NodeUpdateInitiatedBy `type:"string" enum:"true"`

	// The date when the update is triggered
	NodeUpdateInitiatedDate *time.Time `type:"timestamp"`

	// The start date of the update for a node
	NodeUpdateStartDate *time.Time `type:"timestamp"`

	// The update status of the node
	NodeUpdateStatus NodeUpdateStatus `type:"string" enum:"true"`

	// The date when the NodeUpdateStatus was last modified>
	NodeUpdateStatusModifiedDate *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s CacheNodeUpdateStatus) String() string {
	return awsutil.Prettify(s)
}

// Represents the output of a CreateCacheParameterGroup operation.
type CacheParameterGroup struct {
	_ struct{} `type:"structure"`

	// The name of the cache parameter group family that this cache parameter group
	// is compatible with.
	//
	// Valid values are: memcached1.4 | memcached1.5 | redis2.6 | redis2.8 | redis3.2
	// | redis4.0 | redis5.0 |
	CacheParameterGroupFamily *string `type:"string"`

	// The name of the cache parameter group.
	CacheParameterGroupName *string `type:"string"`

	// The description for this cache parameter group.
	Description *string `type:"string"`
}

// String returns the string representation
func (s CacheParameterGroup) String() string {
	return awsutil.Prettify(s)
}

// Status of the cache parameter group.
type CacheParameterGroupStatus struct {
	_ struct{} `type:"structure"`

	// A list of the cache node IDs which need to be rebooted for parameter changes
	// to be applied. A node ID is a numeric identifier (0001, 0002, etc.).
	CacheNodeIdsToReboot []string `locationNameList:"CacheNodeId" type:"list"`

	// The name of the cache parameter group.
	CacheParameterGroupName *string `type:"string"`

	// The status of parameter updates.
	ParameterApplyStatus *string `type:"string"`
}

// String returns the string representation
func (s CacheParameterGroupStatus) String() string {
	return awsutil.Prettify(s)
}

// Represents the output of one of the following operations:
//
//    * AuthorizeCacheSecurityGroupIngress
//
//    * CreateCacheSecurityGroup
//
//    * RevokeCacheSecurityGroupIngress
type CacheSecurityGroup struct {
	_ struct{} `type:"structure"`

	// The name of the cache security group.
	CacheSecurityGroupName *string `type:"string"`

	// The description of the cache security group.
	Description *string `type:"string"`

	// A list of Amazon EC2 security groups that are associated with this cache
	// security group.
	EC2SecurityGroups []EC2SecurityGroup `locationNameList:"EC2SecurityGroup" type:"list"`

	// The AWS account ID of the cache security group owner.
	OwnerId *string `type:"string"`
}

// String returns the string representation
func (s CacheSecurityGroup) String() string {
	return awsutil.Prettify(s)
}

// Represents a cluster's status within a particular cache security group.
type CacheSecurityGroupMembership struct {
	_ struct{} `type:"structure"`

	// The name of the cache security group.
	CacheSecurityGroupName *string `type:"string"`

	// The membership status in the cache security group. The status changes when
	// a cache security group is modified, or when the cache security groups assigned
	// to a cluster are modified.
	Status *string `type:"string"`
}

// String returns the string representation
func (s CacheSecurityGroupMembership) String() string {
	return awsutil.Prettify(s)
}

// Represents the output of one of the following operations:
//
//    * CreateCacheSubnetGroup
//
//    * ModifyCacheSubnetGroup
type CacheSubnetGroup struct {
	_ struct{} `type:"structure"`

	// The description of the cache subnet group.
	CacheSubnetGroupDescription *string `type:"string"`

	// The name of the cache subnet group.
	CacheSubnetGroupName *string `type:"string"`

	// A list of subnets associated with the cache subnet group.
	Subnets []Subnet `locationNameList:"Subnet" type:"list"`

	// The Amazon Virtual Private Cloud identifier (VPC ID) of the cache subnet
	// group.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s CacheSubnetGroup) String() string {
	return awsutil.Prettify(s)
}

// Node group (shard) configuration options when adding or removing replicas.
// Each node group (shard) configuration has the following members: NodeGroupId,
// NewReplicaCount, and PreferredAvailabilityZones.
type ConfigureShard struct {
	_ struct{} `type:"structure"`

	// The number of replicas you want in this node group at the end of this operation.
	// The maximum value for NewReplicaCount is 5. The minimum value depends upon
	// the type of Redis replication group you are working with.
	//
	// The minimum number of replicas in a shard or replication group is:
	//
	//    * Redis (cluster mode disabled) If Multi-AZ with Automatic Failover is
	//    enabled: 1 If Multi-AZ with Automatic Failover is not enable: 0
	//
	//    * Redis (cluster mode enabled): 0 (though you will not be able to failover
	//    to a replica if your primary node fails)
	//
	// NewReplicaCount is a required field
	NewReplicaCount *int64 `type:"integer" required:"true"`

	// The 4-digit id for the node group you are configuring. For Redis (cluster
	// mode disabled) replication groups, the node group id is always 0001. To find
	// a Redis (cluster mode enabled)'s node group's (shard's) id, see Finding a
	// Shard's Id (https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/shard-find-id.html).
	//
	// NodeGroupId is a required field
	NodeGroupId *string `min:"1" type:"string" required:"true"`

	// A list of PreferredAvailabilityZone strings that specify which availability
	// zones the replication group's nodes are to be in. The nummber of PreferredAvailabilityZone
	// values must equal the value of NewReplicaCount plus 1 to account for the
	// primary node. If this member of ReplicaConfiguration is omitted, ElastiCache
	// for Redis selects the availability zone for each of the replicas.
	PreferredAvailabilityZones []string `locationNameList:"PreferredAvailabilityZone" type:"list"`
}

// String returns the string representation
func (s ConfigureShard) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConfigureShard) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ConfigureShard"}

	if s.NewReplicaCount == nil {
		invalidParams.Add(aws.NewErrParamRequired("NewReplicaCount"))
	}

	if s.NodeGroupId == nil {
		invalidParams.Add(aws.NewErrParamRequired("NodeGroupId"))
	}
	if s.NodeGroupId != nil && len(*s.NodeGroupId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NodeGroupId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The endpoint from which data should be migrated.
type CustomerNodeEndpoint struct {
	_ struct{} `type:"structure"`

	// The address of the node endpoint
	Address *string `type:"string"`

	// The port of the node endpoint
	Port *int64 `type:"integer"`
}

// String returns the string representation
func (s CustomerNodeEndpoint) String() string {
	return awsutil.Prettify(s)
}

// Provides ownership and status information for an Amazon EC2 security group.
type EC2SecurityGroup struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon EC2 security group.
	EC2SecurityGroupName *string `type:"string"`

	// The AWS account ID of the Amazon EC2 security group owner.
	EC2SecurityGroupOwnerId *string `type:"string"`

	// The status of the Amazon EC2 security group.
	Status *string `type:"string"`
}

// String returns the string representation
func (s EC2SecurityGroup) String() string {
	return awsutil.Prettify(s)
}

// Represents the information required for client programs to connect to a cache
// node.
type Endpoint struct {
	_ struct{} `type:"structure"`

	// The DNS hostname of the cache node.
	Address *string `type:"string"`

	// The port number that the cache engine is listening on.
	Port *int64 `type:"integer"`
}

// String returns the string representation
func (s Endpoint) String() string {
	return awsutil.Prettify(s)
}

// Represents the output of a DescribeEngineDefaultParameters operation.
type EngineDefaults struct {
	_ struct{} `type:"structure"`

	// A list of parameters specific to a particular cache node type. Each element
	// in the list contains detailed information about one parameter.
	CacheNodeTypeSpecificParameters []CacheNodeTypeSpecificParameter `locationNameList:"CacheNodeTypeSpecificParameter" type:"list"`

	// Specifies the name of the cache parameter group family to which the engine
	// default parameters apply.
	//
	// Valid values are: memcached1.4 | memcached1.5 | redis2.6 | redis2.8 | redis3.2
	// | redis4.0 | redis5.0 |
	CacheParameterGroupFamily *string `type:"string"`

	// Provides an identifier to allow retrieval of paginated results.
	Marker *string `type:"string"`

	// Contains a list of engine default parameters.
	Parameters []Parameter `locationNameList:"Parameter" type:"list"`
}

// String returns the string representation
func (s EngineDefaults) String() string {
	return awsutil.Prettify(s)
}

// Represents a single occurrence of something interesting within the system.
// Some examples of events are creating a cluster, adding or removing a cache
// node, or rebooting a node.
type Event struct {
	_ struct{} `type:"structure"`

	// The date and time when the event occurred.
	Date *time.Time `type:"timestamp"`

	// The text of the event.
	Message *string `type:"string"`

	// The identifier for the source of the event. For example, if the event occurred
	// at the cluster level, the identifier would be the name of the cluster.
	SourceIdentifier *string `type:"string"`

	// Specifies the origin of this event - a cluster, a parameter group, a security
	// group, etc.
	SourceType SourceType `type:"string" enum:"true"`
}

// String returns the string representation
func (s Event) String() string {
	return awsutil.Prettify(s)
}

// Represents a collection of cache nodes in a replication group. One node in
// the node group is the read/write primary node. All the other nodes are read-only
// Replica nodes.
type NodeGroup struct {
	_ struct{} `type:"structure"`

	// The identifier for the node group (shard). A Redis (cluster mode disabled)
	// replication group contains only 1 node group; therefore, the node group ID
	// is 0001. A Redis (cluster mode enabled) replication group contains 1 to 90
	// node groups numbered 0001 to 0090. Optionally, the user can provide the id
	// for a node group.
	NodeGroupId *string `type:"string"`

	// A list containing information about individual nodes within the node group
	// (shard).
	NodeGroupMembers []NodeGroupMember `locationNameList:"NodeGroupMember" type:"list"`

	// The endpoint of the primary node in this node group (shard).
	PrimaryEndpoint *Endpoint `type:"structure"`

	// The endpoint of the replica nodes in this node group (shard).
	ReaderEndpoint *Endpoint `type:"structure"`

	// The keyspace for this node group (shard).
	Slots *string `type:"string"`

	// The current state of this replication group - creating, available, etc.
	Status *string `type:"string"`
}

// String returns the string representation
func (s NodeGroup) String() string {
	return awsutil.Prettify(s)
}

// Node group (shard) configuration options. Each node group (shard) configuration
// has the following: Slots, PrimaryAvailabilityZone, ReplicaAvailabilityZones,
// ReplicaCount.
type NodeGroupConfiguration struct {
	_ struct{} `type:"structure"`

	// Either the ElastiCache for Redis supplied 4-digit id or a user supplied id
	// for the node group these configuration values apply to.
	NodeGroupId *string `min:"1" type:"string"`

	// The Availability Zone where the primary node of this node group (shard) is
	// launched.
	PrimaryAvailabilityZone *string `type:"string"`

	// A list of Availability Zones to be used for the read replicas. The number
	// of Availability Zones in this list must match the value of ReplicaCount or
	// ReplicasPerNodeGroup if not specified.
	ReplicaAvailabilityZones []string `locationNameList:"AvailabilityZone" type:"list"`

	// The number of read replica nodes in this node group (shard).
	ReplicaCount *int64 `type:"integer"`

	// A string that specifies the keyspace for a particular node group. Keyspaces
	// range from 0 to 16,383. The string is in the format startkey-endkey.
	//
	// Example: "0-3999"
	Slots *string `type:"string"`
}

// String returns the string representation
func (s NodeGroupConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NodeGroupConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "NodeGroupConfiguration"}
	if s.NodeGroupId != nil && len(*s.NodeGroupId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NodeGroupId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents a single node within a node group (shard).
type NodeGroupMember struct {
	_ struct{} `type:"structure"`

	// The ID of the cluster to which the node belongs.
	CacheClusterId *string `type:"string"`

	// The ID of the node within its cluster. A node ID is a numeric identifier
	// (0001, 0002, etc.).
	CacheNodeId *string `type:"string"`

	// The role that is currently assigned to the node - primary or replica. This
	// member is only applicable for Redis (cluster mode disabled) replication groups.
	CurrentRole *string `type:"string"`

	// The name of the Availability Zone in which the node is located.
	PreferredAvailabilityZone *string `type:"string"`

	// The information required for client programs to connect to a node for read
	// operations. The read endpoint is only applicable on Redis (cluster mode disabled)
	// clusters.
	ReadEndpoint *Endpoint `type:"structure"`
}

// String returns the string representation
func (s NodeGroupMember) String() string {
	return awsutil.Prettify(s)
}

// The status of the service update on the node group member
type NodeGroupMemberUpdateStatus struct {
	_ struct{} `type:"structure"`

	// The cache cluster ID
	CacheClusterId *string `type:"string"`

	// The node ID of the cache cluster
	CacheNodeId *string `type:"string"`

	// The deletion date of the node
	NodeDeletionDate *time.Time `type:"timestamp"`

	// The end date of the update for a node
	NodeUpdateEndDate *time.Time `type:"timestamp"`

	// Reflects whether the update was initiated by the customer or automatically
	// applied
	NodeUpdateInitiatedBy NodeUpdateInitiatedBy `type:"string" enum:"true"`

	// The date when the update is triggered
	NodeUpdateInitiatedDate *time.Time `type:"timestamp"`

	// The start date of the update for a node
	NodeUpdateStartDate *time.Time `type:"timestamp"`

	// The update status of the node
	NodeUpdateStatus NodeUpdateStatus `type:"string" enum:"true"`

	// The date when the NodeUpdateStatus was last modified
	NodeUpdateStatusModifiedDate *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s NodeGroupMemberUpdateStatus) String() string {
	return awsutil.Prettify(s)
}

// The status of the service update on the node group
type NodeGroupUpdateStatus struct {
	_ struct{} `type:"structure"`

	// The ID of the node group
	NodeGroupId *string `type:"string"`

	// The status of the service update on the node group member
	NodeGroupMemberUpdateStatus []NodeGroupMemberUpdateStatus `locationNameList:"NodeGroupMemberUpdateStatus" type:"list"`
}

// String returns the string representation
func (s NodeGroupUpdateStatus) String() string {
	return awsutil.Prettify(s)
}

// Represents an individual cache node in a snapshot of a cluster.
type NodeSnapshot struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the source cluster.
	CacheClusterId *string `type:"string"`

	// The date and time when the cache node was created in the source cluster.
	CacheNodeCreateTime *time.Time `type:"timestamp"`

	// The cache node identifier for the node in the source cluster.
	CacheNodeId *string `type:"string"`

	// The size of the cache on the source cache node.
	CacheSize *string `type:"string"`

	// The configuration for the source node group (shard).
	NodeGroupConfiguration *NodeGroupConfiguration `type:"structure"`

	// A unique identifier for the source node group (shard).
	NodeGroupId *string `type:"string"`

	// The date and time when the source node's metadata and cache data set was
	// obtained for the snapshot.
	SnapshotCreateTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s NodeSnapshot) String() string {
	return awsutil.Prettify(s)
}

// Describes a notification topic and its status. Notification topics are used
// for publishing ElastiCache events to subscribers using Amazon Simple Notification
// Service (SNS).
type NotificationConfiguration struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that identifies the topic.
	TopicArn *string `type:"string"`

	// The current state of the topic.
	TopicStatus *string `type:"string"`
}

// String returns the string representation
func (s NotificationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Describes an individual setting that controls some aspect of ElastiCache
// behavior.
type Parameter struct {
	_ struct{} `type:"structure"`

	// The valid range of values for the parameter.
	AllowedValues *string `type:"string"`

	// Indicates whether a change to the parameter is applied immediately or requires
	// a reboot for the change to be applied. You can force a reboot or wait until
	// the next maintenance window's reboot. For more information, see Rebooting
	// a Cluster (https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.Rebooting.html).
	ChangeType ChangeType `type:"string" enum:"true"`

	// The valid data type for the parameter.
	DataType *string `type:"string"`

	// A description of the parameter.
	Description *string `type:"string"`

	// Indicates whether (true) or not (false) the parameter can be modified. Some
	// parameters have security or operational implications that prevent them from
	// being changed.
	IsModifiable *bool `type:"boolean"`

	// The earliest cache engine version to which the parameter can apply.
	MinimumEngineVersion *string `type:"string"`

	// The name of the parameter.
	ParameterName *string `type:"string"`

	// The value of the parameter.
	ParameterValue *string `type:"string"`

	// The source of the parameter.
	Source *string `type:"string"`
}

// String returns the string representation
func (s Parameter) String() string {
	return awsutil.Prettify(s)
}

// Describes a name-value pair that is used to update the value of a parameter.
type ParameterNameValue struct {
	_ struct{} `type:"structure"`

	// The name of the parameter.
	ParameterName *string `type:"string"`

	// The value of the parameter.
	ParameterValue *string `type:"string"`
}

// String returns the string representation
func (s ParameterNameValue) String() string {
	return awsutil.Prettify(s)
}

// A group of settings that are applied to the cluster in the future, or that
// are currently being applied.
type PendingModifiedValues struct {
	_ struct{} `type:"structure"`

	// The auth token status
	AuthTokenStatus AuthTokenUpdateStatus `type:"string" enum:"true"`

	// A list of cache node IDs that are being removed (or will be removed) from
	// the cluster. A node ID is a 4-digit numeric identifier (0001, 0002, etc.).
	CacheNodeIdsToRemove []string `locationNameList:"CacheNodeId" type:"list"`

	// The cache node type that this cluster or replication group is scaled to.
	CacheNodeType *string `type:"string"`

	// The new cache engine version that the cluster runs.
	EngineVersion *string `type:"string"`

	// The new number of cache nodes for the cluster.
	//
	// For clusters running Redis, this value must be 1. For clusters running Memcached,
	// this value must be between 1 and 20.
	NumCacheNodes *int64 `type:"integer"`
}

// String returns the string representation
func (s PendingModifiedValues) String() string {
	return awsutil.Prettify(s)
}

// Update action that has been processed for the corresponding apply/stop request
type ProcessedUpdateAction struct {
	_ struct{} `type:"structure"`

	// The ID of the cache cluster
	CacheClusterId *string `type:"string"`

	// The ID of the replication group
	ReplicationGroupId *string `type:"string"`

	// The unique ID of the service update
	ServiceUpdateName *string `type:"string"`

	// The status of the update action on the Redis cluster
	UpdateActionStatus UpdateActionStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s ProcessedUpdateAction) String() string {
	return awsutil.Prettify(s)
}

// Contains the specific price and frequency of a recurring charges for a reserved
// cache node, or for a reserved cache node offering.
type RecurringCharge struct {
	_ struct{} `type:"structure"`

	// The monetary amount of the recurring charge.
	RecurringChargeAmount *float64 `type:"double"`

	// The frequency of the recurring charge.
	RecurringChargeFrequency *string `type:"string"`
}

// String returns the string representation
func (s RecurringCharge) String() string {
	return awsutil.Prettify(s)
}

// Contains all of the attributes of a specific Redis replication group.
type ReplicationGroup struct {
	_ struct{} `type:"structure"`

	// A flag that enables encryption at-rest when set to true.
	//
	// You cannot modify the value of AtRestEncryptionEnabled after the cluster
	// is created. To enable encryption at-rest on a cluster you must set AtRestEncryptionEnabled
	// to true when you create a cluster.
	//
	// Required: Only available when creating a replication group in an Amazon VPC
	// using redis version 3.2.6, 4.x or later.
	//
	// Default: false
	AtRestEncryptionEnabled *bool `type:"boolean"`

	// A flag that enables using an AuthToken (password) when issuing Redis commands.
	//
	// Default: false
	AuthTokenEnabled *bool `type:"boolean"`

	// The date the auth token was last modified
	AuthTokenLastModifiedDate *time.Time `type:"timestamp"`

	// Indicates the status of Multi-AZ with automatic failover for this Redis replication
	// group.
	//
	// Amazon ElastiCache for Redis does not support Multi-AZ with automatic failover
	// on:
	//
	//    * Redis versions earlier than 2.8.6.
	//
	//    * Redis (cluster mode disabled): T1 node types.
	//
	//    * Redis (cluster mode enabled): T1 node types.
	AutomaticFailover AutomaticFailoverStatus `type:"string" enum:"true"`

	// The name of the compute and memory capacity node type for each node in the
	// replication group.
	CacheNodeType *string `type:"string"`

	// A flag indicating whether or not this replication group is cluster enabled;
	// i.e., whether its data can be partitioned across multiple shards (API/CLI:
	// node groups).
	//
	// Valid values: true | false
	ClusterEnabled *bool `type:"boolean"`

	// The configuration endpoint for this replication group. Use the configuration
	// endpoint to connect to this replication group.
	ConfigurationEndpoint *Endpoint `type:"structure"`

	// The user supplied description of the replication group.
	Description *string `type:"string"`

	// The ID of the KMS key used to encrypt the disk in the cluster.
	KmsKeyId *string `type:"string"`

	// The names of all the cache clusters that are part of this replication group.
	MemberClusters []string `locationNameList:"ClusterId" type:"list"`

	// A list of node groups in this replication group. For Redis (cluster mode
	// disabled) replication groups, this is a single-element list. For Redis (cluster
	// mode enabled) replication groups, the list contains an entry for each node
	// group (shard).
	NodeGroups []NodeGroup `locationNameList:"NodeGroup" type:"list"`

	// A group of settings to be applied to the replication group, either immediately
	// or during the next maintenance window.
	PendingModifiedValues *ReplicationGroupPendingModifiedValues `type:"structure"`

	// The identifier for the replication group.
	ReplicationGroupId *string `type:"string"`

	// The number of days for which ElastiCache retains automatic cluster snapshots
	// before deleting them. For example, if you set SnapshotRetentionLimit to 5,
	// a snapshot that was taken today is retained for 5 days before being deleted.
	//
	// If the value of SnapshotRetentionLimit is set to zero (0), backups are turned
	// off.
	SnapshotRetentionLimit *int64 `type:"integer"`

	// The daily time range (in UTC) during which ElastiCache begins taking a daily
	// snapshot of your node group (shard).
	//
	// Example: 05:00-09:00
	//
	// If you do not specify this parameter, ElastiCache automatically chooses an
	// appropriate time range.
	//
	// This parameter is only valid if the Engine parameter is redis.
	SnapshotWindow *string `type:"string"`

	// The cluster ID that is used as the daily snapshot source for the replication
	// group.
	SnapshottingClusterId *string `type:"string"`

	// The current state of this replication group - creating, available, modifying,
	// deleting, create-failed, snapshotting.
	Status *string `type:"string"`

	// A flag that enables in-transit encryption when set to true.
	//
	// You cannot modify the value of TransitEncryptionEnabled after the cluster
	// is created. To enable in-transit encryption on a cluster you must set TransitEncryptionEnabled
	// to true when you create a cluster.
	//
	// Required: Only available when creating a replication group in an Amazon VPC
	// using redis version 3.2.6, 4.x or later.
	//
	// Default: false
	TransitEncryptionEnabled *bool `type:"boolean"`
}

// String returns the string representation
func (s ReplicationGroup) String() string {
	return awsutil.Prettify(s)
}

// The settings to be applied to the Redis replication group, either immediately
// or during the next maintenance window.
type ReplicationGroupPendingModifiedValues struct {
	_ struct{} `type:"structure"`

	// The auth token status
	AuthTokenStatus AuthTokenUpdateStatus `type:"string" enum:"true"`

	// Indicates the status of Multi-AZ with automatic failover for this Redis replication
	// group.
	//
	// Amazon ElastiCache for Redis does not support Multi-AZ with automatic failover
	// on:
	//
	//    * Redis versions earlier than 2.8.6.
	//
	//    * Redis (cluster mode disabled): T1 node types.
	//
	//    * Redis (cluster mode enabled): T1 node types.
	AutomaticFailoverStatus PendingAutomaticFailoverStatus `type:"string" enum:"true"`

	// The primary cluster ID that is applied immediately (if --apply-immediately
	// was specified), or during the next maintenance window.
	PrimaryClusterId *string `type:"string"`

	// The status of an online resharding operation.
	Resharding *ReshardingStatus `type:"structure"`
}

// String returns the string representation
func (s ReplicationGroupPendingModifiedValues) String() string {
	return awsutil.Prettify(s)
}

// Represents the output of a PurchaseReservedCacheNodesOffering operation.
type ReservedCacheNode struct {
	_ struct{} `type:"structure"`

	// The number of cache nodes that have been reserved.
	CacheNodeCount *int64 `type:"integer"`

	// The cache node type for the reserved cache nodes.
	//
	// The following node types are supported by ElastiCache. Generally speaking,
	// the current generation types provide more memory and computational power
	// at lower cost when compared to their equivalent previous generation counterparts.
	//
	//    * General purpose: Current generation: M5 node types: cache.m5.large,
	//    cache.m5.xlarge, cache.m5.2xlarge, cache.m5.4xlarge, cache.m5.12xlarge,
	//    cache.m5.24xlarge M4 node types: cache.m4.large, cache.m4.xlarge, cache.m4.2xlarge,
	//    cache.m4.4xlarge, cache.m4.10xlarge T2 node types: cache.t2.micro, cache.t2.small,
	//    cache.t2.medium Previous generation: (not recommended) T1 node types:
	//    cache.t1.micro M1 node types: cache.m1.small, cache.m1.medium, cache.m1.large,
	//    cache.m1.xlarge M3 node types: cache.m3.medium, cache.m3.large, cache.m3.xlarge,
	//    cache.m3.2xlarge
	//
	//    * Compute optimized: Previous generation: (not recommended) C1 node types:
	//    cache.c1.xlarge
	//
	//    * Memory optimized: Current generation: R5 node types: cache.r5.large,
	//    cache.r5.xlarge, cache.r5.2xlarge, cache.r5.4xlarge, cache.r5.12xlarge,
	//    cache.r5.24xlarge R4 node types: cache.r4.large, cache.r4.xlarge, cache.r4.2xlarge,
	//    cache.r4.4xlarge, cache.r4.8xlarge, cache.r4.16xlarge Previous generation:
	//    (not recommended) M2 node types: cache.m2.xlarge, cache.m2.2xlarge, cache.m2.4xlarge
	//    R3 node types: cache.r3.large, cache.r3.xlarge, cache.r3.2xlarge, cache.r3.4xlarge,
	//    cache.r3.8xlarge
	//
	// Additional node type info
	//
	//    * All current generation instance types are created in Amazon VPC by default.
	//
	//    * Redis append-only files (AOF) are not supported for T1 or T2 instances.
	//
	//    * Redis Multi-AZ with automatic failover is not supported on T1 instances.
	//
	//    * Redis configuration variables appendonly and appendfsync are not supported
	//    on Redis version 2.8.22 and later.
	CacheNodeType *string `type:"string"`

	// The duration of the reservation in seconds.
	Duration *int64 `type:"integer"`

	// The fixed price charged for this reserved cache node.
	FixedPrice *float64 `type:"double"`

	// The offering type of this reserved cache node.
	OfferingType *string `type:"string"`

	// The description of the reserved cache node.
	ProductDescription *string `type:"string"`

	// The recurring price charged to run this reserved cache node.
	RecurringCharges []RecurringCharge `locationNameList:"RecurringCharge" type:"list"`

	// The Amazon Resource Name (ARN) of the reserved cache node.
	//
	// Example: arn:aws:elasticache:us-east-1:123456789012:reserved-instance:ri-2017-03-27-08-33-25-582
	ReservationARN *string `type:"string"`

	// The unique identifier for the reservation.
	ReservedCacheNodeId *string `type:"string"`

	// The offering identifier.
	ReservedCacheNodesOfferingId *string `type:"string"`

	// The time the reservation started.
	StartTime *time.Time `type:"timestamp"`

	// The state of the reserved cache node.
	State *string `type:"string"`

	// The hourly price charged for this reserved cache node.
	UsagePrice *float64 `type:"double"`
}

// String returns the string representation
func (s ReservedCacheNode) String() string {
	return awsutil.Prettify(s)
}

// Describes all of the attributes of a reserved cache node offering.
type ReservedCacheNodesOffering struct {
	_ struct{} `type:"structure"`

	// The cache node type for the reserved cache node.
	//
	// The following node types are supported by ElastiCache. Generally speaking,
	// the current generation types provide more memory and computational power
	// at lower cost when compared to their equivalent previous generation counterparts.
	//
	//    * General purpose: Current generation: M5 node types: cache.m5.large,
	//    cache.m5.xlarge, cache.m5.2xlarge, cache.m5.4xlarge, cache.m5.12xlarge,
	//    cache.m5.24xlarge M4 node types: cache.m4.large, cache.m4.xlarge, cache.m4.2xlarge,
	//    cache.m4.4xlarge, cache.m4.10xlarge T2 node types: cache.t2.micro, cache.t2.small,
	//    cache.t2.medium Previous generation: (not recommended) T1 node types:
	//    cache.t1.micro M1 node types: cache.m1.small, cache.m1.medium, cache.m1.large,
	//    cache.m1.xlarge M3 node types: cache.m3.medium, cache.m3.large, cache.m3.xlarge,
	//    cache.m3.2xlarge
	//
	//    * Compute optimized: Previous generation: (not recommended) C1 node types:
	//    cache.c1.xlarge
	//
	//    * Memory optimized: Current generation: R5 node types: cache.r5.large,
	//    cache.r5.xlarge, cache.r5.2xlarge, cache.r5.4xlarge, cache.r5.12xlarge,
	//    cache.r5.24xlarge R4 node types: cache.r4.large, cache.r4.xlarge, cache.r4.2xlarge,
	//    cache.r4.4xlarge, cache.r4.8xlarge, cache.r4.16xlarge Previous generation:
	//    (not recommended) M2 node types: cache.m2.xlarge, cache.m2.2xlarge, cache.m2.4xlarge
	//    R3 node types: cache.r3.large, cache.r3.xlarge, cache.r3.2xlarge, cache.r3.4xlarge,
	//    cache.r3.8xlarge
	//
	// Additional node type info
	//
	//    * All current generation instance types are created in Amazon VPC by default.
	//
	//    * Redis append-only files (AOF) are not supported for T1 or T2 instances.
	//
	//    * Redis Multi-AZ with automatic failover is not supported on T1 instances.
	//
	//    * Redis configuration variables appendonly and appendfsync are not supported
	//    on Redis version 2.8.22 and later.
	CacheNodeType *string `type:"string"`

	// The duration of the offering. in seconds.
	Duration *int64 `type:"integer"`

	// The fixed price charged for this offering.
	FixedPrice *float64 `type:"double"`

	// The offering type.
	OfferingType *string `type:"string"`

	// The cache engine used by the offering.
	ProductDescription *string `type:"string"`

	// The recurring price charged to run this reserved cache node.
	RecurringCharges []RecurringCharge `locationNameList:"RecurringCharge" type:"list"`

	// A unique identifier for the reserved cache node offering.
	ReservedCacheNodesOfferingId *string `type:"string"`

	// The hourly price charged for this offering.
	UsagePrice *float64 `type:"double"`
}

// String returns the string representation
func (s ReservedCacheNodesOffering) String() string {
	return awsutil.Prettify(s)
}

// A list of PreferredAvailabilityZones objects that specifies the configuration
// of a node group in the resharded cluster.
type ReshardingConfiguration struct {
	_ struct{} `type:"structure"`

	// Either the ElastiCache for Redis supplied 4-digit id or a user supplied id
	// for the node group these configuration values apply to.
	NodeGroupId *string `min:"1" type:"string"`

	// A list of preferred availability zones for the nodes in this cluster.
	PreferredAvailabilityZones []string `locationNameList:"AvailabilityZone" type:"list"`
}

// String returns the string representation
func (s ReshardingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReshardingConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ReshardingConfiguration"}
	if s.NodeGroupId != nil && len(*s.NodeGroupId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NodeGroupId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The status of an online resharding operation.
type ReshardingStatus struct {
	_ struct{} `type:"structure"`

	// Represents the progress of an online resharding operation.
	SlotMigration *SlotMigration `type:"structure"`
}

// String returns the string representation
func (s ReshardingStatus) String() string {
	return awsutil.Prettify(s)
}

// Represents a single cache security group and its status.
type SecurityGroupMembership struct {
	_ struct{} `type:"structure"`

	// The identifier of the cache security group.
	SecurityGroupId *string `type:"string"`

	// The status of the cache security group membership. The status changes whenever
	// a cache security group is modified, or when the cache security groups assigned
	// to a cluster are modified.
	Status *string `type:"string"`
}

// String returns the string representation
func (s SecurityGroupMembership) String() string {
	return awsutil.Prettify(s)
}

// An update that you can apply to your Redis clusters.
type ServiceUpdate struct {
	_ struct{} `type:"structure"`

	// Indicates whether the service update will be automatically applied once the
	// recommended apply-by date has expired.
	AutoUpdateAfterRecommendedApplyByDate *bool `type:"boolean"`

	// The Elasticache engine to which the update applies. Either Redis or Memcached
	Engine *string `type:"string"`

	// The Elasticache engine version to which the update applies. Either Redis
	// or Memcached engine version
	EngineVersion *string `type:"string"`

	// The estimated length of time the service update will take
	EstimatedUpdateTime *string `type:"string"`

	// Provides details of the service update
	ServiceUpdateDescription *string `type:"string"`

	// The date after which the service update is no longer available
	ServiceUpdateEndDate *time.Time `type:"timestamp"`

	// The unique ID of the service update
	ServiceUpdateName *string `type:"string"`

	// The recommendend date to apply the service update in order to ensure compliance.
	// For information on compliance, see Self-Service Security Updates for Compliance
	// (https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/elasticache-compliance.html#elasticache-compliance-self-service).
	ServiceUpdateRecommendedApplyByDate *time.Time `type:"timestamp"`

	// The date when the service update is initially available
	ServiceUpdateReleaseDate *time.Time `type:"timestamp"`

	// The severity of the service update
	ServiceUpdateSeverity ServiceUpdateSeverity `type:"string" enum:"true"`

	// The status of the service update
	ServiceUpdateStatus ServiceUpdateStatus `type:"string" enum:"true"`

	// Reflects the nature of the service update
	ServiceUpdateType ServiceUpdateType `type:"string" enum:"true"`
}

// String returns the string representation
func (s ServiceUpdate) String() string {
	return awsutil.Prettify(s)
}

// Represents the progress of an online resharding operation.
type SlotMigration struct {
	_ struct{} `type:"structure"`

	// The percentage of the slot migration that is complete.
	ProgressPercentage *float64 `type:"double"`
}

// String returns the string representation
func (s SlotMigration) String() string {
	return awsutil.Prettify(s)
}

// Represents a copy of an entire Redis cluster as of the time when the snapshot
// was taken.
type Snapshot struct {
	_ struct{} `type:"structure"`

	// This parameter is currently disabled.
	AutoMinorVersionUpgrade *bool `type:"boolean"`

	// Indicates the status of Multi-AZ with automatic failover for the source Redis
	// replication group.
	//
	// Amazon ElastiCache for Redis does not support Multi-AZ with automatic failover
	// on:
	//
	//    * Redis versions earlier than 2.8.6.
	//
	//    * Redis (cluster mode disabled): T1 node types.
	//
	//    * Redis (cluster mode enabled): T1 node types.
	AutomaticFailover AutomaticFailoverStatus `type:"string" enum:"true"`

	// The date and time when the source cluster was created.
	CacheClusterCreateTime *time.Time `type:"timestamp"`

	// The user-supplied identifier of the source cluster.
	CacheClusterId *string `type:"string"`

	// The name of the compute and memory capacity node type for the source cluster.
	//
	// The following node types are supported by ElastiCache. Generally speaking,
	// the current generation types provide more memory and computational power
	// at lower cost when compared to their equivalent previous generation counterparts.
	//
	//    * General purpose: Current generation: M5 node types: cache.m5.large,
	//    cache.m5.xlarge, cache.m5.2xlarge, cache.m5.4xlarge, cache.m5.12xlarge,
	//    cache.m5.24xlarge M4 node types: cache.m4.large, cache.m4.xlarge, cache.m4.2xlarge,
	//    cache.m4.4xlarge, cache.m4.10xlarge T2 node types: cache.t2.micro, cache.t2.small,
	//    cache.t2.medium Previous generation: (not recommended) T1 node types:
	//    cache.t1.micro M1 node types: cache.m1.small, cache.m1.medium, cache.m1.large,
	//    cache.m1.xlarge M3 node types: cache.m3.medium, cache.m3.large, cache.m3.xlarge,
	//    cache.m3.2xlarge
	//
	//    * Compute optimized: Previous generation: (not recommended) C1 node types:
	//    cache.c1.xlarge
	//
	//    * Memory optimized: Current generation: R5 node types: cache.r5.large,
	//    cache.r5.xlarge, cache.r5.2xlarge, cache.r5.4xlarge, cache.r5.12xlarge,
	//    cache.r5.24xlarge R4 node types: cache.r4.large, cache.r4.xlarge, cache.r4.2xlarge,
	//    cache.r4.4xlarge, cache.r4.8xlarge, cache.r4.16xlarge Previous generation:
	//    (not recommended) M2 node types: cache.m2.xlarge, cache.m2.2xlarge, cache.m2.4xlarge
	//    R3 node types: cache.r3.large, cache.r3.xlarge, cache.r3.2xlarge, cache.r3.4xlarge,
	//    cache.r3.8xlarge
	//
	// Additional node type info
	//
	//    * All current generation instance types are created in Amazon VPC by default.
	//
	//    * Redis append-only files (AOF) are not supported for T1 or T2 instances.
	//
	//    * Redis Multi-AZ with automatic failover is not supported on T1 instances.
	//
	//    * Redis configuration variables appendonly and appendfsync are not supported
	//    on Redis version 2.8.22 and later.
	CacheNodeType *string `type:"string"`

	// The cache parameter group that is associated with the source cluster.
	CacheParameterGroupName *string `type:"string"`

	// The name of the cache subnet group associated with the source cluster.
	CacheSubnetGroupName *string `type:"string"`

	// The name of the cache engine (memcached or redis) used by the source cluster.
	Engine *string `type:"string"`

	// The version of the cache engine version that is used by the source cluster.
	EngineVersion *string `type:"string"`

	// The ID of the KMS key used to encrypt the snapshot.
	KmsKeyId *string `type:"string"`

	// A list of the cache nodes in the source cluster.
	NodeSnapshots []NodeSnapshot `locationNameList:"NodeSnapshot" type:"list"`

	// The number of cache nodes in the source cluster.
	//
	// For clusters running Redis, this value must be 1. For clusters running Memcached,
	// this value must be between 1 and 20.
	NumCacheNodes *int64 `type:"integer"`

	// The number of node groups (shards) in this snapshot. When restoring from
	// a snapshot, the number of node groups (shards) in the snapshot and in the
	// restored replication group must be the same.
	NumNodeGroups *int64 `type:"integer"`

	// The port number used by each cache nodes in the source cluster.
	Port *int64 `type:"integer"`

	// The name of the Availability Zone in which the source cluster is located.
	PreferredAvailabilityZone *string `type:"string"`

	// Specifies the weekly time range during which maintenance on the cluster is
	// performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi
	// (24H Clock UTC). The minimum maintenance window is a 60 minute period.
	//
	// Valid values for ddd are:
	//
	//    * sun
	//
	//    * mon
	//
	//    * tue
	//
	//    * wed
	//
	//    * thu
	//
	//    * fri
	//
	//    * sat
	//
	// Example: sun:23:00-mon:01:30
	PreferredMaintenanceWindow *string `type:"string"`

	// A description of the source replication group.
	ReplicationGroupDescription *string `type:"string"`

	// The unique identifier of the source replication group.
	ReplicationGroupId *string `type:"string"`

	// The name of a snapshot. For an automatic snapshot, the name is system-generated.
	// For a manual snapshot, this is the user-provided name.
	SnapshotName *string `type:"string"`

	// For an automatic snapshot, the number of days for which ElastiCache retains
	// the snapshot before deleting it.
	//
	// For manual snapshots, this field reflects the SnapshotRetentionLimit for
	// the source cluster when the snapshot was created. This field is otherwise
	// ignored: Manual snapshots do not expire, and can only be deleted using the
	// DeleteSnapshot operation.
	//
	// Important If the value of SnapshotRetentionLimit is set to zero (0), backups
	// are turned off.
	SnapshotRetentionLimit *int64 `type:"integer"`

	// Indicates whether the snapshot is from an automatic backup (automated) or
	// was created manually (manual).
	SnapshotSource *string `type:"string"`

	// The status of the snapshot. Valid values: creating | available | restoring
	// | copying | deleting.
	SnapshotStatus *string `type:"string"`

	// The daily time range during which ElastiCache takes daily snapshots of the
	// source cluster.
	SnapshotWindow *string `type:"string"`

	// The Amazon Resource Name (ARN) for the topic used by the source cluster for
	// publishing notifications.
	TopicArn *string `type:"string"`

	// The Amazon Virtual Private Cloud identifier (VPC ID) of the cache subnet
	// group for the source cluster.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s Snapshot) String() string {
	return awsutil.Prettify(s)
}

// Represents the subnet associated with a cluster. This parameter refers to
// subnets defined in Amazon Virtual Private Cloud (Amazon VPC) and used with
// ElastiCache.
type Subnet struct {
	_ struct{} `type:"structure"`

	// The Availability Zone associated with the subnet.
	SubnetAvailabilityZone *AvailabilityZone `type:"structure"`

	// The unique identifier for the subnet.
	SubnetIdentifier *string `type:"string"`
}

// String returns the string representation
func (s Subnet) String() string {
	return awsutil.Prettify(s)
}

// A cost allocation Tag that can be added to an ElastiCache cluster or replication
// group. Tags are composed of a Key/Value pair. A tag with a null Value is
// permitted.
type Tag struct {
	_ struct{} `type:"structure"`

	// The key for the tag. May not be null.
	Key *string `type:"string"`

	// The tag's value. May be null.
	Value *string `type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// Filters update actions from the service updates that are in available status
// during the time range.
type TimeRangeFilter struct {
	_ struct{} `type:"structure"`

	// The end time of the time range filter
	EndTime *time.Time `type:"timestamp"`

	// The start time of the time range filter
	StartTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s TimeRangeFilter) String() string {
	return awsutil.Prettify(s)
}

// Update action that has failed to be processed for the corresponding apply/stop
// request
type UnprocessedUpdateAction struct {
	_ struct{} `type:"structure"`

	// The ID of the cache cluster
	CacheClusterId *string `type:"string"`

	// The error message that describes the reason the request was not processed
	ErrorMessage *string `type:"string"`

	// The error type for requests that are not processed
	ErrorType *string `type:"string"`

	// The replication group ID
	ReplicationGroupId *string `type:"string"`

	// The unique ID of the service update
	ServiceUpdateName *string `type:"string"`
}

// String returns the string representation
func (s UnprocessedUpdateAction) String() string {
	return awsutil.Prettify(s)
}

// The status of the service update for a specific replication group
type UpdateAction struct {
	_ struct{} `type:"structure"`

	// The ID of the cache cluster
	CacheClusterId *string `type:"string"`

	// The status of the service update on the cache node
	CacheNodeUpdateStatus []CacheNodeUpdateStatus `locationNameList:"CacheNodeUpdateStatus" type:"list"`

	// The Elasticache engine to which the update applies. Either Redis or Memcached
	Engine *string `type:"string"`

	// The estimated length of time for the update to complete
	EstimatedUpdateTime *string `type:"string"`

	// The status of the service update on the node group
	NodeGroupUpdateStatus []NodeGroupUpdateStatus `locationNameList:"NodeGroupUpdateStatus" type:"list"`

	// The progress of the service update on the replication group
	NodesUpdated *string `type:"string"`

	// The ID of the replication group
	ReplicationGroupId *string `type:"string"`

	// The unique ID of the service update
	ServiceUpdateName *string `type:"string"`

	// The recommended date to apply the service update to ensure compliance. For
	// information on compliance, see Self-Service Security Updates for Compliance
	// (https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/elasticache-compliance.html#elasticache-compliance-self-service).
	ServiceUpdateRecommendedApplyByDate *time.Time `type:"timestamp"`

	// The date the update is first available
	ServiceUpdateReleaseDate *time.Time `type:"timestamp"`

	// The severity of the service update
	ServiceUpdateSeverity ServiceUpdateSeverity `type:"string" enum:"true"`

	// The status of the service update
	ServiceUpdateStatus ServiceUpdateStatus `type:"string" enum:"true"`

	// Reflects the nature of the service update
	ServiceUpdateType ServiceUpdateType `type:"string" enum:"true"`

	// If yes, all nodes in the replication group have been updated by the recommended
	// apply-by date. If no, at least one node in the replication group have not
	// been updated by the recommended apply-by date. If N/A, the replication group
	// was created after the recommended apply-by date.
	SlaMet SlaMet `type:"string" enum:"true"`

	// The date that the service update is available to a replication group
	UpdateActionAvailableDate *time.Time `type:"timestamp"`

	// The status of the update action
	UpdateActionStatus UpdateActionStatus `type:"string" enum:"true"`

	// The date when the UpdateActionStatus was last modified
	UpdateActionStatusModifiedDate *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s UpdateAction) String() string {
	return awsutil.Prettify(s)
}
