// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package efs

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DescribeMountTargetSecurityGroupsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the mount target whose security groups you want to retrieve.
	//
	// MountTargetId is a required field
	MountTargetId *string `location:"uri" locationName:"MountTargetId" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeMountTargetSecurityGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeMountTargetSecurityGroupsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeMountTargetSecurityGroupsInput"}

	if s.MountTargetId == nil {
		invalidParams.Add(aws.NewErrParamRequired("MountTargetId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeMountTargetSecurityGroupsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.MountTargetId != nil {
		v := *s.MountTargetId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "MountTargetId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DescribeMountTargetSecurityGroupsOutput struct {
	_ struct{} `type:"structure"`

	// An array of security groups.
	//
	// SecurityGroups is a required field
	SecurityGroups []string `type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeMountTargetSecurityGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeMountTargetSecurityGroupsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.SecurityGroups != nil {
		v := s.SecurityGroups

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "SecurityGroups", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

const opDescribeMountTargetSecurityGroups = "DescribeMountTargetSecurityGroups"

// DescribeMountTargetSecurityGroupsRequest returns a request value for making API operation for
// Amazon Elastic File System.
//
// Returns the security groups currently in effect for a mount target. This
// operation requires that the network interface of the mount target has been
// created and the lifecycle state of the mount target is not deleted.
//
// This operation requires permissions for the following actions:
//
//    * elasticfilesystem:DescribeMountTargetSecurityGroups action on the mount
//    target's file system.
//
//    * ec2:DescribeNetworkInterfaceAttribute action on the mount target's network
//    interface.
//
//    // Example sending a request using DescribeMountTargetSecurityGroupsRequest.
//    req := client.DescribeMountTargetSecurityGroupsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/DescribeMountTargetSecurityGroups
func (c *Client) DescribeMountTargetSecurityGroupsRequest(input *DescribeMountTargetSecurityGroupsInput) DescribeMountTargetSecurityGroupsRequest {
	op := &aws.Operation{
		Name:       opDescribeMountTargetSecurityGroups,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-02-01/mount-targets/{MountTargetId}/security-groups",
	}

	if input == nil {
		input = &DescribeMountTargetSecurityGroupsInput{}
	}

	req := c.newRequest(op, input, &DescribeMountTargetSecurityGroupsOutput{})
	return DescribeMountTargetSecurityGroupsRequest{Request: req, Input: input, Copy: c.DescribeMountTargetSecurityGroupsRequest}
}

// DescribeMountTargetSecurityGroupsRequest is the request type for the
// DescribeMountTargetSecurityGroups API operation.
type DescribeMountTargetSecurityGroupsRequest struct {
	*aws.Request
	Input *DescribeMountTargetSecurityGroupsInput
	Copy  func(*DescribeMountTargetSecurityGroupsInput) DescribeMountTargetSecurityGroupsRequest
}

// Send marshals and sends the DescribeMountTargetSecurityGroups API request.
func (r DescribeMountTargetSecurityGroupsRequest) Send(ctx context.Context) (*DescribeMountTargetSecurityGroupsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeMountTargetSecurityGroupsResponse{
		DescribeMountTargetSecurityGroupsOutput: r.Request.Data.(*DescribeMountTargetSecurityGroupsOutput),
		response:                                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeMountTargetSecurityGroupsResponse is the response type for the
// DescribeMountTargetSecurityGroups API operation.
type DescribeMountTargetSecurityGroupsResponse struct {
	*DescribeMountTargetSecurityGroupsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeMountTargetSecurityGroups request.
func (r *DescribeMountTargetSecurityGroupsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
