// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeregisterTransitGatewayMulticastGroupSourcesInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// The IP address assigned to the transit gateway multicast group.
	GroupIpAddress *string `type:"string"`

	// The IDs of the group sources' network interfaces.
	NetworkInterfaceIds []string `locationNameList:"item" type:"list"`

	// The ID of the transit gateway multicast domain.
	TransitGatewayMulticastDomainId *string `type:"string"`
}

// String returns the string representation
func (s DeregisterTransitGatewayMulticastGroupSourcesInput) String() string {
	return awsutil.Prettify(s)
}

type DeregisterTransitGatewayMulticastGroupSourcesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the deregistered group sources.
	DeregisteredMulticastGroupSources *TransitGatewayMulticastDeregisteredGroupSources `locationName:"deregisteredMulticastGroupSources" type:"structure"`
}

// String returns the string representation
func (s DeregisterTransitGatewayMulticastGroupSourcesOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeregisterTransitGatewayMulticastGroupSources = "DeregisterTransitGatewayMulticastGroupSources"

// DeregisterTransitGatewayMulticastGroupSourcesRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Deregisters the specified sources (network interfaces) from the transit gateway
// multicast group.
//
//    // Example sending a request using DeregisterTransitGatewayMulticastGroupSourcesRequest.
//    req := client.DeregisterTransitGatewayMulticastGroupSourcesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeregisterTransitGatewayMulticastGroupSources
func (c *Client) DeregisterTransitGatewayMulticastGroupSourcesRequest(input *DeregisterTransitGatewayMulticastGroupSourcesInput) DeregisterTransitGatewayMulticastGroupSourcesRequest {
	op := &aws.Operation{
		Name:       opDeregisterTransitGatewayMulticastGroupSources,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeregisterTransitGatewayMulticastGroupSourcesInput{}
	}

	req := c.newRequest(op, input, &DeregisterTransitGatewayMulticastGroupSourcesOutput{})
	return DeregisterTransitGatewayMulticastGroupSourcesRequest{Request: req, Input: input, Copy: c.DeregisterTransitGatewayMulticastGroupSourcesRequest}
}

// DeregisterTransitGatewayMulticastGroupSourcesRequest is the request type for the
// DeregisterTransitGatewayMulticastGroupSources API operation.
type DeregisterTransitGatewayMulticastGroupSourcesRequest struct {
	*aws.Request
	Input *DeregisterTransitGatewayMulticastGroupSourcesInput
	Copy  func(*DeregisterTransitGatewayMulticastGroupSourcesInput) DeregisterTransitGatewayMulticastGroupSourcesRequest
}

// Send marshals and sends the DeregisterTransitGatewayMulticastGroupSources API request.
func (r DeregisterTransitGatewayMulticastGroupSourcesRequest) Send(ctx context.Context) (*DeregisterTransitGatewayMulticastGroupSourcesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeregisterTransitGatewayMulticastGroupSourcesResponse{
		DeregisterTransitGatewayMulticastGroupSourcesOutput: r.Request.Data.(*DeregisterTransitGatewayMulticastGroupSourcesOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeregisterTransitGatewayMulticastGroupSourcesResponse is the response type for the
// DeregisterTransitGatewayMulticastGroupSources API operation.
type DeregisterTransitGatewayMulticastGroupSourcesResponse struct {
	*DeregisterTransitGatewayMulticastGroupSourcesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeregisterTransitGatewayMulticastGroupSources request.
func (r *DeregisterTransitGatewayMulticastGroupSourcesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
