// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package directconnect

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeInterconnectsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the interconnect.
	InterconnectId *string `locationName:"interconnectId" type:"string"`
}

// String returns the string representation
func (s DescribeInterconnectsInput) String() string {
	return awsutil.Prettify(s)
}

type DescribeInterconnectsOutput struct {
	_ struct{} `type:"structure"`

	// The interconnects.
	Interconnects []Interconnect `locationName:"interconnects" type:"list"`
}

// String returns the string representation
func (s DescribeInterconnectsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeInterconnects = "DescribeInterconnects"

// DescribeInterconnectsRequest returns a request value for making API operation for
// AWS Direct Connect.
//
// Lists the interconnects owned by the AWS account or only the specified interconnect.
//
//    // Example sending a request using DescribeInterconnectsRequest.
//    req := client.DescribeInterconnectsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeInterconnects
func (c *Client) DescribeInterconnectsRequest(input *DescribeInterconnectsInput) DescribeInterconnectsRequest {
	op := &aws.Operation{
		Name:       opDescribeInterconnects,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeInterconnectsInput{}
	}

	req := c.newRequest(op, input, &DescribeInterconnectsOutput{})
	return DescribeInterconnectsRequest{Request: req, Input: input, Copy: c.DescribeInterconnectsRequest}
}

// DescribeInterconnectsRequest is the request type for the
// DescribeInterconnects API operation.
type DescribeInterconnectsRequest struct {
	*aws.Request
	Input *DescribeInterconnectsInput
	Copy  func(*DescribeInterconnectsInput) DescribeInterconnectsRequest
}

// Send marshals and sends the DescribeInterconnects API request.
func (r DescribeInterconnectsRequest) Send(ctx context.Context) (*DescribeInterconnectsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeInterconnectsResponse{
		DescribeInterconnectsOutput: r.Request.Data.(*DescribeInterconnectsOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeInterconnectsResponse is the response type for the
// DescribeInterconnects API operation.
type DescribeInterconnectsResponse struct {
	*DescribeInterconnectsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeInterconnects request.
func (r *DescribeInterconnectsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
