// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package configservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeAggregateComplianceByConfigRulesInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration aggregator.
	//
	// ConfigurationAggregatorName is a required field
	ConfigurationAggregatorName *string `min:"1" type:"string" required:"true"`

	// Filters the results by ConfigRuleComplianceFilters object.
	Filters *ConfigRuleComplianceFilters `type:"structure"`

	// The maximum number of evaluation results returned on each page. The default
	// is maximum. If you specify 0, AWS Config uses the default.
	Limit *int64 `type:"integer"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeAggregateComplianceByConfigRulesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAggregateComplianceByConfigRulesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeAggregateComplianceByConfigRulesInput"}

	if s.ConfigurationAggregatorName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ConfigurationAggregatorName"))
	}
	if s.ConfigurationAggregatorName != nil && len(*s.ConfigurationAggregatorName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ConfigurationAggregatorName", 1))
	}
	if s.Filters != nil {
		if err := s.Filters.Validate(); err != nil {
			invalidParams.AddNested("Filters", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeAggregateComplianceByConfigRulesOutput struct {
	_ struct{} `type:"structure"`

	// Returns a list of AggregateComplianceByConfigRule object.
	AggregateComplianceByConfigRules []AggregateComplianceByConfigRule `type:"list"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeAggregateComplianceByConfigRulesOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeAggregateComplianceByConfigRules = "DescribeAggregateComplianceByConfigRules"

// DescribeAggregateComplianceByConfigRulesRequest returns a request value for making API operation for
// AWS Config.
//
// Returns a list of compliant and noncompliant rules with the number of resources
// for compliant and noncompliant rules.
//
// The results can return an empty result page, but if you have a nextToken,
// the results are displayed on the next page.
//
//    // Example sending a request using DescribeAggregateComplianceByConfigRulesRequest.
//    req := client.DescribeAggregateComplianceByConfigRulesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeAggregateComplianceByConfigRules
func (c *Client) DescribeAggregateComplianceByConfigRulesRequest(input *DescribeAggregateComplianceByConfigRulesInput) DescribeAggregateComplianceByConfigRulesRequest {
	op := &aws.Operation{
		Name:       opDescribeAggregateComplianceByConfigRules,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAggregateComplianceByConfigRulesInput{}
	}

	req := c.newRequest(op, input, &DescribeAggregateComplianceByConfigRulesOutput{})
	return DescribeAggregateComplianceByConfigRulesRequest{Request: req, Input: input, Copy: c.DescribeAggregateComplianceByConfigRulesRequest}
}

// DescribeAggregateComplianceByConfigRulesRequest is the request type for the
// DescribeAggregateComplianceByConfigRules API operation.
type DescribeAggregateComplianceByConfigRulesRequest struct {
	*aws.Request
	Input *DescribeAggregateComplianceByConfigRulesInput
	Copy  func(*DescribeAggregateComplianceByConfigRulesInput) DescribeAggregateComplianceByConfigRulesRequest
}

// Send marshals and sends the DescribeAggregateComplianceByConfigRules API request.
func (r DescribeAggregateComplianceByConfigRulesRequest) Send(ctx context.Context) (*DescribeAggregateComplianceByConfigRulesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeAggregateComplianceByConfigRulesResponse{
		DescribeAggregateComplianceByConfigRulesOutput: r.Request.Data.(*DescribeAggregateComplianceByConfigRulesOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeAggregateComplianceByConfigRulesResponse is the response type for the
// DescribeAggregateComplianceByConfigRules API operation.
type DescribeAggregateComplianceByConfigRulesResponse struct {
	*DescribeAggregateComplianceByConfigRulesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeAggregateComplianceByConfigRules request.
func (r *DescribeAggregateComplianceByConfigRulesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
