// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package comprehend

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeSentimentDetectionJobInput struct {
	_ struct{} `type:"structure"`

	// The identifier that Amazon Comprehend generated for the job. The operation
	// returns this identifier in its response.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeSentimentDetectionJobInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeSentimentDetectionJobInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeSentimentDetectionJobInput"}

	if s.JobId == nil {
		invalidParams.Add(aws.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeSentimentDetectionJobOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains the properties associated with a sentiment detection
	// job.
	SentimentDetectionJobProperties *SentimentDetectionJobProperties `type:"structure"`
}

// String returns the string representation
func (s DescribeSentimentDetectionJobOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeSentimentDetectionJob = "DescribeSentimentDetectionJob"

// DescribeSentimentDetectionJobRequest returns a request value for making API operation for
// Amazon Comprehend.
//
// Gets the properties associated with a sentiment detection job. Use this operation
// to get the status of a detection job.
//
//    // Example sending a request using DescribeSentimentDetectionJobRequest.
//    req := client.DescribeSentimentDetectionJobRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeSentimentDetectionJob
func (c *Client) DescribeSentimentDetectionJobRequest(input *DescribeSentimentDetectionJobInput) DescribeSentimentDetectionJobRequest {
	op := &aws.Operation{
		Name:       opDescribeSentimentDetectionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSentimentDetectionJobInput{}
	}

	req := c.newRequest(op, input, &DescribeSentimentDetectionJobOutput{})
	return DescribeSentimentDetectionJobRequest{Request: req, Input: input, Copy: c.DescribeSentimentDetectionJobRequest}
}

// DescribeSentimentDetectionJobRequest is the request type for the
// DescribeSentimentDetectionJob API operation.
type DescribeSentimentDetectionJobRequest struct {
	*aws.Request
	Input *DescribeSentimentDetectionJobInput
	Copy  func(*DescribeSentimentDetectionJobInput) DescribeSentimentDetectionJobRequest
}

// Send marshals and sends the DescribeSentimentDetectionJob API request.
func (r DescribeSentimentDetectionJobRequest) Send(ctx context.Context) (*DescribeSentimentDetectionJobResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeSentimentDetectionJobResponse{
		DescribeSentimentDetectionJobOutput: r.Request.Data.(*DescribeSentimentDetectionJobOutput),
		response:                            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeSentimentDetectionJobResponse is the response type for the
// DescribeSentimentDetectionJob API operation.
type DescribeSentimentDetectionJobResponse struct {
	*DescribeSentimentDetectionJobOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeSentimentDetectionJob request.
func (r *DescribeSentimentDetectionJobResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
