// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package waf

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteGeoMatchSetInput struct {
	_ struct{} `type:"structure"`

	// The value returned by the most recent call to GetChangeToken.
	//
	// ChangeToken is a required field
	ChangeToken *string `min:"1" type:"string" required:"true"`

	// The GeoMatchSetID of the GeoMatchSet that you want to delete. GeoMatchSetId
	// is returned by CreateGeoMatchSet and by ListGeoMatchSets.
	//
	// GeoMatchSetId is a required field
	GeoMatchSetId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteGeoMatchSetInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteGeoMatchSetInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteGeoMatchSetInput"}

	if s.ChangeToken == nil {
		invalidParams.Add(aws.NewErrParamRequired("ChangeToken"))
	}
	if s.ChangeToken != nil && len(*s.ChangeToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ChangeToken", 1))
	}

	if s.GeoMatchSetId == nil {
		invalidParams.Add(aws.NewErrParamRequired("GeoMatchSetId"))
	}
	if s.GeoMatchSetId != nil && len(*s.GeoMatchSetId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("GeoMatchSetId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteGeoMatchSetOutput struct {
	_ struct{} `type:"structure"`

	// The ChangeToken that you used to submit the DeleteGeoMatchSet request. You
	// can also use this value to query the status of the request. For more information,
	// see GetChangeTokenStatus.
	ChangeToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DeleteGeoMatchSetOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteGeoMatchSet = "DeleteGeoMatchSet"

// DeleteGeoMatchSetRequest returns a request value for making API operation for
// AWS WAF.
//
// Permanently deletes a GeoMatchSet. You can't delete a GeoMatchSet if it's
// still used in any Rules or if it still includes any countries.
//
// If you just want to remove a GeoMatchSet from a Rule, use UpdateRule.
//
// To permanently delete a GeoMatchSet from AWS WAF, perform the following steps:
//
// Update the GeoMatchSet to remove any countries. For more information, see
// UpdateGeoMatchSet.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of a DeleteGeoMatchSet request.
//
// Submit a DeleteGeoMatchSet request.
//
//    // Example sending a request using DeleteGeoMatchSetRequest.
//    req := client.DeleteGeoMatchSetRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/DeleteGeoMatchSet
func (c *Client) DeleteGeoMatchSetRequest(input *DeleteGeoMatchSetInput) DeleteGeoMatchSetRequest {
	op := &aws.Operation{
		Name:       opDeleteGeoMatchSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteGeoMatchSetInput{}
	}

	req := c.newRequest(op, input, &DeleteGeoMatchSetOutput{})
	return DeleteGeoMatchSetRequest{Request: req, Input: input, Copy: c.DeleteGeoMatchSetRequest}
}

// DeleteGeoMatchSetRequest is the request type for the
// DeleteGeoMatchSet API operation.
type DeleteGeoMatchSetRequest struct {
	*aws.Request
	Input *DeleteGeoMatchSetInput
	Copy  func(*DeleteGeoMatchSetInput) DeleteGeoMatchSetRequest
}

// Send marshals and sends the DeleteGeoMatchSet API request.
func (r DeleteGeoMatchSetRequest) Send(ctx context.Context) (*DeleteGeoMatchSetResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteGeoMatchSetResponse{
		DeleteGeoMatchSetOutput: r.Request.Data.(*DeleteGeoMatchSetOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteGeoMatchSetResponse is the response type for the
// DeleteGeoMatchSet API operation.
type DeleteGeoMatchSetResponse struct {
	*DeleteGeoMatchSetOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteGeoMatchSet request.
func (r *DeleteGeoMatchSetResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
