// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package redshift

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeLoggingStatusInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the cluster from which to get the logging status.
	//
	// Example: examplecluster
	//
	// ClusterIdentifier is a required field
	ClusterIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeLoggingStatusInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeLoggingStatusInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeLoggingStatusInput"}

	if s.ClusterIdentifier == nil {
		invalidParams.Add(aws.NewErrParamRequired("ClusterIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes the status of logging for a cluster.
type DescribeLoggingStatusOutput struct {
	_ struct{} `type:"structure"`

	// The name of the S3 bucket where the log files are stored.
	BucketName *string `type:"string"`

	// The message indicating that logs failed to be delivered.
	LastFailureMessage *string `type:"string"`

	// The last time when logs failed to be delivered.
	LastFailureTime *time.Time `type:"timestamp"`

	// The last time that logs were delivered.
	LastSuccessfulDeliveryTime *time.Time `type:"timestamp"`

	// true if logging is on, false if logging is off.
	LoggingEnabled *bool `type:"boolean"`

	// The prefix applied to the log file names.
	S3KeyPrefix *string `type:"string"`
}

// String returns the string representation
func (s DescribeLoggingStatusOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeLoggingStatus = "DescribeLoggingStatus"

// DescribeLoggingStatusRequest returns a request value for making API operation for
// Amazon Redshift.
//
// Describes whether information, such as queries and connection attempts, is
// being logged for the specified Amazon Redshift cluster.
//
//    // Example sending a request using DescribeLoggingStatusRequest.
//    req := client.DescribeLoggingStatusRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeLoggingStatus
func (c *Client) DescribeLoggingStatusRequest(input *DescribeLoggingStatusInput) DescribeLoggingStatusRequest {
	op := &aws.Operation{
		Name:       opDescribeLoggingStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeLoggingStatusInput{}
	}

	req := c.newRequest(op, input, &DescribeLoggingStatusOutput{})
	return DescribeLoggingStatusRequest{Request: req, Input: input, Copy: c.DescribeLoggingStatusRequest}
}

// DescribeLoggingStatusRequest is the request type for the
// DescribeLoggingStatus API operation.
type DescribeLoggingStatusRequest struct {
	*aws.Request
	Input *DescribeLoggingStatusInput
	Copy  func(*DescribeLoggingStatusInput) DescribeLoggingStatusRequest
}

// Send marshals and sends the DescribeLoggingStatus API request.
func (r DescribeLoggingStatusRequest) Send(ctx context.Context) (*DescribeLoggingStatusResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeLoggingStatusResponse{
		DescribeLoggingStatusOutput: r.Request.Data.(*DescribeLoggingStatusOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeLoggingStatusResponse is the response type for the
// DescribeLoggingStatus API operation.
type DescribeLoggingStatusResponse struct {
	*DescribeLoggingStatusOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeLoggingStatus request.
func (r *DescribeLoggingStatusResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
