// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package autoscaling

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/query"
)

type DeleteAutoScalingGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// Specifies that the group is to be deleted along with all instances associated
	// with the group, without waiting for all instances to be terminated. This
	// parameter also deletes any lifecycle actions associated with the group.
	ForceDelete *bool `type:"boolean"`
}

// String returns the string representation
func (s DeleteAutoScalingGroupInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAutoScalingGroupInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteAutoScalingGroupInput"}

	if s.AutoScalingGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AutoScalingGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteAutoScalingGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteAutoScalingGroupOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteAutoScalingGroup = "DeleteAutoScalingGroup"

// DeleteAutoScalingGroupRequest returns a request value for making API operation for
// Auto Scaling.
//
// Deletes the specified Auto Scaling group.
//
// If the group has instances or scaling activities in progress, you must specify
// the option to force the deletion in order for it to succeed.
//
// If the group has policies, deleting the group deletes the policies, the underlying
// alarm actions, and any alarm that no longer has an associated action.
//
// To remove instances from the Auto Scaling group before deleting it, call
// DetachInstances with the list of instances and the option to decrement the
// desired capacity. This ensures that Amazon EC2 Auto Scaling does not launch
// replacement instances.
//
// To terminate all instances before deleting the Auto Scaling group, call UpdateAutoScalingGroup
// and set the minimum size and desired capacity of the Auto Scaling group to
// zero.
//
//    // Example sending a request using DeleteAutoScalingGroupRequest.
//    req := client.DeleteAutoScalingGroupRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DeleteAutoScalingGroup
func (c *Client) DeleteAutoScalingGroupRequest(input *DeleteAutoScalingGroupInput) DeleteAutoScalingGroupRequest {
	op := &aws.Operation{
		Name:       opDeleteAutoScalingGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAutoScalingGroupInput{}
	}

	req := c.newRequest(op, input, &DeleteAutoScalingGroupOutput{})
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DeleteAutoScalingGroupRequest{Request: req, Input: input, Copy: c.DeleteAutoScalingGroupRequest}
}

// DeleteAutoScalingGroupRequest is the request type for the
// DeleteAutoScalingGroup API operation.
type DeleteAutoScalingGroupRequest struct {
	*aws.Request
	Input *DeleteAutoScalingGroupInput
	Copy  func(*DeleteAutoScalingGroupInput) DeleteAutoScalingGroupRequest
}

// Send marshals and sends the DeleteAutoScalingGroup API request.
func (r DeleteAutoScalingGroupRequest) Send(ctx context.Context) (*DeleteAutoScalingGroupResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteAutoScalingGroupResponse{
		DeleteAutoScalingGroupOutput: r.Request.Data.(*DeleteAutoScalingGroupOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteAutoScalingGroupResponse is the response type for the
// DeleteAutoScalingGroup API operation.
type DeleteAutoScalingGroupResponse struct {
	*DeleteAutoScalingGroupOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteAutoScalingGroup request.
func (r *DeleteAutoScalingGroupResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
