// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package wafregional_test

import (
	"context"
	"fmt"
	"strings"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/aws/awserr"
	"github.com/aws/aws-sdk-go-v2/aws/external"
	"github.com/aws/aws-sdk-go-v2/service/waf"
	"github.com/aws/aws-sdk-go-v2/service/wafregional"
)

var _ time.Duration
var _ strings.Reader
var _ aws.Config

func parseTime(layout, value string) *time.Time {
	t, err := time.Parse(layout, value)
	if err != nil {
		panic(err)
	}
	return &t
}

// To create an IP set
//
// The following example creates an IP match set named MyIPSetFriendlyName.
func ExampleClient_CreateIPSetRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := wafregional.New(cfg)
	input := &wafregional.CreateIPSetInput{
		ChangeToken: aws.String("abcd12f2-46da-4fdb-b8d5-fbd4c466928f"),
		Name:        aws.String("MyIPSetFriendlyName"),
	}

	req := svc.CreateIPSetRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case wafregional.ErrCodeWAFStaleDataException:
				fmt.Println(wafregional.ErrCodeWAFStaleDataException, aerr.Error())
			case wafregional.ErrCodeWAFInternalErrorException:
				fmt.Println(wafregional.ErrCodeWAFInternalErrorException, aerr.Error())
			case wafregional.ErrCodeWAFInvalidAccountException:
				fmt.Println(wafregional.ErrCodeWAFInvalidAccountException, aerr.Error())
			case wafregional.ErrCodeWAFDisallowedNameException:
				fmt.Println(wafregional.ErrCodeWAFDisallowedNameException, aerr.Error())
			case wafregional.ErrCodeWAFInvalidParameterException:
				fmt.Println(wafregional.ErrCodeWAFInvalidParameterException, aerr.Error())
			case wafregional.ErrCodeWAFLimitsExceededException:
				fmt.Println(wafregional.ErrCodeWAFLimitsExceededException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a rule
//
// The following example creates a rule named WAFByteHeaderRule.
func ExampleClient_CreateRuleRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := wafregional.New(cfg)
	input := &wafregional.CreateRuleInput{
		ChangeToken: aws.String("abcd12f2-46da-4fdb-b8d5-fbd4c466928f"),
		MetricName:  aws.String("WAFByteHeaderRule"),
		Name:        aws.String("WAFByteHeaderRule"),
	}

	req := svc.CreateRuleRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case wafregional.ErrCodeWAFStaleDataException:
				fmt.Println(wafregional.ErrCodeWAFStaleDataException, aerr.Error())
			case wafregional.ErrCodeWAFInternalErrorException:
				fmt.Println(wafregional.ErrCodeWAFInternalErrorException, aerr.Error())
			case wafregional.ErrCodeWAFDisallowedNameException:
				fmt.Println(wafregional.ErrCodeWAFDisallowedNameException, aerr.Error())
			case wafregional.ErrCodeWAFInvalidParameterException:
				fmt.Println(wafregional.ErrCodeWAFInvalidParameterException, aerr.Error())
			case wafregional.ErrCodeWAFLimitsExceededException:
				fmt.Println(wafregional.ErrCodeWAFLimitsExceededException, aerr.Error())
			case wafregional.ErrCodeWAFTagOperationException:
				fmt.Println(wafregional.ErrCodeWAFTagOperationException, aerr.Error())
			case wafregional.ErrCodeWAFTagOperationInternalErrorException:
				fmt.Println(wafregional.ErrCodeWAFTagOperationInternalErrorException, aerr.Error())
			case wafregional.ErrCodeWAFBadRequestException:
				fmt.Println(wafregional.ErrCodeWAFBadRequestException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a size constraint
//
// The following example creates size constraint set named MySampleSizeConstraintSet.
func ExampleClient_CreateSizeConstraintSetRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := wafregional.New(cfg)
	input := &wafregional.CreateSizeConstraintSetInput{
		ChangeToken: aws.String("abcd12f2-46da-4fdb-b8d5-fbd4c466928f"),
		Name:        aws.String("MySampleSizeConstraintSet"),
	}

	req := svc.CreateSizeConstraintSetRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case wafregional.ErrCodeWAFStaleDataException:
				fmt.Println(wafregional.ErrCodeWAFStaleDataException, aerr.Error())
			case wafregional.ErrCodeWAFInternalErrorException:
				fmt.Println(wafregional.ErrCodeWAFInternalErrorException, aerr.Error())
			case wafregional.ErrCodeWAFInvalidAccountException:
				fmt.Println(wafregional.ErrCodeWAFInvalidAccountException, aerr.Error())
			case wafregional.ErrCodeWAFDisallowedNameException:
				fmt.Println(wafregional.ErrCodeWAFDisallowedNameException, aerr.Error())
			case wafregional.ErrCodeWAFInvalidParameterException:
				fmt.Println(wafregional.ErrCodeWAFInvalidParameterException, aerr.Error())
			case wafregional.ErrCodeWAFLimitsExceededException:
				fmt.Println(wafregional.ErrCodeWAFLimitsExceededException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a SQL injection match set
//
// The following example creates a SQL injection match set named MySQLInjectionMatchSet.
func ExampleClient_CreateSqlInjectionMatchSetRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := wafregional.New(cfg)
	input := &wafregional.CreateSqlInjectionMatchSetInput{
		ChangeToken: aws.String("abcd12f2-46da-4fdb-b8d5-fbd4c466928f"),
		Name:        aws.String("MySQLInjectionMatchSet"),
	}

	req := svc.CreateSqlInjectionMatchSetRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case wafregional.ErrCodeWAFDisallowedNameException:
				fmt.Println(wafregional.ErrCodeWAFDisallowedNameException, aerr.Error())
			case wafregional.ErrCodeWAFInternalErrorException:
				fmt.Println(wafregional.ErrCodeWAFInternalErrorException, aerr.Error())
			case wafregional.ErrCodeWAFInvalidAccountException:
				fmt.Println(wafregional.ErrCodeWAFInvalidAccountException, aerr.Error())
			case wafregional.ErrCodeWAFInvalidParameterException:
				fmt.Println(wafregional.ErrCodeWAFInvalidParameterException, aerr.Error())
			case wafregional.ErrCodeWAFStaleDataException:
				fmt.Println(wafregional.ErrCodeWAFStaleDataException, aerr.Error())
			case wafregional.ErrCodeWAFLimitsExceededException:
				fmt.Println(wafregional.ErrCodeWAFLimitsExceededException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a web ACL
//
// The following example creates a web ACL named CreateExample.
func ExampleClient_CreateWebACLRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := wafregional.New(cfg)
	input := &wafregional.CreateWebACLInput{
		ChangeToken: aws.String("abcd12f2-46da-4fdb-b8d5-fbd4c466928f"),
		DefaultAction: &waf.WafAction{
			Type: waf.WafActionTypeAllow,
		},
		MetricName: aws.String("CreateExample"),
		Name:       aws.String("CreateExample"),
	}

	req := svc.CreateWebACLRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case wafregional.ErrCodeWAFStaleDataException:
				fmt.Println(wafregional.ErrCodeWAFStaleDataException, aerr.Error())
			case wafregional.ErrCodeWAFInternalErrorException:
				fmt.Println(wafregional.ErrCodeWAFInternalErrorException, aerr.Error())
			case wafregional.ErrCodeWAFInvalidAccountException:
				fmt.Println(wafregional.ErrCodeWAFInvalidAccountException, aerr.Error())
			case wafregional.ErrCodeWAFDisallowedNameException:
				fmt.Println(wafregional.ErrCodeWAFDisallowedNameException, aerr.Error())
			case wafregional.ErrCodeWAFInvalidParameterException:
				fmt.Println(wafregional.ErrCodeWAFInvalidParameterException, aerr.Error())
			case wafregional.ErrCodeWAFLimitsExceededException:
				fmt.Println(wafregional.ErrCodeWAFLimitsExceededException, aerr.Error())
			case wafregional.ErrCodeWAFTagOperationException:
				fmt.Println(wafregional.ErrCodeWAFTagOperationException, aerr.Error())
			case wafregional.ErrCodeWAFTagOperationInternalErrorException:
				fmt.Println(wafregional.ErrCodeWAFTagOperationInternalErrorException, aerr.Error())
			case wafregional.ErrCodeWAFBadRequestException:
				fmt.Println(wafregional.ErrCodeWAFBadRequestException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create an XSS match set
//
// The following example creates an XSS match set named MySampleXssMatchSet.
func ExampleClient_CreateXssMatchSetRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := wafregional.New(cfg)
	input := &wafregional.CreateXssMatchSetInput{
		ChangeToken: aws.String("abcd12f2-46da-4fdb-b8d5-fbd4c466928f"),
		Name:        aws.String("MySampleXssMatchSet"),
	}

	req := svc.CreateXssMatchSetRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case wafregional.ErrCodeWAFDisallowedNameException:
				fmt.Println(wafregional.ErrCodeWAFDisallowedNameException, aerr.Error())
			case wafregional.ErrCodeWAFInternalErrorException:
				fmt.Println(wafregional.ErrCodeWAFInternalErrorException, aerr.Error())
			case wafregional.ErrCodeWAFInvalidAccountException:
				fmt.Println(wafregional.ErrCodeWAFInvalidAccountException, aerr.Error())
			case wafregional.ErrCodeWAFInvalidParameterException:
				fmt.Println(wafregional.ErrCodeWAFInvalidParameterException, aerr.Error())
			case wafregional.ErrCodeWAFStaleDataException:
				fmt.Println(wafregional.ErrCodeWAFStaleDataException, aerr.Error())
			case wafregional.ErrCodeWAFLimitsExceededException:
				fmt.Println(wafregional.ErrCodeWAFLimitsExceededException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a byte match set
//
// The following example deletes a byte match set with the ID exampleIDs3t-46da-4fdb-b8d5-abc321j569j5.
func ExampleClient_DeleteByteMatchSetRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := wafregional.New(cfg)
	input := &wafregional.DeleteByteMatchSetInput{
		ByteMatchSetId: aws.String("exampleIDs3t-46da-4fdb-b8d5-abc321j569j5"),
		ChangeToken:    aws.String("abcd12f2-46da-4fdb-b8d5-fbd4c466928f"),
	}

	req := svc.DeleteByteMatchSetRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case wafregional.ErrCodeWAFInternalErrorException:
				fmt.Println(wafregional.ErrCodeWAFInternalErrorException, aerr.Error())
			case wafregional.ErrCodeWAFInvalidAccountException:
				fmt.Println(wafregional.ErrCodeWAFInvalidAccountException, aerr.Error())
			case wafregional.ErrCodeWAFNonexistentItemException:
				fmt.Println(wafregional.ErrCodeWAFNonexistentItemException, aerr.Error())
			case wafregional.ErrCodeWAFReferencedItemException:
				fmt.Println(wafregional.ErrCodeWAFReferencedItemException, aerr.Error())
			case wafregional.ErrCodeWAFStaleDataException:
				fmt.Println(wafregional.ErrCodeWAFStaleDataException, aerr.Error())
			case wafregional.ErrCodeWAFNonEmptyEntityException:
				fmt.Println(wafregional.ErrCodeWAFNonEmptyEntityException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete an IP set
//
// The following example deletes an IP match set with the ID example1ds3t-46da-4fdb-b8d5-abc321j569j5.
func ExampleClient_DeleteIPSetRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := wafregional.New(cfg)
	input := &wafregional.DeleteIPSetInput{
		ChangeToken: aws.String("abcd12f2-46da-4fdb-b8d5-fbd4c466928f"),
		IPSetId:     aws.String("example1ds3t-46da-4fdb-b8d5-abc321j569j5"),
	}

	req := svc.DeleteIPSetRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case wafregional.ErrCodeWAFStaleDataException:
				fmt.Println(wafregional.ErrCodeWAFStaleDataException, aerr.Error())
			case wafregional.ErrCodeWAFInternalErrorException:
				fmt.Println(wafregional.ErrCodeWAFInternalErrorException, aerr.Error())
			case wafregional.ErrCodeWAFInvalidAccountException:
				fmt.Println(wafregional.ErrCodeWAFInvalidAccountException, aerr.Error())
			case wafregional.ErrCodeWAFNonexistentItemException:
				fmt.Println(wafregional.ErrCodeWAFNonexistentItemException, aerr.Error())
			case wafregional.ErrCodeWAFReferencedItemException:
				fmt.Println(wafregional.ErrCodeWAFReferencedItemException, aerr.Error())
			case wafregional.ErrCodeWAFNonEmptyEntityException:
				fmt.Println(wafregional.ErrCodeWAFNonEmptyEntityException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a rule
//
// The following example deletes a rule with the ID WAFRule-1-Example.
func ExampleClient_DeleteRuleRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := wafregional.New(cfg)
	input := &wafregional.DeleteRuleInput{
		ChangeToken: aws.String("abcd12f2-46da-4fdb-b8d5-fbd4c466928f"),
		RuleId:      aws.String("WAFRule-1-Example"),
	}

	req := svc.DeleteRuleRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case wafregional.ErrCodeWAFStaleDataException:
				fmt.Println(wafregional.ErrCodeWAFStaleDataException, aerr.Error())
			case wafregional.ErrCodeWAFInternalErrorException:
				fmt.Println(wafregional.ErrCodeWAFInternalErrorException, aerr.Error())
			case wafregional.ErrCodeWAFInvalidAccountException:
				fmt.Println(wafregional.ErrCodeWAFInvalidAccountException, aerr.Error())
			case wafregional.ErrCodeWAFNonexistentItemException:
				fmt.Println(wafregional.ErrCodeWAFNonexistentItemException, aerr.Error())
			case wafregional.ErrCodeWAFReferencedItemException:
				fmt.Println(wafregional.ErrCodeWAFReferencedItemException, aerr.Error())
			case wafregional.ErrCodeWAFNonEmptyEntityException:
				fmt.Println(wafregional.ErrCodeWAFNonEmptyEntityException, aerr.Error())
			case wafregional.ErrCodeWAFTagOperationException:
				fmt.Println(wafregional.ErrCodeWAFTagOperationException, aerr.Error())
			case wafregional.ErrCodeWAFTagOperationInternalErrorException:
				fmt.Println(wafregional.ErrCodeWAFTagOperationInternalErrorException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a size constraint set
//
// The following example deletes a size constraint set with the ID example1ds3t-46da-4fdb-b8d5-abc321j569j5.
func ExampleClient_DeleteSizeConstraintSetRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := wafregional.New(cfg)
	input := &wafregional.DeleteSizeConstraintSetInput{
		ChangeToken:         aws.String("abcd12f2-46da-4fdb-b8d5-fbd4c466928f"),
		SizeConstraintSetId: aws.String("example1ds3t-46da-4fdb-b8d5-abc321j569j5"),
	}

	req := svc.DeleteSizeConstraintSetRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case wafregional.ErrCodeWAFStaleDataException:
				fmt.Println(wafregional.ErrCodeWAFStaleDataException, aerr.Error())
			case wafregional.ErrCodeWAFInternalErrorException:
				fmt.Println(wafregional.ErrCodeWAFInternalErrorException, aerr.Error())
			case wafregional.ErrCodeWAFInvalidAccountException:
				fmt.Println(wafregional.ErrCodeWAFInvalidAccountException, aerr.Error())
			case wafregional.ErrCodeWAFNonexistentItemException:
				fmt.Println(wafregional.ErrCodeWAFNonexistentItemException, aerr.Error())
			case wafregional.ErrCodeWAFReferencedItemException:
				fmt.Println(wafregional.ErrCodeWAFReferencedItemException, aerr.Error())
			case wafregional.ErrCodeWAFNonEmptyEntityException:
				fmt.Println(wafregional.ErrCodeWAFNonEmptyEntityException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a SQL injection match set
//
// The following example deletes a SQL injection match set with the ID example1ds3t-46da-4fdb-b8d5-abc321j569j5.
func ExampleClient_DeleteSqlInjectionMatchSetRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := wafregional.New(cfg)
	input := &wafregional.DeleteSqlInjectionMatchSetInput{
		ChangeToken:            aws.String("abcd12f2-46da-4fdb-b8d5-fbd4c466928f"),
		SqlInjectionMatchSetId: aws.String("example1ds3t-46da-4fdb-b8d5-abc321j569j5"),
	}

	req := svc.DeleteSqlInjectionMatchSetRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case wafregional.ErrCodeWAFInternalErrorException:
				fmt.Println(wafregional.ErrCodeWAFInternalErrorException, aerr.Error())
			case wafregional.ErrCodeWAFInvalidAccountException:
				fmt.Println(wafregional.ErrCodeWAFInvalidAccountException, aerr.Error())
			case wafregional.ErrCodeWAFNonexistentItemException:
				fmt.Println(wafregional.ErrCodeWAFNonexistentItemException, aerr.Error())
			case wafregional.ErrCodeWAFReferencedItemException:
				fmt.Println(wafregional.ErrCodeWAFReferencedItemException, aerr.Error())
			case wafregional.ErrCodeWAFStaleDataException:
				fmt.Println(wafregional.ErrCodeWAFStaleDataException, aerr.Error())
			case wafregional.ErrCodeWAFNonEmptyEntityException:
				fmt.Println(wafregional.ErrCodeWAFNonEmptyEntityException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a web ACL
//
// The following example deletes a web ACL with the ID example-46da-4444-5555-example.
func ExampleClient_DeleteWebACLRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := wafregional.New(cfg)
	input := &wafregional.DeleteWebACLInput{
		ChangeToken: aws.String("abcd12f2-46da-4fdb-b8d5-fbd4c466928f"),
		WebACLId:    aws.String("example-46da-4444-5555-example"),
	}

	req := svc.DeleteWebACLRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case wafregional.ErrCodeWAFStaleDataException:
				fmt.Println(wafregional.ErrCodeWAFStaleDataException, aerr.Error())
			case wafregional.ErrCodeWAFInternalErrorException:
				fmt.Println(wafregional.ErrCodeWAFInternalErrorException, aerr.Error())
			case wafregional.ErrCodeWAFInvalidAccountException:
				fmt.Println(wafregional.ErrCodeWAFInvalidAccountException, aerr.Error())
			case wafregional.ErrCodeWAFNonexistentItemException:
				fmt.Println(wafregional.ErrCodeWAFNonexistentItemException, aerr.Error())
			case wafregional.ErrCodeWAFReferencedItemException:
				fmt.Println(wafregional.ErrCodeWAFReferencedItemException, aerr.Error())
			case wafregional.ErrCodeWAFNonEmptyEntityException:
				fmt.Println(wafregional.ErrCodeWAFNonEmptyEntityException, aerr.Error())
			case wafregional.ErrCodeWAFTagOperationException:
				fmt.Println(wafregional.ErrCodeWAFTagOperationException, aerr.Error())
			case wafregional.ErrCodeWAFTagOperationInternalErrorException:
				fmt.Println(wafregional.ErrCodeWAFTagOperationInternalErrorException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete an XSS match set
//
// The following example deletes an XSS match set with the ID example1ds3t-46da-4fdb-b8d5-abc321j569j5.
func ExampleClient_DeleteXssMatchSetRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := wafregional.New(cfg)
	input := &wafregional.DeleteXssMatchSetInput{
		ChangeToken:   aws.String("abcd12f2-46da-4fdb-b8d5-fbd4c466928f"),
		XssMatchSetId: aws.String("example1ds3t-46da-4fdb-b8d5-abc321j569j5"),
	}

	req := svc.DeleteXssMatchSetRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case wafregional.ErrCodeWAFInternalErrorException:
				fmt.Println(wafregional.ErrCodeWAFInternalErrorException, aerr.Error())
			case wafregional.ErrCodeWAFInvalidAccountException:
				fmt.Println(wafregional.ErrCodeWAFInvalidAccountException, aerr.Error())
			case wafregional.ErrCodeWAFNonexistentItemException:
				fmt.Println(wafregional.ErrCodeWAFNonexistentItemException, aerr.Error())
			case wafregional.ErrCodeWAFReferencedItemException:
				fmt.Println(wafregional.ErrCodeWAFReferencedItemException, aerr.Error())
			case wafregional.ErrCodeWAFStaleDataException:
				fmt.Println(wafregional.ErrCodeWAFStaleDataException, aerr.Error())
			case wafregional.ErrCodeWAFNonEmptyEntityException:
				fmt.Println(wafregional.ErrCodeWAFNonEmptyEntityException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get a byte match set
//
// The following example returns the details of a byte match set with the ID exampleIDs3t-46da-4fdb-b8d5-abc321j569j5.
func ExampleClient_GetByteMatchSetRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := wafregional.New(cfg)
	input := &wafregional.GetByteMatchSetInput{
		ByteMatchSetId: aws.String("exampleIDs3t-46da-4fdb-b8d5-abc321j569j5"),
	}

	req := svc.GetByteMatchSetRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case wafregional.ErrCodeWAFInternalErrorException:
				fmt.Println(wafregional.ErrCodeWAFInternalErrorException, aerr.Error())
			case wafregional.ErrCodeWAFInvalidAccountException:
				fmt.Println(wafregional.ErrCodeWAFInvalidAccountException, aerr.Error())
			case wafregional.ErrCodeWAFNonexistentItemException:
				fmt.Println(wafregional.ErrCodeWAFNonexistentItemException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get a change token
//
// The following example returns a change token to use for a create, update or delete
// operation.
func ExampleClient_GetChangeTokenRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := wafregional.New(cfg)
	input := &wafregional.GetChangeTokenInput{}

	req := svc.GetChangeTokenRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case wafregional.ErrCodeWAFInternalErrorException:
				fmt.Println(wafregional.ErrCodeWAFInternalErrorException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get the change token status
//
// The following example returns the status of a change token with the ID abcd12f2-46da-4fdb-b8d5-fbd4c466928f.
func ExampleClient_GetChangeTokenStatusRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := wafregional.New(cfg)
	input := &wafregional.GetChangeTokenStatusInput{
		ChangeToken: aws.String("abcd12f2-46da-4fdb-b8d5-fbd4c466928f"),
	}

	req := svc.GetChangeTokenStatusRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case wafregional.ErrCodeWAFNonexistentItemException:
				fmt.Println(wafregional.ErrCodeWAFNonexistentItemException, aerr.Error())
			case wafregional.ErrCodeWAFInternalErrorException:
				fmt.Println(wafregional.ErrCodeWAFInternalErrorException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get an IP set
//
// The following example returns the details of an IP match set with the ID example1ds3t-46da-4fdb-b8d5-abc321j569j5.
func ExampleClient_GetIPSetRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := wafregional.New(cfg)
	input := &wafregional.GetIPSetInput{
		IPSetId: aws.String("example1ds3t-46da-4fdb-b8d5-abc321j569j5"),
	}

	req := svc.GetIPSetRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case wafregional.ErrCodeWAFInternalErrorException:
				fmt.Println(wafregional.ErrCodeWAFInternalErrorException, aerr.Error())
			case wafregional.ErrCodeWAFInvalidAccountException:
				fmt.Println(wafregional.ErrCodeWAFInvalidAccountException, aerr.Error())
			case wafregional.ErrCodeWAFNonexistentItemException:
				fmt.Println(wafregional.ErrCodeWAFNonexistentItemException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get a rule
//
// The following example returns the details of a rule with the ID example1ds3t-46da-4fdb-b8d5-abc321j569j5.
func ExampleClient_GetRuleRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := wafregional.New(cfg)
	input := &wafregional.GetRuleInput{
		RuleId: aws.String("example1ds3t-46da-4fdb-b8d5-abc321j569j5"),
	}

	req := svc.GetRuleRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case wafregional.ErrCodeWAFInternalErrorException:
				fmt.Println(wafregional.ErrCodeWAFInternalErrorException, aerr.Error())
			case wafregional.ErrCodeWAFInvalidAccountException:
				fmt.Println(wafregional.ErrCodeWAFInvalidAccountException, aerr.Error())
			case wafregional.ErrCodeWAFNonexistentItemException:
				fmt.Println(wafregional.ErrCodeWAFNonexistentItemException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get a sampled requests
//
// The following example returns detailed information about 100 requests --a sample--
// that AWS WAF randomly selects from among the first 5,000 requests that your AWS resource
// received between the time period 2016-09-27T15:50Z to 2016-09-27T15:50Z.
func ExampleClient_GetSampledRequestsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := wafregional.New(cfg)
	input := &wafregional.GetSampledRequestsInput{
		MaxItems: aws.Int64(100),
		RuleId:   aws.String("WAFRule-1-Example"),
		TimeWindow: &waf.TimeWindow{
			EndTime:   parseTime("2006-01-02T15:04:05Z", "2016-09-27T15:50Z"),
			StartTime: parseTime("2006-01-02T15:04:05Z", "2016-09-27T15:50Z"),
		},
		WebAclId: aws.String("createwebacl-1472061481310"),
	}

	req := svc.GetSampledRequestsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case wafregional.ErrCodeWAFNonexistentItemException:
				fmt.Println(wafregional.ErrCodeWAFNonexistentItemException, aerr.Error())
			case wafregional.ErrCodeWAFInternalErrorException:
				fmt.Println(wafregional.ErrCodeWAFInternalErrorException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get a size constraint set
//
// The following example returns the details of a size constraint match set with the
// ID example1ds3t-46da-4fdb-b8d5-abc321j569j5.
func ExampleClient_GetSizeConstraintSetRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := wafregional.New(cfg)
	input := &wafregional.GetSizeConstraintSetInput{
		SizeConstraintSetId: aws.String("example1ds3t-46da-4fdb-b8d5-abc321j569j5"),
	}

	req := svc.GetSizeConstraintSetRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case wafregional.ErrCodeWAFInternalErrorException:
				fmt.Println(wafregional.ErrCodeWAFInternalErrorException, aerr.Error())
			case wafregional.ErrCodeWAFInvalidAccountException:
				fmt.Println(wafregional.ErrCodeWAFInvalidAccountException, aerr.Error())
			case wafregional.ErrCodeWAFNonexistentItemException:
				fmt.Println(wafregional.ErrCodeWAFNonexistentItemException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get a SQL injection match set
//
// The following example returns the details of a SQL injection match set with the ID
// example1ds3t-46da-4fdb-b8d5-abc321j569j5.
func ExampleClient_GetSqlInjectionMatchSetRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := wafregional.New(cfg)
	input := &wafregional.GetSqlInjectionMatchSetInput{
		SqlInjectionMatchSetId: aws.String("example1ds3t-46da-4fdb-b8d5-abc321j569j5"),
	}

	req := svc.GetSqlInjectionMatchSetRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case wafregional.ErrCodeWAFInternalErrorException:
				fmt.Println(wafregional.ErrCodeWAFInternalErrorException, aerr.Error())
			case wafregional.ErrCodeWAFInvalidAccountException:
				fmt.Println(wafregional.ErrCodeWAFInvalidAccountException, aerr.Error())
			case wafregional.ErrCodeWAFNonexistentItemException:
				fmt.Println(wafregional.ErrCodeWAFNonexistentItemException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get a web ACL
//
// The following example returns the details of a web ACL with the ID createwebacl-1472061481310.
func ExampleClient_GetWebACLRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := wafregional.New(cfg)
	input := &wafregional.GetWebACLInput{
		WebACLId: aws.String("createwebacl-1472061481310"),
	}

	req := svc.GetWebACLRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case wafregional.ErrCodeWAFInternalErrorException:
				fmt.Println(wafregional.ErrCodeWAFInternalErrorException, aerr.Error())
			case wafregional.ErrCodeWAFInvalidAccountException:
				fmt.Println(wafregional.ErrCodeWAFInvalidAccountException, aerr.Error())
			case wafregional.ErrCodeWAFNonexistentItemException:
				fmt.Println(wafregional.ErrCodeWAFNonexistentItemException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get an XSS match set
//
// The following example returns the details of an XSS match set with the ID example1ds3t-46da-4fdb-b8d5-abc321j569j5.
func ExampleClient_GetXssMatchSetRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := wafregional.New(cfg)
	input := &wafregional.GetXssMatchSetInput{
		XssMatchSetId: aws.String("example1ds3t-46da-4fdb-b8d5-abc321j569j5"),
	}

	req := svc.GetXssMatchSetRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case wafregional.ErrCodeWAFInternalErrorException:
				fmt.Println(wafregional.ErrCodeWAFInternalErrorException, aerr.Error())
			case wafregional.ErrCodeWAFInvalidAccountException:
				fmt.Println(wafregional.ErrCodeWAFInvalidAccountException, aerr.Error())
			case wafregional.ErrCodeWAFNonexistentItemException:
				fmt.Println(wafregional.ErrCodeWAFNonexistentItemException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list IP sets
//
// The following example returns an array of up to 100 IP match sets.
func ExampleClient_ListIPSetsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := wafregional.New(cfg)
	input := &wafregional.ListIPSetsInput{
		Limit: aws.Int64(100),
	}

	req := svc.ListIPSetsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case wafregional.ErrCodeWAFInternalErrorException:
				fmt.Println(wafregional.ErrCodeWAFInternalErrorException, aerr.Error())
			case wafregional.ErrCodeWAFInvalidAccountException:
				fmt.Println(wafregional.ErrCodeWAFInvalidAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list rules
//
// The following example returns an array of up to 100 rules.
func ExampleClient_ListRulesRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := wafregional.New(cfg)
	input := &wafregional.ListRulesInput{
		Limit: aws.Int64(100),
	}

	req := svc.ListRulesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case wafregional.ErrCodeWAFInternalErrorException:
				fmt.Println(wafregional.ErrCodeWAFInternalErrorException, aerr.Error())
			case wafregional.ErrCodeWAFInvalidAccountException:
				fmt.Println(wafregional.ErrCodeWAFInvalidAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list a size constraint sets
//
// The following example returns an array of up to 100 size contraint match sets.
func ExampleClient_ListSizeConstraintSetsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := wafregional.New(cfg)
	input := &wafregional.ListSizeConstraintSetsInput{
		Limit: aws.Int64(100),
	}

	req := svc.ListSizeConstraintSetsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case wafregional.ErrCodeWAFInternalErrorException:
				fmt.Println(wafregional.ErrCodeWAFInternalErrorException, aerr.Error())
			case wafregional.ErrCodeWAFInvalidAccountException:
				fmt.Println(wafregional.ErrCodeWAFInvalidAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list SQL injection match sets
//
// The following example returns an array of up to 100 SQL injection match sets.
func ExampleClient_ListSqlInjectionMatchSetsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := wafregional.New(cfg)
	input := &wafregional.ListSqlInjectionMatchSetsInput{
		Limit: aws.Int64(100),
	}

	req := svc.ListSqlInjectionMatchSetsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case wafregional.ErrCodeWAFInternalErrorException:
				fmt.Println(wafregional.ErrCodeWAFInternalErrorException, aerr.Error())
			case wafregional.ErrCodeWAFInvalidAccountException:
				fmt.Println(wafregional.ErrCodeWAFInvalidAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list Web ACLs
//
// The following example returns an array of up to 100 web ACLs.
func ExampleClient_ListWebACLsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := wafregional.New(cfg)
	input := &wafregional.ListWebACLsInput{
		Limit: aws.Int64(100),
	}

	req := svc.ListWebACLsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case wafregional.ErrCodeWAFInternalErrorException:
				fmt.Println(wafregional.ErrCodeWAFInternalErrorException, aerr.Error())
			case wafregional.ErrCodeWAFInvalidAccountException:
				fmt.Println(wafregional.ErrCodeWAFInvalidAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list XSS match sets
//
// The following example returns an array of up to 100 XSS match sets.
func ExampleClient_ListXssMatchSetsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := wafregional.New(cfg)
	input := &wafregional.ListXssMatchSetsInput{
		Limit: aws.Int64(100),
	}

	req := svc.ListXssMatchSetsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case wafregional.ErrCodeWAFInternalErrorException:
				fmt.Println(wafregional.ErrCodeWAFInternalErrorException, aerr.Error())
			case wafregional.ErrCodeWAFInvalidAccountException:
				fmt.Println(wafregional.ErrCodeWAFInvalidAccountException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To update a byte match set
//
// The following example deletes a ByteMatchTuple object (filters) in an byte match
// set with the ID exampleIDs3t-46da-4fdb-b8d5-abc321j569j5.
func ExampleClient_UpdateByteMatchSetRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := wafregional.New(cfg)
	input := &wafregional.UpdateByteMatchSetInput{
		ByteMatchSetId: aws.String("exampleIDs3t-46da-4fdb-b8d5-abc321j569j5"),
		ChangeToken:    aws.String("abcd12f2-46da-4fdb-b8d5-fbd4c466928f"),
		Updates: []waf.ByteMatchSetUpdate{
			{
				Action: waf.ChangeActionDelete,
			},
		},
	}

	req := svc.UpdateByteMatchSetRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case wafregional.ErrCodeWAFInternalErrorException:
				fmt.Println(wafregional.ErrCodeWAFInternalErrorException, aerr.Error())
			case wafregional.ErrCodeWAFInvalidAccountException:
				fmt.Println(wafregional.ErrCodeWAFInvalidAccountException, aerr.Error())
			case wafregional.ErrCodeWAFInvalidOperationException:
				fmt.Println(wafregional.ErrCodeWAFInvalidOperationException, aerr.Error())
			case wafregional.ErrCodeWAFInvalidParameterException:
				fmt.Println(wafregional.ErrCodeWAFInvalidParameterException, aerr.Error())
			case wafregional.ErrCodeWAFNonexistentContainerException:
				fmt.Println(wafregional.ErrCodeWAFNonexistentContainerException, aerr.Error())
			case wafregional.ErrCodeWAFNonexistentItemException:
				fmt.Println(wafregional.ErrCodeWAFNonexistentItemException, aerr.Error())
			case wafregional.ErrCodeWAFStaleDataException:
				fmt.Println(wafregional.ErrCodeWAFStaleDataException, aerr.Error())
			case wafregional.ErrCodeWAFLimitsExceededException:
				fmt.Println(wafregional.ErrCodeWAFLimitsExceededException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To update an IP set
//
// The following example deletes an IPSetDescriptor object in an IP match set with the
// ID example1ds3t-46da-4fdb-b8d5-abc321j569j5.
func ExampleClient_UpdateIPSetRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := wafregional.New(cfg)
	input := &wafregional.UpdateIPSetInput{
		ChangeToken: aws.String("abcd12f2-46da-4fdb-b8d5-fbd4c466928f"),
		IPSetId:     aws.String("example1ds3t-46da-4fdb-b8d5-abc321j569j5"),
		Updates: []waf.IPSetUpdate{
			{
				Action: waf.ChangeActionDelete,
			},
		},
	}

	req := svc.UpdateIPSetRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case wafregional.ErrCodeWAFStaleDataException:
				fmt.Println(wafregional.ErrCodeWAFStaleDataException, aerr.Error())
			case wafregional.ErrCodeWAFInternalErrorException:
				fmt.Println(wafregional.ErrCodeWAFInternalErrorException, aerr.Error())
			case wafregional.ErrCodeWAFInvalidAccountException:
				fmt.Println(wafregional.ErrCodeWAFInvalidAccountException, aerr.Error())
			case wafregional.ErrCodeWAFInvalidOperationException:
				fmt.Println(wafregional.ErrCodeWAFInvalidOperationException, aerr.Error())
			case wafregional.ErrCodeWAFInvalidParameterException:
				fmt.Println(wafregional.ErrCodeWAFInvalidParameterException, aerr.Error())
			case wafregional.ErrCodeWAFNonexistentContainerException:
				fmt.Println(wafregional.ErrCodeWAFNonexistentContainerException, aerr.Error())
			case wafregional.ErrCodeWAFNonexistentItemException:
				fmt.Println(wafregional.ErrCodeWAFNonexistentItemException, aerr.Error())
			case wafregional.ErrCodeWAFReferencedItemException:
				fmt.Println(wafregional.ErrCodeWAFReferencedItemException, aerr.Error())
			case wafregional.ErrCodeWAFLimitsExceededException:
				fmt.Println(wafregional.ErrCodeWAFLimitsExceededException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To update a rule
//
// The following example deletes a Predicate object in a rule with the ID example1ds3t-46da-4fdb-b8d5-abc321j569j5.
func ExampleClient_UpdateRuleRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := wafregional.New(cfg)
	input := &wafregional.UpdateRuleInput{
		ChangeToken: aws.String("abcd12f2-46da-4fdb-b8d5-fbd4c466928f"),
		RuleId:      aws.String("example1ds3t-46da-4fdb-b8d5-abc321j569j5"),
		Updates: []waf.RuleUpdate{
			{
				Action: waf.ChangeActionDelete,
			},
		},
	}

	req := svc.UpdateRuleRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case wafregional.ErrCodeWAFStaleDataException:
				fmt.Println(wafregional.ErrCodeWAFStaleDataException, aerr.Error())
			case wafregional.ErrCodeWAFInternalErrorException:
				fmt.Println(wafregional.ErrCodeWAFInternalErrorException, aerr.Error())
			case wafregional.ErrCodeWAFInvalidAccountException:
				fmt.Println(wafregional.ErrCodeWAFInvalidAccountException, aerr.Error())
			case wafregional.ErrCodeWAFInvalidOperationException:
				fmt.Println(wafregional.ErrCodeWAFInvalidOperationException, aerr.Error())
			case wafregional.ErrCodeWAFInvalidParameterException:
				fmt.Println(wafregional.ErrCodeWAFInvalidParameterException, aerr.Error())
			case wafregional.ErrCodeWAFNonexistentContainerException:
				fmt.Println(wafregional.ErrCodeWAFNonexistentContainerException, aerr.Error())
			case wafregional.ErrCodeWAFNonexistentItemException:
				fmt.Println(wafregional.ErrCodeWAFNonexistentItemException, aerr.Error())
			case wafregional.ErrCodeWAFReferencedItemException:
				fmt.Println(wafregional.ErrCodeWAFReferencedItemException, aerr.Error())
			case wafregional.ErrCodeWAFLimitsExceededException:
				fmt.Println(wafregional.ErrCodeWAFLimitsExceededException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To update a size constraint set
//
// The following example deletes a SizeConstraint object (filters) in a size constraint
// set with the ID example1ds3t-46da-4fdb-b8d5-abc321j569j5.
func ExampleClient_UpdateSizeConstraintSetRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := wafregional.New(cfg)
	input := &wafregional.UpdateSizeConstraintSetInput{
		ChangeToken:         aws.String("abcd12f2-46da-4fdb-b8d5-fbd4c466928f"),
		SizeConstraintSetId: aws.String("example1ds3t-46da-4fdb-b8d5-abc321j569j5"),
		Updates: []waf.SizeConstraintSetUpdate{
			{
				Action: waf.ChangeActionDelete,
			},
		},
	}

	req := svc.UpdateSizeConstraintSetRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case wafregional.ErrCodeWAFStaleDataException:
				fmt.Println(wafregional.ErrCodeWAFStaleDataException, aerr.Error())
			case wafregional.ErrCodeWAFInternalErrorException:
				fmt.Println(wafregional.ErrCodeWAFInternalErrorException, aerr.Error())
			case wafregional.ErrCodeWAFInvalidAccountException:
				fmt.Println(wafregional.ErrCodeWAFInvalidAccountException, aerr.Error())
			case wafregional.ErrCodeWAFInvalidOperationException:
				fmt.Println(wafregional.ErrCodeWAFInvalidOperationException, aerr.Error())
			case wafregional.ErrCodeWAFInvalidParameterException:
				fmt.Println(wafregional.ErrCodeWAFInvalidParameterException, aerr.Error())
			case wafregional.ErrCodeWAFNonexistentContainerException:
				fmt.Println(wafregional.ErrCodeWAFNonexistentContainerException, aerr.Error())
			case wafregional.ErrCodeWAFNonexistentItemException:
				fmt.Println(wafregional.ErrCodeWAFNonexistentItemException, aerr.Error())
			case wafregional.ErrCodeWAFReferencedItemException:
				fmt.Println(wafregional.ErrCodeWAFReferencedItemException, aerr.Error())
			case wafregional.ErrCodeWAFLimitsExceededException:
				fmt.Println(wafregional.ErrCodeWAFLimitsExceededException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To update a SQL injection match set
//
// The following example deletes a SqlInjectionMatchTuple object (filters) in a SQL
// injection match set with the ID example1ds3t-46da-4fdb-b8d5-abc321j569j5.
func ExampleClient_UpdateSqlInjectionMatchSetRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := wafregional.New(cfg)
	input := &wafregional.UpdateSqlInjectionMatchSetInput{
		ChangeToken:            aws.String("abcd12f2-46da-4fdb-b8d5-fbd4c466928f"),
		SqlInjectionMatchSetId: aws.String("example1ds3t-46da-4fdb-b8d5-abc321j569j5"),
		Updates: []waf.SqlInjectionMatchSetUpdate{
			{
				Action: waf.ChangeActionDelete,
			},
		},
	}

	req := svc.UpdateSqlInjectionMatchSetRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case wafregional.ErrCodeWAFInternalErrorException:
				fmt.Println(wafregional.ErrCodeWAFInternalErrorException, aerr.Error())
			case wafregional.ErrCodeWAFInvalidAccountException:
				fmt.Println(wafregional.ErrCodeWAFInvalidAccountException, aerr.Error())
			case wafregional.ErrCodeWAFInvalidOperationException:
				fmt.Println(wafregional.ErrCodeWAFInvalidOperationException, aerr.Error())
			case wafregional.ErrCodeWAFInvalidParameterException:
				fmt.Println(wafregional.ErrCodeWAFInvalidParameterException, aerr.Error())
			case wafregional.ErrCodeWAFNonexistentContainerException:
				fmt.Println(wafregional.ErrCodeWAFNonexistentContainerException, aerr.Error())
			case wafregional.ErrCodeWAFNonexistentItemException:
				fmt.Println(wafregional.ErrCodeWAFNonexistentItemException, aerr.Error())
			case wafregional.ErrCodeWAFStaleDataException:
				fmt.Println(wafregional.ErrCodeWAFStaleDataException, aerr.Error())
			case wafregional.ErrCodeWAFLimitsExceededException:
				fmt.Println(wafregional.ErrCodeWAFLimitsExceededException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To update a Web ACL
//
// The following example deletes an ActivatedRule object in a WebACL with the ID webacl-1472061481310.
func ExampleClient_UpdateWebACLRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := wafregional.New(cfg)
	input := &wafregional.UpdateWebACLInput{
		ChangeToken: aws.String("abcd12f2-46da-4fdb-b8d5-fbd4c466928f"),
		DefaultAction: &waf.WafAction{
			Type: waf.WafActionTypeAllow,
		},
		Updates: []waf.WebACLUpdate{
			{
				Action: waf.ChangeActionDelete,
			},
		},
		WebACLId: aws.String("webacl-1472061481310"),
	}

	req := svc.UpdateWebACLRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case wafregional.ErrCodeWAFStaleDataException:
				fmt.Println(wafregional.ErrCodeWAFStaleDataException, aerr.Error())
			case wafregional.ErrCodeWAFInternalErrorException:
				fmt.Println(wafregional.ErrCodeWAFInternalErrorException, aerr.Error())
			case wafregional.ErrCodeWAFInvalidAccountException:
				fmt.Println(wafregional.ErrCodeWAFInvalidAccountException, aerr.Error())
			case wafregional.ErrCodeWAFInvalidOperationException:
				fmt.Println(wafregional.ErrCodeWAFInvalidOperationException, aerr.Error())
			case wafregional.ErrCodeWAFInvalidParameterException:
				fmt.Println(wafregional.ErrCodeWAFInvalidParameterException, aerr.Error())
			case wafregional.ErrCodeWAFNonexistentContainerException:
				fmt.Println(wafregional.ErrCodeWAFNonexistentContainerException, aerr.Error())
			case wafregional.ErrCodeWAFNonexistentItemException:
				fmt.Println(wafregional.ErrCodeWAFNonexistentItemException, aerr.Error())
			case wafregional.ErrCodeWAFReferencedItemException:
				fmt.Println(wafregional.ErrCodeWAFReferencedItemException, aerr.Error())
			case wafregional.ErrCodeWAFLimitsExceededException:
				fmt.Println(wafregional.ErrCodeWAFLimitsExceededException, aerr.Error())
			case wafregional.ErrCodeWAFSubscriptionNotFoundException:
				fmt.Println(wafregional.ErrCodeWAFSubscriptionNotFoundException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To update an XSS match set
//
// The following example deletes an XssMatchTuple object (filters) in an XssMatchSet
// with the ID example1ds3t-46da-4fdb-b8d5-abc321j569j5.
func ExampleClient_UpdateXssMatchSetRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := wafregional.New(cfg)
	input := &wafregional.UpdateXssMatchSetInput{
		ChangeToken: aws.String("abcd12f2-46da-4fdb-b8d5-fbd4c466928f"),
		Updates: []waf.XssMatchSetUpdate{
			{
				Action: waf.ChangeActionDelete,
			},
		},
		XssMatchSetId: aws.String("example1ds3t-46da-4fdb-b8d5-abc321j569j5"),
	}

	req := svc.UpdateXssMatchSetRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case wafregional.ErrCodeWAFInternalErrorException:
				fmt.Println(wafregional.ErrCodeWAFInternalErrorException, aerr.Error())
			case wafregional.ErrCodeWAFInvalidAccountException:
				fmt.Println(wafregional.ErrCodeWAFInvalidAccountException, aerr.Error())
			case wafregional.ErrCodeWAFInvalidOperationException:
				fmt.Println(wafregional.ErrCodeWAFInvalidOperationException, aerr.Error())
			case wafregional.ErrCodeWAFInvalidParameterException:
				fmt.Println(wafregional.ErrCodeWAFInvalidParameterException, aerr.Error())
			case wafregional.ErrCodeWAFNonexistentContainerException:
				fmt.Println(wafregional.ErrCodeWAFNonexistentContainerException, aerr.Error())
			case wafregional.ErrCodeWAFNonexistentItemException:
				fmt.Println(wafregional.ErrCodeWAFNonexistentItemException, aerr.Error())
			case wafregional.ErrCodeWAFStaleDataException:
				fmt.Println(wafregional.ErrCodeWAFStaleDataException, aerr.Error())
			case wafregional.ErrCodeWAFLimitsExceededException:
				fmt.Println(wafregional.ErrCodeWAFLimitsExceededException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}
