// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package s3

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restxml"
)

type PutBucketPolicyInput struct {
	_ struct{} `type:"structure" payload:"Policy"`

	// The name of the bucket.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Set this parameter to true to confirm that you want to remove your permissions
	// to change this bucket policy in the future.
	ConfirmRemoveSelfBucketAccess *bool `location:"header" locationName:"x-amz-confirm-remove-self-bucket-access" type:"boolean"`

	// The bucket policy as a JSON document.
	//
	// Policy is a required field
	Policy *string `type:"string" required:"true"`
}

// String returns the string representation
func (s PutBucketPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBucketPolicyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutBucketPolicyInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if s.Policy == nil {
		invalidParams.Add(aws.NewErrParamRequired("Policy"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *PutBucketPolicyInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutBucketPolicyInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.ConfirmRemoveSelfBucketAccess != nil {
		v := *s.ConfirmRemoveSelfBucketAccess

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-confirm-remove-self-bucket-access", protocol.BoolValue(v), metadata)
	}
	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.Policy != nil {
		v := *s.Policy

		metadata := protocol.Metadata{}
		e.SetStream(protocol.PayloadTarget, "Policy", protocol.StringStream(v), metadata)
	}
	return nil
}

type PutBucketPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutBucketPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutBucketPolicyOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opPutBucketPolicy = "PutBucketPolicy"

// PutBucketPolicyRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Applies an Amazon S3 bucket policy to an Amazon S3 bucket. If you are using
// an identity other than the root user of the AWS account that owns the bucket,
// the calling identity must have the PutBucketPolicy permissions on the specified
// bucket and belong to the bucket owner's account in order to use this operation.
//
// If you don't have PutBucketPolicy permissions, Amazon S3 returns a 403 Access
// Denied error. If you have the correct permissions, but you're not using an
// identity that belongs to the bucket owner's account, Amazon S3 returns a
// 405 Method Not Allowed error.
//
// As a security precaution, the root user of the AWS account that owns a bucket
// can always use this operation, even if the policy explicitly denies the root
// user the ability to perform this action.
//
// For more information about bucket policies, see Using Bucket Policies and
// User Policies (https://docs.aws.amazon.com/AmazonS3/latest/dev/using-iam-policies.html).
//
// The following operations are related to PutBucketPolicy:
//
//    * CreateBucket
//
//    * DeleteBucket
//
//    // Example sending a request using PutBucketPolicyRequest.
//    req := client.PutBucketPolicyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketPolicy
func (c *Client) PutBucketPolicyRequest(input *PutBucketPolicyInput) PutBucketPolicyRequest {
	op := &aws.Operation{
		Name:       opPutBucketPolicy,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?policy",
	}

	if input == nil {
		input = &PutBucketPolicyInput{}
	}

	req := c.newRequest(op, input, &PutBucketPolicyOutput{})
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return PutBucketPolicyRequest{Request: req, Input: input, Copy: c.PutBucketPolicyRequest}
}

// PutBucketPolicyRequest is the request type for the
// PutBucketPolicy API operation.
type PutBucketPolicyRequest struct {
	*aws.Request
	Input *PutBucketPolicyInput
	Copy  func(*PutBucketPolicyInput) PutBucketPolicyRequest
}

// Send marshals and sends the PutBucketPolicy API request.
func (r PutBucketPolicyRequest) Send(ctx context.Context) (*PutBucketPolicyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutBucketPolicyResponse{
		PutBucketPolicyOutput: r.Request.Data.(*PutBucketPolicyOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutBucketPolicyResponse is the response type for the
// PutBucketPolicy API operation.
type PutBucketPolicyResponse struct {
	*PutBucketPolicyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutBucketPolicy request.
func (r *PutBucketPolicyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
