// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package rekognition

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteCollectionInput struct {
	_ struct{} `type:"structure"`

	// ID of the collection to delete.
	//
	// CollectionId is a required field
	CollectionId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteCollectionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCollectionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteCollectionInput"}

	if s.CollectionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("CollectionId"))
	}
	if s.CollectionId != nil && len(*s.CollectionId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("CollectionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteCollectionOutput struct {
	_ struct{} `type:"structure"`

	// HTTP status code that indicates the result of the operation.
	StatusCode *int64 `type:"integer"`
}

// String returns the string representation
func (s DeleteCollectionOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteCollection = "DeleteCollection"

// DeleteCollectionRequest returns a request value for making API operation for
// Amazon Rekognition.
//
// Deletes the specified collection. Note that this operation removes all faces
// in the collection. For an example, see delete-collection-procedure.
//
// This operation requires permissions to perform the rekognition:DeleteCollection
// action.
//
//    // Example sending a request using DeleteCollectionRequest.
//    req := client.DeleteCollectionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) DeleteCollectionRequest(input *DeleteCollectionInput) DeleteCollectionRequest {
	op := &aws.Operation{
		Name:       opDeleteCollection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteCollectionInput{}
	}

	req := c.newRequest(op, input, &DeleteCollectionOutput{})
	return DeleteCollectionRequest{Request: req, Input: input, Copy: c.DeleteCollectionRequest}
}

// DeleteCollectionRequest is the request type for the
// DeleteCollection API operation.
type DeleteCollectionRequest struct {
	*aws.Request
	Input *DeleteCollectionInput
	Copy  func(*DeleteCollectionInput) DeleteCollectionRequest
}

// Send marshals and sends the DeleteCollection API request.
func (r DeleteCollectionRequest) Send(ctx context.Context) (*DeleteCollectionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteCollectionResponse{
		DeleteCollectionOutput: r.Request.Data.(*DeleteCollectionOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteCollectionResponse is the response type for the
// DeleteCollection API operation.
type DeleteCollectionResponse struct {
	*DeleteCollectionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteCollection request.
func (r *DeleteCollectionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
