// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package redshift

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateEventSubscriptionInput struct {
	_ struct{} `type:"structure"`

	// A boolean value; set to true to activate the subscription, and set to false
	// to create the subscription but not activate it.
	Enabled *bool `type:"boolean"`

	// Specifies the Amazon Redshift event categories to be published by the event
	// notification subscription.
	//
	// Values: configuration, management, monitoring, security
	EventCategories []string `locationNameList:"EventCategory" type:"list"`

	// Specifies the Amazon Redshift event severity to be published by the event
	// notification subscription.
	//
	// Values: ERROR, INFO
	Severity *string `type:"string"`

	// The Amazon Resource Name (ARN) of the Amazon SNS topic used to transmit the
	// event notifications. The ARN is created by Amazon SNS when you create a topic
	// and subscribe to it.
	//
	// SnsTopicArn is a required field
	SnsTopicArn *string `type:"string" required:"true"`

	// A list of one or more identifiers of Amazon Redshift source objects. All
	// of the objects must be of the same type as was specified in the source type
	// parameter. The event subscription will return only events generated by the
	// specified objects. If not specified, then events are returned for all objects
	// within the source type specified.
	//
	// Example: my-cluster-1, my-cluster-2
	//
	// Example: my-snapshot-20131010
	SourceIds []string `locationNameList:"SourceId" type:"list"`

	// The type of source that will be generating the events. For example, if you
	// want to be notified of events generated by a cluster, you would set this
	// parameter to cluster. If this value is not specified, events are returned
	// for all Amazon Redshift objects in your AWS account. You must specify a source
	// type in order to specify source IDs.
	//
	// Valid values: cluster, cluster-parameter-group, cluster-security-group, and
	// cluster-snapshot.
	SourceType *string `type:"string"`

	// The name of the event subscription to be created.
	//
	// Constraints:
	//
	//    * Cannot be null, empty, or blank.
	//
	//    * Must contain from 1 to 255 alphanumeric characters or hyphens.
	//
	//    * First character must be a letter.
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens.
	//
	// SubscriptionName is a required field
	SubscriptionName *string `type:"string" required:"true"`

	// A list of tag instances.
	Tags []Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s CreateEventSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEventSubscriptionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateEventSubscriptionInput"}

	if s.SnsTopicArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("SnsTopicArn"))
	}

	if s.SubscriptionName == nil {
		invalidParams.Add(aws.NewErrParamRequired("SubscriptionName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateEventSubscriptionOutput struct {
	_ struct{} `type:"structure"`

	// Describes event subscriptions.
	EventSubscription *EventSubscription `type:"structure"`
}

// String returns the string representation
func (s CreateEventSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateEventSubscription = "CreateEventSubscription"

// CreateEventSubscriptionRequest returns a request value for making API operation for
// Amazon Redshift.
//
// Creates an Amazon Redshift event notification subscription. This action requires
// an ARN (Amazon Resource Name) of an Amazon SNS topic created by either the
// Amazon Redshift console, the Amazon SNS console, or the Amazon SNS API. To
// obtain an ARN with Amazon SNS, you must create a topic in Amazon SNS and
// subscribe to the topic. The ARN is displayed in the SNS console.
//
// You can specify the source type, and lists of Amazon Redshift source IDs,
// event categories, and event severities. Notifications will be sent for all
// events you want that match those criteria. For example, you can specify source
// type = cluster, source ID = my-cluster-1 and mycluster2, event categories
// = Availability, Backup, and severity = ERROR. The subscription will only
// send notifications for those ERROR events in the Availability and Backup
// categories for the specified clusters.
//
// If you specify both the source type and source IDs, such as source type =
// cluster and source identifier = my-cluster-1, notifications will be sent
// for all the cluster events for my-cluster-1. If you specify a source type
// but do not specify a source identifier, you will receive notice of the events
// for the objects of that type in your AWS account. If you do not specify either
// the SourceType nor the SourceIdentifier, you will be notified of events generated
// from all Amazon Redshift sources belonging to your AWS account. You must
// specify a source type if you specify a source ID.
//
//    // Example sending a request using CreateEventSubscriptionRequest.
//    req := client.CreateEventSubscriptionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateEventSubscription
func (c *Client) CreateEventSubscriptionRequest(input *CreateEventSubscriptionInput) CreateEventSubscriptionRequest {
	op := &aws.Operation{
		Name:       opCreateEventSubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateEventSubscriptionInput{}
	}

	req := c.newRequest(op, input, &CreateEventSubscriptionOutput{})
	return CreateEventSubscriptionRequest{Request: req, Input: input, Copy: c.CreateEventSubscriptionRequest}
}

// CreateEventSubscriptionRequest is the request type for the
// CreateEventSubscription API operation.
type CreateEventSubscriptionRequest struct {
	*aws.Request
	Input *CreateEventSubscriptionInput
	Copy  func(*CreateEventSubscriptionInput) CreateEventSubscriptionRequest
}

// Send marshals and sends the CreateEventSubscription API request.
func (r CreateEventSubscriptionRequest) Send(ctx context.Context) (*CreateEventSubscriptionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateEventSubscriptionResponse{
		CreateEventSubscriptionOutput: r.Request.Data.(*CreateEventSubscriptionOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateEventSubscriptionResponse is the response type for the
// CreateEventSubscription API operation.
type CreateEventSubscriptionResponse struct {
	*CreateEventSubscriptionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateEventSubscription request.
func (r *CreateEventSubscriptionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
