// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package networkmanager

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type CreateDeviceInput struct {
	_ struct{} `type:"structure"`

	// A description of the device.
	//
	// Length Constraints: Maximum length of 256 characters.
	Description *string `type:"string"`

	// The ID of the global network.
	//
	// GlobalNetworkId is a required field
	GlobalNetworkId *string `location:"uri" locationName:"globalNetworkId" type:"string" required:"true"`

	// The location of the device.
	Location *Location `type:"structure"`

	// The model of the device.
	//
	// Length Constraints: Maximum length of 128 characters.
	Model *string `type:"string"`

	// The serial number of the device.
	//
	// Length Constraints: Maximum length of 128 characters.
	SerialNumber *string `type:"string"`

	// The ID of the site.
	SiteId *string `type:"string"`

	// The tags to apply to the resource during creation.
	Tags []Tag `type:"list"`

	// The type of the device.
	Type *string `type:"string"`

	// The vendor of the device.
	//
	// Length Constraints: Maximum length of 128 characters.
	Vendor *string `type:"string"`
}

// String returns the string representation
func (s CreateDeviceInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDeviceInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateDeviceInput"}

	if s.GlobalNetworkId == nil {
		invalidParams.Add(aws.NewErrParamRequired("GlobalNetworkId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateDeviceInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Location != nil {
		v := s.Location

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Location", v, metadata)
	}
	if s.Model != nil {
		v := *s.Model

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Model", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SerialNumber != nil {
		v := *s.SerialNumber

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SerialNumber", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SiteId != nil {
		v := *s.SiteId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SiteId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Tags", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Type != nil {
		v := *s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Vendor != nil {
		v := *s.Vendor

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Vendor", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.GlobalNetworkId != nil {
		v := *s.GlobalNetworkId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "globalNetworkId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type CreateDeviceOutput struct {
	_ struct{} `type:"structure"`

	// Information about the device.
	Device *Device `type:"structure"`
}

// String returns the string representation
func (s CreateDeviceOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateDeviceOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Device != nil {
		v := s.Device

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Device", v, metadata)
	}
	return nil
}

const opCreateDevice = "CreateDevice"

// CreateDeviceRequest returns a request value for making API operation for
// AWS Network Manager.
//
// Creates a new device in a global network. If you specify both a site ID and
// a location, the location of the site is used for visualization in the Network
// Manager console.
//
//    // Example sending a request using CreateDeviceRequest.
//    req := client.CreateDeviceRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/CreateDevice
func (c *Client) CreateDeviceRequest(input *CreateDeviceInput) CreateDeviceRequest {
	op := &aws.Operation{
		Name:       opCreateDevice,
		HTTPMethod: "POST",
		HTTPPath:   "/global-networks/{globalNetworkId}/devices",
	}

	if input == nil {
		input = &CreateDeviceInput{}
	}

	req := c.newRequest(op, input, &CreateDeviceOutput{})
	return CreateDeviceRequest{Request: req, Input: input, Copy: c.CreateDeviceRequest}
}

// CreateDeviceRequest is the request type for the
// CreateDevice API operation.
type CreateDeviceRequest struct {
	*aws.Request
	Input *CreateDeviceInput
	Copy  func(*CreateDeviceInput) CreateDeviceRequest
}

// Send marshals and sends the CreateDevice API request.
func (r CreateDeviceRequest) Send(ctx context.Context) (*CreateDeviceResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateDeviceResponse{
		CreateDeviceOutput: r.Request.Data.(*CreateDeviceOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateDeviceResponse is the response type for the
// CreateDevice API operation.
type CreateDeviceResponse struct {
	*CreateDeviceOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateDevice request.
func (r *CreateDeviceResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
