// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kinesisvideo

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DeleteSignalingChannelInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the signaling channel that you want to delete.
	//
	// ChannelARN is a required field
	ChannelARN *string `min:"1" type:"string" required:"true"`

	// The current version of the signaling channel that you want to delete. You
	// can obtain the current version by invoking the DescribeSignalingChannel or
	// ListSignalingChannels APIs.
	CurrentVersion *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DeleteSignalingChannelInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSignalingChannelInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteSignalingChannelInput"}

	if s.ChannelARN == nil {
		invalidParams.Add(aws.NewErrParamRequired("ChannelARN"))
	}
	if s.ChannelARN != nil && len(*s.ChannelARN) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ChannelARN", 1))
	}
	if s.CurrentVersion != nil && len(*s.CurrentVersion) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("CurrentVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteSignalingChannelInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ChannelARN != nil {
		v := *s.ChannelARN

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ChannelARN", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CurrentVersion != nil {
		v := *s.CurrentVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CurrentVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeleteSignalingChannelOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteSignalingChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteSignalingChannelOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteSignalingChannel = "DeleteSignalingChannel"

// DeleteSignalingChannelRequest returns a request value for making API operation for
// Amazon Kinesis Video Streams.
//
// Deletes a specified signaling channel. DeleteSignalingChannel is an asynchronous
// operation. If you don't specify the channel's current version, the most recent
// version is deleted.
//
//    // Example sending a request using DeleteSignalingChannelRequest.
//    req := client.DeleteSignalingChannelRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisvideo-2017-09-30/DeleteSignalingChannel
func (c *Client) DeleteSignalingChannelRequest(input *DeleteSignalingChannelInput) DeleteSignalingChannelRequest {
	op := &aws.Operation{
		Name:       opDeleteSignalingChannel,
		HTTPMethod: "POST",
		HTTPPath:   "/deleteSignalingChannel",
	}

	if input == nil {
		input = &DeleteSignalingChannelInput{}
	}

	req := c.newRequest(op, input, &DeleteSignalingChannelOutput{})
	return DeleteSignalingChannelRequest{Request: req, Input: input, Copy: c.DeleteSignalingChannelRequest}
}

// DeleteSignalingChannelRequest is the request type for the
// DeleteSignalingChannel API operation.
type DeleteSignalingChannelRequest struct {
	*aws.Request
	Input *DeleteSignalingChannelInput
	Copy  func(*DeleteSignalingChannelInput) DeleteSignalingChannelRequest
}

// Send marshals and sends the DeleteSignalingChannel API request.
func (r DeleteSignalingChannelRequest) Send(ctx context.Context) (*DeleteSignalingChannelResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteSignalingChannelResponse{
		DeleteSignalingChannelOutput: r.Request.Data.(*DeleteSignalingChannelOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteSignalingChannelResponse is the response type for the
// DeleteSignalingChannel API operation.
type DeleteSignalingChannelResponse struct {
	*DeleteSignalingChannelOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteSignalingChannel request.
func (r *DeleteSignalingChannelResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
