// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iot

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// The input for the ListPrincipalThings operation.
type ListPrincipalThingsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return in this operation.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The principal.
	//
	// Principal is a required field
	Principal *string `location:"header" locationName:"x-amzn-principal" type:"string" required:"true"`
}

// String returns the string representation
func (s ListPrincipalThingsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPrincipalThingsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListPrincipalThingsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if s.Principal == nil {
		invalidParams.Add(aws.NewErrParamRequired("Principal"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListPrincipalThingsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Principal != nil {
		v := *s.Principal

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amzn-principal", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "maxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The output from the ListPrincipalThings operation.
type ListPrincipalThingsOutput struct {
	_ struct{} `type:"structure"`

	// The token used to get the next set of results, or null if there are no additional
	// results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The things.
	Things []string `locationName:"things" type:"list"`
}

// String returns the string representation
func (s ListPrincipalThingsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListPrincipalThingsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Things != nil {
		v := s.Things

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "things", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

const opListPrincipalThings = "ListPrincipalThings"

// ListPrincipalThingsRequest returns a request value for making API operation for
// AWS IoT.
//
// Lists the things associated with the specified principal. A principal can
// be X.509 certificates, IAM users, groups, and roles, Amazon Cognito identities
// or federated identities.
//
//    // Example sending a request using ListPrincipalThingsRequest.
//    req := client.ListPrincipalThingsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) ListPrincipalThingsRequest(input *ListPrincipalThingsInput) ListPrincipalThingsRequest {
	op := &aws.Operation{
		Name:       opListPrincipalThings,
		HTTPMethod: "GET",
		HTTPPath:   "/principals/things",
	}

	if input == nil {
		input = &ListPrincipalThingsInput{}
	}

	req := c.newRequest(op, input, &ListPrincipalThingsOutput{})
	return ListPrincipalThingsRequest{Request: req, Input: input, Copy: c.ListPrincipalThingsRequest}
}

// ListPrincipalThingsRequest is the request type for the
// ListPrincipalThings API operation.
type ListPrincipalThingsRequest struct {
	*aws.Request
	Input *ListPrincipalThingsInput
	Copy  func(*ListPrincipalThingsInput) ListPrincipalThingsRequest
}

// Send marshals and sends the ListPrincipalThings API request.
func (r ListPrincipalThingsRequest) Send(ctx context.Context) (*ListPrincipalThingsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListPrincipalThingsResponse{
		ListPrincipalThingsOutput: r.Request.Data.(*ListPrincipalThingsOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListPrincipalThingsResponse is the response type for the
// ListPrincipalThings API operation.
type ListPrincipalThingsResponse struct {
	*ListPrincipalThingsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListPrincipalThings request.
func (r *ListPrincipalThingsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
