// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package forecast

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateForecastInput struct {
	_ struct{} `type:"structure"`

	// A name for the forecast.
	//
	// ForecastName is a required field
	ForecastName *string `min:"1" type:"string" required:"true"`

	// The quantiles at which probabilistic forecasts are generated. You can specify
	// up to 5 quantiles per forecast. Accepted values include 0.01 to 0.99 (increments
	// of .01 only) and mean. The mean forecast is different from the median (0.50)
	// when the distribution is not symmetric (e.g. Beta, Negative Binomial). The
	// default value is ["0.1", "0.5", "0.9"].
	ForecastTypes []string `min:"1" type:"list"`

	// The Amazon Resource Name (ARN) of the predictor to use to generate the forecast.
	//
	// PredictorArn is a required field
	PredictorArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateForecastInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateForecastInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateForecastInput"}

	if s.ForecastName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ForecastName"))
	}
	if s.ForecastName != nil && len(*s.ForecastName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ForecastName", 1))
	}
	if s.ForecastTypes != nil && len(s.ForecastTypes) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ForecastTypes", 1))
	}

	if s.PredictorArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("PredictorArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateForecastOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the forecast.
	ForecastArn *string `type:"string"`
}

// String returns the string representation
func (s CreateForecastOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateForecast = "CreateForecast"

// CreateForecastRequest returns a request value for making API operation for
// Amazon Forecast Service.
//
// Creates a forecast for each item in the TARGET_TIME_SERIES dataset that was
// used to train the predictor. This is known as inference. To retrieve the
// forecast for a single item at low latency, use the operation. To export the
// complete forecast into your Amazon Simple Storage Service (Amazon S3) bucket,
// use the CreateForecastExportJob operation.
//
// The range of the forecast is determined by the ForecastHorizon value, which
// you specify in the CreatePredictor request, multiplied by the DataFrequency
// value, which you specify in the CreateDataset request. When you query a forecast,
// you can request a specific date range within the forecast.
//
// To get a list of all your forecasts, use the ListForecasts operation.
//
// The forecasts generated by Amazon Forecast are in the same time zone as the
// dataset that was used to create the predictor.
//
// For more information, see howitworks-forecast.
//
// The Status of the forecast must be ACTIVE before you can query or export
// the forecast. Use the DescribeForecast operation to get the status.
//
//    // Example sending a request using CreateForecastRequest.
//    req := client.CreateForecastRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/CreateForecast
func (c *Client) CreateForecastRequest(input *CreateForecastInput) CreateForecastRequest {
	op := &aws.Operation{
		Name:       opCreateForecast,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateForecastInput{}
	}

	req := c.newRequest(op, input, &CreateForecastOutput{})
	return CreateForecastRequest{Request: req, Input: input, Copy: c.CreateForecastRequest}
}

// CreateForecastRequest is the request type for the
// CreateForecast API operation.
type CreateForecastRequest struct {
	*aws.Request
	Input *CreateForecastInput
	Copy  func(*CreateForecastInput) CreateForecastRequest
}

// Send marshals and sends the CreateForecast API request.
func (r CreateForecastRequest) Send(ctx context.Context) (*CreateForecastResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateForecastResponse{
		CreateForecastOutput: r.Request.Data.(*CreateForecastOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateForecastResponse is the response type for the
// CreateForecast API operation.
type CreateForecastResponse struct {
	*CreateForecastOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateForecast request.
func (r *CreateForecastResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
