// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package applicationdiscoveryservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ExportConfigurationsInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ExportConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

type ExportConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	// A unique identifier that you can use to query the export status.
	ExportId *string `locationName:"exportId" type:"string"`
}

// String returns the string representation
func (s ExportConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

const opExportConfigurations = "ExportConfigurations"

// ExportConfigurationsRequest returns a request value for making API operation for
// AWS Application Discovery Service.
//
// Deprecated. Use StartExportTask instead.
//
// Exports all discovered configuration data to an Amazon S3 bucket or an application
// that enables you to view and evaluate the data. Data includes tags and tag
// associations, processes, connections, servers, and system performance. This
// API returns an export ID that you can query using the DescribeExportConfigurations
// API. The system imposes a limit of two configuration exports in six hours.
//
//    // Example sending a request using ExportConfigurationsRequest.
//    req := client.ExportConfigurationsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/ExportConfigurations
func (c *Client) ExportConfigurationsRequest(input *ExportConfigurationsInput) ExportConfigurationsRequest {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, ExportConfigurations, has been deprecated")
	}
	op := &aws.Operation{
		Name:       opExportConfigurations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ExportConfigurationsInput{}
	}

	req := c.newRequest(op, input, &ExportConfigurationsOutput{})
	return ExportConfigurationsRequest{Request: req, Input: input, Copy: c.ExportConfigurationsRequest}
}

// ExportConfigurationsRequest is the request type for the
// ExportConfigurations API operation.
type ExportConfigurationsRequest struct {
	*aws.Request
	Input *ExportConfigurationsInput
	Copy  func(*ExportConfigurationsInput) ExportConfigurationsRequest
}

// Send marshals and sends the ExportConfigurations API request.
func (r ExportConfigurationsRequest) Send(ctx context.Context) (*ExportConfigurationsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ExportConfigurationsResponse{
		ExportConfigurationsOutput: r.Request.Data.(*ExportConfigurationsOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ExportConfigurationsResponse is the response type for the
// ExportConfigurations API operation.
type ExportConfigurationsResponse struct {
	*ExportConfigurationsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ExportConfigurations request.
func (r *ExportConfigurationsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
