// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sagemaker

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeCodeRepositoryInput struct {
	_ struct{} `type:"structure"`

	// The name of the Git repository to describe.
	//
	// CodeRepositoryName is a required field
	CodeRepositoryName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeCodeRepositoryInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeCodeRepositoryInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeCodeRepositoryInput"}

	if s.CodeRepositoryName == nil {
		invalidParams.Add(aws.NewErrParamRequired("CodeRepositoryName"))
	}
	if s.CodeRepositoryName != nil && len(*s.CodeRepositoryName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("CodeRepositoryName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeCodeRepositoryOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Git repository.
	//
	// CodeRepositoryArn is a required field
	CodeRepositoryArn *string `min:"1" type:"string" required:"true"`

	// The name of the Git repository.
	//
	// CodeRepositoryName is a required field
	CodeRepositoryName *string `min:"1" type:"string" required:"true"`

	// The date and time that the repository was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`

	// Configuration details about the repository, including the URL where the repository
	// is located, the default branch, and the Amazon Resource Name (ARN) of the
	// AWS Secrets Manager secret that contains the credentials used to access the
	// repository.
	GitConfig *GitConfig `type:"structure"`

	// The date and time that the repository was last changed.
	//
	// LastModifiedTime is a required field
	LastModifiedTime *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation
func (s DescribeCodeRepositoryOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeCodeRepository = "DescribeCodeRepository"

// DescribeCodeRepositoryRequest returns a request value for making API operation for
// Amazon SageMaker Service.
//
// Gets details about the specified Git repository.
//
//    // Example sending a request using DescribeCodeRepositoryRequest.
//    req := client.DescribeCodeRepositoryRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeCodeRepository
func (c *Client) DescribeCodeRepositoryRequest(input *DescribeCodeRepositoryInput) DescribeCodeRepositoryRequest {
	op := &aws.Operation{
		Name:       opDescribeCodeRepository,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeCodeRepositoryInput{}
	}

	req := c.newRequest(op, input, &DescribeCodeRepositoryOutput{})
	return DescribeCodeRepositoryRequest{Request: req, Input: input, Copy: c.DescribeCodeRepositoryRequest}
}

// DescribeCodeRepositoryRequest is the request type for the
// DescribeCodeRepository API operation.
type DescribeCodeRepositoryRequest struct {
	*aws.Request
	Input *DescribeCodeRepositoryInput
	Copy  func(*DescribeCodeRepositoryInput) DescribeCodeRepositoryRequest
}

// Send marshals and sends the DescribeCodeRepository API request.
func (r DescribeCodeRepositoryRequest) Send(ctx context.Context) (*DescribeCodeRepositoryResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeCodeRepositoryResponse{
		DescribeCodeRepositoryOutput: r.Request.Data.(*DescribeCodeRepositoryOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeCodeRepositoryResponse is the response type for the
// DescribeCodeRepository API operation.
type DescribeCodeRepositoryResponse struct {
	*DescribeCodeRepositoryOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeCodeRepository request.
func (r *DescribeCodeRepositoryResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
