# Contributing Guidelines

The **kubernetes/cloud-provider-openstack** project accepts contribution via github [pull request](https://help.github.com/articles/about-pull-requests/). This document outlines the process to help get your contribution accepted. Please also read the [Kubernetes contributor guide](https://github.com/kubernetes/community/blob/master/contributors/guide/README.md)

### Sign the Contributor License Agreement

We'd love to accept your patches! Before we can accept them you need to sign Cloud Native Computing Foundation (CNCF) [CLA](https://github.com/kubernetes/community/blob/master/CLA.md).

### Setup the Development Environment 
Refer [getting started](https://github.com/kubernetes/cloud-provider-openstack/blob/master/docs/getting-started-provider-dev.md)  document to setup development environment

### Reporting an issue
If you find a bug or a feature request related to cloud-provider-openstack you can create a new github issue in this repo @[kubernetes/cloud-provider-openstack](https://github.com/kubernetes/cloud-provider-openstack/issues).

### Contributing a Patch
1. Submit an issue describing your proposed change to the repo.
2. Fork the cloud-provider-openstack repo, develop and test your code changes.
3. Submit a pull request.
4. The bot will automatically assigns someone to review your PR. Check the full list of bot commands [here](https://prow.k8s.io/command-help)

### Contact and Meeting Time

* [Slack](https://kubernetes.slack.com/messages/sig-openstack).
* [Mailing list](https://groups.google.com/forum/#!forum/kubernetes-sig-openstack).
* Please check the [sig-openstack community page](https://github.com/kubernetes/community/tree/master/sig-cloud-provider#provider-openstack) for meeting time.
