// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"context"
	"time"

	v1alpha1 "github.com/openshift/api/operatorcontrolplane/v1alpha1"
	scheme "github.com/openshift/client-go/operatorcontrolplane/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// PodNetworkConnectivityChecksGetter has a method to return a PodNetworkConnectivityCheckInterface.
// A group's client should implement this interface.
type PodNetworkConnectivityChecksGetter interface {
	PodNetworkConnectivityChecks(namespace string) PodNetworkConnectivityCheckInterface
}

// PodNetworkConnectivityCheckInterface has methods to work with PodNetworkConnectivityCheck resources.
type PodNetworkConnectivityCheckInterface interface {
	Create(ctx context.Context, podNetworkConnectivityCheck *v1alpha1.PodNetworkConnectivityCheck, opts v1.CreateOptions) (*v1alpha1.PodNetworkConnectivityCheck, error)
	Update(ctx context.Context, podNetworkConnectivityCheck *v1alpha1.PodNetworkConnectivityCheck, opts v1.UpdateOptions) (*v1alpha1.PodNetworkConnectivityCheck, error)
	UpdateStatus(ctx context.Context, podNetworkConnectivityCheck *v1alpha1.PodNetworkConnectivityCheck, opts v1.UpdateOptions) (*v1alpha1.PodNetworkConnectivityCheck, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1alpha1.PodNetworkConnectivityCheck, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1alpha1.PodNetworkConnectivityCheckList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.PodNetworkConnectivityCheck, err error)
	PodNetworkConnectivityCheckExpansion
}

// podNetworkConnectivityChecks implements PodNetworkConnectivityCheckInterface
type podNetworkConnectivityChecks struct {
	client rest.Interface
	ns     string
}

// newPodNetworkConnectivityChecks returns a PodNetworkConnectivityChecks
func newPodNetworkConnectivityChecks(c *ControlplaneV1alpha1Client, namespace string) *podNetworkConnectivityChecks {
	return &podNetworkConnectivityChecks{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the podNetworkConnectivityCheck, and returns the corresponding podNetworkConnectivityCheck object, and an error if there is any.
func (c *podNetworkConnectivityChecks) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.PodNetworkConnectivityCheck, err error) {
	result = &v1alpha1.PodNetworkConnectivityCheck{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("podnetworkconnectivitychecks").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of PodNetworkConnectivityChecks that match those selectors.
func (c *podNetworkConnectivityChecks) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.PodNetworkConnectivityCheckList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.PodNetworkConnectivityCheckList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("podnetworkconnectivitychecks").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested podNetworkConnectivityChecks.
func (c *podNetworkConnectivityChecks) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("podnetworkconnectivitychecks").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a podNetworkConnectivityCheck and creates it.  Returns the server's representation of the podNetworkConnectivityCheck, and an error, if there is any.
func (c *podNetworkConnectivityChecks) Create(ctx context.Context, podNetworkConnectivityCheck *v1alpha1.PodNetworkConnectivityCheck, opts v1.CreateOptions) (result *v1alpha1.PodNetworkConnectivityCheck, err error) {
	result = &v1alpha1.PodNetworkConnectivityCheck{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("podnetworkconnectivitychecks").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(podNetworkConnectivityCheck).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a podNetworkConnectivityCheck and updates it. Returns the server's representation of the podNetworkConnectivityCheck, and an error, if there is any.
func (c *podNetworkConnectivityChecks) Update(ctx context.Context, podNetworkConnectivityCheck *v1alpha1.PodNetworkConnectivityCheck, opts v1.UpdateOptions) (result *v1alpha1.PodNetworkConnectivityCheck, err error) {
	result = &v1alpha1.PodNetworkConnectivityCheck{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("podnetworkconnectivitychecks").
		Name(podNetworkConnectivityCheck.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(podNetworkConnectivityCheck).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *podNetworkConnectivityChecks) UpdateStatus(ctx context.Context, podNetworkConnectivityCheck *v1alpha1.PodNetworkConnectivityCheck, opts v1.UpdateOptions) (result *v1alpha1.PodNetworkConnectivityCheck, err error) {
	result = &v1alpha1.PodNetworkConnectivityCheck{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("podnetworkconnectivitychecks").
		Name(podNetworkConnectivityCheck.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(podNetworkConnectivityCheck).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the podNetworkConnectivityCheck and deletes it. Returns an error if one occurs.
func (c *podNetworkConnectivityChecks) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("podnetworkconnectivitychecks").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *podNetworkConnectivityChecks) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("podnetworkconnectivitychecks").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched podNetworkConnectivityCheck.
func (c *podNetworkConnectivityChecks) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.PodNetworkConnectivityCheck, err error) {
	result = &v1alpha1.PodNetworkConnectivityCheck{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("podnetworkconnectivitychecks").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
