// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.13.0
// source: google/cloud/asset/v1/assets.proto

package asset

import (
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	v11 "google.golang.org/genproto/googleapis/cloud/orgpolicy/v1"
	v1 "google.golang.org/genproto/googleapis/iam/v1"
	v12 "google.golang.org/genproto/googleapis/identity/accesscontextmanager/v1"
	code "google.golang.org/genproto/googleapis/rpc/code"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	_ "google.golang.org/protobuf/types/known/anypb"
	structpb "google.golang.org/protobuf/types/known/structpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// State of prior asset.
type TemporalAsset_PriorAssetState int32

const (
	// prior_asset is not applicable for the current asset.
	TemporalAsset_PRIOR_ASSET_STATE_UNSPECIFIED TemporalAsset_PriorAssetState = 0
	// prior_asset is populated correctly.
	TemporalAsset_PRESENT TemporalAsset_PriorAssetState = 1
	// Failed to set prior_asset.
	TemporalAsset_INVALID TemporalAsset_PriorAssetState = 2
	// Current asset is the first known state.
	TemporalAsset_DOES_NOT_EXIST TemporalAsset_PriorAssetState = 3
	// prior_asset is a deletion.
	TemporalAsset_DELETED TemporalAsset_PriorAssetState = 4
)

// Enum value maps for TemporalAsset_PriorAssetState.
var (
	TemporalAsset_PriorAssetState_name = map[int32]string{
		0: "PRIOR_ASSET_STATE_UNSPECIFIED",
		1: "PRESENT",
		2: "INVALID",
		3: "DOES_NOT_EXIST",
		4: "DELETED",
	}
	TemporalAsset_PriorAssetState_value = map[string]int32{
		"PRIOR_ASSET_STATE_UNSPECIFIED": 0,
		"PRESENT":                       1,
		"INVALID":                       2,
		"DOES_NOT_EXIST":                3,
		"DELETED":                       4,
	}
)

func (x TemporalAsset_PriorAssetState) Enum() *TemporalAsset_PriorAssetState {
	p := new(TemporalAsset_PriorAssetState)
	*p = x
	return p
}

func (x TemporalAsset_PriorAssetState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TemporalAsset_PriorAssetState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_asset_v1_assets_proto_enumTypes[0].Descriptor()
}

func (TemporalAsset_PriorAssetState) Type() protoreflect.EnumType {
	return &file_google_cloud_asset_v1_assets_proto_enumTypes[0]
}

func (x TemporalAsset_PriorAssetState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TemporalAsset_PriorAssetState.Descriptor instead.
func (TemporalAsset_PriorAssetState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_assets_proto_rawDescGZIP(), []int{0, 0}
}

// An asset in Google Cloud and its temporal metadata, including the time window
// when it was observed and its status during that window.
type TemporalAsset struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The time window when the asset data and state was observed.
	Window *TimeWindow `protobuf:"bytes,1,opt,name=window,proto3" json:"window,omitempty"`
	// Whether the asset has been deleted or not.
	Deleted bool `protobuf:"varint,2,opt,name=deleted,proto3" json:"deleted,omitempty"`
	// An asset in Google Cloud.
	Asset *Asset `protobuf:"bytes,3,opt,name=asset,proto3" json:"asset,omitempty"`
	// State of prior_asset.
	PriorAssetState TemporalAsset_PriorAssetState `protobuf:"varint,4,opt,name=prior_asset_state,json=priorAssetState,proto3,enum=google.cloud.asset.v1.TemporalAsset_PriorAssetState" json:"prior_asset_state,omitempty"`
	// Prior copy of the asset. Populated if prior_asset_state is PRESENT.
	// Currently this is only set for responses in Real-Time Feed.
	PriorAsset *Asset `protobuf:"bytes,5,opt,name=prior_asset,json=priorAsset,proto3" json:"prior_asset,omitempty"`
}

func (x *TemporalAsset) Reset() {
	*x = TemporalAsset{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_assets_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TemporalAsset) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TemporalAsset) ProtoMessage() {}

func (x *TemporalAsset) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_assets_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TemporalAsset.ProtoReflect.Descriptor instead.
func (*TemporalAsset) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_assets_proto_rawDescGZIP(), []int{0}
}

func (x *TemporalAsset) GetWindow() *TimeWindow {
	if x != nil {
		return x.Window
	}
	return nil
}

func (x *TemporalAsset) GetDeleted() bool {
	if x != nil {
		return x.Deleted
	}
	return false
}

func (x *TemporalAsset) GetAsset() *Asset {
	if x != nil {
		return x.Asset
	}
	return nil
}

func (x *TemporalAsset) GetPriorAssetState() TemporalAsset_PriorAssetState {
	if x != nil {
		return x.PriorAssetState
	}
	return TemporalAsset_PRIOR_ASSET_STATE_UNSPECIFIED
}

func (x *TemporalAsset) GetPriorAsset() *Asset {
	if x != nil {
		return x.PriorAsset
	}
	return nil
}

// A time window specified by its `start_time` and `end_time`.
type TimeWindow struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Start time of the time window (exclusive).
	StartTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// End time of the time window (inclusive). If not specified, the current
	// timestamp is used instead.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
}

func (x *TimeWindow) Reset() {
	*x = TimeWindow{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_assets_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TimeWindow) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TimeWindow) ProtoMessage() {}

func (x *TimeWindow) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_assets_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TimeWindow.ProtoReflect.Descriptor instead.
func (*TimeWindow) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_assets_proto_rawDescGZIP(), []int{1}
}

func (x *TimeWindow) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *TimeWindow) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

// An asset in Google Cloud. An asset can be any resource in the Google Cloud
// [resource
// hierarchy](https://cloud.google.com/resource-manager/docs/cloud-platform-resource-hierarchy),
// a resource outside the Google Cloud resource hierarchy (such as Google
// Kubernetes Engine clusters and objects), or a policy (e.g. Cloud IAM policy).
// See [Supported asset
// types](https://cloud.google.com/asset-inventory/docs/supported-asset-types)
// for more information.
type Asset struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The last update timestamp of an asset. update_time is updated when
	// create/update/delete operation is performed.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,11,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// The full name of the asset. Example:
	// `//compute.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1`
	//
	// See [Resource
	// names](https://cloud.google.com/apis/design/resource_names#full_resource_name)
	// for more information.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The type of the asset. Example: `compute.googleapis.com/Disk`
	//
	// See [Supported asset
	// types](https://cloud.google.com/asset-inventory/docs/supported-asset-types)
	// for more information.
	AssetType string `protobuf:"bytes,2,opt,name=asset_type,json=assetType,proto3" json:"asset_type,omitempty"`
	// A representation of the resource.
	Resource *Resource `protobuf:"bytes,3,opt,name=resource,proto3" json:"resource,omitempty"`
	// A representation of the Cloud IAM policy set on a Google Cloud resource.
	// There can be a maximum of one Cloud IAM policy set on any given resource.
	// In addition, Cloud IAM policies inherit their granted access scope from any
	// policies set on parent resources in the resource hierarchy. Therefore, the
	// effectively policy is the union of both the policy set on this resource
	// and each policy set on all of the resource's ancestry resource levels in
	// the hierarchy. See
	// [this topic](https://cloud.google.com/iam/docs/policies#inheritance) for
	// more information.
	IamPolicy *v1.Policy `protobuf:"bytes,4,opt,name=iam_policy,json=iamPolicy,proto3" json:"iam_policy,omitempty"`
	// A representation of an [organization
	// policy](https://cloud.google.com/resource-manager/docs/organization-policy/overview#organization_policy).
	// There can be more than one organization policy with different constraints
	// set on a given resource.
	OrgPolicy []*v11.Policy `protobuf:"bytes,6,rep,name=org_policy,json=orgPolicy,proto3" json:"org_policy,omitempty"`
	// A representation of an [access
	// policy](https://cloud.google.com/access-context-manager/docs/overview#access-policies).
	//
	// Types that are assignable to AccessContextPolicy:
	//	*Asset_AccessPolicy
	//	*Asset_AccessLevel
	//	*Asset_ServicePerimeter
	AccessContextPolicy isAsset_AccessContextPolicy `protobuf_oneof:"access_context_policy"`
	// The ancestry path of an asset in Google Cloud [resource
	// hierarchy](https://cloud.google.com/resource-manager/docs/cloud-platform-resource-hierarchy),
	// represented as a list of relative resource names. An ancestry path starts
	// with the closest ancestor in the hierarchy and ends at root. If the asset
	// is a project, folder, or organization, the ancestry path starts from the
	// asset itself.
	//
	// Example: `["projects/123456789", "folders/5432", "organizations/1234"]`
	Ancestors []string `protobuf:"bytes,10,rep,name=ancestors,proto3" json:"ancestors,omitempty"`
}

func (x *Asset) Reset() {
	*x = Asset{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_assets_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Asset) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Asset) ProtoMessage() {}

func (x *Asset) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_assets_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Asset.ProtoReflect.Descriptor instead.
func (*Asset) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_assets_proto_rawDescGZIP(), []int{2}
}

func (x *Asset) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Asset) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Asset) GetAssetType() string {
	if x != nil {
		return x.AssetType
	}
	return ""
}

func (x *Asset) GetResource() *Resource {
	if x != nil {
		return x.Resource
	}
	return nil
}

func (x *Asset) GetIamPolicy() *v1.Policy {
	if x != nil {
		return x.IamPolicy
	}
	return nil
}

func (x *Asset) GetOrgPolicy() []*v11.Policy {
	if x != nil {
		return x.OrgPolicy
	}
	return nil
}

func (m *Asset) GetAccessContextPolicy() isAsset_AccessContextPolicy {
	if m != nil {
		return m.AccessContextPolicy
	}
	return nil
}

func (x *Asset) GetAccessPolicy() *v12.AccessPolicy {
	if x, ok := x.GetAccessContextPolicy().(*Asset_AccessPolicy); ok {
		return x.AccessPolicy
	}
	return nil
}

func (x *Asset) GetAccessLevel() *v12.AccessLevel {
	if x, ok := x.GetAccessContextPolicy().(*Asset_AccessLevel); ok {
		return x.AccessLevel
	}
	return nil
}

func (x *Asset) GetServicePerimeter() *v12.ServicePerimeter {
	if x, ok := x.GetAccessContextPolicy().(*Asset_ServicePerimeter); ok {
		return x.ServicePerimeter
	}
	return nil
}

func (x *Asset) GetAncestors() []string {
	if x != nil {
		return x.Ancestors
	}
	return nil
}

type isAsset_AccessContextPolicy interface {
	isAsset_AccessContextPolicy()
}

type Asset_AccessPolicy struct {
	// Please also refer to the [access policy user
	// guide](https://cloud.google.com/access-context-manager/docs/overview#access-policies).
	AccessPolicy *v12.AccessPolicy `protobuf:"bytes,7,opt,name=access_policy,json=accessPolicy,proto3,oneof"`
}

type Asset_AccessLevel struct {
	// Please also refer to the [access level user
	// guide](https://cloud.google.com/access-context-manager/docs/overview#access-levels).
	AccessLevel *v12.AccessLevel `protobuf:"bytes,8,opt,name=access_level,json=accessLevel,proto3,oneof"`
}

type Asset_ServicePerimeter struct {
	// Please also refer to the [service perimeter user
	// guide](https://cloud.google.com/vpc-service-controls/docs/overview).
	ServicePerimeter *v12.ServicePerimeter `protobuf:"bytes,9,opt,name=service_perimeter,json=servicePerimeter,proto3,oneof"`
}

func (*Asset_AccessPolicy) isAsset_AccessContextPolicy() {}

func (*Asset_AccessLevel) isAsset_AccessContextPolicy() {}

func (*Asset_ServicePerimeter) isAsset_AccessContextPolicy() {}

// A representation of a Google Cloud resource.
type Resource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The API version. Example: `v1`
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	// The URL of the discovery document containing the resource's JSON schema.
	// Example:
	// `https://www.googleapis.com/discovery/v1/apis/compute/v1/rest`
	//
	// This value is unspecified for resources that do not have an API based on a
	// discovery document, such as Cloud Bigtable.
	DiscoveryDocumentUri string `protobuf:"bytes,2,opt,name=discovery_document_uri,json=discoveryDocumentUri,proto3" json:"discovery_document_uri,omitempty"`
	// The JSON schema name listed in the discovery document. Example:
	// `Project`
	//
	// This value is unspecified for resources that do not have an API based on a
	// discovery document, such as Cloud Bigtable.
	DiscoveryName string `protobuf:"bytes,3,opt,name=discovery_name,json=discoveryName,proto3" json:"discovery_name,omitempty"`
	// The REST URL for accessing the resource. An HTTP `GET` request using this
	// URL returns the resource itself. Example:
	// `https://cloudresourcemanager.googleapis.com/v1/projects/my-project-123`
	//
	// This value is unspecified for resources without a REST API.
	ResourceUrl string `protobuf:"bytes,4,opt,name=resource_url,json=resourceUrl,proto3" json:"resource_url,omitempty"`
	// The full name of the immediate parent of this resource. See
	// [Resource
	// Names](https://cloud.google.com/apis/design/resource_names#full_resource_name)
	// for more information.
	//
	// For Google Cloud assets, this value is the parent resource defined in the
	// [Cloud IAM policy
	// hierarchy](https://cloud.google.com/iam/docs/overview#policy_hierarchy).
	// Example:
	// `//cloudresourcemanager.googleapis.com/projects/my_project_123`
	//
	// For third-party assets, this field may be set differently.
	Parent string `protobuf:"bytes,5,opt,name=parent,proto3" json:"parent,omitempty"`
	// The content of the resource, in which some sensitive fields are removed
	// and may not be present.
	Data *structpb.Struct `protobuf:"bytes,6,opt,name=data,proto3" json:"data,omitempty"`
	// The location of the resource in Google Cloud, such as its zone and region.
	// For more information, see https://cloud.google.com/about/locations/.
	Location string `protobuf:"bytes,8,opt,name=location,proto3" json:"location,omitempty"`
}

func (x *Resource) Reset() {
	*x = Resource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_assets_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Resource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Resource) ProtoMessage() {}

func (x *Resource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_assets_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Resource.ProtoReflect.Descriptor instead.
func (*Resource) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_assets_proto_rawDescGZIP(), []int{3}
}

func (x *Resource) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *Resource) GetDiscoveryDocumentUri() string {
	if x != nil {
		return x.DiscoveryDocumentUri
	}
	return ""
}

func (x *Resource) GetDiscoveryName() string {
	if x != nil {
		return x.DiscoveryName
	}
	return ""
}

func (x *Resource) GetResourceUrl() string {
	if x != nil {
		return x.ResourceUrl
	}
	return ""
}

func (x *Resource) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *Resource) GetData() *structpb.Struct {
	if x != nil {
		return x.Data
	}
	return nil
}

func (x *Resource) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

// A result of Resource Search, containing information of a cloud resource.
type ResourceSearchResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The full resource name of this resource. Example:
	// `//compute.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1`.
	// See [Cloud Asset Inventory Resource Name
	// Format](https://cloud.google.com/asset-inventory/docs/resource-name-format)
	// for more information.
	//
	// To search against the `name`:
	//
	// * use a field query. Example: `name:instance1`
	// * use a free text query. Example: `instance1`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The type of this resource. Example: `compute.googleapis.com/Disk`.
	//
	// To search against the `asset_type`:
	//
	// * specify the `asset_type` field in your search request.
	AssetType string `protobuf:"bytes,2,opt,name=asset_type,json=assetType,proto3" json:"asset_type,omitempty"`
	// The project that this resource belongs to, in the form of
	// projects/{PROJECT_NUMBER}.
	//
	// To search against the `project`:
	//
	// * specify the `scope` field as this project in your search request.
	Project string `protobuf:"bytes,3,opt,name=project,proto3" json:"project,omitempty"`
	// The display name of this resource.
	//
	// To search against the `display_name`:
	//
	// * use a field query. Example: `displayName:"My Instance"`
	// * use a free text query. Example: `"My Instance"`
	DisplayName string `protobuf:"bytes,4,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// One or more paragraphs of text description of this resource. Maximum length
	// could be up to 1M bytes.
	//
	// To search against the `description`:
	//
	// * use a field query. Example: `description:"*important instance*"`
	// * use a free text query. Example: `"*important instance*"`
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Location can be `global`, regional like `us-east1`, or zonal like
	// `us-west1-b`.
	//
	// To search against the `location`:
	//
	// * use a field query. Example: `location:us-west*`
	// * use a free text query. Example: `us-west*`
	Location string `protobuf:"bytes,6,opt,name=location,proto3" json:"location,omitempty"`
	// Labels associated with this resource. See [Labelling and grouping GCP
	// resources](https://cloud.google.com/blog/products/gcp/labelling-and-grouping-your-google-cloud-platform-resources)
	// for more information.
	//
	// To search against the `labels`:
	//
	// * use a field query:
	//     - query on any label's key or value. Example: `labels:prod`
	//     - query by a given label. Example: `labels.env:prod`
	//     - query by a given label's existence. Example: `labels.env:*`
	// * use a free text query. Example: `prod`
	Labels map[string]string `protobuf:"bytes,7,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Network tags associated with this resource. Like labels, network tags are a
	// type of annotations used to group GCP resources. See [Labelling GCP
	// resources](https://cloud.google.com/blog/products/gcp/labelling-and-grouping-your-google-cloud-platform-resources)
	// for more information.
	//
	// To search against the `network_tags`:
	//
	// * use a field query. Example: `networkTags:internal`
	// * use a free text query. Example: `internal`
	NetworkTags []string `protobuf:"bytes,8,rep,name=network_tags,json=networkTags,proto3" json:"network_tags,omitempty"`
	// The additional searchable attributes of this resource. The attributes may
	// vary from one resource type to another. Examples: `projectId` for Project,
	// `dnsName` for DNS ManagedZone. This field contains a subset of the resource
	// metadata fields that are returned by the List or Get APIs provided by the
	// corresponding GCP service (e.g., Compute Engine). see [API references and
	// supported searchable
	// attributes](https://cloud.google.com/asset-inventory/docs/supported-asset-types#searchable_asset_types)
	// for more information.
	//
	// You can search values of these fields through free text search. However,
	// you should not consume the field programically as the field names and
	// values may change as the GCP service updates to a new incompatible API
	// version.
	//
	// To search against the `additional_attributes`:
	//
	// * use a free text query to match the attributes values. Example: to search
	//   `additional_attributes = { dnsName: "foobar" }`, you can issue a query
	//   `foobar`.
	AdditionalAttributes *structpb.Struct `protobuf:"bytes,9,opt,name=additional_attributes,json=additionalAttributes,proto3" json:"additional_attributes,omitempty"`
}

func (x *ResourceSearchResult) Reset() {
	*x = ResourceSearchResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_assets_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResourceSearchResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceSearchResult) ProtoMessage() {}

func (x *ResourceSearchResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_assets_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceSearchResult.ProtoReflect.Descriptor instead.
func (*ResourceSearchResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_assets_proto_rawDescGZIP(), []int{4}
}

func (x *ResourceSearchResult) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ResourceSearchResult) GetAssetType() string {
	if x != nil {
		return x.AssetType
	}
	return ""
}

func (x *ResourceSearchResult) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *ResourceSearchResult) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *ResourceSearchResult) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *ResourceSearchResult) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

func (x *ResourceSearchResult) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *ResourceSearchResult) GetNetworkTags() []string {
	if x != nil {
		return x.NetworkTags
	}
	return nil
}

func (x *ResourceSearchResult) GetAdditionalAttributes() *structpb.Struct {
	if x != nil {
		return x.AdditionalAttributes
	}
	return nil
}

// A result of IAM Policy search, containing information of an IAM policy.
type IamPolicySearchResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The full resource name of the resource associated with this IAM policy.
	// Example:
	// `//compute.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1`.
	// See [Cloud Asset Inventory Resource Name
	// Format](https://cloud.google.com/asset-inventory/docs/resource-name-format)
	// for more information.
	//
	// To search against the `resource`:
	//
	// * use a field query. Example: `resource:organizations/123`
	Resource string `protobuf:"bytes,1,opt,name=resource,proto3" json:"resource,omitempty"`
	// The project that the associated GCP resource belongs to, in the form of
	// projects/{PROJECT_NUMBER}. If an IAM policy is set on a resource (like VM
	// instance, Cloud Storage bucket), the project field will indicate the
	// project that contains the resource. If an IAM policy is set on a folder or
	// orgnization, the project field will be empty.
	//
	// To search against the `project`:
	//
	// * specify the `scope` field as this project in your search request.
	Project string `protobuf:"bytes,2,opt,name=project,proto3" json:"project,omitempty"`
	// The IAM policy directly set on the given resource. Note that the original
	// IAM policy can contain multiple bindings. This only contains the bindings
	// that match the given query. For queries that don't contain a constrain on
	// policies (e.g., an empty query), this contains all the bindings.
	//
	// To search against the `policy` bindings:
	//
	// * use a field query:
	//     - query by the policy contained members. Example:
	//       `policy:amy@gmail.com`
	//     - query by the policy contained roles. Example:
	//       `policy:roles/compute.admin`
	//     - query by the policy contained roles' included permissions. Example:
	//       `policy.role.permissions:compute.instances.create`
	Policy *v1.Policy `protobuf:"bytes,3,opt,name=policy,proto3" json:"policy,omitempty"`
	// Explanation about the IAM policy search result. It contains additional
	// information to explain why the search result matches the query.
	Explanation *IamPolicySearchResult_Explanation `protobuf:"bytes,4,opt,name=explanation,proto3" json:"explanation,omitempty"`
}

func (x *IamPolicySearchResult) Reset() {
	*x = IamPolicySearchResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_assets_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IamPolicySearchResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IamPolicySearchResult) ProtoMessage() {}

func (x *IamPolicySearchResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_assets_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IamPolicySearchResult.ProtoReflect.Descriptor instead.
func (*IamPolicySearchResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_assets_proto_rawDescGZIP(), []int{5}
}

func (x *IamPolicySearchResult) GetResource() string {
	if x != nil {
		return x.Resource
	}
	return ""
}

func (x *IamPolicySearchResult) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *IamPolicySearchResult) GetPolicy() *v1.Policy {
	if x != nil {
		return x.Policy
	}
	return nil
}

func (x *IamPolicySearchResult) GetExplanation() *IamPolicySearchResult_Explanation {
	if x != nil {
		return x.Explanation
	}
	return nil
}

// Represents the detailed state of an entity under analysis, such as a
// resource, an identity or an access.
type IamPolicyAnalysisState struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Google standard error code that best describes the state.
	// For example:
	// - OK means the analysis on this entity has been successfully finished;
	// - PERMISSION_DENIED means an access denied error is encountered;
	// - DEADLINE_EXCEEDED means the analysis on this entity hasn't been started
	// in time;
	Code code.Code `protobuf:"varint,1,opt,name=code,proto3,enum=google.rpc.Code" json:"code,omitempty"`
	// The human-readable description of the cause of failure.
	Cause string `protobuf:"bytes,2,opt,name=cause,proto3" json:"cause,omitempty"`
}

func (x *IamPolicyAnalysisState) Reset() {
	*x = IamPolicyAnalysisState{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_assets_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IamPolicyAnalysisState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IamPolicyAnalysisState) ProtoMessage() {}

func (x *IamPolicyAnalysisState) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_assets_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IamPolicyAnalysisState.ProtoReflect.Descriptor instead.
func (*IamPolicyAnalysisState) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_assets_proto_rawDescGZIP(), []int{6}
}

func (x *IamPolicyAnalysisState) GetCode() code.Code {
	if x != nil {
		return x.Code
	}
	return code.Code_OK
}

func (x *IamPolicyAnalysisState) GetCause() string {
	if x != nil {
		return x.Cause
	}
	return ""
}

// IAM Policy analysis result, consisting of one IAM policy binding and derived
// access control lists.
type IamPolicyAnalysisResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The [full resource
	// name](https://cloud.google.com/asset-inventory/docs/resource-name-format)
	// of the resource to which the [iam_binding][google.cloud.asset.v1.IamPolicyAnalysisResult.iam_binding] policy attaches.
	AttachedResourceFullName string `protobuf:"bytes,1,opt,name=attached_resource_full_name,json=attachedResourceFullName,proto3" json:"attached_resource_full_name,omitempty"`
	// The Cloud IAM policy binding under analysis.
	IamBinding *v1.Binding `protobuf:"bytes,2,opt,name=iam_binding,json=iamBinding,proto3" json:"iam_binding,omitempty"`
	// The access control lists derived from the [iam_binding][google.cloud.asset.v1.IamPolicyAnalysisResult.iam_binding] that match or
	// potentially match resource and access selectors specified in the request.
	AccessControlLists []*IamPolicyAnalysisResult_AccessControlList `protobuf:"bytes,3,rep,name=access_control_lists,json=accessControlLists,proto3" json:"access_control_lists,omitempty"`
	// The identity list derived from members of the [iam_binding][google.cloud.asset.v1.IamPolicyAnalysisResult.iam_binding] that match or
	// potentially match identity selector specified in the request.
	IdentityList *IamPolicyAnalysisResult_IdentityList `protobuf:"bytes,4,opt,name=identity_list,json=identityList,proto3" json:"identity_list,omitempty"`
	// Represents whether all analyses on the [iam_binding][google.cloud.asset.v1.IamPolicyAnalysisResult.iam_binding] have successfully
	// finished.
	FullyExplored bool `protobuf:"varint,5,opt,name=fully_explored,json=fullyExplored,proto3" json:"fully_explored,omitempty"`
}

func (x *IamPolicyAnalysisResult) Reset() {
	*x = IamPolicyAnalysisResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_assets_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IamPolicyAnalysisResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IamPolicyAnalysisResult) ProtoMessage() {}

func (x *IamPolicyAnalysisResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_assets_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IamPolicyAnalysisResult.ProtoReflect.Descriptor instead.
func (*IamPolicyAnalysisResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_assets_proto_rawDescGZIP(), []int{7}
}

func (x *IamPolicyAnalysisResult) GetAttachedResourceFullName() string {
	if x != nil {
		return x.AttachedResourceFullName
	}
	return ""
}

func (x *IamPolicyAnalysisResult) GetIamBinding() *v1.Binding {
	if x != nil {
		return x.IamBinding
	}
	return nil
}

func (x *IamPolicyAnalysisResult) GetAccessControlLists() []*IamPolicyAnalysisResult_AccessControlList {
	if x != nil {
		return x.AccessControlLists
	}
	return nil
}

func (x *IamPolicyAnalysisResult) GetIdentityList() *IamPolicyAnalysisResult_IdentityList {
	if x != nil {
		return x.IdentityList
	}
	return nil
}

func (x *IamPolicyAnalysisResult) GetFullyExplored() bool {
	if x != nil {
		return x.FullyExplored
	}
	return false
}

// Explanation about the IAM policy search result.
type IamPolicySearchResult_Explanation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The map from roles to their included permissions that match the
	// permission query (i.e., a query containing `policy.role.permissions:`).
	// Example: if query `policy.role.permissions:compute.disk.get`
	// matches a policy binding that contains owner role, the
	// matched_permissions will be `{"roles/owner": ["compute.disk.get"]}`. The
	// roles can also be found in the returned `policy` bindings. Note that the
	// map is populated only for requests with permission queries.
	MatchedPermissions map[string]*IamPolicySearchResult_Explanation_Permissions `protobuf:"bytes,1,rep,name=matched_permissions,json=matchedPermissions,proto3" json:"matched_permissions,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *IamPolicySearchResult_Explanation) Reset() {
	*x = IamPolicySearchResult_Explanation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_assets_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IamPolicySearchResult_Explanation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IamPolicySearchResult_Explanation) ProtoMessage() {}

func (x *IamPolicySearchResult_Explanation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_assets_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IamPolicySearchResult_Explanation.ProtoReflect.Descriptor instead.
func (*IamPolicySearchResult_Explanation) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_assets_proto_rawDescGZIP(), []int{5, 0}
}

func (x *IamPolicySearchResult_Explanation) GetMatchedPermissions() map[string]*IamPolicySearchResult_Explanation_Permissions {
	if x != nil {
		return x.MatchedPermissions
	}
	return nil
}

// IAM permissions
type IamPolicySearchResult_Explanation_Permissions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of permissions. A sample permission string: `compute.disk.get`.
	Permissions []string `protobuf:"bytes,1,rep,name=permissions,proto3" json:"permissions,omitempty"`
}

func (x *IamPolicySearchResult_Explanation_Permissions) Reset() {
	*x = IamPolicySearchResult_Explanation_Permissions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_assets_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IamPolicySearchResult_Explanation_Permissions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IamPolicySearchResult_Explanation_Permissions) ProtoMessage() {}

func (x *IamPolicySearchResult_Explanation_Permissions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_assets_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IamPolicySearchResult_Explanation_Permissions.ProtoReflect.Descriptor instead.
func (*IamPolicySearchResult_Explanation_Permissions) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_assets_proto_rawDescGZIP(), []int{5, 0, 0}
}

func (x *IamPolicySearchResult_Explanation_Permissions) GetPermissions() []string {
	if x != nil {
		return x.Permissions
	}
	return nil
}

// A Google Cloud resource under analysis.
type IamPolicyAnalysisResult_Resource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The [full resource
	// name](https://cloud.google.com/asset-inventory/docs/resource-name-format)
	FullResourceName string `protobuf:"bytes,1,opt,name=full_resource_name,json=fullResourceName,proto3" json:"full_resource_name,omitempty"`
	// The analysis state of this resource.
	AnalysisState *IamPolicyAnalysisState `protobuf:"bytes,2,opt,name=analysis_state,json=analysisState,proto3" json:"analysis_state,omitempty"`
}

func (x *IamPolicyAnalysisResult_Resource) Reset() {
	*x = IamPolicyAnalysisResult_Resource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_assets_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IamPolicyAnalysisResult_Resource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IamPolicyAnalysisResult_Resource) ProtoMessage() {}

func (x *IamPolicyAnalysisResult_Resource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_assets_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IamPolicyAnalysisResult_Resource.ProtoReflect.Descriptor instead.
func (*IamPolicyAnalysisResult_Resource) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_assets_proto_rawDescGZIP(), []int{7, 0}
}

func (x *IamPolicyAnalysisResult_Resource) GetFullResourceName() string {
	if x != nil {
		return x.FullResourceName
	}
	return ""
}

func (x *IamPolicyAnalysisResult_Resource) GetAnalysisState() *IamPolicyAnalysisState {
	if x != nil {
		return x.AnalysisState
	}
	return nil
}

// An IAM role or permission under analysis.
type IamPolicyAnalysisResult_Access struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to OneofAccess:
	//	*IamPolicyAnalysisResult_Access_Role
	//	*IamPolicyAnalysisResult_Access_Permission
	OneofAccess isIamPolicyAnalysisResult_Access_OneofAccess `protobuf_oneof:"oneof_access"`
	// The analysis state of this access.
	AnalysisState *IamPolicyAnalysisState `protobuf:"bytes,3,opt,name=analysis_state,json=analysisState,proto3" json:"analysis_state,omitempty"`
}

func (x *IamPolicyAnalysisResult_Access) Reset() {
	*x = IamPolicyAnalysisResult_Access{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_assets_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IamPolicyAnalysisResult_Access) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IamPolicyAnalysisResult_Access) ProtoMessage() {}

func (x *IamPolicyAnalysisResult_Access) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_assets_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IamPolicyAnalysisResult_Access.ProtoReflect.Descriptor instead.
func (*IamPolicyAnalysisResult_Access) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_assets_proto_rawDescGZIP(), []int{7, 1}
}

func (m *IamPolicyAnalysisResult_Access) GetOneofAccess() isIamPolicyAnalysisResult_Access_OneofAccess {
	if m != nil {
		return m.OneofAccess
	}
	return nil
}

func (x *IamPolicyAnalysisResult_Access) GetRole() string {
	if x, ok := x.GetOneofAccess().(*IamPolicyAnalysisResult_Access_Role); ok {
		return x.Role
	}
	return ""
}

func (x *IamPolicyAnalysisResult_Access) GetPermission() string {
	if x, ok := x.GetOneofAccess().(*IamPolicyAnalysisResult_Access_Permission); ok {
		return x.Permission
	}
	return ""
}

func (x *IamPolicyAnalysisResult_Access) GetAnalysisState() *IamPolicyAnalysisState {
	if x != nil {
		return x.AnalysisState
	}
	return nil
}

type isIamPolicyAnalysisResult_Access_OneofAccess interface {
	isIamPolicyAnalysisResult_Access_OneofAccess()
}

type IamPolicyAnalysisResult_Access_Role struct {
	// The role.
	Role string `protobuf:"bytes,1,opt,name=role,proto3,oneof"`
}

type IamPolicyAnalysisResult_Access_Permission struct {
	// The permission.
	Permission string `protobuf:"bytes,2,opt,name=permission,proto3,oneof"`
}

func (*IamPolicyAnalysisResult_Access_Role) isIamPolicyAnalysisResult_Access_OneofAccess() {}

func (*IamPolicyAnalysisResult_Access_Permission) isIamPolicyAnalysisResult_Access_OneofAccess() {}

// An identity under analysis.
type IamPolicyAnalysisResult_Identity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The identity name in any form of members appear in
	// [IAM policy
	// binding](https://cloud.google.com/iam/reference/rest/v1/Binding), such
	// as:
	// - user:foo@google.com
	// - group:group1@google.com
	// - serviceAccount:s1@prj1.iam.gserviceaccount.com
	// - projectOwner:some_project_id
	// - domain:google.com
	// - allUsers
	// - etc.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The analysis state of this identity.
	AnalysisState *IamPolicyAnalysisState `protobuf:"bytes,2,opt,name=analysis_state,json=analysisState,proto3" json:"analysis_state,omitempty"`
}

func (x *IamPolicyAnalysisResult_Identity) Reset() {
	*x = IamPolicyAnalysisResult_Identity{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_assets_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IamPolicyAnalysisResult_Identity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IamPolicyAnalysisResult_Identity) ProtoMessage() {}

func (x *IamPolicyAnalysisResult_Identity) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_assets_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IamPolicyAnalysisResult_Identity.ProtoReflect.Descriptor instead.
func (*IamPolicyAnalysisResult_Identity) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_assets_proto_rawDescGZIP(), []int{7, 2}
}

func (x *IamPolicyAnalysisResult_Identity) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *IamPolicyAnalysisResult_Identity) GetAnalysisState() *IamPolicyAnalysisState {
	if x != nil {
		return x.AnalysisState
	}
	return nil
}

// A directional edge.
type IamPolicyAnalysisResult_Edge struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The source node of the edge. For example, it could be a full resource
	// name for a resource node or an email of an identity.
	SourceNode string `protobuf:"bytes,1,opt,name=source_node,json=sourceNode,proto3" json:"source_node,omitempty"`
	// The target node of the edge. For example, it could be a full resource
	// name for a resource node or an email of an identity.
	TargetNode string `protobuf:"bytes,2,opt,name=target_node,json=targetNode,proto3" json:"target_node,omitempty"`
}

func (x *IamPolicyAnalysisResult_Edge) Reset() {
	*x = IamPolicyAnalysisResult_Edge{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_assets_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IamPolicyAnalysisResult_Edge) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IamPolicyAnalysisResult_Edge) ProtoMessage() {}

func (x *IamPolicyAnalysisResult_Edge) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_assets_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IamPolicyAnalysisResult_Edge.ProtoReflect.Descriptor instead.
func (*IamPolicyAnalysisResult_Edge) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_assets_proto_rawDescGZIP(), []int{7, 3}
}

func (x *IamPolicyAnalysisResult_Edge) GetSourceNode() string {
	if x != nil {
		return x.SourceNode
	}
	return ""
}

func (x *IamPolicyAnalysisResult_Edge) GetTargetNode() string {
	if x != nil {
		return x.TargetNode
	}
	return ""
}

// An access control list, derived from the above IAM policy binding, which
// contains a set of resources and accesses. May include one
// item from each set to compose an access control entry.
//
// NOTICE that there could be multiple access control lists for one IAM policy
// binding. The access control lists are created based on resource and access
// combinations.
//
// For example, assume we have the following cases in one IAM policy binding:
// - Permission P1 and P2 apply to resource R1 and R2;
// - Permission P3 applies to resource R2 and R3;
//
// This will result in the following access control lists:
// - AccessControlList 1: [R1, R2], [P1, P2]
// - AccessControlList 2: [R2, R3], [P3]
type IamPolicyAnalysisResult_AccessControlList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resources that match one of the following conditions:
	// - The resource_selector, if it is specified in request;
	// - Otherwise, resources reachable from the policy attached resource.
	Resources []*IamPolicyAnalysisResult_Resource `protobuf:"bytes,1,rep,name=resources,proto3" json:"resources,omitempty"`
	// The accesses that match one of the following conditions:
	// - The access_selector, if it is specified in request;
	// - Otherwise, access specifiers reachable from the policy binding's role.
	Accesses []*IamPolicyAnalysisResult_Access `protobuf:"bytes,2,rep,name=accesses,proto3" json:"accesses,omitempty"`
	// Resource edges of the graph starting from the policy attached
	// resource to any descendant resources. The [Edge.source_node][google.cloud.asset.v1.IamPolicyAnalysisResult.Edge.source_node] contains
	// the full resource name of a parent resource and [Edge.target_node][google.cloud.asset.v1.IamPolicyAnalysisResult.Edge.target_node]
	// contains the full resource name of a child resource. This field is
	// present only if the output_resource_edges option is enabled in request.
	ResourceEdges []*IamPolicyAnalysisResult_Edge `protobuf:"bytes,3,rep,name=resource_edges,json=resourceEdges,proto3" json:"resource_edges,omitempty"`
}

func (x *IamPolicyAnalysisResult_AccessControlList) Reset() {
	*x = IamPolicyAnalysisResult_AccessControlList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_assets_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IamPolicyAnalysisResult_AccessControlList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IamPolicyAnalysisResult_AccessControlList) ProtoMessage() {}

func (x *IamPolicyAnalysisResult_AccessControlList) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_assets_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IamPolicyAnalysisResult_AccessControlList.ProtoReflect.Descriptor instead.
func (*IamPolicyAnalysisResult_AccessControlList) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_assets_proto_rawDescGZIP(), []int{7, 4}
}

func (x *IamPolicyAnalysisResult_AccessControlList) GetResources() []*IamPolicyAnalysisResult_Resource {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *IamPolicyAnalysisResult_AccessControlList) GetAccesses() []*IamPolicyAnalysisResult_Access {
	if x != nil {
		return x.Accesses
	}
	return nil
}

func (x *IamPolicyAnalysisResult_AccessControlList) GetResourceEdges() []*IamPolicyAnalysisResult_Edge {
	if x != nil {
		return x.ResourceEdges
	}
	return nil
}

// The identities and group edges.
type IamPolicyAnalysisResult_IdentityList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Only the identities that match one of the following conditions will be
	// presented:
	// - The identity_selector, if it is specified in request;
	// - Otherwise, identities reachable from the policy binding's members.
	Identities []*IamPolicyAnalysisResult_Identity `protobuf:"bytes,1,rep,name=identities,proto3" json:"identities,omitempty"`
	// Group identity edges of the graph starting from the binding's
	// group members to any node of the [identities][google.cloud.asset.v1.IamPolicyAnalysisResult.IdentityList.identities]. The [Edge.source_node][google.cloud.asset.v1.IamPolicyAnalysisResult.Edge.source_node]
	// contains a group, such as `group:parent@google.com`. The
	// [Edge.target_node][google.cloud.asset.v1.IamPolicyAnalysisResult.Edge.target_node] contains a member of the group,
	// such as `group:child@google.com` or `user:foo@google.com`.
	// This field is present only if the output_group_edges option is enabled in
	// request.
	GroupEdges []*IamPolicyAnalysisResult_Edge `protobuf:"bytes,2,rep,name=group_edges,json=groupEdges,proto3" json:"group_edges,omitempty"`
}

func (x *IamPolicyAnalysisResult_IdentityList) Reset() {
	*x = IamPolicyAnalysisResult_IdentityList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_assets_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IamPolicyAnalysisResult_IdentityList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IamPolicyAnalysisResult_IdentityList) ProtoMessage() {}

func (x *IamPolicyAnalysisResult_IdentityList) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_assets_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IamPolicyAnalysisResult_IdentityList.ProtoReflect.Descriptor instead.
func (*IamPolicyAnalysisResult_IdentityList) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_assets_proto_rawDescGZIP(), []int{7, 5}
}

func (x *IamPolicyAnalysisResult_IdentityList) GetIdentities() []*IamPolicyAnalysisResult_Identity {
	if x != nil {
		return x.Identities
	}
	return nil
}

func (x *IamPolicyAnalysisResult_IdentityList) GetGroupEdges() []*IamPolicyAnalysisResult_Edge {
	if x != nil {
		return x.GroupEdges
	}
	return nil
}

var File_google_cloud_asset_v1_assets_proto protoreflect.FileDescriptor

var file_google_cloud_asset_v1_assets_proto_rawDesc = []byte{
	0x0a, 0x22, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x73, 0x73, 0x65, 0x74, 0x2f, 0x76, 0x31, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x1a, 0x19, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x29, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6f, 0x72, 0x67, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2f, 0x76,
	0x31, 0x2f, 0x6f, 0x72, 0x67, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x69, 0x61, 0x6d, 0x2f, 0x76, 0x31,
	0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3a, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2f, 0x61,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x6c, 0x65,
	0x76, 0x65, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3b, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2f, 0x61, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2f,
	0x76, 0x31, 0x2f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x69,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x63, 0x6f,
	0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x2f,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x74, 0x65,
	0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x61, 0x6e, 0x79, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x63, 0x6f,
	0x64, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xaa, 0x03, 0x0a, 0x0d, 0x54, 0x65, 0x6d, 0x70, 0x6f,
	0x72, 0x61, 0x6c, 0x41, 0x73, 0x73, 0x65, 0x74, 0x12, 0x39, 0x0a, 0x06, 0x77, 0x69, 0x6e, 0x64,
	0x6f, 0x77, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x52, 0x06, 0x77, 0x69, 0x6e,
	0x64, 0x6f, 0x77, 0x12, 0x18, 0x0a, 0x07, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x12, 0x32, 0x0a,
	0x05, 0x61, 0x73, 0x73, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65,
	0x74, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x05, 0x61, 0x73, 0x73, 0x65,
	0x74, 0x12, 0x60, 0x0a, 0x11, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x5f, 0x61, 0x73, 0x73, 0x65, 0x74,
	0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x34, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65,
	0x74, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x6d, 0x70, 0x6f, 0x72, 0x61, 0x6c, 0x41, 0x73, 0x73,
	0x65, 0x74, 0x2e, 0x50, 0x72, 0x69, 0x6f, 0x72, 0x41, 0x73, 0x73, 0x65, 0x74, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x52, 0x0f, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x41, 0x73, 0x73, 0x65, 0x74, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x3d, 0x0a, 0x0b, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x5f, 0x61, 0x73, 0x73,
	0x65, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31,
	0x2e, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x0a, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x41, 0x73, 0x73,
	0x65, 0x74, 0x22, 0x6f, 0x0a, 0x0f, 0x50, 0x72, 0x69, 0x6f, 0x72, 0x41, 0x73, 0x73, 0x65, 0x74,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x21, 0x0a, 0x1d, 0x50, 0x52, 0x49, 0x4f, 0x52, 0x5f, 0x41,
	0x53, 0x53, 0x45, 0x54, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x52, 0x45, 0x53,
	0x45, 0x4e, 0x54, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44,
	0x10, 0x02, 0x12, 0x12, 0x0a, 0x0e, 0x44, 0x4f, 0x45, 0x53, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x45,
	0x58, 0x49, 0x53, 0x54, 0x10, 0x03, 0x12, 0x0b, 0x0a, 0x07, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45,
	0x44, 0x10, 0x04, 0x22, 0x7e, 0x0a, 0x0a, 0x54, 0x69, 0x6d, 0x65, 0x57, 0x69, 0x6e, 0x64, 0x6f,
	0x77, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x35, 0x0a, 0x08,
	0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54,
	0x69, 0x6d, 0x65, 0x22, 0xaf, 0x05, 0x0a, 0x05, 0x41, 0x73, 0x73, 0x65, 0x74, 0x12, 0x3b, 0x0a,
	0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0b, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1d,
	0x0a, 0x0a, 0x61, 0x73, 0x73, 0x65, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x61, 0x73, 0x73, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x3b, 0x0a,
	0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x52, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x34, 0x0a, 0x0a, 0x69, 0x61,
	0x6d, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x09, 0x69, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x12, 0x40, 0x0a, 0x0a, 0x6f, 0x72, 0x67, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x06,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x67, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x76, 0x31,
	0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x09, 0x6f, 0x72, 0x67, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x12, 0x5c, 0x0a, 0x0d, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x70, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x61, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x48, 0x00, 0x52, 0x0c, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x12, 0x59, 0x0a, 0x0c, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x48, 0x00, 0x52, 0x0b,
	0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x68, 0x0a, 0x11, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x74, 0x65, 0x72,
	0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x74, 0x65,
	0x72, 0x48, 0x00, 0x52, 0x10, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x65, 0x72, 0x69,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x12, 0x1c, 0x0a, 0x09, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x74, 0x6f,
	0x72, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x09, 0x52, 0x09, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x74,
	0x6f, 0x72, 0x73, 0x3a, 0x27, 0xea, 0x41, 0x24, 0x0a, 0x1f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x61,
	0x73, 0x73, 0x65, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x73, 0x73, 0x65, 0x74, 0x12, 0x01, 0x2a, 0x42, 0x17, 0x0a, 0x15,
	0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x70,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0x85, 0x02, 0x0a, 0x08, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x34, 0x0a, 0x16,
	0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x5f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x14, 0x64, 0x69,
	0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x55,
	0x72, 0x69, 0x12, 0x25, 0x0a, 0x0e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x64, 0x69, 0x73, 0x63,
	0x6f, 0x76, 0x65, 0x72, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x55, 0x72, 0x6c, 0x12, 0x16, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x2b, 0x0a, 0x04, 0x64, 0x61, 0x74, 0x61, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x04, 0x64, 0x61, 0x74,
	0x61, 0x12, 0x1a, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xc1, 0x03,
	0x0a, 0x14, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x61, 0x73,
	0x73, 0x65, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x61, 0x73, 0x73, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1a, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4f, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x07,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x5f, 0x74, 0x61, 0x67, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x54, 0x61, 0x67, 0x73, 0x12, 0x4c, 0x0a, 0x15, 0x61, 0x64, 0x64, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65,
	0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74,
	0x52, 0x14, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x41, 0x74, 0x74, 0x72,
	0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38,
	0x01, 0x22, 0xab, 0x04, 0x0a, 0x15, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x53,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x12, 0x2d, 0x0a, 0x06, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76,
	0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x06, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x12, 0x5a, 0x0a, 0x0b, 0x65, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x61,
	0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x0b, 0x65, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0xd0, 0x02, 0x0a,
	0x0b, 0x45, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x81, 0x01, 0x0a,
	0x13, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x64, 0x5f, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x50, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e,
	0x76, 0x31, 0x2e, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x53, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x64, 0x50, 0x65, 0x72, 0x6d,
	0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x12, 0x6d, 0x61,
	0x74, 0x63, 0x68, 0x65, 0x64, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x1a, 0x2f, 0x0a, 0x0b, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x20, 0x0a, 0x0b, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x1a, 0x8b, 0x01, 0x0a, 0x17, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x64, 0x50, 0x65, 0x72,
	0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x5a, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x44,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73,
	0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x45, 0x78, 0x70,
	0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22,
	0x54, 0x0a, 0x16, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c,
	0x79, 0x73, 0x69, 0x73, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x24, 0x0a, 0x04, 0x63, 0x6f, 0x64,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x10, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x72, 0x70, 0x63, 0x2e, 0x43, 0x6f, 0x64, 0x65, 0x52, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x12,
	0x14, 0x0a, 0x05, 0x63, 0x61, 0x75, 0x73, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x63, 0x61, 0x75, 0x73, 0x65, 0x22, 0xe4, 0x0a, 0x0a, 0x17, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x12, 0x3d, 0x0a, 0x1b, 0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x5f, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x66, 0x75, 0x6c, 0x6c, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x18, 0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x46, 0x75, 0x6c, 0x6c, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x37, 0x0a, 0x0b, 0x69, 0x61, 0x6d, 0x5f, 0x62, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69,
	0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x0a, 0x69,
	0x61, 0x6d, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x72, 0x0a, 0x14, 0x61, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x5f, 0x6c, 0x69, 0x73, 0x74,
	0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e,
	0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69,
	0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f,
	0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x12, 0x61, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x4c, 0x69, 0x73, 0x74, 0x73, 0x12, 0x60, 0x0a,
	0x0d, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x6c, 0x69, 0x73, 0x74, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x61, 0x6d,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x2e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x4c, 0x69, 0x73,
	0x74, 0x52, 0x0c, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x4c, 0x69, 0x73, 0x74, 0x12,
	0x25, 0x0a, 0x0e, 0x66, 0x75, 0x6c, 0x6c, 0x79, 0x5f, 0x65, 0x78, 0x70, 0x6c, 0x6f, 0x72, 0x65,
	0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x66, 0x75, 0x6c, 0x6c, 0x79, 0x45, 0x78,
	0x70, 0x6c, 0x6f, 0x72, 0x65, 0x64, 0x1a, 0x8e, 0x01, 0x0a, 0x08, 0x52, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x12, 0x2c, 0x0a, 0x12, 0x66, 0x75, 0x6c, 0x6c, 0x5f, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x10, 0x66, 0x75, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x54, 0x0a, 0x0e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x5f, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76,
	0x31, 0x2e, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79,
	0x73, 0x69, 0x73, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x0d, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73,
	0x69, 0x73, 0x53, 0x74, 0x61, 0x74, 0x65, 0x1a, 0xa6, 0x01, 0x0a, 0x06, 0x41, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x12, 0x14, 0x0a, 0x04, 0x72, 0x6f, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x48, 0x00, 0x52, 0x04, 0x72, 0x6f, 0x6c, 0x65, 0x12, 0x20, 0x0a, 0x0a, 0x70, 0x65, 0x72, 0x6d,
	0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0a,
	0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x54, 0x0a, 0x0e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x61, 0x6d, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x52, 0x0d, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x42, 0x0e, 0x0a, 0x0c, 0x6f, 0x6e, 0x65, 0x6f, 0x66, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x1a, 0x74, 0x0a, 0x08, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x12, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x54, 0x0a, 0x0e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x5f, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31,
	0x2e, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73,
	0x69, 0x73, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x0d, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69,
	0x73, 0x53, 0x74, 0x61, 0x74, 0x65, 0x1a, 0x48, 0x0a, 0x04, 0x45, 0x64, 0x67, 0x65, 0x12, 0x1f,
	0x0a, 0x0b, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x12,
	0x1f, 0x0a, 0x0b, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x4e, 0x6f, 0x64, 0x65,
	0x1a, 0x99, 0x02, 0x0a, 0x11, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72,
	0x6f, 0x6c, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x55, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76,
	0x31, 0x2e, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79,
	0x73, 0x69, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x52, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x51, 0x0a,
	0x08, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e,
	0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x52, 0x08, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x65, 0x73,
	0x12, 0x5a, 0x0a, 0x0e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x65, 0x64, 0x67,
	0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31,
	0x2e, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73,
	0x69, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x45, 0x64, 0x67, 0x65, 0x52, 0x0d, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x45, 0x64, 0x67, 0x65, 0x73, 0x1a, 0xbd, 0x01, 0x0a,
	0x0c, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x57, 0x0a,
	0x0a, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x2e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x0a, 0x69, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x12, 0x54, 0x0a, 0x0b, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f,
	0x65, 0x64, 0x67, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74,
	0x2e, 0x76, 0x31, 0x2e, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x6e, 0x61,
	0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x45, 0x64, 0x67, 0x65,
	0x52, 0x0a, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x45, 0x64, 0x67, 0x65, 0x73, 0x42, 0x98, 0x01, 0x0a,
	0x19, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x42, 0x0a, 0x41, 0x73, 0x73, 0x65,
	0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2f, 0x76, 0x31, 0x3b, 0x61,
	0x73, 0x73, 0x65, 0x74, 0xf8, 0x01, 0x01, 0xaa, 0x02, 0x15, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x41, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x56, 0x31, 0xca,
	0x02, 0x15, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x41,
	0x73, 0x73, 0x65, 0x74, 0x5c, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_asset_v1_assets_proto_rawDescOnce sync.Once
	file_google_cloud_asset_v1_assets_proto_rawDescData = file_google_cloud_asset_v1_assets_proto_rawDesc
)

func file_google_cloud_asset_v1_assets_proto_rawDescGZIP() []byte {
	file_google_cloud_asset_v1_assets_proto_rawDescOnce.Do(func() {
		file_google_cloud_asset_v1_assets_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_asset_v1_assets_proto_rawDescData)
	})
	return file_google_cloud_asset_v1_assets_proto_rawDescData
}

var file_google_cloud_asset_v1_assets_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_asset_v1_assets_proto_msgTypes = make([]protoimpl.MessageInfo, 18)
var file_google_cloud_asset_v1_assets_proto_goTypes = []interface{}{
	(TemporalAsset_PriorAssetState)(0),        // 0: google.cloud.asset.v1.TemporalAsset.PriorAssetState
	(*TemporalAsset)(nil),                     // 1: google.cloud.asset.v1.TemporalAsset
	(*TimeWindow)(nil),                        // 2: google.cloud.asset.v1.TimeWindow
	(*Asset)(nil),                             // 3: google.cloud.asset.v1.Asset
	(*Resource)(nil),                          // 4: google.cloud.asset.v1.Resource
	(*ResourceSearchResult)(nil),              // 5: google.cloud.asset.v1.ResourceSearchResult
	(*IamPolicySearchResult)(nil),             // 6: google.cloud.asset.v1.IamPolicySearchResult
	(*IamPolicyAnalysisState)(nil),            // 7: google.cloud.asset.v1.IamPolicyAnalysisState
	(*IamPolicyAnalysisResult)(nil),           // 8: google.cloud.asset.v1.IamPolicyAnalysisResult
	nil,                                       // 9: google.cloud.asset.v1.ResourceSearchResult.LabelsEntry
	(*IamPolicySearchResult_Explanation)(nil), // 10: google.cloud.asset.v1.IamPolicySearchResult.Explanation
	(*IamPolicySearchResult_Explanation_Permissions)(nil), // 11: google.cloud.asset.v1.IamPolicySearchResult.Explanation.Permissions
	nil,                                               // 12: google.cloud.asset.v1.IamPolicySearchResult.Explanation.MatchedPermissionsEntry
	(*IamPolicyAnalysisResult_Resource)(nil),          // 13: google.cloud.asset.v1.IamPolicyAnalysisResult.Resource
	(*IamPolicyAnalysisResult_Access)(nil),            // 14: google.cloud.asset.v1.IamPolicyAnalysisResult.Access
	(*IamPolicyAnalysisResult_Identity)(nil),          // 15: google.cloud.asset.v1.IamPolicyAnalysisResult.Identity
	(*IamPolicyAnalysisResult_Edge)(nil),              // 16: google.cloud.asset.v1.IamPolicyAnalysisResult.Edge
	(*IamPolicyAnalysisResult_AccessControlList)(nil), // 17: google.cloud.asset.v1.IamPolicyAnalysisResult.AccessControlList
	(*IamPolicyAnalysisResult_IdentityList)(nil),      // 18: google.cloud.asset.v1.IamPolicyAnalysisResult.IdentityList
	(*timestamppb.Timestamp)(nil),                     // 19: google.protobuf.Timestamp
	(*v1.Policy)(nil),                                 // 20: google.iam.v1.Policy
	(*v11.Policy)(nil),                                // 21: google.cloud.orgpolicy.v1.Policy
	(*v12.AccessPolicy)(nil),                          // 22: google.identity.accesscontextmanager.v1.AccessPolicy
	(*v12.AccessLevel)(nil),                           // 23: google.identity.accesscontextmanager.v1.AccessLevel
	(*v12.ServicePerimeter)(nil),                      // 24: google.identity.accesscontextmanager.v1.ServicePerimeter
	(*structpb.Struct)(nil),                           // 25: google.protobuf.Struct
	(code.Code)(0),                                    // 26: google.rpc.Code
	(*v1.Binding)(nil),                                // 27: google.iam.v1.Binding
}
var file_google_cloud_asset_v1_assets_proto_depIdxs = []int32{
	2,  // 0: google.cloud.asset.v1.TemporalAsset.window:type_name -> google.cloud.asset.v1.TimeWindow
	3,  // 1: google.cloud.asset.v1.TemporalAsset.asset:type_name -> google.cloud.asset.v1.Asset
	0,  // 2: google.cloud.asset.v1.TemporalAsset.prior_asset_state:type_name -> google.cloud.asset.v1.TemporalAsset.PriorAssetState
	3,  // 3: google.cloud.asset.v1.TemporalAsset.prior_asset:type_name -> google.cloud.asset.v1.Asset
	19, // 4: google.cloud.asset.v1.TimeWindow.start_time:type_name -> google.protobuf.Timestamp
	19, // 5: google.cloud.asset.v1.TimeWindow.end_time:type_name -> google.protobuf.Timestamp
	19, // 6: google.cloud.asset.v1.Asset.update_time:type_name -> google.protobuf.Timestamp
	4,  // 7: google.cloud.asset.v1.Asset.resource:type_name -> google.cloud.asset.v1.Resource
	20, // 8: google.cloud.asset.v1.Asset.iam_policy:type_name -> google.iam.v1.Policy
	21, // 9: google.cloud.asset.v1.Asset.org_policy:type_name -> google.cloud.orgpolicy.v1.Policy
	22, // 10: google.cloud.asset.v1.Asset.access_policy:type_name -> google.identity.accesscontextmanager.v1.AccessPolicy
	23, // 11: google.cloud.asset.v1.Asset.access_level:type_name -> google.identity.accesscontextmanager.v1.AccessLevel
	24, // 12: google.cloud.asset.v1.Asset.service_perimeter:type_name -> google.identity.accesscontextmanager.v1.ServicePerimeter
	25, // 13: google.cloud.asset.v1.Resource.data:type_name -> google.protobuf.Struct
	9,  // 14: google.cloud.asset.v1.ResourceSearchResult.labels:type_name -> google.cloud.asset.v1.ResourceSearchResult.LabelsEntry
	25, // 15: google.cloud.asset.v1.ResourceSearchResult.additional_attributes:type_name -> google.protobuf.Struct
	20, // 16: google.cloud.asset.v1.IamPolicySearchResult.policy:type_name -> google.iam.v1.Policy
	10, // 17: google.cloud.asset.v1.IamPolicySearchResult.explanation:type_name -> google.cloud.asset.v1.IamPolicySearchResult.Explanation
	26, // 18: google.cloud.asset.v1.IamPolicyAnalysisState.code:type_name -> google.rpc.Code
	27, // 19: google.cloud.asset.v1.IamPolicyAnalysisResult.iam_binding:type_name -> google.iam.v1.Binding
	17, // 20: google.cloud.asset.v1.IamPolicyAnalysisResult.access_control_lists:type_name -> google.cloud.asset.v1.IamPolicyAnalysisResult.AccessControlList
	18, // 21: google.cloud.asset.v1.IamPolicyAnalysisResult.identity_list:type_name -> google.cloud.asset.v1.IamPolicyAnalysisResult.IdentityList
	12, // 22: google.cloud.asset.v1.IamPolicySearchResult.Explanation.matched_permissions:type_name -> google.cloud.asset.v1.IamPolicySearchResult.Explanation.MatchedPermissionsEntry
	11, // 23: google.cloud.asset.v1.IamPolicySearchResult.Explanation.MatchedPermissionsEntry.value:type_name -> google.cloud.asset.v1.IamPolicySearchResult.Explanation.Permissions
	7,  // 24: google.cloud.asset.v1.IamPolicyAnalysisResult.Resource.analysis_state:type_name -> google.cloud.asset.v1.IamPolicyAnalysisState
	7,  // 25: google.cloud.asset.v1.IamPolicyAnalysisResult.Access.analysis_state:type_name -> google.cloud.asset.v1.IamPolicyAnalysisState
	7,  // 26: google.cloud.asset.v1.IamPolicyAnalysisResult.Identity.analysis_state:type_name -> google.cloud.asset.v1.IamPolicyAnalysisState
	13, // 27: google.cloud.asset.v1.IamPolicyAnalysisResult.AccessControlList.resources:type_name -> google.cloud.asset.v1.IamPolicyAnalysisResult.Resource
	14, // 28: google.cloud.asset.v1.IamPolicyAnalysisResult.AccessControlList.accesses:type_name -> google.cloud.asset.v1.IamPolicyAnalysisResult.Access
	16, // 29: google.cloud.asset.v1.IamPolicyAnalysisResult.AccessControlList.resource_edges:type_name -> google.cloud.asset.v1.IamPolicyAnalysisResult.Edge
	15, // 30: google.cloud.asset.v1.IamPolicyAnalysisResult.IdentityList.identities:type_name -> google.cloud.asset.v1.IamPolicyAnalysisResult.Identity
	16, // 31: google.cloud.asset.v1.IamPolicyAnalysisResult.IdentityList.group_edges:type_name -> google.cloud.asset.v1.IamPolicyAnalysisResult.Edge
	32, // [32:32] is the sub-list for method output_type
	32, // [32:32] is the sub-list for method input_type
	32, // [32:32] is the sub-list for extension type_name
	32, // [32:32] is the sub-list for extension extendee
	0,  // [0:32] is the sub-list for field type_name
}

func init() { file_google_cloud_asset_v1_assets_proto_init() }
func file_google_cloud_asset_v1_assets_proto_init() {
	if File_google_cloud_asset_v1_assets_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_asset_v1_assets_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TemporalAsset); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_assets_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TimeWindow); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_assets_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Asset); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_assets_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Resource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_assets_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResourceSearchResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_assets_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IamPolicySearchResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_assets_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IamPolicyAnalysisState); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_assets_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IamPolicyAnalysisResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_assets_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IamPolicySearchResult_Explanation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_assets_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IamPolicySearchResult_Explanation_Permissions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_assets_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IamPolicyAnalysisResult_Resource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_assets_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IamPolicyAnalysisResult_Access); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_assets_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IamPolicyAnalysisResult_Identity); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_assets_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IamPolicyAnalysisResult_Edge); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_assets_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IamPolicyAnalysisResult_AccessControlList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_assets_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IamPolicyAnalysisResult_IdentityList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_asset_v1_assets_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*Asset_AccessPolicy)(nil),
		(*Asset_AccessLevel)(nil),
		(*Asset_ServicePerimeter)(nil),
	}
	file_google_cloud_asset_v1_assets_proto_msgTypes[13].OneofWrappers = []interface{}{
		(*IamPolicyAnalysisResult_Access_Role)(nil),
		(*IamPolicyAnalysisResult_Access_Permission)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_asset_v1_assets_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   18,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_asset_v1_assets_proto_goTypes,
		DependencyIndexes: file_google_cloud_asset_v1_assets_proto_depIdxs,
		EnumInfos:         file_google_cloud_asset_v1_assets_proto_enumTypes,
		MessageInfos:      file_google_cloud_asset_v1_assets_proto_msgTypes,
	}.Build()
	File_google_cloud_asset_v1_assets_proto = out.File
	file_google_cloud_asset_v1_assets_proto_rawDesc = nil
	file_google_cloud_asset_v1_assets_proto_goTypes = nil
	file_google_cloud_asset_v1_assets_proto_depIdxs = nil
}
