// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lambda

import (
	"fmt"
	"io"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opAddLayerVersionPermission = "AddLayerVersionPermission"

// AddLayerVersionPermissionRequest generates a "aws/request.Request" representing the
// client's request for the AddLayerVersionPermission operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddLayerVersionPermission for more information on using the AddLayerVersionPermission
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AddLayerVersionPermissionRequest method.
//    req, resp := client.AddLayerVersionPermissionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/AddLayerVersionPermission
func (c *Lambda) AddLayerVersionPermissionRequest(input *AddLayerVersionPermissionInput) (req *request.Request, output *AddLayerVersionPermissionOutput) {
	op := &request.Operation{
		Name:       opAddLayerVersionPermission,
		HTTPMethod: "POST",
		HTTPPath:   "/2018-10-31/layers/{LayerName}/versions/{VersionNumber}/policy",
	}

	if input == nil {
		input = &AddLayerVersionPermissionInput{}
	}

	output = &AddLayerVersionPermissionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AddLayerVersionPermission API operation for AWS Lambda.
//
// Adds permissions to the resource-based policy of a version of an AWS Lambda
// layer (https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html).
// Use this action to grant layer usage permission to other accounts. You can
// grant permission to a single account, all AWS accounts, or all accounts in
// an organization.
//
// To revoke permission, call RemoveLayerVersionPermission with the statement
// ID that you specified when you added it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation AddLayerVersionPermission for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   The AWS Lambda service encountered an internal error.
//
//   * ResourceNotFoundException
//   The resource specified in the request does not exist.
//
//   * ResourceConflictException
//   The resource already exists, or another operation is in progress.
//
//   * TooManyRequestsException
//   The request throughput limit was exceeded.
//
//   * InvalidParameterValueException
//   One of the parameters in the request is invalid.
//
//   * PolicyLengthExceededException
//   The permissions policy for the resource is too large. Learn more (https://docs.aws.amazon.com/lambda/latest/dg/limits.html)
//
//   * PreconditionFailedException
//   The RevisionId provided does not match the latest RevisionId for the Lambda
//   function or alias. Call the GetFunction or the GetAlias API to retrieve the
//   latest RevisionId for your resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/AddLayerVersionPermission
func (c *Lambda) AddLayerVersionPermission(input *AddLayerVersionPermissionInput) (*AddLayerVersionPermissionOutput, error) {
	req, out := c.AddLayerVersionPermissionRequest(input)
	return out, req.Send()
}

// AddLayerVersionPermissionWithContext is the same as AddLayerVersionPermission with the addition of
// the ability to pass a context and additional request options.
//
// See AddLayerVersionPermission for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) AddLayerVersionPermissionWithContext(ctx aws.Context, input *AddLayerVersionPermissionInput, opts ...request.Option) (*AddLayerVersionPermissionOutput, error) {
	req, out := c.AddLayerVersionPermissionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAddPermission = "AddPermission"

// AddPermissionRequest generates a "aws/request.Request" representing the
// client's request for the AddPermission operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddPermission for more information on using the AddPermission
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AddPermissionRequest method.
//    req, resp := client.AddPermissionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/AddPermission
func (c *Lambda) AddPermissionRequest(input *AddPermissionInput) (req *request.Request, output *AddPermissionOutput) {
	op := &request.Operation{
		Name:       opAddPermission,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}/policy",
	}

	if input == nil {
		input = &AddPermissionInput{}
	}

	output = &AddPermissionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AddPermission API operation for AWS Lambda.
//
// Grants an AWS service or another account permission to use a function. You
// can apply the policy at the function level, or specify a qualifier to restrict
// access to a single version or alias. If you use a qualifier, the invoker
// must use the full Amazon Resource Name (ARN) of that version or alias to
// invoke the function.
//
// To grant permission to another account, specify the account ID as the Principal.
// For AWS services, the principal is a domain-style identifier defined by the
// service, like s3.amazonaws.com or sns.amazonaws.com. For AWS services, you
// can also specify the ARN of the associated resource as the SourceArn. If
// you grant permission to a service principal without specifying the source,
// other accounts could potentially configure resources in their account to
// invoke your Lambda function.
//
// This action adds a statement to a resource-based permissions policy for the
// function. For more information about function policies, see Lambda Function
// Policies (https://docs.aws.amazon.com/lambda/latest/dg/access-control-resource-based.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation AddPermission for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   The AWS Lambda service encountered an internal error.
//
//   * ResourceNotFoundException
//   The resource specified in the request does not exist.
//
//   * ResourceConflictException
//   The resource already exists, or another operation is in progress.
//
//   * InvalidParameterValueException
//   One of the parameters in the request is invalid.
//
//   * PolicyLengthExceededException
//   The permissions policy for the resource is too large. Learn more (https://docs.aws.amazon.com/lambda/latest/dg/limits.html)
//
//   * TooManyRequestsException
//   The request throughput limit was exceeded.
//
//   * PreconditionFailedException
//   The RevisionId provided does not match the latest RevisionId for the Lambda
//   function or alias. Call the GetFunction or the GetAlias API to retrieve the
//   latest RevisionId for your resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/AddPermission
func (c *Lambda) AddPermission(input *AddPermissionInput) (*AddPermissionOutput, error) {
	req, out := c.AddPermissionRequest(input)
	return out, req.Send()
}

// AddPermissionWithContext is the same as AddPermission with the addition of
// the ability to pass a context and additional request options.
//
// See AddPermission for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) AddPermissionWithContext(ctx aws.Context, input *AddPermissionInput, opts ...request.Option) (*AddPermissionOutput, error) {
	req, out := c.AddPermissionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAlias = "CreateAlias"

// CreateAliasRequest generates a "aws/request.Request" representing the
// client's request for the CreateAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAlias for more information on using the CreateAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateAliasRequest method.
//    req, resp := client.CreateAliasRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/CreateAlias
func (c *Lambda) CreateAliasRequest(input *CreateAliasInput) (req *request.Request, output *AliasConfiguration) {
	op := &request.Operation{
		Name:       opCreateAlias,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}/aliases",
	}

	if input == nil {
		input = &CreateAliasInput{}
	}

	output = &AliasConfiguration{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAlias API operation for AWS Lambda.
//
// Creates an alias (https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html)
// for a Lambda function version. Use aliases to provide clients with a function
// identifier that you can update to invoke a different version.
//
// You can also map an alias to split invocation requests between two versions.
// Use the RoutingConfig parameter to specify a second version and the percentage
// of invocation requests that it receives.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation CreateAlias for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   The AWS Lambda service encountered an internal error.
//
//   * ResourceNotFoundException
//   The resource specified in the request does not exist.
//
//   * ResourceConflictException
//   The resource already exists, or another operation is in progress.
//
//   * InvalidParameterValueException
//   One of the parameters in the request is invalid.
//
//   * TooManyRequestsException
//   The request throughput limit was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/CreateAlias
func (c *Lambda) CreateAlias(input *CreateAliasInput) (*AliasConfiguration, error) {
	req, out := c.CreateAliasRequest(input)
	return out, req.Send()
}

// CreateAliasWithContext is the same as CreateAlias with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) CreateAliasWithContext(ctx aws.Context, input *CreateAliasInput, opts ...request.Option) (*AliasConfiguration, error) {
	req, out := c.CreateAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateEventSourceMapping = "CreateEventSourceMapping"

// CreateEventSourceMappingRequest generates a "aws/request.Request" representing the
// client's request for the CreateEventSourceMapping operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateEventSourceMapping for more information on using the CreateEventSourceMapping
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateEventSourceMappingRequest method.
//    req, resp := client.CreateEventSourceMappingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/CreateEventSourceMapping
func (c *Lambda) CreateEventSourceMappingRequest(input *CreateEventSourceMappingInput) (req *request.Request, output *EventSourceMappingConfiguration) {
	op := &request.Operation{
		Name:       opCreateEventSourceMapping,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-03-31/event-source-mappings/",
	}

	if input == nil {
		input = &CreateEventSourceMappingInput{}
	}

	output = &EventSourceMappingConfiguration{}
	req = c.newRequest(op, input, output)
	return
}

// CreateEventSourceMapping API operation for AWS Lambda.
//
// Creates a mapping between an event source and an AWS Lambda function. Lambda
// reads items from the event source and triggers the function.
//
// For details about each event source type, see the following topics.
//
//    * Using AWS Lambda with Amazon DynamoDB (https://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html)
//
//    * Using AWS Lambda with Amazon Kinesis (https://docs.aws.amazon.com/lambda/latest/dg/with-kinesis.html)
//
//    * Using AWS Lambda with Amazon SQS (https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html)
//
// The following error handling options are only available for stream sources
// (DynamoDB and Kinesis):
//
//    * BisectBatchOnFunctionError - If the function returns an error, split
//    the batch in two and retry.
//
//    * DestinationConfig - Send discarded records to an Amazon SQS queue or
//    Amazon SNS topic.
//
//    * MaximumRecordAgeInSeconds - Discard records older than the specified
//    age.
//
//    * MaximumRetryAttempts - Discard records after the specified number of
//    retries.
//
//    * ParallelizationFactor - Process multiple batches from each shard concurrently.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation CreateEventSourceMapping for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   The AWS Lambda service encountered an internal error.
//
//   * InvalidParameterValueException
//   One of the parameters in the request is invalid.
//
//   * ResourceConflictException
//   The resource already exists, or another operation is in progress.
//
//   * TooManyRequestsException
//   The request throughput limit was exceeded.
//
//   * ResourceNotFoundException
//   The resource specified in the request does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/CreateEventSourceMapping
func (c *Lambda) CreateEventSourceMapping(input *CreateEventSourceMappingInput) (*EventSourceMappingConfiguration, error) {
	req, out := c.CreateEventSourceMappingRequest(input)
	return out, req.Send()
}

// CreateEventSourceMappingWithContext is the same as CreateEventSourceMapping with the addition of
// the ability to pass a context and additional request options.
//
// See CreateEventSourceMapping for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) CreateEventSourceMappingWithContext(ctx aws.Context, input *CreateEventSourceMappingInput, opts ...request.Option) (*EventSourceMappingConfiguration, error) {
	req, out := c.CreateEventSourceMappingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateFunction = "CreateFunction"

// CreateFunctionRequest generates a "aws/request.Request" representing the
// client's request for the CreateFunction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateFunction for more information on using the CreateFunction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateFunctionRequest method.
//    req, resp := client.CreateFunctionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/CreateFunction
func (c *Lambda) CreateFunctionRequest(input *CreateFunctionInput) (req *request.Request, output *FunctionConfiguration) {
	op := &request.Operation{
		Name:       opCreateFunction,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-03-31/functions",
	}

	if input == nil {
		input = &CreateFunctionInput{}
	}

	output = &FunctionConfiguration{}
	req = c.newRequest(op, input, output)
	return
}

// CreateFunction API operation for AWS Lambda.
//
// Creates a Lambda function. To create a function, you need a deployment package
// (https://docs.aws.amazon.com/lambda/latest/dg/deployment-package-v2.html)
// and an execution role (https://docs.aws.amazon.com/lambda/latest/dg/intro-permission-model.html#lambda-intro-execution-role).
// The deployment package contains your function code. The execution role grants
// the function permission to use AWS services, such as Amazon CloudWatch Logs
// for log streaming and AWS X-Ray for request tracing.
//
// When you create a function, Lambda provisions an instance of the function
// and its supporting resources. If your function connects to a VPC, this process
// can take a minute or so. During this time, you can't invoke or modify the
// function. The State, StateReason, and StateReasonCode fields in the response
// from GetFunctionConfiguration indicate when the function is ready to invoke.
// For more information, see Function States (https://docs.aws.amazon.com/lambda/latest/dg/functions-states.html).
//
// A function has an unpublished version, and can have published versions and
// aliases. The unpublished version changes when you update your function's
// code and configuration. A published version is a snapshot of your function
// code and configuration that can't be changed. An alias is a named resource
// that maps to a version, and can be changed to map to a different version.
// Use the Publish parameter to create version 1 of your function from its initial
// configuration.
//
// The other parameters let you configure version-specific and function-level
// settings. You can modify version-specific settings later with UpdateFunctionConfiguration.
// Function-level settings apply to both the unpublished and published versions
// of the function, and include tags (TagResource) and per-function concurrency
// limits (PutFunctionConcurrency).
//
// If another account or an AWS service invokes your function, use AddPermission
// to grant permission by creating a resource-based IAM policy. You can grant
// permissions at the function level, on a version, or on an alias.
//
// To invoke your function directly, use Invoke. To invoke your function in
// response to events in other AWS services, create an event source mapping
// (CreateEventSourceMapping), or configure a function trigger in the other
// service. For more information, see Invoking Functions (https://docs.aws.amazon.com/lambda/latest/dg/lambda-invocation.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation CreateFunction for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   The AWS Lambda service encountered an internal error.
//
//   * InvalidParameterValueException
//   One of the parameters in the request is invalid.
//
//   * ResourceNotFoundException
//   The resource specified in the request does not exist.
//
//   * ResourceConflictException
//   The resource already exists, or another operation is in progress.
//
//   * TooManyRequestsException
//   The request throughput limit was exceeded.
//
//   * CodeStorageExceededException
//   You have exceeded your maximum total code size per account. Learn more (https://docs.aws.amazon.com/lambda/latest/dg/limits.html)
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/CreateFunction
func (c *Lambda) CreateFunction(input *CreateFunctionInput) (*FunctionConfiguration, error) {
	req, out := c.CreateFunctionRequest(input)
	return out, req.Send()
}

// CreateFunctionWithContext is the same as CreateFunction with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFunction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) CreateFunctionWithContext(ctx aws.Context, input *CreateFunctionInput, opts ...request.Option) (*FunctionConfiguration, error) {
	req, out := c.CreateFunctionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAlias = "DeleteAlias"

// DeleteAliasRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAlias for more information on using the DeleteAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAliasRequest method.
//    req, resp := client.DeleteAliasRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteAlias
func (c *Lambda) DeleteAliasRequest(input *DeleteAliasInput) (req *request.Request, output *DeleteAliasOutput) {
	op := &request.Operation{
		Name:       opDeleteAlias,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}/aliases/{Name}",
	}

	if input == nil {
		input = &DeleteAliasInput{}
	}

	output = &DeleteAliasOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAlias API operation for AWS Lambda.
//
// Deletes a Lambda function alias (https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation DeleteAlias for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   The AWS Lambda service encountered an internal error.
//
//   * InvalidParameterValueException
//   One of the parameters in the request is invalid.
//
//   * ResourceConflictException
//   The resource already exists, or another operation is in progress.
//
//   * TooManyRequestsException
//   The request throughput limit was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteAlias
func (c *Lambda) DeleteAlias(input *DeleteAliasInput) (*DeleteAliasOutput, error) {
	req, out := c.DeleteAliasRequest(input)
	return out, req.Send()
}

// DeleteAliasWithContext is the same as DeleteAlias with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) DeleteAliasWithContext(ctx aws.Context, input *DeleteAliasInput, opts ...request.Option) (*DeleteAliasOutput, error) {
	req, out := c.DeleteAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEventSourceMapping = "DeleteEventSourceMapping"

// DeleteEventSourceMappingRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEventSourceMapping operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEventSourceMapping for more information on using the DeleteEventSourceMapping
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteEventSourceMappingRequest method.
//    req, resp := client.DeleteEventSourceMappingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteEventSourceMapping
func (c *Lambda) DeleteEventSourceMappingRequest(input *DeleteEventSourceMappingInput) (req *request.Request, output *EventSourceMappingConfiguration) {
	op := &request.Operation{
		Name:       opDeleteEventSourceMapping,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2015-03-31/event-source-mappings/{UUID}",
	}

	if input == nil {
		input = &DeleteEventSourceMappingInput{}
	}

	output = &EventSourceMappingConfiguration{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteEventSourceMapping API operation for AWS Lambda.
//
// Deletes an event source mapping (https://docs.aws.amazon.com/lambda/latest/dg/intro-invocation-modes.html).
// You can get the identifier of a mapping from the output of ListEventSourceMappings.
//
// When you delete an event source mapping, it enters a Deleting state and might
// not be completely deleted for several seconds.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation DeleteEventSourceMapping for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   The AWS Lambda service encountered an internal error.
//
//   * ResourceNotFoundException
//   The resource specified in the request does not exist.
//
//   * InvalidParameterValueException
//   One of the parameters in the request is invalid.
//
//   * TooManyRequestsException
//   The request throughput limit was exceeded.
//
//   * ResourceInUseException
//   The operation conflicts with the resource's availability. For example, you
//   attempted to update an EventSource Mapping in CREATING, or tried to delete
//   a EventSource mapping currently in the UPDATING state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteEventSourceMapping
func (c *Lambda) DeleteEventSourceMapping(input *DeleteEventSourceMappingInput) (*EventSourceMappingConfiguration, error) {
	req, out := c.DeleteEventSourceMappingRequest(input)
	return out, req.Send()
}

// DeleteEventSourceMappingWithContext is the same as DeleteEventSourceMapping with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEventSourceMapping for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) DeleteEventSourceMappingWithContext(ctx aws.Context, input *DeleteEventSourceMappingInput, opts ...request.Option) (*EventSourceMappingConfiguration, error) {
	req, out := c.DeleteEventSourceMappingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFunction = "DeleteFunction"

// DeleteFunctionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFunction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFunction for more information on using the DeleteFunction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteFunctionRequest method.
//    req, resp := client.DeleteFunctionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteFunction
func (c *Lambda) DeleteFunctionRequest(input *DeleteFunctionInput) (req *request.Request, output *DeleteFunctionOutput) {
	op := &request.Operation{
		Name:       opDeleteFunction,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}",
	}

	if input == nil {
		input = &DeleteFunctionInput{}
	}

	output = &DeleteFunctionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteFunction API operation for AWS Lambda.
//
// Deletes a Lambda function. To delete a specific function version, use the
// Qualifier parameter. Otherwise, all versions and aliases are deleted.
//
// To delete Lambda event source mappings that invoke a function, use DeleteEventSourceMapping.
// For AWS services and resources that invoke your function directly, delete
// the trigger in the service where you originally configured it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation DeleteFunction for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   The AWS Lambda service encountered an internal error.
//
//   * ResourceNotFoundException
//   The resource specified in the request does not exist.
//
//   * TooManyRequestsException
//   The request throughput limit was exceeded.
//
//   * InvalidParameterValueException
//   One of the parameters in the request is invalid.
//
//   * ResourceConflictException
//   The resource already exists, or another operation is in progress.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteFunction
func (c *Lambda) DeleteFunction(input *DeleteFunctionInput) (*DeleteFunctionOutput, error) {
	req, out := c.DeleteFunctionRequest(input)
	return out, req.Send()
}

// DeleteFunctionWithContext is the same as DeleteFunction with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFunction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) DeleteFunctionWithContext(ctx aws.Context, input *DeleteFunctionInput, opts ...request.Option) (*DeleteFunctionOutput, error) {
	req, out := c.DeleteFunctionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFunctionConcurrency = "DeleteFunctionConcurrency"

// DeleteFunctionConcurrencyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFunctionConcurrency operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFunctionConcurrency for more information on using the DeleteFunctionConcurrency
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteFunctionConcurrencyRequest method.
//    req, resp := client.DeleteFunctionConcurrencyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteFunctionConcurrency
func (c *Lambda) DeleteFunctionConcurrencyRequest(input *DeleteFunctionConcurrencyInput) (req *request.Request, output *DeleteFunctionConcurrencyOutput) {
	op := &request.Operation{
		Name:       opDeleteFunctionConcurrency,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2017-10-31/functions/{FunctionName}/concurrency",
	}

	if input == nil {
		input = &DeleteFunctionConcurrencyInput{}
	}

	output = &DeleteFunctionConcurrencyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteFunctionConcurrency API operation for AWS Lambda.
//
// Removes a concurrent execution limit from a function.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation DeleteFunctionConcurrency for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   The AWS Lambda service encountered an internal error.
//
//   * ResourceNotFoundException
//   The resource specified in the request does not exist.
//
//   * TooManyRequestsException
//   The request throughput limit was exceeded.
//
//   * InvalidParameterValueException
//   One of the parameters in the request is invalid.
//
//   * ResourceConflictException
//   The resource already exists, or another operation is in progress.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteFunctionConcurrency
func (c *Lambda) DeleteFunctionConcurrency(input *DeleteFunctionConcurrencyInput) (*DeleteFunctionConcurrencyOutput, error) {
	req, out := c.DeleteFunctionConcurrencyRequest(input)
	return out, req.Send()
}

// DeleteFunctionConcurrencyWithContext is the same as DeleteFunctionConcurrency with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFunctionConcurrency for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) DeleteFunctionConcurrencyWithContext(ctx aws.Context, input *DeleteFunctionConcurrencyInput, opts ...request.Option) (*DeleteFunctionConcurrencyOutput, error) {
	req, out := c.DeleteFunctionConcurrencyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFunctionEventInvokeConfig = "DeleteFunctionEventInvokeConfig"

// DeleteFunctionEventInvokeConfigRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFunctionEventInvokeConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFunctionEventInvokeConfig for more information on using the DeleteFunctionEventInvokeConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteFunctionEventInvokeConfigRequest method.
//    req, resp := client.DeleteFunctionEventInvokeConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteFunctionEventInvokeConfig
func (c *Lambda) DeleteFunctionEventInvokeConfigRequest(input *DeleteFunctionEventInvokeConfigInput) (req *request.Request, output *DeleteFunctionEventInvokeConfigOutput) {
	op := &request.Operation{
		Name:       opDeleteFunctionEventInvokeConfig,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2019-09-25/functions/{FunctionName}/event-invoke-config",
	}

	if input == nil {
		input = &DeleteFunctionEventInvokeConfigInput{}
	}

	output = &DeleteFunctionEventInvokeConfigOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteFunctionEventInvokeConfig API operation for AWS Lambda.
//
// Deletes the configuration for asynchronous invocation for a function, version,
// or alias.
//
// To configure options for asynchronous invocation, use PutFunctionEventInvokeConfig.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation DeleteFunctionEventInvokeConfig for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   The AWS Lambda service encountered an internal error.
//
//   * ResourceNotFoundException
//   The resource specified in the request does not exist.
//
//   * InvalidParameterValueException
//   One of the parameters in the request is invalid.
//
//   * TooManyRequestsException
//   The request throughput limit was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteFunctionEventInvokeConfig
func (c *Lambda) DeleteFunctionEventInvokeConfig(input *DeleteFunctionEventInvokeConfigInput) (*DeleteFunctionEventInvokeConfigOutput, error) {
	req, out := c.DeleteFunctionEventInvokeConfigRequest(input)
	return out, req.Send()
}

// DeleteFunctionEventInvokeConfigWithContext is the same as DeleteFunctionEventInvokeConfig with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFunctionEventInvokeConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) DeleteFunctionEventInvokeConfigWithContext(ctx aws.Context, input *DeleteFunctionEventInvokeConfigInput, opts ...request.Option) (*DeleteFunctionEventInvokeConfigOutput, error) {
	req, out := c.DeleteFunctionEventInvokeConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteLayerVersion = "DeleteLayerVersion"

// DeleteLayerVersionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteLayerVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteLayerVersion for more information on using the DeleteLayerVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteLayerVersionRequest method.
//    req, resp := client.DeleteLayerVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteLayerVersion
func (c *Lambda) DeleteLayerVersionRequest(input *DeleteLayerVersionInput) (req *request.Request, output *DeleteLayerVersionOutput) {
	op := &request.Operation{
		Name:       opDeleteLayerVersion,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2018-10-31/layers/{LayerName}/versions/{VersionNumber}",
	}

	if input == nil {
		input = &DeleteLayerVersionInput{}
	}

	output = &DeleteLayerVersionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteLayerVersion API operation for AWS Lambda.
//
// Deletes a version of an AWS Lambda layer (https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html).
// Deleted versions can no longer be viewed or added to functions. To avoid
// breaking functions, a copy of the version remains in Lambda until no functions
// refer to it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation DeleteLayerVersion for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   The AWS Lambda service encountered an internal error.
//
//   * TooManyRequestsException
//   The request throughput limit was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteLayerVersion
func (c *Lambda) DeleteLayerVersion(input *DeleteLayerVersionInput) (*DeleteLayerVersionOutput, error) {
	req, out := c.DeleteLayerVersionRequest(input)
	return out, req.Send()
}

// DeleteLayerVersionWithContext is the same as DeleteLayerVersion with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteLayerVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) DeleteLayerVersionWithContext(ctx aws.Context, input *DeleteLayerVersionInput, opts ...request.Option) (*DeleteLayerVersionOutput, error) {
	req, out := c.DeleteLayerVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteProvisionedConcurrencyConfig = "DeleteProvisionedConcurrencyConfig"

// DeleteProvisionedConcurrencyConfigRequest generates a "aws/request.Request" representing the
// client's request for the DeleteProvisionedConcurrencyConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteProvisionedConcurrencyConfig for more information on using the DeleteProvisionedConcurrencyConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteProvisionedConcurrencyConfigRequest method.
//    req, resp := client.DeleteProvisionedConcurrencyConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteProvisionedConcurrencyConfig
func (c *Lambda) DeleteProvisionedConcurrencyConfigRequest(input *DeleteProvisionedConcurrencyConfigInput) (req *request.Request, output *DeleteProvisionedConcurrencyConfigOutput) {
	op := &request.Operation{
		Name:       opDeleteProvisionedConcurrencyConfig,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2019-09-30/functions/{FunctionName}/provisioned-concurrency",
	}

	if input == nil {
		input = &DeleteProvisionedConcurrencyConfigInput{}
	}

	output = &DeleteProvisionedConcurrencyConfigOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteProvisionedConcurrencyConfig API operation for AWS Lambda.
//
// Deletes the provisioned concurrency configuration for a function.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation DeleteProvisionedConcurrencyConfig for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   One of the parameters in the request is invalid.
//
//   * ResourceConflictException
//   The resource already exists, or another operation is in progress.
//
//   * ResourceNotFoundException
//   The resource specified in the request does not exist.
//
//   * TooManyRequestsException
//   The request throughput limit was exceeded.
//
//   * ServiceException
//   The AWS Lambda service encountered an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteProvisionedConcurrencyConfig
func (c *Lambda) DeleteProvisionedConcurrencyConfig(input *DeleteProvisionedConcurrencyConfigInput) (*DeleteProvisionedConcurrencyConfigOutput, error) {
	req, out := c.DeleteProvisionedConcurrencyConfigRequest(input)
	return out, req.Send()
}

// DeleteProvisionedConcurrencyConfigWithContext is the same as DeleteProvisionedConcurrencyConfig with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteProvisionedConcurrencyConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) DeleteProvisionedConcurrencyConfigWithContext(ctx aws.Context, input *DeleteProvisionedConcurrencyConfigInput, opts ...request.Option) (*DeleteProvisionedConcurrencyConfigOutput, error) {
	req, out := c.DeleteProvisionedConcurrencyConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAccountSettings = "GetAccountSettings"

// GetAccountSettingsRequest generates a "aws/request.Request" representing the
// client's request for the GetAccountSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAccountSettings for more information on using the GetAccountSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAccountSettingsRequest method.
//    req, resp := client.GetAccountSettingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetAccountSettings
func (c *Lambda) GetAccountSettingsRequest(input *GetAccountSettingsInput) (req *request.Request, output *GetAccountSettingsOutput) {
	op := &request.Operation{
		Name:       opGetAccountSettings,
		HTTPMethod: "GET",
		HTTPPath:   "/2016-08-19/account-settings/",
	}

	if input == nil {
		input = &GetAccountSettingsInput{}
	}

	output = &GetAccountSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAccountSettings API operation for AWS Lambda.
//
// Retrieves details about your account's limits (https://docs.aws.amazon.com/lambda/latest/dg/limits.html)
// and usage in an AWS Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation GetAccountSettings for usage and error information.
//
// Returned Error Types:
//   * TooManyRequestsException
//   The request throughput limit was exceeded.
//
//   * ServiceException
//   The AWS Lambda service encountered an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetAccountSettings
func (c *Lambda) GetAccountSettings(input *GetAccountSettingsInput) (*GetAccountSettingsOutput, error) {
	req, out := c.GetAccountSettingsRequest(input)
	return out, req.Send()
}

// GetAccountSettingsWithContext is the same as GetAccountSettings with the addition of
// the ability to pass a context and additional request options.
//
// See GetAccountSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) GetAccountSettingsWithContext(ctx aws.Context, input *GetAccountSettingsInput, opts ...request.Option) (*GetAccountSettingsOutput, error) {
	req, out := c.GetAccountSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAlias = "GetAlias"

// GetAliasRequest generates a "aws/request.Request" representing the
// client's request for the GetAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAlias for more information on using the GetAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAliasRequest method.
//    req, resp := client.GetAliasRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetAlias
func (c *Lambda) GetAliasRequest(input *GetAliasInput) (req *request.Request, output *AliasConfiguration) {
	op := &request.Operation{
		Name:       opGetAlias,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}/aliases/{Name}",
	}

	if input == nil {
		input = &GetAliasInput{}
	}

	output = &AliasConfiguration{}
	req = c.newRequest(op, input, output)
	return
}

// GetAlias API operation for AWS Lambda.
//
// Returns details about a Lambda function alias (https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation GetAlias for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   The AWS Lambda service encountered an internal error.
//
//   * ResourceNotFoundException
//   The resource specified in the request does not exist.
//
//   * InvalidParameterValueException
//   One of the parameters in the request is invalid.
//
//   * TooManyRequestsException
//   The request throughput limit was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetAlias
func (c *Lambda) GetAlias(input *GetAliasInput) (*AliasConfiguration, error) {
	req, out := c.GetAliasRequest(input)
	return out, req.Send()
}

// GetAliasWithContext is the same as GetAlias with the addition of
// the ability to pass a context and additional request options.
//
// See GetAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) GetAliasWithContext(ctx aws.Context, input *GetAliasInput, opts ...request.Option) (*AliasConfiguration, error) {
	req, out := c.GetAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetEventSourceMapping = "GetEventSourceMapping"

// GetEventSourceMappingRequest generates a "aws/request.Request" representing the
// client's request for the GetEventSourceMapping operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEventSourceMapping for more information on using the GetEventSourceMapping
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetEventSourceMappingRequest method.
//    req, resp := client.GetEventSourceMappingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetEventSourceMapping
func (c *Lambda) GetEventSourceMappingRequest(input *GetEventSourceMappingInput) (req *request.Request, output *EventSourceMappingConfiguration) {
	op := &request.Operation{
		Name:       opGetEventSourceMapping,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-03-31/event-source-mappings/{UUID}",
	}

	if input == nil {
		input = &GetEventSourceMappingInput{}
	}

	output = &EventSourceMappingConfiguration{}
	req = c.newRequest(op, input, output)
	return
}

// GetEventSourceMapping API operation for AWS Lambda.
//
// Returns details about an event source mapping. You can get the identifier
// of a mapping from the output of ListEventSourceMappings.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation GetEventSourceMapping for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   The AWS Lambda service encountered an internal error.
//
//   * ResourceNotFoundException
//   The resource specified in the request does not exist.
//
//   * InvalidParameterValueException
//   One of the parameters in the request is invalid.
//
//   * TooManyRequestsException
//   The request throughput limit was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetEventSourceMapping
func (c *Lambda) GetEventSourceMapping(input *GetEventSourceMappingInput) (*EventSourceMappingConfiguration, error) {
	req, out := c.GetEventSourceMappingRequest(input)
	return out, req.Send()
}

// GetEventSourceMappingWithContext is the same as GetEventSourceMapping with the addition of
// the ability to pass a context and additional request options.
//
// See GetEventSourceMapping for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) GetEventSourceMappingWithContext(ctx aws.Context, input *GetEventSourceMappingInput, opts ...request.Option) (*EventSourceMappingConfiguration, error) {
	req, out := c.GetEventSourceMappingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetFunction = "GetFunction"

// GetFunctionRequest generates a "aws/request.Request" representing the
// client's request for the GetFunction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetFunction for more information on using the GetFunction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetFunctionRequest method.
//    req, resp := client.GetFunctionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetFunction
func (c *Lambda) GetFunctionRequest(input *GetFunctionInput) (req *request.Request, output *GetFunctionOutput) {
	op := &request.Operation{
		Name:       opGetFunction,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}",
	}

	if input == nil {
		input = &GetFunctionInput{}
	}

	output = &GetFunctionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetFunction API operation for AWS Lambda.
//
// Returns information about the function or function version, with a link to
// download the deployment package that's valid for 10 minutes. If you specify
// a function version, only details that are specific to that version are returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation GetFunction for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   The AWS Lambda service encountered an internal error.
//
//   * ResourceNotFoundException
//   The resource specified in the request does not exist.
//
//   * TooManyRequestsException
//   The request throughput limit was exceeded.
//
//   * InvalidParameterValueException
//   One of the parameters in the request is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetFunction
func (c *Lambda) GetFunction(input *GetFunctionInput) (*GetFunctionOutput, error) {
	req, out := c.GetFunctionRequest(input)
	return out, req.Send()
}

// GetFunctionWithContext is the same as GetFunction with the addition of
// the ability to pass a context and additional request options.
//
// See GetFunction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) GetFunctionWithContext(ctx aws.Context, input *GetFunctionInput, opts ...request.Option) (*GetFunctionOutput, error) {
	req, out := c.GetFunctionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetFunctionConcurrency = "GetFunctionConcurrency"

// GetFunctionConcurrencyRequest generates a "aws/request.Request" representing the
// client's request for the GetFunctionConcurrency operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetFunctionConcurrency for more information on using the GetFunctionConcurrency
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetFunctionConcurrencyRequest method.
//    req, resp := client.GetFunctionConcurrencyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetFunctionConcurrency
func (c *Lambda) GetFunctionConcurrencyRequest(input *GetFunctionConcurrencyInput) (req *request.Request, output *GetFunctionConcurrencyOutput) {
	op := &request.Operation{
		Name:       opGetFunctionConcurrency,
		HTTPMethod: "GET",
		HTTPPath:   "/2019-09-30/functions/{FunctionName}/concurrency",
	}

	if input == nil {
		input = &GetFunctionConcurrencyInput{}
	}

	output = &GetFunctionConcurrencyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetFunctionConcurrency API operation for AWS Lambda.
//
// Returns details about the reserved concurrency configuration for a function.
// To set a concurrency limit for a function, use PutFunctionConcurrency.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation GetFunctionConcurrency for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   One of the parameters in the request is invalid.
//
//   * ResourceNotFoundException
//   The resource specified in the request does not exist.
//
//   * TooManyRequestsException
//   The request throughput limit was exceeded.
//
//   * ServiceException
//   The AWS Lambda service encountered an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetFunctionConcurrency
func (c *Lambda) GetFunctionConcurrency(input *GetFunctionConcurrencyInput) (*GetFunctionConcurrencyOutput, error) {
	req, out := c.GetFunctionConcurrencyRequest(input)
	return out, req.Send()
}

// GetFunctionConcurrencyWithContext is the same as GetFunctionConcurrency with the addition of
// the ability to pass a context and additional request options.
//
// See GetFunctionConcurrency for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) GetFunctionConcurrencyWithContext(ctx aws.Context, input *GetFunctionConcurrencyInput, opts ...request.Option) (*GetFunctionConcurrencyOutput, error) {
	req, out := c.GetFunctionConcurrencyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetFunctionConfiguration = "GetFunctionConfiguration"

// GetFunctionConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetFunctionConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetFunctionConfiguration for more information on using the GetFunctionConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetFunctionConfigurationRequest method.
//    req, resp := client.GetFunctionConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetFunctionConfiguration
func (c *Lambda) GetFunctionConfigurationRequest(input *GetFunctionConfigurationInput) (req *request.Request, output *FunctionConfiguration) {
	op := &request.Operation{
		Name:       opGetFunctionConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}/configuration",
	}

	if input == nil {
		input = &GetFunctionConfigurationInput{}
	}

	output = &FunctionConfiguration{}
	req = c.newRequest(op, input, output)
	return
}

// GetFunctionConfiguration API operation for AWS Lambda.
//
// Returns the version-specific settings of a Lambda function or version. The
// output includes only options that can vary between versions of a function.
// To modify these settings, use UpdateFunctionConfiguration.
//
// To get all of a function's details, including function-level settings, use
// GetFunction.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation GetFunctionConfiguration for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   The AWS Lambda service encountered an internal error.
//
//   * ResourceNotFoundException
//   The resource specified in the request does not exist.
//
//   * TooManyRequestsException
//   The request throughput limit was exceeded.
//
//   * InvalidParameterValueException
//   One of the parameters in the request is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetFunctionConfiguration
func (c *Lambda) GetFunctionConfiguration(input *GetFunctionConfigurationInput) (*FunctionConfiguration, error) {
	req, out := c.GetFunctionConfigurationRequest(input)
	return out, req.Send()
}

// GetFunctionConfigurationWithContext is the same as GetFunctionConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetFunctionConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) GetFunctionConfigurationWithContext(ctx aws.Context, input *GetFunctionConfigurationInput, opts ...request.Option) (*FunctionConfiguration, error) {
	req, out := c.GetFunctionConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetFunctionEventInvokeConfig = "GetFunctionEventInvokeConfig"

// GetFunctionEventInvokeConfigRequest generates a "aws/request.Request" representing the
// client's request for the GetFunctionEventInvokeConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetFunctionEventInvokeConfig for more information on using the GetFunctionEventInvokeConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetFunctionEventInvokeConfigRequest method.
//    req, resp := client.GetFunctionEventInvokeConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetFunctionEventInvokeConfig
func (c *Lambda) GetFunctionEventInvokeConfigRequest(input *GetFunctionEventInvokeConfigInput) (req *request.Request, output *GetFunctionEventInvokeConfigOutput) {
	op := &request.Operation{
		Name:       opGetFunctionEventInvokeConfig,
		HTTPMethod: "GET",
		HTTPPath:   "/2019-09-25/functions/{FunctionName}/event-invoke-config",
	}

	if input == nil {
		input = &GetFunctionEventInvokeConfigInput{}
	}

	output = &GetFunctionEventInvokeConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetFunctionEventInvokeConfig API operation for AWS Lambda.
//
// Retrieves the configuration for asynchronous invocation for a function, version,
// or alias.
//
// To configure options for asynchronous invocation, use PutFunctionEventInvokeConfig.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation GetFunctionEventInvokeConfig for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   The AWS Lambda service encountered an internal error.
//
//   * ResourceNotFoundException
//   The resource specified in the request does not exist.
//
//   * InvalidParameterValueException
//   One of the parameters in the request is invalid.
//
//   * TooManyRequestsException
//   The request throughput limit was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetFunctionEventInvokeConfig
func (c *Lambda) GetFunctionEventInvokeConfig(input *GetFunctionEventInvokeConfigInput) (*GetFunctionEventInvokeConfigOutput, error) {
	req, out := c.GetFunctionEventInvokeConfigRequest(input)
	return out, req.Send()
}

// GetFunctionEventInvokeConfigWithContext is the same as GetFunctionEventInvokeConfig with the addition of
// the ability to pass a context and additional request options.
//
// See GetFunctionEventInvokeConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) GetFunctionEventInvokeConfigWithContext(ctx aws.Context, input *GetFunctionEventInvokeConfigInput, opts ...request.Option) (*GetFunctionEventInvokeConfigOutput, error) {
	req, out := c.GetFunctionEventInvokeConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetLayerVersion = "GetLayerVersion"

// GetLayerVersionRequest generates a "aws/request.Request" representing the
// client's request for the GetLayerVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetLayerVersion for more information on using the GetLayerVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetLayerVersionRequest method.
//    req, resp := client.GetLayerVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetLayerVersion
func (c *Lambda) GetLayerVersionRequest(input *GetLayerVersionInput) (req *request.Request, output *GetLayerVersionOutput) {
	op := &request.Operation{
		Name:       opGetLayerVersion,
		HTTPMethod: "GET",
		HTTPPath:   "/2018-10-31/layers/{LayerName}/versions/{VersionNumber}",
	}

	if input == nil {
		input = &GetLayerVersionInput{}
	}

	output = &GetLayerVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetLayerVersion API operation for AWS Lambda.
//
// Returns information about a version of an AWS Lambda layer (https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html),
// with a link to download the layer archive that's valid for 10 minutes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation GetLayerVersion for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   The AWS Lambda service encountered an internal error.
//
//   * InvalidParameterValueException
//   One of the parameters in the request is invalid.
//
//   * TooManyRequestsException
//   The request throughput limit was exceeded.
//
//   * ResourceNotFoundException
//   The resource specified in the request does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetLayerVersion
func (c *Lambda) GetLayerVersion(input *GetLayerVersionInput) (*GetLayerVersionOutput, error) {
	req, out := c.GetLayerVersionRequest(input)
	return out, req.Send()
}

// GetLayerVersionWithContext is the same as GetLayerVersion with the addition of
// the ability to pass a context and additional request options.
//
// See GetLayerVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) GetLayerVersionWithContext(ctx aws.Context, input *GetLayerVersionInput, opts ...request.Option) (*GetLayerVersionOutput, error) {
	req, out := c.GetLayerVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetLayerVersionByArn = "GetLayerVersionByArn"

// GetLayerVersionByArnRequest generates a "aws/request.Request" representing the
// client's request for the GetLayerVersionByArn operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetLayerVersionByArn for more information on using the GetLayerVersionByArn
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetLayerVersionByArnRequest method.
//    req, resp := client.GetLayerVersionByArnRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetLayerVersionByArn
func (c *Lambda) GetLayerVersionByArnRequest(input *GetLayerVersionByArnInput) (req *request.Request, output *GetLayerVersionByArnOutput) {
	op := &request.Operation{
		Name:       opGetLayerVersionByArn,
		HTTPMethod: "GET",
		HTTPPath:   "/2018-10-31/layers?find=LayerVersion",
	}

	if input == nil {
		input = &GetLayerVersionByArnInput{}
	}

	output = &GetLayerVersionByArnOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetLayerVersionByArn API operation for AWS Lambda.
//
// Returns information about a version of an AWS Lambda layer (https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html),
// with a link to download the layer archive that's valid for 10 minutes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation GetLayerVersionByArn for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   The AWS Lambda service encountered an internal error.
//
//   * InvalidParameterValueException
//   One of the parameters in the request is invalid.
//
//   * TooManyRequestsException
//   The request throughput limit was exceeded.
//
//   * ResourceNotFoundException
//   The resource specified in the request does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetLayerVersionByArn
func (c *Lambda) GetLayerVersionByArn(input *GetLayerVersionByArnInput) (*GetLayerVersionByArnOutput, error) {
	req, out := c.GetLayerVersionByArnRequest(input)
	return out, req.Send()
}

// GetLayerVersionByArnWithContext is the same as GetLayerVersionByArn with the addition of
// the ability to pass a context and additional request options.
//
// See GetLayerVersionByArn for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) GetLayerVersionByArnWithContext(ctx aws.Context, input *GetLayerVersionByArnInput, opts ...request.Option) (*GetLayerVersionByArnOutput, error) {
	req, out := c.GetLayerVersionByArnRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetLayerVersionPolicy = "GetLayerVersionPolicy"

// GetLayerVersionPolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetLayerVersionPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetLayerVersionPolicy for more information on using the GetLayerVersionPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetLayerVersionPolicyRequest method.
//    req, resp := client.GetLayerVersionPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetLayerVersionPolicy
func (c *Lambda) GetLayerVersionPolicyRequest(input *GetLayerVersionPolicyInput) (req *request.Request, output *GetLayerVersionPolicyOutput) {
	op := &request.Operation{
		Name:       opGetLayerVersionPolicy,
		HTTPMethod: "GET",
		HTTPPath:   "/2018-10-31/layers/{LayerName}/versions/{VersionNumber}/policy",
	}

	if input == nil {
		input = &GetLayerVersionPolicyInput{}
	}

	output = &GetLayerVersionPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetLayerVersionPolicy API operation for AWS Lambda.
//
// Returns the permission policy for a version of an AWS Lambda layer (https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html).
// For more information, see AddLayerVersionPermission.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation GetLayerVersionPolicy for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   The AWS Lambda service encountered an internal error.
//
//   * ResourceNotFoundException
//   The resource specified in the request does not exist.
//
//   * TooManyRequestsException
//   The request throughput limit was exceeded.
//
//   * InvalidParameterValueException
//   One of the parameters in the request is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetLayerVersionPolicy
func (c *Lambda) GetLayerVersionPolicy(input *GetLayerVersionPolicyInput) (*GetLayerVersionPolicyOutput, error) {
	req, out := c.GetLayerVersionPolicyRequest(input)
	return out, req.Send()
}

// GetLayerVersionPolicyWithContext is the same as GetLayerVersionPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetLayerVersionPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) GetLayerVersionPolicyWithContext(ctx aws.Context, input *GetLayerVersionPolicyInput, opts ...request.Option) (*GetLayerVersionPolicyOutput, error) {
	req, out := c.GetLayerVersionPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPolicy = "GetPolicy"

// GetPolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPolicy for more information on using the GetPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetPolicyRequest method.
//    req, resp := client.GetPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetPolicy
func (c *Lambda) GetPolicyRequest(input *GetPolicyInput) (req *request.Request, output *GetPolicyOutput) {
	op := &request.Operation{
		Name:       opGetPolicy,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}/policy",
	}

	if input == nil {
		input = &GetPolicyInput{}
	}

	output = &GetPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPolicy API operation for AWS Lambda.
//
// Returns the resource-based IAM policy (https://docs.aws.amazon.com/lambda/latest/dg/access-control-resource-based.html)
// for a function, version, or alias.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation GetPolicy for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   The AWS Lambda service encountered an internal error.
//
//   * ResourceNotFoundException
//   The resource specified in the request does not exist.
//
//   * TooManyRequestsException
//   The request throughput limit was exceeded.
//
//   * InvalidParameterValueException
//   One of the parameters in the request is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetPolicy
func (c *Lambda) GetPolicy(input *GetPolicyInput) (*GetPolicyOutput, error) {
	req, out := c.GetPolicyRequest(input)
	return out, req.Send()
}

// GetPolicyWithContext is the same as GetPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) GetPolicyWithContext(ctx aws.Context, input *GetPolicyInput, opts ...request.Option) (*GetPolicyOutput, error) {
	req, out := c.GetPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetProvisionedConcurrencyConfig = "GetProvisionedConcurrencyConfig"

// GetProvisionedConcurrencyConfigRequest generates a "aws/request.Request" representing the
// client's request for the GetProvisionedConcurrencyConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetProvisionedConcurrencyConfig for more information on using the GetProvisionedConcurrencyConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetProvisionedConcurrencyConfigRequest method.
//    req, resp := client.GetProvisionedConcurrencyConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetProvisionedConcurrencyConfig
func (c *Lambda) GetProvisionedConcurrencyConfigRequest(input *GetProvisionedConcurrencyConfigInput) (req *request.Request, output *GetProvisionedConcurrencyConfigOutput) {
	op := &request.Operation{
		Name:       opGetProvisionedConcurrencyConfig,
		HTTPMethod: "GET",
		HTTPPath:   "/2019-09-30/functions/{FunctionName}/provisioned-concurrency",
	}

	if input == nil {
		input = &GetProvisionedConcurrencyConfigInput{}
	}

	output = &GetProvisionedConcurrencyConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetProvisionedConcurrencyConfig API operation for AWS Lambda.
//
// Retrieves the provisioned concurrency configuration for a function's alias
// or version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation GetProvisionedConcurrencyConfig for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   One of the parameters in the request is invalid.
//
//   * ResourceNotFoundException
//   The resource specified in the request does not exist.
//
//   * TooManyRequestsException
//   The request throughput limit was exceeded.
//
//   * ServiceException
//   The AWS Lambda service encountered an internal error.
//
//   * ProvisionedConcurrencyConfigNotFoundException
//   The specified configuration does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetProvisionedConcurrencyConfig
func (c *Lambda) GetProvisionedConcurrencyConfig(input *GetProvisionedConcurrencyConfigInput) (*GetProvisionedConcurrencyConfigOutput, error) {
	req, out := c.GetProvisionedConcurrencyConfigRequest(input)
	return out, req.Send()
}

// GetProvisionedConcurrencyConfigWithContext is the same as GetProvisionedConcurrencyConfig with the addition of
// the ability to pass a context and additional request options.
//
// See GetProvisionedConcurrencyConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) GetProvisionedConcurrencyConfigWithContext(ctx aws.Context, input *GetProvisionedConcurrencyConfigInput, opts ...request.Option) (*GetProvisionedConcurrencyConfigOutput, error) {
	req, out := c.GetProvisionedConcurrencyConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opInvoke = "Invoke"

// InvokeRequest generates a "aws/request.Request" representing the
// client's request for the Invoke operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See Invoke for more information on using the Invoke
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the InvokeRequest method.
//    req, resp := client.InvokeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/Invoke
func (c *Lambda) InvokeRequest(input *InvokeInput) (req *request.Request, output *InvokeOutput) {
	op := &request.Operation{
		Name:       opInvoke,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}/invocations",
	}

	if input == nil {
		input = &InvokeInput{}
	}

	output = &InvokeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// Invoke API operation for AWS Lambda.
//
// Invokes a Lambda function. You can invoke a function synchronously (and wait
// for the response), or asynchronously. To invoke a function asynchronously,
// set InvocationType to Event.
//
// For synchronous invocation (https://docs.aws.amazon.com/lambda/latest/dg/invocation-sync.html),
// details about the function response, including errors, are included in the
// response body and headers. For either invocation type, you can find more
// information in the execution log (https://docs.aws.amazon.com/lambda/latest/dg/monitoring-functions.html)
// and trace (https://docs.aws.amazon.com/lambda/latest/dg/lambda-x-ray.html).
//
// When an error occurs, your function may be invoked multiple times. Retry
// behavior varies by error type, client, event source, and invocation type.
// For example, if you invoke a function asynchronously and it returns an error,
// Lambda executes the function up to two more times. For more information,
// see Retry Behavior (https://docs.aws.amazon.com/lambda/latest/dg/retries-on-errors.html).
//
// For asynchronous invocation (https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html),
// Lambda adds events to a queue before sending them to your function. If your
// function does not have enough capacity to keep up with the queue, events
// may be lost. Occasionally, your function may receive the same event multiple
// times, even if no error occurs. To retain events that were not processed,
// configure your function with a dead-letter queue (https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#dlq).
//
// The status code in the API response doesn't reflect function errors. Error
// codes are reserved for errors that prevent your function from executing,
// such as permissions errors, limit errors (https://docs.aws.amazon.com/lambda/latest/dg/limits.html),
// or issues with your function's code and configuration. For example, Lambda
// returns TooManyRequestsException if executing the function would cause you
// to exceed a concurrency limit at either the account level (ConcurrentInvocationLimitExceeded)
// or function level (ReservedFunctionConcurrentInvocationLimitExceeded).
//
// For functions with a long timeout, your client might be disconnected during
// synchronous invocation while it waits for a response. Configure your HTTP
// client, SDK, firewall, proxy, or operating system to allow for long connections
// with timeout or keep-alive settings.
//
// This operation requires permission for the lambda:InvokeFunction (https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awslambda.html)
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation Invoke for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   The AWS Lambda service encountered an internal error.
//
//   * ResourceNotFoundException
//   The resource specified in the request does not exist.
//
//   * InvalidRequestContentException
//   The request body could not be parsed as JSON.
//
//   * RequestTooLargeException
//   The request payload exceeded the Invoke request body JSON input limit. For
//   more information, see Limits (https://docs.aws.amazon.com/lambda/latest/dg/limits.html).
//
//   * UnsupportedMediaTypeException
//   The content type of the Invoke request body is not JSON.
//
//   * TooManyRequestsException
//   The request throughput limit was exceeded.
//
//   * InvalidParameterValueException
//   One of the parameters in the request is invalid.
//
//   * EC2UnexpectedException
//   AWS Lambda received an unexpected EC2 client exception while setting up for
//   the Lambda function.
//
//   * SubnetIPAddressLimitReachedException
//   AWS Lambda was not able to set up VPC access for the Lambda function because
//   one or more configured subnets has no available IP addresses.
//
//   * ENILimitReachedException
//   AWS Lambda was not able to create an elastic network interface in the VPC,
//   specified as part of Lambda function configuration, because the limit for
//   network interfaces has been reached.
//
//   * EC2ThrottledException
//   AWS Lambda was throttled by Amazon EC2 during Lambda function initialization
//   using the execution role provided for the Lambda function.
//
//   * EC2AccessDeniedException
//   Need additional permissions to configure VPC settings.
//
//   * InvalidSubnetIDException
//   The Subnet ID provided in the Lambda function VPC configuration is invalid.
//
//   * InvalidSecurityGroupIDException
//   The Security Group ID provided in the Lambda function VPC configuration is
//   invalid.
//
//   * InvalidZipFileException
//   AWS Lambda could not unzip the deployment package.
//
//   * KMSDisabledException
//   Lambda was unable to decrypt the environment variables because the KMS key
//   used is disabled. Check the Lambda function's KMS key settings.
//
//   * KMSInvalidStateException
//   Lambda was unable to decrypt the environment variables because the KMS key
//   used is in an invalid state for Decrypt. Check the function's KMS key settings.
//
//   * KMSAccessDeniedException
//   Lambda was unable to decrypt the environment variables because KMS access
//   was denied. Check the Lambda function's KMS permissions.
//
//   * KMSNotFoundException
//   Lambda was unable to decrypt the environment variables because the KMS key
//   was not found. Check the function's KMS key settings.
//
//   * InvalidRuntimeException
//   The runtime or runtime version specified is not supported.
//
//   * ResourceConflictException
//   The resource already exists, or another operation is in progress.
//
//   * ResourceNotReadyException
//   The function is inactive and its VPC connection is no longer available. Wait
//   for the VPC connection to reestablish and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/Invoke
func (c *Lambda) Invoke(input *InvokeInput) (*InvokeOutput, error) {
	req, out := c.InvokeRequest(input)
	return out, req.Send()
}

// InvokeWithContext is the same as Invoke with the addition of
// the ability to pass a context and additional request options.
//
// See Invoke for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) InvokeWithContext(ctx aws.Context, input *InvokeInput, opts ...request.Option) (*InvokeOutput, error) {
	req, out := c.InvokeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opInvokeAsync = "InvokeAsync"

// InvokeAsyncRequest generates a "aws/request.Request" representing the
// client's request for the InvokeAsync operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See InvokeAsync for more information on using the InvokeAsync
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the InvokeAsyncRequest method.
//    req, resp := client.InvokeAsyncRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/InvokeAsync
//
// Deprecated: InvokeAsync has been deprecated
func (c *Lambda) InvokeAsyncRequest(input *InvokeAsyncInput) (req *request.Request, output *InvokeAsyncOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, InvokeAsync, has been deprecated")
	}
	op := &request.Operation{
		Name:       opInvokeAsync,
		HTTPMethod: "POST",
		HTTPPath:   "/2014-11-13/functions/{FunctionName}/invoke-async/",
	}

	if input == nil {
		input = &InvokeAsyncInput{}
	}

	output = &InvokeAsyncOutput{}
	req = c.newRequest(op, input, output)
	return
}

// InvokeAsync API operation for AWS Lambda.
//
//
// For asynchronous function invocation, use Invoke.
//
// Invokes a function asynchronously.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation InvokeAsync for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   The AWS Lambda service encountered an internal error.
//
//   * ResourceNotFoundException
//   The resource specified in the request does not exist.
//
//   * InvalidRequestContentException
//   The request body could not be parsed as JSON.
//
//   * InvalidRuntimeException
//   The runtime or runtime version specified is not supported.
//
//   * ResourceConflictException
//   The resource already exists, or another operation is in progress.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/InvokeAsync
//
// Deprecated: InvokeAsync has been deprecated
func (c *Lambda) InvokeAsync(input *InvokeAsyncInput) (*InvokeAsyncOutput, error) {
	req, out := c.InvokeAsyncRequest(input)
	return out, req.Send()
}

// InvokeAsyncWithContext is the same as InvokeAsync with the addition of
// the ability to pass a context and additional request options.
//
// See InvokeAsync for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: InvokeAsyncWithContext has been deprecated
func (c *Lambda) InvokeAsyncWithContext(ctx aws.Context, input *InvokeAsyncInput, opts ...request.Option) (*InvokeAsyncOutput, error) {
	req, out := c.InvokeAsyncRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAliases = "ListAliases"

// ListAliasesRequest generates a "aws/request.Request" representing the
// client's request for the ListAliases operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAliases for more information on using the ListAliases
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAliasesRequest method.
//    req, resp := client.ListAliasesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListAliases
func (c *Lambda) ListAliasesRequest(input *ListAliasesInput) (req *request.Request, output *ListAliasesOutput) {
	op := &request.Operation{
		Name:       opListAliases,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}/aliases",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"NextMarker"},
			LimitToken:      "MaxItems",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAliasesInput{}
	}

	output = &ListAliasesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAliases API operation for AWS Lambda.
//
// Returns a list of aliases (https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html)
// for a Lambda function.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation ListAliases for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   The AWS Lambda service encountered an internal error.
//
//   * ResourceNotFoundException
//   The resource specified in the request does not exist.
//
//   * InvalidParameterValueException
//   One of the parameters in the request is invalid.
//
//   * TooManyRequestsException
//   The request throughput limit was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListAliases
func (c *Lambda) ListAliases(input *ListAliasesInput) (*ListAliasesOutput, error) {
	req, out := c.ListAliasesRequest(input)
	return out, req.Send()
}

// ListAliasesWithContext is the same as ListAliases with the addition of
// the ability to pass a context and additional request options.
//
// See ListAliases for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) ListAliasesWithContext(ctx aws.Context, input *ListAliasesInput, opts ...request.Option) (*ListAliasesOutput, error) {
	req, out := c.ListAliasesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAliasesPages iterates over the pages of a ListAliases operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAliases method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAliases operation.
//    pageNum := 0
//    err := client.ListAliasesPages(params,
//        func(page *lambda.ListAliasesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Lambda) ListAliasesPages(input *ListAliasesInput, fn func(*ListAliasesOutput, bool) bool) error {
	return c.ListAliasesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAliasesPagesWithContext same as ListAliasesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) ListAliasesPagesWithContext(ctx aws.Context, input *ListAliasesInput, fn func(*ListAliasesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAliasesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAliasesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAliasesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListEventSourceMappings = "ListEventSourceMappings"

// ListEventSourceMappingsRequest generates a "aws/request.Request" representing the
// client's request for the ListEventSourceMappings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEventSourceMappings for more information on using the ListEventSourceMappings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListEventSourceMappingsRequest method.
//    req, resp := client.ListEventSourceMappingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListEventSourceMappings
func (c *Lambda) ListEventSourceMappingsRequest(input *ListEventSourceMappingsInput) (req *request.Request, output *ListEventSourceMappingsOutput) {
	op := &request.Operation{
		Name:       opListEventSourceMappings,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-03-31/event-source-mappings/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"NextMarker"},
			LimitToken:      "MaxItems",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEventSourceMappingsInput{}
	}

	output = &ListEventSourceMappingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEventSourceMappings API operation for AWS Lambda.
//
// Lists event source mappings. Specify an EventSourceArn to only show event
// source mappings for a single event source.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation ListEventSourceMappings for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   The AWS Lambda service encountered an internal error.
//
//   * ResourceNotFoundException
//   The resource specified in the request does not exist.
//
//   * InvalidParameterValueException
//   One of the parameters in the request is invalid.
//
//   * TooManyRequestsException
//   The request throughput limit was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListEventSourceMappings
func (c *Lambda) ListEventSourceMappings(input *ListEventSourceMappingsInput) (*ListEventSourceMappingsOutput, error) {
	req, out := c.ListEventSourceMappingsRequest(input)
	return out, req.Send()
}

// ListEventSourceMappingsWithContext is the same as ListEventSourceMappings with the addition of
// the ability to pass a context and additional request options.
//
// See ListEventSourceMappings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) ListEventSourceMappingsWithContext(ctx aws.Context, input *ListEventSourceMappingsInput, opts ...request.Option) (*ListEventSourceMappingsOutput, error) {
	req, out := c.ListEventSourceMappingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListEventSourceMappingsPages iterates over the pages of a ListEventSourceMappings operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEventSourceMappings method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListEventSourceMappings operation.
//    pageNum := 0
//    err := client.ListEventSourceMappingsPages(params,
//        func(page *lambda.ListEventSourceMappingsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Lambda) ListEventSourceMappingsPages(input *ListEventSourceMappingsInput, fn func(*ListEventSourceMappingsOutput, bool) bool) error {
	return c.ListEventSourceMappingsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListEventSourceMappingsPagesWithContext same as ListEventSourceMappingsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) ListEventSourceMappingsPagesWithContext(ctx aws.Context, input *ListEventSourceMappingsInput, fn func(*ListEventSourceMappingsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListEventSourceMappingsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListEventSourceMappingsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListEventSourceMappingsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListFunctionEventInvokeConfigs = "ListFunctionEventInvokeConfigs"

// ListFunctionEventInvokeConfigsRequest generates a "aws/request.Request" representing the
// client's request for the ListFunctionEventInvokeConfigs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFunctionEventInvokeConfigs for more information on using the ListFunctionEventInvokeConfigs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListFunctionEventInvokeConfigsRequest method.
//    req, resp := client.ListFunctionEventInvokeConfigsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListFunctionEventInvokeConfigs
func (c *Lambda) ListFunctionEventInvokeConfigsRequest(input *ListFunctionEventInvokeConfigsInput) (req *request.Request, output *ListFunctionEventInvokeConfigsOutput) {
	op := &request.Operation{
		Name:       opListFunctionEventInvokeConfigs,
		HTTPMethod: "GET",
		HTTPPath:   "/2019-09-25/functions/{FunctionName}/event-invoke-config/list",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"NextMarker"},
			LimitToken:      "MaxItems",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListFunctionEventInvokeConfigsInput{}
	}

	output = &ListFunctionEventInvokeConfigsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFunctionEventInvokeConfigs API operation for AWS Lambda.
//
// Retrieves a list of configurations for asynchronous invocation for a function.
//
// To configure options for asynchronous invocation, use PutFunctionEventInvokeConfig.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation ListFunctionEventInvokeConfigs for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   One of the parameters in the request is invalid.
//
//   * ResourceNotFoundException
//   The resource specified in the request does not exist.
//
//   * TooManyRequestsException
//   The request throughput limit was exceeded.
//
//   * ServiceException
//   The AWS Lambda service encountered an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListFunctionEventInvokeConfigs
func (c *Lambda) ListFunctionEventInvokeConfigs(input *ListFunctionEventInvokeConfigsInput) (*ListFunctionEventInvokeConfigsOutput, error) {
	req, out := c.ListFunctionEventInvokeConfigsRequest(input)
	return out, req.Send()
}

// ListFunctionEventInvokeConfigsWithContext is the same as ListFunctionEventInvokeConfigs with the addition of
// the ability to pass a context and additional request options.
//
// See ListFunctionEventInvokeConfigs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) ListFunctionEventInvokeConfigsWithContext(ctx aws.Context, input *ListFunctionEventInvokeConfigsInput, opts ...request.Option) (*ListFunctionEventInvokeConfigsOutput, error) {
	req, out := c.ListFunctionEventInvokeConfigsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListFunctionEventInvokeConfigsPages iterates over the pages of a ListFunctionEventInvokeConfigs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListFunctionEventInvokeConfigs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListFunctionEventInvokeConfigs operation.
//    pageNum := 0
//    err := client.ListFunctionEventInvokeConfigsPages(params,
//        func(page *lambda.ListFunctionEventInvokeConfigsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Lambda) ListFunctionEventInvokeConfigsPages(input *ListFunctionEventInvokeConfigsInput, fn func(*ListFunctionEventInvokeConfigsOutput, bool) bool) error {
	return c.ListFunctionEventInvokeConfigsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListFunctionEventInvokeConfigsPagesWithContext same as ListFunctionEventInvokeConfigsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) ListFunctionEventInvokeConfigsPagesWithContext(ctx aws.Context, input *ListFunctionEventInvokeConfigsInput, fn func(*ListFunctionEventInvokeConfigsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListFunctionEventInvokeConfigsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListFunctionEventInvokeConfigsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListFunctionEventInvokeConfigsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListFunctions = "ListFunctions"

// ListFunctionsRequest generates a "aws/request.Request" representing the
// client's request for the ListFunctions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFunctions for more information on using the ListFunctions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListFunctionsRequest method.
//    req, resp := client.ListFunctionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListFunctions
func (c *Lambda) ListFunctionsRequest(input *ListFunctionsInput) (req *request.Request, output *ListFunctionsOutput) {
	op := &request.Operation{
		Name:       opListFunctions,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-03-31/functions/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"NextMarker"},
			LimitToken:      "MaxItems",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListFunctionsInput{}
	}

	output = &ListFunctionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFunctions API operation for AWS Lambda.
//
// Returns a list of Lambda functions, with the version-specific configuration
// of each. Lambda returns up to 50 functions per call.
//
// Set FunctionVersion to ALL to include all published versions of each function
// in addition to the unpublished version. To get more information about a function
// or version, use GetFunction.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation ListFunctions for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   The AWS Lambda service encountered an internal error.
//
//   * TooManyRequestsException
//   The request throughput limit was exceeded.
//
//   * InvalidParameterValueException
//   One of the parameters in the request is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListFunctions
func (c *Lambda) ListFunctions(input *ListFunctionsInput) (*ListFunctionsOutput, error) {
	req, out := c.ListFunctionsRequest(input)
	return out, req.Send()
}

// ListFunctionsWithContext is the same as ListFunctions with the addition of
// the ability to pass a context and additional request options.
//
// See ListFunctions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) ListFunctionsWithContext(ctx aws.Context, input *ListFunctionsInput, opts ...request.Option) (*ListFunctionsOutput, error) {
	req, out := c.ListFunctionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListFunctionsPages iterates over the pages of a ListFunctions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListFunctions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListFunctions operation.
//    pageNum := 0
//    err := client.ListFunctionsPages(params,
//        func(page *lambda.ListFunctionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Lambda) ListFunctionsPages(input *ListFunctionsInput, fn func(*ListFunctionsOutput, bool) bool) error {
	return c.ListFunctionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListFunctionsPagesWithContext same as ListFunctionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) ListFunctionsPagesWithContext(ctx aws.Context, input *ListFunctionsInput, fn func(*ListFunctionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListFunctionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListFunctionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListFunctionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListLayerVersions = "ListLayerVersions"

// ListLayerVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListLayerVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListLayerVersions for more information on using the ListLayerVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListLayerVersionsRequest method.
//    req, resp := client.ListLayerVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListLayerVersions
func (c *Lambda) ListLayerVersionsRequest(input *ListLayerVersionsInput) (req *request.Request, output *ListLayerVersionsOutput) {
	op := &request.Operation{
		Name:       opListLayerVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/2018-10-31/layers/{LayerName}/versions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"NextMarker"},
			LimitToken:      "MaxItems",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListLayerVersionsInput{}
	}

	output = &ListLayerVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListLayerVersions API operation for AWS Lambda.
//
// Lists the versions of an AWS Lambda layer (https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html).
// Versions that have been deleted aren't listed. Specify a runtime identifier
// (https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html) to list
// only versions that indicate that they're compatible with that runtime.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation ListLayerVersions for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   The AWS Lambda service encountered an internal error.
//
//   * InvalidParameterValueException
//   One of the parameters in the request is invalid.
//
//   * ResourceNotFoundException
//   The resource specified in the request does not exist.
//
//   * TooManyRequestsException
//   The request throughput limit was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListLayerVersions
func (c *Lambda) ListLayerVersions(input *ListLayerVersionsInput) (*ListLayerVersionsOutput, error) {
	req, out := c.ListLayerVersionsRequest(input)
	return out, req.Send()
}

// ListLayerVersionsWithContext is the same as ListLayerVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListLayerVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) ListLayerVersionsWithContext(ctx aws.Context, input *ListLayerVersionsInput, opts ...request.Option) (*ListLayerVersionsOutput, error) {
	req, out := c.ListLayerVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListLayerVersionsPages iterates over the pages of a ListLayerVersions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListLayerVersions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListLayerVersions operation.
//    pageNum := 0
//    err := client.ListLayerVersionsPages(params,
//        func(page *lambda.ListLayerVersionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Lambda) ListLayerVersionsPages(input *ListLayerVersionsInput, fn func(*ListLayerVersionsOutput, bool) bool) error {
	return c.ListLayerVersionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListLayerVersionsPagesWithContext same as ListLayerVersionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) ListLayerVersionsPagesWithContext(ctx aws.Context, input *ListLayerVersionsInput, fn func(*ListLayerVersionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListLayerVersionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListLayerVersionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListLayerVersionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListLayers = "ListLayers"

// ListLayersRequest generates a "aws/request.Request" representing the
// client's request for the ListLayers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListLayers for more information on using the ListLayers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListLayersRequest method.
//    req, resp := client.ListLayersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListLayers
func (c *Lambda) ListLayersRequest(input *ListLayersInput) (req *request.Request, output *ListLayersOutput) {
	op := &request.Operation{
		Name:       opListLayers,
		HTTPMethod: "GET",
		HTTPPath:   "/2018-10-31/layers",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"NextMarker"},
			LimitToken:      "MaxItems",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListLayersInput{}
	}

	output = &ListLayersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListLayers API operation for AWS Lambda.
//
// Lists AWS Lambda layers (https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html)
// and shows information about the latest version of each. Specify a runtime
// identifier (https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html)
// to list only layers that indicate that they're compatible with that runtime.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation ListLayers for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   The AWS Lambda service encountered an internal error.
//
//   * InvalidParameterValueException
//   One of the parameters in the request is invalid.
//
//   * TooManyRequestsException
//   The request throughput limit was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListLayers
func (c *Lambda) ListLayers(input *ListLayersInput) (*ListLayersOutput, error) {
	req, out := c.ListLayersRequest(input)
	return out, req.Send()
}

// ListLayersWithContext is the same as ListLayers with the addition of
// the ability to pass a context and additional request options.
//
// See ListLayers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) ListLayersWithContext(ctx aws.Context, input *ListLayersInput, opts ...request.Option) (*ListLayersOutput, error) {
	req, out := c.ListLayersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListLayersPages iterates over the pages of a ListLayers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListLayers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListLayers operation.
//    pageNum := 0
//    err := client.ListLayersPages(params,
//        func(page *lambda.ListLayersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Lambda) ListLayersPages(input *ListLayersInput, fn func(*ListLayersOutput, bool) bool) error {
	return c.ListLayersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListLayersPagesWithContext same as ListLayersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) ListLayersPagesWithContext(ctx aws.Context, input *ListLayersInput, fn func(*ListLayersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListLayersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListLayersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListLayersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListProvisionedConcurrencyConfigs = "ListProvisionedConcurrencyConfigs"

// ListProvisionedConcurrencyConfigsRequest generates a "aws/request.Request" representing the
// client's request for the ListProvisionedConcurrencyConfigs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListProvisionedConcurrencyConfigs for more information on using the ListProvisionedConcurrencyConfigs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListProvisionedConcurrencyConfigsRequest method.
//    req, resp := client.ListProvisionedConcurrencyConfigsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListProvisionedConcurrencyConfigs
func (c *Lambda) ListProvisionedConcurrencyConfigsRequest(input *ListProvisionedConcurrencyConfigsInput) (req *request.Request, output *ListProvisionedConcurrencyConfigsOutput) {
	op := &request.Operation{
		Name:       opListProvisionedConcurrencyConfigs,
		HTTPMethod: "GET",
		HTTPPath:   "/2019-09-30/functions/{FunctionName}/provisioned-concurrency?List=ALL",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"NextMarker"},
			LimitToken:      "MaxItems",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListProvisionedConcurrencyConfigsInput{}
	}

	output = &ListProvisionedConcurrencyConfigsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListProvisionedConcurrencyConfigs API operation for AWS Lambda.
//
// Retrieves a list of provisioned concurrency configurations for a function.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation ListProvisionedConcurrencyConfigs for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   One of the parameters in the request is invalid.
//
//   * ResourceNotFoundException
//   The resource specified in the request does not exist.
//
//   * TooManyRequestsException
//   The request throughput limit was exceeded.
//
//   * ServiceException
//   The AWS Lambda service encountered an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListProvisionedConcurrencyConfigs
func (c *Lambda) ListProvisionedConcurrencyConfigs(input *ListProvisionedConcurrencyConfigsInput) (*ListProvisionedConcurrencyConfigsOutput, error) {
	req, out := c.ListProvisionedConcurrencyConfigsRequest(input)
	return out, req.Send()
}

// ListProvisionedConcurrencyConfigsWithContext is the same as ListProvisionedConcurrencyConfigs with the addition of
// the ability to pass a context and additional request options.
//
// See ListProvisionedConcurrencyConfigs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) ListProvisionedConcurrencyConfigsWithContext(ctx aws.Context, input *ListProvisionedConcurrencyConfigsInput, opts ...request.Option) (*ListProvisionedConcurrencyConfigsOutput, error) {
	req, out := c.ListProvisionedConcurrencyConfigsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListProvisionedConcurrencyConfigsPages iterates over the pages of a ListProvisionedConcurrencyConfigs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListProvisionedConcurrencyConfigs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListProvisionedConcurrencyConfigs operation.
//    pageNum := 0
//    err := client.ListProvisionedConcurrencyConfigsPages(params,
//        func(page *lambda.ListProvisionedConcurrencyConfigsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Lambda) ListProvisionedConcurrencyConfigsPages(input *ListProvisionedConcurrencyConfigsInput, fn func(*ListProvisionedConcurrencyConfigsOutput, bool) bool) error {
	return c.ListProvisionedConcurrencyConfigsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListProvisionedConcurrencyConfigsPagesWithContext same as ListProvisionedConcurrencyConfigsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) ListProvisionedConcurrencyConfigsPagesWithContext(ctx aws.Context, input *ListProvisionedConcurrencyConfigsInput, fn func(*ListProvisionedConcurrencyConfigsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListProvisionedConcurrencyConfigsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListProvisionedConcurrencyConfigsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListProvisionedConcurrencyConfigsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTags = "ListTags"

// ListTagsRequest generates a "aws/request.Request" representing the
// client's request for the ListTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTags for more information on using the ListTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsRequest method.
//    req, resp := client.ListTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListTags
func (c *Lambda) ListTagsRequest(input *ListTagsInput) (req *request.Request, output *ListTagsOutput) {
	op := &request.Operation{
		Name:       opListTags,
		HTTPMethod: "GET",
		HTTPPath:   "/2017-03-31/tags/{ARN}",
	}

	if input == nil {
		input = &ListTagsInput{}
	}

	output = &ListTagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTags API operation for AWS Lambda.
//
// Returns a function's tags (https://docs.aws.amazon.com/lambda/latest/dg/tagging.html).
// You can also view tags with GetFunction.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation ListTags for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   The AWS Lambda service encountered an internal error.
//
//   * ResourceNotFoundException
//   The resource specified in the request does not exist.
//
//   * InvalidParameterValueException
//   One of the parameters in the request is invalid.
//
//   * TooManyRequestsException
//   The request throughput limit was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListTags
func (c *Lambda) ListTags(input *ListTagsInput) (*ListTagsOutput, error) {
	req, out := c.ListTagsRequest(input)
	return out, req.Send()
}

// ListTagsWithContext is the same as ListTags with the addition of
// the ability to pass a context and additional request options.
//
// See ListTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) ListTagsWithContext(ctx aws.Context, input *ListTagsInput, opts ...request.Option) (*ListTagsOutput, error) {
	req, out := c.ListTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListVersionsByFunction = "ListVersionsByFunction"

// ListVersionsByFunctionRequest generates a "aws/request.Request" representing the
// client's request for the ListVersionsByFunction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListVersionsByFunction for more information on using the ListVersionsByFunction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListVersionsByFunctionRequest method.
//    req, resp := client.ListVersionsByFunctionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListVersionsByFunction
func (c *Lambda) ListVersionsByFunctionRequest(input *ListVersionsByFunctionInput) (req *request.Request, output *ListVersionsByFunctionOutput) {
	op := &request.Operation{
		Name:       opListVersionsByFunction,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}/versions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"NextMarker"},
			LimitToken:      "MaxItems",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListVersionsByFunctionInput{}
	}

	output = &ListVersionsByFunctionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListVersionsByFunction API operation for AWS Lambda.
//
// Returns a list of versions (https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html),
// with the version-specific configuration of each. Lambda returns up to 50
// versions per call.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation ListVersionsByFunction for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   The AWS Lambda service encountered an internal error.
//
//   * ResourceNotFoundException
//   The resource specified in the request does not exist.
//
//   * InvalidParameterValueException
//   One of the parameters in the request is invalid.
//
//   * TooManyRequestsException
//   The request throughput limit was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListVersionsByFunction
func (c *Lambda) ListVersionsByFunction(input *ListVersionsByFunctionInput) (*ListVersionsByFunctionOutput, error) {
	req, out := c.ListVersionsByFunctionRequest(input)
	return out, req.Send()
}

// ListVersionsByFunctionWithContext is the same as ListVersionsByFunction with the addition of
// the ability to pass a context and additional request options.
//
// See ListVersionsByFunction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) ListVersionsByFunctionWithContext(ctx aws.Context, input *ListVersionsByFunctionInput, opts ...request.Option) (*ListVersionsByFunctionOutput, error) {
	req, out := c.ListVersionsByFunctionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListVersionsByFunctionPages iterates over the pages of a ListVersionsByFunction operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListVersionsByFunction method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListVersionsByFunction operation.
//    pageNum := 0
//    err := client.ListVersionsByFunctionPages(params,
//        func(page *lambda.ListVersionsByFunctionOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Lambda) ListVersionsByFunctionPages(input *ListVersionsByFunctionInput, fn func(*ListVersionsByFunctionOutput, bool) bool) error {
	return c.ListVersionsByFunctionPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListVersionsByFunctionPagesWithContext same as ListVersionsByFunctionPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) ListVersionsByFunctionPagesWithContext(ctx aws.Context, input *ListVersionsByFunctionInput, fn func(*ListVersionsByFunctionOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListVersionsByFunctionInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListVersionsByFunctionRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListVersionsByFunctionOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opPublishLayerVersion = "PublishLayerVersion"

// PublishLayerVersionRequest generates a "aws/request.Request" representing the
// client's request for the PublishLayerVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PublishLayerVersion for more information on using the PublishLayerVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PublishLayerVersionRequest method.
//    req, resp := client.PublishLayerVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/PublishLayerVersion
func (c *Lambda) PublishLayerVersionRequest(input *PublishLayerVersionInput) (req *request.Request, output *PublishLayerVersionOutput) {
	op := &request.Operation{
		Name:       opPublishLayerVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/2018-10-31/layers/{LayerName}/versions",
	}

	if input == nil {
		input = &PublishLayerVersionInput{}
	}

	output = &PublishLayerVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PublishLayerVersion API operation for AWS Lambda.
//
// Creates an AWS Lambda layer (https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html)
// from a ZIP archive. Each time you call PublishLayerVersion with the same
// layer name, a new version is created.
//
// Add layers to your function with CreateFunction or UpdateFunctionConfiguration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation PublishLayerVersion for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   The AWS Lambda service encountered an internal error.
//
//   * ResourceNotFoundException
//   The resource specified in the request does not exist.
//
//   * TooManyRequestsException
//   The request throughput limit was exceeded.
//
//   * InvalidParameterValueException
//   One of the parameters in the request is invalid.
//
//   * CodeStorageExceededException
//   You have exceeded your maximum total code size per account. Learn more (https://docs.aws.amazon.com/lambda/latest/dg/limits.html)
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/PublishLayerVersion
func (c *Lambda) PublishLayerVersion(input *PublishLayerVersionInput) (*PublishLayerVersionOutput, error) {
	req, out := c.PublishLayerVersionRequest(input)
	return out, req.Send()
}

// PublishLayerVersionWithContext is the same as PublishLayerVersion with the addition of
// the ability to pass a context and additional request options.
//
// See PublishLayerVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) PublishLayerVersionWithContext(ctx aws.Context, input *PublishLayerVersionInput, opts ...request.Option) (*PublishLayerVersionOutput, error) {
	req, out := c.PublishLayerVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPublishVersion = "PublishVersion"

// PublishVersionRequest generates a "aws/request.Request" representing the
// client's request for the PublishVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PublishVersion for more information on using the PublishVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PublishVersionRequest method.
//    req, resp := client.PublishVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/PublishVersion
func (c *Lambda) PublishVersionRequest(input *PublishVersionInput) (req *request.Request, output *FunctionConfiguration) {
	op := &request.Operation{
		Name:       opPublishVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}/versions",
	}

	if input == nil {
		input = &PublishVersionInput{}
	}

	output = &FunctionConfiguration{}
	req = c.newRequest(op, input, output)
	return
}

// PublishVersion API operation for AWS Lambda.
//
// Creates a version (https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html)
// from the current code and configuration of a function. Use versions to create
// a snapshot of your function code and configuration that doesn't change.
//
// AWS Lambda doesn't publish a version if the function's configuration and
// code haven't changed since the last version. Use UpdateFunctionCode or UpdateFunctionConfiguration
// to update the function before publishing a version.
//
// Clients can invoke versions directly or with an alias. To create an alias,
// use CreateAlias.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation PublishVersion for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   The AWS Lambda service encountered an internal error.
//
//   * ResourceNotFoundException
//   The resource specified in the request does not exist.
//
//   * InvalidParameterValueException
//   One of the parameters in the request is invalid.
//
//   * TooManyRequestsException
//   The request throughput limit was exceeded.
//
//   * CodeStorageExceededException
//   You have exceeded your maximum total code size per account. Learn more (https://docs.aws.amazon.com/lambda/latest/dg/limits.html)
//
//   * PreconditionFailedException
//   The RevisionId provided does not match the latest RevisionId for the Lambda
//   function or alias. Call the GetFunction or the GetAlias API to retrieve the
//   latest RevisionId for your resource.
//
//   * ResourceConflictException
//   The resource already exists, or another operation is in progress.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/PublishVersion
func (c *Lambda) PublishVersion(input *PublishVersionInput) (*FunctionConfiguration, error) {
	req, out := c.PublishVersionRequest(input)
	return out, req.Send()
}

// PublishVersionWithContext is the same as PublishVersion with the addition of
// the ability to pass a context and additional request options.
//
// See PublishVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) PublishVersionWithContext(ctx aws.Context, input *PublishVersionInput, opts ...request.Option) (*FunctionConfiguration, error) {
	req, out := c.PublishVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutFunctionConcurrency = "PutFunctionConcurrency"

// PutFunctionConcurrencyRequest generates a "aws/request.Request" representing the
// client's request for the PutFunctionConcurrency operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutFunctionConcurrency for more information on using the PutFunctionConcurrency
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutFunctionConcurrencyRequest method.
//    req, resp := client.PutFunctionConcurrencyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/PutFunctionConcurrency
func (c *Lambda) PutFunctionConcurrencyRequest(input *PutFunctionConcurrencyInput) (req *request.Request, output *PutFunctionConcurrencyOutput) {
	op := &request.Operation{
		Name:       opPutFunctionConcurrency,
		HTTPMethod: "PUT",
		HTTPPath:   "/2017-10-31/functions/{FunctionName}/concurrency",
	}

	if input == nil {
		input = &PutFunctionConcurrencyInput{}
	}

	output = &PutFunctionConcurrencyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutFunctionConcurrency API operation for AWS Lambda.
//
// Sets the maximum number of simultaneous executions for a function, and reserves
// capacity for that concurrency level.
//
// Concurrency settings apply to the function as a whole, including all published
// versions and the unpublished version. Reserving concurrency both ensures
// that your function has capacity to process the specified number of events
// simultaneously, and prevents it from scaling beyond that level. Use GetFunction
// to see the current setting for a function.
//
// Use GetAccountSettings to see your Regional concurrency limit. You can reserve
// concurrency for as many functions as you like, as long as you leave at least
// 100 simultaneous executions unreserved for functions that aren't configured
// with a per-function limit. For more information, see Managing Concurrency
// (https://docs.aws.amazon.com/lambda/latest/dg/concurrent-executions.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation PutFunctionConcurrency for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   The AWS Lambda service encountered an internal error.
//
//   * InvalidParameterValueException
//   One of the parameters in the request is invalid.
//
//   * ResourceNotFoundException
//   The resource specified in the request does not exist.
//
//   * TooManyRequestsException
//   The request throughput limit was exceeded.
//
//   * ResourceConflictException
//   The resource already exists, or another operation is in progress.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/PutFunctionConcurrency
func (c *Lambda) PutFunctionConcurrency(input *PutFunctionConcurrencyInput) (*PutFunctionConcurrencyOutput, error) {
	req, out := c.PutFunctionConcurrencyRequest(input)
	return out, req.Send()
}

// PutFunctionConcurrencyWithContext is the same as PutFunctionConcurrency with the addition of
// the ability to pass a context and additional request options.
//
// See PutFunctionConcurrency for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) PutFunctionConcurrencyWithContext(ctx aws.Context, input *PutFunctionConcurrencyInput, opts ...request.Option) (*PutFunctionConcurrencyOutput, error) {
	req, out := c.PutFunctionConcurrencyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutFunctionEventInvokeConfig = "PutFunctionEventInvokeConfig"

// PutFunctionEventInvokeConfigRequest generates a "aws/request.Request" representing the
// client's request for the PutFunctionEventInvokeConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutFunctionEventInvokeConfig for more information on using the PutFunctionEventInvokeConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutFunctionEventInvokeConfigRequest method.
//    req, resp := client.PutFunctionEventInvokeConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/PutFunctionEventInvokeConfig
func (c *Lambda) PutFunctionEventInvokeConfigRequest(input *PutFunctionEventInvokeConfigInput) (req *request.Request, output *PutFunctionEventInvokeConfigOutput) {
	op := &request.Operation{
		Name:       opPutFunctionEventInvokeConfig,
		HTTPMethod: "PUT",
		HTTPPath:   "/2019-09-25/functions/{FunctionName}/event-invoke-config",
	}

	if input == nil {
		input = &PutFunctionEventInvokeConfigInput{}
	}

	output = &PutFunctionEventInvokeConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutFunctionEventInvokeConfig API operation for AWS Lambda.
//
// Configures options for asynchronous invocation (https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html)
// on a function, version, or alias. If a configuration already exists for a
// function, version, or alias, this operation overwrites it. If you exclude
// any settings, they are removed. To set one option without affecting existing
// settings for other options, use PutFunctionEventInvokeConfig.
//
// By default, Lambda retries an asynchronous invocation twice if the function
// returns an error. It retains events in a queue for up to six hours. When
// an event fails all processing attempts or stays in the asynchronous invocation
// queue for too long, Lambda discards it. To retain discarded events, configure
// a dead-letter queue with UpdateFunctionConfiguration.
//
// To send an invocation record to a queue, topic, function, or event bus, specify
// a destination (https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#invocation-async-destinations).
// You can configure separate destinations for successful invocations (on-success)
// and events that fail all processing attempts (on-failure). You can configure
// destinations in addition to or instead of a dead-letter queue.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation PutFunctionEventInvokeConfig for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   The AWS Lambda service encountered an internal error.
//
//   * ResourceNotFoundException
//   The resource specified in the request does not exist.
//
//   * InvalidParameterValueException
//   One of the parameters in the request is invalid.
//
//   * TooManyRequestsException
//   The request throughput limit was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/PutFunctionEventInvokeConfig
func (c *Lambda) PutFunctionEventInvokeConfig(input *PutFunctionEventInvokeConfigInput) (*PutFunctionEventInvokeConfigOutput, error) {
	req, out := c.PutFunctionEventInvokeConfigRequest(input)
	return out, req.Send()
}

// PutFunctionEventInvokeConfigWithContext is the same as PutFunctionEventInvokeConfig with the addition of
// the ability to pass a context and additional request options.
//
// See PutFunctionEventInvokeConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) PutFunctionEventInvokeConfigWithContext(ctx aws.Context, input *PutFunctionEventInvokeConfigInput, opts ...request.Option) (*PutFunctionEventInvokeConfigOutput, error) {
	req, out := c.PutFunctionEventInvokeConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutProvisionedConcurrencyConfig = "PutProvisionedConcurrencyConfig"

// PutProvisionedConcurrencyConfigRequest generates a "aws/request.Request" representing the
// client's request for the PutProvisionedConcurrencyConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutProvisionedConcurrencyConfig for more information on using the PutProvisionedConcurrencyConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutProvisionedConcurrencyConfigRequest method.
//    req, resp := client.PutProvisionedConcurrencyConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/PutProvisionedConcurrencyConfig
func (c *Lambda) PutProvisionedConcurrencyConfigRequest(input *PutProvisionedConcurrencyConfigInput) (req *request.Request, output *PutProvisionedConcurrencyConfigOutput) {
	op := &request.Operation{
		Name:       opPutProvisionedConcurrencyConfig,
		HTTPMethod: "PUT",
		HTTPPath:   "/2019-09-30/functions/{FunctionName}/provisioned-concurrency",
	}

	if input == nil {
		input = &PutProvisionedConcurrencyConfigInput{}
	}

	output = &PutProvisionedConcurrencyConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutProvisionedConcurrencyConfig API operation for AWS Lambda.
//
// Adds a provisioned concurrency configuration to a function's alias or version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation PutProvisionedConcurrencyConfig for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValueException
//   One of the parameters in the request is invalid.
//
//   * ResourceNotFoundException
//   The resource specified in the request does not exist.
//
//   * ResourceConflictException
//   The resource already exists, or another operation is in progress.
//
//   * TooManyRequestsException
//   The request throughput limit was exceeded.
//
//   * ServiceException
//   The AWS Lambda service encountered an internal error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/PutProvisionedConcurrencyConfig
func (c *Lambda) PutProvisionedConcurrencyConfig(input *PutProvisionedConcurrencyConfigInput) (*PutProvisionedConcurrencyConfigOutput, error) {
	req, out := c.PutProvisionedConcurrencyConfigRequest(input)
	return out, req.Send()
}

// PutProvisionedConcurrencyConfigWithContext is the same as PutProvisionedConcurrencyConfig with the addition of
// the ability to pass a context and additional request options.
//
// See PutProvisionedConcurrencyConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) PutProvisionedConcurrencyConfigWithContext(ctx aws.Context, input *PutProvisionedConcurrencyConfigInput, opts ...request.Option) (*PutProvisionedConcurrencyConfigOutput, error) {
	req, out := c.PutProvisionedConcurrencyConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemoveLayerVersionPermission = "RemoveLayerVersionPermission"

// RemoveLayerVersionPermissionRequest generates a "aws/request.Request" representing the
// client's request for the RemoveLayerVersionPermission operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemoveLayerVersionPermission for more information on using the RemoveLayerVersionPermission
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RemoveLayerVersionPermissionRequest method.
//    req, resp := client.RemoveLayerVersionPermissionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/RemoveLayerVersionPermission
func (c *Lambda) RemoveLayerVersionPermissionRequest(input *RemoveLayerVersionPermissionInput) (req *request.Request, output *RemoveLayerVersionPermissionOutput) {
	op := &request.Operation{
		Name:       opRemoveLayerVersionPermission,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2018-10-31/layers/{LayerName}/versions/{VersionNumber}/policy/{StatementId}",
	}

	if input == nil {
		input = &RemoveLayerVersionPermissionInput{}
	}

	output = &RemoveLayerVersionPermissionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RemoveLayerVersionPermission API operation for AWS Lambda.
//
// Removes a statement from the permissions policy for a version of an AWS Lambda
// layer (https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html).
// For more information, see AddLayerVersionPermission.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation RemoveLayerVersionPermission for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   The AWS Lambda service encountered an internal error.
//
//   * ResourceNotFoundException
//   The resource specified in the request does not exist.
//
//   * InvalidParameterValueException
//   One of the parameters in the request is invalid.
//
//   * TooManyRequestsException
//   The request throughput limit was exceeded.
//
//   * PreconditionFailedException
//   The RevisionId provided does not match the latest RevisionId for the Lambda
//   function or alias. Call the GetFunction or the GetAlias API to retrieve the
//   latest RevisionId for your resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/RemoveLayerVersionPermission
func (c *Lambda) RemoveLayerVersionPermission(input *RemoveLayerVersionPermissionInput) (*RemoveLayerVersionPermissionOutput, error) {
	req, out := c.RemoveLayerVersionPermissionRequest(input)
	return out, req.Send()
}

// RemoveLayerVersionPermissionWithContext is the same as RemoveLayerVersionPermission with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveLayerVersionPermission for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) RemoveLayerVersionPermissionWithContext(ctx aws.Context, input *RemoveLayerVersionPermissionInput, opts ...request.Option) (*RemoveLayerVersionPermissionOutput, error) {
	req, out := c.RemoveLayerVersionPermissionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemovePermission = "RemovePermission"

// RemovePermissionRequest generates a "aws/request.Request" representing the
// client's request for the RemovePermission operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemovePermission for more information on using the RemovePermission
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RemovePermissionRequest method.
//    req, resp := client.RemovePermissionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/RemovePermission
func (c *Lambda) RemovePermissionRequest(input *RemovePermissionInput) (req *request.Request, output *RemovePermissionOutput) {
	op := &request.Operation{
		Name:       opRemovePermission,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}/policy/{StatementId}",
	}

	if input == nil {
		input = &RemovePermissionInput{}
	}

	output = &RemovePermissionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RemovePermission API operation for AWS Lambda.
//
// Revokes function-use permission from an AWS service or another account. You
// can get the ID of the statement from the output of GetPolicy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation RemovePermission for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   The AWS Lambda service encountered an internal error.
//
//   * ResourceNotFoundException
//   The resource specified in the request does not exist.
//
//   * InvalidParameterValueException
//   One of the parameters in the request is invalid.
//
//   * TooManyRequestsException
//   The request throughput limit was exceeded.
//
//   * PreconditionFailedException
//   The RevisionId provided does not match the latest RevisionId for the Lambda
//   function or alias. Call the GetFunction or the GetAlias API to retrieve the
//   latest RevisionId for your resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/RemovePermission
func (c *Lambda) RemovePermission(input *RemovePermissionInput) (*RemovePermissionOutput, error) {
	req, out := c.RemovePermissionRequest(input)
	return out, req.Send()
}

// RemovePermissionWithContext is the same as RemovePermission with the addition of
// the ability to pass a context and additional request options.
//
// See RemovePermission for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) RemovePermissionWithContext(ctx aws.Context, input *RemovePermissionInput, opts ...request.Option) (*RemovePermissionOutput, error) {
	req, out := c.RemovePermissionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/TagResource
func (c *Lambda) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/2017-03-31/tags/{ARN}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS Lambda.
//
// Adds tags (https://docs.aws.amazon.com/lambda/latest/dg/tagging.html) to
// a function.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   The AWS Lambda service encountered an internal error.
//
//   * ResourceNotFoundException
//   The resource specified in the request does not exist.
//
//   * InvalidParameterValueException
//   One of the parameters in the request is invalid.
//
//   * TooManyRequestsException
//   The request throughput limit was exceeded.
//
//   * ResourceConflictException
//   The resource already exists, or another operation is in progress.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/TagResource
func (c *Lambda) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UntagResource
func (c *Lambda) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2017-03-31/tags/{ARN}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS Lambda.
//
// Removes tags (https://docs.aws.amazon.com/lambda/latest/dg/tagging.html)
// from a function.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   The AWS Lambda service encountered an internal error.
//
//   * ResourceNotFoundException
//   The resource specified in the request does not exist.
//
//   * InvalidParameterValueException
//   One of the parameters in the request is invalid.
//
//   * TooManyRequestsException
//   The request throughput limit was exceeded.
//
//   * ResourceConflictException
//   The resource already exists, or another operation is in progress.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UntagResource
func (c *Lambda) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAlias = "UpdateAlias"

// UpdateAliasRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAlias for more information on using the UpdateAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateAliasRequest method.
//    req, resp := client.UpdateAliasRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateAlias
func (c *Lambda) UpdateAliasRequest(input *UpdateAliasInput) (req *request.Request, output *AliasConfiguration) {
	op := &request.Operation{
		Name:       opUpdateAlias,
		HTTPMethod: "PUT",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}/aliases/{Name}",
	}

	if input == nil {
		input = &UpdateAliasInput{}
	}

	output = &AliasConfiguration{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAlias API operation for AWS Lambda.
//
// Updates the configuration of a Lambda function alias (https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation UpdateAlias for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   The AWS Lambda service encountered an internal error.
//
//   * ResourceNotFoundException
//   The resource specified in the request does not exist.
//
//   * InvalidParameterValueException
//   One of the parameters in the request is invalid.
//
//   * TooManyRequestsException
//   The request throughput limit was exceeded.
//
//   * PreconditionFailedException
//   The RevisionId provided does not match the latest RevisionId for the Lambda
//   function or alias. Call the GetFunction or the GetAlias API to retrieve the
//   latest RevisionId for your resource.
//
//   * ResourceConflictException
//   The resource already exists, or another operation is in progress.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateAlias
func (c *Lambda) UpdateAlias(input *UpdateAliasInput) (*AliasConfiguration, error) {
	req, out := c.UpdateAliasRequest(input)
	return out, req.Send()
}

// UpdateAliasWithContext is the same as UpdateAlias with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) UpdateAliasWithContext(ctx aws.Context, input *UpdateAliasInput, opts ...request.Option) (*AliasConfiguration, error) {
	req, out := c.UpdateAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateEventSourceMapping = "UpdateEventSourceMapping"

// UpdateEventSourceMappingRequest generates a "aws/request.Request" representing the
// client's request for the UpdateEventSourceMapping operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateEventSourceMapping for more information on using the UpdateEventSourceMapping
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateEventSourceMappingRequest method.
//    req, resp := client.UpdateEventSourceMappingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateEventSourceMapping
func (c *Lambda) UpdateEventSourceMappingRequest(input *UpdateEventSourceMappingInput) (req *request.Request, output *EventSourceMappingConfiguration) {
	op := &request.Operation{
		Name:       opUpdateEventSourceMapping,
		HTTPMethod: "PUT",
		HTTPPath:   "/2015-03-31/event-source-mappings/{UUID}",
	}

	if input == nil {
		input = &UpdateEventSourceMappingInput{}
	}

	output = &EventSourceMappingConfiguration{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateEventSourceMapping API operation for AWS Lambda.
//
// Updates an event source mapping. You can change the function that AWS Lambda
// invokes, or pause invocation and resume later from the same location.
//
// The following error handling options are only available for stream sources
// (DynamoDB and Kinesis):
//
//    * BisectBatchOnFunctionError - If the function returns an error, split
//    the batch in two and retry.
//
//    * DestinationConfig - Send discarded records to an Amazon SQS queue or
//    Amazon SNS topic.
//
//    * MaximumRecordAgeInSeconds - Discard records older than the specified
//    age.
//
//    * MaximumRetryAttempts - Discard records after the specified number of
//    retries.
//
//    * ParallelizationFactor - Process multiple batches from each shard concurrently.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation UpdateEventSourceMapping for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   The AWS Lambda service encountered an internal error.
//
//   * ResourceNotFoundException
//   The resource specified in the request does not exist.
//
//   * InvalidParameterValueException
//   One of the parameters in the request is invalid.
//
//   * TooManyRequestsException
//   The request throughput limit was exceeded.
//
//   * ResourceConflictException
//   The resource already exists, or another operation is in progress.
//
//   * ResourceInUseException
//   The operation conflicts with the resource's availability. For example, you
//   attempted to update an EventSource Mapping in CREATING, or tried to delete
//   a EventSource mapping currently in the UPDATING state.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateEventSourceMapping
func (c *Lambda) UpdateEventSourceMapping(input *UpdateEventSourceMappingInput) (*EventSourceMappingConfiguration, error) {
	req, out := c.UpdateEventSourceMappingRequest(input)
	return out, req.Send()
}

// UpdateEventSourceMappingWithContext is the same as UpdateEventSourceMapping with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateEventSourceMapping for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) UpdateEventSourceMappingWithContext(ctx aws.Context, input *UpdateEventSourceMappingInput, opts ...request.Option) (*EventSourceMappingConfiguration, error) {
	req, out := c.UpdateEventSourceMappingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateFunctionCode = "UpdateFunctionCode"

// UpdateFunctionCodeRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFunctionCode operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateFunctionCode for more information on using the UpdateFunctionCode
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateFunctionCodeRequest method.
//    req, resp := client.UpdateFunctionCodeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateFunctionCode
func (c *Lambda) UpdateFunctionCodeRequest(input *UpdateFunctionCodeInput) (req *request.Request, output *FunctionConfiguration) {
	op := &request.Operation{
		Name:       opUpdateFunctionCode,
		HTTPMethod: "PUT",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}/code",
	}

	if input == nil {
		input = &UpdateFunctionCodeInput{}
	}

	output = &FunctionConfiguration{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateFunctionCode API operation for AWS Lambda.
//
// Updates a Lambda function's code.
//
// The function's code is locked when you publish a version. You can't modify
// the code of a published version, only the unpublished version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation UpdateFunctionCode for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   The AWS Lambda service encountered an internal error.
//
//   * ResourceNotFoundException
//   The resource specified in the request does not exist.
//
//   * InvalidParameterValueException
//   One of the parameters in the request is invalid.
//
//   * TooManyRequestsException
//   The request throughput limit was exceeded.
//
//   * CodeStorageExceededException
//   You have exceeded your maximum total code size per account. Learn more (https://docs.aws.amazon.com/lambda/latest/dg/limits.html)
//
//   * PreconditionFailedException
//   The RevisionId provided does not match the latest RevisionId for the Lambda
//   function or alias. Call the GetFunction or the GetAlias API to retrieve the
//   latest RevisionId for your resource.
//
//   * ResourceConflictException
//   The resource already exists, or another operation is in progress.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateFunctionCode
func (c *Lambda) UpdateFunctionCode(input *UpdateFunctionCodeInput) (*FunctionConfiguration, error) {
	req, out := c.UpdateFunctionCodeRequest(input)
	return out, req.Send()
}

// UpdateFunctionCodeWithContext is the same as UpdateFunctionCode with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateFunctionCode for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) UpdateFunctionCodeWithContext(ctx aws.Context, input *UpdateFunctionCodeInput, opts ...request.Option) (*FunctionConfiguration, error) {
	req, out := c.UpdateFunctionCodeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateFunctionConfiguration = "UpdateFunctionConfiguration"

// UpdateFunctionConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFunctionConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateFunctionConfiguration for more information on using the UpdateFunctionConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateFunctionConfigurationRequest method.
//    req, resp := client.UpdateFunctionConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateFunctionConfiguration
func (c *Lambda) UpdateFunctionConfigurationRequest(input *UpdateFunctionConfigurationInput) (req *request.Request, output *FunctionConfiguration) {
	op := &request.Operation{
		Name:       opUpdateFunctionConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}/configuration",
	}

	if input == nil {
		input = &UpdateFunctionConfigurationInput{}
	}

	output = &FunctionConfiguration{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateFunctionConfiguration API operation for AWS Lambda.
//
// Modify the version-specific settings of a Lambda function.
//
// When you update a function, Lambda provisions an instance of the function
// and its supporting resources. If your function connects to a VPC, this process
// can take a minute. During this time, you can't modify the function, but you
// can still invoke it. The LastUpdateStatus, LastUpdateStatusReason, and LastUpdateStatusReasonCode
// fields in the response from GetFunctionConfiguration indicate when the update
// is complete and the function is processing events with the new configuration.
// For more information, see Function States (https://docs.aws.amazon.com/lambda/latest/dg/functions-states.html).
//
// These settings can vary between versions of a function and are locked when
// you publish a version. You can't modify the configuration of a published
// version, only the unpublished version.
//
// To configure function concurrency, use PutFunctionConcurrency. To grant invoke
// permissions to an account or AWS service, use AddPermission.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation UpdateFunctionConfiguration for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   The AWS Lambda service encountered an internal error.
//
//   * ResourceNotFoundException
//   The resource specified in the request does not exist.
//
//   * InvalidParameterValueException
//   One of the parameters in the request is invalid.
//
//   * TooManyRequestsException
//   The request throughput limit was exceeded.
//
//   * ResourceConflictException
//   The resource already exists, or another operation is in progress.
//
//   * PreconditionFailedException
//   The RevisionId provided does not match the latest RevisionId for the Lambda
//   function or alias. Call the GetFunction or the GetAlias API to retrieve the
//   latest RevisionId for your resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateFunctionConfiguration
func (c *Lambda) UpdateFunctionConfiguration(input *UpdateFunctionConfigurationInput) (*FunctionConfiguration, error) {
	req, out := c.UpdateFunctionConfigurationRequest(input)
	return out, req.Send()
}

// UpdateFunctionConfigurationWithContext is the same as UpdateFunctionConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateFunctionConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) UpdateFunctionConfigurationWithContext(ctx aws.Context, input *UpdateFunctionConfigurationInput, opts ...request.Option) (*FunctionConfiguration, error) {
	req, out := c.UpdateFunctionConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateFunctionEventInvokeConfig = "UpdateFunctionEventInvokeConfig"

// UpdateFunctionEventInvokeConfigRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFunctionEventInvokeConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateFunctionEventInvokeConfig for more information on using the UpdateFunctionEventInvokeConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateFunctionEventInvokeConfigRequest method.
//    req, resp := client.UpdateFunctionEventInvokeConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateFunctionEventInvokeConfig
func (c *Lambda) UpdateFunctionEventInvokeConfigRequest(input *UpdateFunctionEventInvokeConfigInput) (req *request.Request, output *UpdateFunctionEventInvokeConfigOutput) {
	op := &request.Operation{
		Name:       opUpdateFunctionEventInvokeConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/2019-09-25/functions/{FunctionName}/event-invoke-config",
	}

	if input == nil {
		input = &UpdateFunctionEventInvokeConfigInput{}
	}

	output = &UpdateFunctionEventInvokeConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateFunctionEventInvokeConfig API operation for AWS Lambda.
//
// Updates the configuration for asynchronous invocation for a function, version,
// or alias.
//
// To configure options for asynchronous invocation, use PutFunctionEventInvokeConfig.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation UpdateFunctionEventInvokeConfig for usage and error information.
//
// Returned Error Types:
//   * ServiceException
//   The AWS Lambda service encountered an internal error.
//
//   * ResourceNotFoundException
//   The resource specified in the request does not exist.
//
//   * InvalidParameterValueException
//   One of the parameters in the request is invalid.
//
//   * TooManyRequestsException
//   The request throughput limit was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateFunctionEventInvokeConfig
func (c *Lambda) UpdateFunctionEventInvokeConfig(input *UpdateFunctionEventInvokeConfigInput) (*UpdateFunctionEventInvokeConfigOutput, error) {
	req, out := c.UpdateFunctionEventInvokeConfigRequest(input)
	return out, req.Send()
}

// UpdateFunctionEventInvokeConfigWithContext is the same as UpdateFunctionEventInvokeConfig with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateFunctionEventInvokeConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lambda) UpdateFunctionEventInvokeConfigWithContext(ctx aws.Context, input *UpdateFunctionEventInvokeConfigInput, opts ...request.Option) (*UpdateFunctionEventInvokeConfigOutput, error) {
	req, out := c.UpdateFunctionEventInvokeConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Limits that are related to concurrency and storage. All file and storage
// sizes are in bytes.
type AccountLimit struct {
	_ struct{} `type:"structure"`

	// The maximum size of a function's deployment package and layers when they're
	// extracted.
	CodeSizeUnzipped *int64 `type:"long"`

	// The maximum size of a deployment package when it's uploaded directly to AWS
	// Lambda. Use Amazon S3 for larger files.
	CodeSizeZipped *int64 `type:"long"`

	// The maximum number of simultaneous function executions.
	ConcurrentExecutions *int64 `type:"integer"`

	// The amount of storage space that you can use for all deployment packages
	// and layer archives.
	TotalCodeSize *int64 `type:"long"`

	// The maximum number of simultaneous function executions, minus the capacity
	// that's reserved for individual functions with PutFunctionConcurrency.
	UnreservedConcurrentExecutions *int64 `type:"integer"`
}

// String returns the string representation
func (s AccountLimit) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccountLimit) GoString() string {
	return s.String()
}

// SetCodeSizeUnzipped sets the CodeSizeUnzipped field's value.
func (s *AccountLimit) SetCodeSizeUnzipped(v int64) *AccountLimit {
	s.CodeSizeUnzipped = &v
	return s
}

// SetCodeSizeZipped sets the CodeSizeZipped field's value.
func (s *AccountLimit) SetCodeSizeZipped(v int64) *AccountLimit {
	s.CodeSizeZipped = &v
	return s
}

// SetConcurrentExecutions sets the ConcurrentExecutions field's value.
func (s *AccountLimit) SetConcurrentExecutions(v int64) *AccountLimit {
	s.ConcurrentExecutions = &v
	return s
}

// SetTotalCodeSize sets the TotalCodeSize field's value.
func (s *AccountLimit) SetTotalCodeSize(v int64) *AccountLimit {
	s.TotalCodeSize = &v
	return s
}

// SetUnreservedConcurrentExecutions sets the UnreservedConcurrentExecutions field's value.
func (s *AccountLimit) SetUnreservedConcurrentExecutions(v int64) *AccountLimit {
	s.UnreservedConcurrentExecutions = &v
	return s
}

// The number of functions and amount of storage in use.
type AccountUsage struct {
	_ struct{} `type:"structure"`

	// The number of Lambda functions.
	FunctionCount *int64 `type:"long"`

	// The amount of storage space, in bytes, that's being used by deployment packages
	// and layer archives.
	TotalCodeSize *int64 `type:"long"`
}

// String returns the string representation
func (s AccountUsage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccountUsage) GoString() string {
	return s.String()
}

// SetFunctionCount sets the FunctionCount field's value.
func (s *AccountUsage) SetFunctionCount(v int64) *AccountUsage {
	s.FunctionCount = &v
	return s
}

// SetTotalCodeSize sets the TotalCodeSize field's value.
func (s *AccountUsage) SetTotalCodeSize(v int64) *AccountUsage {
	s.TotalCodeSize = &v
	return s
}

type AddLayerVersionPermissionInput struct {
	_ struct{} `type:"structure"`

	// The API action that grants access to the layer. For example, lambda:GetLayerVersion.
	//
	// Action is a required field
	Action *string `type:"string" required:"true"`

	// The name or Amazon Resource Name (ARN) of the layer.
	//
	// LayerName is a required field
	LayerName *string `location:"uri" locationName:"LayerName" min:"1" type:"string" required:"true"`

	// With the principal set to *, grant permission to all accounts in the specified
	// organization.
	OrganizationId *string `type:"string"`

	// An account ID, or * to grant permission to all AWS accounts.
	//
	// Principal is a required field
	Principal *string `type:"string" required:"true"`

	// Only update the policy if the revision ID matches the ID specified. Use this
	// option to avoid modifying a policy that has changed since you last read it.
	RevisionId *string `location:"querystring" locationName:"RevisionId" type:"string"`

	// An identifier that distinguishes the policy from others on the same layer
	// version.
	//
	// StatementId is a required field
	StatementId *string `min:"1" type:"string" required:"true"`

	// The version number.
	//
	// VersionNumber is a required field
	VersionNumber *int64 `location:"uri" locationName:"VersionNumber" type:"long" required:"true"`
}

// String returns the string representation
func (s AddLayerVersionPermissionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddLayerVersionPermissionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddLayerVersionPermissionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddLayerVersionPermissionInput"}
	if s.Action == nil {
		invalidParams.Add(request.NewErrParamRequired("Action"))
	}
	if s.LayerName == nil {
		invalidParams.Add(request.NewErrParamRequired("LayerName"))
	}
	if s.LayerName != nil && len(*s.LayerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LayerName", 1))
	}
	if s.Principal == nil {
		invalidParams.Add(request.NewErrParamRequired("Principal"))
	}
	if s.StatementId == nil {
		invalidParams.Add(request.NewErrParamRequired("StatementId"))
	}
	if s.StatementId != nil && len(*s.StatementId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StatementId", 1))
	}
	if s.VersionNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("VersionNumber"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *AddLayerVersionPermissionInput) SetAction(v string) *AddLayerVersionPermissionInput {
	s.Action = &v
	return s
}

// SetLayerName sets the LayerName field's value.
func (s *AddLayerVersionPermissionInput) SetLayerName(v string) *AddLayerVersionPermissionInput {
	s.LayerName = &v
	return s
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *AddLayerVersionPermissionInput) SetOrganizationId(v string) *AddLayerVersionPermissionInput {
	s.OrganizationId = &v
	return s
}

// SetPrincipal sets the Principal field's value.
func (s *AddLayerVersionPermissionInput) SetPrincipal(v string) *AddLayerVersionPermissionInput {
	s.Principal = &v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *AddLayerVersionPermissionInput) SetRevisionId(v string) *AddLayerVersionPermissionInput {
	s.RevisionId = &v
	return s
}

// SetStatementId sets the StatementId field's value.
func (s *AddLayerVersionPermissionInput) SetStatementId(v string) *AddLayerVersionPermissionInput {
	s.StatementId = &v
	return s
}

// SetVersionNumber sets the VersionNumber field's value.
func (s *AddLayerVersionPermissionInput) SetVersionNumber(v int64) *AddLayerVersionPermissionInput {
	s.VersionNumber = &v
	return s
}

type AddLayerVersionPermissionOutput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the current revision of the policy.
	RevisionId *string `type:"string"`

	// The permission statement.
	Statement *string `type:"string"`
}

// String returns the string representation
func (s AddLayerVersionPermissionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddLayerVersionPermissionOutput) GoString() string {
	return s.String()
}

// SetRevisionId sets the RevisionId field's value.
func (s *AddLayerVersionPermissionOutput) SetRevisionId(v string) *AddLayerVersionPermissionOutput {
	s.RevisionId = &v
	return s
}

// SetStatement sets the Statement field's value.
func (s *AddLayerVersionPermissionOutput) SetStatement(v string) *AddLayerVersionPermissionOutput {
	s.Statement = &v
	return s
}

type AddPermissionInput struct {
	_ struct{} `type:"structure"`

	// The action that the principal can use on the function. For example, lambda:InvokeFunction
	// or lambda:GetFunction.
	//
	// Action is a required field
	Action *string `type:"string" required:"true"`

	// For Alexa Smart Home functions, a token that must be supplied by the invoker.
	EventSourceToken *string `type:"string"`

	// The name of the Lambda function, version, or alias.
	//
	// Name formats
	//
	//    * Function name - my-function (name-only), my-function:v1 (with alias).
	//
	//    * Function ARN - arn:aws:lambda:us-west-2:123456789012:function:my-function.
	//
	//    * Partial ARN - 123456789012:function:my-function.
	//
	// You can append a version number or alias to any of the formats. The length
	// constraint applies only to the full ARN. If you specify only the function
	// name, it is limited to 64 characters in length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// The AWS service or account that invokes the function. If you specify a service,
	// use SourceArn or SourceAccount to limit who can invoke the function through
	// that service.
	//
	// Principal is a required field
	Principal *string `type:"string" required:"true"`

	// Specify a version or alias to add permissions to a published version of the
	// function.
	Qualifier *string `location:"querystring" locationName:"Qualifier" min:"1" type:"string"`

	// Only update the policy if the revision ID matches the ID that's specified.
	// Use this option to avoid modifying a policy that has changed since you last
	// read it.
	RevisionId *string `type:"string"`

	// For Amazon S3, the ID of the account that owns the resource. Use this together
	// with SourceArn to ensure that the resource is owned by the specified account.
	// It is possible for an Amazon S3 bucket to be deleted by its owner and recreated
	// by another account.
	SourceAccount *string `type:"string"`

	// For AWS services, the ARN of the AWS resource that invokes the function.
	// For example, an Amazon S3 bucket or Amazon SNS topic.
	SourceArn *string `type:"string"`

	// A statement identifier that differentiates the statement from others in the
	// same policy.
	//
	// StatementId is a required field
	StatementId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AddPermissionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddPermissionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddPermissionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddPermissionInput"}
	if s.Action == nil {
		invalidParams.Add(request.NewErrParamRequired("Action"))
	}
	if s.FunctionName == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}
	if s.Principal == nil {
		invalidParams.Add(request.NewErrParamRequired("Principal"))
	}
	if s.Qualifier != nil && len(*s.Qualifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Qualifier", 1))
	}
	if s.StatementId == nil {
		invalidParams.Add(request.NewErrParamRequired("StatementId"))
	}
	if s.StatementId != nil && len(*s.StatementId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StatementId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *AddPermissionInput) SetAction(v string) *AddPermissionInput {
	s.Action = &v
	return s
}

// SetEventSourceToken sets the EventSourceToken field's value.
func (s *AddPermissionInput) SetEventSourceToken(v string) *AddPermissionInput {
	s.EventSourceToken = &v
	return s
}

// SetFunctionName sets the FunctionName field's value.
func (s *AddPermissionInput) SetFunctionName(v string) *AddPermissionInput {
	s.FunctionName = &v
	return s
}

// SetPrincipal sets the Principal field's value.
func (s *AddPermissionInput) SetPrincipal(v string) *AddPermissionInput {
	s.Principal = &v
	return s
}

// SetQualifier sets the Qualifier field's value.
func (s *AddPermissionInput) SetQualifier(v string) *AddPermissionInput {
	s.Qualifier = &v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *AddPermissionInput) SetRevisionId(v string) *AddPermissionInput {
	s.RevisionId = &v
	return s
}

// SetSourceAccount sets the SourceAccount field's value.
func (s *AddPermissionInput) SetSourceAccount(v string) *AddPermissionInput {
	s.SourceAccount = &v
	return s
}

// SetSourceArn sets the SourceArn field's value.
func (s *AddPermissionInput) SetSourceArn(v string) *AddPermissionInput {
	s.SourceArn = &v
	return s
}

// SetStatementId sets the StatementId field's value.
func (s *AddPermissionInput) SetStatementId(v string) *AddPermissionInput {
	s.StatementId = &v
	return s
}

type AddPermissionOutput struct {
	_ struct{} `type:"structure"`

	// The permission statement that's added to the function policy.
	Statement *string `type:"string"`
}

// String returns the string representation
func (s AddPermissionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddPermissionOutput) GoString() string {
	return s.String()
}

// SetStatement sets the Statement field's value.
func (s *AddPermissionOutput) SetStatement(v string) *AddPermissionOutput {
	s.Statement = &v
	return s
}

// Provides configuration information about a Lambda function alias (https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html).
type AliasConfiguration struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the alias.
	AliasArn *string `type:"string"`

	// A description of the alias.
	Description *string `type:"string"`

	// The function version that the alias invokes.
	FunctionVersion *string `min:"1" type:"string"`

	// The name of the alias.
	Name *string `min:"1" type:"string"`

	// A unique identifier that changes when you update the alias.
	RevisionId *string `type:"string"`

	// The routing configuration (https://docs.aws.amazon.com/lambda/latest/dg/lambda-traffic-shifting-using-aliases.html)
	// of the alias.
	RoutingConfig *AliasRoutingConfiguration `type:"structure"`
}

// String returns the string representation
func (s AliasConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AliasConfiguration) GoString() string {
	return s.String()
}

// SetAliasArn sets the AliasArn field's value.
func (s *AliasConfiguration) SetAliasArn(v string) *AliasConfiguration {
	s.AliasArn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AliasConfiguration) SetDescription(v string) *AliasConfiguration {
	s.Description = &v
	return s
}

// SetFunctionVersion sets the FunctionVersion field's value.
func (s *AliasConfiguration) SetFunctionVersion(v string) *AliasConfiguration {
	s.FunctionVersion = &v
	return s
}

// SetName sets the Name field's value.
func (s *AliasConfiguration) SetName(v string) *AliasConfiguration {
	s.Name = &v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *AliasConfiguration) SetRevisionId(v string) *AliasConfiguration {
	s.RevisionId = &v
	return s
}

// SetRoutingConfig sets the RoutingConfig field's value.
func (s *AliasConfiguration) SetRoutingConfig(v *AliasRoutingConfiguration) *AliasConfiguration {
	s.RoutingConfig = v
	return s
}

// The traffic-shifting (https://docs.aws.amazon.com/lambda/latest/dg/lambda-traffic-shifting-using-aliases.html)
// configuration of a Lambda function alias.
type AliasRoutingConfiguration struct {
	_ struct{} `type:"structure"`

	// The name of the second alias, and the percentage of traffic that's routed
	// to it.
	AdditionalVersionWeights map[string]*float64 `type:"map"`
}

// String returns the string representation
func (s AliasRoutingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AliasRoutingConfiguration) GoString() string {
	return s.String()
}

// SetAdditionalVersionWeights sets the AdditionalVersionWeights field's value.
func (s *AliasRoutingConfiguration) SetAdditionalVersionWeights(v map[string]*float64) *AliasRoutingConfiguration {
	s.AdditionalVersionWeights = v
	return s
}

// You have exceeded your maximum total code size per account. Learn more (https://docs.aws.amazon.com/lambda/latest/dg/limits.html)
type CodeStorageExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The exception type.
	Type *string `type:"string"`
}

// String returns the string representation
func (s CodeStorageExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CodeStorageExceededException) GoString() string {
	return s.String()
}

func newErrorCodeStorageExceededException(v protocol.ResponseMetadata) error {
	return &CodeStorageExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *CodeStorageExceededException) Code() string {
	return "CodeStorageExceededException"
}

// Message returns the exception's message.
func (s *CodeStorageExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *CodeStorageExceededException) OrigErr() error {
	return nil
}

func (s *CodeStorageExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *CodeStorageExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *CodeStorageExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateAliasInput struct {
	_ struct{} `type:"structure"`

	// A description of the alias.
	Description *string `type:"string"`

	// The name of the Lambda function.
	//
	// Name formats
	//
	//    * Function name - MyFunction.
	//
	//    * Function ARN - arn:aws:lambda:us-west-2:123456789012:function:MyFunction.
	//
	//    * Partial ARN - 123456789012:function:MyFunction.
	//
	// The length constraint applies only to the full ARN. If you specify only the
	// function name, it is limited to 64 characters in length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// The function version that the alias invokes.
	//
	// FunctionVersion is a required field
	FunctionVersion *string `min:"1" type:"string" required:"true"`

	// The name of the alias.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The routing configuration (https://docs.aws.amazon.com/lambda/latest/dg/lambda-traffic-shifting-using-aliases.html)
	// of the alias.
	RoutingConfig *AliasRoutingConfiguration `type:"structure"`
}

// String returns the string representation
func (s CreateAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAliasInput"}
	if s.FunctionName == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}
	if s.FunctionVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionVersion"))
	}
	if s.FunctionVersion != nil && len(*s.FunctionVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionVersion", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateAliasInput) SetDescription(v string) *CreateAliasInput {
	s.Description = &v
	return s
}

// SetFunctionName sets the FunctionName field's value.
func (s *CreateAliasInput) SetFunctionName(v string) *CreateAliasInput {
	s.FunctionName = &v
	return s
}

// SetFunctionVersion sets the FunctionVersion field's value.
func (s *CreateAliasInput) SetFunctionVersion(v string) *CreateAliasInput {
	s.FunctionVersion = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateAliasInput) SetName(v string) *CreateAliasInput {
	s.Name = &v
	return s
}

// SetRoutingConfig sets the RoutingConfig field's value.
func (s *CreateAliasInput) SetRoutingConfig(v *AliasRoutingConfiguration) *CreateAliasInput {
	s.RoutingConfig = v
	return s
}

type CreateEventSourceMappingInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of items to retrieve in a single batch.
	//
	//    * Amazon Kinesis - Default 100. Max 10,000.
	//
	//    * Amazon DynamoDB Streams - Default 100. Max 1,000.
	//
	//    * Amazon Simple Queue Service - Default 10. Max 10.
	BatchSize *int64 `min:"1" type:"integer"`

	// (Streams) If the function returns an error, split the batch in two and retry.
	BisectBatchOnFunctionError *bool `type:"boolean"`

	// (Streams) An Amazon SQS queue or Amazon SNS topic destination for discarded
	// records.
	DestinationConfig *DestinationConfig `type:"structure"`

	// Disables the event source mapping to pause polling and invocation.
	Enabled *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) of the event source.
	//
	//    * Amazon Kinesis - The ARN of the data stream or a stream consumer.
	//
	//    * Amazon DynamoDB Streams - The ARN of the stream.
	//
	//    * Amazon Simple Queue Service - The ARN of the queue.
	//
	// EventSourceArn is a required field
	EventSourceArn *string `type:"string" required:"true"`

	// The name of the Lambda function.
	//
	// Name formats
	//
	//    * Function name - MyFunction.
	//
	//    * Function ARN - arn:aws:lambda:us-west-2:123456789012:function:MyFunction.
	//
	//    * Version or Alias ARN - arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD.
	//
	//    * Partial ARN - 123456789012:function:MyFunction.
	//
	// The length constraint applies only to the full ARN. If you specify only the
	// function name, it's limited to 64 characters in length.
	//
	// FunctionName is a required field
	FunctionName *string `min:"1" type:"string" required:"true"`

	// (Streams) The maximum amount of time to gather records before invoking the
	// function, in seconds.
	MaximumBatchingWindowInSeconds *int64 `type:"integer"`

	// (Streams) The maximum age of a record that Lambda sends to a function for
	// processing.
	MaximumRecordAgeInSeconds *int64 `min:"60" type:"integer"`

	// (Streams) The maximum number of times to retry when the function returns
	// an error.
	MaximumRetryAttempts *int64 `type:"integer"`

	// (Streams) The number of batches to process from each shard concurrently.
	ParallelizationFactor *int64 `min:"1" type:"integer"`

	// The position in a stream from which to start reading. Required for Amazon
	// Kinesis and Amazon DynamoDB Streams sources. AT_TIMESTAMP is only supported
	// for Amazon Kinesis streams.
	StartingPosition *string `type:"string" enum:"EventSourcePosition"`

	// With StartingPosition set to AT_TIMESTAMP, the time from which to start reading.
	StartingPositionTimestamp *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s CreateEventSourceMappingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateEventSourceMappingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEventSourceMappingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateEventSourceMappingInput"}
	if s.BatchSize != nil && *s.BatchSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("BatchSize", 1))
	}
	if s.EventSourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EventSourceArn"))
	}
	if s.FunctionName == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}
	if s.MaximumRecordAgeInSeconds != nil && *s.MaximumRecordAgeInSeconds < 60 {
		invalidParams.Add(request.NewErrParamMinValue("MaximumRecordAgeInSeconds", 60))
	}
	if s.ParallelizationFactor != nil && *s.ParallelizationFactor < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ParallelizationFactor", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBatchSize sets the BatchSize field's value.
func (s *CreateEventSourceMappingInput) SetBatchSize(v int64) *CreateEventSourceMappingInput {
	s.BatchSize = &v
	return s
}

// SetBisectBatchOnFunctionError sets the BisectBatchOnFunctionError field's value.
func (s *CreateEventSourceMappingInput) SetBisectBatchOnFunctionError(v bool) *CreateEventSourceMappingInput {
	s.BisectBatchOnFunctionError = &v
	return s
}

// SetDestinationConfig sets the DestinationConfig field's value.
func (s *CreateEventSourceMappingInput) SetDestinationConfig(v *DestinationConfig) *CreateEventSourceMappingInput {
	s.DestinationConfig = v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *CreateEventSourceMappingInput) SetEnabled(v bool) *CreateEventSourceMappingInput {
	s.Enabled = &v
	return s
}

// SetEventSourceArn sets the EventSourceArn field's value.
func (s *CreateEventSourceMappingInput) SetEventSourceArn(v string) *CreateEventSourceMappingInput {
	s.EventSourceArn = &v
	return s
}

// SetFunctionName sets the FunctionName field's value.
func (s *CreateEventSourceMappingInput) SetFunctionName(v string) *CreateEventSourceMappingInput {
	s.FunctionName = &v
	return s
}

// SetMaximumBatchingWindowInSeconds sets the MaximumBatchingWindowInSeconds field's value.
func (s *CreateEventSourceMappingInput) SetMaximumBatchingWindowInSeconds(v int64) *CreateEventSourceMappingInput {
	s.MaximumBatchingWindowInSeconds = &v
	return s
}

// SetMaximumRecordAgeInSeconds sets the MaximumRecordAgeInSeconds field's value.
func (s *CreateEventSourceMappingInput) SetMaximumRecordAgeInSeconds(v int64) *CreateEventSourceMappingInput {
	s.MaximumRecordAgeInSeconds = &v
	return s
}

// SetMaximumRetryAttempts sets the MaximumRetryAttempts field's value.
func (s *CreateEventSourceMappingInput) SetMaximumRetryAttempts(v int64) *CreateEventSourceMappingInput {
	s.MaximumRetryAttempts = &v
	return s
}

// SetParallelizationFactor sets the ParallelizationFactor field's value.
func (s *CreateEventSourceMappingInput) SetParallelizationFactor(v int64) *CreateEventSourceMappingInput {
	s.ParallelizationFactor = &v
	return s
}

// SetStartingPosition sets the StartingPosition field's value.
func (s *CreateEventSourceMappingInput) SetStartingPosition(v string) *CreateEventSourceMappingInput {
	s.StartingPosition = &v
	return s
}

// SetStartingPositionTimestamp sets the StartingPositionTimestamp field's value.
func (s *CreateEventSourceMappingInput) SetStartingPositionTimestamp(v time.Time) *CreateEventSourceMappingInput {
	s.StartingPositionTimestamp = &v
	return s
}

type CreateFunctionInput struct {
	_ struct{} `type:"structure"`

	// The code for the function.
	//
	// Code is a required field
	Code *FunctionCode `type:"structure" required:"true"`

	// A dead letter queue configuration that specifies the queue or topic where
	// Lambda sends asynchronous events when they fail processing. For more information,
	// see Dead Letter Queues (https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#dlq).
	DeadLetterConfig *DeadLetterConfig `type:"structure"`

	// A description of the function.
	Description *string `type:"string"`

	// Environment variables that are accessible from function code during execution.
	Environment *Environment `type:"structure"`

	// The name of the Lambda function.
	//
	// Name formats
	//
	//    * Function name - my-function.
	//
	//    * Function ARN - arn:aws:lambda:us-west-2:123456789012:function:my-function.
	//
	//    * Partial ARN - 123456789012:function:my-function.
	//
	// The length constraint applies only to the full ARN. If you specify only the
	// function name, it is limited to 64 characters in length.
	//
	// FunctionName is a required field
	FunctionName *string `min:"1" type:"string" required:"true"`

	// The name of the method within your code that Lambda calls to execute your
	// function. The format includes the file name. It can also include namespaces
	// and other qualifiers, depending on the runtime. For more information, see
	// Programming Model (https://docs.aws.amazon.com/lambda/latest/dg/programming-model-v2.html).
	//
	// Handler is a required field
	Handler *string `type:"string" required:"true"`

	// The ARN of the AWS Key Management Service (AWS KMS) key that's used to encrypt
	// your function's environment variables. If it's not provided, AWS Lambda uses
	// a default service key.
	KMSKeyArn *string `type:"string"`

	// A list of function layers (https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html)
	// to add to the function's execution environment. Specify each layer by its
	// ARN, including the version.
	Layers []*string `type:"list"`

	// The amount of memory that your function has access to. Increasing the function's
	// memory also increases its CPU allocation. The default value is 128 MB. The
	// value must be a multiple of 64 MB.
	MemorySize *int64 `min:"128" type:"integer"`

	// Set to true to publish the first version of the function during creation.
	Publish *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) of the function's execution role.
	//
	// Role is a required field
	Role *string `type:"string" required:"true"`

	// The identifier of the function's runtime (https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html).
	//
	// Runtime is a required field
	Runtime *string `type:"string" required:"true" enum:"Runtime"`

	// A list of tags (https://docs.aws.amazon.com/lambda/latest/dg/tagging.html)
	// to apply to the function.
	Tags map[string]*string `type:"map"`

	// The amount of time that Lambda allows a function to run before stopping it.
	// The default is 3 seconds. The maximum allowed value is 900 seconds.
	Timeout *int64 `min:"1" type:"integer"`

	// Set Mode to Active to sample and trace a subset of incoming requests with
	// AWS X-Ray.
	TracingConfig *TracingConfig `type:"structure"`

	// For network connectivity to AWS resources in a VPC, specify a list of security
	// groups and subnets in the VPC. When you connect a function to a VPC, it can
	// only access resources and the internet through that VPC. For more information,
	// see VPC Settings (https://docs.aws.amazon.com/lambda/latest/dg/configuration-vpc.html).
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation
func (s CreateFunctionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFunctionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFunctionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateFunctionInput"}
	if s.Code == nil {
		invalidParams.Add(request.NewErrParamRequired("Code"))
	}
	if s.FunctionName == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}
	if s.Handler == nil {
		invalidParams.Add(request.NewErrParamRequired("Handler"))
	}
	if s.MemorySize != nil && *s.MemorySize < 128 {
		invalidParams.Add(request.NewErrParamMinValue("MemorySize", 128))
	}
	if s.Role == nil {
		invalidParams.Add(request.NewErrParamRequired("Role"))
	}
	if s.Runtime == nil {
		invalidParams.Add(request.NewErrParamRequired("Runtime"))
	}
	if s.Timeout != nil && *s.Timeout < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Timeout", 1))
	}
	if s.Code != nil {
		if err := s.Code.Validate(); err != nil {
			invalidParams.AddNested("Code", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCode sets the Code field's value.
func (s *CreateFunctionInput) SetCode(v *FunctionCode) *CreateFunctionInput {
	s.Code = v
	return s
}

// SetDeadLetterConfig sets the DeadLetterConfig field's value.
func (s *CreateFunctionInput) SetDeadLetterConfig(v *DeadLetterConfig) *CreateFunctionInput {
	s.DeadLetterConfig = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateFunctionInput) SetDescription(v string) *CreateFunctionInput {
	s.Description = &v
	return s
}

// SetEnvironment sets the Environment field's value.
func (s *CreateFunctionInput) SetEnvironment(v *Environment) *CreateFunctionInput {
	s.Environment = v
	return s
}

// SetFunctionName sets the FunctionName field's value.
func (s *CreateFunctionInput) SetFunctionName(v string) *CreateFunctionInput {
	s.FunctionName = &v
	return s
}

// SetHandler sets the Handler field's value.
func (s *CreateFunctionInput) SetHandler(v string) *CreateFunctionInput {
	s.Handler = &v
	return s
}

// SetKMSKeyArn sets the KMSKeyArn field's value.
func (s *CreateFunctionInput) SetKMSKeyArn(v string) *CreateFunctionInput {
	s.KMSKeyArn = &v
	return s
}

// SetLayers sets the Layers field's value.
func (s *CreateFunctionInput) SetLayers(v []*string) *CreateFunctionInput {
	s.Layers = v
	return s
}

// SetMemorySize sets the MemorySize field's value.
func (s *CreateFunctionInput) SetMemorySize(v int64) *CreateFunctionInput {
	s.MemorySize = &v
	return s
}

// SetPublish sets the Publish field's value.
func (s *CreateFunctionInput) SetPublish(v bool) *CreateFunctionInput {
	s.Publish = &v
	return s
}

// SetRole sets the Role field's value.
func (s *CreateFunctionInput) SetRole(v string) *CreateFunctionInput {
	s.Role = &v
	return s
}

// SetRuntime sets the Runtime field's value.
func (s *CreateFunctionInput) SetRuntime(v string) *CreateFunctionInput {
	s.Runtime = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateFunctionInput) SetTags(v map[string]*string) *CreateFunctionInput {
	s.Tags = v
	return s
}

// SetTimeout sets the Timeout field's value.
func (s *CreateFunctionInput) SetTimeout(v int64) *CreateFunctionInput {
	s.Timeout = &v
	return s
}

// SetTracingConfig sets the TracingConfig field's value.
func (s *CreateFunctionInput) SetTracingConfig(v *TracingConfig) *CreateFunctionInput {
	s.TracingConfig = v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *CreateFunctionInput) SetVpcConfig(v *VpcConfig) *CreateFunctionInput {
	s.VpcConfig = v
	return s
}

// The dead-letter queue (https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#dlq)
// for failed asynchronous invocations.
type DeadLetterConfig struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of an Amazon SQS queue or Amazon SNS topic.
	TargetArn *string `type:"string"`
}

// String returns the string representation
func (s DeadLetterConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeadLetterConfig) GoString() string {
	return s.String()
}

// SetTargetArn sets the TargetArn field's value.
func (s *DeadLetterConfig) SetTargetArn(v string) *DeadLetterConfig {
	s.TargetArn = &v
	return s
}

type DeleteAliasInput struct {
	_ struct{} `type:"structure"`

	// The name of the Lambda function.
	//
	// Name formats
	//
	//    * Function name - MyFunction.
	//
	//    * Function ARN - arn:aws:lambda:us-west-2:123456789012:function:MyFunction.
	//
	//    * Partial ARN - 123456789012:function:MyFunction.
	//
	// The length constraint applies only to the full ARN. If you specify only the
	// function name, it is limited to 64 characters in length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// The name of the alias.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"Name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAliasInput"}
	if s.FunctionName == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFunctionName sets the FunctionName field's value.
func (s *DeleteAliasInput) SetFunctionName(v string) *DeleteAliasInput {
	s.FunctionName = &v
	return s
}

// SetName sets the Name field's value.
func (s *DeleteAliasInput) SetName(v string) *DeleteAliasInput {
	s.Name = &v
	return s
}

type DeleteAliasOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAliasOutput) GoString() string {
	return s.String()
}

type DeleteEventSourceMappingInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the event source mapping.
	//
	// UUID is a required field
	UUID *string `location:"uri" locationName:"UUID" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteEventSourceMappingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEventSourceMappingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEventSourceMappingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEventSourceMappingInput"}
	if s.UUID == nil {
		invalidParams.Add(request.NewErrParamRequired("UUID"))
	}
	if s.UUID != nil && len(*s.UUID) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UUID", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUUID sets the UUID field's value.
func (s *DeleteEventSourceMappingInput) SetUUID(v string) *DeleteEventSourceMappingInput {
	s.UUID = &v
	return s
}

type DeleteFunctionConcurrencyInput struct {
	_ struct{} `type:"structure"`

	// The name of the Lambda function.
	//
	// Name formats
	//
	//    * Function name - my-function.
	//
	//    * Function ARN - arn:aws:lambda:us-west-2:123456789012:function:my-function.
	//
	//    * Partial ARN - 123456789012:function:my-function.
	//
	// The length constraint applies only to the full ARN. If you specify only the
	// function name, it is limited to 64 characters in length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteFunctionConcurrencyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFunctionConcurrencyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFunctionConcurrencyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteFunctionConcurrencyInput"}
	if s.FunctionName == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFunctionName sets the FunctionName field's value.
func (s *DeleteFunctionConcurrencyInput) SetFunctionName(v string) *DeleteFunctionConcurrencyInput {
	s.FunctionName = &v
	return s
}

type DeleteFunctionConcurrencyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteFunctionConcurrencyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFunctionConcurrencyOutput) GoString() string {
	return s.String()
}

type DeleteFunctionEventInvokeConfigInput struct {
	_ struct{} `type:"structure"`

	// The name of the Lambda function, version, or alias.
	//
	// Name formats
	//
	//    * Function name - my-function (name-only), my-function:v1 (with alias).
	//
	//    * Function ARN - arn:aws:lambda:us-west-2:123456789012:function:my-function.
	//
	//    * Partial ARN - 123456789012:function:my-function.
	//
	// You can append a version number or alias to any of the formats. The length
	// constraint applies only to the full ARN. If you specify only the function
	// name, it is limited to 64 characters in length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// A version number or alias name.
	Qualifier *string `location:"querystring" locationName:"Qualifier" min:"1" type:"string"`
}

// String returns the string representation
func (s DeleteFunctionEventInvokeConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFunctionEventInvokeConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFunctionEventInvokeConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteFunctionEventInvokeConfigInput"}
	if s.FunctionName == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}
	if s.Qualifier != nil && len(*s.Qualifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Qualifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFunctionName sets the FunctionName field's value.
func (s *DeleteFunctionEventInvokeConfigInput) SetFunctionName(v string) *DeleteFunctionEventInvokeConfigInput {
	s.FunctionName = &v
	return s
}

// SetQualifier sets the Qualifier field's value.
func (s *DeleteFunctionEventInvokeConfigInput) SetQualifier(v string) *DeleteFunctionEventInvokeConfigInput {
	s.Qualifier = &v
	return s
}

type DeleteFunctionEventInvokeConfigOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteFunctionEventInvokeConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFunctionEventInvokeConfigOutput) GoString() string {
	return s.String()
}

type DeleteFunctionInput struct {
	_ struct{} `type:"structure"`

	// The name of the Lambda function or version.
	//
	// Name formats
	//
	//    * Function name - my-function (name-only), my-function:1 (with version).
	//
	//    * Function ARN - arn:aws:lambda:us-west-2:123456789012:function:my-function.
	//
	//    * Partial ARN - 123456789012:function:my-function.
	//
	// You can append a version number or alias to any of the formats. The length
	// constraint applies only to the full ARN. If you specify only the function
	// name, it is limited to 64 characters in length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// Specify a version to delete. You can't delete a version that's referenced
	// by an alias.
	Qualifier *string `location:"querystring" locationName:"Qualifier" min:"1" type:"string"`
}

// String returns the string representation
func (s DeleteFunctionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFunctionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFunctionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteFunctionInput"}
	if s.FunctionName == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}
	if s.Qualifier != nil && len(*s.Qualifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Qualifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFunctionName sets the FunctionName field's value.
func (s *DeleteFunctionInput) SetFunctionName(v string) *DeleteFunctionInput {
	s.FunctionName = &v
	return s
}

// SetQualifier sets the Qualifier field's value.
func (s *DeleteFunctionInput) SetQualifier(v string) *DeleteFunctionInput {
	s.Qualifier = &v
	return s
}

type DeleteFunctionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteFunctionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFunctionOutput) GoString() string {
	return s.String()
}

type DeleteLayerVersionInput struct {
	_ struct{} `type:"structure"`

	// The name or Amazon Resource Name (ARN) of the layer.
	//
	// LayerName is a required field
	LayerName *string `location:"uri" locationName:"LayerName" min:"1" type:"string" required:"true"`

	// The version number.
	//
	// VersionNumber is a required field
	VersionNumber *int64 `location:"uri" locationName:"VersionNumber" type:"long" required:"true"`
}

// String returns the string representation
func (s DeleteLayerVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteLayerVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteLayerVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteLayerVersionInput"}
	if s.LayerName == nil {
		invalidParams.Add(request.NewErrParamRequired("LayerName"))
	}
	if s.LayerName != nil && len(*s.LayerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LayerName", 1))
	}
	if s.VersionNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("VersionNumber"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLayerName sets the LayerName field's value.
func (s *DeleteLayerVersionInput) SetLayerName(v string) *DeleteLayerVersionInput {
	s.LayerName = &v
	return s
}

// SetVersionNumber sets the VersionNumber field's value.
func (s *DeleteLayerVersionInput) SetVersionNumber(v int64) *DeleteLayerVersionInput {
	s.VersionNumber = &v
	return s
}

type DeleteLayerVersionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteLayerVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteLayerVersionOutput) GoString() string {
	return s.String()
}

type DeleteProvisionedConcurrencyConfigInput struct {
	_ struct{} `type:"structure"`

	// The name of the Lambda function.
	//
	// Name formats
	//
	//    * Function name - my-function.
	//
	//    * Function ARN - arn:aws:lambda:us-west-2:123456789012:function:my-function.
	//
	//    * Partial ARN - 123456789012:function:my-function.
	//
	// The length constraint applies only to the full ARN. If you specify only the
	// function name, it is limited to 64 characters in length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// The version number or alias name.
	//
	// Qualifier is a required field
	Qualifier *string `location:"querystring" locationName:"Qualifier" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteProvisionedConcurrencyConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteProvisionedConcurrencyConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteProvisionedConcurrencyConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteProvisionedConcurrencyConfigInput"}
	if s.FunctionName == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}
	if s.Qualifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Qualifier"))
	}
	if s.Qualifier != nil && len(*s.Qualifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Qualifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFunctionName sets the FunctionName field's value.
func (s *DeleteProvisionedConcurrencyConfigInput) SetFunctionName(v string) *DeleteProvisionedConcurrencyConfigInput {
	s.FunctionName = &v
	return s
}

// SetQualifier sets the Qualifier field's value.
func (s *DeleteProvisionedConcurrencyConfigInput) SetQualifier(v string) *DeleteProvisionedConcurrencyConfigInput {
	s.Qualifier = &v
	return s
}

type DeleteProvisionedConcurrencyConfigOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteProvisionedConcurrencyConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteProvisionedConcurrencyConfigOutput) GoString() string {
	return s.String()
}

// A configuration object that specifies the destination of an event after Lambda
// processes it.
type DestinationConfig struct {
	_ struct{} `type:"structure"`

	// The destination configuration for failed invocations.
	OnFailure *OnFailure `type:"structure"`

	// The destination configuration for successful invocations.
	OnSuccess *OnSuccess `type:"structure"`
}

// String returns the string representation
func (s DestinationConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DestinationConfig) GoString() string {
	return s.String()
}

// SetOnFailure sets the OnFailure field's value.
func (s *DestinationConfig) SetOnFailure(v *OnFailure) *DestinationConfig {
	s.OnFailure = v
	return s
}

// SetOnSuccess sets the OnSuccess field's value.
func (s *DestinationConfig) SetOnSuccess(v *OnSuccess) *DestinationConfig {
	s.OnSuccess = v
	return s
}

// Need additional permissions to configure VPC settings.
type EC2AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	Type *string `type:"string"`
}

// String returns the string representation
func (s EC2AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EC2AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorEC2AccessDeniedException(v protocol.ResponseMetadata) error {
	return &EC2AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *EC2AccessDeniedException) Code() string {
	return "EC2AccessDeniedException"
}

// Message returns the exception's message.
func (s *EC2AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *EC2AccessDeniedException) OrigErr() error {
	return nil
}

func (s *EC2AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *EC2AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *EC2AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// AWS Lambda was throttled by Amazon EC2 during Lambda function initialization
// using the execution role provided for the Lambda function.
type EC2ThrottledException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	Type *string `type:"string"`
}

// String returns the string representation
func (s EC2ThrottledException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EC2ThrottledException) GoString() string {
	return s.String()
}

func newErrorEC2ThrottledException(v protocol.ResponseMetadata) error {
	return &EC2ThrottledException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *EC2ThrottledException) Code() string {
	return "EC2ThrottledException"
}

// Message returns the exception's message.
func (s *EC2ThrottledException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *EC2ThrottledException) OrigErr() error {
	return nil
}

func (s *EC2ThrottledException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *EC2ThrottledException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *EC2ThrottledException) RequestID() string {
	return s.RespMetadata.RequestID
}

// AWS Lambda received an unexpected EC2 client exception while setting up for
// the Lambda function.
type EC2UnexpectedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	EC2ErrorCode *string `type:"string"`

	Message_ *string `locationName:"Message" type:"string"`

	Type *string `type:"string"`
}

// String returns the string representation
func (s EC2UnexpectedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EC2UnexpectedException) GoString() string {
	return s.String()
}

func newErrorEC2UnexpectedException(v protocol.ResponseMetadata) error {
	return &EC2UnexpectedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *EC2UnexpectedException) Code() string {
	return "EC2UnexpectedException"
}

// Message returns the exception's message.
func (s *EC2UnexpectedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *EC2UnexpectedException) OrigErr() error {
	return nil
}

func (s *EC2UnexpectedException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *EC2UnexpectedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *EC2UnexpectedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// AWS Lambda was not able to create an elastic network interface in the VPC,
// specified as part of Lambda function configuration, because the limit for
// network interfaces has been reached.
type ENILimitReachedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	Type *string `type:"string"`
}

// String returns the string representation
func (s ENILimitReachedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ENILimitReachedException) GoString() string {
	return s.String()
}

func newErrorENILimitReachedException(v protocol.ResponseMetadata) error {
	return &ENILimitReachedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ENILimitReachedException) Code() string {
	return "ENILimitReachedException"
}

// Message returns the exception's message.
func (s *ENILimitReachedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ENILimitReachedException) OrigErr() error {
	return nil
}

func (s *ENILimitReachedException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ENILimitReachedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ENILimitReachedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A function's environment variable settings.
type Environment struct {
	_ struct{} `type:"structure"`

	// Environment variable key-value pairs.
	Variables map[string]*string `type:"map" sensitive:"true"`
}

// String returns the string representation
func (s Environment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Environment) GoString() string {
	return s.String()
}

// SetVariables sets the Variables field's value.
func (s *Environment) SetVariables(v map[string]*string) *Environment {
	s.Variables = v
	return s
}

// Error messages for environment variables that couldn't be applied.
type EnvironmentError struct {
	_ struct{} `type:"structure"`

	// The error code.
	ErrorCode *string `type:"string"`

	// The error message.
	Message *string `type:"string" sensitive:"true"`
}

// String returns the string representation
func (s EnvironmentError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnvironmentError) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *EnvironmentError) SetErrorCode(v string) *EnvironmentError {
	s.ErrorCode = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *EnvironmentError) SetMessage(v string) *EnvironmentError {
	s.Message = &v
	return s
}

// The results of an operation to update or read environment variables. If the
// operation is successful, the response contains the environment variables.
// If it failed, the response contains details about the error.
type EnvironmentResponse struct {
	_ struct{} `type:"structure"`

	// Error messages for environment variables that couldn't be applied.
	Error *EnvironmentError `type:"structure"`

	// Environment variable key-value pairs.
	Variables map[string]*string `type:"map" sensitive:"true"`
}

// String returns the string representation
func (s EnvironmentResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnvironmentResponse) GoString() string {
	return s.String()
}

// SetError sets the Error field's value.
func (s *EnvironmentResponse) SetError(v *EnvironmentError) *EnvironmentResponse {
	s.Error = v
	return s
}

// SetVariables sets the Variables field's value.
func (s *EnvironmentResponse) SetVariables(v map[string]*string) *EnvironmentResponse {
	s.Variables = v
	return s
}

// A mapping between an AWS resource and an AWS Lambda function. See CreateEventSourceMapping
// for details.
type EventSourceMappingConfiguration struct {
	_ struct{} `type:"structure"`

	// The maximum number of items to retrieve in a single batch.
	BatchSize *int64 `min:"1" type:"integer"`

	// (Streams) If the function returns an error, split the batch in two and retry.
	BisectBatchOnFunctionError *bool `type:"boolean"`

	// (Streams) An Amazon SQS queue or Amazon SNS topic destination for discarded
	// records.
	DestinationConfig *DestinationConfig `type:"structure"`

	// The Amazon Resource Name (ARN) of the event source.
	EventSourceArn *string `type:"string"`

	// The ARN of the Lambda function.
	FunctionArn *string `type:"string"`

	// The date that the event source mapping was last updated, or its state changed.
	LastModified *time.Time `type:"timestamp"`

	// The result of the last AWS Lambda invocation of your Lambda function.
	LastProcessingResult *string `type:"string"`

	// (Streams) The maximum amount of time to gather records before invoking the
	// function, in seconds.
	MaximumBatchingWindowInSeconds *int64 `type:"integer"`

	// (Streams) The maximum age of a record that Lambda sends to a function for
	// processing.
	MaximumRecordAgeInSeconds *int64 `min:"60" type:"integer"`

	// (Streams) The maximum number of times to retry when the function returns
	// an error.
	MaximumRetryAttempts *int64 `type:"integer"`

	// (Streams) The number of batches to process from each shard concurrently.
	ParallelizationFactor *int64 `min:"1" type:"integer"`

	// The state of the event source mapping. It can be one of the following: Creating,
	// Enabling, Enabled, Disabling, Disabled, Updating, or Deleting.
	State *string `type:"string"`

	// Indicates whether the last change to the event source mapping was made by
	// a user, or by the Lambda service.
	StateTransitionReason *string `type:"string"`

	// The identifier of the event source mapping.
	UUID *string `type:"string"`
}

// String returns the string representation
func (s EventSourceMappingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EventSourceMappingConfiguration) GoString() string {
	return s.String()
}

// SetBatchSize sets the BatchSize field's value.
func (s *EventSourceMappingConfiguration) SetBatchSize(v int64) *EventSourceMappingConfiguration {
	s.BatchSize = &v
	return s
}

// SetBisectBatchOnFunctionError sets the BisectBatchOnFunctionError field's value.
func (s *EventSourceMappingConfiguration) SetBisectBatchOnFunctionError(v bool) *EventSourceMappingConfiguration {
	s.BisectBatchOnFunctionError = &v
	return s
}

// SetDestinationConfig sets the DestinationConfig field's value.
func (s *EventSourceMappingConfiguration) SetDestinationConfig(v *DestinationConfig) *EventSourceMappingConfiguration {
	s.DestinationConfig = v
	return s
}

// SetEventSourceArn sets the EventSourceArn field's value.
func (s *EventSourceMappingConfiguration) SetEventSourceArn(v string) *EventSourceMappingConfiguration {
	s.EventSourceArn = &v
	return s
}

// SetFunctionArn sets the FunctionArn field's value.
func (s *EventSourceMappingConfiguration) SetFunctionArn(v string) *EventSourceMappingConfiguration {
	s.FunctionArn = &v
	return s
}

// SetLastModified sets the LastModified field's value.
func (s *EventSourceMappingConfiguration) SetLastModified(v time.Time) *EventSourceMappingConfiguration {
	s.LastModified = &v
	return s
}

// SetLastProcessingResult sets the LastProcessingResult field's value.
func (s *EventSourceMappingConfiguration) SetLastProcessingResult(v string) *EventSourceMappingConfiguration {
	s.LastProcessingResult = &v
	return s
}

// SetMaximumBatchingWindowInSeconds sets the MaximumBatchingWindowInSeconds field's value.
func (s *EventSourceMappingConfiguration) SetMaximumBatchingWindowInSeconds(v int64) *EventSourceMappingConfiguration {
	s.MaximumBatchingWindowInSeconds = &v
	return s
}

// SetMaximumRecordAgeInSeconds sets the MaximumRecordAgeInSeconds field's value.
func (s *EventSourceMappingConfiguration) SetMaximumRecordAgeInSeconds(v int64) *EventSourceMappingConfiguration {
	s.MaximumRecordAgeInSeconds = &v
	return s
}

// SetMaximumRetryAttempts sets the MaximumRetryAttempts field's value.
func (s *EventSourceMappingConfiguration) SetMaximumRetryAttempts(v int64) *EventSourceMappingConfiguration {
	s.MaximumRetryAttempts = &v
	return s
}

// SetParallelizationFactor sets the ParallelizationFactor field's value.
func (s *EventSourceMappingConfiguration) SetParallelizationFactor(v int64) *EventSourceMappingConfiguration {
	s.ParallelizationFactor = &v
	return s
}

// SetState sets the State field's value.
func (s *EventSourceMappingConfiguration) SetState(v string) *EventSourceMappingConfiguration {
	s.State = &v
	return s
}

// SetStateTransitionReason sets the StateTransitionReason field's value.
func (s *EventSourceMappingConfiguration) SetStateTransitionReason(v string) *EventSourceMappingConfiguration {
	s.StateTransitionReason = &v
	return s
}

// SetUUID sets the UUID field's value.
func (s *EventSourceMappingConfiguration) SetUUID(v string) *EventSourceMappingConfiguration {
	s.UUID = &v
	return s
}

// The code for the Lambda function. You can specify either an object in Amazon
// S3, or upload a deployment package directly.
type FunctionCode struct {
	_ struct{} `type:"structure"`

	// An Amazon S3 bucket in the same AWS Region as your function. The bucket can
	// be in a different AWS account.
	S3Bucket *string `min:"3" type:"string"`

	// The Amazon S3 key of the deployment package.
	S3Key *string `min:"1" type:"string"`

	// For versioned objects, the version of the deployment package object to use.
	S3ObjectVersion *string `min:"1" type:"string"`

	// The base64-encoded contents of the deployment package. AWS SDK and AWS CLI
	// clients handle the encoding for you.
	//
	// ZipFile is automatically base64 encoded/decoded by the SDK.
	ZipFile []byte `type:"blob" sensitive:"true"`
}

// String returns the string representation
func (s FunctionCode) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FunctionCode) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FunctionCode) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FunctionCode"}
	if s.S3Bucket != nil && len(*s.S3Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("S3Bucket", 3))
	}
	if s.S3Key != nil && len(*s.S3Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("S3Key", 1))
	}
	if s.S3ObjectVersion != nil && len(*s.S3ObjectVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("S3ObjectVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3Bucket sets the S3Bucket field's value.
func (s *FunctionCode) SetS3Bucket(v string) *FunctionCode {
	s.S3Bucket = &v
	return s
}

// SetS3Key sets the S3Key field's value.
func (s *FunctionCode) SetS3Key(v string) *FunctionCode {
	s.S3Key = &v
	return s
}

// SetS3ObjectVersion sets the S3ObjectVersion field's value.
func (s *FunctionCode) SetS3ObjectVersion(v string) *FunctionCode {
	s.S3ObjectVersion = &v
	return s
}

// SetZipFile sets the ZipFile field's value.
func (s *FunctionCode) SetZipFile(v []byte) *FunctionCode {
	s.ZipFile = v
	return s
}

// Details about a function's deployment package.
type FunctionCodeLocation struct {
	_ struct{} `type:"structure"`

	// A presigned URL that you can use to download the deployment package.
	Location *string `type:"string"`

	// The service that's hosting the file.
	RepositoryType *string `type:"string"`
}

// String returns the string representation
func (s FunctionCodeLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FunctionCodeLocation) GoString() string {
	return s.String()
}

// SetLocation sets the Location field's value.
func (s *FunctionCodeLocation) SetLocation(v string) *FunctionCodeLocation {
	s.Location = &v
	return s
}

// SetRepositoryType sets the RepositoryType field's value.
func (s *FunctionCodeLocation) SetRepositoryType(v string) *FunctionCodeLocation {
	s.RepositoryType = &v
	return s
}

// Details about a function's configuration.
type FunctionConfiguration struct {
	_ struct{} `type:"structure"`

	// The SHA256 hash of the function's deployment package.
	CodeSha256 *string `type:"string"`

	// The size of the function's deployment package, in bytes.
	CodeSize *int64 `type:"long"`

	// The function's dead letter queue.
	DeadLetterConfig *DeadLetterConfig `type:"structure"`

	// The function's description.
	Description *string `type:"string"`

	// The function's environment variables.
	Environment *EnvironmentResponse `type:"structure"`

	// The function's Amazon Resource Name (ARN).
	FunctionArn *string `type:"string"`

	// The name of the function.
	FunctionName *string `min:"1" type:"string"`

	// The function that Lambda calls to begin executing your function.
	Handler *string `type:"string"`

	// The KMS key that's used to encrypt the function's environment variables.
	// This key is only returned if you've configured a customer managed CMK.
	KMSKeyArn *string `type:"string"`

	// The date and time that the function was last updated, in ISO-8601 format
	// (https://www.w3.org/TR/NOTE-datetime) (YYYY-MM-DDThh:mm:ss.sTZD).
	LastModified *string `type:"string"`

	// The status of the last update that was performed on the function. This is
	// first set to Successful after function creation completes.
	LastUpdateStatus *string `type:"string" enum:"LastUpdateStatus"`

	// The reason for the last update that was performed on the function.
	LastUpdateStatusReason *string `type:"string"`

	// The reason code for the last update that was performed on the function.
	LastUpdateStatusReasonCode *string `type:"string" enum:"LastUpdateStatusReasonCode"`

	// The function's layers (https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html).
	Layers []*Layer `type:"list"`

	// For Lambda@Edge functions, the ARN of the master function.
	MasterArn *string `type:"string"`

	// The memory that's allocated to the function.
	MemorySize *int64 `min:"128" type:"integer"`

	// The latest updated revision of the function or alias.
	RevisionId *string `type:"string"`

	// The function's execution role.
	Role *string `type:"string"`

	// The runtime environment for the Lambda function.
	Runtime *string `type:"string" enum:"Runtime"`

	// The current state of the function. When the state is Inactive, you can reactivate
	// the function by invoking it.
	State *string `type:"string" enum:"State"`

	// The reason for the function's current state.
	StateReason *string `type:"string"`

	// The reason code for the function's current state. When the code is Creating,
	// you can't invoke or modify the function.
	StateReasonCode *string `type:"string" enum:"StateReasonCode"`

	// The amount of time in seconds that Lambda allows a function to run before
	// stopping it.
	Timeout *int64 `min:"1" type:"integer"`

	// The function's AWS X-Ray tracing configuration.
	TracingConfig *TracingConfigResponse `type:"structure"`

	// The version of the Lambda function.
	Version *string `min:"1" type:"string"`

	// The function's networking configuration.
	VpcConfig *VpcConfigResponse `type:"structure"`
}

// String returns the string representation
func (s FunctionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FunctionConfiguration) GoString() string {
	return s.String()
}

// SetCodeSha256 sets the CodeSha256 field's value.
func (s *FunctionConfiguration) SetCodeSha256(v string) *FunctionConfiguration {
	s.CodeSha256 = &v
	return s
}

// SetCodeSize sets the CodeSize field's value.
func (s *FunctionConfiguration) SetCodeSize(v int64) *FunctionConfiguration {
	s.CodeSize = &v
	return s
}

// SetDeadLetterConfig sets the DeadLetterConfig field's value.
func (s *FunctionConfiguration) SetDeadLetterConfig(v *DeadLetterConfig) *FunctionConfiguration {
	s.DeadLetterConfig = v
	return s
}

// SetDescription sets the Description field's value.
func (s *FunctionConfiguration) SetDescription(v string) *FunctionConfiguration {
	s.Description = &v
	return s
}

// SetEnvironment sets the Environment field's value.
func (s *FunctionConfiguration) SetEnvironment(v *EnvironmentResponse) *FunctionConfiguration {
	s.Environment = v
	return s
}

// SetFunctionArn sets the FunctionArn field's value.
func (s *FunctionConfiguration) SetFunctionArn(v string) *FunctionConfiguration {
	s.FunctionArn = &v
	return s
}

// SetFunctionName sets the FunctionName field's value.
func (s *FunctionConfiguration) SetFunctionName(v string) *FunctionConfiguration {
	s.FunctionName = &v
	return s
}

// SetHandler sets the Handler field's value.
func (s *FunctionConfiguration) SetHandler(v string) *FunctionConfiguration {
	s.Handler = &v
	return s
}

// SetKMSKeyArn sets the KMSKeyArn field's value.
func (s *FunctionConfiguration) SetKMSKeyArn(v string) *FunctionConfiguration {
	s.KMSKeyArn = &v
	return s
}

// SetLastModified sets the LastModified field's value.
func (s *FunctionConfiguration) SetLastModified(v string) *FunctionConfiguration {
	s.LastModified = &v
	return s
}

// SetLastUpdateStatus sets the LastUpdateStatus field's value.
func (s *FunctionConfiguration) SetLastUpdateStatus(v string) *FunctionConfiguration {
	s.LastUpdateStatus = &v
	return s
}

// SetLastUpdateStatusReason sets the LastUpdateStatusReason field's value.
func (s *FunctionConfiguration) SetLastUpdateStatusReason(v string) *FunctionConfiguration {
	s.LastUpdateStatusReason = &v
	return s
}

// SetLastUpdateStatusReasonCode sets the LastUpdateStatusReasonCode field's value.
func (s *FunctionConfiguration) SetLastUpdateStatusReasonCode(v string) *FunctionConfiguration {
	s.LastUpdateStatusReasonCode = &v
	return s
}

// SetLayers sets the Layers field's value.
func (s *FunctionConfiguration) SetLayers(v []*Layer) *FunctionConfiguration {
	s.Layers = v
	return s
}

// SetMasterArn sets the MasterArn field's value.
func (s *FunctionConfiguration) SetMasterArn(v string) *FunctionConfiguration {
	s.MasterArn = &v
	return s
}

// SetMemorySize sets the MemorySize field's value.
func (s *FunctionConfiguration) SetMemorySize(v int64) *FunctionConfiguration {
	s.MemorySize = &v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *FunctionConfiguration) SetRevisionId(v string) *FunctionConfiguration {
	s.RevisionId = &v
	return s
}

// SetRole sets the Role field's value.
func (s *FunctionConfiguration) SetRole(v string) *FunctionConfiguration {
	s.Role = &v
	return s
}

// SetRuntime sets the Runtime field's value.
func (s *FunctionConfiguration) SetRuntime(v string) *FunctionConfiguration {
	s.Runtime = &v
	return s
}

// SetState sets the State field's value.
func (s *FunctionConfiguration) SetState(v string) *FunctionConfiguration {
	s.State = &v
	return s
}

// SetStateReason sets the StateReason field's value.
func (s *FunctionConfiguration) SetStateReason(v string) *FunctionConfiguration {
	s.StateReason = &v
	return s
}

// SetStateReasonCode sets the StateReasonCode field's value.
func (s *FunctionConfiguration) SetStateReasonCode(v string) *FunctionConfiguration {
	s.StateReasonCode = &v
	return s
}

// SetTimeout sets the Timeout field's value.
func (s *FunctionConfiguration) SetTimeout(v int64) *FunctionConfiguration {
	s.Timeout = &v
	return s
}

// SetTracingConfig sets the TracingConfig field's value.
func (s *FunctionConfiguration) SetTracingConfig(v *TracingConfigResponse) *FunctionConfiguration {
	s.TracingConfig = v
	return s
}

// SetVersion sets the Version field's value.
func (s *FunctionConfiguration) SetVersion(v string) *FunctionConfiguration {
	s.Version = &v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *FunctionConfiguration) SetVpcConfig(v *VpcConfigResponse) *FunctionConfiguration {
	s.VpcConfig = v
	return s
}

type FunctionEventInvokeConfig struct {
	_ struct{} `type:"structure"`

	// A destination for events after they have been sent to a function for processing.
	//
	// Destinations
	//
	//    * Function - The Amazon Resource Name (ARN) of a Lambda function.
	//
	//    * Queue - The ARN of an SQS queue.
	//
	//    * Topic - The ARN of an SNS topic.
	//
	//    * Event Bus - The ARN of an Amazon EventBridge event bus.
	DestinationConfig *DestinationConfig `type:"structure"`

	// The Amazon Resource Name (ARN) of the function.
	FunctionArn *string `type:"string"`

	// The date and time that the configuration was last updated.
	LastModified *time.Time `type:"timestamp"`

	// The maximum age of a request that Lambda sends to a function for processing.
	MaximumEventAgeInSeconds *int64 `min:"60" type:"integer"`

	// The maximum number of times to retry when the function returns an error.
	MaximumRetryAttempts *int64 `type:"integer"`
}

// String returns the string representation
func (s FunctionEventInvokeConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FunctionEventInvokeConfig) GoString() string {
	return s.String()
}

// SetDestinationConfig sets the DestinationConfig field's value.
func (s *FunctionEventInvokeConfig) SetDestinationConfig(v *DestinationConfig) *FunctionEventInvokeConfig {
	s.DestinationConfig = v
	return s
}

// SetFunctionArn sets the FunctionArn field's value.
func (s *FunctionEventInvokeConfig) SetFunctionArn(v string) *FunctionEventInvokeConfig {
	s.FunctionArn = &v
	return s
}

// SetLastModified sets the LastModified field's value.
func (s *FunctionEventInvokeConfig) SetLastModified(v time.Time) *FunctionEventInvokeConfig {
	s.LastModified = &v
	return s
}

// SetMaximumEventAgeInSeconds sets the MaximumEventAgeInSeconds field's value.
func (s *FunctionEventInvokeConfig) SetMaximumEventAgeInSeconds(v int64) *FunctionEventInvokeConfig {
	s.MaximumEventAgeInSeconds = &v
	return s
}

// SetMaximumRetryAttempts sets the MaximumRetryAttempts field's value.
func (s *FunctionEventInvokeConfig) SetMaximumRetryAttempts(v int64) *FunctionEventInvokeConfig {
	s.MaximumRetryAttempts = &v
	return s
}

type GetAccountSettingsInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetAccountSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAccountSettingsInput) GoString() string {
	return s.String()
}

type GetAccountSettingsOutput struct {
	_ struct{} `type:"structure"`

	// Limits that are related to concurrency and code storage.
	AccountLimit *AccountLimit `type:"structure"`

	// The number of functions and amount of storage in use.
	AccountUsage *AccountUsage `type:"structure"`
}

// String returns the string representation
func (s GetAccountSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAccountSettingsOutput) GoString() string {
	return s.String()
}

// SetAccountLimit sets the AccountLimit field's value.
func (s *GetAccountSettingsOutput) SetAccountLimit(v *AccountLimit) *GetAccountSettingsOutput {
	s.AccountLimit = v
	return s
}

// SetAccountUsage sets the AccountUsage field's value.
func (s *GetAccountSettingsOutput) SetAccountUsage(v *AccountUsage) *GetAccountSettingsOutput {
	s.AccountUsage = v
	return s
}

type GetAliasInput struct {
	_ struct{} `type:"structure"`

	// The name of the Lambda function.
	//
	// Name formats
	//
	//    * Function name - MyFunction.
	//
	//    * Function ARN - arn:aws:lambda:us-west-2:123456789012:function:MyFunction.
	//
	//    * Partial ARN - 123456789012:function:MyFunction.
	//
	// The length constraint applies only to the full ARN. If you specify only the
	// function name, it is limited to 64 characters in length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// The name of the alias.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"Name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAliasInput"}
	if s.FunctionName == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFunctionName sets the FunctionName field's value.
func (s *GetAliasInput) SetFunctionName(v string) *GetAliasInput {
	s.FunctionName = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetAliasInput) SetName(v string) *GetAliasInput {
	s.Name = &v
	return s
}

type GetEventSourceMappingInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the event source mapping.
	//
	// UUID is a required field
	UUID *string `location:"uri" locationName:"UUID" type:"string" required:"true"`
}

// String returns the string representation
func (s GetEventSourceMappingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEventSourceMappingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEventSourceMappingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetEventSourceMappingInput"}
	if s.UUID == nil {
		invalidParams.Add(request.NewErrParamRequired("UUID"))
	}
	if s.UUID != nil && len(*s.UUID) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UUID", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUUID sets the UUID field's value.
func (s *GetEventSourceMappingInput) SetUUID(v string) *GetEventSourceMappingInput {
	s.UUID = &v
	return s
}

type GetFunctionConcurrencyInput struct {
	_ struct{} `type:"structure"`

	// The name of the Lambda function.
	//
	// Name formats
	//
	//    * Function name - my-function.
	//
	//    * Function ARN - arn:aws:lambda:us-west-2:123456789012:function:my-function.
	//
	//    * Partial ARN - 123456789012:function:my-function.
	//
	// The length constraint applies only to the full ARN. If you specify only the
	// function name, it is limited to 64 characters in length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetFunctionConcurrencyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFunctionConcurrencyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetFunctionConcurrencyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetFunctionConcurrencyInput"}
	if s.FunctionName == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFunctionName sets the FunctionName field's value.
func (s *GetFunctionConcurrencyInput) SetFunctionName(v string) *GetFunctionConcurrencyInput {
	s.FunctionName = &v
	return s
}

type GetFunctionConcurrencyOutput struct {
	_ struct{} `type:"structure"`

	// The number of simultaneous executions that are reserved for the function.
	ReservedConcurrentExecutions *int64 `type:"integer"`
}

// String returns the string representation
func (s GetFunctionConcurrencyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFunctionConcurrencyOutput) GoString() string {
	return s.String()
}

// SetReservedConcurrentExecutions sets the ReservedConcurrentExecutions field's value.
func (s *GetFunctionConcurrencyOutput) SetReservedConcurrentExecutions(v int64) *GetFunctionConcurrencyOutput {
	s.ReservedConcurrentExecutions = &v
	return s
}

type GetFunctionConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The name of the Lambda function, version, or alias.
	//
	// Name formats
	//
	//    * Function name - my-function (name-only), my-function:v1 (with alias).
	//
	//    * Function ARN - arn:aws:lambda:us-west-2:123456789012:function:my-function.
	//
	//    * Partial ARN - 123456789012:function:my-function.
	//
	// You can append a version number or alias to any of the formats. The length
	// constraint applies only to the full ARN. If you specify only the function
	// name, it is limited to 64 characters in length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// Specify a version or alias to get details about a published version of the
	// function.
	Qualifier *string `location:"querystring" locationName:"Qualifier" min:"1" type:"string"`
}

// String returns the string representation
func (s GetFunctionConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFunctionConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetFunctionConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetFunctionConfigurationInput"}
	if s.FunctionName == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}
	if s.Qualifier != nil && len(*s.Qualifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Qualifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFunctionName sets the FunctionName field's value.
func (s *GetFunctionConfigurationInput) SetFunctionName(v string) *GetFunctionConfigurationInput {
	s.FunctionName = &v
	return s
}

// SetQualifier sets the Qualifier field's value.
func (s *GetFunctionConfigurationInput) SetQualifier(v string) *GetFunctionConfigurationInput {
	s.Qualifier = &v
	return s
}

type GetFunctionEventInvokeConfigInput struct {
	_ struct{} `type:"structure"`

	// The name of the Lambda function, version, or alias.
	//
	// Name formats
	//
	//    * Function name - my-function (name-only), my-function:v1 (with alias).
	//
	//    * Function ARN - arn:aws:lambda:us-west-2:123456789012:function:my-function.
	//
	//    * Partial ARN - 123456789012:function:my-function.
	//
	// You can append a version number or alias to any of the formats. The length
	// constraint applies only to the full ARN. If you specify only the function
	// name, it is limited to 64 characters in length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// A version number or alias name.
	Qualifier *string `location:"querystring" locationName:"Qualifier" min:"1" type:"string"`
}

// String returns the string representation
func (s GetFunctionEventInvokeConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFunctionEventInvokeConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetFunctionEventInvokeConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetFunctionEventInvokeConfigInput"}
	if s.FunctionName == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}
	if s.Qualifier != nil && len(*s.Qualifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Qualifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFunctionName sets the FunctionName field's value.
func (s *GetFunctionEventInvokeConfigInput) SetFunctionName(v string) *GetFunctionEventInvokeConfigInput {
	s.FunctionName = &v
	return s
}

// SetQualifier sets the Qualifier field's value.
func (s *GetFunctionEventInvokeConfigInput) SetQualifier(v string) *GetFunctionEventInvokeConfigInput {
	s.Qualifier = &v
	return s
}

type GetFunctionEventInvokeConfigOutput struct {
	_ struct{} `type:"structure"`

	// A destination for events after they have been sent to a function for processing.
	//
	// Destinations
	//
	//    * Function - The Amazon Resource Name (ARN) of a Lambda function.
	//
	//    * Queue - The ARN of an SQS queue.
	//
	//    * Topic - The ARN of an SNS topic.
	//
	//    * Event Bus - The ARN of an Amazon EventBridge event bus.
	DestinationConfig *DestinationConfig `type:"structure"`

	// The Amazon Resource Name (ARN) of the function.
	FunctionArn *string `type:"string"`

	// The date and time that the configuration was last updated.
	LastModified *time.Time `type:"timestamp"`

	// The maximum age of a request that Lambda sends to a function for processing.
	MaximumEventAgeInSeconds *int64 `min:"60" type:"integer"`

	// The maximum number of times to retry when the function returns an error.
	MaximumRetryAttempts *int64 `type:"integer"`
}

// String returns the string representation
func (s GetFunctionEventInvokeConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFunctionEventInvokeConfigOutput) GoString() string {
	return s.String()
}

// SetDestinationConfig sets the DestinationConfig field's value.
func (s *GetFunctionEventInvokeConfigOutput) SetDestinationConfig(v *DestinationConfig) *GetFunctionEventInvokeConfigOutput {
	s.DestinationConfig = v
	return s
}

// SetFunctionArn sets the FunctionArn field's value.
func (s *GetFunctionEventInvokeConfigOutput) SetFunctionArn(v string) *GetFunctionEventInvokeConfigOutput {
	s.FunctionArn = &v
	return s
}

// SetLastModified sets the LastModified field's value.
func (s *GetFunctionEventInvokeConfigOutput) SetLastModified(v time.Time) *GetFunctionEventInvokeConfigOutput {
	s.LastModified = &v
	return s
}

// SetMaximumEventAgeInSeconds sets the MaximumEventAgeInSeconds field's value.
func (s *GetFunctionEventInvokeConfigOutput) SetMaximumEventAgeInSeconds(v int64) *GetFunctionEventInvokeConfigOutput {
	s.MaximumEventAgeInSeconds = &v
	return s
}

// SetMaximumRetryAttempts sets the MaximumRetryAttempts field's value.
func (s *GetFunctionEventInvokeConfigOutput) SetMaximumRetryAttempts(v int64) *GetFunctionEventInvokeConfigOutput {
	s.MaximumRetryAttempts = &v
	return s
}

type GetFunctionInput struct {
	_ struct{} `type:"structure"`

	// The name of the Lambda function, version, or alias.
	//
	// Name formats
	//
	//    * Function name - my-function (name-only), my-function:v1 (with alias).
	//
	//    * Function ARN - arn:aws:lambda:us-west-2:123456789012:function:my-function.
	//
	//    * Partial ARN - 123456789012:function:my-function.
	//
	// You can append a version number or alias to any of the formats. The length
	// constraint applies only to the full ARN. If you specify only the function
	// name, it is limited to 64 characters in length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// Specify a version or alias to get details about a published version of the
	// function.
	Qualifier *string `location:"querystring" locationName:"Qualifier" min:"1" type:"string"`
}

// String returns the string representation
func (s GetFunctionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFunctionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetFunctionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetFunctionInput"}
	if s.FunctionName == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}
	if s.Qualifier != nil && len(*s.Qualifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Qualifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFunctionName sets the FunctionName field's value.
func (s *GetFunctionInput) SetFunctionName(v string) *GetFunctionInput {
	s.FunctionName = &v
	return s
}

// SetQualifier sets the Qualifier field's value.
func (s *GetFunctionInput) SetQualifier(v string) *GetFunctionInput {
	s.Qualifier = &v
	return s
}

type GetFunctionOutput struct {
	_ struct{} `type:"structure"`

	// The deployment package of the function or version.
	Code *FunctionCodeLocation `type:"structure"`

	// The function's reserved concurrency (https://docs.aws.amazon.com/lambda/latest/dg/concurrent-executions.html).
	Concurrency *PutFunctionConcurrencyOutput `type:"structure"`

	// The configuration of the function or version.
	Configuration *FunctionConfiguration `type:"structure"`

	// The function's tags (https://docs.aws.amazon.com/lambda/latest/dg/tagging.html).
	Tags map[string]*string `type:"map"`
}

// String returns the string representation
func (s GetFunctionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFunctionOutput) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *GetFunctionOutput) SetCode(v *FunctionCodeLocation) *GetFunctionOutput {
	s.Code = v
	return s
}

// SetConcurrency sets the Concurrency field's value.
func (s *GetFunctionOutput) SetConcurrency(v *PutFunctionConcurrencyOutput) *GetFunctionOutput {
	s.Concurrency = v
	return s
}

// SetConfiguration sets the Configuration field's value.
func (s *GetFunctionOutput) SetConfiguration(v *FunctionConfiguration) *GetFunctionOutput {
	s.Configuration = v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetFunctionOutput) SetTags(v map[string]*string) *GetFunctionOutput {
	s.Tags = v
	return s
}

type GetLayerVersionByArnInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the layer version.
	//
	// Arn is a required field
	Arn *string `location:"querystring" locationName:"Arn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetLayerVersionByArnInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetLayerVersionByArnInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetLayerVersionByArnInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetLayerVersionByArnInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *GetLayerVersionByArnInput) SetArn(v string) *GetLayerVersionByArnInput {
	s.Arn = &v
	return s
}

type GetLayerVersionByArnOutput struct {
	_ struct{} `type:"structure"`

	// The layer's compatible runtimes.
	CompatibleRuntimes []*string `type:"list"`

	// Details about the layer version.
	Content *LayerVersionContentOutput `type:"structure"`

	// The date that the layer version was created, in ISO-8601 format (https://www.w3.org/TR/NOTE-datetime)
	// (YYYY-MM-DDThh:mm:ss.sTZD).
	CreatedDate *string `type:"string"`

	// The description of the version.
	Description *string `type:"string"`

	// The ARN of the layer.
	LayerArn *string `min:"1" type:"string"`

	// The ARN of the layer version.
	LayerVersionArn *string `min:"1" type:"string"`

	// The layer's software license.
	LicenseInfo *string `type:"string"`

	// The version number.
	Version *int64 `type:"long"`
}

// String returns the string representation
func (s GetLayerVersionByArnOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetLayerVersionByArnOutput) GoString() string {
	return s.String()
}

// SetCompatibleRuntimes sets the CompatibleRuntimes field's value.
func (s *GetLayerVersionByArnOutput) SetCompatibleRuntimes(v []*string) *GetLayerVersionByArnOutput {
	s.CompatibleRuntimes = v
	return s
}

// SetContent sets the Content field's value.
func (s *GetLayerVersionByArnOutput) SetContent(v *LayerVersionContentOutput) *GetLayerVersionByArnOutput {
	s.Content = v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *GetLayerVersionByArnOutput) SetCreatedDate(v string) *GetLayerVersionByArnOutput {
	s.CreatedDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetLayerVersionByArnOutput) SetDescription(v string) *GetLayerVersionByArnOutput {
	s.Description = &v
	return s
}

// SetLayerArn sets the LayerArn field's value.
func (s *GetLayerVersionByArnOutput) SetLayerArn(v string) *GetLayerVersionByArnOutput {
	s.LayerArn = &v
	return s
}

// SetLayerVersionArn sets the LayerVersionArn field's value.
func (s *GetLayerVersionByArnOutput) SetLayerVersionArn(v string) *GetLayerVersionByArnOutput {
	s.LayerVersionArn = &v
	return s
}

// SetLicenseInfo sets the LicenseInfo field's value.
func (s *GetLayerVersionByArnOutput) SetLicenseInfo(v string) *GetLayerVersionByArnOutput {
	s.LicenseInfo = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *GetLayerVersionByArnOutput) SetVersion(v int64) *GetLayerVersionByArnOutput {
	s.Version = &v
	return s
}

type GetLayerVersionInput struct {
	_ struct{} `type:"structure"`

	// The name or Amazon Resource Name (ARN) of the layer.
	//
	// LayerName is a required field
	LayerName *string `location:"uri" locationName:"LayerName" min:"1" type:"string" required:"true"`

	// The version number.
	//
	// VersionNumber is a required field
	VersionNumber *int64 `location:"uri" locationName:"VersionNumber" type:"long" required:"true"`
}

// String returns the string representation
func (s GetLayerVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetLayerVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetLayerVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetLayerVersionInput"}
	if s.LayerName == nil {
		invalidParams.Add(request.NewErrParamRequired("LayerName"))
	}
	if s.LayerName != nil && len(*s.LayerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LayerName", 1))
	}
	if s.VersionNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("VersionNumber"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLayerName sets the LayerName field's value.
func (s *GetLayerVersionInput) SetLayerName(v string) *GetLayerVersionInput {
	s.LayerName = &v
	return s
}

// SetVersionNumber sets the VersionNumber field's value.
func (s *GetLayerVersionInput) SetVersionNumber(v int64) *GetLayerVersionInput {
	s.VersionNumber = &v
	return s
}

type GetLayerVersionOutput struct {
	_ struct{} `type:"structure"`

	// The layer's compatible runtimes.
	CompatibleRuntimes []*string `type:"list"`

	// Details about the layer version.
	Content *LayerVersionContentOutput `type:"structure"`

	// The date that the layer version was created, in ISO-8601 format (https://www.w3.org/TR/NOTE-datetime)
	// (YYYY-MM-DDThh:mm:ss.sTZD).
	CreatedDate *string `type:"string"`

	// The description of the version.
	Description *string `type:"string"`

	// The ARN of the layer.
	LayerArn *string `min:"1" type:"string"`

	// The ARN of the layer version.
	LayerVersionArn *string `min:"1" type:"string"`

	// The layer's software license.
	LicenseInfo *string `type:"string"`

	// The version number.
	Version *int64 `type:"long"`
}

// String returns the string representation
func (s GetLayerVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetLayerVersionOutput) GoString() string {
	return s.String()
}

// SetCompatibleRuntimes sets the CompatibleRuntimes field's value.
func (s *GetLayerVersionOutput) SetCompatibleRuntimes(v []*string) *GetLayerVersionOutput {
	s.CompatibleRuntimes = v
	return s
}

// SetContent sets the Content field's value.
func (s *GetLayerVersionOutput) SetContent(v *LayerVersionContentOutput) *GetLayerVersionOutput {
	s.Content = v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *GetLayerVersionOutput) SetCreatedDate(v string) *GetLayerVersionOutput {
	s.CreatedDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetLayerVersionOutput) SetDescription(v string) *GetLayerVersionOutput {
	s.Description = &v
	return s
}

// SetLayerArn sets the LayerArn field's value.
func (s *GetLayerVersionOutput) SetLayerArn(v string) *GetLayerVersionOutput {
	s.LayerArn = &v
	return s
}

// SetLayerVersionArn sets the LayerVersionArn field's value.
func (s *GetLayerVersionOutput) SetLayerVersionArn(v string) *GetLayerVersionOutput {
	s.LayerVersionArn = &v
	return s
}

// SetLicenseInfo sets the LicenseInfo field's value.
func (s *GetLayerVersionOutput) SetLicenseInfo(v string) *GetLayerVersionOutput {
	s.LicenseInfo = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *GetLayerVersionOutput) SetVersion(v int64) *GetLayerVersionOutput {
	s.Version = &v
	return s
}

type GetLayerVersionPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name or Amazon Resource Name (ARN) of the layer.
	//
	// LayerName is a required field
	LayerName *string `location:"uri" locationName:"LayerName" min:"1" type:"string" required:"true"`

	// The version number.
	//
	// VersionNumber is a required field
	VersionNumber *int64 `location:"uri" locationName:"VersionNumber" type:"long" required:"true"`
}

// String returns the string representation
func (s GetLayerVersionPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetLayerVersionPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetLayerVersionPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetLayerVersionPolicyInput"}
	if s.LayerName == nil {
		invalidParams.Add(request.NewErrParamRequired("LayerName"))
	}
	if s.LayerName != nil && len(*s.LayerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LayerName", 1))
	}
	if s.VersionNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("VersionNumber"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLayerName sets the LayerName field's value.
func (s *GetLayerVersionPolicyInput) SetLayerName(v string) *GetLayerVersionPolicyInput {
	s.LayerName = &v
	return s
}

// SetVersionNumber sets the VersionNumber field's value.
func (s *GetLayerVersionPolicyInput) SetVersionNumber(v int64) *GetLayerVersionPolicyInput {
	s.VersionNumber = &v
	return s
}

type GetLayerVersionPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The policy document.
	Policy *string `type:"string"`

	// A unique identifier for the current revision of the policy.
	RevisionId *string `type:"string"`
}

// String returns the string representation
func (s GetLayerVersionPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetLayerVersionPolicyOutput) GoString() string {
	return s.String()
}

// SetPolicy sets the Policy field's value.
func (s *GetLayerVersionPolicyOutput) SetPolicy(v string) *GetLayerVersionPolicyOutput {
	s.Policy = &v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *GetLayerVersionPolicyOutput) SetRevisionId(v string) *GetLayerVersionPolicyOutput {
	s.RevisionId = &v
	return s
}

type GetPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of the Lambda function, version, or alias.
	//
	// Name formats
	//
	//    * Function name - my-function (name-only), my-function:v1 (with alias).
	//
	//    * Function ARN - arn:aws:lambda:us-west-2:123456789012:function:my-function.
	//
	//    * Partial ARN - 123456789012:function:my-function.
	//
	// You can append a version number or alias to any of the formats. The length
	// constraint applies only to the full ARN. If you specify only the function
	// name, it is limited to 64 characters in length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// Specify a version or alias to get the policy for that resource.
	Qualifier *string `location:"querystring" locationName:"Qualifier" min:"1" type:"string"`
}

// String returns the string representation
func (s GetPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPolicyInput"}
	if s.FunctionName == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}
	if s.Qualifier != nil && len(*s.Qualifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Qualifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFunctionName sets the FunctionName field's value.
func (s *GetPolicyInput) SetFunctionName(v string) *GetPolicyInput {
	s.FunctionName = &v
	return s
}

// SetQualifier sets the Qualifier field's value.
func (s *GetPolicyInput) SetQualifier(v string) *GetPolicyInput {
	s.Qualifier = &v
	return s
}

type GetPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The resource-based policy.
	Policy *string `type:"string"`

	// A unique identifier for the current revision of the policy.
	RevisionId *string `type:"string"`
}

// String returns the string representation
func (s GetPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPolicyOutput) GoString() string {
	return s.String()
}

// SetPolicy sets the Policy field's value.
func (s *GetPolicyOutput) SetPolicy(v string) *GetPolicyOutput {
	s.Policy = &v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *GetPolicyOutput) SetRevisionId(v string) *GetPolicyOutput {
	s.RevisionId = &v
	return s
}

type GetProvisionedConcurrencyConfigInput struct {
	_ struct{} `type:"structure"`

	// The name of the Lambda function.
	//
	// Name formats
	//
	//    * Function name - my-function.
	//
	//    * Function ARN - arn:aws:lambda:us-west-2:123456789012:function:my-function.
	//
	//    * Partial ARN - 123456789012:function:my-function.
	//
	// The length constraint applies only to the full ARN. If you specify only the
	// function name, it is limited to 64 characters in length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// The version number or alias name.
	//
	// Qualifier is a required field
	Qualifier *string `location:"querystring" locationName:"Qualifier" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetProvisionedConcurrencyConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetProvisionedConcurrencyConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetProvisionedConcurrencyConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetProvisionedConcurrencyConfigInput"}
	if s.FunctionName == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}
	if s.Qualifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Qualifier"))
	}
	if s.Qualifier != nil && len(*s.Qualifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Qualifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFunctionName sets the FunctionName field's value.
func (s *GetProvisionedConcurrencyConfigInput) SetFunctionName(v string) *GetProvisionedConcurrencyConfigInput {
	s.FunctionName = &v
	return s
}

// SetQualifier sets the Qualifier field's value.
func (s *GetProvisionedConcurrencyConfigInput) SetQualifier(v string) *GetProvisionedConcurrencyConfigInput {
	s.Qualifier = &v
	return s
}

type GetProvisionedConcurrencyConfigOutput struct {
	_ struct{} `type:"structure"`

	// The amount of provisioned concurrency allocated.
	AllocatedProvisionedConcurrentExecutions *int64 `type:"integer"`

	// The amount of provisioned concurrency available.
	AvailableProvisionedConcurrentExecutions *int64 `type:"integer"`

	// The date and time that a user last updated the configuration, in ISO 8601
	// format (https://www.iso.org/iso-8601-date-and-time-format.html).
	LastModified *string `type:"string"`

	// The amount of provisioned concurrency requested.
	RequestedProvisionedConcurrentExecutions *int64 `min:"1" type:"integer"`

	// The status of the allocation process.
	Status *string `type:"string" enum:"ProvisionedConcurrencyStatusEnum"`

	// For failed allocations, the reason that provisioned concurrency could not
	// be allocated.
	StatusReason *string `type:"string"`
}

// String returns the string representation
func (s GetProvisionedConcurrencyConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetProvisionedConcurrencyConfigOutput) GoString() string {
	return s.String()
}

// SetAllocatedProvisionedConcurrentExecutions sets the AllocatedProvisionedConcurrentExecutions field's value.
func (s *GetProvisionedConcurrencyConfigOutput) SetAllocatedProvisionedConcurrentExecutions(v int64) *GetProvisionedConcurrencyConfigOutput {
	s.AllocatedProvisionedConcurrentExecutions = &v
	return s
}

// SetAvailableProvisionedConcurrentExecutions sets the AvailableProvisionedConcurrentExecutions field's value.
func (s *GetProvisionedConcurrencyConfigOutput) SetAvailableProvisionedConcurrentExecutions(v int64) *GetProvisionedConcurrencyConfigOutput {
	s.AvailableProvisionedConcurrentExecutions = &v
	return s
}

// SetLastModified sets the LastModified field's value.
func (s *GetProvisionedConcurrencyConfigOutput) SetLastModified(v string) *GetProvisionedConcurrencyConfigOutput {
	s.LastModified = &v
	return s
}

// SetRequestedProvisionedConcurrentExecutions sets the RequestedProvisionedConcurrentExecutions field's value.
func (s *GetProvisionedConcurrencyConfigOutput) SetRequestedProvisionedConcurrentExecutions(v int64) *GetProvisionedConcurrencyConfigOutput {
	s.RequestedProvisionedConcurrentExecutions = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetProvisionedConcurrencyConfigOutput) SetStatus(v string) *GetProvisionedConcurrencyConfigOutput {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *GetProvisionedConcurrencyConfigOutput) SetStatusReason(v string) *GetProvisionedConcurrencyConfigOutput {
	s.StatusReason = &v
	return s
}

// One of the parameters in the request is invalid.
type InvalidParameterValueException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The exception message.
	Message_ *string `locationName:"message" type:"string"`

	// The exception type.
	Type *string `type:"string"`
}

// String returns the string representation
func (s InvalidParameterValueException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidParameterValueException) GoString() string {
	return s.String()
}

func newErrorInvalidParameterValueException(v protocol.ResponseMetadata) error {
	return &InvalidParameterValueException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidParameterValueException) Code() string {
	return "InvalidParameterValueException"
}

// Message returns the exception's message.
func (s *InvalidParameterValueException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidParameterValueException) OrigErr() error {
	return nil
}

func (s *InvalidParameterValueException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidParameterValueException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidParameterValueException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request body could not be parsed as JSON.
type InvalidRequestContentException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The exception message.
	Message_ *string `locationName:"message" type:"string"`

	// The exception type.
	Type *string `type:"string"`
}

// String returns the string representation
func (s InvalidRequestContentException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidRequestContentException) GoString() string {
	return s.String()
}

func newErrorInvalidRequestContentException(v protocol.ResponseMetadata) error {
	return &InvalidRequestContentException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidRequestContentException) Code() string {
	return "InvalidRequestContentException"
}

// Message returns the exception's message.
func (s *InvalidRequestContentException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidRequestContentException) OrigErr() error {
	return nil
}

func (s *InvalidRequestContentException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidRequestContentException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidRequestContentException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The runtime or runtime version specified is not supported.
type InvalidRuntimeException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	Type *string `type:"string"`
}

// String returns the string representation
func (s InvalidRuntimeException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidRuntimeException) GoString() string {
	return s.String()
}

func newErrorInvalidRuntimeException(v protocol.ResponseMetadata) error {
	return &InvalidRuntimeException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidRuntimeException) Code() string {
	return "InvalidRuntimeException"
}

// Message returns the exception's message.
func (s *InvalidRuntimeException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidRuntimeException) OrigErr() error {
	return nil
}

func (s *InvalidRuntimeException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidRuntimeException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidRuntimeException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The Security Group ID provided in the Lambda function VPC configuration is
// invalid.
type InvalidSecurityGroupIDException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	Type *string `type:"string"`
}

// String returns the string representation
func (s InvalidSecurityGroupIDException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidSecurityGroupIDException) GoString() string {
	return s.String()
}

func newErrorInvalidSecurityGroupIDException(v protocol.ResponseMetadata) error {
	return &InvalidSecurityGroupIDException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidSecurityGroupIDException) Code() string {
	return "InvalidSecurityGroupIDException"
}

// Message returns the exception's message.
func (s *InvalidSecurityGroupIDException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidSecurityGroupIDException) OrigErr() error {
	return nil
}

func (s *InvalidSecurityGroupIDException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidSecurityGroupIDException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidSecurityGroupIDException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The Subnet ID provided in the Lambda function VPC configuration is invalid.
type InvalidSubnetIDException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	Type *string `type:"string"`
}

// String returns the string representation
func (s InvalidSubnetIDException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidSubnetIDException) GoString() string {
	return s.String()
}

func newErrorInvalidSubnetIDException(v protocol.ResponseMetadata) error {
	return &InvalidSubnetIDException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidSubnetIDException) Code() string {
	return "InvalidSubnetIDException"
}

// Message returns the exception's message.
func (s *InvalidSubnetIDException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidSubnetIDException) OrigErr() error {
	return nil
}

func (s *InvalidSubnetIDException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidSubnetIDException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidSubnetIDException) RequestID() string {
	return s.RespMetadata.RequestID
}

// AWS Lambda could not unzip the deployment package.
type InvalidZipFileException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	Type *string `type:"string"`
}

// String returns the string representation
func (s InvalidZipFileException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidZipFileException) GoString() string {
	return s.String()
}

func newErrorInvalidZipFileException(v protocol.ResponseMetadata) error {
	return &InvalidZipFileException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidZipFileException) Code() string {
	return "InvalidZipFileException"
}

// Message returns the exception's message.
func (s *InvalidZipFileException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidZipFileException) OrigErr() error {
	return nil
}

func (s *InvalidZipFileException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidZipFileException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidZipFileException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Deprecated: InvokeAsyncInput has been deprecated
type InvokeAsyncInput struct {
	_ struct{} `deprecated:"true" type:"structure" payload:"InvokeArgs"`

	// The name of the Lambda function.
	//
	// Name formats
	//
	//    * Function name - my-function.
	//
	//    * Function ARN - arn:aws:lambda:us-west-2:123456789012:function:my-function.
	//
	//    * Partial ARN - 123456789012:function:my-function.
	//
	// The length constraint applies only to the full ARN. If you specify only the
	// function name, it is limited to 64 characters in length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// The JSON that you want to provide to your Lambda function as input.
	//
	// InvokeArgs is a required field
	InvokeArgs io.ReadSeeker `type:"blob" required:"true"`
}

// String returns the string representation
func (s InvokeAsyncInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvokeAsyncInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InvokeAsyncInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InvokeAsyncInput"}
	if s.FunctionName == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}
	if s.InvokeArgs == nil {
		invalidParams.Add(request.NewErrParamRequired("InvokeArgs"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFunctionName sets the FunctionName field's value.
func (s *InvokeAsyncInput) SetFunctionName(v string) *InvokeAsyncInput {
	s.FunctionName = &v
	return s
}

// SetInvokeArgs sets the InvokeArgs field's value.
func (s *InvokeAsyncInput) SetInvokeArgs(v io.ReadSeeker) *InvokeAsyncInput {
	s.InvokeArgs = v
	return s
}

// A success response (202 Accepted) indicates that the request is queued for
// invocation.
//
// Deprecated: InvokeAsyncOutput has been deprecated
type InvokeAsyncOutput struct {
	_ struct{} `deprecated:"true" type:"structure"`

	// The status code.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation
func (s InvokeAsyncOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvokeAsyncOutput) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *InvokeAsyncOutput) SetStatus(v int64) *InvokeAsyncOutput {
	s.Status = &v
	return s
}

type InvokeInput struct {
	_ struct{} `type:"structure" payload:"Payload"`

	// Up to 3583 bytes of base64-encoded data about the invoking client to pass
	// to the function in the context object.
	ClientContext *string `location:"header" locationName:"X-Amz-Client-Context" type:"string"`

	// The name of the Lambda function, version, or alias.
	//
	// Name formats
	//
	//    * Function name - my-function (name-only), my-function:v1 (with alias).
	//
	//    * Function ARN - arn:aws:lambda:us-west-2:123456789012:function:my-function.
	//
	//    * Partial ARN - 123456789012:function:my-function.
	//
	// You can append a version number or alias to any of the formats. The length
	// constraint applies only to the full ARN. If you specify only the function
	// name, it is limited to 64 characters in length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// Choose from the following options.
	//
	//    * RequestResponse (default) - Invoke the function synchronously. Keep
	//    the connection open until the function returns a response or times out.
	//    The API response includes the function response and additional data.
	//
	//    * Event - Invoke the function asynchronously. Send events that fail multiple
	//    times to the function's dead-letter queue (if it's configured). The API
	//    response only includes a status code.
	//
	//    * DryRun - Validate parameter values and verify that the user or role
	//    has permission to invoke the function.
	InvocationType *string `location:"header" locationName:"X-Amz-Invocation-Type" type:"string" enum:"InvocationType"`

	// Set to Tail to include the execution log in the response.
	LogType *string `location:"header" locationName:"X-Amz-Log-Type" type:"string" enum:"LogType"`

	// The JSON that you want to provide to your Lambda function as input.
	Payload []byte `type:"blob" sensitive:"true"`

	// Specify a version or alias to invoke a published version of the function.
	Qualifier *string `location:"querystring" locationName:"Qualifier" min:"1" type:"string"`
}

// String returns the string representation
func (s InvokeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvokeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InvokeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InvokeInput"}
	if s.FunctionName == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}
	if s.Qualifier != nil && len(*s.Qualifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Qualifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientContext sets the ClientContext field's value.
func (s *InvokeInput) SetClientContext(v string) *InvokeInput {
	s.ClientContext = &v
	return s
}

// SetFunctionName sets the FunctionName field's value.
func (s *InvokeInput) SetFunctionName(v string) *InvokeInput {
	s.FunctionName = &v
	return s
}

// SetInvocationType sets the InvocationType field's value.
func (s *InvokeInput) SetInvocationType(v string) *InvokeInput {
	s.InvocationType = &v
	return s
}

// SetLogType sets the LogType field's value.
func (s *InvokeInput) SetLogType(v string) *InvokeInput {
	s.LogType = &v
	return s
}

// SetPayload sets the Payload field's value.
func (s *InvokeInput) SetPayload(v []byte) *InvokeInput {
	s.Payload = v
	return s
}

// SetQualifier sets the Qualifier field's value.
func (s *InvokeInput) SetQualifier(v string) *InvokeInput {
	s.Qualifier = &v
	return s
}

type InvokeOutput struct {
	_ struct{} `type:"structure" payload:"Payload"`

	// The version of the function that executed. When you invoke a function with
	// an alias, this indicates which version the alias resolved to.
	ExecutedVersion *string `location:"header" locationName:"X-Amz-Executed-Version" min:"1" type:"string"`

	// If present, indicates that an error occurred during function execution. Details
	// about the error are included in the response payload.
	FunctionError *string `location:"header" locationName:"X-Amz-Function-Error" type:"string"`

	// The last 4 KB of the execution log, which is base64 encoded.
	LogResult *string `location:"header" locationName:"X-Amz-Log-Result" type:"string"`

	// The response from the function, or an error object.
	Payload []byte `type:"blob" sensitive:"true"`

	// The HTTP status code is in the 200 range for a successful request. For the
	// RequestResponse invocation type, this status code is 200. For the Event invocation
	// type, this status code is 202. For the DryRun invocation type, the status
	// code is 204.
	StatusCode *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation
func (s InvokeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvokeOutput) GoString() string {
	return s.String()
}

// SetExecutedVersion sets the ExecutedVersion field's value.
func (s *InvokeOutput) SetExecutedVersion(v string) *InvokeOutput {
	s.ExecutedVersion = &v
	return s
}

// SetFunctionError sets the FunctionError field's value.
func (s *InvokeOutput) SetFunctionError(v string) *InvokeOutput {
	s.FunctionError = &v
	return s
}

// SetLogResult sets the LogResult field's value.
func (s *InvokeOutput) SetLogResult(v string) *InvokeOutput {
	s.LogResult = &v
	return s
}

// SetPayload sets the Payload field's value.
func (s *InvokeOutput) SetPayload(v []byte) *InvokeOutput {
	s.Payload = v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *InvokeOutput) SetStatusCode(v int64) *InvokeOutput {
	s.StatusCode = &v
	return s
}

// Lambda was unable to decrypt the environment variables because KMS access
// was denied. Check the Lambda function's KMS permissions.
type KMSAccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	Type *string `type:"string"`
}

// String returns the string representation
func (s KMSAccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KMSAccessDeniedException) GoString() string {
	return s.String()
}

func newErrorKMSAccessDeniedException(v protocol.ResponseMetadata) error {
	return &KMSAccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *KMSAccessDeniedException) Code() string {
	return "KMSAccessDeniedException"
}

// Message returns the exception's message.
func (s *KMSAccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *KMSAccessDeniedException) OrigErr() error {
	return nil
}

func (s *KMSAccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *KMSAccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *KMSAccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Lambda was unable to decrypt the environment variables because the KMS key
// used is disabled. Check the Lambda function's KMS key settings.
type KMSDisabledException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	Type *string `type:"string"`
}

// String returns the string representation
func (s KMSDisabledException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KMSDisabledException) GoString() string {
	return s.String()
}

func newErrorKMSDisabledException(v protocol.ResponseMetadata) error {
	return &KMSDisabledException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *KMSDisabledException) Code() string {
	return "KMSDisabledException"
}

// Message returns the exception's message.
func (s *KMSDisabledException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *KMSDisabledException) OrigErr() error {
	return nil
}

func (s *KMSDisabledException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *KMSDisabledException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *KMSDisabledException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Lambda was unable to decrypt the environment variables because the KMS key
// used is in an invalid state for Decrypt. Check the function's KMS key settings.
type KMSInvalidStateException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	Type *string `type:"string"`
}

// String returns the string representation
func (s KMSInvalidStateException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KMSInvalidStateException) GoString() string {
	return s.String()
}

func newErrorKMSInvalidStateException(v protocol.ResponseMetadata) error {
	return &KMSInvalidStateException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *KMSInvalidStateException) Code() string {
	return "KMSInvalidStateException"
}

// Message returns the exception's message.
func (s *KMSInvalidStateException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *KMSInvalidStateException) OrigErr() error {
	return nil
}

func (s *KMSInvalidStateException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *KMSInvalidStateException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *KMSInvalidStateException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Lambda was unable to decrypt the environment variables because the KMS key
// was not found. Check the function's KMS key settings.
type KMSNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	Type *string `type:"string"`
}

// String returns the string representation
func (s KMSNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KMSNotFoundException) GoString() string {
	return s.String()
}

func newErrorKMSNotFoundException(v protocol.ResponseMetadata) error {
	return &KMSNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *KMSNotFoundException) Code() string {
	return "KMSNotFoundException"
}

// Message returns the exception's message.
func (s *KMSNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *KMSNotFoundException) OrigErr() error {
	return nil
}

func (s *KMSNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *KMSNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *KMSNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An AWS Lambda layer (https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html).
type Layer struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the function layer.
	Arn *string `min:"1" type:"string"`

	// The size of the layer archive in bytes.
	CodeSize *int64 `type:"long"`
}

// String returns the string representation
func (s Layer) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Layer) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Layer) SetArn(v string) *Layer {
	s.Arn = &v
	return s
}

// SetCodeSize sets the CodeSize field's value.
func (s *Layer) SetCodeSize(v int64) *Layer {
	s.CodeSize = &v
	return s
}

// A ZIP archive that contains the contents of an AWS Lambda layer (https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html).
// You can specify either an Amazon S3 location, or upload a layer archive directly.
type LayerVersionContentInput struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 bucket of the layer archive.
	S3Bucket *string `min:"3" type:"string"`

	// The Amazon S3 key of the layer archive.
	S3Key *string `min:"1" type:"string"`

	// For versioned objects, the version of the layer archive object to use.
	S3ObjectVersion *string `min:"1" type:"string"`

	// The base64-encoded contents of the layer archive. AWS SDK and AWS CLI clients
	// handle the encoding for you.
	//
	// ZipFile is automatically base64 encoded/decoded by the SDK.
	ZipFile []byte `type:"blob" sensitive:"true"`
}

// String returns the string representation
func (s LayerVersionContentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LayerVersionContentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LayerVersionContentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LayerVersionContentInput"}
	if s.S3Bucket != nil && len(*s.S3Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("S3Bucket", 3))
	}
	if s.S3Key != nil && len(*s.S3Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("S3Key", 1))
	}
	if s.S3ObjectVersion != nil && len(*s.S3ObjectVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("S3ObjectVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3Bucket sets the S3Bucket field's value.
func (s *LayerVersionContentInput) SetS3Bucket(v string) *LayerVersionContentInput {
	s.S3Bucket = &v
	return s
}

// SetS3Key sets the S3Key field's value.
func (s *LayerVersionContentInput) SetS3Key(v string) *LayerVersionContentInput {
	s.S3Key = &v
	return s
}

// SetS3ObjectVersion sets the S3ObjectVersion field's value.
func (s *LayerVersionContentInput) SetS3ObjectVersion(v string) *LayerVersionContentInput {
	s.S3ObjectVersion = &v
	return s
}

// SetZipFile sets the ZipFile field's value.
func (s *LayerVersionContentInput) SetZipFile(v []byte) *LayerVersionContentInput {
	s.ZipFile = v
	return s
}

// Details about a version of an AWS Lambda layer (https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html).
type LayerVersionContentOutput struct {
	_ struct{} `type:"structure"`

	// The SHA-256 hash of the layer archive.
	CodeSha256 *string `type:"string"`

	// The size of the layer archive in bytes.
	CodeSize *int64 `type:"long"`

	// A link to the layer archive in Amazon S3 that is valid for 10 minutes.
	Location *string `type:"string"`
}

// String returns the string representation
func (s LayerVersionContentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LayerVersionContentOutput) GoString() string {
	return s.String()
}

// SetCodeSha256 sets the CodeSha256 field's value.
func (s *LayerVersionContentOutput) SetCodeSha256(v string) *LayerVersionContentOutput {
	s.CodeSha256 = &v
	return s
}

// SetCodeSize sets the CodeSize field's value.
func (s *LayerVersionContentOutput) SetCodeSize(v int64) *LayerVersionContentOutput {
	s.CodeSize = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *LayerVersionContentOutput) SetLocation(v string) *LayerVersionContentOutput {
	s.Location = &v
	return s
}

// Details about a version of an AWS Lambda layer (https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html).
type LayerVersionsListItem struct {
	_ struct{} `type:"structure"`

	// The layer's compatible runtimes.
	CompatibleRuntimes []*string `type:"list"`

	// The date that the version was created, in ISO 8601 format. For example, 2018-11-27T15:10:45.123+0000.
	CreatedDate *string `type:"string"`

	// The description of the version.
	Description *string `type:"string"`

	// The ARN of the layer version.
	LayerVersionArn *string `min:"1" type:"string"`

	// The layer's open-source license.
	LicenseInfo *string `type:"string"`

	// The version number.
	Version *int64 `type:"long"`
}

// String returns the string representation
func (s LayerVersionsListItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LayerVersionsListItem) GoString() string {
	return s.String()
}

// SetCompatibleRuntimes sets the CompatibleRuntimes field's value.
func (s *LayerVersionsListItem) SetCompatibleRuntimes(v []*string) *LayerVersionsListItem {
	s.CompatibleRuntimes = v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *LayerVersionsListItem) SetCreatedDate(v string) *LayerVersionsListItem {
	s.CreatedDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *LayerVersionsListItem) SetDescription(v string) *LayerVersionsListItem {
	s.Description = &v
	return s
}

// SetLayerVersionArn sets the LayerVersionArn field's value.
func (s *LayerVersionsListItem) SetLayerVersionArn(v string) *LayerVersionsListItem {
	s.LayerVersionArn = &v
	return s
}

// SetLicenseInfo sets the LicenseInfo field's value.
func (s *LayerVersionsListItem) SetLicenseInfo(v string) *LayerVersionsListItem {
	s.LicenseInfo = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *LayerVersionsListItem) SetVersion(v int64) *LayerVersionsListItem {
	s.Version = &v
	return s
}

// Details about an AWS Lambda layer (https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html).
type LayersListItem struct {
	_ struct{} `type:"structure"`

	// The newest version of the layer.
	LatestMatchingVersion *LayerVersionsListItem `type:"structure"`

	// The Amazon Resource Name (ARN) of the function layer.
	LayerArn *string `min:"1" type:"string"`

	// The name of the layer.
	LayerName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s LayersListItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LayersListItem) GoString() string {
	return s.String()
}

// SetLatestMatchingVersion sets the LatestMatchingVersion field's value.
func (s *LayersListItem) SetLatestMatchingVersion(v *LayerVersionsListItem) *LayersListItem {
	s.LatestMatchingVersion = v
	return s
}

// SetLayerArn sets the LayerArn field's value.
func (s *LayersListItem) SetLayerArn(v string) *LayersListItem {
	s.LayerArn = &v
	return s
}

// SetLayerName sets the LayerName field's value.
func (s *LayersListItem) SetLayerName(v string) *LayersListItem {
	s.LayerName = &v
	return s
}

type ListAliasesInput struct {
	_ struct{} `type:"structure"`

	// The name of the Lambda function.
	//
	// Name formats
	//
	//    * Function name - MyFunction.
	//
	//    * Function ARN - arn:aws:lambda:us-west-2:123456789012:function:MyFunction.
	//
	//    * Partial ARN - 123456789012:function:MyFunction.
	//
	// The length constraint applies only to the full ARN. If you specify only the
	// function name, it is limited to 64 characters in length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// Specify a function version to only list aliases that invoke that version.
	FunctionVersion *string `location:"querystring" locationName:"FunctionVersion" min:"1" type:"string"`

	// Specify the pagination token that's returned by a previous request to retrieve
	// the next page of results.
	Marker *string `location:"querystring" locationName:"Marker" type:"string"`

	// Limit the number of aliases returned.
	MaxItems *int64 `location:"querystring" locationName:"MaxItems" min:"1" type:"integer"`
}

// String returns the string representation
func (s ListAliasesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAliasesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAliasesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAliasesInput"}
	if s.FunctionName == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}
	if s.FunctionVersion != nil && len(*s.FunctionVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionVersion", 1))
	}
	if s.MaxItems != nil && *s.MaxItems < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxItems", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFunctionName sets the FunctionName field's value.
func (s *ListAliasesInput) SetFunctionName(v string) *ListAliasesInput {
	s.FunctionName = &v
	return s
}

// SetFunctionVersion sets the FunctionVersion field's value.
func (s *ListAliasesInput) SetFunctionVersion(v string) *ListAliasesInput {
	s.FunctionVersion = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListAliasesInput) SetMarker(v string) *ListAliasesInput {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListAliasesInput) SetMaxItems(v int64) *ListAliasesInput {
	s.MaxItems = &v
	return s
}

type ListAliasesOutput struct {
	_ struct{} `type:"structure"`

	// A list of aliases.
	Aliases []*AliasConfiguration `type:"list"`

	// The pagination token that's included if more results are available.
	NextMarker *string `type:"string"`
}

// String returns the string representation
func (s ListAliasesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAliasesOutput) GoString() string {
	return s.String()
}

// SetAliases sets the Aliases field's value.
func (s *ListAliasesOutput) SetAliases(v []*AliasConfiguration) *ListAliasesOutput {
	s.Aliases = v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListAliasesOutput) SetNextMarker(v string) *ListAliasesOutput {
	s.NextMarker = &v
	return s
}

type ListEventSourceMappingsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the event source.
	//
	//    * Amazon Kinesis - The ARN of the data stream or a stream consumer.
	//
	//    * Amazon DynamoDB Streams - The ARN of the stream.
	//
	//    * Amazon Simple Queue Service - The ARN of the queue.
	EventSourceArn *string `location:"querystring" locationName:"EventSourceArn" type:"string"`

	// The name of the Lambda function.
	//
	// Name formats
	//
	//    * Function name - MyFunction.
	//
	//    * Function ARN - arn:aws:lambda:us-west-2:123456789012:function:MyFunction.
	//
	//    * Version or Alias ARN - arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD.
	//
	//    * Partial ARN - 123456789012:function:MyFunction.
	//
	// The length constraint applies only to the full ARN. If you specify only the
	// function name, it's limited to 64 characters in length.
	FunctionName *string `location:"querystring" locationName:"FunctionName" min:"1" type:"string"`

	// A pagination token returned by a previous call.
	Marker *string `location:"querystring" locationName:"Marker" type:"string"`

	// The maximum number of event source mappings to return.
	MaxItems *int64 `location:"querystring" locationName:"MaxItems" min:"1" type:"integer"`
}

// String returns the string representation
func (s ListEventSourceMappingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListEventSourceMappingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEventSourceMappingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListEventSourceMappingsInput"}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}
	if s.MaxItems != nil && *s.MaxItems < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxItems", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEventSourceArn sets the EventSourceArn field's value.
func (s *ListEventSourceMappingsInput) SetEventSourceArn(v string) *ListEventSourceMappingsInput {
	s.EventSourceArn = &v
	return s
}

// SetFunctionName sets the FunctionName field's value.
func (s *ListEventSourceMappingsInput) SetFunctionName(v string) *ListEventSourceMappingsInput {
	s.FunctionName = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListEventSourceMappingsInput) SetMarker(v string) *ListEventSourceMappingsInput {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListEventSourceMappingsInput) SetMaxItems(v int64) *ListEventSourceMappingsInput {
	s.MaxItems = &v
	return s
}

type ListEventSourceMappingsOutput struct {
	_ struct{} `type:"structure"`

	// A list of event source mappings.
	EventSourceMappings []*EventSourceMappingConfiguration `type:"list"`

	// A pagination token that's returned when the response doesn't contain all
	// event source mappings.
	NextMarker *string `type:"string"`
}

// String returns the string representation
func (s ListEventSourceMappingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListEventSourceMappingsOutput) GoString() string {
	return s.String()
}

// SetEventSourceMappings sets the EventSourceMappings field's value.
func (s *ListEventSourceMappingsOutput) SetEventSourceMappings(v []*EventSourceMappingConfiguration) *ListEventSourceMappingsOutput {
	s.EventSourceMappings = v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListEventSourceMappingsOutput) SetNextMarker(v string) *ListEventSourceMappingsOutput {
	s.NextMarker = &v
	return s
}

type ListFunctionEventInvokeConfigsInput struct {
	_ struct{} `type:"structure"`

	// The name of the Lambda function.
	//
	// Name formats
	//
	//    * Function name - my-function.
	//
	//    * Function ARN - arn:aws:lambda:us-west-2:123456789012:function:my-function.
	//
	//    * Partial ARN - 123456789012:function:my-function.
	//
	// The length constraint applies only to the full ARN. If you specify only the
	// function name, it is limited to 64 characters in length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// Specify the pagination token that's returned by a previous request to retrieve
	// the next page of results.
	Marker *string `location:"querystring" locationName:"Marker" type:"string"`

	// The maximum number of configurations to return.
	MaxItems *int64 `location:"querystring" locationName:"MaxItems" min:"1" type:"integer"`
}

// String returns the string representation
func (s ListFunctionEventInvokeConfigsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFunctionEventInvokeConfigsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListFunctionEventInvokeConfigsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListFunctionEventInvokeConfigsInput"}
	if s.FunctionName == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}
	if s.MaxItems != nil && *s.MaxItems < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxItems", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFunctionName sets the FunctionName field's value.
func (s *ListFunctionEventInvokeConfigsInput) SetFunctionName(v string) *ListFunctionEventInvokeConfigsInput {
	s.FunctionName = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListFunctionEventInvokeConfigsInput) SetMarker(v string) *ListFunctionEventInvokeConfigsInput {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListFunctionEventInvokeConfigsInput) SetMaxItems(v int64) *ListFunctionEventInvokeConfigsInput {
	s.MaxItems = &v
	return s
}

type ListFunctionEventInvokeConfigsOutput struct {
	_ struct{} `type:"structure"`

	// A list of configurations.
	FunctionEventInvokeConfigs []*FunctionEventInvokeConfig `type:"list"`

	// The pagination token that's included if more results are available.
	NextMarker *string `type:"string"`
}

// String returns the string representation
func (s ListFunctionEventInvokeConfigsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFunctionEventInvokeConfigsOutput) GoString() string {
	return s.String()
}

// SetFunctionEventInvokeConfigs sets the FunctionEventInvokeConfigs field's value.
func (s *ListFunctionEventInvokeConfigsOutput) SetFunctionEventInvokeConfigs(v []*FunctionEventInvokeConfig) *ListFunctionEventInvokeConfigsOutput {
	s.FunctionEventInvokeConfigs = v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListFunctionEventInvokeConfigsOutput) SetNextMarker(v string) *ListFunctionEventInvokeConfigsOutput {
	s.NextMarker = &v
	return s
}

type ListFunctionsInput struct {
	_ struct{} `type:"structure"`

	// Set to ALL to include entries for all published versions of each function.
	FunctionVersion *string `location:"querystring" locationName:"FunctionVersion" type:"string" enum:"FunctionVersion"`

	// Specify the pagination token that's returned by a previous request to retrieve
	// the next page of results.
	Marker *string `location:"querystring" locationName:"Marker" type:"string"`

	// For Lambda@Edge functions, the AWS Region of the master function. For example,
	// us-east-1 filters the list of functions to only include Lambda@Edge functions
	// replicated from a master function in US East (N. Virginia). If specified,
	// you must set FunctionVersion to ALL.
	MasterRegion *string `location:"querystring" locationName:"MasterRegion" type:"string"`

	// The maximum number of functions to return.
	MaxItems *int64 `location:"querystring" locationName:"MaxItems" min:"1" type:"integer"`
}

// String returns the string representation
func (s ListFunctionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFunctionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListFunctionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListFunctionsInput"}
	if s.MaxItems != nil && *s.MaxItems < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxItems", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFunctionVersion sets the FunctionVersion field's value.
func (s *ListFunctionsInput) SetFunctionVersion(v string) *ListFunctionsInput {
	s.FunctionVersion = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListFunctionsInput) SetMarker(v string) *ListFunctionsInput {
	s.Marker = &v
	return s
}

// SetMasterRegion sets the MasterRegion field's value.
func (s *ListFunctionsInput) SetMasterRegion(v string) *ListFunctionsInput {
	s.MasterRegion = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListFunctionsInput) SetMaxItems(v int64) *ListFunctionsInput {
	s.MaxItems = &v
	return s
}

// A list of Lambda functions.
type ListFunctionsOutput struct {
	_ struct{} `type:"structure"`

	// A list of Lambda functions.
	Functions []*FunctionConfiguration `type:"list"`

	// The pagination token that's included if more results are available.
	NextMarker *string `type:"string"`
}

// String returns the string representation
func (s ListFunctionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFunctionsOutput) GoString() string {
	return s.String()
}

// SetFunctions sets the Functions field's value.
func (s *ListFunctionsOutput) SetFunctions(v []*FunctionConfiguration) *ListFunctionsOutput {
	s.Functions = v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListFunctionsOutput) SetNextMarker(v string) *ListFunctionsOutput {
	s.NextMarker = &v
	return s
}

type ListLayerVersionsInput struct {
	_ struct{} `type:"structure"`

	// A runtime identifier. For example, go1.x.
	CompatibleRuntime *string `location:"querystring" locationName:"CompatibleRuntime" type:"string" enum:"Runtime"`

	// The name or Amazon Resource Name (ARN) of the layer.
	//
	// LayerName is a required field
	LayerName *string `location:"uri" locationName:"LayerName" min:"1" type:"string" required:"true"`

	// A pagination token returned by a previous call.
	Marker *string `location:"querystring" locationName:"Marker" type:"string"`

	// The maximum number of versions to return.
	MaxItems *int64 `location:"querystring" locationName:"MaxItems" min:"1" type:"integer"`
}

// String returns the string representation
func (s ListLayerVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListLayerVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListLayerVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListLayerVersionsInput"}
	if s.LayerName == nil {
		invalidParams.Add(request.NewErrParamRequired("LayerName"))
	}
	if s.LayerName != nil && len(*s.LayerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LayerName", 1))
	}
	if s.MaxItems != nil && *s.MaxItems < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxItems", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCompatibleRuntime sets the CompatibleRuntime field's value.
func (s *ListLayerVersionsInput) SetCompatibleRuntime(v string) *ListLayerVersionsInput {
	s.CompatibleRuntime = &v
	return s
}

// SetLayerName sets the LayerName field's value.
func (s *ListLayerVersionsInput) SetLayerName(v string) *ListLayerVersionsInput {
	s.LayerName = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListLayerVersionsInput) SetMarker(v string) *ListLayerVersionsInput {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListLayerVersionsInput) SetMaxItems(v int64) *ListLayerVersionsInput {
	s.MaxItems = &v
	return s
}

type ListLayerVersionsOutput struct {
	_ struct{} `type:"structure"`

	// A list of versions.
	LayerVersions []*LayerVersionsListItem `type:"list"`

	// A pagination token returned when the response doesn't contain all versions.
	NextMarker *string `type:"string"`
}

// String returns the string representation
func (s ListLayerVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListLayerVersionsOutput) GoString() string {
	return s.String()
}

// SetLayerVersions sets the LayerVersions field's value.
func (s *ListLayerVersionsOutput) SetLayerVersions(v []*LayerVersionsListItem) *ListLayerVersionsOutput {
	s.LayerVersions = v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListLayerVersionsOutput) SetNextMarker(v string) *ListLayerVersionsOutput {
	s.NextMarker = &v
	return s
}

type ListLayersInput struct {
	_ struct{} `type:"structure"`

	// A runtime identifier. For example, go1.x.
	CompatibleRuntime *string `location:"querystring" locationName:"CompatibleRuntime" type:"string" enum:"Runtime"`

	// A pagination token returned by a previous call.
	Marker *string `location:"querystring" locationName:"Marker" type:"string"`

	// The maximum number of layers to return.
	MaxItems *int64 `location:"querystring" locationName:"MaxItems" min:"1" type:"integer"`
}

// String returns the string representation
func (s ListLayersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListLayersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListLayersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListLayersInput"}
	if s.MaxItems != nil && *s.MaxItems < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxItems", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCompatibleRuntime sets the CompatibleRuntime field's value.
func (s *ListLayersInput) SetCompatibleRuntime(v string) *ListLayersInput {
	s.CompatibleRuntime = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListLayersInput) SetMarker(v string) *ListLayersInput {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListLayersInput) SetMaxItems(v int64) *ListLayersInput {
	s.MaxItems = &v
	return s
}

type ListLayersOutput struct {
	_ struct{} `type:"structure"`

	// A list of function layers.
	Layers []*LayersListItem `type:"list"`

	// A pagination token returned when the response doesn't contain all layers.
	NextMarker *string `type:"string"`
}

// String returns the string representation
func (s ListLayersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListLayersOutput) GoString() string {
	return s.String()
}

// SetLayers sets the Layers field's value.
func (s *ListLayersOutput) SetLayers(v []*LayersListItem) *ListLayersOutput {
	s.Layers = v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListLayersOutput) SetNextMarker(v string) *ListLayersOutput {
	s.NextMarker = &v
	return s
}

type ListProvisionedConcurrencyConfigsInput struct {
	_ struct{} `type:"structure"`

	// The name of the Lambda function.
	//
	// Name formats
	//
	//    * Function name - my-function.
	//
	//    * Function ARN - arn:aws:lambda:us-west-2:123456789012:function:my-function.
	//
	//    * Partial ARN - 123456789012:function:my-function.
	//
	// The length constraint applies only to the full ARN. If you specify only the
	// function name, it is limited to 64 characters in length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// Specify the pagination token that's returned by a previous request to retrieve
	// the next page of results.
	Marker *string `location:"querystring" locationName:"Marker" type:"string"`

	// Specify a number to limit the number of configurations returned.
	MaxItems *int64 `location:"querystring" locationName:"MaxItems" min:"1" type:"integer"`
}

// String returns the string representation
func (s ListProvisionedConcurrencyConfigsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListProvisionedConcurrencyConfigsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListProvisionedConcurrencyConfigsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListProvisionedConcurrencyConfigsInput"}
	if s.FunctionName == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}
	if s.MaxItems != nil && *s.MaxItems < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxItems", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFunctionName sets the FunctionName field's value.
func (s *ListProvisionedConcurrencyConfigsInput) SetFunctionName(v string) *ListProvisionedConcurrencyConfigsInput {
	s.FunctionName = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListProvisionedConcurrencyConfigsInput) SetMarker(v string) *ListProvisionedConcurrencyConfigsInput {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListProvisionedConcurrencyConfigsInput) SetMaxItems(v int64) *ListProvisionedConcurrencyConfigsInput {
	s.MaxItems = &v
	return s
}

type ListProvisionedConcurrencyConfigsOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token that's included if more results are available.
	NextMarker *string `type:"string"`

	// A list of provisioned concurrency configurations.
	ProvisionedConcurrencyConfigs []*ProvisionedConcurrencyConfigListItem `type:"list"`
}

// String returns the string representation
func (s ListProvisionedConcurrencyConfigsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListProvisionedConcurrencyConfigsOutput) GoString() string {
	return s.String()
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListProvisionedConcurrencyConfigsOutput) SetNextMarker(v string) *ListProvisionedConcurrencyConfigsOutput {
	s.NextMarker = &v
	return s
}

// SetProvisionedConcurrencyConfigs sets the ProvisionedConcurrencyConfigs field's value.
func (s *ListProvisionedConcurrencyConfigsOutput) SetProvisionedConcurrencyConfigs(v []*ProvisionedConcurrencyConfigListItem) *ListProvisionedConcurrencyConfigsOutput {
	s.ProvisionedConcurrencyConfigs = v
	return s
}

type ListTagsInput struct {
	_ struct{} `type:"structure"`

	// The function's Amazon Resource Name (ARN).
	//
	// Resource is a required field
	Resource *string `location:"uri" locationName:"ARN" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsInput"}
	if s.Resource == nil {
		invalidParams.Add(request.NewErrParamRequired("Resource"))
	}
	if s.Resource != nil && len(*s.Resource) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Resource", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResource sets the Resource field's value.
func (s *ListTagsInput) SetResource(v string) *ListTagsInput {
	s.Resource = &v
	return s
}

type ListTagsOutput struct {
	_ struct{} `type:"structure"`

	// The function's tags.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation
func (s ListTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsOutput) SetTags(v map[string]*string) *ListTagsOutput {
	s.Tags = v
	return s
}

type ListVersionsByFunctionInput struct {
	_ struct{} `type:"structure"`

	// The name of the Lambda function.
	//
	// Name formats
	//
	//    * Function name - MyFunction.
	//
	//    * Function ARN - arn:aws:lambda:us-west-2:123456789012:function:MyFunction.
	//
	//    * Partial ARN - 123456789012:function:MyFunction.
	//
	// The length constraint applies only to the full ARN. If you specify only the
	// function name, it is limited to 64 characters in length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// Specify the pagination token that's returned by a previous request to retrieve
	// the next page of results.
	Marker *string `location:"querystring" locationName:"Marker" type:"string"`

	// The maximum number of versions to return.
	MaxItems *int64 `location:"querystring" locationName:"MaxItems" min:"1" type:"integer"`
}

// String returns the string representation
func (s ListVersionsByFunctionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListVersionsByFunctionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListVersionsByFunctionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListVersionsByFunctionInput"}
	if s.FunctionName == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}
	if s.MaxItems != nil && *s.MaxItems < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxItems", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFunctionName sets the FunctionName field's value.
func (s *ListVersionsByFunctionInput) SetFunctionName(v string) *ListVersionsByFunctionInput {
	s.FunctionName = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListVersionsByFunctionInput) SetMarker(v string) *ListVersionsByFunctionInput {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListVersionsByFunctionInput) SetMaxItems(v int64) *ListVersionsByFunctionInput {
	s.MaxItems = &v
	return s
}

type ListVersionsByFunctionOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token that's included if more results are available.
	NextMarker *string `type:"string"`

	// A list of Lambda function versions.
	Versions []*FunctionConfiguration `type:"list"`
}

// String returns the string representation
func (s ListVersionsByFunctionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListVersionsByFunctionOutput) GoString() string {
	return s.String()
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListVersionsByFunctionOutput) SetNextMarker(v string) *ListVersionsByFunctionOutput {
	s.NextMarker = &v
	return s
}

// SetVersions sets the Versions field's value.
func (s *ListVersionsByFunctionOutput) SetVersions(v []*FunctionConfiguration) *ListVersionsByFunctionOutput {
	s.Versions = v
	return s
}

// A destination for events that failed processing.
type OnFailure struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the destination resource.
	Destination *string `type:"string"`
}

// String returns the string representation
func (s OnFailure) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OnFailure) GoString() string {
	return s.String()
}

// SetDestination sets the Destination field's value.
func (s *OnFailure) SetDestination(v string) *OnFailure {
	s.Destination = &v
	return s
}

// A destination for events that were processed successfully.
type OnSuccess struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the destination resource.
	Destination *string `type:"string"`
}

// String returns the string representation
func (s OnSuccess) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OnSuccess) GoString() string {
	return s.String()
}

// SetDestination sets the Destination field's value.
func (s *OnSuccess) SetDestination(v string) *OnSuccess {
	s.Destination = &v
	return s
}

// The permissions policy for the resource is too large. Learn more (https://docs.aws.amazon.com/lambda/latest/dg/limits.html)
type PolicyLengthExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	Type *string `type:"string"`
}

// String returns the string representation
func (s PolicyLengthExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PolicyLengthExceededException) GoString() string {
	return s.String()
}

func newErrorPolicyLengthExceededException(v protocol.ResponseMetadata) error {
	return &PolicyLengthExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *PolicyLengthExceededException) Code() string {
	return "PolicyLengthExceededException"
}

// Message returns the exception's message.
func (s *PolicyLengthExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *PolicyLengthExceededException) OrigErr() error {
	return nil
}

func (s *PolicyLengthExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *PolicyLengthExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *PolicyLengthExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The RevisionId provided does not match the latest RevisionId for the Lambda
// function or alias. Call the GetFunction or the GetAlias API to retrieve the
// latest RevisionId for your resource.
type PreconditionFailedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The exception message.
	Message_ *string `locationName:"message" type:"string"`

	// The exception type.
	Type *string `type:"string"`
}

// String returns the string representation
func (s PreconditionFailedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PreconditionFailedException) GoString() string {
	return s.String()
}

func newErrorPreconditionFailedException(v protocol.ResponseMetadata) error {
	return &PreconditionFailedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *PreconditionFailedException) Code() string {
	return "PreconditionFailedException"
}

// Message returns the exception's message.
func (s *PreconditionFailedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *PreconditionFailedException) OrigErr() error {
	return nil
}

func (s *PreconditionFailedException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *PreconditionFailedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *PreconditionFailedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Details about the provisioned concurrency configuration for a function alias
// or version.
type ProvisionedConcurrencyConfigListItem struct {
	_ struct{} `type:"structure"`

	// The amount of provisioned concurrency allocated.
	AllocatedProvisionedConcurrentExecutions *int64 `type:"integer"`

	// The amount of provisioned concurrency available.
	AvailableProvisionedConcurrentExecutions *int64 `type:"integer"`

	// The Amazon Resource Name (ARN) of the alias or version.
	FunctionArn *string `type:"string"`

	// The date and time that a user last updated the configuration, in ISO 8601
	// format (https://www.iso.org/iso-8601-date-and-time-format.html).
	LastModified *string `type:"string"`

	// The amount of provisioned concurrency requested.
	RequestedProvisionedConcurrentExecutions *int64 `min:"1" type:"integer"`

	// The status of the allocation process.
	Status *string `type:"string" enum:"ProvisionedConcurrencyStatusEnum"`

	// For failed allocations, the reason that provisioned concurrency could not
	// be allocated.
	StatusReason *string `type:"string"`
}

// String returns the string representation
func (s ProvisionedConcurrencyConfigListItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProvisionedConcurrencyConfigListItem) GoString() string {
	return s.String()
}

// SetAllocatedProvisionedConcurrentExecutions sets the AllocatedProvisionedConcurrentExecutions field's value.
func (s *ProvisionedConcurrencyConfigListItem) SetAllocatedProvisionedConcurrentExecutions(v int64) *ProvisionedConcurrencyConfigListItem {
	s.AllocatedProvisionedConcurrentExecutions = &v
	return s
}

// SetAvailableProvisionedConcurrentExecutions sets the AvailableProvisionedConcurrentExecutions field's value.
func (s *ProvisionedConcurrencyConfigListItem) SetAvailableProvisionedConcurrentExecutions(v int64) *ProvisionedConcurrencyConfigListItem {
	s.AvailableProvisionedConcurrentExecutions = &v
	return s
}

// SetFunctionArn sets the FunctionArn field's value.
func (s *ProvisionedConcurrencyConfigListItem) SetFunctionArn(v string) *ProvisionedConcurrencyConfigListItem {
	s.FunctionArn = &v
	return s
}

// SetLastModified sets the LastModified field's value.
func (s *ProvisionedConcurrencyConfigListItem) SetLastModified(v string) *ProvisionedConcurrencyConfigListItem {
	s.LastModified = &v
	return s
}

// SetRequestedProvisionedConcurrentExecutions sets the RequestedProvisionedConcurrentExecutions field's value.
func (s *ProvisionedConcurrencyConfigListItem) SetRequestedProvisionedConcurrentExecutions(v int64) *ProvisionedConcurrencyConfigListItem {
	s.RequestedProvisionedConcurrentExecutions = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ProvisionedConcurrencyConfigListItem) SetStatus(v string) *ProvisionedConcurrencyConfigListItem {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *ProvisionedConcurrencyConfigListItem) SetStatusReason(v string) *ProvisionedConcurrencyConfigListItem {
	s.StatusReason = &v
	return s
}

// The specified configuration does not exist.
type ProvisionedConcurrencyConfigNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	Type *string `type:"string"`
}

// String returns the string representation
func (s ProvisionedConcurrencyConfigNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProvisionedConcurrencyConfigNotFoundException) GoString() string {
	return s.String()
}

func newErrorProvisionedConcurrencyConfigNotFoundException(v protocol.ResponseMetadata) error {
	return &ProvisionedConcurrencyConfigNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ProvisionedConcurrencyConfigNotFoundException) Code() string {
	return "ProvisionedConcurrencyConfigNotFoundException"
}

// Message returns the exception's message.
func (s *ProvisionedConcurrencyConfigNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ProvisionedConcurrencyConfigNotFoundException) OrigErr() error {
	return nil
}

func (s *ProvisionedConcurrencyConfigNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ProvisionedConcurrencyConfigNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ProvisionedConcurrencyConfigNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

type PublishLayerVersionInput struct {
	_ struct{} `type:"structure"`

	// A list of compatible function runtimes (https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html).
	// Used for filtering with ListLayers and ListLayerVersions.
	CompatibleRuntimes []*string `type:"list"`

	// The function layer archive.
	//
	// Content is a required field
	Content *LayerVersionContentInput `type:"structure" required:"true"`

	// The description of the version.
	Description *string `type:"string"`

	// The name or Amazon Resource Name (ARN) of the layer.
	//
	// LayerName is a required field
	LayerName *string `location:"uri" locationName:"LayerName" min:"1" type:"string" required:"true"`

	// The layer's software license. It can be any of the following:
	//
	//    * An SPDX license identifier (https://spdx.org/licenses/). For example,
	//    MIT.
	//
	//    * The URL of a license hosted on the internet. For example, https://opensource.org/licenses/MIT.
	//
	//    * The full text of the license.
	LicenseInfo *string `type:"string"`
}

// String returns the string representation
func (s PublishLayerVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PublishLayerVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PublishLayerVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PublishLayerVersionInput"}
	if s.Content == nil {
		invalidParams.Add(request.NewErrParamRequired("Content"))
	}
	if s.LayerName == nil {
		invalidParams.Add(request.NewErrParamRequired("LayerName"))
	}
	if s.LayerName != nil && len(*s.LayerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LayerName", 1))
	}
	if s.Content != nil {
		if err := s.Content.Validate(); err != nil {
			invalidParams.AddNested("Content", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCompatibleRuntimes sets the CompatibleRuntimes field's value.
func (s *PublishLayerVersionInput) SetCompatibleRuntimes(v []*string) *PublishLayerVersionInput {
	s.CompatibleRuntimes = v
	return s
}

// SetContent sets the Content field's value.
func (s *PublishLayerVersionInput) SetContent(v *LayerVersionContentInput) *PublishLayerVersionInput {
	s.Content = v
	return s
}

// SetDescription sets the Description field's value.
func (s *PublishLayerVersionInput) SetDescription(v string) *PublishLayerVersionInput {
	s.Description = &v
	return s
}

// SetLayerName sets the LayerName field's value.
func (s *PublishLayerVersionInput) SetLayerName(v string) *PublishLayerVersionInput {
	s.LayerName = &v
	return s
}

// SetLicenseInfo sets the LicenseInfo field's value.
func (s *PublishLayerVersionInput) SetLicenseInfo(v string) *PublishLayerVersionInput {
	s.LicenseInfo = &v
	return s
}

type PublishLayerVersionOutput struct {
	_ struct{} `type:"structure"`

	// The layer's compatible runtimes.
	CompatibleRuntimes []*string `type:"list"`

	// Details about the layer version.
	Content *LayerVersionContentOutput `type:"structure"`

	// The date that the layer version was created, in ISO-8601 format (https://www.w3.org/TR/NOTE-datetime)
	// (YYYY-MM-DDThh:mm:ss.sTZD).
	CreatedDate *string `type:"string"`

	// The description of the version.
	Description *string `type:"string"`

	// The ARN of the layer.
	LayerArn *string `min:"1" type:"string"`

	// The ARN of the layer version.
	LayerVersionArn *string `min:"1" type:"string"`

	// The layer's software license.
	LicenseInfo *string `type:"string"`

	// The version number.
	Version *int64 `type:"long"`
}

// String returns the string representation
func (s PublishLayerVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PublishLayerVersionOutput) GoString() string {
	return s.String()
}

// SetCompatibleRuntimes sets the CompatibleRuntimes field's value.
func (s *PublishLayerVersionOutput) SetCompatibleRuntimes(v []*string) *PublishLayerVersionOutput {
	s.CompatibleRuntimes = v
	return s
}

// SetContent sets the Content field's value.
func (s *PublishLayerVersionOutput) SetContent(v *LayerVersionContentOutput) *PublishLayerVersionOutput {
	s.Content = v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *PublishLayerVersionOutput) SetCreatedDate(v string) *PublishLayerVersionOutput {
	s.CreatedDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *PublishLayerVersionOutput) SetDescription(v string) *PublishLayerVersionOutput {
	s.Description = &v
	return s
}

// SetLayerArn sets the LayerArn field's value.
func (s *PublishLayerVersionOutput) SetLayerArn(v string) *PublishLayerVersionOutput {
	s.LayerArn = &v
	return s
}

// SetLayerVersionArn sets the LayerVersionArn field's value.
func (s *PublishLayerVersionOutput) SetLayerVersionArn(v string) *PublishLayerVersionOutput {
	s.LayerVersionArn = &v
	return s
}

// SetLicenseInfo sets the LicenseInfo field's value.
func (s *PublishLayerVersionOutput) SetLicenseInfo(v string) *PublishLayerVersionOutput {
	s.LicenseInfo = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *PublishLayerVersionOutput) SetVersion(v int64) *PublishLayerVersionOutput {
	s.Version = &v
	return s
}

type PublishVersionInput struct {
	_ struct{} `type:"structure"`

	// Only publish a version if the hash value matches the value that's specified.
	// Use this option to avoid publishing a version if the function code has changed
	// since you last updated it. You can get the hash for the version that you
	// uploaded from the output of UpdateFunctionCode.
	CodeSha256 *string `type:"string"`

	// A description for the version to override the description in the function
	// configuration.
	Description *string `type:"string"`

	// The name of the Lambda function.
	//
	// Name formats
	//
	//    * Function name - MyFunction.
	//
	//    * Function ARN - arn:aws:lambda:us-west-2:123456789012:function:MyFunction.
	//
	//    * Partial ARN - 123456789012:function:MyFunction.
	//
	// The length constraint applies only to the full ARN. If you specify only the
	// function name, it is limited to 64 characters in length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// Only update the function if the revision ID matches the ID that's specified.
	// Use this option to avoid publishing a version if the function configuration
	// has changed since you last updated it.
	RevisionId *string `type:"string"`
}

// String returns the string representation
func (s PublishVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PublishVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PublishVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PublishVersionInput"}
	if s.FunctionName == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCodeSha256 sets the CodeSha256 field's value.
func (s *PublishVersionInput) SetCodeSha256(v string) *PublishVersionInput {
	s.CodeSha256 = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *PublishVersionInput) SetDescription(v string) *PublishVersionInput {
	s.Description = &v
	return s
}

// SetFunctionName sets the FunctionName field's value.
func (s *PublishVersionInput) SetFunctionName(v string) *PublishVersionInput {
	s.FunctionName = &v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *PublishVersionInput) SetRevisionId(v string) *PublishVersionInput {
	s.RevisionId = &v
	return s
}

type PutFunctionConcurrencyInput struct {
	_ struct{} `type:"structure"`

	// The name of the Lambda function.
	//
	// Name formats
	//
	//    * Function name - my-function.
	//
	//    * Function ARN - arn:aws:lambda:us-west-2:123456789012:function:my-function.
	//
	//    * Partial ARN - 123456789012:function:my-function.
	//
	// The length constraint applies only to the full ARN. If you specify only the
	// function name, it is limited to 64 characters in length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// The number of simultaneous executions to reserve for the function.
	//
	// ReservedConcurrentExecutions is a required field
	ReservedConcurrentExecutions *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s PutFunctionConcurrencyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutFunctionConcurrencyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutFunctionConcurrencyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutFunctionConcurrencyInput"}
	if s.FunctionName == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}
	if s.ReservedConcurrentExecutions == nil {
		invalidParams.Add(request.NewErrParamRequired("ReservedConcurrentExecutions"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFunctionName sets the FunctionName field's value.
func (s *PutFunctionConcurrencyInput) SetFunctionName(v string) *PutFunctionConcurrencyInput {
	s.FunctionName = &v
	return s
}

// SetReservedConcurrentExecutions sets the ReservedConcurrentExecutions field's value.
func (s *PutFunctionConcurrencyInput) SetReservedConcurrentExecutions(v int64) *PutFunctionConcurrencyInput {
	s.ReservedConcurrentExecutions = &v
	return s
}

type PutFunctionConcurrencyOutput struct {
	_ struct{} `type:"structure"`

	// The number of concurrent executions that are reserved for this function.
	// For more information, see Managing Concurrency (https://docs.aws.amazon.com/lambda/latest/dg/concurrent-executions.html).
	ReservedConcurrentExecutions *int64 `type:"integer"`
}

// String returns the string representation
func (s PutFunctionConcurrencyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutFunctionConcurrencyOutput) GoString() string {
	return s.String()
}

// SetReservedConcurrentExecutions sets the ReservedConcurrentExecutions field's value.
func (s *PutFunctionConcurrencyOutput) SetReservedConcurrentExecutions(v int64) *PutFunctionConcurrencyOutput {
	s.ReservedConcurrentExecutions = &v
	return s
}

type PutFunctionEventInvokeConfigInput struct {
	_ struct{} `type:"structure"`

	// A destination for events after they have been sent to a function for processing.
	//
	// Destinations
	//
	//    * Function - The Amazon Resource Name (ARN) of a Lambda function.
	//
	//    * Queue - The ARN of an SQS queue.
	//
	//    * Topic - The ARN of an SNS topic.
	//
	//    * Event Bus - The ARN of an Amazon EventBridge event bus.
	DestinationConfig *DestinationConfig `type:"structure"`

	// The name of the Lambda function, version, or alias.
	//
	// Name formats
	//
	//    * Function name - my-function (name-only), my-function:v1 (with alias).
	//
	//    * Function ARN - arn:aws:lambda:us-west-2:123456789012:function:my-function.
	//
	//    * Partial ARN - 123456789012:function:my-function.
	//
	// You can append a version number or alias to any of the formats. The length
	// constraint applies only to the full ARN. If you specify only the function
	// name, it is limited to 64 characters in length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// The maximum age of a request that Lambda sends to a function for processing.
	MaximumEventAgeInSeconds *int64 `min:"60" type:"integer"`

	// The maximum number of times to retry when the function returns an error.
	MaximumRetryAttempts *int64 `type:"integer"`

	// A version number or alias name.
	Qualifier *string `location:"querystring" locationName:"Qualifier" min:"1" type:"string"`
}

// String returns the string representation
func (s PutFunctionEventInvokeConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutFunctionEventInvokeConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutFunctionEventInvokeConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutFunctionEventInvokeConfigInput"}
	if s.FunctionName == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}
	if s.MaximumEventAgeInSeconds != nil && *s.MaximumEventAgeInSeconds < 60 {
		invalidParams.Add(request.NewErrParamMinValue("MaximumEventAgeInSeconds", 60))
	}
	if s.Qualifier != nil && len(*s.Qualifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Qualifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestinationConfig sets the DestinationConfig field's value.
func (s *PutFunctionEventInvokeConfigInput) SetDestinationConfig(v *DestinationConfig) *PutFunctionEventInvokeConfigInput {
	s.DestinationConfig = v
	return s
}

// SetFunctionName sets the FunctionName field's value.
func (s *PutFunctionEventInvokeConfigInput) SetFunctionName(v string) *PutFunctionEventInvokeConfigInput {
	s.FunctionName = &v
	return s
}

// SetMaximumEventAgeInSeconds sets the MaximumEventAgeInSeconds field's value.
func (s *PutFunctionEventInvokeConfigInput) SetMaximumEventAgeInSeconds(v int64) *PutFunctionEventInvokeConfigInput {
	s.MaximumEventAgeInSeconds = &v
	return s
}

// SetMaximumRetryAttempts sets the MaximumRetryAttempts field's value.
func (s *PutFunctionEventInvokeConfigInput) SetMaximumRetryAttempts(v int64) *PutFunctionEventInvokeConfigInput {
	s.MaximumRetryAttempts = &v
	return s
}

// SetQualifier sets the Qualifier field's value.
func (s *PutFunctionEventInvokeConfigInput) SetQualifier(v string) *PutFunctionEventInvokeConfigInput {
	s.Qualifier = &v
	return s
}

type PutFunctionEventInvokeConfigOutput struct {
	_ struct{} `type:"structure"`

	// A destination for events after they have been sent to a function for processing.
	//
	// Destinations
	//
	//    * Function - The Amazon Resource Name (ARN) of a Lambda function.
	//
	//    * Queue - The ARN of an SQS queue.
	//
	//    * Topic - The ARN of an SNS topic.
	//
	//    * Event Bus - The ARN of an Amazon EventBridge event bus.
	DestinationConfig *DestinationConfig `type:"structure"`

	// The Amazon Resource Name (ARN) of the function.
	FunctionArn *string `type:"string"`

	// The date and time that the configuration was last updated.
	LastModified *time.Time `type:"timestamp"`

	// The maximum age of a request that Lambda sends to a function for processing.
	MaximumEventAgeInSeconds *int64 `min:"60" type:"integer"`

	// The maximum number of times to retry when the function returns an error.
	MaximumRetryAttempts *int64 `type:"integer"`
}

// String returns the string representation
func (s PutFunctionEventInvokeConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutFunctionEventInvokeConfigOutput) GoString() string {
	return s.String()
}

// SetDestinationConfig sets the DestinationConfig field's value.
func (s *PutFunctionEventInvokeConfigOutput) SetDestinationConfig(v *DestinationConfig) *PutFunctionEventInvokeConfigOutput {
	s.DestinationConfig = v
	return s
}

// SetFunctionArn sets the FunctionArn field's value.
func (s *PutFunctionEventInvokeConfigOutput) SetFunctionArn(v string) *PutFunctionEventInvokeConfigOutput {
	s.FunctionArn = &v
	return s
}

// SetLastModified sets the LastModified field's value.
func (s *PutFunctionEventInvokeConfigOutput) SetLastModified(v time.Time) *PutFunctionEventInvokeConfigOutput {
	s.LastModified = &v
	return s
}

// SetMaximumEventAgeInSeconds sets the MaximumEventAgeInSeconds field's value.
func (s *PutFunctionEventInvokeConfigOutput) SetMaximumEventAgeInSeconds(v int64) *PutFunctionEventInvokeConfigOutput {
	s.MaximumEventAgeInSeconds = &v
	return s
}

// SetMaximumRetryAttempts sets the MaximumRetryAttempts field's value.
func (s *PutFunctionEventInvokeConfigOutput) SetMaximumRetryAttempts(v int64) *PutFunctionEventInvokeConfigOutput {
	s.MaximumRetryAttempts = &v
	return s
}

type PutProvisionedConcurrencyConfigInput struct {
	_ struct{} `type:"structure"`

	// The name of the Lambda function.
	//
	// Name formats
	//
	//    * Function name - my-function.
	//
	//    * Function ARN - arn:aws:lambda:us-west-2:123456789012:function:my-function.
	//
	//    * Partial ARN - 123456789012:function:my-function.
	//
	// The length constraint applies only to the full ARN. If you specify only the
	// function name, it is limited to 64 characters in length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// The amount of provisioned concurrency to allocate for the version or alias.
	//
	// ProvisionedConcurrentExecutions is a required field
	ProvisionedConcurrentExecutions *int64 `min:"1" type:"integer" required:"true"`

	// The version number or alias name.
	//
	// Qualifier is a required field
	Qualifier *string `location:"querystring" locationName:"Qualifier" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s PutProvisionedConcurrencyConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutProvisionedConcurrencyConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutProvisionedConcurrencyConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutProvisionedConcurrencyConfigInput"}
	if s.FunctionName == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}
	if s.ProvisionedConcurrentExecutions == nil {
		invalidParams.Add(request.NewErrParamRequired("ProvisionedConcurrentExecutions"))
	}
	if s.ProvisionedConcurrentExecutions != nil && *s.ProvisionedConcurrentExecutions < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ProvisionedConcurrentExecutions", 1))
	}
	if s.Qualifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Qualifier"))
	}
	if s.Qualifier != nil && len(*s.Qualifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Qualifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFunctionName sets the FunctionName field's value.
func (s *PutProvisionedConcurrencyConfigInput) SetFunctionName(v string) *PutProvisionedConcurrencyConfigInput {
	s.FunctionName = &v
	return s
}

// SetProvisionedConcurrentExecutions sets the ProvisionedConcurrentExecutions field's value.
func (s *PutProvisionedConcurrencyConfigInput) SetProvisionedConcurrentExecutions(v int64) *PutProvisionedConcurrencyConfigInput {
	s.ProvisionedConcurrentExecutions = &v
	return s
}

// SetQualifier sets the Qualifier field's value.
func (s *PutProvisionedConcurrencyConfigInput) SetQualifier(v string) *PutProvisionedConcurrencyConfigInput {
	s.Qualifier = &v
	return s
}

type PutProvisionedConcurrencyConfigOutput struct {
	_ struct{} `type:"structure"`

	// The amount of provisioned concurrency allocated.
	AllocatedProvisionedConcurrentExecutions *int64 `type:"integer"`

	// The amount of provisioned concurrency available.
	AvailableProvisionedConcurrentExecutions *int64 `type:"integer"`

	// The date and time that a user last updated the configuration, in ISO 8601
	// format (https://www.iso.org/iso-8601-date-and-time-format.html).
	LastModified *string `type:"string"`

	// The amount of provisioned concurrency requested.
	RequestedProvisionedConcurrentExecutions *int64 `min:"1" type:"integer"`

	// The status of the allocation process.
	Status *string `type:"string" enum:"ProvisionedConcurrencyStatusEnum"`

	// For failed allocations, the reason that provisioned concurrency could not
	// be allocated.
	StatusReason *string `type:"string"`
}

// String returns the string representation
func (s PutProvisionedConcurrencyConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutProvisionedConcurrencyConfigOutput) GoString() string {
	return s.String()
}

// SetAllocatedProvisionedConcurrentExecutions sets the AllocatedProvisionedConcurrentExecutions field's value.
func (s *PutProvisionedConcurrencyConfigOutput) SetAllocatedProvisionedConcurrentExecutions(v int64) *PutProvisionedConcurrencyConfigOutput {
	s.AllocatedProvisionedConcurrentExecutions = &v
	return s
}

// SetAvailableProvisionedConcurrentExecutions sets the AvailableProvisionedConcurrentExecutions field's value.
func (s *PutProvisionedConcurrencyConfigOutput) SetAvailableProvisionedConcurrentExecutions(v int64) *PutProvisionedConcurrencyConfigOutput {
	s.AvailableProvisionedConcurrentExecutions = &v
	return s
}

// SetLastModified sets the LastModified field's value.
func (s *PutProvisionedConcurrencyConfigOutput) SetLastModified(v string) *PutProvisionedConcurrencyConfigOutput {
	s.LastModified = &v
	return s
}

// SetRequestedProvisionedConcurrentExecutions sets the RequestedProvisionedConcurrentExecutions field's value.
func (s *PutProvisionedConcurrencyConfigOutput) SetRequestedProvisionedConcurrentExecutions(v int64) *PutProvisionedConcurrencyConfigOutput {
	s.RequestedProvisionedConcurrentExecutions = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *PutProvisionedConcurrencyConfigOutput) SetStatus(v string) *PutProvisionedConcurrencyConfigOutput {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *PutProvisionedConcurrencyConfigOutput) SetStatusReason(v string) *PutProvisionedConcurrencyConfigOutput {
	s.StatusReason = &v
	return s
}

type RemoveLayerVersionPermissionInput struct {
	_ struct{} `type:"structure"`

	// The name or Amazon Resource Name (ARN) of the layer.
	//
	// LayerName is a required field
	LayerName *string `location:"uri" locationName:"LayerName" min:"1" type:"string" required:"true"`

	// Only update the policy if the revision ID matches the ID specified. Use this
	// option to avoid modifying a policy that has changed since you last read it.
	RevisionId *string `location:"querystring" locationName:"RevisionId" type:"string"`

	// The identifier that was specified when the statement was added.
	//
	// StatementId is a required field
	StatementId *string `location:"uri" locationName:"StatementId" min:"1" type:"string" required:"true"`

	// The version number.
	//
	// VersionNumber is a required field
	VersionNumber *int64 `location:"uri" locationName:"VersionNumber" type:"long" required:"true"`
}

// String returns the string representation
func (s RemoveLayerVersionPermissionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveLayerVersionPermissionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveLayerVersionPermissionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveLayerVersionPermissionInput"}
	if s.LayerName == nil {
		invalidParams.Add(request.NewErrParamRequired("LayerName"))
	}
	if s.LayerName != nil && len(*s.LayerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LayerName", 1))
	}
	if s.StatementId == nil {
		invalidParams.Add(request.NewErrParamRequired("StatementId"))
	}
	if s.StatementId != nil && len(*s.StatementId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StatementId", 1))
	}
	if s.VersionNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("VersionNumber"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLayerName sets the LayerName field's value.
func (s *RemoveLayerVersionPermissionInput) SetLayerName(v string) *RemoveLayerVersionPermissionInput {
	s.LayerName = &v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *RemoveLayerVersionPermissionInput) SetRevisionId(v string) *RemoveLayerVersionPermissionInput {
	s.RevisionId = &v
	return s
}

// SetStatementId sets the StatementId field's value.
func (s *RemoveLayerVersionPermissionInput) SetStatementId(v string) *RemoveLayerVersionPermissionInput {
	s.StatementId = &v
	return s
}

// SetVersionNumber sets the VersionNumber field's value.
func (s *RemoveLayerVersionPermissionInput) SetVersionNumber(v int64) *RemoveLayerVersionPermissionInput {
	s.VersionNumber = &v
	return s
}

type RemoveLayerVersionPermissionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RemoveLayerVersionPermissionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveLayerVersionPermissionOutput) GoString() string {
	return s.String()
}

type RemovePermissionInput struct {
	_ struct{} `type:"structure"`

	// The name of the Lambda function, version, or alias.
	//
	// Name formats
	//
	//    * Function name - my-function (name-only), my-function:v1 (with alias).
	//
	//    * Function ARN - arn:aws:lambda:us-west-2:123456789012:function:my-function.
	//
	//    * Partial ARN - 123456789012:function:my-function.
	//
	// You can append a version number or alias to any of the formats. The length
	// constraint applies only to the full ARN. If you specify only the function
	// name, it is limited to 64 characters in length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// Specify a version or alias to remove permissions from a published version
	// of the function.
	Qualifier *string `location:"querystring" locationName:"Qualifier" min:"1" type:"string"`

	// Only update the policy if the revision ID matches the ID that's specified.
	// Use this option to avoid modifying a policy that has changed since you last
	// read it.
	RevisionId *string `location:"querystring" locationName:"RevisionId" type:"string"`

	// Statement ID of the permission to remove.
	//
	// StatementId is a required field
	StatementId *string `location:"uri" locationName:"StatementId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RemovePermissionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemovePermissionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemovePermissionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemovePermissionInput"}
	if s.FunctionName == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}
	if s.Qualifier != nil && len(*s.Qualifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Qualifier", 1))
	}
	if s.StatementId == nil {
		invalidParams.Add(request.NewErrParamRequired("StatementId"))
	}
	if s.StatementId != nil && len(*s.StatementId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StatementId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFunctionName sets the FunctionName field's value.
func (s *RemovePermissionInput) SetFunctionName(v string) *RemovePermissionInput {
	s.FunctionName = &v
	return s
}

// SetQualifier sets the Qualifier field's value.
func (s *RemovePermissionInput) SetQualifier(v string) *RemovePermissionInput {
	s.Qualifier = &v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *RemovePermissionInput) SetRevisionId(v string) *RemovePermissionInput {
	s.RevisionId = &v
	return s
}

// SetStatementId sets the StatementId field's value.
func (s *RemovePermissionInput) SetStatementId(v string) *RemovePermissionInput {
	s.StatementId = &v
	return s
}

type RemovePermissionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RemovePermissionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemovePermissionOutput) GoString() string {
	return s.String()
}

// The request payload exceeded the Invoke request body JSON input limit. For
// more information, see Limits (https://docs.aws.amazon.com/lambda/latest/dg/limits.html).
type RequestTooLargeException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	Type *string `type:"string"`
}

// String returns the string representation
func (s RequestTooLargeException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestTooLargeException) GoString() string {
	return s.String()
}

func newErrorRequestTooLargeException(v protocol.ResponseMetadata) error {
	return &RequestTooLargeException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *RequestTooLargeException) Code() string {
	return "RequestTooLargeException"
}

// Message returns the exception's message.
func (s *RequestTooLargeException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *RequestTooLargeException) OrigErr() error {
	return nil
}

func (s *RequestTooLargeException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *RequestTooLargeException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *RequestTooLargeException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The resource already exists, or another operation is in progress.
type ResourceConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The exception message.
	Message_ *string `locationName:"message" type:"string"`

	// The exception type.
	Type *string `type:"string"`
}

// String returns the string representation
func (s ResourceConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceConflictException) GoString() string {
	return s.String()
}

func newErrorResourceConflictException(v protocol.ResponseMetadata) error {
	return &ResourceConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceConflictException) Code() string {
	return "ResourceConflictException"
}

// Message returns the exception's message.
func (s *ResourceConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceConflictException) OrigErr() error {
	return nil
}

func (s *ResourceConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The operation conflicts with the resource's availability. For example, you
// attempted to update an EventSource Mapping in CREATING, or tried to delete
// a EventSource mapping currently in the UPDATING state.
type ResourceInUseException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	Type *string `type:"string"`
}

// String returns the string representation
func (s ResourceInUseException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceInUseException) GoString() string {
	return s.String()
}

func newErrorResourceInUseException(v protocol.ResponseMetadata) error {
	return &ResourceInUseException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceInUseException) Code() string {
	return "ResourceInUseException"
}

// Message returns the exception's message.
func (s *ResourceInUseException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceInUseException) OrigErr() error {
	return nil
}

func (s *ResourceInUseException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceInUseException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceInUseException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The resource specified in the request does not exist.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	Type *string `type:"string"`
}

// String returns the string representation
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The function is inactive and its VPC connection is no longer available. Wait
// for the VPC connection to reestablish and try again.
type ResourceNotReadyException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The exception message.
	Message_ *string `locationName:"message" type:"string"`

	// The exception type.
	Type *string `type:"string"`
}

// String returns the string representation
func (s ResourceNotReadyException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceNotReadyException) GoString() string {
	return s.String()
}

func newErrorResourceNotReadyException(v protocol.ResponseMetadata) error {
	return &ResourceNotReadyException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotReadyException) Code() string {
	return "ResourceNotReadyException"
}

// Message returns the exception's message.
func (s *ResourceNotReadyException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotReadyException) OrigErr() error {
	return nil
}

func (s *ResourceNotReadyException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotReadyException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotReadyException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The AWS Lambda service encountered an internal error.
type ServiceException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	Type *string `type:"string"`
}

// String returns the string representation
func (s ServiceException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceException) GoString() string {
	return s.String()
}

func newErrorServiceException(v protocol.ResponseMetadata) error {
	return &ServiceException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceException) Code() string {
	return "ServiceException"
}

// Message returns the exception's message.
func (s *ServiceException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceException) OrigErr() error {
	return nil
}

func (s *ServiceException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceException) RequestID() string {
	return s.RespMetadata.RequestID
}

// AWS Lambda was not able to set up VPC access for the Lambda function because
// one or more configured subnets has no available IP addresses.
type SubnetIPAddressLimitReachedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	Type *string `type:"string"`
}

// String returns the string representation
func (s SubnetIPAddressLimitReachedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SubnetIPAddressLimitReachedException) GoString() string {
	return s.String()
}

func newErrorSubnetIPAddressLimitReachedException(v protocol.ResponseMetadata) error {
	return &SubnetIPAddressLimitReachedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *SubnetIPAddressLimitReachedException) Code() string {
	return "SubnetIPAddressLimitReachedException"
}

// Message returns the exception's message.
func (s *SubnetIPAddressLimitReachedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *SubnetIPAddressLimitReachedException) OrigErr() error {
	return nil
}

func (s *SubnetIPAddressLimitReachedException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *SubnetIPAddressLimitReachedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *SubnetIPAddressLimitReachedException) RequestID() string {
	return s.RespMetadata.RequestID
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The function's Amazon Resource Name (ARN).
	//
	// Resource is a required field
	Resource *string `location:"uri" locationName:"ARN" type:"string" required:"true"`

	// A list of tags to apply to the function.
	//
	// Tags is a required field
	Tags map[string]*string `type:"map" required:"true"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.Resource == nil {
		invalidParams.Add(request.NewErrParamRequired("Resource"))
	}
	if s.Resource != nil && len(*s.Resource) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Resource", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResource sets the Resource field's value.
func (s *TagResourceInput) SetResource(v string) *TagResourceInput {
	s.Resource = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The request throughput limit was exceeded.
type TooManyRequestsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	Reason *string `type:"string" enum:"ThrottleReason"`

	// The number of seconds the caller should wait before retrying.
	RetryAfterSeconds *string `location:"header" locationName:"Retry-After" type:"string"`

	Type *string `type:"string"`
}

// String returns the string representation
func (s TooManyRequestsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TooManyRequestsException) GoString() string {
	return s.String()
}

func newErrorTooManyRequestsException(v protocol.ResponseMetadata) error {
	return &TooManyRequestsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TooManyRequestsException) Code() string {
	return "TooManyRequestsException"
}

// Message returns the exception's message.
func (s *TooManyRequestsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TooManyRequestsException) OrigErr() error {
	return nil
}

func (s *TooManyRequestsException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TooManyRequestsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TooManyRequestsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The function's AWS X-Ray tracing configuration. To sample and record incoming
// requests, set Mode to Active.
type TracingConfig struct {
	_ struct{} `type:"structure"`

	// The tracing mode.
	Mode *string `type:"string" enum:"TracingMode"`
}

// String returns the string representation
func (s TracingConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TracingConfig) GoString() string {
	return s.String()
}

// SetMode sets the Mode field's value.
func (s *TracingConfig) SetMode(v string) *TracingConfig {
	s.Mode = &v
	return s
}

// The function's AWS X-Ray tracing configuration.
type TracingConfigResponse struct {
	_ struct{} `type:"structure"`

	// The tracing mode.
	Mode *string `type:"string" enum:"TracingMode"`
}

// String returns the string representation
func (s TracingConfigResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TracingConfigResponse) GoString() string {
	return s.String()
}

// SetMode sets the Mode field's value.
func (s *TracingConfigResponse) SetMode(v string) *TracingConfigResponse {
	s.Mode = &v
	return s
}

// The content type of the Invoke request body is not JSON.
type UnsupportedMediaTypeException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	Type *string `type:"string"`
}

// String returns the string representation
func (s UnsupportedMediaTypeException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnsupportedMediaTypeException) GoString() string {
	return s.String()
}

func newErrorUnsupportedMediaTypeException(v protocol.ResponseMetadata) error {
	return &UnsupportedMediaTypeException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UnsupportedMediaTypeException) Code() string {
	return "UnsupportedMediaTypeException"
}

// Message returns the exception's message.
func (s *UnsupportedMediaTypeException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UnsupportedMediaTypeException) OrigErr() error {
	return nil
}

func (s *UnsupportedMediaTypeException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UnsupportedMediaTypeException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UnsupportedMediaTypeException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The function's Amazon Resource Name (ARN).
	//
	// Resource is a required field
	Resource *string `location:"uri" locationName:"ARN" type:"string" required:"true"`

	// A list of tag keys to remove from the function.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.Resource == nil {
		invalidParams.Add(request.NewErrParamRequired("Resource"))
	}
	if s.Resource != nil && len(*s.Resource) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Resource", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResource sets the Resource field's value.
func (s *UntagResourceInput) SetResource(v string) *UntagResourceInput {
	s.Resource = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateAliasInput struct {
	_ struct{} `type:"structure"`

	// A description of the alias.
	Description *string `type:"string"`

	// The name of the Lambda function.
	//
	// Name formats
	//
	//    * Function name - MyFunction.
	//
	//    * Function ARN - arn:aws:lambda:us-west-2:123456789012:function:MyFunction.
	//
	//    * Partial ARN - 123456789012:function:MyFunction.
	//
	// The length constraint applies only to the full ARN. If you specify only the
	// function name, it is limited to 64 characters in length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// The function version that the alias invokes.
	FunctionVersion *string `min:"1" type:"string"`

	// The name of the alias.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"Name" min:"1" type:"string" required:"true"`

	// Only update the alias if the revision ID matches the ID that's specified.
	// Use this option to avoid modifying an alias that has changed since you last
	// read it.
	RevisionId *string `type:"string"`

	// The routing configuration (https://docs.aws.amazon.com/lambda/latest/dg/lambda-traffic-shifting-using-aliases.html)
	// of the alias.
	RoutingConfig *AliasRoutingConfiguration `type:"structure"`
}

// String returns the string representation
func (s UpdateAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAliasInput"}
	if s.FunctionName == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}
	if s.FunctionVersion != nil && len(*s.FunctionVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionVersion", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateAliasInput) SetDescription(v string) *UpdateAliasInput {
	s.Description = &v
	return s
}

// SetFunctionName sets the FunctionName field's value.
func (s *UpdateAliasInput) SetFunctionName(v string) *UpdateAliasInput {
	s.FunctionName = &v
	return s
}

// SetFunctionVersion sets the FunctionVersion field's value.
func (s *UpdateAliasInput) SetFunctionVersion(v string) *UpdateAliasInput {
	s.FunctionVersion = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateAliasInput) SetName(v string) *UpdateAliasInput {
	s.Name = &v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *UpdateAliasInput) SetRevisionId(v string) *UpdateAliasInput {
	s.RevisionId = &v
	return s
}

// SetRoutingConfig sets the RoutingConfig field's value.
func (s *UpdateAliasInput) SetRoutingConfig(v *AliasRoutingConfiguration) *UpdateAliasInput {
	s.RoutingConfig = v
	return s
}

type UpdateEventSourceMappingInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of items to retrieve in a single batch.
	//
	//    * Amazon Kinesis - Default 100. Max 10,000.
	//
	//    * Amazon DynamoDB Streams - Default 100. Max 1,000.
	//
	//    * Amazon Simple Queue Service - Default 10. Max 10.
	BatchSize *int64 `min:"1" type:"integer"`

	// (Streams) If the function returns an error, split the batch in two and retry.
	BisectBatchOnFunctionError *bool `type:"boolean"`

	// (Streams) An Amazon SQS queue or Amazon SNS topic destination for discarded
	// records.
	DestinationConfig *DestinationConfig `type:"structure"`

	// Disables the event source mapping to pause polling and invocation.
	Enabled *bool `type:"boolean"`

	// The name of the Lambda function.
	//
	// Name formats
	//
	//    * Function name - MyFunction.
	//
	//    * Function ARN - arn:aws:lambda:us-west-2:123456789012:function:MyFunction.
	//
	//    * Version or Alias ARN - arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD.
	//
	//    * Partial ARN - 123456789012:function:MyFunction.
	//
	// The length constraint applies only to the full ARN. If you specify only the
	// function name, it's limited to 64 characters in length.
	FunctionName *string `min:"1" type:"string"`

	// (Streams) The maximum amount of time to gather records before invoking the
	// function, in seconds.
	MaximumBatchingWindowInSeconds *int64 `type:"integer"`

	// (Streams) The maximum age of a record that Lambda sends to a function for
	// processing.
	MaximumRecordAgeInSeconds *int64 `min:"60" type:"integer"`

	// (Streams) The maximum number of times to retry when the function returns
	// an error.
	MaximumRetryAttempts *int64 `type:"integer"`

	// (Streams) The number of batches to process from each shard concurrently.
	ParallelizationFactor *int64 `min:"1" type:"integer"`

	// The identifier of the event source mapping.
	//
	// UUID is a required field
	UUID *string `location:"uri" locationName:"UUID" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateEventSourceMappingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateEventSourceMappingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateEventSourceMappingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateEventSourceMappingInput"}
	if s.BatchSize != nil && *s.BatchSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("BatchSize", 1))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}
	if s.MaximumRecordAgeInSeconds != nil && *s.MaximumRecordAgeInSeconds < 60 {
		invalidParams.Add(request.NewErrParamMinValue("MaximumRecordAgeInSeconds", 60))
	}
	if s.ParallelizationFactor != nil && *s.ParallelizationFactor < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ParallelizationFactor", 1))
	}
	if s.UUID == nil {
		invalidParams.Add(request.NewErrParamRequired("UUID"))
	}
	if s.UUID != nil && len(*s.UUID) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UUID", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBatchSize sets the BatchSize field's value.
func (s *UpdateEventSourceMappingInput) SetBatchSize(v int64) *UpdateEventSourceMappingInput {
	s.BatchSize = &v
	return s
}

// SetBisectBatchOnFunctionError sets the BisectBatchOnFunctionError field's value.
func (s *UpdateEventSourceMappingInput) SetBisectBatchOnFunctionError(v bool) *UpdateEventSourceMappingInput {
	s.BisectBatchOnFunctionError = &v
	return s
}

// SetDestinationConfig sets the DestinationConfig field's value.
func (s *UpdateEventSourceMappingInput) SetDestinationConfig(v *DestinationConfig) *UpdateEventSourceMappingInput {
	s.DestinationConfig = v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *UpdateEventSourceMappingInput) SetEnabled(v bool) *UpdateEventSourceMappingInput {
	s.Enabled = &v
	return s
}

// SetFunctionName sets the FunctionName field's value.
func (s *UpdateEventSourceMappingInput) SetFunctionName(v string) *UpdateEventSourceMappingInput {
	s.FunctionName = &v
	return s
}

// SetMaximumBatchingWindowInSeconds sets the MaximumBatchingWindowInSeconds field's value.
func (s *UpdateEventSourceMappingInput) SetMaximumBatchingWindowInSeconds(v int64) *UpdateEventSourceMappingInput {
	s.MaximumBatchingWindowInSeconds = &v
	return s
}

// SetMaximumRecordAgeInSeconds sets the MaximumRecordAgeInSeconds field's value.
func (s *UpdateEventSourceMappingInput) SetMaximumRecordAgeInSeconds(v int64) *UpdateEventSourceMappingInput {
	s.MaximumRecordAgeInSeconds = &v
	return s
}

// SetMaximumRetryAttempts sets the MaximumRetryAttempts field's value.
func (s *UpdateEventSourceMappingInput) SetMaximumRetryAttempts(v int64) *UpdateEventSourceMappingInput {
	s.MaximumRetryAttempts = &v
	return s
}

// SetParallelizationFactor sets the ParallelizationFactor field's value.
func (s *UpdateEventSourceMappingInput) SetParallelizationFactor(v int64) *UpdateEventSourceMappingInput {
	s.ParallelizationFactor = &v
	return s
}

// SetUUID sets the UUID field's value.
func (s *UpdateEventSourceMappingInput) SetUUID(v string) *UpdateEventSourceMappingInput {
	s.UUID = &v
	return s
}

type UpdateFunctionCodeInput struct {
	_ struct{} `type:"structure"`

	// Set to true to validate the request parameters and access permissions without
	// modifying the function code.
	DryRun *bool `type:"boolean"`

	// The name of the Lambda function.
	//
	// Name formats
	//
	//    * Function name - my-function.
	//
	//    * Function ARN - arn:aws:lambda:us-west-2:123456789012:function:my-function.
	//
	//    * Partial ARN - 123456789012:function:my-function.
	//
	// The length constraint applies only to the full ARN. If you specify only the
	// function name, it is limited to 64 characters in length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// Set to true to publish a new version of the function after updating the code.
	// This has the same effect as calling PublishVersion separately.
	Publish *bool `type:"boolean"`

	// Only update the function if the revision ID matches the ID that's specified.
	// Use this option to avoid modifying a function that has changed since you
	// last read it.
	RevisionId *string `type:"string"`

	// An Amazon S3 bucket in the same AWS Region as your function. The bucket can
	// be in a different AWS account.
	S3Bucket *string `min:"3" type:"string"`

	// The Amazon S3 key of the deployment package.
	S3Key *string `min:"1" type:"string"`

	// For versioned objects, the version of the deployment package object to use.
	S3ObjectVersion *string `min:"1" type:"string"`

	// The base64-encoded contents of the deployment package. AWS SDK and AWS CLI
	// clients handle the encoding for you.
	//
	// ZipFile is automatically base64 encoded/decoded by the SDK.
	ZipFile []byte `type:"blob" sensitive:"true"`
}

// String returns the string representation
func (s UpdateFunctionCodeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFunctionCodeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFunctionCodeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateFunctionCodeInput"}
	if s.FunctionName == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}
	if s.S3Bucket != nil && len(*s.S3Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("S3Bucket", 3))
	}
	if s.S3Key != nil && len(*s.S3Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("S3Key", 1))
	}
	if s.S3ObjectVersion != nil && len(*s.S3ObjectVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("S3ObjectVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDryRun sets the DryRun field's value.
func (s *UpdateFunctionCodeInput) SetDryRun(v bool) *UpdateFunctionCodeInput {
	s.DryRun = &v
	return s
}

// SetFunctionName sets the FunctionName field's value.
func (s *UpdateFunctionCodeInput) SetFunctionName(v string) *UpdateFunctionCodeInput {
	s.FunctionName = &v
	return s
}

// SetPublish sets the Publish field's value.
func (s *UpdateFunctionCodeInput) SetPublish(v bool) *UpdateFunctionCodeInput {
	s.Publish = &v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *UpdateFunctionCodeInput) SetRevisionId(v string) *UpdateFunctionCodeInput {
	s.RevisionId = &v
	return s
}

// SetS3Bucket sets the S3Bucket field's value.
func (s *UpdateFunctionCodeInput) SetS3Bucket(v string) *UpdateFunctionCodeInput {
	s.S3Bucket = &v
	return s
}

// SetS3Key sets the S3Key field's value.
func (s *UpdateFunctionCodeInput) SetS3Key(v string) *UpdateFunctionCodeInput {
	s.S3Key = &v
	return s
}

// SetS3ObjectVersion sets the S3ObjectVersion field's value.
func (s *UpdateFunctionCodeInput) SetS3ObjectVersion(v string) *UpdateFunctionCodeInput {
	s.S3ObjectVersion = &v
	return s
}

// SetZipFile sets the ZipFile field's value.
func (s *UpdateFunctionCodeInput) SetZipFile(v []byte) *UpdateFunctionCodeInput {
	s.ZipFile = v
	return s
}

type UpdateFunctionConfigurationInput struct {
	_ struct{} `type:"structure"`

	// A dead letter queue configuration that specifies the queue or topic where
	// Lambda sends asynchronous events when they fail processing. For more information,
	// see Dead Letter Queues (https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#dlq).
	DeadLetterConfig *DeadLetterConfig `type:"structure"`

	// A description of the function.
	Description *string `type:"string"`

	// Environment variables that are accessible from function code during execution.
	Environment *Environment `type:"structure"`

	// The name of the Lambda function.
	//
	// Name formats
	//
	//    * Function name - my-function.
	//
	//    * Function ARN - arn:aws:lambda:us-west-2:123456789012:function:my-function.
	//
	//    * Partial ARN - 123456789012:function:my-function.
	//
	// The length constraint applies only to the full ARN. If you specify only the
	// function name, it is limited to 64 characters in length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// The name of the method within your code that Lambda calls to execute your
	// function. The format includes the file name. It can also include namespaces
	// and other qualifiers, depending on the runtime. For more information, see
	// Programming Model (https://docs.aws.amazon.com/lambda/latest/dg/programming-model-v2.html).
	Handler *string `type:"string"`

	// The ARN of the AWS Key Management Service (AWS KMS) key that's used to encrypt
	// your function's environment variables. If it's not provided, AWS Lambda uses
	// a default service key.
	KMSKeyArn *string `type:"string"`

	// A list of function layers (https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html)
	// to add to the function's execution environment. Specify each layer by its
	// ARN, including the version.
	Layers []*string `type:"list"`

	// The amount of memory that your function has access to. Increasing the function's
	// memory also increases its CPU allocation. The default value is 128 MB. The
	// value must be a multiple of 64 MB.
	MemorySize *int64 `min:"128" type:"integer"`

	// Only update the function if the revision ID matches the ID that's specified.
	// Use this option to avoid modifying a function that has changed since you
	// last read it.
	RevisionId *string `type:"string"`

	// The Amazon Resource Name (ARN) of the function's execution role.
	Role *string `type:"string"`

	// The identifier of the function's runtime (https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html).
	Runtime *string `type:"string" enum:"Runtime"`

	// The amount of time that Lambda allows a function to run before stopping it.
	// The default is 3 seconds. The maximum allowed value is 900 seconds.
	Timeout *int64 `min:"1" type:"integer"`

	// Set Mode to Active to sample and trace a subset of incoming requests with
	// AWS X-Ray.
	TracingConfig *TracingConfig `type:"structure"`

	// For network connectivity to AWS resources in a VPC, specify a list of security
	// groups and subnets in the VPC. When you connect a function to a VPC, it can
	// only access resources and the internet through that VPC. For more information,
	// see VPC Settings (https://docs.aws.amazon.com/lambda/latest/dg/configuration-vpc.html).
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation
func (s UpdateFunctionConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFunctionConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFunctionConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateFunctionConfigurationInput"}
	if s.FunctionName == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}
	if s.MemorySize != nil && *s.MemorySize < 128 {
		invalidParams.Add(request.NewErrParamMinValue("MemorySize", 128))
	}
	if s.Timeout != nil && *s.Timeout < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Timeout", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeadLetterConfig sets the DeadLetterConfig field's value.
func (s *UpdateFunctionConfigurationInput) SetDeadLetterConfig(v *DeadLetterConfig) *UpdateFunctionConfigurationInput {
	s.DeadLetterConfig = v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateFunctionConfigurationInput) SetDescription(v string) *UpdateFunctionConfigurationInput {
	s.Description = &v
	return s
}

// SetEnvironment sets the Environment field's value.
func (s *UpdateFunctionConfigurationInput) SetEnvironment(v *Environment) *UpdateFunctionConfigurationInput {
	s.Environment = v
	return s
}

// SetFunctionName sets the FunctionName field's value.
func (s *UpdateFunctionConfigurationInput) SetFunctionName(v string) *UpdateFunctionConfigurationInput {
	s.FunctionName = &v
	return s
}

// SetHandler sets the Handler field's value.
func (s *UpdateFunctionConfigurationInput) SetHandler(v string) *UpdateFunctionConfigurationInput {
	s.Handler = &v
	return s
}

// SetKMSKeyArn sets the KMSKeyArn field's value.
func (s *UpdateFunctionConfigurationInput) SetKMSKeyArn(v string) *UpdateFunctionConfigurationInput {
	s.KMSKeyArn = &v
	return s
}

// SetLayers sets the Layers field's value.
func (s *UpdateFunctionConfigurationInput) SetLayers(v []*string) *UpdateFunctionConfigurationInput {
	s.Layers = v
	return s
}

// SetMemorySize sets the MemorySize field's value.
func (s *UpdateFunctionConfigurationInput) SetMemorySize(v int64) *UpdateFunctionConfigurationInput {
	s.MemorySize = &v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *UpdateFunctionConfigurationInput) SetRevisionId(v string) *UpdateFunctionConfigurationInput {
	s.RevisionId = &v
	return s
}

// SetRole sets the Role field's value.
func (s *UpdateFunctionConfigurationInput) SetRole(v string) *UpdateFunctionConfigurationInput {
	s.Role = &v
	return s
}

// SetRuntime sets the Runtime field's value.
func (s *UpdateFunctionConfigurationInput) SetRuntime(v string) *UpdateFunctionConfigurationInput {
	s.Runtime = &v
	return s
}

// SetTimeout sets the Timeout field's value.
func (s *UpdateFunctionConfigurationInput) SetTimeout(v int64) *UpdateFunctionConfigurationInput {
	s.Timeout = &v
	return s
}

// SetTracingConfig sets the TracingConfig field's value.
func (s *UpdateFunctionConfigurationInput) SetTracingConfig(v *TracingConfig) *UpdateFunctionConfigurationInput {
	s.TracingConfig = v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *UpdateFunctionConfigurationInput) SetVpcConfig(v *VpcConfig) *UpdateFunctionConfigurationInput {
	s.VpcConfig = v
	return s
}

type UpdateFunctionEventInvokeConfigInput struct {
	_ struct{} `type:"structure"`

	// A destination for events after they have been sent to a function for processing.
	//
	// Destinations
	//
	//    * Function - The Amazon Resource Name (ARN) of a Lambda function.
	//
	//    * Queue - The ARN of an SQS queue.
	//
	//    * Topic - The ARN of an SNS topic.
	//
	//    * Event Bus - The ARN of an Amazon EventBridge event bus.
	DestinationConfig *DestinationConfig `type:"structure"`

	// The name of the Lambda function, version, or alias.
	//
	// Name formats
	//
	//    * Function name - my-function (name-only), my-function:v1 (with alias).
	//
	//    * Function ARN - arn:aws:lambda:us-west-2:123456789012:function:my-function.
	//
	//    * Partial ARN - 123456789012:function:my-function.
	//
	// You can append a version number or alias to any of the formats. The length
	// constraint applies only to the full ARN. If you specify only the function
	// name, it is limited to 64 characters in length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// The maximum age of a request that Lambda sends to a function for processing.
	MaximumEventAgeInSeconds *int64 `min:"60" type:"integer"`

	// The maximum number of times to retry when the function returns an error.
	MaximumRetryAttempts *int64 `type:"integer"`

	// A version number or alias name.
	Qualifier *string `location:"querystring" locationName:"Qualifier" min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateFunctionEventInvokeConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFunctionEventInvokeConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFunctionEventInvokeConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateFunctionEventInvokeConfigInput"}
	if s.FunctionName == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}
	if s.MaximumEventAgeInSeconds != nil && *s.MaximumEventAgeInSeconds < 60 {
		invalidParams.Add(request.NewErrParamMinValue("MaximumEventAgeInSeconds", 60))
	}
	if s.Qualifier != nil && len(*s.Qualifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Qualifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestinationConfig sets the DestinationConfig field's value.
func (s *UpdateFunctionEventInvokeConfigInput) SetDestinationConfig(v *DestinationConfig) *UpdateFunctionEventInvokeConfigInput {
	s.DestinationConfig = v
	return s
}

// SetFunctionName sets the FunctionName field's value.
func (s *UpdateFunctionEventInvokeConfigInput) SetFunctionName(v string) *UpdateFunctionEventInvokeConfigInput {
	s.FunctionName = &v
	return s
}

// SetMaximumEventAgeInSeconds sets the MaximumEventAgeInSeconds field's value.
func (s *UpdateFunctionEventInvokeConfigInput) SetMaximumEventAgeInSeconds(v int64) *UpdateFunctionEventInvokeConfigInput {
	s.MaximumEventAgeInSeconds = &v
	return s
}

// SetMaximumRetryAttempts sets the MaximumRetryAttempts field's value.
func (s *UpdateFunctionEventInvokeConfigInput) SetMaximumRetryAttempts(v int64) *UpdateFunctionEventInvokeConfigInput {
	s.MaximumRetryAttempts = &v
	return s
}

// SetQualifier sets the Qualifier field's value.
func (s *UpdateFunctionEventInvokeConfigInput) SetQualifier(v string) *UpdateFunctionEventInvokeConfigInput {
	s.Qualifier = &v
	return s
}

type UpdateFunctionEventInvokeConfigOutput struct {
	_ struct{} `type:"structure"`

	// A destination for events after they have been sent to a function for processing.
	//
	// Destinations
	//
	//    * Function - The Amazon Resource Name (ARN) of a Lambda function.
	//
	//    * Queue - The ARN of an SQS queue.
	//
	//    * Topic - The ARN of an SNS topic.
	//
	//    * Event Bus - The ARN of an Amazon EventBridge event bus.
	DestinationConfig *DestinationConfig `type:"structure"`

	// The Amazon Resource Name (ARN) of the function.
	FunctionArn *string `type:"string"`

	// The date and time that the configuration was last updated.
	LastModified *time.Time `type:"timestamp"`

	// The maximum age of a request that Lambda sends to a function for processing.
	MaximumEventAgeInSeconds *int64 `min:"60" type:"integer"`

	// The maximum number of times to retry when the function returns an error.
	MaximumRetryAttempts *int64 `type:"integer"`
}

// String returns the string representation
func (s UpdateFunctionEventInvokeConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFunctionEventInvokeConfigOutput) GoString() string {
	return s.String()
}

// SetDestinationConfig sets the DestinationConfig field's value.
func (s *UpdateFunctionEventInvokeConfigOutput) SetDestinationConfig(v *DestinationConfig) *UpdateFunctionEventInvokeConfigOutput {
	s.DestinationConfig = v
	return s
}

// SetFunctionArn sets the FunctionArn field's value.
func (s *UpdateFunctionEventInvokeConfigOutput) SetFunctionArn(v string) *UpdateFunctionEventInvokeConfigOutput {
	s.FunctionArn = &v
	return s
}

// SetLastModified sets the LastModified field's value.
func (s *UpdateFunctionEventInvokeConfigOutput) SetLastModified(v time.Time) *UpdateFunctionEventInvokeConfigOutput {
	s.LastModified = &v
	return s
}

// SetMaximumEventAgeInSeconds sets the MaximumEventAgeInSeconds field's value.
func (s *UpdateFunctionEventInvokeConfigOutput) SetMaximumEventAgeInSeconds(v int64) *UpdateFunctionEventInvokeConfigOutput {
	s.MaximumEventAgeInSeconds = &v
	return s
}

// SetMaximumRetryAttempts sets the MaximumRetryAttempts field's value.
func (s *UpdateFunctionEventInvokeConfigOutput) SetMaximumRetryAttempts(v int64) *UpdateFunctionEventInvokeConfigOutput {
	s.MaximumRetryAttempts = &v
	return s
}

// The VPC security groups and subnets that are attached to a Lambda function.
// For more information, see VPC Settings (https://docs.aws.amazon.com/lambda/latest/dg/configuration-vpc.html).
type VpcConfig struct {
	_ struct{} `type:"structure"`

	// A list of VPC security groups IDs.
	SecurityGroupIds []*string `type:"list"`

	// A list of VPC subnet IDs.
	SubnetIds []*string `type:"list"`
}

// String returns the string representation
func (s VpcConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VpcConfig) GoString() string {
	return s.String()
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *VpcConfig) SetSecurityGroupIds(v []*string) *VpcConfig {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *VpcConfig) SetSubnetIds(v []*string) *VpcConfig {
	s.SubnetIds = v
	return s
}

// The VPC security groups and subnets that are attached to a Lambda function.
type VpcConfigResponse struct {
	_ struct{} `type:"structure"`

	// A list of VPC security groups IDs.
	SecurityGroupIds []*string `type:"list"`

	// A list of VPC subnet IDs.
	SubnetIds []*string `type:"list"`

	// The ID of the VPC.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s VpcConfigResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VpcConfigResponse) GoString() string {
	return s.String()
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *VpcConfigResponse) SetSecurityGroupIds(v []*string) *VpcConfigResponse {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *VpcConfigResponse) SetSubnetIds(v []*string) *VpcConfigResponse {
	s.SubnetIds = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *VpcConfigResponse) SetVpcId(v string) *VpcConfigResponse {
	s.VpcId = &v
	return s
}

const (
	// EventSourcePositionTrimHorizon is a EventSourcePosition enum value
	EventSourcePositionTrimHorizon = "TRIM_HORIZON"

	// EventSourcePositionLatest is a EventSourcePosition enum value
	EventSourcePositionLatest = "LATEST"

	// EventSourcePositionAtTimestamp is a EventSourcePosition enum value
	EventSourcePositionAtTimestamp = "AT_TIMESTAMP"
)

const (
	// FunctionVersionAll is a FunctionVersion enum value
	FunctionVersionAll = "ALL"
)

const (
	// InvocationTypeEvent is a InvocationType enum value
	InvocationTypeEvent = "Event"

	// InvocationTypeRequestResponse is a InvocationType enum value
	InvocationTypeRequestResponse = "RequestResponse"

	// InvocationTypeDryRun is a InvocationType enum value
	InvocationTypeDryRun = "DryRun"
)

const (
	// LastUpdateStatusSuccessful is a LastUpdateStatus enum value
	LastUpdateStatusSuccessful = "Successful"

	// LastUpdateStatusFailed is a LastUpdateStatus enum value
	LastUpdateStatusFailed = "Failed"

	// LastUpdateStatusInProgress is a LastUpdateStatus enum value
	LastUpdateStatusInProgress = "InProgress"
)

const (
	// LastUpdateStatusReasonCodeEniLimitExceeded is a LastUpdateStatusReasonCode enum value
	LastUpdateStatusReasonCodeEniLimitExceeded = "EniLimitExceeded"

	// LastUpdateStatusReasonCodeInsufficientRolePermissions is a LastUpdateStatusReasonCode enum value
	LastUpdateStatusReasonCodeInsufficientRolePermissions = "InsufficientRolePermissions"

	// LastUpdateStatusReasonCodeInvalidConfiguration is a LastUpdateStatusReasonCode enum value
	LastUpdateStatusReasonCodeInvalidConfiguration = "InvalidConfiguration"

	// LastUpdateStatusReasonCodeInternalError is a LastUpdateStatusReasonCode enum value
	LastUpdateStatusReasonCodeInternalError = "InternalError"

	// LastUpdateStatusReasonCodeSubnetOutOfIpaddresses is a LastUpdateStatusReasonCode enum value
	LastUpdateStatusReasonCodeSubnetOutOfIpaddresses = "SubnetOutOfIPAddresses"

	// LastUpdateStatusReasonCodeInvalidSubnet is a LastUpdateStatusReasonCode enum value
	LastUpdateStatusReasonCodeInvalidSubnet = "InvalidSubnet"

	// LastUpdateStatusReasonCodeInvalidSecurityGroup is a LastUpdateStatusReasonCode enum value
	LastUpdateStatusReasonCodeInvalidSecurityGroup = "InvalidSecurityGroup"
)

const (
	// LogTypeNone is a LogType enum value
	LogTypeNone = "None"

	// LogTypeTail is a LogType enum value
	LogTypeTail = "Tail"
)

const (
	// ProvisionedConcurrencyStatusEnumInProgress is a ProvisionedConcurrencyStatusEnum enum value
	ProvisionedConcurrencyStatusEnumInProgress = "IN_PROGRESS"

	// ProvisionedConcurrencyStatusEnumReady is a ProvisionedConcurrencyStatusEnum enum value
	ProvisionedConcurrencyStatusEnumReady = "READY"

	// ProvisionedConcurrencyStatusEnumFailed is a ProvisionedConcurrencyStatusEnum enum value
	ProvisionedConcurrencyStatusEnumFailed = "FAILED"
)

const (
	// RuntimeNodejs is a Runtime enum value
	RuntimeNodejs = "nodejs"

	// RuntimeNodejs43 is a Runtime enum value
	RuntimeNodejs43 = "nodejs4.3"

	// RuntimeNodejs610 is a Runtime enum value
	RuntimeNodejs610 = "nodejs6.10"

	// RuntimeNodejs810 is a Runtime enum value
	RuntimeNodejs810 = "nodejs8.10"

	// RuntimeNodejs10X is a Runtime enum value
	RuntimeNodejs10X = "nodejs10.x"

	// RuntimeNodejs12X is a Runtime enum value
	RuntimeNodejs12X = "nodejs12.x"

	// RuntimeJava8 is a Runtime enum value
	RuntimeJava8 = "java8"

	// RuntimeJava11 is a Runtime enum value
	RuntimeJava11 = "java11"

	// RuntimePython27 is a Runtime enum value
	RuntimePython27 = "python2.7"

	// RuntimePython36 is a Runtime enum value
	RuntimePython36 = "python3.6"

	// RuntimePython37 is a Runtime enum value
	RuntimePython37 = "python3.7"

	// RuntimePython38 is a Runtime enum value
	RuntimePython38 = "python3.8"

	// RuntimeDotnetcore10 is a Runtime enum value
	RuntimeDotnetcore10 = "dotnetcore1.0"

	// RuntimeDotnetcore20 is a Runtime enum value
	RuntimeDotnetcore20 = "dotnetcore2.0"

	// RuntimeDotnetcore21 is a Runtime enum value
	RuntimeDotnetcore21 = "dotnetcore2.1"

	// RuntimeDotnetcore31 is a Runtime enum value
	RuntimeDotnetcore31 = "dotnetcore3.1"

	// RuntimeNodejs43Edge is a Runtime enum value
	RuntimeNodejs43Edge = "nodejs4.3-edge"

	// RuntimeGo1X is a Runtime enum value
	RuntimeGo1X = "go1.x"

	// RuntimeRuby25 is a Runtime enum value
	RuntimeRuby25 = "ruby2.5"

	// RuntimeRuby27 is a Runtime enum value
	RuntimeRuby27 = "ruby2.7"

	// RuntimeProvided is a Runtime enum value
	RuntimeProvided = "provided"
)

const (
	// StatePending is a State enum value
	StatePending = "Pending"

	// StateActive is a State enum value
	StateActive = "Active"

	// StateInactive is a State enum value
	StateInactive = "Inactive"

	// StateFailed is a State enum value
	StateFailed = "Failed"
)

const (
	// StateReasonCodeIdle is a StateReasonCode enum value
	StateReasonCodeIdle = "Idle"

	// StateReasonCodeCreating is a StateReasonCode enum value
	StateReasonCodeCreating = "Creating"

	// StateReasonCodeRestoring is a StateReasonCode enum value
	StateReasonCodeRestoring = "Restoring"

	// StateReasonCodeEniLimitExceeded is a StateReasonCode enum value
	StateReasonCodeEniLimitExceeded = "EniLimitExceeded"

	// StateReasonCodeInsufficientRolePermissions is a StateReasonCode enum value
	StateReasonCodeInsufficientRolePermissions = "InsufficientRolePermissions"

	// StateReasonCodeInvalidConfiguration is a StateReasonCode enum value
	StateReasonCodeInvalidConfiguration = "InvalidConfiguration"

	// StateReasonCodeInternalError is a StateReasonCode enum value
	StateReasonCodeInternalError = "InternalError"

	// StateReasonCodeSubnetOutOfIpaddresses is a StateReasonCode enum value
	StateReasonCodeSubnetOutOfIpaddresses = "SubnetOutOfIPAddresses"

	// StateReasonCodeInvalidSubnet is a StateReasonCode enum value
	StateReasonCodeInvalidSubnet = "InvalidSubnet"

	// StateReasonCodeInvalidSecurityGroup is a StateReasonCode enum value
	StateReasonCodeInvalidSecurityGroup = "InvalidSecurityGroup"
)

const (
	// ThrottleReasonConcurrentInvocationLimitExceeded is a ThrottleReason enum value
	ThrottleReasonConcurrentInvocationLimitExceeded = "ConcurrentInvocationLimitExceeded"

	// ThrottleReasonFunctionInvocationRateLimitExceeded is a ThrottleReason enum value
	ThrottleReasonFunctionInvocationRateLimitExceeded = "FunctionInvocationRateLimitExceeded"

	// ThrottleReasonReservedFunctionConcurrentInvocationLimitExceeded is a ThrottleReason enum value
	ThrottleReasonReservedFunctionConcurrentInvocationLimitExceeded = "ReservedFunctionConcurrentInvocationLimitExceeded"

	// ThrottleReasonReservedFunctionInvocationRateLimitExceeded is a ThrottleReason enum value
	ThrottleReasonReservedFunctionInvocationRateLimitExceeded = "ReservedFunctionInvocationRateLimitExceeded"

	// ThrottleReasonCallerRateLimitExceeded is a ThrottleReason enum value
	ThrottleReasonCallerRateLimitExceeded = "CallerRateLimitExceeded"
)

const (
	// TracingModeActive is a TracingMode enum value
	TracingModeActive = "Active"

	// TracingModePassThrough is a TracingMode enum value
	TracingModePassThrough = "PassThrough"
)
