// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/openshift/cluster-node-tuning-operator/pkg/apis/tuned/v1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// TunedLister helps list Tuneds.
// All objects returned here must be treated as read-only.
type TunedLister interface {
	// List lists all Tuneds in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.Tuned, err error)
	// Tuneds returns an object that can list and get Tuneds.
	Tuneds(namespace string) TunedNamespaceLister
	TunedListerExpansion
}

// tunedLister implements the TunedLister interface.
type tunedLister struct {
	indexer cache.Indexer
}

// NewTunedLister returns a new TunedLister.
func NewTunedLister(indexer cache.Indexer) TunedLister {
	return &tunedLister{indexer: indexer}
}

// List lists all Tuneds in the indexer.
func (s *tunedLister) List(selector labels.Selector) (ret []*v1.Tuned, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.Tuned))
	})
	return ret, err
}

// Tuneds returns an object that can list and get Tuneds.
func (s *tunedLister) Tuneds(namespace string) TunedNamespaceLister {
	return tunedNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// TunedNamespaceLister helps list and get Tuneds.
// All objects returned here must be treated as read-only.
type TunedNamespaceLister interface {
	// List lists all Tuneds in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.Tuned, err error)
	// Get retrieves the Tuned from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v1.Tuned, error)
	TunedNamespaceListerExpansion
}

// tunedNamespaceLister implements the TunedNamespaceLister
// interface.
type tunedNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all Tuneds in the indexer for a given namespace.
func (s tunedNamespaceLister) List(selector labels.Selector) (ret []*v1.Tuned, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.Tuned))
	})
	return ret, err
}

// Get retrieves the Tuned from the indexer for a given namespace and name.
func (s tunedNamespaceLister) Get(name string) (*v1.Tuned, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1.Resource("tuned"), name)
	}
	return obj.(*v1.Tuned), nil
}
