# Getting started

## Prerequisites

In the case this operator is being used without the Cluster Logging Operator or Jaeger Operator:

- the namespace where the Elasticsearch cluster will be deployed into needs to be created. By default our make targets use `openshift-logging`, however they can be overridden by setting `DEPLOYMENT_NAMESPACE`.

- certificates must be provided in the form of a secret where the name matches the pattern `<elasticsearch_cr_name>-secret`. For the convenience of local development the make target `deploy-example-secret` can be used to do this.

## OpenShift

To build a local Elasticsearch Operator image and deploy the example CR you can use:
```
make deploy-example
```

Alternatively, if you just want to deploy the Elasticsearch Operator and provide your own CR afterwards you can use:
```
make deploy
```

There is an example CR provided in the `hack` directory that can be created with:
```
oc create -f hack/cr.yaml
```

# Customize your cluster

## Image customization

The operator is designed to work with `quay.io/openshift-logging/elasticsearch6` image.  To use
a different image edit `config/manager/manage.yaml` and re-run `make bundle`.

## Storage configuration

Storage is configurable per individual node type. Possible configuration
options:

- Empty directory
- PersistentVolume generated by StorageClass (if storage class is left off the cluster default is used)

## Elasticsearch cluster topology customization

Decide how many nodes you want to run.


## Exposing elasticsearch service with a route

Obtain the CA cert from Elasticsearch.
```
oc extract secret/elasticsearch --to=. --keys=admin-ca
```
Create a [re-encrypt route](https://docs.openshift.com/container-platform/3.11/architecture/networking/routes.html#secured-routes).

In the Re-encrypt termination example, use the contents of the file `admin-ca` for spec.tls.destinationCACertificate.
You do not need to set the spec.tls.key, spec.tls.certificate and spec.tls.caCertificate parameters shown in the example.

## Supported features

Kubernetes TBD+ and OpenShift TBD+ are supported.

- [x] SSL-secured deployment (using Opendistro)
- [x] Insecure deployment (requires different image)
- [x] Index per tenant
- [x] Elasticsearch 6.x support
- [x] Master role
- [x] Client role
- [x] Data role
- [x] Clientdata role
- [x] Clientdatamaster role
- [x] Prometheus monitoring
- [x] Status monitoring
- [x] Rolling restarts

# Testing

In a real deployment OpenShift monitoring will be installed.  However
for testing purposes, you should install the monitoring CRDs:
```
make deploy
```

## E2E Testing
To run the e2e tests run:
```
make test-e2e-olm
```
This assumes:

* the Elasticsearch Operator pod is already deployed and running
* the Elasticsearch Operator Registry pod is already deployed and running

## Dev Testing
You should first ensure that you have `podman` available.

To test on an OKD cluster, you can run:
```
make deploy
```
To remove created API objects:
```
make uninstall
```

## Building a Universal Base Image (UBI) based image

You must first `oc login api.ci.openshift.org`.  You'll need these credentials in order
to pull images from the UBI registry.

The image build process for UBI based images uses a private yum repo.
In order to use the private yum repo, you will need access to
https://github.com/openshift/release/blob/master/ci-operator/infra/openshift/release-controller/repos/ocp-4.1-default.repo
and
https://github.com/openshift/shared-secrets/blob/master/mirror/ops-mirror.pem
Note that the latter is private and requires special permission to access.

The best approach is to clone these repos under `$GOPATH/src/github.com/openshift`
which the build scripts will pick up automatically.  If you do not, the build script
will attempt to clone them to a temporary directory.

## Running a full integration test with a 4.x cluster

If you have a local clone of [origin-aggregated-logging](https://github.com/openshift/origin-aggregated-logging)
under `$GOPATH/github.com/openshift/origin-aggregated-logging` you can use its `hack/get-cluster-run-tests.sh`
to build the logging, elasticsearch-operator, and cluster-logging-operator images; deploy a 4.x cluster;
push the images to the cluster; deploy logging; and launch the logging CI tests.

## Pushing an image to a 4.x cluster

You'll need `podman` in addition to `docker`.

If you used the new `openshift-installer`, it creates a user named `kubeadmin`
with the password in the file `installer/auth/kubeadmin_password`.

If you already built the image with `make image`, then it will not be built
again until a change is detected in a prerequisite file (defined in the
Makefile) You need `oc login` to the cluster before pushing the image to the
register.

```bash
oc login --token=<token> --server=https://api.<cluster>:6443
# Or oc login -u kubeadmin -p <password>, if using openshift installer
make deploy-image
```

## Upgrading operator-sdk

The elasticsearch operator relies on `operator-sdk` to scaffold and generate code and
manifests.
To upgrade the generated code to a new operator-sdk version, we need to follow the
instructions in [operator-sdk's migration guide](https://master.sdk.operatorframework.io/docs/upgrading-sdk-version/).

In addition, we must ensure that the k8s dependencies in the operator's `go.mod`
match the selected version of operator-sdk. For example, for operator-sdk *v0.19.x*,
check the k8s dependencies:

- [Identify kubebuilder version referenced by operator-sdk](https://github.com/operator-framework/operator-sdk/blob/ef0bc885e40e6c86c0c079bea612b4eb908f6ec5/go.mod#L53)

- [Identify controller-runtime version referenced by kubebuilder](https://github.com/kubernetes-sigs/kubebuilder/blob/36aa113dbe99a7bdd883d42f8545468a2017775d/pkg/plugin/v3/scaffolds/init.go#L38)

- [Check controller-runtime's go.mod file](https://github.com/kubernetes-sigs/controller-runtime/blob/1c83ff6f06bc764c95dd69b0f743740c064c4bf6/go.mod#L23-L28)

As a result, we can determine the versions of the k8s dependencies in the operator's `go.mod`.

### Generate Go code, CRD, RBAC, and bundle

```bash
# Generate Go code, CRD, ...
make generate

# Generate bundle directory
make bundle
```
