// Copyright 2021 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package run provides access to the Cloud Run Admin API.
//
// For product documentation, see: https://cloud.google.com/run/
//
// Creating a client
//
// Usage example:
//
//   import "google.golang.org/api/run/v1alpha1"
//   ...
//   ctx := context.Background()
//   runService, err := run.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for authentication.
//
// For information on how to create and obtain Application Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API keys), use option.WithAPIKey:
//
//   runService, err := run.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth flow), use option.WithTokenSource:
//
//   config := &oauth2.Config{...}
//   // ...
//   token, err := config.Exchange(ctx, ...)
//   runService, err := run.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See https://godoc.org/google.golang.org/api/option/ for details on options.
package run // import "google.golang.org/api/run/v1alpha1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	googleapi "google.golang.org/api/googleapi"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint

const apiId = "run:v1alpha1"
const apiName = "run"
const apiVersion = "v1alpha1"
const basePath = "https://run.googleapis.com/"
const mtlsBasePath = "https://run.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud Platform data
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := option.WithScopes(
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s, err := New(client)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &Service{client: client, BasePath: basePath}
	s.Namespaces = NewNamespacesService(s)
	return s, nil
}

type Service struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Namespaces *NamespacesService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewNamespacesService(s *Service) *NamespacesService {
	rs := &NamespacesService{s: s}
	rs.Jobs = NewNamespacesJobsService(s)
	return rs
}

type NamespacesService struct {
	s *Service

	Jobs *NamespacesJobsService
}

func NewNamespacesJobsService(s *Service) *NamespacesJobsService {
	rs := &NamespacesJobsService{s: s}
	return rs
}

type NamespacesJobsService struct {
	s *Service
}

// Capabilities: Adds and removes POSIX capabilities from running
// containers.
type Capabilities struct {
	// Add: Added capabilities +optional
	Add []string `json:"add,omitempty"`

	// Drop: Removed capabilities +optional
	Drop []string `json:"drop,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Add") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Add") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Capabilities) MarshalJSON() ([]byte, error) {
	type NoMethod Capabilities
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ConfigMapEnvSource: ConfigMapEnvSource selects a ConfigMap to
// populate the environment variables with. The contents of the target
// ConfigMap's Data field will represent the key-value pairs as
// environment variables.
type ConfigMapEnvSource struct {
	// LocalObjectReference: This field should not be used directly as it is
	// meant to be inlined directly into the message. Use the "name" field
	// instead.
	LocalObjectReference *LocalObjectReference `json:"localObjectReference,omitempty"`

	// Name: Cloud Run fully managed: not supported Cloud Run for Anthos:
	// supported The ConfigMap to select from.
	Name string `json:"name,omitempty"`

	// Optional: Cloud Run fully managed: not supported Cloud Run for
	// Anthos: supported Specify whether the ConfigMap must be defined
	// +optional
	Optional bool `json:"optional,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "LocalObjectReference") to unconditionally include in API requests.
	// By default, fields with empty values are omitted from API requests.
	// However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LocalObjectReference") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *ConfigMapEnvSource) MarshalJSON() ([]byte, error) {
	type NoMethod ConfigMapEnvSource
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ConfigMapKeySelector: Cloud Run fully managed: not supported Cloud
// Run on GKE: supported Selects a key from a ConfigMap.
type ConfigMapKeySelector struct {
	// Key: Cloud Run fully managed: not supported Cloud Run on GKE:
	// supported The key to select.
	Key string `json:"key,omitempty"`

	// LocalObjectReference: This field should not be used directly as it is
	// meant to be inlined directly into the message. Use the "name" field
	// instead.
	LocalObjectReference *LocalObjectReference `json:"localObjectReference,omitempty"`

	// Name: Cloud Run fully managed: not supported Cloud Run on GKE:
	// supported The ConfigMap to select from.
	Name string `json:"name,omitempty"`

	// Optional: Cloud Run fully managed: not supported Cloud Run on GKE:
	// supported Specify whether the ConfigMap or its key must be defined
	// +optional
	Optional bool `json:"optional,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ConfigMapKeySelector) MarshalJSON() ([]byte, error) {
	type NoMethod ConfigMapKeySelector
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ConfigMapVolumeSource: Adapts a ConfigMap into a volume. The contents
// of the target ConfigMap's Data field will be presented in a volume as
// files using the keys in the Data field as the file names, unless the
// items element is populated with specific mappings of keys to paths.
type ConfigMapVolumeSource struct {
	// DefaultMode: Mode bits to use on created files by default. Must be a
	// value between 0 and 0777. Defaults to 0644. Directories within the
	// path are not affected by this setting. This might be in conflict with
	// other options that affect the file mode, like fsGroup, and the result
	// can be other mode bits set.
	DefaultMode int64 `json:"defaultMode,omitempty"`

	// Items: If unspecified, each key-value pair in the Data field of the
	// referenced Secret will be projected into the volume as a file whose
	// name is the key and content is the value. If specified, the listed
	// keys will be projected into the specified paths, and unlisted keys
	// will not be present. If a key is specified which is not present in
	// the Secret, the volume setup will error unless it is marked optional.
	Items []*KeyToPath `json:"items,omitempty"`

	// Name: Name of the config.
	Name string `json:"name,omitempty"`

	// Optional: Specify whether the Secret or its keys must be defined.
	Optional bool `json:"optional,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DefaultMode") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DefaultMode") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ConfigMapVolumeSource) MarshalJSON() ([]byte, error) {
	type NoMethod ConfigMapVolumeSource
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Container: A single application container. This specifies both the
// container to run, the command to run in the container and the
// arguments to supply to it. Note that additional arguments may be
// supplied by the system to the container at runtime.
type Container struct {
	// Args: Arguments to the entrypoint. The docker image's CMD is used if
	// this is not provided. Variable references $(VAR_NAME) are expanded
	// using the container's environment. If a variable cannot be resolved,
	// the reference in the input string will be unchanged. The $(VAR_NAME)
	// syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped
	// references will never be expanded, regardless of whether the variable
	// exists or not. Cannot be updated. More info:
	// https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
	// +optional
	Args []string `json:"args,omitempty"`

	// Command: Entrypoint array. Not executed within a shell. The docker
	// image's ENTRYPOINT is used if this is not provided. Variable
	// references $(VAR_NAME) are expanded using the container's
	// environment. If a variable cannot be resolved, the reference in the
	// input string will be unchanged. The $(VAR_NAME) syntax can be escaped
	// with a double $$, ie: $$(VAR_NAME). Escaped references will never be
	// expanded, regardless of whether the variable exists or not. Cannot be
	// updated. More info:
	// https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
	// +optional
	Command []string `json:"command,omitempty"`

	// Env: List of environment variables to set in the container. Cannot be
	// updated. +optional
	Env []*EnvVar `json:"env,omitempty"`

	// EnvFrom: List of sources to populate environment variables in the
	// container. The keys defined within a source must be a C_IDENTIFIER.
	// All invalid keys will be reported as an event when the container is
	// starting. When a key exists in multiple sources, the value associated
	// with the last source will take precedence. Values defined by an Env
	// with a duplicate key will take precedence. Cannot be updated.
	// +optional
	EnvFrom []*EnvFromSource `json:"envFrom,omitempty"`

	// Image: Docker image name. More info:
	// https://kubernetes.io/docs/concepts/containers/images
	Image string `json:"image,omitempty"`

	// ImagePullPolicy: Image pull policy. One of Always, Never,
	// IfNotPresent. Defaults to Always if :latest tag is specified, or
	// IfNotPresent otherwise. Cannot be updated. More info:
	// https://kubernetes.io/docs/concepts/containers/images#updating-images
	// +optional
	ImagePullPolicy string `json:"imagePullPolicy,omitempty"`

	// Lifecycle: Actions that the management system should take in response
	// to container lifecycle events. Cannot be updated. +optional
	Lifecycle *Lifecycle `json:"lifecycle,omitempty"`

	// LivenessProbe: Periodic probe of container liveness. Container will
	// be restarted if the probe fails. Cannot be updated. More info:
	// https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
	// +optional
	LivenessProbe *Probe `json:"livenessProbe,omitempty"`

	// Name: Name of the container specified as a DNS_LABEL. Each container
	// must have a unique name (DNS_LABEL). Cannot be updated.
	Name string `json:"name,omitempty"`

	// Ports: List of ports to expose from the container. Exposing a port
	// here gives the system additional information about the network
	// connections a container uses, but is primarily informational. Not
	// specifying a port here DOES NOT prevent that port from being exposed.
	// Any port which is listening on the default "0.0.0.0" address inside a
	// container will be accessible from the network. Cannot be updated.
	// +optional
	Ports []*ContainerPort `json:"ports,omitempty"`

	// ReadinessProbe: Periodic probe of container service readiness.
	// Container will be removed from service endpoints if the probe fails.
	// Cannot be updated. More info:
	// https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
	// +optional
	ReadinessProbe *Probe `json:"readinessProbe,omitempty"`

	// Resources: Compute Resources required by this container. Cannot be
	// updated. More info:
	// https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
	// +optional
	Resources *ResourceRequirements `json:"resources,omitempty"`

	// SecurityContext: Security options the pod should run with. More info:
	// https://kubernetes.io/docs/concepts/policy/security-context/ More
	// info:
	// https://kubernetes.io/docs/tasks/configure-pod-container/security-context/
	// +optional
	SecurityContext *SecurityContext `json:"securityContext,omitempty"`

	// Stdin: Whether this container should allocate a buffer for stdin in
	// the container runtime. If this is not set, reads from stdin in the
	// container will always result in EOF. Default is false. +optional
	Stdin bool `json:"stdin,omitempty"`

	// StdinOnce: Whether the container runtime should close the stdin
	// channel after it has been opened by a single attach. When stdin is
	// true the stdin stream will remain open across multiple attach
	// sessions. If stdinOnce is set to true, stdin is opened on container
	// start, is empty until the first client attaches to stdin, and then
	// remains open and accepts data until the client disconnects, at which
	// time stdin is closed and remains closed until the container is
	// restarted. If this flag is false, a container processes that reads
	// from stdin will never receive an EOF. Default is false +optional
	StdinOnce bool `json:"stdinOnce,omitempty"`

	// TerminationMessagePath: Optional: Path at which the file to which the
	// container's termination message will be written is mounted into the
	// container's filesystem. Message written is intended to be brief final
	// status, such as an assertion failure message. Will be truncated by
	// the node if greater than 4096 bytes. The total message length across
	// all containers will be limited to 12kb. Defaults to
	// /dev/termination-log. Cannot be updated. +optional
	TerminationMessagePath string `json:"terminationMessagePath,omitempty"`

	// TerminationMessagePolicy: Indicate how the termination message should
	// be populated. File will use the contents of terminationMessagePath to
	// populate the container status message on both success and failure.
	// FallbackToLogsOnError will use the last chunk of container log output
	// if the termination message file is empty and the container exited
	// with an error. The log output is limited to 2048 bytes or 80 lines,
	// whichever is smaller. Defaults to File. Cannot be updated. +optional
	TerminationMessagePolicy string `json:"terminationMessagePolicy,omitempty"`

	// Tty: Whether this container should allocate a TTY for itself, also
	// requires 'stdin' to be true. Default is false. +optional
	Tty bool `json:"tty,omitempty"`

	// VolumeDevices: volumeDevices is the list of block devices to be used
	// by the container. This is an alpha feature and may change in the
	// future. +optional
	VolumeDevices []*VolumeDevice `json:"volumeDevices,omitempty"`

	// VolumeMounts: Pod volumes to mount into the container's filesystem.
	// Cannot be updated. +optional
	VolumeMounts []*VolumeMount `json:"volumeMounts,omitempty"`

	// WorkingDir: Container's working directory. If not specified, the
	// container runtime's default will be used, which might be configured
	// in the container image. Cannot be updated. +optional
	WorkingDir string `json:"workingDir,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Args") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Args") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Container) MarshalJSON() ([]byte, error) {
	type NoMethod Container
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ContainerPort: ContainerPort represents a network port in a single
// container.
type ContainerPort struct {
	// ContainerPort: Number of port to expose on the pod's IP address. This
	// must be a valid port number, 0 < x < 65536.
	ContainerPort int64 `json:"containerPort,omitempty"`

	// HostIP: What host IP to bind the external port to. +optional
	HostIP string `json:"hostIP,omitempty"`

	// HostPort: Number of port to expose on the host. If specified, this
	// must be a valid port number, 0 < x < 65536. If HostNetwork is
	// specified, this must match ContainerPort. Most containers do not need
	// this. +optional
	HostPort int64 `json:"hostPort,omitempty"`

	// Name: If specified, this must be an IANA_SVC_NAME and unique within
	// the pod. Each named port in a pod must have a unique name. Name for
	// the port that can be referred to by services. +optional
	Name string `json:"name,omitempty"`

	// Protocol: Protocol for port. Must be UDP or TCP. Defaults to "TCP".
	// +optional
	Protocol string `json:"protocol,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ContainerPort") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ContainerPort") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ContainerPort) MarshalJSON() ([]byte, error) {
	type NoMethod ContainerPort
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Empty: A generic empty message that you can re-use to avoid defining
// duplicated empty messages in your APIs. A typical example is to use
// it as the request or the response type of an API method. For
// instance: service Foo { rpc Bar(google.protobuf.Empty) returns
// (google.protobuf.Empty); } The JSON representation for `Empty` is
// empty JSON object `{}`.
type Empty struct {
	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`
}

// EnvFromSource: EnvFromSource represents the source of a set of
// ConfigMaps
type EnvFromSource struct {
	// ConfigMapRef: The ConfigMap to select from +optional
	ConfigMapRef *ConfigMapEnvSource `json:"configMapRef,omitempty"`

	// Prefix: An optional identifier to prepend to each key in the
	// ConfigMap. Must be a C_IDENTIFIER. +optional
	Prefix string `json:"prefix,omitempty"`

	// SecretRef: The Secret to select from +optional
	SecretRef *SecretEnvSource `json:"secretRef,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ConfigMapRef") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ConfigMapRef") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *EnvFromSource) MarshalJSON() ([]byte, error) {
	type NoMethod EnvFromSource
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// EnvVar: EnvVar represents an environment variable present in a
// Container.
type EnvVar struct {
	// Name: Name of the environment variable. Must be a C_IDENTIFIER.
	Name string `json:"name,omitempty"`

	// Value: Variable references $(VAR_NAME) are expanded using the
	// previous defined environment variables in the container and any route
	// environment variables. If a variable cannot be resolved, the
	// reference in the input string will be unchanged. The $(VAR_NAME)
	// syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped
	// references will never be expanded, regardless of whether the variable
	// exists or not. Defaults to "". +optional
	Value string `json:"value,omitempty"`

	// ValueFrom: Cloud Run fully managed: supported Source for the
	// environment variable's value. Only supports secret_key_ref. Cloud Run
	// for Anthos: supported Source for the environment variable's value.
	// Cannot be used if value is not empty. +optional
	ValueFrom *EnvVarSource `json:"valueFrom,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *EnvVar) MarshalJSON() ([]byte, error) {
	type NoMethod EnvVar
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// EnvVarSource: Cloud Run fully managed: not supported Cloud Run on
// GKE: supported EnvVarSource represents a source for the value of an
// EnvVar.
type EnvVarSource struct {
	// ConfigMapKeyRef: Cloud Run fully managed: not supported Cloud Run on
	// GKE: supported Selects a key of a ConfigMap. +optional
	ConfigMapKeyRef *ConfigMapKeySelector `json:"configMapKeyRef,omitempty"`

	// SecretKeyRef: Cloud Run fully managed: supported. Selects a key
	// (version) of a secret in Secret Manager. Cloud Run for Anthos:
	// supported. Selects a key of a secret in the pod's namespace.
	// +optional
	SecretKeyRef *SecretKeySelector `json:"secretKeyRef,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ConfigMapKeyRef") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ConfigMapKeyRef") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *EnvVarSource) MarshalJSON() ([]byte, error) {
	type NoMethod EnvVarSource
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ExecAction: ExecAction describes a "run in container" action.
type ExecAction struct {
	// Command: Command is the command line to execute inside the container,
	// the working directory for the command is root ('/') in the
	// container's filesystem. The command is simply exec'd, it is not run
	// inside a shell, so traditional shell instructions ('|', etc) won't
	// work. To use a shell, you need to explicitly call out to that shell.
	// Exit status of 0 is treated as live/healthy and non-zero is
	// unhealthy. +optional
	Command []string `json:"command,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Command") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Command") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ExecAction) MarshalJSON() ([]byte, error) {
	type NoMethod ExecAction
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HTTPGetAction: HTTPGetAction describes an action based on HTTP Get
// requests.
type HTTPGetAction struct {
	// Host: Host name to connect to, defaults to the pod IP. You probably
	// want to set "Host" in httpHeaders instead. +optional
	Host string `json:"host,omitempty"`

	// HttpHeaders: Custom headers to set in the request. HTTP allows
	// repeated headers. +optional
	HttpHeaders []*HTTPHeader `json:"httpHeaders,omitempty"`

	// Path: Path to access on the HTTP server. +optional
	Path string `json:"path,omitempty"`

	// Port: Name or number of the port to access on the container. Number
	// must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
	Port *IntOrString `json:"port,omitempty"`

	// Scheme: Scheme to use for connecting to the host. Defaults to HTTP.
	// +optional
	Scheme string `json:"scheme,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Host") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Host") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HTTPGetAction) MarshalJSON() ([]byte, error) {
	type NoMethod HTTPGetAction
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// HTTPHeader: HTTPHeader describes a custom header to be used in HTTP
// probes
type HTTPHeader struct {
	// Name: The header field name
	Name string `json:"name,omitempty"`

	// Value: The header field value
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *HTTPHeader) MarshalJSON() ([]byte, error) {
	type NoMethod HTTPHeader
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Handler: Handler defines a specific action that should be taken
type Handler struct {
	// Exec: One and only one of the following should be specified. Exec
	// specifies the action to take. +optional
	Exec *ExecAction `json:"exec,omitempty"`

	// HttpGet: HTTPGet specifies the http request to perform. +optional
	HttpGet *HTTPGetAction `json:"httpGet,omitempty"`

	// TcpSocket: TCPSocket specifies an action involving a TCP port. TCP
	// hooks not yet supported
	TcpSocket *TCPSocketAction `json:"tcpSocket,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Exec") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Exec") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Handler) MarshalJSON() ([]byte, error) {
	type NoMethod Handler
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// InstanceSpec: InstanceSpec is a description of an instance.
type InstanceSpec struct {
	// ActiveDeadlineSeconds: Optional. Optional duration in seconds the
	// instance may be active relative to StartTime before the system will
	// actively try to mark it failed and kill associated containers. If set
	// to zero, the system will never attempt to kill an instance based on
	// time. Otherwise, value must be a positive integer. +optional
	ActiveDeadlineSeconds int64 `json:"activeDeadlineSeconds,omitempty,string"`

	// Containers: Optional. List of containers belonging to the instance.
	// We disallow a number of fields on this Container. Only a single
	// container may be provided.
	Containers []*Container `json:"containers,omitempty"`

	// RestartPolicy: Optional. Restart policy for all containers within the
	// instance. Allowed values are: - OnFailure: Instances will always be
	// restarted on failure if the backoffLimit has not been reached. -
	// Never: Instances are never restarted and all failures are permanent.
	// Cannot be used if backoffLimit is set. +optional
	RestartPolicy string `json:"restartPolicy,omitempty"`

	// ServiceAccountName: Optional. Email address of the IAM service
	// account associated with the instance of a Job. The service account
	// represents the identity of the running instance, and determines what
	// permissions the instance has. If not provided, the instance will use
	// the project's default service account. +optional
	ServiceAccountName string `json:"serviceAccountName,omitempty"`

	// TerminationGracePeriodSeconds: Optional. Optional duration in seconds
	// the instance needs to terminate gracefully. Value must be
	// non-negative integer. The value zero indicates delete immediately.
	// The grace period is the duration in seconds after the processes
	// running in the instance are sent a termination signal and the time
	// when the processes are forcibly halted with a kill signal. Set this
	// value longer than the expected cleanup time for your process.
	// +optional
	TerminationGracePeriodSeconds int64 `json:"terminationGracePeriodSeconds,omitempty,string"`

	// Volumes: Optional. List of volumes that can be mounted by containers
	// belonging to the instance. More info:
	// https://kubernetes.io/docs/concepts/storage/volumes +optional
	Volumes []*Volume `json:"volumes,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "ActiveDeadlineSeconds") to unconditionally include in API requests.
	// By default, fields with empty values are omitted from API requests.
	// However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ActiveDeadlineSeconds") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *InstanceSpec) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceSpec
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// InstanceStatus: Instance represents the status of an instance of a
// Job.
type InstanceStatus struct {
	// CompletionTime: Optional. Represents time when the instance was
	// completed. It is not guaranteed to be set in happens-before order
	// across separate operations. It is represented in RFC3339 form and is
	// in UTC. +optional
	CompletionTime string `json:"completionTime,omitempty"`

	// Failed: Optional. The number of times this instance exited with code
	// > 0; +optional
	Failed int64 `json:"failed,omitempty"`

	// Index: Required. Index of the instance, unique per Job, and beginning
	// at 0.
	Index int64 `json:"index,omitempty"`

	// LastExitCode: Optional. Last exit code seen for this instance.
	// +optional
	LastExitCode int64 `json:"lastExitCode,omitempty"`

	// Restarted: Optional. The number of times this instance was restarted.
	// Instances are restarted according the restartPolicy configured in the
	// Job template. +optional
	Restarted int64 `json:"restarted,omitempty"`

	// StartTime: Optional. Represents time when the instance was created by
	// the job controller. It is not guaranteed to be set in happens-before
	// order across separate operations. It is represented in RFC3339 form
	// and is in UTC. +optional
	StartTime string `json:"startTime,omitempty"`

	// Succeeded: Optional. The number of times this instance exited with
	// code == 0. +optional
	Succeeded int64 `json:"succeeded,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CompletionTime") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CompletionTime") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *InstanceStatus) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// InstanceTemplateSpec: InstanceTemplateSpec describes the data an
// instance should have when created from a template.
type InstanceTemplateSpec struct {
	// Spec: Optional. Specification of the desired behavior of the
	// instance. More info:
	// https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
	// +optional
	Spec *InstanceSpec `json:"spec,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Spec") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Spec") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *InstanceTemplateSpec) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceTemplateSpec
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// IntOrString: IntOrString is a type that can hold an int32 or a
// string. When used in JSON or YAML marshalling and unmarshalling, it
// produces or consumes the inner type. This allows you to have, for
// example, a JSON field that can accept a name or number.
type IntOrString struct {
	// IntVal: The int value.
	IntVal int64 `json:"intVal,omitempty"`

	// StrVal: The string value.
	StrVal string `json:"strVal,omitempty"`

	// Type: The type of the value.
	Type int64 `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "IntVal") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "IntVal") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *IntOrString) MarshalJSON() ([]byte, error) {
	type NoMethod IntOrString
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Job: Job represents the configuration of a single job. A job an
// immutable resource that references a container image which is run to
// completion.
type Job struct {
	// ApiVersion: Optional. APIVersion defines the versioned schema of this
	// representation of an object. Servers should convert recognized
	// schemas to the latest internal value, and may reject unrecognized
	// values. More info:
	// https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
	// +optional
	ApiVersion string `json:"apiVersion,omitempty"`

	// Kind: Optional. Kind is a string value representing the REST resource
	// this object represents. Servers may infer this from the endpoint the
	// client submits requests to. Cannot be updated. In CamelCase. More
	// info:
	// https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
	// +optional
	Kind string `json:"kind,omitempty"`

	// Metadata: Optional. Standard object's metadata. More info:
	// https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
	// +optional
	Metadata *ObjectMeta `json:"metadata,omitempty"`

	// Spec: Optional. Specification of the desired behavior of a job. More
	// info:
	// https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status
	// +optional
	Spec *JobSpec `json:"spec,omitempty"`

	// Status: Optional. Current status of a job. More info:
	// https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status
	// +optional
	Status *JobStatus `json:"status,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ApiVersion") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ApiVersion") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Job) MarshalJSON() ([]byte, error) {
	type NoMethod Job
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// JobCondition: JobCondition defines a readiness condition for a
// Revision.
type JobCondition struct {
	// LastTransitionTime: Optional. Last time the condition transitioned
	// from one status to another.
	LastTransitionTime string `json:"lastTransitionTime,omitempty"`

	// Message: Optional. Human readable message indicating details about
	// the current status.
	Message string `json:"message,omitempty"`

	// Reason: Optional. One-word CamelCase reason for the condition's last
	// transition.
	Reason string `json:"reason,omitempty"`

	// Severity: Optional. How to interpret failures of this condition, one
	// of Error, Warning, Info
	Severity string `json:"severity,omitempty"`

	// Status: Required. Status of the condition, one of True, False,
	// Unknown.
	Status string `json:"status,omitempty"`

	// Type: Required. Type is used to communicate the status of the
	// reconciliation process. See also:
	// https://github.com/knative/serving/blob/master/docs/spec/errors.md#error-conditions-and-reporting
	// Types include: * "Completed": True when the Job has successfully
	// completed. * "Started": True when the Job has successfully started
	// running. * "ResourcesAvailable": True when underlying resources have
	// been provisioned.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "LastTransitionTime")
	// to unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LastTransitionTime") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *JobCondition) MarshalJSON() ([]byte, error) {
	type NoMethod JobCondition
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// JobSpec: JobSpec describes how the job execution will look like.
type JobSpec struct {
	// ActiveDeadlineSeconds: Optional. Specifies the duration in seconds
	// relative to the startTime that the job may be active before the
	// system tries to terminate it. If set to zero, the system will never
	// attempt to terminate the job based on time. Otherwise, the value must
	// be positive integer. +optional
	ActiveDeadlineSeconds int64 `json:"activeDeadlineSeconds,omitempty,string"`

	// BackoffLimit: Optional. Specifies the number of retries per instance,
	// before marking this job failed. If set to zero, instances will never
	// retry on failure. +optional
	BackoffLimit int64 `json:"backoffLimit,omitempty"`

	// Completions: Optional. Specifies the desired number of successfully
	// finished instances the job should be run with. Setting to 1 means
	// that parallelism is limited to 1 and the success of that instance
	// signals the success of the job. More info:
	// https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/
	// +optional
	Completions int64 `json:"completions,omitempty"`

	// Parallelism: Optional. Specifies the maximum desired number of
	// instances the job should run at any given time. Must be <=
	// completions. The actual number of instances running in steady state
	// will be less than this number when ((.spec.completions -
	// .status.successful) < .spec.parallelism), i.e. when the work left to
	// do is less than max parallelism. More info:
	// https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/
	// +optional
	Parallelism int64 `json:"parallelism,omitempty"`

	// Template: Optional. Describes the instance that will be created when
	// executing a job.
	Template *InstanceTemplateSpec `json:"template,omitempty"`

	// TtlSecondsAfterFinished: Optional. ttlSecondsAfterFinished limits the
	// lifetime of a Job that has finished execution (either Complete or
	// Failed). If this field is set, ttlSecondsAfterFinished after the Job
	// finishes, it is eligible to be automatically deleted. When the Job is
	// being deleted, its lifecycle guarantees (e.g. finalizers) will be
	// honored. If this field is set to zero, the Job won't be automatically
	// deleted. +optional
	TtlSecondsAfterFinished int64 `json:"ttlSecondsAfterFinished,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "ActiveDeadlineSeconds") to unconditionally include in API requests.
	// By default, fields with empty values are omitted from API requests.
	// However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ActiveDeadlineSeconds") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *JobSpec) MarshalJSON() ([]byte, error) {
	type NoMethod JobSpec
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// JobStatus: JobStatus represents the current state of a Job.
type JobStatus struct {
	// Active: Optional. The number of actively running instances. +optional
	Active int64 `json:"active,omitempty"`

	// CompletionTime: Optional. Represents time when the job was completed.
	// It is not guaranteed to be set in happens-before order across
	// separate operations. It is represented in RFC3339 form and is in UTC.
	// +optional
	CompletionTime string `json:"completionTime,omitempty"`

	// Conditions: Optional. The latest available observations of a job's
	// current state. More info:
	// https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/
	// +optional
	Conditions []*JobCondition `json:"conditions,omitempty"`

	// Failed: Optional. The number of instances which reached phase Failed.
	// +optional
	Failed int64 `json:"failed,omitempty"`

	// ImageDigest: Optional. ImageDigest holds the resolved digest for the
	// image specified within .Spec.Template.Spec.Container.Image. The
	// digest is resolved during the creation of the Job. This field holds
	// the digest value regardless of whether a tag or digest was originally
	// specified in the Container object.
	ImageDigest string `json:"imageDigest,omitempty"`

	// Instances: Optional. Status of completed, failed, and running
	// instances. +optional
	Instances []*InstanceStatus `json:"instances,omitempty"`

	// ObservedGeneration: Optional. The 'generation' of the job that was
	// last processed by the controller.
	ObservedGeneration int64 `json:"observedGeneration,omitempty"`

	// StartTime: Optional. Represents time when the job was acknowledged by
	// the job controller. It is not guaranteed to be set in happens-before
	// order across separate operations. It is represented in RFC3339 form
	// and is in UTC. +optional
	StartTime string `json:"startTime,omitempty"`

	// Succeeded: Optional. The number of instances which reached phase
	// Succeeded. +optional
	Succeeded int64 `json:"succeeded,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Active") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Active") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *JobStatus) MarshalJSON() ([]byte, error) {
	type NoMethod JobStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// KeyToPath: Maps a string key to a path within a volume.
type KeyToPath struct {
	// Key: Cloud Run fully managed: supported The Cloud Secret Manager
	// secret version. Can be 'latest' for the latest value or an integer
	// for a specific version. Cloud Run for Anthos: supported The key to
	// project.
	Key string `json:"key,omitempty"`

	// Mode: Mode bits to use on this file, must be a value between 0 and
	// 0777. If not specified, the volume defaultMode will be used. This
	// might be in conflict with other options that affect the file mode,
	// like fsGroup, and the result can be other mode bits set. +optional
	Mode int64 `json:"mode,omitempty"`

	// Path: Cloud Run fully managed: supported Cloud Run for Anthos:
	// supported The relative path of the file to map the key to. May not be
	// an absolute path. May not contain the path element '..'. May not
	// start with the string '..'.
	Path string `json:"path,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *KeyToPath) MarshalJSON() ([]byte, error) {
	type NoMethod KeyToPath
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Lifecycle: Lifecycle describes actions that the management system
// should take in response to container lifecycle events. For the
// PostStart and PreStop lifecycle handlers, management of the container
// blocks until the action is complete, unless the container process
// fails, in which case the handler is aborted.
type Lifecycle struct {
	// PostStart: PostStart is called immediately after a container is
	// created. If the handler fails, the container is terminated and
	// restarted according to its restart policy. Other management of the
	// container blocks until the hook completes. More info:
	// https://kubernetes.io/docs/concepts/containers/container-lifecycle-hooks/#container-hooks
	// +optional
	PostStart *Handler `json:"postStart,omitempty"`

	// PreStop: PreStop is called immediately before a container is
	// terminated. The container is terminated after the handler completes.
	// The reason for termination is passed to the handler. Regardless of
	// the outcome of the handler, the container is eventually terminated.
	// Other management of the container blocks until the hook completes.
	// More info:
	// https://kubernetes.io/docs/concepts/containers/container-lifecycle-hooks/#container-hooks
	// +optional
	PreStop *Handler `json:"preStop,omitempty"`

	// ForceSendFields is a list of field names (e.g. "PostStart") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PostStart") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Lifecycle) MarshalJSON() ([]byte, error) {
	type NoMethod Lifecycle
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListJobsResponse: ListJobsResponse is a list of Jobs resources.
type ListJobsResponse struct {
	// ApiVersion: The API version for this call such as
	// "run.googleapis.com/v1alpha1".
	ApiVersion string `json:"apiVersion,omitempty"`

	// Items: List of Jobs.
	Items []*Job `json:"items,omitempty"`

	// Kind: The kind of this resource, in this case "JobsList".
	Kind string `json:"kind,omitempty"`

	// Metadata: Metadata associated with this jobs list.
	Metadata *ListMeta `json:"metadata,omitempty"`

	// NextPageToken: This field is equivalent to the metadata.continue
	// field and is provided as a convenience for compatibility with
	// https://google.aip.dev/158. The value is opaque and may be used to
	// issue another request to the endpoint that served this list to
	// retrieve the next set of available objects. Continuing a list may not
	// be possible if the server configuration has changed or more than a
	// few minutes have passed. The metadata.resourceVersion field returned
	// when using this field will be identical to the value in the first
	// response.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Unreachable: Locations that could not be reached.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ApiVersion") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ApiVersion") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListJobsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListJobsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListMeta: ListMeta describes metadata that synthetic resources must
// have, including lists and various status objects. A resource may have
// only one of {ObjectMeta, ListMeta}.
type ListMeta struct {
	// Continue: continue may be set if the user set a limit on the number
	// of items returned, and indicates that the server has more data
	// available. The value is opaque and may be used to issue another
	// request to the endpoint that served this list to retrieve the next
	// set of available objects. Continuing a list may not be possible if
	// the server configuration has changed or more than a few minutes have
	// passed. The resourceVersion field returned when using this continue
	// value will be identical to the value in the first response.
	Continue string `json:"continue,omitempty"`

	// ResourceVersion: String that identifies the server's internal version
	// of this object that can be used by clients to determine when objects
	// have changed. Value must be treated as opaque by clients and passed
	// unmodified back to the server. Populated by the system. Read-only.
	// More info:
	// https://git.k8s.io/community/contributors/devel/api-conventions.md#concurrency-control-and-consistency
	// +optional
	ResourceVersion string `json:"resourceVersion,omitempty"`

	// SelfLink: SelfLink is a URL representing this object. Populated by
	// the system. Read-only. +optional
	SelfLink string `json:"selfLink,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Continue") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Continue") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListMeta) MarshalJSON() ([]byte, error) {
	type NoMethod ListMeta
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// LocalObjectReference: LocalObjectReference contains enough
// information to let you locate the referenced object inside the same
// namespace.
type LocalObjectReference struct {
	// Name: Name of the referent. More info:
	// https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *LocalObjectReference) MarshalJSON() ([]byte, error) {
	type NoMethod LocalObjectReference
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ObjectMeta: ObjectMeta is metadata that all persisted resources must
// have, which includes all objects users must create.
type ObjectMeta struct {
	// Annotations: Annotations is an unstructured key value map stored with
	// a resource that may be set by external tools to store and retrieve
	// arbitrary metadata. They are not queryable and should be preserved
	// when modifying objects. More info:
	// http://kubernetes.io/docs/user-guide/annotations +optional
	Annotations map[string]string `json:"annotations,omitempty"`

	// ClusterName: Not currently supported by Cloud Run. The name of the
	// cluster which the object belongs to. This is used to distinguish
	// resources with same name and namespace in different clusters. This
	// field is not set anywhere right now and apiserver is going to ignore
	// it if set in create or update request. +optional
	ClusterName string `json:"clusterName,omitempty"`

	// CreationTimestamp: CreationTimestamp is a timestamp representing the
	// server time when this object was created. It is not guaranteed to be
	// set in happens-before order across separate operations. Clients may
	// not set this value. It is represented in RFC3339 form and is in UTC.
	// Populated by the system. Read-only. Null for lists. More info:
	// https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
	// +optional
	CreationTimestamp string `json:"creationTimestamp,omitempty"`

	// DeletionGracePeriodSeconds: Not currently supported by Cloud Run.
	// Number of seconds allowed for this object to gracefully terminate
	// before it will be removed from the system. Only set when
	// deletionTimestamp is also set. May only be shortened. Read-only.
	// +optional
	DeletionGracePeriodSeconds int64 `json:"deletionGracePeriodSeconds,omitempty"`

	// DeletionTimestamp: DeletionTimestamp is RFC 3339 date and time at
	// which this resource will be deleted. This field is set by the server
	// when a graceful deletion is requested by the user, and is not
	// directly settable by a client. The resource is expected to be deleted
	// (no longer visible from resource lists, and not reachable by name)
	// after the time in this field, once the finalizers list is empty. As
	// long as the finalizers list contains items, deletion is blocked. Once
	// the deletionTimestamp is set, this value may not be unset or be set
	// further into the future, although it may be shortened or the resource
	// may be deleted prior to this time. For example, a user may request
	// that a pod is deleted in 30 seconds. The Kubelet will react by
	// sending a graceful termination signal to the containers in the pod.
	// After that 30 seconds, the Kubelet will send a hard termination
	// signal (SIGKILL) to the container and after cleanup, remove the pod
	// from the API. In the presence of network partitions, this object may
	// still exist after this timestamp, until an administrator or automated
	// process can determine the resource is fully terminated. If not set,
	// graceful deletion of the object has not been requested. Populated by
	// the system when a graceful deletion is requested. Read-only. More
	// info:
	// https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
	// +optional
	DeletionTimestamp string `json:"deletionTimestamp,omitempty"`

	// Finalizers: Not currently supported by Cloud Run. Must be empty
	// before the object is deleted from the registry. Each entry is an
	// identifier for the responsible component that will remove the entry
	// from the list. If the deletionTimestamp of the object is non-nil,
	// entries in this list can only be removed. +optional
	// +patchStrategy=merge
	Finalizers []string `json:"finalizers,omitempty"`

	// GenerateName: Not currently supported by Cloud Run. GenerateName is
	// an optional prefix, used by the server, to generate a unique name
	// ONLY IF the Name field has not been provided. If this field is used,
	// the name returned to the client will be different than the name
	// passed. This value will also be combined with a unique suffix. The
	// provided value has the same validation rules as the Name field, and
	// may be truncated by the length of the suffix required to make the
	// value unique on the server. If this field is specified and the
	// generated name exists, the server will NOT return a 409 - instead, it
	// will either return 201 Created or 500 with Reason ServerTimeout
	// indicating a unique name could not be found in the time allotted, and
	// the client should retry (optionally after the time indicated in the
	// Retry-After header). Applied only if Name is not specified. More
	// info:
	// https://git.k8s.io/community/contributors/devel/api-conventions.md#idempotency
	// +optional string generateName = 2;
	GenerateName string `json:"generateName,omitempty"`

	// Generation: A sequence number representing a specific generation of
	// the desired state. Populated by the system. Read-only. +optional
	Generation int64 `json:"generation,omitempty"`

	// Labels: Map of string keys and values that can be used to organize
	// and categorize (scope and select) objects. May match selectors of
	// replication controllers and routes. More info:
	// http://kubernetes.io/docs/user-guide/labels +optional
	Labels map[string]string `json:"labels,omitempty"`

	// Name: Name must be unique within a namespace, within a Cloud Run
	// region. Is required when creating resources, although some resources
	// may allow a client to request the generation of an appropriate name
	// automatically. Name is primarily intended for creation idempotence
	// and configuration definition. Cannot be updated. More info:
	// http://kubernetes.io/docs/user-guide/identifiers#names +optional
	Name string `json:"name,omitempty"`

	// Namespace: Namespace defines the space within each name must be
	// unique, within a Cloud Run region. In Cloud Run the namespace must be
	// equal to either the project ID or project number.
	Namespace string `json:"namespace,omitempty"`

	// OwnerReferences: List of objects that own this object. If ALL objects
	// in the list have been deleted, this object will be garbage collected.
	// +optional
	OwnerReferences []*OwnerReference `json:"ownerReferences,omitempty"`

	// ResourceVersion: An opaque value that represents the internal version
	// of this object that can be used by clients to determine when objects
	// have changed. May be used for optimistic concurrency, change
	// detection, and the watch operation on a resource or set of resources.
	// Clients must treat these values as opaque and passed unmodified back
	// to the server. They may only be valid for a particular resource or
	// set of resources. Populated by the system. Read-only. Value must be
	// treated as opaque by clients and . More info:
	// https://git.k8s.io/community/contributors/devel/api-conventions.md#concurrency-control-and-consistency
	// +optional
	ResourceVersion string `json:"resourceVersion,omitempty"`

	// SelfLink: SelfLink is a URL representing this object. Populated by
	// the system. Read-only. +optional string selfLink = 4;
	SelfLink string `json:"selfLink,omitempty"`

	// Uid: UID is the unique in time and space value for this object. It is
	// typically generated by the server on successful creation of a
	// resource and is not allowed to change on PUT operations. Populated by
	// the system. Read-only. More info:
	// http://kubernetes.io/docs/user-guide/identifiers#uids +optional
	Uid string `json:"uid,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Annotations") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Annotations") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ObjectMeta) MarshalJSON() ([]byte, error) {
	type NoMethod ObjectMeta
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// OwnerReference: OwnerReference contains enough information to let you
// identify an owning object. Currently, an owning object must be in the
// same namespace, so there is no namespace field.
type OwnerReference struct {
	// ApiVersion: API version of the referent.
	ApiVersion string `json:"apiVersion,omitempty"`

	// BlockOwnerDeletion: If true, AND if the owner has the
	// "foregroundDeletion" finalizer, then the owner cannot be deleted from
	// the key-value store until this reference is removed. Defaults to
	// false. To set this field, a user needs "delete" permission of the
	// owner, otherwise 422 (Unprocessable Entity) will be returned.
	// +optional
	BlockOwnerDeletion bool `json:"blockOwnerDeletion,omitempty"`

	// Controller: If true, this reference points to the managing
	// controller. +optional
	Controller bool `json:"controller,omitempty"`

	// Kind: Kind of the referent. More info:
	// https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
	Kind string `json:"kind,omitempty"`

	// Name: Name of the referent. More info:
	// http://kubernetes.io/docs/user-guide/identifiers#names
	Name string `json:"name,omitempty"`

	// Uid: UID of the referent. More info:
	// http://kubernetes.io/docs/user-guide/identifiers#uids
	Uid string `json:"uid,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ApiVersion") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ApiVersion") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OwnerReference) MarshalJSON() ([]byte, error) {
	type NoMethod OwnerReference
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Probe: Probe describes a health check to be performed against a
// container to determine whether it is alive or ready to receive
// traffic.
type Probe struct {
	// FailureThreshold: Minimum consecutive failures for the probe to be
	// considered failed after having succeeded. Defaults to 3. Minimum
	// value is 1. +optional
	FailureThreshold int64 `json:"failureThreshold,omitempty"`

	// Handler: The action taken to determine the health of a container
	Handler *Handler `json:"handler,omitempty"`

	// InitialDelaySeconds: Number of seconds after the container has
	// started before liveness probes are initiated. More info:
	// https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
	// +optional
	InitialDelaySeconds int64 `json:"initialDelaySeconds,omitempty"`

	// PeriodSeconds: How often (in seconds) to perform the probe. Default
	// to 10 seconds. Minimum value is 1. +optional
	PeriodSeconds int64 `json:"periodSeconds,omitempty"`

	// SuccessThreshold: Minimum consecutive successes for the probe to be
	// considered successful after having failed. Defaults to 1. Must be 1
	// for liveness. Minimum value is 1. +optional
	SuccessThreshold int64 `json:"successThreshold,omitempty"`

	// TimeoutSeconds: Number of seconds after which the probe times out.
	// Defaults to 1 second. Minimum value is 1. More info:
	// https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
	// +optional
	TimeoutSeconds int64 `json:"timeoutSeconds,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FailureThreshold") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FailureThreshold") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *Probe) MarshalJSON() ([]byte, error) {
	type NoMethod Probe
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Quantity: The view model of a single quantity, e.g. "800 MiB".
// Corresponds to
// https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/generated.proto
type Quantity struct {
	// String: Stringified version of the quantity, e.g., "800 MiB".
	String string `json:"string,omitempty"`

	// ForceSendFields is a list of field names (e.g. "String") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "String") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Quantity) MarshalJSON() ([]byte, error) {
	type NoMethod Quantity
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ResourceRequirements: ResourceRequirements describes the compute
// resource requirements.
type ResourceRequirements struct {
	// Limits: Limits describes the maximum amount of compute resources
	// allowed. The values of the map is string form of the 'quantity' k8s
	// type:
	// https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
	Limits map[string]string `json:"limits,omitempty"`

	// LimitsInMap: Limits describes the maximum amount of compute resources
	// allowed. This is a temporary field created to migrate away from the
	// map limits field. This is done to become compliant with k8s style
	// API. This field is deprecated in favor of limits field.
	LimitsInMap map[string]Quantity `json:"limitsInMap,omitempty"`

	// Requests: Requests describes the minimum amount of compute resources
	// required. If Requests is omitted for a container, it defaults to
	// Limits if that is explicitly specified, otherwise to an
	// implementation-defined value. The values of the map is string form of
	// the 'quantity' k8s type:
	// https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
	Requests map[string]string `json:"requests,omitempty"`

	// RequestsInMap: Requests describes the minimum amount of compute
	// resources required. If Requests is omitted for a container, it
	// defaults to Limits if that is explicitly specified, otherwise to an
	// implementation-defined value. This is a temporary field created to
	// migrate away from the map requests field. This is done to become
	// compliant with k8s style API. This field is deprecated in favor of
	// requests field.
	RequestsInMap map[string]Quantity `json:"requestsInMap,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Limits") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Limits") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ResourceRequirements) MarshalJSON() ([]byte, error) {
	type NoMethod ResourceRequirements
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SELinuxOptions: SELinuxOptions are the labels to be applied to the
// container
type SELinuxOptions struct {
	// Level: Level is SELinux level label that applies to the container.
	// +optional
	Level string `json:"level,omitempty"`

	// Role: Role is a SELinux role label that applies to the container.
	// +optional
	Role string `json:"role,omitempty"`

	// Type: Type is a SELinux type label that applies to the container.
	// +optional
	Type string `json:"type,omitempty"`

	// User: User is a SELinux user label that applies to the container.
	// +optional
	User string `json:"user,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Level") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Level") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SELinuxOptions) MarshalJSON() ([]byte, error) {
	type NoMethod SELinuxOptions
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SecretEnvSource: SecretEnvSource selects a Secret to populate the
// environment variables with. The contents of the target Secret's Data
// field will represent the key-value pairs as environment variables.
type SecretEnvSource struct {
	// LocalObjectReference: This field should not be used directly as it is
	// meant to be inlined directly into the message. Use the "name" field
	// instead.
	LocalObjectReference *LocalObjectReference `json:"localObjectReference,omitempty"`

	// Name: Cloud Run fully managed: not supported Cloud Run for Anthos:
	// supported The Secret to select from.
	Name string `json:"name,omitempty"`

	// Optional: Cloud Run fully managed: not supported Cloud Run for
	// Anthos: supported Specify whether the Secret must be defined
	// +optional
	Optional bool `json:"optional,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "LocalObjectReference") to unconditionally include in API requests.
	// By default, fields with empty values are omitted from API requests.
	// However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LocalObjectReference") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *SecretEnvSource) MarshalJSON() ([]byte, error) {
	type NoMethod SecretEnvSource
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SecretKeySelector: Cloud Run fully managed: supported Cloud Run on
// GKE: supported SecretKeySelector selects a key of a Secret.
type SecretKeySelector struct {
	// Key: Cloud Run fully managed: supported A Cloud Secret Manager secret
	// version. Must be 'latest' for the latest version or an integer for a
	// specific version. Cloud Run for Anthos: supported The key of the
	// secret to select from. Must be a valid secret key.
	Key string `json:"key,omitempty"`

	// LocalObjectReference: This field should not be used directly as it is
	// meant to be inlined directly into the message. Use the "name" field
	// instead.
	LocalObjectReference *LocalObjectReference `json:"localObjectReference,omitempty"`

	// Name: Cloud Run fully managed: supported The name of the secret in
	// Cloud Secret Manager. By default, the secret is assumed to be in the
	// same project. If the secret is in another project, you must define an
	// alias. An alias definition has the form: :projects//secrets/. If
	// multiple alias definitions are needed, they must be separated by
	// commas. The alias definitions must be set on the
	// run.googleapis.com/secrets annotation. Cloud Run for Anthos:
	// supported The name of the secret in the pod's namespace to select
	// from.
	Name string `json:"name,omitempty"`

	// Optional: Cloud Run fully managed: not supported Cloud Run on GKE:
	// supported Specify whether the Secret or its key must be defined
	// +optional
	Optional bool `json:"optional,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Key") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Key") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SecretKeySelector) MarshalJSON() ([]byte, error) {
	type NoMethod SecretKeySelector
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SecretVolumeSource: The contents of the target Secret's Data field
// will be presented in a volume as files using the keys in the Data
// field as the file names.
type SecretVolumeSource struct {
	// DefaultMode: Mode bits to use on created files by default. Must be a
	// value between 0 and 0777. Defaults to 0644. Directories within the
	// path are not affected by this setting. This might be in conflict with
	// other options that affect the file mode, like fsGroup, and the result
	// can be other mode bits set.
	DefaultMode int64 `json:"defaultMode,omitempty"`

	// Items: Cloud Run fully managed: supported If unspecified, the volume
	// will expose a file whose name is the secret_name. If specified, the
	// key will be used as the version to fetch from Cloud Secret Manager
	// and the path will be the name of the file exposed in the volume. When
	// items are defined, they must specify a key and a path. Cloud Run for
	// Anthos: supported If unspecified, each key-value pair in the Data
	// field of the referenced Secret will be projected into the volume as a
	// file whose name is the key and content is the value. If specified,
	// the listed keys will be projected into the specified paths, and
	// unlisted keys will not be present. If a key is specified which is not
	// present in the Secret, the volume setup will error unless it is
	// marked optional.
	Items []*KeyToPath `json:"items,omitempty"`

	// Optional: Specify whether the Secret or its keys must be defined.
	Optional bool `json:"optional,omitempty"`

	// SecretName: Cloud Run fully managed: supported The name of the secret
	// in Cloud Secret Manager. By default, the secret is assumed to be in
	// the same project. If the secret is in another project, you must
	// define an alias. An alias definition has the form:
	// :projects//secrets/. If multiple alias definitions are needed, they
	// must be separated by commas. The alias definitions must be set on the
	// run.googleapis.com/secrets annotation. Cloud Run for Anthos:
	// supported Name of the secret in the container's namespace to use.
	SecretName string `json:"secretName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DefaultMode") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DefaultMode") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SecretVolumeSource) MarshalJSON() ([]byte, error) {
	type NoMethod SecretVolumeSource
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SecurityContext: SecurityContext holds security configuration that
// will be applied to a container. Some fields are present in both
// SecurityContext and PodSecurityContext. When both are set, the values
// in SecurityContext take precedence.
type SecurityContext struct {
	// AllowPrivilegeEscalation: AllowPrivilegeEscalation controls whether a
	// process can gain more privileges than its parent process. This bool
	// directly controls if the no_new_privs flag will be set on the
	// container process. AllowPrivilegeEscalation is true always when the
	// container is: 1) run as Privileged 2) has CAP_SYS_ADMIN +optional
	AllowPrivilegeEscalation bool `json:"allowPrivilegeEscalation,omitempty"`

	// Capabilities: The capabilities to add/drop when running containers.
	// Defaults to the default set of capabilities granted by the container
	// runtime. +optional
	Capabilities *Capabilities `json:"capabilities,omitempty"`

	// Privileged: Run container in privileged mode. Processes in privileged
	// containers are essentially equivalent to root on the host. Defaults
	// to false. +optional
	Privileged bool `json:"privileged,omitempty"`

	// ReadOnlyRootFilesystem: Whether this container has a read-only root
	// filesystem. Default is false. +optional
	ReadOnlyRootFilesystem bool `json:"readOnlyRootFilesystem,omitempty"`

	// RunAsGroup: The GID to run the entrypoint of the container process.
	// Uses runtime default if unset. May also be set in PodSecurityContext.
	// If set in both SecurityContext and PodSecurityContext, the value
	// specified in SecurityContext takes precedence. +optional
	RunAsGroup int64 `json:"runAsGroup,omitempty"`

	// RunAsNonRoot: Indicates that the container must run as a non-root
	// user. If true, the Kubelet will validate the image at runtime to
	// ensure that it does not run as UID 0 (root) and fail to start the
	// container if it does. If unset or false, no such validation will be
	// performed. May also be set in PodSecurityContext. If set in both
	// SecurityContext and PodSecurityContext, the value specified in
	// SecurityContext takes precedence. +optional
	RunAsNonRoot bool `json:"runAsNonRoot,omitempty"`

	// RunAsUser: The UID to run the entrypoint of the container process.
	// Defaults to user specified in image metadata if unspecified. May also
	// be set in PodSecurityContext. If set in both SecurityContext and
	// PodSecurityContext, the value specified in SecurityContext takes
	// precedence. +optional
	RunAsUser int64 `json:"runAsUser,omitempty"`

	// SeLinuxOptions: The SELinux context to be applied to the container.
	// If unspecified, the container runtime will allocate a random SELinux
	// context for each container. May also be set in PodSecurityContext. If
	// set in both SecurityContext and PodSecurityContext, the value
	// specified in SecurityContext takes precedence. +optional
	SeLinuxOptions *SELinuxOptions `json:"seLinuxOptions,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AllowPrivilegeEscalation") to unconditionally include in API
	// requests. By default, fields with empty values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AllowPrivilegeEscalation")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *SecurityContext) MarshalJSON() ([]byte, error) {
	type NoMethod SecurityContext
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// TCPSocketAction: TCPSocketAction describes an action based on opening
// a socket
type TCPSocketAction struct {
	// Host: Optional: Host name to connect to, defaults to the pod IP.
	// +optional
	Host string `json:"host,omitempty"`

	// Port: Number or name of the port to access on the container. Number
	// must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
	Port *IntOrString `json:"port,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Host") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Host") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *TCPSocketAction) MarshalJSON() ([]byte, error) {
	type NoMethod TCPSocketAction
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Volume: Volume represents a named volume in a container.
type Volume struct {
	ConfigMap *ConfigMapVolumeSource `json:"configMap,omitempty"`

	// Name: Volume's name.
	Name string `json:"name,omitempty"`

	Secret *SecretVolumeSource `json:"secret,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ConfigMap") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ConfigMap") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Volume) MarshalJSON() ([]byte, error) {
	type NoMethod Volume
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// VolumeDevice: volumeDevice describes a mapping of a raw block device
// within a container.
type VolumeDevice struct {
	// DevicePath: devicePath is the path inside of the container that the
	// device will be mapped to.
	DevicePath string `json:"devicePath,omitempty"`

	// Name: name must match the name of a persistentVolumeClaim in the pod
	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DevicePath") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DevicePath") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *VolumeDevice) MarshalJSON() ([]byte, error) {
	type NoMethod VolumeDevice
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// VolumeMount: VolumeMount describes a mounting of a Volume within a
// container.
type VolumeMount struct {
	// MountPath: Path within the container at which the volume should be
	// mounted. Must not contain ':'.
	MountPath string `json:"mountPath,omitempty"`

	// MountPropagation: mountPropagation determines how mounts are
	// propagated from the host to container and the other way around. When
	// not set, MountPropagationHostToContainer is used. This field is beta
	// in 1.10. +optional
	MountPropagation string `json:"mountPropagation,omitempty"`

	// Name: This must match the Name of a Volume.
	Name string `json:"name,omitempty"`

	// ReadOnly: Mounted read-only if true, read-write otherwise (false or
	// unspecified). Defaults to false. +optional
	ReadOnly bool `json:"readOnly,omitempty"`

	// SubPath: Path within the volume from which the container's volume
	// should be mounted. Defaults to "" (volume's root). +optional
	SubPath string `json:"subPath,omitempty"`

	// ForceSendFields is a list of field names (e.g. "MountPath") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MountPath") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *VolumeMount) MarshalJSON() ([]byte, error) {
	type NoMethod VolumeMount
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// method id "run.namespaces.jobs.create":

type NamespacesJobsCreateCall struct {
	s          *Service
	parent     string
	job        *Job
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Create a job.
//
// - parent: The namespace in which the job should be created. Replace
//   {namespace_id} with the project ID or number.
func (r *NamespacesJobsService) Create(parent string, job *Job) *NamespacesJobsCreateCall {
	c := &NamespacesJobsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.job = job
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *NamespacesJobsCreateCall) Fields(s ...googleapi.Field) *NamespacesJobsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *NamespacesJobsCreateCall) Context(ctx context.Context) *NamespacesJobsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *NamespacesJobsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *NamespacesJobsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210518")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.job)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "apis/run.googleapis.com/v1alpha1/{+parent}/jobs")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.namespaces.jobs.create" call.
// Exactly one of *Job or error will be non-nil. Any non-2xx status code
// is an error. Response headers are in either
// *Job.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *NamespacesJobsCreateCall) Do(opts ...googleapi.CallOption) (*Job, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Job{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Create a job.",
	//   "flatPath": "apis/run.googleapis.com/v1alpha1/namespaces/{namespacesId}/jobs",
	//   "httpMethod": "POST",
	//   "id": "run.namespaces.jobs.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The namespace in which the job should be created. Replace {namespace_id} with the project ID or number.",
	//       "location": "path",
	//       "pattern": "^namespaces/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "apis/run.googleapis.com/v1alpha1/{+parent}/jobs",
	//   "request": {
	//     "$ref": "Job"
	//   },
	//   "response": {
	//     "$ref": "Job"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "run.namespaces.jobs.delete":

type NamespacesJobsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Delete a job.
//
// - name: The name of the job to delete. For Cloud Run (fully managed),
//   replace {namespace_id} with the project ID or number.
func (r *NamespacesJobsService) Delete(name string) *NamespacesJobsDeleteCall {
	c := &NamespacesJobsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// ApiVersion sets the optional parameter "apiVersion": Cloud Run
// currently ignores this parameter.
func (c *NamespacesJobsDeleteCall) ApiVersion(apiVersion string) *NamespacesJobsDeleteCall {
	c.urlParams_.Set("apiVersion", apiVersion)
	return c
}

// Kind sets the optional parameter "kind": Cloud Run currently ignores
// this parameter.
func (c *NamespacesJobsDeleteCall) Kind(kind string) *NamespacesJobsDeleteCall {
	c.urlParams_.Set("kind", kind)
	return c
}

// PropagationPolicy sets the optional parameter "propagationPolicy":
// Specifies the propagation policy of delete. Cloud Run currently
// ignores this setting, and deletes in the background. Please see
// kubernetes.io/docs/concepts/workloads/controllers/garbage-collection/
// for more information.
func (c *NamespacesJobsDeleteCall) PropagationPolicy(propagationPolicy string) *NamespacesJobsDeleteCall {
	c.urlParams_.Set("propagationPolicy", propagationPolicy)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *NamespacesJobsDeleteCall) Fields(s ...googleapi.Field) *NamespacesJobsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *NamespacesJobsDeleteCall) Context(ctx context.Context) *NamespacesJobsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *NamespacesJobsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *NamespacesJobsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210518")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "apis/run.googleapis.com/v1alpha1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.namespaces.jobs.delete" call.
// Exactly one of *Empty or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *NamespacesJobsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Delete a job.",
	//   "flatPath": "apis/run.googleapis.com/v1alpha1/namespaces/{namespacesId}/jobs/{jobsId}",
	//   "httpMethod": "DELETE",
	//   "id": "run.namespaces.jobs.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "apiVersion": {
	//       "description": "Optional. Cloud Run currently ignores this parameter.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "kind": {
	//       "description": "Optional. Cloud Run currently ignores this parameter.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "name": {
	//       "description": "Required. The name of the job to delete. For Cloud Run (fully managed), replace {namespace_id} with the project ID or number.",
	//       "location": "path",
	//       "pattern": "^namespaces/[^/]+/jobs/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "propagationPolicy": {
	//       "description": "Optional. Specifies the propagation policy of delete. Cloud Run currently ignores this setting, and deletes in the background. Please see kubernetes.io/docs/concepts/workloads/controllers/garbage-collection/ for more information.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "apis/run.googleapis.com/v1alpha1/{+name}",
	//   "response": {
	//     "$ref": "Empty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "run.namespaces.jobs.get":

type NamespacesJobsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Get information about a job.
//
// - name: The name of the job to retrieve. For Cloud Run (fully
//   managed), replace {namespace_id} with the project ID or number.
func (r *NamespacesJobsService) Get(name string) *NamespacesJobsGetCall {
	c := &NamespacesJobsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *NamespacesJobsGetCall) Fields(s ...googleapi.Field) *NamespacesJobsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *NamespacesJobsGetCall) IfNoneMatch(entityTag string) *NamespacesJobsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *NamespacesJobsGetCall) Context(ctx context.Context) *NamespacesJobsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *NamespacesJobsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *NamespacesJobsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210518")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "apis/run.googleapis.com/v1alpha1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.namespaces.jobs.get" call.
// Exactly one of *Job or error will be non-nil. Any non-2xx status code
// is an error. Response headers are in either
// *Job.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *NamespacesJobsGetCall) Do(opts ...googleapi.CallOption) (*Job, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Job{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Get information about a job.",
	//   "flatPath": "apis/run.googleapis.com/v1alpha1/namespaces/{namespacesId}/jobs/{jobsId}",
	//   "httpMethod": "GET",
	//   "id": "run.namespaces.jobs.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the job to retrieve. For Cloud Run (fully managed), replace {namespace_id} with the project ID or number.",
	//       "location": "path",
	//       "pattern": "^namespaces/[^/]+/jobs/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "apis/run.googleapis.com/v1alpha1/{+name}",
	//   "response": {
	//     "$ref": "Job"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "run.namespaces.jobs.list":

type NamespacesJobsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: List jobs.
//
// - parent: The namespace from which the jobs should be listed. Replace
//   {namespace_id} with the project ID or number.
func (r *NamespacesJobsService) List(parent string) *NamespacesJobsListCall {
	c := &NamespacesJobsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Continue sets the optional parameter "continue": Optional encoded
// string to continue paging.
func (c *NamespacesJobsListCall) Continue(continue_ string) *NamespacesJobsListCall {
	c.urlParams_.Set("continue", continue_)
	return c
}

// FieldSelector sets the optional parameter "fieldSelector": Allows to
// filter resources based on a specific value for a field name. Send
// this in a query string format. i.e. 'metadata.name%3Dlorem'. Not
// currently used by Cloud Run.
func (c *NamespacesJobsListCall) FieldSelector(fieldSelector string) *NamespacesJobsListCall {
	c.urlParams_.Set("fieldSelector", fieldSelector)
	return c
}

// IncludeUninitialized sets the optional parameter
// "includeUninitialized": Not currently used by Cloud Run.
func (c *NamespacesJobsListCall) IncludeUninitialized(includeUninitialized bool) *NamespacesJobsListCall {
	c.urlParams_.Set("includeUninitialized", fmt.Sprint(includeUninitialized))
	return c
}

// LabelSelector sets the optional parameter "labelSelector": Allows to
// filter resources based on a label. Supported operations are =, !=,
// exists, in, and notIn.
func (c *NamespacesJobsListCall) LabelSelector(labelSelector string) *NamespacesJobsListCall {
	c.urlParams_.Set("labelSelector", labelSelector)
	return c
}

// Limit sets the optional parameter "limit": The maximum number of
// records that should be returned.
func (c *NamespacesJobsListCall) Limit(limit int64) *NamespacesJobsListCall {
	c.urlParams_.Set("limit", fmt.Sprint(limit))
	return c
}

// ResourceVersion sets the optional parameter "resourceVersion": The
// baseline resource version from which the list or watch operation
// should start. Not currently used by Cloud Run.
func (c *NamespacesJobsListCall) ResourceVersion(resourceVersion string) *NamespacesJobsListCall {
	c.urlParams_.Set("resourceVersion", resourceVersion)
	return c
}

// Watch sets the optional parameter "watch": Flag that indicates that
// the client expects to watch this resource as well. Not currently used
// by Cloud Run.
func (c *NamespacesJobsListCall) Watch(watch bool) *NamespacesJobsListCall {
	c.urlParams_.Set("watch", fmt.Sprint(watch))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *NamespacesJobsListCall) Fields(s ...googleapi.Field) *NamespacesJobsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *NamespacesJobsListCall) IfNoneMatch(entityTag string) *NamespacesJobsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *NamespacesJobsListCall) Context(ctx context.Context) *NamespacesJobsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *NamespacesJobsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *NamespacesJobsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210518")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "apis/run.googleapis.com/v1alpha1/{+parent}/jobs")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.namespaces.jobs.list" call.
// Exactly one of *ListJobsResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *ListJobsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *NamespacesJobsListCall) Do(opts ...googleapi.CallOption) (*ListJobsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &ListJobsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "List jobs.",
	//   "flatPath": "apis/run.googleapis.com/v1alpha1/namespaces/{namespacesId}/jobs",
	//   "httpMethod": "GET",
	//   "id": "run.namespaces.jobs.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "continue": {
	//       "description": "Optional. Optional encoded string to continue paging.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "fieldSelector": {
	//       "description": "Optional. Allows to filter resources based on a specific value for a field name. Send this in a query string format. i.e. 'metadata.name%3Dlorem'. Not currently used by Cloud Run.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "includeUninitialized": {
	//       "description": "Optional. Not currently used by Cloud Run.",
	//       "location": "query",
	//       "type": "boolean"
	//     },
	//     "labelSelector": {
	//       "description": "Optional. Allows to filter resources based on a label. Supported operations are =, !=, exists, in, and notIn.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "limit": {
	//       "description": "Optional. The maximum number of records that should be returned.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "parent": {
	//       "description": "Required. The namespace from which the jobs should be listed. Replace {namespace_id} with the project ID or number.",
	//       "location": "path",
	//       "pattern": "^namespaces/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "resourceVersion": {
	//       "description": "Optional. The baseline resource version from which the list or watch operation should start. Not currently used by Cloud Run.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "watch": {
	//       "description": "Optional. Flag that indicates that the client expects to watch this resource as well. Not currently used by Cloud Run.",
	//       "location": "query",
	//       "type": "boolean"
	//     }
	//   },
	//   "path": "apis/run.googleapis.com/v1alpha1/{+parent}/jobs",
	//   "response": {
	//     "$ref": "ListJobsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}
